#! /usr/bin/env bash
# tl;dr AGPLv3+
# copyright info at bottom

set -o nounset
set -o errexit

GILT_HOOKUP_DEBUG="${GILT_HOOKUP_DEBUG:-}"

if (( GILT_HOOKUP_DEBUG )); then
    set -x
    echo "in $0"
    pwd
fi

# create a temp directory to hold just the staged content
#  mktemp is used twice here, the first works on gnu,
#  the second works on mac
stage_dir=`mktemp -d 2>/dev/null || mktemp -d -t 'mytmpdir'`

# remove the temp staging directory when sigterm, sigint (ctrl-c),
#  and when the script exits normally
# the exit status of the script will not be affected by this trap
#  when it traps the SIGEXIT signal
# if we're debugging, then leave the testing directory around
#  for inspection
if (( ! GILT_HOOKUP_DEBUG )); then
  trap 'rm -rf "$stage_dir"' SIGTERM SIGINT EXIT
fi

# checkout all staged files into temporary staging directory
git checkout-index --prefix="${stage_dir}/" --all \
  && sync

if (( GILT_HOOKUP_DEBUG )); then
    tree "$stage_dir"
fi

# run make in temporary staging directory
make --directory="$stage_dir"

# {{name}} is {{description}}
# Copyright (C) {{year}} {{author}}

# This file is part of {{name}}.

# {{name}} is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.

# {{name}} is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
# the GNU General Affero Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with {{name}}.  If not, see
# <http://www.gnu.org/licenses/>.
