;; -*- coding: utf-8 -*-
;;
;; (c)2014 Flipboard Inc, All Rights Reserved.
;; Author: David Creemer
;;
;; flipboard.base.tld
;;
;; top-level-domain name nadling


(ns flipboard.base.tld
  "functions for dealing with domains of an internet hostname"
  (:require [clojure.string :as str])
  (:import [com.google.common.net InternetDomainName]))

(defn- join
  "[google com] -> google.com"
  [c] (str/join "." c))

(defn top-level-domain
  "Given a hostname string, return the top level domain for that host.
  (top-level-domain \"www.google.com\")
  ;;=> \"com\"

  (top-level-domain \"www.jobs.ac.uk\")
  ;;=> \"ac.uk\"
  "
  [h]
  (join (.. (InternetDomainName/from h)
            (publicSuffix)
            (parts))))

(defn domain
  "Given a hostname string, return just the domain for that host.
  (domain \"www.flipboard.com\")
  ;;=> \"flipboard.com\"

  (domain \"www.jobs.ac.uk\")
  ;;=> \"jobs.ac.uk\"
  "
  [h]
  (join (.. (InternetDomainName/from h)
            (topPrivateDomain)
            (parts))))
