;; -*- coding: utf-8 -*-
;;
;; (c)2014 Flipboard Inc, All Rights Reserved.
;; Author: David Creemer
;;
;; component encapsulation of all common "core" services

(ns flipboard.component.core
  (:require [clojure.tools.logging :as log]
            [flipboard.base.config :as config]
            [flipboard.base.domains :as domains]
            [flipboard.base.instance :as instance]
            [com.stuartsierra.component :as component]))

;; initialize all of the "core" elements of an application

(defrecord Core []

  component/Lifecycle

  (start [this]
    this)

  (stop [this]
    this))

(defn new-core
  []
  (let [cfg (config/create-config-map)]
    (map->Core {:config cfg
                :instance (instance/my-instance cfg)})))
