/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import flipkart.cp.gojira.core.MethodDataInterceptorHandler;
import flipkart.cp.gojira.core.Mode;
import flipkart.cp.gojira.core.NoneMethodDataInterceptorHandler;
import flipkart.cp.gojira.core.ProfileMethodDataInterceptorHandler;
import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.SerializeMethodDataInterceptorHandler;
import flipkart.cp.gojira.core.TestMethodDataInterceptorHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileOrTestMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileOrTestMethodInterceptor.class);
    private Map<Mode, MethodDataInterceptorHandler> modeMethodDataInterceptorHandlerMap = Collections.unmodifiableMap(new HashMap<Mode, MethodDataInterceptorHandler>(){
        {
            this.put(Mode.NONE, new NoneMethodDataInterceptorHandler());
            this.put(Mode.PROFILE, new ProfileMethodDataInterceptorHandler());
            this.put(Mode.TEST, new TestMethodDataInterceptorHandler());
            this.put(Mode.SERIALIZE, new SerializeMethodDataInterceptorHandler());
        }
    });

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.modeMethodDataInterceptorHandlerMap.containsKey((Object)ProfileRepository.getMode())) {
            return this.modeMethodDataInterceptorHandlerMap.get((Object)ProfileRepository.getMode()).handle(invocation);
        }
        return invocation.proceed();
    }
}

