/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.ProfileState;
import flipkart.cp.gojira.core.StartEndTestHandler;
import flipkart.cp.gojira.core.injectors.GuiceInjector;
import flipkart.cp.gojira.models.TestData;
import flipkart.cp.gojira.models.TestDataType;
import flipkart.cp.gojira.models.TestRequestData;
import flipkart.cp.gojira.models.TestResponseData;
import flipkart.cp.gojira.queuedsender.TestQueuedSender;
import flipkart.cp.gojira.requestsampling.RequestSamplingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileStartEndTestHandler<T extends TestDataType>
implements StartEndTestHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileStartEndTestHandler.class);

    @Override
    public void start(String id, TestRequestData<T> requestData) {
        try {
            if (this.fallsInSamplingBucket()) {
                ProfileRepository.begin(id);
                ProfileRepository.setRequestData(requestData);
                LOGGER.info("Profiling initiated for id: " + ProfileRepository.getTestData().getId());
            } else {
                LOGGER.info("doesn't fall into this sampling bucket, ignoring profiling for this request");
            }
        }
        catch (Exception e) {
            ProfileRepository.setProfileState(ProfileState.FAILED);
            LOGGER.warn("error starting test profile data. global_per_request_Id: " + id, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(TestResponseData<T> responseData) {
        block6: {
            try {
                TestQueuedSender testQueuedSender = (TestQueuedSender)GuiceInjector.getInjector().getInstance(TestQueuedSender.class);
                if (!ProfileState.INITIATED.equals((Object)ProfileRepository.getProfileState()) || testQueuedSender == null) break block6;
                try {
                    LOGGER.info("Profiling complete for id : " + ProfileRepository.getTestData().getId());
                    ProfileRepository.setResponseData(responseData);
                    TestData testData = ProfileRepository.getTestData();
                    if (testData != null) {
                        LOGGER.info("Profiling complete for id : " + ProfileRepository.getTestData().getId() + " sending to queuedSender.");
                        testQueuedSender.send(testData);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("error writing test profile data to datastore global_request_per_id: " + ProfileRepository.getGlobalPerRequestID(), (Throwable)e);
                }
            }
            finally {
                ProfileRepository.end();
            }
        }
    }

    private boolean fallsInSamplingBucket() {
        return (double)(System.nanoTime() % 10000L) < ((RequestSamplingRepository)GuiceInjector.getInjector().getInstance(RequestSamplingRepository.class)).getSamplingPercentage() * 100.0;
    }
}

