/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import flipkart.cp.compare.TestCompareException;
import flipkart.cp.gojira.compare.GojiraCompareHandlerRepository;
import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.ProfileState;
import flipkart.cp.gojira.core.StartEndTestHandler;
import flipkart.cp.gojira.core.injectors.GuiceInjector;
import flipkart.cp.gojira.models.TestData;
import flipkart.cp.gojira.models.TestDataType;
import flipkart.cp.gojira.models.TestRequestData;
import flipkart.cp.gojira.models.TestResponseData;
import flipkart.cp.gojira.serde.SerdeHandlerRepository;
import flipkart.cp.gojira.sinkstore.SinkException;
import flipkart.cp.gojira.sinkstore.handlers.SinkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStartEndTestHandler<T extends TestDataType>
implements StartEndTestHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestStartEndTestHandler.class);
    private static final String delim = " | ";
    private static final String RESULT_SUCCESS = "SUCCESS";
    private static final String READ_FAILURE = "READ_FAILED";
    private static final String COMPARE_FAILED = "COMPARE_FAILED";
    private static final String EXECUTION_FAILED = "EXECUTION_FAILED";
    private static final String UNKNOWN_FAILED = "UNKNOWN_FAILED";
    private GojiraCompareHandlerRepository gojiraCompareHandlerRepository = (GojiraCompareHandlerRepository)((Object)GuiceInjector.getInjector().getInstance(GojiraCompareHandlerRepository.class));
    private SerdeHandlerRepository serdeHandlerRepository = (SerdeHandlerRepository)GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);
    private SinkHandler sinkHandler = (SinkHandler)GuiceInjector.getInjector().getInstance(SinkHandler.class);

    @Override
    public void start(String id, TestRequestData<T> requestData) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("invalid test id.");
        }
        try {
            TestData testData = this.serdeHandlerRepository.getTestDataSerdeHandler().deserialize(this.sinkHandler.read(id), TestData.class);
            if (testData == null) {
                throw new RuntimeException("no data available against mentioned test id: " + id);
            }
            ProfileRepository.begin(id);
            ProfileRepository.setTestData(testData);
        }
        catch (Exception e) {
            ProfileRepository.setProfileState(ProfileState.FAILED);
            LOGGER.error("unable to fetch data against test id: " + id);
            try {
                this.sinkHandler.writeResults(id, READ_FAILURE);
            }
            catch (SinkException se) {
                LOGGER.error(String.format("sink write of READ_FAILURE failed for test id : %s with exception: ", id), (Throwable)se);
                throw new RuntimeException(se);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end(TestResponseData<T> responseData) {
        try {
            String id = ProfileRepository.getTestData().getId();
            if (!ProfileState.NONE.equals((Object)ProfileRepository.getProfileState())) {
                try {
                    this.gojiraCompareHandlerRepository.getResponseDataCompareHandler().compare(this.serdeHandlerRepository.getReqRespDataSerdeHandler().serialize(ProfileRepository.getTestData().getResponseData()), this.serdeHandlerRepository.getReqRespDataSerdeHandler().serialize(responseData));
                    this.sinkHandler.writeResults(id, RESULT_SUCCESS);
                    LOGGER.info("RESULT_SUCCESS for " + id);
                }
                catch (TestCompareException e) {
                    LOGGER.error("test compare exception.", (Throwable)e);
                    this.sinkHandler.writeResults(id, COMPARE_FAILED);
                }
                catch (Exception e) {
                    this.sinkHandler.writeResults(id, UNKNOWN_FAILED);
                    LOGGER.error("test unknown failed exception.", (Throwable)e);
                }
            }
        }
        catch (SinkException e) {
            LOGGER.error("error while saving the result", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            ProfileRepository.end();
        }
    }
}

