/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.execute.kafka;

import com.google.inject.Inject;
import flipkart.cp.gojira.execute.TestExecutor;
import flipkart.cp.gojira.external.kafka.IKafkaHelper;
import flipkart.cp.gojira.external.kafka.KafkaProducerException;
import flipkart.cp.gojira.models.TestData;
import flipkart.cp.gojira.models.kafka.KafkaTestDataType;
import flipkart.cp.gojira.models.kafka.KafkaTestRequestData;
import flipkart.cp.gojira.models.kafka.KafkaTestResponseData;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaTestExecutor
implements TestExecutor<TestData<KafkaTestRequestData, KafkaTestResponseData, KafkaTestDataType>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultKafkaTestExecutor.class);
    private static final String GOJIRA_TEST_HEADER = "X-GOJIRA-ID";
    public final IKafkaHelper kafkaHelper;

    @Inject
    public DefaultKafkaTestExecutor(IKafkaHelper kafkaHelper) {
        this.kafkaHelper = kafkaHelper;
    }

    @Override
    public void execute(TestData<KafkaTestRequestData, KafkaTestResponseData, KafkaTestDataType> testData, String clientId) throws KafkaProducerException {
        String testId = testData.getId();
        KafkaTestRequestData requestData = testData.getRequestData();
        RecordHeaders recordHeaders = new RecordHeaders();
        requestData.getHeaders().forEach((k, v) -> recordHeaders.add((Header)new RecordHeader(k, v)));
        recordHeaders.add((Header)new RecordHeader(GOJIRA_TEST_HEADER, testId.getBytes()));
        ProducerRecord producerRecord = new ProducerRecord(requestData.getTopicName(), null, (Object)requestData.getKey(), (Object)requestData.getValue(), (Iterable)recordHeaders);
        LOGGER.info("gojira test ID " + testId);
        RecordMetadata recordMetadata = this.kafkaHelper.produce(clientId, (ProducerRecord<byte[], byte[]>)producerRecord);
        this.logRecordProduction(recordMetadata, clientId, testId);
    }

    private void logRecordProduction(RecordMetadata recordMetadata, String clientId, String testId) {
        LOGGER.info(String.format("produced record to topic: %s with clientId: %s for testId: %s. ", recordMetadata.topic(), clientId, testId));
    }

    @Override
    public void execute(TestData<KafkaTestRequestData, KafkaTestResponseData, KafkaTestDataType> testData) throws KafkaProducerException {
        this.execute(testData, "DEFAULT");
    }
}

