/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.external.kafka;

import flipkart.cp.gojira.core.injectors.TestExecutionInjector;
import flipkart.cp.gojira.external.ExternalConfigRepository;
import flipkart.cp.gojira.external.Managed;
import flipkart.cp.gojira.external.SetupException;
import flipkart.cp.gojira.external.ShutdownException;
import flipkart.cp.gojira.external.config.ExternalConfig;
import flipkart.cp.gojira.external.kafka.IKafkaManager;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KafkaManager implements IKafkaManager,
Managed
{
    KAFKA_MANAGER;

    public static final Logger LOGGER;

    @Override
    public void setup() throws SetupException {
        try {
            for (Map.Entry<String, ExternalConfig> entry : ((ExternalConfigRepository)TestExecutionInjector.getInjector().getInstance(ExternalConfigRepository.class)).getExternalConfig().entrySet()) {
                Properties props = new Properties();
                props.put("bootstrap.servers", entry.getValue().getHostNamePort());
                props.put("key.serializer", ByteArraySerializer.class);
                props.put("value.serializer", ByteArraySerializer.class);
                clientMap.put(entry.getKey(), new KafkaProducer(props));
            }
        }
        catch (Exception e) {
            LOGGER.error("error setting up kafka producers.", (Throwable)e);
            throw new SetupException("error setting up kafka producers.", e);
        }
    }

    @Override
    public void shutdown() throws ShutdownException {
        try {
            for (Map.Entry entry : clientMap.entrySet()) {
                ((Producer)entry.getValue()).close();
            }
        }
        catch (Exception e) {
            LOGGER.error("error closing kafka producers.", (Throwable)e);
            throw new ShutdownException("error closing kafka producers.", e);
        }
    }

    @Override
    public Producer<byte[], byte[]> getProducer(String client) {
        return (Producer)clientMap.get(client);
    }

    static {
        LOGGER = LoggerFactory.getLogger(KafkaManager.class);
    }
}

