var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.evalWorksForGlobals_ = null;
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.getObjectByName(name) && !goog.implicitNamespaces_[name]) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.require = function(rule) {
  if(!COMPILED) {
    if(goog.getObjectByName(rule)) {
      return
    }
    var path = goog.getPathFromDeps_(rule);
    if(path) {
      goog.included_[path] = true;
      goog.writeScripts_()
    }else {
      var errorMessage = "goog.require could not find: " + rule;
      if(goog.global.console) {
        goog.global.console["error"](errorMessage)
      }
      throw Error(errorMessage);
    }
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(requireName in deps.nameToPath) {
            visitNode(deps.nameToPath[requireName])
          }else {
            if(!goog.getObjectByName(requireName)) {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  var context = selfObj || goog.global;
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(context, newArgs)
    }
  }else {
    return function() {
      return fn.apply(context, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = style
};
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global && !goog.string.contains(str, "<")) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var el = goog.global["document"]["createElement"]("div");
  el["innerHTML"] = "<pre>x" + str + "</pre>";
  if(el["firstChild"][goog.string.NORMALIZE_FN_]) {
    el["firstChild"][goog.string.NORMALIZE_FN_]()
  }
  str = el["firstChild"]["firstChild"]["nodeValue"].slice(1);
  el["innerHTML"] = "";
  return goog.string.canonicalizeNewlines(str)
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.NORMALIZE_FN_ = "normalize";
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\u000b":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  var or__3548__auto____3278 = p[goog.typeOf.call(null, x)];
  if(cljs.core.truth_(or__3548__auto____3278)) {
    return or__3548__auto____3278
  }else {
    var or__3548__auto____3279 = p["_"];
    if(cljs.core.truth_(or__3548__auto____3279)) {
      return or__3548__auto____3279
    }else {
      return false
    }
  }
};
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error.call(null, "No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.aget = function aget(array, i) {
  return array[i]
};
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__3343 = function(this$) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3280 = this$;
      if(cljs.core.truth_(and__3546__auto____3280)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3280
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$)
    }else {
      return function() {
        var or__3548__auto____3281 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3281)) {
          return or__3548__auto____3281
        }else {
          var or__3548__auto____3282 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3282)) {
            return or__3548__auto____3282
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__3344 = function(this$, a) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3283 = this$;
      if(cljs.core.truth_(and__3546__auto____3283)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3283
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a)
    }else {
      return function() {
        var or__3548__auto____3284 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3284)) {
          return or__3548__auto____3284
        }else {
          var or__3548__auto____3285 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3285)) {
            return or__3548__auto____3285
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3345 = function(this$, a, b) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3286 = this$;
      if(cljs.core.truth_(and__3546__auto____3286)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3286
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____3287 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3287)) {
          return or__3548__auto____3287
        }else {
          var or__3548__auto____3288 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3288)) {
            return or__3548__auto____3288
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__3346 = function(this$, a, b, c) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3289 = this$;
      if(cljs.core.truth_(and__3546__auto____3289)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3289
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____3290 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3290)) {
          return or__3548__auto____3290
        }else {
          var or__3548__auto____3291 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3291)) {
            return or__3548__auto____3291
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__3347 = function(this$, a, b, c, d) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3292 = this$;
      if(cljs.core.truth_(and__3546__auto____3292)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3292
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____3293 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3293)) {
          return or__3548__auto____3293
        }else {
          var or__3548__auto____3294 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3294)) {
            return or__3548__auto____3294
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__3348 = function(this$, a, b, c, d, e) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3295 = this$;
      if(cljs.core.truth_(and__3546__auto____3295)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3295
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____3296 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3296)) {
          return or__3548__auto____3296
        }else {
          var or__3548__auto____3297 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3297)) {
            return or__3548__auto____3297
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__3349 = function(this$, a, b, c, d, e, f) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3298 = this$;
      if(cljs.core.truth_(and__3546__auto____3298)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3298
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____3299 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3299)) {
          return or__3548__auto____3299
        }else {
          var or__3548__auto____3300 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3300)) {
            return or__3548__auto____3300
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__3350 = function(this$, a, b, c, d, e, f, g) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3301 = this$;
      if(cljs.core.truth_(and__3546__auto____3301)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3301
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____3302 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3302)) {
          return or__3548__auto____3302
        }else {
          var or__3548__auto____3303 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3303)) {
            return or__3548__auto____3303
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__3351 = function(this$, a, b, c, d, e, f, g, h) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3304 = this$;
      if(cljs.core.truth_(and__3546__auto____3304)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3304
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____3305 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3305)) {
          return or__3548__auto____3305
        }else {
          var or__3548__auto____3306 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3306)) {
            return or__3548__auto____3306
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__3352 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3307 = this$;
      if(cljs.core.truth_(and__3546__auto____3307)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3307
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____3308 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3308)) {
          return or__3548__auto____3308
        }else {
          var or__3548__auto____3309 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3309)) {
            return or__3548__auto____3309
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__3353 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3310 = this$;
      if(cljs.core.truth_(and__3546__auto____3310)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3310
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____3311 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3311)) {
          return or__3548__auto____3311
        }else {
          var or__3548__auto____3312 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3312)) {
            return or__3548__auto____3312
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__3354 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3313 = this$;
      if(cljs.core.truth_(and__3546__auto____3313)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3313
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____3314 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3314)) {
          return or__3548__auto____3314
        }else {
          var or__3548__auto____3315 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3315)) {
            return or__3548__auto____3315
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__3355 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3316 = this$;
      if(cljs.core.truth_(and__3546__auto____3316)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3316
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____3317 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3317)) {
          return or__3548__auto____3317
        }else {
          var or__3548__auto____3318 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3318)) {
            return or__3548__auto____3318
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__3356 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3319 = this$;
      if(cljs.core.truth_(and__3546__auto____3319)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3319
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____3320 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3320)) {
          return or__3548__auto____3320
        }else {
          var or__3548__auto____3321 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3321)) {
            return or__3548__auto____3321
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__3357 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3322 = this$;
      if(cljs.core.truth_(and__3546__auto____3322)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3322
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____3323 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3323)) {
          return or__3548__auto____3323
        }else {
          var or__3548__auto____3324 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3324)) {
            return or__3548__auto____3324
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__3358 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3325 = this$;
      if(cljs.core.truth_(and__3546__auto____3325)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3325
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____3326 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3326)) {
          return or__3548__auto____3326
        }else {
          var or__3548__auto____3327 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3327)) {
            return or__3548__auto____3327
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__3359 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3328 = this$;
      if(cljs.core.truth_(and__3546__auto____3328)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3328
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____3329 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3329)) {
          return or__3548__auto____3329
        }else {
          var or__3548__auto____3330 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3330)) {
            return or__3548__auto____3330
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__3360 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3331 = this$;
      if(cljs.core.truth_(and__3546__auto____3331)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3331
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____3332 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3332)) {
          return or__3548__auto____3332
        }else {
          var or__3548__auto____3333 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3333)) {
            return or__3548__auto____3333
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__3361 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3334 = this$;
      if(cljs.core.truth_(and__3546__auto____3334)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3334
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____3335 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3335)) {
          return or__3548__auto____3335
        }else {
          var or__3548__auto____3336 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3336)) {
            return or__3548__auto____3336
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__3362 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3337 = this$;
      if(cljs.core.truth_(and__3546__auto____3337)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3337
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____3338 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3338)) {
          return or__3548__auto____3338
        }else {
          var or__3548__auto____3339 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3339)) {
            return or__3548__auto____3339
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__3363 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3340 = this$;
      if(cljs.core.truth_(and__3546__auto____3340)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3340
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____3341 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3341)) {
          return or__3548__auto____3341
        }else {
          var or__3548__auto____3342 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3342)) {
            return or__3548__auto____3342
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__3343.call(this, this$);
      case 2:
        return _invoke__3344.call(this, this$, a);
      case 3:
        return _invoke__3345.call(this, this$, a, b);
      case 4:
        return _invoke__3346.call(this, this$, a, b, c);
      case 5:
        return _invoke__3347.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__3348.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__3349.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__3350.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__3351.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__3352.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__3353.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__3354.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__3355.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__3356.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__3357.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__3358.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__3359.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__3360.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__3361.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__3362.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__3363.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _invoke
}();
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3365 = coll;
    if(cljs.core.truth_(and__3546__auto____3365)) {
      return coll.cljs$core$ICounted$_count
    }else {
      return and__3546__auto____3365
    }
  }())) {
    return coll.cljs$core$ICounted$_count(coll)
  }else {
    return function() {
      var or__3548__auto____3366 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3366)) {
        return or__3548__auto____3366
      }else {
        var or__3548__auto____3367 = cljs.core._count["_"];
        if(cljs.core.truth_(or__3548__auto____3367)) {
          return or__3548__auto____3367
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3368 = coll;
    if(cljs.core.truth_(and__3546__auto____3368)) {
      return coll.cljs$core$IEmptyableCollection$_empty
    }else {
      return and__3546__auto____3368
    }
  }())) {
    return coll.cljs$core$IEmptyableCollection$_empty(coll)
  }else {
    return function() {
      var or__3548__auto____3369 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3369)) {
        return or__3548__auto____3369
      }else {
        var or__3548__auto____3370 = cljs.core._empty["_"];
        if(cljs.core.truth_(or__3548__auto____3370)) {
          return or__3548__auto____3370
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3371 = coll;
    if(cljs.core.truth_(and__3546__auto____3371)) {
      return coll.cljs$core$ICollection$_conj
    }else {
      return and__3546__auto____3371
    }
  }())) {
    return coll.cljs$core$ICollection$_conj(coll, o)
  }else {
    return function() {
      var or__3548__auto____3372 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3372)) {
        return or__3548__auto____3372
      }else {
        var or__3548__auto____3373 = cljs.core._conj["_"];
        if(cljs.core.truth_(or__3548__auto____3373)) {
          return or__3548__auto____3373
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__3380 = function(coll, n) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3374 = coll;
      if(cljs.core.truth_(and__3546__auto____3374)) {
        return coll.cljs$core$IIndexed$_nth
      }else {
        return and__3546__auto____3374
      }
    }())) {
      return coll.cljs$core$IIndexed$_nth(coll, n)
    }else {
      return function() {
        var or__3548__auto____3375 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3375)) {
          return or__3548__auto____3375
        }else {
          var or__3548__auto____3376 = cljs.core._nth["_"];
          if(cljs.core.truth_(or__3548__auto____3376)) {
            return or__3548__auto____3376
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3381 = function(coll, n, not_found) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3377 = coll;
      if(cljs.core.truth_(and__3546__auto____3377)) {
        return coll.cljs$core$IIndexed$_nth
      }else {
        return and__3546__auto____3377
      }
    }())) {
      return coll.cljs$core$IIndexed$_nth(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____3378 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3378)) {
          return or__3548__auto____3378
        }else {
          var or__3548__auto____3379 = cljs.core._nth["_"];
          if(cljs.core.truth_(or__3548__auto____3379)) {
            return or__3548__auto____3379
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__3380.call(this, coll, n);
      case 3:
        return _nth__3381.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _nth
}();
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3383 = coll;
    if(cljs.core.truth_(and__3546__auto____3383)) {
      return coll.cljs$core$ISeq$_first
    }else {
      return and__3546__auto____3383
    }
  }())) {
    return coll.cljs$core$ISeq$_first(coll)
  }else {
    return function() {
      var or__3548__auto____3384 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3384)) {
        return or__3548__auto____3384
      }else {
        var or__3548__auto____3385 = cljs.core._first["_"];
        if(cljs.core.truth_(or__3548__auto____3385)) {
          return or__3548__auto____3385
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3386 = coll;
    if(cljs.core.truth_(and__3546__auto____3386)) {
      return coll.cljs$core$ISeq$_rest
    }else {
      return and__3546__auto____3386
    }
  }())) {
    return coll.cljs$core$ISeq$_rest(coll)
  }else {
    return function() {
      var or__3548__auto____3387 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3387)) {
        return or__3548__auto____3387
      }else {
        var or__3548__auto____3388 = cljs.core._rest["_"];
        if(cljs.core.truth_(or__3548__auto____3388)) {
          return or__3548__auto____3388
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__3395 = function(o, k) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3389 = o;
      if(cljs.core.truth_(and__3546__auto____3389)) {
        return o.cljs$core$ILookup$_lookup
      }else {
        return and__3546__auto____3389
      }
    }())) {
      return o.cljs$core$ILookup$_lookup(o, k)
    }else {
      return function() {
        var or__3548__auto____3390 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(cljs.core.truth_(or__3548__auto____3390)) {
          return or__3548__auto____3390
        }else {
          var or__3548__auto____3391 = cljs.core._lookup["_"];
          if(cljs.core.truth_(or__3548__auto____3391)) {
            return or__3548__auto____3391
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3396 = function(o, k, not_found) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3392 = o;
      if(cljs.core.truth_(and__3546__auto____3392)) {
        return o.cljs$core$ILookup$_lookup
      }else {
        return and__3546__auto____3392
      }
    }())) {
      return o.cljs$core$ILookup$_lookup(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____3393 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(cljs.core.truth_(or__3548__auto____3393)) {
          return or__3548__auto____3393
        }else {
          var or__3548__auto____3394 = cljs.core._lookup["_"];
          if(cljs.core.truth_(or__3548__auto____3394)) {
            return or__3548__auto____3394
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__3395.call(this, o, k);
      case 3:
        return _lookup__3396.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _lookup
}();
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3398 = coll;
    if(cljs.core.truth_(and__3546__auto____3398)) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_
    }else {
      return and__3546__auto____3398
    }
  }())) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_(coll, k)
  }else {
    return function() {
      var or__3548__auto____3399 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3399)) {
        return or__3548__auto____3399
      }else {
        var or__3548__auto____3400 = cljs.core._contains_key_QMARK_["_"];
        if(cljs.core.truth_(or__3548__auto____3400)) {
          return or__3548__auto____3400
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3401 = coll;
    if(cljs.core.truth_(and__3546__auto____3401)) {
      return coll.cljs$core$IAssociative$_assoc
    }else {
      return and__3546__auto____3401
    }
  }())) {
    return coll.cljs$core$IAssociative$_assoc(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____3402 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3402)) {
        return or__3548__auto____3402
      }else {
        var or__3548__auto____3403 = cljs.core._assoc["_"];
        if(cljs.core.truth_(or__3548__auto____3403)) {
          return or__3548__auto____3403
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3404 = coll;
    if(cljs.core.truth_(and__3546__auto____3404)) {
      return coll.cljs$core$IMap$_dissoc
    }else {
      return and__3546__auto____3404
    }
  }())) {
    return coll.cljs$core$IMap$_dissoc(coll, k)
  }else {
    return function() {
      var or__3548__auto____3405 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3405)) {
        return or__3548__auto____3405
      }else {
        var or__3548__auto____3406 = cljs.core._dissoc["_"];
        if(cljs.core.truth_(or__3548__auto____3406)) {
          return or__3548__auto____3406
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3407 = coll;
    if(cljs.core.truth_(and__3546__auto____3407)) {
      return coll.cljs$core$ISet$_disjoin
    }else {
      return and__3546__auto____3407
    }
  }())) {
    return coll.cljs$core$ISet$_disjoin(coll, v)
  }else {
    return function() {
      var or__3548__auto____3408 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3408)) {
        return or__3548__auto____3408
      }else {
        var or__3548__auto____3409 = cljs.core._disjoin["_"];
        if(cljs.core.truth_(or__3548__auto____3409)) {
          return or__3548__auto____3409
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3410 = coll;
    if(cljs.core.truth_(and__3546__auto____3410)) {
      return coll.cljs$core$IStack$_peek
    }else {
      return and__3546__auto____3410
    }
  }())) {
    return coll.cljs$core$IStack$_peek(coll)
  }else {
    return function() {
      var or__3548__auto____3411 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3411)) {
        return or__3548__auto____3411
      }else {
        var or__3548__auto____3412 = cljs.core._peek["_"];
        if(cljs.core.truth_(or__3548__auto____3412)) {
          return or__3548__auto____3412
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3413 = coll;
    if(cljs.core.truth_(and__3546__auto____3413)) {
      return coll.cljs$core$IStack$_pop
    }else {
      return and__3546__auto____3413
    }
  }())) {
    return coll.cljs$core$IStack$_pop(coll)
  }else {
    return function() {
      var or__3548__auto____3414 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3414)) {
        return or__3548__auto____3414
      }else {
        var or__3548__auto____3415 = cljs.core._pop["_"];
        if(cljs.core.truth_(or__3548__auto____3415)) {
          return or__3548__auto____3415
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3416 = coll;
    if(cljs.core.truth_(and__3546__auto____3416)) {
      return coll.cljs$core$IVector$_assoc_n
    }else {
      return and__3546__auto____3416
    }
  }())) {
    return coll.cljs$core$IVector$_assoc_n(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____3417 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3417)) {
        return or__3548__auto____3417
      }else {
        var or__3548__auto____3418 = cljs.core._assoc_n["_"];
        if(cljs.core.truth_(or__3548__auto____3418)) {
          return or__3548__auto____3418
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3419 = o;
    if(cljs.core.truth_(and__3546__auto____3419)) {
      return o.cljs$core$IDeref$_deref
    }else {
      return and__3546__auto____3419
    }
  }())) {
    return o.cljs$core$IDeref$_deref(o)
  }else {
    return function() {
      var or__3548__auto____3420 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3420)) {
        return or__3548__auto____3420
      }else {
        var or__3548__auto____3421 = cljs.core._deref["_"];
        if(cljs.core.truth_(or__3548__auto____3421)) {
          return or__3548__auto____3421
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3422 = o;
    if(cljs.core.truth_(and__3546__auto____3422)) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout
    }else {
      return and__3546__auto____3422
    }
  }())) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____3423 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3423)) {
        return or__3548__auto____3423
      }else {
        var or__3548__auto____3424 = cljs.core._deref_with_timeout["_"];
        if(cljs.core.truth_(or__3548__auto____3424)) {
          return or__3548__auto____3424
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3425 = o;
    if(cljs.core.truth_(and__3546__auto____3425)) {
      return o.cljs$core$IMeta$_meta
    }else {
      return and__3546__auto____3425
    }
  }())) {
    return o.cljs$core$IMeta$_meta(o)
  }else {
    return function() {
      var or__3548__auto____3426 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3426)) {
        return or__3548__auto____3426
      }else {
        var or__3548__auto____3427 = cljs.core._meta["_"];
        if(cljs.core.truth_(or__3548__auto____3427)) {
          return or__3548__auto____3427
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3428 = o;
    if(cljs.core.truth_(and__3546__auto____3428)) {
      return o.cljs$core$IWithMeta$_with_meta
    }else {
      return and__3546__auto____3428
    }
  }())) {
    return o.cljs$core$IWithMeta$_with_meta(o, meta)
  }else {
    return function() {
      var or__3548__auto____3429 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3429)) {
        return or__3548__auto____3429
      }else {
        var or__3548__auto____3430 = cljs.core._with_meta["_"];
        if(cljs.core.truth_(or__3548__auto____3430)) {
          return or__3548__auto____3430
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__3437 = function(coll, f) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3431 = coll;
      if(cljs.core.truth_(and__3546__auto____3431)) {
        return coll.cljs$core$IReduce$_reduce
      }else {
        return and__3546__auto____3431
      }
    }())) {
      return coll.cljs$core$IReduce$_reduce(coll, f)
    }else {
      return function() {
        var or__3548__auto____3432 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3432)) {
          return or__3548__auto____3432
        }else {
          var or__3548__auto____3433 = cljs.core._reduce["_"];
          if(cljs.core.truth_(or__3548__auto____3433)) {
            return or__3548__auto____3433
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3438 = function(coll, f, start) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3434 = coll;
      if(cljs.core.truth_(and__3546__auto____3434)) {
        return coll.cljs$core$IReduce$_reduce
      }else {
        return and__3546__auto____3434
      }
    }())) {
      return coll.cljs$core$IReduce$_reduce(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____3435 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3435)) {
          return or__3548__auto____3435
        }else {
          var or__3548__auto____3436 = cljs.core._reduce["_"];
          if(cljs.core.truth_(or__3548__auto____3436)) {
            return or__3548__auto____3436
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__3437.call(this, coll, f);
      case 3:
        return _reduce__3438.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _reduce
}();
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3440 = o;
    if(cljs.core.truth_(and__3546__auto____3440)) {
      return o.cljs$core$IEquiv$_equiv
    }else {
      return and__3546__auto____3440
    }
  }())) {
    return o.cljs$core$IEquiv$_equiv(o, other)
  }else {
    return function() {
      var or__3548__auto____3441 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3441)) {
        return or__3548__auto____3441
      }else {
        var or__3548__auto____3442 = cljs.core._equiv["_"];
        if(cljs.core.truth_(or__3548__auto____3442)) {
          return or__3548__auto____3442
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3443 = o;
    if(cljs.core.truth_(and__3546__auto____3443)) {
      return o.cljs$core$IHash$_hash
    }else {
      return and__3546__auto____3443
    }
  }())) {
    return o.cljs$core$IHash$_hash(o)
  }else {
    return function() {
      var or__3548__auto____3444 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3444)) {
        return or__3548__auto____3444
      }else {
        var or__3548__auto____3445 = cljs.core._hash["_"];
        if(cljs.core.truth_(or__3548__auto____3445)) {
          return or__3548__auto____3445
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3446 = o;
    if(cljs.core.truth_(and__3546__auto____3446)) {
      return o.cljs$core$ISeqable$_seq
    }else {
      return and__3546__auto____3446
    }
  }())) {
    return o.cljs$core$ISeqable$_seq(o)
  }else {
    return function() {
      var or__3548__auto____3447 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3447)) {
        return or__3548__auto____3447
      }else {
        var or__3548__auto____3448 = cljs.core._seq["_"];
        if(cljs.core.truth_(or__3548__auto____3448)) {
          return or__3548__auto____3448
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISequential = {};
cljs.core.IRecord = {};
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3449 = o;
    if(cljs.core.truth_(and__3546__auto____3449)) {
      return o.cljs$core$IPrintable$_pr_seq
    }else {
      return and__3546__auto____3449
    }
  }())) {
    return o.cljs$core$IPrintable$_pr_seq(o, opts)
  }else {
    return function() {
      var or__3548__auto____3450 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3450)) {
        return or__3548__auto____3450
      }else {
        var or__3548__auto____3451 = cljs.core._pr_seq["_"];
        if(cljs.core.truth_(or__3548__auto____3451)) {
          return or__3548__auto____3451
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3452 = d;
    if(cljs.core.truth_(and__3546__auto____3452)) {
      return d.cljs$core$IPending$_realized_QMARK_
    }else {
      return and__3546__auto____3452
    }
  }())) {
    return d.cljs$core$IPending$_realized_QMARK_(d)
  }else {
    return function() {
      var or__3548__auto____3453 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(cljs.core.truth_(or__3548__auto____3453)) {
        return or__3548__auto____3453
      }else {
        var or__3548__auto____3454 = cljs.core._realized_QMARK_["_"];
        if(cljs.core.truth_(or__3548__auto____3454)) {
          return or__3548__auto____3454
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3455 = this$;
    if(cljs.core.truth_(and__3546__auto____3455)) {
      return this$.cljs$core$IWatchable$_notify_watches
    }else {
      return and__3546__auto____3455
    }
  }())) {
    return this$.cljs$core$IWatchable$_notify_watches(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____3456 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(cljs.core.truth_(or__3548__auto____3456)) {
        return or__3548__auto____3456
      }else {
        var or__3548__auto____3457 = cljs.core._notify_watches["_"];
        if(cljs.core.truth_(or__3548__auto____3457)) {
          return or__3548__auto____3457
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3458 = this$;
    if(cljs.core.truth_(and__3546__auto____3458)) {
      return this$.cljs$core$IWatchable$_add_watch
    }else {
      return and__3546__auto____3458
    }
  }())) {
    return this$.cljs$core$IWatchable$_add_watch(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____3459 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(cljs.core.truth_(or__3548__auto____3459)) {
        return or__3548__auto____3459
      }else {
        var or__3548__auto____3460 = cljs.core._add_watch["_"];
        if(cljs.core.truth_(or__3548__auto____3460)) {
          return or__3548__auto____3460
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3461 = this$;
    if(cljs.core.truth_(and__3546__auto____3461)) {
      return this$.cljs$core$IWatchable$_remove_watch
    }else {
      return and__3546__auto____3461
    }
  }())) {
    return this$.cljs$core$IWatchable$_remove_watch(this$, key)
  }else {
    return function() {
      var or__3548__auto____3462 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(cljs.core.truth_(or__3548__auto____3462)) {
        return or__3548__auto____3462
      }else {
        var or__3548__auto____3463 = cljs.core._remove_watch["_"];
        if(cljs.core.truth_(or__3548__auto____3463)) {
          return or__3548__auto____3463
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
cljs.core._EQ_ = function _EQ_(x, y) {
  return cljs.core._equiv.call(null, x, y)
};
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x === null
};
cljs.core.type = function type(x) {
  return x.constructor
};
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__3464 = null;
  var G__3464__3465 = function(o, k) {
    return null
  };
  var G__3464__3466 = function(o, k, not_found) {
    return not_found
  };
  G__3464 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3464__3465.call(this, o, k);
      case 3:
        return G__3464__3466.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3464
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__3468 = null;
  var G__3468__3469 = function(_, f) {
    return f.call(null)
  };
  var G__3468__3470 = function(_, f, start) {
    return start
  };
  G__3468 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3468__3469.call(this, _, f);
      case 3:
        return G__3468__3470.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3468
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o === null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__3472 = null;
  var G__3472__3473 = function(_, n) {
    return null
  };
  var G__3472__3474 = function(_, n, not_found) {
    return not_found
  };
  G__3472 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3472__3473.call(this, _, n);
      case 3:
        return G__3472__3474.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3472
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__3482 = function(cicoll, f) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, 0, cljs.core._count.call(null, cicoll)))) {
      return f.call(null)
    }else {
      var val__3476 = cljs.core._nth.call(null, cicoll, 0);
      var n__3477 = 1;
      while(true) {
        if(cljs.core.truth_(n__3477 < cljs.core._count.call(null, cicoll))) {
          var G__3486 = f.call(null, val__3476, cljs.core._nth.call(null, cicoll, n__3477));
          var G__3487 = n__3477 + 1;
          val__3476 = G__3486;
          n__3477 = G__3487;
          continue
        }else {
          return val__3476
        }
        break
      }
    }
  };
  var ci_reduce__3483 = function(cicoll, f, val) {
    var val__3478 = val;
    var n__3479 = 0;
    while(true) {
      if(cljs.core.truth_(n__3479 < cljs.core._count.call(null, cicoll))) {
        var G__3488 = f.call(null, val__3478, cljs.core._nth.call(null, cicoll, n__3479));
        var G__3489 = n__3479 + 1;
        val__3478 = G__3488;
        n__3479 = G__3489;
        continue
      }else {
        return val__3478
      }
      break
    }
  };
  var ci_reduce__3484 = function(cicoll, f, val, idx) {
    var val__3480 = val;
    var n__3481 = idx;
    while(true) {
      if(cljs.core.truth_(n__3481 < cljs.core._count.call(null, cicoll))) {
        var G__3490 = f.call(null, val__3480, cljs.core._nth.call(null, cicoll, n__3481));
        var G__3491 = n__3481 + 1;
        val__3480 = G__3490;
        n__3481 = G__3491;
        continue
      }else {
        return val__3480
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__3482.call(this, cicoll, f);
      case 3:
        return ci_reduce__3483.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__3484.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return ci_reduce
}();
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i
};
cljs.core.IndexedSeq.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3492 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce = function() {
  var G__3505 = null;
  var G__3505__3506 = function(_, f) {
    var this__3493 = this;
    return cljs.core.ci_reduce.call(null, this__3493.a, f, this__3493.a[this__3493.i], this__3493.i + 1)
  };
  var G__3505__3507 = function(_, f, start) {
    var this__3494 = this;
    return cljs.core.ci_reduce.call(null, this__3494.a, f, start, this__3494.i)
  };
  G__3505 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3505__3506.call(this, _, f);
      case 3:
        return G__3505__3507.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3505
}();
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3495 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3496 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth = function() {
  var G__3509 = null;
  var G__3509__3510 = function(coll, n) {
    var this__3497 = this;
    var i__3498 = n + this__3497.i;
    if(cljs.core.truth_(i__3498 < this__3497.a.length)) {
      return this__3497.a[i__3498]
    }else {
      return null
    }
  };
  var G__3509__3511 = function(coll, n, not_found) {
    var this__3499 = this;
    var i__3500 = n + this__3499.i;
    if(cljs.core.truth_(i__3500 < this__3499.a.length)) {
      return this__3499.a[i__3500]
    }else {
      return not_found
    }
  };
  G__3509 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3509__3510.call(this, coll, n);
      case 3:
        return G__3509__3511.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3509
}();
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count = function(_) {
  var this__3501 = this;
  return this__3501.a.length - this__3501.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first = function(_) {
  var this__3502 = this;
  return this__3502.a[this__3502.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest = function(_) {
  var this__3503 = this;
  if(cljs.core.truth_(this__3503.i + 1 < this__3503.a.length)) {
    return new cljs.core.IndexedSeq(this__3503.a, this__3503.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq = function(this$) {
  var this__3504 = this;
  return this$
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function prim_seq(prim, i) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, 0, prim.length))) {
    return null
  }else {
    return new cljs.core.IndexedSeq(prim, i)
  }
};
cljs.core.array_seq = function array_seq(array, i) {
  return cljs.core.prim_seq.call(null, array, i)
};
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__3513 = null;
  var G__3513__3514 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__3513__3515 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__3513 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3513__3514.call(this, array, f);
      case 3:
        return G__3513__3515.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3513
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__3517 = null;
  var G__3517__3518 = function(array, k) {
    return array[k]
  };
  var G__3517__3519 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__3517 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3517__3518.call(this, array, k);
      case 3:
        return G__3517__3519.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3517
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__3521 = null;
  var G__3521__3522 = function(array, n) {
    if(cljs.core.truth_(n < array.length)) {
      return array[n]
    }else {
      return null
    }
  };
  var G__3521__3523 = function(array, n, not_found) {
    if(cljs.core.truth_(n < array.length)) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__3521 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3521__3522.call(this, array, n);
      case 3:
        return G__3521__3523.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3521
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(cljs.core.truth_(coll)) {
    return cljs.core._seq.call(null, coll)
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  var temp__3698__auto____3525 = cljs.core.seq.call(null, coll);
  if(cljs.core.truth_(temp__3698__auto____3525)) {
    var s__3526 = temp__3698__auto____3525;
    return cljs.core._first.call(null, s__3526)
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  return cljs.core._rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.next = function next(coll) {
  if(cljs.core.truth_(coll)) {
    return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__3527 = cljs.core.next.call(null, s);
      s = G__3527;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.ICounted["_"] = true;
cljs.core._count["_"] = function(x) {
  var s__3528 = cljs.core.seq.call(null, x);
  var n__3529 = 0;
  while(true) {
    if(cljs.core.truth_(s__3528)) {
      var G__3530 = cljs.core.next.call(null, s__3528);
      var G__3531 = n__3529 + 1;
      s__3528 = G__3530;
      n__3529 = G__3531;
      continue
    }else {
      return n__3529
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__3532 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3533 = function() {
    var G__3535__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__3536 = conj.call(null, coll, x);
          var G__3537 = cljs.core.first.call(null, xs);
          var G__3538 = cljs.core.next.call(null, xs);
          coll = G__3536;
          x = G__3537;
          xs = G__3538;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__3535 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3535__delegate.call(this, coll, x, xs)
    };
    G__3535.cljs$lang$maxFixedArity = 2;
    G__3535.cljs$lang$applyTo = function(arglist__3539) {
      var coll = cljs.core.first(arglist__3539);
      var x = cljs.core.first(cljs.core.next(arglist__3539));
      var xs = cljs.core.rest(cljs.core.next(arglist__3539));
      return G__3535__delegate.call(this, coll, x, xs)
    };
    return G__3535
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__3532.call(this, coll, x);
      default:
        return conj__3533.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3533.cljs$lang$applyTo;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
cljs.core.count = function count(coll) {
  return cljs.core._count.call(null, coll)
};
cljs.core.nth = function() {
  var nth = null;
  var nth__3540 = function(coll, n) {
    return cljs.core._nth.call(null, coll, Math.floor(n))
  };
  var nth__3541 = function(coll, n, not_found) {
    return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__3540.call(this, coll, n);
      case 3:
        return nth__3541.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__3543 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3544 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__3543.call(this, o, k);
      case 3:
        return get__3544.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3547 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__3548 = function() {
    var G__3550__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__3546 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__3551 = ret__3546;
          var G__3552 = cljs.core.first.call(null, kvs);
          var G__3553 = cljs.core.second.call(null, kvs);
          var G__3554 = cljs.core.nnext.call(null, kvs);
          coll = G__3551;
          k = G__3552;
          v = G__3553;
          kvs = G__3554;
          continue
        }else {
          return ret__3546
        }
        break
      }
    };
    var G__3550 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__3550__delegate.call(this, coll, k, v, kvs)
    };
    G__3550.cljs$lang$maxFixedArity = 3;
    G__3550.cljs$lang$applyTo = function(arglist__3555) {
      var coll = cljs.core.first(arglist__3555);
      var k = cljs.core.first(cljs.core.next(arglist__3555));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3555)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3555)));
      return G__3550__delegate.call(this, coll, k, v, kvs)
    };
    return G__3550
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3547.call(this, coll, k, v);
      default:
        return assoc__3548.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__3548.cljs$lang$applyTo;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__3557 = function(coll) {
    return coll
  };
  var dissoc__3558 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3559 = function() {
    var G__3561__delegate = function(coll, k, ks) {
      while(true) {
        var ret__3556 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__3562 = ret__3556;
          var G__3563 = cljs.core.first.call(null, ks);
          var G__3564 = cljs.core.next.call(null, ks);
          coll = G__3562;
          k = G__3563;
          ks = G__3564;
          continue
        }else {
          return ret__3556
        }
        break
      }
    };
    var G__3561 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3561__delegate.call(this, coll, k, ks)
    };
    G__3561.cljs$lang$maxFixedArity = 2;
    G__3561.cljs$lang$applyTo = function(arglist__3565) {
      var coll = cljs.core.first(arglist__3565);
      var k = cljs.core.first(cljs.core.next(arglist__3565));
      var ks = cljs.core.rest(cljs.core.next(arglist__3565));
      return G__3561__delegate.call(this, coll, k, ks)
    };
    return G__3561
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__3557.call(this, coll);
      case 2:
        return dissoc__3558.call(this, coll, k);
      default:
        return dissoc__3559.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3559.cljs$lang$applyTo;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(cljs.core.truth_(function() {
    var x__451__auto____3566 = o;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3567 = x__451__auto____3566;
      if(cljs.core.truth_(and__3546__auto____3567)) {
        var and__3546__auto____3568 = x__451__auto____3566.cljs$core$IMeta$;
        if(cljs.core.truth_(and__3546__auto____3568)) {
          return cljs.core.not.call(null, x__451__auto____3566.hasOwnProperty("cljs$core$IMeta$"))
        }else {
          return and__3546__auto____3568
        }
      }else {
        return and__3546__auto____3567
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, x__451__auto____3566)
    }
  }())) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__3570 = function(coll) {
    return coll
  };
  var disj__3571 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3572 = function() {
    var G__3574__delegate = function(coll, k, ks) {
      while(true) {
        var ret__3569 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__3575 = ret__3569;
          var G__3576 = cljs.core.first.call(null, ks);
          var G__3577 = cljs.core.next.call(null, ks);
          coll = G__3575;
          k = G__3576;
          ks = G__3577;
          continue
        }else {
          return ret__3569
        }
        break
      }
    };
    var G__3574 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3574__delegate.call(this, coll, k, ks)
    };
    G__3574.cljs$lang$maxFixedArity = 2;
    G__3574.cljs$lang$applyTo = function(arglist__3578) {
      var coll = cljs.core.first(arglist__3578);
      var k = cljs.core.first(cljs.core.next(arglist__3578));
      var ks = cljs.core.rest(cljs.core.next(arglist__3578));
      return G__3574__delegate.call(this, coll, k, ks)
    };
    return G__3574
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__3570.call(this, coll);
      case 2:
        return disj__3571.call(this, coll, k);
      default:
        return disj__3572.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3572.cljs$lang$applyTo;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(cljs.core.truth_(x === null)) {
    return false
  }else {
    var x__451__auto____3579 = x;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3580 = x__451__auto____3579;
      if(cljs.core.truth_(and__3546__auto____3580)) {
        var and__3546__auto____3581 = x__451__auto____3579.cljs$core$ICollection$;
        if(cljs.core.truth_(and__3546__auto____3581)) {
          return cljs.core.not.call(null, x__451__auto____3579.hasOwnProperty("cljs$core$ICollection$"))
        }else {
          return and__3546__auto____3581
        }
      }else {
        return and__3546__auto____3580
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, x__451__auto____3579)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(cljs.core.truth_(x === null)) {
    return false
  }else {
    var x__451__auto____3582 = x;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3583 = x__451__auto____3582;
      if(cljs.core.truth_(and__3546__auto____3583)) {
        var and__3546__auto____3584 = x__451__auto____3582.cljs$core$ISet$;
        if(cljs.core.truth_(and__3546__auto____3584)) {
          return cljs.core.not.call(null, x__451__auto____3582.hasOwnProperty("cljs$core$ISet$"))
        }else {
          return and__3546__auto____3584
        }
      }else {
        return and__3546__auto____3583
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, x__451__auto____3582)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var x__451__auto____3585 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3586 = x__451__auto____3585;
    if(cljs.core.truth_(and__3546__auto____3586)) {
      var and__3546__auto____3587 = x__451__auto____3585.cljs$core$IAssociative$;
      if(cljs.core.truth_(and__3546__auto____3587)) {
        return cljs.core.not.call(null, x__451__auto____3585.hasOwnProperty("cljs$core$IAssociative$"))
      }else {
        return and__3546__auto____3587
      }
    }else {
      return and__3546__auto____3586
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, x__451__auto____3585)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var x__451__auto____3588 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3589 = x__451__auto____3588;
    if(cljs.core.truth_(and__3546__auto____3589)) {
      var and__3546__auto____3590 = x__451__auto____3588.cljs$core$ISequential$;
      if(cljs.core.truth_(and__3546__auto____3590)) {
        return cljs.core.not.call(null, x__451__auto____3588.hasOwnProperty("cljs$core$ISequential$"))
      }else {
        return and__3546__auto____3590
      }
    }else {
      return and__3546__auto____3589
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, x__451__auto____3588)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var x__451__auto____3591 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3592 = x__451__auto____3591;
    if(cljs.core.truth_(and__3546__auto____3592)) {
      var and__3546__auto____3593 = x__451__auto____3591.cljs$core$ICounted$;
      if(cljs.core.truth_(and__3546__auto____3593)) {
        return cljs.core.not.call(null, x__451__auto____3591.hasOwnProperty("cljs$core$ICounted$"))
      }else {
        return and__3546__auto____3593
      }
    }else {
      return and__3546__auto____3592
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, x__451__auto____3591)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(cljs.core.truth_(x === null)) {
    return false
  }else {
    var x__451__auto____3594 = x;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3595 = x__451__auto____3594;
      if(cljs.core.truth_(and__3546__auto____3595)) {
        var and__3546__auto____3596 = x__451__auto____3594.cljs$core$IMap$;
        if(cljs.core.truth_(and__3546__auto____3596)) {
          return cljs.core.not.call(null, x__451__auto____3594.hasOwnProperty("cljs$core$IMap$"))
        }else {
          return and__3546__auto____3596
        }
      }else {
        return and__3546__auto____3595
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, x__451__auto____3594)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var x__451__auto____3597 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3598 = x__451__auto____3597;
    if(cljs.core.truth_(and__3546__auto____3598)) {
      var and__3546__auto____3599 = x__451__auto____3597.cljs$core$IVector$;
      if(cljs.core.truth_(and__3546__auto____3599)) {
        return cljs.core.not.call(null, x__451__auto____3597.hasOwnProperty("cljs$core$IVector$"))
      }else {
        return and__3546__auto____3599
      }
    }else {
      return and__3546__auto____3598
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, x__451__auto____3597)
  }
};
cljs.core.js_obj = function js_obj() {
  return{}
};
cljs.core.js_keys = function js_keys(obj) {
  var keys__3600 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__3600.push(key)
  });
  return keys__3600
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.lookup_sentinel = cljs.core.js_obj.call(null);
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(cljs.core.truth_(s === null)) {
    return false
  }else {
    var x__451__auto____3601 = s;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3602 = x__451__auto____3601;
      if(cljs.core.truth_(and__3546__auto____3602)) {
        var and__3546__auto____3603 = x__451__auto____3601.cljs$core$ISeq$;
        if(cljs.core.truth_(and__3546__auto____3603)) {
          return cljs.core.not.call(null, x__451__auto____3601.hasOwnProperty("cljs$core$ISeq$"))
        }else {
          return and__3546__auto____3603
        }
      }else {
        return and__3546__auto____3602
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, x__451__auto____3601)
    }
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____3604 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____3604)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____3605 = cljs.core._EQ_.call(null, x.charAt(0), "\ufdd0");
      if(cljs.core.truth_(or__3548__auto____3605)) {
        return or__3548__auto____3605
      }else {
        return cljs.core._EQ_.call(null, x.charAt(0), "\ufdd1")
      }
    }())
  }else {
    return and__3546__auto____3604
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____3606 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____3606)) {
    return cljs.core._EQ_.call(null, x.charAt(0), "\ufdd0")
  }else {
    return and__3546__auto____3606
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____3607 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____3607)) {
    return cljs.core._EQ_.call(null, x.charAt(0), "\ufdd1")
  }else {
    return and__3546__auto____3607
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____3608 = cljs.core.number_QMARK_.call(null, n);
  if(cljs.core.truth_(and__3546__auto____3608)) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____3608
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core.truth_(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3609 = coll;
    if(cljs.core.truth_(and__3546__auto____3609)) {
      var and__3546__auto____3610 = cljs.core.associative_QMARK_.call(null, coll);
      if(cljs.core.truth_(and__3546__auto____3610)) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____3610
      }
    }else {
      return and__3546__auto____3609
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___3615 = function(x) {
    return true
  };
  var distinct_QMARK___3616 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3617 = function() {
    var G__3619__delegate = function(x, y, more) {
      if(cljs.core.truth_(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y)))) {
        var s__3611 = cljs.core.set([y, x]);
        var xs__3612 = more;
        while(true) {
          var x__3613 = cljs.core.first.call(null, xs__3612);
          var etc__3614 = cljs.core.next.call(null, xs__3612);
          if(cljs.core.truth_(xs__3612)) {
            if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, s__3611, x__3613))) {
              return false
            }else {
              var G__3620 = cljs.core.conj.call(null, s__3611, x__3613);
              var G__3621 = etc__3614;
              s__3611 = G__3620;
              xs__3612 = G__3621;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__3619 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3619__delegate.call(this, x, y, more)
    };
    G__3619.cljs$lang$maxFixedArity = 2;
    G__3619.cljs$lang$applyTo = function(arglist__3622) {
      var x = cljs.core.first(arglist__3622);
      var y = cljs.core.first(cljs.core.next(arglist__3622));
      var more = cljs.core.rest(cljs.core.next(arglist__3622));
      return G__3619__delegate.call(this, x, y, more)
    };
    return G__3619
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___3615.call(this, x);
      case 2:
        return distinct_QMARK___3616.call(this, x, y);
      default:
        return distinct_QMARK___3617.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3617.cljs$lang$applyTo;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  return goog.array.defaultCompare.call(null, x, y)
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, f, cljs.core.compare))) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__3623 = f.call(null, x, y);
      if(cljs.core.truth_(cljs.core.number_QMARK_.call(null, r__3623))) {
        return r__3623
      }else {
        if(cljs.core.truth_(r__3623)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
cljs.core.sort = function() {
  var sort = null;
  var sort__3625 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__3626 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__3624 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__3624, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__3624)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__3625.call(this, comp);
      case 2:
        return sort__3626.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__3628 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3629 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__3628.call(this, keyfn, comp);
      case 3:
        return sort_by__3629.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return sort_by
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__3631 = function(f, coll) {
    return cljs.core._reduce.call(null, coll, f)
  };
  var reduce__3632 = function(f, val, coll) {
    return cljs.core._reduce.call(null, coll, f, val)
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__3631.call(this, f, val);
      case 3:
        return reduce__3632.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return reduce
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__3638 = function(f, coll) {
    var temp__3695__auto____3634 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____3634)) {
      var s__3635 = temp__3695__auto____3634;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__3635), cljs.core.next.call(null, s__3635))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3639 = function(f, val, coll) {
    var val__3636 = val;
    var coll__3637 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__3637)) {
        var G__3641 = f.call(null, val__3636, cljs.core.first.call(null, coll__3637));
        var G__3642 = cljs.core.next.call(null, coll__3637);
        val__3636 = G__3641;
        coll__3637 = G__3642;
        continue
      }else {
        return val__3636
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__3638.call(this, f, val);
      case 3:
        return seq_reduce__3639.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return seq_reduce
}();
cljs.core.IReduce["_"] = true;
cljs.core._reduce["_"] = function() {
  var G__3643 = null;
  var G__3643__3644 = function(coll, f) {
    return cljs.core.seq_reduce.call(null, f, coll)
  };
  var G__3643__3645 = function(coll, f, start) {
    return cljs.core.seq_reduce.call(null, f, start, coll)
  };
  G__3643 = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3643__3644.call(this, coll, f);
      case 3:
        return G__3643__3645.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3643
}();
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___3647 = function() {
    return 0
  };
  var _PLUS___3648 = function(x) {
    return x
  };
  var _PLUS___3649 = function(x, y) {
    return x + y
  };
  var _PLUS___3650 = function() {
    var G__3652__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__3652 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3652__delegate.call(this, x, y, more)
    };
    G__3652.cljs$lang$maxFixedArity = 2;
    G__3652.cljs$lang$applyTo = function(arglist__3653) {
      var x = cljs.core.first(arglist__3653);
      var y = cljs.core.first(cljs.core.next(arglist__3653));
      var more = cljs.core.rest(cljs.core.next(arglist__3653));
      return G__3652__delegate.call(this, x, y, more)
    };
    return G__3652
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___3647.call(this);
      case 1:
        return _PLUS___3648.call(this, x);
      case 2:
        return _PLUS___3649.call(this, x, y);
      default:
        return _PLUS___3650.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3650.cljs$lang$applyTo;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___3654 = function(x) {
    return-x
  };
  var ___3655 = function(x, y) {
    return x - y
  };
  var ___3656 = function() {
    var G__3658__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__3658 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3658__delegate.call(this, x, y, more)
    };
    G__3658.cljs$lang$maxFixedArity = 2;
    G__3658.cljs$lang$applyTo = function(arglist__3659) {
      var x = cljs.core.first(arglist__3659);
      var y = cljs.core.first(cljs.core.next(arglist__3659));
      var more = cljs.core.rest(cljs.core.next(arglist__3659));
      return G__3658__delegate.call(this, x, y, more)
    };
    return G__3658
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___3654.call(this, x);
      case 2:
        return ___3655.call(this, x, y);
      default:
        return ___3656.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3656.cljs$lang$applyTo;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___3660 = function() {
    return 1
  };
  var _STAR___3661 = function(x) {
    return x
  };
  var _STAR___3662 = function(x, y) {
    return x * y
  };
  var _STAR___3663 = function() {
    var G__3665__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__3665 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3665__delegate.call(this, x, y, more)
    };
    G__3665.cljs$lang$maxFixedArity = 2;
    G__3665.cljs$lang$applyTo = function(arglist__3666) {
      var x = cljs.core.first(arglist__3666);
      var y = cljs.core.first(cljs.core.next(arglist__3666));
      var more = cljs.core.rest(cljs.core.next(arglist__3666));
      return G__3665__delegate.call(this, x, y, more)
    };
    return G__3665
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___3660.call(this);
      case 1:
        return _STAR___3661.call(this, x);
      case 2:
        return _STAR___3662.call(this, x, y);
      default:
        return _STAR___3663.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3663.cljs$lang$applyTo;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___3667 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___3668 = function(x, y) {
    return x / y
  };
  var _SLASH___3669 = function() {
    var G__3671__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__3671 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3671__delegate.call(this, x, y, more)
    };
    G__3671.cljs$lang$maxFixedArity = 2;
    G__3671.cljs$lang$applyTo = function(arglist__3672) {
      var x = cljs.core.first(arglist__3672);
      var y = cljs.core.first(cljs.core.next(arglist__3672));
      var more = cljs.core.rest(cljs.core.next(arglist__3672));
      return G__3671__delegate.call(this, x, y, more)
    };
    return G__3671
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___3667.call(this, x);
      case 2:
        return _SLASH___3668.call(this, x, y);
      default:
        return _SLASH___3669.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3669.cljs$lang$applyTo;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___3673 = function(x) {
    return true
  };
  var _LT___3674 = function(x, y) {
    return x < y
  };
  var _LT___3675 = function() {
    var G__3677__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x < y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3678 = y;
            var G__3679 = cljs.core.first.call(null, more);
            var G__3680 = cljs.core.next.call(null, more);
            x = G__3678;
            y = G__3679;
            more = G__3680;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3677 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3677__delegate.call(this, x, y, more)
    };
    G__3677.cljs$lang$maxFixedArity = 2;
    G__3677.cljs$lang$applyTo = function(arglist__3681) {
      var x = cljs.core.first(arglist__3681);
      var y = cljs.core.first(cljs.core.next(arglist__3681));
      var more = cljs.core.rest(cljs.core.next(arglist__3681));
      return G__3677__delegate.call(this, x, y, more)
    };
    return G__3677
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___3673.call(this, x);
      case 2:
        return _LT___3674.call(this, x, y);
      default:
        return _LT___3675.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3675.cljs$lang$applyTo;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___3682 = function(x) {
    return true
  };
  var _LT__EQ___3683 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3684 = function() {
    var G__3686__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x <= y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3687 = y;
            var G__3688 = cljs.core.first.call(null, more);
            var G__3689 = cljs.core.next.call(null, more);
            x = G__3687;
            y = G__3688;
            more = G__3689;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3686 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3686__delegate.call(this, x, y, more)
    };
    G__3686.cljs$lang$maxFixedArity = 2;
    G__3686.cljs$lang$applyTo = function(arglist__3690) {
      var x = cljs.core.first(arglist__3690);
      var y = cljs.core.first(cljs.core.next(arglist__3690));
      var more = cljs.core.rest(cljs.core.next(arglist__3690));
      return G__3686__delegate.call(this, x, y, more)
    };
    return G__3686
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___3682.call(this, x);
      case 2:
        return _LT__EQ___3683.call(this, x, y);
      default:
        return _LT__EQ___3684.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3684.cljs$lang$applyTo;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___3691 = function(x) {
    return true
  };
  var _GT___3692 = function(x, y) {
    return x > y
  };
  var _GT___3693 = function() {
    var G__3695__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x > y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3696 = y;
            var G__3697 = cljs.core.first.call(null, more);
            var G__3698 = cljs.core.next.call(null, more);
            x = G__3696;
            y = G__3697;
            more = G__3698;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3695 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3695__delegate.call(this, x, y, more)
    };
    G__3695.cljs$lang$maxFixedArity = 2;
    G__3695.cljs$lang$applyTo = function(arglist__3699) {
      var x = cljs.core.first(arglist__3699);
      var y = cljs.core.first(cljs.core.next(arglist__3699));
      var more = cljs.core.rest(cljs.core.next(arglist__3699));
      return G__3695__delegate.call(this, x, y, more)
    };
    return G__3695
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___3691.call(this, x);
      case 2:
        return _GT___3692.call(this, x, y);
      default:
        return _GT___3693.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3693.cljs$lang$applyTo;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___3700 = function(x) {
    return true
  };
  var _GT__EQ___3701 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3702 = function() {
    var G__3704__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x >= y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3705 = y;
            var G__3706 = cljs.core.first.call(null, more);
            var G__3707 = cljs.core.next.call(null, more);
            x = G__3705;
            y = G__3706;
            more = G__3707;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3704 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3704__delegate.call(this, x, y, more)
    };
    G__3704.cljs$lang$maxFixedArity = 2;
    G__3704.cljs$lang$applyTo = function(arglist__3708) {
      var x = cljs.core.first(arglist__3708);
      var y = cljs.core.first(cljs.core.next(arglist__3708));
      var more = cljs.core.rest(cljs.core.next(arglist__3708));
      return G__3704__delegate.call(this, x, y, more)
    };
    return G__3704
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___3700.call(this, x);
      case 2:
        return _GT__EQ___3701.call(this, x, y);
      default:
        return _GT__EQ___3702.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3702.cljs$lang$applyTo;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__3709 = function(x) {
    return x
  };
  var max__3710 = function(x, y) {
    return x > y ? x : y
  };
  var max__3711 = function() {
    var G__3713__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__3713 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3713__delegate.call(this, x, y, more)
    };
    G__3713.cljs$lang$maxFixedArity = 2;
    G__3713.cljs$lang$applyTo = function(arglist__3714) {
      var x = cljs.core.first(arglist__3714);
      var y = cljs.core.first(cljs.core.next(arglist__3714));
      var more = cljs.core.rest(cljs.core.next(arglist__3714));
      return G__3713__delegate.call(this, x, y, more)
    };
    return G__3713
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__3709.call(this, x);
      case 2:
        return max__3710.call(this, x, y);
      default:
        return max__3711.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3711.cljs$lang$applyTo;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__3715 = function(x) {
    return x
  };
  var min__3716 = function(x, y) {
    return x < y ? x : y
  };
  var min__3717 = function() {
    var G__3719__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__3719 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3719__delegate.call(this, x, y, more)
    };
    G__3719.cljs$lang$maxFixedArity = 2;
    G__3719.cljs$lang$applyTo = function(arglist__3720) {
      var x = cljs.core.first(arglist__3720);
      var y = cljs.core.first(cljs.core.next(arglist__3720));
      var more = cljs.core.rest(cljs.core.next(arglist__3720));
      return G__3719__delegate.call(this, x, y, more)
    };
    return G__3719
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__3715.call(this, x);
      case 2:
        return min__3716.call(this, x, y);
      default:
        return min__3717.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3717.cljs$lang$applyTo;
  return min
}();
cljs.core.fix = function fix(q) {
  if(cljs.core.truth_(q >= 0)) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__3721 = n % d;
  return cljs.core.fix.call(null, (n - rem__3721) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__3722 = cljs.core.quot.call(null, n, d);
  return n - d * q__3722
};
cljs.core.rand = function() {
  var rand = null;
  var rand__3723 = function() {
    return Math.random.call(null)
  };
  var rand__3724 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__3723.call(this);
      case 1:
        return rand__3724.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___3726 = function(x) {
    return true
  };
  var _EQ__EQ___3727 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3728 = function() {
    var G__3730__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3731 = y;
            var G__3732 = cljs.core.first.call(null, more);
            var G__3733 = cljs.core.next.call(null, more);
            x = G__3731;
            y = G__3732;
            more = G__3733;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3730 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3730__delegate.call(this, x, y, more)
    };
    G__3730.cljs$lang$maxFixedArity = 2;
    G__3730.cljs$lang$applyTo = function(arglist__3734) {
      var x = cljs.core.first(arglist__3734);
      var y = cljs.core.first(cljs.core.next(arglist__3734));
      var more = cljs.core.rest(cljs.core.next(arglist__3734));
      return G__3730__delegate.call(this, x, y, more)
    };
    return G__3730
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___3726.call(this, x);
      case 2:
        return _EQ__EQ___3727.call(this, x, y);
      default:
        return _EQ__EQ___3728.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3728.cljs$lang$applyTo;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__3735 = n;
  var xs__3736 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3737 = xs__3736;
      if(cljs.core.truth_(and__3546__auto____3737)) {
        return n__3735 > 0
      }else {
        return and__3546__auto____3737
      }
    }())) {
      var G__3738 = n__3735 - 1;
      var G__3739 = cljs.core.next.call(null, xs__3736);
      n__3735 = G__3738;
      xs__3736 = G__3739;
      continue
    }else {
      return xs__3736
    }
    break
  }
};
cljs.core.IIndexed["_"] = true;
cljs.core._nth["_"] = function() {
  var G__3744 = null;
  var G__3744__3745 = function(coll, n) {
    var temp__3695__auto____3740 = cljs.core.nthnext.call(null, coll, n);
    if(cljs.core.truth_(temp__3695__auto____3740)) {
      var xs__3741 = temp__3695__auto____3740;
      return cljs.core.first.call(null, xs__3741)
    }else {
      throw new Error("Index out of bounds");
    }
  };
  var G__3744__3746 = function(coll, n, not_found) {
    var temp__3695__auto____3742 = cljs.core.nthnext.call(null, coll, n);
    if(cljs.core.truth_(temp__3695__auto____3742)) {
      var xs__3743 = temp__3695__auto____3742;
      return cljs.core.first.call(null, xs__3743)
    }else {
      return not_found
    }
  };
  G__3744 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3744__3745.call(this, coll, n);
      case 3:
        return G__3744__3746.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3744
}();
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___3748 = function() {
    return""
  };
  var str_STAR___3749 = function(x) {
    if(cljs.core.truth_(x === null)) {
      return""
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___3750 = function() {
    var G__3752__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__3753 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__3754 = cljs.core.next.call(null, more);
            sb = G__3753;
            more = G__3754;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__3752 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__3752__delegate.call(this, x, ys)
    };
    G__3752.cljs$lang$maxFixedArity = 1;
    G__3752.cljs$lang$applyTo = function(arglist__3755) {
      var x = cljs.core.first(arglist__3755);
      var ys = cljs.core.rest(arglist__3755);
      return G__3752__delegate.call(this, x, ys)
    };
    return G__3752
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___3748.call(this);
      case 1:
        return str_STAR___3749.call(this, x);
      default:
        return str_STAR___3750.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___3750.cljs$lang$applyTo;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__3756 = function() {
    return""
  };
  var str__3757 = function(x) {
    if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, x))) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, x))) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(cljs.core.truth_(x === null)) {
          return""
        }else {
          if(cljs.core.truth_("\ufdd0'else")) {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__3758 = function() {
    var G__3760__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__3761 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__3762 = cljs.core.next.call(null, more);
            sb = G__3761;
            more = G__3762;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__3760 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__3760__delegate.call(this, x, ys)
    };
    G__3760.cljs$lang$maxFixedArity = 1;
    G__3760.cljs$lang$applyTo = function(arglist__3763) {
      var x = cljs.core.first(arglist__3763);
      var ys = cljs.core.rest(arglist__3763);
      return G__3760__delegate.call(this, x, ys)
    };
    return G__3760
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__3756.call(this);
      case 1:
        return str__3757.call(this, x);
      default:
        return str__3758.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__3758.cljs$lang$applyTo;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__3764 = function(s, start) {
    return s.substring(start)
  };
  var subs__3765 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__3764.call(this, s, start);
      case 3:
        return subs__3765.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__3767 = function(name) {
    if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, name))) {
      name
    }else {
      if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, name))) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__3768 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__3767.call(this, ns);
      case 2:
        return symbol__3768.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__3770 = function(name) {
    if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, name))) {
      return name
    }else {
      if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, name))) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__3771 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__3770.call(this, ns);
      case 2:
        return keyword__3771.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.truth_(cljs.core.sequential_QMARK_.call(null, y)) ? function() {
    var xs__3773 = cljs.core.seq.call(null, x);
    var ys__3774 = cljs.core.seq.call(null, y);
    while(true) {
      if(cljs.core.truth_(xs__3773 === null)) {
        return ys__3774 === null
      }else {
        if(cljs.core.truth_(ys__3774 === null)) {
          return false
        }else {
          if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__3773), cljs.core.first.call(null, ys__3774)))) {
            var G__3775 = cljs.core.next.call(null, xs__3773);
            var G__3776 = cljs.core.next.call(null, ys__3774);
            xs__3773 = G__3775;
            ys__3774 = G__3776;
            continue
          }else {
            if(cljs.core.truth_("\ufdd0'else")) {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__3777_SHARP_, p2__3778_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__3777_SHARP_, cljs.core.hash.call(null, p2__3778_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__3779__3780 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__3779__3780)) {
    var G__3782__3784 = cljs.core.first.call(null, G__3779__3780);
    var vec__3783__3785 = G__3782__3784;
    var key_name__3786 = cljs.core.nth.call(null, vec__3783__3785, 0, null);
    var f__3787 = cljs.core.nth.call(null, vec__3783__3785, 1, null);
    var G__3779__3788 = G__3779__3780;
    var G__3782__3789 = G__3782__3784;
    var G__3779__3790 = G__3779__3788;
    while(true) {
      var vec__3791__3792 = G__3782__3789;
      var key_name__3793 = cljs.core.nth.call(null, vec__3791__3792, 0, null);
      var f__3794 = cljs.core.nth.call(null, vec__3791__3792, 1, null);
      var G__3779__3795 = G__3779__3790;
      var str_name__3796 = cljs.core.name.call(null, key_name__3793);
      obj[str_name__3796] = f__3794;
      var temp__3698__auto____3797 = cljs.core.next.call(null, G__3779__3795);
      if(cljs.core.truth_(temp__3698__auto____3797)) {
        var G__3779__3798 = temp__3698__auto____3797;
        var G__3799 = cljs.core.first.call(null, G__3779__3798);
        var G__3800 = G__3779__3798;
        G__3782__3789 = G__3799;
        G__3779__3790 = G__3800;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count
};
cljs.core.List.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3801 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3802 = this;
  return new cljs.core.List(this__3802.meta, o, coll, this__3802.count + 1)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3803 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__3804 = this;
  return this__3804.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__3805 = this;
  return this__3805.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__3806 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3807 = this;
  return this__3807.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3808 = this;
  return this__3808.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3809 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3810 = this;
  return new cljs.core.List(meta, this__3810.first, this__3810.rest, this__3810.count)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3811 = this;
  return this__3811.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3812 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta
};
cljs.core.EmptyList.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3813 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3814 = this;
  return new cljs.core.List(this__3814.meta, o, null, 1)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3815 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__3816 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__3817 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__3818 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3819 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3820 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3821 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3822 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3823 = this;
  return this__3823.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3824 = this;
  return coll
};
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__3825) {
    var items = cljs.core.seq(arglist__3825);
    return list__delegate.call(this, items)
  };
  return list
}();
cljs.core.Cons = function(meta, first, rest) {
  this.meta = meta;
  this.first = first;
  this.rest = rest
};
cljs.core.Cons.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3826 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3827 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3828 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3829 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__3829.meta)
};
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3830 = this;
  return new cljs.core.Cons(null, o, coll)
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3831 = this;
  return this__3831.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3832 = this;
  if(cljs.core.truth_(this__3832.rest === null)) {
    return cljs.core.List.EMPTY
  }else {
    return this__3832.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3833 = this;
  return this__3833.meta
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3834 = this;
  return new cljs.core.Cons(meta, this__3834.first, this__3834.rest)
};
cljs.core.Cons;
cljs.core.cons = function cons(x, seq) {
  return new cljs.core.Cons(null, x, seq)
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__3835 = null;
  var G__3835__3836 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__3835__3837 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__3835 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3835__3836.call(this, string, f);
      case 3:
        return G__3835__3837.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3835
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__3839 = null;
  var G__3839__3840 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__3839__3841 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__3839 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3839__3840.call(this, string, k);
      case 3:
        return G__3839__3841.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3839
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__3843 = null;
  var G__3843__3844 = function(string, n) {
    if(cljs.core.truth_(n < cljs.core._count.call(null, string))) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__3843__3845 = function(string, n, not_found) {
    if(cljs.core.truth_(n < cljs.core._count.call(null, string))) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__3843 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3843__3844.call(this, string, n);
      case 3:
        return G__3843__3845.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3843
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__3853 = null;
  var G__3853__3854 = function(tsym3847, coll) {
    var tsym3847__3849 = this;
    var this$__3850 = tsym3847__3849;
    return cljs.core.get.call(null, coll, this$__3850.toString())
  };
  var G__3853__3855 = function(tsym3848, coll, not_found) {
    var tsym3848__3851 = this;
    var this$__3852 = tsym3848__3851;
    return cljs.core.get.call(null, coll, this$__3852.toString(), not_found)
  };
  G__3853 = function(tsym3848, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3853__3854.call(this, tsym3848, coll);
      case 3:
        return G__3853__3855.call(this, tsym3848, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3853
}();
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.truth_(cljs.core.count.call(null, args) < 2)) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__3857 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__3857
  }else {
    lazy_seq.x = x__3857.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x) {
  this.meta = meta;
  this.realized = realized;
  this.x = x
};
cljs.core.LazySeq.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3858 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3859 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3860 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3861 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__3861.meta)
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3862 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3863 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3864 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3865 = this;
  return this__3865.meta
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3866 = this;
  return new cljs.core.LazySeq(meta, this__3866.realized, this__3866.x)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__3867 = [];
  var s__3868 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__3868))) {
      ary__3867.push(cljs.core.first.call(null, s__3868));
      var G__3869 = cljs.core.next.call(null, s__3868);
      s__3868 = G__3869;
      continue
    }else {
      return ary__3867
    }
    break
  }
};
cljs.core.bounded_count = function bounded_count(s, n) {
  var s__3870 = s;
  var i__3871 = n;
  var sum__3872 = 0;
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3873 = i__3871 > 0;
      if(cljs.core.truth_(and__3546__auto____3873)) {
        return cljs.core.seq.call(null, s__3870)
      }else {
        return and__3546__auto____3873
      }
    }())) {
      var G__3874 = cljs.core.next.call(null, s__3870);
      var G__3875 = i__3871 - 1;
      var G__3876 = sum__3872 + 1;
      s__3870 = G__3874;
      i__3871 = G__3875;
      sum__3872 = G__3876;
      continue
    }else {
      return sum__3872
    }
    break
  }
};
cljs.core.spread = function spread(arglist) {
  if(cljs.core.truth_(arglist === null)) {
    return null
  }else {
    if(cljs.core.truth_(cljs.core.next.call(null, arglist) === null)) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__3880 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__3881 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__3882 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__3877 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__3877)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__3877), concat.call(null, cljs.core.rest.call(null, s__3877), y))
      }else {
        return y
      }
    })
  };
  var concat__3883 = function() {
    var G__3885__delegate = function(x, y, zs) {
      var cat__3879 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__3878 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__3878)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__3878), cat.call(null, cljs.core.rest.call(null, xys__3878), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__3879.call(null, concat.call(null, x, y), zs)
    };
    var G__3885 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3885__delegate.call(this, x, y, zs)
    };
    G__3885.cljs$lang$maxFixedArity = 2;
    G__3885.cljs$lang$applyTo = function(arglist__3886) {
      var x = cljs.core.first(arglist__3886);
      var y = cljs.core.first(cljs.core.next(arglist__3886));
      var zs = cljs.core.rest(cljs.core.next(arglist__3886));
      return G__3885__delegate.call(this, x, y, zs)
    };
    return G__3885
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__3880.call(this);
      case 1:
        return concat__3881.call(this, x);
      case 2:
        return concat__3882.call(this, x, y);
      default:
        return concat__3883.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3883.cljs$lang$applyTo;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___3887 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___3888 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3889 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___3890 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___3891 = function() {
    var G__3893__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__3893 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__3893__delegate.call(this, a, b, c, d, more)
    };
    G__3893.cljs$lang$maxFixedArity = 4;
    G__3893.cljs$lang$applyTo = function(arglist__3894) {
      var a = cljs.core.first(arglist__3894);
      var b = cljs.core.first(cljs.core.next(arglist__3894));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3894)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3894))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3894))));
      return G__3893__delegate.call(this, a, b, c, d, more)
    };
    return G__3893
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___3887.call(this, a);
      case 2:
        return list_STAR___3888.call(this, a, b);
      case 3:
        return list_STAR___3889.call(this, a, b, c);
      case 4:
        return list_STAR___3890.call(this, a, b, c, d);
      default:
        return list_STAR___3891.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___3891.cljs$lang$applyTo;
  return list_STAR_
}();
cljs.core.apply = function() {
  var apply = null;
  var apply__3904 = function(f, args) {
    var fixed_arity__3895 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, args, fixed_arity__3895 + 1) <= fixed_arity__3895)) {
        return f.apply(f, cljs.core.to_array.call(null, args))
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3905 = function(f, x, args) {
    var arglist__3896 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__3897 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3896, fixed_arity__3897) <= fixed_arity__3897)) {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3896))
      }else {
        return f.cljs$lang$applyTo(arglist__3896)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__3896))
    }
  };
  var apply__3906 = function(f, x, y, args) {
    var arglist__3898 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__3899 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3898, fixed_arity__3899) <= fixed_arity__3899)) {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3898))
      }else {
        return f.cljs$lang$applyTo(arglist__3898)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__3898))
    }
  };
  var apply__3907 = function(f, x, y, z, args) {
    var arglist__3900 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__3901 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3900, fixed_arity__3901) <= fixed_arity__3901)) {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3900))
      }else {
        return f.cljs$lang$applyTo(arglist__3900)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__3900))
    }
  };
  var apply__3908 = function() {
    var G__3910__delegate = function(f, a, b, c, d, args) {
      var arglist__3902 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__3903 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3902, fixed_arity__3903) <= fixed_arity__3903)) {
          return f.apply(f, cljs.core.to_array.call(null, arglist__3902))
        }else {
          return f.cljs$lang$applyTo(arglist__3902)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3902))
      }
    };
    var G__3910 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__3910__delegate.call(this, f, a, b, c, d, args)
    };
    G__3910.cljs$lang$maxFixedArity = 5;
    G__3910.cljs$lang$applyTo = function(arglist__3911) {
      var f = cljs.core.first(arglist__3911);
      var a = cljs.core.first(cljs.core.next(arglist__3911));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3911)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3911))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3911)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3911)))));
      return G__3910__delegate.call(this, f, a, b, c, d, args)
    };
    return G__3910
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__3904.call(this, f, a);
      case 3:
        return apply__3905.call(this, f, a, b);
      case 4:
        return apply__3906.call(this, f, a, b, c);
      case 5:
        return apply__3907.call(this, f, a, b, c, d);
      default:
        return apply__3908.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__3908.cljs$lang$applyTo;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__3912) {
    var obj = cljs.core.first(arglist__3912);
    var f = cljs.core.first(cljs.core.next(arglist__3912));
    var args = cljs.core.rest(cljs.core.next(arglist__3912));
    return vary_meta__delegate.call(this, obj, f, args)
  };
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___3913 = function(x) {
    return false
  };
  var not_EQ___3914 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3915 = function() {
    var G__3917__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__3917 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3917__delegate.call(this, x, y, more)
    };
    G__3917.cljs$lang$maxFixedArity = 2;
    G__3917.cljs$lang$applyTo = function(arglist__3918) {
      var x = cljs.core.first(arglist__3918);
      var y = cljs.core.first(cljs.core.next(arglist__3918));
      var more = cljs.core.rest(cljs.core.next(arglist__3918));
      return G__3917__delegate.call(this, x, y, more)
    };
    return G__3917
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___3913.call(this, x);
      case 2:
        return not_EQ___3914.call(this, x, y);
      default:
        return not_EQ___3915.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3915.cljs$lang$applyTo;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll) === null)) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__3919 = pred;
        var G__3920 = cljs.core.next.call(null, coll);
        pred = G__3919;
        coll = G__3920;
        continue
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____3921 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____3921)) {
        return or__3548__auto____3921
      }else {
        var G__3922 = pred;
        var G__3923 = cljs.core.next.call(null, coll);
        pred = G__3922;
        coll = G__3923;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.truth_(cljs.core.integer_QMARK_.call(null, n))) {
    return(n & 1) === 0
  }else {
    throw new Error(cljs.core.str.call(null, "Argument must be an integer: ", n));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__3924 = null;
    var G__3924__3925 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__3924__3926 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__3924__3927 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__3924__3928 = function() {
      var G__3930__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__3930 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__3930__delegate.call(this, x, y, zs)
      };
      G__3930.cljs$lang$maxFixedArity = 2;
      G__3930.cljs$lang$applyTo = function(arglist__3931) {
        var x = cljs.core.first(arglist__3931);
        var y = cljs.core.first(cljs.core.next(arglist__3931));
        var zs = cljs.core.rest(cljs.core.next(arglist__3931));
        return G__3930__delegate.call(this, x, y, zs)
      };
      return G__3930
    }();
    G__3924 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__3924__3925.call(this);
        case 1:
          return G__3924__3926.call(this, x);
        case 2:
          return G__3924__3927.call(this, x, y);
        default:
          return G__3924__3928.apply(this, arguments)
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__3924.cljs$lang$maxFixedArity = 2;
    G__3924.cljs$lang$applyTo = G__3924__3928.cljs$lang$applyTo;
    return G__3924
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__3932__delegate = function(args) {
      return x
    };
    var G__3932 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__3932__delegate.call(this, args)
    };
    G__3932.cljs$lang$maxFixedArity = 0;
    G__3932.cljs$lang$applyTo = function(arglist__3933) {
      var args = cljs.core.seq(arglist__3933);
      return G__3932__delegate.call(this, args)
    };
    return G__3932
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__3937 = function() {
    return cljs.core.identity
  };
  var comp__3938 = function(f) {
    return f
  };
  var comp__3939 = function(f, g) {
    return function() {
      var G__3943 = null;
      var G__3943__3944 = function() {
        return f.call(null, g.call(null))
      };
      var G__3943__3945 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__3943__3946 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__3943__3947 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__3943__3948 = function() {
        var G__3950__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__3950 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3950__delegate.call(this, x, y, z, args)
        };
        G__3950.cljs$lang$maxFixedArity = 3;
        G__3950.cljs$lang$applyTo = function(arglist__3951) {
          var x = cljs.core.first(arglist__3951);
          var y = cljs.core.first(cljs.core.next(arglist__3951));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3951)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3951)));
          return G__3950__delegate.call(this, x, y, z, args)
        };
        return G__3950
      }();
      G__3943 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__3943__3944.call(this);
          case 1:
            return G__3943__3945.call(this, x);
          case 2:
            return G__3943__3946.call(this, x, y);
          case 3:
            return G__3943__3947.call(this, x, y, z);
          default:
            return G__3943__3948.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3943.cljs$lang$maxFixedArity = 3;
      G__3943.cljs$lang$applyTo = G__3943__3948.cljs$lang$applyTo;
      return G__3943
    }()
  };
  var comp__3940 = function(f, g, h) {
    return function() {
      var G__3952 = null;
      var G__3952__3953 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__3952__3954 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__3952__3955 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__3952__3956 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__3952__3957 = function() {
        var G__3959__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__3959 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3959__delegate.call(this, x, y, z, args)
        };
        G__3959.cljs$lang$maxFixedArity = 3;
        G__3959.cljs$lang$applyTo = function(arglist__3960) {
          var x = cljs.core.first(arglist__3960);
          var y = cljs.core.first(cljs.core.next(arglist__3960));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3960)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3960)));
          return G__3959__delegate.call(this, x, y, z, args)
        };
        return G__3959
      }();
      G__3952 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__3952__3953.call(this);
          case 1:
            return G__3952__3954.call(this, x);
          case 2:
            return G__3952__3955.call(this, x, y);
          case 3:
            return G__3952__3956.call(this, x, y, z);
          default:
            return G__3952__3957.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3952.cljs$lang$maxFixedArity = 3;
      G__3952.cljs$lang$applyTo = G__3952__3957.cljs$lang$applyTo;
      return G__3952
    }()
  };
  var comp__3941 = function() {
    var G__3961__delegate = function(f1, f2, f3, fs) {
      var fs__3934 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__3962__delegate = function(args) {
          var ret__3935 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__3934), args);
          var fs__3936 = cljs.core.next.call(null, fs__3934);
          while(true) {
            if(cljs.core.truth_(fs__3936)) {
              var G__3963 = cljs.core.first.call(null, fs__3936).call(null, ret__3935);
              var G__3964 = cljs.core.next.call(null, fs__3936);
              ret__3935 = G__3963;
              fs__3936 = G__3964;
              continue
            }else {
              return ret__3935
            }
            break
          }
        };
        var G__3962 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__3962__delegate.call(this, args)
        };
        G__3962.cljs$lang$maxFixedArity = 0;
        G__3962.cljs$lang$applyTo = function(arglist__3965) {
          var args = cljs.core.seq(arglist__3965);
          return G__3962__delegate.call(this, args)
        };
        return G__3962
      }()
    };
    var G__3961 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__3961__delegate.call(this, f1, f2, f3, fs)
    };
    G__3961.cljs$lang$maxFixedArity = 3;
    G__3961.cljs$lang$applyTo = function(arglist__3966) {
      var f1 = cljs.core.first(arglist__3966);
      var f2 = cljs.core.first(cljs.core.next(arglist__3966));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3966)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3966)));
      return G__3961__delegate.call(this, f1, f2, f3, fs)
    };
    return G__3961
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__3937.call(this);
      case 1:
        return comp__3938.call(this, f1);
      case 2:
        return comp__3939.call(this, f1, f2);
      case 3:
        return comp__3940.call(this, f1, f2, f3);
      default:
        return comp__3941.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__3941.cljs$lang$applyTo;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__3967 = function(f, arg1) {
    return function() {
      var G__3972__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__3972 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__3972__delegate.call(this, args)
      };
      G__3972.cljs$lang$maxFixedArity = 0;
      G__3972.cljs$lang$applyTo = function(arglist__3973) {
        var args = cljs.core.seq(arglist__3973);
        return G__3972__delegate.call(this, args)
      };
      return G__3972
    }()
  };
  var partial__3968 = function(f, arg1, arg2) {
    return function() {
      var G__3974__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__3974 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__3974__delegate.call(this, args)
      };
      G__3974.cljs$lang$maxFixedArity = 0;
      G__3974.cljs$lang$applyTo = function(arglist__3975) {
        var args = cljs.core.seq(arglist__3975);
        return G__3974__delegate.call(this, args)
      };
      return G__3974
    }()
  };
  var partial__3969 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__3976__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__3976 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__3976__delegate.call(this, args)
      };
      G__3976.cljs$lang$maxFixedArity = 0;
      G__3976.cljs$lang$applyTo = function(arglist__3977) {
        var args = cljs.core.seq(arglist__3977);
        return G__3976__delegate.call(this, args)
      };
      return G__3976
    }()
  };
  var partial__3970 = function() {
    var G__3978__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__3979__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__3979 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__3979__delegate.call(this, args)
        };
        G__3979.cljs$lang$maxFixedArity = 0;
        G__3979.cljs$lang$applyTo = function(arglist__3980) {
          var args = cljs.core.seq(arglist__3980);
          return G__3979__delegate.call(this, args)
        };
        return G__3979
      }()
    };
    var G__3978 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__3978__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__3978.cljs$lang$maxFixedArity = 4;
    G__3978.cljs$lang$applyTo = function(arglist__3981) {
      var f = cljs.core.first(arglist__3981);
      var arg1 = cljs.core.first(cljs.core.next(arglist__3981));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3981)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3981))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3981))));
      return G__3978__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    return G__3978
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__3967.call(this, f, arg1);
      case 3:
        return partial__3968.call(this, f, arg1, arg2);
      case 4:
        return partial__3969.call(this, f, arg1, arg2, arg3);
      default:
        return partial__3970.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__3970.cljs$lang$applyTo;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__3982 = function(f, x) {
    return function() {
      var G__3986 = null;
      var G__3986__3987 = function(a) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a)
      };
      var G__3986__3988 = function(a, b) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, b)
      };
      var G__3986__3989 = function(a, b, c) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, b, c)
      };
      var G__3986__3990 = function() {
        var G__3992__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, cljs.core.truth_(a === null) ? x : a, b, c, ds)
        };
        var G__3992 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3992__delegate.call(this, a, b, c, ds)
        };
        G__3992.cljs$lang$maxFixedArity = 3;
        G__3992.cljs$lang$applyTo = function(arglist__3993) {
          var a = cljs.core.first(arglist__3993);
          var b = cljs.core.first(cljs.core.next(arglist__3993));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3993)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3993)));
          return G__3992__delegate.call(this, a, b, c, ds)
        };
        return G__3992
      }();
      G__3986 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__3986__3987.call(this, a);
          case 2:
            return G__3986__3988.call(this, a, b);
          case 3:
            return G__3986__3989.call(this, a, b, c);
          default:
            return G__3986__3990.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3986.cljs$lang$maxFixedArity = 3;
      G__3986.cljs$lang$applyTo = G__3986__3990.cljs$lang$applyTo;
      return G__3986
    }()
  };
  var fnil__3983 = function(f, x, y) {
    return function() {
      var G__3994 = null;
      var G__3994__3995 = function(a, b) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b)
      };
      var G__3994__3996 = function(a, b, c) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, c)
      };
      var G__3994__3997 = function() {
        var G__3999__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, c, ds)
        };
        var G__3999 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3999__delegate.call(this, a, b, c, ds)
        };
        G__3999.cljs$lang$maxFixedArity = 3;
        G__3999.cljs$lang$applyTo = function(arglist__4000) {
          var a = cljs.core.first(arglist__4000);
          var b = cljs.core.first(cljs.core.next(arglist__4000));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4000)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4000)));
          return G__3999__delegate.call(this, a, b, c, ds)
        };
        return G__3999
      }();
      G__3994 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__3994__3995.call(this, a, b);
          case 3:
            return G__3994__3996.call(this, a, b, c);
          default:
            return G__3994__3997.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3994.cljs$lang$maxFixedArity = 3;
      G__3994.cljs$lang$applyTo = G__3994__3997.cljs$lang$applyTo;
      return G__3994
    }()
  };
  var fnil__3984 = function(f, x, y, z) {
    return function() {
      var G__4001 = null;
      var G__4001__4002 = function(a, b) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b)
      };
      var G__4001__4003 = function(a, b, c) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, cljs.core.truth_(c === null) ? z : c)
      };
      var G__4001__4004 = function() {
        var G__4006__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, cljs.core.truth_(c === null) ? z : c, ds)
        };
        var G__4006 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4006__delegate.call(this, a, b, c, ds)
        };
        G__4006.cljs$lang$maxFixedArity = 3;
        G__4006.cljs$lang$applyTo = function(arglist__4007) {
          var a = cljs.core.first(arglist__4007);
          var b = cljs.core.first(cljs.core.next(arglist__4007));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4007)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4007)));
          return G__4006__delegate.call(this, a, b, c, ds)
        };
        return G__4006
      }();
      G__4001 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__4001__4002.call(this, a, b);
          case 3:
            return G__4001__4003.call(this, a, b, c);
          default:
            return G__4001__4004.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4001.cljs$lang$maxFixedArity = 3;
      G__4001.cljs$lang$applyTo = G__4001__4004.cljs$lang$applyTo;
      return G__4001
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__3982.call(this, f, x);
      case 3:
        return fnil__3983.call(this, f, x, y);
      case 4:
        return fnil__3984.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__4010 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4008 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4008)) {
        var s__4009 = temp__3698__auto____4008;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__4009)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__4009)))
      }else {
        return null
      }
    })
  };
  return mapi__4010.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4011 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4011)) {
      var s__4012 = temp__3698__auto____4011;
      var x__4013 = f.call(null, cljs.core.first.call(null, s__4012));
      if(cljs.core.truth_(x__4013 === null)) {
        return keep.call(null, f, cljs.core.rest.call(null, s__4012))
      }else {
        return cljs.core.cons.call(null, x__4013, keep.call(null, f, cljs.core.rest.call(null, s__4012)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__4023 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4020 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4020)) {
        var s__4021 = temp__3698__auto____4020;
        var x__4022 = f.call(null, idx, cljs.core.first.call(null, s__4021));
        if(cljs.core.truth_(x__4022 === null)) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__4021))
        }else {
          return cljs.core.cons.call(null, x__4022, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__4021)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__4023.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__4068 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__4073 = function() {
        return true
      };
      var ep1__4074 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__4075 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4030 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4030)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____4030
          }
        }())
      };
      var ep1__4076 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4031 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4031)) {
            var and__3546__auto____4032 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____4032)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____4032
            }
          }else {
            return and__3546__auto____4031
          }
        }())
      };
      var ep1__4077 = function() {
        var G__4079__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____4033 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____4033)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____4033
            }
          }())
        };
        var G__4079 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4079__delegate.call(this, x, y, z, args)
        };
        G__4079.cljs$lang$maxFixedArity = 3;
        G__4079.cljs$lang$applyTo = function(arglist__4080) {
          var x = cljs.core.first(arglist__4080);
          var y = cljs.core.first(cljs.core.next(arglist__4080));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4080)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4080)));
          return G__4079__delegate.call(this, x, y, z, args)
        };
        return G__4079
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__4073.call(this);
          case 1:
            return ep1__4074.call(this, x);
          case 2:
            return ep1__4075.call(this, x, y);
          case 3:
            return ep1__4076.call(this, x, y, z);
          default:
            return ep1__4077.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4077.cljs$lang$applyTo;
      return ep1
    }()
  };
  var every_pred__4069 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__4081 = function() {
        return true
      };
      var ep2__4082 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4034 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4034)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____4034
          }
        }())
      };
      var ep2__4083 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4035 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4035)) {
            var and__3546__auto____4036 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____4036)) {
              var and__3546__auto____4037 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____4037)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____4037
              }
            }else {
              return and__3546__auto____4036
            }
          }else {
            return and__3546__auto____4035
          }
        }())
      };
      var ep2__4084 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4038 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4038)) {
            var and__3546__auto____4039 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____4039)) {
              var and__3546__auto____4040 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____4040)) {
                var and__3546__auto____4041 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____4041)) {
                  var and__3546__auto____4042 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____4042)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____4042
                  }
                }else {
                  return and__3546__auto____4041
                }
              }else {
                return and__3546__auto____4040
              }
            }else {
              return and__3546__auto____4039
            }
          }else {
            return and__3546__auto____4038
          }
        }())
      };
      var ep2__4085 = function() {
        var G__4087__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____4043 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____4043)) {
              return cljs.core.every_QMARK_.call(null, function(p1__4014_SHARP_) {
                var and__3546__auto____4044 = p1.call(null, p1__4014_SHARP_);
                if(cljs.core.truth_(and__3546__auto____4044)) {
                  return p2.call(null, p1__4014_SHARP_)
                }else {
                  return and__3546__auto____4044
                }
              }, args)
            }else {
              return and__3546__auto____4043
            }
          }())
        };
        var G__4087 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4087__delegate.call(this, x, y, z, args)
        };
        G__4087.cljs$lang$maxFixedArity = 3;
        G__4087.cljs$lang$applyTo = function(arglist__4088) {
          var x = cljs.core.first(arglist__4088);
          var y = cljs.core.first(cljs.core.next(arglist__4088));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4088)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4088)));
          return G__4087__delegate.call(this, x, y, z, args)
        };
        return G__4087
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__4081.call(this);
          case 1:
            return ep2__4082.call(this, x);
          case 2:
            return ep2__4083.call(this, x, y);
          case 3:
            return ep2__4084.call(this, x, y, z);
          default:
            return ep2__4085.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4085.cljs$lang$applyTo;
      return ep2
    }()
  };
  var every_pred__4070 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__4089 = function() {
        return true
      };
      var ep3__4090 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4045 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4045)) {
            var and__3546__auto____4046 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4046)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____4046
            }
          }else {
            return and__3546__auto____4045
          }
        }())
      };
      var ep3__4091 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4047 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4047)) {
            var and__3546__auto____4048 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4048)) {
              var and__3546__auto____4049 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____4049)) {
                var and__3546__auto____4050 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____4050)) {
                  var and__3546__auto____4051 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____4051)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____4051
                  }
                }else {
                  return and__3546__auto____4050
                }
              }else {
                return and__3546__auto____4049
              }
            }else {
              return and__3546__auto____4048
            }
          }else {
            return and__3546__auto____4047
          }
        }())
      };
      var ep3__4092 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4052 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4052)) {
            var and__3546__auto____4053 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4053)) {
              var and__3546__auto____4054 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____4054)) {
                var and__3546__auto____4055 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____4055)) {
                  var and__3546__auto____4056 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____4056)) {
                    var and__3546__auto____4057 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____4057)) {
                      var and__3546__auto____4058 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____4058)) {
                        var and__3546__auto____4059 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____4059)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____4059
                        }
                      }else {
                        return and__3546__auto____4058
                      }
                    }else {
                      return and__3546__auto____4057
                    }
                  }else {
                    return and__3546__auto____4056
                  }
                }else {
                  return and__3546__auto____4055
                }
              }else {
                return and__3546__auto____4054
              }
            }else {
              return and__3546__auto____4053
            }
          }else {
            return and__3546__auto____4052
          }
        }())
      };
      var ep3__4093 = function() {
        var G__4095__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____4060 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____4060)) {
              return cljs.core.every_QMARK_.call(null, function(p1__4015_SHARP_) {
                var and__3546__auto____4061 = p1.call(null, p1__4015_SHARP_);
                if(cljs.core.truth_(and__3546__auto____4061)) {
                  var and__3546__auto____4062 = p2.call(null, p1__4015_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____4062)) {
                    return p3.call(null, p1__4015_SHARP_)
                  }else {
                    return and__3546__auto____4062
                  }
                }else {
                  return and__3546__auto____4061
                }
              }, args)
            }else {
              return and__3546__auto____4060
            }
          }())
        };
        var G__4095 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4095__delegate.call(this, x, y, z, args)
        };
        G__4095.cljs$lang$maxFixedArity = 3;
        G__4095.cljs$lang$applyTo = function(arglist__4096) {
          var x = cljs.core.first(arglist__4096);
          var y = cljs.core.first(cljs.core.next(arglist__4096));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4096)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4096)));
          return G__4095__delegate.call(this, x, y, z, args)
        };
        return G__4095
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__4089.call(this);
          case 1:
            return ep3__4090.call(this, x);
          case 2:
            return ep3__4091.call(this, x, y);
          case 3:
            return ep3__4092.call(this, x, y, z);
          default:
            return ep3__4093.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4093.cljs$lang$applyTo;
      return ep3
    }()
  };
  var every_pred__4071 = function() {
    var G__4097__delegate = function(p1, p2, p3, ps) {
      var ps__4063 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__4098 = function() {
          return true
        };
        var epn__4099 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__4016_SHARP_) {
            return p1__4016_SHARP_.call(null, x)
          }, ps__4063)
        };
        var epn__4100 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__4017_SHARP_) {
            var and__3546__auto____4064 = p1__4017_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4064)) {
              return p1__4017_SHARP_.call(null, y)
            }else {
              return and__3546__auto____4064
            }
          }, ps__4063)
        };
        var epn__4101 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__4018_SHARP_) {
            var and__3546__auto____4065 = p1__4018_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4065)) {
              var and__3546__auto____4066 = p1__4018_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____4066)) {
                return p1__4018_SHARP_.call(null, z)
              }else {
                return and__3546__auto____4066
              }
            }else {
              return and__3546__auto____4065
            }
          }, ps__4063)
        };
        var epn__4102 = function() {
          var G__4104__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____4067 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____4067)) {
                return cljs.core.every_QMARK_.call(null, function(p1__4019_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__4019_SHARP_, args)
                }, ps__4063)
              }else {
                return and__3546__auto____4067
              }
            }())
          };
          var G__4104 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__4104__delegate.call(this, x, y, z, args)
          };
          G__4104.cljs$lang$maxFixedArity = 3;
          G__4104.cljs$lang$applyTo = function(arglist__4105) {
            var x = cljs.core.first(arglist__4105);
            var y = cljs.core.first(cljs.core.next(arglist__4105));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4105)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4105)));
            return G__4104__delegate.call(this, x, y, z, args)
          };
          return G__4104
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__4098.call(this);
            case 1:
              return epn__4099.call(this, x);
            case 2:
              return epn__4100.call(this, x, y);
            case 3:
              return epn__4101.call(this, x, y, z);
            default:
              return epn__4102.apply(this, arguments)
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4102.cljs$lang$applyTo;
        return epn
      }()
    };
    var G__4097 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4097__delegate.call(this, p1, p2, p3, ps)
    };
    G__4097.cljs$lang$maxFixedArity = 3;
    G__4097.cljs$lang$applyTo = function(arglist__4106) {
      var p1 = cljs.core.first(arglist__4106);
      var p2 = cljs.core.first(cljs.core.next(arglist__4106));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4106)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4106)));
      return G__4097__delegate.call(this, p1, p2, p3, ps)
    };
    return G__4097
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__4068.call(this, p1);
      case 2:
        return every_pred__4069.call(this, p1, p2);
      case 3:
        return every_pred__4070.call(this, p1, p2, p3);
      default:
        return every_pred__4071.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4071.cljs$lang$applyTo;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__4146 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__4151 = function() {
        return null
      };
      var sp1__4152 = function(x) {
        return p.call(null, x)
      };
      var sp1__4153 = function(x, y) {
        var or__3548__auto____4108 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4108)) {
          return or__3548__auto____4108
        }else {
          return p.call(null, y)
        }
      };
      var sp1__4154 = function(x, y, z) {
        var or__3548__auto____4109 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4109)) {
          return or__3548__auto____4109
        }else {
          var or__3548__auto____4110 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____4110)) {
            return or__3548__auto____4110
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4155 = function() {
        var G__4157__delegate = function(x, y, z, args) {
          var or__3548__auto____4111 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____4111)) {
            return or__3548__auto____4111
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__4157 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4157__delegate.call(this, x, y, z, args)
        };
        G__4157.cljs$lang$maxFixedArity = 3;
        G__4157.cljs$lang$applyTo = function(arglist__4158) {
          var x = cljs.core.first(arglist__4158);
          var y = cljs.core.first(cljs.core.next(arglist__4158));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4158)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4158)));
          return G__4157__delegate.call(this, x, y, z, args)
        };
        return G__4157
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__4151.call(this);
          case 1:
            return sp1__4152.call(this, x);
          case 2:
            return sp1__4153.call(this, x, y);
          case 3:
            return sp1__4154.call(this, x, y, z);
          default:
            return sp1__4155.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4155.cljs$lang$applyTo;
      return sp1
    }()
  };
  var some_fn__4147 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__4159 = function() {
        return null
      };
      var sp2__4160 = function(x) {
        var or__3548__auto____4112 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4112)) {
          return or__3548__auto____4112
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__4161 = function(x, y) {
        var or__3548__auto____4113 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4113)) {
          return or__3548__auto____4113
        }else {
          var or__3548__auto____4114 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____4114)) {
            return or__3548__auto____4114
          }else {
            var or__3548__auto____4115 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4115)) {
              return or__3548__auto____4115
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__4162 = function(x, y, z) {
        var or__3548__auto____4116 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4116)) {
          return or__3548__auto____4116
        }else {
          var or__3548__auto____4117 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____4117)) {
            return or__3548__auto____4117
          }else {
            var or__3548__auto____4118 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____4118)) {
              return or__3548__auto____4118
            }else {
              var or__3548__auto____4119 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____4119)) {
                return or__3548__auto____4119
              }else {
                var or__3548__auto____4120 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____4120)) {
                  return or__3548__auto____4120
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4163 = function() {
        var G__4165__delegate = function(x, y, z, args) {
          var or__3548__auto____4121 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____4121)) {
            return or__3548__auto____4121
          }else {
            return cljs.core.some.call(null, function(p1__4024_SHARP_) {
              var or__3548__auto____4122 = p1.call(null, p1__4024_SHARP_);
              if(cljs.core.truth_(or__3548__auto____4122)) {
                return or__3548__auto____4122
              }else {
                return p2.call(null, p1__4024_SHARP_)
              }
            }, args)
          }
        };
        var G__4165 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4165__delegate.call(this, x, y, z, args)
        };
        G__4165.cljs$lang$maxFixedArity = 3;
        G__4165.cljs$lang$applyTo = function(arglist__4166) {
          var x = cljs.core.first(arglist__4166);
          var y = cljs.core.first(cljs.core.next(arglist__4166));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4166)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4166)));
          return G__4165__delegate.call(this, x, y, z, args)
        };
        return G__4165
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__4159.call(this);
          case 1:
            return sp2__4160.call(this, x);
          case 2:
            return sp2__4161.call(this, x, y);
          case 3:
            return sp2__4162.call(this, x, y, z);
          default:
            return sp2__4163.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4163.cljs$lang$applyTo;
      return sp2
    }()
  };
  var some_fn__4148 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__4167 = function() {
        return null
      };
      var sp3__4168 = function(x) {
        var or__3548__auto____4123 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4123)) {
          return or__3548__auto____4123
        }else {
          var or__3548__auto____4124 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____4124)) {
            return or__3548__auto____4124
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__4169 = function(x, y) {
        var or__3548__auto____4125 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4125)) {
          return or__3548__auto____4125
        }else {
          var or__3548__auto____4126 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____4126)) {
            return or__3548__auto____4126
          }else {
            var or__3548__auto____4127 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4127)) {
              return or__3548__auto____4127
            }else {
              var or__3548__auto____4128 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____4128)) {
                return or__3548__auto____4128
              }else {
                var or__3548__auto____4129 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____4129)) {
                  return or__3548__auto____4129
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__4170 = function(x, y, z) {
        var or__3548__auto____4130 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4130)) {
          return or__3548__auto____4130
        }else {
          var or__3548__auto____4131 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____4131)) {
            return or__3548__auto____4131
          }else {
            var or__3548__auto____4132 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4132)) {
              return or__3548__auto____4132
            }else {
              var or__3548__auto____4133 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____4133)) {
                return or__3548__auto____4133
              }else {
                var or__3548__auto____4134 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____4134)) {
                  return or__3548__auto____4134
                }else {
                  var or__3548__auto____4135 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____4135)) {
                    return or__3548__auto____4135
                  }else {
                    var or__3548__auto____4136 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____4136)) {
                      return or__3548__auto____4136
                    }else {
                      var or__3548__auto____4137 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____4137)) {
                        return or__3548__auto____4137
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4171 = function() {
        var G__4173__delegate = function(x, y, z, args) {
          var or__3548__auto____4138 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____4138)) {
            return or__3548__auto____4138
          }else {
            return cljs.core.some.call(null, function(p1__4025_SHARP_) {
              var or__3548__auto____4139 = p1.call(null, p1__4025_SHARP_);
              if(cljs.core.truth_(or__3548__auto____4139)) {
                return or__3548__auto____4139
              }else {
                var or__3548__auto____4140 = p2.call(null, p1__4025_SHARP_);
                if(cljs.core.truth_(or__3548__auto____4140)) {
                  return or__3548__auto____4140
                }else {
                  return p3.call(null, p1__4025_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__4173 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4173__delegate.call(this, x, y, z, args)
        };
        G__4173.cljs$lang$maxFixedArity = 3;
        G__4173.cljs$lang$applyTo = function(arglist__4174) {
          var x = cljs.core.first(arglist__4174);
          var y = cljs.core.first(cljs.core.next(arglist__4174));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4174)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4174)));
          return G__4173__delegate.call(this, x, y, z, args)
        };
        return G__4173
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__4167.call(this);
          case 1:
            return sp3__4168.call(this, x);
          case 2:
            return sp3__4169.call(this, x, y);
          case 3:
            return sp3__4170.call(this, x, y, z);
          default:
            return sp3__4171.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4171.cljs$lang$applyTo;
      return sp3
    }()
  };
  var some_fn__4149 = function() {
    var G__4175__delegate = function(p1, p2, p3, ps) {
      var ps__4141 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__4176 = function() {
          return null
        };
        var spn__4177 = function(x) {
          return cljs.core.some.call(null, function(p1__4026_SHARP_) {
            return p1__4026_SHARP_.call(null, x)
          }, ps__4141)
        };
        var spn__4178 = function(x, y) {
          return cljs.core.some.call(null, function(p1__4027_SHARP_) {
            var or__3548__auto____4142 = p1__4027_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4142)) {
              return or__3548__auto____4142
            }else {
              return p1__4027_SHARP_.call(null, y)
            }
          }, ps__4141)
        };
        var spn__4179 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__4028_SHARP_) {
            var or__3548__auto____4143 = p1__4028_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4143)) {
              return or__3548__auto____4143
            }else {
              var or__3548__auto____4144 = p1__4028_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____4144)) {
                return or__3548__auto____4144
              }else {
                return p1__4028_SHARP_.call(null, z)
              }
            }
          }, ps__4141)
        };
        var spn__4180 = function() {
          var G__4182__delegate = function(x, y, z, args) {
            var or__3548__auto____4145 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____4145)) {
              return or__3548__auto____4145
            }else {
              return cljs.core.some.call(null, function(p1__4029_SHARP_) {
                return cljs.core.some.call(null, p1__4029_SHARP_, args)
              }, ps__4141)
            }
          };
          var G__4182 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__4182__delegate.call(this, x, y, z, args)
          };
          G__4182.cljs$lang$maxFixedArity = 3;
          G__4182.cljs$lang$applyTo = function(arglist__4183) {
            var x = cljs.core.first(arglist__4183);
            var y = cljs.core.first(cljs.core.next(arglist__4183));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4183)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4183)));
            return G__4182__delegate.call(this, x, y, z, args)
          };
          return G__4182
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__4176.call(this);
            case 1:
              return spn__4177.call(this, x);
            case 2:
              return spn__4178.call(this, x, y);
            case 3:
              return spn__4179.call(this, x, y, z);
            default:
              return spn__4180.apply(this, arguments)
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4180.cljs$lang$applyTo;
        return spn
      }()
    };
    var G__4175 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4175__delegate.call(this, p1, p2, p3, ps)
    };
    G__4175.cljs$lang$maxFixedArity = 3;
    G__4175.cljs$lang$applyTo = function(arglist__4184) {
      var p1 = cljs.core.first(arglist__4184);
      var p2 = cljs.core.first(cljs.core.next(arglist__4184));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4184)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4184)));
      return G__4175__delegate.call(this, p1, p2, p3, ps)
    };
    return G__4175
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__4146.call(this, p1);
      case 2:
        return some_fn__4147.call(this, p1, p2);
      case 3:
        return some_fn__4148.call(this, p1, p2, p3);
      default:
        return some_fn__4149.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4149.cljs$lang$applyTo;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__4197 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4185 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4185)) {
        var s__4186 = temp__3698__auto____4185;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__4186)), map.call(null, f, cljs.core.rest.call(null, s__4186)))
      }else {
        return null
      }
    })
  };
  var map__4198 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__4187 = cljs.core.seq.call(null, c1);
      var s2__4188 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4189 = s1__4187;
        if(cljs.core.truth_(and__3546__auto____4189)) {
          return s2__4188
        }else {
          return and__3546__auto____4189
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__4187), cljs.core.first.call(null, s2__4188)), map.call(null, f, cljs.core.rest.call(null, s1__4187), cljs.core.rest.call(null, s2__4188)))
      }else {
        return null
      }
    })
  };
  var map__4199 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__4190 = cljs.core.seq.call(null, c1);
      var s2__4191 = cljs.core.seq.call(null, c2);
      var s3__4192 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4193 = s1__4190;
        if(cljs.core.truth_(and__3546__auto____4193)) {
          var and__3546__auto____4194 = s2__4191;
          if(cljs.core.truth_(and__3546__auto____4194)) {
            return s3__4192
          }else {
            return and__3546__auto____4194
          }
        }else {
          return and__3546__auto____4193
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__4190), cljs.core.first.call(null, s2__4191), cljs.core.first.call(null, s3__4192)), map.call(null, f, cljs.core.rest.call(null, s1__4190), cljs.core.rest.call(null, s2__4191), cljs.core.rest.call(null, s3__4192)))
      }else {
        return null
      }
    })
  };
  var map__4200 = function() {
    var G__4202__delegate = function(f, c1, c2, c3, colls) {
      var step__4196 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__4195 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.truth_(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__4195))) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__4195), step.call(null, map.call(null, cljs.core.rest, ss__4195)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__4107_SHARP_) {
        return cljs.core.apply.call(null, f, p1__4107_SHARP_)
      }, step__4196.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__4202 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__4202__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__4202.cljs$lang$maxFixedArity = 4;
    G__4202.cljs$lang$applyTo = function(arglist__4203) {
      var f = cljs.core.first(arglist__4203);
      var c1 = cljs.core.first(cljs.core.next(arglist__4203));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4203)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4203))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4203))));
      return G__4202__delegate.call(this, f, c1, c2, c3, colls)
    };
    return G__4202
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__4197.call(this, f, c1);
      case 3:
        return map__4198.call(this, f, c1, c2);
      case 4:
        return map__4199.call(this, f, c1, c2, c3);
      default:
        return map__4200.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__4200.cljs$lang$applyTo;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(cljs.core.truth_(n > 0)) {
      var temp__3698__auto____4204 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4204)) {
        var s__4205 = temp__3698__auto____4204;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__4205), take.call(null, n - 1, cljs.core.rest.call(null, s__4205)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__4208 = function(n, coll) {
    while(true) {
      var s__4206 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4207 = n > 0;
        if(cljs.core.truth_(and__3546__auto____4207)) {
          return s__4206
        }else {
          return and__3546__auto____4207
        }
      }())) {
        var G__4209 = n - 1;
        var G__4210 = cljs.core.rest.call(null, s__4206);
        n = G__4209;
        coll = G__4210;
        continue
      }else {
        return s__4206
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__4208.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__4211 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__4212 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__4211.call(this, n);
      case 2:
        return drop_last__4212.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__4214 = cljs.core.seq.call(null, coll);
  var lead__4215 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__4215)) {
      var G__4216 = cljs.core.next.call(null, s__4214);
      var G__4217 = cljs.core.next.call(null, lead__4215);
      s__4214 = G__4216;
      lead__4215 = G__4217;
      continue
    }else {
      return s__4214
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__4220 = function(pred, coll) {
    while(true) {
      var s__4218 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4219 = s__4218;
        if(cljs.core.truth_(and__3546__auto____4219)) {
          return pred.call(null, cljs.core.first.call(null, s__4218))
        }else {
          return and__3546__auto____4219
        }
      }())) {
        var G__4221 = pred;
        var G__4222 = cljs.core.rest.call(null, s__4218);
        pred = G__4221;
        coll = G__4222;
        continue
      }else {
        return s__4218
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__4220.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4223 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4223)) {
      var s__4224 = temp__3698__auto____4223;
      return cljs.core.concat.call(null, s__4224, cycle.call(null, s__4224))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__4225 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__4226 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__4225.call(this, n);
      case 2:
        return repeat__4226.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__4228 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__4229 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__4228.call(this, n);
      case 2:
        return repeatedly__4229.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__4235 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__4231 = cljs.core.seq.call(null, c1);
      var s2__4232 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4233 = s1__4231;
        if(cljs.core.truth_(and__3546__auto____4233)) {
          return s2__4232
        }else {
          return and__3546__auto____4233
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__4231), cljs.core.cons.call(null, cljs.core.first.call(null, s2__4232), interleave.call(null, cljs.core.rest.call(null, s1__4231), cljs.core.rest.call(null, s2__4232))))
      }else {
        return null
      }
    })
  };
  var interleave__4236 = function() {
    var G__4238__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__4234 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.truth_(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__4234))) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__4234), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__4234)))
        }else {
          return null
        }
      })
    };
    var G__4238 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4238__delegate.call(this, c1, c2, colls)
    };
    G__4238.cljs$lang$maxFixedArity = 2;
    G__4238.cljs$lang$applyTo = function(arglist__4239) {
      var c1 = cljs.core.first(arglist__4239);
      var c2 = cljs.core.first(cljs.core.next(arglist__4239));
      var colls = cljs.core.rest(cljs.core.next(arglist__4239));
      return G__4238__delegate.call(this, c1, c2, colls)
    };
    return G__4238
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__4235.call(this, c1, c2);
      default:
        return interleave__4236.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__4236.cljs$lang$applyTo;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__4242 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____4240 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____4240)) {
        var coll__4241 = temp__3695__auto____4240;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__4241), cat.call(null, cljs.core.rest.call(null, coll__4241), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__4242.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__4243 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__4244 = function() {
    var G__4246__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__4246 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4246__delegate.call(this, f, coll, colls)
    };
    G__4246.cljs$lang$maxFixedArity = 2;
    G__4246.cljs$lang$applyTo = function(arglist__4247) {
      var f = cljs.core.first(arglist__4247);
      var coll = cljs.core.first(cljs.core.next(arglist__4247));
      var colls = cljs.core.rest(cljs.core.next(arglist__4247));
      return G__4246__delegate.call(this, f, coll, colls)
    };
    return G__4246
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__4243.call(this, f, coll);
      default:
        return mapcat__4244.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__4244.cljs$lang$applyTo;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4248 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4248)) {
      var s__4249 = temp__3698__auto____4248;
      var f__4250 = cljs.core.first.call(null, s__4249);
      var r__4251 = cljs.core.rest.call(null, s__4249);
      if(cljs.core.truth_(pred.call(null, f__4250))) {
        return cljs.core.cons.call(null, f__4250, filter.call(null, pred, r__4251))
      }else {
        return filter.call(null, pred, r__4251)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__4253 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__4253.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__4252_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__4252_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  return cljs.core.reduce.call(null, cljs.core._conj, to, from)
};
cljs.core.partition = function() {
  var partition = null;
  var partition__4260 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__4261 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4254 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4254)) {
        var s__4255 = temp__3698__auto____4254;
        var p__4256 = cljs.core.take.call(null, n, s__4255);
        if(cljs.core.truth_(cljs.core._EQ_.call(null, n, cljs.core.count.call(null, p__4256)))) {
          return cljs.core.cons.call(null, p__4256, partition.call(null, n, step, cljs.core.drop.call(null, step, s__4255)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4262 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4257 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4257)) {
        var s__4258 = temp__3698__auto____4257;
        var p__4259 = cljs.core.take.call(null, n, s__4258);
        if(cljs.core.truth_(cljs.core._EQ_.call(null, n, cljs.core.count.call(null, p__4259)))) {
          return cljs.core.cons.call(null, p__4259, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__4258)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__4259, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__4260.call(this, n, step);
      case 3:
        return partition__4261.call(this, n, step, pad);
      case 4:
        return partition__4262.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__4268 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__4269 = function(m, ks, not_found) {
    var sentinel__4264 = cljs.core.lookup_sentinel;
    var m__4265 = m;
    var ks__4266 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__4266)) {
        var m__4267 = cljs.core.get.call(null, m__4265, cljs.core.first.call(null, ks__4266), sentinel__4264);
        if(cljs.core.truth_(sentinel__4264 === m__4267)) {
          return not_found
        }else {
          var G__4271 = sentinel__4264;
          var G__4272 = m__4267;
          var G__4273 = cljs.core.next.call(null, ks__4266);
          sentinel__4264 = G__4271;
          m__4265 = G__4272;
          ks__4266 = G__4273;
          continue
        }
      }else {
        return m__4265
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__4268.call(this, m, ks);
      case 3:
        return get_in__4269.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__4274, v) {
  var vec__4275__4276 = p__4274;
  var k__4277 = cljs.core.nth.call(null, vec__4275__4276, 0, null);
  var ks__4278 = cljs.core.nthnext.call(null, vec__4275__4276, 1);
  if(cljs.core.truth_(ks__4278)) {
    return cljs.core.assoc.call(null, m, k__4277, assoc_in.call(null, cljs.core.get.call(null, m, k__4277), ks__4278, v))
  }else {
    return cljs.core.assoc.call(null, m, k__4277, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__4279, f, args) {
    var vec__4280__4281 = p__4279;
    var k__4282 = cljs.core.nth.call(null, vec__4280__4281, 0, null);
    var ks__4283 = cljs.core.nthnext.call(null, vec__4280__4281, 1);
    if(cljs.core.truth_(ks__4283)) {
      return cljs.core.assoc.call(null, m, k__4282, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__4282), ks__4283, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__4282, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__4282), args))
    }
  };
  var update_in = function(m, p__4279, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__4279, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__4284) {
    var m = cljs.core.first(arglist__4284);
    var p__4279 = cljs.core.first(cljs.core.next(arglist__4284));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4284)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4284)));
    return update_in__delegate.call(this, m, p__4279, f, args)
  };
  return update_in
}();
cljs.core.Vector = function(meta, array) {
  this.meta = meta;
  this.array = array
};
cljs.core.Vector.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4285 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4318 = null;
  var G__4318__4319 = function(coll, k) {
    var this__4286 = this;
    return cljs.core._nth.call(null, coll, k, null)
  };
  var G__4318__4320 = function(coll, k, not_found) {
    var this__4287 = this;
    return cljs.core._nth.call(null, coll, k, not_found)
  };
  G__4318 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4318__4319.call(this, coll, k);
      case 3:
        return G__4318__4320.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4318
}();
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4288 = this;
  var new_array__4289 = cljs.core.aclone.call(null, this__4288.array);
  new_array__4289[k] = v;
  return new cljs.core.Vector(this__4288.meta, new_array__4289)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__4322 = null;
  var G__4322__4323 = function(tsym4290, k) {
    var this__4292 = this;
    var tsym4290__4293 = this;
    var coll__4294 = tsym4290__4293;
    return cljs.core._lookup.call(null, coll__4294, k)
  };
  var G__4322__4324 = function(tsym4291, k, not_found) {
    var this__4295 = this;
    var tsym4291__4296 = this;
    var coll__4297 = tsym4291__4296;
    return cljs.core._lookup.call(null, coll__4297, k, not_found)
  };
  G__4322 = function(tsym4291, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4322__4323.call(this, tsym4291, k);
      case 3:
        return G__4322__4324.call(this, tsym4291, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4322
}();
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4298 = this;
  var new_array__4299 = cljs.core.aclone.call(null, this__4298.array);
  new_array__4299.push(o);
  return new cljs.core.Vector(this__4298.meta, new_array__4299)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4326 = null;
  var G__4326__4327 = function(v, f) {
    var this__4300 = this;
    return cljs.core.ci_reduce.call(null, this__4300.array, f)
  };
  var G__4326__4328 = function(v, f, start) {
    var this__4301 = this;
    return cljs.core.ci_reduce.call(null, this__4301.array, f, start)
  };
  G__4326 = function(v, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4326__4327.call(this, v, f);
      case 3:
        return G__4326__4328.call(this, v, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4326
}();
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4302 = this;
  if(cljs.core.truth_(this__4302.array.length > 0)) {
    var vector_seq__4303 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(cljs.core.truth_(i < this__4302.array.length)) {
          return cljs.core.cons.call(null, this__4302.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__4303.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4304 = this;
  return this__4304.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4305 = this;
  var count__4306 = this__4305.array.length;
  if(cljs.core.truth_(count__4306 > 0)) {
    return this__4305.array[count__4306 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4307 = this;
  if(cljs.core.truth_(this__4307.array.length > 0)) {
    var new_array__4308 = cljs.core.aclone.call(null, this__4307.array);
    new_array__4308.pop();
    return new cljs.core.Vector(this__4307.meta, new_array__4308)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n = function(coll, n, val) {
  var this__4309 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4310 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4311 = this;
  return new cljs.core.Vector(meta, this__4311.array)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4312 = this;
  return this__4312.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4330 = null;
  var G__4330__4331 = function(coll, n) {
    var this__4313 = this;
    if(cljs.core.truth_(function() {
      var and__3546__auto____4314 = 0 <= n;
      if(cljs.core.truth_(and__3546__auto____4314)) {
        return n < this__4313.array.length
      }else {
        return and__3546__auto____4314
      }
    }())) {
      return this__4313.array[n]
    }else {
      return null
    }
  };
  var G__4330__4332 = function(coll, n, not_found) {
    var this__4315 = this;
    if(cljs.core.truth_(function() {
      var and__3546__auto____4316 = 0 <= n;
      if(cljs.core.truth_(and__3546__auto____4316)) {
        return n < this__4315.array.length
      }else {
        return and__3546__auto____4316
      }
    }())) {
      return this__4315.array[n]
    }else {
      return not_found
    }
  };
  G__4330 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4330__4331.call(this, coll, n);
      case 3:
        return G__4330__4332.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4330
}();
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4317 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__4317.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, []);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs)
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__4334 = pv.cnt;
  if(cljs.core.truth_(cnt__4334 < 32)) {
    return 0
  }else {
    return cnt__4334 - 1 >> 5 << 5
  }
};
cljs.core.new_path = function new_path(level, node) {
  var ll__4335 = level;
  var ret__4336 = node;
  while(true) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, 0, ll__4335))) {
      return ret__4336
    }else {
      var embed__4337 = ret__4336;
      var r__4338 = cljs.core.aclone.call(null, cljs.core.PersistentVector.EMPTY_NODE);
      var ___4339 = r__4338[0] = embed__4337;
      var G__4340 = ll__4335 - 5;
      var G__4341 = r__4338;
      ll__4335 = G__4340;
      ret__4336 = G__4341;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__4342 = cljs.core.aclone.call(null, parent);
  var subidx__4343 = pv.cnt - 1 >> level & 31;
  if(cljs.core.truth_(cljs.core._EQ_.call(null, 5, level))) {
    ret__4342[subidx__4343] = tailnode;
    return ret__4342
  }else {
    var temp__3695__auto____4344 = parent[subidx__4343];
    if(cljs.core.truth_(temp__3695__auto____4344)) {
      var child__4345 = temp__3695__auto____4344;
      var node_to_insert__4346 = push_tail.call(null, pv, level - 5, child__4345, tailnode);
      var ___4347 = ret__4342[subidx__4343] = node_to_insert__4346;
      return ret__4342
    }else {
      var node_to_insert__4348 = cljs.core.new_path.call(null, level - 5, tailnode);
      var ___4349 = ret__4342[subidx__4343] = node_to_insert__4348;
      return ret__4342
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4350 = 0 <= i;
    if(cljs.core.truth_(and__3546__auto____4350)) {
      return i < pv.cnt
    }else {
      return and__3546__auto____4350
    }
  }())) {
    if(cljs.core.truth_(i >= cljs.core.tail_off.call(null, pv))) {
      return pv.tail
    }else {
      var node__4351 = pv.root;
      var level__4352 = pv.shift;
      while(true) {
        if(cljs.core.truth_(level__4352 > 0)) {
          var G__4353 = node__4351[i >> level__4352 & 31];
          var G__4354 = level__4352 - 5;
          node__4351 = G__4353;
          level__4352 = G__4354;
          continue
        }else {
          return node__4351
        }
        break
      }
    }
  }else {
    throw new Error(cljs.core.str.call(null, "No item ", i, " in vector of length ", pv.cnt));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__4355 = cljs.core.aclone.call(null, node);
  if(cljs.core.truth_(level === 0)) {
    ret__4355[i & 31] = val;
    return ret__4355
  }else {
    var subidx__4356 = i >> level & 31;
    var ___4357 = ret__4355[subidx__4356] = do_assoc.call(null, pv, level - 5, node[subidx__4356], i, val);
    return ret__4355
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__4358 = pv.cnt - 2 >> level & 31;
  if(cljs.core.truth_(level > 5)) {
    var new_child__4359 = pop_tail.call(null, pv, level - 5, node[subidx__4358]);
    if(cljs.core.truth_(function() {
      var and__3546__auto____4360 = new_child__4359 === null;
      if(cljs.core.truth_(and__3546__auto____4360)) {
        return subidx__4358 === 0
      }else {
        return and__3546__auto____4360
      }
    }())) {
      return null
    }else {
      var ret__4361 = cljs.core.aclone.call(null, node);
      var ___4362 = ret__4361[subidx__4358] = new_child__4359;
      return ret__4361
    }
  }else {
    if(cljs.core.truth_(subidx__4358 === 0)) {
      return null
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        var ret__4363 = cljs.core.aclone.call(null, node);
        var ___4364 = ret__4363[subidx__4358] = null;
        return ret__4363
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail
};
cljs.core.PersistentVector.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4365 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4405 = null;
  var G__4405__4406 = function(coll, k) {
    var this__4366 = this;
    return cljs.core._nth.call(null, coll, k, null)
  };
  var G__4405__4407 = function(coll, k, not_found) {
    var this__4367 = this;
    return cljs.core._nth.call(null, coll, k, not_found)
  };
  G__4405 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4405__4406.call(this, coll, k);
      case 3:
        return G__4405__4407.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4405
}();
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4368 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____4369 = 0 <= k;
    if(cljs.core.truth_(and__3546__auto____4369)) {
      return k < this__4368.cnt
    }else {
      return and__3546__auto____4369
    }
  }())) {
    if(cljs.core.truth_(cljs.core.tail_off.call(null, coll) <= k)) {
      var new_tail__4370 = cljs.core.aclone.call(null, this__4368.tail);
      new_tail__4370[k & 31] = v;
      return new cljs.core.PersistentVector(this__4368.meta, this__4368.cnt, this__4368.shift, this__4368.root, new_tail__4370)
    }else {
      return new cljs.core.PersistentVector(this__4368.meta, this__4368.cnt, this__4368.shift, cljs.core.do_assoc.call(null, coll, this__4368.shift, this__4368.root, k, v), this__4368.tail)
    }
  }else {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, k, this__4368.cnt))) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        throw new Error(cljs.core.str.call(null, "Index ", k, " out of bounds  [0,", this__4368.cnt, "]"));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__4409 = null;
  var G__4409__4410 = function(tsym4371, k) {
    var this__4373 = this;
    var tsym4371__4374 = this;
    var coll__4375 = tsym4371__4374;
    return cljs.core._lookup.call(null, coll__4375, k)
  };
  var G__4409__4411 = function(tsym4372, k, not_found) {
    var this__4376 = this;
    var tsym4372__4377 = this;
    var coll__4378 = tsym4372__4377;
    return cljs.core._lookup.call(null, coll__4378, k, not_found)
  };
  G__4409 = function(tsym4372, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4409__4410.call(this, tsym4372, k);
      case 3:
        return G__4409__4411.call(this, tsym4372, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4409
}();
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4379 = this;
  if(cljs.core.truth_(this__4379.cnt - cljs.core.tail_off.call(null, coll) < 32)) {
    var new_tail__4380 = cljs.core.aclone.call(null, this__4379.tail);
    new_tail__4380.push(o);
    return new cljs.core.PersistentVector(this__4379.meta, this__4379.cnt + 1, this__4379.shift, this__4379.root, new_tail__4380)
  }else {
    var root_overflow_QMARK___4381 = this__4379.cnt >> 5 > 1 << this__4379.shift;
    var new_shift__4382 = cljs.core.truth_(root_overflow_QMARK___4381) ? this__4379.shift + 5 : this__4379.shift;
    var new_root__4384 = cljs.core.truth_(root_overflow_QMARK___4381) ? function() {
      var n_r__4383 = cljs.core.aclone.call(null, cljs.core.PersistentVector.EMPTY_NODE);
      n_r__4383[0] = this__4379.root;
      n_r__4383[1] = cljs.core.new_path.call(null, this__4379.shift, this__4379.tail);
      return n_r__4383
    }() : cljs.core.push_tail.call(null, coll, this__4379.shift, this__4379.root, this__4379.tail);
    return new cljs.core.PersistentVector(this__4379.meta, this__4379.cnt + 1, new_shift__4382, new_root__4384, [o])
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4413 = null;
  var G__4413__4414 = function(v, f) {
    var this__4385 = this;
    return cljs.core.ci_reduce.call(null, v, f)
  };
  var G__4413__4415 = function(v, f, start) {
    var this__4386 = this;
    return cljs.core.ci_reduce.call(null, v, f, start)
  };
  G__4413 = function(v, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4413__4414.call(this, v, f);
      case 3:
        return G__4413__4415.call(this, v, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4413
}();
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4387 = this;
  if(cljs.core.truth_(this__4387.cnt > 0)) {
    var vector_seq__4388 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(cljs.core.truth_(i < this__4387.cnt)) {
          return cljs.core.cons.call(null, cljs.core._nth.call(null, coll, i), vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__4388.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4389 = this;
  return this__4389.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4390 = this;
  if(cljs.core.truth_(this__4390.cnt > 0)) {
    return cljs.core._nth.call(null, coll, this__4390.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4391 = this;
  if(cljs.core.truth_(this__4391.cnt === 0)) {
    throw new Error("Can't pop empty vector");
  }else {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, 1, this__4391.cnt))) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__4391.meta)
    }else {
      if(cljs.core.truth_(1 < this__4391.cnt - cljs.core.tail_off.call(null, coll))) {
        return new cljs.core.PersistentVector(this__4391.meta, this__4391.cnt - 1, this__4391.shift, this__4391.root, cljs.core.aclone.call(null, this__4391.tail))
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          var new_tail__4392 = cljs.core.array_for.call(null, coll, this__4391.cnt - 2);
          var nr__4393 = cljs.core.pop_tail.call(null, this__4391.shift, this__4391.root);
          var new_root__4394 = cljs.core.truth_(nr__4393 === null) ? cljs.core.PersistentVector.EMPTY_NODE : nr__4393;
          var cnt_1__4395 = this__4391.cnt - 1;
          if(cljs.core.truth_(function() {
            var and__3546__auto____4396 = 5 < this__4391.shift;
            if(cljs.core.truth_(and__3546__auto____4396)) {
              return new_root__4394[1] === null
            }else {
              return and__3546__auto____4396
            }
          }())) {
            return new cljs.core.PersistentVector(this__4391.meta, cnt_1__4395, this__4391.shift - 5, new_root__4394[0], new_tail__4392)
          }else {
            return new cljs.core.PersistentVector(this__4391.meta, cnt_1__4395, this__4391.shift, new_root__4394, new_tail__4392)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n = function(coll, n, val) {
  var this__4397 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4398 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4399 = this;
  return new cljs.core.PersistentVector(meta, this__4399.cnt, this__4399.shift, this__4399.root, this__4399.tail)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4400 = this;
  return this__4400.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4417 = null;
  var G__4417__4418 = function(coll, n) {
    var this__4401 = this;
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  };
  var G__4417__4419 = function(coll, n, not_found) {
    var this__4402 = this;
    if(cljs.core.truth_(function() {
      var and__3546__auto____4403 = 0 <= n;
      if(cljs.core.truth_(and__3546__auto____4403)) {
        return n < this__4402.cnt
      }else {
        return and__3546__auto____4403
      }
    }())) {
      return cljs.core._nth.call(null, coll, n)
    }else {
      return not_found
    }
  };
  G__4417 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4417__4418.call(this, coll, n);
      case 3:
        return G__4417__4419.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4417
}();
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4404 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__4404.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = new Array(32);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, []);
cljs.core.PersistentVector.fromArray = function(xs) {
  return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, xs)
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__4421) {
    var args = cljs.core.seq(arglist__4421);
    return vector__delegate.call(this, args)
  };
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end
};
cljs.core.Subvec.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4422 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4450 = null;
  var G__4450__4451 = function(coll, k) {
    var this__4423 = this;
    return cljs.core._nth.call(null, coll, k, null)
  };
  var G__4450__4452 = function(coll, k, not_found) {
    var this__4424 = this;
    return cljs.core._nth.call(null, coll, k, not_found)
  };
  G__4450 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4450__4451.call(this, coll, k);
      case 3:
        return G__4450__4452.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4450
}();
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc = function(coll, key, val) {
  var this__4425 = this;
  var v_pos__4426 = this__4425.start + key;
  return new cljs.core.Subvec(this__4425.meta, cljs.core._assoc.call(null, this__4425.v, v_pos__4426, val), this__4425.start, this__4425.end > v_pos__4426 + 1 ? this__4425.end : v_pos__4426 + 1)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__4454 = null;
  var G__4454__4455 = function(tsym4427, k) {
    var this__4429 = this;
    var tsym4427__4430 = this;
    var coll__4431 = tsym4427__4430;
    return cljs.core._lookup.call(null, coll__4431, k)
  };
  var G__4454__4456 = function(tsym4428, k, not_found) {
    var this__4432 = this;
    var tsym4428__4433 = this;
    var coll__4434 = tsym4428__4433;
    return cljs.core._lookup.call(null, coll__4434, k, not_found)
  };
  G__4454 = function(tsym4428, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4454__4455.call(this, tsym4428, k);
      case 3:
        return G__4454__4456.call(this, tsym4428, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4454
}();
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4435 = this;
  return new cljs.core.Subvec(this__4435.meta, cljs.core._assoc_n.call(null, this__4435.v, this__4435.end, o), this__4435.start, this__4435.end + 1)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4458 = null;
  var G__4458__4459 = function(coll, f) {
    var this__4436 = this;
    return cljs.core.ci_reduce.call(null, coll, f)
  };
  var G__4458__4460 = function(coll, f, start) {
    var this__4437 = this;
    return cljs.core.ci_reduce.call(null, coll, f, start)
  };
  G__4458 = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4458__4459.call(this, coll, f);
      case 3:
        return G__4458__4460.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4458
}();
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4438 = this;
  var subvec_seq__4439 = function subvec_seq(i) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, i, this__4438.end))) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__4438.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__4439.call(null, this__4438.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4440 = this;
  return this__4440.end - this__4440.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4441 = this;
  return cljs.core._nth.call(null, this__4441.v, this__4441.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4442 = this;
  if(cljs.core.truth_(cljs.core._EQ_.call(null, this__4442.start, this__4442.end))) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__4442.meta, this__4442.v, this__4442.start, this__4442.end - 1)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n = function(coll, n, val) {
  var this__4443 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4444 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4445 = this;
  return new cljs.core.Subvec(meta, this__4445.v, this__4445.start, this__4445.end)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4446 = this;
  return this__4446.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4462 = null;
  var G__4462__4463 = function(coll, n) {
    var this__4447 = this;
    return cljs.core._nth.call(null, this__4447.v, this__4447.start + n)
  };
  var G__4462__4464 = function(coll, n, not_found) {
    var this__4448 = this;
    return cljs.core._nth.call(null, this__4448.v, this__4448.start + n, not_found)
  };
  G__4462 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4462__4463.call(this, coll, n);
      case 3:
        return G__4462__4464.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4462
}();
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4449 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__4449.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__4466 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__4467 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__4466.call(this, v, start);
      case 3:
        return subvec__4467.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return subvec
}();
cljs.core.PersistentQueueSeq = function(meta, front, rear) {
  this.meta = meta;
  this.front = front;
  this.rear = rear
};
cljs.core.PersistentQueueSeq.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4469 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4470 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4471 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4472 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__4472.meta)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4473 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__4474 = this;
  return cljs.core._first.call(null, this__4474.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__4475 = this;
  var temp__3695__auto____4476 = cljs.core.next.call(null, this__4475.front);
  if(cljs.core.truth_(temp__3695__auto____4476)) {
    var f1__4477 = temp__3695__auto____4476;
    return new cljs.core.PersistentQueueSeq(this__4475.meta, f1__4477, this__4475.rear)
  }else {
    if(cljs.core.truth_(this__4475.rear === null)) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__4475.meta, this__4475.rear, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4478 = this;
  return this__4478.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4479 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__4479.front, this__4479.rear)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear
};
cljs.core.PersistentQueue.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4480 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4481 = this;
  if(cljs.core.truth_(this__4481.front)) {
    return new cljs.core.PersistentQueue(this__4481.meta, this__4481.count + 1, this__4481.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____4482 = this__4481.rear;
      if(cljs.core.truth_(or__3548__auto____4482)) {
        return or__3548__auto____4482
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o))
  }else {
    return new cljs.core.PersistentQueue(this__4481.meta, this__4481.count + 1, cljs.core.conj.call(null, this__4481.front, o), cljs.core.PersistentVector.fromArray([]))
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4483 = this;
  var rear__4484 = cljs.core.seq.call(null, this__4483.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____4485 = this__4483.front;
    if(cljs.core.truth_(or__3548__auto____4485)) {
      return or__3548__auto____4485
    }else {
      return rear__4484
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__4483.front, cljs.core.seq.call(null, rear__4484))
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4486 = this;
  return this__4486.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4487 = this;
  return cljs.core._first.call(null, this__4487.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4488 = this;
  if(cljs.core.truth_(this__4488.front)) {
    var temp__3695__auto____4489 = cljs.core.next.call(null, this__4488.front);
    if(cljs.core.truth_(temp__3695__auto____4489)) {
      var f1__4490 = temp__3695__auto____4489;
      return new cljs.core.PersistentQueue(this__4488.meta, this__4488.count - 1, f1__4490, this__4488.rear)
    }else {
      return new cljs.core.PersistentQueue(this__4488.meta, this__4488.count - 1, cljs.core.seq.call(null, this__4488.rear), cljs.core.PersistentVector.fromArray([]))
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__4491 = this;
  return cljs.core.first.call(null, this__4491.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__4492 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4493 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4494 = this;
  return new cljs.core.PersistentQueue(meta, this__4494.count, this__4494.front, this__4494.rear)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4495 = this;
  return this__4495.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4496 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]));
cljs.core.NeverEquiv = function() {
};
cljs.core.NeverEquiv.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv = function(o, other) {
  var this__4497 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.truth_(cljs.core.map_QMARK_.call(null, y)) ? cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.count.call(null, x), cljs.core.count.call(null, y))) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__4498 = array.length;
  var i__4499 = 0;
  while(true) {
    if(cljs.core.truth_(i__4499 < len__4498)) {
      if(cljs.core.truth_(cljs.core._EQ_.call(null, k, array[i__4499]))) {
        return i__4499
      }else {
        var G__4500 = i__4499 + incr;
        i__4499 = G__4500;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___4502 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4503 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____4501 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____4501)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____4501
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___4502.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4503.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__4506 = cljs.core.hash.call(null, a);
  var b__4507 = cljs.core.hash.call(null, b);
  if(cljs.core.truth_(a__4506 < b__4507)) {
    return-1
  }else {
    if(cljs.core.truth_(a__4506 > b__4507)) {
      return 1
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.ObjMap = function(meta, keys, strobj) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj
};
cljs.core.ObjMap.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4508 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4535 = null;
  var G__4535__4536 = function(coll, k) {
    var this__4509 = this;
    return cljs.core._lookup.call(null, coll, k, null)
  };
  var G__4535__4537 = function(coll, k, not_found) {
    var this__4510 = this;
    return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__4510.strobj, this__4510.strobj[k], not_found)
  };
  G__4535 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4535__4536.call(this, coll, k);
      case 3:
        return G__4535__4537.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4535
}();
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4511 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var new_strobj__4512 = goog.object.clone.call(null, this__4511.strobj);
    var overwrite_QMARK___4513 = new_strobj__4512.hasOwnProperty(k);
    new_strobj__4512[k] = v;
    if(cljs.core.truth_(overwrite_QMARK___4513)) {
      return new cljs.core.ObjMap(this__4511.meta, this__4511.keys, new_strobj__4512)
    }else {
      var new_keys__4514 = cljs.core.aclone.call(null, this__4511.keys);
      new_keys__4514.push(k);
      return new cljs.core.ObjMap(this__4511.meta, new_keys__4514, new_strobj__4512)
    }
  }else {
    return cljs.core.with_meta.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null, k, v), cljs.core.seq.call(null, coll)), this__4511.meta)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_ = function(coll, k) {
  var this__4515 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__4515.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__4539 = null;
  var G__4539__4540 = function(tsym4516, k) {
    var this__4518 = this;
    var tsym4516__4519 = this;
    var coll__4520 = tsym4516__4519;
    return cljs.core._lookup.call(null, coll__4520, k)
  };
  var G__4539__4541 = function(tsym4517, k, not_found) {
    var this__4521 = this;
    var tsym4517__4522 = this;
    var coll__4523 = tsym4517__4522;
    return cljs.core._lookup.call(null, coll__4523, k, not_found)
  };
  G__4539 = function(tsym4517, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4539__4540.call(this, tsym4517, k);
      case 3:
        return G__4539__4541.call(this, tsym4517, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4539
}();
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj = function(coll, entry) {
  var this__4524 = this;
  if(cljs.core.truth_(cljs.core.vector_QMARK_.call(null, entry))) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4525 = this;
  if(cljs.core.truth_(this__4525.keys.length > 0)) {
    return cljs.core.map.call(null, function(p1__4505_SHARP_) {
      return cljs.core.vector.call(null, p1__4505_SHARP_, this__4525.strobj[p1__4505_SHARP_])
    }, this__4525.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4526 = this;
  return this__4526.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4527 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4528 = this;
  return new cljs.core.ObjMap(meta, this__4528.keys, this__4528.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4529 = this;
  return this__4529.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4530 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__4530.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc = function(coll, k) {
  var this__4531 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____4532 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____4532)) {
      return this__4531.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____4532
    }
  }())) {
    var new_keys__4533 = cljs.core.aclone.call(null, this__4531.keys);
    var new_strobj__4534 = goog.object.clone.call(null, this__4531.strobj);
    new_keys__4533.splice(cljs.core.scan_array.call(null, 1, k, new_keys__4533), 1);
    cljs.core.js_delete.call(null, new_strobj__4534, k);
    return new cljs.core.ObjMap(this__4531.meta, new_keys__4533, new_strobj__4534)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], cljs.core.js_obj.call(null));
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj)
};
cljs.core.HashMap = function(meta, count, hashobj) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj
};
cljs.core.HashMap.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4544 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4582 = null;
  var G__4582__4583 = function(coll, k) {
    var this__4545 = this;
    return cljs.core._lookup.call(null, coll, k, null)
  };
  var G__4582__4584 = function(coll, k, not_found) {
    var this__4546 = this;
    var bucket__4547 = this__4546.hashobj[cljs.core.hash.call(null, k)];
    var i__4548 = cljs.core.truth_(bucket__4547) ? cljs.core.scan_array.call(null, 2, k, bucket__4547) : null;
    if(cljs.core.truth_(i__4548)) {
      return bucket__4547[i__4548 + 1]
    }else {
      return not_found
    }
  };
  G__4582 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4582__4583.call(this, coll, k);
      case 3:
        return G__4582__4584.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4582
}();
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4549 = this;
  var h__4550 = cljs.core.hash.call(null, k);
  var bucket__4551 = this__4549.hashobj[h__4550];
  if(cljs.core.truth_(bucket__4551)) {
    var new_bucket__4552 = cljs.core.aclone.call(null, bucket__4551);
    var new_hashobj__4553 = goog.object.clone.call(null, this__4549.hashobj);
    new_hashobj__4553[h__4550] = new_bucket__4552;
    var temp__3695__auto____4554 = cljs.core.scan_array.call(null, 2, k, new_bucket__4552);
    if(cljs.core.truth_(temp__3695__auto____4554)) {
      var i__4555 = temp__3695__auto____4554;
      new_bucket__4552[i__4555 + 1] = v;
      return new cljs.core.HashMap(this__4549.meta, this__4549.count, new_hashobj__4553)
    }else {
      new_bucket__4552.push(k, v);
      return new cljs.core.HashMap(this__4549.meta, this__4549.count + 1, new_hashobj__4553)
    }
  }else {
    var new_hashobj__4556 = goog.object.clone.call(null, this__4549.hashobj);
    new_hashobj__4556[h__4550] = [k, v];
    return new cljs.core.HashMap(this__4549.meta, this__4549.count + 1, new_hashobj__4556)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_ = function(coll, k) {
  var this__4557 = this;
  var bucket__4558 = this__4557.hashobj[cljs.core.hash.call(null, k)];
  var i__4559 = cljs.core.truth_(bucket__4558) ? cljs.core.scan_array.call(null, 2, k, bucket__4558) : null;
  if(cljs.core.truth_(i__4559)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__4586 = null;
  var G__4586__4587 = function(tsym4560, k) {
    var this__4562 = this;
    var tsym4560__4563 = this;
    var coll__4564 = tsym4560__4563;
    return cljs.core._lookup.call(null, coll__4564, k)
  };
  var G__4586__4588 = function(tsym4561, k, not_found) {
    var this__4565 = this;
    var tsym4561__4566 = this;
    var coll__4567 = tsym4561__4566;
    return cljs.core._lookup.call(null, coll__4567, k, not_found)
  };
  G__4586 = function(tsym4561, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4586__4587.call(this, tsym4561, k);
      case 3:
        return G__4586__4588.call(this, tsym4561, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4586
}();
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj = function(coll, entry) {
  var this__4568 = this;
  if(cljs.core.truth_(cljs.core.vector_QMARK_.call(null, entry))) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4569 = this;
  if(cljs.core.truth_(this__4569.count > 0)) {
    var hashes__4570 = cljs.core.js_keys.call(null, this__4569.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__4543_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__4569.hashobj[p1__4543_SHARP_]))
    }, hashes__4570)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4571 = this;
  return this__4571.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4572 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4573 = this;
  return new cljs.core.HashMap(meta, this__4573.count, this__4573.hashobj)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4574 = this;
  return this__4574.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4575 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__4575.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc = function(coll, k) {
  var this__4576 = this;
  var h__4577 = cljs.core.hash.call(null, k);
  var bucket__4578 = this__4576.hashobj[h__4577];
  var i__4579 = cljs.core.truth_(bucket__4578) ? cljs.core.scan_array.call(null, 2, k, bucket__4578) : null;
  if(cljs.core.truth_(cljs.core.not.call(null, i__4579))) {
    return coll
  }else {
    var new_hashobj__4580 = goog.object.clone.call(null, this__4576.hashobj);
    if(cljs.core.truth_(3 > bucket__4578.length)) {
      cljs.core.js_delete.call(null, new_hashobj__4580, h__4577)
    }else {
      var new_bucket__4581 = cljs.core.aclone.call(null, bucket__4578);
      new_bucket__4581.splice(i__4579, 2);
      new_hashobj__4580[h__4577] = new_bucket__4581
    }
    return new cljs.core.HashMap(this__4576.meta, this__4576.count - 1, new_hashobj__4580)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, cljs.core.js_obj.call(null));
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__4590 = ks.length;
  var i__4591 = 0;
  var out__4592 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(cljs.core.truth_(i__4591 < len__4590)) {
      var G__4593 = i__4591 + 1;
      var G__4594 = cljs.core.assoc.call(null, out__4592, ks[i__4591], vs[i__4591]);
      i__4591 = G__4593;
      out__4592 = G__4594;
      continue
    }else {
      return out__4592
    }
    break
  }
};
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__4595 = cljs.core.seq.call(null, keyvals);
    var out__4596 = cljs.core.HashMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__4595)) {
        var G__4597 = cljs.core.nnext.call(null, in$__4595);
        var G__4598 = cljs.core.assoc.call(null, out__4596, cljs.core.first.call(null, in$__4595), cljs.core.second.call(null, in$__4595));
        in$__4595 = G__4597;
        out__4596 = G__4598;
        continue
      }else {
        return out__4596
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__4599) {
    var keyvals = cljs.core.seq(arglist__4599);
    return hash_map__delegate.call(this, keyvals)
  };
  return hash_map
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__4600_SHARP_, p2__4601_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____4602 = p1__4600_SHARP_;
          if(cljs.core.truth_(or__3548__auto____4602)) {
            return or__3548__auto____4602
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__4601_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__4603) {
    var maps = cljs.core.seq(arglist__4603);
    return merge__delegate.call(this, maps)
  };
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__4606 = function(m, e) {
        var k__4604 = cljs.core.first.call(null, e);
        var v__4605 = cljs.core.second.call(null, e);
        if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, m, k__4604))) {
          return cljs.core.assoc.call(null, m, k__4604, f.call(null, cljs.core.get.call(null, m, k__4604), v__4605))
        }else {
          return cljs.core.assoc.call(null, m, k__4604, v__4605)
        }
      };
      var merge2__4608 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__4606, function() {
          var or__3548__auto____4607 = m1;
          if(cljs.core.truth_(or__3548__auto____4607)) {
            return or__3548__auto____4607
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__4608, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__4609) {
    var f = cljs.core.first(arglist__4609);
    var maps = cljs.core.rest(arglist__4609);
    return merge_with__delegate.call(this, f, maps)
  };
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__4611 = cljs.core.ObjMap.fromObject([], {});
  var keys__4612 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__4612)) {
      var key__4613 = cljs.core.first.call(null, keys__4612);
      var entry__4614 = cljs.core.get.call(null, map, key__4613, "\ufdd0'user/not-found");
      var G__4615 = cljs.core.truth_(cljs.core.not_EQ_.call(null, entry__4614, "\ufdd0'user/not-found")) ? cljs.core.assoc.call(null, ret__4611, key__4613, entry__4614) : ret__4611;
      var G__4616 = cljs.core.next.call(null, keys__4612);
      ret__4611 = G__4615;
      keys__4612 = G__4616;
      continue
    }else {
      return ret__4611
    }
    break
  }
};
cljs.core.Set = function(meta, hash_map) {
  this.meta = meta;
  this.hash_map = hash_map
};
cljs.core.Set.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Set")
};
cljs.core.Set.prototype.cljs$core$IHash$ = true;
cljs.core.Set.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4617 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Set.prototype.cljs$core$ILookup$ = true;
cljs.core.Set.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4638 = null;
  var G__4638__4639 = function(coll, v) {
    var this__4618 = this;
    return cljs.core._lookup.call(null, coll, v, null)
  };
  var G__4638__4640 = function(coll, v, not_found) {
    var this__4619 = this;
    if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__4619.hash_map, v))) {
      return v
    }else {
      return not_found
    }
  };
  G__4638 = function(coll, v, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4638__4639.call(this, coll, v);
      case 3:
        return G__4638__4640.call(this, coll, v, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4638
}();
cljs.core.Set.prototype.cljs$core$IFn$ = true;
cljs.core.Set.prototype.call = function() {
  var G__4642 = null;
  var G__4642__4643 = function(tsym4620, k) {
    var this__4622 = this;
    var tsym4620__4623 = this;
    var coll__4624 = tsym4620__4623;
    return cljs.core._lookup.call(null, coll__4624, k)
  };
  var G__4642__4644 = function(tsym4621, k, not_found) {
    var this__4625 = this;
    var tsym4621__4626 = this;
    var coll__4627 = tsym4621__4626;
    return cljs.core._lookup.call(null, coll__4627, k, not_found)
  };
  G__4642 = function(tsym4621, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4642__4643.call(this, tsym4621, k);
      case 3:
        return G__4642__4644.call(this, tsym4621, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4642
}();
cljs.core.Set.prototype.cljs$core$ICollection$ = true;
cljs.core.Set.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4628 = this;
  return new cljs.core.Set(this__4628.meta, cljs.core.assoc.call(null, this__4628.hash_map, o, null))
};
cljs.core.Set.prototype.cljs$core$ISeqable$ = true;
cljs.core.Set.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4629 = this;
  return cljs.core.keys.call(null, this__4629.hash_map)
};
cljs.core.Set.prototype.cljs$core$ISet$ = true;
cljs.core.Set.prototype.cljs$core$ISet$_disjoin = function(coll, v) {
  var this__4630 = this;
  return new cljs.core.Set(this__4630.meta, cljs.core.dissoc.call(null, this__4630.hash_map, v))
};
cljs.core.Set.prototype.cljs$core$ICounted$ = true;
cljs.core.Set.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4631 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.Set.prototype.cljs$core$IEquiv$ = true;
cljs.core.Set.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4632 = this;
  var and__3546__auto____4633 = cljs.core.set_QMARK_.call(null, other);
  if(cljs.core.truth_(and__3546__auto____4633)) {
    var and__3546__auto____4634 = cljs.core._EQ_.call(null, cljs.core.count.call(null, coll), cljs.core.count.call(null, other));
    if(cljs.core.truth_(and__3546__auto____4634)) {
      return cljs.core.every_QMARK_.call(null, function(p1__4610_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__4610_SHARP_)
      }, other)
    }else {
      return and__3546__auto____4634
    }
  }else {
    return and__3546__auto____4633
  }
};
cljs.core.Set.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Set.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4635 = this;
  return new cljs.core.Set(meta, this__4635.hash_map)
};
cljs.core.Set.prototype.cljs$core$IMeta$ = true;
cljs.core.Set.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4636 = this;
  return this__4636.meta
};
cljs.core.Set.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Set.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4637 = this;
  return cljs.core.with_meta.call(null, cljs.core.Set.EMPTY, this__4637.meta)
};
cljs.core.Set;
cljs.core.Set.EMPTY = new cljs.core.Set(null, cljs.core.hash_map.call(null));
cljs.core.set = function set(coll) {
  var in$__4647 = cljs.core.seq.call(null, coll);
  var out__4648 = cljs.core.Set.EMPTY;
  while(true) {
    if(cljs.core.truth_(cljs.core.not.call(null, cljs.core.empty_QMARK_.call(null, in$__4647)))) {
      var G__4649 = cljs.core.rest.call(null, in$__4647);
      var G__4650 = cljs.core.conj.call(null, out__4648, cljs.core.first.call(null, in$__4647));
      in$__4647 = G__4649;
      out__4648 = G__4650;
      continue
    }else {
      return out__4648
    }
    break
  }
};
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.truth_(cljs.core.vector_QMARK_.call(null, coll))) {
    var n__4651 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____4652 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____4652)) {
        var e__4653 = temp__3695__auto____4652;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__4653))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__4651, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__4646_SHARP_) {
      var temp__3695__auto____4654 = cljs.core.find.call(null, smap, p1__4646_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____4654)) {
        var e__4655 = temp__3695__auto____4654;
        return cljs.core.second.call(null, e__4655)
      }else {
        return p1__4646_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__4663 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__4656, seen) {
        while(true) {
          var vec__4657__4658 = p__4656;
          var f__4659 = cljs.core.nth.call(null, vec__4657__4658, 0, null);
          var xs__4660 = vec__4657__4658;
          var temp__3698__auto____4661 = cljs.core.seq.call(null, xs__4660);
          if(cljs.core.truth_(temp__3698__auto____4661)) {
            var s__4662 = temp__3698__auto____4661;
            if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, seen, f__4659))) {
              var G__4664 = cljs.core.rest.call(null, s__4662);
              var G__4665 = seen;
              p__4656 = G__4664;
              seen = G__4665;
              continue
            }else {
              return cljs.core.cons.call(null, f__4659, step.call(null, cljs.core.rest.call(null, s__4662), cljs.core.conj.call(null, seen, f__4659)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__4663.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__4666 = cljs.core.PersistentVector.fromArray([]);
  var s__4667 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__4667))) {
      var G__4668 = cljs.core.conj.call(null, ret__4666, cljs.core.first.call(null, s__4667));
      var G__4669 = cljs.core.next.call(null, s__4667);
      ret__4666 = G__4668;
      s__4667 = G__4669;
      continue
    }else {
      return cljs.core.seq.call(null, ret__4666)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.truth_(cljs.core.string_QMARK_.call(null, x))) {
    return x
  }else {
    if(cljs.core.truth_(function() {
      var or__3548__auto____4670 = cljs.core.keyword_QMARK_.call(null, x);
      if(cljs.core.truth_(or__3548__auto____4670)) {
        return or__3548__auto____4670
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }())) {
      var i__4671 = x.lastIndexOf("/");
      if(cljs.core.truth_(i__4671 < 0)) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__4671 + 1)
      }
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        throw new Error(cljs.core.str.call(null, "Doesn't support name: ", x));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(cljs.core.truth_(function() {
    var or__3548__auto____4672 = cljs.core.keyword_QMARK_.call(null, x);
    if(cljs.core.truth_(or__3548__auto____4672)) {
      return or__3548__auto____4672
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }())) {
    var i__4673 = x.lastIndexOf("/");
    if(cljs.core.truth_(i__4673 > -1)) {
      return cljs.core.subs.call(null, x, 2, i__4673)
    }else {
      return null
    }
  }else {
    throw new Error(cljs.core.str.call(null, "Doesn't support namespace: ", x));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__4676 = cljs.core.ObjMap.fromObject([], {});
  var ks__4677 = cljs.core.seq.call(null, keys);
  var vs__4678 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____4679 = ks__4677;
      if(cljs.core.truth_(and__3546__auto____4679)) {
        return vs__4678
      }else {
        return and__3546__auto____4679
      }
    }())) {
      var G__4680 = cljs.core.assoc.call(null, map__4676, cljs.core.first.call(null, ks__4677), cljs.core.first.call(null, vs__4678));
      var G__4681 = cljs.core.next.call(null, ks__4677);
      var G__4682 = cljs.core.next.call(null, vs__4678);
      map__4676 = G__4680;
      ks__4677 = G__4681;
      vs__4678 = G__4682;
      continue
    }else {
      return map__4676
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__4685 = function(k, x) {
    return x
  };
  var max_key__4686 = function(k, x, y) {
    if(cljs.core.truth_(k.call(null, x) > k.call(null, y))) {
      return x
    }else {
      return y
    }
  };
  var max_key__4687 = function() {
    var G__4689__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__4674_SHARP_, p2__4675_SHARP_) {
        return max_key.call(null, k, p1__4674_SHARP_, p2__4675_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__4689 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4689__delegate.call(this, k, x, y, more)
    };
    G__4689.cljs$lang$maxFixedArity = 3;
    G__4689.cljs$lang$applyTo = function(arglist__4690) {
      var k = cljs.core.first(arglist__4690);
      var x = cljs.core.first(cljs.core.next(arglist__4690));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4690)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4690)));
      return G__4689__delegate.call(this, k, x, y, more)
    };
    return G__4689
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__4685.call(this, k, x);
      case 3:
        return max_key__4686.call(this, k, x, y);
      default:
        return max_key__4687.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4687.cljs$lang$applyTo;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__4691 = function(k, x) {
    return x
  };
  var min_key__4692 = function(k, x, y) {
    if(cljs.core.truth_(k.call(null, x) < k.call(null, y))) {
      return x
    }else {
      return y
    }
  };
  var min_key__4693 = function() {
    var G__4695__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__4683_SHARP_, p2__4684_SHARP_) {
        return min_key.call(null, k, p1__4683_SHARP_, p2__4684_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__4695 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4695__delegate.call(this, k, x, y, more)
    };
    G__4695.cljs$lang$maxFixedArity = 3;
    G__4695.cljs$lang$applyTo = function(arglist__4696) {
      var k = cljs.core.first(arglist__4696);
      var x = cljs.core.first(cljs.core.next(arglist__4696));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4696)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4696)));
      return G__4695__delegate.call(this, k, x, y, more)
    };
    return G__4695
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__4691.call(this, k, x);
      case 3:
        return min_key__4692.call(this, k, x, y);
      default:
        return min_key__4693.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4693.cljs$lang$applyTo;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__4699 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__4700 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4697 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4697)) {
        var s__4698 = temp__3698__auto____4697;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__4698), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__4698)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__4699.call(this, n, step);
      case 3:
        return partition_all__4700.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4702 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4702)) {
      var s__4703 = temp__3698__auto____4702;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__4703)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__4703), take_while.call(null, pred, cljs.core.rest.call(null, s__4703)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.Range = function(meta, start, end, step) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step
};
cljs.core.Range.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash = function(rng) {
  var this__4704 = this;
  return cljs.core.hash_coll.call(null, rng)
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj = function(rng, o) {
  var this__4705 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4721 = null;
  var G__4721__4722 = function(rng, f) {
    var this__4706 = this;
    return cljs.core.ci_reduce.call(null, rng, f)
  };
  var G__4721__4723 = function(rng, f, s) {
    var this__4707 = this;
    return cljs.core.ci_reduce.call(null, rng, f, s)
  };
  G__4721 = function(rng, f, s) {
    switch(arguments.length) {
      case 2:
        return G__4721__4722.call(this, rng, f);
      case 3:
        return G__4721__4723.call(this, rng, f, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4721
}();
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq = function(rng) {
  var this__4708 = this;
  var comp__4709 = cljs.core.truth_(this__4708.step > 0) ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__4709.call(null, this__4708.start, this__4708.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count = function(rng) {
  var this__4710 = this;
  if(cljs.core.truth_(cljs.core.not.call(null, cljs.core._seq.call(null, rng)))) {
    return 0
  }else {
    return Math["ceil"].call(null, (this__4710.end - this__4710.start) / this__4710.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first = function(rng) {
  var this__4711 = this;
  return this__4711.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest = function(rng) {
  var this__4712 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__4712.meta, this__4712.start + this__4712.step, this__4712.end, this__4712.step)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv = function(rng, other) {
  var this__4713 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta = function(rng, meta) {
  var this__4714 = this;
  return new cljs.core.Range(meta, this__4714.start, this__4714.end, this__4714.step)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta = function(rng) {
  var this__4715 = this;
  return this__4715.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4725 = null;
  var G__4725__4726 = function(rng, n) {
    var this__4716 = this;
    if(cljs.core.truth_(n < cljs.core._count.call(null, rng))) {
      return this__4716.start + n * this__4716.step
    }else {
      if(cljs.core.truth_(function() {
        var and__3546__auto____4717 = this__4716.start > this__4716.end;
        if(cljs.core.truth_(and__3546__auto____4717)) {
          return cljs.core._EQ_.call(null, this__4716.step, 0)
        }else {
          return and__3546__auto____4717
        }
      }())) {
        return this__4716.start
      }else {
        throw new Error("Index out of bounds");
      }
    }
  };
  var G__4725__4727 = function(rng, n, not_found) {
    var this__4718 = this;
    if(cljs.core.truth_(n < cljs.core._count.call(null, rng))) {
      return this__4718.start + n * this__4718.step
    }else {
      if(cljs.core.truth_(function() {
        var and__3546__auto____4719 = this__4718.start > this__4718.end;
        if(cljs.core.truth_(and__3546__auto____4719)) {
          return cljs.core._EQ_.call(null, this__4718.step, 0)
        }else {
          return and__3546__auto____4719
        }
      }())) {
        return this__4718.start
      }else {
        return not_found
      }
    }
  };
  G__4725 = function(rng, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4725__4726.call(this, rng, n);
      case 3:
        return G__4725__4727.call(this, rng, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4725
}();
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty = function(rng) {
  var this__4720 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__4720.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__4729 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__4730 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__4731 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__4732 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__4729.call(this);
      case 1:
        return range__4730.call(this, start);
      case 2:
        return range__4731.call(this, start, end);
      case 3:
        return range__4732.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4734 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4734)) {
      var s__4735 = temp__3698__auto____4734;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__4735), take_nth.call(null, n, cljs.core.drop.call(null, n, s__4735)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4737 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4737)) {
      var s__4738 = temp__3698__auto____4737;
      var fst__4739 = cljs.core.first.call(null, s__4738);
      var fv__4740 = f.call(null, fst__4739);
      var run__4741 = cljs.core.cons.call(null, fst__4739, cljs.core.take_while.call(null, function(p1__4736_SHARP_) {
        return cljs.core._EQ_.call(null, fv__4740, f.call(null, p1__4736_SHARP_))
      }, cljs.core.next.call(null, s__4738)));
      return cljs.core.cons.call(null, run__4741, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__4741), s__4738))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__4756 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____4752 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____4752)) {
        var s__4753 = temp__3695__auto____4752;
        return reductions.call(null, f, cljs.core.first.call(null, s__4753), cljs.core.rest.call(null, s__4753))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__4757 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4754 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4754)) {
        var s__4755 = temp__3698__auto____4754;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__4755)), cljs.core.rest.call(null, s__4755))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__4756.call(this, f, init);
      case 3:
        return reductions__4757.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__4760 = function(f) {
    return function() {
      var G__4765 = null;
      var G__4765__4766 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__4765__4767 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__4765__4768 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__4765__4769 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__4765__4770 = function() {
        var G__4772__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__4772 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4772__delegate.call(this, x, y, z, args)
        };
        G__4772.cljs$lang$maxFixedArity = 3;
        G__4772.cljs$lang$applyTo = function(arglist__4773) {
          var x = cljs.core.first(arglist__4773);
          var y = cljs.core.first(cljs.core.next(arglist__4773));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4773)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4773)));
          return G__4772__delegate.call(this, x, y, z, args)
        };
        return G__4772
      }();
      G__4765 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__4765__4766.call(this);
          case 1:
            return G__4765__4767.call(this, x);
          case 2:
            return G__4765__4768.call(this, x, y);
          case 3:
            return G__4765__4769.call(this, x, y, z);
          default:
            return G__4765__4770.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4765.cljs$lang$maxFixedArity = 3;
      G__4765.cljs$lang$applyTo = G__4765__4770.cljs$lang$applyTo;
      return G__4765
    }()
  };
  var juxt__4761 = function(f, g) {
    return function() {
      var G__4774 = null;
      var G__4774__4775 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__4774__4776 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__4774__4777 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__4774__4778 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__4774__4779 = function() {
        var G__4781__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__4781 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4781__delegate.call(this, x, y, z, args)
        };
        G__4781.cljs$lang$maxFixedArity = 3;
        G__4781.cljs$lang$applyTo = function(arglist__4782) {
          var x = cljs.core.first(arglist__4782);
          var y = cljs.core.first(cljs.core.next(arglist__4782));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4782)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4782)));
          return G__4781__delegate.call(this, x, y, z, args)
        };
        return G__4781
      }();
      G__4774 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__4774__4775.call(this);
          case 1:
            return G__4774__4776.call(this, x);
          case 2:
            return G__4774__4777.call(this, x, y);
          case 3:
            return G__4774__4778.call(this, x, y, z);
          default:
            return G__4774__4779.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4774.cljs$lang$maxFixedArity = 3;
      G__4774.cljs$lang$applyTo = G__4774__4779.cljs$lang$applyTo;
      return G__4774
    }()
  };
  var juxt__4762 = function(f, g, h) {
    return function() {
      var G__4783 = null;
      var G__4783__4784 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__4783__4785 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__4783__4786 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__4783__4787 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__4783__4788 = function() {
        var G__4790__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__4790 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4790__delegate.call(this, x, y, z, args)
        };
        G__4790.cljs$lang$maxFixedArity = 3;
        G__4790.cljs$lang$applyTo = function(arglist__4791) {
          var x = cljs.core.first(arglist__4791);
          var y = cljs.core.first(cljs.core.next(arglist__4791));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4791)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4791)));
          return G__4790__delegate.call(this, x, y, z, args)
        };
        return G__4790
      }();
      G__4783 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__4783__4784.call(this);
          case 1:
            return G__4783__4785.call(this, x);
          case 2:
            return G__4783__4786.call(this, x, y);
          case 3:
            return G__4783__4787.call(this, x, y, z);
          default:
            return G__4783__4788.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4783.cljs$lang$maxFixedArity = 3;
      G__4783.cljs$lang$applyTo = G__4783__4788.cljs$lang$applyTo;
      return G__4783
    }()
  };
  var juxt__4763 = function() {
    var G__4792__delegate = function(f, g, h, fs) {
      var fs__4759 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__4793 = null;
        var G__4793__4794 = function() {
          return cljs.core.reduce.call(null, function(p1__4742_SHARP_, p2__4743_SHARP_) {
            return cljs.core.conj.call(null, p1__4742_SHARP_, p2__4743_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__4759)
        };
        var G__4793__4795 = function(x) {
          return cljs.core.reduce.call(null, function(p1__4744_SHARP_, p2__4745_SHARP_) {
            return cljs.core.conj.call(null, p1__4744_SHARP_, p2__4745_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__4759)
        };
        var G__4793__4796 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__4746_SHARP_, p2__4747_SHARP_) {
            return cljs.core.conj.call(null, p1__4746_SHARP_, p2__4747_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__4759)
        };
        var G__4793__4797 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__4748_SHARP_, p2__4749_SHARP_) {
            return cljs.core.conj.call(null, p1__4748_SHARP_, p2__4749_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__4759)
        };
        var G__4793__4798 = function() {
          var G__4800__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__4750_SHARP_, p2__4751_SHARP_) {
              return cljs.core.conj.call(null, p1__4750_SHARP_, cljs.core.apply.call(null, p2__4751_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__4759)
          };
          var G__4800 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__4800__delegate.call(this, x, y, z, args)
          };
          G__4800.cljs$lang$maxFixedArity = 3;
          G__4800.cljs$lang$applyTo = function(arglist__4801) {
            var x = cljs.core.first(arglist__4801);
            var y = cljs.core.first(cljs.core.next(arglist__4801));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4801)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4801)));
            return G__4800__delegate.call(this, x, y, z, args)
          };
          return G__4800
        }();
        G__4793 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__4793__4794.call(this);
            case 1:
              return G__4793__4795.call(this, x);
            case 2:
              return G__4793__4796.call(this, x, y);
            case 3:
              return G__4793__4797.call(this, x, y, z);
            default:
              return G__4793__4798.apply(this, arguments)
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__4793.cljs$lang$maxFixedArity = 3;
        G__4793.cljs$lang$applyTo = G__4793__4798.cljs$lang$applyTo;
        return G__4793
      }()
    };
    var G__4792 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4792__delegate.call(this, f, g, h, fs)
    };
    G__4792.cljs$lang$maxFixedArity = 3;
    G__4792.cljs$lang$applyTo = function(arglist__4802) {
      var f = cljs.core.first(arglist__4802);
      var g = cljs.core.first(cljs.core.next(arglist__4802));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4802)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4802)));
      return G__4792__delegate.call(this, f, g, h, fs)
    };
    return G__4792
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__4760.call(this, f);
      case 2:
        return juxt__4761.call(this, f, g);
      case 3:
        return juxt__4762.call(this, f, g, h);
      default:
        return juxt__4763.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4763.cljs$lang$applyTo;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__4804 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__4807 = cljs.core.next.call(null, coll);
        coll = G__4807;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__4805 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____4803 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____4803)) {
          return n > 0
        }else {
          return and__3546__auto____4803
        }
      }())) {
        var G__4808 = n - 1;
        var G__4809 = cljs.core.next.call(null, coll);
        n = G__4808;
        coll = G__4809;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__4804.call(this, n);
      case 2:
        return dorun__4805.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__4810 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__4811 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__4810.call(this, n);
      case 2:
        return doall__4811.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__4813 = re.exec(s);
  if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__4813), s))) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.count.call(null, matches__4813), 1))) {
      return cljs.core.first.call(null, matches__4813)
    }else {
      return cljs.core.vec.call(null, matches__4813)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__4814 = re.exec(s);
  if(cljs.core.truth_(matches__4814 === null)) {
    return null
  }else {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.count.call(null, matches__4814), 1))) {
      return cljs.core.first.call(null, matches__4814)
    }else {
      return cljs.core.vec.call(null, matches__4814)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__4815 = cljs.core.re_find.call(null, re, s);
  var match_idx__4816 = s.search(re);
  var match_str__4817 = cljs.core.truth_(cljs.core.coll_QMARK_.call(null, match_data__4815)) ? cljs.core.first.call(null, match_data__4815) : match_data__4815;
  var post_match__4818 = cljs.core.subs.call(null, s, match_idx__4816 + cljs.core.count.call(null, match_str__4817));
  if(cljs.core.truth_(match_data__4815)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__4815, re_seq.call(null, re, post_match__4818))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__4820__4821 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___4822 = cljs.core.nth.call(null, vec__4820__4821, 0, null);
  var flags__4823 = cljs.core.nth.call(null, vec__4820__4821, 1, null);
  var pattern__4824 = cljs.core.nth.call(null, vec__4820__4821, 2, null);
  return new RegExp(pattern__4824, flags__4823)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__4819_SHARP_) {
    return print_one.call(null, p1__4819_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(cljs.core.truth_(obj === null)) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(cljs.core.truth_(void 0 === obj)) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____4825 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____4825)) {
            var and__3546__auto____4829 = function() {
              var x__451__auto____4826 = obj;
              if(cljs.core.truth_(function() {
                var and__3546__auto____4827 = x__451__auto____4826;
                if(cljs.core.truth_(and__3546__auto____4827)) {
                  var and__3546__auto____4828 = x__451__auto____4826.cljs$core$IMeta$;
                  if(cljs.core.truth_(and__3546__auto____4828)) {
                    return cljs.core.not.call(null, x__451__auto____4826.hasOwnProperty("cljs$core$IMeta$"))
                  }else {
                    return and__3546__auto____4828
                  }
                }else {
                  return and__3546__auto____4827
                }
              }())) {
                return true
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, x__451__auto____4826)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____4829)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____4829
            }
          }else {
            return and__3546__auto____4825
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var x__451__auto____4830 = obj;
          if(cljs.core.truth_(function() {
            var and__3546__auto____4831 = x__451__auto____4830;
            if(cljs.core.truth_(and__3546__auto____4831)) {
              var and__3546__auto____4832 = x__451__auto____4830.cljs$core$IPrintable$;
              if(cljs.core.truth_(and__3546__auto____4832)) {
                return cljs.core.not.call(null, x__451__auto____4830.hasOwnProperty("cljs$core$IPrintable$"))
              }else {
                return and__3546__auto____4832
              }
            }else {
              return and__3546__auto____4831
            }
          }())) {
            return true
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, x__451__auto____4830)
          }
        }()) ? cljs.core._pr_seq.call(null, obj, opts) : cljs.core.list.call(null, "#<", cljs.core.str.call(null, obj), ">"))
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__4833 = cljs.core.first.call(null, objs);
  var sb__4834 = new goog.string.StringBuffer;
  var G__4835__4836 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__4835__4836)) {
    var obj__4837 = cljs.core.first.call(null, G__4835__4836);
    var G__4835__4838 = G__4835__4836;
    while(true) {
      if(cljs.core.truth_(obj__4837 === first_obj__4833)) {
      }else {
        sb__4834.append(" ")
      }
      var G__4839__4840 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__4837, opts));
      if(cljs.core.truth_(G__4839__4840)) {
        var string__4841 = cljs.core.first.call(null, G__4839__4840);
        var G__4839__4842 = G__4839__4840;
        while(true) {
          sb__4834.append(string__4841);
          var temp__3698__auto____4843 = cljs.core.next.call(null, G__4839__4842);
          if(cljs.core.truth_(temp__3698__auto____4843)) {
            var G__4839__4844 = temp__3698__auto____4843;
            var G__4847 = cljs.core.first.call(null, G__4839__4844);
            var G__4848 = G__4839__4844;
            string__4841 = G__4847;
            G__4839__4842 = G__4848;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____4845 = cljs.core.next.call(null, G__4835__4838);
      if(cljs.core.truth_(temp__3698__auto____4845)) {
        var G__4835__4846 = temp__3698__auto____4845;
        var G__4849 = cljs.core.first.call(null, G__4835__4846);
        var G__4850 = G__4835__4846;
        obj__4837 = G__4849;
        G__4835__4838 = G__4850;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__4834
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return cljs.core.str.call(null, cljs.core.pr_sb.call(null, objs, opts))
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__4851 = cljs.core.pr_sb.call(null, objs, opts);
  sb__4851.append("\n");
  return cljs.core.str.call(null, sb__4851)
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__4852 = cljs.core.first.call(null, objs);
  var G__4853__4854 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__4853__4854)) {
    var obj__4855 = cljs.core.first.call(null, G__4853__4854);
    var G__4853__4856 = G__4853__4854;
    while(true) {
      if(cljs.core.truth_(obj__4855 === first_obj__4852)) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__4857__4858 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__4855, opts));
      if(cljs.core.truth_(G__4857__4858)) {
        var string__4859 = cljs.core.first.call(null, G__4857__4858);
        var G__4857__4860 = G__4857__4858;
        while(true) {
          cljs.core.string_print.call(null, string__4859);
          var temp__3698__auto____4861 = cljs.core.next.call(null, G__4857__4860);
          if(cljs.core.truth_(temp__3698__auto____4861)) {
            var G__4857__4862 = temp__3698__auto____4861;
            var G__4865 = cljs.core.first.call(null, G__4857__4862);
            var G__4866 = G__4857__4862;
            string__4859 = G__4865;
            G__4857__4860 = G__4866;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____4863 = cljs.core.next.call(null, G__4853__4856);
      if(cljs.core.truth_(temp__3698__auto____4863)) {
        var G__4853__4864 = temp__3698__auto____4863;
        var G__4867 = cljs.core.first.call(null, G__4853__4864);
        var G__4868 = G__4853__4864;
        obj__4855 = G__4867;
        G__4853__4856 = G__4868;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__4869) {
    var objs = cljs.core.seq(arglist__4869);
    return pr_str__delegate.call(this, objs)
  };
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__4870) {
    var objs = cljs.core.seq(arglist__4870);
    return prn_str__delegate.call(this, objs)
  };
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__4871) {
    var objs = cljs.core.seq(arglist__4871);
    return pr__delegate.call(this, objs)
  };
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__4872) {
    var objs = cljs.core.seq(arglist__4872);
    return cljs_core_print__delegate.call(this, objs)
  };
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__4873) {
    var objs = cljs.core.seq(arglist__4873);
    return print_str__delegate.call(this, objs)
  };
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__4874) {
    var objs = cljs.core.seq(arglist__4874);
    return println__delegate.call(this, objs)
  };
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__4875) {
    var objs = cljs.core.seq(arglist__4875);
    return println_str__delegate.call(this, objs)
  };
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__4876) {
    var objs = cljs.core.seq(arglist__4876);
    return prn__delegate.call(this, objs)
  };
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  var pr_pair__4877 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__4877, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, cljs.core.str.call(null, n))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, cljs.core.str.call(null, bool))
};
cljs.core.Set.prototype.cljs$core$IPrintable$ = true;
cljs.core.Set.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, obj))) {
    return cljs.core.list.call(null, cljs.core.str.call(null, ":", function() {
      var temp__3698__auto____4878 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____4878)) {
        var nspc__4879 = temp__3698__auto____4878;
        return cljs.core.str.call(null, nspc__4879, "/")
      }else {
        return null
      }
    }(), cljs.core.name.call(null, obj)))
  }else {
    if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, obj))) {
      return cljs.core.list.call(null, cljs.core.str.call(null, function() {
        var temp__3698__auto____4880 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____4880)) {
          var nspc__4881 = temp__3698__auto____4880;
          return cljs.core.str.call(null, nspc__4881, "/")
        }else {
          return null
        }
      }(), cljs.core.name.call(null, obj)))
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", cljs.core.str.call(null, this$), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  var pr_pair__4882 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__4882, "{", ", ", "}", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches
};
cljs.core.Atom.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash = function(this$) {
  var this__4883 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches = function(this$, oldval, newval) {
  var this__4884 = this;
  var G__4885__4886 = cljs.core.seq.call(null, this__4884.watches);
  if(cljs.core.truth_(G__4885__4886)) {
    var G__4888__4890 = cljs.core.first.call(null, G__4885__4886);
    var vec__4889__4891 = G__4888__4890;
    var key__4892 = cljs.core.nth.call(null, vec__4889__4891, 0, null);
    var f__4893 = cljs.core.nth.call(null, vec__4889__4891, 1, null);
    var G__4885__4894 = G__4885__4886;
    var G__4888__4895 = G__4888__4890;
    var G__4885__4896 = G__4885__4894;
    while(true) {
      var vec__4897__4898 = G__4888__4895;
      var key__4899 = cljs.core.nth.call(null, vec__4897__4898, 0, null);
      var f__4900 = cljs.core.nth.call(null, vec__4897__4898, 1, null);
      var G__4885__4901 = G__4885__4896;
      f__4900.call(null, key__4899, this$, oldval, newval);
      var temp__3698__auto____4902 = cljs.core.next.call(null, G__4885__4901);
      if(cljs.core.truth_(temp__3698__auto____4902)) {
        var G__4885__4903 = temp__3698__auto____4902;
        var G__4910 = cljs.core.first.call(null, G__4885__4903);
        var G__4911 = G__4885__4903;
        G__4888__4895 = G__4910;
        G__4885__4896 = G__4911;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch = function(this$, key, f) {
  var this__4904 = this;
  return this$.watches = cljs.core.assoc.call(null, this__4904.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch = function(this$, key) {
  var this__4905 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__4905.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq = function(a, opts) {
  var this__4906 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__4906.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta = function(_) {
  var this__4907 = this;
  return this__4907.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref = function(_) {
  var this__4908 = this;
  return this__4908.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv = function(o, other) {
  var this__4909 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__4918 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__4919 = function() {
    var G__4921__delegate = function(x, p__4912) {
      var map__4913__4914 = p__4912;
      var map__4913__4915 = cljs.core.truth_(cljs.core.seq_QMARK_.call(null, map__4913__4914)) ? cljs.core.apply.call(null, cljs.core.hash_map, map__4913__4914) : map__4913__4914;
      var validator__4916 = cljs.core.get.call(null, map__4913__4915, "\ufdd0'validator");
      var meta__4917 = cljs.core.get.call(null, map__4913__4915, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__4917, validator__4916, null)
    };
    var G__4921 = function(x, var_args) {
      var p__4912 = null;
      if(goog.isDef(var_args)) {
        p__4912 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__4921__delegate.call(this, x, p__4912)
    };
    G__4921.cljs$lang$maxFixedArity = 1;
    G__4921.cljs$lang$applyTo = function(arglist__4922) {
      var x = cljs.core.first(arglist__4922);
      var p__4912 = cljs.core.rest(arglist__4922);
      return G__4921__delegate.call(this, x, p__4912)
    };
    return G__4921
  }();
  atom = function(x, var_args) {
    var p__4912 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__4918.call(this, x);
      default:
        return atom__4919.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__4919.cljs$lang$applyTo;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____4923 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____4923)) {
    var validate__4924 = temp__3698__auto____4923;
    if(cljs.core.truth_(validate__4924.call(null, new_value))) {
    }else {
      throw new Error(cljs.core.str.call(null, "Assert failed: ", "Validator rejected reference state", "\n", cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 3282)))));
    }
  }else {
  }
  var old_value__4925 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__4925, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___4926 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___4927 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4928 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___4929 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___4930 = function() {
    var G__4932__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__4932 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__4932__delegate.call(this, a, f, x, y, z, more)
    };
    G__4932.cljs$lang$maxFixedArity = 5;
    G__4932.cljs$lang$applyTo = function(arglist__4933) {
      var a = cljs.core.first(arglist__4933);
      var f = cljs.core.first(cljs.core.next(arglist__4933));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4933)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4933))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4933)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4933)))));
      return G__4932__delegate.call(this, a, f, x, y, z, more)
    };
    return G__4932
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___4926.call(this, a, f);
      case 3:
        return swap_BANG___4927.call(this, a, f, x);
      case 4:
        return swap_BANG___4928.call(this, a, f, x, y);
      case 5:
        return swap_BANG___4929.call(this, a, f, x, y, z);
      default:
        return swap_BANG___4930.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___4930.cljs$lang$applyTo;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, a.state, oldval))) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__4934) {
    var iref = cljs.core.first(arglist__4934);
    var f = cljs.core.first(cljs.core.next(arglist__4934));
    var args = cljs.core.rest(cljs.core.next(arglist__4934));
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__4935 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__4936 = function(prefix_string) {
    if(cljs.core.truth_(cljs.core.gensym_counter === null)) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, cljs.core.str.call(null, prefix_string, cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc)))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__4935.call(this);
      case 1:
        return gensym__4936.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f
};
cljs.core.Delay.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_ = function(d) {
  var this__4938 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__4938.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref = function(_) {
  var this__4939 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__4939.state, function(p__4940) {
    var curr_state__4941 = p__4940;
    var curr_state__4942 = cljs.core.truth_(cljs.core.seq_QMARK_.call(null, curr_state__4941)) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__4941) : curr_state__4941;
    var done__4943 = cljs.core.get.call(null, curr_state__4942, "\ufdd0'done");
    if(cljs.core.truth_(done__4943)) {
      return curr_state__4942
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__4939.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.truth_(cljs.core.delay_QMARK_.call(null, x))) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__4944__4945 = options;
    var map__4944__4946 = cljs.core.truth_(cljs.core.seq_QMARK_.call(null, map__4944__4945)) ? cljs.core.apply.call(null, cljs.core.hash_map, map__4944__4945) : map__4944__4945;
    var keywordize_keys__4947 = cljs.core.get.call(null, map__4944__4946, "\ufdd0'keywordize-keys");
    var keyfn__4948 = cljs.core.truth_(keywordize_keys__4947) ? cljs.core.keyword : cljs.core.str;
    var f__4954 = function thisfn(x) {
      if(cljs.core.truth_(cljs.core.seq_QMARK_.call(null, x))) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.truth_(cljs.core.coll_QMARK_.call(null, x))) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.truth_(goog.isObject.call(null, x))) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__520__auto____4953 = function iter__4949(s__4950) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__4950__4951 = s__4950;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__4950__4951))) {
                        var k__4952 = cljs.core.first.call(null, s__4950__4951);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__4948.call(null, k__4952), thisfn.call(null, x[k__4952])]), iter__4949.call(null, cljs.core.rest.call(null, s__4950__4951)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__520__auto____4953.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if(cljs.core.truth_("\ufdd0'else")) {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__4954.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__4955) {
    var x = cljs.core.first(arglist__4955);
    var options = cljs.core.rest(arglist__4955);
    return js__GT_clj__delegate.call(this, x, options)
  };
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__4956 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__4960__delegate = function(args) {
      var temp__3695__auto____4957 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__4956), args);
      if(cljs.core.truth_(temp__3695__auto____4957)) {
        var v__4958 = temp__3695__auto____4957;
        return v__4958
      }else {
        var ret__4959 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__4956, cljs.core.assoc, args, ret__4959);
        return ret__4959
      }
    };
    var G__4960 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__4960__delegate.call(this, args)
    };
    G__4960.cljs$lang$maxFixedArity = 0;
    G__4960.cljs$lang$applyTo = function(arglist__4961) {
      var args = cljs.core.seq(arglist__4961);
      return G__4960__delegate.call(this, args)
    };
    return G__4960
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__4963 = function(f) {
    while(true) {
      var ret__4962 = f.call(null);
      if(cljs.core.truth_(cljs.core.fn_QMARK_.call(null, ret__4962))) {
        var G__4966 = ret__4962;
        f = G__4966;
        continue
      }else {
        return ret__4962
      }
      break
    }
  };
  var trampoline__4964 = function() {
    var G__4967__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__4967 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__4967__delegate.call(this, f, args)
    };
    G__4967.cljs$lang$maxFixedArity = 1;
    G__4967.cljs$lang$applyTo = function(arglist__4968) {
      var f = cljs.core.first(arglist__4968);
      var args = cljs.core.rest(arglist__4968);
      return G__4967__delegate.call(this, f, args)
    };
    return G__4967
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__4963.call(this, f);
      default:
        return trampoline__4964.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__4964.cljs$lang$applyTo;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__4969 = function() {
    return rand.call(null, 1)
  };
  var rand__4970 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__4969.call(this);
      case 1:
        return rand__4970.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__4972 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__4972, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__4972, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___4981 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___4982 = function(h, child, parent) {
    var or__3548__auto____4973 = cljs.core._EQ_.call(null, child, parent);
    if(cljs.core.truth_(or__3548__auto____4973)) {
      return or__3548__auto____4973
    }else {
      var or__3548__auto____4974 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(cljs.core.truth_(or__3548__auto____4974)) {
        return or__3548__auto____4974
      }else {
        var and__3546__auto____4975 = cljs.core.vector_QMARK_.call(null, parent);
        if(cljs.core.truth_(and__3546__auto____4975)) {
          var and__3546__auto____4976 = cljs.core.vector_QMARK_.call(null, child);
          if(cljs.core.truth_(and__3546__auto____4976)) {
            var and__3546__auto____4977 = cljs.core._EQ_.call(null, cljs.core.count.call(null, parent), cljs.core.count.call(null, child));
            if(cljs.core.truth_(and__3546__auto____4977)) {
              var ret__4978 = true;
              var i__4979 = 0;
              while(true) {
                if(cljs.core.truth_(function() {
                  var or__3548__auto____4980 = cljs.core.not.call(null, ret__4978);
                  if(cljs.core.truth_(or__3548__auto____4980)) {
                    return or__3548__auto____4980
                  }else {
                    return cljs.core._EQ_.call(null, i__4979, cljs.core.count.call(null, parent))
                  }
                }())) {
                  return ret__4978
                }else {
                  var G__4984 = isa_QMARK_.call(null, h, child.call(null, i__4979), parent.call(null, i__4979));
                  var G__4985 = i__4979 + 1;
                  ret__4978 = G__4984;
                  i__4979 = G__4985;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____4977
            }
          }else {
            return and__3546__auto____4976
          }
        }else {
          return and__3546__auto____4975
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___4981.call(this, h, child);
      case 3:
        return isa_QMARK___4982.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__4986 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__4987 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__4986.call(this, h);
      case 2:
        return parents__4987.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__4989 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__4990 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__4989.call(this, h);
      case 2:
        return ancestors__4990.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__4992 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__4993 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__4992.call(this, h);
      case 2:
        return descendants__4993.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__5003 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error(cljs.core.str.call(null, "Assert failed: ", cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 3566)))));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__5004 = function(h, tag, parent) {
    if(cljs.core.truth_(cljs.core.not_EQ_.call(null, tag, parent))) {
    }else {
      throw new Error(cljs.core.str.call(null, "Assert failed: ", cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 3570)))));
    }
    var tp__4998 = "\ufdd0'parents".call(null, h);
    var td__4999 = "\ufdd0'descendants".call(null, h);
    var ta__5000 = "\ufdd0'ancestors".call(null, h);
    var tf__5001 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____5002 = cljs.core.truth_(cljs.core.contains_QMARK_.call(null, tp__4998.call(null, tag), parent)) ? null : function() {
      if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, ta__5000.call(null, tag), parent))) {
        throw new Error(cljs.core.str.call(null, tag, "already has", parent, "as ancestor"));
      }else {
      }
      if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, ta__5000.call(null, parent), tag))) {
        throw new Error(cljs.core.str.call(null, "Cyclic derivation:", parent, "has", tag, "as ancestor"));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__4998, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__5001.call(null, "\ufdd0'ancestors".call(null, h), tag, td__4999, parent, ta__5000), "\ufdd0'descendants":tf__5001.call(null, "\ufdd0'descendants".call(null, h), parent, ta__5000, tag, td__4999)})
    }();
    if(cljs.core.truth_(or__3548__auto____5002)) {
      return or__3548__auto____5002
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__5003.call(this, h, tag);
      case 3:
        return derive__5004.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__5010 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__5011 = function(h, tag, parent) {
    var parentMap__5006 = "\ufdd0'parents".call(null, h);
    var childsParents__5007 = cljs.core.truth_(parentMap__5006.call(null, tag)) ? cljs.core.disj.call(null, parentMap__5006.call(null, tag), parent) : cljs.core.set([]);
    var newParents__5008 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__5007)) ? cljs.core.assoc.call(null, parentMap__5006, tag, childsParents__5007) : cljs.core.dissoc.call(null, parentMap__5006, tag);
    var deriv_seq__5009 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__4995_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__4995_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__4995_SHARP_), cljs.core.second.call(null, p1__4995_SHARP_)))
    }, cljs.core.seq.call(null, newParents__5008)));
    if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, parentMap__5006.call(null, tag), parent))) {
      return cljs.core.reduce.call(null, function(p1__4996_SHARP_, p2__4997_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__4996_SHARP_, p2__4997_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__5009))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__5010.call(this, h, tag);
      case 3:
        return underive__5011.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__5013 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____5015 = cljs.core.truth_(function() {
    var and__3546__auto____5014 = xprefs__5013;
    if(cljs.core.truth_(and__3546__auto____5014)) {
      return xprefs__5013.call(null, y)
    }else {
      return and__3546__auto____5014
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____5015)) {
    return or__3548__auto____5015
  }else {
    var or__3548__auto____5017 = function() {
      var ps__5016 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.truth_(cljs.core.count.call(null, ps__5016) > 0)) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__5016), prefer_table))) {
          }else {
          }
          var G__5020 = cljs.core.rest.call(null, ps__5016);
          ps__5016 = G__5020;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____5017)) {
      return or__3548__auto____5017
    }else {
      var or__3548__auto____5019 = function() {
        var ps__5018 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.truth_(cljs.core.count.call(null, ps__5018) > 0)) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__5018), y, prefer_table))) {
            }else {
            }
            var G__5021 = cljs.core.rest.call(null, ps__5018);
            ps__5018 = G__5021;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____5019)) {
        return or__3548__auto____5019
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____5022 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____5022)) {
    return or__3548__auto____5022
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__5031 = cljs.core.reduce.call(null, function(be, p__5023) {
    var vec__5024__5025 = p__5023;
    var k__5026 = cljs.core.nth.call(null, vec__5024__5025, 0, null);
    var ___5027 = cljs.core.nth.call(null, vec__5024__5025, 1, null);
    var e__5028 = vec__5024__5025;
    if(cljs.core.truth_(cljs.core.isa_QMARK_.call(null, dispatch_val, k__5026))) {
      var be2__5030 = cljs.core.truth_(function() {
        var or__3548__auto____5029 = be === null;
        if(cljs.core.truth_(or__3548__auto____5029)) {
          return or__3548__auto____5029
        }else {
          return cljs.core.dominates.call(null, k__5026, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__5028 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__5030), k__5026, prefer_table))) {
      }else {
        throw new Error(cljs.core.str.call(null, "Multiple methods in multimethod '", name, "' match dispatch value: ", dispatch_val, " -> ", k__5026, " and ", cljs.core.first.call(null, be2__5030), ", and neither is preferred"));
      }
      return be2__5030
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__5031)) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy)))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__5031));
      return cljs.core.second.call(null, best_entry__5031)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5032 = mf;
    if(cljs.core.truth_(and__3546__auto____5032)) {
      return mf.cljs$core$IMultiFn$_reset
    }else {
      return and__3546__auto____5032
    }
  }())) {
    return mf.cljs$core$IMultiFn$_reset(mf)
  }else {
    return function() {
      var or__3548__auto____5033 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5033)) {
        return or__3548__auto____5033
      }else {
        var or__3548__auto____5034 = cljs.core._reset["_"];
        if(cljs.core.truth_(or__3548__auto____5034)) {
          return or__3548__auto____5034
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5035 = mf;
    if(cljs.core.truth_(and__3546__auto____5035)) {
      return mf.cljs$core$IMultiFn$_add_method
    }else {
      return and__3546__auto____5035
    }
  }())) {
    return mf.cljs$core$IMultiFn$_add_method(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____5036 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5036)) {
        return or__3548__auto____5036
      }else {
        var or__3548__auto____5037 = cljs.core._add_method["_"];
        if(cljs.core.truth_(or__3548__auto____5037)) {
          return or__3548__auto____5037
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5038 = mf;
    if(cljs.core.truth_(and__3546__auto____5038)) {
      return mf.cljs$core$IMultiFn$_remove_method
    }else {
      return and__3546__auto____5038
    }
  }())) {
    return mf.cljs$core$IMultiFn$_remove_method(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____5039 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5039)) {
        return or__3548__auto____5039
      }else {
        var or__3548__auto____5040 = cljs.core._remove_method["_"];
        if(cljs.core.truth_(or__3548__auto____5040)) {
          return or__3548__auto____5040
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5041 = mf;
    if(cljs.core.truth_(and__3546__auto____5041)) {
      return mf.cljs$core$IMultiFn$_prefer_method
    }else {
      return and__3546__auto____5041
    }
  }())) {
    return mf.cljs$core$IMultiFn$_prefer_method(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____5042 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5042)) {
        return or__3548__auto____5042
      }else {
        var or__3548__auto____5043 = cljs.core._prefer_method["_"];
        if(cljs.core.truth_(or__3548__auto____5043)) {
          return or__3548__auto____5043
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5044 = mf;
    if(cljs.core.truth_(and__3546__auto____5044)) {
      return mf.cljs$core$IMultiFn$_get_method
    }else {
      return and__3546__auto____5044
    }
  }())) {
    return mf.cljs$core$IMultiFn$_get_method(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____5045 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5045)) {
        return or__3548__auto____5045
      }else {
        var or__3548__auto____5046 = cljs.core._get_method["_"];
        if(cljs.core.truth_(or__3548__auto____5046)) {
          return or__3548__auto____5046
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5047 = mf;
    if(cljs.core.truth_(and__3546__auto____5047)) {
      return mf.cljs$core$IMultiFn$_methods
    }else {
      return and__3546__auto____5047
    }
  }())) {
    return mf.cljs$core$IMultiFn$_methods(mf)
  }else {
    return function() {
      var or__3548__auto____5048 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5048)) {
        return or__3548__auto____5048
      }else {
        var or__3548__auto____5049 = cljs.core._methods["_"];
        if(cljs.core.truth_(or__3548__auto____5049)) {
          return or__3548__auto____5049
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5050 = mf;
    if(cljs.core.truth_(and__3546__auto____5050)) {
      return mf.cljs$core$IMultiFn$_prefers
    }else {
      return and__3546__auto____5050
    }
  }())) {
    return mf.cljs$core$IMultiFn$_prefers(mf)
  }else {
    return function() {
      var or__3548__auto____5051 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5051)) {
        return or__3548__auto____5051
      }else {
        var or__3548__auto____5052 = cljs.core._prefers["_"];
        if(cljs.core.truth_(or__3548__auto____5052)) {
          return or__3548__auto____5052
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5053 = mf;
    if(cljs.core.truth_(and__3546__auto____5053)) {
      return mf.cljs$core$IMultiFn$_dispatch
    }else {
      return and__3546__auto____5053
    }
  }())) {
    return mf.cljs$core$IMultiFn$_dispatch(mf, args)
  }else {
    return function() {
      var or__3548__auto____5054 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5054)) {
        return or__3548__auto____5054
      }else {
        var or__3548__auto____5055 = cljs.core._dispatch["_"];
        if(cljs.core.truth_(or__3548__auto____5055)) {
          return or__3548__auto____5055
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__5056 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__5057 = cljs.core._get_method.call(null, mf, dispatch_val__5056);
  if(cljs.core.truth_(target_fn__5057)) {
  }else {
    throw new Error(cljs.core.str.call(null, "No method in multimethod '", cljs.core.name, "' for dispatch value: ", dispatch_val__5056));
  }
  return cljs.core.apply.call(null, target_fn__5057, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy
};
cljs.core.MultiFn.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash = function(this$) {
  var this__5058 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset = function(mf) {
  var this__5059 = this;
  cljs.core.swap_BANG_.call(null, this__5059.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__5059.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__5059.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__5059.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method = function(mf, dispatch_val, method) {
  var this__5060 = this;
  cljs.core.swap_BANG_.call(null, this__5060.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__5060.method_cache, this__5060.method_table, this__5060.cached_hierarchy, this__5060.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method = function(mf, dispatch_val) {
  var this__5061 = this;
  cljs.core.swap_BANG_.call(null, this__5061.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__5061.method_cache, this__5061.method_table, this__5061.cached_hierarchy, this__5061.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method = function(mf, dispatch_val) {
  var this__5062 = this;
  if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__5062.cached_hierarchy), cljs.core.deref.call(null, this__5062.hierarchy)))) {
  }else {
    cljs.core.reset_cache.call(null, this__5062.method_cache, this__5062.method_table, this__5062.cached_hierarchy, this__5062.hierarchy)
  }
  var temp__3695__auto____5063 = cljs.core.deref.call(null, this__5062.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____5063)) {
    var target_fn__5064 = temp__3695__auto____5063;
    return target_fn__5064
  }else {
    var temp__3695__auto____5065 = cljs.core.find_and_cache_best_method.call(null, this__5062.name, dispatch_val, this__5062.hierarchy, this__5062.method_table, this__5062.prefer_table, this__5062.method_cache, this__5062.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____5065)) {
      var target_fn__5066 = temp__3695__auto____5065;
      return target_fn__5066
    }else {
      return cljs.core.deref.call(null, this__5062.method_table).call(null, this__5062.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__5067 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__5067.prefer_table))) {
    throw new Error(cljs.core.str.call(null, "Preference conflict in multimethod '", this__5067.name, "': ", dispatch_val_y, " is already preferred to ", dispatch_val_x));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__5067.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__5067.method_cache, this__5067.method_table, this__5067.cached_hierarchy, this__5067.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods = function(mf) {
  var this__5068 = this;
  return cljs.core.deref.call(null, this__5068.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers = function(mf) {
  var this__5069 = this;
  return cljs.core.deref.call(null, this__5069.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch = function(mf, args) {
  var this__5070 = this;
  return cljs.core.do_dispatch.call(null, mf, this__5070.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__5071__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__5071 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__5071__delegate.call(this, _, args)
  };
  G__5071.cljs$lang$maxFixedArity = 1;
  G__5071.cljs$lang$applyTo = function(arglist__5072) {
    var _ = cljs.core.first(arglist__5072);
    var args = cljs.core.rest(arglist__5072);
    return G__5071__delegate.call(this, _, args)
  };
  return G__5071
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5074 = reader;
    if(cljs.core.truth_(and__3546__auto____5074)) {
      return reader.cljs$reader$PushbackReader$read_char
    }else {
      return and__3546__auto____5074
    }
  }())) {
    return reader.cljs$reader$PushbackReader$read_char(reader)
  }else {
    return function() {
      var or__3548__auto____5075 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(cljs.core.truth_(or__3548__auto____5075)) {
        return or__3548__auto____5075
      }else {
        var or__3548__auto____5076 = cljs.reader.read_char["_"];
        if(cljs.core.truth_(or__3548__auto____5076)) {
          return or__3548__auto____5076
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5077 = reader;
    if(cljs.core.truth_(and__3546__auto____5077)) {
      return reader.cljs$reader$PushbackReader$unread
    }else {
      return and__3546__auto____5077
    }
  }())) {
    return reader.cljs$reader$PushbackReader$unread(reader, ch)
  }else {
    return function() {
      var or__3548__auto____5078 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(cljs.core.truth_(or__3548__auto____5078)) {
        return or__3548__auto____5078
      }else {
        var or__3548__auto____5079 = cljs.reader.unread["_"];
        if(cljs.core.truth_(or__3548__auto____5079)) {
          return or__3548__auto____5079
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char = function(reader) {
  var this__5080 = this;
  if(cljs.core.truth_(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__5080.buffer_atom)))) {
    var idx__5081 = cljs.core.deref.call(null, this__5080.index_atom);
    cljs.core.swap_BANG_.call(null, this__5080.index_atom, cljs.core.inc);
    return cljs.core.nth.call(null, this__5080.s, idx__5081)
  }else {
    var buf__5082 = cljs.core.deref.call(null, this__5080.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__5080.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__5082)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread = function(reader, ch) {
  var this__5083 = this;
  return cljs.core.swap_BANG_.call(null, this__5083.buffer_atom, function(p1__5073_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__5073_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____5084 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____5084)) {
    return or__3548__auto____5084
  }else {
    return cljs.core._EQ_.call(null, ",", ch)
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return cljs.core._EQ_.call(null, ";", ch)
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____5085 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(cljs.core.truth_(or__3548__auto____5085)) {
    return or__3548__auto____5085
  }else {
    var and__3546__auto____5087 = function() {
      var or__3548__auto____5086 = cljs.core._EQ_.call(null, "+", initch);
      if(cljs.core.truth_(or__3548__auto____5086)) {
        return or__3548__auto____5086
      }else {
        return cljs.core._EQ_.call(null, "-", initch)
      }
    }();
    if(cljs.core.truth_(and__3546__auto____5087)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__5088 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__5088);
        return next_ch__5088
      }())
    }else {
      return and__3546__auto____5087
    }
  }
};
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__5089) {
    var rdr = cljs.core.first(arglist__5089);
    var msg = cljs.core.rest(arglist__5089);
    return reader_error__delegate.call(this, rdr, msg)
  };
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____5090 = cljs.core.not_EQ_.call(null, ch, "#");
  if(cljs.core.truth_(and__3546__auto____5090)) {
    var and__3546__auto____5091 = cljs.core.not_EQ_.call(null, ch, "'");
    if(cljs.core.truth_(and__3546__auto____5091)) {
      var and__3546__auto____5092 = cljs.core.not_EQ_.call(null, ch, ":");
      if(cljs.core.truth_(and__3546__auto____5092)) {
        return cljs.core.contains_QMARK_.call(null, cljs.reader.macros, ch)
      }else {
        return and__3546__auto____5092
      }
    }else {
      return and__3546__auto____5091
    }
  }else {
    return and__3546__auto____5090
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__5093 = new goog.string.StringBuffer(initch);
  var ch__5094 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____5095 = ch__5094 === null;
      if(cljs.core.truth_(or__3548__auto____5095)) {
        return or__3548__auto____5095
      }else {
        var or__3548__auto____5096 = cljs.reader.whitespace_QMARK_.call(null, ch__5094);
        if(cljs.core.truth_(or__3548__auto____5096)) {
          return or__3548__auto____5096
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__5094)
        }
      }
    }())) {
      cljs.reader.unread.call(null, rdr, ch__5094);
      return sb__5093.toString()
    }else {
      var G__5097 = function() {
        sb__5093.append(ch__5094);
        return sb__5093
      }();
      var G__5098 = cljs.reader.read_char.call(null, rdr);
      sb__5093 = G__5097;
      ch__5094 = G__5098;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__5099 = cljs.reader.read_char.call(null, reader);
    if(cljs.core.truth_(function() {
      var or__3548__auto____5100 = cljs.core._EQ_.call(null, ch__5099, "n");
      if(cljs.core.truth_(or__3548__auto____5100)) {
        return or__3548__auto____5100
      }else {
        var or__3548__auto____5101 = cljs.core._EQ_.call(null, ch__5099, "r");
        if(cljs.core.truth_(or__3548__auto____5101)) {
          return or__3548__auto____5101
        }else {
          return ch__5099 === null
        }
      }
    }())) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.match_int = function match_int(s) {
  var groups__5102 = cljs.core.re_find.call(null, cljs.reader.int_pattern, s);
  var group3__5103 = cljs.core.nth.call(null, groups__5102, 2);
  if(cljs.core.truth_(cljs.core.not.call(null, function() {
    var or__3548__auto____5104 = void 0 === group3__5103;
    if(cljs.core.truth_(or__3548__auto____5104)) {
      return or__3548__auto____5104
    }else {
      return group3__5103.length < 1
    }
  }()))) {
    return 0
  }else {
    var negate__5106 = cljs.core.truth_(cljs.core._EQ_.call(null, "-", cljs.core.nth.call(null, groups__5102, 1))) ? -1 : 1;
    var vec__5105__5107 = cljs.core.truth_(cljs.core.nth.call(null, groups__5102, 3)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__5102, 3), 10]) : cljs.core.truth_(cljs.core.nth.call(null, groups__5102, 4)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__5102, 4), 16]) : cljs.core.truth_(cljs.core.nth.call(null, groups__5102, 5)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__5102, 5), 8]) : cljs.core.truth_(cljs.core.nth.call(null, 
    groups__5102, 7)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__5102, 7), parseInt.call(null, cljs.core.nth.call(null, groups__5102, 7))]) : cljs.core.truth_("\ufdd0'default") ? cljs.core.PersistentVector.fromArray([null, null]) : null;
    var n__5108 = cljs.core.nth.call(null, vec__5105__5107, 0, null);
    var radix__5109 = cljs.core.nth.call(null, vec__5105__5107, 1, null);
    if(cljs.core.truth_(n__5108 === null)) {
      return null
    }else {
      return negate__5106 * parseInt.call(null, n__5108, radix__5109)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__5110 = cljs.core.re_find.call(null, cljs.reader.ratio_pattern, s);
  var numinator__5111 = cljs.core.nth.call(null, groups__5110, 1);
  var denominator__5112 = cljs.core.nth.call(null, groups__5110, 2);
  return parseInt.call(null, numinator__5111) / parseInt.call(null, denominator__5112)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat.call(null, s)
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.core.re_matches.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.core.re_matches.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.core.re_matches.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = cljs.core.HashMap.fromArrays(["t", "r", "n", "\\", '"', "b", "f"], ["\t", "\r", "\n", "\\", '"', "\u0008", "\u000c"]);
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__5113 = cljs.reader.read_char.call(null, reader);
  var mapresult__5114 = cljs.core.get.call(null, cljs.reader.escape_char_map, ch__5113);
  if(cljs.core.truth_(mapresult__5114)) {
    return mapresult__5114
  }else {
    if(cljs.core.truth_(function() {
      var or__3548__auto____5115 = cljs.core._EQ_.call(null, "u", ch__5113);
      if(cljs.core.truth_(or__3548__auto____5115)) {
        return or__3548__auto____5115
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__5113)
      }
    }())) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__5113)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape charater: \\", ch__5113)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__5116 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__5116))) {
      var G__5117 = cljs.reader.read_char.call(null, rdr);
      ch__5116 = G__5117;
      continue
    }else {
      return ch__5116
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__5118 = cljs.core.PersistentVector.fromArray([]);
  while(true) {
    var ch__5119 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__5119)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(cljs.core.truth_(cljs.core._EQ_.call(null, delim, ch__5119))) {
      return a__5118
    }else {
      var temp__3695__auto____5120 = cljs.core.get.call(null, cljs.reader.macros, ch__5119);
      if(cljs.core.truth_(temp__3695__auto____5120)) {
        var macrofn__5121 = temp__3695__auto____5120;
        var mret__5122 = macrofn__5121.call(null, rdr, ch__5119);
        var G__5124 = cljs.core.truth_(cljs.core._EQ_.call(null, mret__5122, rdr)) ? a__5118 : cljs.core.conj.call(null, a__5118, mret__5122);
        a__5118 = G__5124;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__5119);
        var o__5123 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__5125 = cljs.core.truth_(cljs.core._EQ_.call(null, o__5123, rdr)) ? a__5118 : cljs.core.conj.call(null, a__5118, o__5123);
        a__5118 = G__5125;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__5126 = cljs.reader.read_char.call(null, rdr);
  var dm__5127 = cljs.core.get.call(null, cljs.reader.dispatch_macros, ch__5126);
  if(cljs.core.truth_(dm__5127)) {
    return dm__5127.call(null, rdr, _)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__5126)
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__5128 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.truth_(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__5128)))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__5128)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__5129 = new goog.string.StringBuffer(initch);
  var ch__5130 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____5131 = ch__5130 === null;
      if(cljs.core.truth_(or__3548__auto____5131)) {
        return or__3548__auto____5131
      }else {
        var or__3548__auto____5132 = cljs.reader.whitespace_QMARK_.call(null, ch__5130);
        if(cljs.core.truth_(or__3548__auto____5132)) {
          return or__3548__auto____5132
        }else {
          return cljs.core.contains_QMARK_.call(null, cljs.reader.macros, ch__5130)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__5130);
      var s__5133 = buffer__5129.toString();
      var or__3548__auto____5134 = cljs.reader.match_number.call(null, s__5133);
      if(cljs.core.truth_(or__3548__auto____5134)) {
        return or__3548__auto____5134
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__5133, "]")
      }
    }else {
      var G__5135 = function() {
        buffer__5129.append(ch__5130);
        return buffer__5129
      }();
      var G__5136 = cljs.reader.read_char.call(null, reader);
      buffer__5129 = G__5135;
      ch__5130 = G__5136;
      continue
    }
    break
  }
};
cljs.reader.read_string = function read_string(reader, _) {
  var buffer__5137 = new goog.string.StringBuffer;
  var ch__5138 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(ch__5138 === null)) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if(cljs.core.truth_(cljs.core._EQ_.call(null, "\\", ch__5138))) {
        var G__5139 = function() {
          buffer__5137.append(cljs.reader.escape_char.call(null, buffer__5137, reader));
          return buffer__5137
        }();
        var G__5140 = cljs.reader.read_char.call(null, reader);
        buffer__5137 = G__5139;
        ch__5138 = G__5140;
        continue
      }else {
        if(cljs.core.truth_(cljs.core._EQ_.call(null, '"', ch__5138))) {
          return buffer__5137.toString()
        }else {
          if(cljs.core.truth_("\ufdd0'default")) {
            var G__5141 = function() {
              buffer__5137.append(ch__5138);
              return buffer__5137
            }();
            var G__5142 = cljs.reader.read_char.call(null, reader);
            buffer__5137 = G__5141;
            ch__5138 = G__5142;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__5143 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__5143, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__5143, 0, token__5143.indexOf("/")), cljs.core.subs.call(null, token__5143, token__5143.indexOf("/") + 1, token__5143.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__5143, cljs.core.symbol.call(null, token__5143))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__5145 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var vec__5144__5146 = cljs.core.re_matches.call(null, cljs.reader.symbol_pattern, token__5145);
  var token__5147 = cljs.core.nth.call(null, vec__5144__5146, 0, null);
  var ns__5148 = cljs.core.nth.call(null, vec__5144__5146, 1, null);
  var name__5149 = cljs.core.nth.call(null, vec__5144__5146, 2, null);
  if(cljs.core.truth_(function() {
    var or__3548__auto____5151 = function() {
      var and__3546__auto____5150 = cljs.core.not.call(null, void 0 === ns__5148);
      if(cljs.core.truth_(and__3546__auto____5150)) {
        return ns__5148.substring(ns__5148.length - 2, ns__5148.length) === ":/"
      }else {
        return and__3546__auto____5150
      }
    }();
    if(cljs.core.truth_(or__3548__auto____5151)) {
      return or__3548__auto____5151
    }else {
      var or__3548__auto____5152 = name__5149[name__5149.length - 1] === ":";
      if(cljs.core.truth_(or__3548__auto____5152)) {
        return or__3548__auto____5152
      }else {
        return cljs.core.not.call(null, token__5147.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__5147)
  }else {
    if(cljs.core.truth_(cljs.reader.ns_QMARK_)) {
      return cljs.core.keyword.call(null, ns__5148.substring(0, ns__5148.indexOf("/")), name__5149)
    }else {
      return cljs.core.keyword.call(null, token__5147)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, f))) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.truth_(cljs.core.string_QMARK_.call(null, f))) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, f))) {
        return cljs.core.HashMap.fromArrays([f], [true])
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__5153 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.truth_(cljs.core.map_QMARK_.call(null, m__5153))) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__5154 = cljs.reader.read.call(null, rdr, true, null, true);
  if(cljs.core.truth_(function() {
    var x__451__auto____5155 = o__5154;
    if(cljs.core.truth_(function() {
      var and__3546__auto____5156 = x__451__auto____5155;
      if(cljs.core.truth_(and__3546__auto____5156)) {
        var and__3546__auto____5157 = x__451__auto____5155.cljs$core$IWithMeta$;
        if(cljs.core.truth_(and__3546__auto____5157)) {
          return cljs.core.not.call(null, x__451__auto____5155.hasOwnProperty("cljs$core$IWithMeta$"))
        }else {
          return and__3546__auto____5157
        }
      }else {
        return and__3546__auto____5156
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, x__451__auto____5155)
    }
  }())) {
    return cljs.core.with_meta.call(null, o__5154, cljs.core.merge.call(null, cljs.core.meta.call(null, o__5154), m__5153))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = cljs.core.HashMap.fromArrays(["@", "`", '"', "#", "%", "'", "(", ")", ":", ";", "[", "{", "\\", "]", "}", "^", "~"], [cljs.reader.wrapping_reader.call(null, "\ufdd1'deref"), cljs.reader.not_implemented, cljs.reader.read_string, cljs.reader.read_dispatch, cljs.reader.not_implemented, cljs.reader.wrapping_reader.call(null, "\ufdd1'quote"), cljs.reader.read_list, cljs.reader.read_unmatched_delimiter, cljs.reader.read_keyword, cljs.reader.not_implemented, cljs.reader.read_vector, 
cljs.reader.read_map, cljs.reader.read_char, cljs.reader.read_unmatched_delimiter, cljs.reader.read_unmatched_delimiter, cljs.reader.read_meta, cljs.reader.not_implemented]);
cljs.reader.dispatch_macros = cljs.core.ObjMap.fromObject(["{", "<", '"', "!", "_"], {"{":cljs.reader.read_set, "<":cljs.reader.throwing_reader.call(null, "Unreadable form"), '"':cljs.reader.read_regex, "!":cljs.reader.read_comment, "_":cljs.reader.read_discard});
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__5158 = cljs.reader.read_char.call(null, reader);
    if(cljs.core.truth_(ch__5158 === null)) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.core.truth_(cljs.reader.whitespace_QMARK_.call(null, ch__5158))) {
        var G__5160 = reader;
        var G__5161 = eof_is_error;
        var G__5162 = sentinel;
        var G__5163 = is_recursive;
        reader = G__5160;
        eof_is_error = G__5161;
        sentinel = G__5162;
        is_recursive = G__5163;
        continue
      }else {
        if(cljs.core.truth_(cljs.reader.comment_prefix_QMARK_.call(null, ch__5158))) {
          var G__5164 = cljs.reader.read_comment.call(null, reader, ch__5158);
          var G__5165 = eof_is_error;
          var G__5166 = sentinel;
          var G__5167 = is_recursive;
          reader = G__5164;
          eof_is_error = G__5165;
          sentinel = G__5166;
          is_recursive = G__5167;
          continue
        }else {
          if(cljs.core.truth_("\ufdd0'else")) {
            var res__5159 = cljs.core.truth_(cljs.reader.macros.call(null, ch__5158)) ? cljs.reader.macros.call(null, ch__5158).call(null, reader, ch__5158) : cljs.core.truth_(cljs.reader.number_literal_QMARK_.call(null, reader, ch__5158)) ? cljs.reader.read_number.call(null, reader, ch__5158) : cljs.core.truth_("\ufdd0'else") ? cljs.reader.read_symbol.call(null, reader, ch__5158) : null;
            if(cljs.core.truth_(cljs.core._EQ_.call(null, res__5159, reader))) {
              var G__5168 = reader;
              var G__5169 = eof_is_error;
              var G__5170 = sentinel;
              var G__5171 = is_recursive;
              reader = G__5168;
              eof_is_error = G__5169;
              sentinel = G__5170;
              is_recursive = G__5171;
              continue
            }else {
              return res__5159
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__5172 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__5172, true, null, false)
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.truth_(cljs.core.string_QMARK_.call(null, match))) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        throw cljs.core.str.call(null, "Invalid match arg: ", match);
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__5277 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__5278 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__5277.call(this, separator);
      case 2:
        return join__5278.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.truth_(cljs.core.count.call(null, s) < 2)) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return cljs.core.str.call(null, clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1)), clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))
  }
};
clojure.string.split = function() {
  var split = null;
  var split__5286 = function(s, re) {
    return cljs.core.vec.call(null, cljs.core.str.call(null, s).split(re))
  };
  var split__5287 = function(s, re, limit) {
    if(cljs.core.truth_(limit < 1)) {
      return cljs.core.vec.call(null, cljs.core.str.call(null, s).split(re))
    }else {
      var s__5280 = s;
      var limit__5281 = limit;
      var parts__5282 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core.truth_(cljs.core._EQ_.call(null, limit__5281, 1))) {
          return cljs.core.conj.call(null, parts__5282, s__5280)
        }else {
          var temp__3695__auto____5283 = cljs.core.re_find.call(null, re, s__5280);
          if(cljs.core.truth_(temp__3695__auto____5283)) {
            var m__5284 = temp__3695__auto____5283;
            var index__5285 = s__5280.indexOf(m__5284);
            var G__5289 = s__5280.substring(index__5285 + cljs.core.count.call(null, m__5284));
            var G__5290 = limit__5281 - 1;
            var G__5291 = cljs.core.conj.call(null, parts__5282, s__5280.substring(0, index__5285));
            s__5280 = G__5289;
            limit__5281 = G__5290;
            parts__5282 = G__5291;
            continue
          }else {
            return cljs.core.conj.call(null, parts__5282, s__5280)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__5286.call(this, s, re);
      case 3:
        return split__5287.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__5292 = s.length;
  while(true) {
    if(cljs.core.truth_(index__5292 === 0)) {
      return""
    }else {
      var ch__5293 = cljs.core.get.call(null, s, index__5292 - 1);
      if(cljs.core.truth_(function() {
        var or__3548__auto____5294 = cljs.core._EQ_.call(null, ch__5293, "\n");
        if(cljs.core.truth_(or__3548__auto____5294)) {
          return or__3548__auto____5294
        }else {
          return cljs.core._EQ_.call(null, ch__5293, "\r")
        }
      }())) {
        var G__5295 = index__5292 - 1;
        index__5292 = G__5295;
        continue
      }else {
        return s.substring(0, index__5292)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__5296 = cljs.core.str.call(null, s);
  if(cljs.core.truth_(function() {
    var or__3548__auto____5297 = cljs.core.not.call(null, s__5296);
    if(cljs.core.truth_(or__3548__auto____5297)) {
      return or__3548__auto____5297
    }else {
      var or__3548__auto____5298 = cljs.core._EQ_.call(null, "", s__5296);
      if(cljs.core.truth_(or__3548__auto____5298)) {
        return or__3548__auto____5298
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__5296)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__5299 = new goog.string.StringBuffer;
  var length__5300 = s.length;
  var index__5301 = 0;
  while(true) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, length__5300, index__5301))) {
      return buffer__5299.toString()
    }else {
      var ch__5302 = s.charAt(index__5301);
      var temp__3695__auto____5303 = cljs.core.get.call(null, cmap, ch__5302);
      if(cljs.core.truth_(temp__3695__auto____5303)) {
        var replacement__5304 = temp__3695__auto____5303;
        buffer__5299.append(cljs.core.str.call(null, replacement__5304))
      }else {
        buffer__5299.append(ch__5302)
      }
      var G__5305 = index__5301 + 1;
      index__5301 = G__5305;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__5248 = cljs.core.js_obj.call(null);
  var G__5249__5250 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__5249__5250)) {
    var G__5252__5254 = cljs.core.first.call(null, G__5249__5250);
    var vec__5253__5255 = G__5252__5254;
    var k__5256 = cljs.core.nth.call(null, vec__5253__5255, 0, null);
    var v__5257 = cljs.core.nth.call(null, vec__5253__5255, 1, null);
    var G__5249__5258 = G__5249__5250;
    var G__5252__5259 = G__5252__5254;
    var G__5249__5260 = G__5249__5258;
    while(true) {
      var vec__5261__5262 = G__5252__5259;
      var k__5263 = cljs.core.nth.call(null, vec__5261__5262, 0, null);
      var v__5264 = cljs.core.nth.call(null, vec__5261__5262, 1, null);
      var G__5249__5265 = G__5249__5260;
      out__5248[cljs.core.name.call(null, k__5263)] = v__5264;
      var temp__3698__auto____5266 = cljs.core.next.call(null, G__5249__5265);
      if(cljs.core.truth_(temp__3698__auto____5266)) {
        var G__5249__5267 = temp__3698__auto____5266;
        var G__5268 = cljs.core.first.call(null, G__5249__5267);
        var G__5269 = G__5249__5267;
        G__5252__5259 = G__5268;
        G__5249__5260 = G__5269;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__5248
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__5270 = cljs.core.truth_(cljs.core.string_QMARK_.call(null, v)) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__5270)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__5271) {
    var v = cljs.core.first(arglist__5271);
    var text = cljs.core.rest(arglist__5271);
    return log__delegate.call(this, v, text)
  };
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.truth_(cljs.core.string_QMARK_.call(null, x))) {
    return x
  }else {
    if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, x))) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.truth_(cljs.core.map_QMARK_.call(null, x))) {
        return cljs.core.reduce.call(null, function(m, p__5272) {
          var vec__5273__5274 = p__5272;
          var k__5275 = cljs.core.nth.call(null, vec__5273__5274, 0, null);
          var v__5276 = cljs.core.nth.call(null, vec__5273__5274, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__5275), clj__GT_js.call(null, v__5276))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.truth_(cljs.core.coll_QMARK_.call(null, x))) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if(cljs.core.truth_("\ufdd0'else")) {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.truth_(cljs.core.string_QMARK_.call(null, sel))) {
    return sel
  }else {
    if(cljs.core.truth_(cljs.core.fn_QMARK_.call(null, sel))) {
      return cljs.core.str.call(null, "[crateGroup=", jayq.core.crate_meta.call(null, sel), "]")
    }else {
      if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, sel))) {
        return cljs.core.name.call(null, sel)
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__5173) {
    var vec__5174__5175 = p__5173;
    var context__5176 = cljs.core.nth.call(null, vec__5174__5175, 0, null);
    if(cljs.core.truth_(cljs.core.not.call(null, context__5176))) {
      return jQuery.call(null, jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery.call(null, jayq.core.__GT_selector.call(null, sel), context__5176)
    }
  };
  var $ = function(sel, var_args) {
    var p__5173 = null;
    if(goog.isDef(var_args)) {
      p__5173 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__5173)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__5177) {
    var sel = cljs.core.first(arglist__5177);
    var p__5173 = cljs.core.rest(arglist__5177);
    return $__delegate.call(this, sel, p__5173)
  };
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce = function(this$, f) {
  return cljs.core.ci_reduce.call(null, jayq.core.coll, f, cljs.core.first.call(null, this$), cljs.core.count.call(null, this$))
};
jQuery.prototype.cljs$core$IReduce$_reduce = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, jayq.core.coll, f, start, jayq.core.i)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup = function() {
  var G__5179 = null;
  var G__5179__5180 = function(this$, k) {
    var or__3548__auto____5178 = this$.slice(k, k + 1);
    if(cljs.core.truth_(or__3548__auto____5178)) {
      return or__3548__auto____5178
    }else {
      return null
    }
  };
  var G__5179__5181 = function(this$, k, not_found) {
    return cljs.core._nth.call(null, this$, k, not_found)
  };
  G__5179 = function(this$, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5179__5180.call(this, this$, k);
      case 3:
        return G__5179__5181.call(this, this$, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5179
}();
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth = function(this$, n) {
  if(cljs.core.truth_(n < cljs.core.count.call(null, this$))) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth = function(this$, n, not_found) {
  if(cljs.core.truth_(n < cljs.core.count.call(null, this$))) {
    return this$.slice(n, n + 1)
  }else {
    if(cljs.core.truth_(void 0 === not_found)) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first = function(this$) {
  return this$.slice(0, 1)
};
jQuery.prototype.cljs$core$ISeq$_rest = function(this$) {
  if(cljs.core.truth_(cljs.core.count.call(null, this$) > 1)) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__5183 = null;
  var G__5183__5184 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__5183__5185 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__5183 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5183__5184.call(this, _, k);
      case 3:
        return G__5183__5185.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5183
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.map__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, opts))) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.map__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__5187) {
    var vec__5188__5189 = p__5187;
    var v__5190 = cljs.core.nth.call(null, vec__5188__5189, 0, null);
    var a__5191 = cljs.core.name.call(null, a);
    if(cljs.core.truth_(cljs.core.not.call(null, v__5190))) {
      return $elem.attr(a__5191)
    }else {
      return $elem.attr(a__5191, v__5190)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__5187 = null;
    if(goog.isDef(var_args)) {
      p__5187 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__5187)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__5192) {
    var $elem = cljs.core.first(arglist__5192);
    var a = cljs.core.first(cljs.core.next(arglist__5192));
    var p__5187 = cljs.core.rest(cljs.core.next(arglist__5192));
    return attr__delegate.call(this, $elem, a, p__5187)
  };
  return attr
}();
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__5193) {
    var vec__5194__5195 = p__5193;
    var v__5196 = cljs.core.nth.call(null, vec__5194__5195, 0, null);
    var k__5197 = cljs.core.name.call(null, k);
    if(cljs.core.truth_(cljs.core.not.call(null, v__5196))) {
      return $elem.data(k__5197)
    }else {
      return $elem.data(k__5197, v__5196)
    }
  };
  var data = function($elem, k, var_args) {
    var p__5193 = null;
    if(goog.isDef(var_args)) {
      p__5193 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__5193)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__5198) {
    var $elem = cljs.core.first(arglist__5198);
    var k = cljs.core.first(cljs.core.next(arglist__5198));
    var p__5193 = cljs.core.rest(cljs.core.next(arglist__5198));
    return data__delegate.call(this, $elem, k, p__5193)
  };
  return data
}();
jayq.core.add_class = function add_class($elem, cl) {
  var cl__5199 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__5199)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__5200 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__5200)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__5201) {
    var vec__5202__5203 = p__5201;
    var speed__5204 = cljs.core.nth.call(null, vec__5202__5203, 0, null);
    var on_finish__5205 = cljs.core.nth.call(null, vec__5202__5203, 1, null);
    return $elem.hide(speed__5204, on_finish__5205)
  };
  var hide = function($elem, var_args) {
    var p__5201 = null;
    if(goog.isDef(var_args)) {
      p__5201 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__5201)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__5206) {
    var $elem = cljs.core.first(arglist__5206);
    var p__5201 = cljs.core.rest(arglist__5206);
    return hide__delegate.call(this, $elem, p__5201)
  };
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__5207) {
    var vec__5208__5209 = p__5207;
    var speed__5210 = cljs.core.nth.call(null, vec__5208__5209, 0, null);
    var on_finish__5211 = cljs.core.nth.call(null, vec__5208__5209, 1, null);
    return $elem.show(speed__5210, on_finish__5211)
  };
  var show = function($elem, var_args) {
    var p__5207 = null;
    if(goog.isDef(var_args)) {
      p__5207 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__5207)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__5212) {
    var $elem = cljs.core.first(arglist__5212);
    var p__5207 = cljs.core.rest(arglist__5212);
    return show__delegate.call(this, $elem, p__5207)
  };
  return show
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__5213) {
    var vec__5214__5215 = p__5213;
    var speed__5216 = cljs.core.nth.call(null, vec__5214__5215, 0, null);
    var on_finish__5217 = cljs.core.nth.call(null, vec__5214__5215, 1, null);
    return $elem.fadeOut(speed__5216, on_finish__5217)
  };
  var fade_out = function($elem, var_args) {
    var p__5213 = null;
    if(goog.isDef(var_args)) {
      p__5213 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__5213)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__5218) {
    var $elem = cljs.core.first(arglist__5218);
    var p__5213 = cljs.core.rest(arglist__5218);
    return fade_out__delegate.call(this, $elem, p__5213)
  };
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__5219) {
    var vec__5220__5221 = p__5219;
    var speed__5222 = cljs.core.nth.call(null, vec__5220__5221, 0, null);
    var on_finish__5223 = cljs.core.nth.call(null, vec__5220__5221, 1, null);
    return $elem.fadeIn(speed__5222, on_finish__5223)
  };
  var fade_in = function($elem, var_args) {
    var p__5219 = null;
    if(goog.isDef(var_args)) {
      p__5219 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__5219)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__5224) {
    var $elem = cljs.core.first(arglist__5224);
    var p__5219 = cljs.core.rest(arglist__5224);
    return fade_in__delegate.call(this, $elem, p__5219)
  };
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__5225) {
    var vec__5226__5227 = p__5225;
    var speed__5228 = cljs.core.nth.call(null, vec__5226__5227, 0, null);
    var on_finish__5229 = cljs.core.nth.call(null, vec__5226__5227, 1, null);
    return $elem.slideUp(speed__5228, on_finish__5229)
  };
  var slide_up = function($elem, var_args) {
    var p__5225 = null;
    if(goog.isDef(var_args)) {
      p__5225 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__5225)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__5230) {
    var $elem = cljs.core.first(arglist__5230);
    var p__5225 = cljs.core.rest(arglist__5230);
    return slide_up__delegate.call(this, $elem, p__5225)
  };
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__5231) {
    var vec__5232__5233 = p__5231;
    var speed__5234 = cljs.core.nth.call(null, vec__5232__5233, 0, null);
    var on_finish__5235 = cljs.core.nth.call(null, vec__5232__5233, 1, null);
    return $elem.slideDown(speed__5234, on_finish__5235)
  };
  var slide_down = function($elem, var_args) {
    var p__5231 = null;
    if(goog.isDef(var_args)) {
      p__5231 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__5231)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__5236) {
    var $elem = cljs.core.first(arglist__5236);
    var p__5231 = cljs.core.rest(arglist__5236);
    return slide_down__delegate.call(this, $elem, p__5231)
  };
  return slide_down
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__5237) {
    var vec__5238__5239 = p__5237;
    var v__5240 = cljs.core.nth.call(null, vec__5238__5239, 0, null);
    if(cljs.core.truth_(v__5240)) {
      return $elem.val(v__5240)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__5237 = null;
    if(goog.isDef(var_args)) {
      p__5237 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__5237)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__5241) {
    var $elem = cljs.core.first(arglist__5241);
    var p__5237 = cljs.core.rest(arglist__5241);
    return val__delegate.call(this, $elem, p__5237)
  };
  return val
}();
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.xhr = function xhr(p__5242, content, callback) {
  var vec__5243__5244 = p__5242;
  var method__5245 = cljs.core.nth.call(null, vec__5243__5244, 0, null);
  var uri__5246 = cljs.core.nth.call(null, vec__5243__5244, 1, null);
  var params__5247 = jayq.util.map__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__5245)), "\ufdd0'data":jayq.util.map__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__5246, params__5247)
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__3187 = cljs.core.js_obj.call(null);
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__3186_SHARP_) {
    return out__3187[cljs.core.name.call(null, cljs.core.first.call(null, p1__3186_SHARP_))] = cljs.core.second.call(null, p1__3186_SHARP_)
  }, cljmap));
  return out__3187
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.truth_(cljs.core.map_QMARK_.call(null, data))) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____3188 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(cljs.core.truth_(or__3548__auto____3188)) {
    return or__3548__auto____3188
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx) {
  if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
    return cljsbinding.translate.call(null, eval.call(null, fnstr).call(null, ctx))
  }else {
    return cljsbinding.translate.call(null, eval.call(null, fnstr).call(null))
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  var bindingname__3189 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__3190 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname__3189))) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname__3189).call(null, elem, cljsbinding.valuefn.call(null, elem, fname__3190, ctx))
    }
  }else {
    return function() {
      return elem[bindingname__3189].call(elem, cljsbinding.valuefn.call(null, elem, fname__3190, ctx))
    }
  }
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_elem = function bind_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__3191__3192 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__3191__3192)) {
    var data__3193 = cljs.core.first.call(null, G__3191__3192);
    var G__3191__3194 = G__3191__3192;
    while(true) {
      cljsbinding.bind_elem.call(null, elem, data__3193.split(":"), ctx);
      var temp__3698__auto____3195 = cljs.core.next.call(null, G__3191__3194);
      if(cljs.core.truth_(temp__3698__auto____3195)) {
        var G__3191__3196 = temp__3698__auto____3195;
        var G__3197 = cljs.core.first.call(null, G__3191__3196);
        var G__3198 = G__3191__3196;
        data__3193 = G__3197;
        G__3191__3194 = G__3198;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljs.core.deref.call(null, eval.call(null, jayq.core.attr.call(null, elem, "bindatom"))))
  });
  return elem.change(function() {
    cljs.core.reset_BANG_.call(null, eval.call(null, jayq.core.attr.call(null, elem, "bindatom")), elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljs.core.deref.call(null, eval.call(null, jayq.core.attr.call(null, elem, "bindatom"))))
  });
  return elem.change(function() {
    cljs.core.reset_BANG_.call(null, eval.call(null, jayq.core.attr.call(null, elem, "bindatom")), elem.is(":checked"));
    return false
  })
};
cljsbinding.bindatom = function bindatom(elem) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type")))) {
    return cljsbinding.bind_checkbox_atom.call(null, elem)
  }else {
    return cljsbinding.bind_input_atom.call(null, elem)
  }
};
cljsbinding.bindall = function bindall(parent, ctx) {
  var seqs__3200 = parent.find("*[bindseq]");
  var seqparents__3201 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__3199_SHARP_) {
    return p1__3199_SHARP_.parent()
  }, parent.find("*[bindseq]")));
  var G__3202__3203 = cljs.core.seq.call(null, seqs__3200);
  if(cljs.core.truth_(G__3202__3203)) {
    var elem__3204 = cljs.core.first.call(null, G__3202__3203);
    var G__3202__3205 = G__3202__3203;
    while(true) {
      jayq.core.remove.call(null, elem__3204);
      var temp__3698__auto____3206 = cljs.core.next.call(null, G__3202__3205);
      if(cljs.core.truth_(temp__3698__auto____3206)) {
        var G__3202__3207 = temp__3698__auto____3206;
        var G__3245 = cljs.core.first.call(null, G__3202__3207);
        var G__3246 = G__3202__3207;
        elem__3204 = G__3245;
        G__3202__3205 = G__3246;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__3208__3209 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__3208__3209)) {
    var elem__3210 = cljs.core.first.call(null, G__3208__3209);
    var G__3208__3211 = G__3208__3209;
    while(true) {
      cljsbinding.bind.call(null, elem__3210, ctx);
      var temp__3698__auto____3212 = cljs.core.next.call(null, G__3208__3211);
      if(cljs.core.truth_(temp__3698__auto____3212)) {
        var G__3208__3213 = temp__3698__auto____3212;
        var G__3247 = cljs.core.first.call(null, G__3208__3213);
        var G__3248 = G__3208__3213;
        elem__3210 = G__3247;
        G__3208__3211 = G__3248;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__3214__3215 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__3214__3215)) {
    var elem__3216 = cljs.core.first.call(null, G__3214__3215);
    var G__3214__3217 = G__3214__3215;
    while(true) {
      cljsbinding.bind.call(null, elem__3216, ctx);
      var temp__3698__auto____3218 = cljs.core.next.call(null, G__3214__3217);
      if(cljs.core.truth_(temp__3698__auto____3218)) {
        var G__3214__3219 = temp__3698__auto____3218;
        var G__3249 = cljs.core.first.call(null, G__3214__3219);
        var G__3250 = G__3214__3219;
        elem__3216 = G__3249;
        G__3214__3217 = G__3250;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__3220__3221 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__3220__3221)) {
    var elem__3222 = cljs.core.first.call(null, G__3220__3221);
    var G__3220__3223 = G__3220__3221;
    while(true) {
      cljsbinding.bindatom.call(null, elem__3222);
      var temp__3698__auto____3224 = cljs.core.next.call(null, G__3220__3223);
      if(cljs.core.truth_(temp__3698__auto____3224)) {
        var G__3220__3225 = temp__3698__auto____3224;
        var G__3251 = cljs.core.first.call(null, G__3220__3225);
        var G__3252 = G__3220__3225;
        elem__3222 = G__3251;
        G__3220__3223 = G__3252;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__3226__3227 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__3200, seqparents__3201));
  if(cljs.core.truth_(G__3226__3227)) {
    var G__3229__3231 = cljs.core.first.call(null, G__3226__3227);
    var vec__3230__3232 = G__3229__3231;
    var elem__3233 = cljs.core.nth.call(null, vec__3230__3232, 0, null);
    var parent__3234 = cljs.core.nth.call(null, vec__3230__3232, 1, null);
    var G__3226__3235 = G__3226__3227;
    var G__3229__3236 = G__3229__3231;
    var G__3226__3237 = G__3226__3235;
    while(true) {
      var vec__3238__3239 = G__3229__3236;
      var elem__3240 = cljs.core.nth.call(null, vec__3238__3239, 0, null);
      var parent__3241 = cljs.core.nth.call(null, vec__3238__3239, 1, null);
      var G__3226__3242 = G__3226__3237;
      cljsbinding.bindseq.call(null, elem__3240, parent__3241);
      var temp__3698__auto____3243 = cljs.core.next.call(null, G__3226__3242);
      if(cljs.core.truth_(temp__3698__auto____3243)) {
        var G__3226__3244 = temp__3698__auto____3243;
        var G__3253 = cljs.core.first.call(null, G__3226__3244);
        var G__3254 = G__3226__3244;
        G__3229__3236 = G__3253;
        G__3226__3237 = G__3254;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem) {
  jayq.core.append.call(null, parent, elem);
  return cljsbinding.bindall.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template) {
  jayq.core.remove.call(null, parent.children());
  var G__3255__3256 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__3255__3256)) {
    var item__3257 = cljs.core.first.call(null, G__3255__3256);
    var G__3255__3258 = G__3255__3256;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__3257, template.clone());
      var temp__3698__auto____3259 = cljs.core.next.call(null, G__3255__3258);
      if(cljs.core.truth_(temp__3698__auto____3259)) {
        var G__3255__3260 = temp__3698__auto____3259;
        var G__3261 = cljs.core.first.call(null, G__3255__3260);
        var G__3262 = G__3255__3260;
        item__3257 = G__3261;
        G__3255__3258 = G__3262;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent) {
  var atom__3263 = eval.call(null, jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__3263), elparent, elem);
  return cljs.core.add_watch.call(null, atom__3263, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem)
  })
};
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.truth_(cljs.core.empty_QMARK_.call(null, sequence))) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__3264_SHARP_, p2__3265_SHARP_) {
      var or__3548__auto____3268 = p1__3264_SHARP_;
      if(cljs.core.truth_(or__3548__auto____3268)) {
        return or__3548__auto____3268
      }else {
        return p2__3265_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__3266_SHARP_) {
      return cljs.core._EQ_.call(null, p1__3266_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, function(p1__3267_SHARP_) {
    return cljs.core.assoc.call(null, p1__3267_SHARP_, atom, cljs.core.truth_(cljs.core.contains_QMARK_.call(null, p1__3267_SHARP_, atom)) ? cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), p1__3267_SHARP_.call(null, atom)) : cljs.core.PersistentVector.fromArray([cljs.core.deref.call(null, cljsbinding.BindFn)]))
  });
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", function(key, a, old_val, new_val) {
    var G__3269__3270 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
    if(cljs.core.truth_(G__3269__3270)) {
      var f__3271 = cljs.core.first.call(null, G__3269__3270);
      var G__3269__3272 = G__3269__3270;
      while(true) {
        f__3271.call(null);
        var temp__3698__auto____3273 = cljs.core.next.call(null, G__3269__3272);
        if(cljs.core.truth_(temp__3698__auto____3273)) {
          var G__3269__3274 = temp__3698__auto____3273;
          var G__3275 = cljs.core.first.call(null, G__3269__3274);
          var G__3276 = G__3269__3274;
          f__3271 = G__3275;
          G__3269__3272 = G__3276;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  });
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.boot = function boot() {
  return eval.call(null, "    \n    var deref = cljs.core.deref\n    cljs.core.deref = function (a) {\n     if (deref(cljsbinding.BindMonitor))\n       cljsbinding.register(a)\n     return deref(a)\n    }\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__3277 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__3277), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__3277)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__3277)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__3277)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__3277))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, localStorage[name]))
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
