var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.evalWorksForGlobals_ = null;
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.getObjectByName(name) && !goog.implicitNamespaces_[name]) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.require = function(rule) {
  if(!COMPILED) {
    if(goog.getObjectByName(rule)) {
      return
    }
    var path = goog.getPathFromDeps_(rule);
    if(path) {
      goog.included_[path] = true;
      goog.writeScripts_()
    }else {
      var errorMessage = "goog.require could not find: " + rule;
      if(goog.global.console) {
        goog.global.console["error"](errorMessage)
      }
      throw Error(errorMessage);
    }
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(requireName in deps.nameToPath) {
            visitNode(deps.nameToPath[requireName])
          }else {
            if(!goog.getObjectByName(requireName)) {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  var context = selfObj || goog.global;
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(context, newArgs)
    }
  }else {
    return function() {
      return fn.apply(context, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = style
};
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global && !goog.string.contains(str, "<")) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var el = goog.global["document"]["createElement"]("div");
  el["innerHTML"] = "<pre>x" + str + "</pre>";
  if(el["firstChild"][goog.string.NORMALIZE_FN_]) {
    el["firstChild"][goog.string.NORMALIZE_FN_]()
  }
  str = el["firstChild"]["firstChild"]["nodeValue"].slice(1);
  el["innerHTML"] = "";
  return goog.string.canonicalizeNewlines(str)
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.NORMALIZE_FN_ = "normalize";
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\u000b":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4607__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4607 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4607__delegate.call(this, array, i, idxs)
    };
    G__4607.cljs$lang$maxFixedArity = 2;
    G__4607.cljs$lang$applyTo = function(arglist__4608) {
      var array = cljs.core.first(arglist__4608);
      var i = cljs.core.first(cljs.core.next(arglist__4608));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4608));
      return G__4607__delegate(array, i, idxs)
    };
    G__4607.cljs$lang$arity$variadic = G__4607__delegate;
    return G__4607
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4609 = this$;
      if(and__3546__auto____4609) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4609
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4610 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4610) {
          return or__3548__auto____4610
        }else {
          var or__3548__auto____4611 = cljs.core._invoke["_"];
          if(or__3548__auto____4611) {
            return or__3548__auto____4611
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4612 = this$;
      if(and__3546__auto____4612) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4612
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4613 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4613) {
          return or__3548__auto____4613
        }else {
          var or__3548__auto____4614 = cljs.core._invoke["_"];
          if(or__3548__auto____4614) {
            return or__3548__auto____4614
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4615 = this$;
      if(and__3546__auto____4615) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4615
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4616 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4616) {
          return or__3548__auto____4616
        }else {
          var or__3548__auto____4617 = cljs.core._invoke["_"];
          if(or__3548__auto____4617) {
            return or__3548__auto____4617
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4618 = this$;
      if(and__3546__auto____4618) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4618
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4619 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4619) {
          return or__3548__auto____4619
        }else {
          var or__3548__auto____4620 = cljs.core._invoke["_"];
          if(or__3548__auto____4620) {
            return or__3548__auto____4620
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4621 = this$;
      if(and__3546__auto____4621) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4621
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4622 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4622) {
          return or__3548__auto____4622
        }else {
          var or__3548__auto____4623 = cljs.core._invoke["_"];
          if(or__3548__auto____4623) {
            return or__3548__auto____4623
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4624 = this$;
      if(and__3546__auto____4624) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4624
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4625 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4625) {
          return or__3548__auto____4625
        }else {
          var or__3548__auto____4626 = cljs.core._invoke["_"];
          if(or__3548__auto____4626) {
            return or__3548__auto____4626
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4627 = this$;
      if(and__3546__auto____4627) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4627
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4628 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4628) {
          return or__3548__auto____4628
        }else {
          var or__3548__auto____4629 = cljs.core._invoke["_"];
          if(or__3548__auto____4629) {
            return or__3548__auto____4629
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4630 = this$;
      if(and__3546__auto____4630) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4630
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4631 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4631) {
          return or__3548__auto____4631
        }else {
          var or__3548__auto____4632 = cljs.core._invoke["_"];
          if(or__3548__auto____4632) {
            return or__3548__auto____4632
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4633 = this$;
      if(and__3546__auto____4633) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4633
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4634 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4634) {
          return or__3548__auto____4634
        }else {
          var or__3548__auto____4635 = cljs.core._invoke["_"];
          if(or__3548__auto____4635) {
            return or__3548__auto____4635
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4636 = this$;
      if(and__3546__auto____4636) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4636
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4637 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4637) {
          return or__3548__auto____4637
        }else {
          var or__3548__auto____4638 = cljs.core._invoke["_"];
          if(or__3548__auto____4638) {
            return or__3548__auto____4638
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4639 = this$;
      if(and__3546__auto____4639) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4639
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4640 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4640) {
          return or__3548__auto____4640
        }else {
          var or__3548__auto____4641 = cljs.core._invoke["_"];
          if(or__3548__auto____4641) {
            return or__3548__auto____4641
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4642 = this$;
      if(and__3546__auto____4642) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4642
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4643 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4643) {
          return or__3548__auto____4643
        }else {
          var or__3548__auto____4644 = cljs.core._invoke["_"];
          if(or__3548__auto____4644) {
            return or__3548__auto____4644
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4645 = this$;
      if(and__3546__auto____4645) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4645
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4646 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4646) {
          return or__3548__auto____4646
        }else {
          var or__3548__auto____4647 = cljs.core._invoke["_"];
          if(or__3548__auto____4647) {
            return or__3548__auto____4647
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4648 = this$;
      if(and__3546__auto____4648) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4648
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4649 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4649) {
          return or__3548__auto____4649
        }else {
          var or__3548__auto____4650 = cljs.core._invoke["_"];
          if(or__3548__auto____4650) {
            return or__3548__auto____4650
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4651 = this$;
      if(and__3546__auto____4651) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4651
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4652 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4652) {
          return or__3548__auto____4652
        }else {
          var or__3548__auto____4653 = cljs.core._invoke["_"];
          if(or__3548__auto____4653) {
            return or__3548__auto____4653
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4654 = this$;
      if(and__3546__auto____4654) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4654
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4655 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4655) {
          return or__3548__auto____4655
        }else {
          var or__3548__auto____4656 = cljs.core._invoke["_"];
          if(or__3548__auto____4656) {
            return or__3548__auto____4656
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4657 = this$;
      if(and__3546__auto____4657) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4657
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4658 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4658) {
          return or__3548__auto____4658
        }else {
          var or__3548__auto____4659 = cljs.core._invoke["_"];
          if(or__3548__auto____4659) {
            return or__3548__auto____4659
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____4660 = this$;
      if(and__3546__auto____4660) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____4660
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____4661 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4661) {
          return or__3548__auto____4661
        }else {
          var or__3548__auto____4662 = cljs.core._invoke["_"];
          if(or__3548__auto____4662) {
            return or__3548__auto____4662
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____4663 = this$;
      if(and__3546__auto____4663) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____4663
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____4664 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4664) {
          return or__3548__auto____4664
        }else {
          var or__3548__auto____4665 = cljs.core._invoke["_"];
          if(or__3548__auto____4665) {
            return or__3548__auto____4665
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____4666 = this$;
      if(and__3546__auto____4666) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____4666
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____4667 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4667) {
          return or__3548__auto____4667
        }else {
          var or__3548__auto____4668 = cljs.core._invoke["_"];
          if(or__3548__auto____4668) {
            return or__3548__auto____4668
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____4669 = this$;
      if(and__3546__auto____4669) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____4669
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____4670 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4670) {
          return or__3548__auto____4670
        }else {
          var or__3548__auto____4671 = cljs.core._invoke["_"];
          if(or__3548__auto____4671) {
            return or__3548__auto____4671
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____4672 = coll;
    if(and__3546__auto____4672) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____4672
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4673 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4673) {
        return or__3548__auto____4673
      }else {
        var or__3548__auto____4674 = cljs.core._count["_"];
        if(or__3548__auto____4674) {
          return or__3548__auto____4674
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____4675 = coll;
    if(and__3546__auto____4675) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____4675
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4676 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4676) {
        return or__3548__auto____4676
      }else {
        var or__3548__auto____4677 = cljs.core._empty["_"];
        if(or__3548__auto____4677) {
          return or__3548__auto____4677
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____4678 = coll;
    if(and__3546__auto____4678) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____4678
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____4679 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4679) {
        return or__3548__auto____4679
      }else {
        var or__3548__auto____4680 = cljs.core._conj["_"];
        if(or__3548__auto____4680) {
          return or__3548__auto____4680
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____4681 = coll;
      if(and__3546__auto____4681) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____4681
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____4682 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4682) {
          return or__3548__auto____4682
        }else {
          var or__3548__auto____4683 = cljs.core._nth["_"];
          if(or__3548__auto____4683) {
            return or__3548__auto____4683
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____4684 = coll;
      if(and__3546__auto____4684) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____4684
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____4685 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4685) {
          return or__3548__auto____4685
        }else {
          var or__3548__auto____4686 = cljs.core._nth["_"];
          if(or__3548__auto____4686) {
            return or__3548__auto____4686
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____4687 = coll;
    if(and__3546__auto____4687) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____4687
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4688 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4688) {
        return or__3548__auto____4688
      }else {
        var or__3548__auto____4689 = cljs.core._first["_"];
        if(or__3548__auto____4689) {
          return or__3548__auto____4689
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____4690 = coll;
    if(and__3546__auto____4690) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____4690
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4691 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4691) {
        return or__3548__auto____4691
      }else {
        var or__3548__auto____4692 = cljs.core._rest["_"];
        if(or__3548__auto____4692) {
          return or__3548__auto____4692
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____4693 = o;
      if(and__3546__auto____4693) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____4693
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____4694 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4694) {
          return or__3548__auto____4694
        }else {
          var or__3548__auto____4695 = cljs.core._lookup["_"];
          if(or__3548__auto____4695) {
            return or__3548__auto____4695
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____4696 = o;
      if(and__3546__auto____4696) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____4696
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____4697 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4697) {
          return or__3548__auto____4697
        }else {
          var or__3548__auto____4698 = cljs.core._lookup["_"];
          if(or__3548__auto____4698) {
            return or__3548__auto____4698
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____4699 = coll;
    if(and__3546__auto____4699) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____4699
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4700 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4700) {
        return or__3548__auto____4700
      }else {
        var or__3548__auto____4701 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____4701) {
          return or__3548__auto____4701
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____4702 = coll;
    if(and__3546__auto____4702) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____4702
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____4703 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4703) {
        return or__3548__auto____4703
      }else {
        var or__3548__auto____4704 = cljs.core._assoc["_"];
        if(or__3548__auto____4704) {
          return or__3548__auto____4704
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____4705 = coll;
    if(and__3546__auto____4705) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____4705
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4706 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4706) {
        return or__3548__auto____4706
      }else {
        var or__3548__auto____4707 = cljs.core._dissoc["_"];
        if(or__3548__auto____4707) {
          return or__3548__auto____4707
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____4708 = coll;
    if(and__3546__auto____4708) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____4708
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4709 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4709) {
        return or__3548__auto____4709
      }else {
        var or__3548__auto____4710 = cljs.core._key["_"];
        if(or__3548__auto____4710) {
          return or__3548__auto____4710
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____4711 = coll;
    if(and__3546__auto____4711) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____4711
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4712 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4712) {
        return or__3548__auto____4712
      }else {
        var or__3548__auto____4713 = cljs.core._val["_"];
        if(or__3548__auto____4713) {
          return or__3548__auto____4713
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____4714 = coll;
    if(and__3546__auto____4714) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____4714
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____4715 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4715) {
        return or__3548__auto____4715
      }else {
        var or__3548__auto____4716 = cljs.core._disjoin["_"];
        if(or__3548__auto____4716) {
          return or__3548__auto____4716
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____4717 = coll;
    if(and__3546__auto____4717) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____4717
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4718 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4718) {
        return or__3548__auto____4718
      }else {
        var or__3548__auto____4719 = cljs.core._peek["_"];
        if(or__3548__auto____4719) {
          return or__3548__auto____4719
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____4720 = coll;
    if(and__3546__auto____4720) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____4720
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4721 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4721) {
        return or__3548__auto____4721
      }else {
        var or__3548__auto____4722 = cljs.core._pop["_"];
        if(or__3548__auto____4722) {
          return or__3548__auto____4722
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____4723 = coll;
    if(and__3546__auto____4723) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____4723
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____4724 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4724) {
        return or__3548__auto____4724
      }else {
        var or__3548__auto____4725 = cljs.core._assoc_n["_"];
        if(or__3548__auto____4725) {
          return or__3548__auto____4725
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____4726 = o;
    if(and__3546__auto____4726) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____4726
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4727 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____4727) {
        return or__3548__auto____4727
      }else {
        var or__3548__auto____4728 = cljs.core._deref["_"];
        if(or__3548__auto____4728) {
          return or__3548__auto____4728
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____4729 = o;
    if(and__3546__auto____4729) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____4729
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____4730 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____4730) {
        return or__3548__auto____4730
      }else {
        var or__3548__auto____4731 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____4731) {
          return or__3548__auto____4731
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____4732 = o;
    if(and__3546__auto____4732) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____4732
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4733 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4733) {
        return or__3548__auto____4733
      }else {
        var or__3548__auto____4734 = cljs.core._meta["_"];
        if(or__3548__auto____4734) {
          return or__3548__auto____4734
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____4735 = o;
    if(and__3546__auto____4735) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____4735
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____4736 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4736) {
        return or__3548__auto____4736
      }else {
        var or__3548__auto____4737 = cljs.core._with_meta["_"];
        if(or__3548__auto____4737) {
          return or__3548__auto____4737
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____4738 = coll;
      if(and__3546__auto____4738) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____4738
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____4739 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4739) {
          return or__3548__auto____4739
        }else {
          var or__3548__auto____4740 = cljs.core._reduce["_"];
          if(or__3548__auto____4740) {
            return or__3548__auto____4740
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____4741 = coll;
      if(and__3546__auto____4741) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____4741
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____4742 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4742) {
          return or__3548__auto____4742
        }else {
          var or__3548__auto____4743 = cljs.core._reduce["_"];
          if(or__3548__auto____4743) {
            return or__3548__auto____4743
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____4744 = coll;
    if(and__3546__auto____4744) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____4744
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____4745 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4745) {
        return or__3548__auto____4745
      }else {
        var or__3548__auto____4746 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____4746) {
          return or__3548__auto____4746
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____4747 = o;
    if(and__3546__auto____4747) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____4747
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____4748 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____4748) {
        return or__3548__auto____4748
      }else {
        var or__3548__auto____4749 = cljs.core._equiv["_"];
        if(or__3548__auto____4749) {
          return or__3548__auto____4749
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____4750 = o;
    if(and__3546__auto____4750) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____4750
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4751 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____4751) {
        return or__3548__auto____4751
      }else {
        var or__3548__auto____4752 = cljs.core._hash["_"];
        if(or__3548__auto____4752) {
          return or__3548__auto____4752
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____4753 = o;
    if(and__3546__auto____4753) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____4753
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4754 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4754) {
        return or__3548__auto____4754
      }else {
        var or__3548__auto____4755 = cljs.core._seq["_"];
        if(or__3548__auto____4755) {
          return or__3548__auto____4755
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____4756 = coll;
    if(and__3546__auto____4756) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____4756
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4757 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4757) {
        return or__3548__auto____4757
      }else {
        var or__3548__auto____4758 = cljs.core._rseq["_"];
        if(or__3548__auto____4758) {
          return or__3548__auto____4758
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4759 = coll;
    if(and__3546__auto____4759) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____4759
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4760 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4760) {
        return or__3548__auto____4760
      }else {
        var or__3548__auto____4761 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____4761) {
          return or__3548__auto____4761
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4762 = coll;
    if(and__3546__auto____4762) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____4762
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4763 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4763) {
        return or__3548__auto____4763
      }else {
        var or__3548__auto____4764 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____4764) {
          return or__3548__auto____4764
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____4765 = coll;
    if(and__3546__auto____4765) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____4765
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____4766 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4766) {
        return or__3548__auto____4766
      }else {
        var or__3548__auto____4767 = cljs.core._entry_key["_"];
        if(or__3548__auto____4767) {
          return or__3548__auto____4767
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____4768 = coll;
    if(and__3546__auto____4768) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____4768
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4769 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4769) {
        return or__3548__auto____4769
      }else {
        var or__3548__auto____4770 = cljs.core._comparator["_"];
        if(or__3548__auto____4770) {
          return or__3548__auto____4770
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____4771 = o;
    if(and__3546__auto____4771) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____4771
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____4772 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4772) {
        return or__3548__auto____4772
      }else {
        var or__3548__auto____4773 = cljs.core._pr_seq["_"];
        if(or__3548__auto____4773) {
          return or__3548__auto____4773
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____4774 = d;
    if(and__3546__auto____4774) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____4774
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____4775 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____4775) {
        return or__3548__auto____4775
      }else {
        var or__3548__auto____4776 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____4776) {
          return or__3548__auto____4776
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____4777 = this$;
    if(and__3546__auto____4777) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____4777
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____4778 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4778) {
        return or__3548__auto____4778
      }else {
        var or__3548__auto____4779 = cljs.core._notify_watches["_"];
        if(or__3548__auto____4779) {
          return or__3548__auto____4779
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____4780 = this$;
    if(and__3546__auto____4780) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____4780
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____4781 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4781) {
        return or__3548__auto____4781
      }else {
        var or__3548__auto____4782 = cljs.core._add_watch["_"];
        if(or__3548__auto____4782) {
          return or__3548__auto____4782
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____4783 = this$;
    if(and__3546__auto____4783) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____4783
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____4784 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4784) {
        return or__3548__auto____4784
      }else {
        var or__3548__auto____4785 = cljs.core._remove_watch["_"];
        if(or__3548__auto____4785) {
          return or__3548__auto____4785
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____4786 = coll;
    if(and__3546__auto____4786) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____4786
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4787 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4787) {
        return or__3548__auto____4787
      }else {
        var or__3548__auto____4788 = cljs.core._as_transient["_"];
        if(or__3548__auto____4788) {
          return or__3548__auto____4788
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____4789 = tcoll;
    if(and__3546__auto____4789) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____4789
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____4790 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4790) {
        return or__3548__auto____4790
      }else {
        var or__3548__auto____4791 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____4791) {
          return or__3548__auto____4791
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4792 = tcoll;
    if(and__3546__auto____4792) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____4792
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4793 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4793) {
        return or__3548__auto____4793
      }else {
        var or__3548__auto____4794 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____4794) {
          return or__3548__auto____4794
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____4795 = tcoll;
    if(and__3546__auto____4795) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____4795
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____4796 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4796) {
        return or__3548__auto____4796
      }else {
        var or__3548__auto____4797 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____4797) {
          return or__3548__auto____4797
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____4798 = tcoll;
    if(and__3546__auto____4798) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____4798
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____4799 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4799) {
        return or__3548__auto____4799
      }else {
        var or__3548__auto____4800 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____4800) {
          return or__3548__auto____4800
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____4801 = tcoll;
    if(and__3546__auto____4801) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____4801
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____4802 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4802) {
        return or__3548__auto____4802
      }else {
        var or__3548__auto____4803 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____4803) {
          return or__3548__auto____4803
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4804 = tcoll;
    if(and__3546__auto____4804) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____4804
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4805 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4805) {
        return or__3548__auto____4805
      }else {
        var or__3548__auto____4806 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____4806) {
          return or__3548__auto____4806
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____4807 = tcoll;
    if(and__3546__auto____4807) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____4807
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____4808 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4808) {
        return or__3548__auto____4808
      }else {
        var or__3548__auto____4809 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____4809) {
          return or__3548__auto____4809
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____4810 = x === y;
    if(or__3548__auto____4810) {
      return or__3548__auto____4810
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__4811__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__4812 = y;
            var G__4813 = cljs.core.first.call(null, more);
            var G__4814 = cljs.core.next.call(null, more);
            x = G__4812;
            y = G__4813;
            more = G__4814;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__4811 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4811__delegate.call(this, x, y, more)
    };
    G__4811.cljs$lang$maxFixedArity = 2;
    G__4811.cljs$lang$applyTo = function(arglist__4815) {
      var x = cljs.core.first(arglist__4815);
      var y = cljs.core.first(cljs.core.next(arglist__4815));
      var more = cljs.core.rest(cljs.core.next(arglist__4815));
      return G__4811__delegate(x, y, more)
    };
    G__4811.cljs$lang$arity$variadic = G__4811__delegate;
    return G__4811
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____4816 = x == null;
    if(or__3548__auto____4816) {
      return or__3548__auto____4816
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__4817 = null;
  var G__4817__2 = function(o, k) {
    return null
  };
  var G__4817__3 = function(o, k, not_found) {
    return not_found
  };
  G__4817 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4817__2.call(this, o, k);
      case 3:
        return G__4817__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4817
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__4818 = null;
  var G__4818__2 = function(_, f) {
    return f.call(null)
  };
  var G__4818__3 = function(_, f, start) {
    return start
  };
  G__4818 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4818__2.call(this, _, f);
      case 3:
        return G__4818__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4818
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__4819 = null;
  var G__4819__2 = function(_, n) {
    return null
  };
  var G__4819__3 = function(_, n, not_found) {
    return not_found
  };
  G__4819 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4819__2.call(this, _, n);
      case 3:
        return G__4819__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4819
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__4820 = cljs.core._nth.call(null, cicoll, 0);
      var n__4821 = 1;
      while(true) {
        if(n__4821 < cljs.core._count.call(null, cicoll)) {
          var nval__4822 = f.call(null, val__4820, cljs.core._nth.call(null, cicoll, n__4821));
          if(cljs.core.reduced_QMARK_.call(null, nval__4822)) {
            return cljs.core.deref.call(null, nval__4822)
          }else {
            var G__4829 = nval__4822;
            var G__4830 = n__4821 + 1;
            val__4820 = G__4829;
            n__4821 = G__4830;
            continue
          }
        }else {
          return val__4820
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__4823 = val;
    var n__4824 = 0;
    while(true) {
      if(n__4824 < cljs.core._count.call(null, cicoll)) {
        var nval__4825 = f.call(null, val__4823, cljs.core._nth.call(null, cicoll, n__4824));
        if(cljs.core.reduced_QMARK_.call(null, nval__4825)) {
          return cljs.core.deref.call(null, nval__4825)
        }else {
          var G__4831 = nval__4825;
          var G__4832 = n__4824 + 1;
          val__4823 = G__4831;
          n__4824 = G__4832;
          continue
        }
      }else {
        return val__4823
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__4826 = val;
    var n__4827 = idx;
    while(true) {
      if(n__4827 < cljs.core._count.call(null, cicoll)) {
        var nval__4828 = f.call(null, val__4826, cljs.core._nth.call(null, cicoll, n__4827));
        if(cljs.core.reduced_QMARK_.call(null, nval__4828)) {
          return cljs.core.deref.call(null, nval__4828)
        }else {
          var G__4833 = nval__4828;
          var G__4834 = n__4827 + 1;
          val__4826 = G__4833;
          n__4827 = G__4834;
          continue
        }
      }else {
        return val__4826
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__4835 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__4836 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__4837 = this;
  var this$__4838 = this;
  return cljs.core.pr_str.call(null, this$__4838)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__4839 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4839.a)) {
    return cljs.core.ci_reduce.call(null, this__4839.a, f, this__4839.a[this__4839.i], this__4839.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__4839.a[this__4839.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__4840 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4840.a)) {
    return cljs.core.ci_reduce.call(null, this__4840.a, f, start, this__4840.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__4841 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__4842 = this;
  return this__4842.a.length - this__4842.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__4843 = this;
  return this__4843.a[this__4843.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__4844 = this;
  if(this__4844.i + 1 < this__4844.a.length) {
    return new cljs.core.IndexedSeq(this__4844.a, this__4844.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__4845 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__4846 = this;
  var i__4847 = n + this__4846.i;
  if(i__4847 < this__4846.a.length) {
    return this__4846.a[i__4847]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__4848 = this;
  var i__4849 = n + this__4848.i;
  if(i__4849 < this__4848.a.length) {
    return this__4848.a[i__4849]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function prim_seq(prim, i) {
  if(prim.length === 0) {
    return null
  }else {
    return new cljs.core.IndexedSeq(prim, i)
  }
};
cljs.core.array_seq = function array_seq(array, i) {
  return cljs.core.prim_seq.call(null, array, i)
};
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__4850 = null;
  var G__4850__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__4850__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__4850 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4850__2.call(this, array, f);
      case 3:
        return G__4850__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4850
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__4851 = null;
  var G__4851__2 = function(array, k) {
    return array[k]
  };
  var G__4851__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__4851 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4851__2.call(this, array, k);
      case 3:
        return G__4851__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4851
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__4852 = null;
  var G__4852__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__4852__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__4852 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4852__2.call(this, array, n);
      case 3:
        return G__4852__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4852
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__4853__4854 = coll;
      if(G__4853__4854 != null) {
        if(function() {
          var or__3548__auto____4855 = G__4853__4854.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____4855) {
            return or__3548__auto____4855
          }else {
            return G__4853__4854.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__4853__4854.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4853__4854)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4853__4854)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__4856__4857 = coll;
      if(G__4856__4857 != null) {
        if(function() {
          var or__3548__auto____4858 = G__4856__4857.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____4858) {
            return or__3548__auto____4858
          }else {
            return G__4856__4857.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__4856__4857.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4856__4857)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4856__4857)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__4859 = cljs.core.seq.call(null, coll);
      if(s__4859 != null) {
        return cljs.core._first.call(null, s__4859)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__4860__4861 = coll;
      if(G__4860__4861 != null) {
        if(function() {
          var or__3548__auto____4862 = G__4860__4861.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____4862) {
            return or__3548__auto____4862
          }else {
            return G__4860__4861.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__4860__4861.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4860__4861)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4860__4861)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__4863 = cljs.core.seq.call(null, coll);
      if(s__4863 != null) {
        return cljs.core._rest.call(null, s__4863)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__4864__4865 = coll;
      if(G__4864__4865 != null) {
        if(function() {
          var or__3548__auto____4866 = G__4864__4865.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____4866) {
            return or__3548__auto____4866
          }else {
            return G__4864__4865.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__4864__4865.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4864__4865)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4864__4865)
      }
    }()) {
      var coll__4867 = cljs.core._rest.call(null, coll);
      if(coll__4867 != null) {
        if(function() {
          var G__4868__4869 = coll__4867;
          if(G__4868__4869 != null) {
            if(function() {
              var or__3548__auto____4870 = G__4868__4869.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____4870) {
                return or__3548__auto____4870
              }else {
                return G__4868__4869.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__4868__4869.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4868__4869)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4868__4869)
          }
        }()) {
          return coll__4867
        }else {
          return cljs.core._seq.call(null, coll__4867)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__4871 = cljs.core.next.call(null, s);
      s = G__4871;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__4872__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__4873 = conj.call(null, coll, x);
          var G__4874 = cljs.core.first.call(null, xs);
          var G__4875 = cljs.core.next.call(null, xs);
          coll = G__4873;
          x = G__4874;
          xs = G__4875;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__4872 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4872__delegate.call(this, coll, x, xs)
    };
    G__4872.cljs$lang$maxFixedArity = 2;
    G__4872.cljs$lang$applyTo = function(arglist__4876) {
      var coll = cljs.core.first(arglist__4876);
      var x = cljs.core.first(cljs.core.next(arglist__4876));
      var xs = cljs.core.rest(cljs.core.next(arglist__4876));
      return G__4872__delegate(coll, x, xs)
    };
    G__4872.cljs$lang$arity$variadic = G__4872__delegate;
    return G__4872
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll, acc) {
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, coll)) {
      return acc + cljs.core._count.call(null, coll)
    }else {
      var G__4877 = cljs.core.next.call(null, coll);
      var G__4878 = acc + 1;
      coll = G__4877;
      acc = G__4878;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll, 0)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(n === 0) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        return cljs.core.first.call(null, coll)
      }else {
        throw new Error("Index out of bounds");
      }
    }else {
      if(cljs.core.indexed_QMARK_.call(null, coll)) {
        return cljs.core._nth.call(null, coll, n)
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
        }else {
          if("\ufdd0'else") {
            throw new Error("Index out of bounds");
          }else {
            return null
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(n === 0) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        return cljs.core.first.call(null, coll)
      }else {
        return not_found
      }
    }else {
      if(cljs.core.indexed_QMARK_.call(null, coll)) {
        return cljs.core._nth.call(null, coll, n, not_found)
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(function() {
      var G__4879__4880 = coll;
      if(G__4879__4880 != null) {
        if(function() {
          var or__3548__auto____4881 = G__4879__4880.cljs$lang$protocol_mask$partition0$ & 16;
          if(or__3548__auto____4881) {
            return or__3548__auto____4881
          }else {
            return G__4879__4880.cljs$core$IIndexed$
          }
        }()) {
          return true
        }else {
          if(!G__4879__4880.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__4879__4880)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__4879__4880)
      }
    }()) {
      return cljs.core._nth.call(null, coll, Math.floor(n))
    }else {
      return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(function() {
      var G__4882__4883 = coll;
      if(G__4882__4883 != null) {
        if(function() {
          var or__3548__auto____4884 = G__4882__4883.cljs$lang$protocol_mask$partition0$ & 16;
          if(or__3548__auto____4884) {
            return or__3548__auto____4884
          }else {
            return G__4882__4883.cljs$core$IIndexed$
          }
        }()) {
          return true
        }else {
          if(!G__4882__4883.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__4882__4883)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__4882__4883)
      }
    }()) {
      return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
    }else {
      return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__4886__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__4885 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__4887 = ret__4885;
          var G__4888 = cljs.core.first.call(null, kvs);
          var G__4889 = cljs.core.second.call(null, kvs);
          var G__4890 = cljs.core.nnext.call(null, kvs);
          coll = G__4887;
          k = G__4888;
          v = G__4889;
          kvs = G__4890;
          continue
        }else {
          return ret__4885
        }
        break
      }
    };
    var G__4886 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4886__delegate.call(this, coll, k, v, kvs)
    };
    G__4886.cljs$lang$maxFixedArity = 3;
    G__4886.cljs$lang$applyTo = function(arglist__4891) {
      var coll = cljs.core.first(arglist__4891);
      var k = cljs.core.first(cljs.core.next(arglist__4891));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4891)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4891)));
      return G__4886__delegate(coll, k, v, kvs)
    };
    G__4886.cljs$lang$arity$variadic = G__4886__delegate;
    return G__4886
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__4893__delegate = function(coll, k, ks) {
      while(true) {
        var ret__4892 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__4894 = ret__4892;
          var G__4895 = cljs.core.first.call(null, ks);
          var G__4896 = cljs.core.next.call(null, ks);
          coll = G__4894;
          k = G__4895;
          ks = G__4896;
          continue
        }else {
          return ret__4892
        }
        break
      }
    };
    var G__4893 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4893__delegate.call(this, coll, k, ks)
    };
    G__4893.cljs$lang$maxFixedArity = 2;
    G__4893.cljs$lang$applyTo = function(arglist__4897) {
      var coll = cljs.core.first(arglist__4897);
      var k = cljs.core.first(cljs.core.next(arglist__4897));
      var ks = cljs.core.rest(cljs.core.next(arglist__4897));
      return G__4893__delegate(coll, k, ks)
    };
    G__4893.cljs$lang$arity$variadic = G__4893__delegate;
    return G__4893
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__4898__4899 = o;
    if(G__4898__4899 != null) {
      if(function() {
        var or__3548__auto____4900 = G__4898__4899.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____4900) {
          return or__3548__auto____4900
        }else {
          return G__4898__4899.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__4898__4899.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__4898__4899)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__4898__4899)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__4902__delegate = function(coll, k, ks) {
      while(true) {
        var ret__4901 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__4903 = ret__4901;
          var G__4904 = cljs.core.first.call(null, ks);
          var G__4905 = cljs.core.next.call(null, ks);
          coll = G__4903;
          k = G__4904;
          ks = G__4905;
          continue
        }else {
          return ret__4901
        }
        break
      }
    };
    var G__4902 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4902__delegate.call(this, coll, k, ks)
    };
    G__4902.cljs$lang$maxFixedArity = 2;
    G__4902.cljs$lang$applyTo = function(arglist__4906) {
      var coll = cljs.core.first(arglist__4906);
      var k = cljs.core.first(cljs.core.next(arglist__4906));
      var ks = cljs.core.rest(cljs.core.next(arglist__4906));
      return G__4902__delegate(coll, k, ks)
    };
    G__4902.cljs$lang$arity$variadic = G__4902__delegate;
    return G__4902
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__4907__4908 = x;
    if(G__4907__4908 != null) {
      if(function() {
        var or__3548__auto____4909 = G__4907__4908.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____4909) {
          return or__3548__auto____4909
        }else {
          return G__4907__4908.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__4907__4908.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__4907__4908)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__4907__4908)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__4910__4911 = x;
    if(G__4910__4911 != null) {
      if(function() {
        var or__3548__auto____4912 = G__4910__4911.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____4912) {
          return or__3548__auto____4912
        }else {
          return G__4910__4911.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__4910__4911.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__4910__4911)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__4910__4911)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__4913__4914 = x;
  if(G__4913__4914 != null) {
    if(function() {
      var or__3548__auto____4915 = G__4913__4914.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____4915) {
        return or__3548__auto____4915
      }else {
        return G__4913__4914.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__4913__4914.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__4913__4914)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__4913__4914)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__4916__4917 = x;
  if(G__4916__4917 != null) {
    if(function() {
      var or__3548__auto____4918 = G__4916__4917.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____4918) {
        return or__3548__auto____4918
      }else {
        return G__4916__4917.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__4916__4917.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__4916__4917)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__4916__4917)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__4919__4920 = x;
  if(G__4919__4920 != null) {
    if(function() {
      var or__3548__auto____4921 = G__4919__4920.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____4921) {
        return or__3548__auto____4921
      }else {
        return G__4919__4920.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__4919__4920.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__4919__4920)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__4919__4920)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__4922__4923 = x;
  if(G__4922__4923 != null) {
    if(function() {
      var or__3548__auto____4924 = G__4922__4923.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____4924) {
        return or__3548__auto____4924
      }else {
        return G__4922__4923.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__4922__4923.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__4922__4923)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__4922__4923)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__4925__4926 = x;
  if(G__4925__4926 != null) {
    if(function() {
      var or__3548__auto____4927 = G__4925__4926.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____4927) {
        return or__3548__auto____4927
      }else {
        return G__4925__4926.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__4925__4926.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__4925__4926)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__4925__4926)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__4928__4929 = x;
    if(G__4928__4929 != null) {
      if(function() {
        var or__3548__auto____4930 = G__4928__4929.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____4930) {
          return or__3548__auto____4930
        }else {
          return G__4928__4929.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__4928__4929.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__4928__4929)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__4928__4929)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__4931__4932 = x;
  if(G__4931__4932 != null) {
    if(function() {
      var or__3548__auto____4933 = G__4931__4932.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____4933) {
        return or__3548__auto____4933
      }else {
        return G__4931__4932.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__4931__4932.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__4931__4932)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__4931__4932)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__4934__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__4934 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__4934__delegate.call(this, keyvals)
    };
    G__4934.cljs$lang$maxFixedArity = 0;
    G__4934.cljs$lang$applyTo = function(arglist__4935) {
      var keyvals = cljs.core.seq(arglist__4935);
      return G__4934__delegate(keyvals)
    };
    G__4934.cljs$lang$arity$variadic = G__4934__delegate;
    return G__4934
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__4936 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__4936.push(key)
  });
  return keys__4936
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__4937 = i;
  var j__4938 = j;
  var len__4939 = len;
  while(true) {
    if(len__4939 === 0) {
      return to
    }else {
      to[j__4938] = from[i__4937];
      var G__4940 = i__4937 + 1;
      var G__4941 = j__4938 + 1;
      var G__4942 = len__4939 - 1;
      i__4937 = G__4940;
      j__4938 = G__4941;
      len__4939 = G__4942;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__4943 = i + (len - 1);
  var j__4944 = j + (len - 1);
  var len__4945 = len;
  while(true) {
    if(len__4945 === 0) {
      return to
    }else {
      to[j__4944] = from[i__4943];
      var G__4946 = i__4943 - 1;
      var G__4947 = j__4944 - 1;
      var G__4948 = len__4945 - 1;
      i__4943 = G__4946;
      j__4944 = G__4947;
      len__4945 = G__4948;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__4949__4950 = s;
    if(G__4949__4950 != null) {
      if(function() {
        var or__3548__auto____4951 = G__4949__4950.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____4951) {
          return or__3548__auto____4951
        }else {
          return G__4949__4950.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__4949__4950.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4949__4950)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4949__4950)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__4952__4953 = s;
  if(G__4952__4953 != null) {
    if(function() {
      var or__3548__auto____4954 = G__4952__4953.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____4954) {
        return or__3548__auto____4954
      }else {
        return G__4952__4953.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__4952__4953.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__4952__4953)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__4952__4953)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____4955 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____4955)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____4956 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____4956) {
        return or__3548__auto____4956
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____4955
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____4957 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____4957)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____4957
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____4958 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____4958)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____4958
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____4959 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____4959) {
    return or__3548__auto____4959
  }else {
    var G__4960__4961 = f;
    if(G__4960__4961 != null) {
      if(function() {
        var or__3548__auto____4962 = G__4960__4961.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____4962) {
          return or__3548__auto____4962
        }else {
          return G__4960__4961.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__4960__4961.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__4960__4961)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__4960__4961)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____4963 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____4963) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____4963
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4964 = coll;
    if(cljs.core.truth_(and__3546__auto____4964)) {
      var and__3546__auto____4965 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____4965) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____4965
      }
    }else {
      return and__3546__auto____4964
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__4970__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__4966 = cljs.core.set([y, x]);
        var xs__4967 = more;
        while(true) {
          var x__4968 = cljs.core.first.call(null, xs__4967);
          var etc__4969 = cljs.core.next.call(null, xs__4967);
          if(cljs.core.truth_(xs__4967)) {
            if(cljs.core.contains_QMARK_.call(null, s__4966, x__4968)) {
              return false
            }else {
              var G__4971 = cljs.core.conj.call(null, s__4966, x__4968);
              var G__4972 = etc__4969;
              s__4966 = G__4971;
              xs__4967 = G__4972;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__4970 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4970__delegate.call(this, x, y, more)
    };
    G__4970.cljs$lang$maxFixedArity = 2;
    G__4970.cljs$lang$applyTo = function(arglist__4973) {
      var x = cljs.core.first(arglist__4973);
      var y = cljs.core.first(cljs.core.next(arglist__4973));
      var more = cljs.core.rest(cljs.core.next(arglist__4973));
      return G__4970__delegate(x, y, more)
    };
    G__4970.cljs$lang$arity$variadic = G__4970__delegate;
    return G__4970
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__4974 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__4974)) {
        return r__4974
      }else {
        if(cljs.core.truth_(r__4974)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__4975 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__4975, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__4975)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____4976 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____4976)) {
      var s__4977 = temp__3695__auto____4976;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__4977), cljs.core.next.call(null, s__4977))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__4978 = val;
    var coll__4979 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__4979)) {
        var nval__4980 = f.call(null, val__4978, cljs.core.first.call(null, coll__4979));
        if(cljs.core.reduced_QMARK_.call(null, nval__4980)) {
          return cljs.core.deref.call(null, nval__4980)
        }else {
          var G__4981 = nval__4980;
          var G__4982 = cljs.core.next.call(null, coll__4979);
          val__4978 = G__4981;
          coll__4979 = G__4982;
          continue
        }
      }else {
        return val__4978
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__4983__4984 = coll;
      if(G__4983__4984 != null) {
        if(function() {
          var or__3548__auto____4985 = G__4983__4984.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____4985) {
            return or__3548__auto____4985
          }else {
            return G__4983__4984.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__4983__4984.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__4983__4984)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__4983__4984)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__4986__4987 = coll;
      if(G__4986__4987 != null) {
        if(function() {
          var or__3548__auto____4988 = G__4986__4987.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____4988) {
            return or__3548__auto____4988
          }else {
            return G__4986__4987.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__4986__4987.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__4986__4987)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__4986__4987)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__4989 = this;
  return this__4989.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__4990__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__4990 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4990__delegate.call(this, x, y, more)
    };
    G__4990.cljs$lang$maxFixedArity = 2;
    G__4990.cljs$lang$applyTo = function(arglist__4991) {
      var x = cljs.core.first(arglist__4991);
      var y = cljs.core.first(cljs.core.next(arglist__4991));
      var more = cljs.core.rest(cljs.core.next(arglist__4991));
      return G__4990__delegate(x, y, more)
    };
    G__4990.cljs$lang$arity$variadic = G__4990__delegate;
    return G__4990
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__4992__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__4992 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4992__delegate.call(this, x, y, more)
    };
    G__4992.cljs$lang$maxFixedArity = 2;
    G__4992.cljs$lang$applyTo = function(arglist__4993) {
      var x = cljs.core.first(arglist__4993);
      var y = cljs.core.first(cljs.core.next(arglist__4993));
      var more = cljs.core.rest(cljs.core.next(arglist__4993));
      return G__4992__delegate(x, y, more)
    };
    G__4992.cljs$lang$arity$variadic = G__4992__delegate;
    return G__4992
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__4994__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__4994 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4994__delegate.call(this, x, y, more)
    };
    G__4994.cljs$lang$maxFixedArity = 2;
    G__4994.cljs$lang$applyTo = function(arglist__4995) {
      var x = cljs.core.first(arglist__4995);
      var y = cljs.core.first(cljs.core.next(arglist__4995));
      var more = cljs.core.rest(cljs.core.next(arglist__4995));
      return G__4994__delegate(x, y, more)
    };
    G__4994.cljs$lang$arity$variadic = G__4994__delegate;
    return G__4994
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__4996__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__4996 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4996__delegate.call(this, x, y, more)
    };
    G__4996.cljs$lang$maxFixedArity = 2;
    G__4996.cljs$lang$applyTo = function(arglist__4997) {
      var x = cljs.core.first(arglist__4997);
      var y = cljs.core.first(cljs.core.next(arglist__4997));
      var more = cljs.core.rest(cljs.core.next(arglist__4997));
      return G__4996__delegate(x, y, more)
    };
    G__4996.cljs$lang$arity$variadic = G__4996__delegate;
    return G__4996
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__4998__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__4999 = y;
            var G__5000 = cljs.core.first.call(null, more);
            var G__5001 = cljs.core.next.call(null, more);
            x = G__4999;
            y = G__5000;
            more = G__5001;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__4998 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4998__delegate.call(this, x, y, more)
    };
    G__4998.cljs$lang$maxFixedArity = 2;
    G__4998.cljs$lang$applyTo = function(arglist__5002) {
      var x = cljs.core.first(arglist__5002);
      var y = cljs.core.first(cljs.core.next(arglist__5002));
      var more = cljs.core.rest(cljs.core.next(arglist__5002));
      return G__4998__delegate(x, y, more)
    };
    G__4998.cljs$lang$arity$variadic = G__4998__delegate;
    return G__4998
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5003__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5004 = y;
            var G__5005 = cljs.core.first.call(null, more);
            var G__5006 = cljs.core.next.call(null, more);
            x = G__5004;
            y = G__5005;
            more = G__5006;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5003 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5003__delegate.call(this, x, y, more)
    };
    G__5003.cljs$lang$maxFixedArity = 2;
    G__5003.cljs$lang$applyTo = function(arglist__5007) {
      var x = cljs.core.first(arglist__5007);
      var y = cljs.core.first(cljs.core.next(arglist__5007));
      var more = cljs.core.rest(cljs.core.next(arglist__5007));
      return G__5003__delegate(x, y, more)
    };
    G__5003.cljs$lang$arity$variadic = G__5003__delegate;
    return G__5003
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5008__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5009 = y;
            var G__5010 = cljs.core.first.call(null, more);
            var G__5011 = cljs.core.next.call(null, more);
            x = G__5009;
            y = G__5010;
            more = G__5011;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5008 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5008__delegate.call(this, x, y, more)
    };
    G__5008.cljs$lang$maxFixedArity = 2;
    G__5008.cljs$lang$applyTo = function(arglist__5012) {
      var x = cljs.core.first(arglist__5012);
      var y = cljs.core.first(cljs.core.next(arglist__5012));
      var more = cljs.core.rest(cljs.core.next(arglist__5012));
      return G__5008__delegate(x, y, more)
    };
    G__5008.cljs$lang$arity$variadic = G__5008__delegate;
    return G__5008
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5013__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5014 = y;
            var G__5015 = cljs.core.first.call(null, more);
            var G__5016 = cljs.core.next.call(null, more);
            x = G__5014;
            y = G__5015;
            more = G__5016;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5013 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5013__delegate.call(this, x, y, more)
    };
    G__5013.cljs$lang$maxFixedArity = 2;
    G__5013.cljs$lang$applyTo = function(arglist__5017) {
      var x = cljs.core.first(arglist__5017);
      var y = cljs.core.first(cljs.core.next(arglist__5017));
      var more = cljs.core.rest(cljs.core.next(arglist__5017));
      return G__5013__delegate(x, y, more)
    };
    G__5013.cljs$lang$arity$variadic = G__5013__delegate;
    return G__5013
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5018__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5018 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5018__delegate.call(this, x, y, more)
    };
    G__5018.cljs$lang$maxFixedArity = 2;
    G__5018.cljs$lang$applyTo = function(arglist__5019) {
      var x = cljs.core.first(arglist__5019);
      var y = cljs.core.first(cljs.core.next(arglist__5019));
      var more = cljs.core.rest(cljs.core.next(arglist__5019));
      return G__5018__delegate(x, y, more)
    };
    G__5018.cljs$lang$arity$variadic = G__5018__delegate;
    return G__5018
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5020__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5020 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5020__delegate.call(this, x, y, more)
    };
    G__5020.cljs$lang$maxFixedArity = 2;
    G__5020.cljs$lang$applyTo = function(arglist__5021) {
      var x = cljs.core.first(arglist__5021);
      var y = cljs.core.first(cljs.core.next(arglist__5021));
      var more = cljs.core.rest(cljs.core.next(arglist__5021));
      return G__5020__delegate(x, y, more)
    };
    G__5020.cljs$lang$arity$variadic = G__5020__delegate;
    return G__5020
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5022 = n % d;
  return cljs.core.fix.call(null, (n - rem__5022) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5023 = cljs.core.quot.call(null, n, d);
  return n - d * q__5023
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5024 = 0;
  var n__5025 = n;
  while(true) {
    if(n__5025 === 0) {
      return c__5024
    }else {
      var G__5026 = c__5024 + 1;
      var G__5027 = n__5025 & n__5025 - 1;
      c__5024 = G__5026;
      n__5025 = G__5027;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5028__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5029 = y;
            var G__5030 = cljs.core.first.call(null, more);
            var G__5031 = cljs.core.next.call(null, more);
            x = G__5029;
            y = G__5030;
            more = G__5031;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5028 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5028__delegate.call(this, x, y, more)
    };
    G__5028.cljs$lang$maxFixedArity = 2;
    G__5028.cljs$lang$applyTo = function(arglist__5032) {
      var x = cljs.core.first(arglist__5032);
      var y = cljs.core.first(cljs.core.next(arglist__5032));
      var more = cljs.core.rest(cljs.core.next(arglist__5032));
      return G__5028__delegate(x, y, more)
    };
    G__5028.cljs$lang$arity$variadic = G__5028__delegate;
    return G__5028
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5033 = n;
  var xs__5034 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5035 = xs__5034;
      if(cljs.core.truth_(and__3546__auto____5035)) {
        return n__5033 > 0
      }else {
        return and__3546__auto____5035
      }
    }())) {
      var G__5036 = n__5033 - 1;
      var G__5037 = cljs.core.next.call(null, xs__5034);
      n__5033 = G__5036;
      xs__5034 = G__5037;
      continue
    }else {
      return xs__5034
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5038__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5039 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5040 = cljs.core.next.call(null, more);
            sb = G__5039;
            more = G__5040;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5038 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5038__delegate.call(this, x, ys)
    };
    G__5038.cljs$lang$maxFixedArity = 1;
    G__5038.cljs$lang$applyTo = function(arglist__5041) {
      var x = cljs.core.first(arglist__5041);
      var ys = cljs.core.rest(arglist__5041);
      return G__5038__delegate(x, ys)
    };
    G__5038.cljs$lang$arity$variadic = G__5038__delegate;
    return G__5038
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5042__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5043 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5044 = cljs.core.next.call(null, more);
            sb = G__5043;
            more = G__5044;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5042 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5042__delegate.call(this, x, ys)
    };
    G__5042.cljs$lang$maxFixedArity = 1;
    G__5042.cljs$lang$applyTo = function(arglist__5045) {
      var x = cljs.core.first(arglist__5045);
      var ys = cljs.core.rest(arglist__5045);
      return G__5042__delegate(x, ys)
    };
    G__5042.cljs$lang$arity$variadic = G__5042__delegate;
    return G__5042
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5046 = cljs.core.seq.call(null, x);
    var ys__5047 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5046 == null) {
        return ys__5047 == null
      }else {
        if(ys__5047 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5046), cljs.core.first.call(null, ys__5047))) {
            var G__5048 = cljs.core.next.call(null, xs__5046);
            var G__5049 = cljs.core.next.call(null, ys__5047);
            xs__5046 = G__5048;
            ys__5047 = G__5049;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5050_SHARP_, p2__5051_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5050_SHARP_, cljs.core.hash.call(null, p2__5051_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5052 = 0;
  var s__5053 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5053)) {
      var e__5054 = cljs.core.first.call(null, s__5053);
      var G__5055 = (h__5052 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5054)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5054)))) % 4503599627370496;
      var G__5056 = cljs.core.next.call(null, s__5053);
      h__5052 = G__5055;
      s__5053 = G__5056;
      continue
    }else {
      return h__5052
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5057 = 0;
  var s__5058 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5058)) {
      var e__5059 = cljs.core.first.call(null, s__5058);
      var G__5060 = (h__5057 + cljs.core.hash.call(null, e__5059)) % 4503599627370496;
      var G__5061 = cljs.core.next.call(null, s__5058);
      h__5057 = G__5060;
      s__5058 = G__5061;
      continue
    }else {
      return h__5057
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5062__5063 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5062__5063)) {
    var G__5065__5067 = cljs.core.first.call(null, G__5062__5063);
    var vec__5066__5068 = G__5065__5067;
    var key_name__5069 = cljs.core.nth.call(null, vec__5066__5068, 0, null);
    var f__5070 = cljs.core.nth.call(null, vec__5066__5068, 1, null);
    var G__5062__5071 = G__5062__5063;
    var G__5065__5072 = G__5065__5067;
    var G__5062__5073 = G__5062__5071;
    while(true) {
      var vec__5074__5075 = G__5065__5072;
      var key_name__5076 = cljs.core.nth.call(null, vec__5074__5075, 0, null);
      var f__5077 = cljs.core.nth.call(null, vec__5074__5075, 1, null);
      var G__5062__5078 = G__5062__5073;
      var str_name__5079 = cljs.core.name.call(null, key_name__5076);
      obj[str_name__5079] = f__5077;
      var temp__3698__auto____5080 = cljs.core.next.call(null, G__5062__5078);
      if(cljs.core.truth_(temp__3698__auto____5080)) {
        var G__5062__5081 = temp__3698__auto____5080;
        var G__5082 = cljs.core.first.call(null, G__5062__5081);
        var G__5083 = G__5062__5081;
        G__5065__5072 = G__5082;
        G__5062__5073 = G__5083;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5084 = this;
  var h__364__auto____5085 = this__5084.__hash;
  if(h__364__auto____5085 != null) {
    return h__364__auto____5085
  }else {
    var h__364__auto____5086 = cljs.core.hash_coll.call(null, coll);
    this__5084.__hash = h__364__auto____5086;
    return h__364__auto____5086
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5087 = this;
  return new cljs.core.List(this__5087.meta, o, coll, this__5087.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5088 = this;
  var this$__5089 = this;
  return cljs.core.pr_str.call(null, this$__5089)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5090 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5091 = this;
  return this__5091.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5092 = this;
  return this__5092.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5093 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5094 = this;
  return this__5094.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5095 = this;
  return this__5095.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5096 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5097 = this;
  return new cljs.core.List(meta, this__5097.first, this__5097.rest, this__5097.count, this__5097.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5098 = this;
  return this__5098.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5099 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5100 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5101 = this;
  return new cljs.core.List(this__5101.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5102 = this;
  var this$__5103 = this;
  return cljs.core.pr_str.call(null, this$__5103)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5104 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5105 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5106 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5107 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5108 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5109 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5110 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5111 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5112 = this;
  return this__5112.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5113 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5114__5115 = coll;
  if(G__5114__5115 != null) {
    if(function() {
      var or__3548__auto____5116 = G__5114__5115.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5116) {
        return or__3548__auto____5116
      }else {
        return G__5114__5115.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5114__5115.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5114__5115)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5114__5115)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5117) {
    var items = cljs.core.seq(arglist__5117);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5118 = this;
  var h__364__auto____5119 = this__5118.__hash;
  if(h__364__auto____5119 != null) {
    return h__364__auto____5119
  }else {
    var h__364__auto____5120 = cljs.core.hash_coll.call(null, coll);
    this__5118.__hash = h__364__auto____5120;
    return h__364__auto____5120
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5121 = this;
  return new cljs.core.Cons(null, o, coll, this__5121.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5122 = this;
  var this$__5123 = this;
  return cljs.core.pr_str.call(null, this$__5123)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5124 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5125 = this;
  return this__5125.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5126 = this;
  if(this__5126.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5126.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5127 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5128 = this;
  return new cljs.core.Cons(meta, this__5128.first, this__5128.rest, this__5128.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5129 = this;
  return this__5129.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5130 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5130.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5131 = coll == null;
    if(or__3548__auto____5131) {
      return or__3548__auto____5131
    }else {
      var G__5132__5133 = coll;
      if(G__5132__5133 != null) {
        if(function() {
          var or__3548__auto____5134 = G__5132__5133.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5134) {
            return or__3548__auto____5134
          }else {
            return G__5132__5133.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5132__5133.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5132__5133)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5132__5133)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5135__5136 = x;
  if(G__5135__5136 != null) {
    if(function() {
      var or__3548__auto____5137 = G__5135__5136.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5137) {
        return or__3548__auto____5137
      }else {
        return G__5135__5136.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5135__5136.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5135__5136)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5135__5136)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5138 = null;
  var G__5138__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5138__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5138 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5138__2.call(this, string, f);
      case 3:
        return G__5138__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5138
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5139 = null;
  var G__5139__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5139__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5139 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5139__2.call(this, string, k);
      case 3:
        return G__5139__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5139
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5140 = null;
  var G__5140__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5140__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5140 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5140__2.call(this, string, n);
      case 3:
        return G__5140__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5140
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5149 = null;
  var G__5149__2 = function(tsym5143, coll) {
    var tsym5143__5145 = this;
    var this$__5146 = tsym5143__5145;
    return cljs.core.get.call(null, coll, this$__5146.toString())
  };
  var G__5149__3 = function(tsym5144, coll, not_found) {
    var tsym5144__5147 = this;
    var this$__5148 = tsym5144__5147;
    return cljs.core.get.call(null, coll, this$__5148.toString(), not_found)
  };
  G__5149 = function(tsym5144, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5149__2.call(this, tsym5144, coll);
      case 3:
        return G__5149__3.call(this, tsym5144, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5149
}();
String.prototype.apply = function(tsym5141, args5142) {
  return tsym5141.call.apply(tsym5141, [tsym5141].concat(cljs.core.aclone.call(null, args5142)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5150 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5150
  }else {
    lazy_seq.x = x__5150.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5151 = this;
  var h__364__auto____5152 = this__5151.__hash;
  if(h__364__auto____5152 != null) {
    return h__364__auto____5152
  }else {
    var h__364__auto____5153 = cljs.core.hash_coll.call(null, coll);
    this__5151.__hash = h__364__auto____5153;
    return h__364__auto____5153
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5154 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5155 = this;
  var this$__5156 = this;
  return cljs.core.pr_str.call(null, this$__5156)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5157 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5158 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5159 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5160 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5161 = this;
  return new cljs.core.LazySeq(meta, this__5161.realized, this__5161.x, this__5161.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5162 = this;
  return this__5162.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5163 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5163.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5164 = [];
  var s__5165 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5165))) {
      ary__5164.push(cljs.core.first.call(null, s__5165));
      var G__5166 = cljs.core.next.call(null, s__5165);
      s__5165 = G__5166;
      continue
    }else {
      return ary__5164
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5167 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5168 = 0;
  var xs__5169 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5169)) {
      ret__5167[i__5168] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5169));
      var G__5170 = i__5168 + 1;
      var G__5171 = cljs.core.next.call(null, xs__5169);
      i__5168 = G__5170;
      xs__5169 = G__5171;
      continue
    }else {
    }
    break
  }
  return ret__5167
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5172 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5173 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5174 = 0;
      var s__5175 = s__5173;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5176 = s__5175;
          if(cljs.core.truth_(and__3546__auto____5176)) {
            return i__5174 < size
          }else {
            return and__3546__auto____5176
          }
        }())) {
          a__5172[i__5174] = cljs.core.first.call(null, s__5175);
          var G__5179 = i__5174 + 1;
          var G__5180 = cljs.core.next.call(null, s__5175);
          i__5174 = G__5179;
          s__5175 = G__5180;
          continue
        }else {
          return a__5172
        }
        break
      }
    }else {
      var n__653__auto____5177 = size;
      var i__5178 = 0;
      while(true) {
        if(i__5178 < n__653__auto____5177) {
          a__5172[i__5178] = init_val_or_seq;
          var G__5181 = i__5178 + 1;
          i__5178 = G__5181;
          continue
        }else {
        }
        break
      }
      return a__5172
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5182 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5183 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5184 = 0;
      var s__5185 = s__5183;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5186 = s__5185;
          if(cljs.core.truth_(and__3546__auto____5186)) {
            return i__5184 < size
          }else {
            return and__3546__auto____5186
          }
        }())) {
          a__5182[i__5184] = cljs.core.first.call(null, s__5185);
          var G__5189 = i__5184 + 1;
          var G__5190 = cljs.core.next.call(null, s__5185);
          i__5184 = G__5189;
          s__5185 = G__5190;
          continue
        }else {
          return a__5182
        }
        break
      }
    }else {
      var n__653__auto____5187 = size;
      var i__5188 = 0;
      while(true) {
        if(i__5188 < n__653__auto____5187) {
          a__5182[i__5188] = init_val_or_seq;
          var G__5191 = i__5188 + 1;
          i__5188 = G__5191;
          continue
        }else {
        }
        break
      }
      return a__5182
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5192 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5193 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5194 = 0;
      var s__5195 = s__5193;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5196 = s__5195;
          if(cljs.core.truth_(and__3546__auto____5196)) {
            return i__5194 < size
          }else {
            return and__3546__auto____5196
          }
        }())) {
          a__5192[i__5194] = cljs.core.first.call(null, s__5195);
          var G__5199 = i__5194 + 1;
          var G__5200 = cljs.core.next.call(null, s__5195);
          i__5194 = G__5199;
          s__5195 = G__5200;
          continue
        }else {
          return a__5192
        }
        break
      }
    }else {
      var n__653__auto____5197 = size;
      var i__5198 = 0;
      while(true) {
        if(i__5198 < n__653__auto____5197) {
          a__5192[i__5198] = init_val_or_seq;
          var G__5201 = i__5198 + 1;
          i__5198 = G__5201;
          continue
        }else {
        }
        break
      }
      return a__5192
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5202 = s;
    var i__5203 = n;
    var sum__5204 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5205 = i__5203 > 0;
        if(and__3546__auto____5205) {
          return cljs.core.seq.call(null, s__5202)
        }else {
          return and__3546__auto____5205
        }
      }())) {
        var G__5206 = cljs.core.next.call(null, s__5202);
        var G__5207 = i__5203 - 1;
        var G__5208 = sum__5204 + 1;
        s__5202 = G__5206;
        i__5203 = G__5207;
        sum__5204 = G__5208;
        continue
      }else {
        return sum__5204
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5209 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5209)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5209), concat.call(null, cljs.core.rest.call(null, s__5209), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5212__delegate = function(x, y, zs) {
      var cat__5211 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5210 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5210)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5210), cat.call(null, cljs.core.rest.call(null, xys__5210), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5211.call(null, concat.call(null, x, y), zs)
    };
    var G__5212 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5212__delegate.call(this, x, y, zs)
    };
    G__5212.cljs$lang$maxFixedArity = 2;
    G__5212.cljs$lang$applyTo = function(arglist__5213) {
      var x = cljs.core.first(arglist__5213);
      var y = cljs.core.first(cljs.core.next(arglist__5213));
      var zs = cljs.core.rest(cljs.core.next(arglist__5213));
      return G__5212__delegate(x, y, zs)
    };
    G__5212.cljs$lang$arity$variadic = G__5212__delegate;
    return G__5212
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5214__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5214 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5214__delegate.call(this, a, b, c, d, more)
    };
    G__5214.cljs$lang$maxFixedArity = 4;
    G__5214.cljs$lang$applyTo = function(arglist__5215) {
      var a = cljs.core.first(arglist__5215);
      var b = cljs.core.first(cljs.core.next(arglist__5215));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5215)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5215))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5215))));
      return G__5214__delegate(a, b, c, d, more)
    };
    G__5214.cljs$lang$arity$variadic = G__5214__delegate;
    return G__5214
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5216 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5217 = cljs.core._first.call(null, args__5216);
    var args__5218 = cljs.core._rest.call(null, args__5216);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5217)
      }else {
        return f.call(null, a__5217)
      }
    }else {
      var b__5219 = cljs.core._first.call(null, args__5218);
      var args__5220 = cljs.core._rest.call(null, args__5218);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5217, b__5219)
        }else {
          return f.call(null, a__5217, b__5219)
        }
      }else {
        var c__5221 = cljs.core._first.call(null, args__5220);
        var args__5222 = cljs.core._rest.call(null, args__5220);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5217, b__5219, c__5221)
          }else {
            return f.call(null, a__5217, b__5219, c__5221)
          }
        }else {
          var d__5223 = cljs.core._first.call(null, args__5222);
          var args__5224 = cljs.core._rest.call(null, args__5222);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5217, b__5219, c__5221, d__5223)
            }else {
              return f.call(null, a__5217, b__5219, c__5221, d__5223)
            }
          }else {
            var e__5225 = cljs.core._first.call(null, args__5224);
            var args__5226 = cljs.core._rest.call(null, args__5224);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5217, b__5219, c__5221, d__5223, e__5225)
              }else {
                return f.call(null, a__5217, b__5219, c__5221, d__5223, e__5225)
              }
            }else {
              var f__5227 = cljs.core._first.call(null, args__5226);
              var args__5228 = cljs.core._rest.call(null, args__5226);
              if(argc === 6) {
                if(f__5227.cljs$lang$arity$6) {
                  return f__5227.cljs$lang$arity$6(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227)
                }else {
                  return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227)
                }
              }else {
                var g__5229 = cljs.core._first.call(null, args__5228);
                var args__5230 = cljs.core._rest.call(null, args__5228);
                if(argc === 7) {
                  if(f__5227.cljs$lang$arity$7) {
                    return f__5227.cljs$lang$arity$7(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229)
                  }else {
                    return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229)
                  }
                }else {
                  var h__5231 = cljs.core._first.call(null, args__5230);
                  var args__5232 = cljs.core._rest.call(null, args__5230);
                  if(argc === 8) {
                    if(f__5227.cljs$lang$arity$8) {
                      return f__5227.cljs$lang$arity$8(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231)
                    }else {
                      return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231)
                    }
                  }else {
                    var i__5233 = cljs.core._first.call(null, args__5232);
                    var args__5234 = cljs.core._rest.call(null, args__5232);
                    if(argc === 9) {
                      if(f__5227.cljs$lang$arity$9) {
                        return f__5227.cljs$lang$arity$9(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233)
                      }else {
                        return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233)
                      }
                    }else {
                      var j__5235 = cljs.core._first.call(null, args__5234);
                      var args__5236 = cljs.core._rest.call(null, args__5234);
                      if(argc === 10) {
                        if(f__5227.cljs$lang$arity$10) {
                          return f__5227.cljs$lang$arity$10(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235)
                        }else {
                          return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235)
                        }
                      }else {
                        var k__5237 = cljs.core._first.call(null, args__5236);
                        var args__5238 = cljs.core._rest.call(null, args__5236);
                        if(argc === 11) {
                          if(f__5227.cljs$lang$arity$11) {
                            return f__5227.cljs$lang$arity$11(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237)
                          }else {
                            return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237)
                          }
                        }else {
                          var l__5239 = cljs.core._first.call(null, args__5238);
                          var args__5240 = cljs.core._rest.call(null, args__5238);
                          if(argc === 12) {
                            if(f__5227.cljs$lang$arity$12) {
                              return f__5227.cljs$lang$arity$12(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239)
                            }else {
                              return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239)
                            }
                          }else {
                            var m__5241 = cljs.core._first.call(null, args__5240);
                            var args__5242 = cljs.core._rest.call(null, args__5240);
                            if(argc === 13) {
                              if(f__5227.cljs$lang$arity$13) {
                                return f__5227.cljs$lang$arity$13(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241)
                              }else {
                                return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241)
                              }
                            }else {
                              var n__5243 = cljs.core._first.call(null, args__5242);
                              var args__5244 = cljs.core._rest.call(null, args__5242);
                              if(argc === 14) {
                                if(f__5227.cljs$lang$arity$14) {
                                  return f__5227.cljs$lang$arity$14(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243)
                                }else {
                                  return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243)
                                }
                              }else {
                                var o__5245 = cljs.core._first.call(null, args__5244);
                                var args__5246 = cljs.core._rest.call(null, args__5244);
                                if(argc === 15) {
                                  if(f__5227.cljs$lang$arity$15) {
                                    return f__5227.cljs$lang$arity$15(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245)
                                  }else {
                                    return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245)
                                  }
                                }else {
                                  var p__5247 = cljs.core._first.call(null, args__5246);
                                  var args__5248 = cljs.core._rest.call(null, args__5246);
                                  if(argc === 16) {
                                    if(f__5227.cljs$lang$arity$16) {
                                      return f__5227.cljs$lang$arity$16(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247)
                                    }else {
                                      return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247)
                                    }
                                  }else {
                                    var q__5249 = cljs.core._first.call(null, args__5248);
                                    var args__5250 = cljs.core._rest.call(null, args__5248);
                                    if(argc === 17) {
                                      if(f__5227.cljs$lang$arity$17) {
                                        return f__5227.cljs$lang$arity$17(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249)
                                      }else {
                                        return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249)
                                      }
                                    }else {
                                      var r__5251 = cljs.core._first.call(null, args__5250);
                                      var args__5252 = cljs.core._rest.call(null, args__5250);
                                      if(argc === 18) {
                                        if(f__5227.cljs$lang$arity$18) {
                                          return f__5227.cljs$lang$arity$18(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249, r__5251)
                                        }else {
                                          return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249, r__5251)
                                        }
                                      }else {
                                        var s__5253 = cljs.core._first.call(null, args__5252);
                                        var args__5254 = cljs.core._rest.call(null, args__5252);
                                        if(argc === 19) {
                                          if(f__5227.cljs$lang$arity$19) {
                                            return f__5227.cljs$lang$arity$19(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249, r__5251, s__5253)
                                          }else {
                                            return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249, r__5251, s__5253)
                                          }
                                        }else {
                                          var t__5255 = cljs.core._first.call(null, args__5254);
                                          var args__5256 = cljs.core._rest.call(null, args__5254);
                                          if(argc === 20) {
                                            if(f__5227.cljs$lang$arity$20) {
                                              return f__5227.cljs$lang$arity$20(a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249, r__5251, s__5253, t__5255)
                                            }else {
                                              return f__5227.call(null, a__5217, b__5219, c__5221, d__5223, e__5225, f__5227, g__5229, h__5231, i__5233, j__5235, k__5237, l__5239, m__5241, n__5243, o__5245, p__5247, q__5249, r__5251, s__5253, t__5255)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5257 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5258 = cljs.core.bounded_count.call(null, args, fixed_arity__5257 + 1);
      if(bc__5258 <= fixed_arity__5257) {
        return cljs.core.apply_to.call(null, f, bc__5258, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5259 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5260 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5261 = cljs.core.bounded_count.call(null, arglist__5259, fixed_arity__5260 + 1);
      if(bc__5261 <= fixed_arity__5260) {
        return cljs.core.apply_to.call(null, f, bc__5261, arglist__5259)
      }else {
        return f.cljs$lang$applyTo(arglist__5259)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5259))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5262 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5263 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5264 = cljs.core.bounded_count.call(null, arglist__5262, fixed_arity__5263 + 1);
      if(bc__5264 <= fixed_arity__5263) {
        return cljs.core.apply_to.call(null, f, bc__5264, arglist__5262)
      }else {
        return f.cljs$lang$applyTo(arglist__5262)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5262))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5265 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5266 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5267 = cljs.core.bounded_count.call(null, arglist__5265, fixed_arity__5266 + 1);
      if(bc__5267 <= fixed_arity__5266) {
        return cljs.core.apply_to.call(null, f, bc__5267, arglist__5265)
      }else {
        return f.cljs$lang$applyTo(arglist__5265)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5265))
    }
  };
  var apply__6 = function() {
    var G__5271__delegate = function(f, a, b, c, d, args) {
      var arglist__5268 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5269 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5270 = cljs.core.bounded_count.call(null, arglist__5268, fixed_arity__5269 + 1);
        if(bc__5270 <= fixed_arity__5269) {
          return cljs.core.apply_to.call(null, f, bc__5270, arglist__5268)
        }else {
          return f.cljs$lang$applyTo(arglist__5268)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5268))
      }
    };
    var G__5271 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5271__delegate.call(this, f, a, b, c, d, args)
    };
    G__5271.cljs$lang$maxFixedArity = 5;
    G__5271.cljs$lang$applyTo = function(arglist__5272) {
      var f = cljs.core.first(arglist__5272);
      var a = cljs.core.first(cljs.core.next(arglist__5272));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5272)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5272))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5272)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5272)))));
      return G__5271__delegate(f, a, b, c, d, args)
    };
    G__5271.cljs$lang$arity$variadic = G__5271__delegate;
    return G__5271
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5273) {
    var obj = cljs.core.first(arglist__5273);
    var f = cljs.core.first(cljs.core.next(arglist__5273));
    var args = cljs.core.rest(cljs.core.next(arglist__5273));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5274__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5274 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5274__delegate.call(this, x, y, more)
    };
    G__5274.cljs$lang$maxFixedArity = 2;
    G__5274.cljs$lang$applyTo = function(arglist__5275) {
      var x = cljs.core.first(arglist__5275);
      var y = cljs.core.first(cljs.core.next(arglist__5275));
      var more = cljs.core.rest(cljs.core.next(arglist__5275));
      return G__5274__delegate(x, y, more)
    };
    G__5274.cljs$lang$arity$variadic = G__5274__delegate;
    return G__5274
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5276 = pred;
        var G__5277 = cljs.core.next.call(null, coll);
        pred = G__5276;
        coll = G__5277;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5278 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5278)) {
        return or__3548__auto____5278
      }else {
        var G__5279 = pred;
        var G__5280 = cljs.core.next.call(null, coll);
        pred = G__5279;
        coll = G__5280;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5281 = null;
    var G__5281__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5281__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5281__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5281__3 = function() {
      var G__5282__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5282 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5282__delegate.call(this, x, y, zs)
      };
      G__5282.cljs$lang$maxFixedArity = 2;
      G__5282.cljs$lang$applyTo = function(arglist__5283) {
        var x = cljs.core.first(arglist__5283);
        var y = cljs.core.first(cljs.core.next(arglist__5283));
        var zs = cljs.core.rest(cljs.core.next(arglist__5283));
        return G__5282__delegate(x, y, zs)
      };
      G__5282.cljs$lang$arity$variadic = G__5282__delegate;
      return G__5282
    }();
    G__5281 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5281__0.call(this);
        case 1:
          return G__5281__1.call(this, x);
        case 2:
          return G__5281__2.call(this, x, y);
        default:
          return G__5281__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5281.cljs$lang$maxFixedArity = 2;
    G__5281.cljs$lang$applyTo = G__5281__3.cljs$lang$applyTo;
    return G__5281
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5284__delegate = function(args) {
      return x
    };
    var G__5284 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5284__delegate.call(this, args)
    };
    G__5284.cljs$lang$maxFixedArity = 0;
    G__5284.cljs$lang$applyTo = function(arglist__5285) {
      var args = cljs.core.seq(arglist__5285);
      return G__5284__delegate(args)
    };
    G__5284.cljs$lang$arity$variadic = G__5284__delegate;
    return G__5284
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5289 = null;
      var G__5289__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5289__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5289__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5289__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5289__4 = function() {
        var G__5290__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5290 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5290__delegate.call(this, x, y, z, args)
        };
        G__5290.cljs$lang$maxFixedArity = 3;
        G__5290.cljs$lang$applyTo = function(arglist__5291) {
          var x = cljs.core.first(arglist__5291);
          var y = cljs.core.first(cljs.core.next(arglist__5291));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5291)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5291)));
          return G__5290__delegate(x, y, z, args)
        };
        G__5290.cljs$lang$arity$variadic = G__5290__delegate;
        return G__5290
      }();
      G__5289 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5289__0.call(this);
          case 1:
            return G__5289__1.call(this, x);
          case 2:
            return G__5289__2.call(this, x, y);
          case 3:
            return G__5289__3.call(this, x, y, z);
          default:
            return G__5289__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5289.cljs$lang$maxFixedArity = 3;
      G__5289.cljs$lang$applyTo = G__5289__4.cljs$lang$applyTo;
      return G__5289
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5292 = null;
      var G__5292__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5292__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5292__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5292__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5292__4 = function() {
        var G__5293__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5293 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5293__delegate.call(this, x, y, z, args)
        };
        G__5293.cljs$lang$maxFixedArity = 3;
        G__5293.cljs$lang$applyTo = function(arglist__5294) {
          var x = cljs.core.first(arglist__5294);
          var y = cljs.core.first(cljs.core.next(arglist__5294));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5294)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5294)));
          return G__5293__delegate(x, y, z, args)
        };
        G__5293.cljs$lang$arity$variadic = G__5293__delegate;
        return G__5293
      }();
      G__5292 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5292__0.call(this);
          case 1:
            return G__5292__1.call(this, x);
          case 2:
            return G__5292__2.call(this, x, y);
          case 3:
            return G__5292__3.call(this, x, y, z);
          default:
            return G__5292__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5292.cljs$lang$maxFixedArity = 3;
      G__5292.cljs$lang$applyTo = G__5292__4.cljs$lang$applyTo;
      return G__5292
    }()
  };
  var comp__4 = function() {
    var G__5295__delegate = function(f1, f2, f3, fs) {
      var fs__5286 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5296__delegate = function(args) {
          var ret__5287 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5286), args);
          var fs__5288 = cljs.core.next.call(null, fs__5286);
          while(true) {
            if(cljs.core.truth_(fs__5288)) {
              var G__5297 = cljs.core.first.call(null, fs__5288).call(null, ret__5287);
              var G__5298 = cljs.core.next.call(null, fs__5288);
              ret__5287 = G__5297;
              fs__5288 = G__5298;
              continue
            }else {
              return ret__5287
            }
            break
          }
        };
        var G__5296 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5296__delegate.call(this, args)
        };
        G__5296.cljs$lang$maxFixedArity = 0;
        G__5296.cljs$lang$applyTo = function(arglist__5299) {
          var args = cljs.core.seq(arglist__5299);
          return G__5296__delegate(args)
        };
        G__5296.cljs$lang$arity$variadic = G__5296__delegate;
        return G__5296
      }()
    };
    var G__5295 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5295__delegate.call(this, f1, f2, f3, fs)
    };
    G__5295.cljs$lang$maxFixedArity = 3;
    G__5295.cljs$lang$applyTo = function(arglist__5300) {
      var f1 = cljs.core.first(arglist__5300);
      var f2 = cljs.core.first(cljs.core.next(arglist__5300));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5300)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5300)));
      return G__5295__delegate(f1, f2, f3, fs)
    };
    G__5295.cljs$lang$arity$variadic = G__5295__delegate;
    return G__5295
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5301__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5301 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5301__delegate.call(this, args)
      };
      G__5301.cljs$lang$maxFixedArity = 0;
      G__5301.cljs$lang$applyTo = function(arglist__5302) {
        var args = cljs.core.seq(arglist__5302);
        return G__5301__delegate(args)
      };
      G__5301.cljs$lang$arity$variadic = G__5301__delegate;
      return G__5301
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5303__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5303 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5303__delegate.call(this, args)
      };
      G__5303.cljs$lang$maxFixedArity = 0;
      G__5303.cljs$lang$applyTo = function(arglist__5304) {
        var args = cljs.core.seq(arglist__5304);
        return G__5303__delegate(args)
      };
      G__5303.cljs$lang$arity$variadic = G__5303__delegate;
      return G__5303
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5305__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5305 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5305__delegate.call(this, args)
      };
      G__5305.cljs$lang$maxFixedArity = 0;
      G__5305.cljs$lang$applyTo = function(arglist__5306) {
        var args = cljs.core.seq(arglist__5306);
        return G__5305__delegate(args)
      };
      G__5305.cljs$lang$arity$variadic = G__5305__delegate;
      return G__5305
    }()
  };
  var partial__5 = function() {
    var G__5307__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5308__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5308 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5308__delegate.call(this, args)
        };
        G__5308.cljs$lang$maxFixedArity = 0;
        G__5308.cljs$lang$applyTo = function(arglist__5309) {
          var args = cljs.core.seq(arglist__5309);
          return G__5308__delegate(args)
        };
        G__5308.cljs$lang$arity$variadic = G__5308__delegate;
        return G__5308
      }()
    };
    var G__5307 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5307__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5307.cljs$lang$maxFixedArity = 4;
    G__5307.cljs$lang$applyTo = function(arglist__5310) {
      var f = cljs.core.first(arglist__5310);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5310));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5310)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5310))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5310))));
      return G__5307__delegate(f, arg1, arg2, arg3, more)
    };
    G__5307.cljs$lang$arity$variadic = G__5307__delegate;
    return G__5307
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5311 = null;
      var G__5311__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5311__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5311__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5311__4 = function() {
        var G__5312__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5312 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5312__delegate.call(this, a, b, c, ds)
        };
        G__5312.cljs$lang$maxFixedArity = 3;
        G__5312.cljs$lang$applyTo = function(arglist__5313) {
          var a = cljs.core.first(arglist__5313);
          var b = cljs.core.first(cljs.core.next(arglist__5313));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5313)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5313)));
          return G__5312__delegate(a, b, c, ds)
        };
        G__5312.cljs$lang$arity$variadic = G__5312__delegate;
        return G__5312
      }();
      G__5311 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5311__1.call(this, a);
          case 2:
            return G__5311__2.call(this, a, b);
          case 3:
            return G__5311__3.call(this, a, b, c);
          default:
            return G__5311__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5311.cljs$lang$maxFixedArity = 3;
      G__5311.cljs$lang$applyTo = G__5311__4.cljs$lang$applyTo;
      return G__5311
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5314 = null;
      var G__5314__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5314__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5314__4 = function() {
        var G__5315__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5315 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5315__delegate.call(this, a, b, c, ds)
        };
        G__5315.cljs$lang$maxFixedArity = 3;
        G__5315.cljs$lang$applyTo = function(arglist__5316) {
          var a = cljs.core.first(arglist__5316);
          var b = cljs.core.first(cljs.core.next(arglist__5316));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5316)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5316)));
          return G__5315__delegate(a, b, c, ds)
        };
        G__5315.cljs$lang$arity$variadic = G__5315__delegate;
        return G__5315
      }();
      G__5314 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5314__2.call(this, a, b);
          case 3:
            return G__5314__3.call(this, a, b, c);
          default:
            return G__5314__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5314.cljs$lang$maxFixedArity = 3;
      G__5314.cljs$lang$applyTo = G__5314__4.cljs$lang$applyTo;
      return G__5314
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5317 = null;
      var G__5317__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5317__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5317__4 = function() {
        var G__5318__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5318 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5318__delegate.call(this, a, b, c, ds)
        };
        G__5318.cljs$lang$maxFixedArity = 3;
        G__5318.cljs$lang$applyTo = function(arglist__5319) {
          var a = cljs.core.first(arglist__5319);
          var b = cljs.core.first(cljs.core.next(arglist__5319));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5319)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5319)));
          return G__5318__delegate(a, b, c, ds)
        };
        G__5318.cljs$lang$arity$variadic = G__5318__delegate;
        return G__5318
      }();
      G__5317 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5317__2.call(this, a, b);
          case 3:
            return G__5317__3.call(this, a, b, c);
          default:
            return G__5317__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5317.cljs$lang$maxFixedArity = 3;
      G__5317.cljs$lang$applyTo = G__5317__4.cljs$lang$applyTo;
      return G__5317
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5322 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5320 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5320)) {
        var s__5321 = temp__3698__auto____5320;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5321)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5321)))
      }else {
        return null
      }
    })
  };
  return mapi__5322.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5323 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5323)) {
      var s__5324 = temp__3698__auto____5323;
      var x__5325 = f.call(null, cljs.core.first.call(null, s__5324));
      if(x__5325 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5324))
      }else {
        return cljs.core.cons.call(null, x__5325, keep.call(null, f, cljs.core.rest.call(null, s__5324)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5335 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5332 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5332)) {
        var s__5333 = temp__3698__auto____5332;
        var x__5334 = f.call(null, idx, cljs.core.first.call(null, s__5333));
        if(x__5334 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5333))
        }else {
          return cljs.core.cons.call(null, x__5334, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5333)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5335.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5342 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5342)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5342
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5343 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5343)) {
            var and__3546__auto____5344 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5344)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5344
            }
          }else {
            return and__3546__auto____5343
          }
        }())
      };
      var ep1__4 = function() {
        var G__5380__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5345 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5345)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5345
            }
          }())
        };
        var G__5380 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5380__delegate.call(this, x, y, z, args)
        };
        G__5380.cljs$lang$maxFixedArity = 3;
        G__5380.cljs$lang$applyTo = function(arglist__5381) {
          var x = cljs.core.first(arglist__5381);
          var y = cljs.core.first(cljs.core.next(arglist__5381));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5381)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5381)));
          return G__5380__delegate(x, y, z, args)
        };
        G__5380.cljs$lang$arity$variadic = G__5380__delegate;
        return G__5380
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5346 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5346)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5346
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5347 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5347)) {
            var and__3546__auto____5348 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5348)) {
              var and__3546__auto____5349 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5349)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5349
              }
            }else {
              return and__3546__auto____5348
            }
          }else {
            return and__3546__auto____5347
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5350 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5350)) {
            var and__3546__auto____5351 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5351)) {
              var and__3546__auto____5352 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5352)) {
                var and__3546__auto____5353 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5353)) {
                  var and__3546__auto____5354 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5354)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5354
                  }
                }else {
                  return and__3546__auto____5353
                }
              }else {
                return and__3546__auto____5352
              }
            }else {
              return and__3546__auto____5351
            }
          }else {
            return and__3546__auto____5350
          }
        }())
      };
      var ep2__4 = function() {
        var G__5382__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5355 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5355)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5326_SHARP_) {
                var and__3546__auto____5356 = p1.call(null, p1__5326_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5356)) {
                  return p2.call(null, p1__5326_SHARP_)
                }else {
                  return and__3546__auto____5356
                }
              }, args)
            }else {
              return and__3546__auto____5355
            }
          }())
        };
        var G__5382 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5382__delegate.call(this, x, y, z, args)
        };
        G__5382.cljs$lang$maxFixedArity = 3;
        G__5382.cljs$lang$applyTo = function(arglist__5383) {
          var x = cljs.core.first(arglist__5383);
          var y = cljs.core.first(cljs.core.next(arglist__5383));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5383)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5383)));
          return G__5382__delegate(x, y, z, args)
        };
        G__5382.cljs$lang$arity$variadic = G__5382__delegate;
        return G__5382
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5357 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5357)) {
            var and__3546__auto____5358 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5358)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5358
            }
          }else {
            return and__3546__auto____5357
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5359 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5359)) {
            var and__3546__auto____5360 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5360)) {
              var and__3546__auto____5361 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5361)) {
                var and__3546__auto____5362 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5362)) {
                  var and__3546__auto____5363 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5363)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5363
                  }
                }else {
                  return and__3546__auto____5362
                }
              }else {
                return and__3546__auto____5361
              }
            }else {
              return and__3546__auto____5360
            }
          }else {
            return and__3546__auto____5359
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5364 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5364)) {
            var and__3546__auto____5365 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5365)) {
              var and__3546__auto____5366 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5366)) {
                var and__3546__auto____5367 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5367)) {
                  var and__3546__auto____5368 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5368)) {
                    var and__3546__auto____5369 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5369)) {
                      var and__3546__auto____5370 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5370)) {
                        var and__3546__auto____5371 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5371)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5371
                        }
                      }else {
                        return and__3546__auto____5370
                      }
                    }else {
                      return and__3546__auto____5369
                    }
                  }else {
                    return and__3546__auto____5368
                  }
                }else {
                  return and__3546__auto____5367
                }
              }else {
                return and__3546__auto____5366
              }
            }else {
              return and__3546__auto____5365
            }
          }else {
            return and__3546__auto____5364
          }
        }())
      };
      var ep3__4 = function() {
        var G__5384__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5372 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5372)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5327_SHARP_) {
                var and__3546__auto____5373 = p1.call(null, p1__5327_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5373)) {
                  var and__3546__auto____5374 = p2.call(null, p1__5327_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5374)) {
                    return p3.call(null, p1__5327_SHARP_)
                  }else {
                    return and__3546__auto____5374
                  }
                }else {
                  return and__3546__auto____5373
                }
              }, args)
            }else {
              return and__3546__auto____5372
            }
          }())
        };
        var G__5384 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5384__delegate.call(this, x, y, z, args)
        };
        G__5384.cljs$lang$maxFixedArity = 3;
        G__5384.cljs$lang$applyTo = function(arglist__5385) {
          var x = cljs.core.first(arglist__5385);
          var y = cljs.core.first(cljs.core.next(arglist__5385));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5385)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5385)));
          return G__5384__delegate(x, y, z, args)
        };
        G__5384.cljs$lang$arity$variadic = G__5384__delegate;
        return G__5384
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5386__delegate = function(p1, p2, p3, ps) {
      var ps__5375 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5328_SHARP_) {
            return p1__5328_SHARP_.call(null, x)
          }, ps__5375)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5329_SHARP_) {
            var and__3546__auto____5376 = p1__5329_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5376)) {
              return p1__5329_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5376
            }
          }, ps__5375)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5330_SHARP_) {
            var and__3546__auto____5377 = p1__5330_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5377)) {
              var and__3546__auto____5378 = p1__5330_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5378)) {
                return p1__5330_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5378
              }
            }else {
              return and__3546__auto____5377
            }
          }, ps__5375)
        };
        var epn__4 = function() {
          var G__5387__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5379 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5379)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5331_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5331_SHARP_, args)
                }, ps__5375)
              }else {
                return and__3546__auto____5379
              }
            }())
          };
          var G__5387 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5387__delegate.call(this, x, y, z, args)
          };
          G__5387.cljs$lang$maxFixedArity = 3;
          G__5387.cljs$lang$applyTo = function(arglist__5388) {
            var x = cljs.core.first(arglist__5388);
            var y = cljs.core.first(cljs.core.next(arglist__5388));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5388)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5388)));
            return G__5387__delegate(x, y, z, args)
          };
          G__5387.cljs$lang$arity$variadic = G__5387__delegate;
          return G__5387
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5386 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5386__delegate.call(this, p1, p2, p3, ps)
    };
    G__5386.cljs$lang$maxFixedArity = 3;
    G__5386.cljs$lang$applyTo = function(arglist__5389) {
      var p1 = cljs.core.first(arglist__5389);
      var p2 = cljs.core.first(cljs.core.next(arglist__5389));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5389)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5389)));
      return G__5386__delegate(p1, p2, p3, ps)
    };
    G__5386.cljs$lang$arity$variadic = G__5386__delegate;
    return G__5386
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5391 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5391)) {
          return or__3548__auto____5391
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5392 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5392)) {
          return or__3548__auto____5392
        }else {
          var or__3548__auto____5393 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5393)) {
            return or__3548__auto____5393
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5429__delegate = function(x, y, z, args) {
          var or__3548__auto____5394 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5394)) {
            return or__3548__auto____5394
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5429 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5429__delegate.call(this, x, y, z, args)
        };
        G__5429.cljs$lang$maxFixedArity = 3;
        G__5429.cljs$lang$applyTo = function(arglist__5430) {
          var x = cljs.core.first(arglist__5430);
          var y = cljs.core.first(cljs.core.next(arglist__5430));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5430)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5430)));
          return G__5429__delegate(x, y, z, args)
        };
        G__5429.cljs$lang$arity$variadic = G__5429__delegate;
        return G__5429
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5395 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5395)) {
          return or__3548__auto____5395
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5396 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5396)) {
          return or__3548__auto____5396
        }else {
          var or__3548__auto____5397 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5397)) {
            return or__3548__auto____5397
          }else {
            var or__3548__auto____5398 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5398)) {
              return or__3548__auto____5398
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5399 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5399)) {
          return or__3548__auto____5399
        }else {
          var or__3548__auto____5400 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5400)) {
            return or__3548__auto____5400
          }else {
            var or__3548__auto____5401 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5401)) {
              return or__3548__auto____5401
            }else {
              var or__3548__auto____5402 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5402)) {
                return or__3548__auto____5402
              }else {
                var or__3548__auto____5403 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5403)) {
                  return or__3548__auto____5403
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5431__delegate = function(x, y, z, args) {
          var or__3548__auto____5404 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5404)) {
            return or__3548__auto____5404
          }else {
            return cljs.core.some.call(null, function(p1__5336_SHARP_) {
              var or__3548__auto____5405 = p1.call(null, p1__5336_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5405)) {
                return or__3548__auto____5405
              }else {
                return p2.call(null, p1__5336_SHARP_)
              }
            }, args)
          }
        };
        var G__5431 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5431__delegate.call(this, x, y, z, args)
        };
        G__5431.cljs$lang$maxFixedArity = 3;
        G__5431.cljs$lang$applyTo = function(arglist__5432) {
          var x = cljs.core.first(arglist__5432);
          var y = cljs.core.first(cljs.core.next(arglist__5432));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5432)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5432)));
          return G__5431__delegate(x, y, z, args)
        };
        G__5431.cljs$lang$arity$variadic = G__5431__delegate;
        return G__5431
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5406 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5406)) {
          return or__3548__auto____5406
        }else {
          var or__3548__auto____5407 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5407)) {
            return or__3548__auto____5407
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5408 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5408)) {
          return or__3548__auto____5408
        }else {
          var or__3548__auto____5409 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5409)) {
            return or__3548__auto____5409
          }else {
            var or__3548__auto____5410 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5410)) {
              return or__3548__auto____5410
            }else {
              var or__3548__auto____5411 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5411)) {
                return or__3548__auto____5411
              }else {
                var or__3548__auto____5412 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5412)) {
                  return or__3548__auto____5412
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5413 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5413)) {
          return or__3548__auto____5413
        }else {
          var or__3548__auto____5414 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5414)) {
            return or__3548__auto____5414
          }else {
            var or__3548__auto____5415 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5415)) {
              return or__3548__auto____5415
            }else {
              var or__3548__auto____5416 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5416)) {
                return or__3548__auto____5416
              }else {
                var or__3548__auto____5417 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5417)) {
                  return or__3548__auto____5417
                }else {
                  var or__3548__auto____5418 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5418)) {
                    return or__3548__auto____5418
                  }else {
                    var or__3548__auto____5419 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5419)) {
                      return or__3548__auto____5419
                    }else {
                      var or__3548__auto____5420 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5420)) {
                        return or__3548__auto____5420
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5433__delegate = function(x, y, z, args) {
          var or__3548__auto____5421 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5421)) {
            return or__3548__auto____5421
          }else {
            return cljs.core.some.call(null, function(p1__5337_SHARP_) {
              var or__3548__auto____5422 = p1.call(null, p1__5337_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5422)) {
                return or__3548__auto____5422
              }else {
                var or__3548__auto____5423 = p2.call(null, p1__5337_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5423)) {
                  return or__3548__auto____5423
                }else {
                  return p3.call(null, p1__5337_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5433 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5433__delegate.call(this, x, y, z, args)
        };
        G__5433.cljs$lang$maxFixedArity = 3;
        G__5433.cljs$lang$applyTo = function(arglist__5434) {
          var x = cljs.core.first(arglist__5434);
          var y = cljs.core.first(cljs.core.next(arglist__5434));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5434)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5434)));
          return G__5433__delegate(x, y, z, args)
        };
        G__5433.cljs$lang$arity$variadic = G__5433__delegate;
        return G__5433
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5435__delegate = function(p1, p2, p3, ps) {
      var ps__5424 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5338_SHARP_) {
            return p1__5338_SHARP_.call(null, x)
          }, ps__5424)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5339_SHARP_) {
            var or__3548__auto____5425 = p1__5339_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5425)) {
              return or__3548__auto____5425
            }else {
              return p1__5339_SHARP_.call(null, y)
            }
          }, ps__5424)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5340_SHARP_) {
            var or__3548__auto____5426 = p1__5340_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5426)) {
              return or__3548__auto____5426
            }else {
              var or__3548__auto____5427 = p1__5340_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5427)) {
                return or__3548__auto____5427
              }else {
                return p1__5340_SHARP_.call(null, z)
              }
            }
          }, ps__5424)
        };
        var spn__4 = function() {
          var G__5436__delegate = function(x, y, z, args) {
            var or__3548__auto____5428 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5428)) {
              return or__3548__auto____5428
            }else {
              return cljs.core.some.call(null, function(p1__5341_SHARP_) {
                return cljs.core.some.call(null, p1__5341_SHARP_, args)
              }, ps__5424)
            }
          };
          var G__5436 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5436__delegate.call(this, x, y, z, args)
          };
          G__5436.cljs$lang$maxFixedArity = 3;
          G__5436.cljs$lang$applyTo = function(arglist__5437) {
            var x = cljs.core.first(arglist__5437);
            var y = cljs.core.first(cljs.core.next(arglist__5437));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5437)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5437)));
            return G__5436__delegate(x, y, z, args)
          };
          G__5436.cljs$lang$arity$variadic = G__5436__delegate;
          return G__5436
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5435 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5435__delegate.call(this, p1, p2, p3, ps)
    };
    G__5435.cljs$lang$maxFixedArity = 3;
    G__5435.cljs$lang$applyTo = function(arglist__5438) {
      var p1 = cljs.core.first(arglist__5438);
      var p2 = cljs.core.first(cljs.core.next(arglist__5438));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5438)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5438)));
      return G__5435__delegate(p1, p2, p3, ps)
    };
    G__5435.cljs$lang$arity$variadic = G__5435__delegate;
    return G__5435
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5439 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5439)) {
        var s__5440 = temp__3698__auto____5439;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5440)), map.call(null, f, cljs.core.rest.call(null, s__5440)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5441 = cljs.core.seq.call(null, c1);
      var s2__5442 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5443 = s1__5441;
        if(cljs.core.truth_(and__3546__auto____5443)) {
          return s2__5442
        }else {
          return and__3546__auto____5443
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5441), cljs.core.first.call(null, s2__5442)), map.call(null, f, cljs.core.rest.call(null, s1__5441), cljs.core.rest.call(null, s2__5442)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5444 = cljs.core.seq.call(null, c1);
      var s2__5445 = cljs.core.seq.call(null, c2);
      var s3__5446 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5447 = s1__5444;
        if(cljs.core.truth_(and__3546__auto____5447)) {
          var and__3546__auto____5448 = s2__5445;
          if(cljs.core.truth_(and__3546__auto____5448)) {
            return s3__5446
          }else {
            return and__3546__auto____5448
          }
        }else {
          return and__3546__auto____5447
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5444), cljs.core.first.call(null, s2__5445), cljs.core.first.call(null, s3__5446)), map.call(null, f, cljs.core.rest.call(null, s1__5444), cljs.core.rest.call(null, s2__5445), cljs.core.rest.call(null, s3__5446)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5451__delegate = function(f, c1, c2, c3, colls) {
      var step__5450 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5449 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5449)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5449), step.call(null, map.call(null, cljs.core.rest, ss__5449)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5390_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5390_SHARP_)
      }, step__5450.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5451 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5451__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5451.cljs$lang$maxFixedArity = 4;
    G__5451.cljs$lang$applyTo = function(arglist__5452) {
      var f = cljs.core.first(arglist__5452);
      var c1 = cljs.core.first(cljs.core.next(arglist__5452));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5452)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5452))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5452))));
      return G__5451__delegate(f, c1, c2, c3, colls)
    };
    G__5451.cljs$lang$arity$variadic = G__5451__delegate;
    return G__5451
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5453 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5453)) {
        var s__5454 = temp__3698__auto____5453;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5454), take.call(null, n - 1, cljs.core.rest.call(null, s__5454)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5457 = function(n, coll) {
    while(true) {
      var s__5455 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5456 = n > 0;
        if(and__3546__auto____5456) {
          return s__5455
        }else {
          return and__3546__auto____5456
        }
      }())) {
        var G__5458 = n - 1;
        var G__5459 = cljs.core.rest.call(null, s__5455);
        n = G__5458;
        coll = G__5459;
        continue
      }else {
        return s__5455
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5457.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5460 = cljs.core.seq.call(null, coll);
  var lead__5461 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5461)) {
      var G__5462 = cljs.core.next.call(null, s__5460);
      var G__5463 = cljs.core.next.call(null, lead__5461);
      s__5460 = G__5462;
      lead__5461 = G__5463;
      continue
    }else {
      return s__5460
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5466 = function(pred, coll) {
    while(true) {
      var s__5464 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5465 = s__5464;
        if(cljs.core.truth_(and__3546__auto____5465)) {
          return pred.call(null, cljs.core.first.call(null, s__5464))
        }else {
          return and__3546__auto____5465
        }
      }())) {
        var G__5467 = pred;
        var G__5468 = cljs.core.rest.call(null, s__5464);
        pred = G__5467;
        coll = G__5468;
        continue
      }else {
        return s__5464
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5466.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5469 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5469)) {
      var s__5470 = temp__3698__auto____5469;
      return cljs.core.concat.call(null, s__5470, cycle.call(null, s__5470))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5471 = cljs.core.seq.call(null, c1);
      var s2__5472 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5473 = s1__5471;
        if(cljs.core.truth_(and__3546__auto____5473)) {
          return s2__5472
        }else {
          return and__3546__auto____5473
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5471), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5472), interleave.call(null, cljs.core.rest.call(null, s1__5471), cljs.core.rest.call(null, s2__5472))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5475__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5474 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5474)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5474), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5474)))
        }else {
          return null
        }
      })
    };
    var G__5475 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5475__delegate.call(this, c1, c2, colls)
    };
    G__5475.cljs$lang$maxFixedArity = 2;
    G__5475.cljs$lang$applyTo = function(arglist__5476) {
      var c1 = cljs.core.first(arglist__5476);
      var c2 = cljs.core.first(cljs.core.next(arglist__5476));
      var colls = cljs.core.rest(cljs.core.next(arglist__5476));
      return G__5475__delegate(c1, c2, colls)
    };
    G__5475.cljs$lang$arity$variadic = G__5475__delegate;
    return G__5475
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5479 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5477 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5477)) {
        var coll__5478 = temp__3695__auto____5477;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5478), cat.call(null, cljs.core.rest.call(null, coll__5478), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5479.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5480__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5480 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5480__delegate.call(this, f, coll, colls)
    };
    G__5480.cljs$lang$maxFixedArity = 2;
    G__5480.cljs$lang$applyTo = function(arglist__5481) {
      var f = cljs.core.first(arglist__5481);
      var coll = cljs.core.first(cljs.core.next(arglist__5481));
      var colls = cljs.core.rest(cljs.core.next(arglist__5481));
      return G__5480__delegate(f, coll, colls)
    };
    G__5480.cljs$lang$arity$variadic = G__5480__delegate;
    return G__5480
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5482 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5482)) {
      var s__5483 = temp__3698__auto____5482;
      var f__5484 = cljs.core.first.call(null, s__5483);
      var r__5485 = cljs.core.rest.call(null, s__5483);
      if(cljs.core.truth_(pred.call(null, f__5484))) {
        return cljs.core.cons.call(null, f__5484, filter.call(null, pred, r__5485))
      }else {
        return filter.call(null, pred, r__5485)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5487 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5487.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5486_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5486_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5488__5489 = to;
    if(G__5488__5489 != null) {
      if(function() {
        var or__3548__auto____5490 = G__5488__5489.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5490) {
          return or__3548__auto____5490
        }else {
          return G__5488__5489.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5488__5489.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5488__5489)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5488__5489)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5491__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5491 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5491__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5491.cljs$lang$maxFixedArity = 4;
    G__5491.cljs$lang$applyTo = function(arglist__5492) {
      var f = cljs.core.first(arglist__5492);
      var c1 = cljs.core.first(cljs.core.next(arglist__5492));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5492)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5492))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5492))));
      return G__5491__delegate(f, c1, c2, c3, colls)
    };
    G__5491.cljs$lang$arity$variadic = G__5491__delegate;
    return G__5491
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5493 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5493)) {
        var s__5494 = temp__3698__auto____5493;
        var p__5495 = cljs.core.take.call(null, n, s__5494);
        if(n === cljs.core.count.call(null, p__5495)) {
          return cljs.core.cons.call(null, p__5495, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5494)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5496 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5496)) {
        var s__5497 = temp__3698__auto____5496;
        var p__5498 = cljs.core.take.call(null, n, s__5497);
        if(n === cljs.core.count.call(null, p__5498)) {
          return cljs.core.cons.call(null, p__5498, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5497)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5498, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5499 = cljs.core.lookup_sentinel;
    var m__5500 = m;
    var ks__5501 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5501)) {
        var m__5502 = cljs.core.get.call(null, m__5500, cljs.core.first.call(null, ks__5501), sentinel__5499);
        if(sentinel__5499 === m__5502) {
          return not_found
        }else {
          var G__5503 = sentinel__5499;
          var G__5504 = m__5502;
          var G__5505 = cljs.core.next.call(null, ks__5501);
          sentinel__5499 = G__5503;
          m__5500 = G__5504;
          ks__5501 = G__5505;
          continue
        }
      }else {
        return m__5500
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5506, v) {
  var vec__5507__5508 = p__5506;
  var k__5509 = cljs.core.nth.call(null, vec__5507__5508, 0, null);
  var ks__5510 = cljs.core.nthnext.call(null, vec__5507__5508, 1);
  if(cljs.core.truth_(ks__5510)) {
    return cljs.core.assoc.call(null, m, k__5509, assoc_in.call(null, cljs.core.get.call(null, m, k__5509), ks__5510, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5509, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5511, f, args) {
    var vec__5512__5513 = p__5511;
    var k__5514 = cljs.core.nth.call(null, vec__5512__5513, 0, null);
    var ks__5515 = cljs.core.nthnext.call(null, vec__5512__5513, 1);
    if(cljs.core.truth_(ks__5515)) {
      return cljs.core.assoc.call(null, m, k__5514, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5514), ks__5515, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5514, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5514), args))
    }
  };
  var update_in = function(m, p__5511, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5511, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5516) {
    var m = cljs.core.first(arglist__5516);
    var p__5511 = cljs.core.first(cljs.core.next(arglist__5516));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5516)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5516)));
    return update_in__delegate(m, p__5511, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5521 = this;
  var h__364__auto____5522 = this__5521.__hash;
  if(h__364__auto____5522 != null) {
    return h__364__auto____5522
  }else {
    var h__364__auto____5523 = cljs.core.hash_coll.call(null, coll);
    this__5521.__hash = h__364__auto____5523;
    return h__364__auto____5523
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5524 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5525 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5526 = this;
  var new_array__5527 = cljs.core.aclone.call(null, this__5526.array);
  new_array__5527[k] = v;
  return new cljs.core.Vector(this__5526.meta, new_array__5527, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5556 = null;
  var G__5556__2 = function(tsym5519, k) {
    var this__5528 = this;
    var tsym5519__5529 = this;
    var coll__5530 = tsym5519__5529;
    return cljs.core._lookup.call(null, coll__5530, k)
  };
  var G__5556__3 = function(tsym5520, k, not_found) {
    var this__5531 = this;
    var tsym5520__5532 = this;
    var coll__5533 = tsym5520__5532;
    return cljs.core._lookup.call(null, coll__5533, k, not_found)
  };
  G__5556 = function(tsym5520, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5556__2.call(this, tsym5520, k);
      case 3:
        return G__5556__3.call(this, tsym5520, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5556
}();
cljs.core.Vector.prototype.apply = function(tsym5517, args5518) {
  return tsym5517.call.apply(tsym5517, [tsym5517].concat(cljs.core.aclone.call(null, args5518)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5534 = this;
  var new_array__5535 = cljs.core.aclone.call(null, this__5534.array);
  new_array__5535.push(o);
  return new cljs.core.Vector(this__5534.meta, new_array__5535, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5536 = this;
  var this$__5537 = this;
  return cljs.core.pr_str.call(null, this$__5537)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5538 = this;
  return cljs.core.ci_reduce.call(null, this__5538.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5539 = this;
  return cljs.core.ci_reduce.call(null, this__5539.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5540 = this;
  if(this__5540.array.length > 0) {
    var vector_seq__5541 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5540.array.length) {
          return cljs.core.cons.call(null, this__5540.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5541.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5542 = this;
  return this__5542.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5543 = this;
  var count__5544 = this__5543.array.length;
  if(count__5544 > 0) {
    return this__5543.array[count__5544 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5545 = this;
  if(this__5545.array.length > 0) {
    var new_array__5546 = cljs.core.aclone.call(null, this__5545.array);
    new_array__5546.pop();
    return new cljs.core.Vector(this__5545.meta, new_array__5546, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5547 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5548 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5549 = this;
  return new cljs.core.Vector(meta, this__5549.array, this__5549.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5550 = this;
  return this__5550.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5552 = this;
  if(function() {
    var and__3546__auto____5553 = 0 <= n;
    if(and__3546__auto____5553) {
      return n < this__5552.array.length
    }else {
      return and__3546__auto____5553
    }
  }()) {
    return this__5552.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5554 = this;
  if(function() {
    var and__3546__auto____5555 = 0 <= n;
    if(and__3546__auto____5555) {
      return n < this__5554.array.length
    }else {
      return and__3546__auto____5555
    }
  }()) {
    return this__5554.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5551 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5551.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__437__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5557 = pv.cnt;
  if(cnt__5557 < 32) {
    return 0
  }else {
    return cnt__5557 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5558 = level;
  var ret__5559 = node;
  while(true) {
    if(ll__5558 === 0) {
      return ret__5559
    }else {
      var embed__5560 = ret__5559;
      var r__5561 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5562 = cljs.core.pv_aset.call(null, r__5561, 0, embed__5560);
      var G__5563 = ll__5558 - 5;
      var G__5564 = r__5561;
      ll__5558 = G__5563;
      ret__5559 = G__5564;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5565 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5566 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5565, subidx__5566, tailnode);
    return ret__5565
  }else {
    var temp__3695__auto____5567 = cljs.core.pv_aget.call(null, parent, subidx__5566);
    if(cljs.core.truth_(temp__3695__auto____5567)) {
      var child__5568 = temp__3695__auto____5567;
      var node_to_insert__5569 = push_tail.call(null, pv, level - 5, child__5568, tailnode);
      cljs.core.pv_aset.call(null, ret__5565, subidx__5566, node_to_insert__5569);
      return ret__5565
    }else {
      var node_to_insert__5570 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5565, subidx__5566, node_to_insert__5570);
      return ret__5565
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5571 = 0 <= i;
    if(and__3546__auto____5571) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5571
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5572 = pv.root;
      var level__5573 = pv.shift;
      while(true) {
        if(level__5573 > 0) {
          var G__5574 = cljs.core.pv_aget.call(null, node__5572, i >>> level__5573 & 31);
          var G__5575 = level__5573 - 5;
          node__5572 = G__5574;
          level__5573 = G__5575;
          continue
        }else {
          return node__5572.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5576 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5576, i & 31, val);
    return ret__5576
  }else {
    var subidx__5577 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5576, subidx__5577, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5577), i, val));
    return ret__5576
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5578 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5579 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5578));
    if(function() {
      var and__3546__auto____5580 = new_child__5579 == null;
      if(and__3546__auto____5580) {
        return subidx__5578 === 0
      }else {
        return and__3546__auto____5580
      }
    }()) {
      return null
    }else {
      var ret__5581 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5581, subidx__5578, new_child__5579);
      return ret__5581
    }
  }else {
    if(subidx__5578 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5582 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5582, subidx__5578, null);
        return ret__5582
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5583 = cljs.core._count.call(null, v);
  if(c__5583 > 0) {
    if(void 0 === cljs.core.t5584) {
      cljs.core.t5584 = function(c, offset, v, vector_seq, __meta__371__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__371__auto__ = __meta__371__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5584.cljs$lang$type = true;
      cljs.core.t5584.cljs$lang$ctorPrSeq = function(this__436__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5584")
      };
      cljs.core.t5584.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5584.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5585 = this;
        return vseq
      };
      cljs.core.t5584.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5584.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5586 = this;
        return cljs.core._nth.call(null, this__5586.v, this__5586.offset)
      };
      cljs.core.t5584.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5587 = this;
        var offset__5588 = this__5587.offset + 1;
        if(offset__5588 < this__5587.c) {
          return this__5587.vector_seq.call(null, this__5587.v, offset__5588)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5584.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5584.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5584.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5589 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5584.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5584.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5584.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5590 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5584.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5584.prototype.cljs$core$IMeta$_meta$arity$1 = function(___372__auto__) {
        var this__5591 = this;
        return this__5591.__meta__371__auto__
      };
      cljs.core.t5584.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5584.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___372__auto__, __meta__371__auto__) {
        var this__5592 = this;
        return new cljs.core.t5584(this__5592.c, this__5592.offset, this__5592.v, this__5592.vector_seq, __meta__371__auto__)
      };
      cljs.core.t5584
    }else {
    }
    return new cljs.core.t5584(c__5583, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5597 = this;
  return new cljs.core.TransientVector(this__5597.cnt, this__5597.shift, cljs.core.tv_editable_root.call(null, this__5597.root), cljs.core.tv_editable_tail.call(null, this__5597.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5598 = this;
  var h__364__auto____5599 = this__5598.__hash;
  if(h__364__auto____5599 != null) {
    return h__364__auto____5599
  }else {
    var h__364__auto____5600 = cljs.core.hash_coll.call(null, coll);
    this__5598.__hash = h__364__auto____5600;
    return h__364__auto____5600
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5601 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5602 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5603 = this;
  if(function() {
    var and__3546__auto____5604 = 0 <= k;
    if(and__3546__auto____5604) {
      return k < this__5603.cnt
    }else {
      return and__3546__auto____5604
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5605 = cljs.core.aclone.call(null, this__5603.tail);
      new_tail__5605[k & 31] = v;
      return new cljs.core.PersistentVector(this__5603.meta, this__5603.cnt, this__5603.shift, this__5603.root, new_tail__5605, null)
    }else {
      return new cljs.core.PersistentVector(this__5603.meta, this__5603.cnt, this__5603.shift, cljs.core.do_assoc.call(null, coll, this__5603.shift, this__5603.root, k, v), this__5603.tail, null)
    }
  }else {
    if(k === this__5603.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5603.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5650 = null;
  var G__5650__2 = function(tsym5595, k) {
    var this__5606 = this;
    var tsym5595__5607 = this;
    var coll__5608 = tsym5595__5607;
    return cljs.core._lookup.call(null, coll__5608, k)
  };
  var G__5650__3 = function(tsym5596, k, not_found) {
    var this__5609 = this;
    var tsym5596__5610 = this;
    var coll__5611 = tsym5596__5610;
    return cljs.core._lookup.call(null, coll__5611, k, not_found)
  };
  G__5650 = function(tsym5596, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5650__2.call(this, tsym5596, k);
      case 3:
        return G__5650__3.call(this, tsym5596, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5650
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5593, args5594) {
  return tsym5593.call.apply(tsym5593, [tsym5593].concat(cljs.core.aclone.call(null, args5594)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5612 = this;
  var step_init__5613 = [0, init];
  var i__5614 = 0;
  while(true) {
    if(i__5614 < this__5612.cnt) {
      var arr__5615 = cljs.core.array_for.call(null, v, i__5614);
      var len__5616 = arr__5615.length;
      var init__5620 = function() {
        var j__5617 = 0;
        var init__5618 = step_init__5613[1];
        while(true) {
          if(j__5617 < len__5616) {
            var init__5619 = f.call(null, init__5618, j__5617 + i__5614, arr__5615[j__5617]);
            if(cljs.core.reduced_QMARK_.call(null, init__5619)) {
              return init__5619
            }else {
              var G__5651 = j__5617 + 1;
              var G__5652 = init__5619;
              j__5617 = G__5651;
              init__5618 = G__5652;
              continue
            }
          }else {
            step_init__5613[0] = len__5616;
            step_init__5613[1] = init__5618;
            return init__5618
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5620)) {
        return cljs.core.deref.call(null, init__5620)
      }else {
        var G__5653 = i__5614 + step_init__5613[0];
        i__5614 = G__5653;
        continue
      }
    }else {
      return step_init__5613[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5621 = this;
  if(this__5621.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5622 = cljs.core.aclone.call(null, this__5621.tail);
    new_tail__5622.push(o);
    return new cljs.core.PersistentVector(this__5621.meta, this__5621.cnt + 1, this__5621.shift, this__5621.root, new_tail__5622, null)
  }else {
    var root_overflow_QMARK___5623 = this__5621.cnt >>> 5 > 1 << this__5621.shift;
    var new_shift__5624 = root_overflow_QMARK___5623 ? this__5621.shift + 5 : this__5621.shift;
    var new_root__5626 = root_overflow_QMARK___5623 ? function() {
      var n_r__5625 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5625, 0, this__5621.root);
      cljs.core.pv_aset.call(null, n_r__5625, 1, cljs.core.new_path.call(null, null, this__5621.shift, new cljs.core.VectorNode(null, this__5621.tail)));
      return n_r__5625
    }() : cljs.core.push_tail.call(null, coll, this__5621.shift, this__5621.root, new cljs.core.VectorNode(null, this__5621.tail));
    return new cljs.core.PersistentVector(this__5621.meta, this__5621.cnt + 1, new_shift__5624, new_root__5626, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5627 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5628 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5629 = this;
  var this$__5630 = this;
  return cljs.core.pr_str.call(null, this$__5630)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5631 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5632 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5633 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5634 = this;
  return this__5634.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5635 = this;
  if(this__5635.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5635.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5636 = this;
  if(this__5636.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5636.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5636.meta)
    }else {
      if(1 < this__5636.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5636.meta, this__5636.cnt - 1, this__5636.shift, this__5636.root, this__5636.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5637 = cljs.core.array_for.call(null, coll, this__5636.cnt - 2);
          var nr__5638 = cljs.core.pop_tail.call(null, coll, this__5636.shift, this__5636.root);
          var new_root__5639 = nr__5638 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5638;
          var cnt_1__5640 = this__5636.cnt - 1;
          if(function() {
            var and__3546__auto____5641 = 5 < this__5636.shift;
            if(and__3546__auto____5641) {
              return cljs.core.pv_aget.call(null, new_root__5639, 1) == null
            }else {
              return and__3546__auto____5641
            }
          }()) {
            return new cljs.core.PersistentVector(this__5636.meta, cnt_1__5640, this__5636.shift - 5, cljs.core.pv_aget.call(null, new_root__5639, 0), new_tail__5637, null)
          }else {
            return new cljs.core.PersistentVector(this__5636.meta, cnt_1__5640, this__5636.shift, new_root__5639, new_tail__5637, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5643 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5644 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5645 = this;
  return new cljs.core.PersistentVector(meta, this__5645.cnt, this__5645.shift, this__5645.root, this__5645.tail, this__5645.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5646 = this;
  return this__5646.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5647 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5648 = this;
  if(function() {
    var and__3546__auto____5649 = 0 <= n;
    if(and__3546__auto____5649) {
      return n < this__5648.cnt
    }else {
      return and__3546__auto____5649
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5642 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5642.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5654 = cljs.core.seq.call(null, xs);
  var out__5655 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5654)) {
      var G__5656 = cljs.core.next.call(null, xs__5654);
      var G__5657 = cljs.core.conj_BANG_.call(null, out__5655, cljs.core.first.call(null, xs__5654));
      xs__5654 = G__5656;
      out__5655 = G__5657;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5655)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__5658) {
    var args = cljs.core.seq(arglist__5658);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5663 = this;
  var h__364__auto____5664 = this__5663.__hash;
  if(h__364__auto____5664 != null) {
    return h__364__auto____5664
  }else {
    var h__364__auto____5665 = cljs.core.hash_coll.call(null, coll);
    this__5663.__hash = h__364__auto____5665;
    return h__364__auto____5665
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5666 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5667 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__5668 = this;
  var v_pos__5669 = this__5668.start + key;
  return new cljs.core.Subvec(this__5668.meta, cljs.core._assoc.call(null, this__5668.v, v_pos__5669, val), this__5668.start, this__5668.end > v_pos__5669 + 1 ? this__5668.end : v_pos__5669 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__5693 = null;
  var G__5693__2 = function(tsym5661, k) {
    var this__5670 = this;
    var tsym5661__5671 = this;
    var coll__5672 = tsym5661__5671;
    return cljs.core._lookup.call(null, coll__5672, k)
  };
  var G__5693__3 = function(tsym5662, k, not_found) {
    var this__5673 = this;
    var tsym5662__5674 = this;
    var coll__5675 = tsym5662__5674;
    return cljs.core._lookup.call(null, coll__5675, k, not_found)
  };
  G__5693 = function(tsym5662, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5693__2.call(this, tsym5662, k);
      case 3:
        return G__5693__3.call(this, tsym5662, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5693
}();
cljs.core.Subvec.prototype.apply = function(tsym5659, args5660) {
  return tsym5659.call.apply(tsym5659, [tsym5659].concat(cljs.core.aclone.call(null, args5660)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5676 = this;
  return new cljs.core.Subvec(this__5676.meta, cljs.core._assoc_n.call(null, this__5676.v, this__5676.end, o), this__5676.start, this__5676.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__5677 = this;
  var this$__5678 = this;
  return cljs.core.pr_str.call(null, this$__5678)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5679 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5680 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5681 = this;
  var subvec_seq__5682 = function subvec_seq(i) {
    if(i === this__5681.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__5681.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__5682.call(null, this__5681.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5683 = this;
  return this__5683.end - this__5683.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5684 = this;
  return cljs.core._nth.call(null, this__5684.v, this__5684.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5685 = this;
  if(this__5685.start === this__5685.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__5685.meta, this__5685.v, this__5685.start, this__5685.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5686 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5687 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5688 = this;
  return new cljs.core.Subvec(meta, this__5688.v, this__5688.start, this__5688.end, this__5688.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5689 = this;
  return this__5689.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5691 = this;
  return cljs.core._nth.call(null, this__5691.v, this__5691.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5692 = this;
  return cljs.core._nth.call(null, this__5692.v, this__5692.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5690 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5690.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__5694 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__5694, 0, tl.length);
  return ret__5694
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__5695 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__5696 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__5695, subidx__5696, level === 5 ? tail_node : function() {
    var child__5697 = cljs.core.pv_aget.call(null, ret__5695, subidx__5696);
    if(child__5697 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__5697, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__5695
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__5698 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__5699 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5700 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__5698, subidx__5699));
    if(function() {
      var and__3546__auto____5701 = new_child__5700 == null;
      if(and__3546__auto____5701) {
        return subidx__5699 === 0
      }else {
        return and__3546__auto____5701
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__5698, subidx__5699, new_child__5700);
      return node__5698
    }
  }else {
    if(subidx__5699 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__5698, subidx__5699, null);
        return node__5698
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____5702 = 0 <= i;
    if(and__3546__auto____5702) {
      return i < tv.cnt
    }else {
      return and__3546__auto____5702
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__5703 = tv.root;
      var node__5704 = root__5703;
      var level__5705 = tv.shift;
      while(true) {
        if(level__5705 > 0) {
          var G__5706 = cljs.core.tv_ensure_editable.call(null, root__5703.edit, cljs.core.pv_aget.call(null, node__5704, i >>> level__5705 & 31));
          var G__5707 = level__5705 - 5;
          node__5704 = G__5706;
          level__5705 = G__5707;
          continue
        }else {
          return node__5704.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__5745 = null;
  var G__5745__2 = function(tsym5710, k) {
    var this__5712 = this;
    var tsym5710__5713 = this;
    var coll__5714 = tsym5710__5713;
    return cljs.core._lookup.call(null, coll__5714, k)
  };
  var G__5745__3 = function(tsym5711, k, not_found) {
    var this__5715 = this;
    var tsym5711__5716 = this;
    var coll__5717 = tsym5711__5716;
    return cljs.core._lookup.call(null, coll__5717, k, not_found)
  };
  G__5745 = function(tsym5711, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5745__2.call(this, tsym5711, k);
      case 3:
        return G__5745__3.call(this, tsym5711, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5745
}();
cljs.core.TransientVector.prototype.apply = function(tsym5708, args5709) {
  return tsym5708.call.apply(tsym5708, [tsym5708].concat(cljs.core.aclone.call(null, args5709)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5718 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5719 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5720 = this;
  if(cljs.core.truth_(this__5720.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5721 = this;
  if(function() {
    var and__3546__auto____5722 = 0 <= n;
    if(and__3546__auto____5722) {
      return n < this__5721.cnt
    }else {
      return and__3546__auto____5722
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5723 = this;
  if(cljs.core.truth_(this__5723.root.edit)) {
    return this__5723.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__5724 = this;
  if(cljs.core.truth_(this__5724.root.edit)) {
    if(function() {
      var and__3546__auto____5725 = 0 <= n;
      if(and__3546__auto____5725) {
        return n < this__5724.cnt
      }else {
        return and__3546__auto____5725
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__5724.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__5728 = function go(level, node) {
          var node__5726 = cljs.core.tv_ensure_editable.call(null, this__5724.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__5726, n & 31, val);
            return node__5726
          }else {
            var subidx__5727 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__5726, subidx__5727, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__5726, subidx__5727)));
            return node__5726
          }
        }.call(null, this__5724.shift, this__5724.root);
        this__5724.root = new_root__5728;
        return tcoll
      }
    }else {
      if(n === this__5724.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__5724.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__5729 = this;
  if(cljs.core.truth_(this__5729.root.edit)) {
    if(this__5729.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__5729.cnt) {
        this__5729.cnt = 0;
        return tcoll
      }else {
        if((this__5729.cnt - 1 & 31) > 0) {
          this__5729.cnt = this__5729.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__5730 = cljs.core.editable_array_for.call(null, tcoll, this__5729.cnt - 2);
            var new_root__5732 = function() {
              var nr__5731 = cljs.core.tv_pop_tail.call(null, tcoll, this__5729.shift, this__5729.root);
              if(nr__5731 != null) {
                return nr__5731
              }else {
                return new cljs.core.VectorNode(this__5729.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____5733 = 5 < this__5729.shift;
              if(and__3546__auto____5733) {
                return cljs.core.pv_aget.call(null, new_root__5732, 1) == null
              }else {
                return and__3546__auto____5733
              }
            }()) {
              var new_root__5734 = cljs.core.tv_ensure_editable.call(null, this__5729.root.edit, cljs.core.pv_aget.call(null, new_root__5732, 0));
              this__5729.root = new_root__5734;
              this__5729.shift = this__5729.shift - 5;
              this__5729.cnt = this__5729.cnt - 1;
              this__5729.tail = new_tail__5730;
              return tcoll
            }else {
              this__5729.root = new_root__5732;
              this__5729.cnt = this__5729.cnt - 1;
              this__5729.tail = new_tail__5730;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__5735 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__5736 = this;
  if(cljs.core.truth_(this__5736.root.edit)) {
    if(this__5736.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__5736.tail[this__5736.cnt & 31] = o;
      this__5736.cnt = this__5736.cnt + 1;
      return tcoll
    }else {
      var tail_node__5737 = new cljs.core.VectorNode(this__5736.root.edit, this__5736.tail);
      var new_tail__5738 = cljs.core.make_array.call(null, 32);
      new_tail__5738[0] = o;
      this__5736.tail = new_tail__5738;
      if(this__5736.cnt >>> 5 > 1 << this__5736.shift) {
        var new_root_array__5739 = cljs.core.make_array.call(null, 32);
        var new_shift__5740 = this__5736.shift + 5;
        new_root_array__5739[0] = this__5736.root;
        new_root_array__5739[1] = cljs.core.new_path.call(null, this__5736.root.edit, this__5736.shift, tail_node__5737);
        this__5736.root = new cljs.core.VectorNode(this__5736.root.edit, new_root_array__5739);
        this__5736.shift = new_shift__5740;
        this__5736.cnt = this__5736.cnt + 1;
        return tcoll
      }else {
        var new_root__5741 = cljs.core.tv_push_tail.call(null, tcoll, this__5736.shift, this__5736.root, tail_node__5737);
        this__5736.root = new_root__5741;
        this__5736.cnt = this__5736.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__5742 = this;
  if(cljs.core.truth_(this__5742.root.edit)) {
    this__5742.root.edit = null;
    var len__5743 = this__5742.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__5744 = cljs.core.make_array.call(null, len__5743);
    cljs.core.array_copy.call(null, this__5742.tail, 0, trimmed_tail__5744, 0, len__5743);
    return new cljs.core.PersistentVector(null, this__5742.cnt, this__5742.shift, this__5742.root, trimmed_tail__5744, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5746 = this;
  var h__364__auto____5747 = this__5746.__hash;
  if(h__364__auto____5747 != null) {
    return h__364__auto____5747
  }else {
    var h__364__auto____5748 = cljs.core.hash_coll.call(null, coll);
    this__5746.__hash = h__364__auto____5748;
    return h__364__auto____5748
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5749 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__5750 = this;
  var this$__5751 = this;
  return cljs.core.pr_str.call(null, this$__5751)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5752 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5753 = this;
  return cljs.core._first.call(null, this__5753.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5754 = this;
  var temp__3695__auto____5755 = cljs.core.next.call(null, this__5754.front);
  if(cljs.core.truth_(temp__3695__auto____5755)) {
    var f1__5756 = temp__3695__auto____5755;
    return new cljs.core.PersistentQueueSeq(this__5754.meta, f1__5756, this__5754.rear, null)
  }else {
    if(this__5754.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__5754.meta, this__5754.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5757 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5758 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__5758.front, this__5758.rear, this__5758.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5759 = this;
  return this__5759.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5760 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5760.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5761 = this;
  var h__364__auto____5762 = this__5761.__hash;
  if(h__364__auto____5762 != null) {
    return h__364__auto____5762
  }else {
    var h__364__auto____5763 = cljs.core.hash_coll.call(null, coll);
    this__5761.__hash = h__364__auto____5763;
    return h__364__auto____5763
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5764 = this;
  if(cljs.core.truth_(this__5764.front)) {
    return new cljs.core.PersistentQueue(this__5764.meta, this__5764.count + 1, this__5764.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____5765 = this__5764.rear;
      if(cljs.core.truth_(or__3548__auto____5765)) {
        return or__3548__auto____5765
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__5764.meta, this__5764.count + 1, cljs.core.conj.call(null, this__5764.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__5766 = this;
  var this$__5767 = this;
  return cljs.core.pr_str.call(null, this$__5767)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5768 = this;
  var rear__5769 = cljs.core.seq.call(null, this__5768.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____5770 = this__5768.front;
    if(cljs.core.truth_(or__3548__auto____5770)) {
      return or__3548__auto____5770
    }else {
      return rear__5769
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__5768.front, cljs.core.seq.call(null, rear__5769), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5771 = this;
  return this__5771.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5772 = this;
  return cljs.core._first.call(null, this__5772.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5773 = this;
  if(cljs.core.truth_(this__5773.front)) {
    var temp__3695__auto____5774 = cljs.core.next.call(null, this__5773.front);
    if(cljs.core.truth_(temp__3695__auto____5774)) {
      var f1__5775 = temp__3695__auto____5774;
      return new cljs.core.PersistentQueue(this__5773.meta, this__5773.count - 1, f1__5775, this__5773.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__5773.meta, this__5773.count - 1, cljs.core.seq.call(null, this__5773.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5776 = this;
  return cljs.core.first.call(null, this__5776.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5777 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5778 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5779 = this;
  return new cljs.core.PersistentQueue(meta, this__5779.count, this__5779.front, this__5779.rear, this__5779.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5780 = this;
  return this__5780.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5781 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__5782 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__5783 = array.length;
  var i__5784 = 0;
  while(true) {
    if(i__5784 < len__5783) {
      if(cljs.core._EQ_.call(null, k, array[i__5784])) {
        return i__5784
      }else {
        var G__5785 = i__5784 + incr;
        i__5784 = G__5785;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5786 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____5786)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____5786
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__5787 = cljs.core.hash.call(null, a);
  var b__5788 = cljs.core.hash.call(null, b);
  if(a__5787 < b__5788) {
    return-1
  }else {
    if(a__5787 > b__5788) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__5790 = m.keys;
  var len__5791 = ks__5790.length;
  var so__5792 = m.strobj;
  var out__5793 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__5794 = 0;
  var out__5795 = cljs.core.transient$.call(null, out__5793);
  while(true) {
    if(i__5794 < len__5791) {
      var k__5796 = ks__5790[i__5794];
      var G__5797 = i__5794 + 1;
      var G__5798 = cljs.core.assoc_BANG_.call(null, out__5795, k__5796, so__5792[k__5796]);
      i__5794 = G__5797;
      out__5795 = G__5798;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__5795, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5803 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5804 = this;
  var h__364__auto____5805 = this__5804.__hash;
  if(h__364__auto____5805 != null) {
    return h__364__auto____5805
  }else {
    var h__364__auto____5806 = cljs.core.hash_imap.call(null, coll);
    this__5804.__hash = h__364__auto____5806;
    return h__364__auto____5806
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5807 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5808 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5808.strobj, this__5808.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5809 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___5810 = this__5809.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___5810)) {
      var new_strobj__5811 = goog.object.clone.call(null, this__5809.strobj);
      new_strobj__5811[k] = v;
      return new cljs.core.ObjMap(this__5809.meta, this__5809.keys, new_strobj__5811, this__5809.update_count + 1, null)
    }else {
      if(this__5809.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__5812 = goog.object.clone.call(null, this__5809.strobj);
        var new_keys__5813 = cljs.core.aclone.call(null, this__5809.keys);
        new_strobj__5812[k] = v;
        new_keys__5813.push(k);
        return new cljs.core.ObjMap(this__5809.meta, new_keys__5813, new_strobj__5812, this__5809.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5814 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5814.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__5834 = null;
  var G__5834__2 = function(tsym5801, k) {
    var this__5815 = this;
    var tsym5801__5816 = this;
    var coll__5817 = tsym5801__5816;
    return cljs.core._lookup.call(null, coll__5817, k)
  };
  var G__5834__3 = function(tsym5802, k, not_found) {
    var this__5818 = this;
    var tsym5802__5819 = this;
    var coll__5820 = tsym5802__5819;
    return cljs.core._lookup.call(null, coll__5820, k, not_found)
  };
  G__5834 = function(tsym5802, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5834__2.call(this, tsym5802, k);
      case 3:
        return G__5834__3.call(this, tsym5802, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5834
}();
cljs.core.ObjMap.prototype.apply = function(tsym5799, args5800) {
  return tsym5799.call.apply(tsym5799, [tsym5799].concat(cljs.core.aclone.call(null, args5800)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5821 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__5822 = this;
  var this$__5823 = this;
  return cljs.core.pr_str.call(null, this$__5823)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5824 = this;
  if(this__5824.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__5789_SHARP_) {
      return cljs.core.vector.call(null, p1__5789_SHARP_, this__5824.strobj[p1__5789_SHARP_])
    }, this__5824.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5825 = this;
  return this__5825.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5826 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5827 = this;
  return new cljs.core.ObjMap(meta, this__5827.keys, this__5827.strobj, this__5827.update_count, this__5827.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5828 = this;
  return this__5828.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5829 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__5829.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__5830 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____5831 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____5831)) {
      return this__5830.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____5831
    }
  }())) {
    var new_keys__5832 = cljs.core.aclone.call(null, this__5830.keys);
    var new_strobj__5833 = goog.object.clone.call(null, this__5830.strobj);
    new_keys__5832.splice(cljs.core.scan_array.call(null, 1, k, new_keys__5832), 1);
    cljs.core.js_delete.call(null, new_strobj__5833, k);
    return new cljs.core.ObjMap(this__5830.meta, new_keys__5832, new_strobj__5833, this__5830.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5840 = this;
  var h__364__auto____5841 = this__5840.__hash;
  if(h__364__auto____5841 != null) {
    return h__364__auto____5841
  }else {
    var h__364__auto____5842 = cljs.core.hash_imap.call(null, coll);
    this__5840.__hash = h__364__auto____5842;
    return h__364__auto____5842
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5843 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5844 = this;
  var bucket__5845 = this__5844.hashobj[cljs.core.hash.call(null, k)];
  var i__5846 = cljs.core.truth_(bucket__5845) ? cljs.core.scan_array.call(null, 2, k, bucket__5845) : null;
  if(cljs.core.truth_(i__5846)) {
    return bucket__5845[i__5846 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5847 = this;
  var h__5848 = cljs.core.hash.call(null, k);
  var bucket__5849 = this__5847.hashobj[h__5848];
  if(cljs.core.truth_(bucket__5849)) {
    var new_bucket__5850 = cljs.core.aclone.call(null, bucket__5849);
    var new_hashobj__5851 = goog.object.clone.call(null, this__5847.hashobj);
    new_hashobj__5851[h__5848] = new_bucket__5850;
    var temp__3695__auto____5852 = cljs.core.scan_array.call(null, 2, k, new_bucket__5850);
    if(cljs.core.truth_(temp__3695__auto____5852)) {
      var i__5853 = temp__3695__auto____5852;
      new_bucket__5850[i__5853 + 1] = v;
      return new cljs.core.HashMap(this__5847.meta, this__5847.count, new_hashobj__5851, null)
    }else {
      new_bucket__5850.push(k, v);
      return new cljs.core.HashMap(this__5847.meta, this__5847.count + 1, new_hashobj__5851, null)
    }
  }else {
    var new_hashobj__5854 = goog.object.clone.call(null, this__5847.hashobj);
    new_hashobj__5854[h__5848] = [k, v];
    return new cljs.core.HashMap(this__5847.meta, this__5847.count + 1, new_hashobj__5854, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5855 = this;
  var bucket__5856 = this__5855.hashobj[cljs.core.hash.call(null, k)];
  var i__5857 = cljs.core.truth_(bucket__5856) ? cljs.core.scan_array.call(null, 2, k, bucket__5856) : null;
  if(cljs.core.truth_(i__5857)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__5880 = null;
  var G__5880__2 = function(tsym5838, k) {
    var this__5858 = this;
    var tsym5838__5859 = this;
    var coll__5860 = tsym5838__5859;
    return cljs.core._lookup.call(null, coll__5860, k)
  };
  var G__5880__3 = function(tsym5839, k, not_found) {
    var this__5861 = this;
    var tsym5839__5862 = this;
    var coll__5863 = tsym5839__5862;
    return cljs.core._lookup.call(null, coll__5863, k, not_found)
  };
  G__5880 = function(tsym5839, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5880__2.call(this, tsym5839, k);
      case 3:
        return G__5880__3.call(this, tsym5839, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5880
}();
cljs.core.HashMap.prototype.apply = function(tsym5836, args5837) {
  return tsym5836.call.apply(tsym5836, [tsym5836].concat(cljs.core.aclone.call(null, args5837)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5864 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__5865 = this;
  var this$__5866 = this;
  return cljs.core.pr_str.call(null, this$__5866)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5867 = this;
  if(this__5867.count > 0) {
    var hashes__5868 = cljs.core.js_keys.call(null, this__5867.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__5835_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__5867.hashobj[p1__5835_SHARP_]))
    }, hashes__5868)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5869 = this;
  return this__5869.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5870 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5871 = this;
  return new cljs.core.HashMap(meta, this__5871.count, this__5871.hashobj, this__5871.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5872 = this;
  return this__5872.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5873 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__5873.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__5874 = this;
  var h__5875 = cljs.core.hash.call(null, k);
  var bucket__5876 = this__5874.hashobj[h__5875];
  var i__5877 = cljs.core.truth_(bucket__5876) ? cljs.core.scan_array.call(null, 2, k, bucket__5876) : null;
  if(cljs.core.not.call(null, i__5877)) {
    return coll
  }else {
    var new_hashobj__5878 = goog.object.clone.call(null, this__5874.hashobj);
    if(3 > bucket__5876.length) {
      cljs.core.js_delete.call(null, new_hashobj__5878, h__5875)
    }else {
      var new_bucket__5879 = cljs.core.aclone.call(null, bucket__5876);
      new_bucket__5879.splice(i__5877, 2);
      new_hashobj__5878[h__5875] = new_bucket__5879
    }
    return new cljs.core.HashMap(this__5874.meta, this__5874.count - 1, new_hashobj__5878, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__5881 = ks.length;
  var i__5882 = 0;
  var out__5883 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__5882 < len__5881) {
      var G__5884 = i__5882 + 1;
      var G__5885 = cljs.core.assoc.call(null, out__5883, ks[i__5882], vs[i__5882]);
      i__5882 = G__5884;
      out__5883 = G__5885;
      continue
    }else {
      return out__5883
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__5886 = m.arr;
  var len__5887 = arr__5886.length;
  var i__5888 = 0;
  while(true) {
    if(len__5887 <= i__5888) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__5886[i__5888], k)) {
        return i__5888
      }else {
        if("\ufdd0'else") {
          var G__5889 = i__5888 + 2;
          i__5888 = G__5889;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5894 = this;
  return new cljs.core.TransientArrayMap({}, this__5894.arr.length, cljs.core.aclone.call(null, this__5894.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5895 = this;
  var h__364__auto____5896 = this__5895.__hash;
  if(h__364__auto____5896 != null) {
    return h__364__auto____5896
  }else {
    var h__364__auto____5897 = cljs.core.hash_imap.call(null, coll);
    this__5895.__hash = h__364__auto____5897;
    return h__364__auto____5897
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5898 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5899 = this;
  var idx__5900 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__5900 === -1) {
    return not_found
  }else {
    return this__5899.arr[idx__5900 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5901 = this;
  var idx__5902 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__5902 === -1) {
    if(this__5901.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__5901.meta, this__5901.cnt + 1, function() {
        var G__5903__5904 = cljs.core.aclone.call(null, this__5901.arr);
        G__5903__5904.push(k);
        G__5903__5904.push(v);
        return G__5903__5904
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__5901.arr[idx__5902 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__5901.meta, this__5901.cnt, function() {
          var G__5905__5906 = cljs.core.aclone.call(null, this__5901.arr);
          G__5905__5906[idx__5902 + 1] = v;
          return G__5905__5906
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5907 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__5937 = null;
  var G__5937__2 = function(tsym5892, k) {
    var this__5908 = this;
    var tsym5892__5909 = this;
    var coll__5910 = tsym5892__5909;
    return cljs.core._lookup.call(null, coll__5910, k)
  };
  var G__5937__3 = function(tsym5893, k, not_found) {
    var this__5911 = this;
    var tsym5893__5912 = this;
    var coll__5913 = tsym5893__5912;
    return cljs.core._lookup.call(null, coll__5913, k, not_found)
  };
  G__5937 = function(tsym5893, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5937__2.call(this, tsym5893, k);
      case 3:
        return G__5937__3.call(this, tsym5893, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5937
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym5890, args5891) {
  return tsym5890.call.apply(tsym5890, [tsym5890].concat(cljs.core.aclone.call(null, args5891)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__5914 = this;
  var len__5915 = this__5914.arr.length;
  var i__5916 = 0;
  var init__5917 = init;
  while(true) {
    if(i__5916 < len__5915) {
      var init__5918 = f.call(null, init__5917, this__5914.arr[i__5916], this__5914.arr[i__5916 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__5918)) {
        return cljs.core.deref.call(null, init__5918)
      }else {
        var G__5938 = i__5916 + 2;
        var G__5939 = init__5918;
        i__5916 = G__5938;
        init__5917 = G__5939;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5919 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__5920 = this;
  var this$__5921 = this;
  return cljs.core.pr_str.call(null, this$__5921)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5922 = this;
  if(this__5922.cnt > 0) {
    var len__5923 = this__5922.arr.length;
    var array_map_seq__5924 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__5923) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__5922.arr[i], this__5922.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__5924.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5925 = this;
  return this__5925.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5926 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5927 = this;
  return new cljs.core.PersistentArrayMap(meta, this__5927.cnt, this__5927.arr, this__5927.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5928 = this;
  return this__5928.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5929 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__5929.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__5930 = this;
  var idx__5931 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__5931 >= 0) {
    var len__5932 = this__5930.arr.length;
    var new_len__5933 = len__5932 - 2;
    if(new_len__5933 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__5934 = cljs.core.make_array.call(null, new_len__5933);
      var s__5935 = 0;
      var d__5936 = 0;
      while(true) {
        if(s__5935 >= len__5932) {
          return new cljs.core.PersistentArrayMap(this__5930.meta, this__5930.cnt - 1, new_arr__5934, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__5930.arr[s__5935])) {
            var G__5940 = s__5935 + 2;
            var G__5941 = d__5936;
            s__5935 = G__5940;
            d__5936 = G__5941;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__5934[d__5936] = this__5930.arr[s__5935];
              new_arr__5934[d__5936 + 1] = this__5930.arr[s__5935 + 1];
              var G__5942 = s__5935 + 2;
              var G__5943 = d__5936 + 2;
              s__5935 = G__5942;
              d__5936 = G__5943;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__5944 = cljs.core.count.call(null, ks);
  var i__5945 = 0;
  var out__5946 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__5945 < len__5944) {
      var G__5947 = i__5945 + 1;
      var G__5948 = cljs.core.assoc_BANG_.call(null, out__5946, ks[i__5945], vs[i__5945]);
      i__5945 = G__5947;
      out__5946 = G__5948;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5946)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__5949 = this;
  if(cljs.core.truth_(this__5949.editable_QMARK_)) {
    var idx__5950 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__5950 >= 0) {
      this__5949.arr[idx__5950] = this__5949.arr[this__5949.len - 2];
      this__5949.arr[idx__5950 + 1] = this__5949.arr[this__5949.len - 1];
      var G__5951__5952 = this__5949.arr;
      G__5951__5952.pop();
      G__5951__5952.pop();
      G__5951__5952;
      this__5949.len = this__5949.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__5953 = this;
  if(cljs.core.truth_(this__5953.editable_QMARK_)) {
    var idx__5954 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__5954 === -1) {
      if(this__5953.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__5953.len = this__5953.len + 2;
        this__5953.arr.push(key);
        this__5953.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__5953.len, this__5953.arr), key, val)
      }
    }else {
      if(val === this__5953.arr[idx__5954 + 1]) {
        return tcoll
      }else {
        this__5953.arr[idx__5954 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__5955 = this;
  if(cljs.core.truth_(this__5955.editable_QMARK_)) {
    if(function() {
      var G__5956__5957 = o;
      if(G__5956__5957 != null) {
        if(function() {
          var or__3548__auto____5958 = G__5956__5957.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____5958) {
            return or__3548__auto____5958
          }else {
            return G__5956__5957.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__5956__5957.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__5956__5957)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__5956__5957)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__5959 = cljs.core.seq.call(null, o);
      var tcoll__5960 = tcoll;
      while(true) {
        var temp__3695__auto____5961 = cljs.core.first.call(null, es__5959);
        if(cljs.core.truth_(temp__3695__auto____5961)) {
          var e__5962 = temp__3695__auto____5961;
          var G__5968 = cljs.core.next.call(null, es__5959);
          var G__5969 = cljs.core._assoc_BANG_.call(null, tcoll__5960, cljs.core.key.call(null, e__5962), cljs.core.val.call(null, e__5962));
          es__5959 = G__5968;
          tcoll__5960 = G__5969;
          continue
        }else {
          return tcoll__5960
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__5963 = this;
  if(cljs.core.truth_(this__5963.editable_QMARK_)) {
    this__5963.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__5963.len, 2), this__5963.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__5964 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__5965 = this;
  if(cljs.core.truth_(this__5965.editable_QMARK_)) {
    var idx__5966 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__5966 === -1) {
      return not_found
    }else {
      return this__5965.arr[idx__5966 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__5967 = this;
  if(cljs.core.truth_(this__5967.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__5967.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__5970 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__5971 = 0;
  while(true) {
    if(i__5971 < len) {
      var G__5972 = cljs.core.assoc_BANG_.call(null, out__5970, arr[i__5971], arr[i__5971 + 1]);
      var G__5973 = i__5971 + 2;
      out__5970 = G__5972;
      i__5971 = G__5973;
      continue
    }else {
      return out__5970
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__5974__5975 = cljs.core.aclone.call(null, arr);
    G__5974__5975[i] = a;
    return G__5974__5975
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__5976__5977 = cljs.core.aclone.call(null, arr);
    G__5976__5977[i] = a;
    G__5976__5977[j] = b;
    return G__5976__5977
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__5978 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__5978, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__5978, 2 * i, new_arr__5978.length - 2 * i);
  return new_arr__5978
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__5979 = inode.ensure_editable(edit);
    editable__5979.arr[i] = a;
    return editable__5979
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__5980 = inode.ensure_editable(edit);
    editable__5980.arr[i] = a;
    editable__5980.arr[j] = b;
    return editable__5980
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__5981 = arr.length;
  var i__5982 = 0;
  var init__5983 = init;
  while(true) {
    if(i__5982 < len__5981) {
      var init__5986 = function() {
        var k__5984 = arr[i__5982];
        if(k__5984 != null) {
          return f.call(null, init__5983, k__5984, arr[i__5982 + 1])
        }else {
          var node__5985 = arr[i__5982 + 1];
          if(node__5985 != null) {
            return node__5985.kv_reduce(f, init__5983)
          }else {
            return init__5983
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5986)) {
        return cljs.core.deref.call(null, init__5986)
      }else {
        var G__5987 = i__5982 + 2;
        var G__5988 = init__5986;
        i__5982 = G__5987;
        init__5983 = G__5988;
        continue
      }
    }else {
      return init__5983
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__5989 = this;
  var inode__5990 = this;
  if(this__5989.bitmap === bit) {
    return null
  }else {
    var editable__5991 = inode__5990.ensure_editable(e);
    var earr__5992 = editable__5991.arr;
    var len__5993 = earr__5992.length;
    editable__5991.bitmap = bit ^ editable__5991.bitmap;
    cljs.core.array_copy.call(null, earr__5992, 2 * (i + 1), earr__5992, 2 * i, len__5993 - 2 * (i + 1));
    earr__5992[len__5993 - 2] = null;
    earr__5992[len__5993 - 1] = null;
    return editable__5991
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__5994 = this;
  var inode__5995 = this;
  var bit__5996 = 1 << (hash >>> shift & 31);
  var idx__5997 = cljs.core.bitmap_indexed_node_index.call(null, this__5994.bitmap, bit__5996);
  if((this__5994.bitmap & bit__5996) === 0) {
    var n__5998 = cljs.core.bit_count.call(null, this__5994.bitmap);
    if(2 * n__5998 < this__5994.arr.length) {
      var editable__5999 = inode__5995.ensure_editable(edit);
      var earr__6000 = editable__5999.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6000, 2 * idx__5997, earr__6000, 2 * (idx__5997 + 1), 2 * (n__5998 - idx__5997));
      earr__6000[2 * idx__5997] = key;
      earr__6000[2 * idx__5997 + 1] = val;
      editable__5999.bitmap = editable__5999.bitmap | bit__5996;
      return editable__5999
    }else {
      if(n__5998 >= 16) {
        var nodes__6001 = cljs.core.make_array.call(null, 32);
        var jdx__6002 = hash >>> shift & 31;
        nodes__6001[jdx__6002] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6003 = 0;
        var j__6004 = 0;
        while(true) {
          if(i__6003 < 32) {
            if((this__5994.bitmap >>> i__6003 & 1) === 0) {
              var G__6057 = i__6003 + 1;
              var G__6058 = j__6004;
              i__6003 = G__6057;
              j__6004 = G__6058;
              continue
            }else {
              nodes__6001[i__6003] = null != this__5994.arr[j__6004] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__5994.arr[j__6004]), this__5994.arr[j__6004], this__5994.arr[j__6004 + 1], added_leaf_QMARK_) : this__5994.arr[j__6004 + 1];
              var G__6059 = i__6003 + 1;
              var G__6060 = j__6004 + 2;
              i__6003 = G__6059;
              j__6004 = G__6060;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__5998 + 1, nodes__6001)
      }else {
        if("\ufdd0'else") {
          var new_arr__6005 = cljs.core.make_array.call(null, 2 * (n__5998 + 4));
          cljs.core.array_copy.call(null, this__5994.arr, 0, new_arr__6005, 0, 2 * idx__5997);
          new_arr__6005[2 * idx__5997] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6005[2 * idx__5997 + 1] = val;
          cljs.core.array_copy.call(null, this__5994.arr, 2 * idx__5997, new_arr__6005, 2 * (idx__5997 + 1), 2 * (n__5998 - idx__5997));
          var editable__6006 = inode__5995.ensure_editable(edit);
          editable__6006.arr = new_arr__6005;
          editable__6006.bitmap = editable__6006.bitmap | bit__5996;
          return editable__6006
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6007 = this__5994.arr[2 * idx__5997];
    var val_or_node__6008 = this__5994.arr[2 * idx__5997 + 1];
    if(null == key_or_nil__6007) {
      var n__6009 = val_or_node__6008.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6009 === val_or_node__6008) {
        return inode__5995
      }else {
        return cljs.core.edit_and_set.call(null, inode__5995, edit, 2 * idx__5997 + 1, n__6009)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6007)) {
        if(val === val_or_node__6008) {
          return inode__5995
        }else {
          return cljs.core.edit_and_set.call(null, inode__5995, edit, 2 * idx__5997 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__5995, edit, 2 * idx__5997, null, 2 * idx__5997 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6007, val_or_node__6008, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6010 = this;
  var inode__6011 = this;
  return cljs.core.create_inode_seq.call(null, this__6010.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6012 = this;
  var inode__6013 = this;
  var bit__6014 = 1 << (hash >>> shift & 31);
  if((this__6012.bitmap & bit__6014) === 0) {
    return inode__6013
  }else {
    var idx__6015 = cljs.core.bitmap_indexed_node_index.call(null, this__6012.bitmap, bit__6014);
    var key_or_nil__6016 = this__6012.arr[2 * idx__6015];
    var val_or_node__6017 = this__6012.arr[2 * idx__6015 + 1];
    if(null == key_or_nil__6016) {
      var n__6018 = val_or_node__6017.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6018 === val_or_node__6017) {
        return inode__6013
      }else {
        if(null != n__6018) {
          return cljs.core.edit_and_set.call(null, inode__6013, edit, 2 * idx__6015 + 1, n__6018)
        }else {
          if(this__6012.bitmap === bit__6014) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6013.edit_and_remove_pair(edit, bit__6014, idx__6015)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6016)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6013.edit_and_remove_pair(edit, bit__6014, idx__6015)
      }else {
        if("\ufdd0'else") {
          return inode__6013
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6019 = this;
  var inode__6020 = this;
  if(e === this__6019.edit) {
    return inode__6020
  }else {
    var n__6021 = cljs.core.bit_count.call(null, this__6019.bitmap);
    var new_arr__6022 = cljs.core.make_array.call(null, n__6021 < 0 ? 4 : 2 * (n__6021 + 1));
    cljs.core.array_copy.call(null, this__6019.arr, 0, new_arr__6022, 0, 2 * n__6021);
    return new cljs.core.BitmapIndexedNode(e, this__6019.bitmap, new_arr__6022)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6023 = this;
  var inode__6024 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6023.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6061 = null;
  var G__6061__3 = function(shift, hash, key) {
    var this__6025 = this;
    var inode__6026 = this;
    var bit__6027 = 1 << (hash >>> shift & 31);
    if((this__6025.bitmap & bit__6027) === 0) {
      return null
    }else {
      var idx__6028 = cljs.core.bitmap_indexed_node_index.call(null, this__6025.bitmap, bit__6027);
      var key_or_nil__6029 = this__6025.arr[2 * idx__6028];
      var val_or_node__6030 = this__6025.arr[2 * idx__6028 + 1];
      if(null == key_or_nil__6029) {
        return val_or_node__6030.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6029)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6029, val_or_node__6030])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6061__4 = function(shift, hash, key, not_found) {
    var this__6031 = this;
    var inode__6032 = this;
    var bit__6033 = 1 << (hash >>> shift & 31);
    if((this__6031.bitmap & bit__6033) === 0) {
      return not_found
    }else {
      var idx__6034 = cljs.core.bitmap_indexed_node_index.call(null, this__6031.bitmap, bit__6033);
      var key_or_nil__6035 = this__6031.arr[2 * idx__6034];
      var val_or_node__6036 = this__6031.arr[2 * idx__6034 + 1];
      if(null == key_or_nil__6035) {
        return val_or_node__6036.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6035)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6035, val_or_node__6036])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6061 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6061__3.call(this, shift, hash, key);
      case 4:
        return G__6061__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6061
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6037 = this;
  var inode__6038 = this;
  var bit__6039 = 1 << (hash >>> shift & 31);
  if((this__6037.bitmap & bit__6039) === 0) {
    return inode__6038
  }else {
    var idx__6040 = cljs.core.bitmap_indexed_node_index.call(null, this__6037.bitmap, bit__6039);
    var key_or_nil__6041 = this__6037.arr[2 * idx__6040];
    var val_or_node__6042 = this__6037.arr[2 * idx__6040 + 1];
    if(null == key_or_nil__6041) {
      var n__6043 = val_or_node__6042.inode_without(shift + 5, hash, key);
      if(n__6043 === val_or_node__6042) {
        return inode__6038
      }else {
        if(null != n__6043) {
          return new cljs.core.BitmapIndexedNode(null, this__6037.bitmap, cljs.core.clone_and_set.call(null, this__6037.arr, 2 * idx__6040 + 1, n__6043))
        }else {
          if(this__6037.bitmap === bit__6039) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6037.bitmap ^ bit__6039, cljs.core.remove_pair.call(null, this__6037.arr, idx__6040))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6041)) {
        return new cljs.core.BitmapIndexedNode(null, this__6037.bitmap ^ bit__6039, cljs.core.remove_pair.call(null, this__6037.arr, idx__6040))
      }else {
        if("\ufdd0'else") {
          return inode__6038
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6044 = this;
  var inode__6045 = this;
  var bit__6046 = 1 << (hash >>> shift & 31);
  var idx__6047 = cljs.core.bitmap_indexed_node_index.call(null, this__6044.bitmap, bit__6046);
  if((this__6044.bitmap & bit__6046) === 0) {
    var n__6048 = cljs.core.bit_count.call(null, this__6044.bitmap);
    if(n__6048 >= 16) {
      var nodes__6049 = cljs.core.make_array.call(null, 32);
      var jdx__6050 = hash >>> shift & 31;
      nodes__6049[jdx__6050] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6051 = 0;
      var j__6052 = 0;
      while(true) {
        if(i__6051 < 32) {
          if((this__6044.bitmap >>> i__6051 & 1) === 0) {
            var G__6062 = i__6051 + 1;
            var G__6063 = j__6052;
            i__6051 = G__6062;
            j__6052 = G__6063;
            continue
          }else {
            nodes__6049[i__6051] = null != this__6044.arr[j__6052] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6044.arr[j__6052]), this__6044.arr[j__6052], this__6044.arr[j__6052 + 1], added_leaf_QMARK_) : this__6044.arr[j__6052 + 1];
            var G__6064 = i__6051 + 1;
            var G__6065 = j__6052 + 2;
            i__6051 = G__6064;
            j__6052 = G__6065;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6048 + 1, nodes__6049)
    }else {
      var new_arr__6053 = cljs.core.make_array.call(null, 2 * (n__6048 + 1));
      cljs.core.array_copy.call(null, this__6044.arr, 0, new_arr__6053, 0, 2 * idx__6047);
      new_arr__6053[2 * idx__6047] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6053[2 * idx__6047 + 1] = val;
      cljs.core.array_copy.call(null, this__6044.arr, 2 * idx__6047, new_arr__6053, 2 * (idx__6047 + 1), 2 * (n__6048 - idx__6047));
      return new cljs.core.BitmapIndexedNode(null, this__6044.bitmap | bit__6046, new_arr__6053)
    }
  }else {
    var key_or_nil__6054 = this__6044.arr[2 * idx__6047];
    var val_or_node__6055 = this__6044.arr[2 * idx__6047 + 1];
    if(null == key_or_nil__6054) {
      var n__6056 = val_or_node__6055.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6056 === val_or_node__6055) {
        return inode__6045
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6044.bitmap, cljs.core.clone_and_set.call(null, this__6044.arr, 2 * idx__6047 + 1, n__6056))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6054)) {
        if(val === val_or_node__6055) {
          return inode__6045
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6044.bitmap, cljs.core.clone_and_set.call(null, this__6044.arr, 2 * idx__6047 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6044.bitmap, cljs.core.clone_and_set.call(null, this__6044.arr, 2 * idx__6047, null, 2 * idx__6047 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6054, val_or_node__6055, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6066 = array_node.arr;
  var len__6067 = 2 * (array_node.cnt - 1);
  var new_arr__6068 = cljs.core.make_array.call(null, len__6067);
  var i__6069 = 0;
  var j__6070 = 1;
  var bitmap__6071 = 0;
  while(true) {
    if(i__6069 < len__6067) {
      if(function() {
        var and__3546__auto____6072 = i__6069 != idx;
        if(and__3546__auto____6072) {
          return null != arr__6066[i__6069]
        }else {
          return and__3546__auto____6072
        }
      }()) {
        new_arr__6068[j__6070] = arr__6066[i__6069];
        var G__6073 = i__6069 + 1;
        var G__6074 = j__6070 + 2;
        var G__6075 = bitmap__6071 | 1 << i__6069;
        i__6069 = G__6073;
        j__6070 = G__6074;
        bitmap__6071 = G__6075;
        continue
      }else {
        var G__6076 = i__6069 + 1;
        var G__6077 = j__6070;
        var G__6078 = bitmap__6071;
        i__6069 = G__6076;
        j__6070 = G__6077;
        bitmap__6071 = G__6078;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6071, new_arr__6068)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6079 = this;
  var inode__6080 = this;
  var idx__6081 = hash >>> shift & 31;
  var node__6082 = this__6079.arr[idx__6081];
  if(null == node__6082) {
    return new cljs.core.ArrayNode(null, this__6079.cnt + 1, cljs.core.clone_and_set.call(null, this__6079.arr, idx__6081, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6083 = node__6082.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6083 === node__6082) {
      return inode__6080
    }else {
      return new cljs.core.ArrayNode(null, this__6079.cnt, cljs.core.clone_and_set.call(null, this__6079.arr, idx__6081, n__6083))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6084 = this;
  var inode__6085 = this;
  var idx__6086 = hash >>> shift & 31;
  var node__6087 = this__6084.arr[idx__6086];
  if(null != node__6087) {
    var n__6088 = node__6087.inode_without(shift + 5, hash, key);
    if(n__6088 === node__6087) {
      return inode__6085
    }else {
      if(n__6088 == null) {
        if(this__6084.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6085, null, idx__6086)
        }else {
          return new cljs.core.ArrayNode(null, this__6084.cnt - 1, cljs.core.clone_and_set.call(null, this__6084.arr, idx__6086, n__6088))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6084.cnt, cljs.core.clone_and_set.call(null, this__6084.arr, idx__6086, n__6088))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6085
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6120 = null;
  var G__6120__3 = function(shift, hash, key) {
    var this__6089 = this;
    var inode__6090 = this;
    var idx__6091 = hash >>> shift & 31;
    var node__6092 = this__6089.arr[idx__6091];
    if(null != node__6092) {
      return node__6092.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6120__4 = function(shift, hash, key, not_found) {
    var this__6093 = this;
    var inode__6094 = this;
    var idx__6095 = hash >>> shift & 31;
    var node__6096 = this__6093.arr[idx__6095];
    if(null != node__6096) {
      return node__6096.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6120 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6120__3.call(this, shift, hash, key);
      case 4:
        return G__6120__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6120
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6097 = this;
  var inode__6098 = this;
  return cljs.core.create_array_node_seq.call(null, this__6097.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6099 = this;
  var inode__6100 = this;
  if(e === this__6099.edit) {
    return inode__6100
  }else {
    return new cljs.core.ArrayNode(e, this__6099.cnt, cljs.core.aclone.call(null, this__6099.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6101 = this;
  var inode__6102 = this;
  var idx__6103 = hash >>> shift & 31;
  var node__6104 = this__6101.arr[idx__6103];
  if(null == node__6104) {
    var editable__6105 = cljs.core.edit_and_set.call(null, inode__6102, edit, idx__6103, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6105.cnt = editable__6105.cnt + 1;
    return editable__6105
  }else {
    var n__6106 = node__6104.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6106 === node__6104) {
      return inode__6102
    }else {
      return cljs.core.edit_and_set.call(null, inode__6102, edit, idx__6103, n__6106)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6107 = this;
  var inode__6108 = this;
  var idx__6109 = hash >>> shift & 31;
  var node__6110 = this__6107.arr[idx__6109];
  if(null == node__6110) {
    return inode__6108
  }else {
    var n__6111 = node__6110.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6111 === node__6110) {
      return inode__6108
    }else {
      if(null == n__6111) {
        if(this__6107.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6108, edit, idx__6109)
        }else {
          var editable__6112 = cljs.core.edit_and_set.call(null, inode__6108, edit, idx__6109, n__6111);
          editable__6112.cnt = editable__6112.cnt - 1;
          return editable__6112
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6108, edit, idx__6109, n__6111)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6113 = this;
  var inode__6114 = this;
  var len__6115 = this__6113.arr.length;
  var i__6116 = 0;
  var init__6117 = init;
  while(true) {
    if(i__6116 < len__6115) {
      var node__6118 = this__6113.arr[i__6116];
      if(node__6118 != null) {
        var init__6119 = node__6118.kv_reduce(f, init__6117);
        if(cljs.core.reduced_QMARK_.call(null, init__6119)) {
          return cljs.core.deref.call(null, init__6119)
        }else {
          var G__6121 = i__6116 + 1;
          var G__6122 = init__6119;
          i__6116 = G__6121;
          init__6117 = G__6122;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6117
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6123 = 2 * cnt;
  var i__6124 = 0;
  while(true) {
    if(i__6124 < lim__6123) {
      if(cljs.core._EQ_.call(null, key, arr[i__6124])) {
        return i__6124
      }else {
        var G__6125 = i__6124 + 2;
        i__6124 = G__6125;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6126 = this;
  var inode__6127 = this;
  if(hash === this__6126.collision_hash) {
    var idx__6128 = cljs.core.hash_collision_node_find_index.call(null, this__6126.arr, this__6126.cnt, key);
    if(idx__6128 === -1) {
      var len__6129 = this__6126.arr.length;
      var new_arr__6130 = cljs.core.make_array.call(null, len__6129 + 2);
      cljs.core.array_copy.call(null, this__6126.arr, 0, new_arr__6130, 0, len__6129);
      new_arr__6130[len__6129] = key;
      new_arr__6130[len__6129 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6126.collision_hash, this__6126.cnt + 1, new_arr__6130)
    }else {
      if(cljs.core._EQ_.call(null, this__6126.arr[idx__6128], val)) {
        return inode__6127
      }else {
        return new cljs.core.HashCollisionNode(null, this__6126.collision_hash, this__6126.cnt, cljs.core.clone_and_set.call(null, this__6126.arr, idx__6128 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6126.collision_hash >>> shift & 31), [null, inode__6127])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6131 = this;
  var inode__6132 = this;
  var idx__6133 = cljs.core.hash_collision_node_find_index.call(null, this__6131.arr, this__6131.cnt, key);
  if(idx__6133 === -1) {
    return inode__6132
  }else {
    if(this__6131.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6131.collision_hash, this__6131.cnt - 1, cljs.core.remove_pair.call(null, this__6131.arr, cljs.core.quot.call(null, idx__6133, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6160 = null;
  var G__6160__3 = function(shift, hash, key) {
    var this__6134 = this;
    var inode__6135 = this;
    var idx__6136 = cljs.core.hash_collision_node_find_index.call(null, this__6134.arr, this__6134.cnt, key);
    if(idx__6136 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6134.arr[idx__6136])) {
        return cljs.core.PersistentVector.fromArray([this__6134.arr[idx__6136], this__6134.arr[idx__6136 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6160__4 = function(shift, hash, key, not_found) {
    var this__6137 = this;
    var inode__6138 = this;
    var idx__6139 = cljs.core.hash_collision_node_find_index.call(null, this__6137.arr, this__6137.cnt, key);
    if(idx__6139 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6137.arr[idx__6139])) {
        return cljs.core.PersistentVector.fromArray([this__6137.arr[idx__6139], this__6137.arr[idx__6139 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6160 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6160__3.call(this, shift, hash, key);
      case 4:
        return G__6160__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6160
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6140 = this;
  var inode__6141 = this;
  return cljs.core.create_inode_seq.call(null, this__6140.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6161 = null;
  var G__6161__1 = function(e) {
    var this__6142 = this;
    var inode__6143 = this;
    if(e === this__6142.edit) {
      return inode__6143
    }else {
      var new_arr__6144 = cljs.core.make_array.call(null, 2 * (this__6142.cnt + 1));
      cljs.core.array_copy.call(null, this__6142.arr, 0, new_arr__6144, 0, 2 * this__6142.cnt);
      return new cljs.core.HashCollisionNode(e, this__6142.collision_hash, this__6142.cnt, new_arr__6144)
    }
  };
  var G__6161__3 = function(e, count, array) {
    var this__6145 = this;
    var inode__6146 = this;
    if(e === this__6145.edit) {
      this__6145.arr = array;
      this__6145.cnt = count;
      return inode__6146
    }else {
      return new cljs.core.HashCollisionNode(this__6145.edit, this__6145.collision_hash, count, array)
    }
  };
  G__6161 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6161__1.call(this, e);
      case 3:
        return G__6161__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6161
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6147 = this;
  var inode__6148 = this;
  if(hash === this__6147.collision_hash) {
    var idx__6149 = cljs.core.hash_collision_node_find_index.call(null, this__6147.arr, this__6147.cnt, key);
    if(idx__6149 === -1) {
      if(this__6147.arr.length > 2 * this__6147.cnt) {
        var editable__6150 = cljs.core.edit_and_set.call(null, inode__6148, edit, 2 * this__6147.cnt, key, 2 * this__6147.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6150.cnt = editable__6150.cnt + 1;
        return editable__6150
      }else {
        var len__6151 = this__6147.arr.length;
        var new_arr__6152 = cljs.core.make_array.call(null, len__6151 + 2);
        cljs.core.array_copy.call(null, this__6147.arr, 0, new_arr__6152, 0, len__6151);
        new_arr__6152[len__6151] = key;
        new_arr__6152[len__6151 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6148.ensure_editable(edit, this__6147.cnt + 1, new_arr__6152)
      }
    }else {
      if(this__6147.arr[idx__6149 + 1] === val) {
        return inode__6148
      }else {
        return cljs.core.edit_and_set.call(null, inode__6148, edit, idx__6149 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6147.collision_hash >>> shift & 31), [null, inode__6148, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6153 = this;
  var inode__6154 = this;
  var idx__6155 = cljs.core.hash_collision_node_find_index.call(null, this__6153.arr, this__6153.cnt, key);
  if(idx__6155 === -1) {
    return inode__6154
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6153.cnt === 1) {
      return null
    }else {
      var editable__6156 = inode__6154.ensure_editable(edit);
      var earr__6157 = editable__6156.arr;
      earr__6157[idx__6155] = earr__6157[2 * this__6153.cnt - 2];
      earr__6157[idx__6155 + 1] = earr__6157[2 * this__6153.cnt - 1];
      earr__6157[2 * this__6153.cnt - 1] = null;
      earr__6157[2 * this__6153.cnt - 2] = null;
      editable__6156.cnt = editable__6156.cnt - 1;
      return editable__6156
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6158 = this;
  var inode__6159 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6158.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6162 = cljs.core.hash.call(null, key1);
    if(key1hash__6162 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6162, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6163 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6162, key1, val1, added_leaf_QMARK___6163).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6163)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6164 = cljs.core.hash.call(null, key1);
    if(key1hash__6164 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6164, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6165 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6164, key1, val1, added_leaf_QMARK___6165).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6165)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6166 = this;
  var h__364__auto____6167 = this__6166.__hash;
  if(h__364__auto____6167 != null) {
    return h__364__auto____6167
  }else {
    var h__364__auto____6168 = cljs.core.hash_coll.call(null, coll);
    this__6166.__hash = h__364__auto____6168;
    return h__364__auto____6168
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6169 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6170 = this;
  var this$__6171 = this;
  return cljs.core.pr_str.call(null, this$__6171)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6172 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6173 = this;
  if(this__6173.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6173.nodes[this__6173.i], this__6173.nodes[this__6173.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6173.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6174 = this;
  if(this__6174.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6174.nodes, this__6174.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6174.nodes, this__6174.i, cljs.core.next.call(null, this__6174.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6175 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6176 = this;
  return new cljs.core.NodeSeq(meta, this__6176.nodes, this__6176.i, this__6176.s, this__6176.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6177 = this;
  return this__6177.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6178 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6178.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6179 = nodes.length;
      var j__6180 = i;
      while(true) {
        if(j__6180 < len__6179) {
          if(null != nodes[j__6180]) {
            return new cljs.core.NodeSeq(null, nodes, j__6180, null, null)
          }else {
            var temp__3695__auto____6181 = nodes[j__6180 + 1];
            if(cljs.core.truth_(temp__3695__auto____6181)) {
              var node__6182 = temp__3695__auto____6181;
              var temp__3695__auto____6183 = node__6182.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6183)) {
                var node_seq__6184 = temp__3695__auto____6183;
                return new cljs.core.NodeSeq(null, nodes, j__6180 + 2, node_seq__6184, null)
              }else {
                var G__6185 = j__6180 + 2;
                j__6180 = G__6185;
                continue
              }
            }else {
              var G__6186 = j__6180 + 2;
              j__6180 = G__6186;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6187 = this;
  var h__364__auto____6188 = this__6187.__hash;
  if(h__364__auto____6188 != null) {
    return h__364__auto____6188
  }else {
    var h__364__auto____6189 = cljs.core.hash_coll.call(null, coll);
    this__6187.__hash = h__364__auto____6189;
    return h__364__auto____6189
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6190 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6191 = this;
  var this$__6192 = this;
  return cljs.core.pr_str.call(null, this$__6192)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6193 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6194 = this;
  return cljs.core.first.call(null, this__6194.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6195 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6195.nodes, this__6195.i, cljs.core.next.call(null, this__6195.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6196 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6197 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6197.nodes, this__6197.i, this__6197.s, this__6197.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6198 = this;
  return this__6198.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6199 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6199.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6200 = nodes.length;
      var j__6201 = i;
      while(true) {
        if(j__6201 < len__6200) {
          var temp__3695__auto____6202 = nodes[j__6201];
          if(cljs.core.truth_(temp__3695__auto____6202)) {
            var nj__6203 = temp__3695__auto____6202;
            var temp__3695__auto____6204 = nj__6203.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6204)) {
              var ns__6205 = temp__3695__auto____6204;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6201 + 1, ns__6205, null)
            }else {
              var G__6206 = j__6201 + 1;
              j__6201 = G__6206;
              continue
            }
          }else {
            var G__6207 = j__6201 + 1;
            j__6201 = G__6207;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6212 = this;
  return new cljs.core.TransientHashMap({}, this__6212.root, this__6212.cnt, this__6212.has_nil_QMARK_, this__6212.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6213 = this;
  var h__364__auto____6214 = this__6213.__hash;
  if(h__364__auto____6214 != null) {
    return h__364__auto____6214
  }else {
    var h__364__auto____6215 = cljs.core.hash_imap.call(null, coll);
    this__6213.__hash = h__364__auto____6215;
    return h__364__auto____6215
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6216 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6217 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6217.has_nil_QMARK_)) {
      return this__6217.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6217.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6217.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6218 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6219 = this__6218.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6219)) {
        return v === this__6218.nil_val
      }else {
        return and__3546__auto____6219
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6218.meta, cljs.core.truth_(this__6218.has_nil_QMARK_) ? this__6218.cnt : this__6218.cnt + 1, this__6218.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6220 = [false];
    var new_root__6221 = (this__6218.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6218.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6220);
    if(new_root__6221 === this__6218.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6218.meta, cljs.core.truth_(added_leaf_QMARK___6220[0]) ? this__6218.cnt + 1 : this__6218.cnt, new_root__6221, this__6218.has_nil_QMARK_, this__6218.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6222 = this;
  if(k == null) {
    return this__6222.has_nil_QMARK_
  }else {
    if(this__6222.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6222.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6243 = null;
  var G__6243__2 = function(tsym6210, k) {
    var this__6223 = this;
    var tsym6210__6224 = this;
    var coll__6225 = tsym6210__6224;
    return cljs.core._lookup.call(null, coll__6225, k)
  };
  var G__6243__3 = function(tsym6211, k, not_found) {
    var this__6226 = this;
    var tsym6211__6227 = this;
    var coll__6228 = tsym6211__6227;
    return cljs.core._lookup.call(null, coll__6228, k, not_found)
  };
  G__6243 = function(tsym6211, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6243__2.call(this, tsym6211, k);
      case 3:
        return G__6243__3.call(this, tsym6211, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6243
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6208, args6209) {
  return tsym6208.call.apply(tsym6208, [tsym6208].concat(cljs.core.aclone.call(null, args6209)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6229 = this;
  var init__6230 = cljs.core.truth_(this__6229.has_nil_QMARK_) ? f.call(null, init, null, this__6229.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6230)) {
    return cljs.core.deref.call(null, init__6230)
  }else {
    if(null != this__6229.root) {
      return this__6229.root.kv_reduce(f, init__6230)
    }else {
      if("\ufdd0'else") {
        return init__6230
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6231 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6232 = this;
  var this$__6233 = this;
  return cljs.core.pr_str.call(null, this$__6233)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6234 = this;
  if(this__6234.cnt > 0) {
    var s__6235 = null != this__6234.root ? this__6234.root.inode_seq() : null;
    if(cljs.core.truth_(this__6234.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6234.nil_val]), s__6235)
    }else {
      return s__6235
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6236 = this;
  return this__6236.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6237 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6238 = this;
  return new cljs.core.PersistentHashMap(meta, this__6238.cnt, this__6238.root, this__6238.has_nil_QMARK_, this__6238.nil_val, this__6238.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6239 = this;
  return this__6239.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6240 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6240.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6241 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6241.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6241.meta, this__6241.cnt - 1, this__6241.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6241.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6242 = this__6241.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6242 === this__6241.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6241.meta, this__6241.cnt - 1, new_root__6242, this__6241.has_nil_QMARK_, this__6241.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6244 = ks.length;
  var i__6245 = 0;
  var out__6246 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6245 < len__6244) {
      var G__6247 = i__6245 + 1;
      var G__6248 = cljs.core.assoc_BANG_.call(null, out__6246, ks[i__6245], vs[i__6245]);
      i__6245 = G__6247;
      out__6246 = G__6248;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6246)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6249 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6250 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6251 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6252 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6253 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6253.has_nil_QMARK_)) {
      return this__6253.nil_val
    }else {
      return null
    }
  }else {
    if(this__6253.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6253.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6254 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6254.has_nil_QMARK_)) {
      return this__6254.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6254.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6254.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6255 = this;
  if(cljs.core.truth_(this__6255.edit)) {
    return this__6255.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6256 = this;
  var tcoll__6257 = this;
  if(cljs.core.truth_(this__6256.edit)) {
    if(function() {
      var G__6258__6259 = o;
      if(G__6258__6259 != null) {
        if(function() {
          var or__3548__auto____6260 = G__6258__6259.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6260) {
            return or__3548__auto____6260
          }else {
            return G__6258__6259.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6258__6259.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6258__6259)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6258__6259)
      }
    }()) {
      return tcoll__6257.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6261 = cljs.core.seq.call(null, o);
      var tcoll__6262 = tcoll__6257;
      while(true) {
        var temp__3695__auto____6263 = cljs.core.first.call(null, es__6261);
        if(cljs.core.truth_(temp__3695__auto____6263)) {
          var e__6264 = temp__3695__auto____6263;
          var G__6275 = cljs.core.next.call(null, es__6261);
          var G__6276 = tcoll__6262.assoc_BANG_(cljs.core.key.call(null, e__6264), cljs.core.val.call(null, e__6264));
          es__6261 = G__6275;
          tcoll__6262 = G__6276;
          continue
        }else {
          return tcoll__6262
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6265 = this;
  var tcoll__6266 = this;
  if(cljs.core.truth_(this__6265.edit)) {
    if(k == null) {
      if(this__6265.nil_val === v) {
      }else {
        this__6265.nil_val = v
      }
      if(cljs.core.truth_(this__6265.has_nil_QMARK_)) {
      }else {
        this__6265.count = this__6265.count + 1;
        this__6265.has_nil_QMARK_ = true
      }
      return tcoll__6266
    }else {
      var added_leaf_QMARK___6267 = [false];
      var node__6268 = (this__6265.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6265.root).inode_assoc_BANG_(this__6265.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6267);
      if(node__6268 === this__6265.root) {
      }else {
        this__6265.root = node__6268
      }
      if(cljs.core.truth_(added_leaf_QMARK___6267[0])) {
        this__6265.count = this__6265.count + 1
      }else {
      }
      return tcoll__6266
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6269 = this;
  var tcoll__6270 = this;
  if(cljs.core.truth_(this__6269.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6269.has_nil_QMARK_)) {
        this__6269.has_nil_QMARK_ = false;
        this__6269.nil_val = null;
        this__6269.count = this__6269.count - 1;
        return tcoll__6270
      }else {
        return tcoll__6270
      }
    }else {
      if(this__6269.root == null) {
        return tcoll__6270
      }else {
        var removed_leaf_QMARK___6271 = [false];
        var node__6272 = this__6269.root.inode_without_BANG_(this__6269.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6271);
        if(node__6272 === this__6269.root) {
        }else {
          this__6269.root = node__6272
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6271[0])) {
          this__6269.count = this__6269.count - 1
        }else {
        }
        return tcoll__6270
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6273 = this;
  var tcoll__6274 = this;
  if(cljs.core.truth_(this__6273.edit)) {
    this__6273.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6273.count, this__6273.root, this__6273.has_nil_QMARK_, this__6273.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6277 = node;
  var stack__6278 = stack;
  while(true) {
    if(t__6277 != null) {
      var G__6279 = cljs.core.truth_(ascending_QMARK_) ? t__6277.left : t__6277.right;
      var G__6280 = cljs.core.conj.call(null, stack__6278, t__6277);
      t__6277 = G__6279;
      stack__6278 = G__6280;
      continue
    }else {
      return stack__6278
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6281 = this;
  var h__364__auto____6282 = this__6281.__hash;
  if(h__364__auto____6282 != null) {
    return h__364__auto____6282
  }else {
    var h__364__auto____6283 = cljs.core.hash_coll.call(null, coll);
    this__6281.__hash = h__364__auto____6283;
    return h__364__auto____6283
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6284 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6285 = this;
  var this$__6286 = this;
  return cljs.core.pr_str.call(null, this$__6286)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6287 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6288 = this;
  if(this__6288.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6288.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6289 = this;
  return cljs.core.peek.call(null, this__6289.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6290 = this;
  var t__6291 = cljs.core.peek.call(null, this__6290.stack);
  var next_stack__6292 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6290.ascending_QMARK_) ? t__6291.right : t__6291.left, cljs.core.pop.call(null, this__6290.stack), this__6290.ascending_QMARK_);
  if(next_stack__6292 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6292, this__6290.ascending_QMARK_, this__6290.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6293 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6294 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6294.stack, this__6294.ascending_QMARK_, this__6294.cnt, this__6294.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6295 = this;
  return this__6295.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6296 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6296) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6296
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6297 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6297) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6297
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6298 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6298)) {
    return cljs.core.deref.call(null, init__6298)
  }else {
    var init__6299 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6298) : init__6298;
    if(cljs.core.reduced_QMARK_.call(null, init__6299)) {
      return cljs.core.deref.call(null, init__6299)
    }else {
      var init__6300 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6299) : init__6299;
      if(cljs.core.reduced_QMARK_.call(null, init__6300)) {
        return cljs.core.deref.call(null, init__6300)
      }else {
        return init__6300
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6305 = this;
  var h__364__auto____6306 = this__6305.__hash;
  if(h__364__auto____6306 != null) {
    return h__364__auto____6306
  }else {
    var h__364__auto____6307 = cljs.core.hash_coll.call(null, coll);
    this__6305.__hash = h__364__auto____6307;
    return h__364__auto____6307
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6308 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6309 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6310 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6310.key, this__6310.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6357 = null;
  var G__6357__2 = function(tsym6303, k) {
    var this__6311 = this;
    var tsym6303__6312 = this;
    var node__6313 = tsym6303__6312;
    return cljs.core._lookup.call(null, node__6313, k)
  };
  var G__6357__3 = function(tsym6304, k, not_found) {
    var this__6314 = this;
    var tsym6304__6315 = this;
    var node__6316 = tsym6304__6315;
    return cljs.core._lookup.call(null, node__6316, k, not_found)
  };
  G__6357 = function(tsym6304, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6357__2.call(this, tsym6304, k);
      case 3:
        return G__6357__3.call(this, tsym6304, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6357
}();
cljs.core.BlackNode.prototype.apply = function(tsym6301, args6302) {
  return tsym6301.call.apply(tsym6301, [tsym6301].concat(cljs.core.aclone.call(null, args6302)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6317 = this;
  return cljs.core.PersistentVector.fromArray([this__6317.key, this__6317.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6318 = this;
  return this__6318.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6319 = this;
  return this__6319.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6320 = this;
  var node__6321 = this;
  return ins.balance_right(node__6321)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6322 = this;
  var node__6323 = this;
  return new cljs.core.RedNode(this__6322.key, this__6322.val, this__6322.left, this__6322.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6324 = this;
  var node__6325 = this;
  return cljs.core.balance_right_del.call(null, this__6324.key, this__6324.val, this__6324.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6326 = this;
  var node__6327 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6328 = this;
  var node__6329 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6329, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6330 = this;
  var node__6331 = this;
  return cljs.core.balance_left_del.call(null, this__6330.key, this__6330.val, del, this__6330.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6332 = this;
  var node__6333 = this;
  return ins.balance_left(node__6333)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6334 = this;
  var node__6335 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6335, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6358 = null;
  var G__6358__0 = function() {
    var this__6338 = this;
    var this$__6339 = this;
    return cljs.core.pr_str.call(null, this$__6339)
  };
  G__6358 = function() {
    switch(arguments.length) {
      case 0:
        return G__6358__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6358
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6340 = this;
  var node__6341 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6341, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6342 = this;
  var node__6343 = this;
  return node__6343
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6344 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6345 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6346 = this;
  return cljs.core.list.call(null, this__6346.key, this__6346.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6348 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6349 = this;
  return this__6349.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6350 = this;
  return cljs.core.PersistentVector.fromArray([this__6350.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6351 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6351.key, this__6351.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6352 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6353 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6353.key, this__6353.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6354 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6355 = this;
  if(n === 0) {
    return this__6355.key
  }else {
    if(n === 1) {
      return this__6355.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6356 = this;
  if(n === 0) {
    return this__6356.key
  }else {
    if(n === 1) {
      return this__6356.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6347 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6363 = this;
  var h__364__auto____6364 = this__6363.__hash;
  if(h__364__auto____6364 != null) {
    return h__364__auto____6364
  }else {
    var h__364__auto____6365 = cljs.core.hash_coll.call(null, coll);
    this__6363.__hash = h__364__auto____6365;
    return h__364__auto____6365
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6366 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6367 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6368 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6368.key, this__6368.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6415 = null;
  var G__6415__2 = function(tsym6361, k) {
    var this__6369 = this;
    var tsym6361__6370 = this;
    var node__6371 = tsym6361__6370;
    return cljs.core._lookup.call(null, node__6371, k)
  };
  var G__6415__3 = function(tsym6362, k, not_found) {
    var this__6372 = this;
    var tsym6362__6373 = this;
    var node__6374 = tsym6362__6373;
    return cljs.core._lookup.call(null, node__6374, k, not_found)
  };
  G__6415 = function(tsym6362, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6415__2.call(this, tsym6362, k);
      case 3:
        return G__6415__3.call(this, tsym6362, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6415
}();
cljs.core.RedNode.prototype.apply = function(tsym6359, args6360) {
  return tsym6359.call.apply(tsym6359, [tsym6359].concat(cljs.core.aclone.call(null, args6360)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6375 = this;
  return cljs.core.PersistentVector.fromArray([this__6375.key, this__6375.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6376 = this;
  return this__6376.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6377 = this;
  return this__6377.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6378 = this;
  var node__6379 = this;
  return new cljs.core.RedNode(this__6378.key, this__6378.val, this__6378.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6380 = this;
  var node__6381 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6382 = this;
  var node__6383 = this;
  return new cljs.core.RedNode(this__6382.key, this__6382.val, this__6382.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6384 = this;
  var node__6385 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6386 = this;
  var node__6387 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6387, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6388 = this;
  var node__6389 = this;
  return new cljs.core.RedNode(this__6388.key, this__6388.val, del, this__6388.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6390 = this;
  var node__6391 = this;
  return new cljs.core.RedNode(this__6390.key, this__6390.val, ins, this__6390.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6392 = this;
  var node__6393 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6392.left)) {
    return new cljs.core.RedNode(this__6392.key, this__6392.val, this__6392.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6392.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6392.right)) {
      return new cljs.core.RedNode(this__6392.right.key, this__6392.right.val, new cljs.core.BlackNode(this__6392.key, this__6392.val, this__6392.left, this__6392.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6392.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6393, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6416 = null;
  var G__6416__0 = function() {
    var this__6396 = this;
    var this$__6397 = this;
    return cljs.core.pr_str.call(null, this$__6397)
  };
  G__6416 = function() {
    switch(arguments.length) {
      case 0:
        return G__6416__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6416
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6398 = this;
  var node__6399 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6398.right)) {
    return new cljs.core.RedNode(this__6398.key, this__6398.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6398.left, null), this__6398.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6398.left)) {
      return new cljs.core.RedNode(this__6398.left.key, this__6398.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6398.left.left, null), new cljs.core.BlackNode(this__6398.key, this__6398.val, this__6398.left.right, this__6398.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6399, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6400 = this;
  var node__6401 = this;
  return new cljs.core.BlackNode(this__6400.key, this__6400.val, this__6400.left, this__6400.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6402 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6403 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6404 = this;
  return cljs.core.list.call(null, this__6404.key, this__6404.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6406 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6407 = this;
  return this__6407.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6408 = this;
  return cljs.core.PersistentVector.fromArray([this__6408.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6409 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6409.key, this__6409.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6410 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6411 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6411.key, this__6411.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6412 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6413 = this;
  if(n === 0) {
    return this__6413.key
  }else {
    if(n === 1) {
      return this__6413.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6414 = this;
  if(n === 0) {
    return this__6414.key
  }else {
    if(n === 1) {
      return this__6414.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6405 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6417 = comp.call(null, k, tree.key);
    if(c__6417 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6417 < 0) {
        var ins__6418 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6418 != null) {
          return tree.add_left(ins__6418)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6419 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6419 != null) {
            return tree.add_right(ins__6419)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6420 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6420)) {
            return new cljs.core.RedNode(app__6420.key, app__6420.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6420.left), new cljs.core.RedNode(right.key, right.val, app__6420.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6420, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6421 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6421)) {
              return new cljs.core.RedNode(app__6421.key, app__6421.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6421.left, null), new cljs.core.BlackNode(right.key, right.val, app__6421.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6421, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6422 = comp.call(null, k, tree.key);
    if(c__6422 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6422 < 0) {
        var del__6423 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6424 = del__6423 != null;
          if(or__3548__auto____6424) {
            return or__3548__auto____6424
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6423, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6423, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6425 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6426 = del__6425 != null;
            if(or__3548__auto____6426) {
              return or__3548__auto____6426
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6425)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6425, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6427 = tree.key;
  var c__6428 = comp.call(null, k, tk__6427);
  if(c__6428 === 0) {
    return tree.replace(tk__6427, v, tree.left, tree.right)
  }else {
    if(c__6428 < 0) {
      return tree.replace(tk__6427, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6427, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6433 = this;
  var h__364__auto____6434 = this__6433.__hash;
  if(h__364__auto____6434 != null) {
    return h__364__auto____6434
  }else {
    var h__364__auto____6435 = cljs.core.hash_imap.call(null, coll);
    this__6433.__hash = h__364__auto____6435;
    return h__364__auto____6435
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6436 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6437 = this;
  var n__6438 = coll.entry_at(k);
  if(n__6438 != null) {
    return n__6438.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6439 = this;
  var found__6440 = [null];
  var t__6441 = cljs.core.tree_map_add.call(null, this__6439.comp, this__6439.tree, k, v, found__6440);
  if(t__6441 == null) {
    var found_node__6442 = cljs.core.nth.call(null, found__6440, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6442.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6439.comp, cljs.core.tree_map_replace.call(null, this__6439.comp, this__6439.tree, k, v), this__6439.cnt, this__6439.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6439.comp, t__6441.blacken(), this__6439.cnt + 1, this__6439.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6443 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6475 = null;
  var G__6475__2 = function(tsym6431, k) {
    var this__6444 = this;
    var tsym6431__6445 = this;
    var coll__6446 = tsym6431__6445;
    return cljs.core._lookup.call(null, coll__6446, k)
  };
  var G__6475__3 = function(tsym6432, k, not_found) {
    var this__6447 = this;
    var tsym6432__6448 = this;
    var coll__6449 = tsym6432__6448;
    return cljs.core._lookup.call(null, coll__6449, k, not_found)
  };
  G__6475 = function(tsym6432, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6475__2.call(this, tsym6432, k);
      case 3:
        return G__6475__3.call(this, tsym6432, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6475
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6429, args6430) {
  return tsym6429.call.apply(tsym6429, [tsym6429].concat(cljs.core.aclone.call(null, args6430)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6450 = this;
  if(this__6450.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6450.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6451 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6452 = this;
  if(this__6452.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6452.tree, false, this__6452.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6453 = this;
  var this$__6454 = this;
  return cljs.core.pr_str.call(null, this$__6454)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6455 = this;
  var coll__6456 = this;
  var t__6457 = this__6455.tree;
  while(true) {
    if(t__6457 != null) {
      var c__6458 = this__6455.comp.call(null, k, t__6457.key);
      if(c__6458 === 0) {
        return t__6457
      }else {
        if(c__6458 < 0) {
          var G__6476 = t__6457.left;
          t__6457 = G__6476;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6477 = t__6457.right;
            t__6457 = G__6477;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6459 = this;
  if(this__6459.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6459.tree, ascending_QMARK_, this__6459.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6460 = this;
  if(this__6460.cnt > 0) {
    var stack__6461 = null;
    var t__6462 = this__6460.tree;
    while(true) {
      if(t__6462 != null) {
        var c__6463 = this__6460.comp.call(null, k, t__6462.key);
        if(c__6463 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6461, t__6462), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6463 < 0) {
              var G__6478 = cljs.core.conj.call(null, stack__6461, t__6462);
              var G__6479 = t__6462.left;
              stack__6461 = G__6478;
              t__6462 = G__6479;
              continue
            }else {
              var G__6480 = stack__6461;
              var G__6481 = t__6462.right;
              stack__6461 = G__6480;
              t__6462 = G__6481;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6463 > 0) {
                var G__6482 = cljs.core.conj.call(null, stack__6461, t__6462);
                var G__6483 = t__6462.right;
                stack__6461 = G__6482;
                t__6462 = G__6483;
                continue
              }else {
                var G__6484 = stack__6461;
                var G__6485 = t__6462.left;
                stack__6461 = G__6484;
                t__6462 = G__6485;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6461 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6461, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6464 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6465 = this;
  return this__6465.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6466 = this;
  if(this__6466.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6466.tree, true, this__6466.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6467 = this;
  return this__6467.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6468 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6469 = this;
  return new cljs.core.PersistentTreeMap(this__6469.comp, this__6469.tree, this__6469.cnt, meta, this__6469.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6473 = this;
  return this__6473.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6474 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6474.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6470 = this;
  var found__6471 = [null];
  var t__6472 = cljs.core.tree_map_remove.call(null, this__6470.comp, this__6470.tree, k, found__6471);
  if(t__6472 == null) {
    if(cljs.core.nth.call(null, found__6471, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6470.comp, null, 0, this__6470.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6470.comp, t__6472.blacken(), this__6470.cnt - 1, this__6470.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6486 = cljs.core.seq.call(null, keyvals);
    var out__6487 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6486)) {
        var G__6488 = cljs.core.nnext.call(null, in$__6486);
        var G__6489 = cljs.core.assoc_BANG_.call(null, out__6487, cljs.core.first.call(null, in$__6486), cljs.core.second.call(null, in$__6486));
        in$__6486 = G__6488;
        out__6487 = G__6489;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6487)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6490) {
    var keyvals = cljs.core.seq(arglist__6490);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6491) {
    var keyvals = cljs.core.seq(arglist__6491);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6492 = cljs.core.seq.call(null, keyvals);
    var out__6493 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6492)) {
        var G__6494 = cljs.core.nnext.call(null, in$__6492);
        var G__6495 = cljs.core.assoc.call(null, out__6493, cljs.core.first.call(null, in$__6492), cljs.core.second.call(null, in$__6492));
        in$__6492 = G__6494;
        out__6493 = G__6495;
        continue
      }else {
        return out__6493
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6496) {
    var keyvals = cljs.core.seq(arglist__6496);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6497 = cljs.core.seq.call(null, keyvals);
    var out__6498 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6497)) {
        var G__6499 = cljs.core.nnext.call(null, in$__6497);
        var G__6500 = cljs.core.assoc.call(null, out__6498, cljs.core.first.call(null, in$__6497), cljs.core.second.call(null, in$__6497));
        in$__6497 = G__6499;
        out__6498 = G__6500;
        continue
      }else {
        return out__6498
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6501) {
    var comparator = cljs.core.first(arglist__6501);
    var keyvals = cljs.core.rest(arglist__6501);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6502_SHARP_, p2__6503_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6504 = p1__6502_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6504)) {
            return or__3548__auto____6504
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6503_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6505) {
    var maps = cljs.core.seq(arglist__6505);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6508 = function(m, e) {
        var k__6506 = cljs.core.first.call(null, e);
        var v__6507 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6506)) {
          return cljs.core.assoc.call(null, m, k__6506, f.call(null, cljs.core.get.call(null, m, k__6506), v__6507))
        }else {
          return cljs.core.assoc.call(null, m, k__6506, v__6507)
        }
      };
      var merge2__6510 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6508, function() {
          var or__3548__auto____6509 = m1;
          if(cljs.core.truth_(or__3548__auto____6509)) {
            return or__3548__auto____6509
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6510, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6511) {
    var f = cljs.core.first(arglist__6511);
    var maps = cljs.core.rest(arglist__6511);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6512 = cljs.core.ObjMap.fromObject([], {});
  var keys__6513 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6513)) {
      var key__6514 = cljs.core.first.call(null, keys__6513);
      var entry__6515 = cljs.core.get.call(null, map, key__6514, "\ufdd0'user/not-found");
      var G__6516 = cljs.core.not_EQ_.call(null, entry__6515, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6512, key__6514, entry__6515) : ret__6512;
      var G__6517 = cljs.core.next.call(null, keys__6513);
      ret__6512 = G__6516;
      keys__6513 = G__6517;
      continue
    }else {
      return ret__6512
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6523 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6523.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6524 = this;
  var h__364__auto____6525 = this__6524.__hash;
  if(h__364__auto____6525 != null) {
    return h__364__auto____6525
  }else {
    var h__364__auto____6526 = cljs.core.hash_iset.call(null, coll);
    this__6524.__hash = h__364__auto____6526;
    return h__364__auto____6526
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6527 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6528 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6528.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6547 = null;
  var G__6547__2 = function(tsym6521, k) {
    var this__6529 = this;
    var tsym6521__6530 = this;
    var coll__6531 = tsym6521__6530;
    return cljs.core._lookup.call(null, coll__6531, k)
  };
  var G__6547__3 = function(tsym6522, k, not_found) {
    var this__6532 = this;
    var tsym6522__6533 = this;
    var coll__6534 = tsym6522__6533;
    return cljs.core._lookup.call(null, coll__6534, k, not_found)
  };
  G__6547 = function(tsym6522, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6547__2.call(this, tsym6522, k);
      case 3:
        return G__6547__3.call(this, tsym6522, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6547
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6519, args6520) {
  return tsym6519.call.apply(tsym6519, [tsym6519].concat(cljs.core.aclone.call(null, args6520)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6535 = this;
  return new cljs.core.PersistentHashSet(this__6535.meta, cljs.core.assoc.call(null, this__6535.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6536 = this;
  var this$__6537 = this;
  return cljs.core.pr_str.call(null, this$__6537)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6538 = this;
  return cljs.core.keys.call(null, this__6538.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6539 = this;
  return new cljs.core.PersistentHashSet(this__6539.meta, cljs.core.dissoc.call(null, this__6539.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6540 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6541 = this;
  var and__3546__auto____6542 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6542) {
    var and__3546__auto____6543 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6543) {
      return cljs.core.every_QMARK_.call(null, function(p1__6518_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6518_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6543
    }
  }else {
    return and__3546__auto____6542
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6544 = this;
  return new cljs.core.PersistentHashSet(meta, this__6544.hash_map, this__6544.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6545 = this;
  return this__6545.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6546 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6546.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6565 = null;
  var G__6565__2 = function(tsym6551, k) {
    var this__6553 = this;
    var tsym6551__6554 = this;
    var tcoll__6555 = tsym6551__6554;
    if(cljs.core._lookup.call(null, this__6553.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6565__3 = function(tsym6552, k, not_found) {
    var this__6556 = this;
    var tsym6552__6557 = this;
    var tcoll__6558 = tsym6552__6557;
    if(cljs.core._lookup.call(null, this__6556.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6565 = function(tsym6552, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6565__2.call(this, tsym6552, k);
      case 3:
        return G__6565__3.call(this, tsym6552, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6565
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6549, args6550) {
  return tsym6549.call.apply(tsym6549, [tsym6549].concat(cljs.core.aclone.call(null, args6550)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6559 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6560 = this;
  if(cljs.core._lookup.call(null, this__6560.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6561 = this;
  return cljs.core.count.call(null, this__6561.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6562 = this;
  this__6562.transient_map = cljs.core.dissoc_BANG_.call(null, this__6562.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6563 = this;
  this__6563.transient_map = cljs.core.assoc_BANG_.call(null, this__6563.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6564 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6564.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6570 = this;
  var h__364__auto____6571 = this__6570.__hash;
  if(h__364__auto____6571 != null) {
    return h__364__auto____6571
  }else {
    var h__364__auto____6572 = cljs.core.hash_iset.call(null, coll);
    this__6570.__hash = h__364__auto____6572;
    return h__364__auto____6572
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6573 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6574 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6574.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6598 = null;
  var G__6598__2 = function(tsym6568, k) {
    var this__6575 = this;
    var tsym6568__6576 = this;
    var coll__6577 = tsym6568__6576;
    return cljs.core._lookup.call(null, coll__6577, k)
  };
  var G__6598__3 = function(tsym6569, k, not_found) {
    var this__6578 = this;
    var tsym6569__6579 = this;
    var coll__6580 = tsym6569__6579;
    return cljs.core._lookup.call(null, coll__6580, k, not_found)
  };
  G__6598 = function(tsym6569, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6598__2.call(this, tsym6569, k);
      case 3:
        return G__6598__3.call(this, tsym6569, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6598
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6566, args6567) {
  return tsym6566.call.apply(tsym6566, [tsym6566].concat(cljs.core.aclone.call(null, args6567)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6581 = this;
  return new cljs.core.PersistentTreeSet(this__6581.meta, cljs.core.assoc.call(null, this__6581.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6582 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6582.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6583 = this;
  var this$__6584 = this;
  return cljs.core.pr_str.call(null, this$__6584)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6585 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6585.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6586 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6586.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6587 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6588 = this;
  return cljs.core._comparator.call(null, this__6588.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6589 = this;
  return cljs.core.keys.call(null, this__6589.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6590 = this;
  return new cljs.core.PersistentTreeSet(this__6590.meta, cljs.core.dissoc.call(null, this__6590.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6591 = this;
  return cljs.core.count.call(null, this__6591.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6592 = this;
  var and__3546__auto____6593 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6593) {
    var and__3546__auto____6594 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6594) {
      return cljs.core.every_QMARK_.call(null, function(p1__6548_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6548_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6594
    }
  }else {
    return and__3546__auto____6593
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6595 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6595.tree_map, this__6595.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6596 = this;
  return this__6596.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6597 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6597.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6599 = cljs.core.seq.call(null, coll);
  var out__6600 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6599))) {
      var G__6601 = cljs.core.next.call(null, in$__6599);
      var G__6602 = cljs.core.conj_BANG_.call(null, out__6600, cljs.core.first.call(null, in$__6599));
      in$__6599 = G__6601;
      out__6600 = G__6602;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6600)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6603) {
    var keys = cljs.core.seq(arglist__6603);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6605) {
    var comparator = cljs.core.first(arglist__6605);
    var keys = cljs.core.rest(arglist__6605);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6606 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6607 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6607)) {
        var e__6608 = temp__3695__auto____6607;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6608))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6606, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6604_SHARP_) {
      var temp__3695__auto____6609 = cljs.core.find.call(null, smap, p1__6604_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6609)) {
        var e__6610 = temp__3695__auto____6609;
        return cljs.core.second.call(null, e__6610)
      }else {
        return p1__6604_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6618 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6611, seen) {
        while(true) {
          var vec__6612__6613 = p__6611;
          var f__6614 = cljs.core.nth.call(null, vec__6612__6613, 0, null);
          var xs__6615 = vec__6612__6613;
          var temp__3698__auto____6616 = cljs.core.seq.call(null, xs__6615);
          if(cljs.core.truth_(temp__3698__auto____6616)) {
            var s__6617 = temp__3698__auto____6616;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6614)) {
              var G__6619 = cljs.core.rest.call(null, s__6617);
              var G__6620 = seen;
              p__6611 = G__6619;
              seen = G__6620;
              continue
            }else {
              return cljs.core.cons.call(null, f__6614, step.call(null, cljs.core.rest.call(null, s__6617), cljs.core.conj.call(null, seen, f__6614)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6618.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6621 = cljs.core.PersistentVector.fromArray([]);
  var s__6622 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6622))) {
      var G__6623 = cljs.core.conj.call(null, ret__6621, cljs.core.first.call(null, s__6622));
      var G__6624 = cljs.core.next.call(null, s__6622);
      ret__6621 = G__6623;
      s__6622 = G__6624;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6621)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6625 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6625) {
        return or__3548__auto____6625
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6626 = x.lastIndexOf("/");
      if(i__6626 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6626 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6627 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6627) {
      return or__3548__auto____6627
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6628 = x.lastIndexOf("/");
    if(i__6628 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6628)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6631 = cljs.core.ObjMap.fromObject([], {});
  var ks__6632 = cljs.core.seq.call(null, keys);
  var vs__6633 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6634 = ks__6632;
      if(cljs.core.truth_(and__3546__auto____6634)) {
        return vs__6633
      }else {
        return and__3546__auto____6634
      }
    }())) {
      var G__6635 = cljs.core.assoc.call(null, map__6631, cljs.core.first.call(null, ks__6632), cljs.core.first.call(null, vs__6633));
      var G__6636 = cljs.core.next.call(null, ks__6632);
      var G__6637 = cljs.core.next.call(null, vs__6633);
      map__6631 = G__6635;
      ks__6632 = G__6636;
      vs__6633 = G__6637;
      continue
    }else {
      return map__6631
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6640__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6629_SHARP_, p2__6630_SHARP_) {
        return max_key.call(null, k, p1__6629_SHARP_, p2__6630_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6640 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6640__delegate.call(this, k, x, y, more)
    };
    G__6640.cljs$lang$maxFixedArity = 3;
    G__6640.cljs$lang$applyTo = function(arglist__6641) {
      var k = cljs.core.first(arglist__6641);
      var x = cljs.core.first(cljs.core.next(arglist__6641));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6641)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6641)));
      return G__6640__delegate(k, x, y, more)
    };
    G__6640.cljs$lang$arity$variadic = G__6640__delegate;
    return G__6640
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6642__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6638_SHARP_, p2__6639_SHARP_) {
        return min_key.call(null, k, p1__6638_SHARP_, p2__6639_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6642 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6642__delegate.call(this, k, x, y, more)
    };
    G__6642.cljs$lang$maxFixedArity = 3;
    G__6642.cljs$lang$applyTo = function(arglist__6643) {
      var k = cljs.core.first(arglist__6643);
      var x = cljs.core.first(cljs.core.next(arglist__6643));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6643)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6643)));
      return G__6642__delegate(k, x, y, more)
    };
    G__6642.cljs$lang$arity$variadic = G__6642__delegate;
    return G__6642
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6644 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6644)) {
        var s__6645 = temp__3698__auto____6644;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6645), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6645)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6646 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6646)) {
      var s__6647 = temp__3698__auto____6646;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6647)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6647), take_while.call(null, pred, cljs.core.rest.call(null, s__6647)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6648 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6648.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6649 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6650 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6650)) {
        var vec__6651__6652 = temp__3698__auto____6650;
        var e__6653 = cljs.core.nth.call(null, vec__6651__6652, 0, null);
        var s__6654 = vec__6651__6652;
        if(cljs.core.truth_(include__6649.call(null, e__6653))) {
          return s__6654
        }else {
          return cljs.core.next.call(null, s__6654)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6649, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6655 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6655)) {
      var vec__6656__6657 = temp__3698__auto____6655;
      var e__6658 = cljs.core.nth.call(null, vec__6656__6657, 0, null);
      var s__6659 = vec__6656__6657;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__6658)) ? s__6659 : cljs.core.next.call(null, s__6659))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__6660 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____6661 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____6661)) {
        var vec__6662__6663 = temp__3698__auto____6661;
        var e__6664 = cljs.core.nth.call(null, vec__6662__6663, 0, null);
        var s__6665 = vec__6662__6663;
        if(cljs.core.truth_(include__6660.call(null, e__6664))) {
          return s__6665
        }else {
          return cljs.core.next.call(null, s__6665)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6660, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6666 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____6666)) {
      var vec__6667__6668 = temp__3698__auto____6666;
      var e__6669 = cljs.core.nth.call(null, vec__6667__6668, 0, null);
      var s__6670 = vec__6667__6668;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__6669)) ? s__6670 : cljs.core.next.call(null, s__6670))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__6671 = this;
  var h__364__auto____6672 = this__6671.__hash;
  if(h__364__auto____6672 != null) {
    return h__364__auto____6672
  }else {
    var h__364__auto____6673 = cljs.core.hash_coll.call(null, rng);
    this__6671.__hash = h__364__auto____6673;
    return h__364__auto____6673
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__6674 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__6675 = this;
  var this$__6676 = this;
  return cljs.core.pr_str.call(null, this$__6676)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__6677 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__6678 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__6679 = this;
  var comp__6680 = this__6679.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__6680.call(null, this__6679.start, this__6679.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__6681 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__6681.end - this__6681.start) / this__6681.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__6682 = this;
  return this__6682.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__6683 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__6683.meta, this__6683.start + this__6683.step, this__6683.end, this__6683.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__6684 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__6685 = this;
  return new cljs.core.Range(meta, this__6685.start, this__6685.end, this__6685.step, this__6685.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__6686 = this;
  return this__6686.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__6687 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6687.start + n * this__6687.step
  }else {
    if(function() {
      var and__3546__auto____6688 = this__6687.start > this__6687.end;
      if(and__3546__auto____6688) {
        return this__6687.step === 0
      }else {
        return and__3546__auto____6688
      }
    }()) {
      return this__6687.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__6689 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6689.start + n * this__6689.step
  }else {
    if(function() {
      var and__3546__auto____6690 = this__6689.start > this__6689.end;
      if(and__3546__auto____6690) {
        return this__6689.step === 0
      }else {
        return and__3546__auto____6690
      }
    }()) {
      return this__6689.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__6691 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6691.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6692 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6692)) {
      var s__6693 = temp__3698__auto____6692;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__6693), take_nth.call(null, n, cljs.core.drop.call(null, n, s__6693)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6695 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6695)) {
      var s__6696 = temp__3698__auto____6695;
      var fst__6697 = cljs.core.first.call(null, s__6696);
      var fv__6698 = f.call(null, fst__6697);
      var run__6699 = cljs.core.cons.call(null, fst__6697, cljs.core.take_while.call(null, function(p1__6694_SHARP_) {
        return cljs.core._EQ_.call(null, fv__6698, f.call(null, p1__6694_SHARP_))
      }, cljs.core.next.call(null, s__6696)));
      return cljs.core.cons.call(null, run__6699, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__6699), s__6696))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____6710 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____6710)) {
        var s__6711 = temp__3695__auto____6710;
        return reductions.call(null, f, cljs.core.first.call(null, s__6711), cljs.core.rest.call(null, s__6711))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6712 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6712)) {
        var s__6713 = temp__3698__auto____6712;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__6713)), cljs.core.rest.call(null, s__6713))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__6715 = null;
      var G__6715__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__6715__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__6715__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__6715__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__6715__4 = function() {
        var G__6716__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__6716 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6716__delegate.call(this, x, y, z, args)
        };
        G__6716.cljs$lang$maxFixedArity = 3;
        G__6716.cljs$lang$applyTo = function(arglist__6717) {
          var x = cljs.core.first(arglist__6717);
          var y = cljs.core.first(cljs.core.next(arglist__6717));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6717)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6717)));
          return G__6716__delegate(x, y, z, args)
        };
        G__6716.cljs$lang$arity$variadic = G__6716__delegate;
        return G__6716
      }();
      G__6715 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6715__0.call(this);
          case 1:
            return G__6715__1.call(this, x);
          case 2:
            return G__6715__2.call(this, x, y);
          case 3:
            return G__6715__3.call(this, x, y, z);
          default:
            return G__6715__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6715.cljs$lang$maxFixedArity = 3;
      G__6715.cljs$lang$applyTo = G__6715__4.cljs$lang$applyTo;
      return G__6715
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__6718 = null;
      var G__6718__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__6718__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__6718__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__6718__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__6718__4 = function() {
        var G__6719__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__6719 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6719__delegate.call(this, x, y, z, args)
        };
        G__6719.cljs$lang$maxFixedArity = 3;
        G__6719.cljs$lang$applyTo = function(arglist__6720) {
          var x = cljs.core.first(arglist__6720);
          var y = cljs.core.first(cljs.core.next(arglist__6720));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6720)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6720)));
          return G__6719__delegate(x, y, z, args)
        };
        G__6719.cljs$lang$arity$variadic = G__6719__delegate;
        return G__6719
      }();
      G__6718 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6718__0.call(this);
          case 1:
            return G__6718__1.call(this, x);
          case 2:
            return G__6718__2.call(this, x, y);
          case 3:
            return G__6718__3.call(this, x, y, z);
          default:
            return G__6718__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6718.cljs$lang$maxFixedArity = 3;
      G__6718.cljs$lang$applyTo = G__6718__4.cljs$lang$applyTo;
      return G__6718
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__6721 = null;
      var G__6721__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__6721__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__6721__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__6721__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__6721__4 = function() {
        var G__6722__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__6722 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6722__delegate.call(this, x, y, z, args)
        };
        G__6722.cljs$lang$maxFixedArity = 3;
        G__6722.cljs$lang$applyTo = function(arglist__6723) {
          var x = cljs.core.first(arglist__6723);
          var y = cljs.core.first(cljs.core.next(arglist__6723));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6723)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6723)));
          return G__6722__delegate(x, y, z, args)
        };
        G__6722.cljs$lang$arity$variadic = G__6722__delegate;
        return G__6722
      }();
      G__6721 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6721__0.call(this);
          case 1:
            return G__6721__1.call(this, x);
          case 2:
            return G__6721__2.call(this, x, y);
          case 3:
            return G__6721__3.call(this, x, y, z);
          default:
            return G__6721__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6721.cljs$lang$maxFixedArity = 3;
      G__6721.cljs$lang$applyTo = G__6721__4.cljs$lang$applyTo;
      return G__6721
    }()
  };
  var juxt__4 = function() {
    var G__6724__delegate = function(f, g, h, fs) {
      var fs__6714 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__6725 = null;
        var G__6725__0 = function() {
          return cljs.core.reduce.call(null, function(p1__6700_SHARP_, p2__6701_SHARP_) {
            return cljs.core.conj.call(null, p1__6700_SHARP_, p2__6701_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__6714)
        };
        var G__6725__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__6702_SHARP_, p2__6703_SHARP_) {
            return cljs.core.conj.call(null, p1__6702_SHARP_, p2__6703_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__6714)
        };
        var G__6725__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__6704_SHARP_, p2__6705_SHARP_) {
            return cljs.core.conj.call(null, p1__6704_SHARP_, p2__6705_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__6714)
        };
        var G__6725__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__6706_SHARP_, p2__6707_SHARP_) {
            return cljs.core.conj.call(null, p1__6706_SHARP_, p2__6707_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__6714)
        };
        var G__6725__4 = function() {
          var G__6726__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__6708_SHARP_, p2__6709_SHARP_) {
              return cljs.core.conj.call(null, p1__6708_SHARP_, cljs.core.apply.call(null, p2__6709_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__6714)
          };
          var G__6726 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__6726__delegate.call(this, x, y, z, args)
          };
          G__6726.cljs$lang$maxFixedArity = 3;
          G__6726.cljs$lang$applyTo = function(arglist__6727) {
            var x = cljs.core.first(arglist__6727);
            var y = cljs.core.first(cljs.core.next(arglist__6727));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6727)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6727)));
            return G__6726__delegate(x, y, z, args)
          };
          G__6726.cljs$lang$arity$variadic = G__6726__delegate;
          return G__6726
        }();
        G__6725 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__6725__0.call(this);
            case 1:
              return G__6725__1.call(this, x);
            case 2:
              return G__6725__2.call(this, x, y);
            case 3:
              return G__6725__3.call(this, x, y, z);
            default:
              return G__6725__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__6725.cljs$lang$maxFixedArity = 3;
        G__6725.cljs$lang$applyTo = G__6725__4.cljs$lang$applyTo;
        return G__6725
      }()
    };
    var G__6724 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6724__delegate.call(this, f, g, h, fs)
    };
    G__6724.cljs$lang$maxFixedArity = 3;
    G__6724.cljs$lang$applyTo = function(arglist__6728) {
      var f = cljs.core.first(arglist__6728);
      var g = cljs.core.first(cljs.core.next(arglist__6728));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6728)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6728)));
      return G__6724__delegate(f, g, h, fs)
    };
    G__6724.cljs$lang$arity$variadic = G__6724__delegate;
    return G__6724
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__6730 = cljs.core.next.call(null, coll);
        coll = G__6730;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____6729 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____6729)) {
          return n > 0
        }else {
          return and__3546__auto____6729
        }
      }())) {
        var G__6731 = n - 1;
        var G__6732 = cljs.core.next.call(null, coll);
        n = G__6731;
        coll = G__6732;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__6733 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__6733), s)) {
    if(cljs.core.count.call(null, matches__6733) === 1) {
      return cljs.core.first.call(null, matches__6733)
    }else {
      return cljs.core.vec.call(null, matches__6733)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__6734 = re.exec(s);
  if(matches__6734 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__6734) === 1) {
      return cljs.core.first.call(null, matches__6734)
    }else {
      return cljs.core.vec.call(null, matches__6734)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__6735 = cljs.core.re_find.call(null, re, s);
  var match_idx__6736 = s.search(re);
  var match_str__6737 = cljs.core.coll_QMARK_.call(null, match_data__6735) ? cljs.core.first.call(null, match_data__6735) : match_data__6735;
  var post_match__6738 = cljs.core.subs.call(null, s, match_idx__6736 + cljs.core.count.call(null, match_str__6737));
  if(cljs.core.truth_(match_data__6735)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__6735, re_seq.call(null, re, post_match__6738))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__6740__6741 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___6742 = cljs.core.nth.call(null, vec__6740__6741, 0, null);
  var flags__6743 = cljs.core.nth.call(null, vec__6740__6741, 1, null);
  var pattern__6744 = cljs.core.nth.call(null, vec__6740__6741, 2, null);
  return new RegExp(pattern__6744, flags__6743)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__6739_SHARP_) {
    return print_one.call(null, p1__6739_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____6745 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____6745)) {
            var and__3546__auto____6749 = function() {
              var G__6746__6747 = obj;
              if(G__6746__6747 != null) {
                if(function() {
                  var or__3548__auto____6748 = G__6746__6747.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____6748) {
                    return or__3548__auto____6748
                  }else {
                    return G__6746__6747.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__6746__6747.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6746__6747)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6746__6747)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____6749)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____6749
            }
          }else {
            return and__3546__auto____6745
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____6750 = obj != null;
          if(and__3546__auto____6750) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____6750
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__6751__6752 = obj;
          if(G__6751__6752 != null) {
            if(function() {
              var or__3548__auto____6753 = G__6751__6752.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____6753) {
                return or__3548__auto____6753
              }else {
                return G__6751__6752.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__6751__6752.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6751__6752)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6751__6752)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__6754 = cljs.core.first.call(null, objs);
  var sb__6755 = new goog.string.StringBuffer;
  var G__6756__6757 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6756__6757)) {
    var obj__6758 = cljs.core.first.call(null, G__6756__6757);
    var G__6756__6759 = G__6756__6757;
    while(true) {
      if(obj__6758 === first_obj__6754) {
      }else {
        sb__6755.append(" ")
      }
      var G__6760__6761 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6758, opts));
      if(cljs.core.truth_(G__6760__6761)) {
        var string__6762 = cljs.core.first.call(null, G__6760__6761);
        var G__6760__6763 = G__6760__6761;
        while(true) {
          sb__6755.append(string__6762);
          var temp__3698__auto____6764 = cljs.core.next.call(null, G__6760__6763);
          if(cljs.core.truth_(temp__3698__auto____6764)) {
            var G__6760__6765 = temp__3698__auto____6764;
            var G__6768 = cljs.core.first.call(null, G__6760__6765);
            var G__6769 = G__6760__6765;
            string__6762 = G__6768;
            G__6760__6763 = G__6769;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6766 = cljs.core.next.call(null, G__6756__6759);
      if(cljs.core.truth_(temp__3698__auto____6766)) {
        var G__6756__6767 = temp__3698__auto____6766;
        var G__6770 = cljs.core.first.call(null, G__6756__6767);
        var G__6771 = G__6756__6767;
        obj__6758 = G__6770;
        G__6756__6759 = G__6771;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__6755
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__6772 = cljs.core.pr_sb.call(null, objs, opts);
  sb__6772.append("\n");
  return[cljs.core.str(sb__6772)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__6773 = cljs.core.first.call(null, objs);
  var G__6774__6775 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6774__6775)) {
    var obj__6776 = cljs.core.first.call(null, G__6774__6775);
    var G__6774__6777 = G__6774__6775;
    while(true) {
      if(obj__6776 === first_obj__6773) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__6778__6779 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6776, opts));
      if(cljs.core.truth_(G__6778__6779)) {
        var string__6780 = cljs.core.first.call(null, G__6778__6779);
        var G__6778__6781 = G__6778__6779;
        while(true) {
          cljs.core.string_print.call(null, string__6780);
          var temp__3698__auto____6782 = cljs.core.next.call(null, G__6778__6781);
          if(cljs.core.truth_(temp__3698__auto____6782)) {
            var G__6778__6783 = temp__3698__auto____6782;
            var G__6786 = cljs.core.first.call(null, G__6778__6783);
            var G__6787 = G__6778__6783;
            string__6780 = G__6786;
            G__6778__6781 = G__6787;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6784 = cljs.core.next.call(null, G__6774__6777);
      if(cljs.core.truth_(temp__3698__auto____6784)) {
        var G__6774__6785 = temp__3698__auto____6784;
        var G__6788 = cljs.core.first.call(null, G__6774__6785);
        var G__6789 = G__6774__6785;
        obj__6776 = G__6788;
        G__6774__6777 = G__6789;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__6790) {
    var objs = cljs.core.seq(arglist__6790);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__6791) {
    var objs = cljs.core.seq(arglist__6791);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__6792) {
    var objs = cljs.core.seq(arglist__6792);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__6793) {
    var objs = cljs.core.seq(arglist__6793);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__6794) {
    var objs = cljs.core.seq(arglist__6794);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__6795) {
    var objs = cljs.core.seq(arglist__6795);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__6796) {
    var objs = cljs.core.seq(arglist__6796);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__6797) {
    var objs = cljs.core.seq(arglist__6797);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6798 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6798, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6799 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6799, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6800 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6800, "{", ", ", "}", opts, coll)
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____6801 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____6801)) {
        var nspc__6802 = temp__3698__auto____6801;
        return[cljs.core.str(nspc__6802), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____6803 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____6803)) {
          var nspc__6804 = temp__3698__auto____6803;
          return[cljs.core.str(nspc__6804), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6805 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6805, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6806 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6806, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__6807 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__6808 = this;
  var G__6809__6810 = cljs.core.seq.call(null, this__6808.watches);
  if(cljs.core.truth_(G__6809__6810)) {
    var G__6812__6814 = cljs.core.first.call(null, G__6809__6810);
    var vec__6813__6815 = G__6812__6814;
    var key__6816 = cljs.core.nth.call(null, vec__6813__6815, 0, null);
    var f__6817 = cljs.core.nth.call(null, vec__6813__6815, 1, null);
    var G__6809__6818 = G__6809__6810;
    var G__6812__6819 = G__6812__6814;
    var G__6809__6820 = G__6809__6818;
    while(true) {
      var vec__6821__6822 = G__6812__6819;
      var key__6823 = cljs.core.nth.call(null, vec__6821__6822, 0, null);
      var f__6824 = cljs.core.nth.call(null, vec__6821__6822, 1, null);
      var G__6809__6825 = G__6809__6820;
      f__6824.call(null, key__6823, this$, oldval, newval);
      var temp__3698__auto____6826 = cljs.core.next.call(null, G__6809__6825);
      if(cljs.core.truth_(temp__3698__auto____6826)) {
        var G__6809__6827 = temp__3698__auto____6826;
        var G__6834 = cljs.core.first.call(null, G__6809__6827);
        var G__6835 = G__6809__6827;
        G__6812__6819 = G__6834;
        G__6809__6820 = G__6835;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__6828 = this;
  return this$.watches = cljs.core.assoc.call(null, this__6828.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__6829 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__6829.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__6830 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__6830.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__6831 = this;
  return this__6831.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__6832 = this;
  return this__6832.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6833 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__6842__delegate = function(x, p__6836) {
      var map__6837__6838 = p__6836;
      var map__6837__6839 = cljs.core.seq_QMARK_.call(null, map__6837__6838) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6837__6838) : map__6837__6838;
      var validator__6840 = cljs.core.get.call(null, map__6837__6839, "\ufdd0'validator");
      var meta__6841 = cljs.core.get.call(null, map__6837__6839, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__6841, validator__6840, null)
    };
    var G__6842 = function(x, var_args) {
      var p__6836 = null;
      if(goog.isDef(var_args)) {
        p__6836 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__6842__delegate.call(this, x, p__6836)
    };
    G__6842.cljs$lang$maxFixedArity = 1;
    G__6842.cljs$lang$applyTo = function(arglist__6843) {
      var x = cljs.core.first(arglist__6843);
      var p__6836 = cljs.core.rest(arglist__6843);
      return G__6842__delegate(x, p__6836)
    };
    G__6842.cljs$lang$arity$variadic = G__6842__delegate;
    return G__6842
  }();
  atom = function(x, var_args) {
    var p__6836 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____6844 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____6844)) {
    var validate__6845 = temp__3698__auto____6844;
    if(cljs.core.truth_(validate__6845.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5905))))].join(""));
    }
  }else {
  }
  var old_value__6846 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__6846, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__6847__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__6847 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__6847__delegate.call(this, a, f, x, y, z, more)
    };
    G__6847.cljs$lang$maxFixedArity = 5;
    G__6847.cljs$lang$applyTo = function(arglist__6848) {
      var a = cljs.core.first(arglist__6848);
      var f = cljs.core.first(cljs.core.next(arglist__6848));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6848)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__6848))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__6848)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__6848)))));
      return G__6847__delegate(a, f, x, y, z, more)
    };
    G__6847.cljs$lang$arity$variadic = G__6847__delegate;
    return G__6847
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__6849) {
    var iref = cljs.core.first(arglist__6849);
    var f = cljs.core.first(cljs.core.next(arglist__6849));
    var args = cljs.core.rest(cljs.core.next(arglist__6849));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__6850 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__6850.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__6851 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__6851.state, function(p__6852) {
    var curr_state__6853 = p__6852;
    var curr_state__6854 = cljs.core.seq_QMARK_.call(null, curr_state__6853) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__6853) : curr_state__6853;
    var done__6855 = cljs.core.get.call(null, curr_state__6854, "\ufdd0'done");
    if(cljs.core.truth_(done__6855)) {
      return curr_state__6854
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__6851.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__6856__6857 = options;
    var map__6856__6858 = cljs.core.seq_QMARK_.call(null, map__6856__6857) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6856__6857) : map__6856__6857;
    var keywordize_keys__6859 = cljs.core.get.call(null, map__6856__6858, "\ufdd0'keywordize-keys");
    var keyfn__6860 = cljs.core.truth_(keywordize_keys__6859) ? cljs.core.keyword : cljs.core.str;
    var f__6866 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__593__auto____6865 = function iter__6861(s__6862) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__6862__6863 = s__6862;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__6862__6863))) {
                        var k__6864 = cljs.core.first.call(null, s__6862__6863);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__6860.call(null, k__6864), thisfn.call(null, x[k__6864])]), iter__6861.call(null, cljs.core.rest.call(null, s__6862__6863)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__593__auto____6865.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__6866.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__6867) {
    var x = cljs.core.first(arglist__6867);
    var options = cljs.core.rest(arglist__6867);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__6868 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__6872__delegate = function(args) {
      var temp__3695__auto____6869 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__6868), args);
      if(cljs.core.truth_(temp__3695__auto____6869)) {
        var v__6870 = temp__3695__auto____6869;
        return v__6870
      }else {
        var ret__6871 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__6868, cljs.core.assoc, args, ret__6871);
        return ret__6871
      }
    };
    var G__6872 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__6872__delegate.call(this, args)
    };
    G__6872.cljs$lang$maxFixedArity = 0;
    G__6872.cljs$lang$applyTo = function(arglist__6873) {
      var args = cljs.core.seq(arglist__6873);
      return G__6872__delegate(args)
    };
    G__6872.cljs$lang$arity$variadic = G__6872__delegate;
    return G__6872
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__6874 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__6874)) {
        var G__6875 = ret__6874;
        f = G__6875;
        continue
      }else {
        return ret__6874
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__6876__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__6876 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__6876__delegate.call(this, f, args)
    };
    G__6876.cljs$lang$maxFixedArity = 1;
    G__6876.cljs$lang$applyTo = function(arglist__6877) {
      var f = cljs.core.first(arglist__6877);
      var args = cljs.core.rest(arglist__6877);
      return G__6876__delegate(f, args)
    };
    G__6876.cljs$lang$arity$variadic = G__6876__delegate;
    return G__6876
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__6878 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__6878, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__6878, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____6879 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____6879) {
      return or__3548__auto____6879
    }else {
      var or__3548__auto____6880 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____6880) {
        return or__3548__auto____6880
      }else {
        var and__3546__auto____6881 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____6881) {
          var and__3546__auto____6882 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____6882) {
            var and__3546__auto____6883 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____6883) {
              var ret__6884 = true;
              var i__6885 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____6886 = cljs.core.not.call(null, ret__6884);
                  if(or__3548__auto____6886) {
                    return or__3548__auto____6886
                  }else {
                    return i__6885 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__6884
                }else {
                  var G__6887 = isa_QMARK_.call(null, h, child.call(null, i__6885), parent.call(null, i__6885));
                  var G__6888 = i__6885 + 1;
                  ret__6884 = G__6887;
                  i__6885 = G__6888;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____6883
            }
          }else {
            return and__3546__auto____6882
          }
        }else {
          return and__3546__auto____6881
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6189))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6193))))].join(""));
    }
    var tp__6892 = "\ufdd0'parents".call(null, h);
    var td__6893 = "\ufdd0'descendants".call(null, h);
    var ta__6894 = "\ufdd0'ancestors".call(null, h);
    var tf__6895 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____6896 = cljs.core.contains_QMARK_.call(null, tp__6892.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__6894.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__6894.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__6892, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__6895.call(null, "\ufdd0'ancestors".call(null, h), tag, td__6893, parent, ta__6894), "\ufdd0'descendants":tf__6895.call(null, "\ufdd0'descendants".call(null, h), parent, ta__6894, tag, td__6893)})
    }();
    if(cljs.core.truth_(or__3548__auto____6896)) {
      return or__3548__auto____6896
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__6897 = "\ufdd0'parents".call(null, h);
    var childsParents__6898 = cljs.core.truth_(parentMap__6897.call(null, tag)) ? cljs.core.disj.call(null, parentMap__6897.call(null, tag), parent) : cljs.core.set([]);
    var newParents__6899 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__6898)) ? cljs.core.assoc.call(null, parentMap__6897, tag, childsParents__6898) : cljs.core.dissoc.call(null, parentMap__6897, tag);
    var deriv_seq__6900 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__6889_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__6889_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__6889_SHARP_), cljs.core.second.call(null, p1__6889_SHARP_)))
    }, cljs.core.seq.call(null, newParents__6899)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__6897.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__6890_SHARP_, p2__6891_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__6890_SHARP_, p2__6891_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__6900))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__6901 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____6903 = cljs.core.truth_(function() {
    var and__3546__auto____6902 = xprefs__6901;
    if(cljs.core.truth_(and__3546__auto____6902)) {
      return xprefs__6901.call(null, y)
    }else {
      return and__3546__auto____6902
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____6903)) {
    return or__3548__auto____6903
  }else {
    var or__3548__auto____6905 = function() {
      var ps__6904 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__6904) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__6904), prefer_table))) {
          }else {
          }
          var G__6908 = cljs.core.rest.call(null, ps__6904);
          ps__6904 = G__6908;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____6905)) {
      return or__3548__auto____6905
    }else {
      var or__3548__auto____6907 = function() {
        var ps__6906 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__6906) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__6906), y, prefer_table))) {
            }else {
            }
            var G__6909 = cljs.core.rest.call(null, ps__6906);
            ps__6906 = G__6909;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____6907)) {
        return or__3548__auto____6907
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____6910 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____6910)) {
    return or__3548__auto____6910
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__6919 = cljs.core.reduce.call(null, function(be, p__6911) {
    var vec__6912__6913 = p__6911;
    var k__6914 = cljs.core.nth.call(null, vec__6912__6913, 0, null);
    var ___6915 = cljs.core.nth.call(null, vec__6912__6913, 1, null);
    var e__6916 = vec__6912__6913;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__6914)) {
      var be2__6918 = cljs.core.truth_(function() {
        var or__3548__auto____6917 = be == null;
        if(or__3548__auto____6917) {
          return or__3548__auto____6917
        }else {
          return cljs.core.dominates.call(null, k__6914, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__6916 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__6918), k__6914, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__6914), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__6918)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__6918
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__6919)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__6919));
      return cljs.core.second.call(null, best_entry__6919)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____6920 = mf;
    if(and__3546__auto____6920) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____6920
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____6921 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6921) {
        return or__3548__auto____6921
      }else {
        var or__3548__auto____6922 = cljs.core._reset["_"];
        if(or__3548__auto____6922) {
          return or__3548__auto____6922
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____6923 = mf;
    if(and__3546__auto____6923) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____6923
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____6924 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6924) {
        return or__3548__auto____6924
      }else {
        var or__3548__auto____6925 = cljs.core._add_method["_"];
        if(or__3548__auto____6925) {
          return or__3548__auto____6925
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____6926 = mf;
    if(and__3546__auto____6926) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____6926
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____6927 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6927) {
        return or__3548__auto____6927
      }else {
        var or__3548__auto____6928 = cljs.core._remove_method["_"];
        if(or__3548__auto____6928) {
          return or__3548__auto____6928
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____6929 = mf;
    if(and__3546__auto____6929) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____6929
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____6930 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6930) {
        return or__3548__auto____6930
      }else {
        var or__3548__auto____6931 = cljs.core._prefer_method["_"];
        if(or__3548__auto____6931) {
          return or__3548__auto____6931
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____6932 = mf;
    if(and__3546__auto____6932) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____6932
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____6933 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6933) {
        return or__3548__auto____6933
      }else {
        var or__3548__auto____6934 = cljs.core._get_method["_"];
        if(or__3548__auto____6934) {
          return or__3548__auto____6934
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____6935 = mf;
    if(and__3546__auto____6935) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____6935
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____6936 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6936) {
        return or__3548__auto____6936
      }else {
        var or__3548__auto____6937 = cljs.core._methods["_"];
        if(or__3548__auto____6937) {
          return or__3548__auto____6937
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____6938 = mf;
    if(and__3546__auto____6938) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____6938
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____6939 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6939) {
        return or__3548__auto____6939
      }else {
        var or__3548__auto____6940 = cljs.core._prefers["_"];
        if(or__3548__auto____6940) {
          return or__3548__auto____6940
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____6941 = mf;
    if(and__3546__auto____6941) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____6941
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____6942 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____6942) {
        return or__3548__auto____6942
      }else {
        var or__3548__auto____6943 = cljs.core._dispatch["_"];
        if(or__3548__auto____6943) {
          return or__3548__auto____6943
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__6944 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__6945 = cljs.core._get_method.call(null, mf, dispatch_val__6944);
  if(cljs.core.truth_(target_fn__6945)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__6944)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__6945, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__6946 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__6947 = this;
  cljs.core.swap_BANG_.call(null, this__6947.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__6947.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__6947.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__6947.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__6948 = this;
  cljs.core.swap_BANG_.call(null, this__6948.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__6948.method_cache, this__6948.method_table, this__6948.cached_hierarchy, this__6948.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__6949 = this;
  cljs.core.swap_BANG_.call(null, this__6949.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__6949.method_cache, this__6949.method_table, this__6949.cached_hierarchy, this__6949.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__6950 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__6950.cached_hierarchy), cljs.core.deref.call(null, this__6950.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__6950.method_cache, this__6950.method_table, this__6950.cached_hierarchy, this__6950.hierarchy)
  }
  var temp__3695__auto____6951 = cljs.core.deref.call(null, this__6950.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____6951)) {
    var target_fn__6952 = temp__3695__auto____6951;
    return target_fn__6952
  }else {
    var temp__3695__auto____6953 = cljs.core.find_and_cache_best_method.call(null, this__6950.name, dispatch_val, this__6950.hierarchy, this__6950.method_table, this__6950.prefer_table, this__6950.method_cache, this__6950.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____6953)) {
      var target_fn__6954 = temp__3695__auto____6953;
      return target_fn__6954
    }else {
      return cljs.core.deref.call(null, this__6950.method_table).call(null, this__6950.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__6955 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__6955.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__6955.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__6955.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__6955.method_cache, this__6955.method_table, this__6955.cached_hierarchy, this__6955.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__6956 = this;
  return cljs.core.deref.call(null, this__6956.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__6957 = this;
  return cljs.core.deref.call(null, this__6957.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__6958 = this;
  return cljs.core.do_dispatch.call(null, mf, this__6958.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__6959__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__6959 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__6959__delegate.call(this, _, args)
  };
  G__6959.cljs$lang$maxFixedArity = 1;
  G__6959.cljs$lang$applyTo = function(arglist__6960) {
    var _ = cljs.core.first(arglist__6960);
    var args = cljs.core.rest(arglist__6960);
    return G__6959__delegate(_, args)
  };
  G__6959.cljs$lang$arity$variadic = G__6959__delegate;
  return G__6959
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____6962 = reader;
    if(and__3546__auto____6962) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____6962
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____6963 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____6963) {
        return or__3548__auto____6963
      }else {
        var or__3548__auto____6964 = cljs.reader.read_char["_"];
        if(or__3548__auto____6964) {
          return or__3548__auto____6964
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____6965 = reader;
    if(and__3546__auto____6965) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____6965
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____6966 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____6966) {
        return or__3548__auto____6966
      }else {
        var or__3548__auto____6967 = cljs.reader.unread["_"];
        if(or__3548__auto____6967) {
          return or__3548__auto____6967
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__436__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__6968 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__6968.buffer_atom))) {
    var idx__6969 = cljs.core.deref.call(null, this__6968.index_atom);
    cljs.core.swap_BANG_.call(null, this__6968.index_atom, cljs.core.inc);
    return cljs.core.nth.call(null, this__6968.s, idx__6969)
  }else {
    var buf__6970 = cljs.core.deref.call(null, this__6968.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__6968.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__6970)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__6971 = this;
  return cljs.core.swap_BANG_.call(null, this__6971.buffer_atom, function(p1__6961_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__6961_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____6972 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____6972)) {
    return or__3548__auto____6972
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____6973 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(cljs.core.truth_(or__3548__auto____6973)) {
    return or__3548__auto____6973
  }else {
    var and__3546__auto____6975 = function() {
      var or__3548__auto____6974 = "+" === initch;
      if(or__3548__auto____6974) {
        return or__3548__auto____6974
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____6975)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__6976 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__6976);
        return next_ch__6976
      }())
    }else {
      return and__3546__auto____6975
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__6977) {
    var rdr = cljs.core.first(arglist__6977);
    var msg = cljs.core.rest(arglist__6977);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____6978 = cljs.core.not_EQ_.call(null, ch, "#");
  if(and__3546__auto____6978) {
    var and__3546__auto____6979 = cljs.core.not_EQ_.call(null, ch, "'");
    if(and__3546__auto____6979) {
      var and__3546__auto____6980 = cljs.core.not_EQ_.call(null, ch, ":");
      if(and__3546__auto____6980) {
        return cljs.core.contains_QMARK_.call(null, cljs.reader.macros, ch)
      }else {
        return and__3546__auto____6980
      }
    }else {
      return and__3546__auto____6979
    }
  }else {
    return and__3546__auto____6978
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__6981 = new goog.string.StringBuffer(initch);
  var ch__6982 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____6983 = ch__6982 == null;
      if(or__3548__auto____6983) {
        return or__3548__auto____6983
      }else {
        var or__3548__auto____6984 = cljs.reader.whitespace_QMARK_.call(null, ch__6982);
        if(cljs.core.truth_(or__3548__auto____6984)) {
          return or__3548__auto____6984
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__6982)
        }
      }
    }())) {
      cljs.reader.unread.call(null, rdr, ch__6982);
      return sb__6981.toString()
    }else {
      var G__6985 = function() {
        sb__6981.append(ch__6982);
        return sb__6981
      }();
      var G__6986 = cljs.reader.read_char.call(null, rdr);
      sb__6981 = G__6985;
      ch__6982 = G__6986;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__6987 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____6988 = ch__6987 === "n";
      if(or__3548__auto____6988) {
        return or__3548__auto____6988
      }else {
        var or__3548__auto____6989 = ch__6987 === "r";
        if(or__3548__auto____6989) {
          return or__3548__auto____6989
        }else {
          return ch__6987 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.match_int = function match_int(s) {
  var groups__6990 = cljs.core.re_find.call(null, cljs.reader.int_pattern, s);
  var group3__6991 = cljs.core.nth.call(null, groups__6990, 2);
  if(cljs.core.not.call(null, function() {
    var or__3548__auto____6992 = void 0 === group3__6991;
    if(or__3548__auto____6992) {
      return or__3548__auto____6992
    }else {
      return group3__6991.length < 1
    }
  }())) {
    return 0
  }else {
    var negate__6994 = "-" === cljs.core.nth.call(null, groups__6990, 1) ? -1 : 1;
    var vec__6993__6995 = cljs.core.truth_(cljs.core.nth.call(null, groups__6990, 3)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__6990, 3), 10]) : cljs.core.truth_(cljs.core.nth.call(null, groups__6990, 4)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__6990, 4), 16]) : cljs.core.truth_(cljs.core.nth.call(null, groups__6990, 5)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__6990, 5), 8]) : cljs.core.truth_(cljs.core.nth.call(null, 
    groups__6990, 7)) ? cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, groups__6990, 7), parseInt(cljs.core.nth.call(null, groups__6990, 7))]) : "\ufdd0'default" ? cljs.core.PersistentVector.fromArray([null, null]) : null;
    var n__6996 = cljs.core.nth.call(null, vec__6993__6995, 0, null);
    var radix__6997 = cljs.core.nth.call(null, vec__6993__6995, 1, null);
    if(n__6996 == null) {
      return null
    }else {
      return negate__6994 * parseInt(n__6996, radix__6997)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__6998 = cljs.core.re_find.call(null, cljs.reader.ratio_pattern, s);
  var numinator__6999 = cljs.core.nth.call(null, groups__6998, 1);
  var denominator__7000 = cljs.core.nth.call(null, groups__6998, 2);
  return parseInt(numinator__6999) / parseInt(denominator__7000)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.core.re_matches.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.core.re_matches.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.core.re_matches.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = cljs.core.PersistentArrayMap.fromArrays(["t", "r", "n", "\\", '"', "b", "f"], ["\t", "\r", "\n", "\\", '"', "\u0008", "\u000c"]);
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7001 = cljs.reader.read_char.call(null, reader);
  var mapresult__7002 = cljs.core.get.call(null, cljs.reader.escape_char_map, ch__7001);
  if(cljs.core.truth_(mapresult__7002)) {
    return mapresult__7002
  }else {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7003 = "u" === ch__7001;
      if(or__3548__auto____7003) {
        return or__3548__auto____7003
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7001)
      }
    }())) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7001)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape charater: \\", ch__7001)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7004 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7004))) {
      var G__7005 = cljs.reader.read_char.call(null, rdr);
      ch__7004 = G__7005;
      continue
    }else {
      return ch__7004
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7006 = cljs.core.PersistentVector.fromArray([]);
  while(true) {
    var ch__7007 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7007)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7007) {
      return a__7006
    }else {
      var temp__3695__auto____7008 = cljs.core.get.call(null, cljs.reader.macros, ch__7007);
      if(cljs.core.truth_(temp__3695__auto____7008)) {
        var macrofn__7009 = temp__3695__auto____7008;
        var mret__7010 = macrofn__7009.call(null, rdr, ch__7007);
        var G__7012 = cljs.core._EQ_.call(null, mret__7010, rdr) ? a__7006 : cljs.core.conj.call(null, a__7006, mret__7010);
        a__7006 = G__7012;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7007);
        var o__7011 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7013 = cljs.core._EQ_.call(null, o__7011, rdr) ? a__7006 : cljs.core.conj.call(null, a__7006, o__7011);
        a__7006 = G__7013;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7014 = cljs.reader.read_char.call(null, rdr);
  var dm__7015 = cljs.core.get.call(null, cljs.reader.dispatch_macros, ch__7014);
  if(cljs.core.truth_(dm__7015)) {
    return dm__7015.call(null, rdr, _)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7014)
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7016 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7016))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7016)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7017 = new goog.string.StringBuffer(initch);
  var ch__7018 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7019 = ch__7018 == null;
      if(or__3548__auto____7019) {
        return or__3548__auto____7019
      }else {
        var or__3548__auto____7020 = cljs.reader.whitespace_QMARK_.call(null, ch__7018);
        if(cljs.core.truth_(or__3548__auto____7020)) {
          return or__3548__auto____7020
        }else {
          return cljs.core.contains_QMARK_.call(null, cljs.reader.macros, ch__7018)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7018);
      var s__7021 = buffer__7017.toString();
      var or__3548__auto____7022 = cljs.reader.match_number.call(null, s__7021);
      if(cljs.core.truth_(or__3548__auto____7022)) {
        return or__3548__auto____7022
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7021, "]")
      }
    }else {
      var G__7023 = function() {
        buffer__7017.append(ch__7018);
        return buffer__7017
      }();
      var G__7024 = cljs.reader.read_char.call(null, reader);
      buffer__7017 = G__7023;
      ch__7018 = G__7024;
      continue
    }
    break
  }
};
cljs.reader.read_string = function read_string(reader, _) {
  var buffer__7025 = new goog.string.StringBuffer;
  var ch__7026 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7026 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7026) {
        var G__7027 = function() {
          buffer__7025.append(cljs.reader.escape_char.call(null, buffer__7025, reader));
          return buffer__7025
        }();
        var G__7028 = cljs.reader.read_char.call(null, reader);
        buffer__7025 = G__7027;
        ch__7026 = G__7028;
        continue
      }else {
        if('"' === ch__7026) {
          return buffer__7025.toString()
        }else {
          if("\ufdd0'default") {
            var G__7029 = function() {
              buffer__7025.append(ch__7026);
              return buffer__7025
            }();
            var G__7030 = cljs.reader.read_char.call(null, reader);
            buffer__7025 = G__7029;
            ch__7026 = G__7030;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7031 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7031, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7031, 0, token__7031.indexOf("/")), cljs.core.subs.call(null, token__7031, token__7031.indexOf("/") + 1, token__7031.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7031, cljs.core.symbol.call(null, token__7031))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7033 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var vec__7032__7034 = cljs.core.re_matches.call(null, cljs.reader.symbol_pattern, token__7033);
  var token__7035 = cljs.core.nth.call(null, vec__7032__7034, 0, null);
  var ns__7036 = cljs.core.nth.call(null, vec__7032__7034, 1, null);
  var name__7037 = cljs.core.nth.call(null, vec__7032__7034, 2, null);
  if(cljs.core.truth_(function() {
    var or__3548__auto____7039 = function() {
      var and__3546__auto____7038 = cljs.core.not.call(null, void 0 === ns__7036);
      if(and__3546__auto____7038) {
        return ns__7036.substring(ns__7036.length - 2, ns__7036.length) === ":/"
      }else {
        return and__3546__auto____7038
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7039)) {
      return or__3548__auto____7039
    }else {
      var or__3548__auto____7040 = name__7037[name__7037.length - 1] === ":";
      if(or__3548__auto____7040) {
        return or__3548__auto____7040
      }else {
        return cljs.core.not.call(null, token__7035.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7035)
  }else {
    if(cljs.core.truth_(ns__7036)) {
      return cljs.core.keyword.call(null, ns__7036.substring(0, ns__7036.indexOf("/")), name__7037)
    }else {
      return cljs.core.keyword.call(null, token__7035)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7041 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7041)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7042 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7043__7044 = o__7042;
    if(G__7043__7044 != null) {
      if(function() {
        var or__3548__auto____7045 = G__7043__7044.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7045) {
          return or__3548__auto____7045
        }else {
          return G__7043__7044.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7043__7044.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7043__7044)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7043__7044)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7042, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7042), m__7041))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = cljs.core.PersistentHashMap.fromArrays(["@", "`", '"', "#", "%", "'", "(", ")", ":", ";", "[", "{", "\\", "]", "}", "^", "~"], [cljs.reader.wrapping_reader.call(null, "\ufdd1'deref"), cljs.reader.not_implemented, cljs.reader.read_string, cljs.reader.read_dispatch, cljs.reader.not_implemented, cljs.reader.wrapping_reader.call(null, "\ufdd1'quote"), cljs.reader.read_list, cljs.reader.read_unmatched_delimiter, cljs.reader.read_keyword, cljs.reader.not_implemented, cljs.reader.read_vector, 
cljs.reader.read_map, cljs.reader.read_char, cljs.reader.read_unmatched_delimiter, cljs.reader.read_unmatched_delimiter, cljs.reader.read_meta, cljs.reader.not_implemented]);
cljs.reader.dispatch_macros = cljs.core.ObjMap.fromObject(["{", "<", '"', "!", "_"], {"{":cljs.reader.read_set, "<":cljs.reader.throwing_reader.call(null, "Unreadable form"), '"':cljs.reader.read_regex, "!":cljs.reader.read_comment, "_":cljs.reader.read_discard});
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7046 = cljs.reader.read_char.call(null, reader);
    if(ch__7046 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.core.truth_(cljs.reader.whitespace_QMARK_.call(null, ch__7046))) {
        var G__7048 = reader;
        var G__7049 = eof_is_error;
        var G__7050 = sentinel;
        var G__7051 = is_recursive;
        reader = G__7048;
        eof_is_error = G__7049;
        sentinel = G__7050;
        is_recursive = G__7051;
        continue
      }else {
        if(cljs.core.truth_(cljs.reader.comment_prefix_QMARK_.call(null, ch__7046))) {
          var G__7052 = cljs.reader.read_comment.call(null, reader, ch__7046);
          var G__7053 = eof_is_error;
          var G__7054 = sentinel;
          var G__7055 = is_recursive;
          reader = G__7052;
          eof_is_error = G__7053;
          sentinel = G__7054;
          is_recursive = G__7055;
          continue
        }else {
          if("\ufdd0'else") {
            var res__7047 = cljs.core.truth_(cljs.reader.macros.call(null, ch__7046)) ? cljs.reader.macros.call(null, ch__7046).call(null, reader, ch__7046) : cljs.core.truth_(cljs.reader.number_literal_QMARK_.call(null, reader, ch__7046)) ? cljs.reader.read_number.call(null, reader, ch__7046) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7046) : null;
            if(cljs.core._EQ_.call(null, res__7047, reader)) {
              var G__7056 = reader;
              var G__7057 = eof_is_error;
              var G__7058 = sentinel;
              var G__7059 = is_recursive;
              reader = G__7056;
              eof_is_error = G__7057;
              sentinel = G__7058;
              is_recursive = G__7059;
              continue
            }else {
              return res__7047
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7060 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7060, true, null, false)
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7158 = s;
      var limit__7159 = limit;
      var parts__7160 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7159, 1)) {
          return cljs.core.conj.call(null, parts__7160, s__7158)
        }else {
          var temp__3695__auto____7161 = cljs.core.re_find.call(null, re, s__7158);
          if(cljs.core.truth_(temp__3695__auto____7161)) {
            var m__7162 = temp__3695__auto____7161;
            var index__7163 = s__7158.indexOf(m__7162);
            var G__7164 = s__7158.substring(index__7163 + cljs.core.count.call(null, m__7162));
            var G__7165 = limit__7159 - 1;
            var G__7166 = cljs.core.conj.call(null, parts__7160, s__7158.substring(0, index__7163));
            s__7158 = G__7164;
            limit__7159 = G__7165;
            parts__7160 = G__7166;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7160, s__7158)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7167 = s.length;
  while(true) {
    if(index__7167 === 0) {
      return""
    }else {
      var ch__7168 = cljs.core.get.call(null, s, index__7167 - 1);
      if(function() {
        var or__3548__auto____7169 = cljs.core._EQ_.call(null, ch__7168, "\n");
        if(or__3548__auto____7169) {
          return or__3548__auto____7169
        }else {
          return cljs.core._EQ_.call(null, ch__7168, "\r")
        }
      }()) {
        var G__7170 = index__7167 - 1;
        index__7167 = G__7170;
        continue
      }else {
        return s.substring(0, index__7167)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7171 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7172 = cljs.core.not.call(null, s__7171);
    if(or__3548__auto____7172) {
      return or__3548__auto____7172
    }else {
      var or__3548__auto____7173 = cljs.core._EQ_.call(null, "", s__7171);
      if(or__3548__auto____7173) {
        return or__3548__auto____7173
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7171)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7174 = new goog.string.StringBuffer;
  var length__7175 = s.length;
  var index__7176 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7175, index__7176)) {
      return buffer__7174.toString()
    }else {
      var ch__7177 = s.charAt(index__7176);
      var temp__3695__auto____7178 = cljs.core.get.call(null, cmap, ch__7177);
      if(cljs.core.truth_(temp__3695__auto____7178)) {
        var replacement__7179 = temp__3695__auto____7178;
        buffer__7174.append([cljs.core.str(replacement__7179)].join(""))
      }else {
        buffer__7174.append(ch__7177)
      }
      var G__7180 = index__7176 + 1;
      index__7176 = G__7180;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7129 = {};
  var G__7130__7131 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7130__7131)) {
    var G__7133__7135 = cljs.core.first.call(null, G__7130__7131);
    var vec__7134__7136 = G__7133__7135;
    var k__7137 = cljs.core.nth.call(null, vec__7134__7136, 0, null);
    var v__7138 = cljs.core.nth.call(null, vec__7134__7136, 1, null);
    var G__7130__7139 = G__7130__7131;
    var G__7133__7140 = G__7133__7135;
    var G__7130__7141 = G__7130__7139;
    while(true) {
      var vec__7142__7143 = G__7133__7140;
      var k__7144 = cljs.core.nth.call(null, vec__7142__7143, 0, null);
      var v__7145 = cljs.core.nth.call(null, vec__7142__7143, 1, null);
      var G__7130__7146 = G__7130__7141;
      out__7129[cljs.core.name.call(null, k__7144)] = v__7145;
      var temp__3698__auto____7147 = cljs.core.next.call(null, G__7130__7146);
      if(cljs.core.truth_(temp__3698__auto____7147)) {
        var G__7130__7148 = temp__3698__auto____7147;
        var G__7149 = cljs.core.first.call(null, G__7130__7148);
        var G__7150 = G__7130__7148;
        G__7133__7140 = G__7149;
        G__7130__7141 = G__7150;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7129
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7151 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7151)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7152) {
    var v = cljs.core.first(arglist__7152);
    var text = cljs.core.rest(arglist__7152);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7153) {
          var vec__7154__7155 = p__7153;
          var k__7156 = cljs.core.nth.call(null, vec__7154__7155, 0, null);
          var v__7157 = cljs.core.nth.call(null, vec__7154__7155, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7156), clj__GT_js.call(null, v__7157))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      return[cljs.core.str("[crateGroup="), cljs.core.str(jayq.core.crate_meta.call(null, sel)), cljs.core.str("]")].join("")
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7061) {
    var vec__7062__7063 = p__7061;
    var context__7064 = cljs.core.nth.call(null, vec__7062__7063, 0, null);
    if(cljs.core.not.call(null, context__7064)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7064)
    }
  };
  var $ = function(sel, var_args) {
    var p__7061 = null;
    if(goog.isDef(var_args)) {
      p__7061 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7061)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7065) {
    var sel = cljs.core.first(arglist__7065);
    var p__7061 = cljs.core.rest(arglist__7065);
    return $__delegate(sel, p__7061)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, jayq.core.coll, f, cljs.core.first.call(null, this$), cljs.core.count.call(null, this$))
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, jayq.core.coll, f, start, jayq.core.i)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7066 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7066)) {
    return or__3548__auto____7066
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.slice(0, 1)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7067 = null;
  var G__7067__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7067__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7067 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7067__2.call(this, _, k);
      case 3:
        return G__7067__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7067
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.map__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.map__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7068) {
    var vec__7069__7070 = p__7068;
    var v__7071 = cljs.core.nth.call(null, vec__7069__7070, 0, null);
    var a__7072 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7071)) {
      return $elem.attr(a__7072)
    }else {
      return $elem.attr(a__7072, v__7071)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7068 = null;
    if(goog.isDef(var_args)) {
      p__7068 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7068)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7073) {
    var $elem = cljs.core.first(arglist__7073);
    var a = cljs.core.first(cljs.core.next(arglist__7073));
    var p__7068 = cljs.core.rest(cljs.core.next(arglist__7073));
    return attr__delegate($elem, a, p__7068)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7074) {
    var vec__7075__7076 = p__7074;
    var v__7077 = cljs.core.nth.call(null, vec__7075__7076, 0, null);
    var k__7078 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7077)) {
      return $elem.data(k__7078)
    }else {
      return $elem.data(k__7078, v__7077)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7074 = null;
    if(goog.isDef(var_args)) {
      p__7074 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7074)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7079) {
    var $elem = cljs.core.first(arglist__7079);
    var k = cljs.core.first(cljs.core.next(arglist__7079));
    var p__7074 = cljs.core.rest(cljs.core.next(arglist__7079));
    return data__delegate($elem, k, p__7074)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7080 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7080)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7081 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7081)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7082) {
    var vec__7083__7084 = p__7082;
    var speed__7085 = cljs.core.nth.call(null, vec__7083__7084, 0, null);
    var on_finish__7086 = cljs.core.nth.call(null, vec__7083__7084, 1, null);
    return $elem.hide(speed__7085, on_finish__7086)
  };
  var hide = function($elem, var_args) {
    var p__7082 = null;
    if(goog.isDef(var_args)) {
      p__7082 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7082)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7087) {
    var $elem = cljs.core.first(arglist__7087);
    var p__7082 = cljs.core.rest(arglist__7087);
    return hide__delegate($elem, p__7082)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7088) {
    var vec__7089__7090 = p__7088;
    var speed__7091 = cljs.core.nth.call(null, vec__7089__7090, 0, null);
    var on_finish__7092 = cljs.core.nth.call(null, vec__7089__7090, 1, null);
    return $elem.show(speed__7091, on_finish__7092)
  };
  var show = function($elem, var_args) {
    var p__7088 = null;
    if(goog.isDef(var_args)) {
      p__7088 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7088)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7093) {
    var $elem = cljs.core.first(arglist__7093);
    var p__7088 = cljs.core.rest(arglist__7093);
    return show__delegate($elem, p__7088)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7094) {
    var vec__7095__7096 = p__7094;
    var speed__7097 = cljs.core.nth.call(null, vec__7095__7096, 0, null);
    var on_finish__7098 = cljs.core.nth.call(null, vec__7095__7096, 1, null);
    return $elem.fadeOut(speed__7097, on_finish__7098)
  };
  var fade_out = function($elem, var_args) {
    var p__7094 = null;
    if(goog.isDef(var_args)) {
      p__7094 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7094)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7099) {
    var $elem = cljs.core.first(arglist__7099);
    var p__7094 = cljs.core.rest(arglist__7099);
    return fade_out__delegate($elem, p__7094)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7100) {
    var vec__7101__7102 = p__7100;
    var speed__7103 = cljs.core.nth.call(null, vec__7101__7102, 0, null);
    var on_finish__7104 = cljs.core.nth.call(null, vec__7101__7102, 1, null);
    return $elem.fadeIn(speed__7103, on_finish__7104)
  };
  var fade_in = function($elem, var_args) {
    var p__7100 = null;
    if(goog.isDef(var_args)) {
      p__7100 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7100)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7105) {
    var $elem = cljs.core.first(arglist__7105);
    var p__7100 = cljs.core.rest(arglist__7105);
    return fade_in__delegate($elem, p__7100)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7106) {
    var vec__7107__7108 = p__7106;
    var speed__7109 = cljs.core.nth.call(null, vec__7107__7108, 0, null);
    var on_finish__7110 = cljs.core.nth.call(null, vec__7107__7108, 1, null);
    return $elem.slideUp(speed__7109, on_finish__7110)
  };
  var slide_up = function($elem, var_args) {
    var p__7106 = null;
    if(goog.isDef(var_args)) {
      p__7106 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7106)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7111) {
    var $elem = cljs.core.first(arglist__7111);
    var p__7106 = cljs.core.rest(arglist__7111);
    return slide_up__delegate($elem, p__7106)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7112) {
    var vec__7113__7114 = p__7112;
    var speed__7115 = cljs.core.nth.call(null, vec__7113__7114, 0, null);
    var on_finish__7116 = cljs.core.nth.call(null, vec__7113__7114, 1, null);
    return $elem.slideDown(speed__7115, on_finish__7116)
  };
  var slide_down = function($elem, var_args) {
    var p__7112 = null;
    if(goog.isDef(var_args)) {
      p__7112 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7112)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7117) {
    var $elem = cljs.core.first(arglist__7117);
    var p__7112 = cljs.core.rest(arglist__7117);
    return slide_down__delegate($elem, p__7112)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7118) {
    var vec__7119__7120 = p__7118;
    var v__7121 = cljs.core.nth.call(null, vec__7119__7120, 0, null);
    if(cljs.core.truth_(v__7121)) {
      return $elem.val(v__7121)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7118 = null;
    if(goog.isDef(var_args)) {
      p__7118 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7118)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7122) {
    var $elem = cljs.core.first(arglist__7122);
    var p__7118 = cljs.core.rest(arglist__7122);
    return val__delegate($elem, p__7118)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.xhr = function xhr(p__7123, content, callback) {
  var vec__7124__7125 = p__7123;
  var method__7126 = cljs.core.nth.call(null, vec__7124__7125, 0, null);
  var uri__7127 = cljs.core.nth.call(null, vec__7124__7125, 1, null);
  var params__7128 = jayq.util.map__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7126)), "\ufdd0'data":jayq.util.map__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7127, params__7128)
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4516 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4515_SHARP_) {
    return out__4516[cljs.core.name.call(null, cljs.core.first.call(null, p1__4515_SHARP_))] = cljs.core.second.call(null, p1__4515_SHARP_)
  }, cljmap));
  return out__4516
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4517 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4517) {
    return or__3548__auto____4517
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx) {
  if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
    return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
  }else {
    return cljsbinding.translate.call(null, eval(fnstr).call(null))
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  var bindingname__4518 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4519 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname__4518)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname__4518).call(null, elem, cljsbinding.valuefn.call(null, elem, fname__4519, ctx))
    }
  }else {
    return function() {
      return elem[bindingname__4518].call(elem, cljsbinding.valuefn.call(null, elem, fname__4519, ctx))
    }
  }
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_elem = function bind_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4520__4521 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4520__4521)) {
    var data__4522 = cljs.core.first.call(null, G__4520__4521);
    var G__4520__4523 = G__4520__4521;
    while(true) {
      cljsbinding.bind_elem.call(null, elem, data__4522.split(":"), ctx);
      var temp__3698__auto____4524 = cljs.core.next.call(null, G__4520__4523);
      if(cljs.core.truth_(temp__3698__auto____4524)) {
        var G__4520__4525 = temp__3698__auto____4524;
        var G__4526 = cljs.core.first.call(null, G__4520__4525);
        var G__4527 = G__4520__4525;
        data__4522 = G__4526;
        G__4520__4523 = G__4527;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljs.core.deref.call(null, eval(jayq.core.attr.call(null, elem, "bindatom"))))
  });
  return elem.change(function() {
    cljs.core.reset_BANG_.call(null, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljs.core.deref.call(null, eval(jayq.core.attr.call(null, elem, "bindatom"))))
  });
  return elem.change(function() {
    cljs.core.reset_BANG_.call(null, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.is(":checked"));
    return false
  })
};
cljsbinding.bindatom = function bindatom(elem) {
  if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
    return cljsbinding.bind_checkbox_atom.call(null, elem)
  }else {
    return cljsbinding.bind_input_atom.call(null, elem)
  }
};
cljsbinding.bindall = function bindall(parent, ctx) {
  var seqs__4529 = parent.find("*[bindseq]");
  var seqparents__4530 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__4528_SHARP_) {
    return p1__4528_SHARP_.parent()
  }, parent.find("*[bindseq]")));
  var G__4531__4532 = cljs.core.seq.call(null, seqs__4529);
  if(cljs.core.truth_(G__4531__4532)) {
    var elem__4533 = cljs.core.first.call(null, G__4531__4532);
    var G__4531__4534 = G__4531__4532;
    while(true) {
      jayq.core.remove.call(null, elem__4533);
      var temp__3698__auto____4535 = cljs.core.next.call(null, G__4531__4534);
      if(cljs.core.truth_(temp__3698__auto____4535)) {
        var G__4531__4536 = temp__3698__auto____4535;
        var G__4574 = cljs.core.first.call(null, G__4531__4536);
        var G__4575 = G__4531__4536;
        elem__4533 = G__4574;
        G__4531__4534 = G__4575;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4537__4538 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4537__4538)) {
    var elem__4539 = cljs.core.first.call(null, G__4537__4538);
    var G__4537__4540 = G__4537__4538;
    while(true) {
      cljsbinding.bind.call(null, elem__4539, ctx);
      var temp__3698__auto____4541 = cljs.core.next.call(null, G__4537__4540);
      if(cljs.core.truth_(temp__3698__auto____4541)) {
        var G__4537__4542 = temp__3698__auto____4541;
        var G__4576 = cljs.core.first.call(null, G__4537__4542);
        var G__4577 = G__4537__4542;
        elem__4539 = G__4576;
        G__4537__4540 = G__4577;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4543__4544 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4543__4544)) {
    var elem__4545 = cljs.core.first.call(null, G__4543__4544);
    var G__4543__4546 = G__4543__4544;
    while(true) {
      cljsbinding.bind.call(null, elem__4545, ctx);
      var temp__3698__auto____4547 = cljs.core.next.call(null, G__4543__4546);
      if(cljs.core.truth_(temp__3698__auto____4547)) {
        var G__4543__4548 = temp__3698__auto____4547;
        var G__4578 = cljs.core.first.call(null, G__4543__4548);
        var G__4579 = G__4543__4548;
        elem__4545 = G__4578;
        G__4543__4546 = G__4579;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4549__4550 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4549__4550)) {
    var elem__4551 = cljs.core.first.call(null, G__4549__4550);
    var G__4549__4552 = G__4549__4550;
    while(true) {
      cljsbinding.bindatom.call(null, elem__4551);
      var temp__3698__auto____4553 = cljs.core.next.call(null, G__4549__4552);
      if(cljs.core.truth_(temp__3698__auto____4553)) {
        var G__4549__4554 = temp__3698__auto____4553;
        var G__4580 = cljs.core.first.call(null, G__4549__4554);
        var G__4581 = G__4549__4554;
        elem__4551 = G__4580;
        G__4549__4552 = G__4581;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4555__4556 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4529, seqparents__4530));
  if(cljs.core.truth_(G__4555__4556)) {
    var G__4558__4560 = cljs.core.first.call(null, G__4555__4556);
    var vec__4559__4561 = G__4558__4560;
    var elem__4562 = cljs.core.nth.call(null, vec__4559__4561, 0, null);
    var parent__4563 = cljs.core.nth.call(null, vec__4559__4561, 1, null);
    var G__4555__4564 = G__4555__4556;
    var G__4558__4565 = G__4558__4560;
    var G__4555__4566 = G__4555__4564;
    while(true) {
      var vec__4567__4568 = G__4558__4565;
      var elem__4569 = cljs.core.nth.call(null, vec__4567__4568, 0, null);
      var parent__4570 = cljs.core.nth.call(null, vec__4567__4568, 1, null);
      var G__4555__4571 = G__4555__4566;
      cljsbinding.bindseq.call(null, elem__4569, parent__4570);
      var temp__3698__auto____4572 = cljs.core.next.call(null, G__4555__4571);
      if(cljs.core.truth_(temp__3698__auto____4572)) {
        var G__4555__4573 = temp__3698__auto____4572;
        var G__4582 = cljs.core.first.call(null, G__4555__4573);
        var G__4583 = G__4555__4573;
        G__4558__4565 = G__4582;
        G__4555__4566 = G__4583;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem) {
  jayq.core.append.call(null, parent, elem);
  return cljsbinding.bindall.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template) {
  jayq.core.remove.call(null, parent.children());
  var G__4584__4585 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4584__4585)) {
    var item__4586 = cljs.core.first.call(null, G__4584__4585);
    var G__4584__4587 = G__4584__4585;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4586, template.clone());
      var temp__3698__auto____4588 = cljs.core.next.call(null, G__4584__4587);
      if(cljs.core.truth_(temp__3698__auto____4588)) {
        var G__4584__4589 = temp__3698__auto____4588;
        var G__4590 = cljs.core.first.call(null, G__4584__4589);
        var G__4591 = G__4584__4589;
        item__4586 = G__4590;
        G__4584__4587 = G__4591;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent) {
  var atom__4592 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4592), elparent, elem);
  return cljs.core.add_watch.call(null, atom__4592, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem)
  })
};
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4593_SHARP_, p2__4594_SHARP_) {
      var or__3548__auto____4597 = p1__4593_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4597)) {
        return or__3548__auto____4597
      }else {
        return p2__4594_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4595_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4595_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, function(p1__4596_SHARP_) {
    return cljs.core.assoc.call(null, p1__4596_SHARP_, atom, cljs.core.contains_QMARK_.call(null, p1__4596_SHARP_, atom) ? cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), p1__4596_SHARP_.call(null, atom)) : cljs.core.PersistentVector.fromArray([cljs.core.deref.call(null, cljsbinding.BindFn)]))
  });
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", function(key, a, old_val, new_val) {
    var G__4598__4599 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
    if(cljs.core.truth_(G__4598__4599)) {
      var f__4600 = cljs.core.first.call(null, G__4598__4599);
      var G__4598__4601 = G__4598__4599;
      while(true) {
        f__4600.call(null);
        var temp__3698__auto____4602 = cljs.core.next.call(null, G__4598__4601);
        if(cljs.core.truth_(temp__3698__auto____4602)) {
          var G__4598__4603 = temp__3698__auto____4602;
          var G__4604 = cljs.core.first.call(null, G__4598__4603);
          var G__4605 = G__4598__4603;
          f__4600 = G__4604;
          G__4598__4601 = G__4605;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  });
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.boot = function boot() {
  return eval("    \n    var deref = cljs.core.deref\n    cljs.core.deref = function (a) {\n     if (deref(cljsbinding.BindMonitor))\n       cljsbinding.register(a)\n     return deref(a)\n    }\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4606 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4606), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4606)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4606)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4606)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4606))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, localStorage[name]))
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
