var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4731__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4731 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4731__delegate.call(this, array, i, idxs)
    };
    G__4731.cljs$lang$maxFixedArity = 2;
    G__4731.cljs$lang$applyTo = function(arglist__4732) {
      var array = cljs.core.first(arglist__4732);
      var i = cljs.core.first(cljs.core.next(arglist__4732));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4732));
      return G__4731__delegate(array, i, idxs)
    };
    G__4731.cljs$lang$arity$variadic = G__4731__delegate;
    return G__4731
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4733 = this$;
      if(and__3546__auto____4733) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4733
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4734 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4734) {
          return or__3548__auto____4734
        }else {
          var or__3548__auto____4735 = cljs.core._invoke["_"];
          if(or__3548__auto____4735) {
            return or__3548__auto____4735
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4736 = this$;
      if(and__3546__auto____4736) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4736
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4737 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4737) {
          return or__3548__auto____4737
        }else {
          var or__3548__auto____4738 = cljs.core._invoke["_"];
          if(or__3548__auto____4738) {
            return or__3548__auto____4738
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4739 = this$;
      if(and__3546__auto____4739) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4739
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4740 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4740) {
          return or__3548__auto____4740
        }else {
          var or__3548__auto____4741 = cljs.core._invoke["_"];
          if(or__3548__auto____4741) {
            return or__3548__auto____4741
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4742 = this$;
      if(and__3546__auto____4742) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4742
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4743 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4743) {
          return or__3548__auto____4743
        }else {
          var or__3548__auto____4744 = cljs.core._invoke["_"];
          if(or__3548__auto____4744) {
            return or__3548__auto____4744
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4745 = this$;
      if(and__3546__auto____4745) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4745
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4746 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4746) {
          return or__3548__auto____4746
        }else {
          var or__3548__auto____4747 = cljs.core._invoke["_"];
          if(or__3548__auto____4747) {
            return or__3548__auto____4747
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4748 = this$;
      if(and__3546__auto____4748) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4748
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4749 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4749) {
          return or__3548__auto____4749
        }else {
          var or__3548__auto____4750 = cljs.core._invoke["_"];
          if(or__3548__auto____4750) {
            return or__3548__auto____4750
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4751 = this$;
      if(and__3546__auto____4751) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4751
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4752 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4752) {
          return or__3548__auto____4752
        }else {
          var or__3548__auto____4753 = cljs.core._invoke["_"];
          if(or__3548__auto____4753) {
            return or__3548__auto____4753
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4754 = this$;
      if(and__3546__auto____4754) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4754
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4755 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4755) {
          return or__3548__auto____4755
        }else {
          var or__3548__auto____4756 = cljs.core._invoke["_"];
          if(or__3548__auto____4756) {
            return or__3548__auto____4756
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4757 = this$;
      if(and__3546__auto____4757) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4757
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4758 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4758) {
          return or__3548__auto____4758
        }else {
          var or__3548__auto____4759 = cljs.core._invoke["_"];
          if(or__3548__auto____4759) {
            return or__3548__auto____4759
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4760 = this$;
      if(and__3546__auto____4760) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4760
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4761 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4761) {
          return or__3548__auto____4761
        }else {
          var or__3548__auto____4762 = cljs.core._invoke["_"];
          if(or__3548__auto____4762) {
            return or__3548__auto____4762
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4763 = this$;
      if(and__3546__auto____4763) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4763
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4764 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4764) {
          return or__3548__auto____4764
        }else {
          var or__3548__auto____4765 = cljs.core._invoke["_"];
          if(or__3548__auto____4765) {
            return or__3548__auto____4765
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4766 = this$;
      if(and__3546__auto____4766) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4766
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4767 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4767) {
          return or__3548__auto____4767
        }else {
          var or__3548__auto____4768 = cljs.core._invoke["_"];
          if(or__3548__auto____4768) {
            return or__3548__auto____4768
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4769 = this$;
      if(and__3546__auto____4769) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4769
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4770 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4770) {
          return or__3548__auto____4770
        }else {
          var or__3548__auto____4771 = cljs.core._invoke["_"];
          if(or__3548__auto____4771) {
            return or__3548__auto____4771
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4772 = this$;
      if(and__3546__auto____4772) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4772
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4773 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4773) {
          return or__3548__auto____4773
        }else {
          var or__3548__auto____4774 = cljs.core._invoke["_"];
          if(or__3548__auto____4774) {
            return or__3548__auto____4774
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4775 = this$;
      if(and__3546__auto____4775) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4775
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4776 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4776) {
          return or__3548__auto____4776
        }else {
          var or__3548__auto____4777 = cljs.core._invoke["_"];
          if(or__3548__auto____4777) {
            return or__3548__auto____4777
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4778 = this$;
      if(and__3546__auto____4778) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4778
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4779 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4779) {
          return or__3548__auto____4779
        }else {
          var or__3548__auto____4780 = cljs.core._invoke["_"];
          if(or__3548__auto____4780) {
            return or__3548__auto____4780
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4781 = this$;
      if(and__3546__auto____4781) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4781
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4782 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4782) {
          return or__3548__auto____4782
        }else {
          var or__3548__auto____4783 = cljs.core._invoke["_"];
          if(or__3548__auto____4783) {
            return or__3548__auto____4783
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____4784 = this$;
      if(and__3546__auto____4784) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____4784
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____4785 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4785) {
          return or__3548__auto____4785
        }else {
          var or__3548__auto____4786 = cljs.core._invoke["_"];
          if(or__3548__auto____4786) {
            return or__3548__auto____4786
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____4787 = this$;
      if(and__3546__auto____4787) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____4787
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____4788 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4788) {
          return or__3548__auto____4788
        }else {
          var or__3548__auto____4789 = cljs.core._invoke["_"];
          if(or__3548__auto____4789) {
            return or__3548__auto____4789
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____4790 = this$;
      if(and__3546__auto____4790) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____4790
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____4791 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4791) {
          return or__3548__auto____4791
        }else {
          var or__3548__auto____4792 = cljs.core._invoke["_"];
          if(or__3548__auto____4792) {
            return or__3548__auto____4792
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____4793 = this$;
      if(and__3546__auto____4793) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____4793
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____4794 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4794) {
          return or__3548__auto____4794
        }else {
          var or__3548__auto____4795 = cljs.core._invoke["_"];
          if(or__3548__auto____4795) {
            return or__3548__auto____4795
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____4796 = coll;
    if(and__3546__auto____4796) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____4796
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4797 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4797) {
        return or__3548__auto____4797
      }else {
        var or__3548__auto____4798 = cljs.core._count["_"];
        if(or__3548__auto____4798) {
          return or__3548__auto____4798
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____4799 = coll;
    if(and__3546__auto____4799) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____4799
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4800 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4800) {
        return or__3548__auto____4800
      }else {
        var or__3548__auto____4801 = cljs.core._empty["_"];
        if(or__3548__auto____4801) {
          return or__3548__auto____4801
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____4802 = coll;
    if(and__3546__auto____4802) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____4802
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____4803 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4803) {
        return or__3548__auto____4803
      }else {
        var or__3548__auto____4804 = cljs.core._conj["_"];
        if(or__3548__auto____4804) {
          return or__3548__auto____4804
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____4805 = coll;
      if(and__3546__auto____4805) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____4805
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____4806 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4806) {
          return or__3548__auto____4806
        }else {
          var or__3548__auto____4807 = cljs.core._nth["_"];
          if(or__3548__auto____4807) {
            return or__3548__auto____4807
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____4808 = coll;
      if(and__3546__auto____4808) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____4808
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____4809 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4809) {
          return or__3548__auto____4809
        }else {
          var or__3548__auto____4810 = cljs.core._nth["_"];
          if(or__3548__auto____4810) {
            return or__3548__auto____4810
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____4811 = coll;
    if(and__3546__auto____4811) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____4811
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4812 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4812) {
        return or__3548__auto____4812
      }else {
        var or__3548__auto____4813 = cljs.core._first["_"];
        if(or__3548__auto____4813) {
          return or__3548__auto____4813
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____4814 = coll;
    if(and__3546__auto____4814) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____4814
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4815 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4815) {
        return or__3548__auto____4815
      }else {
        var or__3548__auto____4816 = cljs.core._rest["_"];
        if(or__3548__auto____4816) {
          return or__3548__auto____4816
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____4817 = o;
      if(and__3546__auto____4817) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____4817
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____4818 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4818) {
          return or__3548__auto____4818
        }else {
          var or__3548__auto____4819 = cljs.core._lookup["_"];
          if(or__3548__auto____4819) {
            return or__3548__auto____4819
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____4820 = o;
      if(and__3546__auto____4820) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____4820
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____4821 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4821) {
          return or__3548__auto____4821
        }else {
          var or__3548__auto____4822 = cljs.core._lookup["_"];
          if(or__3548__auto____4822) {
            return or__3548__auto____4822
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____4823 = coll;
    if(and__3546__auto____4823) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____4823
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4824 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4824) {
        return or__3548__auto____4824
      }else {
        var or__3548__auto____4825 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____4825) {
          return or__3548__auto____4825
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____4826 = coll;
    if(and__3546__auto____4826) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____4826
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____4827 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4827) {
        return or__3548__auto____4827
      }else {
        var or__3548__auto____4828 = cljs.core._assoc["_"];
        if(or__3548__auto____4828) {
          return or__3548__auto____4828
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____4829 = coll;
    if(and__3546__auto____4829) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____4829
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4830 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4830) {
        return or__3548__auto____4830
      }else {
        var or__3548__auto____4831 = cljs.core._dissoc["_"];
        if(or__3548__auto____4831) {
          return or__3548__auto____4831
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____4832 = coll;
    if(and__3546__auto____4832) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____4832
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4833 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4833) {
        return or__3548__auto____4833
      }else {
        var or__3548__auto____4834 = cljs.core._key["_"];
        if(or__3548__auto____4834) {
          return or__3548__auto____4834
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____4835 = coll;
    if(and__3546__auto____4835) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____4835
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4836 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4836) {
        return or__3548__auto____4836
      }else {
        var or__3548__auto____4837 = cljs.core._val["_"];
        if(or__3548__auto____4837) {
          return or__3548__auto____4837
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____4838 = coll;
    if(and__3546__auto____4838) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____4838
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____4839 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4839) {
        return or__3548__auto____4839
      }else {
        var or__3548__auto____4840 = cljs.core._disjoin["_"];
        if(or__3548__auto____4840) {
          return or__3548__auto____4840
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____4841 = coll;
    if(and__3546__auto____4841) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____4841
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4842 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4842) {
        return or__3548__auto____4842
      }else {
        var or__3548__auto____4843 = cljs.core._peek["_"];
        if(or__3548__auto____4843) {
          return or__3548__auto____4843
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____4844 = coll;
    if(and__3546__auto____4844) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____4844
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4845 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4845) {
        return or__3548__auto____4845
      }else {
        var or__3548__auto____4846 = cljs.core._pop["_"];
        if(or__3548__auto____4846) {
          return or__3548__auto____4846
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____4847 = coll;
    if(and__3546__auto____4847) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____4847
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____4848 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4848) {
        return or__3548__auto____4848
      }else {
        var or__3548__auto____4849 = cljs.core._assoc_n["_"];
        if(or__3548__auto____4849) {
          return or__3548__auto____4849
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____4850 = o;
    if(and__3546__auto____4850) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____4850
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4851 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____4851) {
        return or__3548__auto____4851
      }else {
        var or__3548__auto____4852 = cljs.core._deref["_"];
        if(or__3548__auto____4852) {
          return or__3548__auto____4852
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____4853 = o;
    if(and__3546__auto____4853) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____4853
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____4854 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____4854) {
        return or__3548__auto____4854
      }else {
        var or__3548__auto____4855 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____4855) {
          return or__3548__auto____4855
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____4856 = o;
    if(and__3546__auto____4856) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____4856
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4857 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4857) {
        return or__3548__auto____4857
      }else {
        var or__3548__auto____4858 = cljs.core._meta["_"];
        if(or__3548__auto____4858) {
          return or__3548__auto____4858
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____4859 = o;
    if(and__3546__auto____4859) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____4859
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____4860 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4860) {
        return or__3548__auto____4860
      }else {
        var or__3548__auto____4861 = cljs.core._with_meta["_"];
        if(or__3548__auto____4861) {
          return or__3548__auto____4861
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____4862 = coll;
      if(and__3546__auto____4862) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____4862
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____4863 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4863) {
          return or__3548__auto____4863
        }else {
          var or__3548__auto____4864 = cljs.core._reduce["_"];
          if(or__3548__auto____4864) {
            return or__3548__auto____4864
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____4865 = coll;
      if(and__3546__auto____4865) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____4865
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____4866 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4866) {
          return or__3548__auto____4866
        }else {
          var or__3548__auto____4867 = cljs.core._reduce["_"];
          if(or__3548__auto____4867) {
            return or__3548__auto____4867
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____4868 = coll;
    if(and__3546__auto____4868) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____4868
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____4869 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4869) {
        return or__3548__auto____4869
      }else {
        var or__3548__auto____4870 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____4870) {
          return or__3548__auto____4870
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____4871 = o;
    if(and__3546__auto____4871) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____4871
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____4872 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____4872) {
        return or__3548__auto____4872
      }else {
        var or__3548__auto____4873 = cljs.core._equiv["_"];
        if(or__3548__auto____4873) {
          return or__3548__auto____4873
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____4874 = o;
    if(and__3546__auto____4874) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____4874
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4875 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____4875) {
        return or__3548__auto____4875
      }else {
        var or__3548__auto____4876 = cljs.core._hash["_"];
        if(or__3548__auto____4876) {
          return or__3548__auto____4876
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____4877 = o;
    if(and__3546__auto____4877) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____4877
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4878 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4878) {
        return or__3548__auto____4878
      }else {
        var or__3548__auto____4879 = cljs.core._seq["_"];
        if(or__3548__auto____4879) {
          return or__3548__auto____4879
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____4880 = coll;
    if(and__3546__auto____4880) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____4880
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4881 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4881) {
        return or__3548__auto____4881
      }else {
        var or__3548__auto____4882 = cljs.core._rseq["_"];
        if(or__3548__auto____4882) {
          return or__3548__auto____4882
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4883 = coll;
    if(and__3546__auto____4883) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____4883
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4884 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4884) {
        return or__3548__auto____4884
      }else {
        var or__3548__auto____4885 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____4885) {
          return or__3548__auto____4885
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4886 = coll;
    if(and__3546__auto____4886) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____4886
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4887 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4887) {
        return or__3548__auto____4887
      }else {
        var or__3548__auto____4888 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____4888) {
          return or__3548__auto____4888
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____4889 = coll;
    if(and__3546__auto____4889) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____4889
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____4890 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4890) {
        return or__3548__auto____4890
      }else {
        var or__3548__auto____4891 = cljs.core._entry_key["_"];
        if(or__3548__auto____4891) {
          return or__3548__auto____4891
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____4892 = coll;
    if(and__3546__auto____4892) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____4892
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4893 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4893) {
        return or__3548__auto____4893
      }else {
        var or__3548__auto____4894 = cljs.core._comparator["_"];
        if(or__3548__auto____4894) {
          return or__3548__auto____4894
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____4895 = o;
    if(and__3546__auto____4895) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____4895
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____4896 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4896) {
        return or__3548__auto____4896
      }else {
        var or__3548__auto____4897 = cljs.core._pr_seq["_"];
        if(or__3548__auto____4897) {
          return or__3548__auto____4897
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____4898 = d;
    if(and__3546__auto____4898) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____4898
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____4899 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____4899) {
        return or__3548__auto____4899
      }else {
        var or__3548__auto____4900 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____4900) {
          return or__3548__auto____4900
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____4901 = this$;
    if(and__3546__auto____4901) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____4901
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____4902 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4902) {
        return or__3548__auto____4902
      }else {
        var or__3548__auto____4903 = cljs.core._notify_watches["_"];
        if(or__3548__auto____4903) {
          return or__3548__auto____4903
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____4904 = this$;
    if(and__3546__auto____4904) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____4904
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____4905 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4905) {
        return or__3548__auto____4905
      }else {
        var or__3548__auto____4906 = cljs.core._add_watch["_"];
        if(or__3548__auto____4906) {
          return or__3548__auto____4906
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____4907 = this$;
    if(and__3546__auto____4907) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____4907
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____4908 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4908) {
        return or__3548__auto____4908
      }else {
        var or__3548__auto____4909 = cljs.core._remove_watch["_"];
        if(or__3548__auto____4909) {
          return or__3548__auto____4909
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____4910 = coll;
    if(and__3546__auto____4910) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____4910
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4911 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4911) {
        return or__3548__auto____4911
      }else {
        var or__3548__auto____4912 = cljs.core._as_transient["_"];
        if(or__3548__auto____4912) {
          return or__3548__auto____4912
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____4913 = tcoll;
    if(and__3546__auto____4913) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____4913
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____4914 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4914) {
        return or__3548__auto____4914
      }else {
        var or__3548__auto____4915 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____4915) {
          return or__3548__auto____4915
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4916 = tcoll;
    if(and__3546__auto____4916) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____4916
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4917 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4917) {
        return or__3548__auto____4917
      }else {
        var or__3548__auto____4918 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____4918) {
          return or__3548__auto____4918
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____4919 = tcoll;
    if(and__3546__auto____4919) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____4919
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____4920 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4920) {
        return or__3548__auto____4920
      }else {
        var or__3548__auto____4921 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____4921) {
          return or__3548__auto____4921
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____4922 = tcoll;
    if(and__3546__auto____4922) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____4922
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____4923 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4923) {
        return or__3548__auto____4923
      }else {
        var or__3548__auto____4924 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____4924) {
          return or__3548__auto____4924
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____4925 = tcoll;
    if(and__3546__auto____4925) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____4925
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____4926 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4926) {
        return or__3548__auto____4926
      }else {
        var or__3548__auto____4927 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____4927) {
          return or__3548__auto____4927
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4928 = tcoll;
    if(and__3546__auto____4928) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____4928
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4929 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4929) {
        return or__3548__auto____4929
      }else {
        var or__3548__auto____4930 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____4930) {
          return or__3548__auto____4930
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____4931 = tcoll;
    if(and__3546__auto____4931) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____4931
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____4932 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4932) {
        return or__3548__auto____4932
      }else {
        var or__3548__auto____4933 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____4933) {
          return or__3548__auto____4933
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____4934 = x === y;
    if(or__3548__auto____4934) {
      return or__3548__auto____4934
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__4935__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__4936 = y;
            var G__4937 = cljs.core.first.call(null, more);
            var G__4938 = cljs.core.next.call(null, more);
            x = G__4936;
            y = G__4937;
            more = G__4938;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__4935 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4935__delegate.call(this, x, y, more)
    };
    G__4935.cljs$lang$maxFixedArity = 2;
    G__4935.cljs$lang$applyTo = function(arglist__4939) {
      var x = cljs.core.first(arglist__4939);
      var y = cljs.core.first(cljs.core.next(arglist__4939));
      var more = cljs.core.rest(cljs.core.next(arglist__4939));
      return G__4935__delegate(x, y, more)
    };
    G__4935.cljs$lang$arity$variadic = G__4935__delegate;
    return G__4935
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____4940 = x == null;
    if(or__3548__auto____4940) {
      return or__3548__auto____4940
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__4941 = null;
  var G__4941__2 = function(o, k) {
    return null
  };
  var G__4941__3 = function(o, k, not_found) {
    return not_found
  };
  G__4941 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4941__2.call(this, o, k);
      case 3:
        return G__4941__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4941
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__4942 = null;
  var G__4942__2 = function(_, f) {
    return f.call(null)
  };
  var G__4942__3 = function(_, f, start) {
    return start
  };
  G__4942 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4942__2.call(this, _, f);
      case 3:
        return G__4942__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4942
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__4943 = null;
  var G__4943__2 = function(_, n) {
    return null
  };
  var G__4943__3 = function(_, n, not_found) {
    return not_found
  };
  G__4943 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4943__2.call(this, _, n);
      case 3:
        return G__4943__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4943
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__4944 = cljs.core._nth.call(null, cicoll, 0);
      var n__4945 = 1;
      while(true) {
        if(n__4945 < cljs.core._count.call(null, cicoll)) {
          var nval__4946 = f.call(null, val__4944, cljs.core._nth.call(null, cicoll, n__4945));
          if(cljs.core.reduced_QMARK_.call(null, nval__4946)) {
            return cljs.core.deref.call(null, nval__4946)
          }else {
            var G__4953 = nval__4946;
            var G__4954 = n__4945 + 1;
            val__4944 = G__4953;
            n__4945 = G__4954;
            continue
          }
        }else {
          return val__4944
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__4947 = val;
    var n__4948 = 0;
    while(true) {
      if(n__4948 < cljs.core._count.call(null, cicoll)) {
        var nval__4949 = f.call(null, val__4947, cljs.core._nth.call(null, cicoll, n__4948));
        if(cljs.core.reduced_QMARK_.call(null, nval__4949)) {
          return cljs.core.deref.call(null, nval__4949)
        }else {
          var G__4955 = nval__4949;
          var G__4956 = n__4948 + 1;
          val__4947 = G__4955;
          n__4948 = G__4956;
          continue
        }
      }else {
        return val__4947
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__4950 = val;
    var n__4951 = idx;
    while(true) {
      if(n__4951 < cljs.core._count.call(null, cicoll)) {
        var nval__4952 = f.call(null, val__4950, cljs.core._nth.call(null, cicoll, n__4951));
        if(cljs.core.reduced_QMARK_.call(null, nval__4952)) {
          return cljs.core.deref.call(null, nval__4952)
        }else {
          var G__4957 = nval__4952;
          var G__4958 = n__4951 + 1;
          val__4950 = G__4957;
          n__4951 = G__4958;
          continue
        }
      }else {
        return val__4950
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__4959 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__4960 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__4961 = this;
  var this$__4962 = this;
  return cljs.core.pr_str.call(null, this$__4962)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__4963 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4963.a)) {
    return cljs.core.ci_reduce.call(null, this__4963.a, f, this__4963.a[this__4963.i], this__4963.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__4963.a[this__4963.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__4964 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4964.a)) {
    return cljs.core.ci_reduce.call(null, this__4964.a, f, start, this__4964.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__4965 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__4966 = this;
  return this__4966.a.length - this__4966.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__4967 = this;
  return this__4967.a[this__4967.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__4968 = this;
  if(this__4968.i + 1 < this__4968.a.length) {
    return new cljs.core.IndexedSeq(this__4968.a, this__4968.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__4969 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__4970 = this;
  var i__4971 = n + this__4970.i;
  if(i__4971 < this__4970.a.length) {
    return this__4970.a[i__4971]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__4972 = this;
  var i__4973 = n + this__4972.i;
  if(i__4973 < this__4972.a.length) {
    return this__4972.a[i__4973]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__4974 = null;
  var G__4974__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__4974__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__4974 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4974__2.call(this, array, f);
      case 3:
        return G__4974__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4974
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__4975 = null;
  var G__4975__2 = function(array, k) {
    return array[k]
  };
  var G__4975__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__4975 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4975__2.call(this, array, k);
      case 3:
        return G__4975__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4975
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__4976 = null;
  var G__4976__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__4976__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__4976 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4976__2.call(this, array, n);
      case 3:
        return G__4976__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4976
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__4977__4978 = coll;
      if(G__4977__4978 != null) {
        if(function() {
          var or__3548__auto____4979 = G__4977__4978.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____4979) {
            return or__3548__auto____4979
          }else {
            return G__4977__4978.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__4977__4978.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4977__4978)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4977__4978)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__4980__4981 = coll;
      if(G__4980__4981 != null) {
        if(function() {
          var or__3548__auto____4982 = G__4980__4981.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____4982) {
            return or__3548__auto____4982
          }else {
            return G__4980__4981.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__4980__4981.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4980__4981)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4980__4981)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__4983 = cljs.core.seq.call(null, coll);
      if(s__4983 != null) {
        return cljs.core._first.call(null, s__4983)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__4984__4985 = coll;
      if(G__4984__4985 != null) {
        if(function() {
          var or__3548__auto____4986 = G__4984__4985.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____4986) {
            return or__3548__auto____4986
          }else {
            return G__4984__4985.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__4984__4985.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4984__4985)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4984__4985)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__4987 = cljs.core.seq.call(null, coll);
      if(s__4987 != null) {
        return cljs.core._rest.call(null, s__4987)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__4988__4989 = coll;
      if(G__4988__4989 != null) {
        if(function() {
          var or__3548__auto____4990 = G__4988__4989.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____4990) {
            return or__3548__auto____4990
          }else {
            return G__4988__4989.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__4988__4989.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4988__4989)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__4988__4989)
      }
    }()) {
      var coll__4991 = cljs.core._rest.call(null, coll);
      if(coll__4991 != null) {
        if(function() {
          var G__4992__4993 = coll__4991;
          if(G__4992__4993 != null) {
            if(function() {
              var or__3548__auto____4994 = G__4992__4993.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____4994) {
                return or__3548__auto____4994
              }else {
                return G__4992__4993.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__4992__4993.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4992__4993)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__4992__4993)
          }
        }()) {
          return coll__4991
        }else {
          return cljs.core._seq.call(null, coll__4991)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__4995 = cljs.core.next.call(null, s);
      s = G__4995;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__4996__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__4997 = conj.call(null, coll, x);
          var G__4998 = cljs.core.first.call(null, xs);
          var G__4999 = cljs.core.next.call(null, xs);
          coll = G__4997;
          x = G__4998;
          xs = G__4999;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__4996 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4996__delegate.call(this, coll, x, xs)
    };
    G__4996.cljs$lang$maxFixedArity = 2;
    G__4996.cljs$lang$applyTo = function(arglist__5000) {
      var coll = cljs.core.first(arglist__5000);
      var x = cljs.core.first(cljs.core.next(arglist__5000));
      var xs = cljs.core.rest(cljs.core.next(arglist__5000));
      return G__4996__delegate(coll, x, xs)
    };
    G__4996.cljs$lang$arity$variadic = G__4996__delegate;
    return G__4996
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5001 = cljs.core.seq.call(null, coll);
  var acc__5002 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5001)) {
      return acc__5002 + cljs.core._count.call(null, s__5001)
    }else {
      var G__5003 = cljs.core.next.call(null, s__5001);
      var G__5004 = acc__5002 + 1;
      s__5001 = G__5003;
      acc__5002 = G__5004;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5005__5006 = coll;
        if(G__5005__5006 != null) {
          if(function() {
            var or__3548__auto____5007 = G__5005__5006.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5007) {
              return or__3548__auto____5007
            }else {
              return G__5005__5006.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5005__5006.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5005__5006)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5005__5006)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5008__5009 = coll;
        if(G__5008__5009 != null) {
          if(function() {
            var or__3548__auto____5010 = G__5008__5009.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5010) {
              return or__3548__auto____5010
            }else {
              return G__5008__5009.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5008__5009.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5008__5009)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5008__5009)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5012__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5011 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5013 = ret__5011;
          var G__5014 = cljs.core.first.call(null, kvs);
          var G__5015 = cljs.core.second.call(null, kvs);
          var G__5016 = cljs.core.nnext.call(null, kvs);
          coll = G__5013;
          k = G__5014;
          v = G__5015;
          kvs = G__5016;
          continue
        }else {
          return ret__5011
        }
        break
      }
    };
    var G__5012 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5012__delegate.call(this, coll, k, v, kvs)
    };
    G__5012.cljs$lang$maxFixedArity = 3;
    G__5012.cljs$lang$applyTo = function(arglist__5017) {
      var coll = cljs.core.first(arglist__5017);
      var k = cljs.core.first(cljs.core.next(arglist__5017));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5017)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5017)));
      return G__5012__delegate(coll, k, v, kvs)
    };
    G__5012.cljs$lang$arity$variadic = G__5012__delegate;
    return G__5012
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5019__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5018 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5020 = ret__5018;
          var G__5021 = cljs.core.first.call(null, ks);
          var G__5022 = cljs.core.next.call(null, ks);
          coll = G__5020;
          k = G__5021;
          ks = G__5022;
          continue
        }else {
          return ret__5018
        }
        break
      }
    };
    var G__5019 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5019__delegate.call(this, coll, k, ks)
    };
    G__5019.cljs$lang$maxFixedArity = 2;
    G__5019.cljs$lang$applyTo = function(arglist__5023) {
      var coll = cljs.core.first(arglist__5023);
      var k = cljs.core.first(cljs.core.next(arglist__5023));
      var ks = cljs.core.rest(cljs.core.next(arglist__5023));
      return G__5019__delegate(coll, k, ks)
    };
    G__5019.cljs$lang$arity$variadic = G__5019__delegate;
    return G__5019
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5024__5025 = o;
    if(G__5024__5025 != null) {
      if(function() {
        var or__3548__auto____5026 = G__5024__5025.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5026) {
          return or__3548__auto____5026
        }else {
          return G__5024__5025.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5024__5025.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5024__5025)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5024__5025)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5028__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5027 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5029 = ret__5027;
          var G__5030 = cljs.core.first.call(null, ks);
          var G__5031 = cljs.core.next.call(null, ks);
          coll = G__5029;
          k = G__5030;
          ks = G__5031;
          continue
        }else {
          return ret__5027
        }
        break
      }
    };
    var G__5028 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5028__delegate.call(this, coll, k, ks)
    };
    G__5028.cljs$lang$maxFixedArity = 2;
    G__5028.cljs$lang$applyTo = function(arglist__5032) {
      var coll = cljs.core.first(arglist__5032);
      var k = cljs.core.first(cljs.core.next(arglist__5032));
      var ks = cljs.core.rest(cljs.core.next(arglist__5032));
      return G__5028__delegate(coll, k, ks)
    };
    G__5028.cljs$lang$arity$variadic = G__5028__delegate;
    return G__5028
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5033__5034 = x;
    if(G__5033__5034 != null) {
      if(function() {
        var or__3548__auto____5035 = G__5033__5034.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5035) {
          return or__3548__auto____5035
        }else {
          return G__5033__5034.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5033__5034.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5033__5034)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5033__5034)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5036__5037 = x;
    if(G__5036__5037 != null) {
      if(function() {
        var or__3548__auto____5038 = G__5036__5037.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5038) {
          return or__3548__auto____5038
        }else {
          return G__5036__5037.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5036__5037.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5036__5037)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5036__5037)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5039__5040 = x;
  if(G__5039__5040 != null) {
    if(function() {
      var or__3548__auto____5041 = G__5039__5040.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5041) {
        return or__3548__auto____5041
      }else {
        return G__5039__5040.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5039__5040.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5039__5040)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5039__5040)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5042__5043 = x;
  if(G__5042__5043 != null) {
    if(function() {
      var or__3548__auto____5044 = G__5042__5043.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5044) {
        return or__3548__auto____5044
      }else {
        return G__5042__5043.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5042__5043.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5042__5043)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5042__5043)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5045__5046 = x;
  if(G__5045__5046 != null) {
    if(function() {
      var or__3548__auto____5047 = G__5045__5046.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5047) {
        return or__3548__auto____5047
      }else {
        return G__5045__5046.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5045__5046.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5045__5046)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5045__5046)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5048__5049 = x;
  if(G__5048__5049 != null) {
    if(function() {
      var or__3548__auto____5050 = G__5048__5049.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5050) {
        return or__3548__auto____5050
      }else {
        return G__5048__5049.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5048__5049.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5048__5049)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5048__5049)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5051__5052 = x;
  if(G__5051__5052 != null) {
    if(function() {
      var or__3548__auto____5053 = G__5051__5052.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5053) {
        return or__3548__auto____5053
      }else {
        return G__5051__5052.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5051__5052.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5051__5052)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5051__5052)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5054__5055 = x;
    if(G__5054__5055 != null) {
      if(function() {
        var or__3548__auto____5056 = G__5054__5055.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5056) {
          return or__3548__auto____5056
        }else {
          return G__5054__5055.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5054__5055.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5054__5055)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5054__5055)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5057__5058 = x;
  if(G__5057__5058 != null) {
    if(function() {
      var or__3548__auto____5059 = G__5057__5058.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5059) {
        return or__3548__auto____5059
      }else {
        return G__5057__5058.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5057__5058.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5057__5058)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5057__5058)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5060__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5060 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5060__delegate.call(this, keyvals)
    };
    G__5060.cljs$lang$maxFixedArity = 0;
    G__5060.cljs$lang$applyTo = function(arglist__5061) {
      var keyvals = cljs.core.seq(arglist__5061);
      return G__5060__delegate(keyvals)
    };
    G__5060.cljs$lang$arity$variadic = G__5060__delegate;
    return G__5060
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5062 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5062.push(key)
  });
  return keys__5062
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5063 = i;
  var j__5064 = j;
  var len__5065 = len;
  while(true) {
    if(len__5065 === 0) {
      return to
    }else {
      to[j__5064] = from[i__5063];
      var G__5066 = i__5063 + 1;
      var G__5067 = j__5064 + 1;
      var G__5068 = len__5065 - 1;
      i__5063 = G__5066;
      j__5064 = G__5067;
      len__5065 = G__5068;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5069 = i + (len - 1);
  var j__5070 = j + (len - 1);
  var len__5071 = len;
  while(true) {
    if(len__5071 === 0) {
      return to
    }else {
      to[j__5070] = from[i__5069];
      var G__5072 = i__5069 - 1;
      var G__5073 = j__5070 - 1;
      var G__5074 = len__5071 - 1;
      i__5069 = G__5072;
      j__5070 = G__5073;
      len__5071 = G__5074;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5075__5076 = s;
    if(G__5075__5076 != null) {
      if(function() {
        var or__3548__auto____5077 = G__5075__5076.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5077) {
          return or__3548__auto____5077
        }else {
          return G__5075__5076.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5075__5076.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5075__5076)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5075__5076)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5078__5079 = s;
  if(G__5078__5079 != null) {
    if(function() {
      var or__3548__auto____5080 = G__5078__5079.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5080) {
        return or__3548__auto____5080
      }else {
        return G__5078__5079.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5078__5079.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5078__5079)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5078__5079)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5081 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5081)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5082 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5082) {
        return or__3548__auto____5082
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5081
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5083 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5083)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5083
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5084 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5084)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5084
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5085 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5085) {
    return or__3548__auto____5085
  }else {
    var G__5086__5087 = f;
    if(G__5086__5087 != null) {
      if(function() {
        var or__3548__auto____5088 = G__5086__5087.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5088) {
          return or__3548__auto____5088
        }else {
          return G__5086__5087.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5086__5087.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5086__5087)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5086__5087)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5089 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5089) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5089
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5090 = coll;
    if(cljs.core.truth_(and__3546__auto____5090)) {
      var and__3546__auto____5091 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5091) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5091
      }
    }else {
      return and__3546__auto____5090
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5096__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5092 = cljs.core.set([y, x]);
        var xs__5093 = more;
        while(true) {
          var x__5094 = cljs.core.first.call(null, xs__5093);
          var etc__5095 = cljs.core.next.call(null, xs__5093);
          if(cljs.core.truth_(xs__5093)) {
            if(cljs.core.contains_QMARK_.call(null, s__5092, x__5094)) {
              return false
            }else {
              var G__5097 = cljs.core.conj.call(null, s__5092, x__5094);
              var G__5098 = etc__5095;
              s__5092 = G__5097;
              xs__5093 = G__5098;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5096 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5096__delegate.call(this, x, y, more)
    };
    G__5096.cljs$lang$maxFixedArity = 2;
    G__5096.cljs$lang$applyTo = function(arglist__5099) {
      var x = cljs.core.first(arglist__5099);
      var y = cljs.core.first(cljs.core.next(arglist__5099));
      var more = cljs.core.rest(cljs.core.next(arglist__5099));
      return G__5096__delegate(x, y, more)
    };
    G__5096.cljs$lang$arity$variadic = G__5096__delegate;
    return G__5096
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5100 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5100)) {
        return r__5100
      }else {
        if(cljs.core.truth_(r__5100)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5101 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5101, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5101)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5102 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5102)) {
      var s__5103 = temp__3695__auto____5102;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5103), cljs.core.next.call(null, s__5103))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5104 = val;
    var coll__5105 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5105)) {
        var nval__5106 = f.call(null, val__5104, cljs.core.first.call(null, coll__5105));
        if(cljs.core.reduced_QMARK_.call(null, nval__5106)) {
          return cljs.core.deref.call(null, nval__5106)
        }else {
          var G__5107 = nval__5106;
          var G__5108 = cljs.core.next.call(null, coll__5105);
          val__5104 = G__5107;
          coll__5105 = G__5108;
          continue
        }
      }else {
        return val__5104
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5109__5110 = coll;
      if(G__5109__5110 != null) {
        if(function() {
          var or__3548__auto____5111 = G__5109__5110.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5111) {
            return or__3548__auto____5111
          }else {
            return G__5109__5110.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5109__5110.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5109__5110)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5109__5110)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5112__5113 = coll;
      if(G__5112__5113 != null) {
        if(function() {
          var or__3548__auto____5114 = G__5112__5113.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5114) {
            return or__3548__auto____5114
          }else {
            return G__5112__5113.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5112__5113.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5112__5113)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5112__5113)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5115 = this;
  return this__5115.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5116__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5116 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5116__delegate.call(this, x, y, more)
    };
    G__5116.cljs$lang$maxFixedArity = 2;
    G__5116.cljs$lang$applyTo = function(arglist__5117) {
      var x = cljs.core.first(arglist__5117);
      var y = cljs.core.first(cljs.core.next(arglist__5117));
      var more = cljs.core.rest(cljs.core.next(arglist__5117));
      return G__5116__delegate(x, y, more)
    };
    G__5116.cljs$lang$arity$variadic = G__5116__delegate;
    return G__5116
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5118__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5118 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5118__delegate.call(this, x, y, more)
    };
    G__5118.cljs$lang$maxFixedArity = 2;
    G__5118.cljs$lang$applyTo = function(arglist__5119) {
      var x = cljs.core.first(arglist__5119);
      var y = cljs.core.first(cljs.core.next(arglist__5119));
      var more = cljs.core.rest(cljs.core.next(arglist__5119));
      return G__5118__delegate(x, y, more)
    };
    G__5118.cljs$lang$arity$variadic = G__5118__delegate;
    return G__5118
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5120__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5120 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5120__delegate.call(this, x, y, more)
    };
    G__5120.cljs$lang$maxFixedArity = 2;
    G__5120.cljs$lang$applyTo = function(arglist__5121) {
      var x = cljs.core.first(arglist__5121);
      var y = cljs.core.first(cljs.core.next(arglist__5121));
      var more = cljs.core.rest(cljs.core.next(arglist__5121));
      return G__5120__delegate(x, y, more)
    };
    G__5120.cljs$lang$arity$variadic = G__5120__delegate;
    return G__5120
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5122__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5122 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5122__delegate.call(this, x, y, more)
    };
    G__5122.cljs$lang$maxFixedArity = 2;
    G__5122.cljs$lang$applyTo = function(arglist__5123) {
      var x = cljs.core.first(arglist__5123);
      var y = cljs.core.first(cljs.core.next(arglist__5123));
      var more = cljs.core.rest(cljs.core.next(arglist__5123));
      return G__5122__delegate(x, y, more)
    };
    G__5122.cljs$lang$arity$variadic = G__5122__delegate;
    return G__5122
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5124__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5125 = y;
            var G__5126 = cljs.core.first.call(null, more);
            var G__5127 = cljs.core.next.call(null, more);
            x = G__5125;
            y = G__5126;
            more = G__5127;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5124 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5124__delegate.call(this, x, y, more)
    };
    G__5124.cljs$lang$maxFixedArity = 2;
    G__5124.cljs$lang$applyTo = function(arglist__5128) {
      var x = cljs.core.first(arglist__5128);
      var y = cljs.core.first(cljs.core.next(arglist__5128));
      var more = cljs.core.rest(cljs.core.next(arglist__5128));
      return G__5124__delegate(x, y, more)
    };
    G__5124.cljs$lang$arity$variadic = G__5124__delegate;
    return G__5124
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5129__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5130 = y;
            var G__5131 = cljs.core.first.call(null, more);
            var G__5132 = cljs.core.next.call(null, more);
            x = G__5130;
            y = G__5131;
            more = G__5132;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5129 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5129__delegate.call(this, x, y, more)
    };
    G__5129.cljs$lang$maxFixedArity = 2;
    G__5129.cljs$lang$applyTo = function(arglist__5133) {
      var x = cljs.core.first(arglist__5133);
      var y = cljs.core.first(cljs.core.next(arglist__5133));
      var more = cljs.core.rest(cljs.core.next(arglist__5133));
      return G__5129__delegate(x, y, more)
    };
    G__5129.cljs$lang$arity$variadic = G__5129__delegate;
    return G__5129
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5134__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5135 = y;
            var G__5136 = cljs.core.first.call(null, more);
            var G__5137 = cljs.core.next.call(null, more);
            x = G__5135;
            y = G__5136;
            more = G__5137;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5134 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5134__delegate.call(this, x, y, more)
    };
    G__5134.cljs$lang$maxFixedArity = 2;
    G__5134.cljs$lang$applyTo = function(arglist__5138) {
      var x = cljs.core.first(arglist__5138);
      var y = cljs.core.first(cljs.core.next(arglist__5138));
      var more = cljs.core.rest(cljs.core.next(arglist__5138));
      return G__5134__delegate(x, y, more)
    };
    G__5134.cljs$lang$arity$variadic = G__5134__delegate;
    return G__5134
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5139__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5140 = y;
            var G__5141 = cljs.core.first.call(null, more);
            var G__5142 = cljs.core.next.call(null, more);
            x = G__5140;
            y = G__5141;
            more = G__5142;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5139 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5139__delegate.call(this, x, y, more)
    };
    G__5139.cljs$lang$maxFixedArity = 2;
    G__5139.cljs$lang$applyTo = function(arglist__5143) {
      var x = cljs.core.first(arglist__5143);
      var y = cljs.core.first(cljs.core.next(arglist__5143));
      var more = cljs.core.rest(cljs.core.next(arglist__5143));
      return G__5139__delegate(x, y, more)
    };
    G__5139.cljs$lang$arity$variadic = G__5139__delegate;
    return G__5139
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5144__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5144 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5144__delegate.call(this, x, y, more)
    };
    G__5144.cljs$lang$maxFixedArity = 2;
    G__5144.cljs$lang$applyTo = function(arglist__5145) {
      var x = cljs.core.first(arglist__5145);
      var y = cljs.core.first(cljs.core.next(arglist__5145));
      var more = cljs.core.rest(cljs.core.next(arglist__5145));
      return G__5144__delegate(x, y, more)
    };
    G__5144.cljs$lang$arity$variadic = G__5144__delegate;
    return G__5144
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5146__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5146 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5146__delegate.call(this, x, y, more)
    };
    G__5146.cljs$lang$maxFixedArity = 2;
    G__5146.cljs$lang$applyTo = function(arglist__5147) {
      var x = cljs.core.first(arglist__5147);
      var y = cljs.core.first(cljs.core.next(arglist__5147));
      var more = cljs.core.rest(cljs.core.next(arglist__5147));
      return G__5146__delegate(x, y, more)
    };
    G__5146.cljs$lang$arity$variadic = G__5146__delegate;
    return G__5146
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5148 = n % d;
  return cljs.core.fix.call(null, (n - rem__5148) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5149 = cljs.core.quot.call(null, n, d);
  return n - d * q__5149
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5150 = 0;
  var n__5151 = n;
  while(true) {
    if(n__5151 === 0) {
      return c__5150
    }else {
      var G__5152 = c__5150 + 1;
      var G__5153 = n__5151 & n__5151 - 1;
      c__5150 = G__5152;
      n__5151 = G__5153;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5154__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5155 = y;
            var G__5156 = cljs.core.first.call(null, more);
            var G__5157 = cljs.core.next.call(null, more);
            x = G__5155;
            y = G__5156;
            more = G__5157;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5154 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5154__delegate.call(this, x, y, more)
    };
    G__5154.cljs$lang$maxFixedArity = 2;
    G__5154.cljs$lang$applyTo = function(arglist__5158) {
      var x = cljs.core.first(arglist__5158);
      var y = cljs.core.first(cljs.core.next(arglist__5158));
      var more = cljs.core.rest(cljs.core.next(arglist__5158));
      return G__5154__delegate(x, y, more)
    };
    G__5154.cljs$lang$arity$variadic = G__5154__delegate;
    return G__5154
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5159 = n;
  var xs__5160 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5161 = xs__5160;
      if(cljs.core.truth_(and__3546__auto____5161)) {
        return n__5159 > 0
      }else {
        return and__3546__auto____5161
      }
    }())) {
      var G__5162 = n__5159 - 1;
      var G__5163 = cljs.core.next.call(null, xs__5160);
      n__5159 = G__5162;
      xs__5160 = G__5163;
      continue
    }else {
      return xs__5160
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5164__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5165 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5166 = cljs.core.next.call(null, more);
            sb = G__5165;
            more = G__5166;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5164 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5164__delegate.call(this, x, ys)
    };
    G__5164.cljs$lang$maxFixedArity = 1;
    G__5164.cljs$lang$applyTo = function(arglist__5167) {
      var x = cljs.core.first(arglist__5167);
      var ys = cljs.core.rest(arglist__5167);
      return G__5164__delegate(x, ys)
    };
    G__5164.cljs$lang$arity$variadic = G__5164__delegate;
    return G__5164
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5168__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5169 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5170 = cljs.core.next.call(null, more);
            sb = G__5169;
            more = G__5170;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5168 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5168__delegate.call(this, x, ys)
    };
    G__5168.cljs$lang$maxFixedArity = 1;
    G__5168.cljs$lang$applyTo = function(arglist__5171) {
      var x = cljs.core.first(arglist__5171);
      var ys = cljs.core.rest(arglist__5171);
      return G__5168__delegate(x, ys)
    };
    G__5168.cljs$lang$arity$variadic = G__5168__delegate;
    return G__5168
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5172 = cljs.core.seq.call(null, x);
    var ys__5173 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5172 == null) {
        return ys__5173 == null
      }else {
        if(ys__5173 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5172), cljs.core.first.call(null, ys__5173))) {
            var G__5174 = cljs.core.next.call(null, xs__5172);
            var G__5175 = cljs.core.next.call(null, ys__5173);
            xs__5172 = G__5174;
            ys__5173 = G__5175;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5176_SHARP_, p2__5177_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5176_SHARP_, cljs.core.hash.call(null, p2__5177_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5178 = 0;
  var s__5179 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5179)) {
      var e__5180 = cljs.core.first.call(null, s__5179);
      var G__5181 = (h__5178 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5180)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5180)))) % 4503599627370496;
      var G__5182 = cljs.core.next.call(null, s__5179);
      h__5178 = G__5181;
      s__5179 = G__5182;
      continue
    }else {
      return h__5178
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5183 = 0;
  var s__5184 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5184)) {
      var e__5185 = cljs.core.first.call(null, s__5184);
      var G__5186 = (h__5183 + cljs.core.hash.call(null, e__5185)) % 4503599627370496;
      var G__5187 = cljs.core.next.call(null, s__5184);
      h__5183 = G__5186;
      s__5184 = G__5187;
      continue
    }else {
      return h__5183
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5188__5189 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5188__5189)) {
    var G__5191__5193 = cljs.core.first.call(null, G__5188__5189);
    var vec__5192__5194 = G__5191__5193;
    var key_name__5195 = cljs.core.nth.call(null, vec__5192__5194, 0, null);
    var f__5196 = cljs.core.nth.call(null, vec__5192__5194, 1, null);
    var G__5188__5197 = G__5188__5189;
    var G__5191__5198 = G__5191__5193;
    var G__5188__5199 = G__5188__5197;
    while(true) {
      var vec__5200__5201 = G__5191__5198;
      var key_name__5202 = cljs.core.nth.call(null, vec__5200__5201, 0, null);
      var f__5203 = cljs.core.nth.call(null, vec__5200__5201, 1, null);
      var G__5188__5204 = G__5188__5199;
      var str_name__5205 = cljs.core.name.call(null, key_name__5202);
      obj[str_name__5205] = f__5203;
      var temp__3698__auto____5206 = cljs.core.next.call(null, G__5188__5204);
      if(cljs.core.truth_(temp__3698__auto____5206)) {
        var G__5188__5207 = temp__3698__auto____5206;
        var G__5208 = cljs.core.first.call(null, G__5188__5207);
        var G__5209 = G__5188__5207;
        G__5191__5198 = G__5208;
        G__5188__5199 = G__5209;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5210 = this;
  var h__364__auto____5211 = this__5210.__hash;
  if(h__364__auto____5211 != null) {
    return h__364__auto____5211
  }else {
    var h__364__auto____5212 = cljs.core.hash_coll.call(null, coll);
    this__5210.__hash = h__364__auto____5212;
    return h__364__auto____5212
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5213 = this;
  return new cljs.core.List(this__5213.meta, o, coll, this__5213.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5214 = this;
  var this$__5215 = this;
  return cljs.core.pr_str.call(null, this$__5215)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5216 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5217 = this;
  return this__5217.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5218 = this;
  return this__5218.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5219 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5220 = this;
  return this__5220.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5221 = this;
  return this__5221.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5222 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5223 = this;
  return new cljs.core.List(meta, this__5223.first, this__5223.rest, this__5223.count, this__5223.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5224 = this;
  return this__5224.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5225 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5226 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5227 = this;
  return new cljs.core.List(this__5227.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5228 = this;
  var this$__5229 = this;
  return cljs.core.pr_str.call(null, this$__5229)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5230 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5231 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5232 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5233 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5234 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5235 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5236 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5237 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5238 = this;
  return this__5238.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5239 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5240__5241 = coll;
  if(G__5240__5241 != null) {
    if(function() {
      var or__3548__auto____5242 = G__5240__5241.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5242) {
        return or__3548__auto____5242
      }else {
        return G__5240__5241.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5240__5241.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5240__5241)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5240__5241)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5243) {
    var items = cljs.core.seq(arglist__5243);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5244 = this;
  var h__364__auto____5245 = this__5244.__hash;
  if(h__364__auto____5245 != null) {
    return h__364__auto____5245
  }else {
    var h__364__auto____5246 = cljs.core.hash_coll.call(null, coll);
    this__5244.__hash = h__364__auto____5246;
    return h__364__auto____5246
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5247 = this;
  return new cljs.core.Cons(null, o, coll, this__5247.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5248 = this;
  var this$__5249 = this;
  return cljs.core.pr_str.call(null, this$__5249)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5250 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5251 = this;
  return this__5251.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5252 = this;
  if(this__5252.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5252.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5253 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5254 = this;
  return new cljs.core.Cons(meta, this__5254.first, this__5254.rest, this__5254.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5255 = this;
  return this__5255.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5256 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5256.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5257 = coll == null;
    if(or__3548__auto____5257) {
      return or__3548__auto____5257
    }else {
      var G__5258__5259 = coll;
      if(G__5258__5259 != null) {
        if(function() {
          var or__3548__auto____5260 = G__5258__5259.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5260) {
            return or__3548__auto____5260
          }else {
            return G__5258__5259.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5258__5259.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5258__5259)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5258__5259)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5261__5262 = x;
  if(G__5261__5262 != null) {
    if(function() {
      var or__3548__auto____5263 = G__5261__5262.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5263) {
        return or__3548__auto____5263
      }else {
        return G__5261__5262.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5261__5262.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5261__5262)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5261__5262)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5264 = null;
  var G__5264__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5264__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5264 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5264__2.call(this, string, f);
      case 3:
        return G__5264__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5264
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5265 = null;
  var G__5265__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5265__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5265 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5265__2.call(this, string, k);
      case 3:
        return G__5265__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5265
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5266 = null;
  var G__5266__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5266__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5266 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5266__2.call(this, string, n);
      case 3:
        return G__5266__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5266
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5275 = null;
  var G__5275__2 = function(tsym5269, coll) {
    var tsym5269__5271 = this;
    var this$__5272 = tsym5269__5271;
    return cljs.core.get.call(null, coll, this$__5272.toString())
  };
  var G__5275__3 = function(tsym5270, coll, not_found) {
    var tsym5270__5273 = this;
    var this$__5274 = tsym5270__5273;
    return cljs.core.get.call(null, coll, this$__5274.toString(), not_found)
  };
  G__5275 = function(tsym5270, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5275__2.call(this, tsym5270, coll);
      case 3:
        return G__5275__3.call(this, tsym5270, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5275
}();
String.prototype.apply = function(tsym5267, args5268) {
  return tsym5267.call.apply(tsym5267, [tsym5267].concat(cljs.core.aclone.call(null, args5268)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5276 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5276
  }else {
    lazy_seq.x = x__5276.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5277 = this;
  var h__364__auto____5278 = this__5277.__hash;
  if(h__364__auto____5278 != null) {
    return h__364__auto____5278
  }else {
    var h__364__auto____5279 = cljs.core.hash_coll.call(null, coll);
    this__5277.__hash = h__364__auto____5279;
    return h__364__auto____5279
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5280 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5281 = this;
  var this$__5282 = this;
  return cljs.core.pr_str.call(null, this$__5282)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5283 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5284 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5285 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5286 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5287 = this;
  return new cljs.core.LazySeq(meta, this__5287.realized, this__5287.x, this__5287.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5288 = this;
  return this__5288.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5289 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5289.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5290 = [];
  var s__5291 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5291))) {
      ary__5290.push(cljs.core.first.call(null, s__5291));
      var G__5292 = cljs.core.next.call(null, s__5291);
      s__5291 = G__5292;
      continue
    }else {
      return ary__5290
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5293 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5294 = 0;
  var xs__5295 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5295)) {
      ret__5293[i__5294] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5295));
      var G__5296 = i__5294 + 1;
      var G__5297 = cljs.core.next.call(null, xs__5295);
      i__5294 = G__5296;
      xs__5295 = G__5297;
      continue
    }else {
    }
    break
  }
  return ret__5293
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5298 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5299 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5300 = 0;
      var s__5301 = s__5299;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5302 = s__5301;
          if(cljs.core.truth_(and__3546__auto____5302)) {
            return i__5300 < size
          }else {
            return and__3546__auto____5302
          }
        }())) {
          a__5298[i__5300] = cljs.core.first.call(null, s__5301);
          var G__5305 = i__5300 + 1;
          var G__5306 = cljs.core.next.call(null, s__5301);
          i__5300 = G__5305;
          s__5301 = G__5306;
          continue
        }else {
          return a__5298
        }
        break
      }
    }else {
      var n__685__auto____5303 = size;
      var i__5304 = 0;
      while(true) {
        if(i__5304 < n__685__auto____5303) {
          a__5298[i__5304] = init_val_or_seq;
          var G__5307 = i__5304 + 1;
          i__5304 = G__5307;
          continue
        }else {
        }
        break
      }
      return a__5298
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5308 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5309 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5310 = 0;
      var s__5311 = s__5309;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5312 = s__5311;
          if(cljs.core.truth_(and__3546__auto____5312)) {
            return i__5310 < size
          }else {
            return and__3546__auto____5312
          }
        }())) {
          a__5308[i__5310] = cljs.core.first.call(null, s__5311);
          var G__5315 = i__5310 + 1;
          var G__5316 = cljs.core.next.call(null, s__5311);
          i__5310 = G__5315;
          s__5311 = G__5316;
          continue
        }else {
          return a__5308
        }
        break
      }
    }else {
      var n__685__auto____5313 = size;
      var i__5314 = 0;
      while(true) {
        if(i__5314 < n__685__auto____5313) {
          a__5308[i__5314] = init_val_or_seq;
          var G__5317 = i__5314 + 1;
          i__5314 = G__5317;
          continue
        }else {
        }
        break
      }
      return a__5308
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5318 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5319 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5320 = 0;
      var s__5321 = s__5319;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5322 = s__5321;
          if(cljs.core.truth_(and__3546__auto____5322)) {
            return i__5320 < size
          }else {
            return and__3546__auto____5322
          }
        }())) {
          a__5318[i__5320] = cljs.core.first.call(null, s__5321);
          var G__5325 = i__5320 + 1;
          var G__5326 = cljs.core.next.call(null, s__5321);
          i__5320 = G__5325;
          s__5321 = G__5326;
          continue
        }else {
          return a__5318
        }
        break
      }
    }else {
      var n__685__auto____5323 = size;
      var i__5324 = 0;
      while(true) {
        if(i__5324 < n__685__auto____5323) {
          a__5318[i__5324] = init_val_or_seq;
          var G__5327 = i__5324 + 1;
          i__5324 = G__5327;
          continue
        }else {
        }
        break
      }
      return a__5318
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5328 = s;
    var i__5329 = n;
    var sum__5330 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5331 = i__5329 > 0;
        if(and__3546__auto____5331) {
          return cljs.core.seq.call(null, s__5328)
        }else {
          return and__3546__auto____5331
        }
      }())) {
        var G__5332 = cljs.core.next.call(null, s__5328);
        var G__5333 = i__5329 - 1;
        var G__5334 = sum__5330 + 1;
        s__5328 = G__5332;
        i__5329 = G__5333;
        sum__5330 = G__5334;
        continue
      }else {
        return sum__5330
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5335 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5335)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5335), concat.call(null, cljs.core.rest.call(null, s__5335), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5338__delegate = function(x, y, zs) {
      var cat__5337 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5336 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5336)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5336), cat.call(null, cljs.core.rest.call(null, xys__5336), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5337.call(null, concat.call(null, x, y), zs)
    };
    var G__5338 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5338__delegate.call(this, x, y, zs)
    };
    G__5338.cljs$lang$maxFixedArity = 2;
    G__5338.cljs$lang$applyTo = function(arglist__5339) {
      var x = cljs.core.first(arglist__5339);
      var y = cljs.core.first(cljs.core.next(arglist__5339));
      var zs = cljs.core.rest(cljs.core.next(arglist__5339));
      return G__5338__delegate(x, y, zs)
    };
    G__5338.cljs$lang$arity$variadic = G__5338__delegate;
    return G__5338
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5340__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5340 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5340__delegate.call(this, a, b, c, d, more)
    };
    G__5340.cljs$lang$maxFixedArity = 4;
    G__5340.cljs$lang$applyTo = function(arglist__5341) {
      var a = cljs.core.first(arglist__5341);
      var b = cljs.core.first(cljs.core.next(arglist__5341));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5341)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5341))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5341))));
      return G__5340__delegate(a, b, c, d, more)
    };
    G__5340.cljs$lang$arity$variadic = G__5340__delegate;
    return G__5340
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5342 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5343 = cljs.core._first.call(null, args__5342);
    var args__5344 = cljs.core._rest.call(null, args__5342);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5343)
      }else {
        return f.call(null, a__5343)
      }
    }else {
      var b__5345 = cljs.core._first.call(null, args__5344);
      var args__5346 = cljs.core._rest.call(null, args__5344);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5343, b__5345)
        }else {
          return f.call(null, a__5343, b__5345)
        }
      }else {
        var c__5347 = cljs.core._first.call(null, args__5346);
        var args__5348 = cljs.core._rest.call(null, args__5346);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5343, b__5345, c__5347)
          }else {
            return f.call(null, a__5343, b__5345, c__5347)
          }
        }else {
          var d__5349 = cljs.core._first.call(null, args__5348);
          var args__5350 = cljs.core._rest.call(null, args__5348);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5343, b__5345, c__5347, d__5349)
            }else {
              return f.call(null, a__5343, b__5345, c__5347, d__5349)
            }
          }else {
            var e__5351 = cljs.core._first.call(null, args__5350);
            var args__5352 = cljs.core._rest.call(null, args__5350);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5343, b__5345, c__5347, d__5349, e__5351)
              }else {
                return f.call(null, a__5343, b__5345, c__5347, d__5349, e__5351)
              }
            }else {
              var f__5353 = cljs.core._first.call(null, args__5352);
              var args__5354 = cljs.core._rest.call(null, args__5352);
              if(argc === 6) {
                if(f__5353.cljs$lang$arity$6) {
                  return f__5353.cljs$lang$arity$6(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353)
                }else {
                  return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353)
                }
              }else {
                var g__5355 = cljs.core._first.call(null, args__5354);
                var args__5356 = cljs.core._rest.call(null, args__5354);
                if(argc === 7) {
                  if(f__5353.cljs$lang$arity$7) {
                    return f__5353.cljs$lang$arity$7(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355)
                  }else {
                    return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355)
                  }
                }else {
                  var h__5357 = cljs.core._first.call(null, args__5356);
                  var args__5358 = cljs.core._rest.call(null, args__5356);
                  if(argc === 8) {
                    if(f__5353.cljs$lang$arity$8) {
                      return f__5353.cljs$lang$arity$8(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357)
                    }else {
                      return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357)
                    }
                  }else {
                    var i__5359 = cljs.core._first.call(null, args__5358);
                    var args__5360 = cljs.core._rest.call(null, args__5358);
                    if(argc === 9) {
                      if(f__5353.cljs$lang$arity$9) {
                        return f__5353.cljs$lang$arity$9(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359)
                      }else {
                        return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359)
                      }
                    }else {
                      var j__5361 = cljs.core._first.call(null, args__5360);
                      var args__5362 = cljs.core._rest.call(null, args__5360);
                      if(argc === 10) {
                        if(f__5353.cljs$lang$arity$10) {
                          return f__5353.cljs$lang$arity$10(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361)
                        }else {
                          return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361)
                        }
                      }else {
                        var k__5363 = cljs.core._first.call(null, args__5362);
                        var args__5364 = cljs.core._rest.call(null, args__5362);
                        if(argc === 11) {
                          if(f__5353.cljs$lang$arity$11) {
                            return f__5353.cljs$lang$arity$11(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363)
                          }else {
                            return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363)
                          }
                        }else {
                          var l__5365 = cljs.core._first.call(null, args__5364);
                          var args__5366 = cljs.core._rest.call(null, args__5364);
                          if(argc === 12) {
                            if(f__5353.cljs$lang$arity$12) {
                              return f__5353.cljs$lang$arity$12(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365)
                            }else {
                              return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365)
                            }
                          }else {
                            var m__5367 = cljs.core._first.call(null, args__5366);
                            var args__5368 = cljs.core._rest.call(null, args__5366);
                            if(argc === 13) {
                              if(f__5353.cljs$lang$arity$13) {
                                return f__5353.cljs$lang$arity$13(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367)
                              }else {
                                return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367)
                              }
                            }else {
                              var n__5369 = cljs.core._first.call(null, args__5368);
                              var args__5370 = cljs.core._rest.call(null, args__5368);
                              if(argc === 14) {
                                if(f__5353.cljs$lang$arity$14) {
                                  return f__5353.cljs$lang$arity$14(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369)
                                }else {
                                  return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369)
                                }
                              }else {
                                var o__5371 = cljs.core._first.call(null, args__5370);
                                var args__5372 = cljs.core._rest.call(null, args__5370);
                                if(argc === 15) {
                                  if(f__5353.cljs$lang$arity$15) {
                                    return f__5353.cljs$lang$arity$15(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371)
                                  }else {
                                    return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371)
                                  }
                                }else {
                                  var p__5373 = cljs.core._first.call(null, args__5372);
                                  var args__5374 = cljs.core._rest.call(null, args__5372);
                                  if(argc === 16) {
                                    if(f__5353.cljs$lang$arity$16) {
                                      return f__5353.cljs$lang$arity$16(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373)
                                    }else {
                                      return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373)
                                    }
                                  }else {
                                    var q__5375 = cljs.core._first.call(null, args__5374);
                                    var args__5376 = cljs.core._rest.call(null, args__5374);
                                    if(argc === 17) {
                                      if(f__5353.cljs$lang$arity$17) {
                                        return f__5353.cljs$lang$arity$17(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375)
                                      }else {
                                        return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375)
                                      }
                                    }else {
                                      var r__5377 = cljs.core._first.call(null, args__5376);
                                      var args__5378 = cljs.core._rest.call(null, args__5376);
                                      if(argc === 18) {
                                        if(f__5353.cljs$lang$arity$18) {
                                          return f__5353.cljs$lang$arity$18(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375, r__5377)
                                        }else {
                                          return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375, r__5377)
                                        }
                                      }else {
                                        var s__5379 = cljs.core._first.call(null, args__5378);
                                        var args__5380 = cljs.core._rest.call(null, args__5378);
                                        if(argc === 19) {
                                          if(f__5353.cljs$lang$arity$19) {
                                            return f__5353.cljs$lang$arity$19(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375, r__5377, s__5379)
                                          }else {
                                            return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375, r__5377, s__5379)
                                          }
                                        }else {
                                          var t__5381 = cljs.core._first.call(null, args__5380);
                                          var args__5382 = cljs.core._rest.call(null, args__5380);
                                          if(argc === 20) {
                                            if(f__5353.cljs$lang$arity$20) {
                                              return f__5353.cljs$lang$arity$20(a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375, r__5377, s__5379, t__5381)
                                            }else {
                                              return f__5353.call(null, a__5343, b__5345, c__5347, d__5349, e__5351, f__5353, g__5355, h__5357, i__5359, j__5361, k__5363, l__5365, m__5367, n__5369, o__5371, p__5373, q__5375, r__5377, s__5379, t__5381)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5383 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5384 = cljs.core.bounded_count.call(null, args, fixed_arity__5383 + 1);
      if(bc__5384 <= fixed_arity__5383) {
        return cljs.core.apply_to.call(null, f, bc__5384, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5385 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5386 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5387 = cljs.core.bounded_count.call(null, arglist__5385, fixed_arity__5386 + 1);
      if(bc__5387 <= fixed_arity__5386) {
        return cljs.core.apply_to.call(null, f, bc__5387, arglist__5385)
      }else {
        return f.cljs$lang$applyTo(arglist__5385)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5385))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5388 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5389 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5390 = cljs.core.bounded_count.call(null, arglist__5388, fixed_arity__5389 + 1);
      if(bc__5390 <= fixed_arity__5389) {
        return cljs.core.apply_to.call(null, f, bc__5390, arglist__5388)
      }else {
        return f.cljs$lang$applyTo(arglist__5388)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5388))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5391 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5392 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5393 = cljs.core.bounded_count.call(null, arglist__5391, fixed_arity__5392 + 1);
      if(bc__5393 <= fixed_arity__5392) {
        return cljs.core.apply_to.call(null, f, bc__5393, arglist__5391)
      }else {
        return f.cljs$lang$applyTo(arglist__5391)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5391))
    }
  };
  var apply__6 = function() {
    var G__5397__delegate = function(f, a, b, c, d, args) {
      var arglist__5394 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5395 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5396 = cljs.core.bounded_count.call(null, arglist__5394, fixed_arity__5395 + 1);
        if(bc__5396 <= fixed_arity__5395) {
          return cljs.core.apply_to.call(null, f, bc__5396, arglist__5394)
        }else {
          return f.cljs$lang$applyTo(arglist__5394)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5394))
      }
    };
    var G__5397 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5397__delegate.call(this, f, a, b, c, d, args)
    };
    G__5397.cljs$lang$maxFixedArity = 5;
    G__5397.cljs$lang$applyTo = function(arglist__5398) {
      var f = cljs.core.first(arglist__5398);
      var a = cljs.core.first(cljs.core.next(arglist__5398));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5398)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5398))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5398)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5398)))));
      return G__5397__delegate(f, a, b, c, d, args)
    };
    G__5397.cljs$lang$arity$variadic = G__5397__delegate;
    return G__5397
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5399) {
    var obj = cljs.core.first(arglist__5399);
    var f = cljs.core.first(cljs.core.next(arglist__5399));
    var args = cljs.core.rest(cljs.core.next(arglist__5399));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5400__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5400 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5400__delegate.call(this, x, y, more)
    };
    G__5400.cljs$lang$maxFixedArity = 2;
    G__5400.cljs$lang$applyTo = function(arglist__5401) {
      var x = cljs.core.first(arglist__5401);
      var y = cljs.core.first(cljs.core.next(arglist__5401));
      var more = cljs.core.rest(cljs.core.next(arglist__5401));
      return G__5400__delegate(x, y, more)
    };
    G__5400.cljs$lang$arity$variadic = G__5400__delegate;
    return G__5400
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5402 = pred;
        var G__5403 = cljs.core.next.call(null, coll);
        pred = G__5402;
        coll = G__5403;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5404 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5404)) {
        return or__3548__auto____5404
      }else {
        var G__5405 = pred;
        var G__5406 = cljs.core.next.call(null, coll);
        pred = G__5405;
        coll = G__5406;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5407 = null;
    var G__5407__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5407__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5407__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5407__3 = function() {
      var G__5408__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5408 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5408__delegate.call(this, x, y, zs)
      };
      G__5408.cljs$lang$maxFixedArity = 2;
      G__5408.cljs$lang$applyTo = function(arglist__5409) {
        var x = cljs.core.first(arglist__5409);
        var y = cljs.core.first(cljs.core.next(arglist__5409));
        var zs = cljs.core.rest(cljs.core.next(arglist__5409));
        return G__5408__delegate(x, y, zs)
      };
      G__5408.cljs$lang$arity$variadic = G__5408__delegate;
      return G__5408
    }();
    G__5407 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5407__0.call(this);
        case 1:
          return G__5407__1.call(this, x);
        case 2:
          return G__5407__2.call(this, x, y);
        default:
          return G__5407__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5407.cljs$lang$maxFixedArity = 2;
    G__5407.cljs$lang$applyTo = G__5407__3.cljs$lang$applyTo;
    return G__5407
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5410__delegate = function(args) {
      return x
    };
    var G__5410 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5410__delegate.call(this, args)
    };
    G__5410.cljs$lang$maxFixedArity = 0;
    G__5410.cljs$lang$applyTo = function(arglist__5411) {
      var args = cljs.core.seq(arglist__5411);
      return G__5410__delegate(args)
    };
    G__5410.cljs$lang$arity$variadic = G__5410__delegate;
    return G__5410
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5415 = null;
      var G__5415__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5415__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5415__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5415__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5415__4 = function() {
        var G__5416__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5416 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5416__delegate.call(this, x, y, z, args)
        };
        G__5416.cljs$lang$maxFixedArity = 3;
        G__5416.cljs$lang$applyTo = function(arglist__5417) {
          var x = cljs.core.first(arglist__5417);
          var y = cljs.core.first(cljs.core.next(arglist__5417));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5417)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5417)));
          return G__5416__delegate(x, y, z, args)
        };
        G__5416.cljs$lang$arity$variadic = G__5416__delegate;
        return G__5416
      }();
      G__5415 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5415__0.call(this);
          case 1:
            return G__5415__1.call(this, x);
          case 2:
            return G__5415__2.call(this, x, y);
          case 3:
            return G__5415__3.call(this, x, y, z);
          default:
            return G__5415__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5415.cljs$lang$maxFixedArity = 3;
      G__5415.cljs$lang$applyTo = G__5415__4.cljs$lang$applyTo;
      return G__5415
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5418 = null;
      var G__5418__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5418__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5418__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5418__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5418__4 = function() {
        var G__5419__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5419 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5419__delegate.call(this, x, y, z, args)
        };
        G__5419.cljs$lang$maxFixedArity = 3;
        G__5419.cljs$lang$applyTo = function(arglist__5420) {
          var x = cljs.core.first(arglist__5420);
          var y = cljs.core.first(cljs.core.next(arglist__5420));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5420)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5420)));
          return G__5419__delegate(x, y, z, args)
        };
        G__5419.cljs$lang$arity$variadic = G__5419__delegate;
        return G__5419
      }();
      G__5418 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5418__0.call(this);
          case 1:
            return G__5418__1.call(this, x);
          case 2:
            return G__5418__2.call(this, x, y);
          case 3:
            return G__5418__3.call(this, x, y, z);
          default:
            return G__5418__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5418.cljs$lang$maxFixedArity = 3;
      G__5418.cljs$lang$applyTo = G__5418__4.cljs$lang$applyTo;
      return G__5418
    }()
  };
  var comp__4 = function() {
    var G__5421__delegate = function(f1, f2, f3, fs) {
      var fs__5412 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5422__delegate = function(args) {
          var ret__5413 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5412), args);
          var fs__5414 = cljs.core.next.call(null, fs__5412);
          while(true) {
            if(cljs.core.truth_(fs__5414)) {
              var G__5423 = cljs.core.first.call(null, fs__5414).call(null, ret__5413);
              var G__5424 = cljs.core.next.call(null, fs__5414);
              ret__5413 = G__5423;
              fs__5414 = G__5424;
              continue
            }else {
              return ret__5413
            }
            break
          }
        };
        var G__5422 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5422__delegate.call(this, args)
        };
        G__5422.cljs$lang$maxFixedArity = 0;
        G__5422.cljs$lang$applyTo = function(arglist__5425) {
          var args = cljs.core.seq(arglist__5425);
          return G__5422__delegate(args)
        };
        G__5422.cljs$lang$arity$variadic = G__5422__delegate;
        return G__5422
      }()
    };
    var G__5421 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5421__delegate.call(this, f1, f2, f3, fs)
    };
    G__5421.cljs$lang$maxFixedArity = 3;
    G__5421.cljs$lang$applyTo = function(arglist__5426) {
      var f1 = cljs.core.first(arglist__5426);
      var f2 = cljs.core.first(cljs.core.next(arglist__5426));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5426)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5426)));
      return G__5421__delegate(f1, f2, f3, fs)
    };
    G__5421.cljs$lang$arity$variadic = G__5421__delegate;
    return G__5421
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5427__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5427 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5427__delegate.call(this, args)
      };
      G__5427.cljs$lang$maxFixedArity = 0;
      G__5427.cljs$lang$applyTo = function(arglist__5428) {
        var args = cljs.core.seq(arglist__5428);
        return G__5427__delegate(args)
      };
      G__5427.cljs$lang$arity$variadic = G__5427__delegate;
      return G__5427
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5429__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5429 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5429__delegate.call(this, args)
      };
      G__5429.cljs$lang$maxFixedArity = 0;
      G__5429.cljs$lang$applyTo = function(arglist__5430) {
        var args = cljs.core.seq(arglist__5430);
        return G__5429__delegate(args)
      };
      G__5429.cljs$lang$arity$variadic = G__5429__delegate;
      return G__5429
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5431__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5431 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5431__delegate.call(this, args)
      };
      G__5431.cljs$lang$maxFixedArity = 0;
      G__5431.cljs$lang$applyTo = function(arglist__5432) {
        var args = cljs.core.seq(arglist__5432);
        return G__5431__delegate(args)
      };
      G__5431.cljs$lang$arity$variadic = G__5431__delegate;
      return G__5431
    }()
  };
  var partial__5 = function() {
    var G__5433__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5434__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5434 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5434__delegate.call(this, args)
        };
        G__5434.cljs$lang$maxFixedArity = 0;
        G__5434.cljs$lang$applyTo = function(arglist__5435) {
          var args = cljs.core.seq(arglist__5435);
          return G__5434__delegate(args)
        };
        G__5434.cljs$lang$arity$variadic = G__5434__delegate;
        return G__5434
      }()
    };
    var G__5433 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5433__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5433.cljs$lang$maxFixedArity = 4;
    G__5433.cljs$lang$applyTo = function(arglist__5436) {
      var f = cljs.core.first(arglist__5436);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5436));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5436)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5436))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5436))));
      return G__5433__delegate(f, arg1, arg2, arg3, more)
    };
    G__5433.cljs$lang$arity$variadic = G__5433__delegate;
    return G__5433
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5437 = null;
      var G__5437__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5437__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5437__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5437__4 = function() {
        var G__5438__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5438 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5438__delegate.call(this, a, b, c, ds)
        };
        G__5438.cljs$lang$maxFixedArity = 3;
        G__5438.cljs$lang$applyTo = function(arglist__5439) {
          var a = cljs.core.first(arglist__5439);
          var b = cljs.core.first(cljs.core.next(arglist__5439));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5439)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5439)));
          return G__5438__delegate(a, b, c, ds)
        };
        G__5438.cljs$lang$arity$variadic = G__5438__delegate;
        return G__5438
      }();
      G__5437 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5437__1.call(this, a);
          case 2:
            return G__5437__2.call(this, a, b);
          case 3:
            return G__5437__3.call(this, a, b, c);
          default:
            return G__5437__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5437.cljs$lang$maxFixedArity = 3;
      G__5437.cljs$lang$applyTo = G__5437__4.cljs$lang$applyTo;
      return G__5437
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5440 = null;
      var G__5440__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5440__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5440__4 = function() {
        var G__5441__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5441 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5441__delegate.call(this, a, b, c, ds)
        };
        G__5441.cljs$lang$maxFixedArity = 3;
        G__5441.cljs$lang$applyTo = function(arglist__5442) {
          var a = cljs.core.first(arglist__5442);
          var b = cljs.core.first(cljs.core.next(arglist__5442));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5442)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5442)));
          return G__5441__delegate(a, b, c, ds)
        };
        G__5441.cljs$lang$arity$variadic = G__5441__delegate;
        return G__5441
      }();
      G__5440 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5440__2.call(this, a, b);
          case 3:
            return G__5440__3.call(this, a, b, c);
          default:
            return G__5440__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5440.cljs$lang$maxFixedArity = 3;
      G__5440.cljs$lang$applyTo = G__5440__4.cljs$lang$applyTo;
      return G__5440
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5443 = null;
      var G__5443__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5443__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5443__4 = function() {
        var G__5444__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5444 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5444__delegate.call(this, a, b, c, ds)
        };
        G__5444.cljs$lang$maxFixedArity = 3;
        G__5444.cljs$lang$applyTo = function(arglist__5445) {
          var a = cljs.core.first(arglist__5445);
          var b = cljs.core.first(cljs.core.next(arglist__5445));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5445)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5445)));
          return G__5444__delegate(a, b, c, ds)
        };
        G__5444.cljs$lang$arity$variadic = G__5444__delegate;
        return G__5444
      }();
      G__5443 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5443__2.call(this, a, b);
          case 3:
            return G__5443__3.call(this, a, b, c);
          default:
            return G__5443__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5443.cljs$lang$maxFixedArity = 3;
      G__5443.cljs$lang$applyTo = G__5443__4.cljs$lang$applyTo;
      return G__5443
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5448 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5446 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5446)) {
        var s__5447 = temp__3698__auto____5446;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5447)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5447)))
      }else {
        return null
      }
    })
  };
  return mapi__5448.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5449 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5449)) {
      var s__5450 = temp__3698__auto____5449;
      var x__5451 = f.call(null, cljs.core.first.call(null, s__5450));
      if(x__5451 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5450))
      }else {
        return cljs.core.cons.call(null, x__5451, keep.call(null, f, cljs.core.rest.call(null, s__5450)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5461 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5458 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5458)) {
        var s__5459 = temp__3698__auto____5458;
        var x__5460 = f.call(null, idx, cljs.core.first.call(null, s__5459));
        if(x__5460 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5459))
        }else {
          return cljs.core.cons.call(null, x__5460, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5459)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5461.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5468 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5468)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5468
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5469 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5469)) {
            var and__3546__auto____5470 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5470)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5470
            }
          }else {
            return and__3546__auto____5469
          }
        }())
      };
      var ep1__4 = function() {
        var G__5506__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5471 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5471)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5471
            }
          }())
        };
        var G__5506 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5506__delegate.call(this, x, y, z, args)
        };
        G__5506.cljs$lang$maxFixedArity = 3;
        G__5506.cljs$lang$applyTo = function(arglist__5507) {
          var x = cljs.core.first(arglist__5507);
          var y = cljs.core.first(cljs.core.next(arglist__5507));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5507)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5507)));
          return G__5506__delegate(x, y, z, args)
        };
        G__5506.cljs$lang$arity$variadic = G__5506__delegate;
        return G__5506
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5472 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5472)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5472
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5473 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5473)) {
            var and__3546__auto____5474 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5474)) {
              var and__3546__auto____5475 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5475)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5475
              }
            }else {
              return and__3546__auto____5474
            }
          }else {
            return and__3546__auto____5473
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5476 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5476)) {
            var and__3546__auto____5477 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5477)) {
              var and__3546__auto____5478 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5478)) {
                var and__3546__auto____5479 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5479)) {
                  var and__3546__auto____5480 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5480)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5480
                  }
                }else {
                  return and__3546__auto____5479
                }
              }else {
                return and__3546__auto____5478
              }
            }else {
              return and__3546__auto____5477
            }
          }else {
            return and__3546__auto____5476
          }
        }())
      };
      var ep2__4 = function() {
        var G__5508__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5481 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5481)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5452_SHARP_) {
                var and__3546__auto____5482 = p1.call(null, p1__5452_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5482)) {
                  return p2.call(null, p1__5452_SHARP_)
                }else {
                  return and__3546__auto____5482
                }
              }, args)
            }else {
              return and__3546__auto____5481
            }
          }())
        };
        var G__5508 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5508__delegate.call(this, x, y, z, args)
        };
        G__5508.cljs$lang$maxFixedArity = 3;
        G__5508.cljs$lang$applyTo = function(arglist__5509) {
          var x = cljs.core.first(arglist__5509);
          var y = cljs.core.first(cljs.core.next(arglist__5509));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5509)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5509)));
          return G__5508__delegate(x, y, z, args)
        };
        G__5508.cljs$lang$arity$variadic = G__5508__delegate;
        return G__5508
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5483 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5483)) {
            var and__3546__auto____5484 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5484)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5484
            }
          }else {
            return and__3546__auto____5483
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5485 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5485)) {
            var and__3546__auto____5486 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5486)) {
              var and__3546__auto____5487 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5487)) {
                var and__3546__auto____5488 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5488)) {
                  var and__3546__auto____5489 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5489)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5489
                  }
                }else {
                  return and__3546__auto____5488
                }
              }else {
                return and__3546__auto____5487
              }
            }else {
              return and__3546__auto____5486
            }
          }else {
            return and__3546__auto____5485
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5490 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5490)) {
            var and__3546__auto____5491 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5491)) {
              var and__3546__auto____5492 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5492)) {
                var and__3546__auto____5493 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5493)) {
                  var and__3546__auto____5494 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5494)) {
                    var and__3546__auto____5495 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5495)) {
                      var and__3546__auto____5496 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5496)) {
                        var and__3546__auto____5497 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5497)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5497
                        }
                      }else {
                        return and__3546__auto____5496
                      }
                    }else {
                      return and__3546__auto____5495
                    }
                  }else {
                    return and__3546__auto____5494
                  }
                }else {
                  return and__3546__auto____5493
                }
              }else {
                return and__3546__auto____5492
              }
            }else {
              return and__3546__auto____5491
            }
          }else {
            return and__3546__auto____5490
          }
        }())
      };
      var ep3__4 = function() {
        var G__5510__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5498 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5498)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5453_SHARP_) {
                var and__3546__auto____5499 = p1.call(null, p1__5453_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5499)) {
                  var and__3546__auto____5500 = p2.call(null, p1__5453_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5500)) {
                    return p3.call(null, p1__5453_SHARP_)
                  }else {
                    return and__3546__auto____5500
                  }
                }else {
                  return and__3546__auto____5499
                }
              }, args)
            }else {
              return and__3546__auto____5498
            }
          }())
        };
        var G__5510 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5510__delegate.call(this, x, y, z, args)
        };
        G__5510.cljs$lang$maxFixedArity = 3;
        G__5510.cljs$lang$applyTo = function(arglist__5511) {
          var x = cljs.core.first(arglist__5511);
          var y = cljs.core.first(cljs.core.next(arglist__5511));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5511)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5511)));
          return G__5510__delegate(x, y, z, args)
        };
        G__5510.cljs$lang$arity$variadic = G__5510__delegate;
        return G__5510
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5512__delegate = function(p1, p2, p3, ps) {
      var ps__5501 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5454_SHARP_) {
            return p1__5454_SHARP_.call(null, x)
          }, ps__5501)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5455_SHARP_) {
            var and__3546__auto____5502 = p1__5455_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5502)) {
              return p1__5455_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5502
            }
          }, ps__5501)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5456_SHARP_) {
            var and__3546__auto____5503 = p1__5456_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5503)) {
              var and__3546__auto____5504 = p1__5456_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5504)) {
                return p1__5456_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5504
              }
            }else {
              return and__3546__auto____5503
            }
          }, ps__5501)
        };
        var epn__4 = function() {
          var G__5513__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5505 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5505)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5457_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5457_SHARP_, args)
                }, ps__5501)
              }else {
                return and__3546__auto____5505
              }
            }())
          };
          var G__5513 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5513__delegate.call(this, x, y, z, args)
          };
          G__5513.cljs$lang$maxFixedArity = 3;
          G__5513.cljs$lang$applyTo = function(arglist__5514) {
            var x = cljs.core.first(arglist__5514);
            var y = cljs.core.first(cljs.core.next(arglist__5514));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5514)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5514)));
            return G__5513__delegate(x, y, z, args)
          };
          G__5513.cljs$lang$arity$variadic = G__5513__delegate;
          return G__5513
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5512 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5512__delegate.call(this, p1, p2, p3, ps)
    };
    G__5512.cljs$lang$maxFixedArity = 3;
    G__5512.cljs$lang$applyTo = function(arglist__5515) {
      var p1 = cljs.core.first(arglist__5515);
      var p2 = cljs.core.first(cljs.core.next(arglist__5515));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5515)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5515)));
      return G__5512__delegate(p1, p2, p3, ps)
    };
    G__5512.cljs$lang$arity$variadic = G__5512__delegate;
    return G__5512
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5517 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5517)) {
          return or__3548__auto____5517
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5518 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5518)) {
          return or__3548__auto____5518
        }else {
          var or__3548__auto____5519 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5519)) {
            return or__3548__auto____5519
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5555__delegate = function(x, y, z, args) {
          var or__3548__auto____5520 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5520)) {
            return or__3548__auto____5520
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5555 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5555__delegate.call(this, x, y, z, args)
        };
        G__5555.cljs$lang$maxFixedArity = 3;
        G__5555.cljs$lang$applyTo = function(arglist__5556) {
          var x = cljs.core.first(arglist__5556);
          var y = cljs.core.first(cljs.core.next(arglist__5556));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5556)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5556)));
          return G__5555__delegate(x, y, z, args)
        };
        G__5555.cljs$lang$arity$variadic = G__5555__delegate;
        return G__5555
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5521 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5521)) {
          return or__3548__auto____5521
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5522 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5522)) {
          return or__3548__auto____5522
        }else {
          var or__3548__auto____5523 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5523)) {
            return or__3548__auto____5523
          }else {
            var or__3548__auto____5524 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5524)) {
              return or__3548__auto____5524
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5525 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5525)) {
          return or__3548__auto____5525
        }else {
          var or__3548__auto____5526 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5526)) {
            return or__3548__auto____5526
          }else {
            var or__3548__auto____5527 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5527)) {
              return or__3548__auto____5527
            }else {
              var or__3548__auto____5528 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5528)) {
                return or__3548__auto____5528
              }else {
                var or__3548__auto____5529 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5529)) {
                  return or__3548__auto____5529
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5557__delegate = function(x, y, z, args) {
          var or__3548__auto____5530 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5530)) {
            return or__3548__auto____5530
          }else {
            return cljs.core.some.call(null, function(p1__5462_SHARP_) {
              var or__3548__auto____5531 = p1.call(null, p1__5462_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5531)) {
                return or__3548__auto____5531
              }else {
                return p2.call(null, p1__5462_SHARP_)
              }
            }, args)
          }
        };
        var G__5557 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5557__delegate.call(this, x, y, z, args)
        };
        G__5557.cljs$lang$maxFixedArity = 3;
        G__5557.cljs$lang$applyTo = function(arglist__5558) {
          var x = cljs.core.first(arglist__5558);
          var y = cljs.core.first(cljs.core.next(arglist__5558));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5558)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5558)));
          return G__5557__delegate(x, y, z, args)
        };
        G__5557.cljs$lang$arity$variadic = G__5557__delegate;
        return G__5557
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5532 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5532)) {
          return or__3548__auto____5532
        }else {
          var or__3548__auto____5533 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5533)) {
            return or__3548__auto____5533
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5534 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5534)) {
          return or__3548__auto____5534
        }else {
          var or__3548__auto____5535 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5535)) {
            return or__3548__auto____5535
          }else {
            var or__3548__auto____5536 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5536)) {
              return or__3548__auto____5536
            }else {
              var or__3548__auto____5537 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5537)) {
                return or__3548__auto____5537
              }else {
                var or__3548__auto____5538 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5538)) {
                  return or__3548__auto____5538
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5539 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5539)) {
          return or__3548__auto____5539
        }else {
          var or__3548__auto____5540 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5540)) {
            return or__3548__auto____5540
          }else {
            var or__3548__auto____5541 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5541)) {
              return or__3548__auto____5541
            }else {
              var or__3548__auto____5542 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5542)) {
                return or__3548__auto____5542
              }else {
                var or__3548__auto____5543 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5543)) {
                  return or__3548__auto____5543
                }else {
                  var or__3548__auto____5544 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5544)) {
                    return or__3548__auto____5544
                  }else {
                    var or__3548__auto____5545 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5545)) {
                      return or__3548__auto____5545
                    }else {
                      var or__3548__auto____5546 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5546)) {
                        return or__3548__auto____5546
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5559__delegate = function(x, y, z, args) {
          var or__3548__auto____5547 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5547)) {
            return or__3548__auto____5547
          }else {
            return cljs.core.some.call(null, function(p1__5463_SHARP_) {
              var or__3548__auto____5548 = p1.call(null, p1__5463_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5548)) {
                return or__3548__auto____5548
              }else {
                var or__3548__auto____5549 = p2.call(null, p1__5463_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5549)) {
                  return or__3548__auto____5549
                }else {
                  return p3.call(null, p1__5463_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5559 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5559__delegate.call(this, x, y, z, args)
        };
        G__5559.cljs$lang$maxFixedArity = 3;
        G__5559.cljs$lang$applyTo = function(arglist__5560) {
          var x = cljs.core.first(arglist__5560);
          var y = cljs.core.first(cljs.core.next(arglist__5560));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5560)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5560)));
          return G__5559__delegate(x, y, z, args)
        };
        G__5559.cljs$lang$arity$variadic = G__5559__delegate;
        return G__5559
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5561__delegate = function(p1, p2, p3, ps) {
      var ps__5550 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5464_SHARP_) {
            return p1__5464_SHARP_.call(null, x)
          }, ps__5550)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5465_SHARP_) {
            var or__3548__auto____5551 = p1__5465_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5551)) {
              return or__3548__auto____5551
            }else {
              return p1__5465_SHARP_.call(null, y)
            }
          }, ps__5550)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5466_SHARP_) {
            var or__3548__auto____5552 = p1__5466_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5552)) {
              return or__3548__auto____5552
            }else {
              var or__3548__auto____5553 = p1__5466_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5553)) {
                return or__3548__auto____5553
              }else {
                return p1__5466_SHARP_.call(null, z)
              }
            }
          }, ps__5550)
        };
        var spn__4 = function() {
          var G__5562__delegate = function(x, y, z, args) {
            var or__3548__auto____5554 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5554)) {
              return or__3548__auto____5554
            }else {
              return cljs.core.some.call(null, function(p1__5467_SHARP_) {
                return cljs.core.some.call(null, p1__5467_SHARP_, args)
              }, ps__5550)
            }
          };
          var G__5562 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5562__delegate.call(this, x, y, z, args)
          };
          G__5562.cljs$lang$maxFixedArity = 3;
          G__5562.cljs$lang$applyTo = function(arglist__5563) {
            var x = cljs.core.first(arglist__5563);
            var y = cljs.core.first(cljs.core.next(arglist__5563));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5563)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5563)));
            return G__5562__delegate(x, y, z, args)
          };
          G__5562.cljs$lang$arity$variadic = G__5562__delegate;
          return G__5562
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5561 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5561__delegate.call(this, p1, p2, p3, ps)
    };
    G__5561.cljs$lang$maxFixedArity = 3;
    G__5561.cljs$lang$applyTo = function(arglist__5564) {
      var p1 = cljs.core.first(arglist__5564);
      var p2 = cljs.core.first(cljs.core.next(arglist__5564));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5564)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5564)));
      return G__5561__delegate(p1, p2, p3, ps)
    };
    G__5561.cljs$lang$arity$variadic = G__5561__delegate;
    return G__5561
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5565 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5565)) {
        var s__5566 = temp__3698__auto____5565;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5566)), map.call(null, f, cljs.core.rest.call(null, s__5566)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5567 = cljs.core.seq.call(null, c1);
      var s2__5568 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5569 = s1__5567;
        if(cljs.core.truth_(and__3546__auto____5569)) {
          return s2__5568
        }else {
          return and__3546__auto____5569
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5567), cljs.core.first.call(null, s2__5568)), map.call(null, f, cljs.core.rest.call(null, s1__5567), cljs.core.rest.call(null, s2__5568)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5570 = cljs.core.seq.call(null, c1);
      var s2__5571 = cljs.core.seq.call(null, c2);
      var s3__5572 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5573 = s1__5570;
        if(cljs.core.truth_(and__3546__auto____5573)) {
          var and__3546__auto____5574 = s2__5571;
          if(cljs.core.truth_(and__3546__auto____5574)) {
            return s3__5572
          }else {
            return and__3546__auto____5574
          }
        }else {
          return and__3546__auto____5573
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5570), cljs.core.first.call(null, s2__5571), cljs.core.first.call(null, s3__5572)), map.call(null, f, cljs.core.rest.call(null, s1__5570), cljs.core.rest.call(null, s2__5571), cljs.core.rest.call(null, s3__5572)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5577__delegate = function(f, c1, c2, c3, colls) {
      var step__5576 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5575 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5575)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5575), step.call(null, map.call(null, cljs.core.rest, ss__5575)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5516_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5516_SHARP_)
      }, step__5576.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5577 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5577__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5577.cljs$lang$maxFixedArity = 4;
    G__5577.cljs$lang$applyTo = function(arglist__5578) {
      var f = cljs.core.first(arglist__5578);
      var c1 = cljs.core.first(cljs.core.next(arglist__5578));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5578)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5578))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5578))));
      return G__5577__delegate(f, c1, c2, c3, colls)
    };
    G__5577.cljs$lang$arity$variadic = G__5577__delegate;
    return G__5577
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5579 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5579)) {
        var s__5580 = temp__3698__auto____5579;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5580), take.call(null, n - 1, cljs.core.rest.call(null, s__5580)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5583 = function(n, coll) {
    while(true) {
      var s__5581 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5582 = n > 0;
        if(and__3546__auto____5582) {
          return s__5581
        }else {
          return and__3546__auto____5582
        }
      }())) {
        var G__5584 = n - 1;
        var G__5585 = cljs.core.rest.call(null, s__5581);
        n = G__5584;
        coll = G__5585;
        continue
      }else {
        return s__5581
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5583.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5586 = cljs.core.seq.call(null, coll);
  var lead__5587 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5587)) {
      var G__5588 = cljs.core.next.call(null, s__5586);
      var G__5589 = cljs.core.next.call(null, lead__5587);
      s__5586 = G__5588;
      lead__5587 = G__5589;
      continue
    }else {
      return s__5586
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5592 = function(pred, coll) {
    while(true) {
      var s__5590 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5591 = s__5590;
        if(cljs.core.truth_(and__3546__auto____5591)) {
          return pred.call(null, cljs.core.first.call(null, s__5590))
        }else {
          return and__3546__auto____5591
        }
      }())) {
        var G__5593 = pred;
        var G__5594 = cljs.core.rest.call(null, s__5590);
        pred = G__5593;
        coll = G__5594;
        continue
      }else {
        return s__5590
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5592.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5595 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5595)) {
      var s__5596 = temp__3698__auto____5595;
      return cljs.core.concat.call(null, s__5596, cycle.call(null, s__5596))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5597 = cljs.core.seq.call(null, c1);
      var s2__5598 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5599 = s1__5597;
        if(cljs.core.truth_(and__3546__auto____5599)) {
          return s2__5598
        }else {
          return and__3546__auto____5599
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5597), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5598), interleave.call(null, cljs.core.rest.call(null, s1__5597), cljs.core.rest.call(null, s2__5598))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5601__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5600 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5600)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5600), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5600)))
        }else {
          return null
        }
      })
    };
    var G__5601 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5601__delegate.call(this, c1, c2, colls)
    };
    G__5601.cljs$lang$maxFixedArity = 2;
    G__5601.cljs$lang$applyTo = function(arglist__5602) {
      var c1 = cljs.core.first(arglist__5602);
      var c2 = cljs.core.first(cljs.core.next(arglist__5602));
      var colls = cljs.core.rest(cljs.core.next(arglist__5602));
      return G__5601__delegate(c1, c2, colls)
    };
    G__5601.cljs$lang$arity$variadic = G__5601__delegate;
    return G__5601
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5605 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5603 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5603)) {
        var coll__5604 = temp__3695__auto____5603;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5604), cat.call(null, cljs.core.rest.call(null, coll__5604), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5605.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5606__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5606 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5606__delegate.call(this, f, coll, colls)
    };
    G__5606.cljs$lang$maxFixedArity = 2;
    G__5606.cljs$lang$applyTo = function(arglist__5607) {
      var f = cljs.core.first(arglist__5607);
      var coll = cljs.core.first(cljs.core.next(arglist__5607));
      var colls = cljs.core.rest(cljs.core.next(arglist__5607));
      return G__5606__delegate(f, coll, colls)
    };
    G__5606.cljs$lang$arity$variadic = G__5606__delegate;
    return G__5606
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5608 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5608)) {
      var s__5609 = temp__3698__auto____5608;
      var f__5610 = cljs.core.first.call(null, s__5609);
      var r__5611 = cljs.core.rest.call(null, s__5609);
      if(cljs.core.truth_(pred.call(null, f__5610))) {
        return cljs.core.cons.call(null, f__5610, filter.call(null, pred, r__5611))
      }else {
        return filter.call(null, pred, r__5611)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5613 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5613.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5612_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5612_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5614__5615 = to;
    if(G__5614__5615 != null) {
      if(function() {
        var or__3548__auto____5616 = G__5614__5615.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5616) {
          return or__3548__auto____5616
        }else {
          return G__5614__5615.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5614__5615.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5614__5615)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5614__5615)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5617__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5617 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5617__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5617.cljs$lang$maxFixedArity = 4;
    G__5617.cljs$lang$applyTo = function(arglist__5618) {
      var f = cljs.core.first(arglist__5618);
      var c1 = cljs.core.first(cljs.core.next(arglist__5618));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5618)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5618))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5618))));
      return G__5617__delegate(f, c1, c2, c3, colls)
    };
    G__5617.cljs$lang$arity$variadic = G__5617__delegate;
    return G__5617
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5619 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5619)) {
        var s__5620 = temp__3698__auto____5619;
        var p__5621 = cljs.core.take.call(null, n, s__5620);
        if(n === cljs.core.count.call(null, p__5621)) {
          return cljs.core.cons.call(null, p__5621, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5620)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5622 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5622)) {
        var s__5623 = temp__3698__auto____5622;
        var p__5624 = cljs.core.take.call(null, n, s__5623);
        if(n === cljs.core.count.call(null, p__5624)) {
          return cljs.core.cons.call(null, p__5624, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5623)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5624, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5625 = cljs.core.lookup_sentinel;
    var m__5626 = m;
    var ks__5627 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5627)) {
        var m__5628 = cljs.core.get.call(null, m__5626, cljs.core.first.call(null, ks__5627), sentinel__5625);
        if(sentinel__5625 === m__5628) {
          return not_found
        }else {
          var G__5629 = sentinel__5625;
          var G__5630 = m__5628;
          var G__5631 = cljs.core.next.call(null, ks__5627);
          sentinel__5625 = G__5629;
          m__5626 = G__5630;
          ks__5627 = G__5631;
          continue
        }
      }else {
        return m__5626
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5632, v) {
  var vec__5633__5634 = p__5632;
  var k__5635 = cljs.core.nth.call(null, vec__5633__5634, 0, null);
  var ks__5636 = cljs.core.nthnext.call(null, vec__5633__5634, 1);
  if(cljs.core.truth_(ks__5636)) {
    return cljs.core.assoc.call(null, m, k__5635, assoc_in.call(null, cljs.core.get.call(null, m, k__5635), ks__5636, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5635, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5637, f, args) {
    var vec__5638__5639 = p__5637;
    var k__5640 = cljs.core.nth.call(null, vec__5638__5639, 0, null);
    var ks__5641 = cljs.core.nthnext.call(null, vec__5638__5639, 1);
    if(cljs.core.truth_(ks__5641)) {
      return cljs.core.assoc.call(null, m, k__5640, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5640), ks__5641, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5640, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5640), args))
    }
  };
  var update_in = function(m, p__5637, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5637, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5642) {
    var m = cljs.core.first(arglist__5642);
    var p__5637 = cljs.core.first(cljs.core.next(arglist__5642));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5642)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5642)));
    return update_in__delegate(m, p__5637, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5647 = this;
  var h__364__auto____5648 = this__5647.__hash;
  if(h__364__auto____5648 != null) {
    return h__364__auto____5648
  }else {
    var h__364__auto____5649 = cljs.core.hash_coll.call(null, coll);
    this__5647.__hash = h__364__auto____5649;
    return h__364__auto____5649
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5650 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5651 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5652 = this;
  var new_array__5653 = cljs.core.aclone.call(null, this__5652.array);
  new_array__5653[k] = v;
  return new cljs.core.Vector(this__5652.meta, new_array__5653, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5682 = null;
  var G__5682__2 = function(tsym5645, k) {
    var this__5654 = this;
    var tsym5645__5655 = this;
    var coll__5656 = tsym5645__5655;
    return cljs.core._lookup.call(null, coll__5656, k)
  };
  var G__5682__3 = function(tsym5646, k, not_found) {
    var this__5657 = this;
    var tsym5646__5658 = this;
    var coll__5659 = tsym5646__5658;
    return cljs.core._lookup.call(null, coll__5659, k, not_found)
  };
  G__5682 = function(tsym5646, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5682__2.call(this, tsym5646, k);
      case 3:
        return G__5682__3.call(this, tsym5646, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5682
}();
cljs.core.Vector.prototype.apply = function(tsym5643, args5644) {
  return tsym5643.call.apply(tsym5643, [tsym5643].concat(cljs.core.aclone.call(null, args5644)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5660 = this;
  var new_array__5661 = cljs.core.aclone.call(null, this__5660.array);
  new_array__5661.push(o);
  return new cljs.core.Vector(this__5660.meta, new_array__5661, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5662 = this;
  var this$__5663 = this;
  return cljs.core.pr_str.call(null, this$__5663)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5664 = this;
  return cljs.core.ci_reduce.call(null, this__5664.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5665 = this;
  return cljs.core.ci_reduce.call(null, this__5665.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5666 = this;
  if(this__5666.array.length > 0) {
    var vector_seq__5667 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5666.array.length) {
          return cljs.core.cons.call(null, this__5666.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5667.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5668 = this;
  return this__5668.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5669 = this;
  var count__5670 = this__5669.array.length;
  if(count__5670 > 0) {
    return this__5669.array[count__5670 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5671 = this;
  if(this__5671.array.length > 0) {
    var new_array__5672 = cljs.core.aclone.call(null, this__5671.array);
    new_array__5672.pop();
    return new cljs.core.Vector(this__5671.meta, new_array__5672, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5673 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5674 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5675 = this;
  return new cljs.core.Vector(meta, this__5675.array, this__5675.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5676 = this;
  return this__5676.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5678 = this;
  if(function() {
    var and__3546__auto____5679 = 0 <= n;
    if(and__3546__auto____5679) {
      return n < this__5678.array.length
    }else {
      return and__3546__auto____5679
    }
  }()) {
    return this__5678.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5680 = this;
  if(function() {
    var and__3546__auto____5681 = 0 <= n;
    if(and__3546__auto____5681) {
      return n < this__5680.array.length
    }else {
      return and__3546__auto____5681
    }
  }()) {
    return this__5680.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5677 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5677.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5683 = pv.cnt;
  if(cnt__5683 < 32) {
    return 0
  }else {
    return cnt__5683 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5684 = level;
  var ret__5685 = node;
  while(true) {
    if(ll__5684 === 0) {
      return ret__5685
    }else {
      var embed__5686 = ret__5685;
      var r__5687 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5688 = cljs.core.pv_aset.call(null, r__5687, 0, embed__5686);
      var G__5689 = ll__5684 - 5;
      var G__5690 = r__5687;
      ll__5684 = G__5689;
      ret__5685 = G__5690;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5691 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5692 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5691, subidx__5692, tailnode);
    return ret__5691
  }else {
    var temp__3695__auto____5693 = cljs.core.pv_aget.call(null, parent, subidx__5692);
    if(cljs.core.truth_(temp__3695__auto____5693)) {
      var child__5694 = temp__3695__auto____5693;
      var node_to_insert__5695 = push_tail.call(null, pv, level - 5, child__5694, tailnode);
      cljs.core.pv_aset.call(null, ret__5691, subidx__5692, node_to_insert__5695);
      return ret__5691
    }else {
      var node_to_insert__5696 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5691, subidx__5692, node_to_insert__5696);
      return ret__5691
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5697 = 0 <= i;
    if(and__3546__auto____5697) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5697
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5698 = pv.root;
      var level__5699 = pv.shift;
      while(true) {
        if(level__5699 > 0) {
          var G__5700 = cljs.core.pv_aget.call(null, node__5698, i >>> level__5699 & 31);
          var G__5701 = level__5699 - 5;
          node__5698 = G__5700;
          level__5699 = G__5701;
          continue
        }else {
          return node__5698.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5702 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5702, i & 31, val);
    return ret__5702
  }else {
    var subidx__5703 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5702, subidx__5703, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5703), i, val));
    return ret__5702
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5704 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5705 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5704));
    if(function() {
      var and__3546__auto____5706 = new_child__5705 == null;
      if(and__3546__auto____5706) {
        return subidx__5704 === 0
      }else {
        return and__3546__auto____5706
      }
    }()) {
      return null
    }else {
      var ret__5707 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5707, subidx__5704, new_child__5705);
      return ret__5707
    }
  }else {
    if(subidx__5704 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5708 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5708, subidx__5704, null);
        return ret__5708
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5709 = cljs.core._count.call(null, v);
  if(c__5709 > 0) {
    if(void 0 === cljs.core.t5710) {
      cljs.core.t5710 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5710.cljs$lang$type = true;
      cljs.core.t5710.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5710")
      };
      cljs.core.t5710.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5710.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5711 = this;
        return vseq
      };
      cljs.core.t5710.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5710.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5712 = this;
        return cljs.core._nth.call(null, this__5712.v, this__5712.offset)
      };
      cljs.core.t5710.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5713 = this;
        var offset__5714 = this__5713.offset + 1;
        if(offset__5714 < this__5713.c) {
          return this__5713.vector_seq.call(null, this__5713.v, offset__5714)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5710.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5710.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5710.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5715 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5710.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5710.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5710.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5716 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5710.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5710.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5717 = this;
        return this__5717.__meta__389__auto__
      };
      cljs.core.t5710.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5718 = this;
        return new cljs.core.t5710(this__5718.c, this__5718.offset, this__5718.v, this__5718.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5710
    }else {
    }
    return new cljs.core.t5710(c__5709, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5723 = this;
  return new cljs.core.TransientVector(this__5723.cnt, this__5723.shift, cljs.core.tv_editable_root.call(null, this__5723.root), cljs.core.tv_editable_tail.call(null, this__5723.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5724 = this;
  var h__364__auto____5725 = this__5724.__hash;
  if(h__364__auto____5725 != null) {
    return h__364__auto____5725
  }else {
    var h__364__auto____5726 = cljs.core.hash_coll.call(null, coll);
    this__5724.__hash = h__364__auto____5726;
    return h__364__auto____5726
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5727 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5728 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5729 = this;
  if(function() {
    var and__3546__auto____5730 = 0 <= k;
    if(and__3546__auto____5730) {
      return k < this__5729.cnt
    }else {
      return and__3546__auto____5730
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5731 = cljs.core.aclone.call(null, this__5729.tail);
      new_tail__5731[k & 31] = v;
      return new cljs.core.PersistentVector(this__5729.meta, this__5729.cnt, this__5729.shift, this__5729.root, new_tail__5731, null)
    }else {
      return new cljs.core.PersistentVector(this__5729.meta, this__5729.cnt, this__5729.shift, cljs.core.do_assoc.call(null, coll, this__5729.shift, this__5729.root, k, v), this__5729.tail, null)
    }
  }else {
    if(k === this__5729.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5729.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5776 = null;
  var G__5776__2 = function(tsym5721, k) {
    var this__5732 = this;
    var tsym5721__5733 = this;
    var coll__5734 = tsym5721__5733;
    return cljs.core._lookup.call(null, coll__5734, k)
  };
  var G__5776__3 = function(tsym5722, k, not_found) {
    var this__5735 = this;
    var tsym5722__5736 = this;
    var coll__5737 = tsym5722__5736;
    return cljs.core._lookup.call(null, coll__5737, k, not_found)
  };
  G__5776 = function(tsym5722, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5776__2.call(this, tsym5722, k);
      case 3:
        return G__5776__3.call(this, tsym5722, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5776
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5719, args5720) {
  return tsym5719.call.apply(tsym5719, [tsym5719].concat(cljs.core.aclone.call(null, args5720)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5738 = this;
  var step_init__5739 = [0, init];
  var i__5740 = 0;
  while(true) {
    if(i__5740 < this__5738.cnt) {
      var arr__5741 = cljs.core.array_for.call(null, v, i__5740);
      var len__5742 = arr__5741.length;
      var init__5746 = function() {
        var j__5743 = 0;
        var init__5744 = step_init__5739[1];
        while(true) {
          if(j__5743 < len__5742) {
            var init__5745 = f.call(null, init__5744, j__5743 + i__5740, arr__5741[j__5743]);
            if(cljs.core.reduced_QMARK_.call(null, init__5745)) {
              return init__5745
            }else {
              var G__5777 = j__5743 + 1;
              var G__5778 = init__5745;
              j__5743 = G__5777;
              init__5744 = G__5778;
              continue
            }
          }else {
            step_init__5739[0] = len__5742;
            step_init__5739[1] = init__5744;
            return init__5744
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5746)) {
        return cljs.core.deref.call(null, init__5746)
      }else {
        var G__5779 = i__5740 + step_init__5739[0];
        i__5740 = G__5779;
        continue
      }
    }else {
      return step_init__5739[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5747 = this;
  if(this__5747.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5748 = cljs.core.aclone.call(null, this__5747.tail);
    new_tail__5748.push(o);
    return new cljs.core.PersistentVector(this__5747.meta, this__5747.cnt + 1, this__5747.shift, this__5747.root, new_tail__5748, null)
  }else {
    var root_overflow_QMARK___5749 = this__5747.cnt >>> 5 > 1 << this__5747.shift;
    var new_shift__5750 = root_overflow_QMARK___5749 ? this__5747.shift + 5 : this__5747.shift;
    var new_root__5752 = root_overflow_QMARK___5749 ? function() {
      var n_r__5751 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5751, 0, this__5747.root);
      cljs.core.pv_aset.call(null, n_r__5751, 1, cljs.core.new_path.call(null, null, this__5747.shift, new cljs.core.VectorNode(null, this__5747.tail)));
      return n_r__5751
    }() : cljs.core.push_tail.call(null, coll, this__5747.shift, this__5747.root, new cljs.core.VectorNode(null, this__5747.tail));
    return new cljs.core.PersistentVector(this__5747.meta, this__5747.cnt + 1, new_shift__5750, new_root__5752, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5753 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5754 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5755 = this;
  var this$__5756 = this;
  return cljs.core.pr_str.call(null, this$__5756)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5757 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5758 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5759 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5760 = this;
  return this__5760.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5761 = this;
  if(this__5761.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5761.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5762 = this;
  if(this__5762.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5762.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5762.meta)
    }else {
      if(1 < this__5762.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5762.meta, this__5762.cnt - 1, this__5762.shift, this__5762.root, this__5762.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5763 = cljs.core.array_for.call(null, coll, this__5762.cnt - 2);
          var nr__5764 = cljs.core.pop_tail.call(null, coll, this__5762.shift, this__5762.root);
          var new_root__5765 = nr__5764 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5764;
          var cnt_1__5766 = this__5762.cnt - 1;
          if(function() {
            var and__3546__auto____5767 = 5 < this__5762.shift;
            if(and__3546__auto____5767) {
              return cljs.core.pv_aget.call(null, new_root__5765, 1) == null
            }else {
              return and__3546__auto____5767
            }
          }()) {
            return new cljs.core.PersistentVector(this__5762.meta, cnt_1__5766, this__5762.shift - 5, cljs.core.pv_aget.call(null, new_root__5765, 0), new_tail__5763, null)
          }else {
            return new cljs.core.PersistentVector(this__5762.meta, cnt_1__5766, this__5762.shift, new_root__5765, new_tail__5763, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5769 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5770 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5771 = this;
  return new cljs.core.PersistentVector(meta, this__5771.cnt, this__5771.shift, this__5771.root, this__5771.tail, this__5771.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5772 = this;
  return this__5772.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5773 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5774 = this;
  if(function() {
    var and__3546__auto____5775 = 0 <= n;
    if(and__3546__auto____5775) {
      return n < this__5774.cnt
    }else {
      return and__3546__auto____5775
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5768 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5768.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5780 = cljs.core.seq.call(null, xs);
  var out__5781 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5780)) {
      var G__5782 = cljs.core.next.call(null, xs__5780);
      var G__5783 = cljs.core.conj_BANG_.call(null, out__5781, cljs.core.first.call(null, xs__5780));
      xs__5780 = G__5782;
      out__5781 = G__5783;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5781)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__5784) {
    var args = cljs.core.seq(arglist__5784);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5789 = this;
  var h__364__auto____5790 = this__5789.__hash;
  if(h__364__auto____5790 != null) {
    return h__364__auto____5790
  }else {
    var h__364__auto____5791 = cljs.core.hash_coll.call(null, coll);
    this__5789.__hash = h__364__auto____5791;
    return h__364__auto____5791
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5792 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5793 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__5794 = this;
  var v_pos__5795 = this__5794.start + key;
  return new cljs.core.Subvec(this__5794.meta, cljs.core._assoc.call(null, this__5794.v, v_pos__5795, val), this__5794.start, this__5794.end > v_pos__5795 + 1 ? this__5794.end : v_pos__5795 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__5819 = null;
  var G__5819__2 = function(tsym5787, k) {
    var this__5796 = this;
    var tsym5787__5797 = this;
    var coll__5798 = tsym5787__5797;
    return cljs.core._lookup.call(null, coll__5798, k)
  };
  var G__5819__3 = function(tsym5788, k, not_found) {
    var this__5799 = this;
    var tsym5788__5800 = this;
    var coll__5801 = tsym5788__5800;
    return cljs.core._lookup.call(null, coll__5801, k, not_found)
  };
  G__5819 = function(tsym5788, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5819__2.call(this, tsym5788, k);
      case 3:
        return G__5819__3.call(this, tsym5788, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5819
}();
cljs.core.Subvec.prototype.apply = function(tsym5785, args5786) {
  return tsym5785.call.apply(tsym5785, [tsym5785].concat(cljs.core.aclone.call(null, args5786)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5802 = this;
  return new cljs.core.Subvec(this__5802.meta, cljs.core._assoc_n.call(null, this__5802.v, this__5802.end, o), this__5802.start, this__5802.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__5803 = this;
  var this$__5804 = this;
  return cljs.core.pr_str.call(null, this$__5804)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5805 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5806 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5807 = this;
  var subvec_seq__5808 = function subvec_seq(i) {
    if(i === this__5807.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__5807.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__5808.call(null, this__5807.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5809 = this;
  return this__5809.end - this__5809.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5810 = this;
  return cljs.core._nth.call(null, this__5810.v, this__5810.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5811 = this;
  if(this__5811.start === this__5811.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__5811.meta, this__5811.v, this__5811.start, this__5811.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5812 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5813 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5814 = this;
  return new cljs.core.Subvec(meta, this__5814.v, this__5814.start, this__5814.end, this__5814.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5815 = this;
  return this__5815.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5817 = this;
  return cljs.core._nth.call(null, this__5817.v, this__5817.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5818 = this;
  return cljs.core._nth.call(null, this__5818.v, this__5818.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5816 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5816.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__5820 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__5820, 0, tl.length);
  return ret__5820
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__5821 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__5822 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__5821, subidx__5822, level === 5 ? tail_node : function() {
    var child__5823 = cljs.core.pv_aget.call(null, ret__5821, subidx__5822);
    if(child__5823 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__5823, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__5821
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__5824 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__5825 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5826 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__5824, subidx__5825));
    if(function() {
      var and__3546__auto____5827 = new_child__5826 == null;
      if(and__3546__auto____5827) {
        return subidx__5825 === 0
      }else {
        return and__3546__auto____5827
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__5824, subidx__5825, new_child__5826);
      return node__5824
    }
  }else {
    if(subidx__5825 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__5824, subidx__5825, null);
        return node__5824
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____5828 = 0 <= i;
    if(and__3546__auto____5828) {
      return i < tv.cnt
    }else {
      return and__3546__auto____5828
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__5829 = tv.root;
      var node__5830 = root__5829;
      var level__5831 = tv.shift;
      while(true) {
        if(level__5831 > 0) {
          var G__5832 = cljs.core.tv_ensure_editable.call(null, root__5829.edit, cljs.core.pv_aget.call(null, node__5830, i >>> level__5831 & 31));
          var G__5833 = level__5831 - 5;
          node__5830 = G__5832;
          level__5831 = G__5833;
          continue
        }else {
          return node__5830.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__5871 = null;
  var G__5871__2 = function(tsym5836, k) {
    var this__5838 = this;
    var tsym5836__5839 = this;
    var coll__5840 = tsym5836__5839;
    return cljs.core._lookup.call(null, coll__5840, k)
  };
  var G__5871__3 = function(tsym5837, k, not_found) {
    var this__5841 = this;
    var tsym5837__5842 = this;
    var coll__5843 = tsym5837__5842;
    return cljs.core._lookup.call(null, coll__5843, k, not_found)
  };
  G__5871 = function(tsym5837, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5871__2.call(this, tsym5837, k);
      case 3:
        return G__5871__3.call(this, tsym5837, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5871
}();
cljs.core.TransientVector.prototype.apply = function(tsym5834, args5835) {
  return tsym5834.call.apply(tsym5834, [tsym5834].concat(cljs.core.aclone.call(null, args5835)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5844 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5845 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5846 = this;
  if(cljs.core.truth_(this__5846.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5847 = this;
  if(function() {
    var and__3546__auto____5848 = 0 <= n;
    if(and__3546__auto____5848) {
      return n < this__5847.cnt
    }else {
      return and__3546__auto____5848
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5849 = this;
  if(cljs.core.truth_(this__5849.root.edit)) {
    return this__5849.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__5850 = this;
  if(cljs.core.truth_(this__5850.root.edit)) {
    if(function() {
      var and__3546__auto____5851 = 0 <= n;
      if(and__3546__auto____5851) {
        return n < this__5850.cnt
      }else {
        return and__3546__auto____5851
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__5850.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__5854 = function go(level, node) {
          var node__5852 = cljs.core.tv_ensure_editable.call(null, this__5850.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__5852, n & 31, val);
            return node__5852
          }else {
            var subidx__5853 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__5852, subidx__5853, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__5852, subidx__5853)));
            return node__5852
          }
        }.call(null, this__5850.shift, this__5850.root);
        this__5850.root = new_root__5854;
        return tcoll
      }
    }else {
      if(n === this__5850.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__5850.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__5855 = this;
  if(cljs.core.truth_(this__5855.root.edit)) {
    if(this__5855.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__5855.cnt) {
        this__5855.cnt = 0;
        return tcoll
      }else {
        if((this__5855.cnt - 1 & 31) > 0) {
          this__5855.cnt = this__5855.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__5856 = cljs.core.editable_array_for.call(null, tcoll, this__5855.cnt - 2);
            var new_root__5858 = function() {
              var nr__5857 = cljs.core.tv_pop_tail.call(null, tcoll, this__5855.shift, this__5855.root);
              if(nr__5857 != null) {
                return nr__5857
              }else {
                return new cljs.core.VectorNode(this__5855.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____5859 = 5 < this__5855.shift;
              if(and__3546__auto____5859) {
                return cljs.core.pv_aget.call(null, new_root__5858, 1) == null
              }else {
                return and__3546__auto____5859
              }
            }()) {
              var new_root__5860 = cljs.core.tv_ensure_editable.call(null, this__5855.root.edit, cljs.core.pv_aget.call(null, new_root__5858, 0));
              this__5855.root = new_root__5860;
              this__5855.shift = this__5855.shift - 5;
              this__5855.cnt = this__5855.cnt - 1;
              this__5855.tail = new_tail__5856;
              return tcoll
            }else {
              this__5855.root = new_root__5858;
              this__5855.cnt = this__5855.cnt - 1;
              this__5855.tail = new_tail__5856;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__5861 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__5862 = this;
  if(cljs.core.truth_(this__5862.root.edit)) {
    if(this__5862.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__5862.tail[this__5862.cnt & 31] = o;
      this__5862.cnt = this__5862.cnt + 1;
      return tcoll
    }else {
      var tail_node__5863 = new cljs.core.VectorNode(this__5862.root.edit, this__5862.tail);
      var new_tail__5864 = cljs.core.make_array.call(null, 32);
      new_tail__5864[0] = o;
      this__5862.tail = new_tail__5864;
      if(this__5862.cnt >>> 5 > 1 << this__5862.shift) {
        var new_root_array__5865 = cljs.core.make_array.call(null, 32);
        var new_shift__5866 = this__5862.shift + 5;
        new_root_array__5865[0] = this__5862.root;
        new_root_array__5865[1] = cljs.core.new_path.call(null, this__5862.root.edit, this__5862.shift, tail_node__5863);
        this__5862.root = new cljs.core.VectorNode(this__5862.root.edit, new_root_array__5865);
        this__5862.shift = new_shift__5866;
        this__5862.cnt = this__5862.cnt + 1;
        return tcoll
      }else {
        var new_root__5867 = cljs.core.tv_push_tail.call(null, tcoll, this__5862.shift, this__5862.root, tail_node__5863);
        this__5862.root = new_root__5867;
        this__5862.cnt = this__5862.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__5868 = this;
  if(cljs.core.truth_(this__5868.root.edit)) {
    this__5868.root.edit = null;
    var len__5869 = this__5868.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__5870 = cljs.core.make_array.call(null, len__5869);
    cljs.core.array_copy.call(null, this__5868.tail, 0, trimmed_tail__5870, 0, len__5869);
    return new cljs.core.PersistentVector(null, this__5868.cnt, this__5868.shift, this__5868.root, trimmed_tail__5870, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5872 = this;
  var h__364__auto____5873 = this__5872.__hash;
  if(h__364__auto____5873 != null) {
    return h__364__auto____5873
  }else {
    var h__364__auto____5874 = cljs.core.hash_coll.call(null, coll);
    this__5872.__hash = h__364__auto____5874;
    return h__364__auto____5874
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5875 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__5876 = this;
  var this$__5877 = this;
  return cljs.core.pr_str.call(null, this$__5877)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5878 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5879 = this;
  return cljs.core._first.call(null, this__5879.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5880 = this;
  var temp__3695__auto____5881 = cljs.core.next.call(null, this__5880.front);
  if(cljs.core.truth_(temp__3695__auto____5881)) {
    var f1__5882 = temp__3695__auto____5881;
    return new cljs.core.PersistentQueueSeq(this__5880.meta, f1__5882, this__5880.rear, null)
  }else {
    if(this__5880.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__5880.meta, this__5880.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5883 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5884 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__5884.front, this__5884.rear, this__5884.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5885 = this;
  return this__5885.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5886 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5886.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5887 = this;
  var h__364__auto____5888 = this__5887.__hash;
  if(h__364__auto____5888 != null) {
    return h__364__auto____5888
  }else {
    var h__364__auto____5889 = cljs.core.hash_coll.call(null, coll);
    this__5887.__hash = h__364__auto____5889;
    return h__364__auto____5889
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5890 = this;
  if(cljs.core.truth_(this__5890.front)) {
    return new cljs.core.PersistentQueue(this__5890.meta, this__5890.count + 1, this__5890.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____5891 = this__5890.rear;
      if(cljs.core.truth_(or__3548__auto____5891)) {
        return or__3548__auto____5891
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__5890.meta, this__5890.count + 1, cljs.core.conj.call(null, this__5890.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__5892 = this;
  var this$__5893 = this;
  return cljs.core.pr_str.call(null, this$__5893)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5894 = this;
  var rear__5895 = cljs.core.seq.call(null, this__5894.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____5896 = this__5894.front;
    if(cljs.core.truth_(or__3548__auto____5896)) {
      return or__3548__auto____5896
    }else {
      return rear__5895
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__5894.front, cljs.core.seq.call(null, rear__5895), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5897 = this;
  return this__5897.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5898 = this;
  return cljs.core._first.call(null, this__5898.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5899 = this;
  if(cljs.core.truth_(this__5899.front)) {
    var temp__3695__auto____5900 = cljs.core.next.call(null, this__5899.front);
    if(cljs.core.truth_(temp__3695__auto____5900)) {
      var f1__5901 = temp__3695__auto____5900;
      return new cljs.core.PersistentQueue(this__5899.meta, this__5899.count - 1, f1__5901, this__5899.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__5899.meta, this__5899.count - 1, cljs.core.seq.call(null, this__5899.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5902 = this;
  return cljs.core.first.call(null, this__5902.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5903 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5904 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5905 = this;
  return new cljs.core.PersistentQueue(meta, this__5905.count, this__5905.front, this__5905.rear, this__5905.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5906 = this;
  return this__5906.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5907 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__5908 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__5909 = array.length;
  var i__5910 = 0;
  while(true) {
    if(i__5910 < len__5909) {
      if(cljs.core._EQ_.call(null, k, array[i__5910])) {
        return i__5910
      }else {
        var G__5911 = i__5910 + incr;
        i__5910 = G__5911;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5912 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____5912)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____5912
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__5913 = cljs.core.hash.call(null, a);
  var b__5914 = cljs.core.hash.call(null, b);
  if(a__5913 < b__5914) {
    return-1
  }else {
    if(a__5913 > b__5914) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__5916 = m.keys;
  var len__5917 = ks__5916.length;
  var so__5918 = m.strobj;
  var out__5919 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__5920 = 0;
  var out__5921 = cljs.core.transient$.call(null, out__5919);
  while(true) {
    if(i__5920 < len__5917) {
      var k__5922 = ks__5916[i__5920];
      var G__5923 = i__5920 + 1;
      var G__5924 = cljs.core.assoc_BANG_.call(null, out__5921, k__5922, so__5918[k__5922]);
      i__5920 = G__5923;
      out__5921 = G__5924;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__5921, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5929 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5930 = this;
  var h__364__auto____5931 = this__5930.__hash;
  if(h__364__auto____5931 != null) {
    return h__364__auto____5931
  }else {
    var h__364__auto____5932 = cljs.core.hash_imap.call(null, coll);
    this__5930.__hash = h__364__auto____5932;
    return h__364__auto____5932
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5933 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5934 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5934.strobj, this__5934.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5935 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___5936 = this__5935.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___5936)) {
      var new_strobj__5937 = goog.object.clone.call(null, this__5935.strobj);
      new_strobj__5937[k] = v;
      return new cljs.core.ObjMap(this__5935.meta, this__5935.keys, new_strobj__5937, this__5935.update_count + 1, null)
    }else {
      if(this__5935.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__5938 = goog.object.clone.call(null, this__5935.strobj);
        var new_keys__5939 = cljs.core.aclone.call(null, this__5935.keys);
        new_strobj__5938[k] = v;
        new_keys__5939.push(k);
        return new cljs.core.ObjMap(this__5935.meta, new_keys__5939, new_strobj__5938, this__5935.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5940 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5940.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__5960 = null;
  var G__5960__2 = function(tsym5927, k) {
    var this__5941 = this;
    var tsym5927__5942 = this;
    var coll__5943 = tsym5927__5942;
    return cljs.core._lookup.call(null, coll__5943, k)
  };
  var G__5960__3 = function(tsym5928, k, not_found) {
    var this__5944 = this;
    var tsym5928__5945 = this;
    var coll__5946 = tsym5928__5945;
    return cljs.core._lookup.call(null, coll__5946, k, not_found)
  };
  G__5960 = function(tsym5928, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5960__2.call(this, tsym5928, k);
      case 3:
        return G__5960__3.call(this, tsym5928, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5960
}();
cljs.core.ObjMap.prototype.apply = function(tsym5925, args5926) {
  return tsym5925.call.apply(tsym5925, [tsym5925].concat(cljs.core.aclone.call(null, args5926)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5947 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__5948 = this;
  var this$__5949 = this;
  return cljs.core.pr_str.call(null, this$__5949)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5950 = this;
  if(this__5950.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__5915_SHARP_) {
      return cljs.core.vector.call(null, p1__5915_SHARP_, this__5950.strobj[p1__5915_SHARP_])
    }, this__5950.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5951 = this;
  return this__5951.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5952 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5953 = this;
  return new cljs.core.ObjMap(meta, this__5953.keys, this__5953.strobj, this__5953.update_count, this__5953.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5954 = this;
  return this__5954.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5955 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__5955.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__5956 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____5957 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____5957)) {
      return this__5956.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____5957
    }
  }())) {
    var new_keys__5958 = cljs.core.aclone.call(null, this__5956.keys);
    var new_strobj__5959 = goog.object.clone.call(null, this__5956.strobj);
    new_keys__5958.splice(cljs.core.scan_array.call(null, 1, k, new_keys__5958), 1);
    cljs.core.js_delete.call(null, new_strobj__5959, k);
    return new cljs.core.ObjMap(this__5956.meta, new_keys__5958, new_strobj__5959, this__5956.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5966 = this;
  var h__364__auto____5967 = this__5966.__hash;
  if(h__364__auto____5967 != null) {
    return h__364__auto____5967
  }else {
    var h__364__auto____5968 = cljs.core.hash_imap.call(null, coll);
    this__5966.__hash = h__364__auto____5968;
    return h__364__auto____5968
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5969 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5970 = this;
  var bucket__5971 = this__5970.hashobj[cljs.core.hash.call(null, k)];
  var i__5972 = cljs.core.truth_(bucket__5971) ? cljs.core.scan_array.call(null, 2, k, bucket__5971) : null;
  if(cljs.core.truth_(i__5972)) {
    return bucket__5971[i__5972 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5973 = this;
  var h__5974 = cljs.core.hash.call(null, k);
  var bucket__5975 = this__5973.hashobj[h__5974];
  if(cljs.core.truth_(bucket__5975)) {
    var new_bucket__5976 = cljs.core.aclone.call(null, bucket__5975);
    var new_hashobj__5977 = goog.object.clone.call(null, this__5973.hashobj);
    new_hashobj__5977[h__5974] = new_bucket__5976;
    var temp__3695__auto____5978 = cljs.core.scan_array.call(null, 2, k, new_bucket__5976);
    if(cljs.core.truth_(temp__3695__auto____5978)) {
      var i__5979 = temp__3695__auto____5978;
      new_bucket__5976[i__5979 + 1] = v;
      return new cljs.core.HashMap(this__5973.meta, this__5973.count, new_hashobj__5977, null)
    }else {
      new_bucket__5976.push(k, v);
      return new cljs.core.HashMap(this__5973.meta, this__5973.count + 1, new_hashobj__5977, null)
    }
  }else {
    var new_hashobj__5980 = goog.object.clone.call(null, this__5973.hashobj);
    new_hashobj__5980[h__5974] = [k, v];
    return new cljs.core.HashMap(this__5973.meta, this__5973.count + 1, new_hashobj__5980, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5981 = this;
  var bucket__5982 = this__5981.hashobj[cljs.core.hash.call(null, k)];
  var i__5983 = cljs.core.truth_(bucket__5982) ? cljs.core.scan_array.call(null, 2, k, bucket__5982) : null;
  if(cljs.core.truth_(i__5983)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6006 = null;
  var G__6006__2 = function(tsym5964, k) {
    var this__5984 = this;
    var tsym5964__5985 = this;
    var coll__5986 = tsym5964__5985;
    return cljs.core._lookup.call(null, coll__5986, k)
  };
  var G__6006__3 = function(tsym5965, k, not_found) {
    var this__5987 = this;
    var tsym5965__5988 = this;
    var coll__5989 = tsym5965__5988;
    return cljs.core._lookup.call(null, coll__5989, k, not_found)
  };
  G__6006 = function(tsym5965, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6006__2.call(this, tsym5965, k);
      case 3:
        return G__6006__3.call(this, tsym5965, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6006
}();
cljs.core.HashMap.prototype.apply = function(tsym5962, args5963) {
  return tsym5962.call.apply(tsym5962, [tsym5962].concat(cljs.core.aclone.call(null, args5963)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5990 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__5991 = this;
  var this$__5992 = this;
  return cljs.core.pr_str.call(null, this$__5992)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5993 = this;
  if(this__5993.count > 0) {
    var hashes__5994 = cljs.core.js_keys.call(null, this__5993.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__5961_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__5993.hashobj[p1__5961_SHARP_]))
    }, hashes__5994)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5995 = this;
  return this__5995.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5996 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5997 = this;
  return new cljs.core.HashMap(meta, this__5997.count, this__5997.hashobj, this__5997.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5998 = this;
  return this__5998.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5999 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__5999.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6000 = this;
  var h__6001 = cljs.core.hash.call(null, k);
  var bucket__6002 = this__6000.hashobj[h__6001];
  var i__6003 = cljs.core.truth_(bucket__6002) ? cljs.core.scan_array.call(null, 2, k, bucket__6002) : null;
  if(cljs.core.not.call(null, i__6003)) {
    return coll
  }else {
    var new_hashobj__6004 = goog.object.clone.call(null, this__6000.hashobj);
    if(3 > bucket__6002.length) {
      cljs.core.js_delete.call(null, new_hashobj__6004, h__6001)
    }else {
      var new_bucket__6005 = cljs.core.aclone.call(null, bucket__6002);
      new_bucket__6005.splice(i__6003, 2);
      new_hashobj__6004[h__6001] = new_bucket__6005
    }
    return new cljs.core.HashMap(this__6000.meta, this__6000.count - 1, new_hashobj__6004, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6007 = ks.length;
  var i__6008 = 0;
  var out__6009 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6008 < len__6007) {
      var G__6010 = i__6008 + 1;
      var G__6011 = cljs.core.assoc.call(null, out__6009, ks[i__6008], vs[i__6008]);
      i__6008 = G__6010;
      out__6009 = G__6011;
      continue
    }else {
      return out__6009
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6012 = m.arr;
  var len__6013 = arr__6012.length;
  var i__6014 = 0;
  while(true) {
    if(len__6013 <= i__6014) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6012[i__6014], k)) {
        return i__6014
      }else {
        if("\ufdd0'else") {
          var G__6015 = i__6014 + 2;
          i__6014 = G__6015;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6020 = this;
  return new cljs.core.TransientArrayMap({}, this__6020.arr.length, cljs.core.aclone.call(null, this__6020.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6021 = this;
  var h__364__auto____6022 = this__6021.__hash;
  if(h__364__auto____6022 != null) {
    return h__364__auto____6022
  }else {
    var h__364__auto____6023 = cljs.core.hash_imap.call(null, coll);
    this__6021.__hash = h__364__auto____6023;
    return h__364__auto____6023
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6024 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6025 = this;
  var idx__6026 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6026 === -1) {
    return not_found
  }else {
    return this__6025.arr[idx__6026 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6027 = this;
  var idx__6028 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6028 === -1) {
    if(this__6027.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6027.meta, this__6027.cnt + 1, function() {
        var G__6029__6030 = cljs.core.aclone.call(null, this__6027.arr);
        G__6029__6030.push(k);
        G__6029__6030.push(v);
        return G__6029__6030
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6027.arr[idx__6028 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6027.meta, this__6027.cnt, function() {
          var G__6031__6032 = cljs.core.aclone.call(null, this__6027.arr);
          G__6031__6032[idx__6028 + 1] = v;
          return G__6031__6032
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6033 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6063 = null;
  var G__6063__2 = function(tsym6018, k) {
    var this__6034 = this;
    var tsym6018__6035 = this;
    var coll__6036 = tsym6018__6035;
    return cljs.core._lookup.call(null, coll__6036, k)
  };
  var G__6063__3 = function(tsym6019, k, not_found) {
    var this__6037 = this;
    var tsym6019__6038 = this;
    var coll__6039 = tsym6019__6038;
    return cljs.core._lookup.call(null, coll__6039, k, not_found)
  };
  G__6063 = function(tsym6019, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6063__2.call(this, tsym6019, k);
      case 3:
        return G__6063__3.call(this, tsym6019, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6063
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6016, args6017) {
  return tsym6016.call.apply(tsym6016, [tsym6016].concat(cljs.core.aclone.call(null, args6017)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6040 = this;
  var len__6041 = this__6040.arr.length;
  var i__6042 = 0;
  var init__6043 = init;
  while(true) {
    if(i__6042 < len__6041) {
      var init__6044 = f.call(null, init__6043, this__6040.arr[i__6042], this__6040.arr[i__6042 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6044)) {
        return cljs.core.deref.call(null, init__6044)
      }else {
        var G__6064 = i__6042 + 2;
        var G__6065 = init__6044;
        i__6042 = G__6064;
        init__6043 = G__6065;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6045 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6046 = this;
  var this$__6047 = this;
  return cljs.core.pr_str.call(null, this$__6047)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6048 = this;
  if(this__6048.cnt > 0) {
    var len__6049 = this__6048.arr.length;
    var array_map_seq__6050 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6049) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6048.arr[i], this__6048.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6050.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6051 = this;
  return this__6051.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6052 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6053 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6053.cnt, this__6053.arr, this__6053.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6054 = this;
  return this__6054.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6055 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6055.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6056 = this;
  var idx__6057 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6057 >= 0) {
    var len__6058 = this__6056.arr.length;
    var new_len__6059 = len__6058 - 2;
    if(new_len__6059 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6060 = cljs.core.make_array.call(null, new_len__6059);
      var s__6061 = 0;
      var d__6062 = 0;
      while(true) {
        if(s__6061 >= len__6058) {
          return new cljs.core.PersistentArrayMap(this__6056.meta, this__6056.cnt - 1, new_arr__6060, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6056.arr[s__6061])) {
            var G__6066 = s__6061 + 2;
            var G__6067 = d__6062;
            s__6061 = G__6066;
            d__6062 = G__6067;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6060[d__6062] = this__6056.arr[s__6061];
              new_arr__6060[d__6062 + 1] = this__6056.arr[s__6061 + 1];
              var G__6068 = s__6061 + 2;
              var G__6069 = d__6062 + 2;
              s__6061 = G__6068;
              d__6062 = G__6069;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6070 = cljs.core.count.call(null, ks);
  var i__6071 = 0;
  var out__6072 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6071 < len__6070) {
      var G__6073 = i__6071 + 1;
      var G__6074 = cljs.core.assoc_BANG_.call(null, out__6072, ks[i__6071], vs[i__6071]);
      i__6071 = G__6073;
      out__6072 = G__6074;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6072)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6075 = this;
  if(cljs.core.truth_(this__6075.editable_QMARK_)) {
    var idx__6076 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6076 >= 0) {
      this__6075.arr[idx__6076] = this__6075.arr[this__6075.len - 2];
      this__6075.arr[idx__6076 + 1] = this__6075.arr[this__6075.len - 1];
      var G__6077__6078 = this__6075.arr;
      G__6077__6078.pop();
      G__6077__6078.pop();
      G__6077__6078;
      this__6075.len = this__6075.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6079 = this;
  if(cljs.core.truth_(this__6079.editable_QMARK_)) {
    var idx__6080 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6080 === -1) {
      if(this__6079.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6079.len = this__6079.len + 2;
        this__6079.arr.push(key);
        this__6079.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6079.len, this__6079.arr), key, val)
      }
    }else {
      if(val === this__6079.arr[idx__6080 + 1]) {
        return tcoll
      }else {
        this__6079.arr[idx__6080 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6081 = this;
  if(cljs.core.truth_(this__6081.editable_QMARK_)) {
    if(function() {
      var G__6082__6083 = o;
      if(G__6082__6083 != null) {
        if(function() {
          var or__3548__auto____6084 = G__6082__6083.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6084) {
            return or__3548__auto____6084
          }else {
            return G__6082__6083.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6082__6083.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6082__6083)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6082__6083)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6085 = cljs.core.seq.call(null, o);
      var tcoll__6086 = tcoll;
      while(true) {
        var temp__3695__auto____6087 = cljs.core.first.call(null, es__6085);
        if(cljs.core.truth_(temp__3695__auto____6087)) {
          var e__6088 = temp__3695__auto____6087;
          var G__6094 = cljs.core.next.call(null, es__6085);
          var G__6095 = cljs.core._assoc_BANG_.call(null, tcoll__6086, cljs.core.key.call(null, e__6088), cljs.core.val.call(null, e__6088));
          es__6085 = G__6094;
          tcoll__6086 = G__6095;
          continue
        }else {
          return tcoll__6086
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6089 = this;
  if(cljs.core.truth_(this__6089.editable_QMARK_)) {
    this__6089.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6089.len, 2), this__6089.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6090 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6091 = this;
  if(cljs.core.truth_(this__6091.editable_QMARK_)) {
    var idx__6092 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6092 === -1) {
      return not_found
    }else {
      return this__6091.arr[idx__6092 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6093 = this;
  if(cljs.core.truth_(this__6093.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6093.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6096 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6097 = 0;
  while(true) {
    if(i__6097 < len) {
      var G__6098 = cljs.core.assoc_BANG_.call(null, out__6096, arr[i__6097], arr[i__6097 + 1]);
      var G__6099 = i__6097 + 2;
      out__6096 = G__6098;
      i__6097 = G__6099;
      continue
    }else {
      return out__6096
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6100__6101 = cljs.core.aclone.call(null, arr);
    G__6100__6101[i] = a;
    return G__6100__6101
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6102__6103 = cljs.core.aclone.call(null, arr);
    G__6102__6103[i] = a;
    G__6102__6103[j] = b;
    return G__6102__6103
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6104 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6104, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6104, 2 * i, new_arr__6104.length - 2 * i);
  return new_arr__6104
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6105 = inode.ensure_editable(edit);
    editable__6105.arr[i] = a;
    return editable__6105
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6106 = inode.ensure_editable(edit);
    editable__6106.arr[i] = a;
    editable__6106.arr[j] = b;
    return editable__6106
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6107 = arr.length;
  var i__6108 = 0;
  var init__6109 = init;
  while(true) {
    if(i__6108 < len__6107) {
      var init__6112 = function() {
        var k__6110 = arr[i__6108];
        if(k__6110 != null) {
          return f.call(null, init__6109, k__6110, arr[i__6108 + 1])
        }else {
          var node__6111 = arr[i__6108 + 1];
          if(node__6111 != null) {
            return node__6111.kv_reduce(f, init__6109)
          }else {
            return init__6109
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6112)) {
        return cljs.core.deref.call(null, init__6112)
      }else {
        var G__6113 = i__6108 + 2;
        var G__6114 = init__6112;
        i__6108 = G__6113;
        init__6109 = G__6114;
        continue
      }
    }else {
      return init__6109
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6115 = this;
  var inode__6116 = this;
  if(this__6115.bitmap === bit) {
    return null
  }else {
    var editable__6117 = inode__6116.ensure_editable(e);
    var earr__6118 = editable__6117.arr;
    var len__6119 = earr__6118.length;
    editable__6117.bitmap = bit ^ editable__6117.bitmap;
    cljs.core.array_copy.call(null, earr__6118, 2 * (i + 1), earr__6118, 2 * i, len__6119 - 2 * (i + 1));
    earr__6118[len__6119 - 2] = null;
    earr__6118[len__6119 - 1] = null;
    return editable__6117
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6120 = this;
  var inode__6121 = this;
  var bit__6122 = 1 << (hash >>> shift & 31);
  var idx__6123 = cljs.core.bitmap_indexed_node_index.call(null, this__6120.bitmap, bit__6122);
  if((this__6120.bitmap & bit__6122) === 0) {
    var n__6124 = cljs.core.bit_count.call(null, this__6120.bitmap);
    if(2 * n__6124 < this__6120.arr.length) {
      var editable__6125 = inode__6121.ensure_editable(edit);
      var earr__6126 = editable__6125.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6126, 2 * idx__6123, earr__6126, 2 * (idx__6123 + 1), 2 * (n__6124 - idx__6123));
      earr__6126[2 * idx__6123] = key;
      earr__6126[2 * idx__6123 + 1] = val;
      editable__6125.bitmap = editable__6125.bitmap | bit__6122;
      return editable__6125
    }else {
      if(n__6124 >= 16) {
        var nodes__6127 = cljs.core.make_array.call(null, 32);
        var jdx__6128 = hash >>> shift & 31;
        nodes__6127[jdx__6128] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6129 = 0;
        var j__6130 = 0;
        while(true) {
          if(i__6129 < 32) {
            if((this__6120.bitmap >>> i__6129 & 1) === 0) {
              var G__6183 = i__6129 + 1;
              var G__6184 = j__6130;
              i__6129 = G__6183;
              j__6130 = G__6184;
              continue
            }else {
              nodes__6127[i__6129] = null != this__6120.arr[j__6130] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6120.arr[j__6130]), this__6120.arr[j__6130], this__6120.arr[j__6130 + 1], added_leaf_QMARK_) : this__6120.arr[j__6130 + 1];
              var G__6185 = i__6129 + 1;
              var G__6186 = j__6130 + 2;
              i__6129 = G__6185;
              j__6130 = G__6186;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6124 + 1, nodes__6127)
      }else {
        if("\ufdd0'else") {
          var new_arr__6131 = cljs.core.make_array.call(null, 2 * (n__6124 + 4));
          cljs.core.array_copy.call(null, this__6120.arr, 0, new_arr__6131, 0, 2 * idx__6123);
          new_arr__6131[2 * idx__6123] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6131[2 * idx__6123 + 1] = val;
          cljs.core.array_copy.call(null, this__6120.arr, 2 * idx__6123, new_arr__6131, 2 * (idx__6123 + 1), 2 * (n__6124 - idx__6123));
          var editable__6132 = inode__6121.ensure_editable(edit);
          editable__6132.arr = new_arr__6131;
          editable__6132.bitmap = editable__6132.bitmap | bit__6122;
          return editable__6132
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6133 = this__6120.arr[2 * idx__6123];
    var val_or_node__6134 = this__6120.arr[2 * idx__6123 + 1];
    if(null == key_or_nil__6133) {
      var n__6135 = val_or_node__6134.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6135 === val_or_node__6134) {
        return inode__6121
      }else {
        return cljs.core.edit_and_set.call(null, inode__6121, edit, 2 * idx__6123 + 1, n__6135)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6133)) {
        if(val === val_or_node__6134) {
          return inode__6121
        }else {
          return cljs.core.edit_and_set.call(null, inode__6121, edit, 2 * idx__6123 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6121, edit, 2 * idx__6123, null, 2 * idx__6123 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6133, val_or_node__6134, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6136 = this;
  var inode__6137 = this;
  return cljs.core.create_inode_seq.call(null, this__6136.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6138 = this;
  var inode__6139 = this;
  var bit__6140 = 1 << (hash >>> shift & 31);
  if((this__6138.bitmap & bit__6140) === 0) {
    return inode__6139
  }else {
    var idx__6141 = cljs.core.bitmap_indexed_node_index.call(null, this__6138.bitmap, bit__6140);
    var key_or_nil__6142 = this__6138.arr[2 * idx__6141];
    var val_or_node__6143 = this__6138.arr[2 * idx__6141 + 1];
    if(null == key_or_nil__6142) {
      var n__6144 = val_or_node__6143.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6144 === val_or_node__6143) {
        return inode__6139
      }else {
        if(null != n__6144) {
          return cljs.core.edit_and_set.call(null, inode__6139, edit, 2 * idx__6141 + 1, n__6144)
        }else {
          if(this__6138.bitmap === bit__6140) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6139.edit_and_remove_pair(edit, bit__6140, idx__6141)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6142)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6139.edit_and_remove_pair(edit, bit__6140, idx__6141)
      }else {
        if("\ufdd0'else") {
          return inode__6139
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6145 = this;
  var inode__6146 = this;
  if(e === this__6145.edit) {
    return inode__6146
  }else {
    var n__6147 = cljs.core.bit_count.call(null, this__6145.bitmap);
    var new_arr__6148 = cljs.core.make_array.call(null, n__6147 < 0 ? 4 : 2 * (n__6147 + 1));
    cljs.core.array_copy.call(null, this__6145.arr, 0, new_arr__6148, 0, 2 * n__6147);
    return new cljs.core.BitmapIndexedNode(e, this__6145.bitmap, new_arr__6148)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6149 = this;
  var inode__6150 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6149.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6187 = null;
  var G__6187__3 = function(shift, hash, key) {
    var this__6151 = this;
    var inode__6152 = this;
    var bit__6153 = 1 << (hash >>> shift & 31);
    if((this__6151.bitmap & bit__6153) === 0) {
      return null
    }else {
      var idx__6154 = cljs.core.bitmap_indexed_node_index.call(null, this__6151.bitmap, bit__6153);
      var key_or_nil__6155 = this__6151.arr[2 * idx__6154];
      var val_or_node__6156 = this__6151.arr[2 * idx__6154 + 1];
      if(null == key_or_nil__6155) {
        return val_or_node__6156.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6155)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6155, val_or_node__6156])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6187__4 = function(shift, hash, key, not_found) {
    var this__6157 = this;
    var inode__6158 = this;
    var bit__6159 = 1 << (hash >>> shift & 31);
    if((this__6157.bitmap & bit__6159) === 0) {
      return not_found
    }else {
      var idx__6160 = cljs.core.bitmap_indexed_node_index.call(null, this__6157.bitmap, bit__6159);
      var key_or_nil__6161 = this__6157.arr[2 * idx__6160];
      var val_or_node__6162 = this__6157.arr[2 * idx__6160 + 1];
      if(null == key_or_nil__6161) {
        return val_or_node__6162.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6161)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6161, val_or_node__6162])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6187 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6187__3.call(this, shift, hash, key);
      case 4:
        return G__6187__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6187
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6163 = this;
  var inode__6164 = this;
  var bit__6165 = 1 << (hash >>> shift & 31);
  if((this__6163.bitmap & bit__6165) === 0) {
    return inode__6164
  }else {
    var idx__6166 = cljs.core.bitmap_indexed_node_index.call(null, this__6163.bitmap, bit__6165);
    var key_or_nil__6167 = this__6163.arr[2 * idx__6166];
    var val_or_node__6168 = this__6163.arr[2 * idx__6166 + 1];
    if(null == key_or_nil__6167) {
      var n__6169 = val_or_node__6168.inode_without(shift + 5, hash, key);
      if(n__6169 === val_or_node__6168) {
        return inode__6164
      }else {
        if(null != n__6169) {
          return new cljs.core.BitmapIndexedNode(null, this__6163.bitmap, cljs.core.clone_and_set.call(null, this__6163.arr, 2 * idx__6166 + 1, n__6169))
        }else {
          if(this__6163.bitmap === bit__6165) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6163.bitmap ^ bit__6165, cljs.core.remove_pair.call(null, this__6163.arr, idx__6166))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6167)) {
        return new cljs.core.BitmapIndexedNode(null, this__6163.bitmap ^ bit__6165, cljs.core.remove_pair.call(null, this__6163.arr, idx__6166))
      }else {
        if("\ufdd0'else") {
          return inode__6164
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6170 = this;
  var inode__6171 = this;
  var bit__6172 = 1 << (hash >>> shift & 31);
  var idx__6173 = cljs.core.bitmap_indexed_node_index.call(null, this__6170.bitmap, bit__6172);
  if((this__6170.bitmap & bit__6172) === 0) {
    var n__6174 = cljs.core.bit_count.call(null, this__6170.bitmap);
    if(n__6174 >= 16) {
      var nodes__6175 = cljs.core.make_array.call(null, 32);
      var jdx__6176 = hash >>> shift & 31;
      nodes__6175[jdx__6176] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6177 = 0;
      var j__6178 = 0;
      while(true) {
        if(i__6177 < 32) {
          if((this__6170.bitmap >>> i__6177 & 1) === 0) {
            var G__6188 = i__6177 + 1;
            var G__6189 = j__6178;
            i__6177 = G__6188;
            j__6178 = G__6189;
            continue
          }else {
            nodes__6175[i__6177] = null != this__6170.arr[j__6178] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6170.arr[j__6178]), this__6170.arr[j__6178], this__6170.arr[j__6178 + 1], added_leaf_QMARK_) : this__6170.arr[j__6178 + 1];
            var G__6190 = i__6177 + 1;
            var G__6191 = j__6178 + 2;
            i__6177 = G__6190;
            j__6178 = G__6191;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6174 + 1, nodes__6175)
    }else {
      var new_arr__6179 = cljs.core.make_array.call(null, 2 * (n__6174 + 1));
      cljs.core.array_copy.call(null, this__6170.arr, 0, new_arr__6179, 0, 2 * idx__6173);
      new_arr__6179[2 * idx__6173] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6179[2 * idx__6173 + 1] = val;
      cljs.core.array_copy.call(null, this__6170.arr, 2 * idx__6173, new_arr__6179, 2 * (idx__6173 + 1), 2 * (n__6174 - idx__6173));
      return new cljs.core.BitmapIndexedNode(null, this__6170.bitmap | bit__6172, new_arr__6179)
    }
  }else {
    var key_or_nil__6180 = this__6170.arr[2 * idx__6173];
    var val_or_node__6181 = this__6170.arr[2 * idx__6173 + 1];
    if(null == key_or_nil__6180) {
      var n__6182 = val_or_node__6181.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6182 === val_or_node__6181) {
        return inode__6171
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6170.bitmap, cljs.core.clone_and_set.call(null, this__6170.arr, 2 * idx__6173 + 1, n__6182))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6180)) {
        if(val === val_or_node__6181) {
          return inode__6171
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6170.bitmap, cljs.core.clone_and_set.call(null, this__6170.arr, 2 * idx__6173 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6170.bitmap, cljs.core.clone_and_set.call(null, this__6170.arr, 2 * idx__6173, null, 2 * idx__6173 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6180, val_or_node__6181, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6192 = array_node.arr;
  var len__6193 = 2 * (array_node.cnt - 1);
  var new_arr__6194 = cljs.core.make_array.call(null, len__6193);
  var i__6195 = 0;
  var j__6196 = 1;
  var bitmap__6197 = 0;
  while(true) {
    if(i__6195 < len__6193) {
      if(function() {
        var and__3546__auto____6198 = i__6195 != idx;
        if(and__3546__auto____6198) {
          return null != arr__6192[i__6195]
        }else {
          return and__3546__auto____6198
        }
      }()) {
        new_arr__6194[j__6196] = arr__6192[i__6195];
        var G__6199 = i__6195 + 1;
        var G__6200 = j__6196 + 2;
        var G__6201 = bitmap__6197 | 1 << i__6195;
        i__6195 = G__6199;
        j__6196 = G__6200;
        bitmap__6197 = G__6201;
        continue
      }else {
        var G__6202 = i__6195 + 1;
        var G__6203 = j__6196;
        var G__6204 = bitmap__6197;
        i__6195 = G__6202;
        j__6196 = G__6203;
        bitmap__6197 = G__6204;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6197, new_arr__6194)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6205 = this;
  var inode__6206 = this;
  var idx__6207 = hash >>> shift & 31;
  var node__6208 = this__6205.arr[idx__6207];
  if(null == node__6208) {
    return new cljs.core.ArrayNode(null, this__6205.cnt + 1, cljs.core.clone_and_set.call(null, this__6205.arr, idx__6207, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6209 = node__6208.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6209 === node__6208) {
      return inode__6206
    }else {
      return new cljs.core.ArrayNode(null, this__6205.cnt, cljs.core.clone_and_set.call(null, this__6205.arr, idx__6207, n__6209))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6210 = this;
  var inode__6211 = this;
  var idx__6212 = hash >>> shift & 31;
  var node__6213 = this__6210.arr[idx__6212];
  if(null != node__6213) {
    var n__6214 = node__6213.inode_without(shift + 5, hash, key);
    if(n__6214 === node__6213) {
      return inode__6211
    }else {
      if(n__6214 == null) {
        if(this__6210.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6211, null, idx__6212)
        }else {
          return new cljs.core.ArrayNode(null, this__6210.cnt - 1, cljs.core.clone_and_set.call(null, this__6210.arr, idx__6212, n__6214))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6210.cnt, cljs.core.clone_and_set.call(null, this__6210.arr, idx__6212, n__6214))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6211
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6246 = null;
  var G__6246__3 = function(shift, hash, key) {
    var this__6215 = this;
    var inode__6216 = this;
    var idx__6217 = hash >>> shift & 31;
    var node__6218 = this__6215.arr[idx__6217];
    if(null != node__6218) {
      return node__6218.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6246__4 = function(shift, hash, key, not_found) {
    var this__6219 = this;
    var inode__6220 = this;
    var idx__6221 = hash >>> shift & 31;
    var node__6222 = this__6219.arr[idx__6221];
    if(null != node__6222) {
      return node__6222.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6246 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6246__3.call(this, shift, hash, key);
      case 4:
        return G__6246__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6246
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6223 = this;
  var inode__6224 = this;
  return cljs.core.create_array_node_seq.call(null, this__6223.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6225 = this;
  var inode__6226 = this;
  if(e === this__6225.edit) {
    return inode__6226
  }else {
    return new cljs.core.ArrayNode(e, this__6225.cnt, cljs.core.aclone.call(null, this__6225.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6227 = this;
  var inode__6228 = this;
  var idx__6229 = hash >>> shift & 31;
  var node__6230 = this__6227.arr[idx__6229];
  if(null == node__6230) {
    var editable__6231 = cljs.core.edit_and_set.call(null, inode__6228, edit, idx__6229, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6231.cnt = editable__6231.cnt + 1;
    return editable__6231
  }else {
    var n__6232 = node__6230.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6232 === node__6230) {
      return inode__6228
    }else {
      return cljs.core.edit_and_set.call(null, inode__6228, edit, idx__6229, n__6232)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6233 = this;
  var inode__6234 = this;
  var idx__6235 = hash >>> shift & 31;
  var node__6236 = this__6233.arr[idx__6235];
  if(null == node__6236) {
    return inode__6234
  }else {
    var n__6237 = node__6236.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6237 === node__6236) {
      return inode__6234
    }else {
      if(null == n__6237) {
        if(this__6233.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6234, edit, idx__6235)
        }else {
          var editable__6238 = cljs.core.edit_and_set.call(null, inode__6234, edit, idx__6235, n__6237);
          editable__6238.cnt = editable__6238.cnt - 1;
          return editable__6238
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6234, edit, idx__6235, n__6237)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6239 = this;
  var inode__6240 = this;
  var len__6241 = this__6239.arr.length;
  var i__6242 = 0;
  var init__6243 = init;
  while(true) {
    if(i__6242 < len__6241) {
      var node__6244 = this__6239.arr[i__6242];
      if(node__6244 != null) {
        var init__6245 = node__6244.kv_reduce(f, init__6243);
        if(cljs.core.reduced_QMARK_.call(null, init__6245)) {
          return cljs.core.deref.call(null, init__6245)
        }else {
          var G__6247 = i__6242 + 1;
          var G__6248 = init__6245;
          i__6242 = G__6247;
          init__6243 = G__6248;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6243
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6249 = 2 * cnt;
  var i__6250 = 0;
  while(true) {
    if(i__6250 < lim__6249) {
      if(cljs.core._EQ_.call(null, key, arr[i__6250])) {
        return i__6250
      }else {
        var G__6251 = i__6250 + 2;
        i__6250 = G__6251;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6252 = this;
  var inode__6253 = this;
  if(hash === this__6252.collision_hash) {
    var idx__6254 = cljs.core.hash_collision_node_find_index.call(null, this__6252.arr, this__6252.cnt, key);
    if(idx__6254 === -1) {
      var len__6255 = this__6252.arr.length;
      var new_arr__6256 = cljs.core.make_array.call(null, len__6255 + 2);
      cljs.core.array_copy.call(null, this__6252.arr, 0, new_arr__6256, 0, len__6255);
      new_arr__6256[len__6255] = key;
      new_arr__6256[len__6255 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6252.collision_hash, this__6252.cnt + 1, new_arr__6256)
    }else {
      if(cljs.core._EQ_.call(null, this__6252.arr[idx__6254], val)) {
        return inode__6253
      }else {
        return new cljs.core.HashCollisionNode(null, this__6252.collision_hash, this__6252.cnt, cljs.core.clone_and_set.call(null, this__6252.arr, idx__6254 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6252.collision_hash >>> shift & 31), [null, inode__6253])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6257 = this;
  var inode__6258 = this;
  var idx__6259 = cljs.core.hash_collision_node_find_index.call(null, this__6257.arr, this__6257.cnt, key);
  if(idx__6259 === -1) {
    return inode__6258
  }else {
    if(this__6257.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6257.collision_hash, this__6257.cnt - 1, cljs.core.remove_pair.call(null, this__6257.arr, cljs.core.quot.call(null, idx__6259, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6286 = null;
  var G__6286__3 = function(shift, hash, key) {
    var this__6260 = this;
    var inode__6261 = this;
    var idx__6262 = cljs.core.hash_collision_node_find_index.call(null, this__6260.arr, this__6260.cnt, key);
    if(idx__6262 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6260.arr[idx__6262])) {
        return cljs.core.PersistentVector.fromArray([this__6260.arr[idx__6262], this__6260.arr[idx__6262 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6286__4 = function(shift, hash, key, not_found) {
    var this__6263 = this;
    var inode__6264 = this;
    var idx__6265 = cljs.core.hash_collision_node_find_index.call(null, this__6263.arr, this__6263.cnt, key);
    if(idx__6265 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6263.arr[idx__6265])) {
        return cljs.core.PersistentVector.fromArray([this__6263.arr[idx__6265], this__6263.arr[idx__6265 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6286 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6286__3.call(this, shift, hash, key);
      case 4:
        return G__6286__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6286
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6266 = this;
  var inode__6267 = this;
  return cljs.core.create_inode_seq.call(null, this__6266.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6287 = null;
  var G__6287__1 = function(e) {
    var this__6268 = this;
    var inode__6269 = this;
    if(e === this__6268.edit) {
      return inode__6269
    }else {
      var new_arr__6270 = cljs.core.make_array.call(null, 2 * (this__6268.cnt + 1));
      cljs.core.array_copy.call(null, this__6268.arr, 0, new_arr__6270, 0, 2 * this__6268.cnt);
      return new cljs.core.HashCollisionNode(e, this__6268.collision_hash, this__6268.cnt, new_arr__6270)
    }
  };
  var G__6287__3 = function(e, count, array) {
    var this__6271 = this;
    var inode__6272 = this;
    if(e === this__6271.edit) {
      this__6271.arr = array;
      this__6271.cnt = count;
      return inode__6272
    }else {
      return new cljs.core.HashCollisionNode(this__6271.edit, this__6271.collision_hash, count, array)
    }
  };
  G__6287 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6287__1.call(this, e);
      case 3:
        return G__6287__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6287
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6273 = this;
  var inode__6274 = this;
  if(hash === this__6273.collision_hash) {
    var idx__6275 = cljs.core.hash_collision_node_find_index.call(null, this__6273.arr, this__6273.cnt, key);
    if(idx__6275 === -1) {
      if(this__6273.arr.length > 2 * this__6273.cnt) {
        var editable__6276 = cljs.core.edit_and_set.call(null, inode__6274, edit, 2 * this__6273.cnt, key, 2 * this__6273.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6276.cnt = editable__6276.cnt + 1;
        return editable__6276
      }else {
        var len__6277 = this__6273.arr.length;
        var new_arr__6278 = cljs.core.make_array.call(null, len__6277 + 2);
        cljs.core.array_copy.call(null, this__6273.arr, 0, new_arr__6278, 0, len__6277);
        new_arr__6278[len__6277] = key;
        new_arr__6278[len__6277 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6274.ensure_editable(edit, this__6273.cnt + 1, new_arr__6278)
      }
    }else {
      if(this__6273.arr[idx__6275 + 1] === val) {
        return inode__6274
      }else {
        return cljs.core.edit_and_set.call(null, inode__6274, edit, idx__6275 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6273.collision_hash >>> shift & 31), [null, inode__6274, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6279 = this;
  var inode__6280 = this;
  var idx__6281 = cljs.core.hash_collision_node_find_index.call(null, this__6279.arr, this__6279.cnt, key);
  if(idx__6281 === -1) {
    return inode__6280
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6279.cnt === 1) {
      return null
    }else {
      var editable__6282 = inode__6280.ensure_editable(edit);
      var earr__6283 = editable__6282.arr;
      earr__6283[idx__6281] = earr__6283[2 * this__6279.cnt - 2];
      earr__6283[idx__6281 + 1] = earr__6283[2 * this__6279.cnt - 1];
      earr__6283[2 * this__6279.cnt - 1] = null;
      earr__6283[2 * this__6279.cnt - 2] = null;
      editable__6282.cnt = editable__6282.cnt - 1;
      return editable__6282
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6284 = this;
  var inode__6285 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6284.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6288 = cljs.core.hash.call(null, key1);
    if(key1hash__6288 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6288, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6289 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6288, key1, val1, added_leaf_QMARK___6289).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6289)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6290 = cljs.core.hash.call(null, key1);
    if(key1hash__6290 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6290, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6291 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6290, key1, val1, added_leaf_QMARK___6291).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6291)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6292 = this;
  var h__364__auto____6293 = this__6292.__hash;
  if(h__364__auto____6293 != null) {
    return h__364__auto____6293
  }else {
    var h__364__auto____6294 = cljs.core.hash_coll.call(null, coll);
    this__6292.__hash = h__364__auto____6294;
    return h__364__auto____6294
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6295 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6296 = this;
  var this$__6297 = this;
  return cljs.core.pr_str.call(null, this$__6297)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6298 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6299 = this;
  if(this__6299.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6299.nodes[this__6299.i], this__6299.nodes[this__6299.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6299.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6300 = this;
  if(this__6300.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6300.nodes, this__6300.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6300.nodes, this__6300.i, cljs.core.next.call(null, this__6300.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6301 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6302 = this;
  return new cljs.core.NodeSeq(meta, this__6302.nodes, this__6302.i, this__6302.s, this__6302.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6303 = this;
  return this__6303.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6304 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6304.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6305 = nodes.length;
      var j__6306 = i;
      while(true) {
        if(j__6306 < len__6305) {
          if(null != nodes[j__6306]) {
            return new cljs.core.NodeSeq(null, nodes, j__6306, null, null)
          }else {
            var temp__3695__auto____6307 = nodes[j__6306 + 1];
            if(cljs.core.truth_(temp__3695__auto____6307)) {
              var node__6308 = temp__3695__auto____6307;
              var temp__3695__auto____6309 = node__6308.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6309)) {
                var node_seq__6310 = temp__3695__auto____6309;
                return new cljs.core.NodeSeq(null, nodes, j__6306 + 2, node_seq__6310, null)
              }else {
                var G__6311 = j__6306 + 2;
                j__6306 = G__6311;
                continue
              }
            }else {
              var G__6312 = j__6306 + 2;
              j__6306 = G__6312;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6313 = this;
  var h__364__auto____6314 = this__6313.__hash;
  if(h__364__auto____6314 != null) {
    return h__364__auto____6314
  }else {
    var h__364__auto____6315 = cljs.core.hash_coll.call(null, coll);
    this__6313.__hash = h__364__auto____6315;
    return h__364__auto____6315
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6316 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6317 = this;
  var this$__6318 = this;
  return cljs.core.pr_str.call(null, this$__6318)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6319 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6320 = this;
  return cljs.core.first.call(null, this__6320.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6321 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6321.nodes, this__6321.i, cljs.core.next.call(null, this__6321.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6322 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6323 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6323.nodes, this__6323.i, this__6323.s, this__6323.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6324 = this;
  return this__6324.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6325 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6325.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6326 = nodes.length;
      var j__6327 = i;
      while(true) {
        if(j__6327 < len__6326) {
          var temp__3695__auto____6328 = nodes[j__6327];
          if(cljs.core.truth_(temp__3695__auto____6328)) {
            var nj__6329 = temp__3695__auto____6328;
            var temp__3695__auto____6330 = nj__6329.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6330)) {
              var ns__6331 = temp__3695__auto____6330;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6327 + 1, ns__6331, null)
            }else {
              var G__6332 = j__6327 + 1;
              j__6327 = G__6332;
              continue
            }
          }else {
            var G__6333 = j__6327 + 1;
            j__6327 = G__6333;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6338 = this;
  return new cljs.core.TransientHashMap({}, this__6338.root, this__6338.cnt, this__6338.has_nil_QMARK_, this__6338.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6339 = this;
  var h__364__auto____6340 = this__6339.__hash;
  if(h__364__auto____6340 != null) {
    return h__364__auto____6340
  }else {
    var h__364__auto____6341 = cljs.core.hash_imap.call(null, coll);
    this__6339.__hash = h__364__auto____6341;
    return h__364__auto____6341
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6342 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6343 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6343.has_nil_QMARK_)) {
      return this__6343.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6343.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6343.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6344 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6345 = this__6344.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6345)) {
        return v === this__6344.nil_val
      }else {
        return and__3546__auto____6345
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6344.meta, cljs.core.truth_(this__6344.has_nil_QMARK_) ? this__6344.cnt : this__6344.cnt + 1, this__6344.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6346 = [false];
    var new_root__6347 = (this__6344.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6344.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6346);
    if(new_root__6347 === this__6344.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6344.meta, cljs.core.truth_(added_leaf_QMARK___6346[0]) ? this__6344.cnt + 1 : this__6344.cnt, new_root__6347, this__6344.has_nil_QMARK_, this__6344.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6348 = this;
  if(k == null) {
    return this__6348.has_nil_QMARK_
  }else {
    if(this__6348.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6348.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6369 = null;
  var G__6369__2 = function(tsym6336, k) {
    var this__6349 = this;
    var tsym6336__6350 = this;
    var coll__6351 = tsym6336__6350;
    return cljs.core._lookup.call(null, coll__6351, k)
  };
  var G__6369__3 = function(tsym6337, k, not_found) {
    var this__6352 = this;
    var tsym6337__6353 = this;
    var coll__6354 = tsym6337__6353;
    return cljs.core._lookup.call(null, coll__6354, k, not_found)
  };
  G__6369 = function(tsym6337, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6369__2.call(this, tsym6337, k);
      case 3:
        return G__6369__3.call(this, tsym6337, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6369
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6334, args6335) {
  return tsym6334.call.apply(tsym6334, [tsym6334].concat(cljs.core.aclone.call(null, args6335)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6355 = this;
  var init__6356 = cljs.core.truth_(this__6355.has_nil_QMARK_) ? f.call(null, init, null, this__6355.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6356)) {
    return cljs.core.deref.call(null, init__6356)
  }else {
    if(null != this__6355.root) {
      return this__6355.root.kv_reduce(f, init__6356)
    }else {
      if("\ufdd0'else") {
        return init__6356
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6357 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6358 = this;
  var this$__6359 = this;
  return cljs.core.pr_str.call(null, this$__6359)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6360 = this;
  if(this__6360.cnt > 0) {
    var s__6361 = null != this__6360.root ? this__6360.root.inode_seq() : null;
    if(cljs.core.truth_(this__6360.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6360.nil_val]), s__6361)
    }else {
      return s__6361
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6362 = this;
  return this__6362.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6363 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6364 = this;
  return new cljs.core.PersistentHashMap(meta, this__6364.cnt, this__6364.root, this__6364.has_nil_QMARK_, this__6364.nil_val, this__6364.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6365 = this;
  return this__6365.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6366 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6366.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6367 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6367.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6367.meta, this__6367.cnt - 1, this__6367.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6367.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6368 = this__6367.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6368 === this__6367.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6367.meta, this__6367.cnt - 1, new_root__6368, this__6367.has_nil_QMARK_, this__6367.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6370 = ks.length;
  var i__6371 = 0;
  var out__6372 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6371 < len__6370) {
      var G__6373 = i__6371 + 1;
      var G__6374 = cljs.core.assoc_BANG_.call(null, out__6372, ks[i__6371], vs[i__6371]);
      i__6371 = G__6373;
      out__6372 = G__6374;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6372)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6375 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6376 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6377 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6378 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6379 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6379.has_nil_QMARK_)) {
      return this__6379.nil_val
    }else {
      return null
    }
  }else {
    if(this__6379.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6379.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6380 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6380.has_nil_QMARK_)) {
      return this__6380.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6380.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6380.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6381 = this;
  if(cljs.core.truth_(this__6381.edit)) {
    return this__6381.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6382 = this;
  var tcoll__6383 = this;
  if(cljs.core.truth_(this__6382.edit)) {
    if(function() {
      var G__6384__6385 = o;
      if(G__6384__6385 != null) {
        if(function() {
          var or__3548__auto____6386 = G__6384__6385.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6386) {
            return or__3548__auto____6386
          }else {
            return G__6384__6385.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6384__6385.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6384__6385)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6384__6385)
      }
    }()) {
      return tcoll__6383.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6387 = cljs.core.seq.call(null, o);
      var tcoll__6388 = tcoll__6383;
      while(true) {
        var temp__3695__auto____6389 = cljs.core.first.call(null, es__6387);
        if(cljs.core.truth_(temp__3695__auto____6389)) {
          var e__6390 = temp__3695__auto____6389;
          var G__6401 = cljs.core.next.call(null, es__6387);
          var G__6402 = tcoll__6388.assoc_BANG_(cljs.core.key.call(null, e__6390), cljs.core.val.call(null, e__6390));
          es__6387 = G__6401;
          tcoll__6388 = G__6402;
          continue
        }else {
          return tcoll__6388
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6391 = this;
  var tcoll__6392 = this;
  if(cljs.core.truth_(this__6391.edit)) {
    if(k == null) {
      if(this__6391.nil_val === v) {
      }else {
        this__6391.nil_val = v
      }
      if(cljs.core.truth_(this__6391.has_nil_QMARK_)) {
      }else {
        this__6391.count = this__6391.count + 1;
        this__6391.has_nil_QMARK_ = true
      }
      return tcoll__6392
    }else {
      var added_leaf_QMARK___6393 = [false];
      var node__6394 = (this__6391.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6391.root).inode_assoc_BANG_(this__6391.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6393);
      if(node__6394 === this__6391.root) {
      }else {
        this__6391.root = node__6394
      }
      if(cljs.core.truth_(added_leaf_QMARK___6393[0])) {
        this__6391.count = this__6391.count + 1
      }else {
      }
      return tcoll__6392
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6395 = this;
  var tcoll__6396 = this;
  if(cljs.core.truth_(this__6395.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6395.has_nil_QMARK_)) {
        this__6395.has_nil_QMARK_ = false;
        this__6395.nil_val = null;
        this__6395.count = this__6395.count - 1;
        return tcoll__6396
      }else {
        return tcoll__6396
      }
    }else {
      if(this__6395.root == null) {
        return tcoll__6396
      }else {
        var removed_leaf_QMARK___6397 = [false];
        var node__6398 = this__6395.root.inode_without_BANG_(this__6395.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6397);
        if(node__6398 === this__6395.root) {
        }else {
          this__6395.root = node__6398
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6397[0])) {
          this__6395.count = this__6395.count - 1
        }else {
        }
        return tcoll__6396
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6399 = this;
  var tcoll__6400 = this;
  if(cljs.core.truth_(this__6399.edit)) {
    this__6399.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6399.count, this__6399.root, this__6399.has_nil_QMARK_, this__6399.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6403 = node;
  var stack__6404 = stack;
  while(true) {
    if(t__6403 != null) {
      var G__6405 = cljs.core.truth_(ascending_QMARK_) ? t__6403.left : t__6403.right;
      var G__6406 = cljs.core.conj.call(null, stack__6404, t__6403);
      t__6403 = G__6405;
      stack__6404 = G__6406;
      continue
    }else {
      return stack__6404
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6407 = this;
  var h__364__auto____6408 = this__6407.__hash;
  if(h__364__auto____6408 != null) {
    return h__364__auto____6408
  }else {
    var h__364__auto____6409 = cljs.core.hash_coll.call(null, coll);
    this__6407.__hash = h__364__auto____6409;
    return h__364__auto____6409
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6410 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6411 = this;
  var this$__6412 = this;
  return cljs.core.pr_str.call(null, this$__6412)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6413 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6414 = this;
  if(this__6414.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6414.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6415 = this;
  return cljs.core.peek.call(null, this__6415.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6416 = this;
  var t__6417 = cljs.core.peek.call(null, this__6416.stack);
  var next_stack__6418 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6416.ascending_QMARK_) ? t__6417.right : t__6417.left, cljs.core.pop.call(null, this__6416.stack), this__6416.ascending_QMARK_);
  if(next_stack__6418 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6418, this__6416.ascending_QMARK_, this__6416.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6419 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6420 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6420.stack, this__6420.ascending_QMARK_, this__6420.cnt, this__6420.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6421 = this;
  return this__6421.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6422 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6422) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6422
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6423 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6423) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6423
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6424 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6424)) {
    return cljs.core.deref.call(null, init__6424)
  }else {
    var init__6425 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6424) : init__6424;
    if(cljs.core.reduced_QMARK_.call(null, init__6425)) {
      return cljs.core.deref.call(null, init__6425)
    }else {
      var init__6426 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6425) : init__6425;
      if(cljs.core.reduced_QMARK_.call(null, init__6426)) {
        return cljs.core.deref.call(null, init__6426)
      }else {
        return init__6426
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6431 = this;
  var h__364__auto____6432 = this__6431.__hash;
  if(h__364__auto____6432 != null) {
    return h__364__auto____6432
  }else {
    var h__364__auto____6433 = cljs.core.hash_coll.call(null, coll);
    this__6431.__hash = h__364__auto____6433;
    return h__364__auto____6433
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6434 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6435 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6436 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6436.key, this__6436.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6483 = null;
  var G__6483__2 = function(tsym6429, k) {
    var this__6437 = this;
    var tsym6429__6438 = this;
    var node__6439 = tsym6429__6438;
    return cljs.core._lookup.call(null, node__6439, k)
  };
  var G__6483__3 = function(tsym6430, k, not_found) {
    var this__6440 = this;
    var tsym6430__6441 = this;
    var node__6442 = tsym6430__6441;
    return cljs.core._lookup.call(null, node__6442, k, not_found)
  };
  G__6483 = function(tsym6430, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6483__2.call(this, tsym6430, k);
      case 3:
        return G__6483__3.call(this, tsym6430, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6483
}();
cljs.core.BlackNode.prototype.apply = function(tsym6427, args6428) {
  return tsym6427.call.apply(tsym6427, [tsym6427].concat(cljs.core.aclone.call(null, args6428)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6443 = this;
  return cljs.core.PersistentVector.fromArray([this__6443.key, this__6443.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6444 = this;
  return this__6444.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6445 = this;
  return this__6445.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6446 = this;
  var node__6447 = this;
  return ins.balance_right(node__6447)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6448 = this;
  var node__6449 = this;
  return new cljs.core.RedNode(this__6448.key, this__6448.val, this__6448.left, this__6448.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6450 = this;
  var node__6451 = this;
  return cljs.core.balance_right_del.call(null, this__6450.key, this__6450.val, this__6450.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6452 = this;
  var node__6453 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6454 = this;
  var node__6455 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6455, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6456 = this;
  var node__6457 = this;
  return cljs.core.balance_left_del.call(null, this__6456.key, this__6456.val, del, this__6456.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6458 = this;
  var node__6459 = this;
  return ins.balance_left(node__6459)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6460 = this;
  var node__6461 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6461, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6484 = null;
  var G__6484__0 = function() {
    var this__6464 = this;
    var this$__6465 = this;
    return cljs.core.pr_str.call(null, this$__6465)
  };
  G__6484 = function() {
    switch(arguments.length) {
      case 0:
        return G__6484__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6484
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6466 = this;
  var node__6467 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6467, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6468 = this;
  var node__6469 = this;
  return node__6469
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6470 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6471 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6472 = this;
  return cljs.core.list.call(null, this__6472.key, this__6472.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6474 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6475 = this;
  return this__6475.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6476 = this;
  return cljs.core.PersistentVector.fromArray([this__6476.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6477 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6477.key, this__6477.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6478 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6479 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6479.key, this__6479.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6480 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6481 = this;
  if(n === 0) {
    return this__6481.key
  }else {
    if(n === 1) {
      return this__6481.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6482 = this;
  if(n === 0) {
    return this__6482.key
  }else {
    if(n === 1) {
      return this__6482.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6473 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6489 = this;
  var h__364__auto____6490 = this__6489.__hash;
  if(h__364__auto____6490 != null) {
    return h__364__auto____6490
  }else {
    var h__364__auto____6491 = cljs.core.hash_coll.call(null, coll);
    this__6489.__hash = h__364__auto____6491;
    return h__364__auto____6491
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6492 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6493 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6494 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6494.key, this__6494.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6541 = null;
  var G__6541__2 = function(tsym6487, k) {
    var this__6495 = this;
    var tsym6487__6496 = this;
    var node__6497 = tsym6487__6496;
    return cljs.core._lookup.call(null, node__6497, k)
  };
  var G__6541__3 = function(tsym6488, k, not_found) {
    var this__6498 = this;
    var tsym6488__6499 = this;
    var node__6500 = tsym6488__6499;
    return cljs.core._lookup.call(null, node__6500, k, not_found)
  };
  G__6541 = function(tsym6488, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6541__2.call(this, tsym6488, k);
      case 3:
        return G__6541__3.call(this, tsym6488, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6541
}();
cljs.core.RedNode.prototype.apply = function(tsym6485, args6486) {
  return tsym6485.call.apply(tsym6485, [tsym6485].concat(cljs.core.aclone.call(null, args6486)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6501 = this;
  return cljs.core.PersistentVector.fromArray([this__6501.key, this__6501.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6502 = this;
  return this__6502.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6503 = this;
  return this__6503.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6504 = this;
  var node__6505 = this;
  return new cljs.core.RedNode(this__6504.key, this__6504.val, this__6504.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6506 = this;
  var node__6507 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6508 = this;
  var node__6509 = this;
  return new cljs.core.RedNode(this__6508.key, this__6508.val, this__6508.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6510 = this;
  var node__6511 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6512 = this;
  var node__6513 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6513, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6514 = this;
  var node__6515 = this;
  return new cljs.core.RedNode(this__6514.key, this__6514.val, del, this__6514.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6516 = this;
  var node__6517 = this;
  return new cljs.core.RedNode(this__6516.key, this__6516.val, ins, this__6516.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6518 = this;
  var node__6519 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6518.left)) {
    return new cljs.core.RedNode(this__6518.key, this__6518.val, this__6518.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6518.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6518.right)) {
      return new cljs.core.RedNode(this__6518.right.key, this__6518.right.val, new cljs.core.BlackNode(this__6518.key, this__6518.val, this__6518.left, this__6518.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6518.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6519, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6542 = null;
  var G__6542__0 = function() {
    var this__6522 = this;
    var this$__6523 = this;
    return cljs.core.pr_str.call(null, this$__6523)
  };
  G__6542 = function() {
    switch(arguments.length) {
      case 0:
        return G__6542__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6542
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6524 = this;
  var node__6525 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6524.right)) {
    return new cljs.core.RedNode(this__6524.key, this__6524.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6524.left, null), this__6524.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6524.left)) {
      return new cljs.core.RedNode(this__6524.left.key, this__6524.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6524.left.left, null), new cljs.core.BlackNode(this__6524.key, this__6524.val, this__6524.left.right, this__6524.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6525, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6526 = this;
  var node__6527 = this;
  return new cljs.core.BlackNode(this__6526.key, this__6526.val, this__6526.left, this__6526.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6528 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6529 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6530 = this;
  return cljs.core.list.call(null, this__6530.key, this__6530.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6532 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6533 = this;
  return this__6533.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6534 = this;
  return cljs.core.PersistentVector.fromArray([this__6534.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6535 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6535.key, this__6535.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6536 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6537 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6537.key, this__6537.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6538 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6539 = this;
  if(n === 0) {
    return this__6539.key
  }else {
    if(n === 1) {
      return this__6539.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6540 = this;
  if(n === 0) {
    return this__6540.key
  }else {
    if(n === 1) {
      return this__6540.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6531 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6543 = comp.call(null, k, tree.key);
    if(c__6543 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6543 < 0) {
        var ins__6544 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6544 != null) {
          return tree.add_left(ins__6544)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6545 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6545 != null) {
            return tree.add_right(ins__6545)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6546 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6546)) {
            return new cljs.core.RedNode(app__6546.key, app__6546.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6546.left), new cljs.core.RedNode(right.key, right.val, app__6546.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6546, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6547 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6547)) {
              return new cljs.core.RedNode(app__6547.key, app__6547.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6547.left, null), new cljs.core.BlackNode(right.key, right.val, app__6547.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6547, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6548 = comp.call(null, k, tree.key);
    if(c__6548 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6548 < 0) {
        var del__6549 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6550 = del__6549 != null;
          if(or__3548__auto____6550) {
            return or__3548__auto____6550
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6549, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6549, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6551 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6552 = del__6551 != null;
            if(or__3548__auto____6552) {
              return or__3548__auto____6552
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6551)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6551, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6553 = tree.key;
  var c__6554 = comp.call(null, k, tk__6553);
  if(c__6554 === 0) {
    return tree.replace(tk__6553, v, tree.left, tree.right)
  }else {
    if(c__6554 < 0) {
      return tree.replace(tk__6553, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6553, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6559 = this;
  var h__364__auto____6560 = this__6559.__hash;
  if(h__364__auto____6560 != null) {
    return h__364__auto____6560
  }else {
    var h__364__auto____6561 = cljs.core.hash_imap.call(null, coll);
    this__6559.__hash = h__364__auto____6561;
    return h__364__auto____6561
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6562 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6563 = this;
  var n__6564 = coll.entry_at(k);
  if(n__6564 != null) {
    return n__6564.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6565 = this;
  var found__6566 = [null];
  var t__6567 = cljs.core.tree_map_add.call(null, this__6565.comp, this__6565.tree, k, v, found__6566);
  if(t__6567 == null) {
    var found_node__6568 = cljs.core.nth.call(null, found__6566, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6568.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6565.comp, cljs.core.tree_map_replace.call(null, this__6565.comp, this__6565.tree, k, v), this__6565.cnt, this__6565.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6565.comp, t__6567.blacken(), this__6565.cnt + 1, this__6565.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6569 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6601 = null;
  var G__6601__2 = function(tsym6557, k) {
    var this__6570 = this;
    var tsym6557__6571 = this;
    var coll__6572 = tsym6557__6571;
    return cljs.core._lookup.call(null, coll__6572, k)
  };
  var G__6601__3 = function(tsym6558, k, not_found) {
    var this__6573 = this;
    var tsym6558__6574 = this;
    var coll__6575 = tsym6558__6574;
    return cljs.core._lookup.call(null, coll__6575, k, not_found)
  };
  G__6601 = function(tsym6558, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6601__2.call(this, tsym6558, k);
      case 3:
        return G__6601__3.call(this, tsym6558, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6601
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6555, args6556) {
  return tsym6555.call.apply(tsym6555, [tsym6555].concat(cljs.core.aclone.call(null, args6556)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6576 = this;
  if(this__6576.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6576.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6577 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6578 = this;
  if(this__6578.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6578.tree, false, this__6578.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6579 = this;
  var this$__6580 = this;
  return cljs.core.pr_str.call(null, this$__6580)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6581 = this;
  var coll__6582 = this;
  var t__6583 = this__6581.tree;
  while(true) {
    if(t__6583 != null) {
      var c__6584 = this__6581.comp.call(null, k, t__6583.key);
      if(c__6584 === 0) {
        return t__6583
      }else {
        if(c__6584 < 0) {
          var G__6602 = t__6583.left;
          t__6583 = G__6602;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6603 = t__6583.right;
            t__6583 = G__6603;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6585 = this;
  if(this__6585.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6585.tree, ascending_QMARK_, this__6585.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6586 = this;
  if(this__6586.cnt > 0) {
    var stack__6587 = null;
    var t__6588 = this__6586.tree;
    while(true) {
      if(t__6588 != null) {
        var c__6589 = this__6586.comp.call(null, k, t__6588.key);
        if(c__6589 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6587, t__6588), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6589 < 0) {
              var G__6604 = cljs.core.conj.call(null, stack__6587, t__6588);
              var G__6605 = t__6588.left;
              stack__6587 = G__6604;
              t__6588 = G__6605;
              continue
            }else {
              var G__6606 = stack__6587;
              var G__6607 = t__6588.right;
              stack__6587 = G__6606;
              t__6588 = G__6607;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6589 > 0) {
                var G__6608 = cljs.core.conj.call(null, stack__6587, t__6588);
                var G__6609 = t__6588.right;
                stack__6587 = G__6608;
                t__6588 = G__6609;
                continue
              }else {
                var G__6610 = stack__6587;
                var G__6611 = t__6588.left;
                stack__6587 = G__6610;
                t__6588 = G__6611;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6587 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6587, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6590 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6591 = this;
  return this__6591.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6592 = this;
  if(this__6592.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6592.tree, true, this__6592.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6593 = this;
  return this__6593.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6594 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6595 = this;
  return new cljs.core.PersistentTreeMap(this__6595.comp, this__6595.tree, this__6595.cnt, meta, this__6595.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6599 = this;
  return this__6599.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6600 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6600.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6596 = this;
  var found__6597 = [null];
  var t__6598 = cljs.core.tree_map_remove.call(null, this__6596.comp, this__6596.tree, k, found__6597);
  if(t__6598 == null) {
    if(cljs.core.nth.call(null, found__6597, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6596.comp, null, 0, this__6596.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6596.comp, t__6598.blacken(), this__6596.cnt - 1, this__6596.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6612 = cljs.core.seq.call(null, keyvals);
    var out__6613 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6612)) {
        var G__6614 = cljs.core.nnext.call(null, in$__6612);
        var G__6615 = cljs.core.assoc_BANG_.call(null, out__6613, cljs.core.first.call(null, in$__6612), cljs.core.second.call(null, in$__6612));
        in$__6612 = G__6614;
        out__6613 = G__6615;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6613)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6616) {
    var keyvals = cljs.core.seq(arglist__6616);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6617) {
    var keyvals = cljs.core.seq(arglist__6617);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6618 = cljs.core.seq.call(null, keyvals);
    var out__6619 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6618)) {
        var G__6620 = cljs.core.nnext.call(null, in$__6618);
        var G__6621 = cljs.core.assoc.call(null, out__6619, cljs.core.first.call(null, in$__6618), cljs.core.second.call(null, in$__6618));
        in$__6618 = G__6620;
        out__6619 = G__6621;
        continue
      }else {
        return out__6619
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6622) {
    var keyvals = cljs.core.seq(arglist__6622);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6623 = cljs.core.seq.call(null, keyvals);
    var out__6624 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6623)) {
        var G__6625 = cljs.core.nnext.call(null, in$__6623);
        var G__6626 = cljs.core.assoc.call(null, out__6624, cljs.core.first.call(null, in$__6623), cljs.core.second.call(null, in$__6623));
        in$__6623 = G__6625;
        out__6624 = G__6626;
        continue
      }else {
        return out__6624
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6627) {
    var comparator = cljs.core.first(arglist__6627);
    var keyvals = cljs.core.rest(arglist__6627);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6628_SHARP_, p2__6629_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6630 = p1__6628_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6630)) {
            return or__3548__auto____6630
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6629_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6631) {
    var maps = cljs.core.seq(arglist__6631);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6634 = function(m, e) {
        var k__6632 = cljs.core.first.call(null, e);
        var v__6633 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6632)) {
          return cljs.core.assoc.call(null, m, k__6632, f.call(null, cljs.core.get.call(null, m, k__6632), v__6633))
        }else {
          return cljs.core.assoc.call(null, m, k__6632, v__6633)
        }
      };
      var merge2__6636 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6634, function() {
          var or__3548__auto____6635 = m1;
          if(cljs.core.truth_(or__3548__auto____6635)) {
            return or__3548__auto____6635
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6636, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6637) {
    var f = cljs.core.first(arglist__6637);
    var maps = cljs.core.rest(arglist__6637);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6638 = cljs.core.ObjMap.fromObject([], {});
  var keys__6639 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6639)) {
      var key__6640 = cljs.core.first.call(null, keys__6639);
      var entry__6641 = cljs.core.get.call(null, map, key__6640, "\ufdd0'user/not-found");
      var G__6642 = cljs.core.not_EQ_.call(null, entry__6641, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6638, key__6640, entry__6641) : ret__6638;
      var G__6643 = cljs.core.next.call(null, keys__6639);
      ret__6638 = G__6642;
      keys__6639 = G__6643;
      continue
    }else {
      return ret__6638
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6649 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6649.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6650 = this;
  var h__364__auto____6651 = this__6650.__hash;
  if(h__364__auto____6651 != null) {
    return h__364__auto____6651
  }else {
    var h__364__auto____6652 = cljs.core.hash_iset.call(null, coll);
    this__6650.__hash = h__364__auto____6652;
    return h__364__auto____6652
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6653 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6654 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6654.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6673 = null;
  var G__6673__2 = function(tsym6647, k) {
    var this__6655 = this;
    var tsym6647__6656 = this;
    var coll__6657 = tsym6647__6656;
    return cljs.core._lookup.call(null, coll__6657, k)
  };
  var G__6673__3 = function(tsym6648, k, not_found) {
    var this__6658 = this;
    var tsym6648__6659 = this;
    var coll__6660 = tsym6648__6659;
    return cljs.core._lookup.call(null, coll__6660, k, not_found)
  };
  G__6673 = function(tsym6648, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6673__2.call(this, tsym6648, k);
      case 3:
        return G__6673__3.call(this, tsym6648, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6673
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6645, args6646) {
  return tsym6645.call.apply(tsym6645, [tsym6645].concat(cljs.core.aclone.call(null, args6646)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6661 = this;
  return new cljs.core.PersistentHashSet(this__6661.meta, cljs.core.assoc.call(null, this__6661.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6662 = this;
  var this$__6663 = this;
  return cljs.core.pr_str.call(null, this$__6663)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6664 = this;
  return cljs.core.keys.call(null, this__6664.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6665 = this;
  return new cljs.core.PersistentHashSet(this__6665.meta, cljs.core.dissoc.call(null, this__6665.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6666 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6667 = this;
  var and__3546__auto____6668 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6668) {
    var and__3546__auto____6669 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6669) {
      return cljs.core.every_QMARK_.call(null, function(p1__6644_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6644_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6669
    }
  }else {
    return and__3546__auto____6668
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6670 = this;
  return new cljs.core.PersistentHashSet(meta, this__6670.hash_map, this__6670.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6671 = this;
  return this__6671.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6672 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6672.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6691 = null;
  var G__6691__2 = function(tsym6677, k) {
    var this__6679 = this;
    var tsym6677__6680 = this;
    var tcoll__6681 = tsym6677__6680;
    if(cljs.core._lookup.call(null, this__6679.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6691__3 = function(tsym6678, k, not_found) {
    var this__6682 = this;
    var tsym6678__6683 = this;
    var tcoll__6684 = tsym6678__6683;
    if(cljs.core._lookup.call(null, this__6682.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6691 = function(tsym6678, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6691__2.call(this, tsym6678, k);
      case 3:
        return G__6691__3.call(this, tsym6678, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6691
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6675, args6676) {
  return tsym6675.call.apply(tsym6675, [tsym6675].concat(cljs.core.aclone.call(null, args6676)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6685 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6686 = this;
  if(cljs.core._lookup.call(null, this__6686.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6687 = this;
  return cljs.core.count.call(null, this__6687.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6688 = this;
  this__6688.transient_map = cljs.core.dissoc_BANG_.call(null, this__6688.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6689 = this;
  this__6689.transient_map = cljs.core.assoc_BANG_.call(null, this__6689.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6690 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6690.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6696 = this;
  var h__364__auto____6697 = this__6696.__hash;
  if(h__364__auto____6697 != null) {
    return h__364__auto____6697
  }else {
    var h__364__auto____6698 = cljs.core.hash_iset.call(null, coll);
    this__6696.__hash = h__364__auto____6698;
    return h__364__auto____6698
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6699 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6700 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6700.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6724 = null;
  var G__6724__2 = function(tsym6694, k) {
    var this__6701 = this;
    var tsym6694__6702 = this;
    var coll__6703 = tsym6694__6702;
    return cljs.core._lookup.call(null, coll__6703, k)
  };
  var G__6724__3 = function(tsym6695, k, not_found) {
    var this__6704 = this;
    var tsym6695__6705 = this;
    var coll__6706 = tsym6695__6705;
    return cljs.core._lookup.call(null, coll__6706, k, not_found)
  };
  G__6724 = function(tsym6695, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6724__2.call(this, tsym6695, k);
      case 3:
        return G__6724__3.call(this, tsym6695, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6724
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6692, args6693) {
  return tsym6692.call.apply(tsym6692, [tsym6692].concat(cljs.core.aclone.call(null, args6693)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6707 = this;
  return new cljs.core.PersistentTreeSet(this__6707.meta, cljs.core.assoc.call(null, this__6707.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6708 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6708.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6709 = this;
  var this$__6710 = this;
  return cljs.core.pr_str.call(null, this$__6710)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6711 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6711.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6712 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6712.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6713 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6714 = this;
  return cljs.core._comparator.call(null, this__6714.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6715 = this;
  return cljs.core.keys.call(null, this__6715.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6716 = this;
  return new cljs.core.PersistentTreeSet(this__6716.meta, cljs.core.dissoc.call(null, this__6716.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6717 = this;
  return cljs.core.count.call(null, this__6717.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6718 = this;
  var and__3546__auto____6719 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6719) {
    var and__3546__auto____6720 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6720) {
      return cljs.core.every_QMARK_.call(null, function(p1__6674_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6674_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6720
    }
  }else {
    return and__3546__auto____6719
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6721 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6721.tree_map, this__6721.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6722 = this;
  return this__6722.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6723 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6723.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6725 = cljs.core.seq.call(null, coll);
  var out__6726 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6725))) {
      var G__6727 = cljs.core.next.call(null, in$__6725);
      var G__6728 = cljs.core.conj_BANG_.call(null, out__6726, cljs.core.first.call(null, in$__6725));
      in$__6725 = G__6727;
      out__6726 = G__6728;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6726)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6729) {
    var keys = cljs.core.seq(arglist__6729);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6731) {
    var comparator = cljs.core.first(arglist__6731);
    var keys = cljs.core.rest(arglist__6731);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6732 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6733 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6733)) {
        var e__6734 = temp__3695__auto____6733;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6734))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6732, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6730_SHARP_) {
      var temp__3695__auto____6735 = cljs.core.find.call(null, smap, p1__6730_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6735)) {
        var e__6736 = temp__3695__auto____6735;
        return cljs.core.second.call(null, e__6736)
      }else {
        return p1__6730_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6744 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6737, seen) {
        while(true) {
          var vec__6738__6739 = p__6737;
          var f__6740 = cljs.core.nth.call(null, vec__6738__6739, 0, null);
          var xs__6741 = vec__6738__6739;
          var temp__3698__auto____6742 = cljs.core.seq.call(null, xs__6741);
          if(cljs.core.truth_(temp__3698__auto____6742)) {
            var s__6743 = temp__3698__auto____6742;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6740)) {
              var G__6745 = cljs.core.rest.call(null, s__6743);
              var G__6746 = seen;
              p__6737 = G__6745;
              seen = G__6746;
              continue
            }else {
              return cljs.core.cons.call(null, f__6740, step.call(null, cljs.core.rest.call(null, s__6743), cljs.core.conj.call(null, seen, f__6740)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6744.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6747 = cljs.core.PersistentVector.fromArray([]);
  var s__6748 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6748))) {
      var G__6749 = cljs.core.conj.call(null, ret__6747, cljs.core.first.call(null, s__6748));
      var G__6750 = cljs.core.next.call(null, s__6748);
      ret__6747 = G__6749;
      s__6748 = G__6750;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6747)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6751 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6751) {
        return or__3548__auto____6751
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6752 = x.lastIndexOf("/");
      if(i__6752 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6752 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6753 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6753) {
      return or__3548__auto____6753
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6754 = x.lastIndexOf("/");
    if(i__6754 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6754)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6757 = cljs.core.ObjMap.fromObject([], {});
  var ks__6758 = cljs.core.seq.call(null, keys);
  var vs__6759 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6760 = ks__6758;
      if(cljs.core.truth_(and__3546__auto____6760)) {
        return vs__6759
      }else {
        return and__3546__auto____6760
      }
    }())) {
      var G__6761 = cljs.core.assoc.call(null, map__6757, cljs.core.first.call(null, ks__6758), cljs.core.first.call(null, vs__6759));
      var G__6762 = cljs.core.next.call(null, ks__6758);
      var G__6763 = cljs.core.next.call(null, vs__6759);
      map__6757 = G__6761;
      ks__6758 = G__6762;
      vs__6759 = G__6763;
      continue
    }else {
      return map__6757
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6766__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6755_SHARP_, p2__6756_SHARP_) {
        return max_key.call(null, k, p1__6755_SHARP_, p2__6756_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6766 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6766__delegate.call(this, k, x, y, more)
    };
    G__6766.cljs$lang$maxFixedArity = 3;
    G__6766.cljs$lang$applyTo = function(arglist__6767) {
      var k = cljs.core.first(arglist__6767);
      var x = cljs.core.first(cljs.core.next(arglist__6767));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6767)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6767)));
      return G__6766__delegate(k, x, y, more)
    };
    G__6766.cljs$lang$arity$variadic = G__6766__delegate;
    return G__6766
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6768__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6764_SHARP_, p2__6765_SHARP_) {
        return min_key.call(null, k, p1__6764_SHARP_, p2__6765_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6768 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6768__delegate.call(this, k, x, y, more)
    };
    G__6768.cljs$lang$maxFixedArity = 3;
    G__6768.cljs$lang$applyTo = function(arglist__6769) {
      var k = cljs.core.first(arglist__6769);
      var x = cljs.core.first(cljs.core.next(arglist__6769));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6769)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6769)));
      return G__6768__delegate(k, x, y, more)
    };
    G__6768.cljs$lang$arity$variadic = G__6768__delegate;
    return G__6768
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6770 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6770)) {
        var s__6771 = temp__3698__auto____6770;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6771), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6771)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6772 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6772)) {
      var s__6773 = temp__3698__auto____6772;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6773)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6773), take_while.call(null, pred, cljs.core.rest.call(null, s__6773)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6774 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6774.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6775 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6776 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6776)) {
        var vec__6777__6778 = temp__3698__auto____6776;
        var e__6779 = cljs.core.nth.call(null, vec__6777__6778, 0, null);
        var s__6780 = vec__6777__6778;
        if(cljs.core.truth_(include__6775.call(null, e__6779))) {
          return s__6780
        }else {
          return cljs.core.next.call(null, s__6780)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6775, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6781 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6781)) {
      var vec__6782__6783 = temp__3698__auto____6781;
      var e__6784 = cljs.core.nth.call(null, vec__6782__6783, 0, null);
      var s__6785 = vec__6782__6783;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__6784)) ? s__6785 : cljs.core.next.call(null, s__6785))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__6786 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____6787 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____6787)) {
        var vec__6788__6789 = temp__3698__auto____6787;
        var e__6790 = cljs.core.nth.call(null, vec__6788__6789, 0, null);
        var s__6791 = vec__6788__6789;
        if(cljs.core.truth_(include__6786.call(null, e__6790))) {
          return s__6791
        }else {
          return cljs.core.next.call(null, s__6791)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6786, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6792 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____6792)) {
      var vec__6793__6794 = temp__3698__auto____6792;
      var e__6795 = cljs.core.nth.call(null, vec__6793__6794, 0, null);
      var s__6796 = vec__6793__6794;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__6795)) ? s__6796 : cljs.core.next.call(null, s__6796))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__6797 = this;
  var h__364__auto____6798 = this__6797.__hash;
  if(h__364__auto____6798 != null) {
    return h__364__auto____6798
  }else {
    var h__364__auto____6799 = cljs.core.hash_coll.call(null, rng);
    this__6797.__hash = h__364__auto____6799;
    return h__364__auto____6799
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__6800 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__6801 = this;
  var this$__6802 = this;
  return cljs.core.pr_str.call(null, this$__6802)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__6803 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__6804 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__6805 = this;
  var comp__6806 = this__6805.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__6806.call(null, this__6805.start, this__6805.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__6807 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__6807.end - this__6807.start) / this__6807.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__6808 = this;
  return this__6808.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__6809 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__6809.meta, this__6809.start + this__6809.step, this__6809.end, this__6809.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__6810 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__6811 = this;
  return new cljs.core.Range(meta, this__6811.start, this__6811.end, this__6811.step, this__6811.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__6812 = this;
  return this__6812.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__6813 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6813.start + n * this__6813.step
  }else {
    if(function() {
      var and__3546__auto____6814 = this__6813.start > this__6813.end;
      if(and__3546__auto____6814) {
        return this__6813.step === 0
      }else {
        return and__3546__auto____6814
      }
    }()) {
      return this__6813.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__6815 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6815.start + n * this__6815.step
  }else {
    if(function() {
      var and__3546__auto____6816 = this__6815.start > this__6815.end;
      if(and__3546__auto____6816) {
        return this__6815.step === 0
      }else {
        return and__3546__auto____6816
      }
    }()) {
      return this__6815.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__6817 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6817.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6818 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6818)) {
      var s__6819 = temp__3698__auto____6818;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__6819), take_nth.call(null, n, cljs.core.drop.call(null, n, s__6819)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6821 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6821)) {
      var s__6822 = temp__3698__auto____6821;
      var fst__6823 = cljs.core.first.call(null, s__6822);
      var fv__6824 = f.call(null, fst__6823);
      var run__6825 = cljs.core.cons.call(null, fst__6823, cljs.core.take_while.call(null, function(p1__6820_SHARP_) {
        return cljs.core._EQ_.call(null, fv__6824, f.call(null, p1__6820_SHARP_))
      }, cljs.core.next.call(null, s__6822)));
      return cljs.core.cons.call(null, run__6825, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__6825), s__6822))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____6836 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____6836)) {
        var s__6837 = temp__3695__auto____6836;
        return reductions.call(null, f, cljs.core.first.call(null, s__6837), cljs.core.rest.call(null, s__6837))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6838 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6838)) {
        var s__6839 = temp__3698__auto____6838;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__6839)), cljs.core.rest.call(null, s__6839))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__6841 = null;
      var G__6841__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__6841__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__6841__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__6841__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__6841__4 = function() {
        var G__6842__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__6842 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6842__delegate.call(this, x, y, z, args)
        };
        G__6842.cljs$lang$maxFixedArity = 3;
        G__6842.cljs$lang$applyTo = function(arglist__6843) {
          var x = cljs.core.first(arglist__6843);
          var y = cljs.core.first(cljs.core.next(arglist__6843));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6843)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6843)));
          return G__6842__delegate(x, y, z, args)
        };
        G__6842.cljs$lang$arity$variadic = G__6842__delegate;
        return G__6842
      }();
      G__6841 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6841__0.call(this);
          case 1:
            return G__6841__1.call(this, x);
          case 2:
            return G__6841__2.call(this, x, y);
          case 3:
            return G__6841__3.call(this, x, y, z);
          default:
            return G__6841__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6841.cljs$lang$maxFixedArity = 3;
      G__6841.cljs$lang$applyTo = G__6841__4.cljs$lang$applyTo;
      return G__6841
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__6844 = null;
      var G__6844__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__6844__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__6844__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__6844__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__6844__4 = function() {
        var G__6845__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__6845 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6845__delegate.call(this, x, y, z, args)
        };
        G__6845.cljs$lang$maxFixedArity = 3;
        G__6845.cljs$lang$applyTo = function(arglist__6846) {
          var x = cljs.core.first(arglist__6846);
          var y = cljs.core.first(cljs.core.next(arglist__6846));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6846)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6846)));
          return G__6845__delegate(x, y, z, args)
        };
        G__6845.cljs$lang$arity$variadic = G__6845__delegate;
        return G__6845
      }();
      G__6844 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6844__0.call(this);
          case 1:
            return G__6844__1.call(this, x);
          case 2:
            return G__6844__2.call(this, x, y);
          case 3:
            return G__6844__3.call(this, x, y, z);
          default:
            return G__6844__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6844.cljs$lang$maxFixedArity = 3;
      G__6844.cljs$lang$applyTo = G__6844__4.cljs$lang$applyTo;
      return G__6844
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__6847 = null;
      var G__6847__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__6847__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__6847__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__6847__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__6847__4 = function() {
        var G__6848__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__6848 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6848__delegate.call(this, x, y, z, args)
        };
        G__6848.cljs$lang$maxFixedArity = 3;
        G__6848.cljs$lang$applyTo = function(arglist__6849) {
          var x = cljs.core.first(arglist__6849);
          var y = cljs.core.first(cljs.core.next(arglist__6849));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6849)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6849)));
          return G__6848__delegate(x, y, z, args)
        };
        G__6848.cljs$lang$arity$variadic = G__6848__delegate;
        return G__6848
      }();
      G__6847 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6847__0.call(this);
          case 1:
            return G__6847__1.call(this, x);
          case 2:
            return G__6847__2.call(this, x, y);
          case 3:
            return G__6847__3.call(this, x, y, z);
          default:
            return G__6847__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6847.cljs$lang$maxFixedArity = 3;
      G__6847.cljs$lang$applyTo = G__6847__4.cljs$lang$applyTo;
      return G__6847
    }()
  };
  var juxt__4 = function() {
    var G__6850__delegate = function(f, g, h, fs) {
      var fs__6840 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__6851 = null;
        var G__6851__0 = function() {
          return cljs.core.reduce.call(null, function(p1__6826_SHARP_, p2__6827_SHARP_) {
            return cljs.core.conj.call(null, p1__6826_SHARP_, p2__6827_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__6840)
        };
        var G__6851__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__6828_SHARP_, p2__6829_SHARP_) {
            return cljs.core.conj.call(null, p1__6828_SHARP_, p2__6829_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__6840)
        };
        var G__6851__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__6830_SHARP_, p2__6831_SHARP_) {
            return cljs.core.conj.call(null, p1__6830_SHARP_, p2__6831_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__6840)
        };
        var G__6851__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__6832_SHARP_, p2__6833_SHARP_) {
            return cljs.core.conj.call(null, p1__6832_SHARP_, p2__6833_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__6840)
        };
        var G__6851__4 = function() {
          var G__6852__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__6834_SHARP_, p2__6835_SHARP_) {
              return cljs.core.conj.call(null, p1__6834_SHARP_, cljs.core.apply.call(null, p2__6835_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__6840)
          };
          var G__6852 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__6852__delegate.call(this, x, y, z, args)
          };
          G__6852.cljs$lang$maxFixedArity = 3;
          G__6852.cljs$lang$applyTo = function(arglist__6853) {
            var x = cljs.core.first(arglist__6853);
            var y = cljs.core.first(cljs.core.next(arglist__6853));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6853)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6853)));
            return G__6852__delegate(x, y, z, args)
          };
          G__6852.cljs$lang$arity$variadic = G__6852__delegate;
          return G__6852
        }();
        G__6851 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__6851__0.call(this);
            case 1:
              return G__6851__1.call(this, x);
            case 2:
              return G__6851__2.call(this, x, y);
            case 3:
              return G__6851__3.call(this, x, y, z);
            default:
              return G__6851__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__6851.cljs$lang$maxFixedArity = 3;
        G__6851.cljs$lang$applyTo = G__6851__4.cljs$lang$applyTo;
        return G__6851
      }()
    };
    var G__6850 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6850__delegate.call(this, f, g, h, fs)
    };
    G__6850.cljs$lang$maxFixedArity = 3;
    G__6850.cljs$lang$applyTo = function(arglist__6854) {
      var f = cljs.core.first(arglist__6854);
      var g = cljs.core.first(cljs.core.next(arglist__6854));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6854)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6854)));
      return G__6850__delegate(f, g, h, fs)
    };
    G__6850.cljs$lang$arity$variadic = G__6850__delegate;
    return G__6850
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__6856 = cljs.core.next.call(null, coll);
        coll = G__6856;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____6855 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____6855)) {
          return n > 0
        }else {
          return and__3546__auto____6855
        }
      }())) {
        var G__6857 = n - 1;
        var G__6858 = cljs.core.next.call(null, coll);
        n = G__6857;
        coll = G__6858;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__6859 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__6859), s)) {
    if(cljs.core.count.call(null, matches__6859) === 1) {
      return cljs.core.first.call(null, matches__6859)
    }else {
      return cljs.core.vec.call(null, matches__6859)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__6860 = re.exec(s);
  if(matches__6860 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__6860) === 1) {
      return cljs.core.first.call(null, matches__6860)
    }else {
      return cljs.core.vec.call(null, matches__6860)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__6861 = cljs.core.re_find.call(null, re, s);
  var match_idx__6862 = s.search(re);
  var match_str__6863 = cljs.core.coll_QMARK_.call(null, match_data__6861) ? cljs.core.first.call(null, match_data__6861) : match_data__6861;
  var post_match__6864 = cljs.core.subs.call(null, s, match_idx__6862 + cljs.core.count.call(null, match_str__6863));
  if(cljs.core.truth_(match_data__6861)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__6861, re_seq.call(null, re, post_match__6864))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__6866__6867 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___6868 = cljs.core.nth.call(null, vec__6866__6867, 0, null);
  var flags__6869 = cljs.core.nth.call(null, vec__6866__6867, 1, null);
  var pattern__6870 = cljs.core.nth.call(null, vec__6866__6867, 2, null);
  return new RegExp(pattern__6870, flags__6869)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__6865_SHARP_) {
    return print_one.call(null, p1__6865_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____6871 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____6871)) {
            var and__3546__auto____6875 = function() {
              var G__6872__6873 = obj;
              if(G__6872__6873 != null) {
                if(function() {
                  var or__3548__auto____6874 = G__6872__6873.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____6874) {
                    return or__3548__auto____6874
                  }else {
                    return G__6872__6873.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__6872__6873.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6872__6873)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6872__6873)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____6875)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____6875
            }
          }else {
            return and__3546__auto____6871
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____6876 = obj != null;
          if(and__3546__auto____6876) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____6876
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__6877__6878 = obj;
          if(G__6877__6878 != null) {
            if(function() {
              var or__3548__auto____6879 = G__6877__6878.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____6879) {
                return or__3548__auto____6879
              }else {
                return G__6877__6878.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__6877__6878.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6877__6878)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6877__6878)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__6880 = cljs.core.first.call(null, objs);
  var sb__6881 = new goog.string.StringBuffer;
  var G__6882__6883 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6882__6883)) {
    var obj__6884 = cljs.core.first.call(null, G__6882__6883);
    var G__6882__6885 = G__6882__6883;
    while(true) {
      if(obj__6884 === first_obj__6880) {
      }else {
        sb__6881.append(" ")
      }
      var G__6886__6887 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6884, opts));
      if(cljs.core.truth_(G__6886__6887)) {
        var string__6888 = cljs.core.first.call(null, G__6886__6887);
        var G__6886__6889 = G__6886__6887;
        while(true) {
          sb__6881.append(string__6888);
          var temp__3698__auto____6890 = cljs.core.next.call(null, G__6886__6889);
          if(cljs.core.truth_(temp__3698__auto____6890)) {
            var G__6886__6891 = temp__3698__auto____6890;
            var G__6894 = cljs.core.first.call(null, G__6886__6891);
            var G__6895 = G__6886__6891;
            string__6888 = G__6894;
            G__6886__6889 = G__6895;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6892 = cljs.core.next.call(null, G__6882__6885);
      if(cljs.core.truth_(temp__3698__auto____6892)) {
        var G__6882__6893 = temp__3698__auto____6892;
        var G__6896 = cljs.core.first.call(null, G__6882__6893);
        var G__6897 = G__6882__6893;
        obj__6884 = G__6896;
        G__6882__6885 = G__6897;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__6881
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__6898 = cljs.core.pr_sb.call(null, objs, opts);
  sb__6898.append("\n");
  return[cljs.core.str(sb__6898)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__6899 = cljs.core.first.call(null, objs);
  var G__6900__6901 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6900__6901)) {
    var obj__6902 = cljs.core.first.call(null, G__6900__6901);
    var G__6900__6903 = G__6900__6901;
    while(true) {
      if(obj__6902 === first_obj__6899) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__6904__6905 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6902, opts));
      if(cljs.core.truth_(G__6904__6905)) {
        var string__6906 = cljs.core.first.call(null, G__6904__6905);
        var G__6904__6907 = G__6904__6905;
        while(true) {
          cljs.core.string_print.call(null, string__6906);
          var temp__3698__auto____6908 = cljs.core.next.call(null, G__6904__6907);
          if(cljs.core.truth_(temp__3698__auto____6908)) {
            var G__6904__6909 = temp__3698__auto____6908;
            var G__6912 = cljs.core.first.call(null, G__6904__6909);
            var G__6913 = G__6904__6909;
            string__6906 = G__6912;
            G__6904__6907 = G__6913;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6910 = cljs.core.next.call(null, G__6900__6903);
      if(cljs.core.truth_(temp__3698__auto____6910)) {
        var G__6900__6911 = temp__3698__auto____6910;
        var G__6914 = cljs.core.first.call(null, G__6900__6911);
        var G__6915 = G__6900__6911;
        obj__6902 = G__6914;
        G__6900__6903 = G__6915;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__6916) {
    var objs = cljs.core.seq(arglist__6916);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__6917) {
    var objs = cljs.core.seq(arglist__6917);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__6918) {
    var objs = cljs.core.seq(arglist__6918);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__6919) {
    var objs = cljs.core.seq(arglist__6919);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__6920) {
    var objs = cljs.core.seq(arglist__6920);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__6921) {
    var objs = cljs.core.seq(arglist__6921);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__6922) {
    var objs = cljs.core.seq(arglist__6922);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__6923) {
    var objs = cljs.core.seq(arglist__6923);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6924 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6924, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6925 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6925, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6926 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6926, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____6927 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____6927)) {
        var nspc__6928 = temp__3698__auto____6927;
        return[cljs.core.str(nspc__6928), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____6929 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____6929)) {
          var nspc__6930 = temp__3698__auto____6929;
          return[cljs.core.str(nspc__6930), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6931 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6931, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6932 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6932, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__6933 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__6934 = this;
  var G__6935__6936 = cljs.core.seq.call(null, this__6934.watches);
  if(cljs.core.truth_(G__6935__6936)) {
    var G__6938__6940 = cljs.core.first.call(null, G__6935__6936);
    var vec__6939__6941 = G__6938__6940;
    var key__6942 = cljs.core.nth.call(null, vec__6939__6941, 0, null);
    var f__6943 = cljs.core.nth.call(null, vec__6939__6941, 1, null);
    var G__6935__6944 = G__6935__6936;
    var G__6938__6945 = G__6938__6940;
    var G__6935__6946 = G__6935__6944;
    while(true) {
      var vec__6947__6948 = G__6938__6945;
      var key__6949 = cljs.core.nth.call(null, vec__6947__6948, 0, null);
      var f__6950 = cljs.core.nth.call(null, vec__6947__6948, 1, null);
      var G__6935__6951 = G__6935__6946;
      f__6950.call(null, key__6949, this$, oldval, newval);
      var temp__3698__auto____6952 = cljs.core.next.call(null, G__6935__6951);
      if(cljs.core.truth_(temp__3698__auto____6952)) {
        var G__6935__6953 = temp__3698__auto____6952;
        var G__6960 = cljs.core.first.call(null, G__6935__6953);
        var G__6961 = G__6935__6953;
        G__6938__6945 = G__6960;
        G__6935__6946 = G__6961;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__6954 = this;
  return this$.watches = cljs.core.assoc.call(null, this__6954.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__6955 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__6955.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__6956 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__6956.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__6957 = this;
  return this__6957.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__6958 = this;
  return this__6958.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6959 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__6968__delegate = function(x, p__6962) {
      var map__6963__6964 = p__6962;
      var map__6963__6965 = cljs.core.seq_QMARK_.call(null, map__6963__6964) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6963__6964) : map__6963__6964;
      var validator__6966 = cljs.core.get.call(null, map__6963__6965, "\ufdd0'validator");
      var meta__6967 = cljs.core.get.call(null, map__6963__6965, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__6967, validator__6966, null)
    };
    var G__6968 = function(x, var_args) {
      var p__6962 = null;
      if(goog.isDef(var_args)) {
        p__6962 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__6968__delegate.call(this, x, p__6962)
    };
    G__6968.cljs$lang$maxFixedArity = 1;
    G__6968.cljs$lang$applyTo = function(arglist__6969) {
      var x = cljs.core.first(arglist__6969);
      var p__6962 = cljs.core.rest(arglist__6969);
      return G__6968__delegate(x, p__6962)
    };
    G__6968.cljs$lang$arity$variadic = G__6968__delegate;
    return G__6968
  }();
  atom = function(x, var_args) {
    var p__6962 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____6970 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____6970)) {
    var validate__6971 = temp__3698__auto____6970;
    if(cljs.core.truth_(validate__6971.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__6972 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__6972, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__6973__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__6973 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__6973__delegate.call(this, a, f, x, y, z, more)
    };
    G__6973.cljs$lang$maxFixedArity = 5;
    G__6973.cljs$lang$applyTo = function(arglist__6974) {
      var a = cljs.core.first(arglist__6974);
      var f = cljs.core.first(cljs.core.next(arglist__6974));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6974)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__6974))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__6974)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__6974)))));
      return G__6973__delegate(a, f, x, y, z, more)
    };
    G__6973.cljs$lang$arity$variadic = G__6973__delegate;
    return G__6973
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__6975) {
    var iref = cljs.core.first(arglist__6975);
    var f = cljs.core.first(cljs.core.next(arglist__6975));
    var args = cljs.core.rest(cljs.core.next(arglist__6975));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__6976 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__6976.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__6977 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__6977.state, function(p__6978) {
    var curr_state__6979 = p__6978;
    var curr_state__6980 = cljs.core.seq_QMARK_.call(null, curr_state__6979) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__6979) : curr_state__6979;
    var done__6981 = cljs.core.get.call(null, curr_state__6980, "\ufdd0'done");
    if(cljs.core.truth_(done__6981)) {
      return curr_state__6980
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__6977.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__6982__6983 = options;
    var map__6982__6984 = cljs.core.seq_QMARK_.call(null, map__6982__6983) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6982__6983) : map__6982__6983;
    var keywordize_keys__6985 = cljs.core.get.call(null, map__6982__6984, "\ufdd0'keywordize-keys");
    var keyfn__6986 = cljs.core.truth_(keywordize_keys__6985) ? cljs.core.keyword : cljs.core.str;
    var f__6992 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____6991 = function iter__6987(s__6988) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__6988__6989 = s__6988;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__6988__6989))) {
                        var k__6990 = cljs.core.first.call(null, s__6988__6989);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__6986.call(null, k__6990), thisfn.call(null, x[k__6990])]), iter__6987.call(null, cljs.core.rest.call(null, s__6988__6989)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____6991.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__6992.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__6993) {
    var x = cljs.core.first(arglist__6993);
    var options = cljs.core.rest(arglist__6993);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__6994 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__6998__delegate = function(args) {
      var temp__3695__auto____6995 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__6994), args);
      if(cljs.core.truth_(temp__3695__auto____6995)) {
        var v__6996 = temp__3695__auto____6995;
        return v__6996
      }else {
        var ret__6997 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__6994, cljs.core.assoc, args, ret__6997);
        return ret__6997
      }
    };
    var G__6998 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__6998__delegate.call(this, args)
    };
    G__6998.cljs$lang$maxFixedArity = 0;
    G__6998.cljs$lang$applyTo = function(arglist__6999) {
      var args = cljs.core.seq(arglist__6999);
      return G__6998__delegate(args)
    };
    G__6998.cljs$lang$arity$variadic = G__6998__delegate;
    return G__6998
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7000 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7000)) {
        var G__7001 = ret__7000;
        f = G__7001;
        continue
      }else {
        return ret__7000
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7002__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7002 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7002__delegate.call(this, f, args)
    };
    G__7002.cljs$lang$maxFixedArity = 1;
    G__7002.cljs$lang$applyTo = function(arglist__7003) {
      var f = cljs.core.first(arglist__7003);
      var args = cljs.core.rest(arglist__7003);
      return G__7002__delegate(f, args)
    };
    G__7002.cljs$lang$arity$variadic = G__7002__delegate;
    return G__7002
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7004 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7004, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7004, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7005 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7005) {
      return or__3548__auto____7005
    }else {
      var or__3548__auto____7006 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7006) {
        return or__3548__auto____7006
      }else {
        var and__3546__auto____7007 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7007) {
          var and__3546__auto____7008 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7008) {
            var and__3546__auto____7009 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7009) {
              var ret__7010 = true;
              var i__7011 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7012 = cljs.core.not.call(null, ret__7010);
                  if(or__3548__auto____7012) {
                    return or__3548__auto____7012
                  }else {
                    return i__7011 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7010
                }else {
                  var G__7013 = isa_QMARK_.call(null, h, child.call(null, i__7011), parent.call(null, i__7011));
                  var G__7014 = i__7011 + 1;
                  ret__7010 = G__7013;
                  i__7011 = G__7014;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7009
            }
          }else {
            return and__3546__auto____7008
          }
        }else {
          return and__3546__auto____7007
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7018 = "\ufdd0'parents".call(null, h);
    var td__7019 = "\ufdd0'descendants".call(null, h);
    var ta__7020 = "\ufdd0'ancestors".call(null, h);
    var tf__7021 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7022 = cljs.core.contains_QMARK_.call(null, tp__7018.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7020.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7020.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7018, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7021.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7019, parent, ta__7020), "\ufdd0'descendants":tf__7021.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7020, tag, td__7019)})
    }();
    if(cljs.core.truth_(or__3548__auto____7022)) {
      return or__3548__auto____7022
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7023 = "\ufdd0'parents".call(null, h);
    var childsParents__7024 = cljs.core.truth_(parentMap__7023.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7023.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7025 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7024)) ? cljs.core.assoc.call(null, parentMap__7023, tag, childsParents__7024) : cljs.core.dissoc.call(null, parentMap__7023, tag);
    var deriv_seq__7026 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7015_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7015_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7015_SHARP_), cljs.core.second.call(null, p1__7015_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7025)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7023.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7016_SHARP_, p2__7017_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7016_SHARP_, p2__7017_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7026))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7027 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7029 = cljs.core.truth_(function() {
    var and__3546__auto____7028 = xprefs__7027;
    if(cljs.core.truth_(and__3546__auto____7028)) {
      return xprefs__7027.call(null, y)
    }else {
      return and__3546__auto____7028
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7029)) {
    return or__3548__auto____7029
  }else {
    var or__3548__auto____7031 = function() {
      var ps__7030 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7030) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7030), prefer_table))) {
          }else {
          }
          var G__7034 = cljs.core.rest.call(null, ps__7030);
          ps__7030 = G__7034;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7031)) {
      return or__3548__auto____7031
    }else {
      var or__3548__auto____7033 = function() {
        var ps__7032 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7032) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7032), y, prefer_table))) {
            }else {
            }
            var G__7035 = cljs.core.rest.call(null, ps__7032);
            ps__7032 = G__7035;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7033)) {
        return or__3548__auto____7033
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7036 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7036)) {
    return or__3548__auto____7036
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7045 = cljs.core.reduce.call(null, function(be, p__7037) {
    var vec__7038__7039 = p__7037;
    var k__7040 = cljs.core.nth.call(null, vec__7038__7039, 0, null);
    var ___7041 = cljs.core.nth.call(null, vec__7038__7039, 1, null);
    var e__7042 = vec__7038__7039;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7040)) {
      var be2__7044 = cljs.core.truth_(function() {
        var or__3548__auto____7043 = be == null;
        if(or__3548__auto____7043) {
          return or__3548__auto____7043
        }else {
          return cljs.core.dominates.call(null, k__7040, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7042 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7044), k__7040, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7040), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7044)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7044
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7045)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7045));
      return cljs.core.second.call(null, best_entry__7045)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7046 = mf;
    if(and__3546__auto____7046) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7046
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7047 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7047) {
        return or__3548__auto____7047
      }else {
        var or__3548__auto____7048 = cljs.core._reset["_"];
        if(or__3548__auto____7048) {
          return or__3548__auto____7048
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7049 = mf;
    if(and__3546__auto____7049) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7049
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7050 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7050) {
        return or__3548__auto____7050
      }else {
        var or__3548__auto____7051 = cljs.core._add_method["_"];
        if(or__3548__auto____7051) {
          return or__3548__auto____7051
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7052 = mf;
    if(and__3546__auto____7052) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7052
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7053 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7053) {
        return or__3548__auto____7053
      }else {
        var or__3548__auto____7054 = cljs.core._remove_method["_"];
        if(or__3548__auto____7054) {
          return or__3548__auto____7054
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7055 = mf;
    if(and__3546__auto____7055) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7055
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7056 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7056) {
        return or__3548__auto____7056
      }else {
        var or__3548__auto____7057 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7057) {
          return or__3548__auto____7057
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7058 = mf;
    if(and__3546__auto____7058) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7058
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7059 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7059) {
        return or__3548__auto____7059
      }else {
        var or__3548__auto____7060 = cljs.core._get_method["_"];
        if(or__3548__auto____7060) {
          return or__3548__auto____7060
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7061 = mf;
    if(and__3546__auto____7061) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7061
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7062 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7062) {
        return or__3548__auto____7062
      }else {
        var or__3548__auto____7063 = cljs.core._methods["_"];
        if(or__3548__auto____7063) {
          return or__3548__auto____7063
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7064 = mf;
    if(and__3546__auto____7064) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7064
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7065 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7065) {
        return or__3548__auto____7065
      }else {
        var or__3548__auto____7066 = cljs.core._prefers["_"];
        if(or__3548__auto____7066) {
          return or__3548__auto____7066
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7067 = mf;
    if(and__3546__auto____7067) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7067
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7068 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7068) {
        return or__3548__auto____7068
      }else {
        var or__3548__auto____7069 = cljs.core._dispatch["_"];
        if(or__3548__auto____7069) {
          return or__3548__auto____7069
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7070 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7071 = cljs.core._get_method.call(null, mf, dispatch_val__7070);
  if(cljs.core.truth_(target_fn__7071)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7070)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7071, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7072 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7073 = this;
  cljs.core.swap_BANG_.call(null, this__7073.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7073.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7073.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7073.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7074 = this;
  cljs.core.swap_BANG_.call(null, this__7074.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7074.method_cache, this__7074.method_table, this__7074.cached_hierarchy, this__7074.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7075 = this;
  cljs.core.swap_BANG_.call(null, this__7075.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7075.method_cache, this__7075.method_table, this__7075.cached_hierarchy, this__7075.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7076 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7076.cached_hierarchy), cljs.core.deref.call(null, this__7076.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7076.method_cache, this__7076.method_table, this__7076.cached_hierarchy, this__7076.hierarchy)
  }
  var temp__3695__auto____7077 = cljs.core.deref.call(null, this__7076.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7077)) {
    var target_fn__7078 = temp__3695__auto____7077;
    return target_fn__7078
  }else {
    var temp__3695__auto____7079 = cljs.core.find_and_cache_best_method.call(null, this__7076.name, dispatch_val, this__7076.hierarchy, this__7076.method_table, this__7076.prefer_table, this__7076.method_cache, this__7076.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7079)) {
      var target_fn__7080 = temp__3695__auto____7079;
      return target_fn__7080
    }else {
      return cljs.core.deref.call(null, this__7076.method_table).call(null, this__7076.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7081 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7081.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7081.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7081.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7081.method_cache, this__7081.method_table, this__7081.cached_hierarchy, this__7081.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7082 = this;
  return cljs.core.deref.call(null, this__7082.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7083 = this;
  return cljs.core.deref.call(null, this__7083.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7084 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7084.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7085__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7085 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7085__delegate.call(this, _, args)
  };
  G__7085.cljs$lang$maxFixedArity = 1;
  G__7085.cljs$lang$applyTo = function(arglist__7086) {
    var _ = cljs.core.first(arglist__7086);
    var args = cljs.core.rest(arglist__7086);
    return G__7085__delegate(_, args)
  };
  G__7085.cljs$lang$arity$variadic = G__7085__delegate;
  return G__7085
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7088 = reader;
    if(and__3546__auto____7088) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7088
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7089 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7089) {
        return or__3548__auto____7089
      }else {
        var or__3548__auto____7090 = cljs.reader.read_char["_"];
        if(or__3548__auto____7090) {
          return or__3548__auto____7090
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7091 = reader;
    if(and__3546__auto____7091) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7091
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7092 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7092) {
        return or__3548__auto____7092
      }else {
        var or__3548__auto____7093 = cljs.reader.unread["_"];
        if(or__3548__auto____7093) {
          return or__3548__auto____7093
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7094 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7094.buffer_atom))) {
    var idx__7095 = cljs.core.deref.call(null, this__7094.index_atom);
    cljs.core.swap_BANG_.call(null, this__7094.index_atom, cljs.core.inc);
    return this__7094.s[idx__7095]
  }else {
    var buf__7096 = cljs.core.deref.call(null, this__7094.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7094.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7096)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7097 = this;
  return cljs.core.swap_BANG_.call(null, this__7097.buffer_atom, function(p1__7087_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7087_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7098 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7098)) {
    return or__3548__auto____7098
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7099 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7099) {
    return or__3548__auto____7099
  }else {
    var and__3546__auto____7101 = function() {
      var or__3548__auto____7100 = "+" === initch;
      if(or__3548__auto____7100) {
        return or__3548__auto____7100
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7101)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7102 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7102);
        return next_ch__7102
      }())
    }else {
      return and__3546__auto____7101
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7103) {
    var rdr = cljs.core.first(arglist__7103);
    var msg = cljs.core.rest(arglist__7103);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7104 = ch != "#";
  if(and__3546__auto____7104) {
    var and__3546__auto____7105 = ch != "'";
    if(and__3546__auto____7105) {
      var and__3546__auto____7106 = ch != ":";
      if(and__3546__auto____7106) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7106
      }
    }else {
      return and__3546__auto____7105
    }
  }else {
    return and__3546__auto____7104
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7107 = new goog.string.StringBuffer(initch);
  var ch__7108 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7109 = ch__7108 == null;
      if(or__3548__auto____7109) {
        return or__3548__auto____7109
      }else {
        var or__3548__auto____7110 = cljs.reader.whitespace_QMARK_.call(null, ch__7108);
        if(or__3548__auto____7110) {
          return or__3548__auto____7110
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7108)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7108);
      return sb__7107.toString()
    }else {
      var G__7111 = function() {
        sb__7107.append(ch__7108);
        return sb__7107
      }();
      var G__7112 = cljs.reader.read_char.call(null, rdr);
      sb__7107 = G__7111;
      ch__7108 = G__7112;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7113 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7114 = ch__7113 === "n";
      if(or__3548__auto____7114) {
        return or__3548__auto____7114
      }else {
        var or__3548__auto____7115 = ch__7113 === "r";
        if(or__3548__auto____7115) {
          return or__3548__auto____7115
        }else {
          return ch__7113 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7116 = re.exec(s);
  if(matches__7116 != null) {
    if(matches__7116.length === 1) {
      return matches__7116[0]
    }else {
      return matches__7116
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7117 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7118 = groups__7117[2];
  if(!function() {
    var or__3548__auto____7119 = group3__7118 == null;
    if(or__3548__auto____7119) {
      return or__3548__auto____7119
    }else {
      return group3__7118.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7120 = "-" === groups__7117[1] ? -1 : 1;
    var a__7121 = cljs.core.truth_(groups__7117[3]) ? [groups__7117[3], 10] : cljs.core.truth_(groups__7117[4]) ? [groups__7117[4], 16] : cljs.core.truth_(groups__7117[5]) ? [groups__7117[5], 8] : cljs.core.truth_(groups__7117[7]) ? [groups__7117[7], parseInt(groups__7117[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7122 = a__7121[0];
    var radix__7123 = a__7121[1];
    if(n__7122 == null) {
      return null
    }else {
      return negate__7120 * parseInt(n__7122, radix__7123)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7124 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7125 = groups__7124[1];
  var denominator__7126 = groups__7124[2];
  return parseInt(numinator__7125) / parseInt(denominator__7126)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7127 = re.exec(s);
  if(function() {
    var and__3546__auto____7128 = matches__7127 != null;
    if(and__3546__auto____7128) {
      return matches__7127[0] === s
    }else {
      return and__3546__auto____7128
    }
  }()) {
    if(matches__7127.length === 1) {
      return matches__7127[0]
    }else {
      return matches__7127
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7129 = cljs.reader.read_char.call(null, reader);
  var mapresult__7130 = cljs.reader.escape_char_map.call(null, ch__7129);
  if(cljs.core.truth_(mapresult__7130)) {
    return mapresult__7130
  }else {
    if(function() {
      var or__3548__auto____7131 = "u" === ch__7129;
      if(or__3548__auto____7131) {
        return or__3548__auto____7131
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7129)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7129)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7129)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7132 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7132))) {
      var G__7133 = cljs.reader.read_char.call(null, rdr);
      ch__7132 = G__7133;
      continue
    }else {
      return ch__7132
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7134 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7135 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7135)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7135) {
      return cljs.core.persistent_BANG_.call(null, a__7134)
    }else {
      var temp__3695__auto____7136 = cljs.reader.macros.call(null, ch__7135);
      if(cljs.core.truth_(temp__3695__auto____7136)) {
        var macrofn__7137 = temp__3695__auto____7136;
        var mret__7138 = macrofn__7137.call(null, rdr, ch__7135);
        var G__7140 = mret__7138 === rdr ? a__7134 : cljs.core.conj_BANG_.call(null, a__7134, mret__7138);
        a__7134 = G__7140;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7135);
        var o__7139 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7141 = o__7139 === rdr ? a__7134 : cljs.core.conj_BANG_.call(null, a__7134, o__7139);
        a__7134 = G__7141;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7142 = cljs.reader.read_char.call(null, rdr);
  var dm__7143 = cljs.reader.dispatch_macros.call(null, ch__7142);
  if(cljs.core.truth_(dm__7143)) {
    return dm__7143.call(null, rdr, _)
  }else {
    var temp__3695__auto____7144 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7142);
    if(cljs.core.truth_(temp__3695__auto____7144)) {
      var obj__7145 = temp__3695__auto____7144;
      return obj__7145
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7142)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7146 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7146))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7146)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7147 = new goog.string.StringBuffer(initch);
  var ch__7148 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7149 = ch__7148 == null;
      if(or__3548__auto____7149) {
        return or__3548__auto____7149
      }else {
        var or__3548__auto____7150 = cljs.reader.whitespace_QMARK_.call(null, ch__7148);
        if(or__3548__auto____7150) {
          return or__3548__auto____7150
        }else {
          return cljs.reader.macros.call(null, ch__7148)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7148);
      var s__7151 = buffer__7147.toString();
      var or__3548__auto____7152 = cljs.reader.match_number.call(null, s__7151);
      if(cljs.core.truth_(or__3548__auto____7152)) {
        return or__3548__auto____7152
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7151, "]")
      }
    }else {
      var G__7153 = function() {
        buffer__7147.append(ch__7148);
        return buffer__7147
      }();
      var G__7154 = cljs.reader.read_char.call(null, reader);
      buffer__7147 = G__7153;
      ch__7148 = G__7154;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7155 = new goog.string.StringBuffer;
  var ch__7156 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7156 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7156) {
        var G__7157 = function() {
          buffer__7155.append(cljs.reader.escape_char.call(null, buffer__7155, reader));
          return buffer__7155
        }();
        var G__7158 = cljs.reader.read_char.call(null, reader);
        buffer__7155 = G__7157;
        ch__7156 = G__7158;
        continue
      }else {
        if('"' === ch__7156) {
          return buffer__7155.toString()
        }else {
          if("\ufdd0'default") {
            var G__7159 = function() {
              buffer__7155.append(ch__7156);
              return buffer__7155
            }();
            var G__7160 = cljs.reader.read_char.call(null, reader);
            buffer__7155 = G__7159;
            ch__7156 = G__7160;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7161 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7161, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7161, 0, token__7161.indexOf("/")), cljs.core.subs.call(null, token__7161, token__7161.indexOf("/") + 1, token__7161.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7161, cljs.core.symbol.call(null, token__7161))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7162 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7163 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7162);
  var token__7164 = a__7163[0];
  var ns__7165 = a__7163[1];
  var name__7166 = a__7163[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7168 = function() {
      var and__3546__auto____7167 = !(void 0 === ns__7165);
      if(and__3546__auto____7167) {
        return ns__7165.substring(ns__7165.length - 2, ns__7165.length) === ":/"
      }else {
        return and__3546__auto____7167
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7168)) {
      return or__3548__auto____7168
    }else {
      var or__3548__auto____7169 = name__7166[name__7166.length - 1] === ":";
      if(or__3548__auto____7169) {
        return or__3548__auto____7169
      }else {
        return!(token__7164.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7164)
  }else {
    if(cljs.core.truth_(ns__7165)) {
      return cljs.core.keyword.call(null, ns__7165.substring(0, ns__7165.indexOf("/")), name__7166)
    }else {
      return cljs.core.keyword.call(null, token__7164)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7170 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7170)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7171 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7172__7173 = o__7171;
    if(G__7172__7173 != null) {
      if(function() {
        var or__3548__auto____7174 = G__7172__7173.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7174) {
          return or__3548__auto____7174
        }else {
          return G__7172__7173.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7172__7173.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7172__7173)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7172__7173)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7171, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7171), m__7170))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7175 = cljs.reader.read_char.call(null, reader);
    if(ch__7175 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7175)) {
        var G__7178 = reader;
        var G__7179 = eof_is_error;
        var G__7180 = sentinel;
        var G__7181 = is_recursive;
        reader = G__7178;
        eof_is_error = G__7179;
        sentinel = G__7180;
        is_recursive = G__7181;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7175)) {
          var G__7182 = cljs.reader.read_comment.call(null, reader, ch__7175);
          var G__7183 = eof_is_error;
          var G__7184 = sentinel;
          var G__7185 = is_recursive;
          reader = G__7182;
          eof_is_error = G__7183;
          sentinel = G__7184;
          is_recursive = G__7185;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7176 = cljs.reader.macros.call(null, ch__7175);
            var res__7177 = cljs.core.truth_(f__7176) ? f__7176.call(null, reader, ch__7175) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7175) ? cljs.reader.read_number.call(null, reader, ch__7175) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7175) : null;
            if(res__7177 === reader) {
              var G__7186 = reader;
              var G__7187 = eof_is_error;
              var G__7188 = sentinel;
              var G__7189 = is_recursive;
              reader = G__7186;
              eof_is_error = G__7187;
              sentinel = G__7188;
              is_recursive = G__7189;
              continue
            }else {
              return res__7177
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7190 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7190, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7191 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7192 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7193 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7191));
  if(cljs.core.truth_(pfn__7193)) {
    return pfn__7193.call(null, form__7192)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7191), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7194 = cljs.core.name.call(null, tag);
  var old_parser__7195 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7194);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7194, f);
  return old_parser__7195
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7293 = s;
      var limit__7294 = limit;
      var parts__7295 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7294, 1)) {
          return cljs.core.conj.call(null, parts__7295, s__7293)
        }else {
          var temp__3695__auto____7296 = cljs.core.re_find.call(null, re, s__7293);
          if(cljs.core.truth_(temp__3695__auto____7296)) {
            var m__7297 = temp__3695__auto____7296;
            var index__7298 = s__7293.indexOf(m__7297);
            var G__7299 = s__7293.substring(index__7298 + cljs.core.count.call(null, m__7297));
            var G__7300 = limit__7294 - 1;
            var G__7301 = cljs.core.conj.call(null, parts__7295, s__7293.substring(0, index__7298));
            s__7293 = G__7299;
            limit__7294 = G__7300;
            parts__7295 = G__7301;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7295, s__7293)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7302 = s.length;
  while(true) {
    if(index__7302 === 0) {
      return""
    }else {
      var ch__7303 = cljs.core.get.call(null, s, index__7302 - 1);
      if(function() {
        var or__3548__auto____7304 = cljs.core._EQ_.call(null, ch__7303, "\n");
        if(or__3548__auto____7304) {
          return or__3548__auto____7304
        }else {
          return cljs.core._EQ_.call(null, ch__7303, "\r")
        }
      }()) {
        var G__7305 = index__7302 - 1;
        index__7302 = G__7305;
        continue
      }else {
        return s.substring(0, index__7302)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7306 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7307 = cljs.core.not.call(null, s__7306);
    if(or__3548__auto____7307) {
      return or__3548__auto____7307
    }else {
      var or__3548__auto____7308 = cljs.core._EQ_.call(null, "", s__7306);
      if(or__3548__auto____7308) {
        return or__3548__auto____7308
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7306)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7309 = new goog.string.StringBuffer;
  var length__7310 = s.length;
  var index__7311 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7310, index__7311)) {
      return buffer__7309.toString()
    }else {
      var ch__7312 = s.charAt(index__7311);
      var temp__3695__auto____7313 = cljs.core.get.call(null, cmap, ch__7312);
      if(cljs.core.truth_(temp__3695__auto____7313)) {
        var replacement__7314 = temp__3695__auto____7313;
        buffer__7309.append([cljs.core.str(replacement__7314)].join(""))
      }else {
        buffer__7309.append(ch__7312)
      }
      var G__7315 = index__7311 + 1;
      index__7311 = G__7315;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7264 = {};
  var G__7265__7266 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7265__7266)) {
    var G__7268__7270 = cljs.core.first.call(null, G__7265__7266);
    var vec__7269__7271 = G__7268__7270;
    var k__7272 = cljs.core.nth.call(null, vec__7269__7271, 0, null);
    var v__7273 = cljs.core.nth.call(null, vec__7269__7271, 1, null);
    var G__7265__7274 = G__7265__7266;
    var G__7268__7275 = G__7268__7270;
    var G__7265__7276 = G__7265__7274;
    while(true) {
      var vec__7277__7278 = G__7268__7275;
      var k__7279 = cljs.core.nth.call(null, vec__7277__7278, 0, null);
      var v__7280 = cljs.core.nth.call(null, vec__7277__7278, 1, null);
      var G__7265__7281 = G__7265__7276;
      out__7264[cljs.core.name.call(null, k__7279)] = v__7280;
      var temp__3698__auto____7282 = cljs.core.next.call(null, G__7265__7281);
      if(cljs.core.truth_(temp__3698__auto____7282)) {
        var G__7265__7283 = temp__3698__auto____7282;
        var G__7284 = cljs.core.first.call(null, G__7265__7283);
        var G__7285 = G__7265__7283;
        G__7268__7275 = G__7284;
        G__7265__7276 = G__7285;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7264
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7286 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7286)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7287) {
    var v = cljs.core.first(arglist__7287);
    var text = cljs.core.rest(arglist__7287);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7288) {
          var vec__7289__7290 = p__7288;
          var k__7291 = cljs.core.nth.call(null, vec__7289__7290, 0, null);
          var v__7292 = cljs.core.nth.call(null, vec__7289__7290, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7291), clj__GT_js.call(null, v__7292))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      return[cljs.core.str("[crateGroup="), cljs.core.str(jayq.core.crate_meta.call(null, sel)), cljs.core.str("]")].join("")
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7196) {
    var vec__7197__7198 = p__7196;
    var context__7199 = cljs.core.nth.call(null, vec__7197__7198, 0, null);
    if(cljs.core.not.call(null, context__7199)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7199)
    }
  };
  var $ = function(sel, var_args) {
    var p__7196 = null;
    if(goog.isDef(var_args)) {
      p__7196 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7196)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7200) {
    var sel = cljs.core.first(arglist__7200);
    var p__7196 = cljs.core.rest(arglist__7200);
    return $__delegate(sel, p__7196)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, jayq.core.coll, f, cljs.core.first.call(null, this$), cljs.core.count.call(null, this$))
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, jayq.core.coll, f, start, jayq.core.i)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7201 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7201)) {
    return or__3548__auto____7201
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.slice(0, 1)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7202 = null;
  var G__7202__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7202__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7202 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7202__2.call(this, _, k);
      case 3:
        return G__7202__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7202
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.map__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.map__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7203) {
    var vec__7204__7205 = p__7203;
    var v__7206 = cljs.core.nth.call(null, vec__7204__7205, 0, null);
    var a__7207 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7206)) {
      return $elem.attr(a__7207)
    }else {
      return $elem.attr(a__7207, v__7206)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7203 = null;
    if(goog.isDef(var_args)) {
      p__7203 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7203)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7208) {
    var $elem = cljs.core.first(arglist__7208);
    var a = cljs.core.first(cljs.core.next(arglist__7208));
    var p__7203 = cljs.core.rest(cljs.core.next(arglist__7208));
    return attr__delegate($elem, a, p__7203)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7209) {
    var vec__7210__7211 = p__7209;
    var v__7212 = cljs.core.nth.call(null, vec__7210__7211, 0, null);
    var k__7213 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7212)) {
      return $elem.data(k__7213)
    }else {
      return $elem.data(k__7213, v__7212)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7209 = null;
    if(goog.isDef(var_args)) {
      p__7209 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7209)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7214) {
    var $elem = cljs.core.first(arglist__7214);
    var k = cljs.core.first(cljs.core.next(arglist__7214));
    var p__7209 = cljs.core.rest(cljs.core.next(arglist__7214));
    return data__delegate($elem, k, p__7209)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7215 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7215)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7216 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7216)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7217) {
    var vec__7218__7219 = p__7217;
    var speed__7220 = cljs.core.nth.call(null, vec__7218__7219, 0, null);
    var on_finish__7221 = cljs.core.nth.call(null, vec__7218__7219, 1, null);
    return $elem.hide(speed__7220, on_finish__7221)
  };
  var hide = function($elem, var_args) {
    var p__7217 = null;
    if(goog.isDef(var_args)) {
      p__7217 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7217)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7222) {
    var $elem = cljs.core.first(arglist__7222);
    var p__7217 = cljs.core.rest(arglist__7222);
    return hide__delegate($elem, p__7217)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7223) {
    var vec__7224__7225 = p__7223;
    var speed__7226 = cljs.core.nth.call(null, vec__7224__7225, 0, null);
    var on_finish__7227 = cljs.core.nth.call(null, vec__7224__7225, 1, null);
    return $elem.show(speed__7226, on_finish__7227)
  };
  var show = function($elem, var_args) {
    var p__7223 = null;
    if(goog.isDef(var_args)) {
      p__7223 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7223)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7228) {
    var $elem = cljs.core.first(arglist__7228);
    var p__7223 = cljs.core.rest(arglist__7228);
    return show__delegate($elem, p__7223)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7229) {
    var vec__7230__7231 = p__7229;
    var speed__7232 = cljs.core.nth.call(null, vec__7230__7231, 0, null);
    var on_finish__7233 = cljs.core.nth.call(null, vec__7230__7231, 1, null);
    return $elem.fadeOut(speed__7232, on_finish__7233)
  };
  var fade_out = function($elem, var_args) {
    var p__7229 = null;
    if(goog.isDef(var_args)) {
      p__7229 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7229)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7234) {
    var $elem = cljs.core.first(arglist__7234);
    var p__7229 = cljs.core.rest(arglist__7234);
    return fade_out__delegate($elem, p__7229)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7235) {
    var vec__7236__7237 = p__7235;
    var speed__7238 = cljs.core.nth.call(null, vec__7236__7237, 0, null);
    var on_finish__7239 = cljs.core.nth.call(null, vec__7236__7237, 1, null);
    return $elem.fadeIn(speed__7238, on_finish__7239)
  };
  var fade_in = function($elem, var_args) {
    var p__7235 = null;
    if(goog.isDef(var_args)) {
      p__7235 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7235)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7240) {
    var $elem = cljs.core.first(arglist__7240);
    var p__7235 = cljs.core.rest(arglist__7240);
    return fade_in__delegate($elem, p__7235)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7241) {
    var vec__7242__7243 = p__7241;
    var speed__7244 = cljs.core.nth.call(null, vec__7242__7243, 0, null);
    var on_finish__7245 = cljs.core.nth.call(null, vec__7242__7243, 1, null);
    return $elem.slideUp(speed__7244, on_finish__7245)
  };
  var slide_up = function($elem, var_args) {
    var p__7241 = null;
    if(goog.isDef(var_args)) {
      p__7241 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7241)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7246) {
    var $elem = cljs.core.first(arglist__7246);
    var p__7241 = cljs.core.rest(arglist__7246);
    return slide_up__delegate($elem, p__7241)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7247) {
    var vec__7248__7249 = p__7247;
    var speed__7250 = cljs.core.nth.call(null, vec__7248__7249, 0, null);
    var on_finish__7251 = cljs.core.nth.call(null, vec__7248__7249, 1, null);
    return $elem.slideDown(speed__7250, on_finish__7251)
  };
  var slide_down = function($elem, var_args) {
    var p__7247 = null;
    if(goog.isDef(var_args)) {
      p__7247 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7247)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7252) {
    var $elem = cljs.core.first(arglist__7252);
    var p__7247 = cljs.core.rest(arglist__7252);
    return slide_down__delegate($elem, p__7247)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7253) {
    var vec__7254__7255 = p__7253;
    var v__7256 = cljs.core.nth.call(null, vec__7254__7255, 0, null);
    if(cljs.core.truth_(v__7256)) {
      return $elem.val(v__7256)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7253 = null;
    if(goog.isDef(var_args)) {
      p__7253 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7253)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7257) {
    var $elem = cljs.core.first(arglist__7257);
    var p__7253 = cljs.core.rest(arglist__7257);
    return val__delegate($elem, p__7253)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.xhr = function xhr(p__7258, content, callback) {
  var vec__7259__7260 = p__7258;
  var method__7261 = cljs.core.nth.call(null, vec__7259__7260, 0, null);
  var uri__7262 = cljs.core.nth.call(null, vec__7259__7260, 1, null);
  var params__7263 = jayq.util.map__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7261)), "\ufdd0'data":jayq.util.map__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7262, params__7263)
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4638 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4637_SHARP_) {
    return out__4638[cljs.core.name.call(null, cljs.core.first.call(null, p1__4637_SHARP_))] = cljs.core.second.call(null, p1__4637_SHARP_)
  }, cljmap));
  return out__4638
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4639 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4639) {
    return or__3548__auto____4639
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx) {
  if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
    return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
  }else {
    return cljsbinding.translate.call(null, eval(fnstr).call(null))
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  var bindingname__4640 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4641 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname__4640)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname__4640).call(null, elem, cljsbinding.valuefn.call(null, elem, fname__4641, ctx))
    }
  }else {
    return function() {
      return elem[bindingname__4640].call(elem, cljsbinding.valuefn.call(null, elem, fname__4641, ctx))
    }
  }
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_elem = function bind_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4642__4643 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4642__4643)) {
    var data__4644 = cljs.core.first.call(null, G__4642__4643);
    var G__4642__4645 = G__4642__4643;
    while(true) {
      cljsbinding.bind_elem.call(null, elem, data__4644.split(":"), ctx);
      var temp__3698__auto____4646 = cljs.core.next.call(null, G__4642__4645);
      if(cljs.core.truth_(temp__3698__auto____4646)) {
        var G__4642__4647 = temp__3698__auto____4646;
        var G__4648 = cljs.core.first.call(null, G__4642__4647);
        var G__4649 = G__4642__4647;
        data__4644 = G__4648;
        G__4642__4645 = G__4649;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem) {
  var aval__4651 = cljs.core.deref.call(null, eval(jayq.core.attr.call(null, elem, "bindatom")));
  if(cljs.core.map_QMARK_.call(null, aval__4651)) {
    return aval__4651.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4651
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4650_SHARP_) {
      return cljs.core.assoc.call(null, p1__4650_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.is(":checked"));
    return false
  })
};
cljsbinding.bindatom = function bindatom(elem) {
  if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
    return cljsbinding.bind_checkbox_atom.call(null, elem)
  }else {
    return cljsbinding.bind_input_atom.call(null, elem)
  }
};
cljsbinding.bindall = function bindall(parent, ctx) {
  var seqs__4653 = parent.find("*[bindseq]");
  var seqparents__4654 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__4652_SHARP_) {
    return p1__4652_SHARP_.parent()
  }, parent.find("*[bindseq]")));
  var G__4655__4656 = cljs.core.seq.call(null, seqs__4653);
  if(cljs.core.truth_(G__4655__4656)) {
    var elem__4657 = cljs.core.first.call(null, G__4655__4656);
    var G__4655__4658 = G__4655__4656;
    while(true) {
      jayq.core.remove.call(null, elem__4657);
      var temp__3698__auto____4659 = cljs.core.next.call(null, G__4655__4658);
      if(cljs.core.truth_(temp__3698__auto____4659)) {
        var G__4655__4660 = temp__3698__auto____4659;
        var G__4698 = cljs.core.first.call(null, G__4655__4660);
        var G__4699 = G__4655__4660;
        elem__4657 = G__4698;
        G__4655__4658 = G__4699;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4661__4662 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4661__4662)) {
    var elem__4663 = cljs.core.first.call(null, G__4661__4662);
    var G__4661__4664 = G__4661__4662;
    while(true) {
      cljsbinding.bind.call(null, elem__4663, ctx);
      var temp__3698__auto____4665 = cljs.core.next.call(null, G__4661__4664);
      if(cljs.core.truth_(temp__3698__auto____4665)) {
        var G__4661__4666 = temp__3698__auto____4665;
        var G__4700 = cljs.core.first.call(null, G__4661__4666);
        var G__4701 = G__4661__4666;
        elem__4663 = G__4700;
        G__4661__4664 = G__4701;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4667__4668 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4667__4668)) {
    var elem__4669 = cljs.core.first.call(null, G__4667__4668);
    var G__4667__4670 = G__4667__4668;
    while(true) {
      cljsbinding.bind.call(null, elem__4669, ctx);
      var temp__3698__auto____4671 = cljs.core.next.call(null, G__4667__4670);
      if(cljs.core.truth_(temp__3698__auto____4671)) {
        var G__4667__4672 = temp__3698__auto____4671;
        var G__4702 = cljs.core.first.call(null, G__4667__4672);
        var G__4703 = G__4667__4672;
        elem__4669 = G__4702;
        G__4667__4670 = G__4703;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4673__4674 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4673__4674)) {
    var elem__4675 = cljs.core.first.call(null, G__4673__4674);
    var G__4673__4676 = G__4673__4674;
    while(true) {
      cljsbinding.bindatom.call(null, elem__4675);
      var temp__3698__auto____4677 = cljs.core.next.call(null, G__4673__4676);
      if(cljs.core.truth_(temp__3698__auto____4677)) {
        var G__4673__4678 = temp__3698__auto____4677;
        var G__4704 = cljs.core.first.call(null, G__4673__4678);
        var G__4705 = G__4673__4678;
        elem__4675 = G__4704;
        G__4673__4676 = G__4705;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4679__4680 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4653, seqparents__4654));
  if(cljs.core.truth_(G__4679__4680)) {
    var G__4682__4684 = cljs.core.first.call(null, G__4679__4680);
    var vec__4683__4685 = G__4682__4684;
    var elem__4686 = cljs.core.nth.call(null, vec__4683__4685, 0, null);
    var parent__4687 = cljs.core.nth.call(null, vec__4683__4685, 1, null);
    var G__4679__4688 = G__4679__4680;
    var G__4682__4689 = G__4682__4684;
    var G__4679__4690 = G__4679__4688;
    while(true) {
      var vec__4691__4692 = G__4682__4689;
      var elem__4693 = cljs.core.nth.call(null, vec__4691__4692, 0, null);
      var parent__4694 = cljs.core.nth.call(null, vec__4691__4692, 1, null);
      var G__4679__4695 = G__4679__4690;
      cljsbinding.bindseq.call(null, elem__4693, parent__4694);
      var temp__3698__auto____4696 = cljs.core.next.call(null, G__4679__4695);
      if(cljs.core.truth_(temp__3698__auto____4696)) {
        var G__4679__4697 = temp__3698__auto____4696;
        var G__4706 = cljs.core.first.call(null, G__4679__4697);
        var G__4707 = G__4679__4697;
        G__4682__4689 = G__4706;
        G__4679__4690 = G__4707;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem) {
  jayq.core.append.call(null, parent, elem);
  return cljsbinding.bindall.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template) {
  jayq.core.remove.call(null, parent.children());
  var G__4708__4709 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4708__4709)) {
    var item__4710 = cljs.core.first.call(null, G__4708__4709);
    var G__4708__4711 = G__4708__4709;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4710, template.clone());
      var temp__3698__auto____4712 = cljs.core.next.call(null, G__4708__4711);
      if(cljs.core.truth_(temp__3698__auto____4712)) {
        var G__4708__4713 = temp__3698__auto____4712;
        var G__4714 = cljs.core.first.call(null, G__4708__4713);
        var G__4715 = G__4708__4713;
        item__4710 = G__4714;
        G__4708__4711 = G__4715;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent) {
  var atom__4716 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4716), elparent, elem);
  return cljs.core.add_watch.call(null, atom__4716, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem)
  })
};
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4717_SHARP_, p2__4718_SHARP_) {
      var or__3548__auto____4721 = p1__4717_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4721)) {
        return or__3548__auto____4721
      }else {
        return p2__4718_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4719_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4719_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, function(p1__4720_SHARP_) {
    return cljs.core.assoc.call(null, p1__4720_SHARP_, atom, cljs.core.contains_QMARK_.call(null, p1__4720_SHARP_, atom) ? cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), p1__4720_SHARP_.call(null, atom)) : cljs.core.PersistentVector.fromArray([cljs.core.deref.call(null, cljsbinding.BindFn)]))
  });
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", function(key, a, old_val, new_val) {
    var G__4722__4723 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
    if(cljs.core.truth_(G__4722__4723)) {
      var f__4724 = cljs.core.first.call(null, G__4722__4723);
      var G__4722__4725 = G__4722__4723;
      while(true) {
        f__4724.call(null);
        var temp__3698__auto____4726 = cljs.core.next.call(null, G__4722__4725);
        if(cljs.core.truth_(temp__3698__auto____4726)) {
          var G__4722__4727 = temp__3698__auto____4726;
          var G__4728 = cljs.core.first.call(null, G__4722__4727);
          var G__4729 = G__4722__4727;
          f__4724 = G__4728;
          G__4722__4725 = G__4729;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  });
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.boot = function boot() {
  return eval("    \n    var deref = cljs.core.deref\n    cljs.core.deref = function (a) {\n     if (deref(cljsbinding.BindMonitor))\n       cljsbinding.register(a)\n     return deref(a)\n    }\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4730 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4730), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4730)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4730)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4730)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4730))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, localStorage[name]))
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
