var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4765__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4765 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4765__delegate.call(this, array, i, idxs)
    };
    G__4765.cljs$lang$maxFixedArity = 2;
    G__4765.cljs$lang$applyTo = function(arglist__4766) {
      var array = cljs.core.first(arglist__4766);
      var i = cljs.core.first(cljs.core.next(arglist__4766));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4766));
      return G__4765__delegate(array, i, idxs)
    };
    G__4765.cljs$lang$arity$variadic = G__4765__delegate;
    return G__4765
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4767 = this$;
      if(and__3546__auto____4767) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4767
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4768 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4768) {
          return or__3548__auto____4768
        }else {
          var or__3548__auto____4769 = cljs.core._invoke["_"];
          if(or__3548__auto____4769) {
            return or__3548__auto____4769
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4770 = this$;
      if(and__3546__auto____4770) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4770
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4771 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4771) {
          return or__3548__auto____4771
        }else {
          var or__3548__auto____4772 = cljs.core._invoke["_"];
          if(or__3548__auto____4772) {
            return or__3548__auto____4772
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4773 = this$;
      if(and__3546__auto____4773) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4773
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4774 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4774) {
          return or__3548__auto____4774
        }else {
          var or__3548__auto____4775 = cljs.core._invoke["_"];
          if(or__3548__auto____4775) {
            return or__3548__auto____4775
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4776 = this$;
      if(and__3546__auto____4776) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4776
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4777 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4777) {
          return or__3548__auto____4777
        }else {
          var or__3548__auto____4778 = cljs.core._invoke["_"];
          if(or__3548__auto____4778) {
            return or__3548__auto____4778
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4779 = this$;
      if(and__3546__auto____4779) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4779
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4780 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4780) {
          return or__3548__auto____4780
        }else {
          var or__3548__auto____4781 = cljs.core._invoke["_"];
          if(or__3548__auto____4781) {
            return or__3548__auto____4781
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4782 = this$;
      if(and__3546__auto____4782) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4782
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4783 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4783) {
          return or__3548__auto____4783
        }else {
          var or__3548__auto____4784 = cljs.core._invoke["_"];
          if(or__3548__auto____4784) {
            return or__3548__auto____4784
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4785 = this$;
      if(and__3546__auto____4785) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4785
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4786 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4786) {
          return or__3548__auto____4786
        }else {
          var or__3548__auto____4787 = cljs.core._invoke["_"];
          if(or__3548__auto____4787) {
            return or__3548__auto____4787
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4788 = this$;
      if(and__3546__auto____4788) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4788
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4789 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4789) {
          return or__3548__auto____4789
        }else {
          var or__3548__auto____4790 = cljs.core._invoke["_"];
          if(or__3548__auto____4790) {
            return or__3548__auto____4790
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4791 = this$;
      if(and__3546__auto____4791) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4791
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4792 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4792) {
          return or__3548__auto____4792
        }else {
          var or__3548__auto____4793 = cljs.core._invoke["_"];
          if(or__3548__auto____4793) {
            return or__3548__auto____4793
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4794 = this$;
      if(and__3546__auto____4794) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4794
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4795 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4795) {
          return or__3548__auto____4795
        }else {
          var or__3548__auto____4796 = cljs.core._invoke["_"];
          if(or__3548__auto____4796) {
            return or__3548__auto____4796
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4797 = this$;
      if(and__3546__auto____4797) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4797
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4798 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4798) {
          return or__3548__auto____4798
        }else {
          var or__3548__auto____4799 = cljs.core._invoke["_"];
          if(or__3548__auto____4799) {
            return or__3548__auto____4799
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4800 = this$;
      if(and__3546__auto____4800) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4800
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4801 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4801) {
          return or__3548__auto____4801
        }else {
          var or__3548__auto____4802 = cljs.core._invoke["_"];
          if(or__3548__auto____4802) {
            return or__3548__auto____4802
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4803 = this$;
      if(and__3546__auto____4803) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4803
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4804 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4804) {
          return or__3548__auto____4804
        }else {
          var or__3548__auto____4805 = cljs.core._invoke["_"];
          if(or__3548__auto____4805) {
            return or__3548__auto____4805
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4806 = this$;
      if(and__3546__auto____4806) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4806
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4807 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4807) {
          return or__3548__auto____4807
        }else {
          var or__3548__auto____4808 = cljs.core._invoke["_"];
          if(or__3548__auto____4808) {
            return or__3548__auto____4808
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4809 = this$;
      if(and__3546__auto____4809) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4809
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4810 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4810) {
          return or__3548__auto____4810
        }else {
          var or__3548__auto____4811 = cljs.core._invoke["_"];
          if(or__3548__auto____4811) {
            return or__3548__auto____4811
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4812 = this$;
      if(and__3546__auto____4812) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4812
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4813 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4813) {
          return or__3548__auto____4813
        }else {
          var or__3548__auto____4814 = cljs.core._invoke["_"];
          if(or__3548__auto____4814) {
            return or__3548__auto____4814
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4815 = this$;
      if(and__3546__auto____4815) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4815
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4816 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4816) {
          return or__3548__auto____4816
        }else {
          var or__3548__auto____4817 = cljs.core._invoke["_"];
          if(or__3548__auto____4817) {
            return or__3548__auto____4817
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____4818 = this$;
      if(and__3546__auto____4818) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____4818
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____4819 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4819) {
          return or__3548__auto____4819
        }else {
          var or__3548__auto____4820 = cljs.core._invoke["_"];
          if(or__3548__auto____4820) {
            return or__3548__auto____4820
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____4821 = this$;
      if(and__3546__auto____4821) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____4821
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____4822 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4822) {
          return or__3548__auto____4822
        }else {
          var or__3548__auto____4823 = cljs.core._invoke["_"];
          if(or__3548__auto____4823) {
            return or__3548__auto____4823
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____4824 = this$;
      if(and__3546__auto____4824) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____4824
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____4825 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4825) {
          return or__3548__auto____4825
        }else {
          var or__3548__auto____4826 = cljs.core._invoke["_"];
          if(or__3548__auto____4826) {
            return or__3548__auto____4826
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____4827 = this$;
      if(and__3546__auto____4827) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____4827
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____4828 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4828) {
          return or__3548__auto____4828
        }else {
          var or__3548__auto____4829 = cljs.core._invoke["_"];
          if(or__3548__auto____4829) {
            return or__3548__auto____4829
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____4830 = coll;
    if(and__3546__auto____4830) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____4830
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4831 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4831) {
        return or__3548__auto____4831
      }else {
        var or__3548__auto____4832 = cljs.core._count["_"];
        if(or__3548__auto____4832) {
          return or__3548__auto____4832
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____4833 = coll;
    if(and__3546__auto____4833) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____4833
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4834 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4834) {
        return or__3548__auto____4834
      }else {
        var or__3548__auto____4835 = cljs.core._empty["_"];
        if(or__3548__auto____4835) {
          return or__3548__auto____4835
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____4836 = coll;
    if(and__3546__auto____4836) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____4836
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____4837 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4837) {
        return or__3548__auto____4837
      }else {
        var or__3548__auto____4838 = cljs.core._conj["_"];
        if(or__3548__auto____4838) {
          return or__3548__auto____4838
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____4839 = coll;
      if(and__3546__auto____4839) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____4839
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____4840 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4840) {
          return or__3548__auto____4840
        }else {
          var or__3548__auto____4841 = cljs.core._nth["_"];
          if(or__3548__auto____4841) {
            return or__3548__auto____4841
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____4842 = coll;
      if(and__3546__auto____4842) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____4842
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____4843 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4843) {
          return or__3548__auto____4843
        }else {
          var or__3548__auto____4844 = cljs.core._nth["_"];
          if(or__3548__auto____4844) {
            return or__3548__auto____4844
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____4845 = coll;
    if(and__3546__auto____4845) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____4845
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4846 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4846) {
        return or__3548__auto____4846
      }else {
        var or__3548__auto____4847 = cljs.core._first["_"];
        if(or__3548__auto____4847) {
          return or__3548__auto____4847
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____4848 = coll;
    if(and__3546__auto____4848) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____4848
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4849 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4849) {
        return or__3548__auto____4849
      }else {
        var or__3548__auto____4850 = cljs.core._rest["_"];
        if(or__3548__auto____4850) {
          return or__3548__auto____4850
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____4851 = o;
      if(and__3546__auto____4851) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____4851
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____4852 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4852) {
          return or__3548__auto____4852
        }else {
          var or__3548__auto____4853 = cljs.core._lookup["_"];
          if(or__3548__auto____4853) {
            return or__3548__auto____4853
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____4854 = o;
      if(and__3546__auto____4854) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____4854
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____4855 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4855) {
          return or__3548__auto____4855
        }else {
          var or__3548__auto____4856 = cljs.core._lookup["_"];
          if(or__3548__auto____4856) {
            return or__3548__auto____4856
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____4857 = coll;
    if(and__3546__auto____4857) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____4857
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4858 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4858) {
        return or__3548__auto____4858
      }else {
        var or__3548__auto____4859 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____4859) {
          return or__3548__auto____4859
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____4860 = coll;
    if(and__3546__auto____4860) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____4860
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____4861 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4861) {
        return or__3548__auto____4861
      }else {
        var or__3548__auto____4862 = cljs.core._assoc["_"];
        if(or__3548__auto____4862) {
          return or__3548__auto____4862
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____4863 = coll;
    if(and__3546__auto____4863) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____4863
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4864 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4864) {
        return or__3548__auto____4864
      }else {
        var or__3548__auto____4865 = cljs.core._dissoc["_"];
        if(or__3548__auto____4865) {
          return or__3548__auto____4865
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____4866 = coll;
    if(and__3546__auto____4866) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____4866
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4867 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4867) {
        return or__3548__auto____4867
      }else {
        var or__3548__auto____4868 = cljs.core._key["_"];
        if(or__3548__auto____4868) {
          return or__3548__auto____4868
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____4869 = coll;
    if(and__3546__auto____4869) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____4869
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4870 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4870) {
        return or__3548__auto____4870
      }else {
        var or__3548__auto____4871 = cljs.core._val["_"];
        if(or__3548__auto____4871) {
          return or__3548__auto____4871
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____4872 = coll;
    if(and__3546__auto____4872) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____4872
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____4873 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4873) {
        return or__3548__auto____4873
      }else {
        var or__3548__auto____4874 = cljs.core._disjoin["_"];
        if(or__3548__auto____4874) {
          return or__3548__auto____4874
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____4875 = coll;
    if(and__3546__auto____4875) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____4875
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4876 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4876) {
        return or__3548__auto____4876
      }else {
        var or__3548__auto____4877 = cljs.core._peek["_"];
        if(or__3548__auto____4877) {
          return or__3548__auto____4877
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____4878 = coll;
    if(and__3546__auto____4878) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____4878
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4879 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4879) {
        return or__3548__auto____4879
      }else {
        var or__3548__auto____4880 = cljs.core._pop["_"];
        if(or__3548__auto____4880) {
          return or__3548__auto____4880
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____4881 = coll;
    if(and__3546__auto____4881) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____4881
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____4882 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4882) {
        return or__3548__auto____4882
      }else {
        var or__3548__auto____4883 = cljs.core._assoc_n["_"];
        if(or__3548__auto____4883) {
          return or__3548__auto____4883
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____4884 = o;
    if(and__3546__auto____4884) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____4884
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4885 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____4885) {
        return or__3548__auto____4885
      }else {
        var or__3548__auto____4886 = cljs.core._deref["_"];
        if(or__3548__auto____4886) {
          return or__3548__auto____4886
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____4887 = o;
    if(and__3546__auto____4887) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____4887
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____4888 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____4888) {
        return or__3548__auto____4888
      }else {
        var or__3548__auto____4889 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____4889) {
          return or__3548__auto____4889
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____4890 = o;
    if(and__3546__auto____4890) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____4890
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4891 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4891) {
        return or__3548__auto____4891
      }else {
        var or__3548__auto____4892 = cljs.core._meta["_"];
        if(or__3548__auto____4892) {
          return or__3548__auto____4892
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____4893 = o;
    if(and__3546__auto____4893) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____4893
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____4894 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4894) {
        return or__3548__auto____4894
      }else {
        var or__3548__auto____4895 = cljs.core._with_meta["_"];
        if(or__3548__auto____4895) {
          return or__3548__auto____4895
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____4896 = coll;
      if(and__3546__auto____4896) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____4896
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____4897 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4897) {
          return or__3548__auto____4897
        }else {
          var or__3548__auto____4898 = cljs.core._reduce["_"];
          if(or__3548__auto____4898) {
            return or__3548__auto____4898
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____4899 = coll;
      if(and__3546__auto____4899) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____4899
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____4900 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4900) {
          return or__3548__auto____4900
        }else {
          var or__3548__auto____4901 = cljs.core._reduce["_"];
          if(or__3548__auto____4901) {
            return or__3548__auto____4901
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____4902 = coll;
    if(and__3546__auto____4902) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____4902
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____4903 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4903) {
        return or__3548__auto____4903
      }else {
        var or__3548__auto____4904 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____4904) {
          return or__3548__auto____4904
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____4905 = o;
    if(and__3546__auto____4905) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____4905
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____4906 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____4906) {
        return or__3548__auto____4906
      }else {
        var or__3548__auto____4907 = cljs.core._equiv["_"];
        if(or__3548__auto____4907) {
          return or__3548__auto____4907
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____4908 = o;
    if(and__3546__auto____4908) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____4908
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4909 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____4909) {
        return or__3548__auto____4909
      }else {
        var or__3548__auto____4910 = cljs.core._hash["_"];
        if(or__3548__auto____4910) {
          return or__3548__auto____4910
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____4911 = o;
    if(and__3546__auto____4911) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____4911
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4912 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4912) {
        return or__3548__auto____4912
      }else {
        var or__3548__auto____4913 = cljs.core._seq["_"];
        if(or__3548__auto____4913) {
          return or__3548__auto____4913
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____4914 = coll;
    if(and__3546__auto____4914) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____4914
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4915 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4915) {
        return or__3548__auto____4915
      }else {
        var or__3548__auto____4916 = cljs.core._rseq["_"];
        if(or__3548__auto____4916) {
          return or__3548__auto____4916
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4917 = coll;
    if(and__3546__auto____4917) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____4917
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4918 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4918) {
        return or__3548__auto____4918
      }else {
        var or__3548__auto____4919 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____4919) {
          return or__3548__auto____4919
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4920 = coll;
    if(and__3546__auto____4920) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____4920
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4921 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4921) {
        return or__3548__auto____4921
      }else {
        var or__3548__auto____4922 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____4922) {
          return or__3548__auto____4922
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____4923 = coll;
    if(and__3546__auto____4923) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____4923
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____4924 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4924) {
        return or__3548__auto____4924
      }else {
        var or__3548__auto____4925 = cljs.core._entry_key["_"];
        if(or__3548__auto____4925) {
          return or__3548__auto____4925
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____4926 = coll;
    if(and__3546__auto____4926) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____4926
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4927 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4927) {
        return or__3548__auto____4927
      }else {
        var or__3548__auto____4928 = cljs.core._comparator["_"];
        if(or__3548__auto____4928) {
          return or__3548__auto____4928
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____4929 = o;
    if(and__3546__auto____4929) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____4929
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____4930 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4930) {
        return or__3548__auto____4930
      }else {
        var or__3548__auto____4931 = cljs.core._pr_seq["_"];
        if(or__3548__auto____4931) {
          return or__3548__auto____4931
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____4932 = d;
    if(and__3546__auto____4932) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____4932
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____4933 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____4933) {
        return or__3548__auto____4933
      }else {
        var or__3548__auto____4934 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____4934) {
          return or__3548__auto____4934
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____4935 = this$;
    if(and__3546__auto____4935) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____4935
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____4936 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4936) {
        return or__3548__auto____4936
      }else {
        var or__3548__auto____4937 = cljs.core._notify_watches["_"];
        if(or__3548__auto____4937) {
          return or__3548__auto____4937
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____4938 = this$;
    if(and__3546__auto____4938) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____4938
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____4939 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4939) {
        return or__3548__auto____4939
      }else {
        var or__3548__auto____4940 = cljs.core._add_watch["_"];
        if(or__3548__auto____4940) {
          return or__3548__auto____4940
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____4941 = this$;
    if(and__3546__auto____4941) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____4941
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____4942 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4942) {
        return or__3548__auto____4942
      }else {
        var or__3548__auto____4943 = cljs.core._remove_watch["_"];
        if(or__3548__auto____4943) {
          return or__3548__auto____4943
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____4944 = coll;
    if(and__3546__auto____4944) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____4944
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4945 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4945) {
        return or__3548__auto____4945
      }else {
        var or__3548__auto____4946 = cljs.core._as_transient["_"];
        if(or__3548__auto____4946) {
          return or__3548__auto____4946
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____4947 = tcoll;
    if(and__3546__auto____4947) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____4947
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____4948 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4948) {
        return or__3548__auto____4948
      }else {
        var or__3548__auto____4949 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____4949) {
          return or__3548__auto____4949
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4950 = tcoll;
    if(and__3546__auto____4950) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____4950
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4951 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4951) {
        return or__3548__auto____4951
      }else {
        var or__3548__auto____4952 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____4952) {
          return or__3548__auto____4952
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____4953 = tcoll;
    if(and__3546__auto____4953) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____4953
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____4954 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4954) {
        return or__3548__auto____4954
      }else {
        var or__3548__auto____4955 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____4955) {
          return or__3548__auto____4955
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____4956 = tcoll;
    if(and__3546__auto____4956) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____4956
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____4957 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4957) {
        return or__3548__auto____4957
      }else {
        var or__3548__auto____4958 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____4958) {
          return or__3548__auto____4958
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____4959 = tcoll;
    if(and__3546__auto____4959) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____4959
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____4960 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4960) {
        return or__3548__auto____4960
      }else {
        var or__3548__auto____4961 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____4961) {
          return or__3548__auto____4961
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4962 = tcoll;
    if(and__3546__auto____4962) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____4962
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4963 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4963) {
        return or__3548__auto____4963
      }else {
        var or__3548__auto____4964 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____4964) {
          return or__3548__auto____4964
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____4965 = tcoll;
    if(and__3546__auto____4965) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____4965
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____4966 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4966) {
        return or__3548__auto____4966
      }else {
        var or__3548__auto____4967 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____4967) {
          return or__3548__auto____4967
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____4968 = x === y;
    if(or__3548__auto____4968) {
      return or__3548__auto____4968
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__4969__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__4970 = y;
            var G__4971 = cljs.core.first.call(null, more);
            var G__4972 = cljs.core.next.call(null, more);
            x = G__4970;
            y = G__4971;
            more = G__4972;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__4969 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4969__delegate.call(this, x, y, more)
    };
    G__4969.cljs$lang$maxFixedArity = 2;
    G__4969.cljs$lang$applyTo = function(arglist__4973) {
      var x = cljs.core.first(arglist__4973);
      var y = cljs.core.first(cljs.core.next(arglist__4973));
      var more = cljs.core.rest(cljs.core.next(arglist__4973));
      return G__4969__delegate(x, y, more)
    };
    G__4969.cljs$lang$arity$variadic = G__4969__delegate;
    return G__4969
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____4974 = x == null;
    if(or__3548__auto____4974) {
      return or__3548__auto____4974
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__4975 = null;
  var G__4975__2 = function(o, k) {
    return null
  };
  var G__4975__3 = function(o, k, not_found) {
    return not_found
  };
  G__4975 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4975__2.call(this, o, k);
      case 3:
        return G__4975__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4975
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__4976 = null;
  var G__4976__2 = function(_, f) {
    return f.call(null)
  };
  var G__4976__3 = function(_, f, start) {
    return start
  };
  G__4976 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4976__2.call(this, _, f);
      case 3:
        return G__4976__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4976
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__4977 = null;
  var G__4977__2 = function(_, n) {
    return null
  };
  var G__4977__3 = function(_, n, not_found) {
    return not_found
  };
  G__4977 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4977__2.call(this, _, n);
      case 3:
        return G__4977__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4977
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__4978 = cljs.core._nth.call(null, cicoll, 0);
      var n__4979 = 1;
      while(true) {
        if(n__4979 < cljs.core._count.call(null, cicoll)) {
          var nval__4980 = f.call(null, val__4978, cljs.core._nth.call(null, cicoll, n__4979));
          if(cljs.core.reduced_QMARK_.call(null, nval__4980)) {
            return cljs.core.deref.call(null, nval__4980)
          }else {
            var G__4987 = nval__4980;
            var G__4988 = n__4979 + 1;
            val__4978 = G__4987;
            n__4979 = G__4988;
            continue
          }
        }else {
          return val__4978
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__4981 = val;
    var n__4982 = 0;
    while(true) {
      if(n__4982 < cljs.core._count.call(null, cicoll)) {
        var nval__4983 = f.call(null, val__4981, cljs.core._nth.call(null, cicoll, n__4982));
        if(cljs.core.reduced_QMARK_.call(null, nval__4983)) {
          return cljs.core.deref.call(null, nval__4983)
        }else {
          var G__4989 = nval__4983;
          var G__4990 = n__4982 + 1;
          val__4981 = G__4989;
          n__4982 = G__4990;
          continue
        }
      }else {
        return val__4981
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__4984 = val;
    var n__4985 = idx;
    while(true) {
      if(n__4985 < cljs.core._count.call(null, cicoll)) {
        var nval__4986 = f.call(null, val__4984, cljs.core._nth.call(null, cicoll, n__4985));
        if(cljs.core.reduced_QMARK_.call(null, nval__4986)) {
          return cljs.core.deref.call(null, nval__4986)
        }else {
          var G__4991 = nval__4986;
          var G__4992 = n__4985 + 1;
          val__4984 = G__4991;
          n__4985 = G__4992;
          continue
        }
      }else {
        return val__4984
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__4993 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__4994 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__4995 = this;
  var this$__4996 = this;
  return cljs.core.pr_str.call(null, this$__4996)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__4997 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4997.a)) {
    return cljs.core.ci_reduce.call(null, this__4997.a, f, this__4997.a[this__4997.i], this__4997.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__4997.a[this__4997.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__4998 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4998.a)) {
    return cljs.core.ci_reduce.call(null, this__4998.a, f, start, this__4998.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__4999 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__5000 = this;
  return this__5000.a.length - this__5000.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5001 = this;
  return this__5001.a[this__5001.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5002 = this;
  if(this__5002.i + 1 < this__5002.a.length) {
    return new cljs.core.IndexedSeq(this__5002.a, this__5002.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5003 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5004 = this;
  var i__5005 = n + this__5004.i;
  if(i__5005 < this__5004.a.length) {
    return this__5004.a[i__5005]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5006 = this;
  var i__5007 = n + this__5006.i;
  if(i__5007 < this__5006.a.length) {
    return this__5006.a[i__5007]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5008 = null;
  var G__5008__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5008__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5008 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5008__2.call(this, array, f);
      case 3:
        return G__5008__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5008
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5009 = null;
  var G__5009__2 = function(array, k) {
    return array[k]
  };
  var G__5009__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5009 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5009__2.call(this, array, k);
      case 3:
        return G__5009__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5009
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5010 = null;
  var G__5010__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5010__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5010 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5010__2.call(this, array, n);
      case 3:
        return G__5010__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5010
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5011__5012 = coll;
      if(G__5011__5012 != null) {
        if(function() {
          var or__3548__auto____5013 = G__5011__5012.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5013) {
            return or__3548__auto____5013
          }else {
            return G__5011__5012.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5011__5012.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5011__5012)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5011__5012)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5014__5015 = coll;
      if(G__5014__5015 != null) {
        if(function() {
          var or__3548__auto____5016 = G__5014__5015.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5016) {
            return or__3548__auto____5016
          }else {
            return G__5014__5015.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5014__5015.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5014__5015)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5014__5015)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5017 = cljs.core.seq.call(null, coll);
      if(s__5017 != null) {
        return cljs.core._first.call(null, s__5017)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5018__5019 = coll;
      if(G__5018__5019 != null) {
        if(function() {
          var or__3548__auto____5020 = G__5018__5019.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5020) {
            return or__3548__auto____5020
          }else {
            return G__5018__5019.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5018__5019.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5018__5019)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5018__5019)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5021 = cljs.core.seq.call(null, coll);
      if(s__5021 != null) {
        return cljs.core._rest.call(null, s__5021)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5022__5023 = coll;
      if(G__5022__5023 != null) {
        if(function() {
          var or__3548__auto____5024 = G__5022__5023.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5024) {
            return or__3548__auto____5024
          }else {
            return G__5022__5023.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5022__5023.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5022__5023)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5022__5023)
      }
    }()) {
      var coll__5025 = cljs.core._rest.call(null, coll);
      if(coll__5025 != null) {
        if(function() {
          var G__5026__5027 = coll__5025;
          if(G__5026__5027 != null) {
            if(function() {
              var or__3548__auto____5028 = G__5026__5027.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5028) {
                return or__3548__auto____5028
              }else {
                return G__5026__5027.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5026__5027.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5026__5027)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5026__5027)
          }
        }()) {
          return coll__5025
        }else {
          return cljs.core._seq.call(null, coll__5025)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5029 = cljs.core.next.call(null, s);
      s = G__5029;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5030__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5031 = conj.call(null, coll, x);
          var G__5032 = cljs.core.first.call(null, xs);
          var G__5033 = cljs.core.next.call(null, xs);
          coll = G__5031;
          x = G__5032;
          xs = G__5033;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5030 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5030__delegate.call(this, coll, x, xs)
    };
    G__5030.cljs$lang$maxFixedArity = 2;
    G__5030.cljs$lang$applyTo = function(arglist__5034) {
      var coll = cljs.core.first(arglist__5034);
      var x = cljs.core.first(cljs.core.next(arglist__5034));
      var xs = cljs.core.rest(cljs.core.next(arglist__5034));
      return G__5030__delegate(coll, x, xs)
    };
    G__5030.cljs$lang$arity$variadic = G__5030__delegate;
    return G__5030
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5035 = cljs.core.seq.call(null, coll);
  var acc__5036 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5035)) {
      return acc__5036 + cljs.core._count.call(null, s__5035)
    }else {
      var G__5037 = cljs.core.next.call(null, s__5035);
      var G__5038 = acc__5036 + 1;
      s__5035 = G__5037;
      acc__5036 = G__5038;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5039__5040 = coll;
        if(G__5039__5040 != null) {
          if(function() {
            var or__3548__auto____5041 = G__5039__5040.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5041) {
              return or__3548__auto____5041
            }else {
              return G__5039__5040.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5039__5040.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5039__5040)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5039__5040)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5042__5043 = coll;
        if(G__5042__5043 != null) {
          if(function() {
            var or__3548__auto____5044 = G__5042__5043.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5044) {
              return or__3548__auto____5044
            }else {
              return G__5042__5043.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5042__5043.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5042__5043)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5042__5043)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5046__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5045 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5047 = ret__5045;
          var G__5048 = cljs.core.first.call(null, kvs);
          var G__5049 = cljs.core.second.call(null, kvs);
          var G__5050 = cljs.core.nnext.call(null, kvs);
          coll = G__5047;
          k = G__5048;
          v = G__5049;
          kvs = G__5050;
          continue
        }else {
          return ret__5045
        }
        break
      }
    };
    var G__5046 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5046__delegate.call(this, coll, k, v, kvs)
    };
    G__5046.cljs$lang$maxFixedArity = 3;
    G__5046.cljs$lang$applyTo = function(arglist__5051) {
      var coll = cljs.core.first(arglist__5051);
      var k = cljs.core.first(cljs.core.next(arglist__5051));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5051)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5051)));
      return G__5046__delegate(coll, k, v, kvs)
    };
    G__5046.cljs$lang$arity$variadic = G__5046__delegate;
    return G__5046
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5053__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5052 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5054 = ret__5052;
          var G__5055 = cljs.core.first.call(null, ks);
          var G__5056 = cljs.core.next.call(null, ks);
          coll = G__5054;
          k = G__5055;
          ks = G__5056;
          continue
        }else {
          return ret__5052
        }
        break
      }
    };
    var G__5053 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5053__delegate.call(this, coll, k, ks)
    };
    G__5053.cljs$lang$maxFixedArity = 2;
    G__5053.cljs$lang$applyTo = function(arglist__5057) {
      var coll = cljs.core.first(arglist__5057);
      var k = cljs.core.first(cljs.core.next(arglist__5057));
      var ks = cljs.core.rest(cljs.core.next(arglist__5057));
      return G__5053__delegate(coll, k, ks)
    };
    G__5053.cljs$lang$arity$variadic = G__5053__delegate;
    return G__5053
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5058__5059 = o;
    if(G__5058__5059 != null) {
      if(function() {
        var or__3548__auto____5060 = G__5058__5059.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5060) {
          return or__3548__auto____5060
        }else {
          return G__5058__5059.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5058__5059.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5058__5059)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5058__5059)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5062__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5061 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5063 = ret__5061;
          var G__5064 = cljs.core.first.call(null, ks);
          var G__5065 = cljs.core.next.call(null, ks);
          coll = G__5063;
          k = G__5064;
          ks = G__5065;
          continue
        }else {
          return ret__5061
        }
        break
      }
    };
    var G__5062 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5062__delegate.call(this, coll, k, ks)
    };
    G__5062.cljs$lang$maxFixedArity = 2;
    G__5062.cljs$lang$applyTo = function(arglist__5066) {
      var coll = cljs.core.first(arglist__5066);
      var k = cljs.core.first(cljs.core.next(arglist__5066));
      var ks = cljs.core.rest(cljs.core.next(arglist__5066));
      return G__5062__delegate(coll, k, ks)
    };
    G__5062.cljs$lang$arity$variadic = G__5062__delegate;
    return G__5062
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5067__5068 = x;
    if(G__5067__5068 != null) {
      if(function() {
        var or__3548__auto____5069 = G__5067__5068.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5069) {
          return or__3548__auto____5069
        }else {
          return G__5067__5068.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5067__5068.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5067__5068)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5067__5068)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5070__5071 = x;
    if(G__5070__5071 != null) {
      if(function() {
        var or__3548__auto____5072 = G__5070__5071.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5072) {
          return or__3548__auto____5072
        }else {
          return G__5070__5071.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5070__5071.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5070__5071)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5070__5071)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5073__5074 = x;
  if(G__5073__5074 != null) {
    if(function() {
      var or__3548__auto____5075 = G__5073__5074.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5075) {
        return or__3548__auto____5075
      }else {
        return G__5073__5074.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5073__5074.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5073__5074)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5073__5074)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5076__5077 = x;
  if(G__5076__5077 != null) {
    if(function() {
      var or__3548__auto____5078 = G__5076__5077.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5078) {
        return or__3548__auto____5078
      }else {
        return G__5076__5077.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5076__5077.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5076__5077)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5076__5077)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5079__5080 = x;
  if(G__5079__5080 != null) {
    if(function() {
      var or__3548__auto____5081 = G__5079__5080.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5081) {
        return or__3548__auto____5081
      }else {
        return G__5079__5080.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5079__5080.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5079__5080)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5079__5080)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5082__5083 = x;
  if(G__5082__5083 != null) {
    if(function() {
      var or__3548__auto____5084 = G__5082__5083.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5084) {
        return or__3548__auto____5084
      }else {
        return G__5082__5083.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5082__5083.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5082__5083)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5082__5083)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5085__5086 = x;
  if(G__5085__5086 != null) {
    if(function() {
      var or__3548__auto____5087 = G__5085__5086.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5087) {
        return or__3548__auto____5087
      }else {
        return G__5085__5086.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5085__5086.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5085__5086)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5085__5086)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5088__5089 = x;
    if(G__5088__5089 != null) {
      if(function() {
        var or__3548__auto____5090 = G__5088__5089.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5090) {
          return or__3548__auto____5090
        }else {
          return G__5088__5089.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5088__5089.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5088__5089)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5088__5089)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5091__5092 = x;
  if(G__5091__5092 != null) {
    if(function() {
      var or__3548__auto____5093 = G__5091__5092.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5093) {
        return or__3548__auto____5093
      }else {
        return G__5091__5092.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5091__5092.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5091__5092)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5091__5092)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5094__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5094 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5094__delegate.call(this, keyvals)
    };
    G__5094.cljs$lang$maxFixedArity = 0;
    G__5094.cljs$lang$applyTo = function(arglist__5095) {
      var keyvals = cljs.core.seq(arglist__5095);
      return G__5094__delegate(keyvals)
    };
    G__5094.cljs$lang$arity$variadic = G__5094__delegate;
    return G__5094
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5096 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5096.push(key)
  });
  return keys__5096
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5097 = i;
  var j__5098 = j;
  var len__5099 = len;
  while(true) {
    if(len__5099 === 0) {
      return to
    }else {
      to[j__5098] = from[i__5097];
      var G__5100 = i__5097 + 1;
      var G__5101 = j__5098 + 1;
      var G__5102 = len__5099 - 1;
      i__5097 = G__5100;
      j__5098 = G__5101;
      len__5099 = G__5102;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5103 = i + (len - 1);
  var j__5104 = j + (len - 1);
  var len__5105 = len;
  while(true) {
    if(len__5105 === 0) {
      return to
    }else {
      to[j__5104] = from[i__5103];
      var G__5106 = i__5103 - 1;
      var G__5107 = j__5104 - 1;
      var G__5108 = len__5105 - 1;
      i__5103 = G__5106;
      j__5104 = G__5107;
      len__5105 = G__5108;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5109__5110 = s;
    if(G__5109__5110 != null) {
      if(function() {
        var or__3548__auto____5111 = G__5109__5110.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5111) {
          return or__3548__auto____5111
        }else {
          return G__5109__5110.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5109__5110.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5109__5110)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5109__5110)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5112__5113 = s;
  if(G__5112__5113 != null) {
    if(function() {
      var or__3548__auto____5114 = G__5112__5113.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5114) {
        return or__3548__auto____5114
      }else {
        return G__5112__5113.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5112__5113.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5112__5113)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5112__5113)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5115 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5115)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5116 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5116) {
        return or__3548__auto____5116
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5115
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5117 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5117)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5117
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5118 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5118)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5118
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5119 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5119) {
    return or__3548__auto____5119
  }else {
    var G__5120__5121 = f;
    if(G__5120__5121 != null) {
      if(function() {
        var or__3548__auto____5122 = G__5120__5121.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5122) {
          return or__3548__auto____5122
        }else {
          return G__5120__5121.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5120__5121.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5120__5121)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5120__5121)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5123 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5123) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5123
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5124 = coll;
    if(cljs.core.truth_(and__3546__auto____5124)) {
      var and__3546__auto____5125 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5125) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5125
      }
    }else {
      return and__3546__auto____5124
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5130__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5126 = cljs.core.set([y, x]);
        var xs__5127 = more;
        while(true) {
          var x__5128 = cljs.core.first.call(null, xs__5127);
          var etc__5129 = cljs.core.next.call(null, xs__5127);
          if(cljs.core.truth_(xs__5127)) {
            if(cljs.core.contains_QMARK_.call(null, s__5126, x__5128)) {
              return false
            }else {
              var G__5131 = cljs.core.conj.call(null, s__5126, x__5128);
              var G__5132 = etc__5129;
              s__5126 = G__5131;
              xs__5127 = G__5132;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5130 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5130__delegate.call(this, x, y, more)
    };
    G__5130.cljs$lang$maxFixedArity = 2;
    G__5130.cljs$lang$applyTo = function(arglist__5133) {
      var x = cljs.core.first(arglist__5133);
      var y = cljs.core.first(cljs.core.next(arglist__5133));
      var more = cljs.core.rest(cljs.core.next(arglist__5133));
      return G__5130__delegate(x, y, more)
    };
    G__5130.cljs$lang$arity$variadic = G__5130__delegate;
    return G__5130
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5134 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5134)) {
        return r__5134
      }else {
        if(cljs.core.truth_(r__5134)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5135 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5135, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5135)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5136 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5136)) {
      var s__5137 = temp__3695__auto____5136;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5137), cljs.core.next.call(null, s__5137))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5138 = val;
    var coll__5139 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5139)) {
        var nval__5140 = f.call(null, val__5138, cljs.core.first.call(null, coll__5139));
        if(cljs.core.reduced_QMARK_.call(null, nval__5140)) {
          return cljs.core.deref.call(null, nval__5140)
        }else {
          var G__5141 = nval__5140;
          var G__5142 = cljs.core.next.call(null, coll__5139);
          val__5138 = G__5141;
          coll__5139 = G__5142;
          continue
        }
      }else {
        return val__5138
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5143__5144 = coll;
      if(G__5143__5144 != null) {
        if(function() {
          var or__3548__auto____5145 = G__5143__5144.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5145) {
            return or__3548__auto____5145
          }else {
            return G__5143__5144.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5143__5144.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5143__5144)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5143__5144)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5146__5147 = coll;
      if(G__5146__5147 != null) {
        if(function() {
          var or__3548__auto____5148 = G__5146__5147.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5148) {
            return or__3548__auto____5148
          }else {
            return G__5146__5147.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5146__5147.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5146__5147)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5146__5147)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5149 = this;
  return this__5149.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5150__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5150 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5150__delegate.call(this, x, y, more)
    };
    G__5150.cljs$lang$maxFixedArity = 2;
    G__5150.cljs$lang$applyTo = function(arglist__5151) {
      var x = cljs.core.first(arglist__5151);
      var y = cljs.core.first(cljs.core.next(arglist__5151));
      var more = cljs.core.rest(cljs.core.next(arglist__5151));
      return G__5150__delegate(x, y, more)
    };
    G__5150.cljs$lang$arity$variadic = G__5150__delegate;
    return G__5150
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5152__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5152 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5152__delegate.call(this, x, y, more)
    };
    G__5152.cljs$lang$maxFixedArity = 2;
    G__5152.cljs$lang$applyTo = function(arglist__5153) {
      var x = cljs.core.first(arglist__5153);
      var y = cljs.core.first(cljs.core.next(arglist__5153));
      var more = cljs.core.rest(cljs.core.next(arglist__5153));
      return G__5152__delegate(x, y, more)
    };
    G__5152.cljs$lang$arity$variadic = G__5152__delegate;
    return G__5152
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5154__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5154 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5154__delegate.call(this, x, y, more)
    };
    G__5154.cljs$lang$maxFixedArity = 2;
    G__5154.cljs$lang$applyTo = function(arglist__5155) {
      var x = cljs.core.first(arglist__5155);
      var y = cljs.core.first(cljs.core.next(arglist__5155));
      var more = cljs.core.rest(cljs.core.next(arglist__5155));
      return G__5154__delegate(x, y, more)
    };
    G__5154.cljs$lang$arity$variadic = G__5154__delegate;
    return G__5154
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5156__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5156 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5156__delegate.call(this, x, y, more)
    };
    G__5156.cljs$lang$maxFixedArity = 2;
    G__5156.cljs$lang$applyTo = function(arglist__5157) {
      var x = cljs.core.first(arglist__5157);
      var y = cljs.core.first(cljs.core.next(arglist__5157));
      var more = cljs.core.rest(cljs.core.next(arglist__5157));
      return G__5156__delegate(x, y, more)
    };
    G__5156.cljs$lang$arity$variadic = G__5156__delegate;
    return G__5156
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5158__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5159 = y;
            var G__5160 = cljs.core.first.call(null, more);
            var G__5161 = cljs.core.next.call(null, more);
            x = G__5159;
            y = G__5160;
            more = G__5161;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5158 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5158__delegate.call(this, x, y, more)
    };
    G__5158.cljs$lang$maxFixedArity = 2;
    G__5158.cljs$lang$applyTo = function(arglist__5162) {
      var x = cljs.core.first(arglist__5162);
      var y = cljs.core.first(cljs.core.next(arglist__5162));
      var more = cljs.core.rest(cljs.core.next(arglist__5162));
      return G__5158__delegate(x, y, more)
    };
    G__5158.cljs$lang$arity$variadic = G__5158__delegate;
    return G__5158
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5163__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5164 = y;
            var G__5165 = cljs.core.first.call(null, more);
            var G__5166 = cljs.core.next.call(null, more);
            x = G__5164;
            y = G__5165;
            more = G__5166;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5163 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5163__delegate.call(this, x, y, more)
    };
    G__5163.cljs$lang$maxFixedArity = 2;
    G__5163.cljs$lang$applyTo = function(arglist__5167) {
      var x = cljs.core.first(arglist__5167);
      var y = cljs.core.first(cljs.core.next(arglist__5167));
      var more = cljs.core.rest(cljs.core.next(arglist__5167));
      return G__5163__delegate(x, y, more)
    };
    G__5163.cljs$lang$arity$variadic = G__5163__delegate;
    return G__5163
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5168__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5169 = y;
            var G__5170 = cljs.core.first.call(null, more);
            var G__5171 = cljs.core.next.call(null, more);
            x = G__5169;
            y = G__5170;
            more = G__5171;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5168 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5168__delegate.call(this, x, y, more)
    };
    G__5168.cljs$lang$maxFixedArity = 2;
    G__5168.cljs$lang$applyTo = function(arglist__5172) {
      var x = cljs.core.first(arglist__5172);
      var y = cljs.core.first(cljs.core.next(arglist__5172));
      var more = cljs.core.rest(cljs.core.next(arglist__5172));
      return G__5168__delegate(x, y, more)
    };
    G__5168.cljs$lang$arity$variadic = G__5168__delegate;
    return G__5168
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5173__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5174 = y;
            var G__5175 = cljs.core.first.call(null, more);
            var G__5176 = cljs.core.next.call(null, more);
            x = G__5174;
            y = G__5175;
            more = G__5176;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5173 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5173__delegate.call(this, x, y, more)
    };
    G__5173.cljs$lang$maxFixedArity = 2;
    G__5173.cljs$lang$applyTo = function(arglist__5177) {
      var x = cljs.core.first(arglist__5177);
      var y = cljs.core.first(cljs.core.next(arglist__5177));
      var more = cljs.core.rest(cljs.core.next(arglist__5177));
      return G__5173__delegate(x, y, more)
    };
    G__5173.cljs$lang$arity$variadic = G__5173__delegate;
    return G__5173
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5178__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5178 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5178__delegate.call(this, x, y, more)
    };
    G__5178.cljs$lang$maxFixedArity = 2;
    G__5178.cljs$lang$applyTo = function(arglist__5179) {
      var x = cljs.core.first(arglist__5179);
      var y = cljs.core.first(cljs.core.next(arglist__5179));
      var more = cljs.core.rest(cljs.core.next(arglist__5179));
      return G__5178__delegate(x, y, more)
    };
    G__5178.cljs$lang$arity$variadic = G__5178__delegate;
    return G__5178
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5180__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5180 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5180__delegate.call(this, x, y, more)
    };
    G__5180.cljs$lang$maxFixedArity = 2;
    G__5180.cljs$lang$applyTo = function(arglist__5181) {
      var x = cljs.core.first(arglist__5181);
      var y = cljs.core.first(cljs.core.next(arglist__5181));
      var more = cljs.core.rest(cljs.core.next(arglist__5181));
      return G__5180__delegate(x, y, more)
    };
    G__5180.cljs$lang$arity$variadic = G__5180__delegate;
    return G__5180
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5182 = n % d;
  return cljs.core.fix.call(null, (n - rem__5182) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5183 = cljs.core.quot.call(null, n, d);
  return n - d * q__5183
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5184 = 0;
  var n__5185 = n;
  while(true) {
    if(n__5185 === 0) {
      return c__5184
    }else {
      var G__5186 = c__5184 + 1;
      var G__5187 = n__5185 & n__5185 - 1;
      c__5184 = G__5186;
      n__5185 = G__5187;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5188__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5189 = y;
            var G__5190 = cljs.core.first.call(null, more);
            var G__5191 = cljs.core.next.call(null, more);
            x = G__5189;
            y = G__5190;
            more = G__5191;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5188 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5188__delegate.call(this, x, y, more)
    };
    G__5188.cljs$lang$maxFixedArity = 2;
    G__5188.cljs$lang$applyTo = function(arglist__5192) {
      var x = cljs.core.first(arglist__5192);
      var y = cljs.core.first(cljs.core.next(arglist__5192));
      var more = cljs.core.rest(cljs.core.next(arglist__5192));
      return G__5188__delegate(x, y, more)
    };
    G__5188.cljs$lang$arity$variadic = G__5188__delegate;
    return G__5188
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5193 = n;
  var xs__5194 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5195 = xs__5194;
      if(cljs.core.truth_(and__3546__auto____5195)) {
        return n__5193 > 0
      }else {
        return and__3546__auto____5195
      }
    }())) {
      var G__5196 = n__5193 - 1;
      var G__5197 = cljs.core.next.call(null, xs__5194);
      n__5193 = G__5196;
      xs__5194 = G__5197;
      continue
    }else {
      return xs__5194
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5198__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5199 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5200 = cljs.core.next.call(null, more);
            sb = G__5199;
            more = G__5200;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5198 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5198__delegate.call(this, x, ys)
    };
    G__5198.cljs$lang$maxFixedArity = 1;
    G__5198.cljs$lang$applyTo = function(arglist__5201) {
      var x = cljs.core.first(arglist__5201);
      var ys = cljs.core.rest(arglist__5201);
      return G__5198__delegate(x, ys)
    };
    G__5198.cljs$lang$arity$variadic = G__5198__delegate;
    return G__5198
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5202__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5203 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5204 = cljs.core.next.call(null, more);
            sb = G__5203;
            more = G__5204;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5202 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5202__delegate.call(this, x, ys)
    };
    G__5202.cljs$lang$maxFixedArity = 1;
    G__5202.cljs$lang$applyTo = function(arglist__5205) {
      var x = cljs.core.first(arglist__5205);
      var ys = cljs.core.rest(arglist__5205);
      return G__5202__delegate(x, ys)
    };
    G__5202.cljs$lang$arity$variadic = G__5202__delegate;
    return G__5202
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5206 = cljs.core.seq.call(null, x);
    var ys__5207 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5206 == null) {
        return ys__5207 == null
      }else {
        if(ys__5207 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5206), cljs.core.first.call(null, ys__5207))) {
            var G__5208 = cljs.core.next.call(null, xs__5206);
            var G__5209 = cljs.core.next.call(null, ys__5207);
            xs__5206 = G__5208;
            ys__5207 = G__5209;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5210_SHARP_, p2__5211_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5210_SHARP_, cljs.core.hash.call(null, p2__5211_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5212 = 0;
  var s__5213 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5213)) {
      var e__5214 = cljs.core.first.call(null, s__5213);
      var G__5215 = (h__5212 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5214)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5214)))) % 4503599627370496;
      var G__5216 = cljs.core.next.call(null, s__5213);
      h__5212 = G__5215;
      s__5213 = G__5216;
      continue
    }else {
      return h__5212
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5217 = 0;
  var s__5218 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5218)) {
      var e__5219 = cljs.core.first.call(null, s__5218);
      var G__5220 = (h__5217 + cljs.core.hash.call(null, e__5219)) % 4503599627370496;
      var G__5221 = cljs.core.next.call(null, s__5218);
      h__5217 = G__5220;
      s__5218 = G__5221;
      continue
    }else {
      return h__5217
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5222__5223 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5222__5223)) {
    var G__5225__5227 = cljs.core.first.call(null, G__5222__5223);
    var vec__5226__5228 = G__5225__5227;
    var key_name__5229 = cljs.core.nth.call(null, vec__5226__5228, 0, null);
    var f__5230 = cljs.core.nth.call(null, vec__5226__5228, 1, null);
    var G__5222__5231 = G__5222__5223;
    var G__5225__5232 = G__5225__5227;
    var G__5222__5233 = G__5222__5231;
    while(true) {
      var vec__5234__5235 = G__5225__5232;
      var key_name__5236 = cljs.core.nth.call(null, vec__5234__5235, 0, null);
      var f__5237 = cljs.core.nth.call(null, vec__5234__5235, 1, null);
      var G__5222__5238 = G__5222__5233;
      var str_name__5239 = cljs.core.name.call(null, key_name__5236);
      obj[str_name__5239] = f__5237;
      var temp__3698__auto____5240 = cljs.core.next.call(null, G__5222__5238);
      if(cljs.core.truth_(temp__3698__auto____5240)) {
        var G__5222__5241 = temp__3698__auto____5240;
        var G__5242 = cljs.core.first.call(null, G__5222__5241);
        var G__5243 = G__5222__5241;
        G__5225__5232 = G__5242;
        G__5222__5233 = G__5243;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5244 = this;
  var h__364__auto____5245 = this__5244.__hash;
  if(h__364__auto____5245 != null) {
    return h__364__auto____5245
  }else {
    var h__364__auto____5246 = cljs.core.hash_coll.call(null, coll);
    this__5244.__hash = h__364__auto____5246;
    return h__364__auto____5246
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5247 = this;
  return new cljs.core.List(this__5247.meta, o, coll, this__5247.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5248 = this;
  var this$__5249 = this;
  return cljs.core.pr_str.call(null, this$__5249)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5250 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5251 = this;
  return this__5251.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5252 = this;
  return this__5252.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5253 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5254 = this;
  return this__5254.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5255 = this;
  return this__5255.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5256 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5257 = this;
  return new cljs.core.List(meta, this__5257.first, this__5257.rest, this__5257.count, this__5257.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5258 = this;
  return this__5258.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5259 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5260 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5261 = this;
  return new cljs.core.List(this__5261.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5262 = this;
  var this$__5263 = this;
  return cljs.core.pr_str.call(null, this$__5263)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5264 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5265 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5266 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5267 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5268 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5269 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5270 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5271 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5272 = this;
  return this__5272.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5273 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5274__5275 = coll;
  if(G__5274__5275 != null) {
    if(function() {
      var or__3548__auto____5276 = G__5274__5275.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5276) {
        return or__3548__auto____5276
      }else {
        return G__5274__5275.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5274__5275.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5274__5275)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5274__5275)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5277) {
    var items = cljs.core.seq(arglist__5277);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5278 = this;
  var h__364__auto____5279 = this__5278.__hash;
  if(h__364__auto____5279 != null) {
    return h__364__auto____5279
  }else {
    var h__364__auto____5280 = cljs.core.hash_coll.call(null, coll);
    this__5278.__hash = h__364__auto____5280;
    return h__364__auto____5280
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5281 = this;
  return new cljs.core.Cons(null, o, coll, this__5281.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5282 = this;
  var this$__5283 = this;
  return cljs.core.pr_str.call(null, this$__5283)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5284 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5285 = this;
  return this__5285.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5286 = this;
  if(this__5286.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5286.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5287 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5288 = this;
  return new cljs.core.Cons(meta, this__5288.first, this__5288.rest, this__5288.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5289 = this;
  return this__5289.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5290 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5290.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5291 = coll == null;
    if(or__3548__auto____5291) {
      return or__3548__auto____5291
    }else {
      var G__5292__5293 = coll;
      if(G__5292__5293 != null) {
        if(function() {
          var or__3548__auto____5294 = G__5292__5293.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5294) {
            return or__3548__auto____5294
          }else {
            return G__5292__5293.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5292__5293.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5292__5293)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5292__5293)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5295__5296 = x;
  if(G__5295__5296 != null) {
    if(function() {
      var or__3548__auto____5297 = G__5295__5296.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5297) {
        return or__3548__auto____5297
      }else {
        return G__5295__5296.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5295__5296.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5295__5296)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5295__5296)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5298 = null;
  var G__5298__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5298__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5298 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5298__2.call(this, string, f);
      case 3:
        return G__5298__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5298
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5299 = null;
  var G__5299__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5299__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5299 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5299__2.call(this, string, k);
      case 3:
        return G__5299__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5299
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5300 = null;
  var G__5300__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5300__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5300 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5300__2.call(this, string, n);
      case 3:
        return G__5300__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5300
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5309 = null;
  var G__5309__2 = function(tsym5303, coll) {
    var tsym5303__5305 = this;
    var this$__5306 = tsym5303__5305;
    return cljs.core.get.call(null, coll, this$__5306.toString())
  };
  var G__5309__3 = function(tsym5304, coll, not_found) {
    var tsym5304__5307 = this;
    var this$__5308 = tsym5304__5307;
    return cljs.core.get.call(null, coll, this$__5308.toString(), not_found)
  };
  G__5309 = function(tsym5304, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5309__2.call(this, tsym5304, coll);
      case 3:
        return G__5309__3.call(this, tsym5304, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5309
}();
String.prototype.apply = function(tsym5301, args5302) {
  return tsym5301.call.apply(tsym5301, [tsym5301].concat(cljs.core.aclone.call(null, args5302)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5310 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5310
  }else {
    lazy_seq.x = x__5310.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5311 = this;
  var h__364__auto____5312 = this__5311.__hash;
  if(h__364__auto____5312 != null) {
    return h__364__auto____5312
  }else {
    var h__364__auto____5313 = cljs.core.hash_coll.call(null, coll);
    this__5311.__hash = h__364__auto____5313;
    return h__364__auto____5313
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5314 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5315 = this;
  var this$__5316 = this;
  return cljs.core.pr_str.call(null, this$__5316)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5317 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5318 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5319 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5320 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5321 = this;
  return new cljs.core.LazySeq(meta, this__5321.realized, this__5321.x, this__5321.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5322 = this;
  return this__5322.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5323 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5323.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5324 = [];
  var s__5325 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5325))) {
      ary__5324.push(cljs.core.first.call(null, s__5325));
      var G__5326 = cljs.core.next.call(null, s__5325);
      s__5325 = G__5326;
      continue
    }else {
      return ary__5324
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5327 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5328 = 0;
  var xs__5329 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5329)) {
      ret__5327[i__5328] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5329));
      var G__5330 = i__5328 + 1;
      var G__5331 = cljs.core.next.call(null, xs__5329);
      i__5328 = G__5330;
      xs__5329 = G__5331;
      continue
    }else {
    }
    break
  }
  return ret__5327
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5332 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5333 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5334 = 0;
      var s__5335 = s__5333;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5336 = s__5335;
          if(cljs.core.truth_(and__3546__auto____5336)) {
            return i__5334 < size
          }else {
            return and__3546__auto____5336
          }
        }())) {
          a__5332[i__5334] = cljs.core.first.call(null, s__5335);
          var G__5339 = i__5334 + 1;
          var G__5340 = cljs.core.next.call(null, s__5335);
          i__5334 = G__5339;
          s__5335 = G__5340;
          continue
        }else {
          return a__5332
        }
        break
      }
    }else {
      var n__685__auto____5337 = size;
      var i__5338 = 0;
      while(true) {
        if(i__5338 < n__685__auto____5337) {
          a__5332[i__5338] = init_val_or_seq;
          var G__5341 = i__5338 + 1;
          i__5338 = G__5341;
          continue
        }else {
        }
        break
      }
      return a__5332
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5342 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5343 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5344 = 0;
      var s__5345 = s__5343;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5346 = s__5345;
          if(cljs.core.truth_(and__3546__auto____5346)) {
            return i__5344 < size
          }else {
            return and__3546__auto____5346
          }
        }())) {
          a__5342[i__5344] = cljs.core.first.call(null, s__5345);
          var G__5349 = i__5344 + 1;
          var G__5350 = cljs.core.next.call(null, s__5345);
          i__5344 = G__5349;
          s__5345 = G__5350;
          continue
        }else {
          return a__5342
        }
        break
      }
    }else {
      var n__685__auto____5347 = size;
      var i__5348 = 0;
      while(true) {
        if(i__5348 < n__685__auto____5347) {
          a__5342[i__5348] = init_val_or_seq;
          var G__5351 = i__5348 + 1;
          i__5348 = G__5351;
          continue
        }else {
        }
        break
      }
      return a__5342
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5352 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5353 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5354 = 0;
      var s__5355 = s__5353;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5356 = s__5355;
          if(cljs.core.truth_(and__3546__auto____5356)) {
            return i__5354 < size
          }else {
            return and__3546__auto____5356
          }
        }())) {
          a__5352[i__5354] = cljs.core.first.call(null, s__5355);
          var G__5359 = i__5354 + 1;
          var G__5360 = cljs.core.next.call(null, s__5355);
          i__5354 = G__5359;
          s__5355 = G__5360;
          continue
        }else {
          return a__5352
        }
        break
      }
    }else {
      var n__685__auto____5357 = size;
      var i__5358 = 0;
      while(true) {
        if(i__5358 < n__685__auto____5357) {
          a__5352[i__5358] = init_val_or_seq;
          var G__5361 = i__5358 + 1;
          i__5358 = G__5361;
          continue
        }else {
        }
        break
      }
      return a__5352
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5362 = s;
    var i__5363 = n;
    var sum__5364 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5365 = i__5363 > 0;
        if(and__3546__auto____5365) {
          return cljs.core.seq.call(null, s__5362)
        }else {
          return and__3546__auto____5365
        }
      }())) {
        var G__5366 = cljs.core.next.call(null, s__5362);
        var G__5367 = i__5363 - 1;
        var G__5368 = sum__5364 + 1;
        s__5362 = G__5366;
        i__5363 = G__5367;
        sum__5364 = G__5368;
        continue
      }else {
        return sum__5364
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5369 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5369)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5369), concat.call(null, cljs.core.rest.call(null, s__5369), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5372__delegate = function(x, y, zs) {
      var cat__5371 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5370 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5370)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5370), cat.call(null, cljs.core.rest.call(null, xys__5370), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5371.call(null, concat.call(null, x, y), zs)
    };
    var G__5372 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5372__delegate.call(this, x, y, zs)
    };
    G__5372.cljs$lang$maxFixedArity = 2;
    G__5372.cljs$lang$applyTo = function(arglist__5373) {
      var x = cljs.core.first(arglist__5373);
      var y = cljs.core.first(cljs.core.next(arglist__5373));
      var zs = cljs.core.rest(cljs.core.next(arglist__5373));
      return G__5372__delegate(x, y, zs)
    };
    G__5372.cljs$lang$arity$variadic = G__5372__delegate;
    return G__5372
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5374__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5374 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5374__delegate.call(this, a, b, c, d, more)
    };
    G__5374.cljs$lang$maxFixedArity = 4;
    G__5374.cljs$lang$applyTo = function(arglist__5375) {
      var a = cljs.core.first(arglist__5375);
      var b = cljs.core.first(cljs.core.next(arglist__5375));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5375)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5375))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5375))));
      return G__5374__delegate(a, b, c, d, more)
    };
    G__5374.cljs$lang$arity$variadic = G__5374__delegate;
    return G__5374
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5376 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5377 = cljs.core._first.call(null, args__5376);
    var args__5378 = cljs.core._rest.call(null, args__5376);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5377)
      }else {
        return f.call(null, a__5377)
      }
    }else {
      var b__5379 = cljs.core._first.call(null, args__5378);
      var args__5380 = cljs.core._rest.call(null, args__5378);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5377, b__5379)
        }else {
          return f.call(null, a__5377, b__5379)
        }
      }else {
        var c__5381 = cljs.core._first.call(null, args__5380);
        var args__5382 = cljs.core._rest.call(null, args__5380);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5377, b__5379, c__5381)
          }else {
            return f.call(null, a__5377, b__5379, c__5381)
          }
        }else {
          var d__5383 = cljs.core._first.call(null, args__5382);
          var args__5384 = cljs.core._rest.call(null, args__5382);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5377, b__5379, c__5381, d__5383)
            }else {
              return f.call(null, a__5377, b__5379, c__5381, d__5383)
            }
          }else {
            var e__5385 = cljs.core._first.call(null, args__5384);
            var args__5386 = cljs.core._rest.call(null, args__5384);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5377, b__5379, c__5381, d__5383, e__5385)
              }else {
                return f.call(null, a__5377, b__5379, c__5381, d__5383, e__5385)
              }
            }else {
              var f__5387 = cljs.core._first.call(null, args__5386);
              var args__5388 = cljs.core._rest.call(null, args__5386);
              if(argc === 6) {
                if(f__5387.cljs$lang$arity$6) {
                  return f__5387.cljs$lang$arity$6(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387)
                }else {
                  return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387)
                }
              }else {
                var g__5389 = cljs.core._first.call(null, args__5388);
                var args__5390 = cljs.core._rest.call(null, args__5388);
                if(argc === 7) {
                  if(f__5387.cljs$lang$arity$7) {
                    return f__5387.cljs$lang$arity$7(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389)
                  }else {
                    return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389)
                  }
                }else {
                  var h__5391 = cljs.core._first.call(null, args__5390);
                  var args__5392 = cljs.core._rest.call(null, args__5390);
                  if(argc === 8) {
                    if(f__5387.cljs$lang$arity$8) {
                      return f__5387.cljs$lang$arity$8(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391)
                    }else {
                      return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391)
                    }
                  }else {
                    var i__5393 = cljs.core._first.call(null, args__5392);
                    var args__5394 = cljs.core._rest.call(null, args__5392);
                    if(argc === 9) {
                      if(f__5387.cljs$lang$arity$9) {
                        return f__5387.cljs$lang$arity$9(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393)
                      }else {
                        return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393)
                      }
                    }else {
                      var j__5395 = cljs.core._first.call(null, args__5394);
                      var args__5396 = cljs.core._rest.call(null, args__5394);
                      if(argc === 10) {
                        if(f__5387.cljs$lang$arity$10) {
                          return f__5387.cljs$lang$arity$10(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395)
                        }else {
                          return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395)
                        }
                      }else {
                        var k__5397 = cljs.core._first.call(null, args__5396);
                        var args__5398 = cljs.core._rest.call(null, args__5396);
                        if(argc === 11) {
                          if(f__5387.cljs$lang$arity$11) {
                            return f__5387.cljs$lang$arity$11(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397)
                          }else {
                            return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397)
                          }
                        }else {
                          var l__5399 = cljs.core._first.call(null, args__5398);
                          var args__5400 = cljs.core._rest.call(null, args__5398);
                          if(argc === 12) {
                            if(f__5387.cljs$lang$arity$12) {
                              return f__5387.cljs$lang$arity$12(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399)
                            }else {
                              return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399)
                            }
                          }else {
                            var m__5401 = cljs.core._first.call(null, args__5400);
                            var args__5402 = cljs.core._rest.call(null, args__5400);
                            if(argc === 13) {
                              if(f__5387.cljs$lang$arity$13) {
                                return f__5387.cljs$lang$arity$13(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401)
                              }else {
                                return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401)
                              }
                            }else {
                              var n__5403 = cljs.core._first.call(null, args__5402);
                              var args__5404 = cljs.core._rest.call(null, args__5402);
                              if(argc === 14) {
                                if(f__5387.cljs$lang$arity$14) {
                                  return f__5387.cljs$lang$arity$14(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403)
                                }else {
                                  return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403)
                                }
                              }else {
                                var o__5405 = cljs.core._first.call(null, args__5404);
                                var args__5406 = cljs.core._rest.call(null, args__5404);
                                if(argc === 15) {
                                  if(f__5387.cljs$lang$arity$15) {
                                    return f__5387.cljs$lang$arity$15(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405)
                                  }else {
                                    return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405)
                                  }
                                }else {
                                  var p__5407 = cljs.core._first.call(null, args__5406);
                                  var args__5408 = cljs.core._rest.call(null, args__5406);
                                  if(argc === 16) {
                                    if(f__5387.cljs$lang$arity$16) {
                                      return f__5387.cljs$lang$arity$16(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407)
                                    }else {
                                      return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407)
                                    }
                                  }else {
                                    var q__5409 = cljs.core._first.call(null, args__5408);
                                    var args__5410 = cljs.core._rest.call(null, args__5408);
                                    if(argc === 17) {
                                      if(f__5387.cljs$lang$arity$17) {
                                        return f__5387.cljs$lang$arity$17(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409)
                                      }else {
                                        return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409)
                                      }
                                    }else {
                                      var r__5411 = cljs.core._first.call(null, args__5410);
                                      var args__5412 = cljs.core._rest.call(null, args__5410);
                                      if(argc === 18) {
                                        if(f__5387.cljs$lang$arity$18) {
                                          return f__5387.cljs$lang$arity$18(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409, r__5411)
                                        }else {
                                          return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409, r__5411)
                                        }
                                      }else {
                                        var s__5413 = cljs.core._first.call(null, args__5412);
                                        var args__5414 = cljs.core._rest.call(null, args__5412);
                                        if(argc === 19) {
                                          if(f__5387.cljs$lang$arity$19) {
                                            return f__5387.cljs$lang$arity$19(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409, r__5411, s__5413)
                                          }else {
                                            return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409, r__5411, s__5413)
                                          }
                                        }else {
                                          var t__5415 = cljs.core._first.call(null, args__5414);
                                          var args__5416 = cljs.core._rest.call(null, args__5414);
                                          if(argc === 20) {
                                            if(f__5387.cljs$lang$arity$20) {
                                              return f__5387.cljs$lang$arity$20(a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409, r__5411, s__5413, t__5415)
                                            }else {
                                              return f__5387.call(null, a__5377, b__5379, c__5381, d__5383, e__5385, f__5387, g__5389, h__5391, i__5393, j__5395, k__5397, l__5399, m__5401, n__5403, o__5405, p__5407, q__5409, r__5411, s__5413, t__5415)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5417 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5418 = cljs.core.bounded_count.call(null, args, fixed_arity__5417 + 1);
      if(bc__5418 <= fixed_arity__5417) {
        return cljs.core.apply_to.call(null, f, bc__5418, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5419 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5420 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5421 = cljs.core.bounded_count.call(null, arglist__5419, fixed_arity__5420 + 1);
      if(bc__5421 <= fixed_arity__5420) {
        return cljs.core.apply_to.call(null, f, bc__5421, arglist__5419)
      }else {
        return f.cljs$lang$applyTo(arglist__5419)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5419))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5422 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5423 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5424 = cljs.core.bounded_count.call(null, arglist__5422, fixed_arity__5423 + 1);
      if(bc__5424 <= fixed_arity__5423) {
        return cljs.core.apply_to.call(null, f, bc__5424, arglist__5422)
      }else {
        return f.cljs$lang$applyTo(arglist__5422)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5422))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5425 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5426 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5427 = cljs.core.bounded_count.call(null, arglist__5425, fixed_arity__5426 + 1);
      if(bc__5427 <= fixed_arity__5426) {
        return cljs.core.apply_to.call(null, f, bc__5427, arglist__5425)
      }else {
        return f.cljs$lang$applyTo(arglist__5425)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5425))
    }
  };
  var apply__6 = function() {
    var G__5431__delegate = function(f, a, b, c, d, args) {
      var arglist__5428 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5429 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5430 = cljs.core.bounded_count.call(null, arglist__5428, fixed_arity__5429 + 1);
        if(bc__5430 <= fixed_arity__5429) {
          return cljs.core.apply_to.call(null, f, bc__5430, arglist__5428)
        }else {
          return f.cljs$lang$applyTo(arglist__5428)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5428))
      }
    };
    var G__5431 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5431__delegate.call(this, f, a, b, c, d, args)
    };
    G__5431.cljs$lang$maxFixedArity = 5;
    G__5431.cljs$lang$applyTo = function(arglist__5432) {
      var f = cljs.core.first(arglist__5432);
      var a = cljs.core.first(cljs.core.next(arglist__5432));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5432)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5432))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5432)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5432)))));
      return G__5431__delegate(f, a, b, c, d, args)
    };
    G__5431.cljs$lang$arity$variadic = G__5431__delegate;
    return G__5431
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5433) {
    var obj = cljs.core.first(arglist__5433);
    var f = cljs.core.first(cljs.core.next(arglist__5433));
    var args = cljs.core.rest(cljs.core.next(arglist__5433));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5434__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5434 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5434__delegate.call(this, x, y, more)
    };
    G__5434.cljs$lang$maxFixedArity = 2;
    G__5434.cljs$lang$applyTo = function(arglist__5435) {
      var x = cljs.core.first(arglist__5435);
      var y = cljs.core.first(cljs.core.next(arglist__5435));
      var more = cljs.core.rest(cljs.core.next(arglist__5435));
      return G__5434__delegate(x, y, more)
    };
    G__5434.cljs$lang$arity$variadic = G__5434__delegate;
    return G__5434
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5436 = pred;
        var G__5437 = cljs.core.next.call(null, coll);
        pred = G__5436;
        coll = G__5437;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5438 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5438)) {
        return or__3548__auto____5438
      }else {
        var G__5439 = pred;
        var G__5440 = cljs.core.next.call(null, coll);
        pred = G__5439;
        coll = G__5440;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5441 = null;
    var G__5441__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5441__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5441__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5441__3 = function() {
      var G__5442__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5442 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5442__delegate.call(this, x, y, zs)
      };
      G__5442.cljs$lang$maxFixedArity = 2;
      G__5442.cljs$lang$applyTo = function(arglist__5443) {
        var x = cljs.core.first(arglist__5443);
        var y = cljs.core.first(cljs.core.next(arglist__5443));
        var zs = cljs.core.rest(cljs.core.next(arglist__5443));
        return G__5442__delegate(x, y, zs)
      };
      G__5442.cljs$lang$arity$variadic = G__5442__delegate;
      return G__5442
    }();
    G__5441 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5441__0.call(this);
        case 1:
          return G__5441__1.call(this, x);
        case 2:
          return G__5441__2.call(this, x, y);
        default:
          return G__5441__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5441.cljs$lang$maxFixedArity = 2;
    G__5441.cljs$lang$applyTo = G__5441__3.cljs$lang$applyTo;
    return G__5441
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5444__delegate = function(args) {
      return x
    };
    var G__5444 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5444__delegate.call(this, args)
    };
    G__5444.cljs$lang$maxFixedArity = 0;
    G__5444.cljs$lang$applyTo = function(arglist__5445) {
      var args = cljs.core.seq(arglist__5445);
      return G__5444__delegate(args)
    };
    G__5444.cljs$lang$arity$variadic = G__5444__delegate;
    return G__5444
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5449 = null;
      var G__5449__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5449__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5449__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5449__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5449__4 = function() {
        var G__5450__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5450 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5450__delegate.call(this, x, y, z, args)
        };
        G__5450.cljs$lang$maxFixedArity = 3;
        G__5450.cljs$lang$applyTo = function(arglist__5451) {
          var x = cljs.core.first(arglist__5451);
          var y = cljs.core.first(cljs.core.next(arglist__5451));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5451)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5451)));
          return G__5450__delegate(x, y, z, args)
        };
        G__5450.cljs$lang$arity$variadic = G__5450__delegate;
        return G__5450
      }();
      G__5449 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5449__0.call(this);
          case 1:
            return G__5449__1.call(this, x);
          case 2:
            return G__5449__2.call(this, x, y);
          case 3:
            return G__5449__3.call(this, x, y, z);
          default:
            return G__5449__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5449.cljs$lang$maxFixedArity = 3;
      G__5449.cljs$lang$applyTo = G__5449__4.cljs$lang$applyTo;
      return G__5449
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5452 = null;
      var G__5452__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5452__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5452__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5452__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5452__4 = function() {
        var G__5453__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5453 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5453__delegate.call(this, x, y, z, args)
        };
        G__5453.cljs$lang$maxFixedArity = 3;
        G__5453.cljs$lang$applyTo = function(arglist__5454) {
          var x = cljs.core.first(arglist__5454);
          var y = cljs.core.first(cljs.core.next(arglist__5454));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5454)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5454)));
          return G__5453__delegate(x, y, z, args)
        };
        G__5453.cljs$lang$arity$variadic = G__5453__delegate;
        return G__5453
      }();
      G__5452 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5452__0.call(this);
          case 1:
            return G__5452__1.call(this, x);
          case 2:
            return G__5452__2.call(this, x, y);
          case 3:
            return G__5452__3.call(this, x, y, z);
          default:
            return G__5452__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5452.cljs$lang$maxFixedArity = 3;
      G__5452.cljs$lang$applyTo = G__5452__4.cljs$lang$applyTo;
      return G__5452
    }()
  };
  var comp__4 = function() {
    var G__5455__delegate = function(f1, f2, f3, fs) {
      var fs__5446 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5456__delegate = function(args) {
          var ret__5447 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5446), args);
          var fs__5448 = cljs.core.next.call(null, fs__5446);
          while(true) {
            if(cljs.core.truth_(fs__5448)) {
              var G__5457 = cljs.core.first.call(null, fs__5448).call(null, ret__5447);
              var G__5458 = cljs.core.next.call(null, fs__5448);
              ret__5447 = G__5457;
              fs__5448 = G__5458;
              continue
            }else {
              return ret__5447
            }
            break
          }
        };
        var G__5456 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5456__delegate.call(this, args)
        };
        G__5456.cljs$lang$maxFixedArity = 0;
        G__5456.cljs$lang$applyTo = function(arglist__5459) {
          var args = cljs.core.seq(arglist__5459);
          return G__5456__delegate(args)
        };
        G__5456.cljs$lang$arity$variadic = G__5456__delegate;
        return G__5456
      }()
    };
    var G__5455 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5455__delegate.call(this, f1, f2, f3, fs)
    };
    G__5455.cljs$lang$maxFixedArity = 3;
    G__5455.cljs$lang$applyTo = function(arglist__5460) {
      var f1 = cljs.core.first(arglist__5460);
      var f2 = cljs.core.first(cljs.core.next(arglist__5460));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5460)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5460)));
      return G__5455__delegate(f1, f2, f3, fs)
    };
    G__5455.cljs$lang$arity$variadic = G__5455__delegate;
    return G__5455
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5461__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5461 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5461__delegate.call(this, args)
      };
      G__5461.cljs$lang$maxFixedArity = 0;
      G__5461.cljs$lang$applyTo = function(arglist__5462) {
        var args = cljs.core.seq(arglist__5462);
        return G__5461__delegate(args)
      };
      G__5461.cljs$lang$arity$variadic = G__5461__delegate;
      return G__5461
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5463__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5463 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5463__delegate.call(this, args)
      };
      G__5463.cljs$lang$maxFixedArity = 0;
      G__5463.cljs$lang$applyTo = function(arglist__5464) {
        var args = cljs.core.seq(arglist__5464);
        return G__5463__delegate(args)
      };
      G__5463.cljs$lang$arity$variadic = G__5463__delegate;
      return G__5463
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5465__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5465 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5465__delegate.call(this, args)
      };
      G__5465.cljs$lang$maxFixedArity = 0;
      G__5465.cljs$lang$applyTo = function(arglist__5466) {
        var args = cljs.core.seq(arglist__5466);
        return G__5465__delegate(args)
      };
      G__5465.cljs$lang$arity$variadic = G__5465__delegate;
      return G__5465
    }()
  };
  var partial__5 = function() {
    var G__5467__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5468__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5468 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5468__delegate.call(this, args)
        };
        G__5468.cljs$lang$maxFixedArity = 0;
        G__5468.cljs$lang$applyTo = function(arglist__5469) {
          var args = cljs.core.seq(arglist__5469);
          return G__5468__delegate(args)
        };
        G__5468.cljs$lang$arity$variadic = G__5468__delegate;
        return G__5468
      }()
    };
    var G__5467 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5467__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5467.cljs$lang$maxFixedArity = 4;
    G__5467.cljs$lang$applyTo = function(arglist__5470) {
      var f = cljs.core.first(arglist__5470);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5470));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5470)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5470))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5470))));
      return G__5467__delegate(f, arg1, arg2, arg3, more)
    };
    G__5467.cljs$lang$arity$variadic = G__5467__delegate;
    return G__5467
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5471 = null;
      var G__5471__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5471__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5471__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5471__4 = function() {
        var G__5472__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5472 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5472__delegate.call(this, a, b, c, ds)
        };
        G__5472.cljs$lang$maxFixedArity = 3;
        G__5472.cljs$lang$applyTo = function(arglist__5473) {
          var a = cljs.core.first(arglist__5473);
          var b = cljs.core.first(cljs.core.next(arglist__5473));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5473)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5473)));
          return G__5472__delegate(a, b, c, ds)
        };
        G__5472.cljs$lang$arity$variadic = G__5472__delegate;
        return G__5472
      }();
      G__5471 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5471__1.call(this, a);
          case 2:
            return G__5471__2.call(this, a, b);
          case 3:
            return G__5471__3.call(this, a, b, c);
          default:
            return G__5471__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5471.cljs$lang$maxFixedArity = 3;
      G__5471.cljs$lang$applyTo = G__5471__4.cljs$lang$applyTo;
      return G__5471
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5474 = null;
      var G__5474__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5474__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5474__4 = function() {
        var G__5475__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5475 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5475__delegate.call(this, a, b, c, ds)
        };
        G__5475.cljs$lang$maxFixedArity = 3;
        G__5475.cljs$lang$applyTo = function(arglist__5476) {
          var a = cljs.core.first(arglist__5476);
          var b = cljs.core.first(cljs.core.next(arglist__5476));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5476)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5476)));
          return G__5475__delegate(a, b, c, ds)
        };
        G__5475.cljs$lang$arity$variadic = G__5475__delegate;
        return G__5475
      }();
      G__5474 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5474__2.call(this, a, b);
          case 3:
            return G__5474__3.call(this, a, b, c);
          default:
            return G__5474__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5474.cljs$lang$maxFixedArity = 3;
      G__5474.cljs$lang$applyTo = G__5474__4.cljs$lang$applyTo;
      return G__5474
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5477 = null;
      var G__5477__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5477__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5477__4 = function() {
        var G__5478__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5478 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5478__delegate.call(this, a, b, c, ds)
        };
        G__5478.cljs$lang$maxFixedArity = 3;
        G__5478.cljs$lang$applyTo = function(arglist__5479) {
          var a = cljs.core.first(arglist__5479);
          var b = cljs.core.first(cljs.core.next(arglist__5479));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5479)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5479)));
          return G__5478__delegate(a, b, c, ds)
        };
        G__5478.cljs$lang$arity$variadic = G__5478__delegate;
        return G__5478
      }();
      G__5477 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5477__2.call(this, a, b);
          case 3:
            return G__5477__3.call(this, a, b, c);
          default:
            return G__5477__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5477.cljs$lang$maxFixedArity = 3;
      G__5477.cljs$lang$applyTo = G__5477__4.cljs$lang$applyTo;
      return G__5477
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5482 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5480 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5480)) {
        var s__5481 = temp__3698__auto____5480;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5481)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5481)))
      }else {
        return null
      }
    })
  };
  return mapi__5482.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5483 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5483)) {
      var s__5484 = temp__3698__auto____5483;
      var x__5485 = f.call(null, cljs.core.first.call(null, s__5484));
      if(x__5485 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5484))
      }else {
        return cljs.core.cons.call(null, x__5485, keep.call(null, f, cljs.core.rest.call(null, s__5484)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5495 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5492 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5492)) {
        var s__5493 = temp__3698__auto____5492;
        var x__5494 = f.call(null, idx, cljs.core.first.call(null, s__5493));
        if(x__5494 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5493))
        }else {
          return cljs.core.cons.call(null, x__5494, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5493)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5495.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5502 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5502)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5502
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5503 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5503)) {
            var and__3546__auto____5504 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5504)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5504
            }
          }else {
            return and__3546__auto____5503
          }
        }())
      };
      var ep1__4 = function() {
        var G__5540__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5505 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5505)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5505
            }
          }())
        };
        var G__5540 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5540__delegate.call(this, x, y, z, args)
        };
        G__5540.cljs$lang$maxFixedArity = 3;
        G__5540.cljs$lang$applyTo = function(arglist__5541) {
          var x = cljs.core.first(arglist__5541);
          var y = cljs.core.first(cljs.core.next(arglist__5541));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5541)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5541)));
          return G__5540__delegate(x, y, z, args)
        };
        G__5540.cljs$lang$arity$variadic = G__5540__delegate;
        return G__5540
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5506 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5506)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5506
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5507 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5507)) {
            var and__3546__auto____5508 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5508)) {
              var and__3546__auto____5509 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5509)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5509
              }
            }else {
              return and__3546__auto____5508
            }
          }else {
            return and__3546__auto____5507
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5510 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5510)) {
            var and__3546__auto____5511 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5511)) {
              var and__3546__auto____5512 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5512)) {
                var and__3546__auto____5513 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5513)) {
                  var and__3546__auto____5514 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5514)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5514
                  }
                }else {
                  return and__3546__auto____5513
                }
              }else {
                return and__3546__auto____5512
              }
            }else {
              return and__3546__auto____5511
            }
          }else {
            return and__3546__auto____5510
          }
        }())
      };
      var ep2__4 = function() {
        var G__5542__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5515 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5515)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5486_SHARP_) {
                var and__3546__auto____5516 = p1.call(null, p1__5486_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5516)) {
                  return p2.call(null, p1__5486_SHARP_)
                }else {
                  return and__3546__auto____5516
                }
              }, args)
            }else {
              return and__3546__auto____5515
            }
          }())
        };
        var G__5542 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5542__delegate.call(this, x, y, z, args)
        };
        G__5542.cljs$lang$maxFixedArity = 3;
        G__5542.cljs$lang$applyTo = function(arglist__5543) {
          var x = cljs.core.first(arglist__5543);
          var y = cljs.core.first(cljs.core.next(arglist__5543));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5543)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5543)));
          return G__5542__delegate(x, y, z, args)
        };
        G__5542.cljs$lang$arity$variadic = G__5542__delegate;
        return G__5542
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5517 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5517)) {
            var and__3546__auto____5518 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5518)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5518
            }
          }else {
            return and__3546__auto____5517
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5519 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5519)) {
            var and__3546__auto____5520 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5520)) {
              var and__3546__auto____5521 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5521)) {
                var and__3546__auto____5522 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5522)) {
                  var and__3546__auto____5523 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5523)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5523
                  }
                }else {
                  return and__3546__auto____5522
                }
              }else {
                return and__3546__auto____5521
              }
            }else {
              return and__3546__auto____5520
            }
          }else {
            return and__3546__auto____5519
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5524 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5524)) {
            var and__3546__auto____5525 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5525)) {
              var and__3546__auto____5526 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5526)) {
                var and__3546__auto____5527 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5527)) {
                  var and__3546__auto____5528 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5528)) {
                    var and__3546__auto____5529 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5529)) {
                      var and__3546__auto____5530 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5530)) {
                        var and__3546__auto____5531 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5531)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5531
                        }
                      }else {
                        return and__3546__auto____5530
                      }
                    }else {
                      return and__3546__auto____5529
                    }
                  }else {
                    return and__3546__auto____5528
                  }
                }else {
                  return and__3546__auto____5527
                }
              }else {
                return and__3546__auto____5526
              }
            }else {
              return and__3546__auto____5525
            }
          }else {
            return and__3546__auto____5524
          }
        }())
      };
      var ep3__4 = function() {
        var G__5544__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5532 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5532)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5487_SHARP_) {
                var and__3546__auto____5533 = p1.call(null, p1__5487_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5533)) {
                  var and__3546__auto____5534 = p2.call(null, p1__5487_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5534)) {
                    return p3.call(null, p1__5487_SHARP_)
                  }else {
                    return and__3546__auto____5534
                  }
                }else {
                  return and__3546__auto____5533
                }
              }, args)
            }else {
              return and__3546__auto____5532
            }
          }())
        };
        var G__5544 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5544__delegate.call(this, x, y, z, args)
        };
        G__5544.cljs$lang$maxFixedArity = 3;
        G__5544.cljs$lang$applyTo = function(arglist__5545) {
          var x = cljs.core.first(arglist__5545);
          var y = cljs.core.first(cljs.core.next(arglist__5545));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5545)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5545)));
          return G__5544__delegate(x, y, z, args)
        };
        G__5544.cljs$lang$arity$variadic = G__5544__delegate;
        return G__5544
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5546__delegate = function(p1, p2, p3, ps) {
      var ps__5535 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5488_SHARP_) {
            return p1__5488_SHARP_.call(null, x)
          }, ps__5535)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5489_SHARP_) {
            var and__3546__auto____5536 = p1__5489_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5536)) {
              return p1__5489_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5536
            }
          }, ps__5535)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5490_SHARP_) {
            var and__3546__auto____5537 = p1__5490_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5537)) {
              var and__3546__auto____5538 = p1__5490_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5538)) {
                return p1__5490_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5538
              }
            }else {
              return and__3546__auto____5537
            }
          }, ps__5535)
        };
        var epn__4 = function() {
          var G__5547__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5539 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5539)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5491_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5491_SHARP_, args)
                }, ps__5535)
              }else {
                return and__3546__auto____5539
              }
            }())
          };
          var G__5547 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5547__delegate.call(this, x, y, z, args)
          };
          G__5547.cljs$lang$maxFixedArity = 3;
          G__5547.cljs$lang$applyTo = function(arglist__5548) {
            var x = cljs.core.first(arglist__5548);
            var y = cljs.core.first(cljs.core.next(arglist__5548));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5548)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5548)));
            return G__5547__delegate(x, y, z, args)
          };
          G__5547.cljs$lang$arity$variadic = G__5547__delegate;
          return G__5547
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5546 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5546__delegate.call(this, p1, p2, p3, ps)
    };
    G__5546.cljs$lang$maxFixedArity = 3;
    G__5546.cljs$lang$applyTo = function(arglist__5549) {
      var p1 = cljs.core.first(arglist__5549);
      var p2 = cljs.core.first(cljs.core.next(arglist__5549));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5549)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5549)));
      return G__5546__delegate(p1, p2, p3, ps)
    };
    G__5546.cljs$lang$arity$variadic = G__5546__delegate;
    return G__5546
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5551 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5551)) {
          return or__3548__auto____5551
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5552 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5552)) {
          return or__3548__auto____5552
        }else {
          var or__3548__auto____5553 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5553)) {
            return or__3548__auto____5553
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5589__delegate = function(x, y, z, args) {
          var or__3548__auto____5554 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5554)) {
            return or__3548__auto____5554
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5589 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5589__delegate.call(this, x, y, z, args)
        };
        G__5589.cljs$lang$maxFixedArity = 3;
        G__5589.cljs$lang$applyTo = function(arglist__5590) {
          var x = cljs.core.first(arglist__5590);
          var y = cljs.core.first(cljs.core.next(arglist__5590));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5590)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5590)));
          return G__5589__delegate(x, y, z, args)
        };
        G__5589.cljs$lang$arity$variadic = G__5589__delegate;
        return G__5589
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5555 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5555)) {
          return or__3548__auto____5555
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5556 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5556)) {
          return or__3548__auto____5556
        }else {
          var or__3548__auto____5557 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5557)) {
            return or__3548__auto____5557
          }else {
            var or__3548__auto____5558 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5558)) {
              return or__3548__auto____5558
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5559 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5559)) {
          return or__3548__auto____5559
        }else {
          var or__3548__auto____5560 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5560)) {
            return or__3548__auto____5560
          }else {
            var or__3548__auto____5561 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5561)) {
              return or__3548__auto____5561
            }else {
              var or__3548__auto____5562 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5562)) {
                return or__3548__auto____5562
              }else {
                var or__3548__auto____5563 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5563)) {
                  return or__3548__auto____5563
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5591__delegate = function(x, y, z, args) {
          var or__3548__auto____5564 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5564)) {
            return or__3548__auto____5564
          }else {
            return cljs.core.some.call(null, function(p1__5496_SHARP_) {
              var or__3548__auto____5565 = p1.call(null, p1__5496_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5565)) {
                return or__3548__auto____5565
              }else {
                return p2.call(null, p1__5496_SHARP_)
              }
            }, args)
          }
        };
        var G__5591 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5591__delegate.call(this, x, y, z, args)
        };
        G__5591.cljs$lang$maxFixedArity = 3;
        G__5591.cljs$lang$applyTo = function(arglist__5592) {
          var x = cljs.core.first(arglist__5592);
          var y = cljs.core.first(cljs.core.next(arglist__5592));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5592)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5592)));
          return G__5591__delegate(x, y, z, args)
        };
        G__5591.cljs$lang$arity$variadic = G__5591__delegate;
        return G__5591
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5566 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5566)) {
          return or__3548__auto____5566
        }else {
          var or__3548__auto____5567 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5567)) {
            return or__3548__auto____5567
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5568 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5568)) {
          return or__3548__auto____5568
        }else {
          var or__3548__auto____5569 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5569)) {
            return or__3548__auto____5569
          }else {
            var or__3548__auto____5570 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5570)) {
              return or__3548__auto____5570
            }else {
              var or__3548__auto____5571 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5571)) {
                return or__3548__auto____5571
              }else {
                var or__3548__auto____5572 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5572)) {
                  return or__3548__auto____5572
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5573 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5573)) {
          return or__3548__auto____5573
        }else {
          var or__3548__auto____5574 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5574)) {
            return or__3548__auto____5574
          }else {
            var or__3548__auto____5575 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5575)) {
              return or__3548__auto____5575
            }else {
              var or__3548__auto____5576 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5576)) {
                return or__3548__auto____5576
              }else {
                var or__3548__auto____5577 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5577)) {
                  return or__3548__auto____5577
                }else {
                  var or__3548__auto____5578 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5578)) {
                    return or__3548__auto____5578
                  }else {
                    var or__3548__auto____5579 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5579)) {
                      return or__3548__auto____5579
                    }else {
                      var or__3548__auto____5580 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5580)) {
                        return or__3548__auto____5580
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5593__delegate = function(x, y, z, args) {
          var or__3548__auto____5581 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5581)) {
            return or__3548__auto____5581
          }else {
            return cljs.core.some.call(null, function(p1__5497_SHARP_) {
              var or__3548__auto____5582 = p1.call(null, p1__5497_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5582)) {
                return or__3548__auto____5582
              }else {
                var or__3548__auto____5583 = p2.call(null, p1__5497_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5583)) {
                  return or__3548__auto____5583
                }else {
                  return p3.call(null, p1__5497_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5593 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5593__delegate.call(this, x, y, z, args)
        };
        G__5593.cljs$lang$maxFixedArity = 3;
        G__5593.cljs$lang$applyTo = function(arglist__5594) {
          var x = cljs.core.first(arglist__5594);
          var y = cljs.core.first(cljs.core.next(arglist__5594));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5594)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5594)));
          return G__5593__delegate(x, y, z, args)
        };
        G__5593.cljs$lang$arity$variadic = G__5593__delegate;
        return G__5593
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5595__delegate = function(p1, p2, p3, ps) {
      var ps__5584 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5498_SHARP_) {
            return p1__5498_SHARP_.call(null, x)
          }, ps__5584)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5499_SHARP_) {
            var or__3548__auto____5585 = p1__5499_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5585)) {
              return or__3548__auto____5585
            }else {
              return p1__5499_SHARP_.call(null, y)
            }
          }, ps__5584)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5500_SHARP_) {
            var or__3548__auto____5586 = p1__5500_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5586)) {
              return or__3548__auto____5586
            }else {
              var or__3548__auto____5587 = p1__5500_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5587)) {
                return or__3548__auto____5587
              }else {
                return p1__5500_SHARP_.call(null, z)
              }
            }
          }, ps__5584)
        };
        var spn__4 = function() {
          var G__5596__delegate = function(x, y, z, args) {
            var or__3548__auto____5588 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5588)) {
              return or__3548__auto____5588
            }else {
              return cljs.core.some.call(null, function(p1__5501_SHARP_) {
                return cljs.core.some.call(null, p1__5501_SHARP_, args)
              }, ps__5584)
            }
          };
          var G__5596 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5596__delegate.call(this, x, y, z, args)
          };
          G__5596.cljs$lang$maxFixedArity = 3;
          G__5596.cljs$lang$applyTo = function(arglist__5597) {
            var x = cljs.core.first(arglist__5597);
            var y = cljs.core.first(cljs.core.next(arglist__5597));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5597)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5597)));
            return G__5596__delegate(x, y, z, args)
          };
          G__5596.cljs$lang$arity$variadic = G__5596__delegate;
          return G__5596
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5595 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5595__delegate.call(this, p1, p2, p3, ps)
    };
    G__5595.cljs$lang$maxFixedArity = 3;
    G__5595.cljs$lang$applyTo = function(arglist__5598) {
      var p1 = cljs.core.first(arglist__5598);
      var p2 = cljs.core.first(cljs.core.next(arglist__5598));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5598)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5598)));
      return G__5595__delegate(p1, p2, p3, ps)
    };
    G__5595.cljs$lang$arity$variadic = G__5595__delegate;
    return G__5595
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5599 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5599)) {
        var s__5600 = temp__3698__auto____5599;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5600)), map.call(null, f, cljs.core.rest.call(null, s__5600)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5601 = cljs.core.seq.call(null, c1);
      var s2__5602 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5603 = s1__5601;
        if(cljs.core.truth_(and__3546__auto____5603)) {
          return s2__5602
        }else {
          return and__3546__auto____5603
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5601), cljs.core.first.call(null, s2__5602)), map.call(null, f, cljs.core.rest.call(null, s1__5601), cljs.core.rest.call(null, s2__5602)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5604 = cljs.core.seq.call(null, c1);
      var s2__5605 = cljs.core.seq.call(null, c2);
      var s3__5606 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5607 = s1__5604;
        if(cljs.core.truth_(and__3546__auto____5607)) {
          var and__3546__auto____5608 = s2__5605;
          if(cljs.core.truth_(and__3546__auto____5608)) {
            return s3__5606
          }else {
            return and__3546__auto____5608
          }
        }else {
          return and__3546__auto____5607
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5604), cljs.core.first.call(null, s2__5605), cljs.core.first.call(null, s3__5606)), map.call(null, f, cljs.core.rest.call(null, s1__5604), cljs.core.rest.call(null, s2__5605), cljs.core.rest.call(null, s3__5606)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5611__delegate = function(f, c1, c2, c3, colls) {
      var step__5610 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5609 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5609)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5609), step.call(null, map.call(null, cljs.core.rest, ss__5609)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5550_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5550_SHARP_)
      }, step__5610.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5611 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5611__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5611.cljs$lang$maxFixedArity = 4;
    G__5611.cljs$lang$applyTo = function(arglist__5612) {
      var f = cljs.core.first(arglist__5612);
      var c1 = cljs.core.first(cljs.core.next(arglist__5612));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5612)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5612))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5612))));
      return G__5611__delegate(f, c1, c2, c3, colls)
    };
    G__5611.cljs$lang$arity$variadic = G__5611__delegate;
    return G__5611
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5613 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5613)) {
        var s__5614 = temp__3698__auto____5613;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5614), take.call(null, n - 1, cljs.core.rest.call(null, s__5614)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5617 = function(n, coll) {
    while(true) {
      var s__5615 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5616 = n > 0;
        if(and__3546__auto____5616) {
          return s__5615
        }else {
          return and__3546__auto____5616
        }
      }())) {
        var G__5618 = n - 1;
        var G__5619 = cljs.core.rest.call(null, s__5615);
        n = G__5618;
        coll = G__5619;
        continue
      }else {
        return s__5615
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5617.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5620 = cljs.core.seq.call(null, coll);
  var lead__5621 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5621)) {
      var G__5622 = cljs.core.next.call(null, s__5620);
      var G__5623 = cljs.core.next.call(null, lead__5621);
      s__5620 = G__5622;
      lead__5621 = G__5623;
      continue
    }else {
      return s__5620
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5626 = function(pred, coll) {
    while(true) {
      var s__5624 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5625 = s__5624;
        if(cljs.core.truth_(and__3546__auto____5625)) {
          return pred.call(null, cljs.core.first.call(null, s__5624))
        }else {
          return and__3546__auto____5625
        }
      }())) {
        var G__5627 = pred;
        var G__5628 = cljs.core.rest.call(null, s__5624);
        pred = G__5627;
        coll = G__5628;
        continue
      }else {
        return s__5624
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5626.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5629 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5629)) {
      var s__5630 = temp__3698__auto____5629;
      return cljs.core.concat.call(null, s__5630, cycle.call(null, s__5630))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5631 = cljs.core.seq.call(null, c1);
      var s2__5632 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5633 = s1__5631;
        if(cljs.core.truth_(and__3546__auto____5633)) {
          return s2__5632
        }else {
          return and__3546__auto____5633
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5631), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5632), interleave.call(null, cljs.core.rest.call(null, s1__5631), cljs.core.rest.call(null, s2__5632))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5635__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5634 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5634)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5634), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5634)))
        }else {
          return null
        }
      })
    };
    var G__5635 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5635__delegate.call(this, c1, c2, colls)
    };
    G__5635.cljs$lang$maxFixedArity = 2;
    G__5635.cljs$lang$applyTo = function(arglist__5636) {
      var c1 = cljs.core.first(arglist__5636);
      var c2 = cljs.core.first(cljs.core.next(arglist__5636));
      var colls = cljs.core.rest(cljs.core.next(arglist__5636));
      return G__5635__delegate(c1, c2, colls)
    };
    G__5635.cljs$lang$arity$variadic = G__5635__delegate;
    return G__5635
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5639 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5637 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5637)) {
        var coll__5638 = temp__3695__auto____5637;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5638), cat.call(null, cljs.core.rest.call(null, coll__5638), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5639.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5640__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5640 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5640__delegate.call(this, f, coll, colls)
    };
    G__5640.cljs$lang$maxFixedArity = 2;
    G__5640.cljs$lang$applyTo = function(arglist__5641) {
      var f = cljs.core.first(arglist__5641);
      var coll = cljs.core.first(cljs.core.next(arglist__5641));
      var colls = cljs.core.rest(cljs.core.next(arglist__5641));
      return G__5640__delegate(f, coll, colls)
    };
    G__5640.cljs$lang$arity$variadic = G__5640__delegate;
    return G__5640
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5642 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5642)) {
      var s__5643 = temp__3698__auto____5642;
      var f__5644 = cljs.core.first.call(null, s__5643);
      var r__5645 = cljs.core.rest.call(null, s__5643);
      if(cljs.core.truth_(pred.call(null, f__5644))) {
        return cljs.core.cons.call(null, f__5644, filter.call(null, pred, r__5645))
      }else {
        return filter.call(null, pred, r__5645)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5647 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5647.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5646_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5646_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5648__5649 = to;
    if(G__5648__5649 != null) {
      if(function() {
        var or__3548__auto____5650 = G__5648__5649.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5650) {
          return or__3548__auto____5650
        }else {
          return G__5648__5649.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5648__5649.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5648__5649)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5648__5649)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5651__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5651 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5651__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5651.cljs$lang$maxFixedArity = 4;
    G__5651.cljs$lang$applyTo = function(arglist__5652) {
      var f = cljs.core.first(arglist__5652);
      var c1 = cljs.core.first(cljs.core.next(arglist__5652));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5652)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5652))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5652))));
      return G__5651__delegate(f, c1, c2, c3, colls)
    };
    G__5651.cljs$lang$arity$variadic = G__5651__delegate;
    return G__5651
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5653 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5653)) {
        var s__5654 = temp__3698__auto____5653;
        var p__5655 = cljs.core.take.call(null, n, s__5654);
        if(n === cljs.core.count.call(null, p__5655)) {
          return cljs.core.cons.call(null, p__5655, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5654)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5656 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5656)) {
        var s__5657 = temp__3698__auto____5656;
        var p__5658 = cljs.core.take.call(null, n, s__5657);
        if(n === cljs.core.count.call(null, p__5658)) {
          return cljs.core.cons.call(null, p__5658, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5657)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5658, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5659 = cljs.core.lookup_sentinel;
    var m__5660 = m;
    var ks__5661 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5661)) {
        var m__5662 = cljs.core.get.call(null, m__5660, cljs.core.first.call(null, ks__5661), sentinel__5659);
        if(sentinel__5659 === m__5662) {
          return not_found
        }else {
          var G__5663 = sentinel__5659;
          var G__5664 = m__5662;
          var G__5665 = cljs.core.next.call(null, ks__5661);
          sentinel__5659 = G__5663;
          m__5660 = G__5664;
          ks__5661 = G__5665;
          continue
        }
      }else {
        return m__5660
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5666, v) {
  var vec__5667__5668 = p__5666;
  var k__5669 = cljs.core.nth.call(null, vec__5667__5668, 0, null);
  var ks__5670 = cljs.core.nthnext.call(null, vec__5667__5668, 1);
  if(cljs.core.truth_(ks__5670)) {
    return cljs.core.assoc.call(null, m, k__5669, assoc_in.call(null, cljs.core.get.call(null, m, k__5669), ks__5670, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5669, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5671, f, args) {
    var vec__5672__5673 = p__5671;
    var k__5674 = cljs.core.nth.call(null, vec__5672__5673, 0, null);
    var ks__5675 = cljs.core.nthnext.call(null, vec__5672__5673, 1);
    if(cljs.core.truth_(ks__5675)) {
      return cljs.core.assoc.call(null, m, k__5674, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5674), ks__5675, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5674, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5674), args))
    }
  };
  var update_in = function(m, p__5671, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5671, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5676) {
    var m = cljs.core.first(arglist__5676);
    var p__5671 = cljs.core.first(cljs.core.next(arglist__5676));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5676)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5676)));
    return update_in__delegate(m, p__5671, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5681 = this;
  var h__364__auto____5682 = this__5681.__hash;
  if(h__364__auto____5682 != null) {
    return h__364__auto____5682
  }else {
    var h__364__auto____5683 = cljs.core.hash_coll.call(null, coll);
    this__5681.__hash = h__364__auto____5683;
    return h__364__auto____5683
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5684 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5685 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5686 = this;
  var new_array__5687 = cljs.core.aclone.call(null, this__5686.array);
  new_array__5687[k] = v;
  return new cljs.core.Vector(this__5686.meta, new_array__5687, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5716 = null;
  var G__5716__2 = function(tsym5679, k) {
    var this__5688 = this;
    var tsym5679__5689 = this;
    var coll__5690 = tsym5679__5689;
    return cljs.core._lookup.call(null, coll__5690, k)
  };
  var G__5716__3 = function(tsym5680, k, not_found) {
    var this__5691 = this;
    var tsym5680__5692 = this;
    var coll__5693 = tsym5680__5692;
    return cljs.core._lookup.call(null, coll__5693, k, not_found)
  };
  G__5716 = function(tsym5680, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5716__2.call(this, tsym5680, k);
      case 3:
        return G__5716__3.call(this, tsym5680, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5716
}();
cljs.core.Vector.prototype.apply = function(tsym5677, args5678) {
  return tsym5677.call.apply(tsym5677, [tsym5677].concat(cljs.core.aclone.call(null, args5678)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5694 = this;
  var new_array__5695 = cljs.core.aclone.call(null, this__5694.array);
  new_array__5695.push(o);
  return new cljs.core.Vector(this__5694.meta, new_array__5695, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5696 = this;
  var this$__5697 = this;
  return cljs.core.pr_str.call(null, this$__5697)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5698 = this;
  return cljs.core.ci_reduce.call(null, this__5698.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5699 = this;
  return cljs.core.ci_reduce.call(null, this__5699.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5700 = this;
  if(this__5700.array.length > 0) {
    var vector_seq__5701 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5700.array.length) {
          return cljs.core.cons.call(null, this__5700.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5701.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5702 = this;
  return this__5702.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5703 = this;
  var count__5704 = this__5703.array.length;
  if(count__5704 > 0) {
    return this__5703.array[count__5704 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5705 = this;
  if(this__5705.array.length > 0) {
    var new_array__5706 = cljs.core.aclone.call(null, this__5705.array);
    new_array__5706.pop();
    return new cljs.core.Vector(this__5705.meta, new_array__5706, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5707 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5708 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5709 = this;
  return new cljs.core.Vector(meta, this__5709.array, this__5709.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5710 = this;
  return this__5710.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5712 = this;
  if(function() {
    var and__3546__auto____5713 = 0 <= n;
    if(and__3546__auto____5713) {
      return n < this__5712.array.length
    }else {
      return and__3546__auto____5713
    }
  }()) {
    return this__5712.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5714 = this;
  if(function() {
    var and__3546__auto____5715 = 0 <= n;
    if(and__3546__auto____5715) {
      return n < this__5714.array.length
    }else {
      return and__3546__auto____5715
    }
  }()) {
    return this__5714.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5711 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5711.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5717 = pv.cnt;
  if(cnt__5717 < 32) {
    return 0
  }else {
    return cnt__5717 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5718 = level;
  var ret__5719 = node;
  while(true) {
    if(ll__5718 === 0) {
      return ret__5719
    }else {
      var embed__5720 = ret__5719;
      var r__5721 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5722 = cljs.core.pv_aset.call(null, r__5721, 0, embed__5720);
      var G__5723 = ll__5718 - 5;
      var G__5724 = r__5721;
      ll__5718 = G__5723;
      ret__5719 = G__5724;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5725 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5726 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5725, subidx__5726, tailnode);
    return ret__5725
  }else {
    var temp__3695__auto____5727 = cljs.core.pv_aget.call(null, parent, subidx__5726);
    if(cljs.core.truth_(temp__3695__auto____5727)) {
      var child__5728 = temp__3695__auto____5727;
      var node_to_insert__5729 = push_tail.call(null, pv, level - 5, child__5728, tailnode);
      cljs.core.pv_aset.call(null, ret__5725, subidx__5726, node_to_insert__5729);
      return ret__5725
    }else {
      var node_to_insert__5730 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5725, subidx__5726, node_to_insert__5730);
      return ret__5725
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5731 = 0 <= i;
    if(and__3546__auto____5731) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5731
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5732 = pv.root;
      var level__5733 = pv.shift;
      while(true) {
        if(level__5733 > 0) {
          var G__5734 = cljs.core.pv_aget.call(null, node__5732, i >>> level__5733 & 31);
          var G__5735 = level__5733 - 5;
          node__5732 = G__5734;
          level__5733 = G__5735;
          continue
        }else {
          return node__5732.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5736 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5736, i & 31, val);
    return ret__5736
  }else {
    var subidx__5737 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5736, subidx__5737, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5737), i, val));
    return ret__5736
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5738 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5739 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5738));
    if(function() {
      var and__3546__auto____5740 = new_child__5739 == null;
      if(and__3546__auto____5740) {
        return subidx__5738 === 0
      }else {
        return and__3546__auto____5740
      }
    }()) {
      return null
    }else {
      var ret__5741 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5741, subidx__5738, new_child__5739);
      return ret__5741
    }
  }else {
    if(subidx__5738 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5742 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5742, subidx__5738, null);
        return ret__5742
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5743 = cljs.core._count.call(null, v);
  if(c__5743 > 0) {
    if(void 0 === cljs.core.t5744) {
      cljs.core.t5744 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5744.cljs$lang$type = true;
      cljs.core.t5744.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5744")
      };
      cljs.core.t5744.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5744.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5745 = this;
        return vseq
      };
      cljs.core.t5744.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5744.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5746 = this;
        return cljs.core._nth.call(null, this__5746.v, this__5746.offset)
      };
      cljs.core.t5744.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5747 = this;
        var offset__5748 = this__5747.offset + 1;
        if(offset__5748 < this__5747.c) {
          return this__5747.vector_seq.call(null, this__5747.v, offset__5748)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5744.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5744.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5744.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5749 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5744.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5744.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5744.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5750 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5744.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5744.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5751 = this;
        return this__5751.__meta__389__auto__
      };
      cljs.core.t5744.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5744.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5752 = this;
        return new cljs.core.t5744(this__5752.c, this__5752.offset, this__5752.v, this__5752.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5744
    }else {
    }
    return new cljs.core.t5744(c__5743, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5757 = this;
  return new cljs.core.TransientVector(this__5757.cnt, this__5757.shift, cljs.core.tv_editable_root.call(null, this__5757.root), cljs.core.tv_editable_tail.call(null, this__5757.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5758 = this;
  var h__364__auto____5759 = this__5758.__hash;
  if(h__364__auto____5759 != null) {
    return h__364__auto____5759
  }else {
    var h__364__auto____5760 = cljs.core.hash_coll.call(null, coll);
    this__5758.__hash = h__364__auto____5760;
    return h__364__auto____5760
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5761 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5762 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5763 = this;
  if(function() {
    var and__3546__auto____5764 = 0 <= k;
    if(and__3546__auto____5764) {
      return k < this__5763.cnt
    }else {
      return and__3546__auto____5764
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5765 = cljs.core.aclone.call(null, this__5763.tail);
      new_tail__5765[k & 31] = v;
      return new cljs.core.PersistentVector(this__5763.meta, this__5763.cnt, this__5763.shift, this__5763.root, new_tail__5765, null)
    }else {
      return new cljs.core.PersistentVector(this__5763.meta, this__5763.cnt, this__5763.shift, cljs.core.do_assoc.call(null, coll, this__5763.shift, this__5763.root, k, v), this__5763.tail, null)
    }
  }else {
    if(k === this__5763.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5763.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5810 = null;
  var G__5810__2 = function(tsym5755, k) {
    var this__5766 = this;
    var tsym5755__5767 = this;
    var coll__5768 = tsym5755__5767;
    return cljs.core._lookup.call(null, coll__5768, k)
  };
  var G__5810__3 = function(tsym5756, k, not_found) {
    var this__5769 = this;
    var tsym5756__5770 = this;
    var coll__5771 = tsym5756__5770;
    return cljs.core._lookup.call(null, coll__5771, k, not_found)
  };
  G__5810 = function(tsym5756, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5810__2.call(this, tsym5756, k);
      case 3:
        return G__5810__3.call(this, tsym5756, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5810
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5753, args5754) {
  return tsym5753.call.apply(tsym5753, [tsym5753].concat(cljs.core.aclone.call(null, args5754)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5772 = this;
  var step_init__5773 = [0, init];
  var i__5774 = 0;
  while(true) {
    if(i__5774 < this__5772.cnt) {
      var arr__5775 = cljs.core.array_for.call(null, v, i__5774);
      var len__5776 = arr__5775.length;
      var init__5780 = function() {
        var j__5777 = 0;
        var init__5778 = step_init__5773[1];
        while(true) {
          if(j__5777 < len__5776) {
            var init__5779 = f.call(null, init__5778, j__5777 + i__5774, arr__5775[j__5777]);
            if(cljs.core.reduced_QMARK_.call(null, init__5779)) {
              return init__5779
            }else {
              var G__5811 = j__5777 + 1;
              var G__5812 = init__5779;
              j__5777 = G__5811;
              init__5778 = G__5812;
              continue
            }
          }else {
            step_init__5773[0] = len__5776;
            step_init__5773[1] = init__5778;
            return init__5778
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5780)) {
        return cljs.core.deref.call(null, init__5780)
      }else {
        var G__5813 = i__5774 + step_init__5773[0];
        i__5774 = G__5813;
        continue
      }
    }else {
      return step_init__5773[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5781 = this;
  if(this__5781.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5782 = cljs.core.aclone.call(null, this__5781.tail);
    new_tail__5782.push(o);
    return new cljs.core.PersistentVector(this__5781.meta, this__5781.cnt + 1, this__5781.shift, this__5781.root, new_tail__5782, null)
  }else {
    var root_overflow_QMARK___5783 = this__5781.cnt >>> 5 > 1 << this__5781.shift;
    var new_shift__5784 = root_overflow_QMARK___5783 ? this__5781.shift + 5 : this__5781.shift;
    var new_root__5786 = root_overflow_QMARK___5783 ? function() {
      var n_r__5785 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5785, 0, this__5781.root);
      cljs.core.pv_aset.call(null, n_r__5785, 1, cljs.core.new_path.call(null, null, this__5781.shift, new cljs.core.VectorNode(null, this__5781.tail)));
      return n_r__5785
    }() : cljs.core.push_tail.call(null, coll, this__5781.shift, this__5781.root, new cljs.core.VectorNode(null, this__5781.tail));
    return new cljs.core.PersistentVector(this__5781.meta, this__5781.cnt + 1, new_shift__5784, new_root__5786, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5787 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5788 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5789 = this;
  var this$__5790 = this;
  return cljs.core.pr_str.call(null, this$__5790)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5791 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5792 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5793 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5794 = this;
  return this__5794.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5795 = this;
  if(this__5795.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5795.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5796 = this;
  if(this__5796.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5796.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5796.meta)
    }else {
      if(1 < this__5796.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5796.meta, this__5796.cnt - 1, this__5796.shift, this__5796.root, this__5796.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5797 = cljs.core.array_for.call(null, coll, this__5796.cnt - 2);
          var nr__5798 = cljs.core.pop_tail.call(null, coll, this__5796.shift, this__5796.root);
          var new_root__5799 = nr__5798 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5798;
          var cnt_1__5800 = this__5796.cnt - 1;
          if(function() {
            var and__3546__auto____5801 = 5 < this__5796.shift;
            if(and__3546__auto____5801) {
              return cljs.core.pv_aget.call(null, new_root__5799, 1) == null
            }else {
              return and__3546__auto____5801
            }
          }()) {
            return new cljs.core.PersistentVector(this__5796.meta, cnt_1__5800, this__5796.shift - 5, cljs.core.pv_aget.call(null, new_root__5799, 0), new_tail__5797, null)
          }else {
            return new cljs.core.PersistentVector(this__5796.meta, cnt_1__5800, this__5796.shift, new_root__5799, new_tail__5797, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5803 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5804 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5805 = this;
  return new cljs.core.PersistentVector(meta, this__5805.cnt, this__5805.shift, this__5805.root, this__5805.tail, this__5805.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5806 = this;
  return this__5806.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5807 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5808 = this;
  if(function() {
    var and__3546__auto____5809 = 0 <= n;
    if(and__3546__auto____5809) {
      return n < this__5808.cnt
    }else {
      return and__3546__auto____5809
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5802 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5802.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5814 = cljs.core.seq.call(null, xs);
  var out__5815 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5814)) {
      var G__5816 = cljs.core.next.call(null, xs__5814);
      var G__5817 = cljs.core.conj_BANG_.call(null, out__5815, cljs.core.first.call(null, xs__5814));
      xs__5814 = G__5816;
      out__5815 = G__5817;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5815)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__5818) {
    var args = cljs.core.seq(arglist__5818);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5823 = this;
  var h__364__auto____5824 = this__5823.__hash;
  if(h__364__auto____5824 != null) {
    return h__364__auto____5824
  }else {
    var h__364__auto____5825 = cljs.core.hash_coll.call(null, coll);
    this__5823.__hash = h__364__auto____5825;
    return h__364__auto____5825
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5826 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5827 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__5828 = this;
  var v_pos__5829 = this__5828.start + key;
  return new cljs.core.Subvec(this__5828.meta, cljs.core._assoc.call(null, this__5828.v, v_pos__5829, val), this__5828.start, this__5828.end > v_pos__5829 + 1 ? this__5828.end : v_pos__5829 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__5853 = null;
  var G__5853__2 = function(tsym5821, k) {
    var this__5830 = this;
    var tsym5821__5831 = this;
    var coll__5832 = tsym5821__5831;
    return cljs.core._lookup.call(null, coll__5832, k)
  };
  var G__5853__3 = function(tsym5822, k, not_found) {
    var this__5833 = this;
    var tsym5822__5834 = this;
    var coll__5835 = tsym5822__5834;
    return cljs.core._lookup.call(null, coll__5835, k, not_found)
  };
  G__5853 = function(tsym5822, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5853__2.call(this, tsym5822, k);
      case 3:
        return G__5853__3.call(this, tsym5822, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5853
}();
cljs.core.Subvec.prototype.apply = function(tsym5819, args5820) {
  return tsym5819.call.apply(tsym5819, [tsym5819].concat(cljs.core.aclone.call(null, args5820)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5836 = this;
  return new cljs.core.Subvec(this__5836.meta, cljs.core._assoc_n.call(null, this__5836.v, this__5836.end, o), this__5836.start, this__5836.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__5837 = this;
  var this$__5838 = this;
  return cljs.core.pr_str.call(null, this$__5838)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5839 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5840 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5841 = this;
  var subvec_seq__5842 = function subvec_seq(i) {
    if(i === this__5841.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__5841.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__5842.call(null, this__5841.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5843 = this;
  return this__5843.end - this__5843.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5844 = this;
  return cljs.core._nth.call(null, this__5844.v, this__5844.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5845 = this;
  if(this__5845.start === this__5845.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__5845.meta, this__5845.v, this__5845.start, this__5845.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5846 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5847 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5848 = this;
  return new cljs.core.Subvec(meta, this__5848.v, this__5848.start, this__5848.end, this__5848.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5849 = this;
  return this__5849.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5851 = this;
  return cljs.core._nth.call(null, this__5851.v, this__5851.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5852 = this;
  return cljs.core._nth.call(null, this__5852.v, this__5852.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5850 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5850.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__5854 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__5854, 0, tl.length);
  return ret__5854
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__5855 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__5856 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__5855, subidx__5856, level === 5 ? tail_node : function() {
    var child__5857 = cljs.core.pv_aget.call(null, ret__5855, subidx__5856);
    if(child__5857 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__5857, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__5855
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__5858 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__5859 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5860 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__5858, subidx__5859));
    if(function() {
      var and__3546__auto____5861 = new_child__5860 == null;
      if(and__3546__auto____5861) {
        return subidx__5859 === 0
      }else {
        return and__3546__auto____5861
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__5858, subidx__5859, new_child__5860);
      return node__5858
    }
  }else {
    if(subidx__5859 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__5858, subidx__5859, null);
        return node__5858
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____5862 = 0 <= i;
    if(and__3546__auto____5862) {
      return i < tv.cnt
    }else {
      return and__3546__auto____5862
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__5863 = tv.root;
      var node__5864 = root__5863;
      var level__5865 = tv.shift;
      while(true) {
        if(level__5865 > 0) {
          var G__5866 = cljs.core.tv_ensure_editable.call(null, root__5863.edit, cljs.core.pv_aget.call(null, node__5864, i >>> level__5865 & 31));
          var G__5867 = level__5865 - 5;
          node__5864 = G__5866;
          level__5865 = G__5867;
          continue
        }else {
          return node__5864.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__5905 = null;
  var G__5905__2 = function(tsym5870, k) {
    var this__5872 = this;
    var tsym5870__5873 = this;
    var coll__5874 = tsym5870__5873;
    return cljs.core._lookup.call(null, coll__5874, k)
  };
  var G__5905__3 = function(tsym5871, k, not_found) {
    var this__5875 = this;
    var tsym5871__5876 = this;
    var coll__5877 = tsym5871__5876;
    return cljs.core._lookup.call(null, coll__5877, k, not_found)
  };
  G__5905 = function(tsym5871, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5905__2.call(this, tsym5871, k);
      case 3:
        return G__5905__3.call(this, tsym5871, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5905
}();
cljs.core.TransientVector.prototype.apply = function(tsym5868, args5869) {
  return tsym5868.call.apply(tsym5868, [tsym5868].concat(cljs.core.aclone.call(null, args5869)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5878 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5879 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5880 = this;
  if(cljs.core.truth_(this__5880.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5881 = this;
  if(function() {
    var and__3546__auto____5882 = 0 <= n;
    if(and__3546__auto____5882) {
      return n < this__5881.cnt
    }else {
      return and__3546__auto____5882
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5883 = this;
  if(cljs.core.truth_(this__5883.root.edit)) {
    return this__5883.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__5884 = this;
  if(cljs.core.truth_(this__5884.root.edit)) {
    if(function() {
      var and__3546__auto____5885 = 0 <= n;
      if(and__3546__auto____5885) {
        return n < this__5884.cnt
      }else {
        return and__3546__auto____5885
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__5884.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__5888 = function go(level, node) {
          var node__5886 = cljs.core.tv_ensure_editable.call(null, this__5884.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__5886, n & 31, val);
            return node__5886
          }else {
            var subidx__5887 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__5886, subidx__5887, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__5886, subidx__5887)));
            return node__5886
          }
        }.call(null, this__5884.shift, this__5884.root);
        this__5884.root = new_root__5888;
        return tcoll
      }
    }else {
      if(n === this__5884.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__5884.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__5889 = this;
  if(cljs.core.truth_(this__5889.root.edit)) {
    if(this__5889.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__5889.cnt) {
        this__5889.cnt = 0;
        return tcoll
      }else {
        if((this__5889.cnt - 1 & 31) > 0) {
          this__5889.cnt = this__5889.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__5890 = cljs.core.editable_array_for.call(null, tcoll, this__5889.cnt - 2);
            var new_root__5892 = function() {
              var nr__5891 = cljs.core.tv_pop_tail.call(null, tcoll, this__5889.shift, this__5889.root);
              if(nr__5891 != null) {
                return nr__5891
              }else {
                return new cljs.core.VectorNode(this__5889.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____5893 = 5 < this__5889.shift;
              if(and__3546__auto____5893) {
                return cljs.core.pv_aget.call(null, new_root__5892, 1) == null
              }else {
                return and__3546__auto____5893
              }
            }()) {
              var new_root__5894 = cljs.core.tv_ensure_editable.call(null, this__5889.root.edit, cljs.core.pv_aget.call(null, new_root__5892, 0));
              this__5889.root = new_root__5894;
              this__5889.shift = this__5889.shift - 5;
              this__5889.cnt = this__5889.cnt - 1;
              this__5889.tail = new_tail__5890;
              return tcoll
            }else {
              this__5889.root = new_root__5892;
              this__5889.cnt = this__5889.cnt - 1;
              this__5889.tail = new_tail__5890;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__5895 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__5896 = this;
  if(cljs.core.truth_(this__5896.root.edit)) {
    if(this__5896.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__5896.tail[this__5896.cnt & 31] = o;
      this__5896.cnt = this__5896.cnt + 1;
      return tcoll
    }else {
      var tail_node__5897 = new cljs.core.VectorNode(this__5896.root.edit, this__5896.tail);
      var new_tail__5898 = cljs.core.make_array.call(null, 32);
      new_tail__5898[0] = o;
      this__5896.tail = new_tail__5898;
      if(this__5896.cnt >>> 5 > 1 << this__5896.shift) {
        var new_root_array__5899 = cljs.core.make_array.call(null, 32);
        var new_shift__5900 = this__5896.shift + 5;
        new_root_array__5899[0] = this__5896.root;
        new_root_array__5899[1] = cljs.core.new_path.call(null, this__5896.root.edit, this__5896.shift, tail_node__5897);
        this__5896.root = new cljs.core.VectorNode(this__5896.root.edit, new_root_array__5899);
        this__5896.shift = new_shift__5900;
        this__5896.cnt = this__5896.cnt + 1;
        return tcoll
      }else {
        var new_root__5901 = cljs.core.tv_push_tail.call(null, tcoll, this__5896.shift, this__5896.root, tail_node__5897);
        this__5896.root = new_root__5901;
        this__5896.cnt = this__5896.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__5902 = this;
  if(cljs.core.truth_(this__5902.root.edit)) {
    this__5902.root.edit = null;
    var len__5903 = this__5902.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__5904 = cljs.core.make_array.call(null, len__5903);
    cljs.core.array_copy.call(null, this__5902.tail, 0, trimmed_tail__5904, 0, len__5903);
    return new cljs.core.PersistentVector(null, this__5902.cnt, this__5902.shift, this__5902.root, trimmed_tail__5904, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5906 = this;
  var h__364__auto____5907 = this__5906.__hash;
  if(h__364__auto____5907 != null) {
    return h__364__auto____5907
  }else {
    var h__364__auto____5908 = cljs.core.hash_coll.call(null, coll);
    this__5906.__hash = h__364__auto____5908;
    return h__364__auto____5908
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5909 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__5910 = this;
  var this$__5911 = this;
  return cljs.core.pr_str.call(null, this$__5911)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5912 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5913 = this;
  return cljs.core._first.call(null, this__5913.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5914 = this;
  var temp__3695__auto____5915 = cljs.core.next.call(null, this__5914.front);
  if(cljs.core.truth_(temp__3695__auto____5915)) {
    var f1__5916 = temp__3695__auto____5915;
    return new cljs.core.PersistentQueueSeq(this__5914.meta, f1__5916, this__5914.rear, null)
  }else {
    if(this__5914.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__5914.meta, this__5914.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5917 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5918 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__5918.front, this__5918.rear, this__5918.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5919 = this;
  return this__5919.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5920 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5920.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5921 = this;
  var h__364__auto____5922 = this__5921.__hash;
  if(h__364__auto____5922 != null) {
    return h__364__auto____5922
  }else {
    var h__364__auto____5923 = cljs.core.hash_coll.call(null, coll);
    this__5921.__hash = h__364__auto____5923;
    return h__364__auto____5923
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5924 = this;
  if(cljs.core.truth_(this__5924.front)) {
    return new cljs.core.PersistentQueue(this__5924.meta, this__5924.count + 1, this__5924.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____5925 = this__5924.rear;
      if(cljs.core.truth_(or__3548__auto____5925)) {
        return or__3548__auto____5925
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__5924.meta, this__5924.count + 1, cljs.core.conj.call(null, this__5924.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__5926 = this;
  var this$__5927 = this;
  return cljs.core.pr_str.call(null, this$__5927)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5928 = this;
  var rear__5929 = cljs.core.seq.call(null, this__5928.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____5930 = this__5928.front;
    if(cljs.core.truth_(or__3548__auto____5930)) {
      return or__3548__auto____5930
    }else {
      return rear__5929
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__5928.front, cljs.core.seq.call(null, rear__5929), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5931 = this;
  return this__5931.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5932 = this;
  return cljs.core._first.call(null, this__5932.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5933 = this;
  if(cljs.core.truth_(this__5933.front)) {
    var temp__3695__auto____5934 = cljs.core.next.call(null, this__5933.front);
    if(cljs.core.truth_(temp__3695__auto____5934)) {
      var f1__5935 = temp__3695__auto____5934;
      return new cljs.core.PersistentQueue(this__5933.meta, this__5933.count - 1, f1__5935, this__5933.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__5933.meta, this__5933.count - 1, cljs.core.seq.call(null, this__5933.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5936 = this;
  return cljs.core.first.call(null, this__5936.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5937 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5938 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5939 = this;
  return new cljs.core.PersistentQueue(meta, this__5939.count, this__5939.front, this__5939.rear, this__5939.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5940 = this;
  return this__5940.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5941 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__5942 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__5943 = array.length;
  var i__5944 = 0;
  while(true) {
    if(i__5944 < len__5943) {
      if(cljs.core._EQ_.call(null, k, array[i__5944])) {
        return i__5944
      }else {
        var G__5945 = i__5944 + incr;
        i__5944 = G__5945;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5946 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____5946)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____5946
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__5947 = cljs.core.hash.call(null, a);
  var b__5948 = cljs.core.hash.call(null, b);
  if(a__5947 < b__5948) {
    return-1
  }else {
    if(a__5947 > b__5948) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__5950 = m.keys;
  var len__5951 = ks__5950.length;
  var so__5952 = m.strobj;
  var out__5953 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__5954 = 0;
  var out__5955 = cljs.core.transient$.call(null, out__5953);
  while(true) {
    if(i__5954 < len__5951) {
      var k__5956 = ks__5950[i__5954];
      var G__5957 = i__5954 + 1;
      var G__5958 = cljs.core.assoc_BANG_.call(null, out__5955, k__5956, so__5952[k__5956]);
      i__5954 = G__5957;
      out__5955 = G__5958;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__5955, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5963 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5964 = this;
  var h__364__auto____5965 = this__5964.__hash;
  if(h__364__auto____5965 != null) {
    return h__364__auto____5965
  }else {
    var h__364__auto____5966 = cljs.core.hash_imap.call(null, coll);
    this__5964.__hash = h__364__auto____5966;
    return h__364__auto____5966
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5967 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5968 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5968.strobj, this__5968.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5969 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___5970 = this__5969.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___5970)) {
      var new_strobj__5971 = goog.object.clone.call(null, this__5969.strobj);
      new_strobj__5971[k] = v;
      return new cljs.core.ObjMap(this__5969.meta, this__5969.keys, new_strobj__5971, this__5969.update_count + 1, null)
    }else {
      if(this__5969.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__5972 = goog.object.clone.call(null, this__5969.strobj);
        var new_keys__5973 = cljs.core.aclone.call(null, this__5969.keys);
        new_strobj__5972[k] = v;
        new_keys__5973.push(k);
        return new cljs.core.ObjMap(this__5969.meta, new_keys__5973, new_strobj__5972, this__5969.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5974 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5974.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__5994 = null;
  var G__5994__2 = function(tsym5961, k) {
    var this__5975 = this;
    var tsym5961__5976 = this;
    var coll__5977 = tsym5961__5976;
    return cljs.core._lookup.call(null, coll__5977, k)
  };
  var G__5994__3 = function(tsym5962, k, not_found) {
    var this__5978 = this;
    var tsym5962__5979 = this;
    var coll__5980 = tsym5962__5979;
    return cljs.core._lookup.call(null, coll__5980, k, not_found)
  };
  G__5994 = function(tsym5962, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5994__2.call(this, tsym5962, k);
      case 3:
        return G__5994__3.call(this, tsym5962, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5994
}();
cljs.core.ObjMap.prototype.apply = function(tsym5959, args5960) {
  return tsym5959.call.apply(tsym5959, [tsym5959].concat(cljs.core.aclone.call(null, args5960)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5981 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__5982 = this;
  var this$__5983 = this;
  return cljs.core.pr_str.call(null, this$__5983)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5984 = this;
  if(this__5984.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__5949_SHARP_) {
      return cljs.core.vector.call(null, p1__5949_SHARP_, this__5984.strobj[p1__5949_SHARP_])
    }, this__5984.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5985 = this;
  return this__5985.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5986 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5987 = this;
  return new cljs.core.ObjMap(meta, this__5987.keys, this__5987.strobj, this__5987.update_count, this__5987.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5988 = this;
  return this__5988.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5989 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__5989.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__5990 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____5991 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____5991)) {
      return this__5990.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____5991
    }
  }())) {
    var new_keys__5992 = cljs.core.aclone.call(null, this__5990.keys);
    var new_strobj__5993 = goog.object.clone.call(null, this__5990.strobj);
    new_keys__5992.splice(cljs.core.scan_array.call(null, 1, k, new_keys__5992), 1);
    cljs.core.js_delete.call(null, new_strobj__5993, k);
    return new cljs.core.ObjMap(this__5990.meta, new_keys__5992, new_strobj__5993, this__5990.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6000 = this;
  var h__364__auto____6001 = this__6000.__hash;
  if(h__364__auto____6001 != null) {
    return h__364__auto____6001
  }else {
    var h__364__auto____6002 = cljs.core.hash_imap.call(null, coll);
    this__6000.__hash = h__364__auto____6002;
    return h__364__auto____6002
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6003 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6004 = this;
  var bucket__6005 = this__6004.hashobj[cljs.core.hash.call(null, k)];
  var i__6006 = cljs.core.truth_(bucket__6005) ? cljs.core.scan_array.call(null, 2, k, bucket__6005) : null;
  if(cljs.core.truth_(i__6006)) {
    return bucket__6005[i__6006 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6007 = this;
  var h__6008 = cljs.core.hash.call(null, k);
  var bucket__6009 = this__6007.hashobj[h__6008];
  if(cljs.core.truth_(bucket__6009)) {
    var new_bucket__6010 = cljs.core.aclone.call(null, bucket__6009);
    var new_hashobj__6011 = goog.object.clone.call(null, this__6007.hashobj);
    new_hashobj__6011[h__6008] = new_bucket__6010;
    var temp__3695__auto____6012 = cljs.core.scan_array.call(null, 2, k, new_bucket__6010);
    if(cljs.core.truth_(temp__3695__auto____6012)) {
      var i__6013 = temp__3695__auto____6012;
      new_bucket__6010[i__6013 + 1] = v;
      return new cljs.core.HashMap(this__6007.meta, this__6007.count, new_hashobj__6011, null)
    }else {
      new_bucket__6010.push(k, v);
      return new cljs.core.HashMap(this__6007.meta, this__6007.count + 1, new_hashobj__6011, null)
    }
  }else {
    var new_hashobj__6014 = goog.object.clone.call(null, this__6007.hashobj);
    new_hashobj__6014[h__6008] = [k, v];
    return new cljs.core.HashMap(this__6007.meta, this__6007.count + 1, new_hashobj__6014, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6015 = this;
  var bucket__6016 = this__6015.hashobj[cljs.core.hash.call(null, k)];
  var i__6017 = cljs.core.truth_(bucket__6016) ? cljs.core.scan_array.call(null, 2, k, bucket__6016) : null;
  if(cljs.core.truth_(i__6017)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6040 = null;
  var G__6040__2 = function(tsym5998, k) {
    var this__6018 = this;
    var tsym5998__6019 = this;
    var coll__6020 = tsym5998__6019;
    return cljs.core._lookup.call(null, coll__6020, k)
  };
  var G__6040__3 = function(tsym5999, k, not_found) {
    var this__6021 = this;
    var tsym5999__6022 = this;
    var coll__6023 = tsym5999__6022;
    return cljs.core._lookup.call(null, coll__6023, k, not_found)
  };
  G__6040 = function(tsym5999, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6040__2.call(this, tsym5999, k);
      case 3:
        return G__6040__3.call(this, tsym5999, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6040
}();
cljs.core.HashMap.prototype.apply = function(tsym5996, args5997) {
  return tsym5996.call.apply(tsym5996, [tsym5996].concat(cljs.core.aclone.call(null, args5997)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6024 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6025 = this;
  var this$__6026 = this;
  return cljs.core.pr_str.call(null, this$__6026)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6027 = this;
  if(this__6027.count > 0) {
    var hashes__6028 = cljs.core.js_keys.call(null, this__6027.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__5995_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6027.hashobj[p1__5995_SHARP_]))
    }, hashes__6028)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6029 = this;
  return this__6029.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6030 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6031 = this;
  return new cljs.core.HashMap(meta, this__6031.count, this__6031.hashobj, this__6031.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6032 = this;
  return this__6032.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6033 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6033.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6034 = this;
  var h__6035 = cljs.core.hash.call(null, k);
  var bucket__6036 = this__6034.hashobj[h__6035];
  var i__6037 = cljs.core.truth_(bucket__6036) ? cljs.core.scan_array.call(null, 2, k, bucket__6036) : null;
  if(cljs.core.not.call(null, i__6037)) {
    return coll
  }else {
    var new_hashobj__6038 = goog.object.clone.call(null, this__6034.hashobj);
    if(3 > bucket__6036.length) {
      cljs.core.js_delete.call(null, new_hashobj__6038, h__6035)
    }else {
      var new_bucket__6039 = cljs.core.aclone.call(null, bucket__6036);
      new_bucket__6039.splice(i__6037, 2);
      new_hashobj__6038[h__6035] = new_bucket__6039
    }
    return new cljs.core.HashMap(this__6034.meta, this__6034.count - 1, new_hashobj__6038, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6041 = ks.length;
  var i__6042 = 0;
  var out__6043 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6042 < len__6041) {
      var G__6044 = i__6042 + 1;
      var G__6045 = cljs.core.assoc.call(null, out__6043, ks[i__6042], vs[i__6042]);
      i__6042 = G__6044;
      out__6043 = G__6045;
      continue
    }else {
      return out__6043
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6046 = m.arr;
  var len__6047 = arr__6046.length;
  var i__6048 = 0;
  while(true) {
    if(len__6047 <= i__6048) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6046[i__6048], k)) {
        return i__6048
      }else {
        if("\ufdd0'else") {
          var G__6049 = i__6048 + 2;
          i__6048 = G__6049;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6054 = this;
  return new cljs.core.TransientArrayMap({}, this__6054.arr.length, cljs.core.aclone.call(null, this__6054.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6055 = this;
  var h__364__auto____6056 = this__6055.__hash;
  if(h__364__auto____6056 != null) {
    return h__364__auto____6056
  }else {
    var h__364__auto____6057 = cljs.core.hash_imap.call(null, coll);
    this__6055.__hash = h__364__auto____6057;
    return h__364__auto____6057
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6058 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6059 = this;
  var idx__6060 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6060 === -1) {
    return not_found
  }else {
    return this__6059.arr[idx__6060 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6061 = this;
  var idx__6062 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6062 === -1) {
    if(this__6061.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6061.meta, this__6061.cnt + 1, function() {
        var G__6063__6064 = cljs.core.aclone.call(null, this__6061.arr);
        G__6063__6064.push(k);
        G__6063__6064.push(v);
        return G__6063__6064
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6061.arr[idx__6062 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6061.meta, this__6061.cnt, function() {
          var G__6065__6066 = cljs.core.aclone.call(null, this__6061.arr);
          G__6065__6066[idx__6062 + 1] = v;
          return G__6065__6066
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6067 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6097 = null;
  var G__6097__2 = function(tsym6052, k) {
    var this__6068 = this;
    var tsym6052__6069 = this;
    var coll__6070 = tsym6052__6069;
    return cljs.core._lookup.call(null, coll__6070, k)
  };
  var G__6097__3 = function(tsym6053, k, not_found) {
    var this__6071 = this;
    var tsym6053__6072 = this;
    var coll__6073 = tsym6053__6072;
    return cljs.core._lookup.call(null, coll__6073, k, not_found)
  };
  G__6097 = function(tsym6053, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6097__2.call(this, tsym6053, k);
      case 3:
        return G__6097__3.call(this, tsym6053, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6097
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6050, args6051) {
  return tsym6050.call.apply(tsym6050, [tsym6050].concat(cljs.core.aclone.call(null, args6051)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6074 = this;
  var len__6075 = this__6074.arr.length;
  var i__6076 = 0;
  var init__6077 = init;
  while(true) {
    if(i__6076 < len__6075) {
      var init__6078 = f.call(null, init__6077, this__6074.arr[i__6076], this__6074.arr[i__6076 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6078)) {
        return cljs.core.deref.call(null, init__6078)
      }else {
        var G__6098 = i__6076 + 2;
        var G__6099 = init__6078;
        i__6076 = G__6098;
        init__6077 = G__6099;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6079 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6080 = this;
  var this$__6081 = this;
  return cljs.core.pr_str.call(null, this$__6081)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6082 = this;
  if(this__6082.cnt > 0) {
    var len__6083 = this__6082.arr.length;
    var array_map_seq__6084 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6083) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6082.arr[i], this__6082.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6084.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6085 = this;
  return this__6085.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6086 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6087 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6087.cnt, this__6087.arr, this__6087.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6088 = this;
  return this__6088.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6089 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6089.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6090 = this;
  var idx__6091 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6091 >= 0) {
    var len__6092 = this__6090.arr.length;
    var new_len__6093 = len__6092 - 2;
    if(new_len__6093 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6094 = cljs.core.make_array.call(null, new_len__6093);
      var s__6095 = 0;
      var d__6096 = 0;
      while(true) {
        if(s__6095 >= len__6092) {
          return new cljs.core.PersistentArrayMap(this__6090.meta, this__6090.cnt - 1, new_arr__6094, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6090.arr[s__6095])) {
            var G__6100 = s__6095 + 2;
            var G__6101 = d__6096;
            s__6095 = G__6100;
            d__6096 = G__6101;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6094[d__6096] = this__6090.arr[s__6095];
              new_arr__6094[d__6096 + 1] = this__6090.arr[s__6095 + 1];
              var G__6102 = s__6095 + 2;
              var G__6103 = d__6096 + 2;
              s__6095 = G__6102;
              d__6096 = G__6103;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6104 = cljs.core.count.call(null, ks);
  var i__6105 = 0;
  var out__6106 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6105 < len__6104) {
      var G__6107 = i__6105 + 1;
      var G__6108 = cljs.core.assoc_BANG_.call(null, out__6106, ks[i__6105], vs[i__6105]);
      i__6105 = G__6107;
      out__6106 = G__6108;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6106)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6109 = this;
  if(cljs.core.truth_(this__6109.editable_QMARK_)) {
    var idx__6110 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6110 >= 0) {
      this__6109.arr[idx__6110] = this__6109.arr[this__6109.len - 2];
      this__6109.arr[idx__6110 + 1] = this__6109.arr[this__6109.len - 1];
      var G__6111__6112 = this__6109.arr;
      G__6111__6112.pop();
      G__6111__6112.pop();
      G__6111__6112;
      this__6109.len = this__6109.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6113 = this;
  if(cljs.core.truth_(this__6113.editable_QMARK_)) {
    var idx__6114 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6114 === -1) {
      if(this__6113.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6113.len = this__6113.len + 2;
        this__6113.arr.push(key);
        this__6113.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6113.len, this__6113.arr), key, val)
      }
    }else {
      if(val === this__6113.arr[idx__6114 + 1]) {
        return tcoll
      }else {
        this__6113.arr[idx__6114 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6115 = this;
  if(cljs.core.truth_(this__6115.editable_QMARK_)) {
    if(function() {
      var G__6116__6117 = o;
      if(G__6116__6117 != null) {
        if(function() {
          var or__3548__auto____6118 = G__6116__6117.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6118) {
            return or__3548__auto____6118
          }else {
            return G__6116__6117.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6116__6117.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6116__6117)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6116__6117)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6119 = cljs.core.seq.call(null, o);
      var tcoll__6120 = tcoll;
      while(true) {
        var temp__3695__auto____6121 = cljs.core.first.call(null, es__6119);
        if(cljs.core.truth_(temp__3695__auto____6121)) {
          var e__6122 = temp__3695__auto____6121;
          var G__6128 = cljs.core.next.call(null, es__6119);
          var G__6129 = cljs.core._assoc_BANG_.call(null, tcoll__6120, cljs.core.key.call(null, e__6122), cljs.core.val.call(null, e__6122));
          es__6119 = G__6128;
          tcoll__6120 = G__6129;
          continue
        }else {
          return tcoll__6120
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6123 = this;
  if(cljs.core.truth_(this__6123.editable_QMARK_)) {
    this__6123.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6123.len, 2), this__6123.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6124 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6125 = this;
  if(cljs.core.truth_(this__6125.editable_QMARK_)) {
    var idx__6126 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6126 === -1) {
      return not_found
    }else {
      return this__6125.arr[idx__6126 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6127 = this;
  if(cljs.core.truth_(this__6127.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6127.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6130 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6131 = 0;
  while(true) {
    if(i__6131 < len) {
      var G__6132 = cljs.core.assoc_BANG_.call(null, out__6130, arr[i__6131], arr[i__6131 + 1]);
      var G__6133 = i__6131 + 2;
      out__6130 = G__6132;
      i__6131 = G__6133;
      continue
    }else {
      return out__6130
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6134__6135 = cljs.core.aclone.call(null, arr);
    G__6134__6135[i] = a;
    return G__6134__6135
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6136__6137 = cljs.core.aclone.call(null, arr);
    G__6136__6137[i] = a;
    G__6136__6137[j] = b;
    return G__6136__6137
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6138 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6138, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6138, 2 * i, new_arr__6138.length - 2 * i);
  return new_arr__6138
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6139 = inode.ensure_editable(edit);
    editable__6139.arr[i] = a;
    return editable__6139
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6140 = inode.ensure_editable(edit);
    editable__6140.arr[i] = a;
    editable__6140.arr[j] = b;
    return editable__6140
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6141 = arr.length;
  var i__6142 = 0;
  var init__6143 = init;
  while(true) {
    if(i__6142 < len__6141) {
      var init__6146 = function() {
        var k__6144 = arr[i__6142];
        if(k__6144 != null) {
          return f.call(null, init__6143, k__6144, arr[i__6142 + 1])
        }else {
          var node__6145 = arr[i__6142 + 1];
          if(node__6145 != null) {
            return node__6145.kv_reduce(f, init__6143)
          }else {
            return init__6143
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6146)) {
        return cljs.core.deref.call(null, init__6146)
      }else {
        var G__6147 = i__6142 + 2;
        var G__6148 = init__6146;
        i__6142 = G__6147;
        init__6143 = G__6148;
        continue
      }
    }else {
      return init__6143
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6149 = this;
  var inode__6150 = this;
  if(this__6149.bitmap === bit) {
    return null
  }else {
    var editable__6151 = inode__6150.ensure_editable(e);
    var earr__6152 = editable__6151.arr;
    var len__6153 = earr__6152.length;
    editable__6151.bitmap = bit ^ editable__6151.bitmap;
    cljs.core.array_copy.call(null, earr__6152, 2 * (i + 1), earr__6152, 2 * i, len__6153 - 2 * (i + 1));
    earr__6152[len__6153 - 2] = null;
    earr__6152[len__6153 - 1] = null;
    return editable__6151
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6154 = this;
  var inode__6155 = this;
  var bit__6156 = 1 << (hash >>> shift & 31);
  var idx__6157 = cljs.core.bitmap_indexed_node_index.call(null, this__6154.bitmap, bit__6156);
  if((this__6154.bitmap & bit__6156) === 0) {
    var n__6158 = cljs.core.bit_count.call(null, this__6154.bitmap);
    if(2 * n__6158 < this__6154.arr.length) {
      var editable__6159 = inode__6155.ensure_editable(edit);
      var earr__6160 = editable__6159.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6160, 2 * idx__6157, earr__6160, 2 * (idx__6157 + 1), 2 * (n__6158 - idx__6157));
      earr__6160[2 * idx__6157] = key;
      earr__6160[2 * idx__6157 + 1] = val;
      editable__6159.bitmap = editable__6159.bitmap | bit__6156;
      return editable__6159
    }else {
      if(n__6158 >= 16) {
        var nodes__6161 = cljs.core.make_array.call(null, 32);
        var jdx__6162 = hash >>> shift & 31;
        nodes__6161[jdx__6162] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6163 = 0;
        var j__6164 = 0;
        while(true) {
          if(i__6163 < 32) {
            if((this__6154.bitmap >>> i__6163 & 1) === 0) {
              var G__6217 = i__6163 + 1;
              var G__6218 = j__6164;
              i__6163 = G__6217;
              j__6164 = G__6218;
              continue
            }else {
              nodes__6161[i__6163] = null != this__6154.arr[j__6164] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6154.arr[j__6164]), this__6154.arr[j__6164], this__6154.arr[j__6164 + 1], added_leaf_QMARK_) : this__6154.arr[j__6164 + 1];
              var G__6219 = i__6163 + 1;
              var G__6220 = j__6164 + 2;
              i__6163 = G__6219;
              j__6164 = G__6220;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6158 + 1, nodes__6161)
      }else {
        if("\ufdd0'else") {
          var new_arr__6165 = cljs.core.make_array.call(null, 2 * (n__6158 + 4));
          cljs.core.array_copy.call(null, this__6154.arr, 0, new_arr__6165, 0, 2 * idx__6157);
          new_arr__6165[2 * idx__6157] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6165[2 * idx__6157 + 1] = val;
          cljs.core.array_copy.call(null, this__6154.arr, 2 * idx__6157, new_arr__6165, 2 * (idx__6157 + 1), 2 * (n__6158 - idx__6157));
          var editable__6166 = inode__6155.ensure_editable(edit);
          editable__6166.arr = new_arr__6165;
          editable__6166.bitmap = editable__6166.bitmap | bit__6156;
          return editable__6166
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6167 = this__6154.arr[2 * idx__6157];
    var val_or_node__6168 = this__6154.arr[2 * idx__6157 + 1];
    if(null == key_or_nil__6167) {
      var n__6169 = val_or_node__6168.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6169 === val_or_node__6168) {
        return inode__6155
      }else {
        return cljs.core.edit_and_set.call(null, inode__6155, edit, 2 * idx__6157 + 1, n__6169)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6167)) {
        if(val === val_or_node__6168) {
          return inode__6155
        }else {
          return cljs.core.edit_and_set.call(null, inode__6155, edit, 2 * idx__6157 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6155, edit, 2 * idx__6157, null, 2 * idx__6157 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6167, val_or_node__6168, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6170 = this;
  var inode__6171 = this;
  return cljs.core.create_inode_seq.call(null, this__6170.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6172 = this;
  var inode__6173 = this;
  var bit__6174 = 1 << (hash >>> shift & 31);
  if((this__6172.bitmap & bit__6174) === 0) {
    return inode__6173
  }else {
    var idx__6175 = cljs.core.bitmap_indexed_node_index.call(null, this__6172.bitmap, bit__6174);
    var key_or_nil__6176 = this__6172.arr[2 * idx__6175];
    var val_or_node__6177 = this__6172.arr[2 * idx__6175 + 1];
    if(null == key_or_nil__6176) {
      var n__6178 = val_or_node__6177.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6178 === val_or_node__6177) {
        return inode__6173
      }else {
        if(null != n__6178) {
          return cljs.core.edit_and_set.call(null, inode__6173, edit, 2 * idx__6175 + 1, n__6178)
        }else {
          if(this__6172.bitmap === bit__6174) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6173.edit_and_remove_pair(edit, bit__6174, idx__6175)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6176)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6173.edit_and_remove_pair(edit, bit__6174, idx__6175)
      }else {
        if("\ufdd0'else") {
          return inode__6173
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6179 = this;
  var inode__6180 = this;
  if(e === this__6179.edit) {
    return inode__6180
  }else {
    var n__6181 = cljs.core.bit_count.call(null, this__6179.bitmap);
    var new_arr__6182 = cljs.core.make_array.call(null, n__6181 < 0 ? 4 : 2 * (n__6181 + 1));
    cljs.core.array_copy.call(null, this__6179.arr, 0, new_arr__6182, 0, 2 * n__6181);
    return new cljs.core.BitmapIndexedNode(e, this__6179.bitmap, new_arr__6182)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6183 = this;
  var inode__6184 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6183.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6221 = null;
  var G__6221__3 = function(shift, hash, key) {
    var this__6185 = this;
    var inode__6186 = this;
    var bit__6187 = 1 << (hash >>> shift & 31);
    if((this__6185.bitmap & bit__6187) === 0) {
      return null
    }else {
      var idx__6188 = cljs.core.bitmap_indexed_node_index.call(null, this__6185.bitmap, bit__6187);
      var key_or_nil__6189 = this__6185.arr[2 * idx__6188];
      var val_or_node__6190 = this__6185.arr[2 * idx__6188 + 1];
      if(null == key_or_nil__6189) {
        return val_or_node__6190.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6189)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6189, val_or_node__6190])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6221__4 = function(shift, hash, key, not_found) {
    var this__6191 = this;
    var inode__6192 = this;
    var bit__6193 = 1 << (hash >>> shift & 31);
    if((this__6191.bitmap & bit__6193) === 0) {
      return not_found
    }else {
      var idx__6194 = cljs.core.bitmap_indexed_node_index.call(null, this__6191.bitmap, bit__6193);
      var key_or_nil__6195 = this__6191.arr[2 * idx__6194];
      var val_or_node__6196 = this__6191.arr[2 * idx__6194 + 1];
      if(null == key_or_nil__6195) {
        return val_or_node__6196.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6195)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6195, val_or_node__6196])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6221 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6221__3.call(this, shift, hash, key);
      case 4:
        return G__6221__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6221
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6197 = this;
  var inode__6198 = this;
  var bit__6199 = 1 << (hash >>> shift & 31);
  if((this__6197.bitmap & bit__6199) === 0) {
    return inode__6198
  }else {
    var idx__6200 = cljs.core.bitmap_indexed_node_index.call(null, this__6197.bitmap, bit__6199);
    var key_or_nil__6201 = this__6197.arr[2 * idx__6200];
    var val_or_node__6202 = this__6197.arr[2 * idx__6200 + 1];
    if(null == key_or_nil__6201) {
      var n__6203 = val_or_node__6202.inode_without(shift + 5, hash, key);
      if(n__6203 === val_or_node__6202) {
        return inode__6198
      }else {
        if(null != n__6203) {
          return new cljs.core.BitmapIndexedNode(null, this__6197.bitmap, cljs.core.clone_and_set.call(null, this__6197.arr, 2 * idx__6200 + 1, n__6203))
        }else {
          if(this__6197.bitmap === bit__6199) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6197.bitmap ^ bit__6199, cljs.core.remove_pair.call(null, this__6197.arr, idx__6200))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6201)) {
        return new cljs.core.BitmapIndexedNode(null, this__6197.bitmap ^ bit__6199, cljs.core.remove_pair.call(null, this__6197.arr, idx__6200))
      }else {
        if("\ufdd0'else") {
          return inode__6198
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6204 = this;
  var inode__6205 = this;
  var bit__6206 = 1 << (hash >>> shift & 31);
  var idx__6207 = cljs.core.bitmap_indexed_node_index.call(null, this__6204.bitmap, bit__6206);
  if((this__6204.bitmap & bit__6206) === 0) {
    var n__6208 = cljs.core.bit_count.call(null, this__6204.bitmap);
    if(n__6208 >= 16) {
      var nodes__6209 = cljs.core.make_array.call(null, 32);
      var jdx__6210 = hash >>> shift & 31;
      nodes__6209[jdx__6210] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6211 = 0;
      var j__6212 = 0;
      while(true) {
        if(i__6211 < 32) {
          if((this__6204.bitmap >>> i__6211 & 1) === 0) {
            var G__6222 = i__6211 + 1;
            var G__6223 = j__6212;
            i__6211 = G__6222;
            j__6212 = G__6223;
            continue
          }else {
            nodes__6209[i__6211] = null != this__6204.arr[j__6212] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6204.arr[j__6212]), this__6204.arr[j__6212], this__6204.arr[j__6212 + 1], added_leaf_QMARK_) : this__6204.arr[j__6212 + 1];
            var G__6224 = i__6211 + 1;
            var G__6225 = j__6212 + 2;
            i__6211 = G__6224;
            j__6212 = G__6225;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6208 + 1, nodes__6209)
    }else {
      var new_arr__6213 = cljs.core.make_array.call(null, 2 * (n__6208 + 1));
      cljs.core.array_copy.call(null, this__6204.arr, 0, new_arr__6213, 0, 2 * idx__6207);
      new_arr__6213[2 * idx__6207] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6213[2 * idx__6207 + 1] = val;
      cljs.core.array_copy.call(null, this__6204.arr, 2 * idx__6207, new_arr__6213, 2 * (idx__6207 + 1), 2 * (n__6208 - idx__6207));
      return new cljs.core.BitmapIndexedNode(null, this__6204.bitmap | bit__6206, new_arr__6213)
    }
  }else {
    var key_or_nil__6214 = this__6204.arr[2 * idx__6207];
    var val_or_node__6215 = this__6204.arr[2 * idx__6207 + 1];
    if(null == key_or_nil__6214) {
      var n__6216 = val_or_node__6215.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6216 === val_or_node__6215) {
        return inode__6205
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6204.bitmap, cljs.core.clone_and_set.call(null, this__6204.arr, 2 * idx__6207 + 1, n__6216))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6214)) {
        if(val === val_or_node__6215) {
          return inode__6205
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6204.bitmap, cljs.core.clone_and_set.call(null, this__6204.arr, 2 * idx__6207 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6204.bitmap, cljs.core.clone_and_set.call(null, this__6204.arr, 2 * idx__6207, null, 2 * idx__6207 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6214, val_or_node__6215, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6226 = array_node.arr;
  var len__6227 = 2 * (array_node.cnt - 1);
  var new_arr__6228 = cljs.core.make_array.call(null, len__6227);
  var i__6229 = 0;
  var j__6230 = 1;
  var bitmap__6231 = 0;
  while(true) {
    if(i__6229 < len__6227) {
      if(function() {
        var and__3546__auto____6232 = i__6229 != idx;
        if(and__3546__auto____6232) {
          return null != arr__6226[i__6229]
        }else {
          return and__3546__auto____6232
        }
      }()) {
        new_arr__6228[j__6230] = arr__6226[i__6229];
        var G__6233 = i__6229 + 1;
        var G__6234 = j__6230 + 2;
        var G__6235 = bitmap__6231 | 1 << i__6229;
        i__6229 = G__6233;
        j__6230 = G__6234;
        bitmap__6231 = G__6235;
        continue
      }else {
        var G__6236 = i__6229 + 1;
        var G__6237 = j__6230;
        var G__6238 = bitmap__6231;
        i__6229 = G__6236;
        j__6230 = G__6237;
        bitmap__6231 = G__6238;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6231, new_arr__6228)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6239 = this;
  var inode__6240 = this;
  var idx__6241 = hash >>> shift & 31;
  var node__6242 = this__6239.arr[idx__6241];
  if(null == node__6242) {
    return new cljs.core.ArrayNode(null, this__6239.cnt + 1, cljs.core.clone_and_set.call(null, this__6239.arr, idx__6241, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6243 = node__6242.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6243 === node__6242) {
      return inode__6240
    }else {
      return new cljs.core.ArrayNode(null, this__6239.cnt, cljs.core.clone_and_set.call(null, this__6239.arr, idx__6241, n__6243))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6244 = this;
  var inode__6245 = this;
  var idx__6246 = hash >>> shift & 31;
  var node__6247 = this__6244.arr[idx__6246];
  if(null != node__6247) {
    var n__6248 = node__6247.inode_without(shift + 5, hash, key);
    if(n__6248 === node__6247) {
      return inode__6245
    }else {
      if(n__6248 == null) {
        if(this__6244.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6245, null, idx__6246)
        }else {
          return new cljs.core.ArrayNode(null, this__6244.cnt - 1, cljs.core.clone_and_set.call(null, this__6244.arr, idx__6246, n__6248))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6244.cnt, cljs.core.clone_and_set.call(null, this__6244.arr, idx__6246, n__6248))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6245
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6280 = null;
  var G__6280__3 = function(shift, hash, key) {
    var this__6249 = this;
    var inode__6250 = this;
    var idx__6251 = hash >>> shift & 31;
    var node__6252 = this__6249.arr[idx__6251];
    if(null != node__6252) {
      return node__6252.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6280__4 = function(shift, hash, key, not_found) {
    var this__6253 = this;
    var inode__6254 = this;
    var idx__6255 = hash >>> shift & 31;
    var node__6256 = this__6253.arr[idx__6255];
    if(null != node__6256) {
      return node__6256.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6280 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6280__3.call(this, shift, hash, key);
      case 4:
        return G__6280__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6280
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6257 = this;
  var inode__6258 = this;
  return cljs.core.create_array_node_seq.call(null, this__6257.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6259 = this;
  var inode__6260 = this;
  if(e === this__6259.edit) {
    return inode__6260
  }else {
    return new cljs.core.ArrayNode(e, this__6259.cnt, cljs.core.aclone.call(null, this__6259.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6261 = this;
  var inode__6262 = this;
  var idx__6263 = hash >>> shift & 31;
  var node__6264 = this__6261.arr[idx__6263];
  if(null == node__6264) {
    var editable__6265 = cljs.core.edit_and_set.call(null, inode__6262, edit, idx__6263, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6265.cnt = editable__6265.cnt + 1;
    return editable__6265
  }else {
    var n__6266 = node__6264.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6266 === node__6264) {
      return inode__6262
    }else {
      return cljs.core.edit_and_set.call(null, inode__6262, edit, idx__6263, n__6266)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6267 = this;
  var inode__6268 = this;
  var idx__6269 = hash >>> shift & 31;
  var node__6270 = this__6267.arr[idx__6269];
  if(null == node__6270) {
    return inode__6268
  }else {
    var n__6271 = node__6270.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6271 === node__6270) {
      return inode__6268
    }else {
      if(null == n__6271) {
        if(this__6267.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6268, edit, idx__6269)
        }else {
          var editable__6272 = cljs.core.edit_and_set.call(null, inode__6268, edit, idx__6269, n__6271);
          editable__6272.cnt = editable__6272.cnt - 1;
          return editable__6272
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6268, edit, idx__6269, n__6271)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6273 = this;
  var inode__6274 = this;
  var len__6275 = this__6273.arr.length;
  var i__6276 = 0;
  var init__6277 = init;
  while(true) {
    if(i__6276 < len__6275) {
      var node__6278 = this__6273.arr[i__6276];
      if(node__6278 != null) {
        var init__6279 = node__6278.kv_reduce(f, init__6277);
        if(cljs.core.reduced_QMARK_.call(null, init__6279)) {
          return cljs.core.deref.call(null, init__6279)
        }else {
          var G__6281 = i__6276 + 1;
          var G__6282 = init__6279;
          i__6276 = G__6281;
          init__6277 = G__6282;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6277
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6283 = 2 * cnt;
  var i__6284 = 0;
  while(true) {
    if(i__6284 < lim__6283) {
      if(cljs.core._EQ_.call(null, key, arr[i__6284])) {
        return i__6284
      }else {
        var G__6285 = i__6284 + 2;
        i__6284 = G__6285;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6286 = this;
  var inode__6287 = this;
  if(hash === this__6286.collision_hash) {
    var idx__6288 = cljs.core.hash_collision_node_find_index.call(null, this__6286.arr, this__6286.cnt, key);
    if(idx__6288 === -1) {
      var len__6289 = this__6286.arr.length;
      var new_arr__6290 = cljs.core.make_array.call(null, len__6289 + 2);
      cljs.core.array_copy.call(null, this__6286.arr, 0, new_arr__6290, 0, len__6289);
      new_arr__6290[len__6289] = key;
      new_arr__6290[len__6289 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6286.collision_hash, this__6286.cnt + 1, new_arr__6290)
    }else {
      if(cljs.core._EQ_.call(null, this__6286.arr[idx__6288], val)) {
        return inode__6287
      }else {
        return new cljs.core.HashCollisionNode(null, this__6286.collision_hash, this__6286.cnt, cljs.core.clone_and_set.call(null, this__6286.arr, idx__6288 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6286.collision_hash >>> shift & 31), [null, inode__6287])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6291 = this;
  var inode__6292 = this;
  var idx__6293 = cljs.core.hash_collision_node_find_index.call(null, this__6291.arr, this__6291.cnt, key);
  if(idx__6293 === -1) {
    return inode__6292
  }else {
    if(this__6291.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6291.collision_hash, this__6291.cnt - 1, cljs.core.remove_pair.call(null, this__6291.arr, cljs.core.quot.call(null, idx__6293, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6320 = null;
  var G__6320__3 = function(shift, hash, key) {
    var this__6294 = this;
    var inode__6295 = this;
    var idx__6296 = cljs.core.hash_collision_node_find_index.call(null, this__6294.arr, this__6294.cnt, key);
    if(idx__6296 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6294.arr[idx__6296])) {
        return cljs.core.PersistentVector.fromArray([this__6294.arr[idx__6296], this__6294.arr[idx__6296 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6320__4 = function(shift, hash, key, not_found) {
    var this__6297 = this;
    var inode__6298 = this;
    var idx__6299 = cljs.core.hash_collision_node_find_index.call(null, this__6297.arr, this__6297.cnt, key);
    if(idx__6299 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6297.arr[idx__6299])) {
        return cljs.core.PersistentVector.fromArray([this__6297.arr[idx__6299], this__6297.arr[idx__6299 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6320 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6320__3.call(this, shift, hash, key);
      case 4:
        return G__6320__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6320
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6300 = this;
  var inode__6301 = this;
  return cljs.core.create_inode_seq.call(null, this__6300.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6321 = null;
  var G__6321__1 = function(e) {
    var this__6302 = this;
    var inode__6303 = this;
    if(e === this__6302.edit) {
      return inode__6303
    }else {
      var new_arr__6304 = cljs.core.make_array.call(null, 2 * (this__6302.cnt + 1));
      cljs.core.array_copy.call(null, this__6302.arr, 0, new_arr__6304, 0, 2 * this__6302.cnt);
      return new cljs.core.HashCollisionNode(e, this__6302.collision_hash, this__6302.cnt, new_arr__6304)
    }
  };
  var G__6321__3 = function(e, count, array) {
    var this__6305 = this;
    var inode__6306 = this;
    if(e === this__6305.edit) {
      this__6305.arr = array;
      this__6305.cnt = count;
      return inode__6306
    }else {
      return new cljs.core.HashCollisionNode(this__6305.edit, this__6305.collision_hash, count, array)
    }
  };
  G__6321 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6321__1.call(this, e);
      case 3:
        return G__6321__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6321
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6307 = this;
  var inode__6308 = this;
  if(hash === this__6307.collision_hash) {
    var idx__6309 = cljs.core.hash_collision_node_find_index.call(null, this__6307.arr, this__6307.cnt, key);
    if(idx__6309 === -1) {
      if(this__6307.arr.length > 2 * this__6307.cnt) {
        var editable__6310 = cljs.core.edit_and_set.call(null, inode__6308, edit, 2 * this__6307.cnt, key, 2 * this__6307.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6310.cnt = editable__6310.cnt + 1;
        return editable__6310
      }else {
        var len__6311 = this__6307.arr.length;
        var new_arr__6312 = cljs.core.make_array.call(null, len__6311 + 2);
        cljs.core.array_copy.call(null, this__6307.arr, 0, new_arr__6312, 0, len__6311);
        new_arr__6312[len__6311] = key;
        new_arr__6312[len__6311 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6308.ensure_editable(edit, this__6307.cnt + 1, new_arr__6312)
      }
    }else {
      if(this__6307.arr[idx__6309 + 1] === val) {
        return inode__6308
      }else {
        return cljs.core.edit_and_set.call(null, inode__6308, edit, idx__6309 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6307.collision_hash >>> shift & 31), [null, inode__6308, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6313 = this;
  var inode__6314 = this;
  var idx__6315 = cljs.core.hash_collision_node_find_index.call(null, this__6313.arr, this__6313.cnt, key);
  if(idx__6315 === -1) {
    return inode__6314
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6313.cnt === 1) {
      return null
    }else {
      var editable__6316 = inode__6314.ensure_editable(edit);
      var earr__6317 = editable__6316.arr;
      earr__6317[idx__6315] = earr__6317[2 * this__6313.cnt - 2];
      earr__6317[idx__6315 + 1] = earr__6317[2 * this__6313.cnt - 1];
      earr__6317[2 * this__6313.cnt - 1] = null;
      earr__6317[2 * this__6313.cnt - 2] = null;
      editable__6316.cnt = editable__6316.cnt - 1;
      return editable__6316
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6318 = this;
  var inode__6319 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6318.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6322 = cljs.core.hash.call(null, key1);
    if(key1hash__6322 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6322, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6323 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6322, key1, val1, added_leaf_QMARK___6323).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6323)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6324 = cljs.core.hash.call(null, key1);
    if(key1hash__6324 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6324, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6325 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6324, key1, val1, added_leaf_QMARK___6325).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6325)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6326 = this;
  var h__364__auto____6327 = this__6326.__hash;
  if(h__364__auto____6327 != null) {
    return h__364__auto____6327
  }else {
    var h__364__auto____6328 = cljs.core.hash_coll.call(null, coll);
    this__6326.__hash = h__364__auto____6328;
    return h__364__auto____6328
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6329 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6330 = this;
  var this$__6331 = this;
  return cljs.core.pr_str.call(null, this$__6331)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6332 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6333 = this;
  if(this__6333.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6333.nodes[this__6333.i], this__6333.nodes[this__6333.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6333.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6334 = this;
  if(this__6334.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6334.nodes, this__6334.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6334.nodes, this__6334.i, cljs.core.next.call(null, this__6334.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6335 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6336 = this;
  return new cljs.core.NodeSeq(meta, this__6336.nodes, this__6336.i, this__6336.s, this__6336.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6337 = this;
  return this__6337.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6338 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6338.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6339 = nodes.length;
      var j__6340 = i;
      while(true) {
        if(j__6340 < len__6339) {
          if(null != nodes[j__6340]) {
            return new cljs.core.NodeSeq(null, nodes, j__6340, null, null)
          }else {
            var temp__3695__auto____6341 = nodes[j__6340 + 1];
            if(cljs.core.truth_(temp__3695__auto____6341)) {
              var node__6342 = temp__3695__auto____6341;
              var temp__3695__auto____6343 = node__6342.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6343)) {
                var node_seq__6344 = temp__3695__auto____6343;
                return new cljs.core.NodeSeq(null, nodes, j__6340 + 2, node_seq__6344, null)
              }else {
                var G__6345 = j__6340 + 2;
                j__6340 = G__6345;
                continue
              }
            }else {
              var G__6346 = j__6340 + 2;
              j__6340 = G__6346;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6347 = this;
  var h__364__auto____6348 = this__6347.__hash;
  if(h__364__auto____6348 != null) {
    return h__364__auto____6348
  }else {
    var h__364__auto____6349 = cljs.core.hash_coll.call(null, coll);
    this__6347.__hash = h__364__auto____6349;
    return h__364__auto____6349
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6350 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6351 = this;
  var this$__6352 = this;
  return cljs.core.pr_str.call(null, this$__6352)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6353 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6354 = this;
  return cljs.core.first.call(null, this__6354.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6355 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6355.nodes, this__6355.i, cljs.core.next.call(null, this__6355.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6356 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6357 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6357.nodes, this__6357.i, this__6357.s, this__6357.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6358 = this;
  return this__6358.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6359 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6359.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6360 = nodes.length;
      var j__6361 = i;
      while(true) {
        if(j__6361 < len__6360) {
          var temp__3695__auto____6362 = nodes[j__6361];
          if(cljs.core.truth_(temp__3695__auto____6362)) {
            var nj__6363 = temp__3695__auto____6362;
            var temp__3695__auto____6364 = nj__6363.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6364)) {
              var ns__6365 = temp__3695__auto____6364;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6361 + 1, ns__6365, null)
            }else {
              var G__6366 = j__6361 + 1;
              j__6361 = G__6366;
              continue
            }
          }else {
            var G__6367 = j__6361 + 1;
            j__6361 = G__6367;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6372 = this;
  return new cljs.core.TransientHashMap({}, this__6372.root, this__6372.cnt, this__6372.has_nil_QMARK_, this__6372.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6373 = this;
  var h__364__auto____6374 = this__6373.__hash;
  if(h__364__auto____6374 != null) {
    return h__364__auto____6374
  }else {
    var h__364__auto____6375 = cljs.core.hash_imap.call(null, coll);
    this__6373.__hash = h__364__auto____6375;
    return h__364__auto____6375
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6376 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6377 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6377.has_nil_QMARK_)) {
      return this__6377.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6377.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6377.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6378 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6379 = this__6378.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6379)) {
        return v === this__6378.nil_val
      }else {
        return and__3546__auto____6379
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6378.meta, cljs.core.truth_(this__6378.has_nil_QMARK_) ? this__6378.cnt : this__6378.cnt + 1, this__6378.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6380 = [false];
    var new_root__6381 = (this__6378.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6378.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6380);
    if(new_root__6381 === this__6378.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6378.meta, cljs.core.truth_(added_leaf_QMARK___6380[0]) ? this__6378.cnt + 1 : this__6378.cnt, new_root__6381, this__6378.has_nil_QMARK_, this__6378.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6382 = this;
  if(k == null) {
    return this__6382.has_nil_QMARK_
  }else {
    if(this__6382.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6382.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6403 = null;
  var G__6403__2 = function(tsym6370, k) {
    var this__6383 = this;
    var tsym6370__6384 = this;
    var coll__6385 = tsym6370__6384;
    return cljs.core._lookup.call(null, coll__6385, k)
  };
  var G__6403__3 = function(tsym6371, k, not_found) {
    var this__6386 = this;
    var tsym6371__6387 = this;
    var coll__6388 = tsym6371__6387;
    return cljs.core._lookup.call(null, coll__6388, k, not_found)
  };
  G__6403 = function(tsym6371, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6403__2.call(this, tsym6371, k);
      case 3:
        return G__6403__3.call(this, tsym6371, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6403
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6368, args6369) {
  return tsym6368.call.apply(tsym6368, [tsym6368].concat(cljs.core.aclone.call(null, args6369)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6389 = this;
  var init__6390 = cljs.core.truth_(this__6389.has_nil_QMARK_) ? f.call(null, init, null, this__6389.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6390)) {
    return cljs.core.deref.call(null, init__6390)
  }else {
    if(null != this__6389.root) {
      return this__6389.root.kv_reduce(f, init__6390)
    }else {
      if("\ufdd0'else") {
        return init__6390
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6391 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6392 = this;
  var this$__6393 = this;
  return cljs.core.pr_str.call(null, this$__6393)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6394 = this;
  if(this__6394.cnt > 0) {
    var s__6395 = null != this__6394.root ? this__6394.root.inode_seq() : null;
    if(cljs.core.truth_(this__6394.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6394.nil_val]), s__6395)
    }else {
      return s__6395
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6396 = this;
  return this__6396.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6397 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6398 = this;
  return new cljs.core.PersistentHashMap(meta, this__6398.cnt, this__6398.root, this__6398.has_nil_QMARK_, this__6398.nil_val, this__6398.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6399 = this;
  return this__6399.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6400 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6400.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6401 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6401.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6401.meta, this__6401.cnt - 1, this__6401.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6401.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6402 = this__6401.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6402 === this__6401.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6401.meta, this__6401.cnt - 1, new_root__6402, this__6401.has_nil_QMARK_, this__6401.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6404 = ks.length;
  var i__6405 = 0;
  var out__6406 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6405 < len__6404) {
      var G__6407 = i__6405 + 1;
      var G__6408 = cljs.core.assoc_BANG_.call(null, out__6406, ks[i__6405], vs[i__6405]);
      i__6405 = G__6407;
      out__6406 = G__6408;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6406)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6409 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6410 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6411 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6412 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6413 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6413.has_nil_QMARK_)) {
      return this__6413.nil_val
    }else {
      return null
    }
  }else {
    if(this__6413.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6413.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6414 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6414.has_nil_QMARK_)) {
      return this__6414.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6414.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6414.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6415 = this;
  if(cljs.core.truth_(this__6415.edit)) {
    return this__6415.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6416 = this;
  var tcoll__6417 = this;
  if(cljs.core.truth_(this__6416.edit)) {
    if(function() {
      var G__6418__6419 = o;
      if(G__6418__6419 != null) {
        if(function() {
          var or__3548__auto____6420 = G__6418__6419.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6420) {
            return or__3548__auto____6420
          }else {
            return G__6418__6419.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6418__6419.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6418__6419)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6418__6419)
      }
    }()) {
      return tcoll__6417.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6421 = cljs.core.seq.call(null, o);
      var tcoll__6422 = tcoll__6417;
      while(true) {
        var temp__3695__auto____6423 = cljs.core.first.call(null, es__6421);
        if(cljs.core.truth_(temp__3695__auto____6423)) {
          var e__6424 = temp__3695__auto____6423;
          var G__6435 = cljs.core.next.call(null, es__6421);
          var G__6436 = tcoll__6422.assoc_BANG_(cljs.core.key.call(null, e__6424), cljs.core.val.call(null, e__6424));
          es__6421 = G__6435;
          tcoll__6422 = G__6436;
          continue
        }else {
          return tcoll__6422
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6425 = this;
  var tcoll__6426 = this;
  if(cljs.core.truth_(this__6425.edit)) {
    if(k == null) {
      if(this__6425.nil_val === v) {
      }else {
        this__6425.nil_val = v
      }
      if(cljs.core.truth_(this__6425.has_nil_QMARK_)) {
      }else {
        this__6425.count = this__6425.count + 1;
        this__6425.has_nil_QMARK_ = true
      }
      return tcoll__6426
    }else {
      var added_leaf_QMARK___6427 = [false];
      var node__6428 = (this__6425.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6425.root).inode_assoc_BANG_(this__6425.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6427);
      if(node__6428 === this__6425.root) {
      }else {
        this__6425.root = node__6428
      }
      if(cljs.core.truth_(added_leaf_QMARK___6427[0])) {
        this__6425.count = this__6425.count + 1
      }else {
      }
      return tcoll__6426
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6429 = this;
  var tcoll__6430 = this;
  if(cljs.core.truth_(this__6429.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6429.has_nil_QMARK_)) {
        this__6429.has_nil_QMARK_ = false;
        this__6429.nil_val = null;
        this__6429.count = this__6429.count - 1;
        return tcoll__6430
      }else {
        return tcoll__6430
      }
    }else {
      if(this__6429.root == null) {
        return tcoll__6430
      }else {
        var removed_leaf_QMARK___6431 = [false];
        var node__6432 = this__6429.root.inode_without_BANG_(this__6429.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6431);
        if(node__6432 === this__6429.root) {
        }else {
          this__6429.root = node__6432
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6431[0])) {
          this__6429.count = this__6429.count - 1
        }else {
        }
        return tcoll__6430
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6433 = this;
  var tcoll__6434 = this;
  if(cljs.core.truth_(this__6433.edit)) {
    this__6433.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6433.count, this__6433.root, this__6433.has_nil_QMARK_, this__6433.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6437 = node;
  var stack__6438 = stack;
  while(true) {
    if(t__6437 != null) {
      var G__6439 = cljs.core.truth_(ascending_QMARK_) ? t__6437.left : t__6437.right;
      var G__6440 = cljs.core.conj.call(null, stack__6438, t__6437);
      t__6437 = G__6439;
      stack__6438 = G__6440;
      continue
    }else {
      return stack__6438
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6441 = this;
  var h__364__auto____6442 = this__6441.__hash;
  if(h__364__auto____6442 != null) {
    return h__364__auto____6442
  }else {
    var h__364__auto____6443 = cljs.core.hash_coll.call(null, coll);
    this__6441.__hash = h__364__auto____6443;
    return h__364__auto____6443
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6444 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6445 = this;
  var this$__6446 = this;
  return cljs.core.pr_str.call(null, this$__6446)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6447 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6448 = this;
  if(this__6448.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6448.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6449 = this;
  return cljs.core.peek.call(null, this__6449.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6450 = this;
  var t__6451 = cljs.core.peek.call(null, this__6450.stack);
  var next_stack__6452 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6450.ascending_QMARK_) ? t__6451.right : t__6451.left, cljs.core.pop.call(null, this__6450.stack), this__6450.ascending_QMARK_);
  if(next_stack__6452 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6452, this__6450.ascending_QMARK_, this__6450.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6453 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6454 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6454.stack, this__6454.ascending_QMARK_, this__6454.cnt, this__6454.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6455 = this;
  return this__6455.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6456 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6456) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6456
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6457 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6457) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6457
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6458 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6458)) {
    return cljs.core.deref.call(null, init__6458)
  }else {
    var init__6459 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6458) : init__6458;
    if(cljs.core.reduced_QMARK_.call(null, init__6459)) {
      return cljs.core.deref.call(null, init__6459)
    }else {
      var init__6460 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6459) : init__6459;
      if(cljs.core.reduced_QMARK_.call(null, init__6460)) {
        return cljs.core.deref.call(null, init__6460)
      }else {
        return init__6460
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6465 = this;
  var h__364__auto____6466 = this__6465.__hash;
  if(h__364__auto____6466 != null) {
    return h__364__auto____6466
  }else {
    var h__364__auto____6467 = cljs.core.hash_coll.call(null, coll);
    this__6465.__hash = h__364__auto____6467;
    return h__364__auto____6467
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6468 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6469 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6470 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6470.key, this__6470.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6517 = null;
  var G__6517__2 = function(tsym6463, k) {
    var this__6471 = this;
    var tsym6463__6472 = this;
    var node__6473 = tsym6463__6472;
    return cljs.core._lookup.call(null, node__6473, k)
  };
  var G__6517__3 = function(tsym6464, k, not_found) {
    var this__6474 = this;
    var tsym6464__6475 = this;
    var node__6476 = tsym6464__6475;
    return cljs.core._lookup.call(null, node__6476, k, not_found)
  };
  G__6517 = function(tsym6464, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6517__2.call(this, tsym6464, k);
      case 3:
        return G__6517__3.call(this, tsym6464, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6517
}();
cljs.core.BlackNode.prototype.apply = function(tsym6461, args6462) {
  return tsym6461.call.apply(tsym6461, [tsym6461].concat(cljs.core.aclone.call(null, args6462)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6477 = this;
  return cljs.core.PersistentVector.fromArray([this__6477.key, this__6477.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6478 = this;
  return this__6478.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6479 = this;
  return this__6479.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6480 = this;
  var node__6481 = this;
  return ins.balance_right(node__6481)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6482 = this;
  var node__6483 = this;
  return new cljs.core.RedNode(this__6482.key, this__6482.val, this__6482.left, this__6482.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6484 = this;
  var node__6485 = this;
  return cljs.core.balance_right_del.call(null, this__6484.key, this__6484.val, this__6484.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6486 = this;
  var node__6487 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6488 = this;
  var node__6489 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6489, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6490 = this;
  var node__6491 = this;
  return cljs.core.balance_left_del.call(null, this__6490.key, this__6490.val, del, this__6490.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6492 = this;
  var node__6493 = this;
  return ins.balance_left(node__6493)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6494 = this;
  var node__6495 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6495, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6518 = null;
  var G__6518__0 = function() {
    var this__6498 = this;
    var this$__6499 = this;
    return cljs.core.pr_str.call(null, this$__6499)
  };
  G__6518 = function() {
    switch(arguments.length) {
      case 0:
        return G__6518__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6518
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6500 = this;
  var node__6501 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6501, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6502 = this;
  var node__6503 = this;
  return node__6503
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6504 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6505 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6506 = this;
  return cljs.core.list.call(null, this__6506.key, this__6506.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6508 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6509 = this;
  return this__6509.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6510 = this;
  return cljs.core.PersistentVector.fromArray([this__6510.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6511 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6511.key, this__6511.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6512 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6513 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6513.key, this__6513.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6514 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6515 = this;
  if(n === 0) {
    return this__6515.key
  }else {
    if(n === 1) {
      return this__6515.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6516 = this;
  if(n === 0) {
    return this__6516.key
  }else {
    if(n === 1) {
      return this__6516.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6507 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6523 = this;
  var h__364__auto____6524 = this__6523.__hash;
  if(h__364__auto____6524 != null) {
    return h__364__auto____6524
  }else {
    var h__364__auto____6525 = cljs.core.hash_coll.call(null, coll);
    this__6523.__hash = h__364__auto____6525;
    return h__364__auto____6525
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6526 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6527 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6528 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6528.key, this__6528.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6575 = null;
  var G__6575__2 = function(tsym6521, k) {
    var this__6529 = this;
    var tsym6521__6530 = this;
    var node__6531 = tsym6521__6530;
    return cljs.core._lookup.call(null, node__6531, k)
  };
  var G__6575__3 = function(tsym6522, k, not_found) {
    var this__6532 = this;
    var tsym6522__6533 = this;
    var node__6534 = tsym6522__6533;
    return cljs.core._lookup.call(null, node__6534, k, not_found)
  };
  G__6575 = function(tsym6522, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6575__2.call(this, tsym6522, k);
      case 3:
        return G__6575__3.call(this, tsym6522, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6575
}();
cljs.core.RedNode.prototype.apply = function(tsym6519, args6520) {
  return tsym6519.call.apply(tsym6519, [tsym6519].concat(cljs.core.aclone.call(null, args6520)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6535 = this;
  return cljs.core.PersistentVector.fromArray([this__6535.key, this__6535.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6536 = this;
  return this__6536.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6537 = this;
  return this__6537.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6538 = this;
  var node__6539 = this;
  return new cljs.core.RedNode(this__6538.key, this__6538.val, this__6538.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6540 = this;
  var node__6541 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6542 = this;
  var node__6543 = this;
  return new cljs.core.RedNode(this__6542.key, this__6542.val, this__6542.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6544 = this;
  var node__6545 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6546 = this;
  var node__6547 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6547, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6548 = this;
  var node__6549 = this;
  return new cljs.core.RedNode(this__6548.key, this__6548.val, del, this__6548.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6550 = this;
  var node__6551 = this;
  return new cljs.core.RedNode(this__6550.key, this__6550.val, ins, this__6550.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6552 = this;
  var node__6553 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6552.left)) {
    return new cljs.core.RedNode(this__6552.key, this__6552.val, this__6552.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6552.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6552.right)) {
      return new cljs.core.RedNode(this__6552.right.key, this__6552.right.val, new cljs.core.BlackNode(this__6552.key, this__6552.val, this__6552.left, this__6552.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6552.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6553, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6576 = null;
  var G__6576__0 = function() {
    var this__6556 = this;
    var this$__6557 = this;
    return cljs.core.pr_str.call(null, this$__6557)
  };
  G__6576 = function() {
    switch(arguments.length) {
      case 0:
        return G__6576__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6576
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6558 = this;
  var node__6559 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6558.right)) {
    return new cljs.core.RedNode(this__6558.key, this__6558.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6558.left, null), this__6558.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6558.left)) {
      return new cljs.core.RedNode(this__6558.left.key, this__6558.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6558.left.left, null), new cljs.core.BlackNode(this__6558.key, this__6558.val, this__6558.left.right, this__6558.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6559, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6560 = this;
  var node__6561 = this;
  return new cljs.core.BlackNode(this__6560.key, this__6560.val, this__6560.left, this__6560.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6562 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6563 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6564 = this;
  return cljs.core.list.call(null, this__6564.key, this__6564.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6566 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6567 = this;
  return this__6567.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6568 = this;
  return cljs.core.PersistentVector.fromArray([this__6568.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6569 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6569.key, this__6569.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6570 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6571 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6571.key, this__6571.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6572 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6573 = this;
  if(n === 0) {
    return this__6573.key
  }else {
    if(n === 1) {
      return this__6573.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6574 = this;
  if(n === 0) {
    return this__6574.key
  }else {
    if(n === 1) {
      return this__6574.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6565 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6577 = comp.call(null, k, tree.key);
    if(c__6577 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6577 < 0) {
        var ins__6578 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6578 != null) {
          return tree.add_left(ins__6578)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6579 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6579 != null) {
            return tree.add_right(ins__6579)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6580 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6580)) {
            return new cljs.core.RedNode(app__6580.key, app__6580.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6580.left), new cljs.core.RedNode(right.key, right.val, app__6580.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6580, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6581 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6581)) {
              return new cljs.core.RedNode(app__6581.key, app__6581.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6581.left, null), new cljs.core.BlackNode(right.key, right.val, app__6581.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6581, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6582 = comp.call(null, k, tree.key);
    if(c__6582 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6582 < 0) {
        var del__6583 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6584 = del__6583 != null;
          if(or__3548__auto____6584) {
            return or__3548__auto____6584
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6583, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6583, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6585 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6586 = del__6585 != null;
            if(or__3548__auto____6586) {
              return or__3548__auto____6586
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6585)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6585, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6587 = tree.key;
  var c__6588 = comp.call(null, k, tk__6587);
  if(c__6588 === 0) {
    return tree.replace(tk__6587, v, tree.left, tree.right)
  }else {
    if(c__6588 < 0) {
      return tree.replace(tk__6587, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6587, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6593 = this;
  var h__364__auto____6594 = this__6593.__hash;
  if(h__364__auto____6594 != null) {
    return h__364__auto____6594
  }else {
    var h__364__auto____6595 = cljs.core.hash_imap.call(null, coll);
    this__6593.__hash = h__364__auto____6595;
    return h__364__auto____6595
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6596 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6597 = this;
  var n__6598 = coll.entry_at(k);
  if(n__6598 != null) {
    return n__6598.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6599 = this;
  var found__6600 = [null];
  var t__6601 = cljs.core.tree_map_add.call(null, this__6599.comp, this__6599.tree, k, v, found__6600);
  if(t__6601 == null) {
    var found_node__6602 = cljs.core.nth.call(null, found__6600, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6602.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6599.comp, cljs.core.tree_map_replace.call(null, this__6599.comp, this__6599.tree, k, v), this__6599.cnt, this__6599.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6599.comp, t__6601.blacken(), this__6599.cnt + 1, this__6599.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6603 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6635 = null;
  var G__6635__2 = function(tsym6591, k) {
    var this__6604 = this;
    var tsym6591__6605 = this;
    var coll__6606 = tsym6591__6605;
    return cljs.core._lookup.call(null, coll__6606, k)
  };
  var G__6635__3 = function(tsym6592, k, not_found) {
    var this__6607 = this;
    var tsym6592__6608 = this;
    var coll__6609 = tsym6592__6608;
    return cljs.core._lookup.call(null, coll__6609, k, not_found)
  };
  G__6635 = function(tsym6592, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6635__2.call(this, tsym6592, k);
      case 3:
        return G__6635__3.call(this, tsym6592, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6635
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6589, args6590) {
  return tsym6589.call.apply(tsym6589, [tsym6589].concat(cljs.core.aclone.call(null, args6590)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6610 = this;
  if(this__6610.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6610.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6611 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6612 = this;
  if(this__6612.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6612.tree, false, this__6612.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6613 = this;
  var this$__6614 = this;
  return cljs.core.pr_str.call(null, this$__6614)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6615 = this;
  var coll__6616 = this;
  var t__6617 = this__6615.tree;
  while(true) {
    if(t__6617 != null) {
      var c__6618 = this__6615.comp.call(null, k, t__6617.key);
      if(c__6618 === 0) {
        return t__6617
      }else {
        if(c__6618 < 0) {
          var G__6636 = t__6617.left;
          t__6617 = G__6636;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6637 = t__6617.right;
            t__6617 = G__6637;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6619 = this;
  if(this__6619.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6619.tree, ascending_QMARK_, this__6619.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6620 = this;
  if(this__6620.cnt > 0) {
    var stack__6621 = null;
    var t__6622 = this__6620.tree;
    while(true) {
      if(t__6622 != null) {
        var c__6623 = this__6620.comp.call(null, k, t__6622.key);
        if(c__6623 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6621, t__6622), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6623 < 0) {
              var G__6638 = cljs.core.conj.call(null, stack__6621, t__6622);
              var G__6639 = t__6622.left;
              stack__6621 = G__6638;
              t__6622 = G__6639;
              continue
            }else {
              var G__6640 = stack__6621;
              var G__6641 = t__6622.right;
              stack__6621 = G__6640;
              t__6622 = G__6641;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6623 > 0) {
                var G__6642 = cljs.core.conj.call(null, stack__6621, t__6622);
                var G__6643 = t__6622.right;
                stack__6621 = G__6642;
                t__6622 = G__6643;
                continue
              }else {
                var G__6644 = stack__6621;
                var G__6645 = t__6622.left;
                stack__6621 = G__6644;
                t__6622 = G__6645;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6621 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6621, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6624 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6625 = this;
  return this__6625.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6626 = this;
  if(this__6626.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6626.tree, true, this__6626.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6627 = this;
  return this__6627.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6628 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6629 = this;
  return new cljs.core.PersistentTreeMap(this__6629.comp, this__6629.tree, this__6629.cnt, meta, this__6629.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6633 = this;
  return this__6633.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6634 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6634.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6630 = this;
  var found__6631 = [null];
  var t__6632 = cljs.core.tree_map_remove.call(null, this__6630.comp, this__6630.tree, k, found__6631);
  if(t__6632 == null) {
    if(cljs.core.nth.call(null, found__6631, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6630.comp, null, 0, this__6630.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6630.comp, t__6632.blacken(), this__6630.cnt - 1, this__6630.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6646 = cljs.core.seq.call(null, keyvals);
    var out__6647 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6646)) {
        var G__6648 = cljs.core.nnext.call(null, in$__6646);
        var G__6649 = cljs.core.assoc_BANG_.call(null, out__6647, cljs.core.first.call(null, in$__6646), cljs.core.second.call(null, in$__6646));
        in$__6646 = G__6648;
        out__6647 = G__6649;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6647)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6650) {
    var keyvals = cljs.core.seq(arglist__6650);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6651) {
    var keyvals = cljs.core.seq(arglist__6651);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6652 = cljs.core.seq.call(null, keyvals);
    var out__6653 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6652)) {
        var G__6654 = cljs.core.nnext.call(null, in$__6652);
        var G__6655 = cljs.core.assoc.call(null, out__6653, cljs.core.first.call(null, in$__6652), cljs.core.second.call(null, in$__6652));
        in$__6652 = G__6654;
        out__6653 = G__6655;
        continue
      }else {
        return out__6653
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6656) {
    var keyvals = cljs.core.seq(arglist__6656);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6657 = cljs.core.seq.call(null, keyvals);
    var out__6658 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6657)) {
        var G__6659 = cljs.core.nnext.call(null, in$__6657);
        var G__6660 = cljs.core.assoc.call(null, out__6658, cljs.core.first.call(null, in$__6657), cljs.core.second.call(null, in$__6657));
        in$__6657 = G__6659;
        out__6658 = G__6660;
        continue
      }else {
        return out__6658
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6661) {
    var comparator = cljs.core.first(arglist__6661);
    var keyvals = cljs.core.rest(arglist__6661);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6662_SHARP_, p2__6663_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6664 = p1__6662_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6664)) {
            return or__3548__auto____6664
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6663_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6665) {
    var maps = cljs.core.seq(arglist__6665);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6668 = function(m, e) {
        var k__6666 = cljs.core.first.call(null, e);
        var v__6667 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6666)) {
          return cljs.core.assoc.call(null, m, k__6666, f.call(null, cljs.core.get.call(null, m, k__6666), v__6667))
        }else {
          return cljs.core.assoc.call(null, m, k__6666, v__6667)
        }
      };
      var merge2__6670 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6668, function() {
          var or__3548__auto____6669 = m1;
          if(cljs.core.truth_(or__3548__auto____6669)) {
            return or__3548__auto____6669
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6670, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6671) {
    var f = cljs.core.first(arglist__6671);
    var maps = cljs.core.rest(arglist__6671);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6672 = cljs.core.ObjMap.fromObject([], {});
  var keys__6673 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6673)) {
      var key__6674 = cljs.core.first.call(null, keys__6673);
      var entry__6675 = cljs.core.get.call(null, map, key__6674, "\ufdd0'user/not-found");
      var G__6676 = cljs.core.not_EQ_.call(null, entry__6675, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6672, key__6674, entry__6675) : ret__6672;
      var G__6677 = cljs.core.next.call(null, keys__6673);
      ret__6672 = G__6676;
      keys__6673 = G__6677;
      continue
    }else {
      return ret__6672
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6683 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6683.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6684 = this;
  var h__364__auto____6685 = this__6684.__hash;
  if(h__364__auto____6685 != null) {
    return h__364__auto____6685
  }else {
    var h__364__auto____6686 = cljs.core.hash_iset.call(null, coll);
    this__6684.__hash = h__364__auto____6686;
    return h__364__auto____6686
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6687 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6688 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6688.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6707 = null;
  var G__6707__2 = function(tsym6681, k) {
    var this__6689 = this;
    var tsym6681__6690 = this;
    var coll__6691 = tsym6681__6690;
    return cljs.core._lookup.call(null, coll__6691, k)
  };
  var G__6707__3 = function(tsym6682, k, not_found) {
    var this__6692 = this;
    var tsym6682__6693 = this;
    var coll__6694 = tsym6682__6693;
    return cljs.core._lookup.call(null, coll__6694, k, not_found)
  };
  G__6707 = function(tsym6682, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6707__2.call(this, tsym6682, k);
      case 3:
        return G__6707__3.call(this, tsym6682, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6707
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6679, args6680) {
  return tsym6679.call.apply(tsym6679, [tsym6679].concat(cljs.core.aclone.call(null, args6680)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6695 = this;
  return new cljs.core.PersistentHashSet(this__6695.meta, cljs.core.assoc.call(null, this__6695.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6696 = this;
  var this$__6697 = this;
  return cljs.core.pr_str.call(null, this$__6697)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6698 = this;
  return cljs.core.keys.call(null, this__6698.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6699 = this;
  return new cljs.core.PersistentHashSet(this__6699.meta, cljs.core.dissoc.call(null, this__6699.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6700 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6701 = this;
  var and__3546__auto____6702 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6702) {
    var and__3546__auto____6703 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6703) {
      return cljs.core.every_QMARK_.call(null, function(p1__6678_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6678_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6703
    }
  }else {
    return and__3546__auto____6702
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6704 = this;
  return new cljs.core.PersistentHashSet(meta, this__6704.hash_map, this__6704.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6705 = this;
  return this__6705.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6706 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6706.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6725 = null;
  var G__6725__2 = function(tsym6711, k) {
    var this__6713 = this;
    var tsym6711__6714 = this;
    var tcoll__6715 = tsym6711__6714;
    if(cljs.core._lookup.call(null, this__6713.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6725__3 = function(tsym6712, k, not_found) {
    var this__6716 = this;
    var tsym6712__6717 = this;
    var tcoll__6718 = tsym6712__6717;
    if(cljs.core._lookup.call(null, this__6716.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6725 = function(tsym6712, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6725__2.call(this, tsym6712, k);
      case 3:
        return G__6725__3.call(this, tsym6712, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6725
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6709, args6710) {
  return tsym6709.call.apply(tsym6709, [tsym6709].concat(cljs.core.aclone.call(null, args6710)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6719 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6720 = this;
  if(cljs.core._lookup.call(null, this__6720.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6721 = this;
  return cljs.core.count.call(null, this__6721.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6722 = this;
  this__6722.transient_map = cljs.core.dissoc_BANG_.call(null, this__6722.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6723 = this;
  this__6723.transient_map = cljs.core.assoc_BANG_.call(null, this__6723.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6724 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6724.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6730 = this;
  var h__364__auto____6731 = this__6730.__hash;
  if(h__364__auto____6731 != null) {
    return h__364__auto____6731
  }else {
    var h__364__auto____6732 = cljs.core.hash_iset.call(null, coll);
    this__6730.__hash = h__364__auto____6732;
    return h__364__auto____6732
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6733 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6734 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6734.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6758 = null;
  var G__6758__2 = function(tsym6728, k) {
    var this__6735 = this;
    var tsym6728__6736 = this;
    var coll__6737 = tsym6728__6736;
    return cljs.core._lookup.call(null, coll__6737, k)
  };
  var G__6758__3 = function(tsym6729, k, not_found) {
    var this__6738 = this;
    var tsym6729__6739 = this;
    var coll__6740 = tsym6729__6739;
    return cljs.core._lookup.call(null, coll__6740, k, not_found)
  };
  G__6758 = function(tsym6729, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6758__2.call(this, tsym6729, k);
      case 3:
        return G__6758__3.call(this, tsym6729, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6758
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6726, args6727) {
  return tsym6726.call.apply(tsym6726, [tsym6726].concat(cljs.core.aclone.call(null, args6727)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6741 = this;
  return new cljs.core.PersistentTreeSet(this__6741.meta, cljs.core.assoc.call(null, this__6741.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6742 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6742.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6743 = this;
  var this$__6744 = this;
  return cljs.core.pr_str.call(null, this$__6744)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6745 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6745.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6746 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6746.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6747 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6748 = this;
  return cljs.core._comparator.call(null, this__6748.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6749 = this;
  return cljs.core.keys.call(null, this__6749.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6750 = this;
  return new cljs.core.PersistentTreeSet(this__6750.meta, cljs.core.dissoc.call(null, this__6750.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6751 = this;
  return cljs.core.count.call(null, this__6751.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6752 = this;
  var and__3546__auto____6753 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6753) {
    var and__3546__auto____6754 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6754) {
      return cljs.core.every_QMARK_.call(null, function(p1__6708_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6708_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6754
    }
  }else {
    return and__3546__auto____6753
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6755 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6755.tree_map, this__6755.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6756 = this;
  return this__6756.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6757 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6757.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6759 = cljs.core.seq.call(null, coll);
  var out__6760 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6759))) {
      var G__6761 = cljs.core.next.call(null, in$__6759);
      var G__6762 = cljs.core.conj_BANG_.call(null, out__6760, cljs.core.first.call(null, in$__6759));
      in$__6759 = G__6761;
      out__6760 = G__6762;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6760)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6763) {
    var keys = cljs.core.seq(arglist__6763);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6765) {
    var comparator = cljs.core.first(arglist__6765);
    var keys = cljs.core.rest(arglist__6765);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6766 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6767 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6767)) {
        var e__6768 = temp__3695__auto____6767;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6768))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6766, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6764_SHARP_) {
      var temp__3695__auto____6769 = cljs.core.find.call(null, smap, p1__6764_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6769)) {
        var e__6770 = temp__3695__auto____6769;
        return cljs.core.second.call(null, e__6770)
      }else {
        return p1__6764_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6778 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6771, seen) {
        while(true) {
          var vec__6772__6773 = p__6771;
          var f__6774 = cljs.core.nth.call(null, vec__6772__6773, 0, null);
          var xs__6775 = vec__6772__6773;
          var temp__3698__auto____6776 = cljs.core.seq.call(null, xs__6775);
          if(cljs.core.truth_(temp__3698__auto____6776)) {
            var s__6777 = temp__3698__auto____6776;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6774)) {
              var G__6779 = cljs.core.rest.call(null, s__6777);
              var G__6780 = seen;
              p__6771 = G__6779;
              seen = G__6780;
              continue
            }else {
              return cljs.core.cons.call(null, f__6774, step.call(null, cljs.core.rest.call(null, s__6777), cljs.core.conj.call(null, seen, f__6774)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6778.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6781 = cljs.core.PersistentVector.fromArray([]);
  var s__6782 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6782))) {
      var G__6783 = cljs.core.conj.call(null, ret__6781, cljs.core.first.call(null, s__6782));
      var G__6784 = cljs.core.next.call(null, s__6782);
      ret__6781 = G__6783;
      s__6782 = G__6784;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6781)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6785 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6785) {
        return or__3548__auto____6785
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6786 = x.lastIndexOf("/");
      if(i__6786 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6786 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6787 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6787) {
      return or__3548__auto____6787
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6788 = x.lastIndexOf("/");
    if(i__6788 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6788)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6791 = cljs.core.ObjMap.fromObject([], {});
  var ks__6792 = cljs.core.seq.call(null, keys);
  var vs__6793 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6794 = ks__6792;
      if(cljs.core.truth_(and__3546__auto____6794)) {
        return vs__6793
      }else {
        return and__3546__auto____6794
      }
    }())) {
      var G__6795 = cljs.core.assoc.call(null, map__6791, cljs.core.first.call(null, ks__6792), cljs.core.first.call(null, vs__6793));
      var G__6796 = cljs.core.next.call(null, ks__6792);
      var G__6797 = cljs.core.next.call(null, vs__6793);
      map__6791 = G__6795;
      ks__6792 = G__6796;
      vs__6793 = G__6797;
      continue
    }else {
      return map__6791
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6800__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6789_SHARP_, p2__6790_SHARP_) {
        return max_key.call(null, k, p1__6789_SHARP_, p2__6790_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6800 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6800__delegate.call(this, k, x, y, more)
    };
    G__6800.cljs$lang$maxFixedArity = 3;
    G__6800.cljs$lang$applyTo = function(arglist__6801) {
      var k = cljs.core.first(arglist__6801);
      var x = cljs.core.first(cljs.core.next(arglist__6801));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6801)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6801)));
      return G__6800__delegate(k, x, y, more)
    };
    G__6800.cljs$lang$arity$variadic = G__6800__delegate;
    return G__6800
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6802__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6798_SHARP_, p2__6799_SHARP_) {
        return min_key.call(null, k, p1__6798_SHARP_, p2__6799_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6802 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6802__delegate.call(this, k, x, y, more)
    };
    G__6802.cljs$lang$maxFixedArity = 3;
    G__6802.cljs$lang$applyTo = function(arglist__6803) {
      var k = cljs.core.first(arglist__6803);
      var x = cljs.core.first(cljs.core.next(arglist__6803));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6803)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6803)));
      return G__6802__delegate(k, x, y, more)
    };
    G__6802.cljs$lang$arity$variadic = G__6802__delegate;
    return G__6802
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6804 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6804)) {
        var s__6805 = temp__3698__auto____6804;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6805), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6805)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6806 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6806)) {
      var s__6807 = temp__3698__auto____6806;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6807)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6807), take_while.call(null, pred, cljs.core.rest.call(null, s__6807)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6808 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6808.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6809 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6810 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6810)) {
        var vec__6811__6812 = temp__3698__auto____6810;
        var e__6813 = cljs.core.nth.call(null, vec__6811__6812, 0, null);
        var s__6814 = vec__6811__6812;
        if(cljs.core.truth_(include__6809.call(null, e__6813))) {
          return s__6814
        }else {
          return cljs.core.next.call(null, s__6814)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6809, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6815 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6815)) {
      var vec__6816__6817 = temp__3698__auto____6815;
      var e__6818 = cljs.core.nth.call(null, vec__6816__6817, 0, null);
      var s__6819 = vec__6816__6817;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__6818)) ? s__6819 : cljs.core.next.call(null, s__6819))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__6820 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____6821 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____6821)) {
        var vec__6822__6823 = temp__3698__auto____6821;
        var e__6824 = cljs.core.nth.call(null, vec__6822__6823, 0, null);
        var s__6825 = vec__6822__6823;
        if(cljs.core.truth_(include__6820.call(null, e__6824))) {
          return s__6825
        }else {
          return cljs.core.next.call(null, s__6825)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6820, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6826 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____6826)) {
      var vec__6827__6828 = temp__3698__auto____6826;
      var e__6829 = cljs.core.nth.call(null, vec__6827__6828, 0, null);
      var s__6830 = vec__6827__6828;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__6829)) ? s__6830 : cljs.core.next.call(null, s__6830))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__6831 = this;
  var h__364__auto____6832 = this__6831.__hash;
  if(h__364__auto____6832 != null) {
    return h__364__auto____6832
  }else {
    var h__364__auto____6833 = cljs.core.hash_coll.call(null, rng);
    this__6831.__hash = h__364__auto____6833;
    return h__364__auto____6833
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__6834 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__6835 = this;
  var this$__6836 = this;
  return cljs.core.pr_str.call(null, this$__6836)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__6837 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__6838 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__6839 = this;
  var comp__6840 = this__6839.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__6840.call(null, this__6839.start, this__6839.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__6841 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__6841.end - this__6841.start) / this__6841.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__6842 = this;
  return this__6842.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__6843 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__6843.meta, this__6843.start + this__6843.step, this__6843.end, this__6843.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__6844 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__6845 = this;
  return new cljs.core.Range(meta, this__6845.start, this__6845.end, this__6845.step, this__6845.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__6846 = this;
  return this__6846.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__6847 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6847.start + n * this__6847.step
  }else {
    if(function() {
      var and__3546__auto____6848 = this__6847.start > this__6847.end;
      if(and__3546__auto____6848) {
        return this__6847.step === 0
      }else {
        return and__3546__auto____6848
      }
    }()) {
      return this__6847.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__6849 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6849.start + n * this__6849.step
  }else {
    if(function() {
      var and__3546__auto____6850 = this__6849.start > this__6849.end;
      if(and__3546__auto____6850) {
        return this__6849.step === 0
      }else {
        return and__3546__auto____6850
      }
    }()) {
      return this__6849.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__6851 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6851.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6852 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6852)) {
      var s__6853 = temp__3698__auto____6852;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__6853), take_nth.call(null, n, cljs.core.drop.call(null, n, s__6853)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6855 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6855)) {
      var s__6856 = temp__3698__auto____6855;
      var fst__6857 = cljs.core.first.call(null, s__6856);
      var fv__6858 = f.call(null, fst__6857);
      var run__6859 = cljs.core.cons.call(null, fst__6857, cljs.core.take_while.call(null, function(p1__6854_SHARP_) {
        return cljs.core._EQ_.call(null, fv__6858, f.call(null, p1__6854_SHARP_))
      }, cljs.core.next.call(null, s__6856)));
      return cljs.core.cons.call(null, run__6859, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__6859), s__6856))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____6870 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____6870)) {
        var s__6871 = temp__3695__auto____6870;
        return reductions.call(null, f, cljs.core.first.call(null, s__6871), cljs.core.rest.call(null, s__6871))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6872 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6872)) {
        var s__6873 = temp__3698__auto____6872;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__6873)), cljs.core.rest.call(null, s__6873))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__6875 = null;
      var G__6875__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__6875__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__6875__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__6875__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__6875__4 = function() {
        var G__6876__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__6876 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6876__delegate.call(this, x, y, z, args)
        };
        G__6876.cljs$lang$maxFixedArity = 3;
        G__6876.cljs$lang$applyTo = function(arglist__6877) {
          var x = cljs.core.first(arglist__6877);
          var y = cljs.core.first(cljs.core.next(arglist__6877));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6877)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6877)));
          return G__6876__delegate(x, y, z, args)
        };
        G__6876.cljs$lang$arity$variadic = G__6876__delegate;
        return G__6876
      }();
      G__6875 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6875__0.call(this);
          case 1:
            return G__6875__1.call(this, x);
          case 2:
            return G__6875__2.call(this, x, y);
          case 3:
            return G__6875__3.call(this, x, y, z);
          default:
            return G__6875__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6875.cljs$lang$maxFixedArity = 3;
      G__6875.cljs$lang$applyTo = G__6875__4.cljs$lang$applyTo;
      return G__6875
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__6878 = null;
      var G__6878__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__6878__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__6878__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__6878__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__6878__4 = function() {
        var G__6879__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__6879 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6879__delegate.call(this, x, y, z, args)
        };
        G__6879.cljs$lang$maxFixedArity = 3;
        G__6879.cljs$lang$applyTo = function(arglist__6880) {
          var x = cljs.core.first(arglist__6880);
          var y = cljs.core.first(cljs.core.next(arglist__6880));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6880)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6880)));
          return G__6879__delegate(x, y, z, args)
        };
        G__6879.cljs$lang$arity$variadic = G__6879__delegate;
        return G__6879
      }();
      G__6878 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6878__0.call(this);
          case 1:
            return G__6878__1.call(this, x);
          case 2:
            return G__6878__2.call(this, x, y);
          case 3:
            return G__6878__3.call(this, x, y, z);
          default:
            return G__6878__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6878.cljs$lang$maxFixedArity = 3;
      G__6878.cljs$lang$applyTo = G__6878__4.cljs$lang$applyTo;
      return G__6878
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__6881 = null;
      var G__6881__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__6881__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__6881__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__6881__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__6881__4 = function() {
        var G__6882__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__6882 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6882__delegate.call(this, x, y, z, args)
        };
        G__6882.cljs$lang$maxFixedArity = 3;
        G__6882.cljs$lang$applyTo = function(arglist__6883) {
          var x = cljs.core.first(arglist__6883);
          var y = cljs.core.first(cljs.core.next(arglist__6883));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6883)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6883)));
          return G__6882__delegate(x, y, z, args)
        };
        G__6882.cljs$lang$arity$variadic = G__6882__delegate;
        return G__6882
      }();
      G__6881 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6881__0.call(this);
          case 1:
            return G__6881__1.call(this, x);
          case 2:
            return G__6881__2.call(this, x, y);
          case 3:
            return G__6881__3.call(this, x, y, z);
          default:
            return G__6881__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6881.cljs$lang$maxFixedArity = 3;
      G__6881.cljs$lang$applyTo = G__6881__4.cljs$lang$applyTo;
      return G__6881
    }()
  };
  var juxt__4 = function() {
    var G__6884__delegate = function(f, g, h, fs) {
      var fs__6874 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__6885 = null;
        var G__6885__0 = function() {
          return cljs.core.reduce.call(null, function(p1__6860_SHARP_, p2__6861_SHARP_) {
            return cljs.core.conj.call(null, p1__6860_SHARP_, p2__6861_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__6874)
        };
        var G__6885__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__6862_SHARP_, p2__6863_SHARP_) {
            return cljs.core.conj.call(null, p1__6862_SHARP_, p2__6863_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__6874)
        };
        var G__6885__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__6864_SHARP_, p2__6865_SHARP_) {
            return cljs.core.conj.call(null, p1__6864_SHARP_, p2__6865_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__6874)
        };
        var G__6885__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__6866_SHARP_, p2__6867_SHARP_) {
            return cljs.core.conj.call(null, p1__6866_SHARP_, p2__6867_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__6874)
        };
        var G__6885__4 = function() {
          var G__6886__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__6868_SHARP_, p2__6869_SHARP_) {
              return cljs.core.conj.call(null, p1__6868_SHARP_, cljs.core.apply.call(null, p2__6869_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__6874)
          };
          var G__6886 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__6886__delegate.call(this, x, y, z, args)
          };
          G__6886.cljs$lang$maxFixedArity = 3;
          G__6886.cljs$lang$applyTo = function(arglist__6887) {
            var x = cljs.core.first(arglist__6887);
            var y = cljs.core.first(cljs.core.next(arglist__6887));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6887)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6887)));
            return G__6886__delegate(x, y, z, args)
          };
          G__6886.cljs$lang$arity$variadic = G__6886__delegate;
          return G__6886
        }();
        G__6885 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__6885__0.call(this);
            case 1:
              return G__6885__1.call(this, x);
            case 2:
              return G__6885__2.call(this, x, y);
            case 3:
              return G__6885__3.call(this, x, y, z);
            default:
              return G__6885__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__6885.cljs$lang$maxFixedArity = 3;
        G__6885.cljs$lang$applyTo = G__6885__4.cljs$lang$applyTo;
        return G__6885
      }()
    };
    var G__6884 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6884__delegate.call(this, f, g, h, fs)
    };
    G__6884.cljs$lang$maxFixedArity = 3;
    G__6884.cljs$lang$applyTo = function(arglist__6888) {
      var f = cljs.core.first(arglist__6888);
      var g = cljs.core.first(cljs.core.next(arglist__6888));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6888)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6888)));
      return G__6884__delegate(f, g, h, fs)
    };
    G__6884.cljs$lang$arity$variadic = G__6884__delegate;
    return G__6884
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__6890 = cljs.core.next.call(null, coll);
        coll = G__6890;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____6889 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____6889)) {
          return n > 0
        }else {
          return and__3546__auto____6889
        }
      }())) {
        var G__6891 = n - 1;
        var G__6892 = cljs.core.next.call(null, coll);
        n = G__6891;
        coll = G__6892;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__6893 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__6893), s)) {
    if(cljs.core.count.call(null, matches__6893) === 1) {
      return cljs.core.first.call(null, matches__6893)
    }else {
      return cljs.core.vec.call(null, matches__6893)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__6894 = re.exec(s);
  if(matches__6894 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__6894) === 1) {
      return cljs.core.first.call(null, matches__6894)
    }else {
      return cljs.core.vec.call(null, matches__6894)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__6895 = cljs.core.re_find.call(null, re, s);
  var match_idx__6896 = s.search(re);
  var match_str__6897 = cljs.core.coll_QMARK_.call(null, match_data__6895) ? cljs.core.first.call(null, match_data__6895) : match_data__6895;
  var post_match__6898 = cljs.core.subs.call(null, s, match_idx__6896 + cljs.core.count.call(null, match_str__6897));
  if(cljs.core.truth_(match_data__6895)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__6895, re_seq.call(null, re, post_match__6898))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__6900__6901 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___6902 = cljs.core.nth.call(null, vec__6900__6901, 0, null);
  var flags__6903 = cljs.core.nth.call(null, vec__6900__6901, 1, null);
  var pattern__6904 = cljs.core.nth.call(null, vec__6900__6901, 2, null);
  return new RegExp(pattern__6904, flags__6903)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__6899_SHARP_) {
    return print_one.call(null, p1__6899_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____6905 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____6905)) {
            var and__3546__auto____6909 = function() {
              var G__6906__6907 = obj;
              if(G__6906__6907 != null) {
                if(function() {
                  var or__3548__auto____6908 = G__6906__6907.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____6908) {
                    return or__3548__auto____6908
                  }else {
                    return G__6906__6907.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__6906__6907.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6906__6907)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6906__6907)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____6909)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____6909
            }
          }else {
            return and__3546__auto____6905
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____6910 = obj != null;
          if(and__3546__auto____6910) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____6910
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__6911__6912 = obj;
          if(G__6911__6912 != null) {
            if(function() {
              var or__3548__auto____6913 = G__6911__6912.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____6913) {
                return or__3548__auto____6913
              }else {
                return G__6911__6912.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__6911__6912.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6911__6912)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6911__6912)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__6914 = cljs.core.first.call(null, objs);
  var sb__6915 = new goog.string.StringBuffer;
  var G__6916__6917 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6916__6917)) {
    var obj__6918 = cljs.core.first.call(null, G__6916__6917);
    var G__6916__6919 = G__6916__6917;
    while(true) {
      if(obj__6918 === first_obj__6914) {
      }else {
        sb__6915.append(" ")
      }
      var G__6920__6921 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6918, opts));
      if(cljs.core.truth_(G__6920__6921)) {
        var string__6922 = cljs.core.first.call(null, G__6920__6921);
        var G__6920__6923 = G__6920__6921;
        while(true) {
          sb__6915.append(string__6922);
          var temp__3698__auto____6924 = cljs.core.next.call(null, G__6920__6923);
          if(cljs.core.truth_(temp__3698__auto____6924)) {
            var G__6920__6925 = temp__3698__auto____6924;
            var G__6928 = cljs.core.first.call(null, G__6920__6925);
            var G__6929 = G__6920__6925;
            string__6922 = G__6928;
            G__6920__6923 = G__6929;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6926 = cljs.core.next.call(null, G__6916__6919);
      if(cljs.core.truth_(temp__3698__auto____6926)) {
        var G__6916__6927 = temp__3698__auto____6926;
        var G__6930 = cljs.core.first.call(null, G__6916__6927);
        var G__6931 = G__6916__6927;
        obj__6918 = G__6930;
        G__6916__6919 = G__6931;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__6915
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__6932 = cljs.core.pr_sb.call(null, objs, opts);
  sb__6932.append("\n");
  return[cljs.core.str(sb__6932)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__6933 = cljs.core.first.call(null, objs);
  var G__6934__6935 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6934__6935)) {
    var obj__6936 = cljs.core.first.call(null, G__6934__6935);
    var G__6934__6937 = G__6934__6935;
    while(true) {
      if(obj__6936 === first_obj__6933) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__6938__6939 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6936, opts));
      if(cljs.core.truth_(G__6938__6939)) {
        var string__6940 = cljs.core.first.call(null, G__6938__6939);
        var G__6938__6941 = G__6938__6939;
        while(true) {
          cljs.core.string_print.call(null, string__6940);
          var temp__3698__auto____6942 = cljs.core.next.call(null, G__6938__6941);
          if(cljs.core.truth_(temp__3698__auto____6942)) {
            var G__6938__6943 = temp__3698__auto____6942;
            var G__6946 = cljs.core.first.call(null, G__6938__6943);
            var G__6947 = G__6938__6943;
            string__6940 = G__6946;
            G__6938__6941 = G__6947;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6944 = cljs.core.next.call(null, G__6934__6937);
      if(cljs.core.truth_(temp__3698__auto____6944)) {
        var G__6934__6945 = temp__3698__auto____6944;
        var G__6948 = cljs.core.first.call(null, G__6934__6945);
        var G__6949 = G__6934__6945;
        obj__6936 = G__6948;
        G__6934__6937 = G__6949;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__6950) {
    var objs = cljs.core.seq(arglist__6950);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__6951) {
    var objs = cljs.core.seq(arglist__6951);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__6952) {
    var objs = cljs.core.seq(arglist__6952);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__6953) {
    var objs = cljs.core.seq(arglist__6953);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__6954) {
    var objs = cljs.core.seq(arglist__6954);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__6955) {
    var objs = cljs.core.seq(arglist__6955);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__6956) {
    var objs = cljs.core.seq(arglist__6956);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__6957) {
    var objs = cljs.core.seq(arglist__6957);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6958 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6958, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6959 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6959, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6960 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6960, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____6961 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____6961)) {
        var nspc__6962 = temp__3698__auto____6961;
        return[cljs.core.str(nspc__6962), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____6963 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____6963)) {
          var nspc__6964 = temp__3698__auto____6963;
          return[cljs.core.str(nspc__6964), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6965 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6965, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6966 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6966, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__6967 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__6968 = this;
  var G__6969__6970 = cljs.core.seq.call(null, this__6968.watches);
  if(cljs.core.truth_(G__6969__6970)) {
    var G__6972__6974 = cljs.core.first.call(null, G__6969__6970);
    var vec__6973__6975 = G__6972__6974;
    var key__6976 = cljs.core.nth.call(null, vec__6973__6975, 0, null);
    var f__6977 = cljs.core.nth.call(null, vec__6973__6975, 1, null);
    var G__6969__6978 = G__6969__6970;
    var G__6972__6979 = G__6972__6974;
    var G__6969__6980 = G__6969__6978;
    while(true) {
      var vec__6981__6982 = G__6972__6979;
      var key__6983 = cljs.core.nth.call(null, vec__6981__6982, 0, null);
      var f__6984 = cljs.core.nth.call(null, vec__6981__6982, 1, null);
      var G__6969__6985 = G__6969__6980;
      f__6984.call(null, key__6983, this$, oldval, newval);
      var temp__3698__auto____6986 = cljs.core.next.call(null, G__6969__6985);
      if(cljs.core.truth_(temp__3698__auto____6986)) {
        var G__6969__6987 = temp__3698__auto____6986;
        var G__6994 = cljs.core.first.call(null, G__6969__6987);
        var G__6995 = G__6969__6987;
        G__6972__6979 = G__6994;
        G__6969__6980 = G__6995;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__6988 = this;
  return this$.watches = cljs.core.assoc.call(null, this__6988.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__6989 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__6989.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__6990 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__6990.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__6991 = this;
  return this__6991.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__6992 = this;
  return this__6992.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6993 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7002__delegate = function(x, p__6996) {
      var map__6997__6998 = p__6996;
      var map__6997__6999 = cljs.core.seq_QMARK_.call(null, map__6997__6998) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6997__6998) : map__6997__6998;
      var validator__7000 = cljs.core.get.call(null, map__6997__6999, "\ufdd0'validator");
      var meta__7001 = cljs.core.get.call(null, map__6997__6999, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7001, validator__7000, null)
    };
    var G__7002 = function(x, var_args) {
      var p__6996 = null;
      if(goog.isDef(var_args)) {
        p__6996 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7002__delegate.call(this, x, p__6996)
    };
    G__7002.cljs$lang$maxFixedArity = 1;
    G__7002.cljs$lang$applyTo = function(arglist__7003) {
      var x = cljs.core.first(arglist__7003);
      var p__6996 = cljs.core.rest(arglist__7003);
      return G__7002__delegate(x, p__6996)
    };
    G__7002.cljs$lang$arity$variadic = G__7002__delegate;
    return G__7002
  }();
  atom = function(x, var_args) {
    var p__6996 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7004 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7004)) {
    var validate__7005 = temp__3698__auto____7004;
    if(cljs.core.truth_(validate__7005.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7006 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7006, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7007__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7007 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7007__delegate.call(this, a, f, x, y, z, more)
    };
    G__7007.cljs$lang$maxFixedArity = 5;
    G__7007.cljs$lang$applyTo = function(arglist__7008) {
      var a = cljs.core.first(arglist__7008);
      var f = cljs.core.first(cljs.core.next(arglist__7008));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7008)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7008))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7008)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7008)))));
      return G__7007__delegate(a, f, x, y, z, more)
    };
    G__7007.cljs$lang$arity$variadic = G__7007__delegate;
    return G__7007
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7009) {
    var iref = cljs.core.first(arglist__7009);
    var f = cljs.core.first(cljs.core.next(arglist__7009));
    var args = cljs.core.rest(cljs.core.next(arglist__7009));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7010 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7010.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7011 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7011.state, function(p__7012) {
    var curr_state__7013 = p__7012;
    var curr_state__7014 = cljs.core.seq_QMARK_.call(null, curr_state__7013) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7013) : curr_state__7013;
    var done__7015 = cljs.core.get.call(null, curr_state__7014, "\ufdd0'done");
    if(cljs.core.truth_(done__7015)) {
      return curr_state__7014
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7011.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7016__7017 = options;
    var map__7016__7018 = cljs.core.seq_QMARK_.call(null, map__7016__7017) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7016__7017) : map__7016__7017;
    var keywordize_keys__7019 = cljs.core.get.call(null, map__7016__7018, "\ufdd0'keywordize-keys");
    var keyfn__7020 = cljs.core.truth_(keywordize_keys__7019) ? cljs.core.keyword : cljs.core.str;
    var f__7026 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7025 = function iter__7021(s__7022) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7022__7023 = s__7022;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7022__7023))) {
                        var k__7024 = cljs.core.first.call(null, s__7022__7023);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7020.call(null, k__7024), thisfn.call(null, x[k__7024])]), iter__7021.call(null, cljs.core.rest.call(null, s__7022__7023)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7025.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7026.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7027) {
    var x = cljs.core.first(arglist__7027);
    var options = cljs.core.rest(arglist__7027);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7028 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7032__delegate = function(args) {
      var temp__3695__auto____7029 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7028), args);
      if(cljs.core.truth_(temp__3695__auto____7029)) {
        var v__7030 = temp__3695__auto____7029;
        return v__7030
      }else {
        var ret__7031 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7028, cljs.core.assoc, args, ret__7031);
        return ret__7031
      }
    };
    var G__7032 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7032__delegate.call(this, args)
    };
    G__7032.cljs$lang$maxFixedArity = 0;
    G__7032.cljs$lang$applyTo = function(arglist__7033) {
      var args = cljs.core.seq(arglist__7033);
      return G__7032__delegate(args)
    };
    G__7032.cljs$lang$arity$variadic = G__7032__delegate;
    return G__7032
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7034 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7034)) {
        var G__7035 = ret__7034;
        f = G__7035;
        continue
      }else {
        return ret__7034
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7036__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7036 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7036__delegate.call(this, f, args)
    };
    G__7036.cljs$lang$maxFixedArity = 1;
    G__7036.cljs$lang$applyTo = function(arglist__7037) {
      var f = cljs.core.first(arglist__7037);
      var args = cljs.core.rest(arglist__7037);
      return G__7036__delegate(f, args)
    };
    G__7036.cljs$lang$arity$variadic = G__7036__delegate;
    return G__7036
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7038 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7038, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7038, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7039 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7039) {
      return or__3548__auto____7039
    }else {
      var or__3548__auto____7040 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7040) {
        return or__3548__auto____7040
      }else {
        var and__3546__auto____7041 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7041) {
          var and__3546__auto____7042 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7042) {
            var and__3546__auto____7043 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7043) {
              var ret__7044 = true;
              var i__7045 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7046 = cljs.core.not.call(null, ret__7044);
                  if(or__3548__auto____7046) {
                    return or__3548__auto____7046
                  }else {
                    return i__7045 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7044
                }else {
                  var G__7047 = isa_QMARK_.call(null, h, child.call(null, i__7045), parent.call(null, i__7045));
                  var G__7048 = i__7045 + 1;
                  ret__7044 = G__7047;
                  i__7045 = G__7048;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7043
            }
          }else {
            return and__3546__auto____7042
          }
        }else {
          return and__3546__auto____7041
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7052 = "\ufdd0'parents".call(null, h);
    var td__7053 = "\ufdd0'descendants".call(null, h);
    var ta__7054 = "\ufdd0'ancestors".call(null, h);
    var tf__7055 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7056 = cljs.core.contains_QMARK_.call(null, tp__7052.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7054.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7054.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7052, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7055.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7053, parent, ta__7054), "\ufdd0'descendants":tf__7055.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7054, tag, td__7053)})
    }();
    if(cljs.core.truth_(or__3548__auto____7056)) {
      return or__3548__auto____7056
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7057 = "\ufdd0'parents".call(null, h);
    var childsParents__7058 = cljs.core.truth_(parentMap__7057.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7057.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7059 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7058)) ? cljs.core.assoc.call(null, parentMap__7057, tag, childsParents__7058) : cljs.core.dissoc.call(null, parentMap__7057, tag);
    var deriv_seq__7060 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7049_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7049_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7049_SHARP_), cljs.core.second.call(null, p1__7049_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7059)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7057.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7050_SHARP_, p2__7051_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7050_SHARP_, p2__7051_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7060))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7061 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7063 = cljs.core.truth_(function() {
    var and__3546__auto____7062 = xprefs__7061;
    if(cljs.core.truth_(and__3546__auto____7062)) {
      return xprefs__7061.call(null, y)
    }else {
      return and__3546__auto____7062
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7063)) {
    return or__3548__auto____7063
  }else {
    var or__3548__auto____7065 = function() {
      var ps__7064 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7064) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7064), prefer_table))) {
          }else {
          }
          var G__7068 = cljs.core.rest.call(null, ps__7064);
          ps__7064 = G__7068;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7065)) {
      return or__3548__auto____7065
    }else {
      var or__3548__auto____7067 = function() {
        var ps__7066 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7066) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7066), y, prefer_table))) {
            }else {
            }
            var G__7069 = cljs.core.rest.call(null, ps__7066);
            ps__7066 = G__7069;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7067)) {
        return or__3548__auto____7067
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7070 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7070)) {
    return or__3548__auto____7070
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7079 = cljs.core.reduce.call(null, function(be, p__7071) {
    var vec__7072__7073 = p__7071;
    var k__7074 = cljs.core.nth.call(null, vec__7072__7073, 0, null);
    var ___7075 = cljs.core.nth.call(null, vec__7072__7073, 1, null);
    var e__7076 = vec__7072__7073;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7074)) {
      var be2__7078 = cljs.core.truth_(function() {
        var or__3548__auto____7077 = be == null;
        if(or__3548__auto____7077) {
          return or__3548__auto____7077
        }else {
          return cljs.core.dominates.call(null, k__7074, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7076 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7078), k__7074, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7074), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7078)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7078
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7079)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7079));
      return cljs.core.second.call(null, best_entry__7079)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7080 = mf;
    if(and__3546__auto____7080) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7080
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7081 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7081) {
        return or__3548__auto____7081
      }else {
        var or__3548__auto____7082 = cljs.core._reset["_"];
        if(or__3548__auto____7082) {
          return or__3548__auto____7082
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7083 = mf;
    if(and__3546__auto____7083) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7083
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7084 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7084) {
        return or__3548__auto____7084
      }else {
        var or__3548__auto____7085 = cljs.core._add_method["_"];
        if(or__3548__auto____7085) {
          return or__3548__auto____7085
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7086 = mf;
    if(and__3546__auto____7086) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7086
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7087 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7087) {
        return or__3548__auto____7087
      }else {
        var or__3548__auto____7088 = cljs.core._remove_method["_"];
        if(or__3548__auto____7088) {
          return or__3548__auto____7088
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7089 = mf;
    if(and__3546__auto____7089) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7089
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7090 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7090) {
        return or__3548__auto____7090
      }else {
        var or__3548__auto____7091 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7091) {
          return or__3548__auto____7091
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7092 = mf;
    if(and__3546__auto____7092) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7092
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7093 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7093) {
        return or__3548__auto____7093
      }else {
        var or__3548__auto____7094 = cljs.core._get_method["_"];
        if(or__3548__auto____7094) {
          return or__3548__auto____7094
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7095 = mf;
    if(and__3546__auto____7095) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7095
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7096 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7096) {
        return or__3548__auto____7096
      }else {
        var or__3548__auto____7097 = cljs.core._methods["_"];
        if(or__3548__auto____7097) {
          return or__3548__auto____7097
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7098 = mf;
    if(and__3546__auto____7098) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7098
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7099 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7099) {
        return or__3548__auto____7099
      }else {
        var or__3548__auto____7100 = cljs.core._prefers["_"];
        if(or__3548__auto____7100) {
          return or__3548__auto____7100
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7101 = mf;
    if(and__3546__auto____7101) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7101
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7102 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7102) {
        return or__3548__auto____7102
      }else {
        var or__3548__auto____7103 = cljs.core._dispatch["_"];
        if(or__3548__auto____7103) {
          return or__3548__auto____7103
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7104 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7105 = cljs.core._get_method.call(null, mf, dispatch_val__7104);
  if(cljs.core.truth_(target_fn__7105)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7104)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7105, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7106 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7107 = this;
  cljs.core.swap_BANG_.call(null, this__7107.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7107.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7107.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7107.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7108 = this;
  cljs.core.swap_BANG_.call(null, this__7108.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7108.method_cache, this__7108.method_table, this__7108.cached_hierarchy, this__7108.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7109 = this;
  cljs.core.swap_BANG_.call(null, this__7109.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7109.method_cache, this__7109.method_table, this__7109.cached_hierarchy, this__7109.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7110 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7110.cached_hierarchy), cljs.core.deref.call(null, this__7110.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7110.method_cache, this__7110.method_table, this__7110.cached_hierarchy, this__7110.hierarchy)
  }
  var temp__3695__auto____7111 = cljs.core.deref.call(null, this__7110.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7111)) {
    var target_fn__7112 = temp__3695__auto____7111;
    return target_fn__7112
  }else {
    var temp__3695__auto____7113 = cljs.core.find_and_cache_best_method.call(null, this__7110.name, dispatch_val, this__7110.hierarchy, this__7110.method_table, this__7110.prefer_table, this__7110.method_cache, this__7110.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7113)) {
      var target_fn__7114 = temp__3695__auto____7113;
      return target_fn__7114
    }else {
      return cljs.core.deref.call(null, this__7110.method_table).call(null, this__7110.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7115 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7115.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7115.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7115.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7115.method_cache, this__7115.method_table, this__7115.cached_hierarchy, this__7115.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7116 = this;
  return cljs.core.deref.call(null, this__7116.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7117 = this;
  return cljs.core.deref.call(null, this__7117.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7118 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7118.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7119__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7119 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7119__delegate.call(this, _, args)
  };
  G__7119.cljs$lang$maxFixedArity = 1;
  G__7119.cljs$lang$applyTo = function(arglist__7120) {
    var _ = cljs.core.first(arglist__7120);
    var args = cljs.core.rest(arglist__7120);
    return G__7119__delegate(_, args)
  };
  G__7119.cljs$lang$arity$variadic = G__7119__delegate;
  return G__7119
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7122 = reader;
    if(and__3546__auto____7122) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7122
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7123 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7123) {
        return or__3548__auto____7123
      }else {
        var or__3548__auto____7124 = cljs.reader.read_char["_"];
        if(or__3548__auto____7124) {
          return or__3548__auto____7124
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7125 = reader;
    if(and__3546__auto____7125) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7125
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7126 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7126) {
        return or__3548__auto____7126
      }else {
        var or__3548__auto____7127 = cljs.reader.unread["_"];
        if(or__3548__auto____7127) {
          return or__3548__auto____7127
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7128 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7128.buffer_atom))) {
    var idx__7129 = cljs.core.deref.call(null, this__7128.index_atom);
    cljs.core.swap_BANG_.call(null, this__7128.index_atom, cljs.core.inc);
    return this__7128.s[idx__7129]
  }else {
    var buf__7130 = cljs.core.deref.call(null, this__7128.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7128.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7130)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7131 = this;
  return cljs.core.swap_BANG_.call(null, this__7131.buffer_atom, function(p1__7121_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7121_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7132 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7132)) {
    return or__3548__auto____7132
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7133 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7133) {
    return or__3548__auto____7133
  }else {
    var and__3546__auto____7135 = function() {
      var or__3548__auto____7134 = "+" === initch;
      if(or__3548__auto____7134) {
        return or__3548__auto____7134
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7135)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7136 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7136);
        return next_ch__7136
      }())
    }else {
      return and__3546__auto____7135
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7137) {
    var rdr = cljs.core.first(arglist__7137);
    var msg = cljs.core.rest(arglist__7137);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7138 = ch != "#";
  if(and__3546__auto____7138) {
    var and__3546__auto____7139 = ch != "'";
    if(and__3546__auto____7139) {
      var and__3546__auto____7140 = ch != ":";
      if(and__3546__auto____7140) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7140
      }
    }else {
      return and__3546__auto____7139
    }
  }else {
    return and__3546__auto____7138
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7141 = new goog.string.StringBuffer(initch);
  var ch__7142 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7143 = ch__7142 == null;
      if(or__3548__auto____7143) {
        return or__3548__auto____7143
      }else {
        var or__3548__auto____7144 = cljs.reader.whitespace_QMARK_.call(null, ch__7142);
        if(or__3548__auto____7144) {
          return or__3548__auto____7144
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7142)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7142);
      return sb__7141.toString()
    }else {
      var G__7145 = function() {
        sb__7141.append(ch__7142);
        return sb__7141
      }();
      var G__7146 = cljs.reader.read_char.call(null, rdr);
      sb__7141 = G__7145;
      ch__7142 = G__7146;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7147 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7148 = ch__7147 === "n";
      if(or__3548__auto____7148) {
        return or__3548__auto____7148
      }else {
        var or__3548__auto____7149 = ch__7147 === "r";
        if(or__3548__auto____7149) {
          return or__3548__auto____7149
        }else {
          return ch__7147 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7150 = re.exec(s);
  if(matches__7150 != null) {
    if(matches__7150.length === 1) {
      return matches__7150[0]
    }else {
      return matches__7150
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7151 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7152 = groups__7151[2];
  if(!function() {
    var or__3548__auto____7153 = group3__7152 == null;
    if(or__3548__auto____7153) {
      return or__3548__auto____7153
    }else {
      return group3__7152.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7154 = "-" === groups__7151[1] ? -1 : 1;
    var a__7155 = cljs.core.truth_(groups__7151[3]) ? [groups__7151[3], 10] : cljs.core.truth_(groups__7151[4]) ? [groups__7151[4], 16] : cljs.core.truth_(groups__7151[5]) ? [groups__7151[5], 8] : cljs.core.truth_(groups__7151[7]) ? [groups__7151[7], parseInt(groups__7151[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7156 = a__7155[0];
    var radix__7157 = a__7155[1];
    if(n__7156 == null) {
      return null
    }else {
      return negate__7154 * parseInt(n__7156, radix__7157)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7158 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7159 = groups__7158[1];
  var denominator__7160 = groups__7158[2];
  return parseInt(numinator__7159) / parseInt(denominator__7160)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7161 = re.exec(s);
  if(function() {
    var and__3546__auto____7162 = matches__7161 != null;
    if(and__3546__auto____7162) {
      return matches__7161[0] === s
    }else {
      return and__3546__auto____7162
    }
  }()) {
    if(matches__7161.length === 1) {
      return matches__7161[0]
    }else {
      return matches__7161
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7163 = cljs.reader.read_char.call(null, reader);
  var mapresult__7164 = cljs.reader.escape_char_map.call(null, ch__7163);
  if(cljs.core.truth_(mapresult__7164)) {
    return mapresult__7164
  }else {
    if(function() {
      var or__3548__auto____7165 = "u" === ch__7163;
      if(or__3548__auto____7165) {
        return or__3548__auto____7165
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7163)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7163)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7163)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7166 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7166))) {
      var G__7167 = cljs.reader.read_char.call(null, rdr);
      ch__7166 = G__7167;
      continue
    }else {
      return ch__7166
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7168 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7169 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7169)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7169) {
      return cljs.core.persistent_BANG_.call(null, a__7168)
    }else {
      var temp__3695__auto____7170 = cljs.reader.macros.call(null, ch__7169);
      if(cljs.core.truth_(temp__3695__auto____7170)) {
        var macrofn__7171 = temp__3695__auto____7170;
        var mret__7172 = macrofn__7171.call(null, rdr, ch__7169);
        var G__7174 = mret__7172 === rdr ? a__7168 : cljs.core.conj_BANG_.call(null, a__7168, mret__7172);
        a__7168 = G__7174;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7169);
        var o__7173 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7175 = o__7173 === rdr ? a__7168 : cljs.core.conj_BANG_.call(null, a__7168, o__7173);
        a__7168 = G__7175;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7176 = cljs.reader.read_char.call(null, rdr);
  var dm__7177 = cljs.reader.dispatch_macros.call(null, ch__7176);
  if(cljs.core.truth_(dm__7177)) {
    return dm__7177.call(null, rdr, _)
  }else {
    var temp__3695__auto____7178 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7176);
    if(cljs.core.truth_(temp__3695__auto____7178)) {
      var obj__7179 = temp__3695__auto____7178;
      return obj__7179
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7176)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7180 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7180))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7180)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7181 = new goog.string.StringBuffer(initch);
  var ch__7182 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7183 = ch__7182 == null;
      if(or__3548__auto____7183) {
        return or__3548__auto____7183
      }else {
        var or__3548__auto____7184 = cljs.reader.whitespace_QMARK_.call(null, ch__7182);
        if(or__3548__auto____7184) {
          return or__3548__auto____7184
        }else {
          return cljs.reader.macros.call(null, ch__7182)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7182);
      var s__7185 = buffer__7181.toString();
      var or__3548__auto____7186 = cljs.reader.match_number.call(null, s__7185);
      if(cljs.core.truth_(or__3548__auto____7186)) {
        return or__3548__auto____7186
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7185, "]")
      }
    }else {
      var G__7187 = function() {
        buffer__7181.append(ch__7182);
        return buffer__7181
      }();
      var G__7188 = cljs.reader.read_char.call(null, reader);
      buffer__7181 = G__7187;
      ch__7182 = G__7188;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7189 = new goog.string.StringBuffer;
  var ch__7190 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7190 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7190) {
        var G__7191 = function() {
          buffer__7189.append(cljs.reader.escape_char.call(null, buffer__7189, reader));
          return buffer__7189
        }();
        var G__7192 = cljs.reader.read_char.call(null, reader);
        buffer__7189 = G__7191;
        ch__7190 = G__7192;
        continue
      }else {
        if('"' === ch__7190) {
          return buffer__7189.toString()
        }else {
          if("\ufdd0'default") {
            var G__7193 = function() {
              buffer__7189.append(ch__7190);
              return buffer__7189
            }();
            var G__7194 = cljs.reader.read_char.call(null, reader);
            buffer__7189 = G__7193;
            ch__7190 = G__7194;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7195 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7195, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7195, 0, token__7195.indexOf("/")), cljs.core.subs.call(null, token__7195, token__7195.indexOf("/") + 1, token__7195.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7195, cljs.core.symbol.call(null, token__7195))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7196 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7197 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7196);
  var token__7198 = a__7197[0];
  var ns__7199 = a__7197[1];
  var name__7200 = a__7197[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7202 = function() {
      var and__3546__auto____7201 = !(void 0 === ns__7199);
      if(and__3546__auto____7201) {
        return ns__7199.substring(ns__7199.length - 2, ns__7199.length) === ":/"
      }else {
        return and__3546__auto____7201
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7202)) {
      return or__3548__auto____7202
    }else {
      var or__3548__auto____7203 = name__7200[name__7200.length - 1] === ":";
      if(or__3548__auto____7203) {
        return or__3548__auto____7203
      }else {
        return!(token__7198.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7198)
  }else {
    if(cljs.core.truth_(ns__7199)) {
      return cljs.core.keyword.call(null, ns__7199.substring(0, ns__7199.indexOf("/")), name__7200)
    }else {
      return cljs.core.keyword.call(null, token__7198)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7204 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7204)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7205 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7206__7207 = o__7205;
    if(G__7206__7207 != null) {
      if(function() {
        var or__3548__auto____7208 = G__7206__7207.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7208) {
          return or__3548__auto____7208
        }else {
          return G__7206__7207.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7206__7207.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7206__7207)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7206__7207)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7205, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7205), m__7204))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7209 = cljs.reader.read_char.call(null, reader);
    if(ch__7209 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7209)) {
        var G__7212 = reader;
        var G__7213 = eof_is_error;
        var G__7214 = sentinel;
        var G__7215 = is_recursive;
        reader = G__7212;
        eof_is_error = G__7213;
        sentinel = G__7214;
        is_recursive = G__7215;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7209)) {
          var G__7216 = cljs.reader.read_comment.call(null, reader, ch__7209);
          var G__7217 = eof_is_error;
          var G__7218 = sentinel;
          var G__7219 = is_recursive;
          reader = G__7216;
          eof_is_error = G__7217;
          sentinel = G__7218;
          is_recursive = G__7219;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7210 = cljs.reader.macros.call(null, ch__7209);
            var res__7211 = cljs.core.truth_(f__7210) ? f__7210.call(null, reader, ch__7209) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7209) ? cljs.reader.read_number.call(null, reader, ch__7209) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7209) : null;
            if(res__7211 === reader) {
              var G__7220 = reader;
              var G__7221 = eof_is_error;
              var G__7222 = sentinel;
              var G__7223 = is_recursive;
              reader = G__7220;
              eof_is_error = G__7221;
              sentinel = G__7222;
              is_recursive = G__7223;
              continue
            }else {
              return res__7211
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7224 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7224, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7225 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7226 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7227 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7225));
  if(cljs.core.truth_(pfn__7227)) {
    return pfn__7227.call(null, form__7226)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7225), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7228 = cljs.core.name.call(null, tag);
  var old_parser__7229 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7228);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7228, f);
  return old_parser__7229
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7367 = s;
      var limit__7368 = limit;
      var parts__7369 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7368, 1)) {
          return cljs.core.conj.call(null, parts__7369, s__7367)
        }else {
          var temp__3695__auto____7370 = cljs.core.re_find.call(null, re, s__7367);
          if(cljs.core.truth_(temp__3695__auto____7370)) {
            var m__7371 = temp__3695__auto____7370;
            var index__7372 = s__7367.indexOf(m__7371);
            var G__7373 = s__7367.substring(index__7372 + cljs.core.count.call(null, m__7371));
            var G__7374 = limit__7368 - 1;
            var G__7375 = cljs.core.conj.call(null, parts__7369, s__7367.substring(0, index__7372));
            s__7367 = G__7373;
            limit__7368 = G__7374;
            parts__7369 = G__7375;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7369, s__7367)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7376 = s.length;
  while(true) {
    if(index__7376 === 0) {
      return""
    }else {
      var ch__7377 = cljs.core.get.call(null, s, index__7376 - 1);
      if(function() {
        var or__3548__auto____7378 = cljs.core._EQ_.call(null, ch__7377, "\n");
        if(or__3548__auto____7378) {
          return or__3548__auto____7378
        }else {
          return cljs.core._EQ_.call(null, ch__7377, "\r")
        }
      }()) {
        var G__7379 = index__7376 - 1;
        index__7376 = G__7379;
        continue
      }else {
        return s.substring(0, index__7376)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7380 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7381 = cljs.core.not.call(null, s__7380);
    if(or__3548__auto____7381) {
      return or__3548__auto____7381
    }else {
      var or__3548__auto____7382 = cljs.core._EQ_.call(null, "", s__7380);
      if(or__3548__auto____7382) {
        return or__3548__auto____7382
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7380)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7383 = new goog.string.StringBuffer;
  var length__7384 = s.length;
  var index__7385 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7384, index__7385)) {
      return buffer__7383.toString()
    }else {
      var ch__7386 = s.charAt(index__7385);
      var temp__3695__auto____7387 = cljs.core.get.call(null, cmap, ch__7386);
      if(cljs.core.truth_(temp__3695__auto____7387)) {
        var replacement__7388 = temp__3695__auto____7387;
        buffer__7383.append([cljs.core.str(replacement__7388)].join(""))
      }else {
        buffer__7383.append(ch__7386)
      }
      var G__7389 = index__7385 + 1;
      index__7385 = G__7389;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7338 = {};
  var G__7339__7340 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7339__7340)) {
    var G__7342__7344 = cljs.core.first.call(null, G__7339__7340);
    var vec__7343__7345 = G__7342__7344;
    var k__7346 = cljs.core.nth.call(null, vec__7343__7345, 0, null);
    var v__7347 = cljs.core.nth.call(null, vec__7343__7345, 1, null);
    var G__7339__7348 = G__7339__7340;
    var G__7342__7349 = G__7342__7344;
    var G__7339__7350 = G__7339__7348;
    while(true) {
      var vec__7351__7352 = G__7342__7349;
      var k__7353 = cljs.core.nth.call(null, vec__7351__7352, 0, null);
      var v__7354 = cljs.core.nth.call(null, vec__7351__7352, 1, null);
      var G__7339__7355 = G__7339__7350;
      out__7338[cljs.core.name.call(null, k__7353)] = v__7354;
      var temp__3698__auto____7356 = cljs.core.next.call(null, G__7339__7355);
      if(cljs.core.truth_(temp__3698__auto____7356)) {
        var G__7339__7357 = temp__3698__auto____7356;
        var G__7358 = cljs.core.first.call(null, G__7339__7357);
        var G__7359 = G__7339__7357;
        G__7342__7349 = G__7358;
        G__7339__7350 = G__7359;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7338
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7360 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7360)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7361) {
    var v = cljs.core.first(arglist__7361);
    var text = cljs.core.rest(arglist__7361);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7362) {
          var vec__7363__7364 = p__7362;
          var k__7365 = cljs.core.nth.call(null, vec__7363__7364, 0, null);
          var v__7366 = cljs.core.nth.call(null, vec__7363__7364, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7365), clj__GT_js.call(null, v__7366))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7230 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7230)) {
        var cm__7231 = temp__3695__auto____7230;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7231), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7232) {
    var vec__7233__7234 = p__7232;
    var context__7235 = cljs.core.nth.call(null, vec__7233__7234, 0, null);
    if(cljs.core.not.call(null, context__7235)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7235)
    }
  };
  var $ = function(sel, var_args) {
    var p__7232 = null;
    if(goog.isDef(var_args)) {
      p__7232 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7232)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7236) {
    var sel = cljs.core.first(arglist__7236);
    var p__7232 = cljs.core.rest(arglist__7236);
    return $__delegate(sel, p__7232)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7237 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7237)) {
    return or__3548__auto____7237
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7238 = null;
  var G__7238__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7238__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7238 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7238__2.call(this, _, k);
      case 3:
        return G__7238__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7238
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7239) {
    var vec__7240__7241 = p__7239;
    var v__7242 = cljs.core.nth.call(null, vec__7240__7241, 0, null);
    var a__7243 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7242)) {
      return $elem.attr(a__7243)
    }else {
      return $elem.attr(a__7243, v__7242)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7239 = null;
    if(goog.isDef(var_args)) {
      p__7239 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7239)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7244) {
    var $elem = cljs.core.first(arglist__7244);
    var a = cljs.core.first(cljs.core.next(arglist__7244));
    var p__7239 = cljs.core.rest(cljs.core.next(arglist__7244));
    return attr__delegate($elem, a, p__7239)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7245) {
    var vec__7246__7247 = p__7245;
    var v__7248 = cljs.core.nth.call(null, vec__7246__7247, 0, null);
    var k__7249 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7248)) {
      return $elem.data(k__7249)
    }else {
      return $elem.data(k__7249, v__7248)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7245 = null;
    if(goog.isDef(var_args)) {
      p__7245 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7245)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7250) {
    var $elem = cljs.core.first(arglist__7250);
    var k = cljs.core.first(cljs.core.next(arglist__7250));
    var p__7245 = cljs.core.rest(cljs.core.next(arglist__7250));
    return data__delegate($elem, k, p__7245)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7251 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7251)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7252 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7252)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7253 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7253)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7254 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7254)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7255) {
    var vec__7256__7257 = p__7255;
    var speed__7258 = cljs.core.nth.call(null, vec__7256__7257, 0, null);
    var on_finish__7259 = cljs.core.nth.call(null, vec__7256__7257, 1, null);
    return $elem.hide(speed__7258, on_finish__7259)
  };
  var hide = function($elem, var_args) {
    var p__7255 = null;
    if(goog.isDef(var_args)) {
      p__7255 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7255)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7260) {
    var $elem = cljs.core.first(arglist__7260);
    var p__7255 = cljs.core.rest(arglist__7260);
    return hide__delegate($elem, p__7255)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7261) {
    var vec__7262__7263 = p__7261;
    var speed__7264 = cljs.core.nth.call(null, vec__7262__7263, 0, null);
    var on_finish__7265 = cljs.core.nth.call(null, vec__7262__7263, 1, null);
    return $elem.show(speed__7264, on_finish__7265)
  };
  var show = function($elem, var_args) {
    var p__7261 = null;
    if(goog.isDef(var_args)) {
      p__7261 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7261)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7266) {
    var $elem = cljs.core.first(arglist__7266);
    var p__7261 = cljs.core.rest(arglist__7266);
    return show__delegate($elem, p__7261)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7267) {
    var vec__7268__7269 = p__7267;
    var speed__7270 = cljs.core.nth.call(null, vec__7268__7269, 0, null);
    var on_finish__7271 = cljs.core.nth.call(null, vec__7268__7269, 1, null);
    return $elem.toggle(speed__7270, on_finish__7271)
  };
  var toggle = function($elem, var_args) {
    var p__7267 = null;
    if(goog.isDef(var_args)) {
      p__7267 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7267)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7272) {
    var $elem = cljs.core.first(arglist__7272);
    var p__7267 = cljs.core.rest(arglist__7272);
    return toggle__delegate($elem, p__7267)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7273) {
    var vec__7274__7275 = p__7273;
    var speed__7276 = cljs.core.nth.call(null, vec__7274__7275, 0, null);
    var on_finish__7277 = cljs.core.nth.call(null, vec__7274__7275, 1, null);
    return $elem.fadeOut(speed__7276, on_finish__7277)
  };
  var fade_out = function($elem, var_args) {
    var p__7273 = null;
    if(goog.isDef(var_args)) {
      p__7273 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7273)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7278) {
    var $elem = cljs.core.first(arglist__7278);
    var p__7273 = cljs.core.rest(arglist__7278);
    return fade_out__delegate($elem, p__7273)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7279) {
    var vec__7280__7281 = p__7279;
    var speed__7282 = cljs.core.nth.call(null, vec__7280__7281, 0, null);
    var on_finish__7283 = cljs.core.nth.call(null, vec__7280__7281, 1, null);
    return $elem.fadeIn(speed__7282, on_finish__7283)
  };
  var fade_in = function($elem, var_args) {
    var p__7279 = null;
    if(goog.isDef(var_args)) {
      p__7279 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7279)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7284) {
    var $elem = cljs.core.first(arglist__7284);
    var p__7279 = cljs.core.rest(arglist__7284);
    return fade_in__delegate($elem, p__7279)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7285) {
    var vec__7286__7287 = p__7285;
    var speed__7288 = cljs.core.nth.call(null, vec__7286__7287, 0, null);
    var on_finish__7289 = cljs.core.nth.call(null, vec__7286__7287, 1, null);
    return $elem.slideUp(speed__7288, on_finish__7289)
  };
  var slide_up = function($elem, var_args) {
    var p__7285 = null;
    if(goog.isDef(var_args)) {
      p__7285 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7285)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7290) {
    var $elem = cljs.core.first(arglist__7290);
    var p__7285 = cljs.core.rest(arglist__7290);
    return slide_up__delegate($elem, p__7285)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7291) {
    var vec__7292__7293 = p__7291;
    var speed__7294 = cljs.core.nth.call(null, vec__7292__7293, 0, null);
    var on_finish__7295 = cljs.core.nth.call(null, vec__7292__7293, 1, null);
    return $elem.slideDown(speed__7294, on_finish__7295)
  };
  var slide_down = function($elem, var_args) {
    var p__7291 = null;
    if(goog.isDef(var_args)) {
      p__7291 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7291)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7296) {
    var $elem = cljs.core.first(arglist__7296);
    var p__7291 = cljs.core.rest(arglist__7296);
    return slide_down__delegate($elem, p__7291)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7297) {
    var vec__7298__7299 = p__7297;
    var context__7300 = cljs.core.nth.call(null, vec__7298__7299, 0, null);
    return $elem.closest(selector, context__7300)
  };
  var closest = function($elem, selector, var_args) {
    var p__7297 = null;
    if(goog.isDef(var_args)) {
      p__7297 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7297)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7301) {
    var $elem = cljs.core.first(arglist__7301);
    var selector = cljs.core.first(cljs.core.next(arglist__7301));
    var p__7297 = cljs.core.rest(cljs.core.next(arglist__7301));
    return closest__delegate($elem, selector, p__7297)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7302) {
    var vec__7303__7304 = p__7302;
    var v__7305 = cljs.core.nth.call(null, vec__7303__7304, 0, null);
    if(cljs.core.truth_(v__7305)) {
      return $elem.val(v__7305)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7302 = null;
    if(goog.isDef(var_args)) {
      p__7302 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7302)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7306) {
    var $elem = cljs.core.first(arglist__7306);
    var p__7302 = cljs.core.rest(arglist__7306);
    return val__delegate($elem, p__7302)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7307, content, callback) {
  var vec__7308__7309 = p__7307;
  var method__7310 = cljs.core.nth.call(null, vec__7308__7309, 0, null);
  var uri__7311 = cljs.core.nth.call(null, vec__7308__7309, 1, null);
  var params__7312 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7310)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7311, params__7312)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7313) {
    var vec__7314__7315 = p__7313;
    var func__7316 = cljs.core.nth.call(null, vec__7314__7315, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7316)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7313 = null;
    if(goog.isDef(var_args)) {
      p__7313 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7313)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7317) {
    var $elem = cljs.core.first(arglist__7317);
    var ev = cljs.core.first(cljs.core.next(arglist__7317));
    var p__7313 = cljs.core.rest(cljs.core.next(arglist__7317));
    return unbind__delegate($elem, ev, p__7313)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7318) {
    var vec__7319__7320 = p__7318;
    var sel__7321 = cljs.core.nth.call(null, vec__7319__7320, 0, null);
    var data__7322 = cljs.core.nth.call(null, vec__7319__7320, 1, null);
    var handler__7323 = cljs.core.nth.call(null, vec__7319__7320, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7321), data__7322, handler__7323)
  };
  var on = function($elem, events, var_args) {
    var p__7318 = null;
    if(goog.isDef(var_args)) {
      p__7318 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7318)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7324) {
    var $elem = cljs.core.first(arglist__7324);
    var events = cljs.core.first(cljs.core.next(arglist__7324));
    var p__7318 = cljs.core.rest(cljs.core.next(arglist__7324));
    return on__delegate($elem, events, p__7318)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7325) {
    var vec__7326__7327 = p__7325;
    var sel__7328 = cljs.core.nth.call(null, vec__7326__7327, 0, null);
    var data__7329 = cljs.core.nth.call(null, vec__7326__7327, 1, null);
    var handler__7330 = cljs.core.nth.call(null, vec__7326__7327, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7328), data__7329, handler__7330)
  };
  var one = function($elem, events, var_args) {
    var p__7325 = null;
    if(goog.isDef(var_args)) {
      p__7325 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7325)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7331) {
    var $elem = cljs.core.first(arglist__7331);
    var events = cljs.core.first(cljs.core.next(arglist__7331));
    var p__7325 = cljs.core.rest(cljs.core.next(arglist__7331));
    return one__delegate($elem, events, p__7325)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7332) {
    var vec__7333__7334 = p__7332;
    var sel__7335 = cljs.core.nth.call(null, vec__7333__7334, 0, null);
    var handler__7336 = cljs.core.nth.call(null, vec__7333__7334, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7335), handler__7336)
  };
  var off = function($elem, events, var_args) {
    var p__7332 = null;
    if(goog.isDef(var_args)) {
      p__7332 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7332)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7337) {
    var $elem = cljs.core.first(arglist__7337);
    var events = cljs.core.first(cljs.core.next(arglist__7337));
    var p__7332 = cljs.core.rest(cljs.core.next(arglist__7337));
    return off__delegate($elem, events, p__7332)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4672 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4671_SHARP_) {
    return out__4672[cljs.core.name.call(null, cljs.core.first.call(null, p1__4671_SHARP_))] = cljs.core.second.call(null, p1__4671_SHARP_)
  }, cljmap));
  return out__4672
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4673 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4673) {
    return or__3548__auto____4673
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4674 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4675 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname__4674)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname__4674).call(null, elem, cljsbinding.valuefn.call(null, elem, fname__4675, ctx, bindingname__4674))
    }
  }else {
    return function() {
      return elem[bindingname__4674].call(elem, cljsbinding.valuefn.call(null, elem, fname__4675, ctx, bindingname__4674))
    }
  }
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_elem = function bind_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4676__4677 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4676__4677)) {
    var data__4678 = cljs.core.first.call(null, G__4676__4677);
    var G__4676__4679 = G__4676__4677;
    while(true) {
      cljsbinding.bind_elem.call(null, elem, data__4678.split(":"), ctx);
      var temp__3698__auto____4680 = cljs.core.next.call(null, G__4676__4679);
      if(cljs.core.truth_(temp__3698__auto____4680)) {
        var G__4676__4681 = temp__3698__auto____4680;
        var G__4682 = cljs.core.first.call(null, G__4676__4681);
        var G__4683 = G__4676__4681;
        data__4678 = G__4682;
        G__4676__4679 = G__4683;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem) {
  var aval__4685 = cljs.core.deref.call(null, eval(jayq.core.attr.call(null, elem, "bindatom")));
  if(cljs.core.map_QMARK_.call(null, aval__4685)) {
    return aval__4685.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4685
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4684_SHARP_) {
      return cljs.core.assoc.call(null, p1__4684_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.is(":checked"));
    return false
  })
};
cljsbinding.bindatom = function bindatom(elem) {
  if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
    return cljsbinding.bind_checkbox_atom.call(null, elem)
  }else {
    return cljsbinding.bind_input_atom.call(null, elem)
  }
};
cljsbinding.bindall = function bindall(parent, ctx) {
  var seqs__4687 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4688 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__4686_SHARP_) {
    return jayq.core.$.call(null, p1__4686_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4689__4690 = cljs.core.seq.call(null, seqs__4687);
  if(cljs.core.truth_(G__4689__4690)) {
    var elem__4691 = cljs.core.first.call(null, G__4689__4690);
    var G__4689__4692 = G__4689__4690;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4691));
      var temp__3698__auto____4693 = cljs.core.next.call(null, G__4689__4692);
      if(cljs.core.truth_(temp__3698__auto____4693)) {
        var G__4689__4694 = temp__3698__auto____4693;
        var G__4732 = cljs.core.first.call(null, G__4689__4694);
        var G__4733 = G__4689__4694;
        elem__4691 = G__4732;
        G__4689__4692 = G__4733;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4695__4696 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4695__4696)) {
    var elem__4697 = cljs.core.first.call(null, G__4695__4696);
    var G__4695__4698 = G__4695__4696;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4697), ctx);
      var temp__3698__auto____4699 = cljs.core.next.call(null, G__4695__4698);
      if(cljs.core.truth_(temp__3698__auto____4699)) {
        var G__4695__4700 = temp__3698__auto____4699;
        var G__4734 = cljs.core.first.call(null, G__4695__4700);
        var G__4735 = G__4695__4700;
        elem__4697 = G__4734;
        G__4695__4698 = G__4735;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4701__4702 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4701__4702)) {
    var elem__4703 = cljs.core.first.call(null, G__4701__4702);
    var G__4701__4704 = G__4701__4702;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4703), ctx);
      var temp__3698__auto____4705 = cljs.core.next.call(null, G__4701__4704);
      if(cljs.core.truth_(temp__3698__auto____4705)) {
        var G__4701__4706 = temp__3698__auto____4705;
        var G__4736 = cljs.core.first.call(null, G__4701__4706);
        var G__4737 = G__4701__4706;
        elem__4703 = G__4736;
        G__4701__4704 = G__4737;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4707__4708 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4707__4708)) {
    var elem__4709 = cljs.core.first.call(null, G__4707__4708);
    var G__4707__4710 = G__4707__4708;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4709));
      var temp__3698__auto____4711 = cljs.core.next.call(null, G__4707__4710);
      if(cljs.core.truth_(temp__3698__auto____4711)) {
        var G__4707__4712 = temp__3698__auto____4711;
        var G__4738 = cljs.core.first.call(null, G__4707__4712);
        var G__4739 = G__4707__4712;
        elem__4709 = G__4738;
        G__4707__4710 = G__4739;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4713__4714 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4687, seqparents__4688));
  if(cljs.core.truth_(G__4713__4714)) {
    var G__4716__4718 = cljs.core.first.call(null, G__4713__4714);
    var vec__4717__4719 = G__4716__4718;
    var elem__4720 = cljs.core.nth.call(null, vec__4717__4719, 0, null);
    var parent__4721 = cljs.core.nth.call(null, vec__4717__4719, 1, null);
    var G__4713__4722 = G__4713__4714;
    var G__4716__4723 = G__4716__4718;
    var G__4713__4724 = G__4713__4722;
    while(true) {
      var vec__4725__4726 = G__4716__4723;
      var elem__4727 = cljs.core.nth.call(null, vec__4725__4726, 0, null);
      var parent__4728 = cljs.core.nth.call(null, vec__4725__4726, 1, null);
      var G__4713__4729 = G__4713__4724;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4727), parent__4728);
      var temp__3698__auto____4730 = cljs.core.next.call(null, G__4713__4729);
      if(cljs.core.truth_(temp__3698__auto____4730)) {
        var G__4713__4731 = temp__3698__auto____4730;
        var G__4740 = cljs.core.first.call(null, G__4713__4731);
        var G__4741 = G__4713__4731;
        G__4716__4723 = G__4740;
        G__4713__4724 = G__4741;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem) {
  jayq.core.append.call(null, parent, elem);
  return cljsbinding.bindall.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template) {
  jayq.core.remove.call(null, parent.children());
  var G__4742__4743 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4742__4743)) {
    var item__4744 = cljs.core.first.call(null, G__4742__4743);
    var G__4742__4745 = G__4742__4743;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4744, template.clone());
      var temp__3698__auto____4746 = cljs.core.next.call(null, G__4742__4745);
      if(cljs.core.truth_(temp__3698__auto____4746)) {
        var G__4742__4747 = temp__3698__auto____4746;
        var G__4748 = cljs.core.first.call(null, G__4742__4747);
        var G__4749 = G__4742__4747;
        item__4744 = G__4748;
        G__4742__4745 = G__4749;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent) {
  var atom__4750 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4750), elparent, elem);
  return cljs.core.add_watch.call(null, atom__4750, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem)
  })
};
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4751_SHARP_, p2__4752_SHARP_) {
      var or__3548__auto____4755 = p1__4751_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4755)) {
        return or__3548__auto____4755
      }else {
        return p2__4752_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4753_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4753_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, function(p1__4754_SHARP_) {
    return cljs.core.assoc.call(null, p1__4754_SHARP_, atom, cljs.core.contains_QMARK_.call(null, p1__4754_SHARP_, atom) ? cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), p1__4754_SHARP_.call(null, atom)) : cljs.core.PersistentVector.fromArray([cljs.core.deref.call(null, cljsbinding.BindFn)]))
  });
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", function(key, a, old_val, new_val) {
    var G__4756__4757 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
    if(cljs.core.truth_(G__4756__4757)) {
      var f__4758 = cljs.core.first.call(null, G__4756__4757);
      var G__4756__4759 = G__4756__4757;
      while(true) {
        f__4758.call(null);
        var temp__3698__auto____4760 = cljs.core.next.call(null, G__4756__4759);
        if(cljs.core.truth_(temp__3698__auto____4760)) {
          var G__4756__4761 = temp__3698__auto____4760;
          var G__4762 = cljs.core.first.call(null, G__4756__4761);
          var G__4763 = G__4756__4761;
          f__4758 = G__4762;
          G__4756__4759 = G__4763;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  });
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.boot = function boot() {
  return eval("    \n    var deref = cljs.core.deref\n    cljs.core.deref = function (a) {\n     if (deref(cljsbinding.BindMonitor))\n       cljsbinding.register(a)\n     return deref(a)\n    }\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4764 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4764), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4764)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4764)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4764)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4764))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, localStorage[name]))
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
