var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4944__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4944 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4944__delegate.call(this, array, i, idxs)
    };
    G__4944.cljs$lang$maxFixedArity = 2;
    G__4944.cljs$lang$applyTo = function(arglist__4945) {
      var array = cljs.core.first(arglist__4945);
      var i = cljs.core.first(cljs.core.next(arglist__4945));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4945));
      return G__4944__delegate(array, i, idxs)
    };
    G__4944.cljs$lang$arity$variadic = G__4944__delegate;
    return G__4944
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4946 = this$;
      if(and__3546__auto____4946) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4946
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4947 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4947) {
          return or__3548__auto____4947
        }else {
          var or__3548__auto____4948 = cljs.core._invoke["_"];
          if(or__3548__auto____4948) {
            return or__3548__auto____4948
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4949 = this$;
      if(and__3546__auto____4949) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4949
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4950 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4950) {
          return or__3548__auto____4950
        }else {
          var or__3548__auto____4951 = cljs.core._invoke["_"];
          if(or__3548__auto____4951) {
            return or__3548__auto____4951
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4952 = this$;
      if(and__3546__auto____4952) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4952
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4953 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4953) {
          return or__3548__auto____4953
        }else {
          var or__3548__auto____4954 = cljs.core._invoke["_"];
          if(or__3548__auto____4954) {
            return or__3548__auto____4954
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4955 = this$;
      if(and__3546__auto____4955) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4955
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4956 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4956) {
          return or__3548__auto____4956
        }else {
          var or__3548__auto____4957 = cljs.core._invoke["_"];
          if(or__3548__auto____4957) {
            return or__3548__auto____4957
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4958 = this$;
      if(and__3546__auto____4958) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4958
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4959 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4959) {
          return or__3548__auto____4959
        }else {
          var or__3548__auto____4960 = cljs.core._invoke["_"];
          if(or__3548__auto____4960) {
            return or__3548__auto____4960
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4961 = this$;
      if(and__3546__auto____4961) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4961
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4962 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4962) {
          return or__3548__auto____4962
        }else {
          var or__3548__auto____4963 = cljs.core._invoke["_"];
          if(or__3548__auto____4963) {
            return or__3548__auto____4963
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4964 = this$;
      if(and__3546__auto____4964) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4964
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4965 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4965) {
          return or__3548__auto____4965
        }else {
          var or__3548__auto____4966 = cljs.core._invoke["_"];
          if(or__3548__auto____4966) {
            return or__3548__auto____4966
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4967 = this$;
      if(and__3546__auto____4967) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4967
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4968 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4968) {
          return or__3548__auto____4968
        }else {
          var or__3548__auto____4969 = cljs.core._invoke["_"];
          if(or__3548__auto____4969) {
            return or__3548__auto____4969
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4970 = this$;
      if(and__3546__auto____4970) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4970
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4971 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4971) {
          return or__3548__auto____4971
        }else {
          var or__3548__auto____4972 = cljs.core._invoke["_"];
          if(or__3548__auto____4972) {
            return or__3548__auto____4972
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4973 = this$;
      if(and__3546__auto____4973) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4973
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4974 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4974) {
          return or__3548__auto____4974
        }else {
          var or__3548__auto____4975 = cljs.core._invoke["_"];
          if(or__3548__auto____4975) {
            return or__3548__auto____4975
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4976 = this$;
      if(and__3546__auto____4976) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4976
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4977 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4977) {
          return or__3548__auto____4977
        }else {
          var or__3548__auto____4978 = cljs.core._invoke["_"];
          if(or__3548__auto____4978) {
            return or__3548__auto____4978
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4979 = this$;
      if(and__3546__auto____4979) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4979
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4980 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4980) {
          return or__3548__auto____4980
        }else {
          var or__3548__auto____4981 = cljs.core._invoke["_"];
          if(or__3548__auto____4981) {
            return or__3548__auto____4981
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4982 = this$;
      if(and__3546__auto____4982) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4982
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4983 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4983) {
          return or__3548__auto____4983
        }else {
          var or__3548__auto____4984 = cljs.core._invoke["_"];
          if(or__3548__auto____4984) {
            return or__3548__auto____4984
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4985 = this$;
      if(and__3546__auto____4985) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4985
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4986 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4986) {
          return or__3548__auto____4986
        }else {
          var or__3548__auto____4987 = cljs.core._invoke["_"];
          if(or__3548__auto____4987) {
            return or__3548__auto____4987
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4988 = this$;
      if(and__3546__auto____4988) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4988
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4989 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4989) {
          return or__3548__auto____4989
        }else {
          var or__3548__auto____4990 = cljs.core._invoke["_"];
          if(or__3548__auto____4990) {
            return or__3548__auto____4990
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4991 = this$;
      if(and__3546__auto____4991) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4991
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4992 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4992) {
          return or__3548__auto____4992
        }else {
          var or__3548__auto____4993 = cljs.core._invoke["_"];
          if(or__3548__auto____4993) {
            return or__3548__auto____4993
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4994 = this$;
      if(and__3546__auto____4994) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4994
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4995 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4995) {
          return or__3548__auto____4995
        }else {
          var or__3548__auto____4996 = cljs.core._invoke["_"];
          if(or__3548__auto____4996) {
            return or__3548__auto____4996
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____4997 = this$;
      if(and__3546__auto____4997) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____4997
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____4998 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4998) {
          return or__3548__auto____4998
        }else {
          var or__3548__auto____4999 = cljs.core._invoke["_"];
          if(or__3548__auto____4999) {
            return or__3548__auto____4999
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____5000 = this$;
      if(and__3546__auto____5000) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____5000
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____5001 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5001) {
          return or__3548__auto____5001
        }else {
          var or__3548__auto____5002 = cljs.core._invoke["_"];
          if(or__3548__auto____5002) {
            return or__3548__auto____5002
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____5003 = this$;
      if(and__3546__auto____5003) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____5003
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____5004 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5004) {
          return or__3548__auto____5004
        }else {
          var or__3548__auto____5005 = cljs.core._invoke["_"];
          if(or__3548__auto____5005) {
            return or__3548__auto____5005
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____5006 = this$;
      if(and__3546__auto____5006) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____5006
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____5007 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5007) {
          return or__3548__auto____5007
        }else {
          var or__3548__auto____5008 = cljs.core._invoke["_"];
          if(or__3548__auto____5008) {
            return or__3548__auto____5008
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____5009 = coll;
    if(and__3546__auto____5009) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____5009
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5010 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5010) {
        return or__3548__auto____5010
      }else {
        var or__3548__auto____5011 = cljs.core._count["_"];
        if(or__3548__auto____5011) {
          return or__3548__auto____5011
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____5012 = coll;
    if(and__3546__auto____5012) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____5012
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5013 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5013) {
        return or__3548__auto____5013
      }else {
        var or__3548__auto____5014 = cljs.core._empty["_"];
        if(or__3548__auto____5014) {
          return or__3548__auto____5014
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____5015 = coll;
    if(and__3546__auto____5015) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____5015
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____5016 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5016) {
        return or__3548__auto____5016
      }else {
        var or__3548__auto____5017 = cljs.core._conj["_"];
        if(or__3548__auto____5017) {
          return or__3548__auto____5017
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____5018 = coll;
      if(and__3546__auto____5018) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____5018
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____5019 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5019) {
          return or__3548__auto____5019
        }else {
          var or__3548__auto____5020 = cljs.core._nth["_"];
          if(or__3548__auto____5020) {
            return or__3548__auto____5020
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____5021 = coll;
      if(and__3546__auto____5021) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____5021
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____5022 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5022) {
          return or__3548__auto____5022
        }else {
          var or__3548__auto____5023 = cljs.core._nth["_"];
          if(or__3548__auto____5023) {
            return or__3548__auto____5023
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____5024 = coll;
    if(and__3546__auto____5024) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____5024
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5025 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5025) {
        return or__3548__auto____5025
      }else {
        var or__3548__auto____5026 = cljs.core._first["_"];
        if(or__3548__auto____5026) {
          return or__3548__auto____5026
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____5027 = coll;
    if(and__3546__auto____5027) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____5027
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5028 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5028) {
        return or__3548__auto____5028
      }else {
        var or__3548__auto____5029 = cljs.core._rest["_"];
        if(or__3548__auto____5029) {
          return or__3548__auto____5029
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____5030 = o;
      if(and__3546__auto____5030) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____5030
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____5031 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5031) {
          return or__3548__auto____5031
        }else {
          var or__3548__auto____5032 = cljs.core._lookup["_"];
          if(or__3548__auto____5032) {
            return or__3548__auto____5032
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____5033 = o;
      if(and__3546__auto____5033) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____5033
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____5034 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5034) {
          return or__3548__auto____5034
        }else {
          var or__3548__auto____5035 = cljs.core._lookup["_"];
          if(or__3548__auto____5035) {
            return or__3548__auto____5035
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____5036 = coll;
    if(and__3546__auto____5036) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____5036
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5037 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5037) {
        return or__3548__auto____5037
      }else {
        var or__3548__auto____5038 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____5038) {
          return or__3548__auto____5038
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____5039 = coll;
    if(and__3546__auto____5039) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____5039
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____5040 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5040) {
        return or__3548__auto____5040
      }else {
        var or__3548__auto____5041 = cljs.core._assoc["_"];
        if(or__3548__auto____5041) {
          return or__3548__auto____5041
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____5042 = coll;
    if(and__3546__auto____5042) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____5042
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5043 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5043) {
        return or__3548__auto____5043
      }else {
        var or__3548__auto____5044 = cljs.core._dissoc["_"];
        if(or__3548__auto____5044) {
          return or__3548__auto____5044
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____5045 = coll;
    if(and__3546__auto____5045) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____5045
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5046 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5046) {
        return or__3548__auto____5046
      }else {
        var or__3548__auto____5047 = cljs.core._key["_"];
        if(or__3548__auto____5047) {
          return or__3548__auto____5047
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____5048 = coll;
    if(and__3546__auto____5048) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____5048
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5049 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5049) {
        return or__3548__auto____5049
      }else {
        var or__3548__auto____5050 = cljs.core._val["_"];
        if(or__3548__auto____5050) {
          return or__3548__auto____5050
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____5051 = coll;
    if(and__3546__auto____5051) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____5051
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____5052 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5052) {
        return or__3548__auto____5052
      }else {
        var or__3548__auto____5053 = cljs.core._disjoin["_"];
        if(or__3548__auto____5053) {
          return or__3548__auto____5053
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____5054 = coll;
    if(and__3546__auto____5054) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____5054
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5055 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5055) {
        return or__3548__auto____5055
      }else {
        var or__3548__auto____5056 = cljs.core._peek["_"];
        if(or__3548__auto____5056) {
          return or__3548__auto____5056
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____5057 = coll;
    if(and__3546__auto____5057) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____5057
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5058 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5058) {
        return or__3548__auto____5058
      }else {
        var or__3548__auto____5059 = cljs.core._pop["_"];
        if(or__3548__auto____5059) {
          return or__3548__auto____5059
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____5060 = coll;
    if(and__3546__auto____5060) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____5060
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____5061 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5061) {
        return or__3548__auto____5061
      }else {
        var or__3548__auto____5062 = cljs.core._assoc_n["_"];
        if(or__3548__auto____5062) {
          return or__3548__auto____5062
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____5063 = o;
    if(and__3546__auto____5063) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____5063
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5064 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____5064) {
        return or__3548__auto____5064
      }else {
        var or__3548__auto____5065 = cljs.core._deref["_"];
        if(or__3548__auto____5065) {
          return or__3548__auto____5065
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____5066 = o;
    if(and__3546__auto____5066) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____5066
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____5067 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____5067) {
        return or__3548__auto____5067
      }else {
        var or__3548__auto____5068 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____5068) {
          return or__3548__auto____5068
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____5069 = o;
    if(and__3546__auto____5069) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____5069
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5070 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5070) {
        return or__3548__auto____5070
      }else {
        var or__3548__auto____5071 = cljs.core._meta["_"];
        if(or__3548__auto____5071) {
          return or__3548__auto____5071
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____5072 = o;
    if(and__3546__auto____5072) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____5072
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____5073 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5073) {
        return or__3548__auto____5073
      }else {
        var or__3548__auto____5074 = cljs.core._with_meta["_"];
        if(or__3548__auto____5074) {
          return or__3548__auto____5074
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____5075 = coll;
      if(and__3546__auto____5075) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____5075
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____5076 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5076) {
          return or__3548__auto____5076
        }else {
          var or__3548__auto____5077 = cljs.core._reduce["_"];
          if(or__3548__auto____5077) {
            return or__3548__auto____5077
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____5078 = coll;
      if(and__3546__auto____5078) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____5078
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____5079 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5079) {
          return or__3548__auto____5079
        }else {
          var or__3548__auto____5080 = cljs.core._reduce["_"];
          if(or__3548__auto____5080) {
            return or__3548__auto____5080
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____5081 = coll;
    if(and__3546__auto____5081) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____5081
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____5082 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5082) {
        return or__3548__auto____5082
      }else {
        var or__3548__auto____5083 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____5083) {
          return or__3548__auto____5083
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____5084 = o;
    if(and__3546__auto____5084) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____5084
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____5085 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____5085) {
        return or__3548__auto____5085
      }else {
        var or__3548__auto____5086 = cljs.core._equiv["_"];
        if(or__3548__auto____5086) {
          return or__3548__auto____5086
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____5087 = o;
    if(and__3546__auto____5087) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____5087
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5088 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____5088) {
        return or__3548__auto____5088
      }else {
        var or__3548__auto____5089 = cljs.core._hash["_"];
        if(or__3548__auto____5089) {
          return or__3548__auto____5089
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____5090 = o;
    if(and__3546__auto____5090) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____5090
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5091 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5091) {
        return or__3548__auto____5091
      }else {
        var or__3548__auto____5092 = cljs.core._seq["_"];
        if(or__3548__auto____5092) {
          return or__3548__auto____5092
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____5093 = coll;
    if(and__3546__auto____5093) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____5093
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5094 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5094) {
        return or__3548__auto____5094
      }else {
        var or__3548__auto____5095 = cljs.core._rseq["_"];
        if(or__3548__auto____5095) {
          return or__3548__auto____5095
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5096 = coll;
    if(and__3546__auto____5096) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____5096
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5097 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5097) {
        return or__3548__auto____5097
      }else {
        var or__3548__auto____5098 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____5098) {
          return or__3548__auto____5098
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5099 = coll;
    if(and__3546__auto____5099) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____5099
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5100 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5100) {
        return or__3548__auto____5100
      }else {
        var or__3548__auto____5101 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____5101) {
          return or__3548__auto____5101
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____5102 = coll;
    if(and__3546__auto____5102) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____5102
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____5103 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5103) {
        return or__3548__auto____5103
      }else {
        var or__3548__auto____5104 = cljs.core._entry_key["_"];
        if(or__3548__auto____5104) {
          return or__3548__auto____5104
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____5105 = coll;
    if(and__3546__auto____5105) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____5105
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5106 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5106) {
        return or__3548__auto____5106
      }else {
        var or__3548__auto____5107 = cljs.core._comparator["_"];
        if(or__3548__auto____5107) {
          return or__3548__auto____5107
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____5108 = o;
    if(and__3546__auto____5108) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____5108
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____5109 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5109) {
        return or__3548__auto____5109
      }else {
        var or__3548__auto____5110 = cljs.core._pr_seq["_"];
        if(or__3548__auto____5110) {
          return or__3548__auto____5110
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____5111 = d;
    if(and__3546__auto____5111) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____5111
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____5112 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____5112) {
        return or__3548__auto____5112
      }else {
        var or__3548__auto____5113 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____5113) {
          return or__3548__auto____5113
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____5114 = this$;
    if(and__3546__auto____5114) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____5114
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____5115 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5115) {
        return or__3548__auto____5115
      }else {
        var or__3548__auto____5116 = cljs.core._notify_watches["_"];
        if(or__3548__auto____5116) {
          return or__3548__auto____5116
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____5117 = this$;
    if(and__3546__auto____5117) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____5117
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____5118 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5118) {
        return or__3548__auto____5118
      }else {
        var or__3548__auto____5119 = cljs.core._add_watch["_"];
        if(or__3548__auto____5119) {
          return or__3548__auto____5119
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____5120 = this$;
    if(and__3546__auto____5120) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____5120
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____5121 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5121) {
        return or__3548__auto____5121
      }else {
        var or__3548__auto____5122 = cljs.core._remove_watch["_"];
        if(or__3548__auto____5122) {
          return or__3548__auto____5122
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____5123 = coll;
    if(and__3546__auto____5123) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____5123
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5124 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5124) {
        return or__3548__auto____5124
      }else {
        var or__3548__auto____5125 = cljs.core._as_transient["_"];
        if(or__3548__auto____5125) {
          return or__3548__auto____5125
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____5126 = tcoll;
    if(and__3546__auto____5126) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____5126
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____5127 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5127) {
        return or__3548__auto____5127
      }else {
        var or__3548__auto____5128 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____5128) {
          return or__3548__auto____5128
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5129 = tcoll;
    if(and__3546__auto____5129) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____5129
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5130 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5130) {
        return or__3548__auto____5130
      }else {
        var or__3548__auto____5131 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____5131) {
          return or__3548__auto____5131
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____5132 = tcoll;
    if(and__3546__auto____5132) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____5132
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____5133 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5133) {
        return or__3548__auto____5133
      }else {
        var or__3548__auto____5134 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____5134) {
          return or__3548__auto____5134
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____5135 = tcoll;
    if(and__3546__auto____5135) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____5135
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____5136 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5136) {
        return or__3548__auto____5136
      }else {
        var or__3548__auto____5137 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____5137) {
          return or__3548__auto____5137
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____5138 = tcoll;
    if(and__3546__auto____5138) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____5138
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____5139 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5139) {
        return or__3548__auto____5139
      }else {
        var or__3548__auto____5140 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____5140) {
          return or__3548__auto____5140
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5141 = tcoll;
    if(and__3546__auto____5141) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____5141
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5142 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5142) {
        return or__3548__auto____5142
      }else {
        var or__3548__auto____5143 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____5143) {
          return or__3548__auto____5143
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____5144 = tcoll;
    if(and__3546__auto____5144) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____5144
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____5145 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5145) {
        return or__3548__auto____5145
      }else {
        var or__3548__auto____5146 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____5146) {
          return or__3548__auto____5146
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____5147 = x === y;
    if(or__3548__auto____5147) {
      return or__3548__auto____5147
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__5148__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5149 = y;
            var G__5150 = cljs.core.first.call(null, more);
            var G__5151 = cljs.core.next.call(null, more);
            x = G__5149;
            y = G__5150;
            more = G__5151;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5148 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5148__delegate.call(this, x, y, more)
    };
    G__5148.cljs$lang$maxFixedArity = 2;
    G__5148.cljs$lang$applyTo = function(arglist__5152) {
      var x = cljs.core.first(arglist__5152);
      var y = cljs.core.first(cljs.core.next(arglist__5152));
      var more = cljs.core.rest(cljs.core.next(arglist__5152));
      return G__5148__delegate(x, y, more)
    };
    G__5148.cljs$lang$arity$variadic = G__5148__delegate;
    return G__5148
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____5153 = x == null;
    if(or__3548__auto____5153) {
      return or__3548__auto____5153
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__5154 = null;
  var G__5154__2 = function(o, k) {
    return null
  };
  var G__5154__3 = function(o, k, not_found) {
    return not_found
  };
  G__5154 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5154__2.call(this, o, k);
      case 3:
        return G__5154__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5154
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__5155 = null;
  var G__5155__2 = function(_, f) {
    return f.call(null)
  };
  var G__5155__3 = function(_, f, start) {
    return start
  };
  G__5155 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5155__2.call(this, _, f);
      case 3:
        return G__5155__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5155
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__5156 = null;
  var G__5156__2 = function(_, n) {
    return null
  };
  var G__5156__3 = function(_, n, not_found) {
    return not_found
  };
  G__5156 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5156__2.call(this, _, n);
      case 3:
        return G__5156__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5156
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__5157 = cljs.core._nth.call(null, cicoll, 0);
      var n__5158 = 1;
      while(true) {
        if(n__5158 < cljs.core._count.call(null, cicoll)) {
          var nval__5159 = f.call(null, val__5157, cljs.core._nth.call(null, cicoll, n__5158));
          if(cljs.core.reduced_QMARK_.call(null, nval__5159)) {
            return cljs.core.deref.call(null, nval__5159)
          }else {
            var G__5166 = nval__5159;
            var G__5167 = n__5158 + 1;
            val__5157 = G__5166;
            n__5158 = G__5167;
            continue
          }
        }else {
          return val__5157
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__5160 = val;
    var n__5161 = 0;
    while(true) {
      if(n__5161 < cljs.core._count.call(null, cicoll)) {
        var nval__5162 = f.call(null, val__5160, cljs.core._nth.call(null, cicoll, n__5161));
        if(cljs.core.reduced_QMARK_.call(null, nval__5162)) {
          return cljs.core.deref.call(null, nval__5162)
        }else {
          var G__5168 = nval__5162;
          var G__5169 = n__5161 + 1;
          val__5160 = G__5168;
          n__5161 = G__5169;
          continue
        }
      }else {
        return val__5160
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__5163 = val;
    var n__5164 = idx;
    while(true) {
      if(n__5164 < cljs.core._count.call(null, cicoll)) {
        var nval__5165 = f.call(null, val__5163, cljs.core._nth.call(null, cicoll, n__5164));
        if(cljs.core.reduced_QMARK_.call(null, nval__5165)) {
          return cljs.core.deref.call(null, nval__5165)
        }else {
          var G__5170 = nval__5165;
          var G__5171 = n__5164 + 1;
          val__5163 = G__5170;
          n__5164 = G__5171;
          continue
        }
      }else {
        return val__5163
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5172 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5173 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__5174 = this;
  var this$__5175 = this;
  return cljs.core.pr_str.call(null, this$__5175)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5176 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5176.a)) {
    return cljs.core.ci_reduce.call(null, this__5176.a, f, this__5176.a[this__5176.i], this__5176.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__5176.a[this__5176.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5177 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5177.a)) {
    return cljs.core.ci_reduce.call(null, this__5177.a, f, start, this__5177.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__5178 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__5179 = this;
  return this__5179.a.length - this__5179.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5180 = this;
  return this__5180.a[this__5180.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5181 = this;
  if(this__5181.i + 1 < this__5181.a.length) {
    return new cljs.core.IndexedSeq(this__5181.a, this__5181.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5182 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5183 = this;
  var i__5184 = n + this__5183.i;
  if(i__5184 < this__5183.a.length) {
    return this__5183.a[i__5184]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5185 = this;
  var i__5186 = n + this__5185.i;
  if(i__5186 < this__5185.a.length) {
    return this__5185.a[i__5186]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5187 = null;
  var G__5187__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5187__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5187 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5187__2.call(this, array, f);
      case 3:
        return G__5187__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5187
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5188 = null;
  var G__5188__2 = function(array, k) {
    return array[k]
  };
  var G__5188__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5188 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5188__2.call(this, array, k);
      case 3:
        return G__5188__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5188
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5189 = null;
  var G__5189__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5189__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5189 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5189__2.call(this, array, n);
      case 3:
        return G__5189__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5189
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5190__5191 = coll;
      if(G__5190__5191 != null) {
        if(function() {
          var or__3548__auto____5192 = G__5190__5191.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5192) {
            return or__3548__auto____5192
          }else {
            return G__5190__5191.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5190__5191.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5190__5191)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5190__5191)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5193__5194 = coll;
      if(G__5193__5194 != null) {
        if(function() {
          var or__3548__auto____5195 = G__5193__5194.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5195) {
            return or__3548__auto____5195
          }else {
            return G__5193__5194.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5193__5194.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5193__5194)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5193__5194)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5196 = cljs.core.seq.call(null, coll);
      if(s__5196 != null) {
        return cljs.core._first.call(null, s__5196)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5197__5198 = coll;
      if(G__5197__5198 != null) {
        if(function() {
          var or__3548__auto____5199 = G__5197__5198.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5199) {
            return or__3548__auto____5199
          }else {
            return G__5197__5198.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5197__5198.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5197__5198)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5197__5198)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5200 = cljs.core.seq.call(null, coll);
      if(s__5200 != null) {
        return cljs.core._rest.call(null, s__5200)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5201__5202 = coll;
      if(G__5201__5202 != null) {
        if(function() {
          var or__3548__auto____5203 = G__5201__5202.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5203) {
            return or__3548__auto____5203
          }else {
            return G__5201__5202.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5201__5202.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5201__5202)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5201__5202)
      }
    }()) {
      var coll__5204 = cljs.core._rest.call(null, coll);
      if(coll__5204 != null) {
        if(function() {
          var G__5205__5206 = coll__5204;
          if(G__5205__5206 != null) {
            if(function() {
              var or__3548__auto____5207 = G__5205__5206.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5207) {
                return or__3548__auto____5207
              }else {
                return G__5205__5206.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5205__5206.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5205__5206)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5205__5206)
          }
        }()) {
          return coll__5204
        }else {
          return cljs.core._seq.call(null, coll__5204)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5208 = cljs.core.next.call(null, s);
      s = G__5208;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5209__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5210 = conj.call(null, coll, x);
          var G__5211 = cljs.core.first.call(null, xs);
          var G__5212 = cljs.core.next.call(null, xs);
          coll = G__5210;
          x = G__5211;
          xs = G__5212;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5209 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5209__delegate.call(this, coll, x, xs)
    };
    G__5209.cljs$lang$maxFixedArity = 2;
    G__5209.cljs$lang$applyTo = function(arglist__5213) {
      var coll = cljs.core.first(arglist__5213);
      var x = cljs.core.first(cljs.core.next(arglist__5213));
      var xs = cljs.core.rest(cljs.core.next(arglist__5213));
      return G__5209__delegate(coll, x, xs)
    };
    G__5209.cljs$lang$arity$variadic = G__5209__delegate;
    return G__5209
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5214 = cljs.core.seq.call(null, coll);
  var acc__5215 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5214)) {
      return acc__5215 + cljs.core._count.call(null, s__5214)
    }else {
      var G__5216 = cljs.core.next.call(null, s__5214);
      var G__5217 = acc__5215 + 1;
      s__5214 = G__5216;
      acc__5215 = G__5217;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5218__5219 = coll;
        if(G__5218__5219 != null) {
          if(function() {
            var or__3548__auto____5220 = G__5218__5219.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5220) {
              return or__3548__auto____5220
            }else {
              return G__5218__5219.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5218__5219.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5218__5219)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5218__5219)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5221__5222 = coll;
        if(G__5221__5222 != null) {
          if(function() {
            var or__3548__auto____5223 = G__5221__5222.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5223) {
              return or__3548__auto____5223
            }else {
              return G__5221__5222.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5221__5222.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5221__5222)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5221__5222)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5225__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5224 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5226 = ret__5224;
          var G__5227 = cljs.core.first.call(null, kvs);
          var G__5228 = cljs.core.second.call(null, kvs);
          var G__5229 = cljs.core.nnext.call(null, kvs);
          coll = G__5226;
          k = G__5227;
          v = G__5228;
          kvs = G__5229;
          continue
        }else {
          return ret__5224
        }
        break
      }
    };
    var G__5225 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5225__delegate.call(this, coll, k, v, kvs)
    };
    G__5225.cljs$lang$maxFixedArity = 3;
    G__5225.cljs$lang$applyTo = function(arglist__5230) {
      var coll = cljs.core.first(arglist__5230);
      var k = cljs.core.first(cljs.core.next(arglist__5230));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5230)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5230)));
      return G__5225__delegate(coll, k, v, kvs)
    };
    G__5225.cljs$lang$arity$variadic = G__5225__delegate;
    return G__5225
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5232__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5231 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5233 = ret__5231;
          var G__5234 = cljs.core.first.call(null, ks);
          var G__5235 = cljs.core.next.call(null, ks);
          coll = G__5233;
          k = G__5234;
          ks = G__5235;
          continue
        }else {
          return ret__5231
        }
        break
      }
    };
    var G__5232 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5232__delegate.call(this, coll, k, ks)
    };
    G__5232.cljs$lang$maxFixedArity = 2;
    G__5232.cljs$lang$applyTo = function(arglist__5236) {
      var coll = cljs.core.first(arglist__5236);
      var k = cljs.core.first(cljs.core.next(arglist__5236));
      var ks = cljs.core.rest(cljs.core.next(arglist__5236));
      return G__5232__delegate(coll, k, ks)
    };
    G__5232.cljs$lang$arity$variadic = G__5232__delegate;
    return G__5232
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5237__5238 = o;
    if(G__5237__5238 != null) {
      if(function() {
        var or__3548__auto____5239 = G__5237__5238.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5239) {
          return or__3548__auto____5239
        }else {
          return G__5237__5238.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5237__5238.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5237__5238)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5237__5238)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5241__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5240 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5242 = ret__5240;
          var G__5243 = cljs.core.first.call(null, ks);
          var G__5244 = cljs.core.next.call(null, ks);
          coll = G__5242;
          k = G__5243;
          ks = G__5244;
          continue
        }else {
          return ret__5240
        }
        break
      }
    };
    var G__5241 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5241__delegate.call(this, coll, k, ks)
    };
    G__5241.cljs$lang$maxFixedArity = 2;
    G__5241.cljs$lang$applyTo = function(arglist__5245) {
      var coll = cljs.core.first(arglist__5245);
      var k = cljs.core.first(cljs.core.next(arglist__5245));
      var ks = cljs.core.rest(cljs.core.next(arglist__5245));
      return G__5241__delegate(coll, k, ks)
    };
    G__5241.cljs$lang$arity$variadic = G__5241__delegate;
    return G__5241
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5246__5247 = x;
    if(G__5246__5247 != null) {
      if(function() {
        var or__3548__auto____5248 = G__5246__5247.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5248) {
          return or__3548__auto____5248
        }else {
          return G__5246__5247.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5246__5247.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5246__5247)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5246__5247)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5249__5250 = x;
    if(G__5249__5250 != null) {
      if(function() {
        var or__3548__auto____5251 = G__5249__5250.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5251) {
          return or__3548__auto____5251
        }else {
          return G__5249__5250.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5249__5250.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5249__5250)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5249__5250)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5252__5253 = x;
  if(G__5252__5253 != null) {
    if(function() {
      var or__3548__auto____5254 = G__5252__5253.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5254) {
        return or__3548__auto____5254
      }else {
        return G__5252__5253.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5252__5253.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5252__5253)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5252__5253)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5255__5256 = x;
  if(G__5255__5256 != null) {
    if(function() {
      var or__3548__auto____5257 = G__5255__5256.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5257) {
        return or__3548__auto____5257
      }else {
        return G__5255__5256.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5255__5256.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5255__5256)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5255__5256)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5258__5259 = x;
  if(G__5258__5259 != null) {
    if(function() {
      var or__3548__auto____5260 = G__5258__5259.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5260) {
        return or__3548__auto____5260
      }else {
        return G__5258__5259.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5258__5259.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5258__5259)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5258__5259)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5261__5262 = x;
  if(G__5261__5262 != null) {
    if(function() {
      var or__3548__auto____5263 = G__5261__5262.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5263) {
        return or__3548__auto____5263
      }else {
        return G__5261__5262.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5261__5262.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5261__5262)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5261__5262)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5264__5265 = x;
  if(G__5264__5265 != null) {
    if(function() {
      var or__3548__auto____5266 = G__5264__5265.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5266) {
        return or__3548__auto____5266
      }else {
        return G__5264__5265.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5264__5265.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5264__5265)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5264__5265)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5267__5268 = x;
    if(G__5267__5268 != null) {
      if(function() {
        var or__3548__auto____5269 = G__5267__5268.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5269) {
          return or__3548__auto____5269
        }else {
          return G__5267__5268.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5267__5268.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5267__5268)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5267__5268)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5270__5271 = x;
  if(G__5270__5271 != null) {
    if(function() {
      var or__3548__auto____5272 = G__5270__5271.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5272) {
        return or__3548__auto____5272
      }else {
        return G__5270__5271.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5270__5271.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5270__5271)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5270__5271)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5273__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5273 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5273__delegate.call(this, keyvals)
    };
    G__5273.cljs$lang$maxFixedArity = 0;
    G__5273.cljs$lang$applyTo = function(arglist__5274) {
      var keyvals = cljs.core.seq(arglist__5274);
      return G__5273__delegate(keyvals)
    };
    G__5273.cljs$lang$arity$variadic = G__5273__delegate;
    return G__5273
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5275 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5275.push(key)
  });
  return keys__5275
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5276 = i;
  var j__5277 = j;
  var len__5278 = len;
  while(true) {
    if(len__5278 === 0) {
      return to
    }else {
      to[j__5277] = from[i__5276];
      var G__5279 = i__5276 + 1;
      var G__5280 = j__5277 + 1;
      var G__5281 = len__5278 - 1;
      i__5276 = G__5279;
      j__5277 = G__5280;
      len__5278 = G__5281;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5282 = i + (len - 1);
  var j__5283 = j + (len - 1);
  var len__5284 = len;
  while(true) {
    if(len__5284 === 0) {
      return to
    }else {
      to[j__5283] = from[i__5282];
      var G__5285 = i__5282 - 1;
      var G__5286 = j__5283 - 1;
      var G__5287 = len__5284 - 1;
      i__5282 = G__5285;
      j__5283 = G__5286;
      len__5284 = G__5287;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5288__5289 = s;
    if(G__5288__5289 != null) {
      if(function() {
        var or__3548__auto____5290 = G__5288__5289.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5290) {
          return or__3548__auto____5290
        }else {
          return G__5288__5289.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5288__5289.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5288__5289)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5288__5289)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5291__5292 = s;
  if(G__5291__5292 != null) {
    if(function() {
      var or__3548__auto____5293 = G__5291__5292.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5293) {
        return or__3548__auto____5293
      }else {
        return G__5291__5292.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5291__5292.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5291__5292)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5291__5292)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5294 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5294)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5295 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5295) {
        return or__3548__auto____5295
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5294
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5296 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5296)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5296
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5297 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5297)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5297
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5298 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5298) {
    return or__3548__auto____5298
  }else {
    var G__5299__5300 = f;
    if(G__5299__5300 != null) {
      if(function() {
        var or__3548__auto____5301 = G__5299__5300.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5301) {
          return or__3548__auto____5301
        }else {
          return G__5299__5300.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5299__5300.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5299__5300)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5299__5300)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5302 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5302) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5302
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5303 = coll;
    if(cljs.core.truth_(and__3546__auto____5303)) {
      var and__3546__auto____5304 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5304) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5304
      }
    }else {
      return and__3546__auto____5303
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5309__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5305 = cljs.core.set([y, x]);
        var xs__5306 = more;
        while(true) {
          var x__5307 = cljs.core.first.call(null, xs__5306);
          var etc__5308 = cljs.core.next.call(null, xs__5306);
          if(cljs.core.truth_(xs__5306)) {
            if(cljs.core.contains_QMARK_.call(null, s__5305, x__5307)) {
              return false
            }else {
              var G__5310 = cljs.core.conj.call(null, s__5305, x__5307);
              var G__5311 = etc__5308;
              s__5305 = G__5310;
              xs__5306 = G__5311;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5309 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5309__delegate.call(this, x, y, more)
    };
    G__5309.cljs$lang$maxFixedArity = 2;
    G__5309.cljs$lang$applyTo = function(arglist__5312) {
      var x = cljs.core.first(arglist__5312);
      var y = cljs.core.first(cljs.core.next(arglist__5312));
      var more = cljs.core.rest(cljs.core.next(arglist__5312));
      return G__5309__delegate(x, y, more)
    };
    G__5309.cljs$lang$arity$variadic = G__5309__delegate;
    return G__5309
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5313 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5313)) {
        return r__5313
      }else {
        if(cljs.core.truth_(r__5313)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5314 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5314, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5314)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5315 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5315)) {
      var s__5316 = temp__3695__auto____5315;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5316), cljs.core.next.call(null, s__5316))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5317 = val;
    var coll__5318 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5318)) {
        var nval__5319 = f.call(null, val__5317, cljs.core.first.call(null, coll__5318));
        if(cljs.core.reduced_QMARK_.call(null, nval__5319)) {
          return cljs.core.deref.call(null, nval__5319)
        }else {
          var G__5320 = nval__5319;
          var G__5321 = cljs.core.next.call(null, coll__5318);
          val__5317 = G__5320;
          coll__5318 = G__5321;
          continue
        }
      }else {
        return val__5317
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5322__5323 = coll;
      if(G__5322__5323 != null) {
        if(function() {
          var or__3548__auto____5324 = G__5322__5323.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5324) {
            return or__3548__auto____5324
          }else {
            return G__5322__5323.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5322__5323.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5322__5323)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5322__5323)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5325__5326 = coll;
      if(G__5325__5326 != null) {
        if(function() {
          var or__3548__auto____5327 = G__5325__5326.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5327) {
            return or__3548__auto____5327
          }else {
            return G__5325__5326.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5325__5326.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5325__5326)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5325__5326)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5328 = this;
  return this__5328.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5329__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5329 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5329__delegate.call(this, x, y, more)
    };
    G__5329.cljs$lang$maxFixedArity = 2;
    G__5329.cljs$lang$applyTo = function(arglist__5330) {
      var x = cljs.core.first(arglist__5330);
      var y = cljs.core.first(cljs.core.next(arglist__5330));
      var more = cljs.core.rest(cljs.core.next(arglist__5330));
      return G__5329__delegate(x, y, more)
    };
    G__5329.cljs$lang$arity$variadic = G__5329__delegate;
    return G__5329
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5331__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5331 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5331__delegate.call(this, x, y, more)
    };
    G__5331.cljs$lang$maxFixedArity = 2;
    G__5331.cljs$lang$applyTo = function(arglist__5332) {
      var x = cljs.core.first(arglist__5332);
      var y = cljs.core.first(cljs.core.next(arglist__5332));
      var more = cljs.core.rest(cljs.core.next(arglist__5332));
      return G__5331__delegate(x, y, more)
    };
    G__5331.cljs$lang$arity$variadic = G__5331__delegate;
    return G__5331
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5333__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5333 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5333__delegate.call(this, x, y, more)
    };
    G__5333.cljs$lang$maxFixedArity = 2;
    G__5333.cljs$lang$applyTo = function(arglist__5334) {
      var x = cljs.core.first(arglist__5334);
      var y = cljs.core.first(cljs.core.next(arglist__5334));
      var more = cljs.core.rest(cljs.core.next(arglist__5334));
      return G__5333__delegate(x, y, more)
    };
    G__5333.cljs$lang$arity$variadic = G__5333__delegate;
    return G__5333
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5335__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5335 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5335__delegate.call(this, x, y, more)
    };
    G__5335.cljs$lang$maxFixedArity = 2;
    G__5335.cljs$lang$applyTo = function(arglist__5336) {
      var x = cljs.core.first(arglist__5336);
      var y = cljs.core.first(cljs.core.next(arglist__5336));
      var more = cljs.core.rest(cljs.core.next(arglist__5336));
      return G__5335__delegate(x, y, more)
    };
    G__5335.cljs$lang$arity$variadic = G__5335__delegate;
    return G__5335
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5337__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5338 = y;
            var G__5339 = cljs.core.first.call(null, more);
            var G__5340 = cljs.core.next.call(null, more);
            x = G__5338;
            y = G__5339;
            more = G__5340;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5337 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5337__delegate.call(this, x, y, more)
    };
    G__5337.cljs$lang$maxFixedArity = 2;
    G__5337.cljs$lang$applyTo = function(arglist__5341) {
      var x = cljs.core.first(arglist__5341);
      var y = cljs.core.first(cljs.core.next(arglist__5341));
      var more = cljs.core.rest(cljs.core.next(arglist__5341));
      return G__5337__delegate(x, y, more)
    };
    G__5337.cljs$lang$arity$variadic = G__5337__delegate;
    return G__5337
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5342__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5343 = y;
            var G__5344 = cljs.core.first.call(null, more);
            var G__5345 = cljs.core.next.call(null, more);
            x = G__5343;
            y = G__5344;
            more = G__5345;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5342 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5342__delegate.call(this, x, y, more)
    };
    G__5342.cljs$lang$maxFixedArity = 2;
    G__5342.cljs$lang$applyTo = function(arglist__5346) {
      var x = cljs.core.first(arglist__5346);
      var y = cljs.core.first(cljs.core.next(arglist__5346));
      var more = cljs.core.rest(cljs.core.next(arglist__5346));
      return G__5342__delegate(x, y, more)
    };
    G__5342.cljs$lang$arity$variadic = G__5342__delegate;
    return G__5342
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5347__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5348 = y;
            var G__5349 = cljs.core.first.call(null, more);
            var G__5350 = cljs.core.next.call(null, more);
            x = G__5348;
            y = G__5349;
            more = G__5350;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5347 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5347__delegate.call(this, x, y, more)
    };
    G__5347.cljs$lang$maxFixedArity = 2;
    G__5347.cljs$lang$applyTo = function(arglist__5351) {
      var x = cljs.core.first(arglist__5351);
      var y = cljs.core.first(cljs.core.next(arglist__5351));
      var more = cljs.core.rest(cljs.core.next(arglist__5351));
      return G__5347__delegate(x, y, more)
    };
    G__5347.cljs$lang$arity$variadic = G__5347__delegate;
    return G__5347
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5352__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5353 = y;
            var G__5354 = cljs.core.first.call(null, more);
            var G__5355 = cljs.core.next.call(null, more);
            x = G__5353;
            y = G__5354;
            more = G__5355;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5352 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5352__delegate.call(this, x, y, more)
    };
    G__5352.cljs$lang$maxFixedArity = 2;
    G__5352.cljs$lang$applyTo = function(arglist__5356) {
      var x = cljs.core.first(arglist__5356);
      var y = cljs.core.first(cljs.core.next(arglist__5356));
      var more = cljs.core.rest(cljs.core.next(arglist__5356));
      return G__5352__delegate(x, y, more)
    };
    G__5352.cljs$lang$arity$variadic = G__5352__delegate;
    return G__5352
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5357__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5357 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5357__delegate.call(this, x, y, more)
    };
    G__5357.cljs$lang$maxFixedArity = 2;
    G__5357.cljs$lang$applyTo = function(arglist__5358) {
      var x = cljs.core.first(arglist__5358);
      var y = cljs.core.first(cljs.core.next(arglist__5358));
      var more = cljs.core.rest(cljs.core.next(arglist__5358));
      return G__5357__delegate(x, y, more)
    };
    G__5357.cljs$lang$arity$variadic = G__5357__delegate;
    return G__5357
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5359__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5359 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5359__delegate.call(this, x, y, more)
    };
    G__5359.cljs$lang$maxFixedArity = 2;
    G__5359.cljs$lang$applyTo = function(arglist__5360) {
      var x = cljs.core.first(arglist__5360);
      var y = cljs.core.first(cljs.core.next(arglist__5360));
      var more = cljs.core.rest(cljs.core.next(arglist__5360));
      return G__5359__delegate(x, y, more)
    };
    G__5359.cljs$lang$arity$variadic = G__5359__delegate;
    return G__5359
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5361 = n % d;
  return cljs.core.fix.call(null, (n - rem__5361) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5362 = cljs.core.quot.call(null, n, d);
  return n - d * q__5362
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5363 = 0;
  var n__5364 = n;
  while(true) {
    if(n__5364 === 0) {
      return c__5363
    }else {
      var G__5365 = c__5363 + 1;
      var G__5366 = n__5364 & n__5364 - 1;
      c__5363 = G__5365;
      n__5364 = G__5366;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5367__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5368 = y;
            var G__5369 = cljs.core.first.call(null, more);
            var G__5370 = cljs.core.next.call(null, more);
            x = G__5368;
            y = G__5369;
            more = G__5370;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5367 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5367__delegate.call(this, x, y, more)
    };
    G__5367.cljs$lang$maxFixedArity = 2;
    G__5367.cljs$lang$applyTo = function(arglist__5371) {
      var x = cljs.core.first(arglist__5371);
      var y = cljs.core.first(cljs.core.next(arglist__5371));
      var more = cljs.core.rest(cljs.core.next(arglist__5371));
      return G__5367__delegate(x, y, more)
    };
    G__5367.cljs$lang$arity$variadic = G__5367__delegate;
    return G__5367
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5372 = n;
  var xs__5373 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5374 = xs__5373;
      if(cljs.core.truth_(and__3546__auto____5374)) {
        return n__5372 > 0
      }else {
        return and__3546__auto____5374
      }
    }())) {
      var G__5375 = n__5372 - 1;
      var G__5376 = cljs.core.next.call(null, xs__5373);
      n__5372 = G__5375;
      xs__5373 = G__5376;
      continue
    }else {
      return xs__5373
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5377__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5378 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5379 = cljs.core.next.call(null, more);
            sb = G__5378;
            more = G__5379;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5377 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5377__delegate.call(this, x, ys)
    };
    G__5377.cljs$lang$maxFixedArity = 1;
    G__5377.cljs$lang$applyTo = function(arglist__5380) {
      var x = cljs.core.first(arglist__5380);
      var ys = cljs.core.rest(arglist__5380);
      return G__5377__delegate(x, ys)
    };
    G__5377.cljs$lang$arity$variadic = G__5377__delegate;
    return G__5377
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5381__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5382 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5383 = cljs.core.next.call(null, more);
            sb = G__5382;
            more = G__5383;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5381 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5381__delegate.call(this, x, ys)
    };
    G__5381.cljs$lang$maxFixedArity = 1;
    G__5381.cljs$lang$applyTo = function(arglist__5384) {
      var x = cljs.core.first(arglist__5384);
      var ys = cljs.core.rest(arglist__5384);
      return G__5381__delegate(x, ys)
    };
    G__5381.cljs$lang$arity$variadic = G__5381__delegate;
    return G__5381
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5385 = cljs.core.seq.call(null, x);
    var ys__5386 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5385 == null) {
        return ys__5386 == null
      }else {
        if(ys__5386 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5385), cljs.core.first.call(null, ys__5386))) {
            var G__5387 = cljs.core.next.call(null, xs__5385);
            var G__5388 = cljs.core.next.call(null, ys__5386);
            xs__5385 = G__5387;
            ys__5386 = G__5388;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5389_SHARP_, p2__5390_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5389_SHARP_, cljs.core.hash.call(null, p2__5390_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5391 = 0;
  var s__5392 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5392)) {
      var e__5393 = cljs.core.first.call(null, s__5392);
      var G__5394 = (h__5391 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5393)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5393)))) % 4503599627370496;
      var G__5395 = cljs.core.next.call(null, s__5392);
      h__5391 = G__5394;
      s__5392 = G__5395;
      continue
    }else {
      return h__5391
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5396 = 0;
  var s__5397 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5397)) {
      var e__5398 = cljs.core.first.call(null, s__5397);
      var G__5399 = (h__5396 + cljs.core.hash.call(null, e__5398)) % 4503599627370496;
      var G__5400 = cljs.core.next.call(null, s__5397);
      h__5396 = G__5399;
      s__5397 = G__5400;
      continue
    }else {
      return h__5396
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5401__5402 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5401__5402)) {
    var G__5404__5406 = cljs.core.first.call(null, G__5401__5402);
    var vec__5405__5407 = G__5404__5406;
    var key_name__5408 = cljs.core.nth.call(null, vec__5405__5407, 0, null);
    var f__5409 = cljs.core.nth.call(null, vec__5405__5407, 1, null);
    var G__5401__5410 = G__5401__5402;
    var G__5404__5411 = G__5404__5406;
    var G__5401__5412 = G__5401__5410;
    while(true) {
      var vec__5413__5414 = G__5404__5411;
      var key_name__5415 = cljs.core.nth.call(null, vec__5413__5414, 0, null);
      var f__5416 = cljs.core.nth.call(null, vec__5413__5414, 1, null);
      var G__5401__5417 = G__5401__5412;
      var str_name__5418 = cljs.core.name.call(null, key_name__5415);
      obj[str_name__5418] = f__5416;
      var temp__3698__auto____5419 = cljs.core.next.call(null, G__5401__5417);
      if(cljs.core.truth_(temp__3698__auto____5419)) {
        var G__5401__5420 = temp__3698__auto____5419;
        var G__5421 = cljs.core.first.call(null, G__5401__5420);
        var G__5422 = G__5401__5420;
        G__5404__5411 = G__5421;
        G__5401__5412 = G__5422;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5423 = this;
  var h__364__auto____5424 = this__5423.__hash;
  if(h__364__auto____5424 != null) {
    return h__364__auto____5424
  }else {
    var h__364__auto____5425 = cljs.core.hash_coll.call(null, coll);
    this__5423.__hash = h__364__auto____5425;
    return h__364__auto____5425
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5426 = this;
  return new cljs.core.List(this__5426.meta, o, coll, this__5426.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5427 = this;
  var this$__5428 = this;
  return cljs.core.pr_str.call(null, this$__5428)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5429 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5430 = this;
  return this__5430.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5431 = this;
  return this__5431.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5432 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5433 = this;
  return this__5433.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5434 = this;
  return this__5434.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5435 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5436 = this;
  return new cljs.core.List(meta, this__5436.first, this__5436.rest, this__5436.count, this__5436.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5437 = this;
  return this__5437.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5438 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5439 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5440 = this;
  return new cljs.core.List(this__5440.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5441 = this;
  var this$__5442 = this;
  return cljs.core.pr_str.call(null, this$__5442)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5443 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5444 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5445 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5446 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5447 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5448 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5449 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5450 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5451 = this;
  return this__5451.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5452 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5453__5454 = coll;
  if(G__5453__5454 != null) {
    if(function() {
      var or__3548__auto____5455 = G__5453__5454.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5455) {
        return or__3548__auto____5455
      }else {
        return G__5453__5454.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5453__5454.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5453__5454)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5453__5454)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5456) {
    var items = cljs.core.seq(arglist__5456);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5457 = this;
  var h__364__auto____5458 = this__5457.__hash;
  if(h__364__auto____5458 != null) {
    return h__364__auto____5458
  }else {
    var h__364__auto____5459 = cljs.core.hash_coll.call(null, coll);
    this__5457.__hash = h__364__auto____5459;
    return h__364__auto____5459
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5460 = this;
  return new cljs.core.Cons(null, o, coll, this__5460.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5461 = this;
  var this$__5462 = this;
  return cljs.core.pr_str.call(null, this$__5462)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5463 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5464 = this;
  return this__5464.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5465 = this;
  if(this__5465.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5465.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5466 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5467 = this;
  return new cljs.core.Cons(meta, this__5467.first, this__5467.rest, this__5467.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5468 = this;
  return this__5468.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5469 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5469.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5470 = coll == null;
    if(or__3548__auto____5470) {
      return or__3548__auto____5470
    }else {
      var G__5471__5472 = coll;
      if(G__5471__5472 != null) {
        if(function() {
          var or__3548__auto____5473 = G__5471__5472.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5473) {
            return or__3548__auto____5473
          }else {
            return G__5471__5472.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5471__5472.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5471__5472)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5471__5472)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5474__5475 = x;
  if(G__5474__5475 != null) {
    if(function() {
      var or__3548__auto____5476 = G__5474__5475.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5476) {
        return or__3548__auto____5476
      }else {
        return G__5474__5475.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5474__5475.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5474__5475)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5474__5475)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5477 = null;
  var G__5477__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5477__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5477 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5477__2.call(this, string, f);
      case 3:
        return G__5477__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5477
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5478 = null;
  var G__5478__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5478__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5478 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5478__2.call(this, string, k);
      case 3:
        return G__5478__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5478
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5479 = null;
  var G__5479__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5479__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5479 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5479__2.call(this, string, n);
      case 3:
        return G__5479__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5479
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5488 = null;
  var G__5488__2 = function(tsym5482, coll) {
    var tsym5482__5484 = this;
    var this$__5485 = tsym5482__5484;
    return cljs.core.get.call(null, coll, this$__5485.toString())
  };
  var G__5488__3 = function(tsym5483, coll, not_found) {
    var tsym5483__5486 = this;
    var this$__5487 = tsym5483__5486;
    return cljs.core.get.call(null, coll, this$__5487.toString(), not_found)
  };
  G__5488 = function(tsym5483, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5488__2.call(this, tsym5483, coll);
      case 3:
        return G__5488__3.call(this, tsym5483, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5488
}();
String.prototype.apply = function(tsym5480, args5481) {
  return tsym5480.call.apply(tsym5480, [tsym5480].concat(cljs.core.aclone.call(null, args5481)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5489 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5489
  }else {
    lazy_seq.x = x__5489.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5490 = this;
  var h__364__auto____5491 = this__5490.__hash;
  if(h__364__auto____5491 != null) {
    return h__364__auto____5491
  }else {
    var h__364__auto____5492 = cljs.core.hash_coll.call(null, coll);
    this__5490.__hash = h__364__auto____5492;
    return h__364__auto____5492
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5493 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5494 = this;
  var this$__5495 = this;
  return cljs.core.pr_str.call(null, this$__5495)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5496 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5497 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5498 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5499 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5500 = this;
  return new cljs.core.LazySeq(meta, this__5500.realized, this__5500.x, this__5500.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5501 = this;
  return this__5501.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5502 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5502.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5503 = [];
  var s__5504 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5504))) {
      ary__5503.push(cljs.core.first.call(null, s__5504));
      var G__5505 = cljs.core.next.call(null, s__5504);
      s__5504 = G__5505;
      continue
    }else {
      return ary__5503
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5506 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5507 = 0;
  var xs__5508 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5508)) {
      ret__5506[i__5507] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5508));
      var G__5509 = i__5507 + 1;
      var G__5510 = cljs.core.next.call(null, xs__5508);
      i__5507 = G__5509;
      xs__5508 = G__5510;
      continue
    }else {
    }
    break
  }
  return ret__5506
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5511 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5512 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5513 = 0;
      var s__5514 = s__5512;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5515 = s__5514;
          if(cljs.core.truth_(and__3546__auto____5515)) {
            return i__5513 < size
          }else {
            return and__3546__auto____5515
          }
        }())) {
          a__5511[i__5513] = cljs.core.first.call(null, s__5514);
          var G__5518 = i__5513 + 1;
          var G__5519 = cljs.core.next.call(null, s__5514);
          i__5513 = G__5518;
          s__5514 = G__5519;
          continue
        }else {
          return a__5511
        }
        break
      }
    }else {
      var n__685__auto____5516 = size;
      var i__5517 = 0;
      while(true) {
        if(i__5517 < n__685__auto____5516) {
          a__5511[i__5517] = init_val_or_seq;
          var G__5520 = i__5517 + 1;
          i__5517 = G__5520;
          continue
        }else {
        }
        break
      }
      return a__5511
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5521 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5522 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5523 = 0;
      var s__5524 = s__5522;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5525 = s__5524;
          if(cljs.core.truth_(and__3546__auto____5525)) {
            return i__5523 < size
          }else {
            return and__3546__auto____5525
          }
        }())) {
          a__5521[i__5523] = cljs.core.first.call(null, s__5524);
          var G__5528 = i__5523 + 1;
          var G__5529 = cljs.core.next.call(null, s__5524);
          i__5523 = G__5528;
          s__5524 = G__5529;
          continue
        }else {
          return a__5521
        }
        break
      }
    }else {
      var n__685__auto____5526 = size;
      var i__5527 = 0;
      while(true) {
        if(i__5527 < n__685__auto____5526) {
          a__5521[i__5527] = init_val_or_seq;
          var G__5530 = i__5527 + 1;
          i__5527 = G__5530;
          continue
        }else {
        }
        break
      }
      return a__5521
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5531 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5532 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5533 = 0;
      var s__5534 = s__5532;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5535 = s__5534;
          if(cljs.core.truth_(and__3546__auto____5535)) {
            return i__5533 < size
          }else {
            return and__3546__auto____5535
          }
        }())) {
          a__5531[i__5533] = cljs.core.first.call(null, s__5534);
          var G__5538 = i__5533 + 1;
          var G__5539 = cljs.core.next.call(null, s__5534);
          i__5533 = G__5538;
          s__5534 = G__5539;
          continue
        }else {
          return a__5531
        }
        break
      }
    }else {
      var n__685__auto____5536 = size;
      var i__5537 = 0;
      while(true) {
        if(i__5537 < n__685__auto____5536) {
          a__5531[i__5537] = init_val_or_seq;
          var G__5540 = i__5537 + 1;
          i__5537 = G__5540;
          continue
        }else {
        }
        break
      }
      return a__5531
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5541 = s;
    var i__5542 = n;
    var sum__5543 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5544 = i__5542 > 0;
        if(and__3546__auto____5544) {
          return cljs.core.seq.call(null, s__5541)
        }else {
          return and__3546__auto____5544
        }
      }())) {
        var G__5545 = cljs.core.next.call(null, s__5541);
        var G__5546 = i__5542 - 1;
        var G__5547 = sum__5543 + 1;
        s__5541 = G__5545;
        i__5542 = G__5546;
        sum__5543 = G__5547;
        continue
      }else {
        return sum__5543
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5548 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5548)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5548), concat.call(null, cljs.core.rest.call(null, s__5548), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5551__delegate = function(x, y, zs) {
      var cat__5550 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5549 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5549)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5549), cat.call(null, cljs.core.rest.call(null, xys__5549), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5550.call(null, concat.call(null, x, y), zs)
    };
    var G__5551 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5551__delegate.call(this, x, y, zs)
    };
    G__5551.cljs$lang$maxFixedArity = 2;
    G__5551.cljs$lang$applyTo = function(arglist__5552) {
      var x = cljs.core.first(arglist__5552);
      var y = cljs.core.first(cljs.core.next(arglist__5552));
      var zs = cljs.core.rest(cljs.core.next(arglist__5552));
      return G__5551__delegate(x, y, zs)
    };
    G__5551.cljs$lang$arity$variadic = G__5551__delegate;
    return G__5551
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5553__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5553 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5553__delegate.call(this, a, b, c, d, more)
    };
    G__5553.cljs$lang$maxFixedArity = 4;
    G__5553.cljs$lang$applyTo = function(arglist__5554) {
      var a = cljs.core.first(arglist__5554);
      var b = cljs.core.first(cljs.core.next(arglist__5554));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5554)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5554))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5554))));
      return G__5553__delegate(a, b, c, d, more)
    };
    G__5553.cljs$lang$arity$variadic = G__5553__delegate;
    return G__5553
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5555 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5556 = cljs.core._first.call(null, args__5555);
    var args__5557 = cljs.core._rest.call(null, args__5555);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5556)
      }else {
        return f.call(null, a__5556)
      }
    }else {
      var b__5558 = cljs.core._first.call(null, args__5557);
      var args__5559 = cljs.core._rest.call(null, args__5557);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5556, b__5558)
        }else {
          return f.call(null, a__5556, b__5558)
        }
      }else {
        var c__5560 = cljs.core._first.call(null, args__5559);
        var args__5561 = cljs.core._rest.call(null, args__5559);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5556, b__5558, c__5560)
          }else {
            return f.call(null, a__5556, b__5558, c__5560)
          }
        }else {
          var d__5562 = cljs.core._first.call(null, args__5561);
          var args__5563 = cljs.core._rest.call(null, args__5561);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5556, b__5558, c__5560, d__5562)
            }else {
              return f.call(null, a__5556, b__5558, c__5560, d__5562)
            }
          }else {
            var e__5564 = cljs.core._first.call(null, args__5563);
            var args__5565 = cljs.core._rest.call(null, args__5563);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5556, b__5558, c__5560, d__5562, e__5564)
              }else {
                return f.call(null, a__5556, b__5558, c__5560, d__5562, e__5564)
              }
            }else {
              var f__5566 = cljs.core._first.call(null, args__5565);
              var args__5567 = cljs.core._rest.call(null, args__5565);
              if(argc === 6) {
                if(f__5566.cljs$lang$arity$6) {
                  return f__5566.cljs$lang$arity$6(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566)
                }else {
                  return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566)
                }
              }else {
                var g__5568 = cljs.core._first.call(null, args__5567);
                var args__5569 = cljs.core._rest.call(null, args__5567);
                if(argc === 7) {
                  if(f__5566.cljs$lang$arity$7) {
                    return f__5566.cljs$lang$arity$7(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568)
                  }else {
                    return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568)
                  }
                }else {
                  var h__5570 = cljs.core._first.call(null, args__5569);
                  var args__5571 = cljs.core._rest.call(null, args__5569);
                  if(argc === 8) {
                    if(f__5566.cljs$lang$arity$8) {
                      return f__5566.cljs$lang$arity$8(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570)
                    }else {
                      return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570)
                    }
                  }else {
                    var i__5572 = cljs.core._first.call(null, args__5571);
                    var args__5573 = cljs.core._rest.call(null, args__5571);
                    if(argc === 9) {
                      if(f__5566.cljs$lang$arity$9) {
                        return f__5566.cljs$lang$arity$9(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572)
                      }else {
                        return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572)
                      }
                    }else {
                      var j__5574 = cljs.core._first.call(null, args__5573);
                      var args__5575 = cljs.core._rest.call(null, args__5573);
                      if(argc === 10) {
                        if(f__5566.cljs$lang$arity$10) {
                          return f__5566.cljs$lang$arity$10(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574)
                        }else {
                          return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574)
                        }
                      }else {
                        var k__5576 = cljs.core._first.call(null, args__5575);
                        var args__5577 = cljs.core._rest.call(null, args__5575);
                        if(argc === 11) {
                          if(f__5566.cljs$lang$arity$11) {
                            return f__5566.cljs$lang$arity$11(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576)
                          }else {
                            return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576)
                          }
                        }else {
                          var l__5578 = cljs.core._first.call(null, args__5577);
                          var args__5579 = cljs.core._rest.call(null, args__5577);
                          if(argc === 12) {
                            if(f__5566.cljs$lang$arity$12) {
                              return f__5566.cljs$lang$arity$12(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578)
                            }else {
                              return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578)
                            }
                          }else {
                            var m__5580 = cljs.core._first.call(null, args__5579);
                            var args__5581 = cljs.core._rest.call(null, args__5579);
                            if(argc === 13) {
                              if(f__5566.cljs$lang$arity$13) {
                                return f__5566.cljs$lang$arity$13(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580)
                              }else {
                                return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580)
                              }
                            }else {
                              var n__5582 = cljs.core._first.call(null, args__5581);
                              var args__5583 = cljs.core._rest.call(null, args__5581);
                              if(argc === 14) {
                                if(f__5566.cljs$lang$arity$14) {
                                  return f__5566.cljs$lang$arity$14(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582)
                                }else {
                                  return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582)
                                }
                              }else {
                                var o__5584 = cljs.core._first.call(null, args__5583);
                                var args__5585 = cljs.core._rest.call(null, args__5583);
                                if(argc === 15) {
                                  if(f__5566.cljs$lang$arity$15) {
                                    return f__5566.cljs$lang$arity$15(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584)
                                  }else {
                                    return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584)
                                  }
                                }else {
                                  var p__5586 = cljs.core._first.call(null, args__5585);
                                  var args__5587 = cljs.core._rest.call(null, args__5585);
                                  if(argc === 16) {
                                    if(f__5566.cljs$lang$arity$16) {
                                      return f__5566.cljs$lang$arity$16(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586)
                                    }else {
                                      return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586)
                                    }
                                  }else {
                                    var q__5588 = cljs.core._first.call(null, args__5587);
                                    var args__5589 = cljs.core._rest.call(null, args__5587);
                                    if(argc === 17) {
                                      if(f__5566.cljs$lang$arity$17) {
                                        return f__5566.cljs$lang$arity$17(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588)
                                      }else {
                                        return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588)
                                      }
                                    }else {
                                      var r__5590 = cljs.core._first.call(null, args__5589);
                                      var args__5591 = cljs.core._rest.call(null, args__5589);
                                      if(argc === 18) {
                                        if(f__5566.cljs$lang$arity$18) {
                                          return f__5566.cljs$lang$arity$18(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588, r__5590)
                                        }else {
                                          return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588, r__5590)
                                        }
                                      }else {
                                        var s__5592 = cljs.core._first.call(null, args__5591);
                                        var args__5593 = cljs.core._rest.call(null, args__5591);
                                        if(argc === 19) {
                                          if(f__5566.cljs$lang$arity$19) {
                                            return f__5566.cljs$lang$arity$19(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588, r__5590, s__5592)
                                          }else {
                                            return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588, r__5590, s__5592)
                                          }
                                        }else {
                                          var t__5594 = cljs.core._first.call(null, args__5593);
                                          var args__5595 = cljs.core._rest.call(null, args__5593);
                                          if(argc === 20) {
                                            if(f__5566.cljs$lang$arity$20) {
                                              return f__5566.cljs$lang$arity$20(a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588, r__5590, s__5592, t__5594)
                                            }else {
                                              return f__5566.call(null, a__5556, b__5558, c__5560, d__5562, e__5564, f__5566, g__5568, h__5570, i__5572, j__5574, k__5576, l__5578, m__5580, n__5582, o__5584, p__5586, q__5588, r__5590, s__5592, t__5594)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5596 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5597 = cljs.core.bounded_count.call(null, args, fixed_arity__5596 + 1);
      if(bc__5597 <= fixed_arity__5596) {
        return cljs.core.apply_to.call(null, f, bc__5597, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5598 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5599 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5600 = cljs.core.bounded_count.call(null, arglist__5598, fixed_arity__5599 + 1);
      if(bc__5600 <= fixed_arity__5599) {
        return cljs.core.apply_to.call(null, f, bc__5600, arglist__5598)
      }else {
        return f.cljs$lang$applyTo(arglist__5598)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5598))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5601 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5602 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5603 = cljs.core.bounded_count.call(null, arglist__5601, fixed_arity__5602 + 1);
      if(bc__5603 <= fixed_arity__5602) {
        return cljs.core.apply_to.call(null, f, bc__5603, arglist__5601)
      }else {
        return f.cljs$lang$applyTo(arglist__5601)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5601))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5604 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5605 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5606 = cljs.core.bounded_count.call(null, arglist__5604, fixed_arity__5605 + 1);
      if(bc__5606 <= fixed_arity__5605) {
        return cljs.core.apply_to.call(null, f, bc__5606, arglist__5604)
      }else {
        return f.cljs$lang$applyTo(arglist__5604)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5604))
    }
  };
  var apply__6 = function() {
    var G__5610__delegate = function(f, a, b, c, d, args) {
      var arglist__5607 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5608 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5609 = cljs.core.bounded_count.call(null, arglist__5607, fixed_arity__5608 + 1);
        if(bc__5609 <= fixed_arity__5608) {
          return cljs.core.apply_to.call(null, f, bc__5609, arglist__5607)
        }else {
          return f.cljs$lang$applyTo(arglist__5607)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5607))
      }
    };
    var G__5610 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5610__delegate.call(this, f, a, b, c, d, args)
    };
    G__5610.cljs$lang$maxFixedArity = 5;
    G__5610.cljs$lang$applyTo = function(arglist__5611) {
      var f = cljs.core.first(arglist__5611);
      var a = cljs.core.first(cljs.core.next(arglist__5611));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5611)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5611))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5611)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5611)))));
      return G__5610__delegate(f, a, b, c, d, args)
    };
    G__5610.cljs$lang$arity$variadic = G__5610__delegate;
    return G__5610
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5612) {
    var obj = cljs.core.first(arglist__5612);
    var f = cljs.core.first(cljs.core.next(arglist__5612));
    var args = cljs.core.rest(cljs.core.next(arglist__5612));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5613__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5613 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5613__delegate.call(this, x, y, more)
    };
    G__5613.cljs$lang$maxFixedArity = 2;
    G__5613.cljs$lang$applyTo = function(arglist__5614) {
      var x = cljs.core.first(arglist__5614);
      var y = cljs.core.first(cljs.core.next(arglist__5614));
      var more = cljs.core.rest(cljs.core.next(arglist__5614));
      return G__5613__delegate(x, y, more)
    };
    G__5613.cljs$lang$arity$variadic = G__5613__delegate;
    return G__5613
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5615 = pred;
        var G__5616 = cljs.core.next.call(null, coll);
        pred = G__5615;
        coll = G__5616;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5617 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5617)) {
        return or__3548__auto____5617
      }else {
        var G__5618 = pred;
        var G__5619 = cljs.core.next.call(null, coll);
        pred = G__5618;
        coll = G__5619;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5620 = null;
    var G__5620__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5620__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5620__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5620__3 = function() {
      var G__5621__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5621 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5621__delegate.call(this, x, y, zs)
      };
      G__5621.cljs$lang$maxFixedArity = 2;
      G__5621.cljs$lang$applyTo = function(arglist__5622) {
        var x = cljs.core.first(arglist__5622);
        var y = cljs.core.first(cljs.core.next(arglist__5622));
        var zs = cljs.core.rest(cljs.core.next(arglist__5622));
        return G__5621__delegate(x, y, zs)
      };
      G__5621.cljs$lang$arity$variadic = G__5621__delegate;
      return G__5621
    }();
    G__5620 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5620__0.call(this);
        case 1:
          return G__5620__1.call(this, x);
        case 2:
          return G__5620__2.call(this, x, y);
        default:
          return G__5620__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5620.cljs$lang$maxFixedArity = 2;
    G__5620.cljs$lang$applyTo = G__5620__3.cljs$lang$applyTo;
    return G__5620
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5623__delegate = function(args) {
      return x
    };
    var G__5623 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5623__delegate.call(this, args)
    };
    G__5623.cljs$lang$maxFixedArity = 0;
    G__5623.cljs$lang$applyTo = function(arglist__5624) {
      var args = cljs.core.seq(arglist__5624);
      return G__5623__delegate(args)
    };
    G__5623.cljs$lang$arity$variadic = G__5623__delegate;
    return G__5623
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5628 = null;
      var G__5628__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5628__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5628__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5628__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5628__4 = function() {
        var G__5629__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5629 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5629__delegate.call(this, x, y, z, args)
        };
        G__5629.cljs$lang$maxFixedArity = 3;
        G__5629.cljs$lang$applyTo = function(arglist__5630) {
          var x = cljs.core.first(arglist__5630);
          var y = cljs.core.first(cljs.core.next(arglist__5630));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5630)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5630)));
          return G__5629__delegate(x, y, z, args)
        };
        G__5629.cljs$lang$arity$variadic = G__5629__delegate;
        return G__5629
      }();
      G__5628 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5628__0.call(this);
          case 1:
            return G__5628__1.call(this, x);
          case 2:
            return G__5628__2.call(this, x, y);
          case 3:
            return G__5628__3.call(this, x, y, z);
          default:
            return G__5628__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5628.cljs$lang$maxFixedArity = 3;
      G__5628.cljs$lang$applyTo = G__5628__4.cljs$lang$applyTo;
      return G__5628
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5631 = null;
      var G__5631__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5631__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5631__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5631__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5631__4 = function() {
        var G__5632__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5632 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5632__delegate.call(this, x, y, z, args)
        };
        G__5632.cljs$lang$maxFixedArity = 3;
        G__5632.cljs$lang$applyTo = function(arglist__5633) {
          var x = cljs.core.first(arglist__5633);
          var y = cljs.core.first(cljs.core.next(arglist__5633));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5633)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5633)));
          return G__5632__delegate(x, y, z, args)
        };
        G__5632.cljs$lang$arity$variadic = G__5632__delegate;
        return G__5632
      }();
      G__5631 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5631__0.call(this);
          case 1:
            return G__5631__1.call(this, x);
          case 2:
            return G__5631__2.call(this, x, y);
          case 3:
            return G__5631__3.call(this, x, y, z);
          default:
            return G__5631__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5631.cljs$lang$maxFixedArity = 3;
      G__5631.cljs$lang$applyTo = G__5631__4.cljs$lang$applyTo;
      return G__5631
    }()
  };
  var comp__4 = function() {
    var G__5634__delegate = function(f1, f2, f3, fs) {
      var fs__5625 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5635__delegate = function(args) {
          var ret__5626 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5625), args);
          var fs__5627 = cljs.core.next.call(null, fs__5625);
          while(true) {
            if(cljs.core.truth_(fs__5627)) {
              var G__5636 = cljs.core.first.call(null, fs__5627).call(null, ret__5626);
              var G__5637 = cljs.core.next.call(null, fs__5627);
              ret__5626 = G__5636;
              fs__5627 = G__5637;
              continue
            }else {
              return ret__5626
            }
            break
          }
        };
        var G__5635 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5635__delegate.call(this, args)
        };
        G__5635.cljs$lang$maxFixedArity = 0;
        G__5635.cljs$lang$applyTo = function(arglist__5638) {
          var args = cljs.core.seq(arglist__5638);
          return G__5635__delegate(args)
        };
        G__5635.cljs$lang$arity$variadic = G__5635__delegate;
        return G__5635
      }()
    };
    var G__5634 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5634__delegate.call(this, f1, f2, f3, fs)
    };
    G__5634.cljs$lang$maxFixedArity = 3;
    G__5634.cljs$lang$applyTo = function(arglist__5639) {
      var f1 = cljs.core.first(arglist__5639);
      var f2 = cljs.core.first(cljs.core.next(arglist__5639));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5639)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5639)));
      return G__5634__delegate(f1, f2, f3, fs)
    };
    G__5634.cljs$lang$arity$variadic = G__5634__delegate;
    return G__5634
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5640__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5640 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5640__delegate.call(this, args)
      };
      G__5640.cljs$lang$maxFixedArity = 0;
      G__5640.cljs$lang$applyTo = function(arglist__5641) {
        var args = cljs.core.seq(arglist__5641);
        return G__5640__delegate(args)
      };
      G__5640.cljs$lang$arity$variadic = G__5640__delegate;
      return G__5640
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5642__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5642 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5642__delegate.call(this, args)
      };
      G__5642.cljs$lang$maxFixedArity = 0;
      G__5642.cljs$lang$applyTo = function(arglist__5643) {
        var args = cljs.core.seq(arglist__5643);
        return G__5642__delegate(args)
      };
      G__5642.cljs$lang$arity$variadic = G__5642__delegate;
      return G__5642
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5644__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5644 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5644__delegate.call(this, args)
      };
      G__5644.cljs$lang$maxFixedArity = 0;
      G__5644.cljs$lang$applyTo = function(arglist__5645) {
        var args = cljs.core.seq(arglist__5645);
        return G__5644__delegate(args)
      };
      G__5644.cljs$lang$arity$variadic = G__5644__delegate;
      return G__5644
    }()
  };
  var partial__5 = function() {
    var G__5646__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5647__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5647 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5647__delegate.call(this, args)
        };
        G__5647.cljs$lang$maxFixedArity = 0;
        G__5647.cljs$lang$applyTo = function(arglist__5648) {
          var args = cljs.core.seq(arglist__5648);
          return G__5647__delegate(args)
        };
        G__5647.cljs$lang$arity$variadic = G__5647__delegate;
        return G__5647
      }()
    };
    var G__5646 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5646__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5646.cljs$lang$maxFixedArity = 4;
    G__5646.cljs$lang$applyTo = function(arglist__5649) {
      var f = cljs.core.first(arglist__5649);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5649));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5649)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5649))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5649))));
      return G__5646__delegate(f, arg1, arg2, arg3, more)
    };
    G__5646.cljs$lang$arity$variadic = G__5646__delegate;
    return G__5646
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5650 = null;
      var G__5650__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5650__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5650__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5650__4 = function() {
        var G__5651__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5651 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5651__delegate.call(this, a, b, c, ds)
        };
        G__5651.cljs$lang$maxFixedArity = 3;
        G__5651.cljs$lang$applyTo = function(arglist__5652) {
          var a = cljs.core.first(arglist__5652);
          var b = cljs.core.first(cljs.core.next(arglist__5652));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5652)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5652)));
          return G__5651__delegate(a, b, c, ds)
        };
        G__5651.cljs$lang$arity$variadic = G__5651__delegate;
        return G__5651
      }();
      G__5650 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5650__1.call(this, a);
          case 2:
            return G__5650__2.call(this, a, b);
          case 3:
            return G__5650__3.call(this, a, b, c);
          default:
            return G__5650__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5650.cljs$lang$maxFixedArity = 3;
      G__5650.cljs$lang$applyTo = G__5650__4.cljs$lang$applyTo;
      return G__5650
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5653 = null;
      var G__5653__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5653__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5653__4 = function() {
        var G__5654__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5654 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5654__delegate.call(this, a, b, c, ds)
        };
        G__5654.cljs$lang$maxFixedArity = 3;
        G__5654.cljs$lang$applyTo = function(arglist__5655) {
          var a = cljs.core.first(arglist__5655);
          var b = cljs.core.first(cljs.core.next(arglist__5655));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5655)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5655)));
          return G__5654__delegate(a, b, c, ds)
        };
        G__5654.cljs$lang$arity$variadic = G__5654__delegate;
        return G__5654
      }();
      G__5653 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5653__2.call(this, a, b);
          case 3:
            return G__5653__3.call(this, a, b, c);
          default:
            return G__5653__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5653.cljs$lang$maxFixedArity = 3;
      G__5653.cljs$lang$applyTo = G__5653__4.cljs$lang$applyTo;
      return G__5653
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5656 = null;
      var G__5656__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5656__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5656__4 = function() {
        var G__5657__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5657 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5657__delegate.call(this, a, b, c, ds)
        };
        G__5657.cljs$lang$maxFixedArity = 3;
        G__5657.cljs$lang$applyTo = function(arglist__5658) {
          var a = cljs.core.first(arglist__5658);
          var b = cljs.core.first(cljs.core.next(arglist__5658));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5658)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5658)));
          return G__5657__delegate(a, b, c, ds)
        };
        G__5657.cljs$lang$arity$variadic = G__5657__delegate;
        return G__5657
      }();
      G__5656 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5656__2.call(this, a, b);
          case 3:
            return G__5656__3.call(this, a, b, c);
          default:
            return G__5656__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5656.cljs$lang$maxFixedArity = 3;
      G__5656.cljs$lang$applyTo = G__5656__4.cljs$lang$applyTo;
      return G__5656
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5661 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5659 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5659)) {
        var s__5660 = temp__3698__auto____5659;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5660)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5660)))
      }else {
        return null
      }
    })
  };
  return mapi__5661.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5662 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5662)) {
      var s__5663 = temp__3698__auto____5662;
      var x__5664 = f.call(null, cljs.core.first.call(null, s__5663));
      if(x__5664 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5663))
      }else {
        return cljs.core.cons.call(null, x__5664, keep.call(null, f, cljs.core.rest.call(null, s__5663)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5674 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5671 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5671)) {
        var s__5672 = temp__3698__auto____5671;
        var x__5673 = f.call(null, idx, cljs.core.first.call(null, s__5672));
        if(x__5673 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5672))
        }else {
          return cljs.core.cons.call(null, x__5673, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5672)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5674.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5681 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5681)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5681
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5682 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5682)) {
            var and__3546__auto____5683 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5683)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5683
            }
          }else {
            return and__3546__auto____5682
          }
        }())
      };
      var ep1__4 = function() {
        var G__5719__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5684 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5684)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5684
            }
          }())
        };
        var G__5719 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5719__delegate.call(this, x, y, z, args)
        };
        G__5719.cljs$lang$maxFixedArity = 3;
        G__5719.cljs$lang$applyTo = function(arglist__5720) {
          var x = cljs.core.first(arglist__5720);
          var y = cljs.core.first(cljs.core.next(arglist__5720));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5720)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5720)));
          return G__5719__delegate(x, y, z, args)
        };
        G__5719.cljs$lang$arity$variadic = G__5719__delegate;
        return G__5719
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5685 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5685)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5685
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5686 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5686)) {
            var and__3546__auto____5687 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5687)) {
              var and__3546__auto____5688 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5688)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5688
              }
            }else {
              return and__3546__auto____5687
            }
          }else {
            return and__3546__auto____5686
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5689 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5689)) {
            var and__3546__auto____5690 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5690)) {
              var and__3546__auto____5691 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5691)) {
                var and__3546__auto____5692 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5692)) {
                  var and__3546__auto____5693 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5693)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5693
                  }
                }else {
                  return and__3546__auto____5692
                }
              }else {
                return and__3546__auto____5691
              }
            }else {
              return and__3546__auto____5690
            }
          }else {
            return and__3546__auto____5689
          }
        }())
      };
      var ep2__4 = function() {
        var G__5721__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5694 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5694)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5665_SHARP_) {
                var and__3546__auto____5695 = p1.call(null, p1__5665_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5695)) {
                  return p2.call(null, p1__5665_SHARP_)
                }else {
                  return and__3546__auto____5695
                }
              }, args)
            }else {
              return and__3546__auto____5694
            }
          }())
        };
        var G__5721 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5721__delegate.call(this, x, y, z, args)
        };
        G__5721.cljs$lang$maxFixedArity = 3;
        G__5721.cljs$lang$applyTo = function(arglist__5722) {
          var x = cljs.core.first(arglist__5722);
          var y = cljs.core.first(cljs.core.next(arglist__5722));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5722)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5722)));
          return G__5721__delegate(x, y, z, args)
        };
        G__5721.cljs$lang$arity$variadic = G__5721__delegate;
        return G__5721
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5696 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5696)) {
            var and__3546__auto____5697 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5697)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5697
            }
          }else {
            return and__3546__auto____5696
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5698 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5698)) {
            var and__3546__auto____5699 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5699)) {
              var and__3546__auto____5700 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5700)) {
                var and__3546__auto____5701 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5701)) {
                  var and__3546__auto____5702 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5702)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5702
                  }
                }else {
                  return and__3546__auto____5701
                }
              }else {
                return and__3546__auto____5700
              }
            }else {
              return and__3546__auto____5699
            }
          }else {
            return and__3546__auto____5698
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5703 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5703)) {
            var and__3546__auto____5704 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5704)) {
              var and__3546__auto____5705 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5705)) {
                var and__3546__auto____5706 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5706)) {
                  var and__3546__auto____5707 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5707)) {
                    var and__3546__auto____5708 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5708)) {
                      var and__3546__auto____5709 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5709)) {
                        var and__3546__auto____5710 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5710)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5710
                        }
                      }else {
                        return and__3546__auto____5709
                      }
                    }else {
                      return and__3546__auto____5708
                    }
                  }else {
                    return and__3546__auto____5707
                  }
                }else {
                  return and__3546__auto____5706
                }
              }else {
                return and__3546__auto____5705
              }
            }else {
              return and__3546__auto____5704
            }
          }else {
            return and__3546__auto____5703
          }
        }())
      };
      var ep3__4 = function() {
        var G__5723__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5711 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5711)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5666_SHARP_) {
                var and__3546__auto____5712 = p1.call(null, p1__5666_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5712)) {
                  var and__3546__auto____5713 = p2.call(null, p1__5666_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5713)) {
                    return p3.call(null, p1__5666_SHARP_)
                  }else {
                    return and__3546__auto____5713
                  }
                }else {
                  return and__3546__auto____5712
                }
              }, args)
            }else {
              return and__3546__auto____5711
            }
          }())
        };
        var G__5723 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5723__delegate.call(this, x, y, z, args)
        };
        G__5723.cljs$lang$maxFixedArity = 3;
        G__5723.cljs$lang$applyTo = function(arglist__5724) {
          var x = cljs.core.first(arglist__5724);
          var y = cljs.core.first(cljs.core.next(arglist__5724));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5724)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5724)));
          return G__5723__delegate(x, y, z, args)
        };
        G__5723.cljs$lang$arity$variadic = G__5723__delegate;
        return G__5723
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5725__delegate = function(p1, p2, p3, ps) {
      var ps__5714 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5667_SHARP_) {
            return p1__5667_SHARP_.call(null, x)
          }, ps__5714)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5668_SHARP_) {
            var and__3546__auto____5715 = p1__5668_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5715)) {
              return p1__5668_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5715
            }
          }, ps__5714)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5669_SHARP_) {
            var and__3546__auto____5716 = p1__5669_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5716)) {
              var and__3546__auto____5717 = p1__5669_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5717)) {
                return p1__5669_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5717
              }
            }else {
              return and__3546__auto____5716
            }
          }, ps__5714)
        };
        var epn__4 = function() {
          var G__5726__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5718 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5718)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5670_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5670_SHARP_, args)
                }, ps__5714)
              }else {
                return and__3546__auto____5718
              }
            }())
          };
          var G__5726 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5726__delegate.call(this, x, y, z, args)
          };
          G__5726.cljs$lang$maxFixedArity = 3;
          G__5726.cljs$lang$applyTo = function(arglist__5727) {
            var x = cljs.core.first(arglist__5727);
            var y = cljs.core.first(cljs.core.next(arglist__5727));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5727)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5727)));
            return G__5726__delegate(x, y, z, args)
          };
          G__5726.cljs$lang$arity$variadic = G__5726__delegate;
          return G__5726
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5725 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5725__delegate.call(this, p1, p2, p3, ps)
    };
    G__5725.cljs$lang$maxFixedArity = 3;
    G__5725.cljs$lang$applyTo = function(arglist__5728) {
      var p1 = cljs.core.first(arglist__5728);
      var p2 = cljs.core.first(cljs.core.next(arglist__5728));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5728)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5728)));
      return G__5725__delegate(p1, p2, p3, ps)
    };
    G__5725.cljs$lang$arity$variadic = G__5725__delegate;
    return G__5725
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5730 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5730)) {
          return or__3548__auto____5730
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5731 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5731)) {
          return or__3548__auto____5731
        }else {
          var or__3548__auto____5732 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5732)) {
            return or__3548__auto____5732
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5768__delegate = function(x, y, z, args) {
          var or__3548__auto____5733 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5733)) {
            return or__3548__auto____5733
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5768 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5768__delegate.call(this, x, y, z, args)
        };
        G__5768.cljs$lang$maxFixedArity = 3;
        G__5768.cljs$lang$applyTo = function(arglist__5769) {
          var x = cljs.core.first(arglist__5769);
          var y = cljs.core.first(cljs.core.next(arglist__5769));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5769)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5769)));
          return G__5768__delegate(x, y, z, args)
        };
        G__5768.cljs$lang$arity$variadic = G__5768__delegate;
        return G__5768
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5734 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5734)) {
          return or__3548__auto____5734
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5735 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5735)) {
          return or__3548__auto____5735
        }else {
          var or__3548__auto____5736 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5736)) {
            return or__3548__auto____5736
          }else {
            var or__3548__auto____5737 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5737)) {
              return or__3548__auto____5737
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5738 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5738)) {
          return or__3548__auto____5738
        }else {
          var or__3548__auto____5739 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5739)) {
            return or__3548__auto____5739
          }else {
            var or__3548__auto____5740 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5740)) {
              return or__3548__auto____5740
            }else {
              var or__3548__auto____5741 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5741)) {
                return or__3548__auto____5741
              }else {
                var or__3548__auto____5742 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5742)) {
                  return or__3548__auto____5742
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5770__delegate = function(x, y, z, args) {
          var or__3548__auto____5743 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5743)) {
            return or__3548__auto____5743
          }else {
            return cljs.core.some.call(null, function(p1__5675_SHARP_) {
              var or__3548__auto____5744 = p1.call(null, p1__5675_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5744)) {
                return or__3548__auto____5744
              }else {
                return p2.call(null, p1__5675_SHARP_)
              }
            }, args)
          }
        };
        var G__5770 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5770__delegate.call(this, x, y, z, args)
        };
        G__5770.cljs$lang$maxFixedArity = 3;
        G__5770.cljs$lang$applyTo = function(arglist__5771) {
          var x = cljs.core.first(arglist__5771);
          var y = cljs.core.first(cljs.core.next(arglist__5771));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5771)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5771)));
          return G__5770__delegate(x, y, z, args)
        };
        G__5770.cljs$lang$arity$variadic = G__5770__delegate;
        return G__5770
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5745 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5745)) {
          return or__3548__auto____5745
        }else {
          var or__3548__auto____5746 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5746)) {
            return or__3548__auto____5746
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5747 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5747)) {
          return or__3548__auto____5747
        }else {
          var or__3548__auto____5748 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5748)) {
            return or__3548__auto____5748
          }else {
            var or__3548__auto____5749 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5749)) {
              return or__3548__auto____5749
            }else {
              var or__3548__auto____5750 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5750)) {
                return or__3548__auto____5750
              }else {
                var or__3548__auto____5751 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5751)) {
                  return or__3548__auto____5751
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5752 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5752)) {
          return or__3548__auto____5752
        }else {
          var or__3548__auto____5753 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5753)) {
            return or__3548__auto____5753
          }else {
            var or__3548__auto____5754 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5754)) {
              return or__3548__auto____5754
            }else {
              var or__3548__auto____5755 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5755)) {
                return or__3548__auto____5755
              }else {
                var or__3548__auto____5756 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5756)) {
                  return or__3548__auto____5756
                }else {
                  var or__3548__auto____5757 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5757)) {
                    return or__3548__auto____5757
                  }else {
                    var or__3548__auto____5758 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5758)) {
                      return or__3548__auto____5758
                    }else {
                      var or__3548__auto____5759 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5759)) {
                        return or__3548__auto____5759
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5772__delegate = function(x, y, z, args) {
          var or__3548__auto____5760 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5760)) {
            return or__3548__auto____5760
          }else {
            return cljs.core.some.call(null, function(p1__5676_SHARP_) {
              var or__3548__auto____5761 = p1.call(null, p1__5676_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5761)) {
                return or__3548__auto____5761
              }else {
                var or__3548__auto____5762 = p2.call(null, p1__5676_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5762)) {
                  return or__3548__auto____5762
                }else {
                  return p3.call(null, p1__5676_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5772 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5772__delegate.call(this, x, y, z, args)
        };
        G__5772.cljs$lang$maxFixedArity = 3;
        G__5772.cljs$lang$applyTo = function(arglist__5773) {
          var x = cljs.core.first(arglist__5773);
          var y = cljs.core.first(cljs.core.next(arglist__5773));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5773)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5773)));
          return G__5772__delegate(x, y, z, args)
        };
        G__5772.cljs$lang$arity$variadic = G__5772__delegate;
        return G__5772
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5774__delegate = function(p1, p2, p3, ps) {
      var ps__5763 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5677_SHARP_) {
            return p1__5677_SHARP_.call(null, x)
          }, ps__5763)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5678_SHARP_) {
            var or__3548__auto____5764 = p1__5678_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5764)) {
              return or__3548__auto____5764
            }else {
              return p1__5678_SHARP_.call(null, y)
            }
          }, ps__5763)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5679_SHARP_) {
            var or__3548__auto____5765 = p1__5679_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5765)) {
              return or__3548__auto____5765
            }else {
              var or__3548__auto____5766 = p1__5679_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5766)) {
                return or__3548__auto____5766
              }else {
                return p1__5679_SHARP_.call(null, z)
              }
            }
          }, ps__5763)
        };
        var spn__4 = function() {
          var G__5775__delegate = function(x, y, z, args) {
            var or__3548__auto____5767 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5767)) {
              return or__3548__auto____5767
            }else {
              return cljs.core.some.call(null, function(p1__5680_SHARP_) {
                return cljs.core.some.call(null, p1__5680_SHARP_, args)
              }, ps__5763)
            }
          };
          var G__5775 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5775__delegate.call(this, x, y, z, args)
          };
          G__5775.cljs$lang$maxFixedArity = 3;
          G__5775.cljs$lang$applyTo = function(arglist__5776) {
            var x = cljs.core.first(arglist__5776);
            var y = cljs.core.first(cljs.core.next(arglist__5776));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5776)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5776)));
            return G__5775__delegate(x, y, z, args)
          };
          G__5775.cljs$lang$arity$variadic = G__5775__delegate;
          return G__5775
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5774 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5774__delegate.call(this, p1, p2, p3, ps)
    };
    G__5774.cljs$lang$maxFixedArity = 3;
    G__5774.cljs$lang$applyTo = function(arglist__5777) {
      var p1 = cljs.core.first(arglist__5777);
      var p2 = cljs.core.first(cljs.core.next(arglist__5777));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5777)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5777)));
      return G__5774__delegate(p1, p2, p3, ps)
    };
    G__5774.cljs$lang$arity$variadic = G__5774__delegate;
    return G__5774
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5778 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5778)) {
        var s__5779 = temp__3698__auto____5778;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5779)), map.call(null, f, cljs.core.rest.call(null, s__5779)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5780 = cljs.core.seq.call(null, c1);
      var s2__5781 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5782 = s1__5780;
        if(cljs.core.truth_(and__3546__auto____5782)) {
          return s2__5781
        }else {
          return and__3546__auto____5782
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5780), cljs.core.first.call(null, s2__5781)), map.call(null, f, cljs.core.rest.call(null, s1__5780), cljs.core.rest.call(null, s2__5781)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5783 = cljs.core.seq.call(null, c1);
      var s2__5784 = cljs.core.seq.call(null, c2);
      var s3__5785 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5786 = s1__5783;
        if(cljs.core.truth_(and__3546__auto____5786)) {
          var and__3546__auto____5787 = s2__5784;
          if(cljs.core.truth_(and__3546__auto____5787)) {
            return s3__5785
          }else {
            return and__3546__auto____5787
          }
        }else {
          return and__3546__auto____5786
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5783), cljs.core.first.call(null, s2__5784), cljs.core.first.call(null, s3__5785)), map.call(null, f, cljs.core.rest.call(null, s1__5783), cljs.core.rest.call(null, s2__5784), cljs.core.rest.call(null, s3__5785)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5790__delegate = function(f, c1, c2, c3, colls) {
      var step__5789 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5788 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5788)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5788), step.call(null, map.call(null, cljs.core.rest, ss__5788)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5729_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5729_SHARP_)
      }, step__5789.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5790 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5790__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5790.cljs$lang$maxFixedArity = 4;
    G__5790.cljs$lang$applyTo = function(arglist__5791) {
      var f = cljs.core.first(arglist__5791);
      var c1 = cljs.core.first(cljs.core.next(arglist__5791));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5791)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5791))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5791))));
      return G__5790__delegate(f, c1, c2, c3, colls)
    };
    G__5790.cljs$lang$arity$variadic = G__5790__delegate;
    return G__5790
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5792 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5792)) {
        var s__5793 = temp__3698__auto____5792;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5793), take.call(null, n - 1, cljs.core.rest.call(null, s__5793)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5796 = function(n, coll) {
    while(true) {
      var s__5794 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5795 = n > 0;
        if(and__3546__auto____5795) {
          return s__5794
        }else {
          return and__3546__auto____5795
        }
      }())) {
        var G__5797 = n - 1;
        var G__5798 = cljs.core.rest.call(null, s__5794);
        n = G__5797;
        coll = G__5798;
        continue
      }else {
        return s__5794
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5796.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5799 = cljs.core.seq.call(null, coll);
  var lead__5800 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5800)) {
      var G__5801 = cljs.core.next.call(null, s__5799);
      var G__5802 = cljs.core.next.call(null, lead__5800);
      s__5799 = G__5801;
      lead__5800 = G__5802;
      continue
    }else {
      return s__5799
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5805 = function(pred, coll) {
    while(true) {
      var s__5803 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5804 = s__5803;
        if(cljs.core.truth_(and__3546__auto____5804)) {
          return pred.call(null, cljs.core.first.call(null, s__5803))
        }else {
          return and__3546__auto____5804
        }
      }())) {
        var G__5806 = pred;
        var G__5807 = cljs.core.rest.call(null, s__5803);
        pred = G__5806;
        coll = G__5807;
        continue
      }else {
        return s__5803
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5805.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5808 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5808)) {
      var s__5809 = temp__3698__auto____5808;
      return cljs.core.concat.call(null, s__5809, cycle.call(null, s__5809))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5810 = cljs.core.seq.call(null, c1);
      var s2__5811 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5812 = s1__5810;
        if(cljs.core.truth_(and__3546__auto____5812)) {
          return s2__5811
        }else {
          return and__3546__auto____5812
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5810), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5811), interleave.call(null, cljs.core.rest.call(null, s1__5810), cljs.core.rest.call(null, s2__5811))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5814__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5813 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5813)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5813), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5813)))
        }else {
          return null
        }
      })
    };
    var G__5814 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5814__delegate.call(this, c1, c2, colls)
    };
    G__5814.cljs$lang$maxFixedArity = 2;
    G__5814.cljs$lang$applyTo = function(arglist__5815) {
      var c1 = cljs.core.first(arglist__5815);
      var c2 = cljs.core.first(cljs.core.next(arglist__5815));
      var colls = cljs.core.rest(cljs.core.next(arglist__5815));
      return G__5814__delegate(c1, c2, colls)
    };
    G__5814.cljs$lang$arity$variadic = G__5814__delegate;
    return G__5814
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5818 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5816 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5816)) {
        var coll__5817 = temp__3695__auto____5816;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5817), cat.call(null, cljs.core.rest.call(null, coll__5817), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5818.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5819__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5819 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5819__delegate.call(this, f, coll, colls)
    };
    G__5819.cljs$lang$maxFixedArity = 2;
    G__5819.cljs$lang$applyTo = function(arglist__5820) {
      var f = cljs.core.first(arglist__5820);
      var coll = cljs.core.first(cljs.core.next(arglist__5820));
      var colls = cljs.core.rest(cljs.core.next(arglist__5820));
      return G__5819__delegate(f, coll, colls)
    };
    G__5819.cljs$lang$arity$variadic = G__5819__delegate;
    return G__5819
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5821 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5821)) {
      var s__5822 = temp__3698__auto____5821;
      var f__5823 = cljs.core.first.call(null, s__5822);
      var r__5824 = cljs.core.rest.call(null, s__5822);
      if(cljs.core.truth_(pred.call(null, f__5823))) {
        return cljs.core.cons.call(null, f__5823, filter.call(null, pred, r__5824))
      }else {
        return filter.call(null, pred, r__5824)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5826 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5826.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5825_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5825_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5827__5828 = to;
    if(G__5827__5828 != null) {
      if(function() {
        var or__3548__auto____5829 = G__5827__5828.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5829) {
          return or__3548__auto____5829
        }else {
          return G__5827__5828.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5827__5828.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5827__5828)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5827__5828)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5830__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5830 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5830__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5830.cljs$lang$maxFixedArity = 4;
    G__5830.cljs$lang$applyTo = function(arglist__5831) {
      var f = cljs.core.first(arglist__5831);
      var c1 = cljs.core.first(cljs.core.next(arglist__5831));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5831)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5831))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5831))));
      return G__5830__delegate(f, c1, c2, c3, colls)
    };
    G__5830.cljs$lang$arity$variadic = G__5830__delegate;
    return G__5830
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5832 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5832)) {
        var s__5833 = temp__3698__auto____5832;
        var p__5834 = cljs.core.take.call(null, n, s__5833);
        if(n === cljs.core.count.call(null, p__5834)) {
          return cljs.core.cons.call(null, p__5834, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5833)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5835 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5835)) {
        var s__5836 = temp__3698__auto____5835;
        var p__5837 = cljs.core.take.call(null, n, s__5836);
        if(n === cljs.core.count.call(null, p__5837)) {
          return cljs.core.cons.call(null, p__5837, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5836)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5837, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5838 = cljs.core.lookup_sentinel;
    var m__5839 = m;
    var ks__5840 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5840)) {
        var m__5841 = cljs.core.get.call(null, m__5839, cljs.core.first.call(null, ks__5840), sentinel__5838);
        if(sentinel__5838 === m__5841) {
          return not_found
        }else {
          var G__5842 = sentinel__5838;
          var G__5843 = m__5841;
          var G__5844 = cljs.core.next.call(null, ks__5840);
          sentinel__5838 = G__5842;
          m__5839 = G__5843;
          ks__5840 = G__5844;
          continue
        }
      }else {
        return m__5839
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5845, v) {
  var vec__5846__5847 = p__5845;
  var k__5848 = cljs.core.nth.call(null, vec__5846__5847, 0, null);
  var ks__5849 = cljs.core.nthnext.call(null, vec__5846__5847, 1);
  if(cljs.core.truth_(ks__5849)) {
    return cljs.core.assoc.call(null, m, k__5848, assoc_in.call(null, cljs.core.get.call(null, m, k__5848), ks__5849, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5848, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5850, f, args) {
    var vec__5851__5852 = p__5850;
    var k__5853 = cljs.core.nth.call(null, vec__5851__5852, 0, null);
    var ks__5854 = cljs.core.nthnext.call(null, vec__5851__5852, 1);
    if(cljs.core.truth_(ks__5854)) {
      return cljs.core.assoc.call(null, m, k__5853, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5853), ks__5854, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5853, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5853), args))
    }
  };
  var update_in = function(m, p__5850, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5850, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5855) {
    var m = cljs.core.first(arglist__5855);
    var p__5850 = cljs.core.first(cljs.core.next(arglist__5855));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5855)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5855)));
    return update_in__delegate(m, p__5850, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5860 = this;
  var h__364__auto____5861 = this__5860.__hash;
  if(h__364__auto____5861 != null) {
    return h__364__auto____5861
  }else {
    var h__364__auto____5862 = cljs.core.hash_coll.call(null, coll);
    this__5860.__hash = h__364__auto____5862;
    return h__364__auto____5862
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5863 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5864 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5865 = this;
  var new_array__5866 = cljs.core.aclone.call(null, this__5865.array);
  new_array__5866[k] = v;
  return new cljs.core.Vector(this__5865.meta, new_array__5866, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5895 = null;
  var G__5895__2 = function(tsym5858, k) {
    var this__5867 = this;
    var tsym5858__5868 = this;
    var coll__5869 = tsym5858__5868;
    return cljs.core._lookup.call(null, coll__5869, k)
  };
  var G__5895__3 = function(tsym5859, k, not_found) {
    var this__5870 = this;
    var tsym5859__5871 = this;
    var coll__5872 = tsym5859__5871;
    return cljs.core._lookup.call(null, coll__5872, k, not_found)
  };
  G__5895 = function(tsym5859, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5895__2.call(this, tsym5859, k);
      case 3:
        return G__5895__3.call(this, tsym5859, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5895
}();
cljs.core.Vector.prototype.apply = function(tsym5856, args5857) {
  return tsym5856.call.apply(tsym5856, [tsym5856].concat(cljs.core.aclone.call(null, args5857)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5873 = this;
  var new_array__5874 = cljs.core.aclone.call(null, this__5873.array);
  new_array__5874.push(o);
  return new cljs.core.Vector(this__5873.meta, new_array__5874, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5875 = this;
  var this$__5876 = this;
  return cljs.core.pr_str.call(null, this$__5876)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5877 = this;
  return cljs.core.ci_reduce.call(null, this__5877.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5878 = this;
  return cljs.core.ci_reduce.call(null, this__5878.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5879 = this;
  if(this__5879.array.length > 0) {
    var vector_seq__5880 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5879.array.length) {
          return cljs.core.cons.call(null, this__5879.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5880.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5881 = this;
  return this__5881.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5882 = this;
  var count__5883 = this__5882.array.length;
  if(count__5883 > 0) {
    return this__5882.array[count__5883 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5884 = this;
  if(this__5884.array.length > 0) {
    var new_array__5885 = cljs.core.aclone.call(null, this__5884.array);
    new_array__5885.pop();
    return new cljs.core.Vector(this__5884.meta, new_array__5885, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5886 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5887 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5888 = this;
  return new cljs.core.Vector(meta, this__5888.array, this__5888.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5889 = this;
  return this__5889.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5891 = this;
  if(function() {
    var and__3546__auto____5892 = 0 <= n;
    if(and__3546__auto____5892) {
      return n < this__5891.array.length
    }else {
      return and__3546__auto____5892
    }
  }()) {
    return this__5891.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5893 = this;
  if(function() {
    var and__3546__auto____5894 = 0 <= n;
    if(and__3546__auto____5894) {
      return n < this__5893.array.length
    }else {
      return and__3546__auto____5894
    }
  }()) {
    return this__5893.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5890 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5890.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5896 = pv.cnt;
  if(cnt__5896 < 32) {
    return 0
  }else {
    return cnt__5896 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5897 = level;
  var ret__5898 = node;
  while(true) {
    if(ll__5897 === 0) {
      return ret__5898
    }else {
      var embed__5899 = ret__5898;
      var r__5900 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5901 = cljs.core.pv_aset.call(null, r__5900, 0, embed__5899);
      var G__5902 = ll__5897 - 5;
      var G__5903 = r__5900;
      ll__5897 = G__5902;
      ret__5898 = G__5903;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5904 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5905 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5904, subidx__5905, tailnode);
    return ret__5904
  }else {
    var temp__3695__auto____5906 = cljs.core.pv_aget.call(null, parent, subidx__5905);
    if(cljs.core.truth_(temp__3695__auto____5906)) {
      var child__5907 = temp__3695__auto____5906;
      var node_to_insert__5908 = push_tail.call(null, pv, level - 5, child__5907, tailnode);
      cljs.core.pv_aset.call(null, ret__5904, subidx__5905, node_to_insert__5908);
      return ret__5904
    }else {
      var node_to_insert__5909 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5904, subidx__5905, node_to_insert__5909);
      return ret__5904
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5910 = 0 <= i;
    if(and__3546__auto____5910) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5910
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5911 = pv.root;
      var level__5912 = pv.shift;
      while(true) {
        if(level__5912 > 0) {
          var G__5913 = cljs.core.pv_aget.call(null, node__5911, i >>> level__5912 & 31);
          var G__5914 = level__5912 - 5;
          node__5911 = G__5913;
          level__5912 = G__5914;
          continue
        }else {
          return node__5911.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5915 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5915, i & 31, val);
    return ret__5915
  }else {
    var subidx__5916 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5915, subidx__5916, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5916), i, val));
    return ret__5915
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5917 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5918 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5917));
    if(function() {
      var and__3546__auto____5919 = new_child__5918 == null;
      if(and__3546__auto____5919) {
        return subidx__5917 === 0
      }else {
        return and__3546__auto____5919
      }
    }()) {
      return null
    }else {
      var ret__5920 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5920, subidx__5917, new_child__5918);
      return ret__5920
    }
  }else {
    if(subidx__5917 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5921 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5921, subidx__5917, null);
        return ret__5921
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5922 = cljs.core._count.call(null, v);
  if(c__5922 > 0) {
    if(void 0 === cljs.core.t5923) {
      cljs.core.t5923 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5923.cljs$lang$type = true;
      cljs.core.t5923.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5923")
      };
      cljs.core.t5923.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5923.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5924 = this;
        return vseq
      };
      cljs.core.t5923.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5923.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5925 = this;
        return cljs.core._nth.call(null, this__5925.v, this__5925.offset)
      };
      cljs.core.t5923.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5926 = this;
        var offset__5927 = this__5926.offset + 1;
        if(offset__5927 < this__5926.c) {
          return this__5926.vector_seq.call(null, this__5926.v, offset__5927)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5923.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5923.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5923.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5928 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5923.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5923.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5923.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5929 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5923.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5923.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5930 = this;
        return this__5930.__meta__389__auto__
      };
      cljs.core.t5923.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5931 = this;
        return new cljs.core.t5923(this__5931.c, this__5931.offset, this__5931.v, this__5931.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5923
    }else {
    }
    return new cljs.core.t5923(c__5922, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5936 = this;
  return new cljs.core.TransientVector(this__5936.cnt, this__5936.shift, cljs.core.tv_editable_root.call(null, this__5936.root), cljs.core.tv_editable_tail.call(null, this__5936.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5937 = this;
  var h__364__auto____5938 = this__5937.__hash;
  if(h__364__auto____5938 != null) {
    return h__364__auto____5938
  }else {
    var h__364__auto____5939 = cljs.core.hash_coll.call(null, coll);
    this__5937.__hash = h__364__auto____5939;
    return h__364__auto____5939
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5940 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5941 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5942 = this;
  if(function() {
    var and__3546__auto____5943 = 0 <= k;
    if(and__3546__auto____5943) {
      return k < this__5942.cnt
    }else {
      return and__3546__auto____5943
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5944 = cljs.core.aclone.call(null, this__5942.tail);
      new_tail__5944[k & 31] = v;
      return new cljs.core.PersistentVector(this__5942.meta, this__5942.cnt, this__5942.shift, this__5942.root, new_tail__5944, null)
    }else {
      return new cljs.core.PersistentVector(this__5942.meta, this__5942.cnt, this__5942.shift, cljs.core.do_assoc.call(null, coll, this__5942.shift, this__5942.root, k, v), this__5942.tail, null)
    }
  }else {
    if(k === this__5942.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5942.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5989 = null;
  var G__5989__2 = function(tsym5934, k) {
    var this__5945 = this;
    var tsym5934__5946 = this;
    var coll__5947 = tsym5934__5946;
    return cljs.core._lookup.call(null, coll__5947, k)
  };
  var G__5989__3 = function(tsym5935, k, not_found) {
    var this__5948 = this;
    var tsym5935__5949 = this;
    var coll__5950 = tsym5935__5949;
    return cljs.core._lookup.call(null, coll__5950, k, not_found)
  };
  G__5989 = function(tsym5935, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5989__2.call(this, tsym5935, k);
      case 3:
        return G__5989__3.call(this, tsym5935, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5989
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5932, args5933) {
  return tsym5932.call.apply(tsym5932, [tsym5932].concat(cljs.core.aclone.call(null, args5933)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5951 = this;
  var step_init__5952 = [0, init];
  var i__5953 = 0;
  while(true) {
    if(i__5953 < this__5951.cnt) {
      var arr__5954 = cljs.core.array_for.call(null, v, i__5953);
      var len__5955 = arr__5954.length;
      var init__5959 = function() {
        var j__5956 = 0;
        var init__5957 = step_init__5952[1];
        while(true) {
          if(j__5956 < len__5955) {
            var init__5958 = f.call(null, init__5957, j__5956 + i__5953, arr__5954[j__5956]);
            if(cljs.core.reduced_QMARK_.call(null, init__5958)) {
              return init__5958
            }else {
              var G__5990 = j__5956 + 1;
              var G__5991 = init__5958;
              j__5956 = G__5990;
              init__5957 = G__5991;
              continue
            }
          }else {
            step_init__5952[0] = len__5955;
            step_init__5952[1] = init__5957;
            return init__5957
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5959)) {
        return cljs.core.deref.call(null, init__5959)
      }else {
        var G__5992 = i__5953 + step_init__5952[0];
        i__5953 = G__5992;
        continue
      }
    }else {
      return step_init__5952[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5960 = this;
  if(this__5960.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5961 = cljs.core.aclone.call(null, this__5960.tail);
    new_tail__5961.push(o);
    return new cljs.core.PersistentVector(this__5960.meta, this__5960.cnt + 1, this__5960.shift, this__5960.root, new_tail__5961, null)
  }else {
    var root_overflow_QMARK___5962 = this__5960.cnt >>> 5 > 1 << this__5960.shift;
    var new_shift__5963 = root_overflow_QMARK___5962 ? this__5960.shift + 5 : this__5960.shift;
    var new_root__5965 = root_overflow_QMARK___5962 ? function() {
      var n_r__5964 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5964, 0, this__5960.root);
      cljs.core.pv_aset.call(null, n_r__5964, 1, cljs.core.new_path.call(null, null, this__5960.shift, new cljs.core.VectorNode(null, this__5960.tail)));
      return n_r__5964
    }() : cljs.core.push_tail.call(null, coll, this__5960.shift, this__5960.root, new cljs.core.VectorNode(null, this__5960.tail));
    return new cljs.core.PersistentVector(this__5960.meta, this__5960.cnt + 1, new_shift__5963, new_root__5965, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5966 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5967 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5968 = this;
  var this$__5969 = this;
  return cljs.core.pr_str.call(null, this$__5969)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5970 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5971 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5972 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5973 = this;
  return this__5973.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5974 = this;
  if(this__5974.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5974.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5975 = this;
  if(this__5975.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5975.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5975.meta)
    }else {
      if(1 < this__5975.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5975.meta, this__5975.cnt - 1, this__5975.shift, this__5975.root, this__5975.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5976 = cljs.core.array_for.call(null, coll, this__5975.cnt - 2);
          var nr__5977 = cljs.core.pop_tail.call(null, coll, this__5975.shift, this__5975.root);
          var new_root__5978 = nr__5977 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5977;
          var cnt_1__5979 = this__5975.cnt - 1;
          if(function() {
            var and__3546__auto____5980 = 5 < this__5975.shift;
            if(and__3546__auto____5980) {
              return cljs.core.pv_aget.call(null, new_root__5978, 1) == null
            }else {
              return and__3546__auto____5980
            }
          }()) {
            return new cljs.core.PersistentVector(this__5975.meta, cnt_1__5979, this__5975.shift - 5, cljs.core.pv_aget.call(null, new_root__5978, 0), new_tail__5976, null)
          }else {
            return new cljs.core.PersistentVector(this__5975.meta, cnt_1__5979, this__5975.shift, new_root__5978, new_tail__5976, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5982 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5983 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5984 = this;
  return new cljs.core.PersistentVector(meta, this__5984.cnt, this__5984.shift, this__5984.root, this__5984.tail, this__5984.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5985 = this;
  return this__5985.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5986 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5987 = this;
  if(function() {
    var and__3546__auto____5988 = 0 <= n;
    if(and__3546__auto____5988) {
      return n < this__5987.cnt
    }else {
      return and__3546__auto____5988
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5981 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5981.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5993 = cljs.core.seq.call(null, xs);
  var out__5994 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5993)) {
      var G__5995 = cljs.core.next.call(null, xs__5993);
      var G__5996 = cljs.core.conj_BANG_.call(null, out__5994, cljs.core.first.call(null, xs__5993));
      xs__5993 = G__5995;
      out__5994 = G__5996;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5994)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__5997) {
    var args = cljs.core.seq(arglist__5997);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6002 = this;
  var h__364__auto____6003 = this__6002.__hash;
  if(h__364__auto____6003 != null) {
    return h__364__auto____6003
  }else {
    var h__364__auto____6004 = cljs.core.hash_coll.call(null, coll);
    this__6002.__hash = h__364__auto____6004;
    return h__364__auto____6004
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6005 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6006 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__6007 = this;
  var v_pos__6008 = this__6007.start + key;
  return new cljs.core.Subvec(this__6007.meta, cljs.core._assoc.call(null, this__6007.v, v_pos__6008, val), this__6007.start, this__6007.end > v_pos__6008 + 1 ? this__6007.end : v_pos__6008 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__6032 = null;
  var G__6032__2 = function(tsym6000, k) {
    var this__6009 = this;
    var tsym6000__6010 = this;
    var coll__6011 = tsym6000__6010;
    return cljs.core._lookup.call(null, coll__6011, k)
  };
  var G__6032__3 = function(tsym6001, k, not_found) {
    var this__6012 = this;
    var tsym6001__6013 = this;
    var coll__6014 = tsym6001__6013;
    return cljs.core._lookup.call(null, coll__6014, k, not_found)
  };
  G__6032 = function(tsym6001, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6032__2.call(this, tsym6001, k);
      case 3:
        return G__6032__3.call(this, tsym6001, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6032
}();
cljs.core.Subvec.prototype.apply = function(tsym5998, args5999) {
  return tsym5998.call.apply(tsym5998, [tsym5998].concat(cljs.core.aclone.call(null, args5999)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6015 = this;
  return new cljs.core.Subvec(this__6015.meta, cljs.core._assoc_n.call(null, this__6015.v, this__6015.end, o), this__6015.start, this__6015.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__6016 = this;
  var this$__6017 = this;
  return cljs.core.pr_str.call(null, this$__6017)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__6018 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__6019 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6020 = this;
  var subvec_seq__6021 = function subvec_seq(i) {
    if(i === this__6020.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__6020.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__6021.call(null, this__6020.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6022 = this;
  return this__6022.end - this__6022.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6023 = this;
  return cljs.core._nth.call(null, this__6023.v, this__6023.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6024 = this;
  if(this__6024.start === this__6024.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__6024.meta, this__6024.v, this__6024.start, this__6024.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__6025 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6026 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6027 = this;
  return new cljs.core.Subvec(meta, this__6027.v, this__6027.start, this__6027.end, this__6027.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6028 = this;
  return this__6028.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6030 = this;
  return cljs.core._nth.call(null, this__6030.v, this__6030.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6031 = this;
  return cljs.core._nth.call(null, this__6031.v, this__6031.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6029 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__6029.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__6033 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__6033, 0, tl.length);
  return ret__6033
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__6034 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__6035 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__6034, subidx__6035, level === 5 ? tail_node : function() {
    var child__6036 = cljs.core.pv_aget.call(null, ret__6034, subidx__6035);
    if(child__6036 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__6036, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__6034
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__6037 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__6038 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__6039 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__6037, subidx__6038));
    if(function() {
      var and__3546__auto____6040 = new_child__6039 == null;
      if(and__3546__auto____6040) {
        return subidx__6038 === 0
      }else {
        return and__3546__auto____6040
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__6037, subidx__6038, new_child__6039);
      return node__6037
    }
  }else {
    if(subidx__6038 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__6037, subidx__6038, null);
        return node__6037
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____6041 = 0 <= i;
    if(and__3546__auto____6041) {
      return i < tv.cnt
    }else {
      return and__3546__auto____6041
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__6042 = tv.root;
      var node__6043 = root__6042;
      var level__6044 = tv.shift;
      while(true) {
        if(level__6044 > 0) {
          var G__6045 = cljs.core.tv_ensure_editable.call(null, root__6042.edit, cljs.core.pv_aget.call(null, node__6043, i >>> level__6044 & 31));
          var G__6046 = level__6044 - 5;
          node__6043 = G__6045;
          level__6044 = G__6046;
          continue
        }else {
          return node__6043.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__6084 = null;
  var G__6084__2 = function(tsym6049, k) {
    var this__6051 = this;
    var tsym6049__6052 = this;
    var coll__6053 = tsym6049__6052;
    return cljs.core._lookup.call(null, coll__6053, k)
  };
  var G__6084__3 = function(tsym6050, k, not_found) {
    var this__6054 = this;
    var tsym6050__6055 = this;
    var coll__6056 = tsym6050__6055;
    return cljs.core._lookup.call(null, coll__6056, k, not_found)
  };
  G__6084 = function(tsym6050, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6084__2.call(this, tsym6050, k);
      case 3:
        return G__6084__3.call(this, tsym6050, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6084
}();
cljs.core.TransientVector.prototype.apply = function(tsym6047, args6048) {
  return tsym6047.call.apply(tsym6047, [tsym6047].concat(cljs.core.aclone.call(null, args6048)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6057 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6058 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6059 = this;
  if(cljs.core.truth_(this__6059.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6060 = this;
  if(function() {
    var and__3546__auto____6061 = 0 <= n;
    if(and__3546__auto____6061) {
      return n < this__6060.cnt
    }else {
      return and__3546__auto____6061
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6062 = this;
  if(cljs.core.truth_(this__6062.root.edit)) {
    return this__6062.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__6063 = this;
  if(cljs.core.truth_(this__6063.root.edit)) {
    if(function() {
      var and__3546__auto____6064 = 0 <= n;
      if(and__3546__auto____6064) {
        return n < this__6063.cnt
      }else {
        return and__3546__auto____6064
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__6063.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__6067 = function go(level, node) {
          var node__6065 = cljs.core.tv_ensure_editable.call(null, this__6063.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__6065, n & 31, val);
            return node__6065
          }else {
            var subidx__6066 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__6065, subidx__6066, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__6065, subidx__6066)));
            return node__6065
          }
        }.call(null, this__6063.shift, this__6063.root);
        this__6063.root = new_root__6067;
        return tcoll
      }
    }else {
      if(n === this__6063.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__6063.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__6068 = this;
  if(cljs.core.truth_(this__6068.root.edit)) {
    if(this__6068.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__6068.cnt) {
        this__6068.cnt = 0;
        return tcoll
      }else {
        if((this__6068.cnt - 1 & 31) > 0) {
          this__6068.cnt = this__6068.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__6069 = cljs.core.editable_array_for.call(null, tcoll, this__6068.cnt - 2);
            var new_root__6071 = function() {
              var nr__6070 = cljs.core.tv_pop_tail.call(null, tcoll, this__6068.shift, this__6068.root);
              if(nr__6070 != null) {
                return nr__6070
              }else {
                return new cljs.core.VectorNode(this__6068.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____6072 = 5 < this__6068.shift;
              if(and__3546__auto____6072) {
                return cljs.core.pv_aget.call(null, new_root__6071, 1) == null
              }else {
                return and__3546__auto____6072
              }
            }()) {
              var new_root__6073 = cljs.core.tv_ensure_editable.call(null, this__6068.root.edit, cljs.core.pv_aget.call(null, new_root__6071, 0));
              this__6068.root = new_root__6073;
              this__6068.shift = this__6068.shift - 5;
              this__6068.cnt = this__6068.cnt - 1;
              this__6068.tail = new_tail__6069;
              return tcoll
            }else {
              this__6068.root = new_root__6071;
              this__6068.cnt = this__6068.cnt - 1;
              this__6068.tail = new_tail__6069;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6074 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6075 = this;
  if(cljs.core.truth_(this__6075.root.edit)) {
    if(this__6075.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__6075.tail[this__6075.cnt & 31] = o;
      this__6075.cnt = this__6075.cnt + 1;
      return tcoll
    }else {
      var tail_node__6076 = new cljs.core.VectorNode(this__6075.root.edit, this__6075.tail);
      var new_tail__6077 = cljs.core.make_array.call(null, 32);
      new_tail__6077[0] = o;
      this__6075.tail = new_tail__6077;
      if(this__6075.cnt >>> 5 > 1 << this__6075.shift) {
        var new_root_array__6078 = cljs.core.make_array.call(null, 32);
        var new_shift__6079 = this__6075.shift + 5;
        new_root_array__6078[0] = this__6075.root;
        new_root_array__6078[1] = cljs.core.new_path.call(null, this__6075.root.edit, this__6075.shift, tail_node__6076);
        this__6075.root = new cljs.core.VectorNode(this__6075.root.edit, new_root_array__6078);
        this__6075.shift = new_shift__6079;
        this__6075.cnt = this__6075.cnt + 1;
        return tcoll
      }else {
        var new_root__6080 = cljs.core.tv_push_tail.call(null, tcoll, this__6075.shift, this__6075.root, tail_node__6076);
        this__6075.root = new_root__6080;
        this__6075.cnt = this__6075.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6081 = this;
  if(cljs.core.truth_(this__6081.root.edit)) {
    this__6081.root.edit = null;
    var len__6082 = this__6081.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__6083 = cljs.core.make_array.call(null, len__6082);
    cljs.core.array_copy.call(null, this__6081.tail, 0, trimmed_tail__6083, 0, len__6082);
    return new cljs.core.PersistentVector(null, this__6081.cnt, this__6081.shift, this__6081.root, trimmed_tail__6083, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6085 = this;
  var h__364__auto____6086 = this__6085.__hash;
  if(h__364__auto____6086 != null) {
    return h__364__auto____6086
  }else {
    var h__364__auto____6087 = cljs.core.hash_coll.call(null, coll);
    this__6085.__hash = h__364__auto____6087;
    return h__364__auto____6087
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6088 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__6089 = this;
  var this$__6090 = this;
  return cljs.core.pr_str.call(null, this$__6090)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6091 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6092 = this;
  return cljs.core._first.call(null, this__6092.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6093 = this;
  var temp__3695__auto____6094 = cljs.core.next.call(null, this__6093.front);
  if(cljs.core.truth_(temp__3695__auto____6094)) {
    var f1__6095 = temp__3695__auto____6094;
    return new cljs.core.PersistentQueueSeq(this__6093.meta, f1__6095, this__6093.rear, null)
  }else {
    if(this__6093.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__6093.meta, this__6093.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6096 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6097 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__6097.front, this__6097.rear, this__6097.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6098 = this;
  return this__6098.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6099 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6099.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6100 = this;
  var h__364__auto____6101 = this__6100.__hash;
  if(h__364__auto____6101 != null) {
    return h__364__auto____6101
  }else {
    var h__364__auto____6102 = cljs.core.hash_coll.call(null, coll);
    this__6100.__hash = h__364__auto____6102;
    return h__364__auto____6102
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6103 = this;
  if(cljs.core.truth_(this__6103.front)) {
    return new cljs.core.PersistentQueue(this__6103.meta, this__6103.count + 1, this__6103.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____6104 = this__6103.rear;
      if(cljs.core.truth_(or__3548__auto____6104)) {
        return or__3548__auto____6104
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__6103.meta, this__6103.count + 1, cljs.core.conj.call(null, this__6103.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__6105 = this;
  var this$__6106 = this;
  return cljs.core.pr_str.call(null, this$__6106)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6107 = this;
  var rear__6108 = cljs.core.seq.call(null, this__6107.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____6109 = this__6107.front;
    if(cljs.core.truth_(or__3548__auto____6109)) {
      return or__3548__auto____6109
    }else {
      return rear__6108
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__6107.front, cljs.core.seq.call(null, rear__6108), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6110 = this;
  return this__6110.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6111 = this;
  return cljs.core._first.call(null, this__6111.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6112 = this;
  if(cljs.core.truth_(this__6112.front)) {
    var temp__3695__auto____6113 = cljs.core.next.call(null, this__6112.front);
    if(cljs.core.truth_(temp__3695__auto____6113)) {
      var f1__6114 = temp__3695__auto____6113;
      return new cljs.core.PersistentQueue(this__6112.meta, this__6112.count - 1, f1__6114, this__6112.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__6112.meta, this__6112.count - 1, cljs.core.seq.call(null, this__6112.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6115 = this;
  return cljs.core.first.call(null, this__6115.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6116 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6117 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6118 = this;
  return new cljs.core.PersistentQueue(meta, this__6118.count, this__6118.front, this__6118.rear, this__6118.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6119 = this;
  return this__6119.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6120 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6121 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__6122 = array.length;
  var i__6123 = 0;
  while(true) {
    if(i__6123 < len__6122) {
      if(cljs.core._EQ_.call(null, k, array[i__6123])) {
        return i__6123
      }else {
        var G__6124 = i__6123 + incr;
        i__6123 = G__6124;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6125 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____6125)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____6125
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__6126 = cljs.core.hash.call(null, a);
  var b__6127 = cljs.core.hash.call(null, b);
  if(a__6126 < b__6127) {
    return-1
  }else {
    if(a__6126 > b__6127) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__6129 = m.keys;
  var len__6130 = ks__6129.length;
  var so__6131 = m.strobj;
  var out__6132 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__6133 = 0;
  var out__6134 = cljs.core.transient$.call(null, out__6132);
  while(true) {
    if(i__6133 < len__6130) {
      var k__6135 = ks__6129[i__6133];
      var G__6136 = i__6133 + 1;
      var G__6137 = cljs.core.assoc_BANG_.call(null, out__6134, k__6135, so__6131[k__6135]);
      i__6133 = G__6136;
      out__6134 = G__6137;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__6134, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6142 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6143 = this;
  var h__364__auto____6144 = this__6143.__hash;
  if(h__364__auto____6144 != null) {
    return h__364__auto____6144
  }else {
    var h__364__auto____6145 = cljs.core.hash_imap.call(null, coll);
    this__6143.__hash = h__364__auto____6145;
    return h__364__auto____6145
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6146 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6147 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6147.strobj, this__6147.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6148 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___6149 = this__6148.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___6149)) {
      var new_strobj__6150 = goog.object.clone.call(null, this__6148.strobj);
      new_strobj__6150[k] = v;
      return new cljs.core.ObjMap(this__6148.meta, this__6148.keys, new_strobj__6150, this__6148.update_count + 1, null)
    }else {
      if(this__6148.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__6151 = goog.object.clone.call(null, this__6148.strobj);
        var new_keys__6152 = cljs.core.aclone.call(null, this__6148.keys);
        new_strobj__6151[k] = v;
        new_keys__6152.push(k);
        return new cljs.core.ObjMap(this__6148.meta, new_keys__6152, new_strobj__6151, this__6148.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6153 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6153.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__6173 = null;
  var G__6173__2 = function(tsym6140, k) {
    var this__6154 = this;
    var tsym6140__6155 = this;
    var coll__6156 = tsym6140__6155;
    return cljs.core._lookup.call(null, coll__6156, k)
  };
  var G__6173__3 = function(tsym6141, k, not_found) {
    var this__6157 = this;
    var tsym6141__6158 = this;
    var coll__6159 = tsym6141__6158;
    return cljs.core._lookup.call(null, coll__6159, k, not_found)
  };
  G__6173 = function(tsym6141, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6173__2.call(this, tsym6141, k);
      case 3:
        return G__6173__3.call(this, tsym6141, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6173
}();
cljs.core.ObjMap.prototype.apply = function(tsym6138, args6139) {
  return tsym6138.call.apply(tsym6138, [tsym6138].concat(cljs.core.aclone.call(null, args6139)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6160 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__6161 = this;
  var this$__6162 = this;
  return cljs.core.pr_str.call(null, this$__6162)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6163 = this;
  if(this__6163.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__6128_SHARP_) {
      return cljs.core.vector.call(null, p1__6128_SHARP_, this__6163.strobj[p1__6128_SHARP_])
    }, this__6163.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6164 = this;
  return this__6164.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6165 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6166 = this;
  return new cljs.core.ObjMap(meta, this__6166.keys, this__6166.strobj, this__6166.update_count, this__6166.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6167 = this;
  return this__6167.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6168 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__6168.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6169 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____6170 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____6170)) {
      return this__6169.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____6170
    }
  }())) {
    var new_keys__6171 = cljs.core.aclone.call(null, this__6169.keys);
    var new_strobj__6172 = goog.object.clone.call(null, this__6169.strobj);
    new_keys__6171.splice(cljs.core.scan_array.call(null, 1, k, new_keys__6171), 1);
    cljs.core.js_delete.call(null, new_strobj__6172, k);
    return new cljs.core.ObjMap(this__6169.meta, new_keys__6171, new_strobj__6172, this__6169.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6179 = this;
  var h__364__auto____6180 = this__6179.__hash;
  if(h__364__auto____6180 != null) {
    return h__364__auto____6180
  }else {
    var h__364__auto____6181 = cljs.core.hash_imap.call(null, coll);
    this__6179.__hash = h__364__auto____6181;
    return h__364__auto____6181
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6182 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6183 = this;
  var bucket__6184 = this__6183.hashobj[cljs.core.hash.call(null, k)];
  var i__6185 = cljs.core.truth_(bucket__6184) ? cljs.core.scan_array.call(null, 2, k, bucket__6184) : null;
  if(cljs.core.truth_(i__6185)) {
    return bucket__6184[i__6185 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6186 = this;
  var h__6187 = cljs.core.hash.call(null, k);
  var bucket__6188 = this__6186.hashobj[h__6187];
  if(cljs.core.truth_(bucket__6188)) {
    var new_bucket__6189 = cljs.core.aclone.call(null, bucket__6188);
    var new_hashobj__6190 = goog.object.clone.call(null, this__6186.hashobj);
    new_hashobj__6190[h__6187] = new_bucket__6189;
    var temp__3695__auto____6191 = cljs.core.scan_array.call(null, 2, k, new_bucket__6189);
    if(cljs.core.truth_(temp__3695__auto____6191)) {
      var i__6192 = temp__3695__auto____6191;
      new_bucket__6189[i__6192 + 1] = v;
      return new cljs.core.HashMap(this__6186.meta, this__6186.count, new_hashobj__6190, null)
    }else {
      new_bucket__6189.push(k, v);
      return new cljs.core.HashMap(this__6186.meta, this__6186.count + 1, new_hashobj__6190, null)
    }
  }else {
    var new_hashobj__6193 = goog.object.clone.call(null, this__6186.hashobj);
    new_hashobj__6193[h__6187] = [k, v];
    return new cljs.core.HashMap(this__6186.meta, this__6186.count + 1, new_hashobj__6193, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6194 = this;
  var bucket__6195 = this__6194.hashobj[cljs.core.hash.call(null, k)];
  var i__6196 = cljs.core.truth_(bucket__6195) ? cljs.core.scan_array.call(null, 2, k, bucket__6195) : null;
  if(cljs.core.truth_(i__6196)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6219 = null;
  var G__6219__2 = function(tsym6177, k) {
    var this__6197 = this;
    var tsym6177__6198 = this;
    var coll__6199 = tsym6177__6198;
    return cljs.core._lookup.call(null, coll__6199, k)
  };
  var G__6219__3 = function(tsym6178, k, not_found) {
    var this__6200 = this;
    var tsym6178__6201 = this;
    var coll__6202 = tsym6178__6201;
    return cljs.core._lookup.call(null, coll__6202, k, not_found)
  };
  G__6219 = function(tsym6178, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6219__2.call(this, tsym6178, k);
      case 3:
        return G__6219__3.call(this, tsym6178, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6219
}();
cljs.core.HashMap.prototype.apply = function(tsym6175, args6176) {
  return tsym6175.call.apply(tsym6175, [tsym6175].concat(cljs.core.aclone.call(null, args6176)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6203 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6204 = this;
  var this$__6205 = this;
  return cljs.core.pr_str.call(null, this$__6205)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6206 = this;
  if(this__6206.count > 0) {
    var hashes__6207 = cljs.core.js_keys.call(null, this__6206.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__6174_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6206.hashobj[p1__6174_SHARP_]))
    }, hashes__6207)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6208 = this;
  return this__6208.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6209 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6210 = this;
  return new cljs.core.HashMap(meta, this__6210.count, this__6210.hashobj, this__6210.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6211 = this;
  return this__6211.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6212 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6212.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6213 = this;
  var h__6214 = cljs.core.hash.call(null, k);
  var bucket__6215 = this__6213.hashobj[h__6214];
  var i__6216 = cljs.core.truth_(bucket__6215) ? cljs.core.scan_array.call(null, 2, k, bucket__6215) : null;
  if(cljs.core.not.call(null, i__6216)) {
    return coll
  }else {
    var new_hashobj__6217 = goog.object.clone.call(null, this__6213.hashobj);
    if(3 > bucket__6215.length) {
      cljs.core.js_delete.call(null, new_hashobj__6217, h__6214)
    }else {
      var new_bucket__6218 = cljs.core.aclone.call(null, bucket__6215);
      new_bucket__6218.splice(i__6216, 2);
      new_hashobj__6217[h__6214] = new_bucket__6218
    }
    return new cljs.core.HashMap(this__6213.meta, this__6213.count - 1, new_hashobj__6217, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6220 = ks.length;
  var i__6221 = 0;
  var out__6222 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6221 < len__6220) {
      var G__6223 = i__6221 + 1;
      var G__6224 = cljs.core.assoc.call(null, out__6222, ks[i__6221], vs[i__6221]);
      i__6221 = G__6223;
      out__6222 = G__6224;
      continue
    }else {
      return out__6222
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6225 = m.arr;
  var len__6226 = arr__6225.length;
  var i__6227 = 0;
  while(true) {
    if(len__6226 <= i__6227) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6225[i__6227], k)) {
        return i__6227
      }else {
        if("\ufdd0'else") {
          var G__6228 = i__6227 + 2;
          i__6227 = G__6228;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6233 = this;
  return new cljs.core.TransientArrayMap({}, this__6233.arr.length, cljs.core.aclone.call(null, this__6233.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6234 = this;
  var h__364__auto____6235 = this__6234.__hash;
  if(h__364__auto____6235 != null) {
    return h__364__auto____6235
  }else {
    var h__364__auto____6236 = cljs.core.hash_imap.call(null, coll);
    this__6234.__hash = h__364__auto____6236;
    return h__364__auto____6236
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6237 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6238 = this;
  var idx__6239 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6239 === -1) {
    return not_found
  }else {
    return this__6238.arr[idx__6239 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6240 = this;
  var idx__6241 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6241 === -1) {
    if(this__6240.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6240.meta, this__6240.cnt + 1, function() {
        var G__6242__6243 = cljs.core.aclone.call(null, this__6240.arr);
        G__6242__6243.push(k);
        G__6242__6243.push(v);
        return G__6242__6243
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6240.arr[idx__6241 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6240.meta, this__6240.cnt, function() {
          var G__6244__6245 = cljs.core.aclone.call(null, this__6240.arr);
          G__6244__6245[idx__6241 + 1] = v;
          return G__6244__6245
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6246 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6276 = null;
  var G__6276__2 = function(tsym6231, k) {
    var this__6247 = this;
    var tsym6231__6248 = this;
    var coll__6249 = tsym6231__6248;
    return cljs.core._lookup.call(null, coll__6249, k)
  };
  var G__6276__3 = function(tsym6232, k, not_found) {
    var this__6250 = this;
    var tsym6232__6251 = this;
    var coll__6252 = tsym6232__6251;
    return cljs.core._lookup.call(null, coll__6252, k, not_found)
  };
  G__6276 = function(tsym6232, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6276__2.call(this, tsym6232, k);
      case 3:
        return G__6276__3.call(this, tsym6232, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6276
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6229, args6230) {
  return tsym6229.call.apply(tsym6229, [tsym6229].concat(cljs.core.aclone.call(null, args6230)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6253 = this;
  var len__6254 = this__6253.arr.length;
  var i__6255 = 0;
  var init__6256 = init;
  while(true) {
    if(i__6255 < len__6254) {
      var init__6257 = f.call(null, init__6256, this__6253.arr[i__6255], this__6253.arr[i__6255 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6257)) {
        return cljs.core.deref.call(null, init__6257)
      }else {
        var G__6277 = i__6255 + 2;
        var G__6278 = init__6257;
        i__6255 = G__6277;
        init__6256 = G__6278;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6258 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6259 = this;
  var this$__6260 = this;
  return cljs.core.pr_str.call(null, this$__6260)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6261 = this;
  if(this__6261.cnt > 0) {
    var len__6262 = this__6261.arr.length;
    var array_map_seq__6263 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6262) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6261.arr[i], this__6261.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6263.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6264 = this;
  return this__6264.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6265 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6266 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6266.cnt, this__6266.arr, this__6266.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6267 = this;
  return this__6267.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6268 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6268.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6269 = this;
  var idx__6270 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6270 >= 0) {
    var len__6271 = this__6269.arr.length;
    var new_len__6272 = len__6271 - 2;
    if(new_len__6272 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6273 = cljs.core.make_array.call(null, new_len__6272);
      var s__6274 = 0;
      var d__6275 = 0;
      while(true) {
        if(s__6274 >= len__6271) {
          return new cljs.core.PersistentArrayMap(this__6269.meta, this__6269.cnt - 1, new_arr__6273, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6269.arr[s__6274])) {
            var G__6279 = s__6274 + 2;
            var G__6280 = d__6275;
            s__6274 = G__6279;
            d__6275 = G__6280;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6273[d__6275] = this__6269.arr[s__6274];
              new_arr__6273[d__6275 + 1] = this__6269.arr[s__6274 + 1];
              var G__6281 = s__6274 + 2;
              var G__6282 = d__6275 + 2;
              s__6274 = G__6281;
              d__6275 = G__6282;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6283 = cljs.core.count.call(null, ks);
  var i__6284 = 0;
  var out__6285 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6284 < len__6283) {
      var G__6286 = i__6284 + 1;
      var G__6287 = cljs.core.assoc_BANG_.call(null, out__6285, ks[i__6284], vs[i__6284]);
      i__6284 = G__6286;
      out__6285 = G__6287;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6285)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6288 = this;
  if(cljs.core.truth_(this__6288.editable_QMARK_)) {
    var idx__6289 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6289 >= 0) {
      this__6288.arr[idx__6289] = this__6288.arr[this__6288.len - 2];
      this__6288.arr[idx__6289 + 1] = this__6288.arr[this__6288.len - 1];
      var G__6290__6291 = this__6288.arr;
      G__6290__6291.pop();
      G__6290__6291.pop();
      G__6290__6291;
      this__6288.len = this__6288.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6292 = this;
  if(cljs.core.truth_(this__6292.editable_QMARK_)) {
    var idx__6293 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6293 === -1) {
      if(this__6292.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6292.len = this__6292.len + 2;
        this__6292.arr.push(key);
        this__6292.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6292.len, this__6292.arr), key, val)
      }
    }else {
      if(val === this__6292.arr[idx__6293 + 1]) {
        return tcoll
      }else {
        this__6292.arr[idx__6293 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6294 = this;
  if(cljs.core.truth_(this__6294.editable_QMARK_)) {
    if(function() {
      var G__6295__6296 = o;
      if(G__6295__6296 != null) {
        if(function() {
          var or__3548__auto____6297 = G__6295__6296.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6297) {
            return or__3548__auto____6297
          }else {
            return G__6295__6296.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6295__6296.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6295__6296)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6295__6296)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6298 = cljs.core.seq.call(null, o);
      var tcoll__6299 = tcoll;
      while(true) {
        var temp__3695__auto____6300 = cljs.core.first.call(null, es__6298);
        if(cljs.core.truth_(temp__3695__auto____6300)) {
          var e__6301 = temp__3695__auto____6300;
          var G__6307 = cljs.core.next.call(null, es__6298);
          var G__6308 = cljs.core._assoc_BANG_.call(null, tcoll__6299, cljs.core.key.call(null, e__6301), cljs.core.val.call(null, e__6301));
          es__6298 = G__6307;
          tcoll__6299 = G__6308;
          continue
        }else {
          return tcoll__6299
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6302 = this;
  if(cljs.core.truth_(this__6302.editable_QMARK_)) {
    this__6302.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6302.len, 2), this__6302.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6303 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6304 = this;
  if(cljs.core.truth_(this__6304.editable_QMARK_)) {
    var idx__6305 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6305 === -1) {
      return not_found
    }else {
      return this__6304.arr[idx__6305 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6306 = this;
  if(cljs.core.truth_(this__6306.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6306.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6309 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6310 = 0;
  while(true) {
    if(i__6310 < len) {
      var G__6311 = cljs.core.assoc_BANG_.call(null, out__6309, arr[i__6310], arr[i__6310 + 1]);
      var G__6312 = i__6310 + 2;
      out__6309 = G__6311;
      i__6310 = G__6312;
      continue
    }else {
      return out__6309
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6313__6314 = cljs.core.aclone.call(null, arr);
    G__6313__6314[i] = a;
    return G__6313__6314
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6315__6316 = cljs.core.aclone.call(null, arr);
    G__6315__6316[i] = a;
    G__6315__6316[j] = b;
    return G__6315__6316
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6317 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6317, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6317, 2 * i, new_arr__6317.length - 2 * i);
  return new_arr__6317
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6318 = inode.ensure_editable(edit);
    editable__6318.arr[i] = a;
    return editable__6318
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6319 = inode.ensure_editable(edit);
    editable__6319.arr[i] = a;
    editable__6319.arr[j] = b;
    return editable__6319
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6320 = arr.length;
  var i__6321 = 0;
  var init__6322 = init;
  while(true) {
    if(i__6321 < len__6320) {
      var init__6325 = function() {
        var k__6323 = arr[i__6321];
        if(k__6323 != null) {
          return f.call(null, init__6322, k__6323, arr[i__6321 + 1])
        }else {
          var node__6324 = arr[i__6321 + 1];
          if(node__6324 != null) {
            return node__6324.kv_reduce(f, init__6322)
          }else {
            return init__6322
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6325)) {
        return cljs.core.deref.call(null, init__6325)
      }else {
        var G__6326 = i__6321 + 2;
        var G__6327 = init__6325;
        i__6321 = G__6326;
        init__6322 = G__6327;
        continue
      }
    }else {
      return init__6322
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6328 = this;
  var inode__6329 = this;
  if(this__6328.bitmap === bit) {
    return null
  }else {
    var editable__6330 = inode__6329.ensure_editable(e);
    var earr__6331 = editable__6330.arr;
    var len__6332 = earr__6331.length;
    editable__6330.bitmap = bit ^ editable__6330.bitmap;
    cljs.core.array_copy.call(null, earr__6331, 2 * (i + 1), earr__6331, 2 * i, len__6332 - 2 * (i + 1));
    earr__6331[len__6332 - 2] = null;
    earr__6331[len__6332 - 1] = null;
    return editable__6330
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6333 = this;
  var inode__6334 = this;
  var bit__6335 = 1 << (hash >>> shift & 31);
  var idx__6336 = cljs.core.bitmap_indexed_node_index.call(null, this__6333.bitmap, bit__6335);
  if((this__6333.bitmap & bit__6335) === 0) {
    var n__6337 = cljs.core.bit_count.call(null, this__6333.bitmap);
    if(2 * n__6337 < this__6333.arr.length) {
      var editable__6338 = inode__6334.ensure_editable(edit);
      var earr__6339 = editable__6338.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6339, 2 * idx__6336, earr__6339, 2 * (idx__6336 + 1), 2 * (n__6337 - idx__6336));
      earr__6339[2 * idx__6336] = key;
      earr__6339[2 * idx__6336 + 1] = val;
      editable__6338.bitmap = editable__6338.bitmap | bit__6335;
      return editable__6338
    }else {
      if(n__6337 >= 16) {
        var nodes__6340 = cljs.core.make_array.call(null, 32);
        var jdx__6341 = hash >>> shift & 31;
        nodes__6340[jdx__6341] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6342 = 0;
        var j__6343 = 0;
        while(true) {
          if(i__6342 < 32) {
            if((this__6333.bitmap >>> i__6342 & 1) === 0) {
              var G__6396 = i__6342 + 1;
              var G__6397 = j__6343;
              i__6342 = G__6396;
              j__6343 = G__6397;
              continue
            }else {
              nodes__6340[i__6342] = null != this__6333.arr[j__6343] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6333.arr[j__6343]), this__6333.arr[j__6343], this__6333.arr[j__6343 + 1], added_leaf_QMARK_) : this__6333.arr[j__6343 + 1];
              var G__6398 = i__6342 + 1;
              var G__6399 = j__6343 + 2;
              i__6342 = G__6398;
              j__6343 = G__6399;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6337 + 1, nodes__6340)
      }else {
        if("\ufdd0'else") {
          var new_arr__6344 = cljs.core.make_array.call(null, 2 * (n__6337 + 4));
          cljs.core.array_copy.call(null, this__6333.arr, 0, new_arr__6344, 0, 2 * idx__6336);
          new_arr__6344[2 * idx__6336] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6344[2 * idx__6336 + 1] = val;
          cljs.core.array_copy.call(null, this__6333.arr, 2 * idx__6336, new_arr__6344, 2 * (idx__6336 + 1), 2 * (n__6337 - idx__6336));
          var editable__6345 = inode__6334.ensure_editable(edit);
          editable__6345.arr = new_arr__6344;
          editable__6345.bitmap = editable__6345.bitmap | bit__6335;
          return editable__6345
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6346 = this__6333.arr[2 * idx__6336];
    var val_or_node__6347 = this__6333.arr[2 * idx__6336 + 1];
    if(null == key_or_nil__6346) {
      var n__6348 = val_or_node__6347.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6348 === val_or_node__6347) {
        return inode__6334
      }else {
        return cljs.core.edit_and_set.call(null, inode__6334, edit, 2 * idx__6336 + 1, n__6348)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6346)) {
        if(val === val_or_node__6347) {
          return inode__6334
        }else {
          return cljs.core.edit_and_set.call(null, inode__6334, edit, 2 * idx__6336 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6334, edit, 2 * idx__6336, null, 2 * idx__6336 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6346, val_or_node__6347, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6349 = this;
  var inode__6350 = this;
  return cljs.core.create_inode_seq.call(null, this__6349.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6351 = this;
  var inode__6352 = this;
  var bit__6353 = 1 << (hash >>> shift & 31);
  if((this__6351.bitmap & bit__6353) === 0) {
    return inode__6352
  }else {
    var idx__6354 = cljs.core.bitmap_indexed_node_index.call(null, this__6351.bitmap, bit__6353);
    var key_or_nil__6355 = this__6351.arr[2 * idx__6354];
    var val_or_node__6356 = this__6351.arr[2 * idx__6354 + 1];
    if(null == key_or_nil__6355) {
      var n__6357 = val_or_node__6356.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6357 === val_or_node__6356) {
        return inode__6352
      }else {
        if(null != n__6357) {
          return cljs.core.edit_and_set.call(null, inode__6352, edit, 2 * idx__6354 + 1, n__6357)
        }else {
          if(this__6351.bitmap === bit__6353) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6352.edit_and_remove_pair(edit, bit__6353, idx__6354)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6355)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6352.edit_and_remove_pair(edit, bit__6353, idx__6354)
      }else {
        if("\ufdd0'else") {
          return inode__6352
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6358 = this;
  var inode__6359 = this;
  if(e === this__6358.edit) {
    return inode__6359
  }else {
    var n__6360 = cljs.core.bit_count.call(null, this__6358.bitmap);
    var new_arr__6361 = cljs.core.make_array.call(null, n__6360 < 0 ? 4 : 2 * (n__6360 + 1));
    cljs.core.array_copy.call(null, this__6358.arr, 0, new_arr__6361, 0, 2 * n__6360);
    return new cljs.core.BitmapIndexedNode(e, this__6358.bitmap, new_arr__6361)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6362 = this;
  var inode__6363 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6362.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6400 = null;
  var G__6400__3 = function(shift, hash, key) {
    var this__6364 = this;
    var inode__6365 = this;
    var bit__6366 = 1 << (hash >>> shift & 31);
    if((this__6364.bitmap & bit__6366) === 0) {
      return null
    }else {
      var idx__6367 = cljs.core.bitmap_indexed_node_index.call(null, this__6364.bitmap, bit__6366);
      var key_or_nil__6368 = this__6364.arr[2 * idx__6367];
      var val_or_node__6369 = this__6364.arr[2 * idx__6367 + 1];
      if(null == key_or_nil__6368) {
        return val_or_node__6369.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6368)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6368, val_or_node__6369])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6400__4 = function(shift, hash, key, not_found) {
    var this__6370 = this;
    var inode__6371 = this;
    var bit__6372 = 1 << (hash >>> shift & 31);
    if((this__6370.bitmap & bit__6372) === 0) {
      return not_found
    }else {
      var idx__6373 = cljs.core.bitmap_indexed_node_index.call(null, this__6370.bitmap, bit__6372);
      var key_or_nil__6374 = this__6370.arr[2 * idx__6373];
      var val_or_node__6375 = this__6370.arr[2 * idx__6373 + 1];
      if(null == key_or_nil__6374) {
        return val_or_node__6375.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6374)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6374, val_or_node__6375])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6400 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6400__3.call(this, shift, hash, key);
      case 4:
        return G__6400__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6400
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6376 = this;
  var inode__6377 = this;
  var bit__6378 = 1 << (hash >>> shift & 31);
  if((this__6376.bitmap & bit__6378) === 0) {
    return inode__6377
  }else {
    var idx__6379 = cljs.core.bitmap_indexed_node_index.call(null, this__6376.bitmap, bit__6378);
    var key_or_nil__6380 = this__6376.arr[2 * idx__6379];
    var val_or_node__6381 = this__6376.arr[2 * idx__6379 + 1];
    if(null == key_or_nil__6380) {
      var n__6382 = val_or_node__6381.inode_without(shift + 5, hash, key);
      if(n__6382 === val_or_node__6381) {
        return inode__6377
      }else {
        if(null != n__6382) {
          return new cljs.core.BitmapIndexedNode(null, this__6376.bitmap, cljs.core.clone_and_set.call(null, this__6376.arr, 2 * idx__6379 + 1, n__6382))
        }else {
          if(this__6376.bitmap === bit__6378) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6376.bitmap ^ bit__6378, cljs.core.remove_pair.call(null, this__6376.arr, idx__6379))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6380)) {
        return new cljs.core.BitmapIndexedNode(null, this__6376.bitmap ^ bit__6378, cljs.core.remove_pair.call(null, this__6376.arr, idx__6379))
      }else {
        if("\ufdd0'else") {
          return inode__6377
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6383 = this;
  var inode__6384 = this;
  var bit__6385 = 1 << (hash >>> shift & 31);
  var idx__6386 = cljs.core.bitmap_indexed_node_index.call(null, this__6383.bitmap, bit__6385);
  if((this__6383.bitmap & bit__6385) === 0) {
    var n__6387 = cljs.core.bit_count.call(null, this__6383.bitmap);
    if(n__6387 >= 16) {
      var nodes__6388 = cljs.core.make_array.call(null, 32);
      var jdx__6389 = hash >>> shift & 31;
      nodes__6388[jdx__6389] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6390 = 0;
      var j__6391 = 0;
      while(true) {
        if(i__6390 < 32) {
          if((this__6383.bitmap >>> i__6390 & 1) === 0) {
            var G__6401 = i__6390 + 1;
            var G__6402 = j__6391;
            i__6390 = G__6401;
            j__6391 = G__6402;
            continue
          }else {
            nodes__6388[i__6390] = null != this__6383.arr[j__6391] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6383.arr[j__6391]), this__6383.arr[j__6391], this__6383.arr[j__6391 + 1], added_leaf_QMARK_) : this__6383.arr[j__6391 + 1];
            var G__6403 = i__6390 + 1;
            var G__6404 = j__6391 + 2;
            i__6390 = G__6403;
            j__6391 = G__6404;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6387 + 1, nodes__6388)
    }else {
      var new_arr__6392 = cljs.core.make_array.call(null, 2 * (n__6387 + 1));
      cljs.core.array_copy.call(null, this__6383.arr, 0, new_arr__6392, 0, 2 * idx__6386);
      new_arr__6392[2 * idx__6386] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6392[2 * idx__6386 + 1] = val;
      cljs.core.array_copy.call(null, this__6383.arr, 2 * idx__6386, new_arr__6392, 2 * (idx__6386 + 1), 2 * (n__6387 - idx__6386));
      return new cljs.core.BitmapIndexedNode(null, this__6383.bitmap | bit__6385, new_arr__6392)
    }
  }else {
    var key_or_nil__6393 = this__6383.arr[2 * idx__6386];
    var val_or_node__6394 = this__6383.arr[2 * idx__6386 + 1];
    if(null == key_or_nil__6393) {
      var n__6395 = val_or_node__6394.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6395 === val_or_node__6394) {
        return inode__6384
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6383.bitmap, cljs.core.clone_and_set.call(null, this__6383.arr, 2 * idx__6386 + 1, n__6395))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6393)) {
        if(val === val_or_node__6394) {
          return inode__6384
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6383.bitmap, cljs.core.clone_and_set.call(null, this__6383.arr, 2 * idx__6386 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6383.bitmap, cljs.core.clone_and_set.call(null, this__6383.arr, 2 * idx__6386, null, 2 * idx__6386 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6393, val_or_node__6394, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6405 = array_node.arr;
  var len__6406 = 2 * (array_node.cnt - 1);
  var new_arr__6407 = cljs.core.make_array.call(null, len__6406);
  var i__6408 = 0;
  var j__6409 = 1;
  var bitmap__6410 = 0;
  while(true) {
    if(i__6408 < len__6406) {
      if(function() {
        var and__3546__auto____6411 = i__6408 != idx;
        if(and__3546__auto____6411) {
          return null != arr__6405[i__6408]
        }else {
          return and__3546__auto____6411
        }
      }()) {
        new_arr__6407[j__6409] = arr__6405[i__6408];
        var G__6412 = i__6408 + 1;
        var G__6413 = j__6409 + 2;
        var G__6414 = bitmap__6410 | 1 << i__6408;
        i__6408 = G__6412;
        j__6409 = G__6413;
        bitmap__6410 = G__6414;
        continue
      }else {
        var G__6415 = i__6408 + 1;
        var G__6416 = j__6409;
        var G__6417 = bitmap__6410;
        i__6408 = G__6415;
        j__6409 = G__6416;
        bitmap__6410 = G__6417;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6410, new_arr__6407)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6418 = this;
  var inode__6419 = this;
  var idx__6420 = hash >>> shift & 31;
  var node__6421 = this__6418.arr[idx__6420];
  if(null == node__6421) {
    return new cljs.core.ArrayNode(null, this__6418.cnt + 1, cljs.core.clone_and_set.call(null, this__6418.arr, idx__6420, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6422 = node__6421.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6422 === node__6421) {
      return inode__6419
    }else {
      return new cljs.core.ArrayNode(null, this__6418.cnt, cljs.core.clone_and_set.call(null, this__6418.arr, idx__6420, n__6422))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6423 = this;
  var inode__6424 = this;
  var idx__6425 = hash >>> shift & 31;
  var node__6426 = this__6423.arr[idx__6425];
  if(null != node__6426) {
    var n__6427 = node__6426.inode_without(shift + 5, hash, key);
    if(n__6427 === node__6426) {
      return inode__6424
    }else {
      if(n__6427 == null) {
        if(this__6423.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6424, null, idx__6425)
        }else {
          return new cljs.core.ArrayNode(null, this__6423.cnt - 1, cljs.core.clone_and_set.call(null, this__6423.arr, idx__6425, n__6427))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6423.cnt, cljs.core.clone_and_set.call(null, this__6423.arr, idx__6425, n__6427))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6424
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6459 = null;
  var G__6459__3 = function(shift, hash, key) {
    var this__6428 = this;
    var inode__6429 = this;
    var idx__6430 = hash >>> shift & 31;
    var node__6431 = this__6428.arr[idx__6430];
    if(null != node__6431) {
      return node__6431.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6459__4 = function(shift, hash, key, not_found) {
    var this__6432 = this;
    var inode__6433 = this;
    var idx__6434 = hash >>> shift & 31;
    var node__6435 = this__6432.arr[idx__6434];
    if(null != node__6435) {
      return node__6435.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6459 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6459__3.call(this, shift, hash, key);
      case 4:
        return G__6459__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6459
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6436 = this;
  var inode__6437 = this;
  return cljs.core.create_array_node_seq.call(null, this__6436.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6438 = this;
  var inode__6439 = this;
  if(e === this__6438.edit) {
    return inode__6439
  }else {
    return new cljs.core.ArrayNode(e, this__6438.cnt, cljs.core.aclone.call(null, this__6438.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6440 = this;
  var inode__6441 = this;
  var idx__6442 = hash >>> shift & 31;
  var node__6443 = this__6440.arr[idx__6442];
  if(null == node__6443) {
    var editable__6444 = cljs.core.edit_and_set.call(null, inode__6441, edit, idx__6442, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6444.cnt = editable__6444.cnt + 1;
    return editable__6444
  }else {
    var n__6445 = node__6443.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6445 === node__6443) {
      return inode__6441
    }else {
      return cljs.core.edit_and_set.call(null, inode__6441, edit, idx__6442, n__6445)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6446 = this;
  var inode__6447 = this;
  var idx__6448 = hash >>> shift & 31;
  var node__6449 = this__6446.arr[idx__6448];
  if(null == node__6449) {
    return inode__6447
  }else {
    var n__6450 = node__6449.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6450 === node__6449) {
      return inode__6447
    }else {
      if(null == n__6450) {
        if(this__6446.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6447, edit, idx__6448)
        }else {
          var editable__6451 = cljs.core.edit_and_set.call(null, inode__6447, edit, idx__6448, n__6450);
          editable__6451.cnt = editable__6451.cnt - 1;
          return editable__6451
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6447, edit, idx__6448, n__6450)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6452 = this;
  var inode__6453 = this;
  var len__6454 = this__6452.arr.length;
  var i__6455 = 0;
  var init__6456 = init;
  while(true) {
    if(i__6455 < len__6454) {
      var node__6457 = this__6452.arr[i__6455];
      if(node__6457 != null) {
        var init__6458 = node__6457.kv_reduce(f, init__6456);
        if(cljs.core.reduced_QMARK_.call(null, init__6458)) {
          return cljs.core.deref.call(null, init__6458)
        }else {
          var G__6460 = i__6455 + 1;
          var G__6461 = init__6458;
          i__6455 = G__6460;
          init__6456 = G__6461;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6456
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6462 = 2 * cnt;
  var i__6463 = 0;
  while(true) {
    if(i__6463 < lim__6462) {
      if(cljs.core._EQ_.call(null, key, arr[i__6463])) {
        return i__6463
      }else {
        var G__6464 = i__6463 + 2;
        i__6463 = G__6464;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6465 = this;
  var inode__6466 = this;
  if(hash === this__6465.collision_hash) {
    var idx__6467 = cljs.core.hash_collision_node_find_index.call(null, this__6465.arr, this__6465.cnt, key);
    if(idx__6467 === -1) {
      var len__6468 = this__6465.arr.length;
      var new_arr__6469 = cljs.core.make_array.call(null, len__6468 + 2);
      cljs.core.array_copy.call(null, this__6465.arr, 0, new_arr__6469, 0, len__6468);
      new_arr__6469[len__6468] = key;
      new_arr__6469[len__6468 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6465.collision_hash, this__6465.cnt + 1, new_arr__6469)
    }else {
      if(cljs.core._EQ_.call(null, this__6465.arr[idx__6467], val)) {
        return inode__6466
      }else {
        return new cljs.core.HashCollisionNode(null, this__6465.collision_hash, this__6465.cnt, cljs.core.clone_and_set.call(null, this__6465.arr, idx__6467 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6465.collision_hash >>> shift & 31), [null, inode__6466])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6470 = this;
  var inode__6471 = this;
  var idx__6472 = cljs.core.hash_collision_node_find_index.call(null, this__6470.arr, this__6470.cnt, key);
  if(idx__6472 === -1) {
    return inode__6471
  }else {
    if(this__6470.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6470.collision_hash, this__6470.cnt - 1, cljs.core.remove_pair.call(null, this__6470.arr, cljs.core.quot.call(null, idx__6472, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6499 = null;
  var G__6499__3 = function(shift, hash, key) {
    var this__6473 = this;
    var inode__6474 = this;
    var idx__6475 = cljs.core.hash_collision_node_find_index.call(null, this__6473.arr, this__6473.cnt, key);
    if(idx__6475 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6473.arr[idx__6475])) {
        return cljs.core.PersistentVector.fromArray([this__6473.arr[idx__6475], this__6473.arr[idx__6475 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6499__4 = function(shift, hash, key, not_found) {
    var this__6476 = this;
    var inode__6477 = this;
    var idx__6478 = cljs.core.hash_collision_node_find_index.call(null, this__6476.arr, this__6476.cnt, key);
    if(idx__6478 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6476.arr[idx__6478])) {
        return cljs.core.PersistentVector.fromArray([this__6476.arr[idx__6478], this__6476.arr[idx__6478 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6499 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6499__3.call(this, shift, hash, key);
      case 4:
        return G__6499__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6499
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6479 = this;
  var inode__6480 = this;
  return cljs.core.create_inode_seq.call(null, this__6479.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6500 = null;
  var G__6500__1 = function(e) {
    var this__6481 = this;
    var inode__6482 = this;
    if(e === this__6481.edit) {
      return inode__6482
    }else {
      var new_arr__6483 = cljs.core.make_array.call(null, 2 * (this__6481.cnt + 1));
      cljs.core.array_copy.call(null, this__6481.arr, 0, new_arr__6483, 0, 2 * this__6481.cnt);
      return new cljs.core.HashCollisionNode(e, this__6481.collision_hash, this__6481.cnt, new_arr__6483)
    }
  };
  var G__6500__3 = function(e, count, array) {
    var this__6484 = this;
    var inode__6485 = this;
    if(e === this__6484.edit) {
      this__6484.arr = array;
      this__6484.cnt = count;
      return inode__6485
    }else {
      return new cljs.core.HashCollisionNode(this__6484.edit, this__6484.collision_hash, count, array)
    }
  };
  G__6500 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6500__1.call(this, e);
      case 3:
        return G__6500__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6500
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6486 = this;
  var inode__6487 = this;
  if(hash === this__6486.collision_hash) {
    var idx__6488 = cljs.core.hash_collision_node_find_index.call(null, this__6486.arr, this__6486.cnt, key);
    if(idx__6488 === -1) {
      if(this__6486.arr.length > 2 * this__6486.cnt) {
        var editable__6489 = cljs.core.edit_and_set.call(null, inode__6487, edit, 2 * this__6486.cnt, key, 2 * this__6486.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6489.cnt = editable__6489.cnt + 1;
        return editable__6489
      }else {
        var len__6490 = this__6486.arr.length;
        var new_arr__6491 = cljs.core.make_array.call(null, len__6490 + 2);
        cljs.core.array_copy.call(null, this__6486.arr, 0, new_arr__6491, 0, len__6490);
        new_arr__6491[len__6490] = key;
        new_arr__6491[len__6490 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6487.ensure_editable(edit, this__6486.cnt + 1, new_arr__6491)
      }
    }else {
      if(this__6486.arr[idx__6488 + 1] === val) {
        return inode__6487
      }else {
        return cljs.core.edit_and_set.call(null, inode__6487, edit, idx__6488 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6486.collision_hash >>> shift & 31), [null, inode__6487, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6492 = this;
  var inode__6493 = this;
  var idx__6494 = cljs.core.hash_collision_node_find_index.call(null, this__6492.arr, this__6492.cnt, key);
  if(idx__6494 === -1) {
    return inode__6493
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6492.cnt === 1) {
      return null
    }else {
      var editable__6495 = inode__6493.ensure_editable(edit);
      var earr__6496 = editable__6495.arr;
      earr__6496[idx__6494] = earr__6496[2 * this__6492.cnt - 2];
      earr__6496[idx__6494 + 1] = earr__6496[2 * this__6492.cnt - 1];
      earr__6496[2 * this__6492.cnt - 1] = null;
      earr__6496[2 * this__6492.cnt - 2] = null;
      editable__6495.cnt = editable__6495.cnt - 1;
      return editable__6495
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6497 = this;
  var inode__6498 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6497.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6501 = cljs.core.hash.call(null, key1);
    if(key1hash__6501 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6501, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6502 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6501, key1, val1, added_leaf_QMARK___6502).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6502)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6503 = cljs.core.hash.call(null, key1);
    if(key1hash__6503 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6503, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6504 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6503, key1, val1, added_leaf_QMARK___6504).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6504)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6505 = this;
  var h__364__auto____6506 = this__6505.__hash;
  if(h__364__auto____6506 != null) {
    return h__364__auto____6506
  }else {
    var h__364__auto____6507 = cljs.core.hash_coll.call(null, coll);
    this__6505.__hash = h__364__auto____6507;
    return h__364__auto____6507
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6508 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6509 = this;
  var this$__6510 = this;
  return cljs.core.pr_str.call(null, this$__6510)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6511 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6512 = this;
  if(this__6512.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6512.nodes[this__6512.i], this__6512.nodes[this__6512.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6512.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6513 = this;
  if(this__6513.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6513.nodes, this__6513.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6513.nodes, this__6513.i, cljs.core.next.call(null, this__6513.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6514 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6515 = this;
  return new cljs.core.NodeSeq(meta, this__6515.nodes, this__6515.i, this__6515.s, this__6515.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6516 = this;
  return this__6516.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6517 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6517.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6518 = nodes.length;
      var j__6519 = i;
      while(true) {
        if(j__6519 < len__6518) {
          if(null != nodes[j__6519]) {
            return new cljs.core.NodeSeq(null, nodes, j__6519, null, null)
          }else {
            var temp__3695__auto____6520 = nodes[j__6519 + 1];
            if(cljs.core.truth_(temp__3695__auto____6520)) {
              var node__6521 = temp__3695__auto____6520;
              var temp__3695__auto____6522 = node__6521.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6522)) {
                var node_seq__6523 = temp__3695__auto____6522;
                return new cljs.core.NodeSeq(null, nodes, j__6519 + 2, node_seq__6523, null)
              }else {
                var G__6524 = j__6519 + 2;
                j__6519 = G__6524;
                continue
              }
            }else {
              var G__6525 = j__6519 + 2;
              j__6519 = G__6525;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6526 = this;
  var h__364__auto____6527 = this__6526.__hash;
  if(h__364__auto____6527 != null) {
    return h__364__auto____6527
  }else {
    var h__364__auto____6528 = cljs.core.hash_coll.call(null, coll);
    this__6526.__hash = h__364__auto____6528;
    return h__364__auto____6528
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6529 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6530 = this;
  var this$__6531 = this;
  return cljs.core.pr_str.call(null, this$__6531)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6532 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6533 = this;
  return cljs.core.first.call(null, this__6533.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6534 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6534.nodes, this__6534.i, cljs.core.next.call(null, this__6534.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6535 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6536 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6536.nodes, this__6536.i, this__6536.s, this__6536.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6537 = this;
  return this__6537.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6538 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6538.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6539 = nodes.length;
      var j__6540 = i;
      while(true) {
        if(j__6540 < len__6539) {
          var temp__3695__auto____6541 = nodes[j__6540];
          if(cljs.core.truth_(temp__3695__auto____6541)) {
            var nj__6542 = temp__3695__auto____6541;
            var temp__3695__auto____6543 = nj__6542.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6543)) {
              var ns__6544 = temp__3695__auto____6543;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6540 + 1, ns__6544, null)
            }else {
              var G__6545 = j__6540 + 1;
              j__6540 = G__6545;
              continue
            }
          }else {
            var G__6546 = j__6540 + 1;
            j__6540 = G__6546;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6551 = this;
  return new cljs.core.TransientHashMap({}, this__6551.root, this__6551.cnt, this__6551.has_nil_QMARK_, this__6551.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6552 = this;
  var h__364__auto____6553 = this__6552.__hash;
  if(h__364__auto____6553 != null) {
    return h__364__auto____6553
  }else {
    var h__364__auto____6554 = cljs.core.hash_imap.call(null, coll);
    this__6552.__hash = h__364__auto____6554;
    return h__364__auto____6554
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6555 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6556 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6556.has_nil_QMARK_)) {
      return this__6556.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6556.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6556.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6557 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6558 = this__6557.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6558)) {
        return v === this__6557.nil_val
      }else {
        return and__3546__auto____6558
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6557.meta, cljs.core.truth_(this__6557.has_nil_QMARK_) ? this__6557.cnt : this__6557.cnt + 1, this__6557.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6559 = [false];
    var new_root__6560 = (this__6557.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6557.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6559);
    if(new_root__6560 === this__6557.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6557.meta, cljs.core.truth_(added_leaf_QMARK___6559[0]) ? this__6557.cnt + 1 : this__6557.cnt, new_root__6560, this__6557.has_nil_QMARK_, this__6557.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6561 = this;
  if(k == null) {
    return this__6561.has_nil_QMARK_
  }else {
    if(this__6561.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6561.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6582 = null;
  var G__6582__2 = function(tsym6549, k) {
    var this__6562 = this;
    var tsym6549__6563 = this;
    var coll__6564 = tsym6549__6563;
    return cljs.core._lookup.call(null, coll__6564, k)
  };
  var G__6582__3 = function(tsym6550, k, not_found) {
    var this__6565 = this;
    var tsym6550__6566 = this;
    var coll__6567 = tsym6550__6566;
    return cljs.core._lookup.call(null, coll__6567, k, not_found)
  };
  G__6582 = function(tsym6550, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6582__2.call(this, tsym6550, k);
      case 3:
        return G__6582__3.call(this, tsym6550, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6582
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6547, args6548) {
  return tsym6547.call.apply(tsym6547, [tsym6547].concat(cljs.core.aclone.call(null, args6548)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6568 = this;
  var init__6569 = cljs.core.truth_(this__6568.has_nil_QMARK_) ? f.call(null, init, null, this__6568.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6569)) {
    return cljs.core.deref.call(null, init__6569)
  }else {
    if(null != this__6568.root) {
      return this__6568.root.kv_reduce(f, init__6569)
    }else {
      if("\ufdd0'else") {
        return init__6569
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6570 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6571 = this;
  var this$__6572 = this;
  return cljs.core.pr_str.call(null, this$__6572)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6573 = this;
  if(this__6573.cnt > 0) {
    var s__6574 = null != this__6573.root ? this__6573.root.inode_seq() : null;
    if(cljs.core.truth_(this__6573.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6573.nil_val]), s__6574)
    }else {
      return s__6574
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6575 = this;
  return this__6575.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6576 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6577 = this;
  return new cljs.core.PersistentHashMap(meta, this__6577.cnt, this__6577.root, this__6577.has_nil_QMARK_, this__6577.nil_val, this__6577.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6578 = this;
  return this__6578.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6579 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6579.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6580 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6580.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6580.meta, this__6580.cnt - 1, this__6580.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6580.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6581 = this__6580.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6581 === this__6580.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6580.meta, this__6580.cnt - 1, new_root__6581, this__6580.has_nil_QMARK_, this__6580.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6583 = ks.length;
  var i__6584 = 0;
  var out__6585 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6584 < len__6583) {
      var G__6586 = i__6584 + 1;
      var G__6587 = cljs.core.assoc_BANG_.call(null, out__6585, ks[i__6584], vs[i__6584]);
      i__6584 = G__6586;
      out__6585 = G__6587;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6585)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6588 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6589 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6590 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6591 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6592 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6592.has_nil_QMARK_)) {
      return this__6592.nil_val
    }else {
      return null
    }
  }else {
    if(this__6592.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6592.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6593 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6593.has_nil_QMARK_)) {
      return this__6593.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6593.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6593.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6594 = this;
  if(cljs.core.truth_(this__6594.edit)) {
    return this__6594.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6595 = this;
  var tcoll__6596 = this;
  if(cljs.core.truth_(this__6595.edit)) {
    if(function() {
      var G__6597__6598 = o;
      if(G__6597__6598 != null) {
        if(function() {
          var or__3548__auto____6599 = G__6597__6598.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6599) {
            return or__3548__auto____6599
          }else {
            return G__6597__6598.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6597__6598.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6597__6598)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6597__6598)
      }
    }()) {
      return tcoll__6596.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6600 = cljs.core.seq.call(null, o);
      var tcoll__6601 = tcoll__6596;
      while(true) {
        var temp__3695__auto____6602 = cljs.core.first.call(null, es__6600);
        if(cljs.core.truth_(temp__3695__auto____6602)) {
          var e__6603 = temp__3695__auto____6602;
          var G__6614 = cljs.core.next.call(null, es__6600);
          var G__6615 = tcoll__6601.assoc_BANG_(cljs.core.key.call(null, e__6603), cljs.core.val.call(null, e__6603));
          es__6600 = G__6614;
          tcoll__6601 = G__6615;
          continue
        }else {
          return tcoll__6601
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6604 = this;
  var tcoll__6605 = this;
  if(cljs.core.truth_(this__6604.edit)) {
    if(k == null) {
      if(this__6604.nil_val === v) {
      }else {
        this__6604.nil_val = v
      }
      if(cljs.core.truth_(this__6604.has_nil_QMARK_)) {
      }else {
        this__6604.count = this__6604.count + 1;
        this__6604.has_nil_QMARK_ = true
      }
      return tcoll__6605
    }else {
      var added_leaf_QMARK___6606 = [false];
      var node__6607 = (this__6604.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6604.root).inode_assoc_BANG_(this__6604.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6606);
      if(node__6607 === this__6604.root) {
      }else {
        this__6604.root = node__6607
      }
      if(cljs.core.truth_(added_leaf_QMARK___6606[0])) {
        this__6604.count = this__6604.count + 1
      }else {
      }
      return tcoll__6605
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6608 = this;
  var tcoll__6609 = this;
  if(cljs.core.truth_(this__6608.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6608.has_nil_QMARK_)) {
        this__6608.has_nil_QMARK_ = false;
        this__6608.nil_val = null;
        this__6608.count = this__6608.count - 1;
        return tcoll__6609
      }else {
        return tcoll__6609
      }
    }else {
      if(this__6608.root == null) {
        return tcoll__6609
      }else {
        var removed_leaf_QMARK___6610 = [false];
        var node__6611 = this__6608.root.inode_without_BANG_(this__6608.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6610);
        if(node__6611 === this__6608.root) {
        }else {
          this__6608.root = node__6611
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6610[0])) {
          this__6608.count = this__6608.count - 1
        }else {
        }
        return tcoll__6609
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6612 = this;
  var tcoll__6613 = this;
  if(cljs.core.truth_(this__6612.edit)) {
    this__6612.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6612.count, this__6612.root, this__6612.has_nil_QMARK_, this__6612.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6616 = node;
  var stack__6617 = stack;
  while(true) {
    if(t__6616 != null) {
      var G__6618 = cljs.core.truth_(ascending_QMARK_) ? t__6616.left : t__6616.right;
      var G__6619 = cljs.core.conj.call(null, stack__6617, t__6616);
      t__6616 = G__6618;
      stack__6617 = G__6619;
      continue
    }else {
      return stack__6617
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6620 = this;
  var h__364__auto____6621 = this__6620.__hash;
  if(h__364__auto____6621 != null) {
    return h__364__auto____6621
  }else {
    var h__364__auto____6622 = cljs.core.hash_coll.call(null, coll);
    this__6620.__hash = h__364__auto____6622;
    return h__364__auto____6622
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6623 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6624 = this;
  var this$__6625 = this;
  return cljs.core.pr_str.call(null, this$__6625)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6626 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6627 = this;
  if(this__6627.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6627.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6628 = this;
  return cljs.core.peek.call(null, this__6628.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6629 = this;
  var t__6630 = cljs.core.peek.call(null, this__6629.stack);
  var next_stack__6631 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6629.ascending_QMARK_) ? t__6630.right : t__6630.left, cljs.core.pop.call(null, this__6629.stack), this__6629.ascending_QMARK_);
  if(next_stack__6631 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6631, this__6629.ascending_QMARK_, this__6629.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6632 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6633 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6633.stack, this__6633.ascending_QMARK_, this__6633.cnt, this__6633.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6634 = this;
  return this__6634.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6635 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6635) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6635
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6636 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6636) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6636
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6637 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6637)) {
    return cljs.core.deref.call(null, init__6637)
  }else {
    var init__6638 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6637) : init__6637;
    if(cljs.core.reduced_QMARK_.call(null, init__6638)) {
      return cljs.core.deref.call(null, init__6638)
    }else {
      var init__6639 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6638) : init__6638;
      if(cljs.core.reduced_QMARK_.call(null, init__6639)) {
        return cljs.core.deref.call(null, init__6639)
      }else {
        return init__6639
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6644 = this;
  var h__364__auto____6645 = this__6644.__hash;
  if(h__364__auto____6645 != null) {
    return h__364__auto____6645
  }else {
    var h__364__auto____6646 = cljs.core.hash_coll.call(null, coll);
    this__6644.__hash = h__364__auto____6646;
    return h__364__auto____6646
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6647 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6648 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6649 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6649.key, this__6649.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6696 = null;
  var G__6696__2 = function(tsym6642, k) {
    var this__6650 = this;
    var tsym6642__6651 = this;
    var node__6652 = tsym6642__6651;
    return cljs.core._lookup.call(null, node__6652, k)
  };
  var G__6696__3 = function(tsym6643, k, not_found) {
    var this__6653 = this;
    var tsym6643__6654 = this;
    var node__6655 = tsym6643__6654;
    return cljs.core._lookup.call(null, node__6655, k, not_found)
  };
  G__6696 = function(tsym6643, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6696__2.call(this, tsym6643, k);
      case 3:
        return G__6696__3.call(this, tsym6643, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6696
}();
cljs.core.BlackNode.prototype.apply = function(tsym6640, args6641) {
  return tsym6640.call.apply(tsym6640, [tsym6640].concat(cljs.core.aclone.call(null, args6641)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6656 = this;
  return cljs.core.PersistentVector.fromArray([this__6656.key, this__6656.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6657 = this;
  return this__6657.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6658 = this;
  return this__6658.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6659 = this;
  var node__6660 = this;
  return ins.balance_right(node__6660)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6661 = this;
  var node__6662 = this;
  return new cljs.core.RedNode(this__6661.key, this__6661.val, this__6661.left, this__6661.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6663 = this;
  var node__6664 = this;
  return cljs.core.balance_right_del.call(null, this__6663.key, this__6663.val, this__6663.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6665 = this;
  var node__6666 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6667 = this;
  var node__6668 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6668, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6669 = this;
  var node__6670 = this;
  return cljs.core.balance_left_del.call(null, this__6669.key, this__6669.val, del, this__6669.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6671 = this;
  var node__6672 = this;
  return ins.balance_left(node__6672)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6673 = this;
  var node__6674 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6674, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6697 = null;
  var G__6697__0 = function() {
    var this__6677 = this;
    var this$__6678 = this;
    return cljs.core.pr_str.call(null, this$__6678)
  };
  G__6697 = function() {
    switch(arguments.length) {
      case 0:
        return G__6697__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6697
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6679 = this;
  var node__6680 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6680, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6681 = this;
  var node__6682 = this;
  return node__6682
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6683 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6684 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6685 = this;
  return cljs.core.list.call(null, this__6685.key, this__6685.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6687 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6688 = this;
  return this__6688.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6689 = this;
  return cljs.core.PersistentVector.fromArray([this__6689.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6690 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6690.key, this__6690.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6691 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6692 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6692.key, this__6692.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6693 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6694 = this;
  if(n === 0) {
    return this__6694.key
  }else {
    if(n === 1) {
      return this__6694.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6695 = this;
  if(n === 0) {
    return this__6695.key
  }else {
    if(n === 1) {
      return this__6695.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6686 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6702 = this;
  var h__364__auto____6703 = this__6702.__hash;
  if(h__364__auto____6703 != null) {
    return h__364__auto____6703
  }else {
    var h__364__auto____6704 = cljs.core.hash_coll.call(null, coll);
    this__6702.__hash = h__364__auto____6704;
    return h__364__auto____6704
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6705 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6706 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6707 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6707.key, this__6707.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6754 = null;
  var G__6754__2 = function(tsym6700, k) {
    var this__6708 = this;
    var tsym6700__6709 = this;
    var node__6710 = tsym6700__6709;
    return cljs.core._lookup.call(null, node__6710, k)
  };
  var G__6754__3 = function(tsym6701, k, not_found) {
    var this__6711 = this;
    var tsym6701__6712 = this;
    var node__6713 = tsym6701__6712;
    return cljs.core._lookup.call(null, node__6713, k, not_found)
  };
  G__6754 = function(tsym6701, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6754__2.call(this, tsym6701, k);
      case 3:
        return G__6754__3.call(this, tsym6701, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6754
}();
cljs.core.RedNode.prototype.apply = function(tsym6698, args6699) {
  return tsym6698.call.apply(tsym6698, [tsym6698].concat(cljs.core.aclone.call(null, args6699)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6714 = this;
  return cljs.core.PersistentVector.fromArray([this__6714.key, this__6714.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6715 = this;
  return this__6715.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6716 = this;
  return this__6716.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6717 = this;
  var node__6718 = this;
  return new cljs.core.RedNode(this__6717.key, this__6717.val, this__6717.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6719 = this;
  var node__6720 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6721 = this;
  var node__6722 = this;
  return new cljs.core.RedNode(this__6721.key, this__6721.val, this__6721.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6723 = this;
  var node__6724 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6725 = this;
  var node__6726 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6726, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6727 = this;
  var node__6728 = this;
  return new cljs.core.RedNode(this__6727.key, this__6727.val, del, this__6727.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6729 = this;
  var node__6730 = this;
  return new cljs.core.RedNode(this__6729.key, this__6729.val, ins, this__6729.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6731 = this;
  var node__6732 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6731.left)) {
    return new cljs.core.RedNode(this__6731.key, this__6731.val, this__6731.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6731.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6731.right)) {
      return new cljs.core.RedNode(this__6731.right.key, this__6731.right.val, new cljs.core.BlackNode(this__6731.key, this__6731.val, this__6731.left, this__6731.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6731.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6732, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6755 = null;
  var G__6755__0 = function() {
    var this__6735 = this;
    var this$__6736 = this;
    return cljs.core.pr_str.call(null, this$__6736)
  };
  G__6755 = function() {
    switch(arguments.length) {
      case 0:
        return G__6755__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6755
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6737 = this;
  var node__6738 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6737.right)) {
    return new cljs.core.RedNode(this__6737.key, this__6737.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6737.left, null), this__6737.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6737.left)) {
      return new cljs.core.RedNode(this__6737.left.key, this__6737.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6737.left.left, null), new cljs.core.BlackNode(this__6737.key, this__6737.val, this__6737.left.right, this__6737.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6738, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6739 = this;
  var node__6740 = this;
  return new cljs.core.BlackNode(this__6739.key, this__6739.val, this__6739.left, this__6739.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6741 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6742 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6743 = this;
  return cljs.core.list.call(null, this__6743.key, this__6743.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6745 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6746 = this;
  return this__6746.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6747 = this;
  return cljs.core.PersistentVector.fromArray([this__6747.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6748 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6748.key, this__6748.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6749 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6750 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6750.key, this__6750.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6751 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6752 = this;
  if(n === 0) {
    return this__6752.key
  }else {
    if(n === 1) {
      return this__6752.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6753 = this;
  if(n === 0) {
    return this__6753.key
  }else {
    if(n === 1) {
      return this__6753.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6744 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6756 = comp.call(null, k, tree.key);
    if(c__6756 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6756 < 0) {
        var ins__6757 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6757 != null) {
          return tree.add_left(ins__6757)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6758 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6758 != null) {
            return tree.add_right(ins__6758)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6759 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6759)) {
            return new cljs.core.RedNode(app__6759.key, app__6759.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6759.left), new cljs.core.RedNode(right.key, right.val, app__6759.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6759, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6760 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6760)) {
              return new cljs.core.RedNode(app__6760.key, app__6760.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6760.left, null), new cljs.core.BlackNode(right.key, right.val, app__6760.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6760, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6761 = comp.call(null, k, tree.key);
    if(c__6761 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6761 < 0) {
        var del__6762 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6763 = del__6762 != null;
          if(or__3548__auto____6763) {
            return or__3548__auto____6763
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6762, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6762, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6764 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6765 = del__6764 != null;
            if(or__3548__auto____6765) {
              return or__3548__auto____6765
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6764)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6764, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6766 = tree.key;
  var c__6767 = comp.call(null, k, tk__6766);
  if(c__6767 === 0) {
    return tree.replace(tk__6766, v, tree.left, tree.right)
  }else {
    if(c__6767 < 0) {
      return tree.replace(tk__6766, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6766, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6772 = this;
  var h__364__auto____6773 = this__6772.__hash;
  if(h__364__auto____6773 != null) {
    return h__364__auto____6773
  }else {
    var h__364__auto____6774 = cljs.core.hash_imap.call(null, coll);
    this__6772.__hash = h__364__auto____6774;
    return h__364__auto____6774
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6775 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6776 = this;
  var n__6777 = coll.entry_at(k);
  if(n__6777 != null) {
    return n__6777.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6778 = this;
  var found__6779 = [null];
  var t__6780 = cljs.core.tree_map_add.call(null, this__6778.comp, this__6778.tree, k, v, found__6779);
  if(t__6780 == null) {
    var found_node__6781 = cljs.core.nth.call(null, found__6779, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6781.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6778.comp, cljs.core.tree_map_replace.call(null, this__6778.comp, this__6778.tree, k, v), this__6778.cnt, this__6778.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6778.comp, t__6780.blacken(), this__6778.cnt + 1, this__6778.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6782 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6814 = null;
  var G__6814__2 = function(tsym6770, k) {
    var this__6783 = this;
    var tsym6770__6784 = this;
    var coll__6785 = tsym6770__6784;
    return cljs.core._lookup.call(null, coll__6785, k)
  };
  var G__6814__3 = function(tsym6771, k, not_found) {
    var this__6786 = this;
    var tsym6771__6787 = this;
    var coll__6788 = tsym6771__6787;
    return cljs.core._lookup.call(null, coll__6788, k, not_found)
  };
  G__6814 = function(tsym6771, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6814__2.call(this, tsym6771, k);
      case 3:
        return G__6814__3.call(this, tsym6771, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6814
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6768, args6769) {
  return tsym6768.call.apply(tsym6768, [tsym6768].concat(cljs.core.aclone.call(null, args6769)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6789 = this;
  if(this__6789.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6789.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6790 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6791 = this;
  if(this__6791.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6791.tree, false, this__6791.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6792 = this;
  var this$__6793 = this;
  return cljs.core.pr_str.call(null, this$__6793)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6794 = this;
  var coll__6795 = this;
  var t__6796 = this__6794.tree;
  while(true) {
    if(t__6796 != null) {
      var c__6797 = this__6794.comp.call(null, k, t__6796.key);
      if(c__6797 === 0) {
        return t__6796
      }else {
        if(c__6797 < 0) {
          var G__6815 = t__6796.left;
          t__6796 = G__6815;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6816 = t__6796.right;
            t__6796 = G__6816;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6798 = this;
  if(this__6798.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6798.tree, ascending_QMARK_, this__6798.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6799 = this;
  if(this__6799.cnt > 0) {
    var stack__6800 = null;
    var t__6801 = this__6799.tree;
    while(true) {
      if(t__6801 != null) {
        var c__6802 = this__6799.comp.call(null, k, t__6801.key);
        if(c__6802 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6800, t__6801), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6802 < 0) {
              var G__6817 = cljs.core.conj.call(null, stack__6800, t__6801);
              var G__6818 = t__6801.left;
              stack__6800 = G__6817;
              t__6801 = G__6818;
              continue
            }else {
              var G__6819 = stack__6800;
              var G__6820 = t__6801.right;
              stack__6800 = G__6819;
              t__6801 = G__6820;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6802 > 0) {
                var G__6821 = cljs.core.conj.call(null, stack__6800, t__6801);
                var G__6822 = t__6801.right;
                stack__6800 = G__6821;
                t__6801 = G__6822;
                continue
              }else {
                var G__6823 = stack__6800;
                var G__6824 = t__6801.left;
                stack__6800 = G__6823;
                t__6801 = G__6824;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6800 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6800, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6803 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6804 = this;
  return this__6804.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6805 = this;
  if(this__6805.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6805.tree, true, this__6805.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6806 = this;
  return this__6806.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6807 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6808 = this;
  return new cljs.core.PersistentTreeMap(this__6808.comp, this__6808.tree, this__6808.cnt, meta, this__6808.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6812 = this;
  return this__6812.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6813 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6813.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6809 = this;
  var found__6810 = [null];
  var t__6811 = cljs.core.tree_map_remove.call(null, this__6809.comp, this__6809.tree, k, found__6810);
  if(t__6811 == null) {
    if(cljs.core.nth.call(null, found__6810, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6809.comp, null, 0, this__6809.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6809.comp, t__6811.blacken(), this__6809.cnt - 1, this__6809.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6825 = cljs.core.seq.call(null, keyvals);
    var out__6826 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6825)) {
        var G__6827 = cljs.core.nnext.call(null, in$__6825);
        var G__6828 = cljs.core.assoc_BANG_.call(null, out__6826, cljs.core.first.call(null, in$__6825), cljs.core.second.call(null, in$__6825));
        in$__6825 = G__6827;
        out__6826 = G__6828;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6826)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6829) {
    var keyvals = cljs.core.seq(arglist__6829);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6830) {
    var keyvals = cljs.core.seq(arglist__6830);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6831 = cljs.core.seq.call(null, keyvals);
    var out__6832 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6831)) {
        var G__6833 = cljs.core.nnext.call(null, in$__6831);
        var G__6834 = cljs.core.assoc.call(null, out__6832, cljs.core.first.call(null, in$__6831), cljs.core.second.call(null, in$__6831));
        in$__6831 = G__6833;
        out__6832 = G__6834;
        continue
      }else {
        return out__6832
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6835) {
    var keyvals = cljs.core.seq(arglist__6835);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6836 = cljs.core.seq.call(null, keyvals);
    var out__6837 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6836)) {
        var G__6838 = cljs.core.nnext.call(null, in$__6836);
        var G__6839 = cljs.core.assoc.call(null, out__6837, cljs.core.first.call(null, in$__6836), cljs.core.second.call(null, in$__6836));
        in$__6836 = G__6838;
        out__6837 = G__6839;
        continue
      }else {
        return out__6837
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6840) {
    var comparator = cljs.core.first(arglist__6840);
    var keyvals = cljs.core.rest(arglist__6840);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6841_SHARP_, p2__6842_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6843 = p1__6841_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6843)) {
            return or__3548__auto____6843
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6842_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6844) {
    var maps = cljs.core.seq(arglist__6844);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6847 = function(m, e) {
        var k__6845 = cljs.core.first.call(null, e);
        var v__6846 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6845)) {
          return cljs.core.assoc.call(null, m, k__6845, f.call(null, cljs.core.get.call(null, m, k__6845), v__6846))
        }else {
          return cljs.core.assoc.call(null, m, k__6845, v__6846)
        }
      };
      var merge2__6849 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6847, function() {
          var or__3548__auto____6848 = m1;
          if(cljs.core.truth_(or__3548__auto____6848)) {
            return or__3548__auto____6848
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6849, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6850) {
    var f = cljs.core.first(arglist__6850);
    var maps = cljs.core.rest(arglist__6850);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6851 = cljs.core.ObjMap.fromObject([], {});
  var keys__6852 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6852)) {
      var key__6853 = cljs.core.first.call(null, keys__6852);
      var entry__6854 = cljs.core.get.call(null, map, key__6853, "\ufdd0'user/not-found");
      var G__6855 = cljs.core.not_EQ_.call(null, entry__6854, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6851, key__6853, entry__6854) : ret__6851;
      var G__6856 = cljs.core.next.call(null, keys__6852);
      ret__6851 = G__6855;
      keys__6852 = G__6856;
      continue
    }else {
      return ret__6851
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6862 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6862.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6863 = this;
  var h__364__auto____6864 = this__6863.__hash;
  if(h__364__auto____6864 != null) {
    return h__364__auto____6864
  }else {
    var h__364__auto____6865 = cljs.core.hash_iset.call(null, coll);
    this__6863.__hash = h__364__auto____6865;
    return h__364__auto____6865
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6866 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6867 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6867.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6886 = null;
  var G__6886__2 = function(tsym6860, k) {
    var this__6868 = this;
    var tsym6860__6869 = this;
    var coll__6870 = tsym6860__6869;
    return cljs.core._lookup.call(null, coll__6870, k)
  };
  var G__6886__3 = function(tsym6861, k, not_found) {
    var this__6871 = this;
    var tsym6861__6872 = this;
    var coll__6873 = tsym6861__6872;
    return cljs.core._lookup.call(null, coll__6873, k, not_found)
  };
  G__6886 = function(tsym6861, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6886__2.call(this, tsym6861, k);
      case 3:
        return G__6886__3.call(this, tsym6861, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6886
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6858, args6859) {
  return tsym6858.call.apply(tsym6858, [tsym6858].concat(cljs.core.aclone.call(null, args6859)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6874 = this;
  return new cljs.core.PersistentHashSet(this__6874.meta, cljs.core.assoc.call(null, this__6874.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6875 = this;
  var this$__6876 = this;
  return cljs.core.pr_str.call(null, this$__6876)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6877 = this;
  return cljs.core.keys.call(null, this__6877.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6878 = this;
  return new cljs.core.PersistentHashSet(this__6878.meta, cljs.core.dissoc.call(null, this__6878.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6879 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6880 = this;
  var and__3546__auto____6881 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6881) {
    var and__3546__auto____6882 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6882) {
      return cljs.core.every_QMARK_.call(null, function(p1__6857_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6857_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6882
    }
  }else {
    return and__3546__auto____6881
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6883 = this;
  return new cljs.core.PersistentHashSet(meta, this__6883.hash_map, this__6883.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6884 = this;
  return this__6884.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6885 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6885.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6904 = null;
  var G__6904__2 = function(tsym6890, k) {
    var this__6892 = this;
    var tsym6890__6893 = this;
    var tcoll__6894 = tsym6890__6893;
    if(cljs.core._lookup.call(null, this__6892.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6904__3 = function(tsym6891, k, not_found) {
    var this__6895 = this;
    var tsym6891__6896 = this;
    var tcoll__6897 = tsym6891__6896;
    if(cljs.core._lookup.call(null, this__6895.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6904 = function(tsym6891, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6904__2.call(this, tsym6891, k);
      case 3:
        return G__6904__3.call(this, tsym6891, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6904
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6888, args6889) {
  return tsym6888.call.apply(tsym6888, [tsym6888].concat(cljs.core.aclone.call(null, args6889)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6898 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6899 = this;
  if(cljs.core._lookup.call(null, this__6899.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6900 = this;
  return cljs.core.count.call(null, this__6900.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6901 = this;
  this__6901.transient_map = cljs.core.dissoc_BANG_.call(null, this__6901.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6902 = this;
  this__6902.transient_map = cljs.core.assoc_BANG_.call(null, this__6902.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6903 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6903.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6909 = this;
  var h__364__auto____6910 = this__6909.__hash;
  if(h__364__auto____6910 != null) {
    return h__364__auto____6910
  }else {
    var h__364__auto____6911 = cljs.core.hash_iset.call(null, coll);
    this__6909.__hash = h__364__auto____6911;
    return h__364__auto____6911
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6912 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6913 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6913.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6937 = null;
  var G__6937__2 = function(tsym6907, k) {
    var this__6914 = this;
    var tsym6907__6915 = this;
    var coll__6916 = tsym6907__6915;
    return cljs.core._lookup.call(null, coll__6916, k)
  };
  var G__6937__3 = function(tsym6908, k, not_found) {
    var this__6917 = this;
    var tsym6908__6918 = this;
    var coll__6919 = tsym6908__6918;
    return cljs.core._lookup.call(null, coll__6919, k, not_found)
  };
  G__6937 = function(tsym6908, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6937__2.call(this, tsym6908, k);
      case 3:
        return G__6937__3.call(this, tsym6908, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6937
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6905, args6906) {
  return tsym6905.call.apply(tsym6905, [tsym6905].concat(cljs.core.aclone.call(null, args6906)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6920 = this;
  return new cljs.core.PersistentTreeSet(this__6920.meta, cljs.core.assoc.call(null, this__6920.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6921 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6921.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6922 = this;
  var this$__6923 = this;
  return cljs.core.pr_str.call(null, this$__6923)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6924 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6924.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6925 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6925.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6926 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6927 = this;
  return cljs.core._comparator.call(null, this__6927.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6928 = this;
  return cljs.core.keys.call(null, this__6928.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6929 = this;
  return new cljs.core.PersistentTreeSet(this__6929.meta, cljs.core.dissoc.call(null, this__6929.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6930 = this;
  return cljs.core.count.call(null, this__6930.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6931 = this;
  var and__3546__auto____6932 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6932) {
    var and__3546__auto____6933 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6933) {
      return cljs.core.every_QMARK_.call(null, function(p1__6887_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6887_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6933
    }
  }else {
    return and__3546__auto____6932
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6934 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6934.tree_map, this__6934.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6935 = this;
  return this__6935.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6936 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6936.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6938 = cljs.core.seq.call(null, coll);
  var out__6939 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6938))) {
      var G__6940 = cljs.core.next.call(null, in$__6938);
      var G__6941 = cljs.core.conj_BANG_.call(null, out__6939, cljs.core.first.call(null, in$__6938));
      in$__6938 = G__6940;
      out__6939 = G__6941;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6939)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6942) {
    var keys = cljs.core.seq(arglist__6942);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6944) {
    var comparator = cljs.core.first(arglist__6944);
    var keys = cljs.core.rest(arglist__6944);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6945 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6946 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6946)) {
        var e__6947 = temp__3695__auto____6946;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6947))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6945, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6943_SHARP_) {
      var temp__3695__auto____6948 = cljs.core.find.call(null, smap, p1__6943_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6948)) {
        var e__6949 = temp__3695__auto____6948;
        return cljs.core.second.call(null, e__6949)
      }else {
        return p1__6943_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6957 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6950, seen) {
        while(true) {
          var vec__6951__6952 = p__6950;
          var f__6953 = cljs.core.nth.call(null, vec__6951__6952, 0, null);
          var xs__6954 = vec__6951__6952;
          var temp__3698__auto____6955 = cljs.core.seq.call(null, xs__6954);
          if(cljs.core.truth_(temp__3698__auto____6955)) {
            var s__6956 = temp__3698__auto____6955;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6953)) {
              var G__6958 = cljs.core.rest.call(null, s__6956);
              var G__6959 = seen;
              p__6950 = G__6958;
              seen = G__6959;
              continue
            }else {
              return cljs.core.cons.call(null, f__6953, step.call(null, cljs.core.rest.call(null, s__6956), cljs.core.conj.call(null, seen, f__6953)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6957.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6960 = cljs.core.PersistentVector.fromArray([]);
  var s__6961 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6961))) {
      var G__6962 = cljs.core.conj.call(null, ret__6960, cljs.core.first.call(null, s__6961));
      var G__6963 = cljs.core.next.call(null, s__6961);
      ret__6960 = G__6962;
      s__6961 = G__6963;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6960)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6964 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6964) {
        return or__3548__auto____6964
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6965 = x.lastIndexOf("/");
      if(i__6965 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6965 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6966 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6966) {
      return or__3548__auto____6966
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6967 = x.lastIndexOf("/");
    if(i__6967 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6967)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6970 = cljs.core.ObjMap.fromObject([], {});
  var ks__6971 = cljs.core.seq.call(null, keys);
  var vs__6972 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6973 = ks__6971;
      if(cljs.core.truth_(and__3546__auto____6973)) {
        return vs__6972
      }else {
        return and__3546__auto____6973
      }
    }())) {
      var G__6974 = cljs.core.assoc.call(null, map__6970, cljs.core.first.call(null, ks__6971), cljs.core.first.call(null, vs__6972));
      var G__6975 = cljs.core.next.call(null, ks__6971);
      var G__6976 = cljs.core.next.call(null, vs__6972);
      map__6970 = G__6974;
      ks__6971 = G__6975;
      vs__6972 = G__6976;
      continue
    }else {
      return map__6970
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6979__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6968_SHARP_, p2__6969_SHARP_) {
        return max_key.call(null, k, p1__6968_SHARP_, p2__6969_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6979 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6979__delegate.call(this, k, x, y, more)
    };
    G__6979.cljs$lang$maxFixedArity = 3;
    G__6979.cljs$lang$applyTo = function(arglist__6980) {
      var k = cljs.core.first(arglist__6980);
      var x = cljs.core.first(cljs.core.next(arglist__6980));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6980)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6980)));
      return G__6979__delegate(k, x, y, more)
    };
    G__6979.cljs$lang$arity$variadic = G__6979__delegate;
    return G__6979
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6981__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6977_SHARP_, p2__6978_SHARP_) {
        return min_key.call(null, k, p1__6977_SHARP_, p2__6978_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6981 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6981__delegate.call(this, k, x, y, more)
    };
    G__6981.cljs$lang$maxFixedArity = 3;
    G__6981.cljs$lang$applyTo = function(arglist__6982) {
      var k = cljs.core.first(arglist__6982);
      var x = cljs.core.first(cljs.core.next(arglist__6982));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6982)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6982)));
      return G__6981__delegate(k, x, y, more)
    };
    G__6981.cljs$lang$arity$variadic = G__6981__delegate;
    return G__6981
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6983 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6983)) {
        var s__6984 = temp__3698__auto____6983;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6984), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6984)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6985 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6985)) {
      var s__6986 = temp__3698__auto____6985;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6986)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6986), take_while.call(null, pred, cljs.core.rest.call(null, s__6986)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6987 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6987.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6988 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6989 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6989)) {
        var vec__6990__6991 = temp__3698__auto____6989;
        var e__6992 = cljs.core.nth.call(null, vec__6990__6991, 0, null);
        var s__6993 = vec__6990__6991;
        if(cljs.core.truth_(include__6988.call(null, e__6992))) {
          return s__6993
        }else {
          return cljs.core.next.call(null, s__6993)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6988, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6994 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6994)) {
      var vec__6995__6996 = temp__3698__auto____6994;
      var e__6997 = cljs.core.nth.call(null, vec__6995__6996, 0, null);
      var s__6998 = vec__6995__6996;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__6997)) ? s__6998 : cljs.core.next.call(null, s__6998))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__6999 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____7000 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____7000)) {
        var vec__7001__7002 = temp__3698__auto____7000;
        var e__7003 = cljs.core.nth.call(null, vec__7001__7002, 0, null);
        var s__7004 = vec__7001__7002;
        if(cljs.core.truth_(include__6999.call(null, e__7003))) {
          return s__7004
        }else {
          return cljs.core.next.call(null, s__7004)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6999, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7005 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____7005)) {
      var vec__7006__7007 = temp__3698__auto____7005;
      var e__7008 = cljs.core.nth.call(null, vec__7006__7007, 0, null);
      var s__7009 = vec__7006__7007;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__7008)) ? s__7009 : cljs.core.next.call(null, s__7009))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__7010 = this;
  var h__364__auto____7011 = this__7010.__hash;
  if(h__364__auto____7011 != null) {
    return h__364__auto____7011
  }else {
    var h__364__auto____7012 = cljs.core.hash_coll.call(null, rng);
    this__7010.__hash = h__364__auto____7012;
    return h__364__auto____7012
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__7013 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__7014 = this;
  var this$__7015 = this;
  return cljs.core.pr_str.call(null, this$__7015)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__7016 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__7017 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__7018 = this;
  var comp__7019 = this__7018.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__7019.call(null, this__7018.start, this__7018.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__7020 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__7020.end - this__7020.start) / this__7020.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__7021 = this;
  return this__7021.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__7022 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__7022.meta, this__7022.start + this__7022.step, this__7022.end, this__7022.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__7023 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__7024 = this;
  return new cljs.core.Range(meta, this__7024.start, this__7024.end, this__7024.step, this__7024.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__7025 = this;
  return this__7025.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__7026 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7026.start + n * this__7026.step
  }else {
    if(function() {
      var and__3546__auto____7027 = this__7026.start > this__7026.end;
      if(and__3546__auto____7027) {
        return this__7026.step === 0
      }else {
        return and__3546__auto____7027
      }
    }()) {
      return this__7026.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__7028 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7028.start + n * this__7028.step
  }else {
    if(function() {
      var and__3546__auto____7029 = this__7028.start > this__7028.end;
      if(and__3546__auto____7029) {
        return this__7028.step === 0
      }else {
        return and__3546__auto____7029
      }
    }()) {
      return this__7028.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__7030 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7030.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7031 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7031)) {
      var s__7032 = temp__3698__auto____7031;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__7032), take_nth.call(null, n, cljs.core.drop.call(null, n, s__7032)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7034 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7034)) {
      var s__7035 = temp__3698__auto____7034;
      var fst__7036 = cljs.core.first.call(null, s__7035);
      var fv__7037 = f.call(null, fst__7036);
      var run__7038 = cljs.core.cons.call(null, fst__7036, cljs.core.take_while.call(null, function(p1__7033_SHARP_) {
        return cljs.core._EQ_.call(null, fv__7037, f.call(null, p1__7033_SHARP_))
      }, cljs.core.next.call(null, s__7035)));
      return cljs.core.cons.call(null, run__7038, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__7038), s__7035))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____7049 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____7049)) {
        var s__7050 = temp__3695__auto____7049;
        return reductions.call(null, f, cljs.core.first.call(null, s__7050), cljs.core.rest.call(null, s__7050))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____7051 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____7051)) {
        var s__7052 = temp__3698__auto____7051;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__7052)), cljs.core.rest.call(null, s__7052))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__7054 = null;
      var G__7054__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__7054__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__7054__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__7054__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__7054__4 = function() {
        var G__7055__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__7055 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7055__delegate.call(this, x, y, z, args)
        };
        G__7055.cljs$lang$maxFixedArity = 3;
        G__7055.cljs$lang$applyTo = function(arglist__7056) {
          var x = cljs.core.first(arglist__7056);
          var y = cljs.core.first(cljs.core.next(arglist__7056));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7056)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7056)));
          return G__7055__delegate(x, y, z, args)
        };
        G__7055.cljs$lang$arity$variadic = G__7055__delegate;
        return G__7055
      }();
      G__7054 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7054__0.call(this);
          case 1:
            return G__7054__1.call(this, x);
          case 2:
            return G__7054__2.call(this, x, y);
          case 3:
            return G__7054__3.call(this, x, y, z);
          default:
            return G__7054__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7054.cljs$lang$maxFixedArity = 3;
      G__7054.cljs$lang$applyTo = G__7054__4.cljs$lang$applyTo;
      return G__7054
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__7057 = null;
      var G__7057__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__7057__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__7057__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__7057__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__7057__4 = function() {
        var G__7058__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__7058 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7058__delegate.call(this, x, y, z, args)
        };
        G__7058.cljs$lang$maxFixedArity = 3;
        G__7058.cljs$lang$applyTo = function(arglist__7059) {
          var x = cljs.core.first(arglist__7059);
          var y = cljs.core.first(cljs.core.next(arglist__7059));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7059)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7059)));
          return G__7058__delegate(x, y, z, args)
        };
        G__7058.cljs$lang$arity$variadic = G__7058__delegate;
        return G__7058
      }();
      G__7057 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7057__0.call(this);
          case 1:
            return G__7057__1.call(this, x);
          case 2:
            return G__7057__2.call(this, x, y);
          case 3:
            return G__7057__3.call(this, x, y, z);
          default:
            return G__7057__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7057.cljs$lang$maxFixedArity = 3;
      G__7057.cljs$lang$applyTo = G__7057__4.cljs$lang$applyTo;
      return G__7057
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__7060 = null;
      var G__7060__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__7060__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__7060__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__7060__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__7060__4 = function() {
        var G__7061__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__7061 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7061__delegate.call(this, x, y, z, args)
        };
        G__7061.cljs$lang$maxFixedArity = 3;
        G__7061.cljs$lang$applyTo = function(arglist__7062) {
          var x = cljs.core.first(arglist__7062);
          var y = cljs.core.first(cljs.core.next(arglist__7062));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7062)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7062)));
          return G__7061__delegate(x, y, z, args)
        };
        G__7061.cljs$lang$arity$variadic = G__7061__delegate;
        return G__7061
      }();
      G__7060 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7060__0.call(this);
          case 1:
            return G__7060__1.call(this, x);
          case 2:
            return G__7060__2.call(this, x, y);
          case 3:
            return G__7060__3.call(this, x, y, z);
          default:
            return G__7060__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7060.cljs$lang$maxFixedArity = 3;
      G__7060.cljs$lang$applyTo = G__7060__4.cljs$lang$applyTo;
      return G__7060
    }()
  };
  var juxt__4 = function() {
    var G__7063__delegate = function(f, g, h, fs) {
      var fs__7053 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__7064 = null;
        var G__7064__0 = function() {
          return cljs.core.reduce.call(null, function(p1__7039_SHARP_, p2__7040_SHARP_) {
            return cljs.core.conj.call(null, p1__7039_SHARP_, p2__7040_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__7053)
        };
        var G__7064__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__7041_SHARP_, p2__7042_SHARP_) {
            return cljs.core.conj.call(null, p1__7041_SHARP_, p2__7042_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__7053)
        };
        var G__7064__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__7043_SHARP_, p2__7044_SHARP_) {
            return cljs.core.conj.call(null, p1__7043_SHARP_, p2__7044_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__7053)
        };
        var G__7064__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__7045_SHARP_, p2__7046_SHARP_) {
            return cljs.core.conj.call(null, p1__7045_SHARP_, p2__7046_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__7053)
        };
        var G__7064__4 = function() {
          var G__7065__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__7047_SHARP_, p2__7048_SHARP_) {
              return cljs.core.conj.call(null, p1__7047_SHARP_, cljs.core.apply.call(null, p2__7048_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__7053)
          };
          var G__7065 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__7065__delegate.call(this, x, y, z, args)
          };
          G__7065.cljs$lang$maxFixedArity = 3;
          G__7065.cljs$lang$applyTo = function(arglist__7066) {
            var x = cljs.core.first(arglist__7066);
            var y = cljs.core.first(cljs.core.next(arglist__7066));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7066)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7066)));
            return G__7065__delegate(x, y, z, args)
          };
          G__7065.cljs$lang$arity$variadic = G__7065__delegate;
          return G__7065
        }();
        G__7064 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__7064__0.call(this);
            case 1:
              return G__7064__1.call(this, x);
            case 2:
              return G__7064__2.call(this, x, y);
            case 3:
              return G__7064__3.call(this, x, y, z);
            default:
              return G__7064__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__7064.cljs$lang$maxFixedArity = 3;
        G__7064.cljs$lang$applyTo = G__7064__4.cljs$lang$applyTo;
        return G__7064
      }()
    };
    var G__7063 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7063__delegate.call(this, f, g, h, fs)
    };
    G__7063.cljs$lang$maxFixedArity = 3;
    G__7063.cljs$lang$applyTo = function(arglist__7067) {
      var f = cljs.core.first(arglist__7067);
      var g = cljs.core.first(cljs.core.next(arglist__7067));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7067)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7067)));
      return G__7063__delegate(f, g, h, fs)
    };
    G__7063.cljs$lang$arity$variadic = G__7063__delegate;
    return G__7063
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__7069 = cljs.core.next.call(null, coll);
        coll = G__7069;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____7068 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____7068)) {
          return n > 0
        }else {
          return and__3546__auto____7068
        }
      }())) {
        var G__7070 = n - 1;
        var G__7071 = cljs.core.next.call(null, coll);
        n = G__7070;
        coll = G__7071;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__7072 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__7072), s)) {
    if(cljs.core.count.call(null, matches__7072) === 1) {
      return cljs.core.first.call(null, matches__7072)
    }else {
      return cljs.core.vec.call(null, matches__7072)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__7073 = re.exec(s);
  if(matches__7073 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__7073) === 1) {
      return cljs.core.first.call(null, matches__7073)
    }else {
      return cljs.core.vec.call(null, matches__7073)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__7074 = cljs.core.re_find.call(null, re, s);
  var match_idx__7075 = s.search(re);
  var match_str__7076 = cljs.core.coll_QMARK_.call(null, match_data__7074) ? cljs.core.first.call(null, match_data__7074) : match_data__7074;
  var post_match__7077 = cljs.core.subs.call(null, s, match_idx__7075 + cljs.core.count.call(null, match_str__7076));
  if(cljs.core.truth_(match_data__7074)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__7074, re_seq.call(null, re, post_match__7077))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__7079__7080 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___7081 = cljs.core.nth.call(null, vec__7079__7080, 0, null);
  var flags__7082 = cljs.core.nth.call(null, vec__7079__7080, 1, null);
  var pattern__7083 = cljs.core.nth.call(null, vec__7079__7080, 2, null);
  return new RegExp(pattern__7083, flags__7082)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__7078_SHARP_) {
    return print_one.call(null, p1__7078_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____7084 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____7084)) {
            var and__3546__auto____7088 = function() {
              var G__7085__7086 = obj;
              if(G__7085__7086 != null) {
                if(function() {
                  var or__3548__auto____7087 = G__7085__7086.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____7087) {
                    return or__3548__auto____7087
                  }else {
                    return G__7085__7086.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__7085__7086.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7085__7086)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7085__7086)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____7088)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____7088
            }
          }else {
            return and__3546__auto____7084
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____7089 = obj != null;
          if(and__3546__auto____7089) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____7089
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__7090__7091 = obj;
          if(G__7090__7091 != null) {
            if(function() {
              var or__3548__auto____7092 = G__7090__7091.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____7092) {
                return or__3548__auto____7092
              }else {
                return G__7090__7091.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__7090__7091.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7090__7091)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7090__7091)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__7093 = cljs.core.first.call(null, objs);
  var sb__7094 = new goog.string.StringBuffer;
  var G__7095__7096 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7095__7096)) {
    var obj__7097 = cljs.core.first.call(null, G__7095__7096);
    var G__7095__7098 = G__7095__7096;
    while(true) {
      if(obj__7097 === first_obj__7093) {
      }else {
        sb__7094.append(" ")
      }
      var G__7099__7100 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7097, opts));
      if(cljs.core.truth_(G__7099__7100)) {
        var string__7101 = cljs.core.first.call(null, G__7099__7100);
        var G__7099__7102 = G__7099__7100;
        while(true) {
          sb__7094.append(string__7101);
          var temp__3698__auto____7103 = cljs.core.next.call(null, G__7099__7102);
          if(cljs.core.truth_(temp__3698__auto____7103)) {
            var G__7099__7104 = temp__3698__auto____7103;
            var G__7107 = cljs.core.first.call(null, G__7099__7104);
            var G__7108 = G__7099__7104;
            string__7101 = G__7107;
            G__7099__7102 = G__7108;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7105 = cljs.core.next.call(null, G__7095__7098);
      if(cljs.core.truth_(temp__3698__auto____7105)) {
        var G__7095__7106 = temp__3698__auto____7105;
        var G__7109 = cljs.core.first.call(null, G__7095__7106);
        var G__7110 = G__7095__7106;
        obj__7097 = G__7109;
        G__7095__7098 = G__7110;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__7094
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__7111 = cljs.core.pr_sb.call(null, objs, opts);
  sb__7111.append("\n");
  return[cljs.core.str(sb__7111)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__7112 = cljs.core.first.call(null, objs);
  var G__7113__7114 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7113__7114)) {
    var obj__7115 = cljs.core.first.call(null, G__7113__7114);
    var G__7113__7116 = G__7113__7114;
    while(true) {
      if(obj__7115 === first_obj__7112) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__7117__7118 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7115, opts));
      if(cljs.core.truth_(G__7117__7118)) {
        var string__7119 = cljs.core.first.call(null, G__7117__7118);
        var G__7117__7120 = G__7117__7118;
        while(true) {
          cljs.core.string_print.call(null, string__7119);
          var temp__3698__auto____7121 = cljs.core.next.call(null, G__7117__7120);
          if(cljs.core.truth_(temp__3698__auto____7121)) {
            var G__7117__7122 = temp__3698__auto____7121;
            var G__7125 = cljs.core.first.call(null, G__7117__7122);
            var G__7126 = G__7117__7122;
            string__7119 = G__7125;
            G__7117__7120 = G__7126;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7123 = cljs.core.next.call(null, G__7113__7116);
      if(cljs.core.truth_(temp__3698__auto____7123)) {
        var G__7113__7124 = temp__3698__auto____7123;
        var G__7127 = cljs.core.first.call(null, G__7113__7124);
        var G__7128 = G__7113__7124;
        obj__7115 = G__7127;
        G__7113__7116 = G__7128;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__7129) {
    var objs = cljs.core.seq(arglist__7129);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__7130) {
    var objs = cljs.core.seq(arglist__7130);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__7131) {
    var objs = cljs.core.seq(arglist__7131);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__7132) {
    var objs = cljs.core.seq(arglist__7132);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__7133) {
    var objs = cljs.core.seq(arglist__7133);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__7134) {
    var objs = cljs.core.seq(arglist__7134);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__7135) {
    var objs = cljs.core.seq(arglist__7135);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__7136) {
    var objs = cljs.core.seq(arglist__7136);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7137 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7137, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7138 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7138, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7139 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7139, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____7140 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____7140)) {
        var nspc__7141 = temp__3698__auto____7140;
        return[cljs.core.str(nspc__7141), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____7142 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____7142)) {
          var nspc__7143 = temp__3698__auto____7142;
          return[cljs.core.str(nspc__7143), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7144 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7144, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7145 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7145, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7146 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__7147 = this;
  var G__7148__7149 = cljs.core.seq.call(null, this__7147.watches);
  if(cljs.core.truth_(G__7148__7149)) {
    var G__7151__7153 = cljs.core.first.call(null, G__7148__7149);
    var vec__7152__7154 = G__7151__7153;
    var key__7155 = cljs.core.nth.call(null, vec__7152__7154, 0, null);
    var f__7156 = cljs.core.nth.call(null, vec__7152__7154, 1, null);
    var G__7148__7157 = G__7148__7149;
    var G__7151__7158 = G__7151__7153;
    var G__7148__7159 = G__7148__7157;
    while(true) {
      var vec__7160__7161 = G__7151__7158;
      var key__7162 = cljs.core.nth.call(null, vec__7160__7161, 0, null);
      var f__7163 = cljs.core.nth.call(null, vec__7160__7161, 1, null);
      var G__7148__7164 = G__7148__7159;
      f__7163.call(null, key__7162, this$, oldval, newval);
      var temp__3698__auto____7165 = cljs.core.next.call(null, G__7148__7164);
      if(cljs.core.truth_(temp__3698__auto____7165)) {
        var G__7148__7166 = temp__3698__auto____7165;
        var G__7173 = cljs.core.first.call(null, G__7148__7166);
        var G__7174 = G__7148__7166;
        G__7151__7158 = G__7173;
        G__7148__7159 = G__7174;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__7167 = this;
  return this$.watches = cljs.core.assoc.call(null, this__7167.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__7168 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__7168.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__7169 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__7169.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__7170 = this;
  return this__7170.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7171 = this;
  return this__7171.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__7172 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7181__delegate = function(x, p__7175) {
      var map__7176__7177 = p__7175;
      var map__7176__7178 = cljs.core.seq_QMARK_.call(null, map__7176__7177) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7176__7177) : map__7176__7177;
      var validator__7179 = cljs.core.get.call(null, map__7176__7178, "\ufdd0'validator");
      var meta__7180 = cljs.core.get.call(null, map__7176__7178, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7180, validator__7179, null)
    };
    var G__7181 = function(x, var_args) {
      var p__7175 = null;
      if(goog.isDef(var_args)) {
        p__7175 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7181__delegate.call(this, x, p__7175)
    };
    G__7181.cljs$lang$maxFixedArity = 1;
    G__7181.cljs$lang$applyTo = function(arglist__7182) {
      var x = cljs.core.first(arglist__7182);
      var p__7175 = cljs.core.rest(arglist__7182);
      return G__7181__delegate(x, p__7175)
    };
    G__7181.cljs$lang$arity$variadic = G__7181__delegate;
    return G__7181
  }();
  atom = function(x, var_args) {
    var p__7175 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7183 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7183)) {
    var validate__7184 = temp__3698__auto____7183;
    if(cljs.core.truth_(validate__7184.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7185 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7185, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7186__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7186 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7186__delegate.call(this, a, f, x, y, z, more)
    };
    G__7186.cljs$lang$maxFixedArity = 5;
    G__7186.cljs$lang$applyTo = function(arglist__7187) {
      var a = cljs.core.first(arglist__7187);
      var f = cljs.core.first(cljs.core.next(arglist__7187));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7187)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7187))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7187)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7187)))));
      return G__7186__delegate(a, f, x, y, z, more)
    };
    G__7186.cljs$lang$arity$variadic = G__7186__delegate;
    return G__7186
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7188) {
    var iref = cljs.core.first(arglist__7188);
    var f = cljs.core.first(cljs.core.next(arglist__7188));
    var args = cljs.core.rest(cljs.core.next(arglist__7188));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7189 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7189.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7190 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7190.state, function(p__7191) {
    var curr_state__7192 = p__7191;
    var curr_state__7193 = cljs.core.seq_QMARK_.call(null, curr_state__7192) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7192) : curr_state__7192;
    var done__7194 = cljs.core.get.call(null, curr_state__7193, "\ufdd0'done");
    if(cljs.core.truth_(done__7194)) {
      return curr_state__7193
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7190.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7195__7196 = options;
    var map__7195__7197 = cljs.core.seq_QMARK_.call(null, map__7195__7196) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7195__7196) : map__7195__7196;
    var keywordize_keys__7198 = cljs.core.get.call(null, map__7195__7197, "\ufdd0'keywordize-keys");
    var keyfn__7199 = cljs.core.truth_(keywordize_keys__7198) ? cljs.core.keyword : cljs.core.str;
    var f__7205 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7204 = function iter__7200(s__7201) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7201__7202 = s__7201;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7201__7202))) {
                        var k__7203 = cljs.core.first.call(null, s__7201__7202);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7199.call(null, k__7203), thisfn.call(null, x[k__7203])]), iter__7200.call(null, cljs.core.rest.call(null, s__7201__7202)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7204.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7205.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7206) {
    var x = cljs.core.first(arglist__7206);
    var options = cljs.core.rest(arglist__7206);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7207 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7211__delegate = function(args) {
      var temp__3695__auto____7208 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7207), args);
      if(cljs.core.truth_(temp__3695__auto____7208)) {
        var v__7209 = temp__3695__auto____7208;
        return v__7209
      }else {
        var ret__7210 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7207, cljs.core.assoc, args, ret__7210);
        return ret__7210
      }
    };
    var G__7211 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7211__delegate.call(this, args)
    };
    G__7211.cljs$lang$maxFixedArity = 0;
    G__7211.cljs$lang$applyTo = function(arglist__7212) {
      var args = cljs.core.seq(arglist__7212);
      return G__7211__delegate(args)
    };
    G__7211.cljs$lang$arity$variadic = G__7211__delegate;
    return G__7211
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7213 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7213)) {
        var G__7214 = ret__7213;
        f = G__7214;
        continue
      }else {
        return ret__7213
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7215__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7215 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7215__delegate.call(this, f, args)
    };
    G__7215.cljs$lang$maxFixedArity = 1;
    G__7215.cljs$lang$applyTo = function(arglist__7216) {
      var f = cljs.core.first(arglist__7216);
      var args = cljs.core.rest(arglist__7216);
      return G__7215__delegate(f, args)
    };
    G__7215.cljs$lang$arity$variadic = G__7215__delegate;
    return G__7215
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7217 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7217, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7217, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7218 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7218) {
      return or__3548__auto____7218
    }else {
      var or__3548__auto____7219 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7219) {
        return or__3548__auto____7219
      }else {
        var and__3546__auto____7220 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7220) {
          var and__3546__auto____7221 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7221) {
            var and__3546__auto____7222 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7222) {
              var ret__7223 = true;
              var i__7224 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7225 = cljs.core.not.call(null, ret__7223);
                  if(or__3548__auto____7225) {
                    return or__3548__auto____7225
                  }else {
                    return i__7224 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7223
                }else {
                  var G__7226 = isa_QMARK_.call(null, h, child.call(null, i__7224), parent.call(null, i__7224));
                  var G__7227 = i__7224 + 1;
                  ret__7223 = G__7226;
                  i__7224 = G__7227;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7222
            }
          }else {
            return and__3546__auto____7221
          }
        }else {
          return and__3546__auto____7220
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7231 = "\ufdd0'parents".call(null, h);
    var td__7232 = "\ufdd0'descendants".call(null, h);
    var ta__7233 = "\ufdd0'ancestors".call(null, h);
    var tf__7234 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7235 = cljs.core.contains_QMARK_.call(null, tp__7231.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7233.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7233.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7231, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7234.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7232, parent, ta__7233), "\ufdd0'descendants":tf__7234.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7233, tag, td__7232)})
    }();
    if(cljs.core.truth_(or__3548__auto____7235)) {
      return or__3548__auto____7235
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7236 = "\ufdd0'parents".call(null, h);
    var childsParents__7237 = cljs.core.truth_(parentMap__7236.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7236.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7238 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7237)) ? cljs.core.assoc.call(null, parentMap__7236, tag, childsParents__7237) : cljs.core.dissoc.call(null, parentMap__7236, tag);
    var deriv_seq__7239 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7228_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7228_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7228_SHARP_), cljs.core.second.call(null, p1__7228_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7238)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7236.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7229_SHARP_, p2__7230_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7229_SHARP_, p2__7230_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7239))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7240 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7242 = cljs.core.truth_(function() {
    var and__3546__auto____7241 = xprefs__7240;
    if(cljs.core.truth_(and__3546__auto____7241)) {
      return xprefs__7240.call(null, y)
    }else {
      return and__3546__auto____7241
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7242)) {
    return or__3548__auto____7242
  }else {
    var or__3548__auto____7244 = function() {
      var ps__7243 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7243) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7243), prefer_table))) {
          }else {
          }
          var G__7247 = cljs.core.rest.call(null, ps__7243);
          ps__7243 = G__7247;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7244)) {
      return or__3548__auto____7244
    }else {
      var or__3548__auto____7246 = function() {
        var ps__7245 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7245) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7245), y, prefer_table))) {
            }else {
            }
            var G__7248 = cljs.core.rest.call(null, ps__7245);
            ps__7245 = G__7248;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7246)) {
        return or__3548__auto____7246
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7249 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7249)) {
    return or__3548__auto____7249
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7258 = cljs.core.reduce.call(null, function(be, p__7250) {
    var vec__7251__7252 = p__7250;
    var k__7253 = cljs.core.nth.call(null, vec__7251__7252, 0, null);
    var ___7254 = cljs.core.nth.call(null, vec__7251__7252, 1, null);
    var e__7255 = vec__7251__7252;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7253)) {
      var be2__7257 = cljs.core.truth_(function() {
        var or__3548__auto____7256 = be == null;
        if(or__3548__auto____7256) {
          return or__3548__auto____7256
        }else {
          return cljs.core.dominates.call(null, k__7253, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7255 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7257), k__7253, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7253), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7257)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7257
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7258)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7258));
      return cljs.core.second.call(null, best_entry__7258)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7259 = mf;
    if(and__3546__auto____7259) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7259
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7260 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7260) {
        return or__3548__auto____7260
      }else {
        var or__3548__auto____7261 = cljs.core._reset["_"];
        if(or__3548__auto____7261) {
          return or__3548__auto____7261
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7262 = mf;
    if(and__3546__auto____7262) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7262
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7263 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7263) {
        return or__3548__auto____7263
      }else {
        var or__3548__auto____7264 = cljs.core._add_method["_"];
        if(or__3548__auto____7264) {
          return or__3548__auto____7264
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7265 = mf;
    if(and__3546__auto____7265) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7265
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7266 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7266) {
        return or__3548__auto____7266
      }else {
        var or__3548__auto____7267 = cljs.core._remove_method["_"];
        if(or__3548__auto____7267) {
          return or__3548__auto____7267
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7268 = mf;
    if(and__3546__auto____7268) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7268
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7269 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7269) {
        return or__3548__auto____7269
      }else {
        var or__3548__auto____7270 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7270) {
          return or__3548__auto____7270
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7271 = mf;
    if(and__3546__auto____7271) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7271
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7272 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7272) {
        return or__3548__auto____7272
      }else {
        var or__3548__auto____7273 = cljs.core._get_method["_"];
        if(or__3548__auto____7273) {
          return or__3548__auto____7273
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7274 = mf;
    if(and__3546__auto____7274) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7274
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7275 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7275) {
        return or__3548__auto____7275
      }else {
        var or__3548__auto____7276 = cljs.core._methods["_"];
        if(or__3548__auto____7276) {
          return or__3548__auto____7276
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7277 = mf;
    if(and__3546__auto____7277) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7277
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7278 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7278) {
        return or__3548__auto____7278
      }else {
        var or__3548__auto____7279 = cljs.core._prefers["_"];
        if(or__3548__auto____7279) {
          return or__3548__auto____7279
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7280 = mf;
    if(and__3546__auto____7280) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7280
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7281 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7281) {
        return or__3548__auto____7281
      }else {
        var or__3548__auto____7282 = cljs.core._dispatch["_"];
        if(or__3548__auto____7282) {
          return or__3548__auto____7282
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7283 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7284 = cljs.core._get_method.call(null, mf, dispatch_val__7283);
  if(cljs.core.truth_(target_fn__7284)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7283)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7284, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7285 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7286 = this;
  cljs.core.swap_BANG_.call(null, this__7286.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7286.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7286.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7286.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7287 = this;
  cljs.core.swap_BANG_.call(null, this__7287.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7287.method_cache, this__7287.method_table, this__7287.cached_hierarchy, this__7287.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7288 = this;
  cljs.core.swap_BANG_.call(null, this__7288.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7288.method_cache, this__7288.method_table, this__7288.cached_hierarchy, this__7288.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7289 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7289.cached_hierarchy), cljs.core.deref.call(null, this__7289.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7289.method_cache, this__7289.method_table, this__7289.cached_hierarchy, this__7289.hierarchy)
  }
  var temp__3695__auto____7290 = cljs.core.deref.call(null, this__7289.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7290)) {
    var target_fn__7291 = temp__3695__auto____7290;
    return target_fn__7291
  }else {
    var temp__3695__auto____7292 = cljs.core.find_and_cache_best_method.call(null, this__7289.name, dispatch_val, this__7289.hierarchy, this__7289.method_table, this__7289.prefer_table, this__7289.method_cache, this__7289.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7292)) {
      var target_fn__7293 = temp__3695__auto____7292;
      return target_fn__7293
    }else {
      return cljs.core.deref.call(null, this__7289.method_table).call(null, this__7289.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7294 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7294.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7294.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7294.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7294.method_cache, this__7294.method_table, this__7294.cached_hierarchy, this__7294.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7295 = this;
  return cljs.core.deref.call(null, this__7295.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7296 = this;
  return cljs.core.deref.call(null, this__7296.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7297 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7297.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7298__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7298 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7298__delegate.call(this, _, args)
  };
  G__7298.cljs$lang$maxFixedArity = 1;
  G__7298.cljs$lang$applyTo = function(arglist__7299) {
    var _ = cljs.core.first(arglist__7299);
    var args = cljs.core.rest(arglist__7299);
    return G__7298__delegate(_, args)
  };
  G__7298.cljs$lang$arity$variadic = G__7298__delegate;
  return G__7298
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7461 = reader;
    if(and__3546__auto____7461) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7461
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7462 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7462) {
        return or__3548__auto____7462
      }else {
        var or__3548__auto____7463 = cljs.reader.read_char["_"];
        if(or__3548__auto____7463) {
          return or__3548__auto____7463
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7464 = reader;
    if(and__3546__auto____7464) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7464
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7465 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7465) {
        return or__3548__auto____7465
      }else {
        var or__3548__auto____7466 = cljs.reader.unread["_"];
        if(or__3548__auto____7466) {
          return or__3548__auto____7466
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7467 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7467.buffer_atom))) {
    var idx__7468 = cljs.core.deref.call(null, this__7467.index_atom);
    cljs.core.swap_BANG_.call(null, this__7467.index_atom, cljs.core.inc);
    return this__7467.s[idx__7468]
  }else {
    var buf__7469 = cljs.core.deref.call(null, this__7467.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7467.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7469)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7470 = this;
  return cljs.core.swap_BANG_.call(null, this__7470.buffer_atom, function(p1__7460_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7460_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7471 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7471)) {
    return or__3548__auto____7471
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7472 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7472) {
    return or__3548__auto____7472
  }else {
    var and__3546__auto____7474 = function() {
      var or__3548__auto____7473 = "+" === initch;
      if(or__3548__auto____7473) {
        return or__3548__auto____7473
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7474)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7475 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7475);
        return next_ch__7475
      }())
    }else {
      return and__3546__auto____7474
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7476) {
    var rdr = cljs.core.first(arglist__7476);
    var msg = cljs.core.rest(arglist__7476);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7477 = ch != "#";
  if(and__3546__auto____7477) {
    var and__3546__auto____7478 = ch != "'";
    if(and__3546__auto____7478) {
      var and__3546__auto____7479 = ch != ":";
      if(and__3546__auto____7479) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7479
      }
    }else {
      return and__3546__auto____7478
    }
  }else {
    return and__3546__auto____7477
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7480 = new goog.string.StringBuffer(initch);
  var ch__7481 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7482 = ch__7481 == null;
      if(or__3548__auto____7482) {
        return or__3548__auto____7482
      }else {
        var or__3548__auto____7483 = cljs.reader.whitespace_QMARK_.call(null, ch__7481);
        if(or__3548__auto____7483) {
          return or__3548__auto____7483
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7481)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7481);
      return sb__7480.toString()
    }else {
      var G__7484 = function() {
        sb__7480.append(ch__7481);
        return sb__7480
      }();
      var G__7485 = cljs.reader.read_char.call(null, rdr);
      sb__7480 = G__7484;
      ch__7481 = G__7485;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7486 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7487 = ch__7486 === "n";
      if(or__3548__auto____7487) {
        return or__3548__auto____7487
      }else {
        var or__3548__auto____7488 = ch__7486 === "r";
        if(or__3548__auto____7488) {
          return or__3548__auto____7488
        }else {
          return ch__7486 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7489 = re.exec(s);
  if(matches__7489 != null) {
    if(matches__7489.length === 1) {
      return matches__7489[0]
    }else {
      return matches__7489
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7490 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7491 = groups__7490[2];
  if(!function() {
    var or__3548__auto____7492 = group3__7491 == null;
    if(or__3548__auto____7492) {
      return or__3548__auto____7492
    }else {
      return group3__7491.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7493 = "-" === groups__7490[1] ? -1 : 1;
    var a__7494 = cljs.core.truth_(groups__7490[3]) ? [groups__7490[3], 10] : cljs.core.truth_(groups__7490[4]) ? [groups__7490[4], 16] : cljs.core.truth_(groups__7490[5]) ? [groups__7490[5], 8] : cljs.core.truth_(groups__7490[7]) ? [groups__7490[7], parseInt(groups__7490[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7495 = a__7494[0];
    var radix__7496 = a__7494[1];
    if(n__7495 == null) {
      return null
    }else {
      return negate__7493 * parseInt(n__7495, radix__7496)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7497 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7498 = groups__7497[1];
  var denominator__7499 = groups__7497[2];
  return parseInt(numinator__7498) / parseInt(denominator__7499)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7500 = re.exec(s);
  if(function() {
    var and__3546__auto____7501 = matches__7500 != null;
    if(and__3546__auto____7501) {
      return matches__7500[0] === s
    }else {
      return and__3546__auto____7501
    }
  }()) {
    if(matches__7500.length === 1) {
      return matches__7500[0]
    }else {
      return matches__7500
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7502 = cljs.reader.read_char.call(null, reader);
  var mapresult__7503 = cljs.reader.escape_char_map.call(null, ch__7502);
  if(cljs.core.truth_(mapresult__7503)) {
    return mapresult__7503
  }else {
    if(function() {
      var or__3548__auto____7504 = "u" === ch__7502;
      if(or__3548__auto____7504) {
        return or__3548__auto____7504
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7502)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7502)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7502)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7505 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7505))) {
      var G__7506 = cljs.reader.read_char.call(null, rdr);
      ch__7505 = G__7506;
      continue
    }else {
      return ch__7505
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7507 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7508 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7508)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7508) {
      return cljs.core.persistent_BANG_.call(null, a__7507)
    }else {
      var temp__3695__auto____7509 = cljs.reader.macros.call(null, ch__7508);
      if(cljs.core.truth_(temp__3695__auto____7509)) {
        var macrofn__7510 = temp__3695__auto____7509;
        var mret__7511 = macrofn__7510.call(null, rdr, ch__7508);
        var G__7513 = mret__7511 === rdr ? a__7507 : cljs.core.conj_BANG_.call(null, a__7507, mret__7511);
        a__7507 = G__7513;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7508);
        var o__7512 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7514 = o__7512 === rdr ? a__7507 : cljs.core.conj_BANG_.call(null, a__7507, o__7512);
        a__7507 = G__7514;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7515 = cljs.reader.read_char.call(null, rdr);
  var dm__7516 = cljs.reader.dispatch_macros.call(null, ch__7515);
  if(cljs.core.truth_(dm__7516)) {
    return dm__7516.call(null, rdr, _)
  }else {
    var temp__3695__auto____7517 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7515);
    if(cljs.core.truth_(temp__3695__auto____7517)) {
      var obj__7518 = temp__3695__auto____7517;
      return obj__7518
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7515)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7519 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7519))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7519)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7520 = new goog.string.StringBuffer(initch);
  var ch__7521 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7522 = ch__7521 == null;
      if(or__3548__auto____7522) {
        return or__3548__auto____7522
      }else {
        var or__3548__auto____7523 = cljs.reader.whitespace_QMARK_.call(null, ch__7521);
        if(or__3548__auto____7523) {
          return or__3548__auto____7523
        }else {
          return cljs.reader.macros.call(null, ch__7521)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7521);
      var s__7524 = buffer__7520.toString();
      var or__3548__auto____7525 = cljs.reader.match_number.call(null, s__7524);
      if(cljs.core.truth_(or__3548__auto____7525)) {
        return or__3548__auto____7525
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7524, "]")
      }
    }else {
      var G__7526 = function() {
        buffer__7520.append(ch__7521);
        return buffer__7520
      }();
      var G__7527 = cljs.reader.read_char.call(null, reader);
      buffer__7520 = G__7526;
      ch__7521 = G__7527;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7528 = new goog.string.StringBuffer;
  var ch__7529 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7529 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7529) {
        var G__7530 = function() {
          buffer__7528.append(cljs.reader.escape_char.call(null, buffer__7528, reader));
          return buffer__7528
        }();
        var G__7531 = cljs.reader.read_char.call(null, reader);
        buffer__7528 = G__7530;
        ch__7529 = G__7531;
        continue
      }else {
        if('"' === ch__7529) {
          return buffer__7528.toString()
        }else {
          if("\ufdd0'default") {
            var G__7532 = function() {
              buffer__7528.append(ch__7529);
              return buffer__7528
            }();
            var G__7533 = cljs.reader.read_char.call(null, reader);
            buffer__7528 = G__7532;
            ch__7529 = G__7533;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7534 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7534, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7534, 0, token__7534.indexOf("/")), cljs.core.subs.call(null, token__7534, token__7534.indexOf("/") + 1, token__7534.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7534, cljs.core.symbol.call(null, token__7534))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7535 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7536 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7535);
  var token__7537 = a__7536[0];
  var ns__7538 = a__7536[1];
  var name__7539 = a__7536[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7541 = function() {
      var and__3546__auto____7540 = !(void 0 === ns__7538);
      if(and__3546__auto____7540) {
        return ns__7538.substring(ns__7538.length - 2, ns__7538.length) === ":/"
      }else {
        return and__3546__auto____7540
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7541)) {
      return or__3548__auto____7541
    }else {
      var or__3548__auto____7542 = name__7539[name__7539.length - 1] === ":";
      if(or__3548__auto____7542) {
        return or__3548__auto____7542
      }else {
        return!(token__7537.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7537)
  }else {
    if(cljs.core.truth_(ns__7538)) {
      return cljs.core.keyword.call(null, ns__7538.substring(0, ns__7538.indexOf("/")), name__7539)
    }else {
      return cljs.core.keyword.call(null, token__7537)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7543 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7543)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7544 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7545__7546 = o__7544;
    if(G__7545__7546 != null) {
      if(function() {
        var or__3548__auto____7547 = G__7545__7546.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7547) {
          return or__3548__auto____7547
        }else {
          return G__7545__7546.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7545__7546.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7545__7546)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7545__7546)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7544, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7544), m__7543))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7548 = cljs.reader.read_char.call(null, reader);
    if(ch__7548 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7548)) {
        var G__7551 = reader;
        var G__7552 = eof_is_error;
        var G__7553 = sentinel;
        var G__7554 = is_recursive;
        reader = G__7551;
        eof_is_error = G__7552;
        sentinel = G__7553;
        is_recursive = G__7554;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7548)) {
          var G__7555 = cljs.reader.read_comment.call(null, reader, ch__7548);
          var G__7556 = eof_is_error;
          var G__7557 = sentinel;
          var G__7558 = is_recursive;
          reader = G__7555;
          eof_is_error = G__7556;
          sentinel = G__7557;
          is_recursive = G__7558;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7549 = cljs.reader.macros.call(null, ch__7548);
            var res__7550 = cljs.core.truth_(f__7549) ? f__7549.call(null, reader, ch__7548) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7548) ? cljs.reader.read_number.call(null, reader, ch__7548) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7548) : null;
            if(res__7550 === reader) {
              var G__7559 = reader;
              var G__7560 = eof_is_error;
              var G__7561 = sentinel;
              var G__7562 = is_recursive;
              reader = G__7559;
              eof_is_error = G__7560;
              sentinel = G__7561;
              is_recursive = G__7562;
              continue
            }else {
              return res__7550
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7563 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7563, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7564 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7565 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7566 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7564));
  if(cljs.core.truth_(pfn__7566)) {
    return pfn__7566.call(null, form__7565)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7564), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7567 = cljs.core.name.call(null, tag);
  var old_parser__7568 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7567);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7567, f);
  return old_parser__7568
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7437 = s;
      var limit__7438 = limit;
      var parts__7439 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7438, 1)) {
          return cljs.core.conj.call(null, parts__7439, s__7437)
        }else {
          var temp__3695__auto____7440 = cljs.core.re_find.call(null, re, s__7437);
          if(cljs.core.truth_(temp__3695__auto____7440)) {
            var m__7441 = temp__3695__auto____7440;
            var index__7442 = s__7437.indexOf(m__7441);
            var G__7443 = s__7437.substring(index__7442 + cljs.core.count.call(null, m__7441));
            var G__7444 = limit__7438 - 1;
            var G__7445 = cljs.core.conj.call(null, parts__7439, s__7437.substring(0, index__7442));
            s__7437 = G__7443;
            limit__7438 = G__7444;
            parts__7439 = G__7445;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7439, s__7437)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7446 = s.length;
  while(true) {
    if(index__7446 === 0) {
      return""
    }else {
      var ch__7447 = cljs.core.get.call(null, s, index__7446 - 1);
      if(function() {
        var or__3548__auto____7448 = cljs.core._EQ_.call(null, ch__7447, "\n");
        if(or__3548__auto____7448) {
          return or__3548__auto____7448
        }else {
          return cljs.core._EQ_.call(null, ch__7447, "\r")
        }
      }()) {
        var G__7449 = index__7446 - 1;
        index__7446 = G__7449;
        continue
      }else {
        return s.substring(0, index__7446)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7450 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7451 = cljs.core.not.call(null, s__7450);
    if(or__3548__auto____7451) {
      return or__3548__auto____7451
    }else {
      var or__3548__auto____7452 = cljs.core._EQ_.call(null, "", s__7450);
      if(or__3548__auto____7452) {
        return or__3548__auto____7452
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7450)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7453 = new goog.string.StringBuffer;
  var length__7454 = s.length;
  var index__7455 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7454, index__7455)) {
      return buffer__7453.toString()
    }else {
      var ch__7456 = s.charAt(index__7455);
      var temp__3695__auto____7457 = cljs.core.get.call(null, cmap, ch__7456);
      if(cljs.core.truth_(temp__3695__auto____7457)) {
        var replacement__7458 = temp__3695__auto____7457;
        buffer__7453.append([cljs.core.str(replacement__7458)].join(""))
      }else {
        buffer__7453.append(ch__7456)
      }
      var G__7459 = index__7455 + 1;
      index__7455 = G__7459;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7408 = {};
  var G__7409__7410 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7409__7410)) {
    var G__7412__7414 = cljs.core.first.call(null, G__7409__7410);
    var vec__7413__7415 = G__7412__7414;
    var k__7416 = cljs.core.nth.call(null, vec__7413__7415, 0, null);
    var v__7417 = cljs.core.nth.call(null, vec__7413__7415, 1, null);
    var G__7409__7418 = G__7409__7410;
    var G__7412__7419 = G__7412__7414;
    var G__7409__7420 = G__7409__7418;
    while(true) {
      var vec__7421__7422 = G__7412__7419;
      var k__7423 = cljs.core.nth.call(null, vec__7421__7422, 0, null);
      var v__7424 = cljs.core.nth.call(null, vec__7421__7422, 1, null);
      var G__7409__7425 = G__7409__7420;
      out__7408[cljs.core.name.call(null, k__7423)] = v__7424;
      var temp__3698__auto____7426 = cljs.core.next.call(null, G__7409__7425);
      if(cljs.core.truth_(temp__3698__auto____7426)) {
        var G__7409__7427 = temp__3698__auto____7426;
        var G__7428 = cljs.core.first.call(null, G__7409__7427);
        var G__7429 = G__7409__7427;
        G__7412__7419 = G__7428;
        G__7409__7420 = G__7429;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7408
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7430 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7430)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7431) {
    var v = cljs.core.first(arglist__7431);
    var text = cljs.core.rest(arglist__7431);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7432) {
          var vec__7433__7434 = p__7432;
          var k__7435 = cljs.core.nth.call(null, vec__7433__7434, 0, null);
          var v__7436 = cljs.core.nth.call(null, vec__7433__7434, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7435), clj__GT_js.call(null, v__7436))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7300 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7300)) {
        var cm__7301 = temp__3695__auto____7300;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7301), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7302) {
    var vec__7303__7304 = p__7302;
    var context__7305 = cljs.core.nth.call(null, vec__7303__7304, 0, null);
    if(cljs.core.not.call(null, context__7305)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7305)
    }
  };
  var $ = function(sel, var_args) {
    var p__7302 = null;
    if(goog.isDef(var_args)) {
      p__7302 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7302)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7306) {
    var sel = cljs.core.first(arglist__7306);
    var p__7302 = cljs.core.rest(arglist__7306);
    return $__delegate(sel, p__7302)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7307 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7307)) {
    return or__3548__auto____7307
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7308 = null;
  var G__7308__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7308__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7308 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7308__2.call(this, _, k);
      case 3:
        return G__7308__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7308
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7309) {
    var vec__7310__7311 = p__7309;
    var v__7312 = cljs.core.nth.call(null, vec__7310__7311, 0, null);
    var a__7313 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7312)) {
      return $elem.attr(a__7313)
    }else {
      return $elem.attr(a__7313, v__7312)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7309 = null;
    if(goog.isDef(var_args)) {
      p__7309 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7309)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7314) {
    var $elem = cljs.core.first(arglist__7314);
    var a = cljs.core.first(cljs.core.next(arglist__7314));
    var p__7309 = cljs.core.rest(cljs.core.next(arglist__7314));
    return attr__delegate($elem, a, p__7309)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7315) {
    var vec__7316__7317 = p__7315;
    var v__7318 = cljs.core.nth.call(null, vec__7316__7317, 0, null);
    var k__7319 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7318)) {
      return $elem.data(k__7319)
    }else {
      return $elem.data(k__7319, v__7318)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7315 = null;
    if(goog.isDef(var_args)) {
      p__7315 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7315)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7320) {
    var $elem = cljs.core.first(arglist__7320);
    var k = cljs.core.first(cljs.core.next(arglist__7320));
    var p__7315 = cljs.core.rest(cljs.core.next(arglist__7320));
    return data__delegate($elem, k, p__7315)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7321 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7321)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7322 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7322)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7323 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7323)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7324 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7324)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7325) {
    var vec__7326__7327 = p__7325;
    var speed__7328 = cljs.core.nth.call(null, vec__7326__7327, 0, null);
    var on_finish__7329 = cljs.core.nth.call(null, vec__7326__7327, 1, null);
    return $elem.hide(speed__7328, on_finish__7329)
  };
  var hide = function($elem, var_args) {
    var p__7325 = null;
    if(goog.isDef(var_args)) {
      p__7325 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7325)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7330) {
    var $elem = cljs.core.first(arglist__7330);
    var p__7325 = cljs.core.rest(arglist__7330);
    return hide__delegate($elem, p__7325)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7331) {
    var vec__7332__7333 = p__7331;
    var speed__7334 = cljs.core.nth.call(null, vec__7332__7333, 0, null);
    var on_finish__7335 = cljs.core.nth.call(null, vec__7332__7333, 1, null);
    return $elem.show(speed__7334, on_finish__7335)
  };
  var show = function($elem, var_args) {
    var p__7331 = null;
    if(goog.isDef(var_args)) {
      p__7331 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7331)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7336) {
    var $elem = cljs.core.first(arglist__7336);
    var p__7331 = cljs.core.rest(arglist__7336);
    return show__delegate($elem, p__7331)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7337) {
    var vec__7338__7339 = p__7337;
    var speed__7340 = cljs.core.nth.call(null, vec__7338__7339, 0, null);
    var on_finish__7341 = cljs.core.nth.call(null, vec__7338__7339, 1, null);
    return $elem.toggle(speed__7340, on_finish__7341)
  };
  var toggle = function($elem, var_args) {
    var p__7337 = null;
    if(goog.isDef(var_args)) {
      p__7337 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7337)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7342) {
    var $elem = cljs.core.first(arglist__7342);
    var p__7337 = cljs.core.rest(arglist__7342);
    return toggle__delegate($elem, p__7337)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7343) {
    var vec__7344__7345 = p__7343;
    var speed__7346 = cljs.core.nth.call(null, vec__7344__7345, 0, null);
    var on_finish__7347 = cljs.core.nth.call(null, vec__7344__7345, 1, null);
    return $elem.fadeOut(speed__7346, on_finish__7347)
  };
  var fade_out = function($elem, var_args) {
    var p__7343 = null;
    if(goog.isDef(var_args)) {
      p__7343 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7343)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7348) {
    var $elem = cljs.core.first(arglist__7348);
    var p__7343 = cljs.core.rest(arglist__7348);
    return fade_out__delegate($elem, p__7343)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7349) {
    var vec__7350__7351 = p__7349;
    var speed__7352 = cljs.core.nth.call(null, vec__7350__7351, 0, null);
    var on_finish__7353 = cljs.core.nth.call(null, vec__7350__7351, 1, null);
    return $elem.fadeIn(speed__7352, on_finish__7353)
  };
  var fade_in = function($elem, var_args) {
    var p__7349 = null;
    if(goog.isDef(var_args)) {
      p__7349 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7349)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7354) {
    var $elem = cljs.core.first(arglist__7354);
    var p__7349 = cljs.core.rest(arglist__7354);
    return fade_in__delegate($elem, p__7349)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7355) {
    var vec__7356__7357 = p__7355;
    var speed__7358 = cljs.core.nth.call(null, vec__7356__7357, 0, null);
    var on_finish__7359 = cljs.core.nth.call(null, vec__7356__7357, 1, null);
    return $elem.slideUp(speed__7358, on_finish__7359)
  };
  var slide_up = function($elem, var_args) {
    var p__7355 = null;
    if(goog.isDef(var_args)) {
      p__7355 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7355)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7360) {
    var $elem = cljs.core.first(arglist__7360);
    var p__7355 = cljs.core.rest(arglist__7360);
    return slide_up__delegate($elem, p__7355)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7361) {
    var vec__7362__7363 = p__7361;
    var speed__7364 = cljs.core.nth.call(null, vec__7362__7363, 0, null);
    var on_finish__7365 = cljs.core.nth.call(null, vec__7362__7363, 1, null);
    return $elem.slideDown(speed__7364, on_finish__7365)
  };
  var slide_down = function($elem, var_args) {
    var p__7361 = null;
    if(goog.isDef(var_args)) {
      p__7361 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7361)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7366) {
    var $elem = cljs.core.first(arglist__7366);
    var p__7361 = cljs.core.rest(arglist__7366);
    return slide_down__delegate($elem, p__7361)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7367) {
    var vec__7368__7369 = p__7367;
    var context__7370 = cljs.core.nth.call(null, vec__7368__7369, 0, null);
    return $elem.closest(selector, context__7370)
  };
  var closest = function($elem, selector, var_args) {
    var p__7367 = null;
    if(goog.isDef(var_args)) {
      p__7367 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7367)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7371) {
    var $elem = cljs.core.first(arglist__7371);
    var selector = cljs.core.first(cljs.core.next(arglist__7371));
    var p__7367 = cljs.core.rest(cljs.core.next(arglist__7371));
    return closest__delegate($elem, selector, p__7367)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7372) {
    var vec__7373__7374 = p__7372;
    var v__7375 = cljs.core.nth.call(null, vec__7373__7374, 0, null);
    if(cljs.core.truth_(v__7375)) {
      return $elem.val(v__7375)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7372 = null;
    if(goog.isDef(var_args)) {
      p__7372 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7372)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7376) {
    var $elem = cljs.core.first(arglist__7376);
    var p__7372 = cljs.core.rest(arglist__7376);
    return val__delegate($elem, p__7372)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7377, content, callback) {
  var vec__7378__7379 = p__7377;
  var method__7380 = cljs.core.nth.call(null, vec__7378__7379, 0, null);
  var uri__7381 = cljs.core.nth.call(null, vec__7378__7379, 1, null);
  var params__7382 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7380)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7381, params__7382)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7383) {
    var vec__7384__7385 = p__7383;
    var func__7386 = cljs.core.nth.call(null, vec__7384__7385, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7386)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7383 = null;
    if(goog.isDef(var_args)) {
      p__7383 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7383)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7387) {
    var $elem = cljs.core.first(arglist__7387);
    var ev = cljs.core.first(cljs.core.next(arglist__7387));
    var p__7383 = cljs.core.rest(cljs.core.next(arglist__7387));
    return unbind__delegate($elem, ev, p__7383)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7388) {
    var vec__7389__7390 = p__7388;
    var sel__7391 = cljs.core.nth.call(null, vec__7389__7390, 0, null);
    var data__7392 = cljs.core.nth.call(null, vec__7389__7390, 1, null);
    var handler__7393 = cljs.core.nth.call(null, vec__7389__7390, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7391), data__7392, handler__7393)
  };
  var on = function($elem, events, var_args) {
    var p__7388 = null;
    if(goog.isDef(var_args)) {
      p__7388 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7388)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7394) {
    var $elem = cljs.core.first(arglist__7394);
    var events = cljs.core.first(cljs.core.next(arglist__7394));
    var p__7388 = cljs.core.rest(cljs.core.next(arglist__7394));
    return on__delegate($elem, events, p__7388)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7395) {
    var vec__7396__7397 = p__7395;
    var sel__7398 = cljs.core.nth.call(null, vec__7396__7397, 0, null);
    var data__7399 = cljs.core.nth.call(null, vec__7396__7397, 1, null);
    var handler__7400 = cljs.core.nth.call(null, vec__7396__7397, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7398), data__7399, handler__7400)
  };
  var one = function($elem, events, var_args) {
    var p__7395 = null;
    if(goog.isDef(var_args)) {
      p__7395 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7395)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7401) {
    var $elem = cljs.core.first(arglist__7401);
    var events = cljs.core.first(cljs.core.next(arglist__7401));
    var p__7395 = cljs.core.rest(cljs.core.next(arglist__7401));
    return one__delegate($elem, events, p__7395)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7402) {
    var vec__7403__7404 = p__7402;
    var sel__7405 = cljs.core.nth.call(null, vec__7403__7404, 0, null);
    var handler__7406 = cljs.core.nth.call(null, vec__7403__7404, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7405), handler__7406)
  };
  var off = function($elem, events, var_args) {
    var p__7402 = null;
    if(goog.isDef(var_args)) {
      p__7402 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7402)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7407) {
    var $elem = cljs.core.first(arglist__7407);
    var events = cljs.core.first(cljs.core.next(arglist__7407));
    var p__7402 = cljs.core.rest(cljs.core.next(arglist__7407));
    return off__delegate($elem, events, p__7402)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.dynamic_bindings = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.binding_key = cljs.core.atom.call(null, 0);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4819 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4818_SHARP_) {
    return out__4819[cljs.core.name.call(null, cljs.core.first.call(null, p1__4818_SHARP_))] = cljs.core.second.call(null, p1__4818_SHARP_)
  }, cljmap));
  return out__4819
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4820 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4820) {
    return or__3548__auto____4820
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bind_elem = function bind_elem(elem, bindingname, f) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname).call(null, elem, f.call(null))
    }
  }else {
    return function() {
      return elem[bindingname].call(elem, f.call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4821 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4822 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  return cljsbinding.bind_elem.call(null, elem, bindingname__4821, function() {
    return cljsbinding.valuefn.call(null, elem, fname__4822, ctx, bindingname__4821)
  })
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_jq_elem = function bind_jq_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4823__4824 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4823__4824)) {
    var data__4825 = cljs.core.first.call(null, G__4823__4824);
    var G__4823__4826 = G__4823__4824;
    while(true) {
      cljsbinding.bind_jq_elem.call(null, elem, data__4825.split(":"), ctx);
      var temp__3698__auto____4827 = cljs.core.next.call(null, G__4823__4826);
      if(cljs.core.truth_(temp__3698__auto____4827)) {
        var G__4823__4828 = temp__3698__auto____4827;
        var G__4829 = cljs.core.first.call(null, G__4823__4828);
        var G__4830 = G__4823__4828;
        data__4825 = G__4829;
        G__4823__4826 = G__4830;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem, atm) {
  var aval__4832 = cljs.core.deref.call(null, atm);
  if(cljs.core.map_QMARK_.call(null, aval__4832)) {
    return aval__4832.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4832
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4831_SHARP_) {
      return cljs.core.assoc.call(null, p1__4831_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.is(":checked"));
    return false
  })
};
cljsbinding.bind_text_atom = function bind_text_atom(elem, atm) {
  return cljsbinding.run_bind_fn.call(null, function() {
    return elem["text"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  })
};
cljsbinding.bind_elem_to_atom = function bind_elem_to_atom(elem, atm) {
  if(cljs.core.truth_(elem.is("input"))) {
    if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
      return cljsbinding.bind_checkbox_atom.call(null, elem, atm)
    }else {
      return cljsbinding.bind_input_atom.call(null, elem, atm)
    }
  }else {
    return cljsbinding.bind_text_atom.call(null, elem, atm)
  }
};
cljsbinding.bindatom = function bindatom(elem) {
  var atm__4833 = eval(jayq.core.attr.call(null, elem, "bindatom"));
  return cljsbinding.bind_elem_to_atom.call(null, elem, atm__4833)
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem, bindfn) {
  jayq.core.append.call(null, parent, elem);
  return bindfn.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template, bindfn) {
  jayq.core.remove.call(null, parent.children());
  var G__4834__4835 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4834__4835)) {
    var item__4836 = cljs.core.first.call(null, G__4834__4835);
    var G__4834__4837 = G__4834__4835;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4836, template.clone(), bindfn);
      var temp__3698__auto____4838 = cljs.core.next.call(null, G__4834__4837);
      if(cljs.core.truth_(temp__3698__auto____4838)) {
        var G__4834__4839 = temp__3698__auto____4838;
        var G__4840 = cljs.core.first.call(null, G__4834__4839);
        var G__4841 = G__4834__4839;
        item__4836 = G__4840;
        G__4834__4837 = G__4841;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent, bindfn) {
  var atom__4843 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4843), elparent, elem, bindfn);
  return cljs.core.add_watch.call(null, atom__4843, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem, bindfn)
  })
};
cljsbinding.dobind = function dobind(parent, ctx) {
  var seqs__4844 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4845 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__4842_SHARP_) {
    return jayq.core.$.call(null, p1__4842_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4846__4847 = cljs.core.seq.call(null, seqs__4844);
  if(cljs.core.truth_(G__4846__4847)) {
    var elem__4848 = cljs.core.first.call(null, G__4846__4847);
    var G__4846__4849 = G__4846__4847;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4848));
      var temp__3698__auto____4850 = cljs.core.next.call(null, G__4846__4849);
      if(cljs.core.truth_(temp__3698__auto____4850)) {
        var G__4846__4851 = temp__3698__auto____4850;
        var G__4889 = cljs.core.first.call(null, G__4846__4851);
        var G__4890 = G__4846__4851;
        elem__4848 = G__4889;
        G__4846__4849 = G__4890;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4852__4853 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4852__4853)) {
    var elem__4854 = cljs.core.first.call(null, G__4852__4853);
    var G__4852__4855 = G__4852__4853;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4854), ctx);
      var temp__3698__auto____4856 = cljs.core.next.call(null, G__4852__4855);
      if(cljs.core.truth_(temp__3698__auto____4856)) {
        var G__4852__4857 = temp__3698__auto____4856;
        var G__4891 = cljs.core.first.call(null, G__4852__4857);
        var G__4892 = G__4852__4857;
        elem__4854 = G__4891;
        G__4852__4855 = G__4892;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4858__4859 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4858__4859)) {
    var elem__4860 = cljs.core.first.call(null, G__4858__4859);
    var G__4858__4861 = G__4858__4859;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4860), ctx);
      var temp__3698__auto____4862 = cljs.core.next.call(null, G__4858__4861);
      if(cljs.core.truth_(temp__3698__auto____4862)) {
        var G__4858__4863 = temp__3698__auto____4862;
        var G__4893 = cljs.core.first.call(null, G__4858__4863);
        var G__4894 = G__4858__4863;
        elem__4860 = G__4893;
        G__4858__4861 = G__4894;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4864__4865 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4864__4865)) {
    var elem__4866 = cljs.core.first.call(null, G__4864__4865);
    var G__4864__4867 = G__4864__4865;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4866));
      var temp__3698__auto____4868 = cljs.core.next.call(null, G__4864__4867);
      if(cljs.core.truth_(temp__3698__auto____4868)) {
        var G__4864__4869 = temp__3698__auto____4868;
        var G__4895 = cljs.core.first.call(null, G__4864__4869);
        var G__4896 = G__4864__4869;
        elem__4866 = G__4895;
        G__4864__4867 = G__4896;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4870__4871 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4844, seqparents__4845));
  if(cljs.core.truth_(G__4870__4871)) {
    var G__4873__4875 = cljs.core.first.call(null, G__4870__4871);
    var vec__4874__4876 = G__4873__4875;
    var elem__4877 = cljs.core.nth.call(null, vec__4874__4876, 0, null);
    var parent__4878 = cljs.core.nth.call(null, vec__4874__4876, 1, null);
    var G__4870__4879 = G__4870__4871;
    var G__4873__4880 = G__4873__4875;
    var G__4870__4881 = G__4870__4879;
    while(true) {
      var vec__4882__4883 = G__4873__4880;
      var elem__4884 = cljs.core.nth.call(null, vec__4882__4883, 0, null);
      var parent__4885 = cljs.core.nth.call(null, vec__4882__4883, 1, null);
      var G__4870__4886 = G__4870__4881;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4884), parent__4885, dobind);
      var temp__3698__auto____4887 = cljs.core.next.call(null, G__4870__4886);
      if(cljs.core.truth_(temp__3698__auto____4887)) {
        var G__4870__4888 = temp__3698__auto____4887;
        var G__4897 = cljs.core.first.call(null, G__4870__4888);
        var G__4898 = G__4870__4888;
        G__4873__4880 = G__4897;
        G__4870__4881 = G__4898;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindall = function() {
  var bindall = null;
  var bindall__1 = function(elem) {
    return cljsbinding.dobind.call(null, elem, null)
  };
  var bindall__2 = function(elem, ctx) {
    return cljsbinding.dobind.call(null, elem, ctx)
  };
  bindall = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindall__1.call(this, elem);
      case 2:
        return bindall__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindall.cljs$lang$arity$1 = bindall__1;
  bindall.cljs$lang$arity$2 = bindall__2;
  return bindall
}();
goog.exportSymbol("cljsbinding.bindall", cljsbinding.bindall);
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4899_SHARP_, p2__4900_SHARP_) {
      var or__3548__auto____4902 = p1__4899_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4902)) {
        return or__3548__auto____4902
      }else {
        return p2__4900_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4901_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4901_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.add_binding = function add_binding(atom, m) {
  return cljs.core.assoc.call(null, m, atom, cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), m.call(null, atom)))
};
cljsbinding.run_bindings = function run_bindings(key, a, old_val, new_val) {
  var G__4903__4904 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
  if(cljs.core.truth_(G__4903__4904)) {
    var f__4905 = cljs.core.first.call(null, G__4903__4904);
    var G__4903__4906 = G__4903__4904;
    while(true) {
      f__4905.call(null);
      var temp__3698__auto____4907 = cljs.core.next.call(null, G__4903__4906);
      if(cljs.core.truth_(temp__3698__auto____4907)) {
        var G__4903__4908 = temp__3698__auto____4907;
        var G__4909 = cljs.core.first.call(null, G__4903__4908);
        var G__4910 = G__4903__4908;
        f__4905 = G__4909;
        G__4903__4906 = G__4910;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.next_binding_key = function next_binding_key() {
  return cljs.core.swap_BANG_.call(null, cljsbinding.binding_key, cljs.core.inc)
};
cljsbinding.register_bindingsource = function register_bindingsource(source) {
  var bindingkey__4912 = [cljs.core.str(cljsbinding.next_binding_key.call(null))].join("");
  cljs.core.swap_BANG_.call(null, cljsbinding.dynamic_bindings, function(p1__4911_SHARP_) {
    return cljs.core.assoc.call(null, p1__4911_SHARP_, bindingkey__4912, source)
  });
  return bindingkey__4912
};
cljsbinding.apply_binding = function apply_binding(elem, source) {
  if(cljs.core.map_QMARK_.call(null, source)) {
    var G__4913__4914 = cljs.core.seq.call(null, source);
    if(cljs.core.truth_(G__4913__4914)) {
      var G__4916__4918 = cljs.core.first.call(null, G__4913__4914);
      var vec__4917__4919 = G__4916__4918;
      var bindingname__4920 = cljs.core.nth.call(null, vec__4917__4919, 0, null);
      var f__4921 = cljs.core.nth.call(null, vec__4917__4919, 1, null);
      var G__4913__4922 = G__4913__4914;
      var G__4916__4923 = G__4916__4918;
      var G__4913__4924 = G__4913__4922;
      while(true) {
        var vec__4925__4926 = G__4916__4923;
        var bindingname__4927 = cljs.core.nth.call(null, vec__4925__4926, 0, null);
        var f__4928 = cljs.core.nth.call(null, vec__4925__4926, 1, null);
        var G__4913__4929 = G__4913__4924;
        cljsbinding.run_bind_fn.call(null, cljsbinding.bind_elem.call(null, elem, cljs.core.name.call(null, bindingname__4927), f__4928));
        var temp__3698__auto____4930 = cljs.core.next.call(null, G__4913__4929);
        if(cljs.core.truth_(temp__3698__auto____4930)) {
          var G__4913__4931 = temp__3698__auto____4930;
          var G__4932 = cljs.core.first.call(null, G__4913__4931);
          var G__4933 = G__4913__4931;
          G__4916__4923 = G__4932;
          G__4913__4924 = G__4933;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  }else {
    return cljsbinding.bind_elem_to_atom.call(null, elem, source)
  }
};
cljsbinding.apply_bindingsource = function apply_bindingsource(elem, bindingkey) {
  var G__4934__4935 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.dynamic_bindings).call(null, bindingkey));
  if(cljs.core.truth_(G__4934__4935)) {
    var source__4936 = cljs.core.first.call(null, G__4934__4935);
    var G__4934__4937 = G__4934__4935;
    while(true) {
      cljsbinding.apply_binding.call(null, elem, source__4936);
      var temp__3698__auto____4938 = cljs.core.next.call(null, G__4934__4937);
      if(cljs.core.truth_(temp__3698__auto____4938)) {
        var G__4934__4939 = temp__3698__auto____4938;
        var G__4940 = cljs.core.first.call(null, G__4934__4939);
        var G__4941 = G__4934__4939;
        source__4936 = G__4940;
        G__4934__4937 = G__4941;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, cljs.core.partial.call(null, cljsbinding.add_binding, atom));
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", cljsbinding.run_bindings);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.cljsderef = function cljsderef() {
  return cljs.core._deref
};
goog.exportSymbol("cljsbinding.cljsderef", cljsbinding.cljsderef);
cljsbinding.shouldregister = function shouldregister(drf) {
  return drf.call(null, cljsbinding.BindMonitor)
};
goog.exportSymbol("cljsbinding.shouldregister", cljsbinding.shouldregister);
cljsbinding.boot = function boot() {
  return eval("    \n    var derefName = eval('cljsbinding.cljsderef.toString().match(/return.(.*$)\\\\s/m)[1]')\n    if (derefName[derefName.length-1] == ';')\n      derefName = derefName.substr(0,derefName.length-1)\n    var deref = eval(derefName)\n    eval(derefName +' = function (a) { if (cljsbinding.shouldregister(deref)) { cljsbinding.register(a) };return deref(a); }')\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4942 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4942), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4942)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4942)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4942)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4942))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  var storedValue__4943 = localStorage[name];
  if(cljs.core.not.call(null, storedValue__4943 == null)) {
    return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, storedValue__4943))
  }else {
    return null
  }
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
goog.provide("cljsbinding.crate");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljsbinding");
cljsbinding.crate.re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;
cljsbinding.crate.tag_str = function tag_str(tag) {
  if(cljs.core.keyword_QMARK_.call(null, tag)) {
    return cljs.core.name.call(null, tag)
  }else {
    return[cljs.core.str(tag)].join("")
  }
};
cljsbinding.crate.normalize_element = function normalize_element(p__4796) {
  var vec__4797__4798 = p__4796;
  var tag__4799 = cljs.core.nth.call(null, vec__4797__4798, 0, null);
  var content__4800 = cljs.core.nthnext.call(null, vec__4797__4798, 1);
  if(cljs.core.not.call(null, function() {
    var or__3548__auto____4801 = cljs.core.keyword_QMARK_.call(null, tag__4799);
    if(or__3548__auto____4801) {
      return or__3548__auto____4801
    }else {
      var or__3548__auto____4802 = cljs.core.symbol_QMARK_.call(null, tag__4799);
      if(or__3548__auto____4802) {
        return or__3548__auto____4802
      }else {
        return cljs.core.string_QMARK_.call(null, tag__4799)
      }
    }
  }())) {
    throw Error([cljs.core.str(tag__4799), cljs.core.str(" is not a valid element name.")].join(""));
  }else {
  }
  var vec__4803__4804 = cljs.core.re_matches.call(null, cljsbinding.crate.re_tag, cljsbinding.crate.tag_str.call(null, tag__4799));
  var ___4805 = cljs.core.nth.call(null, vec__4803__4804, 0, null);
  var tag__4806 = cljs.core.nth.call(null, vec__4803__4804, 1, null);
  var id__4807 = cljs.core.nth.call(null, vec__4803__4804, 2, null);
  var class$__4808 = cljs.core.nth.call(null, vec__4803__4804, 3, null);
  var tag_attrs__4809 = cljs.core.ObjMap.fromObject(["\ufdd0'id", "\ufdd0'class"], {"\ufdd0'id":id__4807, "\ufdd0'class":cljs.core.truth_(class$__4808) ? class$__4808.replace(".", " ") : null});
  var map_attrs__4810 = cljs.core.first.call(null, content__4800);
  if(cljs.core.map_QMARK_.call(null, map_attrs__4810)) {
    return cljs.core.PersistentVector.fromArray([tag__4806, cljs.core.merge.call(null, tag_attrs__4809, map_attrs__4810), cljs.core.next.call(null, content__4800)])
  }else {
    return cljs.core.PersistentVector.fromArray([tag__4806, tag_attrs__4809, content__4800])
  }
};
cljsbinding.crate.add_binding = function() {
  var add_binding__delegate = function(elem, bind) {
    var vec__4811__4812 = cljsbinding.crate.normalize_element.call(null, elem);
    var tagname__4813 = cljs.core.nth.call(null, vec__4811__4812, 0, null);
    var attrs__4814 = cljs.core.nth.call(null, vec__4811__4812, 1, null);
    var content__4815 = cljs.core.nth.call(null, vec__4811__4812, 2, null);
    return cljs.core.PersistentVector.fromArray([tagname__4813, cljs.core.assoc.call(null, attrs__4814, "\ufdd0'withbinding", cljsbinding.register_bindingsource.call(null, bind))])
  };
  var add_binding = function(elem, var_args) {
    var bind = null;
    if(goog.isDef(var_args)) {
      bind = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return add_binding__delegate.call(this, elem, bind)
  };
  add_binding.cljs$lang$maxFixedArity = 1;
  add_binding.cljs$lang$applyTo = function(arglist__4816) {
    var elem = cljs.core.first(arglist__4816);
    var bind = cljs.core.rest(arglist__4816);
    return add_binding__delegate(elem, bind)
  };
  add_binding.cljs$lang$arity$variadic = add_binding__delegate;
  return add_binding
}();
cljsbinding.crate.bind_html_elem = function bind_html_elem(elem) {
  var bindingkey__4817 = jayq.core.attr.call(null, elem, "withbinding");
  cljsbinding.apply_bindingsource.call(null, elem, bindingkey__4817);
  return elem.removeAttr("withbinding")
};
