var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4942__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4942 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4942__delegate.call(this, array, i, idxs)
    };
    G__4942.cljs$lang$maxFixedArity = 2;
    G__4942.cljs$lang$applyTo = function(arglist__4943) {
      var array = cljs.core.first(arglist__4943);
      var i = cljs.core.first(cljs.core.next(arglist__4943));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4943));
      return G__4942__delegate(array, i, idxs)
    };
    G__4942.cljs$lang$arity$variadic = G__4942__delegate;
    return G__4942
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4944 = this$;
      if(and__3546__auto____4944) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4944
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4945 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4945) {
          return or__3548__auto____4945
        }else {
          var or__3548__auto____4946 = cljs.core._invoke["_"];
          if(or__3548__auto____4946) {
            return or__3548__auto____4946
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4947 = this$;
      if(and__3546__auto____4947) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4947
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4948 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4948) {
          return or__3548__auto____4948
        }else {
          var or__3548__auto____4949 = cljs.core._invoke["_"];
          if(or__3548__auto____4949) {
            return or__3548__auto____4949
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4950 = this$;
      if(and__3546__auto____4950) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4950
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4951 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4951) {
          return or__3548__auto____4951
        }else {
          var or__3548__auto____4952 = cljs.core._invoke["_"];
          if(or__3548__auto____4952) {
            return or__3548__auto____4952
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4953 = this$;
      if(and__3546__auto____4953) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4953
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4954 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4954) {
          return or__3548__auto____4954
        }else {
          var or__3548__auto____4955 = cljs.core._invoke["_"];
          if(or__3548__auto____4955) {
            return or__3548__auto____4955
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4956 = this$;
      if(and__3546__auto____4956) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4956
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4957 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4957) {
          return or__3548__auto____4957
        }else {
          var or__3548__auto____4958 = cljs.core._invoke["_"];
          if(or__3548__auto____4958) {
            return or__3548__auto____4958
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4959 = this$;
      if(and__3546__auto____4959) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4959
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4960 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4960) {
          return or__3548__auto____4960
        }else {
          var or__3548__auto____4961 = cljs.core._invoke["_"];
          if(or__3548__auto____4961) {
            return or__3548__auto____4961
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4962 = this$;
      if(and__3546__auto____4962) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4962
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4963 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4963) {
          return or__3548__auto____4963
        }else {
          var or__3548__auto____4964 = cljs.core._invoke["_"];
          if(or__3548__auto____4964) {
            return or__3548__auto____4964
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4965 = this$;
      if(and__3546__auto____4965) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4965
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4966 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4966) {
          return or__3548__auto____4966
        }else {
          var or__3548__auto____4967 = cljs.core._invoke["_"];
          if(or__3548__auto____4967) {
            return or__3548__auto____4967
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4968 = this$;
      if(and__3546__auto____4968) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4968
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4969 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4969) {
          return or__3548__auto____4969
        }else {
          var or__3548__auto____4970 = cljs.core._invoke["_"];
          if(or__3548__auto____4970) {
            return or__3548__auto____4970
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4971 = this$;
      if(and__3546__auto____4971) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4971
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4972 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4972) {
          return or__3548__auto____4972
        }else {
          var or__3548__auto____4973 = cljs.core._invoke["_"];
          if(or__3548__auto____4973) {
            return or__3548__auto____4973
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4974 = this$;
      if(and__3546__auto____4974) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4974
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4975 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4975) {
          return or__3548__auto____4975
        }else {
          var or__3548__auto____4976 = cljs.core._invoke["_"];
          if(or__3548__auto____4976) {
            return or__3548__auto____4976
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4977 = this$;
      if(and__3546__auto____4977) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4977
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4978 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4978) {
          return or__3548__auto____4978
        }else {
          var or__3548__auto____4979 = cljs.core._invoke["_"];
          if(or__3548__auto____4979) {
            return or__3548__auto____4979
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4980 = this$;
      if(and__3546__auto____4980) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4980
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4981 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4981) {
          return or__3548__auto____4981
        }else {
          var or__3548__auto____4982 = cljs.core._invoke["_"];
          if(or__3548__auto____4982) {
            return or__3548__auto____4982
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4983 = this$;
      if(and__3546__auto____4983) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4983
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4984 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4984) {
          return or__3548__auto____4984
        }else {
          var or__3548__auto____4985 = cljs.core._invoke["_"];
          if(or__3548__auto____4985) {
            return or__3548__auto____4985
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4986 = this$;
      if(and__3546__auto____4986) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4986
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4987 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4987) {
          return or__3548__auto____4987
        }else {
          var or__3548__auto____4988 = cljs.core._invoke["_"];
          if(or__3548__auto____4988) {
            return or__3548__auto____4988
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4989 = this$;
      if(and__3546__auto____4989) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4989
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4990 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4990) {
          return or__3548__auto____4990
        }else {
          var or__3548__auto____4991 = cljs.core._invoke["_"];
          if(or__3548__auto____4991) {
            return or__3548__auto____4991
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4992 = this$;
      if(and__3546__auto____4992) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4992
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4993 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4993) {
          return or__3548__auto____4993
        }else {
          var or__3548__auto____4994 = cljs.core._invoke["_"];
          if(or__3548__auto____4994) {
            return or__3548__auto____4994
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____4995 = this$;
      if(and__3546__auto____4995) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____4995
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____4996 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4996) {
          return or__3548__auto____4996
        }else {
          var or__3548__auto____4997 = cljs.core._invoke["_"];
          if(or__3548__auto____4997) {
            return or__3548__auto____4997
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____4998 = this$;
      if(and__3546__auto____4998) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____4998
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____4999 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4999) {
          return or__3548__auto____4999
        }else {
          var or__3548__auto____5000 = cljs.core._invoke["_"];
          if(or__3548__auto____5000) {
            return or__3548__auto____5000
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____5001 = this$;
      if(and__3546__auto____5001) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____5001
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____5002 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5002) {
          return or__3548__auto____5002
        }else {
          var or__3548__auto____5003 = cljs.core._invoke["_"];
          if(or__3548__auto____5003) {
            return or__3548__auto____5003
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____5004 = this$;
      if(and__3546__auto____5004) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____5004
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____5005 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5005) {
          return or__3548__auto____5005
        }else {
          var or__3548__auto____5006 = cljs.core._invoke["_"];
          if(or__3548__auto____5006) {
            return or__3548__auto____5006
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____5007 = coll;
    if(and__3546__auto____5007) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____5007
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5008 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5008) {
        return or__3548__auto____5008
      }else {
        var or__3548__auto____5009 = cljs.core._count["_"];
        if(or__3548__auto____5009) {
          return or__3548__auto____5009
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____5010 = coll;
    if(and__3546__auto____5010) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____5010
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5011 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5011) {
        return or__3548__auto____5011
      }else {
        var or__3548__auto____5012 = cljs.core._empty["_"];
        if(or__3548__auto____5012) {
          return or__3548__auto____5012
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____5013 = coll;
    if(and__3546__auto____5013) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____5013
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____5014 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5014) {
        return or__3548__auto____5014
      }else {
        var or__3548__auto____5015 = cljs.core._conj["_"];
        if(or__3548__auto____5015) {
          return or__3548__auto____5015
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____5016 = coll;
      if(and__3546__auto____5016) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____5016
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____5017 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5017) {
          return or__3548__auto____5017
        }else {
          var or__3548__auto____5018 = cljs.core._nth["_"];
          if(or__3548__auto____5018) {
            return or__3548__auto____5018
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____5019 = coll;
      if(and__3546__auto____5019) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____5019
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____5020 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5020) {
          return or__3548__auto____5020
        }else {
          var or__3548__auto____5021 = cljs.core._nth["_"];
          if(or__3548__auto____5021) {
            return or__3548__auto____5021
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____5022 = coll;
    if(and__3546__auto____5022) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____5022
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5023 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5023) {
        return or__3548__auto____5023
      }else {
        var or__3548__auto____5024 = cljs.core._first["_"];
        if(or__3548__auto____5024) {
          return or__3548__auto____5024
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____5025 = coll;
    if(and__3546__auto____5025) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____5025
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5026 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5026) {
        return or__3548__auto____5026
      }else {
        var or__3548__auto____5027 = cljs.core._rest["_"];
        if(or__3548__auto____5027) {
          return or__3548__auto____5027
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____5028 = o;
      if(and__3546__auto____5028) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____5028
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____5029 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5029) {
          return or__3548__auto____5029
        }else {
          var or__3548__auto____5030 = cljs.core._lookup["_"];
          if(or__3548__auto____5030) {
            return or__3548__auto____5030
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____5031 = o;
      if(and__3546__auto____5031) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____5031
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____5032 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5032) {
          return or__3548__auto____5032
        }else {
          var or__3548__auto____5033 = cljs.core._lookup["_"];
          if(or__3548__auto____5033) {
            return or__3548__auto____5033
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____5034 = coll;
    if(and__3546__auto____5034) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____5034
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5035 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5035) {
        return or__3548__auto____5035
      }else {
        var or__3548__auto____5036 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____5036) {
          return or__3548__auto____5036
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____5037 = coll;
    if(and__3546__auto____5037) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____5037
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____5038 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5038) {
        return or__3548__auto____5038
      }else {
        var or__3548__auto____5039 = cljs.core._assoc["_"];
        if(or__3548__auto____5039) {
          return or__3548__auto____5039
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____5040 = coll;
    if(and__3546__auto____5040) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____5040
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5041 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5041) {
        return or__3548__auto____5041
      }else {
        var or__3548__auto____5042 = cljs.core._dissoc["_"];
        if(or__3548__auto____5042) {
          return or__3548__auto____5042
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____5043 = coll;
    if(and__3546__auto____5043) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____5043
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5044 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5044) {
        return or__3548__auto____5044
      }else {
        var or__3548__auto____5045 = cljs.core._key["_"];
        if(or__3548__auto____5045) {
          return or__3548__auto____5045
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____5046 = coll;
    if(and__3546__auto____5046) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____5046
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5047 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5047) {
        return or__3548__auto____5047
      }else {
        var or__3548__auto____5048 = cljs.core._val["_"];
        if(or__3548__auto____5048) {
          return or__3548__auto____5048
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____5049 = coll;
    if(and__3546__auto____5049) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____5049
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____5050 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5050) {
        return or__3548__auto____5050
      }else {
        var or__3548__auto____5051 = cljs.core._disjoin["_"];
        if(or__3548__auto____5051) {
          return or__3548__auto____5051
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____5052 = coll;
    if(and__3546__auto____5052) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____5052
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5053 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5053) {
        return or__3548__auto____5053
      }else {
        var or__3548__auto____5054 = cljs.core._peek["_"];
        if(or__3548__auto____5054) {
          return or__3548__auto____5054
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____5055 = coll;
    if(and__3546__auto____5055) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____5055
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5056 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5056) {
        return or__3548__auto____5056
      }else {
        var or__3548__auto____5057 = cljs.core._pop["_"];
        if(or__3548__auto____5057) {
          return or__3548__auto____5057
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____5058 = coll;
    if(and__3546__auto____5058) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____5058
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____5059 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5059) {
        return or__3548__auto____5059
      }else {
        var or__3548__auto____5060 = cljs.core._assoc_n["_"];
        if(or__3548__auto____5060) {
          return or__3548__auto____5060
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____5061 = o;
    if(and__3546__auto____5061) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____5061
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5062 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____5062) {
        return or__3548__auto____5062
      }else {
        var or__3548__auto____5063 = cljs.core._deref["_"];
        if(or__3548__auto____5063) {
          return or__3548__auto____5063
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____5064 = o;
    if(and__3546__auto____5064) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____5064
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____5065 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____5065) {
        return or__3548__auto____5065
      }else {
        var or__3548__auto____5066 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____5066) {
          return or__3548__auto____5066
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____5067 = o;
    if(and__3546__auto____5067) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____5067
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5068 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5068) {
        return or__3548__auto____5068
      }else {
        var or__3548__auto____5069 = cljs.core._meta["_"];
        if(or__3548__auto____5069) {
          return or__3548__auto____5069
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____5070 = o;
    if(and__3546__auto____5070) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____5070
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____5071 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5071) {
        return or__3548__auto____5071
      }else {
        var or__3548__auto____5072 = cljs.core._with_meta["_"];
        if(or__3548__auto____5072) {
          return or__3548__auto____5072
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____5073 = coll;
      if(and__3546__auto____5073) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____5073
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____5074 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5074) {
          return or__3548__auto____5074
        }else {
          var or__3548__auto____5075 = cljs.core._reduce["_"];
          if(or__3548__auto____5075) {
            return or__3548__auto____5075
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____5076 = coll;
      if(and__3546__auto____5076) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____5076
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____5077 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5077) {
          return or__3548__auto____5077
        }else {
          var or__3548__auto____5078 = cljs.core._reduce["_"];
          if(or__3548__auto____5078) {
            return or__3548__auto____5078
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____5079 = coll;
    if(and__3546__auto____5079) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____5079
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____5080 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5080) {
        return or__3548__auto____5080
      }else {
        var or__3548__auto____5081 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____5081) {
          return or__3548__auto____5081
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____5082 = o;
    if(and__3546__auto____5082) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____5082
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____5083 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____5083) {
        return or__3548__auto____5083
      }else {
        var or__3548__auto____5084 = cljs.core._equiv["_"];
        if(or__3548__auto____5084) {
          return or__3548__auto____5084
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____5085 = o;
    if(and__3546__auto____5085) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____5085
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5086 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____5086) {
        return or__3548__auto____5086
      }else {
        var or__3548__auto____5087 = cljs.core._hash["_"];
        if(or__3548__auto____5087) {
          return or__3548__auto____5087
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____5088 = o;
    if(and__3546__auto____5088) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____5088
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5089 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5089) {
        return or__3548__auto____5089
      }else {
        var or__3548__auto____5090 = cljs.core._seq["_"];
        if(or__3548__auto____5090) {
          return or__3548__auto____5090
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____5091 = coll;
    if(and__3546__auto____5091) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____5091
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5092 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5092) {
        return or__3548__auto____5092
      }else {
        var or__3548__auto____5093 = cljs.core._rseq["_"];
        if(or__3548__auto____5093) {
          return or__3548__auto____5093
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5094 = coll;
    if(and__3546__auto____5094) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____5094
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5095 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5095) {
        return or__3548__auto____5095
      }else {
        var or__3548__auto____5096 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____5096) {
          return or__3548__auto____5096
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5097 = coll;
    if(and__3546__auto____5097) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____5097
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5098 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5098) {
        return or__3548__auto____5098
      }else {
        var or__3548__auto____5099 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____5099) {
          return or__3548__auto____5099
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____5100 = coll;
    if(and__3546__auto____5100) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____5100
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____5101 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5101) {
        return or__3548__auto____5101
      }else {
        var or__3548__auto____5102 = cljs.core._entry_key["_"];
        if(or__3548__auto____5102) {
          return or__3548__auto____5102
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____5103 = coll;
    if(and__3546__auto____5103) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____5103
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5104 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5104) {
        return or__3548__auto____5104
      }else {
        var or__3548__auto____5105 = cljs.core._comparator["_"];
        if(or__3548__auto____5105) {
          return or__3548__auto____5105
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____5106 = o;
    if(and__3546__auto____5106) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____5106
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____5107 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5107) {
        return or__3548__auto____5107
      }else {
        var or__3548__auto____5108 = cljs.core._pr_seq["_"];
        if(or__3548__auto____5108) {
          return or__3548__auto____5108
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____5109 = d;
    if(and__3546__auto____5109) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____5109
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____5110 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____5110) {
        return or__3548__auto____5110
      }else {
        var or__3548__auto____5111 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____5111) {
          return or__3548__auto____5111
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____5112 = this$;
    if(and__3546__auto____5112) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____5112
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____5113 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5113) {
        return or__3548__auto____5113
      }else {
        var or__3548__auto____5114 = cljs.core._notify_watches["_"];
        if(or__3548__auto____5114) {
          return or__3548__auto____5114
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____5115 = this$;
    if(and__3546__auto____5115) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____5115
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____5116 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5116) {
        return or__3548__auto____5116
      }else {
        var or__3548__auto____5117 = cljs.core._add_watch["_"];
        if(or__3548__auto____5117) {
          return or__3548__auto____5117
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____5118 = this$;
    if(and__3546__auto____5118) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____5118
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____5119 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5119) {
        return or__3548__auto____5119
      }else {
        var or__3548__auto____5120 = cljs.core._remove_watch["_"];
        if(or__3548__auto____5120) {
          return or__3548__auto____5120
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____5121 = coll;
    if(and__3546__auto____5121) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____5121
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5122 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5122) {
        return or__3548__auto____5122
      }else {
        var or__3548__auto____5123 = cljs.core._as_transient["_"];
        if(or__3548__auto____5123) {
          return or__3548__auto____5123
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____5124 = tcoll;
    if(and__3546__auto____5124) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____5124
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____5125 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5125) {
        return or__3548__auto____5125
      }else {
        var or__3548__auto____5126 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____5126) {
          return or__3548__auto____5126
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5127 = tcoll;
    if(and__3546__auto____5127) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____5127
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5128 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5128) {
        return or__3548__auto____5128
      }else {
        var or__3548__auto____5129 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____5129) {
          return or__3548__auto____5129
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____5130 = tcoll;
    if(and__3546__auto____5130) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____5130
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____5131 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5131) {
        return or__3548__auto____5131
      }else {
        var or__3548__auto____5132 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____5132) {
          return or__3548__auto____5132
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____5133 = tcoll;
    if(and__3546__auto____5133) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____5133
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____5134 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5134) {
        return or__3548__auto____5134
      }else {
        var or__3548__auto____5135 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____5135) {
          return or__3548__auto____5135
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____5136 = tcoll;
    if(and__3546__auto____5136) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____5136
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____5137 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5137) {
        return or__3548__auto____5137
      }else {
        var or__3548__auto____5138 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____5138) {
          return or__3548__auto____5138
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5139 = tcoll;
    if(and__3546__auto____5139) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____5139
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5140 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5140) {
        return or__3548__auto____5140
      }else {
        var or__3548__auto____5141 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____5141) {
          return or__3548__auto____5141
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____5142 = tcoll;
    if(and__3546__auto____5142) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____5142
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____5143 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5143) {
        return or__3548__auto____5143
      }else {
        var or__3548__auto____5144 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____5144) {
          return or__3548__auto____5144
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____5145 = x === y;
    if(or__3548__auto____5145) {
      return or__3548__auto____5145
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__5146__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5147 = y;
            var G__5148 = cljs.core.first.call(null, more);
            var G__5149 = cljs.core.next.call(null, more);
            x = G__5147;
            y = G__5148;
            more = G__5149;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5146 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5146__delegate.call(this, x, y, more)
    };
    G__5146.cljs$lang$maxFixedArity = 2;
    G__5146.cljs$lang$applyTo = function(arglist__5150) {
      var x = cljs.core.first(arglist__5150);
      var y = cljs.core.first(cljs.core.next(arglist__5150));
      var more = cljs.core.rest(cljs.core.next(arglist__5150));
      return G__5146__delegate(x, y, more)
    };
    G__5146.cljs$lang$arity$variadic = G__5146__delegate;
    return G__5146
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____5151 = x == null;
    if(or__3548__auto____5151) {
      return or__3548__auto____5151
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__5152 = null;
  var G__5152__2 = function(o, k) {
    return null
  };
  var G__5152__3 = function(o, k, not_found) {
    return not_found
  };
  G__5152 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5152__2.call(this, o, k);
      case 3:
        return G__5152__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5152
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__5153 = null;
  var G__5153__2 = function(_, f) {
    return f.call(null)
  };
  var G__5153__3 = function(_, f, start) {
    return start
  };
  G__5153 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5153__2.call(this, _, f);
      case 3:
        return G__5153__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5153
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__5154 = null;
  var G__5154__2 = function(_, n) {
    return null
  };
  var G__5154__3 = function(_, n, not_found) {
    return not_found
  };
  G__5154 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5154__2.call(this, _, n);
      case 3:
        return G__5154__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5154
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__5155 = cljs.core._nth.call(null, cicoll, 0);
      var n__5156 = 1;
      while(true) {
        if(n__5156 < cljs.core._count.call(null, cicoll)) {
          var nval__5157 = f.call(null, val__5155, cljs.core._nth.call(null, cicoll, n__5156));
          if(cljs.core.reduced_QMARK_.call(null, nval__5157)) {
            return cljs.core.deref.call(null, nval__5157)
          }else {
            var G__5164 = nval__5157;
            var G__5165 = n__5156 + 1;
            val__5155 = G__5164;
            n__5156 = G__5165;
            continue
          }
        }else {
          return val__5155
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__5158 = val;
    var n__5159 = 0;
    while(true) {
      if(n__5159 < cljs.core._count.call(null, cicoll)) {
        var nval__5160 = f.call(null, val__5158, cljs.core._nth.call(null, cicoll, n__5159));
        if(cljs.core.reduced_QMARK_.call(null, nval__5160)) {
          return cljs.core.deref.call(null, nval__5160)
        }else {
          var G__5166 = nval__5160;
          var G__5167 = n__5159 + 1;
          val__5158 = G__5166;
          n__5159 = G__5167;
          continue
        }
      }else {
        return val__5158
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__5161 = val;
    var n__5162 = idx;
    while(true) {
      if(n__5162 < cljs.core._count.call(null, cicoll)) {
        var nval__5163 = f.call(null, val__5161, cljs.core._nth.call(null, cicoll, n__5162));
        if(cljs.core.reduced_QMARK_.call(null, nval__5163)) {
          return cljs.core.deref.call(null, nval__5163)
        }else {
          var G__5168 = nval__5163;
          var G__5169 = n__5162 + 1;
          val__5161 = G__5168;
          n__5162 = G__5169;
          continue
        }
      }else {
        return val__5161
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5170 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5171 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__5172 = this;
  var this$__5173 = this;
  return cljs.core.pr_str.call(null, this$__5173)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5174 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5174.a)) {
    return cljs.core.ci_reduce.call(null, this__5174.a, f, this__5174.a[this__5174.i], this__5174.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__5174.a[this__5174.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5175 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5175.a)) {
    return cljs.core.ci_reduce.call(null, this__5175.a, f, start, this__5175.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__5176 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__5177 = this;
  return this__5177.a.length - this__5177.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5178 = this;
  return this__5178.a[this__5178.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5179 = this;
  if(this__5179.i + 1 < this__5179.a.length) {
    return new cljs.core.IndexedSeq(this__5179.a, this__5179.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5180 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5181 = this;
  var i__5182 = n + this__5181.i;
  if(i__5182 < this__5181.a.length) {
    return this__5181.a[i__5182]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5183 = this;
  var i__5184 = n + this__5183.i;
  if(i__5184 < this__5183.a.length) {
    return this__5183.a[i__5184]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5185 = null;
  var G__5185__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5185__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5185 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5185__2.call(this, array, f);
      case 3:
        return G__5185__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5185
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5186 = null;
  var G__5186__2 = function(array, k) {
    return array[k]
  };
  var G__5186__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5186 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5186__2.call(this, array, k);
      case 3:
        return G__5186__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5186
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5187 = null;
  var G__5187__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5187__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5187 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5187__2.call(this, array, n);
      case 3:
        return G__5187__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5187
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5188__5189 = coll;
      if(G__5188__5189 != null) {
        if(function() {
          var or__3548__auto____5190 = G__5188__5189.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5190) {
            return or__3548__auto____5190
          }else {
            return G__5188__5189.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5188__5189.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5188__5189)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5188__5189)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5191__5192 = coll;
      if(G__5191__5192 != null) {
        if(function() {
          var or__3548__auto____5193 = G__5191__5192.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5193) {
            return or__3548__auto____5193
          }else {
            return G__5191__5192.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5191__5192.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5191__5192)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5191__5192)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5194 = cljs.core.seq.call(null, coll);
      if(s__5194 != null) {
        return cljs.core._first.call(null, s__5194)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5195__5196 = coll;
      if(G__5195__5196 != null) {
        if(function() {
          var or__3548__auto____5197 = G__5195__5196.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5197) {
            return or__3548__auto____5197
          }else {
            return G__5195__5196.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5195__5196.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5195__5196)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5195__5196)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5198 = cljs.core.seq.call(null, coll);
      if(s__5198 != null) {
        return cljs.core._rest.call(null, s__5198)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5199__5200 = coll;
      if(G__5199__5200 != null) {
        if(function() {
          var or__3548__auto____5201 = G__5199__5200.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5201) {
            return or__3548__auto____5201
          }else {
            return G__5199__5200.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5199__5200.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5199__5200)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5199__5200)
      }
    }()) {
      var coll__5202 = cljs.core._rest.call(null, coll);
      if(coll__5202 != null) {
        if(function() {
          var G__5203__5204 = coll__5202;
          if(G__5203__5204 != null) {
            if(function() {
              var or__3548__auto____5205 = G__5203__5204.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5205) {
                return or__3548__auto____5205
              }else {
                return G__5203__5204.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5203__5204.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5203__5204)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5203__5204)
          }
        }()) {
          return coll__5202
        }else {
          return cljs.core._seq.call(null, coll__5202)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5206 = cljs.core.next.call(null, s);
      s = G__5206;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5207__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5208 = conj.call(null, coll, x);
          var G__5209 = cljs.core.first.call(null, xs);
          var G__5210 = cljs.core.next.call(null, xs);
          coll = G__5208;
          x = G__5209;
          xs = G__5210;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5207 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5207__delegate.call(this, coll, x, xs)
    };
    G__5207.cljs$lang$maxFixedArity = 2;
    G__5207.cljs$lang$applyTo = function(arglist__5211) {
      var coll = cljs.core.first(arglist__5211);
      var x = cljs.core.first(cljs.core.next(arglist__5211));
      var xs = cljs.core.rest(cljs.core.next(arglist__5211));
      return G__5207__delegate(coll, x, xs)
    };
    G__5207.cljs$lang$arity$variadic = G__5207__delegate;
    return G__5207
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5212 = cljs.core.seq.call(null, coll);
  var acc__5213 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5212)) {
      return acc__5213 + cljs.core._count.call(null, s__5212)
    }else {
      var G__5214 = cljs.core.next.call(null, s__5212);
      var G__5215 = acc__5213 + 1;
      s__5212 = G__5214;
      acc__5213 = G__5215;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5216__5217 = coll;
        if(G__5216__5217 != null) {
          if(function() {
            var or__3548__auto____5218 = G__5216__5217.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5218) {
              return or__3548__auto____5218
            }else {
              return G__5216__5217.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5216__5217.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5216__5217)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5216__5217)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5219__5220 = coll;
        if(G__5219__5220 != null) {
          if(function() {
            var or__3548__auto____5221 = G__5219__5220.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5221) {
              return or__3548__auto____5221
            }else {
              return G__5219__5220.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5219__5220.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5219__5220)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5219__5220)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5223__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5222 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5224 = ret__5222;
          var G__5225 = cljs.core.first.call(null, kvs);
          var G__5226 = cljs.core.second.call(null, kvs);
          var G__5227 = cljs.core.nnext.call(null, kvs);
          coll = G__5224;
          k = G__5225;
          v = G__5226;
          kvs = G__5227;
          continue
        }else {
          return ret__5222
        }
        break
      }
    };
    var G__5223 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5223__delegate.call(this, coll, k, v, kvs)
    };
    G__5223.cljs$lang$maxFixedArity = 3;
    G__5223.cljs$lang$applyTo = function(arglist__5228) {
      var coll = cljs.core.first(arglist__5228);
      var k = cljs.core.first(cljs.core.next(arglist__5228));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5228)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5228)));
      return G__5223__delegate(coll, k, v, kvs)
    };
    G__5223.cljs$lang$arity$variadic = G__5223__delegate;
    return G__5223
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5230__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5229 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5231 = ret__5229;
          var G__5232 = cljs.core.first.call(null, ks);
          var G__5233 = cljs.core.next.call(null, ks);
          coll = G__5231;
          k = G__5232;
          ks = G__5233;
          continue
        }else {
          return ret__5229
        }
        break
      }
    };
    var G__5230 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5230__delegate.call(this, coll, k, ks)
    };
    G__5230.cljs$lang$maxFixedArity = 2;
    G__5230.cljs$lang$applyTo = function(arglist__5234) {
      var coll = cljs.core.first(arglist__5234);
      var k = cljs.core.first(cljs.core.next(arglist__5234));
      var ks = cljs.core.rest(cljs.core.next(arglist__5234));
      return G__5230__delegate(coll, k, ks)
    };
    G__5230.cljs$lang$arity$variadic = G__5230__delegate;
    return G__5230
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5235__5236 = o;
    if(G__5235__5236 != null) {
      if(function() {
        var or__3548__auto____5237 = G__5235__5236.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5237) {
          return or__3548__auto____5237
        }else {
          return G__5235__5236.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5235__5236.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5235__5236)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5235__5236)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5239__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5238 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5240 = ret__5238;
          var G__5241 = cljs.core.first.call(null, ks);
          var G__5242 = cljs.core.next.call(null, ks);
          coll = G__5240;
          k = G__5241;
          ks = G__5242;
          continue
        }else {
          return ret__5238
        }
        break
      }
    };
    var G__5239 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5239__delegate.call(this, coll, k, ks)
    };
    G__5239.cljs$lang$maxFixedArity = 2;
    G__5239.cljs$lang$applyTo = function(arglist__5243) {
      var coll = cljs.core.first(arglist__5243);
      var k = cljs.core.first(cljs.core.next(arglist__5243));
      var ks = cljs.core.rest(cljs.core.next(arglist__5243));
      return G__5239__delegate(coll, k, ks)
    };
    G__5239.cljs$lang$arity$variadic = G__5239__delegate;
    return G__5239
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5244__5245 = x;
    if(G__5244__5245 != null) {
      if(function() {
        var or__3548__auto____5246 = G__5244__5245.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5246) {
          return or__3548__auto____5246
        }else {
          return G__5244__5245.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5244__5245.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5244__5245)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5244__5245)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5247__5248 = x;
    if(G__5247__5248 != null) {
      if(function() {
        var or__3548__auto____5249 = G__5247__5248.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5249) {
          return or__3548__auto____5249
        }else {
          return G__5247__5248.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5247__5248.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5247__5248)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5247__5248)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5250__5251 = x;
  if(G__5250__5251 != null) {
    if(function() {
      var or__3548__auto____5252 = G__5250__5251.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5252) {
        return or__3548__auto____5252
      }else {
        return G__5250__5251.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5250__5251.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5250__5251)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5250__5251)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5253__5254 = x;
  if(G__5253__5254 != null) {
    if(function() {
      var or__3548__auto____5255 = G__5253__5254.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5255) {
        return or__3548__auto____5255
      }else {
        return G__5253__5254.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5253__5254.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5253__5254)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5253__5254)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5256__5257 = x;
  if(G__5256__5257 != null) {
    if(function() {
      var or__3548__auto____5258 = G__5256__5257.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5258) {
        return or__3548__auto____5258
      }else {
        return G__5256__5257.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5256__5257.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5256__5257)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5256__5257)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5259__5260 = x;
  if(G__5259__5260 != null) {
    if(function() {
      var or__3548__auto____5261 = G__5259__5260.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5261) {
        return or__3548__auto____5261
      }else {
        return G__5259__5260.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5259__5260.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5259__5260)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5259__5260)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5262__5263 = x;
  if(G__5262__5263 != null) {
    if(function() {
      var or__3548__auto____5264 = G__5262__5263.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5264) {
        return or__3548__auto____5264
      }else {
        return G__5262__5263.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5262__5263.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5262__5263)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5262__5263)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5265__5266 = x;
    if(G__5265__5266 != null) {
      if(function() {
        var or__3548__auto____5267 = G__5265__5266.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5267) {
          return or__3548__auto____5267
        }else {
          return G__5265__5266.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5265__5266.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5265__5266)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5265__5266)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5268__5269 = x;
  if(G__5268__5269 != null) {
    if(function() {
      var or__3548__auto____5270 = G__5268__5269.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5270) {
        return or__3548__auto____5270
      }else {
        return G__5268__5269.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5268__5269.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5268__5269)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5268__5269)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5271__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5271 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5271__delegate.call(this, keyvals)
    };
    G__5271.cljs$lang$maxFixedArity = 0;
    G__5271.cljs$lang$applyTo = function(arglist__5272) {
      var keyvals = cljs.core.seq(arglist__5272);
      return G__5271__delegate(keyvals)
    };
    G__5271.cljs$lang$arity$variadic = G__5271__delegate;
    return G__5271
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5273 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5273.push(key)
  });
  return keys__5273
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5274 = i;
  var j__5275 = j;
  var len__5276 = len;
  while(true) {
    if(len__5276 === 0) {
      return to
    }else {
      to[j__5275] = from[i__5274];
      var G__5277 = i__5274 + 1;
      var G__5278 = j__5275 + 1;
      var G__5279 = len__5276 - 1;
      i__5274 = G__5277;
      j__5275 = G__5278;
      len__5276 = G__5279;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5280 = i + (len - 1);
  var j__5281 = j + (len - 1);
  var len__5282 = len;
  while(true) {
    if(len__5282 === 0) {
      return to
    }else {
      to[j__5281] = from[i__5280];
      var G__5283 = i__5280 - 1;
      var G__5284 = j__5281 - 1;
      var G__5285 = len__5282 - 1;
      i__5280 = G__5283;
      j__5281 = G__5284;
      len__5282 = G__5285;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5286__5287 = s;
    if(G__5286__5287 != null) {
      if(function() {
        var or__3548__auto____5288 = G__5286__5287.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5288) {
          return or__3548__auto____5288
        }else {
          return G__5286__5287.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5286__5287.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5286__5287)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5286__5287)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5289__5290 = s;
  if(G__5289__5290 != null) {
    if(function() {
      var or__3548__auto____5291 = G__5289__5290.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5291) {
        return or__3548__auto____5291
      }else {
        return G__5289__5290.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5289__5290.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5289__5290)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5289__5290)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5292 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5292)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5293 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5293) {
        return or__3548__auto____5293
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5292
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5294 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5294)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5294
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5295 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5295)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5295
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5296 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5296) {
    return or__3548__auto____5296
  }else {
    var G__5297__5298 = f;
    if(G__5297__5298 != null) {
      if(function() {
        var or__3548__auto____5299 = G__5297__5298.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5299) {
          return or__3548__auto____5299
        }else {
          return G__5297__5298.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5297__5298.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5297__5298)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5297__5298)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5300 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5300) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5300
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5301 = coll;
    if(cljs.core.truth_(and__3546__auto____5301)) {
      var and__3546__auto____5302 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5302) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5302
      }
    }else {
      return and__3546__auto____5301
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5307__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5303 = cljs.core.set([y, x]);
        var xs__5304 = more;
        while(true) {
          var x__5305 = cljs.core.first.call(null, xs__5304);
          var etc__5306 = cljs.core.next.call(null, xs__5304);
          if(cljs.core.truth_(xs__5304)) {
            if(cljs.core.contains_QMARK_.call(null, s__5303, x__5305)) {
              return false
            }else {
              var G__5308 = cljs.core.conj.call(null, s__5303, x__5305);
              var G__5309 = etc__5306;
              s__5303 = G__5308;
              xs__5304 = G__5309;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5307 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5307__delegate.call(this, x, y, more)
    };
    G__5307.cljs$lang$maxFixedArity = 2;
    G__5307.cljs$lang$applyTo = function(arglist__5310) {
      var x = cljs.core.first(arglist__5310);
      var y = cljs.core.first(cljs.core.next(arglist__5310));
      var more = cljs.core.rest(cljs.core.next(arglist__5310));
      return G__5307__delegate(x, y, more)
    };
    G__5307.cljs$lang$arity$variadic = G__5307__delegate;
    return G__5307
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5311 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5311)) {
        return r__5311
      }else {
        if(cljs.core.truth_(r__5311)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5312 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5312, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5312)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5313 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5313)) {
      var s__5314 = temp__3695__auto____5313;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5314), cljs.core.next.call(null, s__5314))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5315 = val;
    var coll__5316 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5316)) {
        var nval__5317 = f.call(null, val__5315, cljs.core.first.call(null, coll__5316));
        if(cljs.core.reduced_QMARK_.call(null, nval__5317)) {
          return cljs.core.deref.call(null, nval__5317)
        }else {
          var G__5318 = nval__5317;
          var G__5319 = cljs.core.next.call(null, coll__5316);
          val__5315 = G__5318;
          coll__5316 = G__5319;
          continue
        }
      }else {
        return val__5315
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5320__5321 = coll;
      if(G__5320__5321 != null) {
        if(function() {
          var or__3548__auto____5322 = G__5320__5321.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5322) {
            return or__3548__auto____5322
          }else {
            return G__5320__5321.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5320__5321.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5320__5321)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5320__5321)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5323__5324 = coll;
      if(G__5323__5324 != null) {
        if(function() {
          var or__3548__auto____5325 = G__5323__5324.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5325) {
            return or__3548__auto____5325
          }else {
            return G__5323__5324.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5323__5324.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5323__5324)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5323__5324)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5326 = this;
  return this__5326.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5327__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5327 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5327__delegate.call(this, x, y, more)
    };
    G__5327.cljs$lang$maxFixedArity = 2;
    G__5327.cljs$lang$applyTo = function(arglist__5328) {
      var x = cljs.core.first(arglist__5328);
      var y = cljs.core.first(cljs.core.next(arglist__5328));
      var more = cljs.core.rest(cljs.core.next(arglist__5328));
      return G__5327__delegate(x, y, more)
    };
    G__5327.cljs$lang$arity$variadic = G__5327__delegate;
    return G__5327
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5329__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5329 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5329__delegate.call(this, x, y, more)
    };
    G__5329.cljs$lang$maxFixedArity = 2;
    G__5329.cljs$lang$applyTo = function(arglist__5330) {
      var x = cljs.core.first(arglist__5330);
      var y = cljs.core.first(cljs.core.next(arglist__5330));
      var more = cljs.core.rest(cljs.core.next(arglist__5330));
      return G__5329__delegate(x, y, more)
    };
    G__5329.cljs$lang$arity$variadic = G__5329__delegate;
    return G__5329
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5331__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5331 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5331__delegate.call(this, x, y, more)
    };
    G__5331.cljs$lang$maxFixedArity = 2;
    G__5331.cljs$lang$applyTo = function(arglist__5332) {
      var x = cljs.core.first(arglist__5332);
      var y = cljs.core.first(cljs.core.next(arglist__5332));
      var more = cljs.core.rest(cljs.core.next(arglist__5332));
      return G__5331__delegate(x, y, more)
    };
    G__5331.cljs$lang$arity$variadic = G__5331__delegate;
    return G__5331
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5333__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5333 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5333__delegate.call(this, x, y, more)
    };
    G__5333.cljs$lang$maxFixedArity = 2;
    G__5333.cljs$lang$applyTo = function(arglist__5334) {
      var x = cljs.core.first(arglist__5334);
      var y = cljs.core.first(cljs.core.next(arglist__5334));
      var more = cljs.core.rest(cljs.core.next(arglist__5334));
      return G__5333__delegate(x, y, more)
    };
    G__5333.cljs$lang$arity$variadic = G__5333__delegate;
    return G__5333
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5335__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5336 = y;
            var G__5337 = cljs.core.first.call(null, more);
            var G__5338 = cljs.core.next.call(null, more);
            x = G__5336;
            y = G__5337;
            more = G__5338;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5335 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5335__delegate.call(this, x, y, more)
    };
    G__5335.cljs$lang$maxFixedArity = 2;
    G__5335.cljs$lang$applyTo = function(arglist__5339) {
      var x = cljs.core.first(arglist__5339);
      var y = cljs.core.first(cljs.core.next(arglist__5339));
      var more = cljs.core.rest(cljs.core.next(arglist__5339));
      return G__5335__delegate(x, y, more)
    };
    G__5335.cljs$lang$arity$variadic = G__5335__delegate;
    return G__5335
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5340__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5341 = y;
            var G__5342 = cljs.core.first.call(null, more);
            var G__5343 = cljs.core.next.call(null, more);
            x = G__5341;
            y = G__5342;
            more = G__5343;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5340 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5340__delegate.call(this, x, y, more)
    };
    G__5340.cljs$lang$maxFixedArity = 2;
    G__5340.cljs$lang$applyTo = function(arglist__5344) {
      var x = cljs.core.first(arglist__5344);
      var y = cljs.core.first(cljs.core.next(arglist__5344));
      var more = cljs.core.rest(cljs.core.next(arglist__5344));
      return G__5340__delegate(x, y, more)
    };
    G__5340.cljs$lang$arity$variadic = G__5340__delegate;
    return G__5340
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5345__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5346 = y;
            var G__5347 = cljs.core.first.call(null, more);
            var G__5348 = cljs.core.next.call(null, more);
            x = G__5346;
            y = G__5347;
            more = G__5348;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5345 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5345__delegate.call(this, x, y, more)
    };
    G__5345.cljs$lang$maxFixedArity = 2;
    G__5345.cljs$lang$applyTo = function(arglist__5349) {
      var x = cljs.core.first(arglist__5349);
      var y = cljs.core.first(cljs.core.next(arglist__5349));
      var more = cljs.core.rest(cljs.core.next(arglist__5349));
      return G__5345__delegate(x, y, more)
    };
    G__5345.cljs$lang$arity$variadic = G__5345__delegate;
    return G__5345
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5350__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5351 = y;
            var G__5352 = cljs.core.first.call(null, more);
            var G__5353 = cljs.core.next.call(null, more);
            x = G__5351;
            y = G__5352;
            more = G__5353;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5350 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5350__delegate.call(this, x, y, more)
    };
    G__5350.cljs$lang$maxFixedArity = 2;
    G__5350.cljs$lang$applyTo = function(arglist__5354) {
      var x = cljs.core.first(arglist__5354);
      var y = cljs.core.first(cljs.core.next(arglist__5354));
      var more = cljs.core.rest(cljs.core.next(arglist__5354));
      return G__5350__delegate(x, y, more)
    };
    G__5350.cljs$lang$arity$variadic = G__5350__delegate;
    return G__5350
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5355__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5355 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5355__delegate.call(this, x, y, more)
    };
    G__5355.cljs$lang$maxFixedArity = 2;
    G__5355.cljs$lang$applyTo = function(arglist__5356) {
      var x = cljs.core.first(arglist__5356);
      var y = cljs.core.first(cljs.core.next(arglist__5356));
      var more = cljs.core.rest(cljs.core.next(arglist__5356));
      return G__5355__delegate(x, y, more)
    };
    G__5355.cljs$lang$arity$variadic = G__5355__delegate;
    return G__5355
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5357__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5357 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5357__delegate.call(this, x, y, more)
    };
    G__5357.cljs$lang$maxFixedArity = 2;
    G__5357.cljs$lang$applyTo = function(arglist__5358) {
      var x = cljs.core.first(arglist__5358);
      var y = cljs.core.first(cljs.core.next(arglist__5358));
      var more = cljs.core.rest(cljs.core.next(arglist__5358));
      return G__5357__delegate(x, y, more)
    };
    G__5357.cljs$lang$arity$variadic = G__5357__delegate;
    return G__5357
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5359 = n % d;
  return cljs.core.fix.call(null, (n - rem__5359) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5360 = cljs.core.quot.call(null, n, d);
  return n - d * q__5360
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5361 = 0;
  var n__5362 = n;
  while(true) {
    if(n__5362 === 0) {
      return c__5361
    }else {
      var G__5363 = c__5361 + 1;
      var G__5364 = n__5362 & n__5362 - 1;
      c__5361 = G__5363;
      n__5362 = G__5364;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5365__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5366 = y;
            var G__5367 = cljs.core.first.call(null, more);
            var G__5368 = cljs.core.next.call(null, more);
            x = G__5366;
            y = G__5367;
            more = G__5368;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5365 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5365__delegate.call(this, x, y, more)
    };
    G__5365.cljs$lang$maxFixedArity = 2;
    G__5365.cljs$lang$applyTo = function(arglist__5369) {
      var x = cljs.core.first(arglist__5369);
      var y = cljs.core.first(cljs.core.next(arglist__5369));
      var more = cljs.core.rest(cljs.core.next(arglist__5369));
      return G__5365__delegate(x, y, more)
    };
    G__5365.cljs$lang$arity$variadic = G__5365__delegate;
    return G__5365
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5370 = n;
  var xs__5371 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5372 = xs__5371;
      if(cljs.core.truth_(and__3546__auto____5372)) {
        return n__5370 > 0
      }else {
        return and__3546__auto____5372
      }
    }())) {
      var G__5373 = n__5370 - 1;
      var G__5374 = cljs.core.next.call(null, xs__5371);
      n__5370 = G__5373;
      xs__5371 = G__5374;
      continue
    }else {
      return xs__5371
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5375__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5376 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5377 = cljs.core.next.call(null, more);
            sb = G__5376;
            more = G__5377;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5375 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5375__delegate.call(this, x, ys)
    };
    G__5375.cljs$lang$maxFixedArity = 1;
    G__5375.cljs$lang$applyTo = function(arglist__5378) {
      var x = cljs.core.first(arglist__5378);
      var ys = cljs.core.rest(arglist__5378);
      return G__5375__delegate(x, ys)
    };
    G__5375.cljs$lang$arity$variadic = G__5375__delegate;
    return G__5375
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5379__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5380 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5381 = cljs.core.next.call(null, more);
            sb = G__5380;
            more = G__5381;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5379 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5379__delegate.call(this, x, ys)
    };
    G__5379.cljs$lang$maxFixedArity = 1;
    G__5379.cljs$lang$applyTo = function(arglist__5382) {
      var x = cljs.core.first(arglist__5382);
      var ys = cljs.core.rest(arglist__5382);
      return G__5379__delegate(x, ys)
    };
    G__5379.cljs$lang$arity$variadic = G__5379__delegate;
    return G__5379
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5383 = cljs.core.seq.call(null, x);
    var ys__5384 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5383 == null) {
        return ys__5384 == null
      }else {
        if(ys__5384 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5383), cljs.core.first.call(null, ys__5384))) {
            var G__5385 = cljs.core.next.call(null, xs__5383);
            var G__5386 = cljs.core.next.call(null, ys__5384);
            xs__5383 = G__5385;
            ys__5384 = G__5386;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5387_SHARP_, p2__5388_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5387_SHARP_, cljs.core.hash.call(null, p2__5388_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5389 = 0;
  var s__5390 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5390)) {
      var e__5391 = cljs.core.first.call(null, s__5390);
      var G__5392 = (h__5389 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5391)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5391)))) % 4503599627370496;
      var G__5393 = cljs.core.next.call(null, s__5390);
      h__5389 = G__5392;
      s__5390 = G__5393;
      continue
    }else {
      return h__5389
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5394 = 0;
  var s__5395 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5395)) {
      var e__5396 = cljs.core.first.call(null, s__5395);
      var G__5397 = (h__5394 + cljs.core.hash.call(null, e__5396)) % 4503599627370496;
      var G__5398 = cljs.core.next.call(null, s__5395);
      h__5394 = G__5397;
      s__5395 = G__5398;
      continue
    }else {
      return h__5394
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5399__5400 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5399__5400)) {
    var G__5402__5404 = cljs.core.first.call(null, G__5399__5400);
    var vec__5403__5405 = G__5402__5404;
    var key_name__5406 = cljs.core.nth.call(null, vec__5403__5405, 0, null);
    var f__5407 = cljs.core.nth.call(null, vec__5403__5405, 1, null);
    var G__5399__5408 = G__5399__5400;
    var G__5402__5409 = G__5402__5404;
    var G__5399__5410 = G__5399__5408;
    while(true) {
      var vec__5411__5412 = G__5402__5409;
      var key_name__5413 = cljs.core.nth.call(null, vec__5411__5412, 0, null);
      var f__5414 = cljs.core.nth.call(null, vec__5411__5412, 1, null);
      var G__5399__5415 = G__5399__5410;
      var str_name__5416 = cljs.core.name.call(null, key_name__5413);
      obj[str_name__5416] = f__5414;
      var temp__3698__auto____5417 = cljs.core.next.call(null, G__5399__5415);
      if(cljs.core.truth_(temp__3698__auto____5417)) {
        var G__5399__5418 = temp__3698__auto____5417;
        var G__5419 = cljs.core.first.call(null, G__5399__5418);
        var G__5420 = G__5399__5418;
        G__5402__5409 = G__5419;
        G__5399__5410 = G__5420;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5421 = this;
  var h__364__auto____5422 = this__5421.__hash;
  if(h__364__auto____5422 != null) {
    return h__364__auto____5422
  }else {
    var h__364__auto____5423 = cljs.core.hash_coll.call(null, coll);
    this__5421.__hash = h__364__auto____5423;
    return h__364__auto____5423
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5424 = this;
  return new cljs.core.List(this__5424.meta, o, coll, this__5424.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5425 = this;
  var this$__5426 = this;
  return cljs.core.pr_str.call(null, this$__5426)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5427 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5428 = this;
  return this__5428.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5429 = this;
  return this__5429.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5430 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5431 = this;
  return this__5431.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5432 = this;
  return this__5432.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5433 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5434 = this;
  return new cljs.core.List(meta, this__5434.first, this__5434.rest, this__5434.count, this__5434.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5435 = this;
  return this__5435.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5436 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5437 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5438 = this;
  return new cljs.core.List(this__5438.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5439 = this;
  var this$__5440 = this;
  return cljs.core.pr_str.call(null, this$__5440)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5441 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5442 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5443 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5444 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5445 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5446 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5447 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5448 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5449 = this;
  return this__5449.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5450 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5451__5452 = coll;
  if(G__5451__5452 != null) {
    if(function() {
      var or__3548__auto____5453 = G__5451__5452.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5453) {
        return or__3548__auto____5453
      }else {
        return G__5451__5452.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5451__5452.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5451__5452)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5451__5452)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5454) {
    var items = cljs.core.seq(arglist__5454);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5455 = this;
  var h__364__auto____5456 = this__5455.__hash;
  if(h__364__auto____5456 != null) {
    return h__364__auto____5456
  }else {
    var h__364__auto____5457 = cljs.core.hash_coll.call(null, coll);
    this__5455.__hash = h__364__auto____5457;
    return h__364__auto____5457
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5458 = this;
  return new cljs.core.Cons(null, o, coll, this__5458.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5459 = this;
  var this$__5460 = this;
  return cljs.core.pr_str.call(null, this$__5460)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5461 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5462 = this;
  return this__5462.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5463 = this;
  if(this__5463.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5463.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5464 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5465 = this;
  return new cljs.core.Cons(meta, this__5465.first, this__5465.rest, this__5465.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5466 = this;
  return this__5466.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5467 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5467.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5468 = coll == null;
    if(or__3548__auto____5468) {
      return or__3548__auto____5468
    }else {
      var G__5469__5470 = coll;
      if(G__5469__5470 != null) {
        if(function() {
          var or__3548__auto____5471 = G__5469__5470.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5471) {
            return or__3548__auto____5471
          }else {
            return G__5469__5470.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5469__5470.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5469__5470)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5469__5470)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5472__5473 = x;
  if(G__5472__5473 != null) {
    if(function() {
      var or__3548__auto____5474 = G__5472__5473.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5474) {
        return or__3548__auto____5474
      }else {
        return G__5472__5473.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5472__5473.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5472__5473)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5472__5473)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5475 = null;
  var G__5475__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5475__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5475 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5475__2.call(this, string, f);
      case 3:
        return G__5475__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5475
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5476 = null;
  var G__5476__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5476__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5476 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5476__2.call(this, string, k);
      case 3:
        return G__5476__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5476
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5477 = null;
  var G__5477__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5477__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5477 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5477__2.call(this, string, n);
      case 3:
        return G__5477__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5477
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5486 = null;
  var G__5486__2 = function(tsym5480, coll) {
    var tsym5480__5482 = this;
    var this$__5483 = tsym5480__5482;
    return cljs.core.get.call(null, coll, this$__5483.toString())
  };
  var G__5486__3 = function(tsym5481, coll, not_found) {
    var tsym5481__5484 = this;
    var this$__5485 = tsym5481__5484;
    return cljs.core.get.call(null, coll, this$__5485.toString(), not_found)
  };
  G__5486 = function(tsym5481, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5486__2.call(this, tsym5481, coll);
      case 3:
        return G__5486__3.call(this, tsym5481, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5486
}();
String.prototype.apply = function(tsym5478, args5479) {
  return tsym5478.call.apply(tsym5478, [tsym5478].concat(cljs.core.aclone.call(null, args5479)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5487 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5487
  }else {
    lazy_seq.x = x__5487.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5488 = this;
  var h__364__auto____5489 = this__5488.__hash;
  if(h__364__auto____5489 != null) {
    return h__364__auto____5489
  }else {
    var h__364__auto____5490 = cljs.core.hash_coll.call(null, coll);
    this__5488.__hash = h__364__auto____5490;
    return h__364__auto____5490
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5491 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5492 = this;
  var this$__5493 = this;
  return cljs.core.pr_str.call(null, this$__5493)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5494 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5495 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5496 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5497 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5498 = this;
  return new cljs.core.LazySeq(meta, this__5498.realized, this__5498.x, this__5498.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5499 = this;
  return this__5499.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5500 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5500.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5501 = [];
  var s__5502 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5502))) {
      ary__5501.push(cljs.core.first.call(null, s__5502));
      var G__5503 = cljs.core.next.call(null, s__5502);
      s__5502 = G__5503;
      continue
    }else {
      return ary__5501
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5504 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5505 = 0;
  var xs__5506 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5506)) {
      ret__5504[i__5505] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5506));
      var G__5507 = i__5505 + 1;
      var G__5508 = cljs.core.next.call(null, xs__5506);
      i__5505 = G__5507;
      xs__5506 = G__5508;
      continue
    }else {
    }
    break
  }
  return ret__5504
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5509 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5510 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5511 = 0;
      var s__5512 = s__5510;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5513 = s__5512;
          if(cljs.core.truth_(and__3546__auto____5513)) {
            return i__5511 < size
          }else {
            return and__3546__auto____5513
          }
        }())) {
          a__5509[i__5511] = cljs.core.first.call(null, s__5512);
          var G__5516 = i__5511 + 1;
          var G__5517 = cljs.core.next.call(null, s__5512);
          i__5511 = G__5516;
          s__5512 = G__5517;
          continue
        }else {
          return a__5509
        }
        break
      }
    }else {
      var n__685__auto____5514 = size;
      var i__5515 = 0;
      while(true) {
        if(i__5515 < n__685__auto____5514) {
          a__5509[i__5515] = init_val_or_seq;
          var G__5518 = i__5515 + 1;
          i__5515 = G__5518;
          continue
        }else {
        }
        break
      }
      return a__5509
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5519 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5520 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5521 = 0;
      var s__5522 = s__5520;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5523 = s__5522;
          if(cljs.core.truth_(and__3546__auto____5523)) {
            return i__5521 < size
          }else {
            return and__3546__auto____5523
          }
        }())) {
          a__5519[i__5521] = cljs.core.first.call(null, s__5522);
          var G__5526 = i__5521 + 1;
          var G__5527 = cljs.core.next.call(null, s__5522);
          i__5521 = G__5526;
          s__5522 = G__5527;
          continue
        }else {
          return a__5519
        }
        break
      }
    }else {
      var n__685__auto____5524 = size;
      var i__5525 = 0;
      while(true) {
        if(i__5525 < n__685__auto____5524) {
          a__5519[i__5525] = init_val_or_seq;
          var G__5528 = i__5525 + 1;
          i__5525 = G__5528;
          continue
        }else {
        }
        break
      }
      return a__5519
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5529 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5530 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5531 = 0;
      var s__5532 = s__5530;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5533 = s__5532;
          if(cljs.core.truth_(and__3546__auto____5533)) {
            return i__5531 < size
          }else {
            return and__3546__auto____5533
          }
        }())) {
          a__5529[i__5531] = cljs.core.first.call(null, s__5532);
          var G__5536 = i__5531 + 1;
          var G__5537 = cljs.core.next.call(null, s__5532);
          i__5531 = G__5536;
          s__5532 = G__5537;
          continue
        }else {
          return a__5529
        }
        break
      }
    }else {
      var n__685__auto____5534 = size;
      var i__5535 = 0;
      while(true) {
        if(i__5535 < n__685__auto____5534) {
          a__5529[i__5535] = init_val_or_seq;
          var G__5538 = i__5535 + 1;
          i__5535 = G__5538;
          continue
        }else {
        }
        break
      }
      return a__5529
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5539 = s;
    var i__5540 = n;
    var sum__5541 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5542 = i__5540 > 0;
        if(and__3546__auto____5542) {
          return cljs.core.seq.call(null, s__5539)
        }else {
          return and__3546__auto____5542
        }
      }())) {
        var G__5543 = cljs.core.next.call(null, s__5539);
        var G__5544 = i__5540 - 1;
        var G__5545 = sum__5541 + 1;
        s__5539 = G__5543;
        i__5540 = G__5544;
        sum__5541 = G__5545;
        continue
      }else {
        return sum__5541
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5546 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5546)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5546), concat.call(null, cljs.core.rest.call(null, s__5546), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5549__delegate = function(x, y, zs) {
      var cat__5548 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5547 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5547)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5547), cat.call(null, cljs.core.rest.call(null, xys__5547), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5548.call(null, concat.call(null, x, y), zs)
    };
    var G__5549 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5549__delegate.call(this, x, y, zs)
    };
    G__5549.cljs$lang$maxFixedArity = 2;
    G__5549.cljs$lang$applyTo = function(arglist__5550) {
      var x = cljs.core.first(arglist__5550);
      var y = cljs.core.first(cljs.core.next(arglist__5550));
      var zs = cljs.core.rest(cljs.core.next(arglist__5550));
      return G__5549__delegate(x, y, zs)
    };
    G__5549.cljs$lang$arity$variadic = G__5549__delegate;
    return G__5549
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5551__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5551 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5551__delegate.call(this, a, b, c, d, more)
    };
    G__5551.cljs$lang$maxFixedArity = 4;
    G__5551.cljs$lang$applyTo = function(arglist__5552) {
      var a = cljs.core.first(arglist__5552);
      var b = cljs.core.first(cljs.core.next(arglist__5552));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5552)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5552))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5552))));
      return G__5551__delegate(a, b, c, d, more)
    };
    G__5551.cljs$lang$arity$variadic = G__5551__delegate;
    return G__5551
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5553 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5554 = cljs.core._first.call(null, args__5553);
    var args__5555 = cljs.core._rest.call(null, args__5553);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5554)
      }else {
        return f.call(null, a__5554)
      }
    }else {
      var b__5556 = cljs.core._first.call(null, args__5555);
      var args__5557 = cljs.core._rest.call(null, args__5555);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5554, b__5556)
        }else {
          return f.call(null, a__5554, b__5556)
        }
      }else {
        var c__5558 = cljs.core._first.call(null, args__5557);
        var args__5559 = cljs.core._rest.call(null, args__5557);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5554, b__5556, c__5558)
          }else {
            return f.call(null, a__5554, b__5556, c__5558)
          }
        }else {
          var d__5560 = cljs.core._first.call(null, args__5559);
          var args__5561 = cljs.core._rest.call(null, args__5559);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5554, b__5556, c__5558, d__5560)
            }else {
              return f.call(null, a__5554, b__5556, c__5558, d__5560)
            }
          }else {
            var e__5562 = cljs.core._first.call(null, args__5561);
            var args__5563 = cljs.core._rest.call(null, args__5561);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5554, b__5556, c__5558, d__5560, e__5562)
              }else {
                return f.call(null, a__5554, b__5556, c__5558, d__5560, e__5562)
              }
            }else {
              var f__5564 = cljs.core._first.call(null, args__5563);
              var args__5565 = cljs.core._rest.call(null, args__5563);
              if(argc === 6) {
                if(f__5564.cljs$lang$arity$6) {
                  return f__5564.cljs$lang$arity$6(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564)
                }else {
                  return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564)
                }
              }else {
                var g__5566 = cljs.core._first.call(null, args__5565);
                var args__5567 = cljs.core._rest.call(null, args__5565);
                if(argc === 7) {
                  if(f__5564.cljs$lang$arity$7) {
                    return f__5564.cljs$lang$arity$7(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566)
                  }else {
                    return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566)
                  }
                }else {
                  var h__5568 = cljs.core._first.call(null, args__5567);
                  var args__5569 = cljs.core._rest.call(null, args__5567);
                  if(argc === 8) {
                    if(f__5564.cljs$lang$arity$8) {
                      return f__5564.cljs$lang$arity$8(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568)
                    }else {
                      return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568)
                    }
                  }else {
                    var i__5570 = cljs.core._first.call(null, args__5569);
                    var args__5571 = cljs.core._rest.call(null, args__5569);
                    if(argc === 9) {
                      if(f__5564.cljs$lang$arity$9) {
                        return f__5564.cljs$lang$arity$9(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570)
                      }else {
                        return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570)
                      }
                    }else {
                      var j__5572 = cljs.core._first.call(null, args__5571);
                      var args__5573 = cljs.core._rest.call(null, args__5571);
                      if(argc === 10) {
                        if(f__5564.cljs$lang$arity$10) {
                          return f__5564.cljs$lang$arity$10(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572)
                        }else {
                          return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572)
                        }
                      }else {
                        var k__5574 = cljs.core._first.call(null, args__5573);
                        var args__5575 = cljs.core._rest.call(null, args__5573);
                        if(argc === 11) {
                          if(f__5564.cljs$lang$arity$11) {
                            return f__5564.cljs$lang$arity$11(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574)
                          }else {
                            return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574)
                          }
                        }else {
                          var l__5576 = cljs.core._first.call(null, args__5575);
                          var args__5577 = cljs.core._rest.call(null, args__5575);
                          if(argc === 12) {
                            if(f__5564.cljs$lang$arity$12) {
                              return f__5564.cljs$lang$arity$12(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576)
                            }else {
                              return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576)
                            }
                          }else {
                            var m__5578 = cljs.core._first.call(null, args__5577);
                            var args__5579 = cljs.core._rest.call(null, args__5577);
                            if(argc === 13) {
                              if(f__5564.cljs$lang$arity$13) {
                                return f__5564.cljs$lang$arity$13(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578)
                              }else {
                                return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578)
                              }
                            }else {
                              var n__5580 = cljs.core._first.call(null, args__5579);
                              var args__5581 = cljs.core._rest.call(null, args__5579);
                              if(argc === 14) {
                                if(f__5564.cljs$lang$arity$14) {
                                  return f__5564.cljs$lang$arity$14(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580)
                                }else {
                                  return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580)
                                }
                              }else {
                                var o__5582 = cljs.core._first.call(null, args__5581);
                                var args__5583 = cljs.core._rest.call(null, args__5581);
                                if(argc === 15) {
                                  if(f__5564.cljs$lang$arity$15) {
                                    return f__5564.cljs$lang$arity$15(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582)
                                  }else {
                                    return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582)
                                  }
                                }else {
                                  var p__5584 = cljs.core._first.call(null, args__5583);
                                  var args__5585 = cljs.core._rest.call(null, args__5583);
                                  if(argc === 16) {
                                    if(f__5564.cljs$lang$arity$16) {
                                      return f__5564.cljs$lang$arity$16(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584)
                                    }else {
                                      return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584)
                                    }
                                  }else {
                                    var q__5586 = cljs.core._first.call(null, args__5585);
                                    var args__5587 = cljs.core._rest.call(null, args__5585);
                                    if(argc === 17) {
                                      if(f__5564.cljs$lang$arity$17) {
                                        return f__5564.cljs$lang$arity$17(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586)
                                      }else {
                                        return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586)
                                      }
                                    }else {
                                      var r__5588 = cljs.core._first.call(null, args__5587);
                                      var args__5589 = cljs.core._rest.call(null, args__5587);
                                      if(argc === 18) {
                                        if(f__5564.cljs$lang$arity$18) {
                                          return f__5564.cljs$lang$arity$18(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586, r__5588)
                                        }else {
                                          return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586, r__5588)
                                        }
                                      }else {
                                        var s__5590 = cljs.core._first.call(null, args__5589);
                                        var args__5591 = cljs.core._rest.call(null, args__5589);
                                        if(argc === 19) {
                                          if(f__5564.cljs$lang$arity$19) {
                                            return f__5564.cljs$lang$arity$19(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586, r__5588, s__5590)
                                          }else {
                                            return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586, r__5588, s__5590)
                                          }
                                        }else {
                                          var t__5592 = cljs.core._first.call(null, args__5591);
                                          var args__5593 = cljs.core._rest.call(null, args__5591);
                                          if(argc === 20) {
                                            if(f__5564.cljs$lang$arity$20) {
                                              return f__5564.cljs$lang$arity$20(a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586, r__5588, s__5590, t__5592)
                                            }else {
                                              return f__5564.call(null, a__5554, b__5556, c__5558, d__5560, e__5562, f__5564, g__5566, h__5568, i__5570, j__5572, k__5574, l__5576, m__5578, n__5580, o__5582, p__5584, q__5586, r__5588, s__5590, t__5592)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5594 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5595 = cljs.core.bounded_count.call(null, args, fixed_arity__5594 + 1);
      if(bc__5595 <= fixed_arity__5594) {
        return cljs.core.apply_to.call(null, f, bc__5595, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5596 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5597 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5598 = cljs.core.bounded_count.call(null, arglist__5596, fixed_arity__5597 + 1);
      if(bc__5598 <= fixed_arity__5597) {
        return cljs.core.apply_to.call(null, f, bc__5598, arglist__5596)
      }else {
        return f.cljs$lang$applyTo(arglist__5596)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5596))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5599 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5600 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5601 = cljs.core.bounded_count.call(null, arglist__5599, fixed_arity__5600 + 1);
      if(bc__5601 <= fixed_arity__5600) {
        return cljs.core.apply_to.call(null, f, bc__5601, arglist__5599)
      }else {
        return f.cljs$lang$applyTo(arglist__5599)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5599))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5602 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5603 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5604 = cljs.core.bounded_count.call(null, arglist__5602, fixed_arity__5603 + 1);
      if(bc__5604 <= fixed_arity__5603) {
        return cljs.core.apply_to.call(null, f, bc__5604, arglist__5602)
      }else {
        return f.cljs$lang$applyTo(arglist__5602)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5602))
    }
  };
  var apply__6 = function() {
    var G__5608__delegate = function(f, a, b, c, d, args) {
      var arglist__5605 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5606 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5607 = cljs.core.bounded_count.call(null, arglist__5605, fixed_arity__5606 + 1);
        if(bc__5607 <= fixed_arity__5606) {
          return cljs.core.apply_to.call(null, f, bc__5607, arglist__5605)
        }else {
          return f.cljs$lang$applyTo(arglist__5605)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5605))
      }
    };
    var G__5608 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5608__delegate.call(this, f, a, b, c, d, args)
    };
    G__5608.cljs$lang$maxFixedArity = 5;
    G__5608.cljs$lang$applyTo = function(arglist__5609) {
      var f = cljs.core.first(arglist__5609);
      var a = cljs.core.first(cljs.core.next(arglist__5609));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5609)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5609))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5609)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5609)))));
      return G__5608__delegate(f, a, b, c, d, args)
    };
    G__5608.cljs$lang$arity$variadic = G__5608__delegate;
    return G__5608
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5610) {
    var obj = cljs.core.first(arglist__5610);
    var f = cljs.core.first(cljs.core.next(arglist__5610));
    var args = cljs.core.rest(cljs.core.next(arglist__5610));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5611__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5611 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5611__delegate.call(this, x, y, more)
    };
    G__5611.cljs$lang$maxFixedArity = 2;
    G__5611.cljs$lang$applyTo = function(arglist__5612) {
      var x = cljs.core.first(arglist__5612);
      var y = cljs.core.first(cljs.core.next(arglist__5612));
      var more = cljs.core.rest(cljs.core.next(arglist__5612));
      return G__5611__delegate(x, y, more)
    };
    G__5611.cljs$lang$arity$variadic = G__5611__delegate;
    return G__5611
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5613 = pred;
        var G__5614 = cljs.core.next.call(null, coll);
        pred = G__5613;
        coll = G__5614;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5615 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5615)) {
        return or__3548__auto____5615
      }else {
        var G__5616 = pred;
        var G__5617 = cljs.core.next.call(null, coll);
        pred = G__5616;
        coll = G__5617;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5618 = null;
    var G__5618__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5618__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5618__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5618__3 = function() {
      var G__5619__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5619 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5619__delegate.call(this, x, y, zs)
      };
      G__5619.cljs$lang$maxFixedArity = 2;
      G__5619.cljs$lang$applyTo = function(arglist__5620) {
        var x = cljs.core.first(arglist__5620);
        var y = cljs.core.first(cljs.core.next(arglist__5620));
        var zs = cljs.core.rest(cljs.core.next(arglist__5620));
        return G__5619__delegate(x, y, zs)
      };
      G__5619.cljs$lang$arity$variadic = G__5619__delegate;
      return G__5619
    }();
    G__5618 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5618__0.call(this);
        case 1:
          return G__5618__1.call(this, x);
        case 2:
          return G__5618__2.call(this, x, y);
        default:
          return G__5618__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5618.cljs$lang$maxFixedArity = 2;
    G__5618.cljs$lang$applyTo = G__5618__3.cljs$lang$applyTo;
    return G__5618
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5621__delegate = function(args) {
      return x
    };
    var G__5621 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5621__delegate.call(this, args)
    };
    G__5621.cljs$lang$maxFixedArity = 0;
    G__5621.cljs$lang$applyTo = function(arglist__5622) {
      var args = cljs.core.seq(arglist__5622);
      return G__5621__delegate(args)
    };
    G__5621.cljs$lang$arity$variadic = G__5621__delegate;
    return G__5621
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5626 = null;
      var G__5626__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5626__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5626__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5626__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5626__4 = function() {
        var G__5627__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5627 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5627__delegate.call(this, x, y, z, args)
        };
        G__5627.cljs$lang$maxFixedArity = 3;
        G__5627.cljs$lang$applyTo = function(arglist__5628) {
          var x = cljs.core.first(arglist__5628);
          var y = cljs.core.first(cljs.core.next(arglist__5628));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5628)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5628)));
          return G__5627__delegate(x, y, z, args)
        };
        G__5627.cljs$lang$arity$variadic = G__5627__delegate;
        return G__5627
      }();
      G__5626 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5626__0.call(this);
          case 1:
            return G__5626__1.call(this, x);
          case 2:
            return G__5626__2.call(this, x, y);
          case 3:
            return G__5626__3.call(this, x, y, z);
          default:
            return G__5626__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5626.cljs$lang$maxFixedArity = 3;
      G__5626.cljs$lang$applyTo = G__5626__4.cljs$lang$applyTo;
      return G__5626
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5629 = null;
      var G__5629__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5629__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5629__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5629__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5629__4 = function() {
        var G__5630__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5630 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5630__delegate.call(this, x, y, z, args)
        };
        G__5630.cljs$lang$maxFixedArity = 3;
        G__5630.cljs$lang$applyTo = function(arglist__5631) {
          var x = cljs.core.first(arglist__5631);
          var y = cljs.core.first(cljs.core.next(arglist__5631));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5631)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5631)));
          return G__5630__delegate(x, y, z, args)
        };
        G__5630.cljs$lang$arity$variadic = G__5630__delegate;
        return G__5630
      }();
      G__5629 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5629__0.call(this);
          case 1:
            return G__5629__1.call(this, x);
          case 2:
            return G__5629__2.call(this, x, y);
          case 3:
            return G__5629__3.call(this, x, y, z);
          default:
            return G__5629__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5629.cljs$lang$maxFixedArity = 3;
      G__5629.cljs$lang$applyTo = G__5629__4.cljs$lang$applyTo;
      return G__5629
    }()
  };
  var comp__4 = function() {
    var G__5632__delegate = function(f1, f2, f3, fs) {
      var fs__5623 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5633__delegate = function(args) {
          var ret__5624 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5623), args);
          var fs__5625 = cljs.core.next.call(null, fs__5623);
          while(true) {
            if(cljs.core.truth_(fs__5625)) {
              var G__5634 = cljs.core.first.call(null, fs__5625).call(null, ret__5624);
              var G__5635 = cljs.core.next.call(null, fs__5625);
              ret__5624 = G__5634;
              fs__5625 = G__5635;
              continue
            }else {
              return ret__5624
            }
            break
          }
        };
        var G__5633 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5633__delegate.call(this, args)
        };
        G__5633.cljs$lang$maxFixedArity = 0;
        G__5633.cljs$lang$applyTo = function(arglist__5636) {
          var args = cljs.core.seq(arglist__5636);
          return G__5633__delegate(args)
        };
        G__5633.cljs$lang$arity$variadic = G__5633__delegate;
        return G__5633
      }()
    };
    var G__5632 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5632__delegate.call(this, f1, f2, f3, fs)
    };
    G__5632.cljs$lang$maxFixedArity = 3;
    G__5632.cljs$lang$applyTo = function(arglist__5637) {
      var f1 = cljs.core.first(arglist__5637);
      var f2 = cljs.core.first(cljs.core.next(arglist__5637));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5637)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5637)));
      return G__5632__delegate(f1, f2, f3, fs)
    };
    G__5632.cljs$lang$arity$variadic = G__5632__delegate;
    return G__5632
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5638__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5638 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5638__delegate.call(this, args)
      };
      G__5638.cljs$lang$maxFixedArity = 0;
      G__5638.cljs$lang$applyTo = function(arglist__5639) {
        var args = cljs.core.seq(arglist__5639);
        return G__5638__delegate(args)
      };
      G__5638.cljs$lang$arity$variadic = G__5638__delegate;
      return G__5638
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5640__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5640 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5640__delegate.call(this, args)
      };
      G__5640.cljs$lang$maxFixedArity = 0;
      G__5640.cljs$lang$applyTo = function(arglist__5641) {
        var args = cljs.core.seq(arglist__5641);
        return G__5640__delegate(args)
      };
      G__5640.cljs$lang$arity$variadic = G__5640__delegate;
      return G__5640
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5642__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5642 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5642__delegate.call(this, args)
      };
      G__5642.cljs$lang$maxFixedArity = 0;
      G__5642.cljs$lang$applyTo = function(arglist__5643) {
        var args = cljs.core.seq(arglist__5643);
        return G__5642__delegate(args)
      };
      G__5642.cljs$lang$arity$variadic = G__5642__delegate;
      return G__5642
    }()
  };
  var partial__5 = function() {
    var G__5644__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5645__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5645 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5645__delegate.call(this, args)
        };
        G__5645.cljs$lang$maxFixedArity = 0;
        G__5645.cljs$lang$applyTo = function(arglist__5646) {
          var args = cljs.core.seq(arglist__5646);
          return G__5645__delegate(args)
        };
        G__5645.cljs$lang$arity$variadic = G__5645__delegate;
        return G__5645
      }()
    };
    var G__5644 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5644__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5644.cljs$lang$maxFixedArity = 4;
    G__5644.cljs$lang$applyTo = function(arglist__5647) {
      var f = cljs.core.first(arglist__5647);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5647));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5647)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5647))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5647))));
      return G__5644__delegate(f, arg1, arg2, arg3, more)
    };
    G__5644.cljs$lang$arity$variadic = G__5644__delegate;
    return G__5644
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5648 = null;
      var G__5648__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5648__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5648__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5648__4 = function() {
        var G__5649__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5649 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5649__delegate.call(this, a, b, c, ds)
        };
        G__5649.cljs$lang$maxFixedArity = 3;
        G__5649.cljs$lang$applyTo = function(arglist__5650) {
          var a = cljs.core.first(arglist__5650);
          var b = cljs.core.first(cljs.core.next(arglist__5650));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5650)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5650)));
          return G__5649__delegate(a, b, c, ds)
        };
        G__5649.cljs$lang$arity$variadic = G__5649__delegate;
        return G__5649
      }();
      G__5648 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5648__1.call(this, a);
          case 2:
            return G__5648__2.call(this, a, b);
          case 3:
            return G__5648__3.call(this, a, b, c);
          default:
            return G__5648__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5648.cljs$lang$maxFixedArity = 3;
      G__5648.cljs$lang$applyTo = G__5648__4.cljs$lang$applyTo;
      return G__5648
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5651 = null;
      var G__5651__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5651__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5651__4 = function() {
        var G__5652__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5652 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5652__delegate.call(this, a, b, c, ds)
        };
        G__5652.cljs$lang$maxFixedArity = 3;
        G__5652.cljs$lang$applyTo = function(arglist__5653) {
          var a = cljs.core.first(arglist__5653);
          var b = cljs.core.first(cljs.core.next(arglist__5653));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5653)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5653)));
          return G__5652__delegate(a, b, c, ds)
        };
        G__5652.cljs$lang$arity$variadic = G__5652__delegate;
        return G__5652
      }();
      G__5651 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5651__2.call(this, a, b);
          case 3:
            return G__5651__3.call(this, a, b, c);
          default:
            return G__5651__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5651.cljs$lang$maxFixedArity = 3;
      G__5651.cljs$lang$applyTo = G__5651__4.cljs$lang$applyTo;
      return G__5651
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5654 = null;
      var G__5654__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5654__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5654__4 = function() {
        var G__5655__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5655 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5655__delegate.call(this, a, b, c, ds)
        };
        G__5655.cljs$lang$maxFixedArity = 3;
        G__5655.cljs$lang$applyTo = function(arglist__5656) {
          var a = cljs.core.first(arglist__5656);
          var b = cljs.core.first(cljs.core.next(arglist__5656));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5656)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5656)));
          return G__5655__delegate(a, b, c, ds)
        };
        G__5655.cljs$lang$arity$variadic = G__5655__delegate;
        return G__5655
      }();
      G__5654 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5654__2.call(this, a, b);
          case 3:
            return G__5654__3.call(this, a, b, c);
          default:
            return G__5654__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5654.cljs$lang$maxFixedArity = 3;
      G__5654.cljs$lang$applyTo = G__5654__4.cljs$lang$applyTo;
      return G__5654
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5659 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5657 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5657)) {
        var s__5658 = temp__3698__auto____5657;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5658)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5658)))
      }else {
        return null
      }
    })
  };
  return mapi__5659.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5660 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5660)) {
      var s__5661 = temp__3698__auto____5660;
      var x__5662 = f.call(null, cljs.core.first.call(null, s__5661));
      if(x__5662 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5661))
      }else {
        return cljs.core.cons.call(null, x__5662, keep.call(null, f, cljs.core.rest.call(null, s__5661)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5672 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5669 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5669)) {
        var s__5670 = temp__3698__auto____5669;
        var x__5671 = f.call(null, idx, cljs.core.first.call(null, s__5670));
        if(x__5671 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5670))
        }else {
          return cljs.core.cons.call(null, x__5671, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5670)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5672.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5679 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5679)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5679
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5680 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5680)) {
            var and__3546__auto____5681 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5681)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5681
            }
          }else {
            return and__3546__auto____5680
          }
        }())
      };
      var ep1__4 = function() {
        var G__5717__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5682 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5682)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5682
            }
          }())
        };
        var G__5717 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5717__delegate.call(this, x, y, z, args)
        };
        G__5717.cljs$lang$maxFixedArity = 3;
        G__5717.cljs$lang$applyTo = function(arglist__5718) {
          var x = cljs.core.first(arglist__5718);
          var y = cljs.core.first(cljs.core.next(arglist__5718));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5718)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5718)));
          return G__5717__delegate(x, y, z, args)
        };
        G__5717.cljs$lang$arity$variadic = G__5717__delegate;
        return G__5717
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5683 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5683)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5683
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5684 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5684)) {
            var and__3546__auto____5685 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5685)) {
              var and__3546__auto____5686 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5686)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5686
              }
            }else {
              return and__3546__auto____5685
            }
          }else {
            return and__3546__auto____5684
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5687 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5687)) {
            var and__3546__auto____5688 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5688)) {
              var and__3546__auto____5689 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5689)) {
                var and__3546__auto____5690 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5690)) {
                  var and__3546__auto____5691 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5691)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5691
                  }
                }else {
                  return and__3546__auto____5690
                }
              }else {
                return and__3546__auto____5689
              }
            }else {
              return and__3546__auto____5688
            }
          }else {
            return and__3546__auto____5687
          }
        }())
      };
      var ep2__4 = function() {
        var G__5719__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5692 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5692)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5663_SHARP_) {
                var and__3546__auto____5693 = p1.call(null, p1__5663_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5693)) {
                  return p2.call(null, p1__5663_SHARP_)
                }else {
                  return and__3546__auto____5693
                }
              }, args)
            }else {
              return and__3546__auto____5692
            }
          }())
        };
        var G__5719 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5719__delegate.call(this, x, y, z, args)
        };
        G__5719.cljs$lang$maxFixedArity = 3;
        G__5719.cljs$lang$applyTo = function(arglist__5720) {
          var x = cljs.core.first(arglist__5720);
          var y = cljs.core.first(cljs.core.next(arglist__5720));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5720)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5720)));
          return G__5719__delegate(x, y, z, args)
        };
        G__5719.cljs$lang$arity$variadic = G__5719__delegate;
        return G__5719
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5694 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5694)) {
            var and__3546__auto____5695 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5695)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5695
            }
          }else {
            return and__3546__auto____5694
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5696 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5696)) {
            var and__3546__auto____5697 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5697)) {
              var and__3546__auto____5698 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5698)) {
                var and__3546__auto____5699 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5699)) {
                  var and__3546__auto____5700 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5700)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5700
                  }
                }else {
                  return and__3546__auto____5699
                }
              }else {
                return and__3546__auto____5698
              }
            }else {
              return and__3546__auto____5697
            }
          }else {
            return and__3546__auto____5696
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5701 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5701)) {
            var and__3546__auto____5702 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5702)) {
              var and__3546__auto____5703 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5703)) {
                var and__3546__auto____5704 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5704)) {
                  var and__3546__auto____5705 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5705)) {
                    var and__3546__auto____5706 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5706)) {
                      var and__3546__auto____5707 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5707)) {
                        var and__3546__auto____5708 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5708)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5708
                        }
                      }else {
                        return and__3546__auto____5707
                      }
                    }else {
                      return and__3546__auto____5706
                    }
                  }else {
                    return and__3546__auto____5705
                  }
                }else {
                  return and__3546__auto____5704
                }
              }else {
                return and__3546__auto____5703
              }
            }else {
              return and__3546__auto____5702
            }
          }else {
            return and__3546__auto____5701
          }
        }())
      };
      var ep3__4 = function() {
        var G__5721__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5709 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5709)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5664_SHARP_) {
                var and__3546__auto____5710 = p1.call(null, p1__5664_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5710)) {
                  var and__3546__auto____5711 = p2.call(null, p1__5664_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5711)) {
                    return p3.call(null, p1__5664_SHARP_)
                  }else {
                    return and__3546__auto____5711
                  }
                }else {
                  return and__3546__auto____5710
                }
              }, args)
            }else {
              return and__3546__auto____5709
            }
          }())
        };
        var G__5721 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5721__delegate.call(this, x, y, z, args)
        };
        G__5721.cljs$lang$maxFixedArity = 3;
        G__5721.cljs$lang$applyTo = function(arglist__5722) {
          var x = cljs.core.first(arglist__5722);
          var y = cljs.core.first(cljs.core.next(arglist__5722));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5722)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5722)));
          return G__5721__delegate(x, y, z, args)
        };
        G__5721.cljs$lang$arity$variadic = G__5721__delegate;
        return G__5721
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5723__delegate = function(p1, p2, p3, ps) {
      var ps__5712 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5665_SHARP_) {
            return p1__5665_SHARP_.call(null, x)
          }, ps__5712)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5666_SHARP_) {
            var and__3546__auto____5713 = p1__5666_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5713)) {
              return p1__5666_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5713
            }
          }, ps__5712)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5667_SHARP_) {
            var and__3546__auto____5714 = p1__5667_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5714)) {
              var and__3546__auto____5715 = p1__5667_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5715)) {
                return p1__5667_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5715
              }
            }else {
              return and__3546__auto____5714
            }
          }, ps__5712)
        };
        var epn__4 = function() {
          var G__5724__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5716 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5716)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5668_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5668_SHARP_, args)
                }, ps__5712)
              }else {
                return and__3546__auto____5716
              }
            }())
          };
          var G__5724 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5724__delegate.call(this, x, y, z, args)
          };
          G__5724.cljs$lang$maxFixedArity = 3;
          G__5724.cljs$lang$applyTo = function(arglist__5725) {
            var x = cljs.core.first(arglist__5725);
            var y = cljs.core.first(cljs.core.next(arglist__5725));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5725)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5725)));
            return G__5724__delegate(x, y, z, args)
          };
          G__5724.cljs$lang$arity$variadic = G__5724__delegate;
          return G__5724
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5723 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5723__delegate.call(this, p1, p2, p3, ps)
    };
    G__5723.cljs$lang$maxFixedArity = 3;
    G__5723.cljs$lang$applyTo = function(arglist__5726) {
      var p1 = cljs.core.first(arglist__5726);
      var p2 = cljs.core.first(cljs.core.next(arglist__5726));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5726)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5726)));
      return G__5723__delegate(p1, p2, p3, ps)
    };
    G__5723.cljs$lang$arity$variadic = G__5723__delegate;
    return G__5723
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5728 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5728)) {
          return or__3548__auto____5728
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5729 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5729)) {
          return or__3548__auto____5729
        }else {
          var or__3548__auto____5730 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5730)) {
            return or__3548__auto____5730
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5766__delegate = function(x, y, z, args) {
          var or__3548__auto____5731 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5731)) {
            return or__3548__auto____5731
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5766 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5766__delegate.call(this, x, y, z, args)
        };
        G__5766.cljs$lang$maxFixedArity = 3;
        G__5766.cljs$lang$applyTo = function(arglist__5767) {
          var x = cljs.core.first(arglist__5767);
          var y = cljs.core.first(cljs.core.next(arglist__5767));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5767)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5767)));
          return G__5766__delegate(x, y, z, args)
        };
        G__5766.cljs$lang$arity$variadic = G__5766__delegate;
        return G__5766
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5732 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5732)) {
          return or__3548__auto____5732
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5733 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5733)) {
          return or__3548__auto____5733
        }else {
          var or__3548__auto____5734 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5734)) {
            return or__3548__auto____5734
          }else {
            var or__3548__auto____5735 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5735)) {
              return or__3548__auto____5735
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5736 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5736)) {
          return or__3548__auto____5736
        }else {
          var or__3548__auto____5737 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5737)) {
            return or__3548__auto____5737
          }else {
            var or__3548__auto____5738 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5738)) {
              return or__3548__auto____5738
            }else {
              var or__3548__auto____5739 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5739)) {
                return or__3548__auto____5739
              }else {
                var or__3548__auto____5740 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5740)) {
                  return or__3548__auto____5740
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5768__delegate = function(x, y, z, args) {
          var or__3548__auto____5741 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5741)) {
            return or__3548__auto____5741
          }else {
            return cljs.core.some.call(null, function(p1__5673_SHARP_) {
              var or__3548__auto____5742 = p1.call(null, p1__5673_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5742)) {
                return or__3548__auto____5742
              }else {
                return p2.call(null, p1__5673_SHARP_)
              }
            }, args)
          }
        };
        var G__5768 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5768__delegate.call(this, x, y, z, args)
        };
        G__5768.cljs$lang$maxFixedArity = 3;
        G__5768.cljs$lang$applyTo = function(arglist__5769) {
          var x = cljs.core.first(arglist__5769);
          var y = cljs.core.first(cljs.core.next(arglist__5769));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5769)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5769)));
          return G__5768__delegate(x, y, z, args)
        };
        G__5768.cljs$lang$arity$variadic = G__5768__delegate;
        return G__5768
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5743 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5743)) {
          return or__3548__auto____5743
        }else {
          var or__3548__auto____5744 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5744)) {
            return or__3548__auto____5744
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5745 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5745)) {
          return or__3548__auto____5745
        }else {
          var or__3548__auto____5746 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5746)) {
            return or__3548__auto____5746
          }else {
            var or__3548__auto____5747 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5747)) {
              return or__3548__auto____5747
            }else {
              var or__3548__auto____5748 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5748)) {
                return or__3548__auto____5748
              }else {
                var or__3548__auto____5749 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5749)) {
                  return or__3548__auto____5749
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5750 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5750)) {
          return or__3548__auto____5750
        }else {
          var or__3548__auto____5751 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5751)) {
            return or__3548__auto____5751
          }else {
            var or__3548__auto____5752 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5752)) {
              return or__3548__auto____5752
            }else {
              var or__3548__auto____5753 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5753)) {
                return or__3548__auto____5753
              }else {
                var or__3548__auto____5754 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5754)) {
                  return or__3548__auto____5754
                }else {
                  var or__3548__auto____5755 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5755)) {
                    return or__3548__auto____5755
                  }else {
                    var or__3548__auto____5756 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5756)) {
                      return or__3548__auto____5756
                    }else {
                      var or__3548__auto____5757 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5757)) {
                        return or__3548__auto____5757
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5770__delegate = function(x, y, z, args) {
          var or__3548__auto____5758 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5758)) {
            return or__3548__auto____5758
          }else {
            return cljs.core.some.call(null, function(p1__5674_SHARP_) {
              var or__3548__auto____5759 = p1.call(null, p1__5674_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5759)) {
                return or__3548__auto____5759
              }else {
                var or__3548__auto____5760 = p2.call(null, p1__5674_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5760)) {
                  return or__3548__auto____5760
                }else {
                  return p3.call(null, p1__5674_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5770 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5770__delegate.call(this, x, y, z, args)
        };
        G__5770.cljs$lang$maxFixedArity = 3;
        G__5770.cljs$lang$applyTo = function(arglist__5771) {
          var x = cljs.core.first(arglist__5771);
          var y = cljs.core.first(cljs.core.next(arglist__5771));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5771)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5771)));
          return G__5770__delegate(x, y, z, args)
        };
        G__5770.cljs$lang$arity$variadic = G__5770__delegate;
        return G__5770
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5772__delegate = function(p1, p2, p3, ps) {
      var ps__5761 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5675_SHARP_) {
            return p1__5675_SHARP_.call(null, x)
          }, ps__5761)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5676_SHARP_) {
            var or__3548__auto____5762 = p1__5676_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5762)) {
              return or__3548__auto____5762
            }else {
              return p1__5676_SHARP_.call(null, y)
            }
          }, ps__5761)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5677_SHARP_) {
            var or__3548__auto____5763 = p1__5677_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5763)) {
              return or__3548__auto____5763
            }else {
              var or__3548__auto____5764 = p1__5677_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5764)) {
                return or__3548__auto____5764
              }else {
                return p1__5677_SHARP_.call(null, z)
              }
            }
          }, ps__5761)
        };
        var spn__4 = function() {
          var G__5773__delegate = function(x, y, z, args) {
            var or__3548__auto____5765 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5765)) {
              return or__3548__auto____5765
            }else {
              return cljs.core.some.call(null, function(p1__5678_SHARP_) {
                return cljs.core.some.call(null, p1__5678_SHARP_, args)
              }, ps__5761)
            }
          };
          var G__5773 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5773__delegate.call(this, x, y, z, args)
          };
          G__5773.cljs$lang$maxFixedArity = 3;
          G__5773.cljs$lang$applyTo = function(arglist__5774) {
            var x = cljs.core.first(arglist__5774);
            var y = cljs.core.first(cljs.core.next(arglist__5774));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5774)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5774)));
            return G__5773__delegate(x, y, z, args)
          };
          G__5773.cljs$lang$arity$variadic = G__5773__delegate;
          return G__5773
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5772 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5772__delegate.call(this, p1, p2, p3, ps)
    };
    G__5772.cljs$lang$maxFixedArity = 3;
    G__5772.cljs$lang$applyTo = function(arglist__5775) {
      var p1 = cljs.core.first(arglist__5775);
      var p2 = cljs.core.first(cljs.core.next(arglist__5775));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5775)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5775)));
      return G__5772__delegate(p1, p2, p3, ps)
    };
    G__5772.cljs$lang$arity$variadic = G__5772__delegate;
    return G__5772
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5776 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5776)) {
        var s__5777 = temp__3698__auto____5776;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5777)), map.call(null, f, cljs.core.rest.call(null, s__5777)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5778 = cljs.core.seq.call(null, c1);
      var s2__5779 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5780 = s1__5778;
        if(cljs.core.truth_(and__3546__auto____5780)) {
          return s2__5779
        }else {
          return and__3546__auto____5780
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5778), cljs.core.first.call(null, s2__5779)), map.call(null, f, cljs.core.rest.call(null, s1__5778), cljs.core.rest.call(null, s2__5779)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5781 = cljs.core.seq.call(null, c1);
      var s2__5782 = cljs.core.seq.call(null, c2);
      var s3__5783 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5784 = s1__5781;
        if(cljs.core.truth_(and__3546__auto____5784)) {
          var and__3546__auto____5785 = s2__5782;
          if(cljs.core.truth_(and__3546__auto____5785)) {
            return s3__5783
          }else {
            return and__3546__auto____5785
          }
        }else {
          return and__3546__auto____5784
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5781), cljs.core.first.call(null, s2__5782), cljs.core.first.call(null, s3__5783)), map.call(null, f, cljs.core.rest.call(null, s1__5781), cljs.core.rest.call(null, s2__5782), cljs.core.rest.call(null, s3__5783)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5788__delegate = function(f, c1, c2, c3, colls) {
      var step__5787 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5786 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5786)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5786), step.call(null, map.call(null, cljs.core.rest, ss__5786)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5727_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5727_SHARP_)
      }, step__5787.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5788 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5788__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5788.cljs$lang$maxFixedArity = 4;
    G__5788.cljs$lang$applyTo = function(arglist__5789) {
      var f = cljs.core.first(arglist__5789);
      var c1 = cljs.core.first(cljs.core.next(arglist__5789));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5789)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5789))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5789))));
      return G__5788__delegate(f, c1, c2, c3, colls)
    };
    G__5788.cljs$lang$arity$variadic = G__5788__delegate;
    return G__5788
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5790 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5790)) {
        var s__5791 = temp__3698__auto____5790;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5791), take.call(null, n - 1, cljs.core.rest.call(null, s__5791)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5794 = function(n, coll) {
    while(true) {
      var s__5792 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5793 = n > 0;
        if(and__3546__auto____5793) {
          return s__5792
        }else {
          return and__3546__auto____5793
        }
      }())) {
        var G__5795 = n - 1;
        var G__5796 = cljs.core.rest.call(null, s__5792);
        n = G__5795;
        coll = G__5796;
        continue
      }else {
        return s__5792
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5794.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5797 = cljs.core.seq.call(null, coll);
  var lead__5798 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5798)) {
      var G__5799 = cljs.core.next.call(null, s__5797);
      var G__5800 = cljs.core.next.call(null, lead__5798);
      s__5797 = G__5799;
      lead__5798 = G__5800;
      continue
    }else {
      return s__5797
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5803 = function(pred, coll) {
    while(true) {
      var s__5801 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5802 = s__5801;
        if(cljs.core.truth_(and__3546__auto____5802)) {
          return pred.call(null, cljs.core.first.call(null, s__5801))
        }else {
          return and__3546__auto____5802
        }
      }())) {
        var G__5804 = pred;
        var G__5805 = cljs.core.rest.call(null, s__5801);
        pred = G__5804;
        coll = G__5805;
        continue
      }else {
        return s__5801
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5803.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5806 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5806)) {
      var s__5807 = temp__3698__auto____5806;
      return cljs.core.concat.call(null, s__5807, cycle.call(null, s__5807))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5808 = cljs.core.seq.call(null, c1);
      var s2__5809 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5810 = s1__5808;
        if(cljs.core.truth_(and__3546__auto____5810)) {
          return s2__5809
        }else {
          return and__3546__auto____5810
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5808), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5809), interleave.call(null, cljs.core.rest.call(null, s1__5808), cljs.core.rest.call(null, s2__5809))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5812__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5811 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5811)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5811), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5811)))
        }else {
          return null
        }
      })
    };
    var G__5812 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5812__delegate.call(this, c1, c2, colls)
    };
    G__5812.cljs$lang$maxFixedArity = 2;
    G__5812.cljs$lang$applyTo = function(arglist__5813) {
      var c1 = cljs.core.first(arglist__5813);
      var c2 = cljs.core.first(cljs.core.next(arglist__5813));
      var colls = cljs.core.rest(cljs.core.next(arglist__5813));
      return G__5812__delegate(c1, c2, colls)
    };
    G__5812.cljs$lang$arity$variadic = G__5812__delegate;
    return G__5812
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5816 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5814 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5814)) {
        var coll__5815 = temp__3695__auto____5814;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5815), cat.call(null, cljs.core.rest.call(null, coll__5815), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5816.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5817__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5817 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5817__delegate.call(this, f, coll, colls)
    };
    G__5817.cljs$lang$maxFixedArity = 2;
    G__5817.cljs$lang$applyTo = function(arglist__5818) {
      var f = cljs.core.first(arglist__5818);
      var coll = cljs.core.first(cljs.core.next(arglist__5818));
      var colls = cljs.core.rest(cljs.core.next(arglist__5818));
      return G__5817__delegate(f, coll, colls)
    };
    G__5817.cljs$lang$arity$variadic = G__5817__delegate;
    return G__5817
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5819 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5819)) {
      var s__5820 = temp__3698__auto____5819;
      var f__5821 = cljs.core.first.call(null, s__5820);
      var r__5822 = cljs.core.rest.call(null, s__5820);
      if(cljs.core.truth_(pred.call(null, f__5821))) {
        return cljs.core.cons.call(null, f__5821, filter.call(null, pred, r__5822))
      }else {
        return filter.call(null, pred, r__5822)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5824 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5824.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5823_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5823_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5825__5826 = to;
    if(G__5825__5826 != null) {
      if(function() {
        var or__3548__auto____5827 = G__5825__5826.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5827) {
          return or__3548__auto____5827
        }else {
          return G__5825__5826.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5825__5826.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5825__5826)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5825__5826)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5828__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5828 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5828__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5828.cljs$lang$maxFixedArity = 4;
    G__5828.cljs$lang$applyTo = function(arglist__5829) {
      var f = cljs.core.first(arglist__5829);
      var c1 = cljs.core.first(cljs.core.next(arglist__5829));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5829)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5829))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5829))));
      return G__5828__delegate(f, c1, c2, c3, colls)
    };
    G__5828.cljs$lang$arity$variadic = G__5828__delegate;
    return G__5828
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5830 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5830)) {
        var s__5831 = temp__3698__auto____5830;
        var p__5832 = cljs.core.take.call(null, n, s__5831);
        if(n === cljs.core.count.call(null, p__5832)) {
          return cljs.core.cons.call(null, p__5832, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5831)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5833 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5833)) {
        var s__5834 = temp__3698__auto____5833;
        var p__5835 = cljs.core.take.call(null, n, s__5834);
        if(n === cljs.core.count.call(null, p__5835)) {
          return cljs.core.cons.call(null, p__5835, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5834)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5835, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5836 = cljs.core.lookup_sentinel;
    var m__5837 = m;
    var ks__5838 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5838)) {
        var m__5839 = cljs.core.get.call(null, m__5837, cljs.core.first.call(null, ks__5838), sentinel__5836);
        if(sentinel__5836 === m__5839) {
          return not_found
        }else {
          var G__5840 = sentinel__5836;
          var G__5841 = m__5839;
          var G__5842 = cljs.core.next.call(null, ks__5838);
          sentinel__5836 = G__5840;
          m__5837 = G__5841;
          ks__5838 = G__5842;
          continue
        }
      }else {
        return m__5837
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5843, v) {
  var vec__5844__5845 = p__5843;
  var k__5846 = cljs.core.nth.call(null, vec__5844__5845, 0, null);
  var ks__5847 = cljs.core.nthnext.call(null, vec__5844__5845, 1);
  if(cljs.core.truth_(ks__5847)) {
    return cljs.core.assoc.call(null, m, k__5846, assoc_in.call(null, cljs.core.get.call(null, m, k__5846), ks__5847, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5846, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5848, f, args) {
    var vec__5849__5850 = p__5848;
    var k__5851 = cljs.core.nth.call(null, vec__5849__5850, 0, null);
    var ks__5852 = cljs.core.nthnext.call(null, vec__5849__5850, 1);
    if(cljs.core.truth_(ks__5852)) {
      return cljs.core.assoc.call(null, m, k__5851, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5851), ks__5852, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5851, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5851), args))
    }
  };
  var update_in = function(m, p__5848, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5848, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5853) {
    var m = cljs.core.first(arglist__5853);
    var p__5848 = cljs.core.first(cljs.core.next(arglist__5853));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5853)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5853)));
    return update_in__delegate(m, p__5848, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5858 = this;
  var h__364__auto____5859 = this__5858.__hash;
  if(h__364__auto____5859 != null) {
    return h__364__auto____5859
  }else {
    var h__364__auto____5860 = cljs.core.hash_coll.call(null, coll);
    this__5858.__hash = h__364__auto____5860;
    return h__364__auto____5860
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5861 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5862 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5863 = this;
  var new_array__5864 = cljs.core.aclone.call(null, this__5863.array);
  new_array__5864[k] = v;
  return new cljs.core.Vector(this__5863.meta, new_array__5864, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5893 = null;
  var G__5893__2 = function(tsym5856, k) {
    var this__5865 = this;
    var tsym5856__5866 = this;
    var coll__5867 = tsym5856__5866;
    return cljs.core._lookup.call(null, coll__5867, k)
  };
  var G__5893__3 = function(tsym5857, k, not_found) {
    var this__5868 = this;
    var tsym5857__5869 = this;
    var coll__5870 = tsym5857__5869;
    return cljs.core._lookup.call(null, coll__5870, k, not_found)
  };
  G__5893 = function(tsym5857, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5893__2.call(this, tsym5857, k);
      case 3:
        return G__5893__3.call(this, tsym5857, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5893
}();
cljs.core.Vector.prototype.apply = function(tsym5854, args5855) {
  return tsym5854.call.apply(tsym5854, [tsym5854].concat(cljs.core.aclone.call(null, args5855)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5871 = this;
  var new_array__5872 = cljs.core.aclone.call(null, this__5871.array);
  new_array__5872.push(o);
  return new cljs.core.Vector(this__5871.meta, new_array__5872, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5873 = this;
  var this$__5874 = this;
  return cljs.core.pr_str.call(null, this$__5874)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5875 = this;
  return cljs.core.ci_reduce.call(null, this__5875.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5876 = this;
  return cljs.core.ci_reduce.call(null, this__5876.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5877 = this;
  if(this__5877.array.length > 0) {
    var vector_seq__5878 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5877.array.length) {
          return cljs.core.cons.call(null, this__5877.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5878.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5879 = this;
  return this__5879.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5880 = this;
  var count__5881 = this__5880.array.length;
  if(count__5881 > 0) {
    return this__5880.array[count__5881 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5882 = this;
  if(this__5882.array.length > 0) {
    var new_array__5883 = cljs.core.aclone.call(null, this__5882.array);
    new_array__5883.pop();
    return new cljs.core.Vector(this__5882.meta, new_array__5883, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5884 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5885 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5886 = this;
  return new cljs.core.Vector(meta, this__5886.array, this__5886.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5887 = this;
  return this__5887.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5889 = this;
  if(function() {
    var and__3546__auto____5890 = 0 <= n;
    if(and__3546__auto____5890) {
      return n < this__5889.array.length
    }else {
      return and__3546__auto____5890
    }
  }()) {
    return this__5889.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5891 = this;
  if(function() {
    var and__3546__auto____5892 = 0 <= n;
    if(and__3546__auto____5892) {
      return n < this__5891.array.length
    }else {
      return and__3546__auto____5892
    }
  }()) {
    return this__5891.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5888 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5888.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5894 = pv.cnt;
  if(cnt__5894 < 32) {
    return 0
  }else {
    return cnt__5894 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5895 = level;
  var ret__5896 = node;
  while(true) {
    if(ll__5895 === 0) {
      return ret__5896
    }else {
      var embed__5897 = ret__5896;
      var r__5898 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5899 = cljs.core.pv_aset.call(null, r__5898, 0, embed__5897);
      var G__5900 = ll__5895 - 5;
      var G__5901 = r__5898;
      ll__5895 = G__5900;
      ret__5896 = G__5901;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5902 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5903 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5902, subidx__5903, tailnode);
    return ret__5902
  }else {
    var temp__3695__auto____5904 = cljs.core.pv_aget.call(null, parent, subidx__5903);
    if(cljs.core.truth_(temp__3695__auto____5904)) {
      var child__5905 = temp__3695__auto____5904;
      var node_to_insert__5906 = push_tail.call(null, pv, level - 5, child__5905, tailnode);
      cljs.core.pv_aset.call(null, ret__5902, subidx__5903, node_to_insert__5906);
      return ret__5902
    }else {
      var node_to_insert__5907 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5902, subidx__5903, node_to_insert__5907);
      return ret__5902
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5908 = 0 <= i;
    if(and__3546__auto____5908) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5908
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5909 = pv.root;
      var level__5910 = pv.shift;
      while(true) {
        if(level__5910 > 0) {
          var G__5911 = cljs.core.pv_aget.call(null, node__5909, i >>> level__5910 & 31);
          var G__5912 = level__5910 - 5;
          node__5909 = G__5911;
          level__5910 = G__5912;
          continue
        }else {
          return node__5909.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5913 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5913, i & 31, val);
    return ret__5913
  }else {
    var subidx__5914 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5913, subidx__5914, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5914), i, val));
    return ret__5913
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5915 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5916 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5915));
    if(function() {
      var and__3546__auto____5917 = new_child__5916 == null;
      if(and__3546__auto____5917) {
        return subidx__5915 === 0
      }else {
        return and__3546__auto____5917
      }
    }()) {
      return null
    }else {
      var ret__5918 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5918, subidx__5915, new_child__5916);
      return ret__5918
    }
  }else {
    if(subidx__5915 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5919 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5919, subidx__5915, null);
        return ret__5919
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5920 = cljs.core._count.call(null, v);
  if(c__5920 > 0) {
    if(void 0 === cljs.core.t5921) {
      cljs.core.t5921 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5921.cljs$lang$type = true;
      cljs.core.t5921.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5921")
      };
      cljs.core.t5921.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5921.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5922 = this;
        return vseq
      };
      cljs.core.t5921.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5921.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5923 = this;
        return cljs.core._nth.call(null, this__5923.v, this__5923.offset)
      };
      cljs.core.t5921.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5924 = this;
        var offset__5925 = this__5924.offset + 1;
        if(offset__5925 < this__5924.c) {
          return this__5924.vector_seq.call(null, this__5924.v, offset__5925)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5921.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5921.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5921.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5926 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5921.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5921.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5921.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5927 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5921.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5921.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5928 = this;
        return this__5928.__meta__389__auto__
      };
      cljs.core.t5921.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5921.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5929 = this;
        return new cljs.core.t5921(this__5929.c, this__5929.offset, this__5929.v, this__5929.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5921
    }else {
    }
    return new cljs.core.t5921(c__5920, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5934 = this;
  return new cljs.core.TransientVector(this__5934.cnt, this__5934.shift, cljs.core.tv_editable_root.call(null, this__5934.root), cljs.core.tv_editable_tail.call(null, this__5934.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5935 = this;
  var h__364__auto____5936 = this__5935.__hash;
  if(h__364__auto____5936 != null) {
    return h__364__auto____5936
  }else {
    var h__364__auto____5937 = cljs.core.hash_coll.call(null, coll);
    this__5935.__hash = h__364__auto____5937;
    return h__364__auto____5937
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5938 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5939 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5940 = this;
  if(function() {
    var and__3546__auto____5941 = 0 <= k;
    if(and__3546__auto____5941) {
      return k < this__5940.cnt
    }else {
      return and__3546__auto____5941
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5942 = cljs.core.aclone.call(null, this__5940.tail);
      new_tail__5942[k & 31] = v;
      return new cljs.core.PersistentVector(this__5940.meta, this__5940.cnt, this__5940.shift, this__5940.root, new_tail__5942, null)
    }else {
      return new cljs.core.PersistentVector(this__5940.meta, this__5940.cnt, this__5940.shift, cljs.core.do_assoc.call(null, coll, this__5940.shift, this__5940.root, k, v), this__5940.tail, null)
    }
  }else {
    if(k === this__5940.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5940.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5987 = null;
  var G__5987__2 = function(tsym5932, k) {
    var this__5943 = this;
    var tsym5932__5944 = this;
    var coll__5945 = tsym5932__5944;
    return cljs.core._lookup.call(null, coll__5945, k)
  };
  var G__5987__3 = function(tsym5933, k, not_found) {
    var this__5946 = this;
    var tsym5933__5947 = this;
    var coll__5948 = tsym5933__5947;
    return cljs.core._lookup.call(null, coll__5948, k, not_found)
  };
  G__5987 = function(tsym5933, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5987__2.call(this, tsym5933, k);
      case 3:
        return G__5987__3.call(this, tsym5933, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5987
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5930, args5931) {
  return tsym5930.call.apply(tsym5930, [tsym5930].concat(cljs.core.aclone.call(null, args5931)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5949 = this;
  var step_init__5950 = [0, init];
  var i__5951 = 0;
  while(true) {
    if(i__5951 < this__5949.cnt) {
      var arr__5952 = cljs.core.array_for.call(null, v, i__5951);
      var len__5953 = arr__5952.length;
      var init__5957 = function() {
        var j__5954 = 0;
        var init__5955 = step_init__5950[1];
        while(true) {
          if(j__5954 < len__5953) {
            var init__5956 = f.call(null, init__5955, j__5954 + i__5951, arr__5952[j__5954]);
            if(cljs.core.reduced_QMARK_.call(null, init__5956)) {
              return init__5956
            }else {
              var G__5988 = j__5954 + 1;
              var G__5989 = init__5956;
              j__5954 = G__5988;
              init__5955 = G__5989;
              continue
            }
          }else {
            step_init__5950[0] = len__5953;
            step_init__5950[1] = init__5955;
            return init__5955
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5957)) {
        return cljs.core.deref.call(null, init__5957)
      }else {
        var G__5990 = i__5951 + step_init__5950[0];
        i__5951 = G__5990;
        continue
      }
    }else {
      return step_init__5950[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5958 = this;
  if(this__5958.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5959 = cljs.core.aclone.call(null, this__5958.tail);
    new_tail__5959.push(o);
    return new cljs.core.PersistentVector(this__5958.meta, this__5958.cnt + 1, this__5958.shift, this__5958.root, new_tail__5959, null)
  }else {
    var root_overflow_QMARK___5960 = this__5958.cnt >>> 5 > 1 << this__5958.shift;
    var new_shift__5961 = root_overflow_QMARK___5960 ? this__5958.shift + 5 : this__5958.shift;
    var new_root__5963 = root_overflow_QMARK___5960 ? function() {
      var n_r__5962 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5962, 0, this__5958.root);
      cljs.core.pv_aset.call(null, n_r__5962, 1, cljs.core.new_path.call(null, null, this__5958.shift, new cljs.core.VectorNode(null, this__5958.tail)));
      return n_r__5962
    }() : cljs.core.push_tail.call(null, coll, this__5958.shift, this__5958.root, new cljs.core.VectorNode(null, this__5958.tail));
    return new cljs.core.PersistentVector(this__5958.meta, this__5958.cnt + 1, new_shift__5961, new_root__5963, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5964 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5965 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5966 = this;
  var this$__5967 = this;
  return cljs.core.pr_str.call(null, this$__5967)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5968 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5969 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5970 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5971 = this;
  return this__5971.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5972 = this;
  if(this__5972.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5972.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5973 = this;
  if(this__5973.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5973.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5973.meta)
    }else {
      if(1 < this__5973.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5973.meta, this__5973.cnt - 1, this__5973.shift, this__5973.root, this__5973.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5974 = cljs.core.array_for.call(null, coll, this__5973.cnt - 2);
          var nr__5975 = cljs.core.pop_tail.call(null, coll, this__5973.shift, this__5973.root);
          var new_root__5976 = nr__5975 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5975;
          var cnt_1__5977 = this__5973.cnt - 1;
          if(function() {
            var and__3546__auto____5978 = 5 < this__5973.shift;
            if(and__3546__auto____5978) {
              return cljs.core.pv_aget.call(null, new_root__5976, 1) == null
            }else {
              return and__3546__auto____5978
            }
          }()) {
            return new cljs.core.PersistentVector(this__5973.meta, cnt_1__5977, this__5973.shift - 5, cljs.core.pv_aget.call(null, new_root__5976, 0), new_tail__5974, null)
          }else {
            return new cljs.core.PersistentVector(this__5973.meta, cnt_1__5977, this__5973.shift, new_root__5976, new_tail__5974, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5980 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5981 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5982 = this;
  return new cljs.core.PersistentVector(meta, this__5982.cnt, this__5982.shift, this__5982.root, this__5982.tail, this__5982.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5983 = this;
  return this__5983.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5984 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5985 = this;
  if(function() {
    var and__3546__auto____5986 = 0 <= n;
    if(and__3546__auto____5986) {
      return n < this__5985.cnt
    }else {
      return and__3546__auto____5986
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5979 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5979.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5991 = cljs.core.seq.call(null, xs);
  var out__5992 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5991)) {
      var G__5993 = cljs.core.next.call(null, xs__5991);
      var G__5994 = cljs.core.conj_BANG_.call(null, out__5992, cljs.core.first.call(null, xs__5991));
      xs__5991 = G__5993;
      out__5992 = G__5994;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5992)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__5995) {
    var args = cljs.core.seq(arglist__5995);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6000 = this;
  var h__364__auto____6001 = this__6000.__hash;
  if(h__364__auto____6001 != null) {
    return h__364__auto____6001
  }else {
    var h__364__auto____6002 = cljs.core.hash_coll.call(null, coll);
    this__6000.__hash = h__364__auto____6002;
    return h__364__auto____6002
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6003 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6004 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__6005 = this;
  var v_pos__6006 = this__6005.start + key;
  return new cljs.core.Subvec(this__6005.meta, cljs.core._assoc.call(null, this__6005.v, v_pos__6006, val), this__6005.start, this__6005.end > v_pos__6006 + 1 ? this__6005.end : v_pos__6006 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__6030 = null;
  var G__6030__2 = function(tsym5998, k) {
    var this__6007 = this;
    var tsym5998__6008 = this;
    var coll__6009 = tsym5998__6008;
    return cljs.core._lookup.call(null, coll__6009, k)
  };
  var G__6030__3 = function(tsym5999, k, not_found) {
    var this__6010 = this;
    var tsym5999__6011 = this;
    var coll__6012 = tsym5999__6011;
    return cljs.core._lookup.call(null, coll__6012, k, not_found)
  };
  G__6030 = function(tsym5999, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6030__2.call(this, tsym5999, k);
      case 3:
        return G__6030__3.call(this, tsym5999, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6030
}();
cljs.core.Subvec.prototype.apply = function(tsym5996, args5997) {
  return tsym5996.call.apply(tsym5996, [tsym5996].concat(cljs.core.aclone.call(null, args5997)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6013 = this;
  return new cljs.core.Subvec(this__6013.meta, cljs.core._assoc_n.call(null, this__6013.v, this__6013.end, o), this__6013.start, this__6013.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__6014 = this;
  var this$__6015 = this;
  return cljs.core.pr_str.call(null, this$__6015)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__6016 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__6017 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6018 = this;
  var subvec_seq__6019 = function subvec_seq(i) {
    if(i === this__6018.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__6018.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__6019.call(null, this__6018.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6020 = this;
  return this__6020.end - this__6020.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6021 = this;
  return cljs.core._nth.call(null, this__6021.v, this__6021.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6022 = this;
  if(this__6022.start === this__6022.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__6022.meta, this__6022.v, this__6022.start, this__6022.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__6023 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6024 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6025 = this;
  return new cljs.core.Subvec(meta, this__6025.v, this__6025.start, this__6025.end, this__6025.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6026 = this;
  return this__6026.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6028 = this;
  return cljs.core._nth.call(null, this__6028.v, this__6028.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6029 = this;
  return cljs.core._nth.call(null, this__6029.v, this__6029.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6027 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__6027.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__6031 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__6031, 0, tl.length);
  return ret__6031
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__6032 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__6033 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__6032, subidx__6033, level === 5 ? tail_node : function() {
    var child__6034 = cljs.core.pv_aget.call(null, ret__6032, subidx__6033);
    if(child__6034 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__6034, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__6032
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__6035 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__6036 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__6037 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__6035, subidx__6036));
    if(function() {
      var and__3546__auto____6038 = new_child__6037 == null;
      if(and__3546__auto____6038) {
        return subidx__6036 === 0
      }else {
        return and__3546__auto____6038
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__6035, subidx__6036, new_child__6037);
      return node__6035
    }
  }else {
    if(subidx__6036 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__6035, subidx__6036, null);
        return node__6035
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____6039 = 0 <= i;
    if(and__3546__auto____6039) {
      return i < tv.cnt
    }else {
      return and__3546__auto____6039
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__6040 = tv.root;
      var node__6041 = root__6040;
      var level__6042 = tv.shift;
      while(true) {
        if(level__6042 > 0) {
          var G__6043 = cljs.core.tv_ensure_editable.call(null, root__6040.edit, cljs.core.pv_aget.call(null, node__6041, i >>> level__6042 & 31));
          var G__6044 = level__6042 - 5;
          node__6041 = G__6043;
          level__6042 = G__6044;
          continue
        }else {
          return node__6041.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__6082 = null;
  var G__6082__2 = function(tsym6047, k) {
    var this__6049 = this;
    var tsym6047__6050 = this;
    var coll__6051 = tsym6047__6050;
    return cljs.core._lookup.call(null, coll__6051, k)
  };
  var G__6082__3 = function(tsym6048, k, not_found) {
    var this__6052 = this;
    var tsym6048__6053 = this;
    var coll__6054 = tsym6048__6053;
    return cljs.core._lookup.call(null, coll__6054, k, not_found)
  };
  G__6082 = function(tsym6048, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6082__2.call(this, tsym6048, k);
      case 3:
        return G__6082__3.call(this, tsym6048, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6082
}();
cljs.core.TransientVector.prototype.apply = function(tsym6045, args6046) {
  return tsym6045.call.apply(tsym6045, [tsym6045].concat(cljs.core.aclone.call(null, args6046)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6055 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6056 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6057 = this;
  if(cljs.core.truth_(this__6057.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6058 = this;
  if(function() {
    var and__3546__auto____6059 = 0 <= n;
    if(and__3546__auto____6059) {
      return n < this__6058.cnt
    }else {
      return and__3546__auto____6059
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6060 = this;
  if(cljs.core.truth_(this__6060.root.edit)) {
    return this__6060.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__6061 = this;
  if(cljs.core.truth_(this__6061.root.edit)) {
    if(function() {
      var and__3546__auto____6062 = 0 <= n;
      if(and__3546__auto____6062) {
        return n < this__6061.cnt
      }else {
        return and__3546__auto____6062
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__6061.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__6065 = function go(level, node) {
          var node__6063 = cljs.core.tv_ensure_editable.call(null, this__6061.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__6063, n & 31, val);
            return node__6063
          }else {
            var subidx__6064 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__6063, subidx__6064, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__6063, subidx__6064)));
            return node__6063
          }
        }.call(null, this__6061.shift, this__6061.root);
        this__6061.root = new_root__6065;
        return tcoll
      }
    }else {
      if(n === this__6061.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__6061.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__6066 = this;
  if(cljs.core.truth_(this__6066.root.edit)) {
    if(this__6066.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__6066.cnt) {
        this__6066.cnt = 0;
        return tcoll
      }else {
        if((this__6066.cnt - 1 & 31) > 0) {
          this__6066.cnt = this__6066.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__6067 = cljs.core.editable_array_for.call(null, tcoll, this__6066.cnt - 2);
            var new_root__6069 = function() {
              var nr__6068 = cljs.core.tv_pop_tail.call(null, tcoll, this__6066.shift, this__6066.root);
              if(nr__6068 != null) {
                return nr__6068
              }else {
                return new cljs.core.VectorNode(this__6066.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____6070 = 5 < this__6066.shift;
              if(and__3546__auto____6070) {
                return cljs.core.pv_aget.call(null, new_root__6069, 1) == null
              }else {
                return and__3546__auto____6070
              }
            }()) {
              var new_root__6071 = cljs.core.tv_ensure_editable.call(null, this__6066.root.edit, cljs.core.pv_aget.call(null, new_root__6069, 0));
              this__6066.root = new_root__6071;
              this__6066.shift = this__6066.shift - 5;
              this__6066.cnt = this__6066.cnt - 1;
              this__6066.tail = new_tail__6067;
              return tcoll
            }else {
              this__6066.root = new_root__6069;
              this__6066.cnt = this__6066.cnt - 1;
              this__6066.tail = new_tail__6067;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6072 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6073 = this;
  if(cljs.core.truth_(this__6073.root.edit)) {
    if(this__6073.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__6073.tail[this__6073.cnt & 31] = o;
      this__6073.cnt = this__6073.cnt + 1;
      return tcoll
    }else {
      var tail_node__6074 = new cljs.core.VectorNode(this__6073.root.edit, this__6073.tail);
      var new_tail__6075 = cljs.core.make_array.call(null, 32);
      new_tail__6075[0] = o;
      this__6073.tail = new_tail__6075;
      if(this__6073.cnt >>> 5 > 1 << this__6073.shift) {
        var new_root_array__6076 = cljs.core.make_array.call(null, 32);
        var new_shift__6077 = this__6073.shift + 5;
        new_root_array__6076[0] = this__6073.root;
        new_root_array__6076[1] = cljs.core.new_path.call(null, this__6073.root.edit, this__6073.shift, tail_node__6074);
        this__6073.root = new cljs.core.VectorNode(this__6073.root.edit, new_root_array__6076);
        this__6073.shift = new_shift__6077;
        this__6073.cnt = this__6073.cnt + 1;
        return tcoll
      }else {
        var new_root__6078 = cljs.core.tv_push_tail.call(null, tcoll, this__6073.shift, this__6073.root, tail_node__6074);
        this__6073.root = new_root__6078;
        this__6073.cnt = this__6073.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6079 = this;
  if(cljs.core.truth_(this__6079.root.edit)) {
    this__6079.root.edit = null;
    var len__6080 = this__6079.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__6081 = cljs.core.make_array.call(null, len__6080);
    cljs.core.array_copy.call(null, this__6079.tail, 0, trimmed_tail__6081, 0, len__6080);
    return new cljs.core.PersistentVector(null, this__6079.cnt, this__6079.shift, this__6079.root, trimmed_tail__6081, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6083 = this;
  var h__364__auto____6084 = this__6083.__hash;
  if(h__364__auto____6084 != null) {
    return h__364__auto____6084
  }else {
    var h__364__auto____6085 = cljs.core.hash_coll.call(null, coll);
    this__6083.__hash = h__364__auto____6085;
    return h__364__auto____6085
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6086 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__6087 = this;
  var this$__6088 = this;
  return cljs.core.pr_str.call(null, this$__6088)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6089 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6090 = this;
  return cljs.core._first.call(null, this__6090.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6091 = this;
  var temp__3695__auto____6092 = cljs.core.next.call(null, this__6091.front);
  if(cljs.core.truth_(temp__3695__auto____6092)) {
    var f1__6093 = temp__3695__auto____6092;
    return new cljs.core.PersistentQueueSeq(this__6091.meta, f1__6093, this__6091.rear, null)
  }else {
    if(this__6091.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__6091.meta, this__6091.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6094 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6095 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__6095.front, this__6095.rear, this__6095.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6096 = this;
  return this__6096.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6097 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6097.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6098 = this;
  var h__364__auto____6099 = this__6098.__hash;
  if(h__364__auto____6099 != null) {
    return h__364__auto____6099
  }else {
    var h__364__auto____6100 = cljs.core.hash_coll.call(null, coll);
    this__6098.__hash = h__364__auto____6100;
    return h__364__auto____6100
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6101 = this;
  if(cljs.core.truth_(this__6101.front)) {
    return new cljs.core.PersistentQueue(this__6101.meta, this__6101.count + 1, this__6101.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____6102 = this__6101.rear;
      if(cljs.core.truth_(or__3548__auto____6102)) {
        return or__3548__auto____6102
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__6101.meta, this__6101.count + 1, cljs.core.conj.call(null, this__6101.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__6103 = this;
  var this$__6104 = this;
  return cljs.core.pr_str.call(null, this$__6104)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6105 = this;
  var rear__6106 = cljs.core.seq.call(null, this__6105.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____6107 = this__6105.front;
    if(cljs.core.truth_(or__3548__auto____6107)) {
      return or__3548__auto____6107
    }else {
      return rear__6106
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__6105.front, cljs.core.seq.call(null, rear__6106), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6108 = this;
  return this__6108.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6109 = this;
  return cljs.core._first.call(null, this__6109.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6110 = this;
  if(cljs.core.truth_(this__6110.front)) {
    var temp__3695__auto____6111 = cljs.core.next.call(null, this__6110.front);
    if(cljs.core.truth_(temp__3695__auto____6111)) {
      var f1__6112 = temp__3695__auto____6111;
      return new cljs.core.PersistentQueue(this__6110.meta, this__6110.count - 1, f1__6112, this__6110.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__6110.meta, this__6110.count - 1, cljs.core.seq.call(null, this__6110.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6113 = this;
  return cljs.core.first.call(null, this__6113.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6114 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6115 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6116 = this;
  return new cljs.core.PersistentQueue(meta, this__6116.count, this__6116.front, this__6116.rear, this__6116.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6117 = this;
  return this__6117.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6118 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6119 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__6120 = array.length;
  var i__6121 = 0;
  while(true) {
    if(i__6121 < len__6120) {
      if(cljs.core._EQ_.call(null, k, array[i__6121])) {
        return i__6121
      }else {
        var G__6122 = i__6121 + incr;
        i__6121 = G__6122;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6123 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____6123)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____6123
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__6124 = cljs.core.hash.call(null, a);
  var b__6125 = cljs.core.hash.call(null, b);
  if(a__6124 < b__6125) {
    return-1
  }else {
    if(a__6124 > b__6125) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__6127 = m.keys;
  var len__6128 = ks__6127.length;
  var so__6129 = m.strobj;
  var out__6130 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__6131 = 0;
  var out__6132 = cljs.core.transient$.call(null, out__6130);
  while(true) {
    if(i__6131 < len__6128) {
      var k__6133 = ks__6127[i__6131];
      var G__6134 = i__6131 + 1;
      var G__6135 = cljs.core.assoc_BANG_.call(null, out__6132, k__6133, so__6129[k__6133]);
      i__6131 = G__6134;
      out__6132 = G__6135;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__6132, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6140 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6141 = this;
  var h__364__auto____6142 = this__6141.__hash;
  if(h__364__auto____6142 != null) {
    return h__364__auto____6142
  }else {
    var h__364__auto____6143 = cljs.core.hash_imap.call(null, coll);
    this__6141.__hash = h__364__auto____6143;
    return h__364__auto____6143
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6144 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6145 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6145.strobj, this__6145.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6146 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___6147 = this__6146.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___6147)) {
      var new_strobj__6148 = goog.object.clone.call(null, this__6146.strobj);
      new_strobj__6148[k] = v;
      return new cljs.core.ObjMap(this__6146.meta, this__6146.keys, new_strobj__6148, this__6146.update_count + 1, null)
    }else {
      if(this__6146.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__6149 = goog.object.clone.call(null, this__6146.strobj);
        var new_keys__6150 = cljs.core.aclone.call(null, this__6146.keys);
        new_strobj__6149[k] = v;
        new_keys__6150.push(k);
        return new cljs.core.ObjMap(this__6146.meta, new_keys__6150, new_strobj__6149, this__6146.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6151 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6151.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__6171 = null;
  var G__6171__2 = function(tsym6138, k) {
    var this__6152 = this;
    var tsym6138__6153 = this;
    var coll__6154 = tsym6138__6153;
    return cljs.core._lookup.call(null, coll__6154, k)
  };
  var G__6171__3 = function(tsym6139, k, not_found) {
    var this__6155 = this;
    var tsym6139__6156 = this;
    var coll__6157 = tsym6139__6156;
    return cljs.core._lookup.call(null, coll__6157, k, not_found)
  };
  G__6171 = function(tsym6139, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6171__2.call(this, tsym6139, k);
      case 3:
        return G__6171__3.call(this, tsym6139, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6171
}();
cljs.core.ObjMap.prototype.apply = function(tsym6136, args6137) {
  return tsym6136.call.apply(tsym6136, [tsym6136].concat(cljs.core.aclone.call(null, args6137)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6158 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__6159 = this;
  var this$__6160 = this;
  return cljs.core.pr_str.call(null, this$__6160)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6161 = this;
  if(this__6161.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__6126_SHARP_) {
      return cljs.core.vector.call(null, p1__6126_SHARP_, this__6161.strobj[p1__6126_SHARP_])
    }, this__6161.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6162 = this;
  return this__6162.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6163 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6164 = this;
  return new cljs.core.ObjMap(meta, this__6164.keys, this__6164.strobj, this__6164.update_count, this__6164.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6165 = this;
  return this__6165.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6166 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__6166.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6167 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____6168 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____6168)) {
      return this__6167.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____6168
    }
  }())) {
    var new_keys__6169 = cljs.core.aclone.call(null, this__6167.keys);
    var new_strobj__6170 = goog.object.clone.call(null, this__6167.strobj);
    new_keys__6169.splice(cljs.core.scan_array.call(null, 1, k, new_keys__6169), 1);
    cljs.core.js_delete.call(null, new_strobj__6170, k);
    return new cljs.core.ObjMap(this__6167.meta, new_keys__6169, new_strobj__6170, this__6167.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6177 = this;
  var h__364__auto____6178 = this__6177.__hash;
  if(h__364__auto____6178 != null) {
    return h__364__auto____6178
  }else {
    var h__364__auto____6179 = cljs.core.hash_imap.call(null, coll);
    this__6177.__hash = h__364__auto____6179;
    return h__364__auto____6179
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6180 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6181 = this;
  var bucket__6182 = this__6181.hashobj[cljs.core.hash.call(null, k)];
  var i__6183 = cljs.core.truth_(bucket__6182) ? cljs.core.scan_array.call(null, 2, k, bucket__6182) : null;
  if(cljs.core.truth_(i__6183)) {
    return bucket__6182[i__6183 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6184 = this;
  var h__6185 = cljs.core.hash.call(null, k);
  var bucket__6186 = this__6184.hashobj[h__6185];
  if(cljs.core.truth_(bucket__6186)) {
    var new_bucket__6187 = cljs.core.aclone.call(null, bucket__6186);
    var new_hashobj__6188 = goog.object.clone.call(null, this__6184.hashobj);
    new_hashobj__6188[h__6185] = new_bucket__6187;
    var temp__3695__auto____6189 = cljs.core.scan_array.call(null, 2, k, new_bucket__6187);
    if(cljs.core.truth_(temp__3695__auto____6189)) {
      var i__6190 = temp__3695__auto____6189;
      new_bucket__6187[i__6190 + 1] = v;
      return new cljs.core.HashMap(this__6184.meta, this__6184.count, new_hashobj__6188, null)
    }else {
      new_bucket__6187.push(k, v);
      return new cljs.core.HashMap(this__6184.meta, this__6184.count + 1, new_hashobj__6188, null)
    }
  }else {
    var new_hashobj__6191 = goog.object.clone.call(null, this__6184.hashobj);
    new_hashobj__6191[h__6185] = [k, v];
    return new cljs.core.HashMap(this__6184.meta, this__6184.count + 1, new_hashobj__6191, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6192 = this;
  var bucket__6193 = this__6192.hashobj[cljs.core.hash.call(null, k)];
  var i__6194 = cljs.core.truth_(bucket__6193) ? cljs.core.scan_array.call(null, 2, k, bucket__6193) : null;
  if(cljs.core.truth_(i__6194)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6217 = null;
  var G__6217__2 = function(tsym6175, k) {
    var this__6195 = this;
    var tsym6175__6196 = this;
    var coll__6197 = tsym6175__6196;
    return cljs.core._lookup.call(null, coll__6197, k)
  };
  var G__6217__3 = function(tsym6176, k, not_found) {
    var this__6198 = this;
    var tsym6176__6199 = this;
    var coll__6200 = tsym6176__6199;
    return cljs.core._lookup.call(null, coll__6200, k, not_found)
  };
  G__6217 = function(tsym6176, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6217__2.call(this, tsym6176, k);
      case 3:
        return G__6217__3.call(this, tsym6176, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6217
}();
cljs.core.HashMap.prototype.apply = function(tsym6173, args6174) {
  return tsym6173.call.apply(tsym6173, [tsym6173].concat(cljs.core.aclone.call(null, args6174)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6201 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6202 = this;
  var this$__6203 = this;
  return cljs.core.pr_str.call(null, this$__6203)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6204 = this;
  if(this__6204.count > 0) {
    var hashes__6205 = cljs.core.js_keys.call(null, this__6204.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__6172_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6204.hashobj[p1__6172_SHARP_]))
    }, hashes__6205)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6206 = this;
  return this__6206.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6207 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6208 = this;
  return new cljs.core.HashMap(meta, this__6208.count, this__6208.hashobj, this__6208.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6209 = this;
  return this__6209.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6210 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6210.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6211 = this;
  var h__6212 = cljs.core.hash.call(null, k);
  var bucket__6213 = this__6211.hashobj[h__6212];
  var i__6214 = cljs.core.truth_(bucket__6213) ? cljs.core.scan_array.call(null, 2, k, bucket__6213) : null;
  if(cljs.core.not.call(null, i__6214)) {
    return coll
  }else {
    var new_hashobj__6215 = goog.object.clone.call(null, this__6211.hashobj);
    if(3 > bucket__6213.length) {
      cljs.core.js_delete.call(null, new_hashobj__6215, h__6212)
    }else {
      var new_bucket__6216 = cljs.core.aclone.call(null, bucket__6213);
      new_bucket__6216.splice(i__6214, 2);
      new_hashobj__6215[h__6212] = new_bucket__6216
    }
    return new cljs.core.HashMap(this__6211.meta, this__6211.count - 1, new_hashobj__6215, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6218 = ks.length;
  var i__6219 = 0;
  var out__6220 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6219 < len__6218) {
      var G__6221 = i__6219 + 1;
      var G__6222 = cljs.core.assoc.call(null, out__6220, ks[i__6219], vs[i__6219]);
      i__6219 = G__6221;
      out__6220 = G__6222;
      continue
    }else {
      return out__6220
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6223 = m.arr;
  var len__6224 = arr__6223.length;
  var i__6225 = 0;
  while(true) {
    if(len__6224 <= i__6225) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6223[i__6225], k)) {
        return i__6225
      }else {
        if("\ufdd0'else") {
          var G__6226 = i__6225 + 2;
          i__6225 = G__6226;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6231 = this;
  return new cljs.core.TransientArrayMap({}, this__6231.arr.length, cljs.core.aclone.call(null, this__6231.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6232 = this;
  var h__364__auto____6233 = this__6232.__hash;
  if(h__364__auto____6233 != null) {
    return h__364__auto____6233
  }else {
    var h__364__auto____6234 = cljs.core.hash_imap.call(null, coll);
    this__6232.__hash = h__364__auto____6234;
    return h__364__auto____6234
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6235 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6236 = this;
  var idx__6237 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6237 === -1) {
    return not_found
  }else {
    return this__6236.arr[idx__6237 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6238 = this;
  var idx__6239 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6239 === -1) {
    if(this__6238.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6238.meta, this__6238.cnt + 1, function() {
        var G__6240__6241 = cljs.core.aclone.call(null, this__6238.arr);
        G__6240__6241.push(k);
        G__6240__6241.push(v);
        return G__6240__6241
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6238.arr[idx__6239 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6238.meta, this__6238.cnt, function() {
          var G__6242__6243 = cljs.core.aclone.call(null, this__6238.arr);
          G__6242__6243[idx__6239 + 1] = v;
          return G__6242__6243
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6244 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6274 = null;
  var G__6274__2 = function(tsym6229, k) {
    var this__6245 = this;
    var tsym6229__6246 = this;
    var coll__6247 = tsym6229__6246;
    return cljs.core._lookup.call(null, coll__6247, k)
  };
  var G__6274__3 = function(tsym6230, k, not_found) {
    var this__6248 = this;
    var tsym6230__6249 = this;
    var coll__6250 = tsym6230__6249;
    return cljs.core._lookup.call(null, coll__6250, k, not_found)
  };
  G__6274 = function(tsym6230, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6274__2.call(this, tsym6230, k);
      case 3:
        return G__6274__3.call(this, tsym6230, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6274
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6227, args6228) {
  return tsym6227.call.apply(tsym6227, [tsym6227].concat(cljs.core.aclone.call(null, args6228)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6251 = this;
  var len__6252 = this__6251.arr.length;
  var i__6253 = 0;
  var init__6254 = init;
  while(true) {
    if(i__6253 < len__6252) {
      var init__6255 = f.call(null, init__6254, this__6251.arr[i__6253], this__6251.arr[i__6253 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6255)) {
        return cljs.core.deref.call(null, init__6255)
      }else {
        var G__6275 = i__6253 + 2;
        var G__6276 = init__6255;
        i__6253 = G__6275;
        init__6254 = G__6276;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6256 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6257 = this;
  var this$__6258 = this;
  return cljs.core.pr_str.call(null, this$__6258)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6259 = this;
  if(this__6259.cnt > 0) {
    var len__6260 = this__6259.arr.length;
    var array_map_seq__6261 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6260) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6259.arr[i], this__6259.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6261.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6262 = this;
  return this__6262.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6263 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6264 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6264.cnt, this__6264.arr, this__6264.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6265 = this;
  return this__6265.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6266 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6266.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6267 = this;
  var idx__6268 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6268 >= 0) {
    var len__6269 = this__6267.arr.length;
    var new_len__6270 = len__6269 - 2;
    if(new_len__6270 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6271 = cljs.core.make_array.call(null, new_len__6270);
      var s__6272 = 0;
      var d__6273 = 0;
      while(true) {
        if(s__6272 >= len__6269) {
          return new cljs.core.PersistentArrayMap(this__6267.meta, this__6267.cnt - 1, new_arr__6271, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6267.arr[s__6272])) {
            var G__6277 = s__6272 + 2;
            var G__6278 = d__6273;
            s__6272 = G__6277;
            d__6273 = G__6278;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6271[d__6273] = this__6267.arr[s__6272];
              new_arr__6271[d__6273 + 1] = this__6267.arr[s__6272 + 1];
              var G__6279 = s__6272 + 2;
              var G__6280 = d__6273 + 2;
              s__6272 = G__6279;
              d__6273 = G__6280;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6281 = cljs.core.count.call(null, ks);
  var i__6282 = 0;
  var out__6283 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6282 < len__6281) {
      var G__6284 = i__6282 + 1;
      var G__6285 = cljs.core.assoc_BANG_.call(null, out__6283, ks[i__6282], vs[i__6282]);
      i__6282 = G__6284;
      out__6283 = G__6285;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6283)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6286 = this;
  if(cljs.core.truth_(this__6286.editable_QMARK_)) {
    var idx__6287 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6287 >= 0) {
      this__6286.arr[idx__6287] = this__6286.arr[this__6286.len - 2];
      this__6286.arr[idx__6287 + 1] = this__6286.arr[this__6286.len - 1];
      var G__6288__6289 = this__6286.arr;
      G__6288__6289.pop();
      G__6288__6289.pop();
      G__6288__6289;
      this__6286.len = this__6286.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6290 = this;
  if(cljs.core.truth_(this__6290.editable_QMARK_)) {
    var idx__6291 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6291 === -1) {
      if(this__6290.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6290.len = this__6290.len + 2;
        this__6290.arr.push(key);
        this__6290.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6290.len, this__6290.arr), key, val)
      }
    }else {
      if(val === this__6290.arr[idx__6291 + 1]) {
        return tcoll
      }else {
        this__6290.arr[idx__6291 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6292 = this;
  if(cljs.core.truth_(this__6292.editable_QMARK_)) {
    if(function() {
      var G__6293__6294 = o;
      if(G__6293__6294 != null) {
        if(function() {
          var or__3548__auto____6295 = G__6293__6294.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6295) {
            return or__3548__auto____6295
          }else {
            return G__6293__6294.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6293__6294.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6293__6294)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6293__6294)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6296 = cljs.core.seq.call(null, o);
      var tcoll__6297 = tcoll;
      while(true) {
        var temp__3695__auto____6298 = cljs.core.first.call(null, es__6296);
        if(cljs.core.truth_(temp__3695__auto____6298)) {
          var e__6299 = temp__3695__auto____6298;
          var G__6305 = cljs.core.next.call(null, es__6296);
          var G__6306 = cljs.core._assoc_BANG_.call(null, tcoll__6297, cljs.core.key.call(null, e__6299), cljs.core.val.call(null, e__6299));
          es__6296 = G__6305;
          tcoll__6297 = G__6306;
          continue
        }else {
          return tcoll__6297
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6300 = this;
  if(cljs.core.truth_(this__6300.editable_QMARK_)) {
    this__6300.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6300.len, 2), this__6300.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6301 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6302 = this;
  if(cljs.core.truth_(this__6302.editable_QMARK_)) {
    var idx__6303 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6303 === -1) {
      return not_found
    }else {
      return this__6302.arr[idx__6303 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6304 = this;
  if(cljs.core.truth_(this__6304.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6304.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6307 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6308 = 0;
  while(true) {
    if(i__6308 < len) {
      var G__6309 = cljs.core.assoc_BANG_.call(null, out__6307, arr[i__6308], arr[i__6308 + 1]);
      var G__6310 = i__6308 + 2;
      out__6307 = G__6309;
      i__6308 = G__6310;
      continue
    }else {
      return out__6307
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6311__6312 = cljs.core.aclone.call(null, arr);
    G__6311__6312[i] = a;
    return G__6311__6312
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6313__6314 = cljs.core.aclone.call(null, arr);
    G__6313__6314[i] = a;
    G__6313__6314[j] = b;
    return G__6313__6314
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6315 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6315, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6315, 2 * i, new_arr__6315.length - 2 * i);
  return new_arr__6315
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6316 = inode.ensure_editable(edit);
    editable__6316.arr[i] = a;
    return editable__6316
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6317 = inode.ensure_editable(edit);
    editable__6317.arr[i] = a;
    editable__6317.arr[j] = b;
    return editable__6317
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6318 = arr.length;
  var i__6319 = 0;
  var init__6320 = init;
  while(true) {
    if(i__6319 < len__6318) {
      var init__6323 = function() {
        var k__6321 = arr[i__6319];
        if(k__6321 != null) {
          return f.call(null, init__6320, k__6321, arr[i__6319 + 1])
        }else {
          var node__6322 = arr[i__6319 + 1];
          if(node__6322 != null) {
            return node__6322.kv_reduce(f, init__6320)
          }else {
            return init__6320
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6323)) {
        return cljs.core.deref.call(null, init__6323)
      }else {
        var G__6324 = i__6319 + 2;
        var G__6325 = init__6323;
        i__6319 = G__6324;
        init__6320 = G__6325;
        continue
      }
    }else {
      return init__6320
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6326 = this;
  var inode__6327 = this;
  if(this__6326.bitmap === bit) {
    return null
  }else {
    var editable__6328 = inode__6327.ensure_editable(e);
    var earr__6329 = editable__6328.arr;
    var len__6330 = earr__6329.length;
    editable__6328.bitmap = bit ^ editable__6328.bitmap;
    cljs.core.array_copy.call(null, earr__6329, 2 * (i + 1), earr__6329, 2 * i, len__6330 - 2 * (i + 1));
    earr__6329[len__6330 - 2] = null;
    earr__6329[len__6330 - 1] = null;
    return editable__6328
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6331 = this;
  var inode__6332 = this;
  var bit__6333 = 1 << (hash >>> shift & 31);
  var idx__6334 = cljs.core.bitmap_indexed_node_index.call(null, this__6331.bitmap, bit__6333);
  if((this__6331.bitmap & bit__6333) === 0) {
    var n__6335 = cljs.core.bit_count.call(null, this__6331.bitmap);
    if(2 * n__6335 < this__6331.arr.length) {
      var editable__6336 = inode__6332.ensure_editable(edit);
      var earr__6337 = editable__6336.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6337, 2 * idx__6334, earr__6337, 2 * (idx__6334 + 1), 2 * (n__6335 - idx__6334));
      earr__6337[2 * idx__6334] = key;
      earr__6337[2 * idx__6334 + 1] = val;
      editable__6336.bitmap = editable__6336.bitmap | bit__6333;
      return editable__6336
    }else {
      if(n__6335 >= 16) {
        var nodes__6338 = cljs.core.make_array.call(null, 32);
        var jdx__6339 = hash >>> shift & 31;
        nodes__6338[jdx__6339] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6340 = 0;
        var j__6341 = 0;
        while(true) {
          if(i__6340 < 32) {
            if((this__6331.bitmap >>> i__6340 & 1) === 0) {
              var G__6394 = i__6340 + 1;
              var G__6395 = j__6341;
              i__6340 = G__6394;
              j__6341 = G__6395;
              continue
            }else {
              nodes__6338[i__6340] = null != this__6331.arr[j__6341] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6331.arr[j__6341]), this__6331.arr[j__6341], this__6331.arr[j__6341 + 1], added_leaf_QMARK_) : this__6331.arr[j__6341 + 1];
              var G__6396 = i__6340 + 1;
              var G__6397 = j__6341 + 2;
              i__6340 = G__6396;
              j__6341 = G__6397;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6335 + 1, nodes__6338)
      }else {
        if("\ufdd0'else") {
          var new_arr__6342 = cljs.core.make_array.call(null, 2 * (n__6335 + 4));
          cljs.core.array_copy.call(null, this__6331.arr, 0, new_arr__6342, 0, 2 * idx__6334);
          new_arr__6342[2 * idx__6334] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6342[2 * idx__6334 + 1] = val;
          cljs.core.array_copy.call(null, this__6331.arr, 2 * idx__6334, new_arr__6342, 2 * (idx__6334 + 1), 2 * (n__6335 - idx__6334));
          var editable__6343 = inode__6332.ensure_editable(edit);
          editable__6343.arr = new_arr__6342;
          editable__6343.bitmap = editable__6343.bitmap | bit__6333;
          return editable__6343
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6344 = this__6331.arr[2 * idx__6334];
    var val_or_node__6345 = this__6331.arr[2 * idx__6334 + 1];
    if(null == key_or_nil__6344) {
      var n__6346 = val_or_node__6345.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6346 === val_or_node__6345) {
        return inode__6332
      }else {
        return cljs.core.edit_and_set.call(null, inode__6332, edit, 2 * idx__6334 + 1, n__6346)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6344)) {
        if(val === val_or_node__6345) {
          return inode__6332
        }else {
          return cljs.core.edit_and_set.call(null, inode__6332, edit, 2 * idx__6334 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6332, edit, 2 * idx__6334, null, 2 * idx__6334 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6344, val_or_node__6345, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6347 = this;
  var inode__6348 = this;
  return cljs.core.create_inode_seq.call(null, this__6347.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6349 = this;
  var inode__6350 = this;
  var bit__6351 = 1 << (hash >>> shift & 31);
  if((this__6349.bitmap & bit__6351) === 0) {
    return inode__6350
  }else {
    var idx__6352 = cljs.core.bitmap_indexed_node_index.call(null, this__6349.bitmap, bit__6351);
    var key_or_nil__6353 = this__6349.arr[2 * idx__6352];
    var val_or_node__6354 = this__6349.arr[2 * idx__6352 + 1];
    if(null == key_or_nil__6353) {
      var n__6355 = val_or_node__6354.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6355 === val_or_node__6354) {
        return inode__6350
      }else {
        if(null != n__6355) {
          return cljs.core.edit_and_set.call(null, inode__6350, edit, 2 * idx__6352 + 1, n__6355)
        }else {
          if(this__6349.bitmap === bit__6351) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6350.edit_and_remove_pair(edit, bit__6351, idx__6352)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6353)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6350.edit_and_remove_pair(edit, bit__6351, idx__6352)
      }else {
        if("\ufdd0'else") {
          return inode__6350
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6356 = this;
  var inode__6357 = this;
  if(e === this__6356.edit) {
    return inode__6357
  }else {
    var n__6358 = cljs.core.bit_count.call(null, this__6356.bitmap);
    var new_arr__6359 = cljs.core.make_array.call(null, n__6358 < 0 ? 4 : 2 * (n__6358 + 1));
    cljs.core.array_copy.call(null, this__6356.arr, 0, new_arr__6359, 0, 2 * n__6358);
    return new cljs.core.BitmapIndexedNode(e, this__6356.bitmap, new_arr__6359)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6360 = this;
  var inode__6361 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6360.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6398 = null;
  var G__6398__3 = function(shift, hash, key) {
    var this__6362 = this;
    var inode__6363 = this;
    var bit__6364 = 1 << (hash >>> shift & 31);
    if((this__6362.bitmap & bit__6364) === 0) {
      return null
    }else {
      var idx__6365 = cljs.core.bitmap_indexed_node_index.call(null, this__6362.bitmap, bit__6364);
      var key_or_nil__6366 = this__6362.arr[2 * idx__6365];
      var val_or_node__6367 = this__6362.arr[2 * idx__6365 + 1];
      if(null == key_or_nil__6366) {
        return val_or_node__6367.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6366)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6366, val_or_node__6367])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6398__4 = function(shift, hash, key, not_found) {
    var this__6368 = this;
    var inode__6369 = this;
    var bit__6370 = 1 << (hash >>> shift & 31);
    if((this__6368.bitmap & bit__6370) === 0) {
      return not_found
    }else {
      var idx__6371 = cljs.core.bitmap_indexed_node_index.call(null, this__6368.bitmap, bit__6370);
      var key_or_nil__6372 = this__6368.arr[2 * idx__6371];
      var val_or_node__6373 = this__6368.arr[2 * idx__6371 + 1];
      if(null == key_or_nil__6372) {
        return val_or_node__6373.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6372)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6372, val_or_node__6373])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6398 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6398__3.call(this, shift, hash, key);
      case 4:
        return G__6398__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6398
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6374 = this;
  var inode__6375 = this;
  var bit__6376 = 1 << (hash >>> shift & 31);
  if((this__6374.bitmap & bit__6376) === 0) {
    return inode__6375
  }else {
    var idx__6377 = cljs.core.bitmap_indexed_node_index.call(null, this__6374.bitmap, bit__6376);
    var key_or_nil__6378 = this__6374.arr[2 * idx__6377];
    var val_or_node__6379 = this__6374.arr[2 * idx__6377 + 1];
    if(null == key_or_nil__6378) {
      var n__6380 = val_or_node__6379.inode_without(shift + 5, hash, key);
      if(n__6380 === val_or_node__6379) {
        return inode__6375
      }else {
        if(null != n__6380) {
          return new cljs.core.BitmapIndexedNode(null, this__6374.bitmap, cljs.core.clone_and_set.call(null, this__6374.arr, 2 * idx__6377 + 1, n__6380))
        }else {
          if(this__6374.bitmap === bit__6376) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6374.bitmap ^ bit__6376, cljs.core.remove_pair.call(null, this__6374.arr, idx__6377))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6378)) {
        return new cljs.core.BitmapIndexedNode(null, this__6374.bitmap ^ bit__6376, cljs.core.remove_pair.call(null, this__6374.arr, idx__6377))
      }else {
        if("\ufdd0'else") {
          return inode__6375
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6381 = this;
  var inode__6382 = this;
  var bit__6383 = 1 << (hash >>> shift & 31);
  var idx__6384 = cljs.core.bitmap_indexed_node_index.call(null, this__6381.bitmap, bit__6383);
  if((this__6381.bitmap & bit__6383) === 0) {
    var n__6385 = cljs.core.bit_count.call(null, this__6381.bitmap);
    if(n__6385 >= 16) {
      var nodes__6386 = cljs.core.make_array.call(null, 32);
      var jdx__6387 = hash >>> shift & 31;
      nodes__6386[jdx__6387] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6388 = 0;
      var j__6389 = 0;
      while(true) {
        if(i__6388 < 32) {
          if((this__6381.bitmap >>> i__6388 & 1) === 0) {
            var G__6399 = i__6388 + 1;
            var G__6400 = j__6389;
            i__6388 = G__6399;
            j__6389 = G__6400;
            continue
          }else {
            nodes__6386[i__6388] = null != this__6381.arr[j__6389] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6381.arr[j__6389]), this__6381.arr[j__6389], this__6381.arr[j__6389 + 1], added_leaf_QMARK_) : this__6381.arr[j__6389 + 1];
            var G__6401 = i__6388 + 1;
            var G__6402 = j__6389 + 2;
            i__6388 = G__6401;
            j__6389 = G__6402;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6385 + 1, nodes__6386)
    }else {
      var new_arr__6390 = cljs.core.make_array.call(null, 2 * (n__6385 + 1));
      cljs.core.array_copy.call(null, this__6381.arr, 0, new_arr__6390, 0, 2 * idx__6384);
      new_arr__6390[2 * idx__6384] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6390[2 * idx__6384 + 1] = val;
      cljs.core.array_copy.call(null, this__6381.arr, 2 * idx__6384, new_arr__6390, 2 * (idx__6384 + 1), 2 * (n__6385 - idx__6384));
      return new cljs.core.BitmapIndexedNode(null, this__6381.bitmap | bit__6383, new_arr__6390)
    }
  }else {
    var key_or_nil__6391 = this__6381.arr[2 * idx__6384];
    var val_or_node__6392 = this__6381.arr[2 * idx__6384 + 1];
    if(null == key_or_nil__6391) {
      var n__6393 = val_or_node__6392.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6393 === val_or_node__6392) {
        return inode__6382
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6381.bitmap, cljs.core.clone_and_set.call(null, this__6381.arr, 2 * idx__6384 + 1, n__6393))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6391)) {
        if(val === val_or_node__6392) {
          return inode__6382
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6381.bitmap, cljs.core.clone_and_set.call(null, this__6381.arr, 2 * idx__6384 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6381.bitmap, cljs.core.clone_and_set.call(null, this__6381.arr, 2 * idx__6384, null, 2 * idx__6384 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6391, val_or_node__6392, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6403 = array_node.arr;
  var len__6404 = 2 * (array_node.cnt - 1);
  var new_arr__6405 = cljs.core.make_array.call(null, len__6404);
  var i__6406 = 0;
  var j__6407 = 1;
  var bitmap__6408 = 0;
  while(true) {
    if(i__6406 < len__6404) {
      if(function() {
        var and__3546__auto____6409 = i__6406 != idx;
        if(and__3546__auto____6409) {
          return null != arr__6403[i__6406]
        }else {
          return and__3546__auto____6409
        }
      }()) {
        new_arr__6405[j__6407] = arr__6403[i__6406];
        var G__6410 = i__6406 + 1;
        var G__6411 = j__6407 + 2;
        var G__6412 = bitmap__6408 | 1 << i__6406;
        i__6406 = G__6410;
        j__6407 = G__6411;
        bitmap__6408 = G__6412;
        continue
      }else {
        var G__6413 = i__6406 + 1;
        var G__6414 = j__6407;
        var G__6415 = bitmap__6408;
        i__6406 = G__6413;
        j__6407 = G__6414;
        bitmap__6408 = G__6415;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6408, new_arr__6405)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6416 = this;
  var inode__6417 = this;
  var idx__6418 = hash >>> shift & 31;
  var node__6419 = this__6416.arr[idx__6418];
  if(null == node__6419) {
    return new cljs.core.ArrayNode(null, this__6416.cnt + 1, cljs.core.clone_and_set.call(null, this__6416.arr, idx__6418, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6420 = node__6419.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6420 === node__6419) {
      return inode__6417
    }else {
      return new cljs.core.ArrayNode(null, this__6416.cnt, cljs.core.clone_and_set.call(null, this__6416.arr, idx__6418, n__6420))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6421 = this;
  var inode__6422 = this;
  var idx__6423 = hash >>> shift & 31;
  var node__6424 = this__6421.arr[idx__6423];
  if(null != node__6424) {
    var n__6425 = node__6424.inode_without(shift + 5, hash, key);
    if(n__6425 === node__6424) {
      return inode__6422
    }else {
      if(n__6425 == null) {
        if(this__6421.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6422, null, idx__6423)
        }else {
          return new cljs.core.ArrayNode(null, this__6421.cnt - 1, cljs.core.clone_and_set.call(null, this__6421.arr, idx__6423, n__6425))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6421.cnt, cljs.core.clone_and_set.call(null, this__6421.arr, idx__6423, n__6425))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6422
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6457 = null;
  var G__6457__3 = function(shift, hash, key) {
    var this__6426 = this;
    var inode__6427 = this;
    var idx__6428 = hash >>> shift & 31;
    var node__6429 = this__6426.arr[idx__6428];
    if(null != node__6429) {
      return node__6429.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6457__4 = function(shift, hash, key, not_found) {
    var this__6430 = this;
    var inode__6431 = this;
    var idx__6432 = hash >>> shift & 31;
    var node__6433 = this__6430.arr[idx__6432];
    if(null != node__6433) {
      return node__6433.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6457 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6457__3.call(this, shift, hash, key);
      case 4:
        return G__6457__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6457
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6434 = this;
  var inode__6435 = this;
  return cljs.core.create_array_node_seq.call(null, this__6434.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6436 = this;
  var inode__6437 = this;
  if(e === this__6436.edit) {
    return inode__6437
  }else {
    return new cljs.core.ArrayNode(e, this__6436.cnt, cljs.core.aclone.call(null, this__6436.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6438 = this;
  var inode__6439 = this;
  var idx__6440 = hash >>> shift & 31;
  var node__6441 = this__6438.arr[idx__6440];
  if(null == node__6441) {
    var editable__6442 = cljs.core.edit_and_set.call(null, inode__6439, edit, idx__6440, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6442.cnt = editable__6442.cnt + 1;
    return editable__6442
  }else {
    var n__6443 = node__6441.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6443 === node__6441) {
      return inode__6439
    }else {
      return cljs.core.edit_and_set.call(null, inode__6439, edit, idx__6440, n__6443)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6444 = this;
  var inode__6445 = this;
  var idx__6446 = hash >>> shift & 31;
  var node__6447 = this__6444.arr[idx__6446];
  if(null == node__6447) {
    return inode__6445
  }else {
    var n__6448 = node__6447.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6448 === node__6447) {
      return inode__6445
    }else {
      if(null == n__6448) {
        if(this__6444.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6445, edit, idx__6446)
        }else {
          var editable__6449 = cljs.core.edit_and_set.call(null, inode__6445, edit, idx__6446, n__6448);
          editable__6449.cnt = editable__6449.cnt - 1;
          return editable__6449
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6445, edit, idx__6446, n__6448)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6450 = this;
  var inode__6451 = this;
  var len__6452 = this__6450.arr.length;
  var i__6453 = 0;
  var init__6454 = init;
  while(true) {
    if(i__6453 < len__6452) {
      var node__6455 = this__6450.arr[i__6453];
      if(node__6455 != null) {
        var init__6456 = node__6455.kv_reduce(f, init__6454);
        if(cljs.core.reduced_QMARK_.call(null, init__6456)) {
          return cljs.core.deref.call(null, init__6456)
        }else {
          var G__6458 = i__6453 + 1;
          var G__6459 = init__6456;
          i__6453 = G__6458;
          init__6454 = G__6459;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6454
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6460 = 2 * cnt;
  var i__6461 = 0;
  while(true) {
    if(i__6461 < lim__6460) {
      if(cljs.core._EQ_.call(null, key, arr[i__6461])) {
        return i__6461
      }else {
        var G__6462 = i__6461 + 2;
        i__6461 = G__6462;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6463 = this;
  var inode__6464 = this;
  if(hash === this__6463.collision_hash) {
    var idx__6465 = cljs.core.hash_collision_node_find_index.call(null, this__6463.arr, this__6463.cnt, key);
    if(idx__6465 === -1) {
      var len__6466 = this__6463.arr.length;
      var new_arr__6467 = cljs.core.make_array.call(null, len__6466 + 2);
      cljs.core.array_copy.call(null, this__6463.arr, 0, new_arr__6467, 0, len__6466);
      new_arr__6467[len__6466] = key;
      new_arr__6467[len__6466 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6463.collision_hash, this__6463.cnt + 1, new_arr__6467)
    }else {
      if(cljs.core._EQ_.call(null, this__6463.arr[idx__6465], val)) {
        return inode__6464
      }else {
        return new cljs.core.HashCollisionNode(null, this__6463.collision_hash, this__6463.cnt, cljs.core.clone_and_set.call(null, this__6463.arr, idx__6465 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6463.collision_hash >>> shift & 31), [null, inode__6464])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6468 = this;
  var inode__6469 = this;
  var idx__6470 = cljs.core.hash_collision_node_find_index.call(null, this__6468.arr, this__6468.cnt, key);
  if(idx__6470 === -1) {
    return inode__6469
  }else {
    if(this__6468.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6468.collision_hash, this__6468.cnt - 1, cljs.core.remove_pair.call(null, this__6468.arr, cljs.core.quot.call(null, idx__6470, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6497 = null;
  var G__6497__3 = function(shift, hash, key) {
    var this__6471 = this;
    var inode__6472 = this;
    var idx__6473 = cljs.core.hash_collision_node_find_index.call(null, this__6471.arr, this__6471.cnt, key);
    if(idx__6473 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6471.arr[idx__6473])) {
        return cljs.core.PersistentVector.fromArray([this__6471.arr[idx__6473], this__6471.arr[idx__6473 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6497__4 = function(shift, hash, key, not_found) {
    var this__6474 = this;
    var inode__6475 = this;
    var idx__6476 = cljs.core.hash_collision_node_find_index.call(null, this__6474.arr, this__6474.cnt, key);
    if(idx__6476 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6474.arr[idx__6476])) {
        return cljs.core.PersistentVector.fromArray([this__6474.arr[idx__6476], this__6474.arr[idx__6476 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6497 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6497__3.call(this, shift, hash, key);
      case 4:
        return G__6497__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6497
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6477 = this;
  var inode__6478 = this;
  return cljs.core.create_inode_seq.call(null, this__6477.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6498 = null;
  var G__6498__1 = function(e) {
    var this__6479 = this;
    var inode__6480 = this;
    if(e === this__6479.edit) {
      return inode__6480
    }else {
      var new_arr__6481 = cljs.core.make_array.call(null, 2 * (this__6479.cnt + 1));
      cljs.core.array_copy.call(null, this__6479.arr, 0, new_arr__6481, 0, 2 * this__6479.cnt);
      return new cljs.core.HashCollisionNode(e, this__6479.collision_hash, this__6479.cnt, new_arr__6481)
    }
  };
  var G__6498__3 = function(e, count, array) {
    var this__6482 = this;
    var inode__6483 = this;
    if(e === this__6482.edit) {
      this__6482.arr = array;
      this__6482.cnt = count;
      return inode__6483
    }else {
      return new cljs.core.HashCollisionNode(this__6482.edit, this__6482.collision_hash, count, array)
    }
  };
  G__6498 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6498__1.call(this, e);
      case 3:
        return G__6498__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6498
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6484 = this;
  var inode__6485 = this;
  if(hash === this__6484.collision_hash) {
    var idx__6486 = cljs.core.hash_collision_node_find_index.call(null, this__6484.arr, this__6484.cnt, key);
    if(idx__6486 === -1) {
      if(this__6484.arr.length > 2 * this__6484.cnt) {
        var editable__6487 = cljs.core.edit_and_set.call(null, inode__6485, edit, 2 * this__6484.cnt, key, 2 * this__6484.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6487.cnt = editable__6487.cnt + 1;
        return editable__6487
      }else {
        var len__6488 = this__6484.arr.length;
        var new_arr__6489 = cljs.core.make_array.call(null, len__6488 + 2);
        cljs.core.array_copy.call(null, this__6484.arr, 0, new_arr__6489, 0, len__6488);
        new_arr__6489[len__6488] = key;
        new_arr__6489[len__6488 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6485.ensure_editable(edit, this__6484.cnt + 1, new_arr__6489)
      }
    }else {
      if(this__6484.arr[idx__6486 + 1] === val) {
        return inode__6485
      }else {
        return cljs.core.edit_and_set.call(null, inode__6485, edit, idx__6486 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6484.collision_hash >>> shift & 31), [null, inode__6485, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6490 = this;
  var inode__6491 = this;
  var idx__6492 = cljs.core.hash_collision_node_find_index.call(null, this__6490.arr, this__6490.cnt, key);
  if(idx__6492 === -1) {
    return inode__6491
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6490.cnt === 1) {
      return null
    }else {
      var editable__6493 = inode__6491.ensure_editable(edit);
      var earr__6494 = editable__6493.arr;
      earr__6494[idx__6492] = earr__6494[2 * this__6490.cnt - 2];
      earr__6494[idx__6492 + 1] = earr__6494[2 * this__6490.cnt - 1];
      earr__6494[2 * this__6490.cnt - 1] = null;
      earr__6494[2 * this__6490.cnt - 2] = null;
      editable__6493.cnt = editable__6493.cnt - 1;
      return editable__6493
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6495 = this;
  var inode__6496 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6495.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6499 = cljs.core.hash.call(null, key1);
    if(key1hash__6499 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6499, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6500 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6499, key1, val1, added_leaf_QMARK___6500).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6500)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6501 = cljs.core.hash.call(null, key1);
    if(key1hash__6501 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6501, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6502 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6501, key1, val1, added_leaf_QMARK___6502).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6502)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6503 = this;
  var h__364__auto____6504 = this__6503.__hash;
  if(h__364__auto____6504 != null) {
    return h__364__auto____6504
  }else {
    var h__364__auto____6505 = cljs.core.hash_coll.call(null, coll);
    this__6503.__hash = h__364__auto____6505;
    return h__364__auto____6505
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6506 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6507 = this;
  var this$__6508 = this;
  return cljs.core.pr_str.call(null, this$__6508)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6509 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6510 = this;
  if(this__6510.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6510.nodes[this__6510.i], this__6510.nodes[this__6510.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6510.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6511 = this;
  if(this__6511.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6511.nodes, this__6511.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6511.nodes, this__6511.i, cljs.core.next.call(null, this__6511.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6512 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6513 = this;
  return new cljs.core.NodeSeq(meta, this__6513.nodes, this__6513.i, this__6513.s, this__6513.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6514 = this;
  return this__6514.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6515 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6515.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6516 = nodes.length;
      var j__6517 = i;
      while(true) {
        if(j__6517 < len__6516) {
          if(null != nodes[j__6517]) {
            return new cljs.core.NodeSeq(null, nodes, j__6517, null, null)
          }else {
            var temp__3695__auto____6518 = nodes[j__6517 + 1];
            if(cljs.core.truth_(temp__3695__auto____6518)) {
              var node__6519 = temp__3695__auto____6518;
              var temp__3695__auto____6520 = node__6519.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6520)) {
                var node_seq__6521 = temp__3695__auto____6520;
                return new cljs.core.NodeSeq(null, nodes, j__6517 + 2, node_seq__6521, null)
              }else {
                var G__6522 = j__6517 + 2;
                j__6517 = G__6522;
                continue
              }
            }else {
              var G__6523 = j__6517 + 2;
              j__6517 = G__6523;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6524 = this;
  var h__364__auto____6525 = this__6524.__hash;
  if(h__364__auto____6525 != null) {
    return h__364__auto____6525
  }else {
    var h__364__auto____6526 = cljs.core.hash_coll.call(null, coll);
    this__6524.__hash = h__364__auto____6526;
    return h__364__auto____6526
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6527 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6528 = this;
  var this$__6529 = this;
  return cljs.core.pr_str.call(null, this$__6529)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6530 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6531 = this;
  return cljs.core.first.call(null, this__6531.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6532 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6532.nodes, this__6532.i, cljs.core.next.call(null, this__6532.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6533 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6534 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6534.nodes, this__6534.i, this__6534.s, this__6534.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6535 = this;
  return this__6535.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6536 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6536.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6537 = nodes.length;
      var j__6538 = i;
      while(true) {
        if(j__6538 < len__6537) {
          var temp__3695__auto____6539 = nodes[j__6538];
          if(cljs.core.truth_(temp__3695__auto____6539)) {
            var nj__6540 = temp__3695__auto____6539;
            var temp__3695__auto____6541 = nj__6540.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6541)) {
              var ns__6542 = temp__3695__auto____6541;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6538 + 1, ns__6542, null)
            }else {
              var G__6543 = j__6538 + 1;
              j__6538 = G__6543;
              continue
            }
          }else {
            var G__6544 = j__6538 + 1;
            j__6538 = G__6544;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6549 = this;
  return new cljs.core.TransientHashMap({}, this__6549.root, this__6549.cnt, this__6549.has_nil_QMARK_, this__6549.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6550 = this;
  var h__364__auto____6551 = this__6550.__hash;
  if(h__364__auto____6551 != null) {
    return h__364__auto____6551
  }else {
    var h__364__auto____6552 = cljs.core.hash_imap.call(null, coll);
    this__6550.__hash = h__364__auto____6552;
    return h__364__auto____6552
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6553 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6554 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6554.has_nil_QMARK_)) {
      return this__6554.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6554.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6554.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6555 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6556 = this__6555.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6556)) {
        return v === this__6555.nil_val
      }else {
        return and__3546__auto____6556
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6555.meta, cljs.core.truth_(this__6555.has_nil_QMARK_) ? this__6555.cnt : this__6555.cnt + 1, this__6555.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6557 = [false];
    var new_root__6558 = (this__6555.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6555.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6557);
    if(new_root__6558 === this__6555.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6555.meta, cljs.core.truth_(added_leaf_QMARK___6557[0]) ? this__6555.cnt + 1 : this__6555.cnt, new_root__6558, this__6555.has_nil_QMARK_, this__6555.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6559 = this;
  if(k == null) {
    return this__6559.has_nil_QMARK_
  }else {
    if(this__6559.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6559.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6580 = null;
  var G__6580__2 = function(tsym6547, k) {
    var this__6560 = this;
    var tsym6547__6561 = this;
    var coll__6562 = tsym6547__6561;
    return cljs.core._lookup.call(null, coll__6562, k)
  };
  var G__6580__3 = function(tsym6548, k, not_found) {
    var this__6563 = this;
    var tsym6548__6564 = this;
    var coll__6565 = tsym6548__6564;
    return cljs.core._lookup.call(null, coll__6565, k, not_found)
  };
  G__6580 = function(tsym6548, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6580__2.call(this, tsym6548, k);
      case 3:
        return G__6580__3.call(this, tsym6548, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6580
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6545, args6546) {
  return tsym6545.call.apply(tsym6545, [tsym6545].concat(cljs.core.aclone.call(null, args6546)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6566 = this;
  var init__6567 = cljs.core.truth_(this__6566.has_nil_QMARK_) ? f.call(null, init, null, this__6566.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6567)) {
    return cljs.core.deref.call(null, init__6567)
  }else {
    if(null != this__6566.root) {
      return this__6566.root.kv_reduce(f, init__6567)
    }else {
      if("\ufdd0'else") {
        return init__6567
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6568 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6569 = this;
  var this$__6570 = this;
  return cljs.core.pr_str.call(null, this$__6570)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6571 = this;
  if(this__6571.cnt > 0) {
    var s__6572 = null != this__6571.root ? this__6571.root.inode_seq() : null;
    if(cljs.core.truth_(this__6571.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6571.nil_val]), s__6572)
    }else {
      return s__6572
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6573 = this;
  return this__6573.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6574 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6575 = this;
  return new cljs.core.PersistentHashMap(meta, this__6575.cnt, this__6575.root, this__6575.has_nil_QMARK_, this__6575.nil_val, this__6575.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6576 = this;
  return this__6576.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6577 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6577.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6578 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6578.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6578.meta, this__6578.cnt - 1, this__6578.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6578.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6579 = this__6578.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6579 === this__6578.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6578.meta, this__6578.cnt - 1, new_root__6579, this__6578.has_nil_QMARK_, this__6578.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6581 = ks.length;
  var i__6582 = 0;
  var out__6583 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6582 < len__6581) {
      var G__6584 = i__6582 + 1;
      var G__6585 = cljs.core.assoc_BANG_.call(null, out__6583, ks[i__6582], vs[i__6582]);
      i__6582 = G__6584;
      out__6583 = G__6585;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6583)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6586 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6587 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6588 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6589 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6590 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6590.has_nil_QMARK_)) {
      return this__6590.nil_val
    }else {
      return null
    }
  }else {
    if(this__6590.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6590.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6591 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6591.has_nil_QMARK_)) {
      return this__6591.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6591.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6591.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6592 = this;
  if(cljs.core.truth_(this__6592.edit)) {
    return this__6592.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6593 = this;
  var tcoll__6594 = this;
  if(cljs.core.truth_(this__6593.edit)) {
    if(function() {
      var G__6595__6596 = o;
      if(G__6595__6596 != null) {
        if(function() {
          var or__3548__auto____6597 = G__6595__6596.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6597) {
            return or__3548__auto____6597
          }else {
            return G__6595__6596.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6595__6596.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6595__6596)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6595__6596)
      }
    }()) {
      return tcoll__6594.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6598 = cljs.core.seq.call(null, o);
      var tcoll__6599 = tcoll__6594;
      while(true) {
        var temp__3695__auto____6600 = cljs.core.first.call(null, es__6598);
        if(cljs.core.truth_(temp__3695__auto____6600)) {
          var e__6601 = temp__3695__auto____6600;
          var G__6612 = cljs.core.next.call(null, es__6598);
          var G__6613 = tcoll__6599.assoc_BANG_(cljs.core.key.call(null, e__6601), cljs.core.val.call(null, e__6601));
          es__6598 = G__6612;
          tcoll__6599 = G__6613;
          continue
        }else {
          return tcoll__6599
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6602 = this;
  var tcoll__6603 = this;
  if(cljs.core.truth_(this__6602.edit)) {
    if(k == null) {
      if(this__6602.nil_val === v) {
      }else {
        this__6602.nil_val = v
      }
      if(cljs.core.truth_(this__6602.has_nil_QMARK_)) {
      }else {
        this__6602.count = this__6602.count + 1;
        this__6602.has_nil_QMARK_ = true
      }
      return tcoll__6603
    }else {
      var added_leaf_QMARK___6604 = [false];
      var node__6605 = (this__6602.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6602.root).inode_assoc_BANG_(this__6602.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6604);
      if(node__6605 === this__6602.root) {
      }else {
        this__6602.root = node__6605
      }
      if(cljs.core.truth_(added_leaf_QMARK___6604[0])) {
        this__6602.count = this__6602.count + 1
      }else {
      }
      return tcoll__6603
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6606 = this;
  var tcoll__6607 = this;
  if(cljs.core.truth_(this__6606.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6606.has_nil_QMARK_)) {
        this__6606.has_nil_QMARK_ = false;
        this__6606.nil_val = null;
        this__6606.count = this__6606.count - 1;
        return tcoll__6607
      }else {
        return tcoll__6607
      }
    }else {
      if(this__6606.root == null) {
        return tcoll__6607
      }else {
        var removed_leaf_QMARK___6608 = [false];
        var node__6609 = this__6606.root.inode_without_BANG_(this__6606.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6608);
        if(node__6609 === this__6606.root) {
        }else {
          this__6606.root = node__6609
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6608[0])) {
          this__6606.count = this__6606.count - 1
        }else {
        }
        return tcoll__6607
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6610 = this;
  var tcoll__6611 = this;
  if(cljs.core.truth_(this__6610.edit)) {
    this__6610.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6610.count, this__6610.root, this__6610.has_nil_QMARK_, this__6610.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6614 = node;
  var stack__6615 = stack;
  while(true) {
    if(t__6614 != null) {
      var G__6616 = cljs.core.truth_(ascending_QMARK_) ? t__6614.left : t__6614.right;
      var G__6617 = cljs.core.conj.call(null, stack__6615, t__6614);
      t__6614 = G__6616;
      stack__6615 = G__6617;
      continue
    }else {
      return stack__6615
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6618 = this;
  var h__364__auto____6619 = this__6618.__hash;
  if(h__364__auto____6619 != null) {
    return h__364__auto____6619
  }else {
    var h__364__auto____6620 = cljs.core.hash_coll.call(null, coll);
    this__6618.__hash = h__364__auto____6620;
    return h__364__auto____6620
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6621 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6622 = this;
  var this$__6623 = this;
  return cljs.core.pr_str.call(null, this$__6623)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6624 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6625 = this;
  if(this__6625.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6625.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6626 = this;
  return cljs.core.peek.call(null, this__6626.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6627 = this;
  var t__6628 = cljs.core.peek.call(null, this__6627.stack);
  var next_stack__6629 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6627.ascending_QMARK_) ? t__6628.right : t__6628.left, cljs.core.pop.call(null, this__6627.stack), this__6627.ascending_QMARK_);
  if(next_stack__6629 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6629, this__6627.ascending_QMARK_, this__6627.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6630 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6631 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6631.stack, this__6631.ascending_QMARK_, this__6631.cnt, this__6631.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6632 = this;
  return this__6632.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6633 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6633) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6633
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6634 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6634) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6634
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6635 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6635)) {
    return cljs.core.deref.call(null, init__6635)
  }else {
    var init__6636 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6635) : init__6635;
    if(cljs.core.reduced_QMARK_.call(null, init__6636)) {
      return cljs.core.deref.call(null, init__6636)
    }else {
      var init__6637 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6636) : init__6636;
      if(cljs.core.reduced_QMARK_.call(null, init__6637)) {
        return cljs.core.deref.call(null, init__6637)
      }else {
        return init__6637
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6642 = this;
  var h__364__auto____6643 = this__6642.__hash;
  if(h__364__auto____6643 != null) {
    return h__364__auto____6643
  }else {
    var h__364__auto____6644 = cljs.core.hash_coll.call(null, coll);
    this__6642.__hash = h__364__auto____6644;
    return h__364__auto____6644
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6645 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6646 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6647 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6647.key, this__6647.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6694 = null;
  var G__6694__2 = function(tsym6640, k) {
    var this__6648 = this;
    var tsym6640__6649 = this;
    var node__6650 = tsym6640__6649;
    return cljs.core._lookup.call(null, node__6650, k)
  };
  var G__6694__3 = function(tsym6641, k, not_found) {
    var this__6651 = this;
    var tsym6641__6652 = this;
    var node__6653 = tsym6641__6652;
    return cljs.core._lookup.call(null, node__6653, k, not_found)
  };
  G__6694 = function(tsym6641, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6694__2.call(this, tsym6641, k);
      case 3:
        return G__6694__3.call(this, tsym6641, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6694
}();
cljs.core.BlackNode.prototype.apply = function(tsym6638, args6639) {
  return tsym6638.call.apply(tsym6638, [tsym6638].concat(cljs.core.aclone.call(null, args6639)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6654 = this;
  return cljs.core.PersistentVector.fromArray([this__6654.key, this__6654.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6655 = this;
  return this__6655.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6656 = this;
  return this__6656.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6657 = this;
  var node__6658 = this;
  return ins.balance_right(node__6658)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6659 = this;
  var node__6660 = this;
  return new cljs.core.RedNode(this__6659.key, this__6659.val, this__6659.left, this__6659.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6661 = this;
  var node__6662 = this;
  return cljs.core.balance_right_del.call(null, this__6661.key, this__6661.val, this__6661.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6663 = this;
  var node__6664 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6665 = this;
  var node__6666 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6666, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6667 = this;
  var node__6668 = this;
  return cljs.core.balance_left_del.call(null, this__6667.key, this__6667.val, del, this__6667.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6669 = this;
  var node__6670 = this;
  return ins.balance_left(node__6670)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6671 = this;
  var node__6672 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6672, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6695 = null;
  var G__6695__0 = function() {
    var this__6675 = this;
    var this$__6676 = this;
    return cljs.core.pr_str.call(null, this$__6676)
  };
  G__6695 = function() {
    switch(arguments.length) {
      case 0:
        return G__6695__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6695
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6677 = this;
  var node__6678 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6678, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6679 = this;
  var node__6680 = this;
  return node__6680
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6681 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6682 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6683 = this;
  return cljs.core.list.call(null, this__6683.key, this__6683.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6685 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6686 = this;
  return this__6686.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6687 = this;
  return cljs.core.PersistentVector.fromArray([this__6687.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6688 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6688.key, this__6688.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6689 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6690 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6690.key, this__6690.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6691 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6692 = this;
  if(n === 0) {
    return this__6692.key
  }else {
    if(n === 1) {
      return this__6692.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6693 = this;
  if(n === 0) {
    return this__6693.key
  }else {
    if(n === 1) {
      return this__6693.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6684 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6700 = this;
  var h__364__auto____6701 = this__6700.__hash;
  if(h__364__auto____6701 != null) {
    return h__364__auto____6701
  }else {
    var h__364__auto____6702 = cljs.core.hash_coll.call(null, coll);
    this__6700.__hash = h__364__auto____6702;
    return h__364__auto____6702
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6703 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6704 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6705 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6705.key, this__6705.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6752 = null;
  var G__6752__2 = function(tsym6698, k) {
    var this__6706 = this;
    var tsym6698__6707 = this;
    var node__6708 = tsym6698__6707;
    return cljs.core._lookup.call(null, node__6708, k)
  };
  var G__6752__3 = function(tsym6699, k, not_found) {
    var this__6709 = this;
    var tsym6699__6710 = this;
    var node__6711 = tsym6699__6710;
    return cljs.core._lookup.call(null, node__6711, k, not_found)
  };
  G__6752 = function(tsym6699, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6752__2.call(this, tsym6699, k);
      case 3:
        return G__6752__3.call(this, tsym6699, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6752
}();
cljs.core.RedNode.prototype.apply = function(tsym6696, args6697) {
  return tsym6696.call.apply(tsym6696, [tsym6696].concat(cljs.core.aclone.call(null, args6697)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6712 = this;
  return cljs.core.PersistentVector.fromArray([this__6712.key, this__6712.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6713 = this;
  return this__6713.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6714 = this;
  return this__6714.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6715 = this;
  var node__6716 = this;
  return new cljs.core.RedNode(this__6715.key, this__6715.val, this__6715.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6717 = this;
  var node__6718 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6719 = this;
  var node__6720 = this;
  return new cljs.core.RedNode(this__6719.key, this__6719.val, this__6719.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6721 = this;
  var node__6722 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6723 = this;
  var node__6724 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6724, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6725 = this;
  var node__6726 = this;
  return new cljs.core.RedNode(this__6725.key, this__6725.val, del, this__6725.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6727 = this;
  var node__6728 = this;
  return new cljs.core.RedNode(this__6727.key, this__6727.val, ins, this__6727.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6729 = this;
  var node__6730 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6729.left)) {
    return new cljs.core.RedNode(this__6729.key, this__6729.val, this__6729.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6729.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6729.right)) {
      return new cljs.core.RedNode(this__6729.right.key, this__6729.right.val, new cljs.core.BlackNode(this__6729.key, this__6729.val, this__6729.left, this__6729.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6729.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6730, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6753 = null;
  var G__6753__0 = function() {
    var this__6733 = this;
    var this$__6734 = this;
    return cljs.core.pr_str.call(null, this$__6734)
  };
  G__6753 = function() {
    switch(arguments.length) {
      case 0:
        return G__6753__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6753
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6735 = this;
  var node__6736 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6735.right)) {
    return new cljs.core.RedNode(this__6735.key, this__6735.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6735.left, null), this__6735.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6735.left)) {
      return new cljs.core.RedNode(this__6735.left.key, this__6735.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6735.left.left, null), new cljs.core.BlackNode(this__6735.key, this__6735.val, this__6735.left.right, this__6735.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6736, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6737 = this;
  var node__6738 = this;
  return new cljs.core.BlackNode(this__6737.key, this__6737.val, this__6737.left, this__6737.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6739 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6740 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6741 = this;
  return cljs.core.list.call(null, this__6741.key, this__6741.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6743 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6744 = this;
  return this__6744.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6745 = this;
  return cljs.core.PersistentVector.fromArray([this__6745.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6746 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6746.key, this__6746.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6747 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6748 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6748.key, this__6748.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6749 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6750 = this;
  if(n === 0) {
    return this__6750.key
  }else {
    if(n === 1) {
      return this__6750.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6751 = this;
  if(n === 0) {
    return this__6751.key
  }else {
    if(n === 1) {
      return this__6751.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6742 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6754 = comp.call(null, k, tree.key);
    if(c__6754 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6754 < 0) {
        var ins__6755 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6755 != null) {
          return tree.add_left(ins__6755)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6756 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6756 != null) {
            return tree.add_right(ins__6756)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6757 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6757)) {
            return new cljs.core.RedNode(app__6757.key, app__6757.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6757.left), new cljs.core.RedNode(right.key, right.val, app__6757.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6757, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6758 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6758)) {
              return new cljs.core.RedNode(app__6758.key, app__6758.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6758.left, null), new cljs.core.BlackNode(right.key, right.val, app__6758.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6758, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6759 = comp.call(null, k, tree.key);
    if(c__6759 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6759 < 0) {
        var del__6760 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6761 = del__6760 != null;
          if(or__3548__auto____6761) {
            return or__3548__auto____6761
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6760, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6760, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6762 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6763 = del__6762 != null;
            if(or__3548__auto____6763) {
              return or__3548__auto____6763
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6762)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6762, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6764 = tree.key;
  var c__6765 = comp.call(null, k, tk__6764);
  if(c__6765 === 0) {
    return tree.replace(tk__6764, v, tree.left, tree.right)
  }else {
    if(c__6765 < 0) {
      return tree.replace(tk__6764, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6764, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6770 = this;
  var h__364__auto____6771 = this__6770.__hash;
  if(h__364__auto____6771 != null) {
    return h__364__auto____6771
  }else {
    var h__364__auto____6772 = cljs.core.hash_imap.call(null, coll);
    this__6770.__hash = h__364__auto____6772;
    return h__364__auto____6772
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6773 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6774 = this;
  var n__6775 = coll.entry_at(k);
  if(n__6775 != null) {
    return n__6775.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6776 = this;
  var found__6777 = [null];
  var t__6778 = cljs.core.tree_map_add.call(null, this__6776.comp, this__6776.tree, k, v, found__6777);
  if(t__6778 == null) {
    var found_node__6779 = cljs.core.nth.call(null, found__6777, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6779.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6776.comp, cljs.core.tree_map_replace.call(null, this__6776.comp, this__6776.tree, k, v), this__6776.cnt, this__6776.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6776.comp, t__6778.blacken(), this__6776.cnt + 1, this__6776.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6780 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6812 = null;
  var G__6812__2 = function(tsym6768, k) {
    var this__6781 = this;
    var tsym6768__6782 = this;
    var coll__6783 = tsym6768__6782;
    return cljs.core._lookup.call(null, coll__6783, k)
  };
  var G__6812__3 = function(tsym6769, k, not_found) {
    var this__6784 = this;
    var tsym6769__6785 = this;
    var coll__6786 = tsym6769__6785;
    return cljs.core._lookup.call(null, coll__6786, k, not_found)
  };
  G__6812 = function(tsym6769, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6812__2.call(this, tsym6769, k);
      case 3:
        return G__6812__3.call(this, tsym6769, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6812
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6766, args6767) {
  return tsym6766.call.apply(tsym6766, [tsym6766].concat(cljs.core.aclone.call(null, args6767)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6787 = this;
  if(this__6787.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6787.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6788 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6789 = this;
  if(this__6789.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6789.tree, false, this__6789.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6790 = this;
  var this$__6791 = this;
  return cljs.core.pr_str.call(null, this$__6791)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6792 = this;
  var coll__6793 = this;
  var t__6794 = this__6792.tree;
  while(true) {
    if(t__6794 != null) {
      var c__6795 = this__6792.comp.call(null, k, t__6794.key);
      if(c__6795 === 0) {
        return t__6794
      }else {
        if(c__6795 < 0) {
          var G__6813 = t__6794.left;
          t__6794 = G__6813;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6814 = t__6794.right;
            t__6794 = G__6814;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6796 = this;
  if(this__6796.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6796.tree, ascending_QMARK_, this__6796.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6797 = this;
  if(this__6797.cnt > 0) {
    var stack__6798 = null;
    var t__6799 = this__6797.tree;
    while(true) {
      if(t__6799 != null) {
        var c__6800 = this__6797.comp.call(null, k, t__6799.key);
        if(c__6800 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6798, t__6799), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6800 < 0) {
              var G__6815 = cljs.core.conj.call(null, stack__6798, t__6799);
              var G__6816 = t__6799.left;
              stack__6798 = G__6815;
              t__6799 = G__6816;
              continue
            }else {
              var G__6817 = stack__6798;
              var G__6818 = t__6799.right;
              stack__6798 = G__6817;
              t__6799 = G__6818;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6800 > 0) {
                var G__6819 = cljs.core.conj.call(null, stack__6798, t__6799);
                var G__6820 = t__6799.right;
                stack__6798 = G__6819;
                t__6799 = G__6820;
                continue
              }else {
                var G__6821 = stack__6798;
                var G__6822 = t__6799.left;
                stack__6798 = G__6821;
                t__6799 = G__6822;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6798 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6798, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6801 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6802 = this;
  return this__6802.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6803 = this;
  if(this__6803.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6803.tree, true, this__6803.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6804 = this;
  return this__6804.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6805 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6806 = this;
  return new cljs.core.PersistentTreeMap(this__6806.comp, this__6806.tree, this__6806.cnt, meta, this__6806.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6810 = this;
  return this__6810.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6811 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6811.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6807 = this;
  var found__6808 = [null];
  var t__6809 = cljs.core.tree_map_remove.call(null, this__6807.comp, this__6807.tree, k, found__6808);
  if(t__6809 == null) {
    if(cljs.core.nth.call(null, found__6808, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6807.comp, null, 0, this__6807.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6807.comp, t__6809.blacken(), this__6807.cnt - 1, this__6807.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6823 = cljs.core.seq.call(null, keyvals);
    var out__6824 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6823)) {
        var G__6825 = cljs.core.nnext.call(null, in$__6823);
        var G__6826 = cljs.core.assoc_BANG_.call(null, out__6824, cljs.core.first.call(null, in$__6823), cljs.core.second.call(null, in$__6823));
        in$__6823 = G__6825;
        out__6824 = G__6826;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6824)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6827) {
    var keyvals = cljs.core.seq(arglist__6827);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6828) {
    var keyvals = cljs.core.seq(arglist__6828);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6829 = cljs.core.seq.call(null, keyvals);
    var out__6830 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6829)) {
        var G__6831 = cljs.core.nnext.call(null, in$__6829);
        var G__6832 = cljs.core.assoc.call(null, out__6830, cljs.core.first.call(null, in$__6829), cljs.core.second.call(null, in$__6829));
        in$__6829 = G__6831;
        out__6830 = G__6832;
        continue
      }else {
        return out__6830
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6833) {
    var keyvals = cljs.core.seq(arglist__6833);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6834 = cljs.core.seq.call(null, keyvals);
    var out__6835 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6834)) {
        var G__6836 = cljs.core.nnext.call(null, in$__6834);
        var G__6837 = cljs.core.assoc.call(null, out__6835, cljs.core.first.call(null, in$__6834), cljs.core.second.call(null, in$__6834));
        in$__6834 = G__6836;
        out__6835 = G__6837;
        continue
      }else {
        return out__6835
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6838) {
    var comparator = cljs.core.first(arglist__6838);
    var keyvals = cljs.core.rest(arglist__6838);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6839_SHARP_, p2__6840_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6841 = p1__6839_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6841)) {
            return or__3548__auto____6841
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6840_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6842) {
    var maps = cljs.core.seq(arglist__6842);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6845 = function(m, e) {
        var k__6843 = cljs.core.first.call(null, e);
        var v__6844 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6843)) {
          return cljs.core.assoc.call(null, m, k__6843, f.call(null, cljs.core.get.call(null, m, k__6843), v__6844))
        }else {
          return cljs.core.assoc.call(null, m, k__6843, v__6844)
        }
      };
      var merge2__6847 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6845, function() {
          var or__3548__auto____6846 = m1;
          if(cljs.core.truth_(or__3548__auto____6846)) {
            return or__3548__auto____6846
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6847, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6848) {
    var f = cljs.core.first(arglist__6848);
    var maps = cljs.core.rest(arglist__6848);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6849 = cljs.core.ObjMap.fromObject([], {});
  var keys__6850 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6850)) {
      var key__6851 = cljs.core.first.call(null, keys__6850);
      var entry__6852 = cljs.core.get.call(null, map, key__6851, "\ufdd0'user/not-found");
      var G__6853 = cljs.core.not_EQ_.call(null, entry__6852, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6849, key__6851, entry__6852) : ret__6849;
      var G__6854 = cljs.core.next.call(null, keys__6850);
      ret__6849 = G__6853;
      keys__6850 = G__6854;
      continue
    }else {
      return ret__6849
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6860 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6860.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6861 = this;
  var h__364__auto____6862 = this__6861.__hash;
  if(h__364__auto____6862 != null) {
    return h__364__auto____6862
  }else {
    var h__364__auto____6863 = cljs.core.hash_iset.call(null, coll);
    this__6861.__hash = h__364__auto____6863;
    return h__364__auto____6863
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6864 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6865 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6865.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6884 = null;
  var G__6884__2 = function(tsym6858, k) {
    var this__6866 = this;
    var tsym6858__6867 = this;
    var coll__6868 = tsym6858__6867;
    return cljs.core._lookup.call(null, coll__6868, k)
  };
  var G__6884__3 = function(tsym6859, k, not_found) {
    var this__6869 = this;
    var tsym6859__6870 = this;
    var coll__6871 = tsym6859__6870;
    return cljs.core._lookup.call(null, coll__6871, k, not_found)
  };
  G__6884 = function(tsym6859, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6884__2.call(this, tsym6859, k);
      case 3:
        return G__6884__3.call(this, tsym6859, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6884
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6856, args6857) {
  return tsym6856.call.apply(tsym6856, [tsym6856].concat(cljs.core.aclone.call(null, args6857)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6872 = this;
  return new cljs.core.PersistentHashSet(this__6872.meta, cljs.core.assoc.call(null, this__6872.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6873 = this;
  var this$__6874 = this;
  return cljs.core.pr_str.call(null, this$__6874)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6875 = this;
  return cljs.core.keys.call(null, this__6875.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6876 = this;
  return new cljs.core.PersistentHashSet(this__6876.meta, cljs.core.dissoc.call(null, this__6876.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6877 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6878 = this;
  var and__3546__auto____6879 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6879) {
    var and__3546__auto____6880 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6880) {
      return cljs.core.every_QMARK_.call(null, function(p1__6855_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6855_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6880
    }
  }else {
    return and__3546__auto____6879
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6881 = this;
  return new cljs.core.PersistentHashSet(meta, this__6881.hash_map, this__6881.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6882 = this;
  return this__6882.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6883 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6883.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6902 = null;
  var G__6902__2 = function(tsym6888, k) {
    var this__6890 = this;
    var tsym6888__6891 = this;
    var tcoll__6892 = tsym6888__6891;
    if(cljs.core._lookup.call(null, this__6890.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6902__3 = function(tsym6889, k, not_found) {
    var this__6893 = this;
    var tsym6889__6894 = this;
    var tcoll__6895 = tsym6889__6894;
    if(cljs.core._lookup.call(null, this__6893.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6902 = function(tsym6889, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6902__2.call(this, tsym6889, k);
      case 3:
        return G__6902__3.call(this, tsym6889, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6902
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6886, args6887) {
  return tsym6886.call.apply(tsym6886, [tsym6886].concat(cljs.core.aclone.call(null, args6887)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6896 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6897 = this;
  if(cljs.core._lookup.call(null, this__6897.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6898 = this;
  return cljs.core.count.call(null, this__6898.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6899 = this;
  this__6899.transient_map = cljs.core.dissoc_BANG_.call(null, this__6899.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6900 = this;
  this__6900.transient_map = cljs.core.assoc_BANG_.call(null, this__6900.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6901 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6901.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6907 = this;
  var h__364__auto____6908 = this__6907.__hash;
  if(h__364__auto____6908 != null) {
    return h__364__auto____6908
  }else {
    var h__364__auto____6909 = cljs.core.hash_iset.call(null, coll);
    this__6907.__hash = h__364__auto____6909;
    return h__364__auto____6909
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6910 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6911 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6911.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6935 = null;
  var G__6935__2 = function(tsym6905, k) {
    var this__6912 = this;
    var tsym6905__6913 = this;
    var coll__6914 = tsym6905__6913;
    return cljs.core._lookup.call(null, coll__6914, k)
  };
  var G__6935__3 = function(tsym6906, k, not_found) {
    var this__6915 = this;
    var tsym6906__6916 = this;
    var coll__6917 = tsym6906__6916;
    return cljs.core._lookup.call(null, coll__6917, k, not_found)
  };
  G__6935 = function(tsym6906, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6935__2.call(this, tsym6906, k);
      case 3:
        return G__6935__3.call(this, tsym6906, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6935
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6903, args6904) {
  return tsym6903.call.apply(tsym6903, [tsym6903].concat(cljs.core.aclone.call(null, args6904)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6918 = this;
  return new cljs.core.PersistentTreeSet(this__6918.meta, cljs.core.assoc.call(null, this__6918.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6919 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6919.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6920 = this;
  var this$__6921 = this;
  return cljs.core.pr_str.call(null, this$__6921)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6922 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6922.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6923 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6923.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6924 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6925 = this;
  return cljs.core._comparator.call(null, this__6925.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6926 = this;
  return cljs.core.keys.call(null, this__6926.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6927 = this;
  return new cljs.core.PersistentTreeSet(this__6927.meta, cljs.core.dissoc.call(null, this__6927.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6928 = this;
  return cljs.core.count.call(null, this__6928.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6929 = this;
  var and__3546__auto____6930 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6930) {
    var and__3546__auto____6931 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6931) {
      return cljs.core.every_QMARK_.call(null, function(p1__6885_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6885_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6931
    }
  }else {
    return and__3546__auto____6930
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6932 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6932.tree_map, this__6932.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6933 = this;
  return this__6933.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6934 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6934.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6936 = cljs.core.seq.call(null, coll);
  var out__6937 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6936))) {
      var G__6938 = cljs.core.next.call(null, in$__6936);
      var G__6939 = cljs.core.conj_BANG_.call(null, out__6937, cljs.core.first.call(null, in$__6936));
      in$__6936 = G__6938;
      out__6937 = G__6939;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6937)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6940) {
    var keys = cljs.core.seq(arglist__6940);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6942) {
    var comparator = cljs.core.first(arglist__6942);
    var keys = cljs.core.rest(arglist__6942);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6943 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6944 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6944)) {
        var e__6945 = temp__3695__auto____6944;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6945))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6943, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6941_SHARP_) {
      var temp__3695__auto____6946 = cljs.core.find.call(null, smap, p1__6941_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6946)) {
        var e__6947 = temp__3695__auto____6946;
        return cljs.core.second.call(null, e__6947)
      }else {
        return p1__6941_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6955 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6948, seen) {
        while(true) {
          var vec__6949__6950 = p__6948;
          var f__6951 = cljs.core.nth.call(null, vec__6949__6950, 0, null);
          var xs__6952 = vec__6949__6950;
          var temp__3698__auto____6953 = cljs.core.seq.call(null, xs__6952);
          if(cljs.core.truth_(temp__3698__auto____6953)) {
            var s__6954 = temp__3698__auto____6953;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6951)) {
              var G__6956 = cljs.core.rest.call(null, s__6954);
              var G__6957 = seen;
              p__6948 = G__6956;
              seen = G__6957;
              continue
            }else {
              return cljs.core.cons.call(null, f__6951, step.call(null, cljs.core.rest.call(null, s__6954), cljs.core.conj.call(null, seen, f__6951)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6955.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6958 = cljs.core.PersistentVector.fromArray([]);
  var s__6959 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6959))) {
      var G__6960 = cljs.core.conj.call(null, ret__6958, cljs.core.first.call(null, s__6959));
      var G__6961 = cljs.core.next.call(null, s__6959);
      ret__6958 = G__6960;
      s__6959 = G__6961;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6958)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6962 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6962) {
        return or__3548__auto____6962
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6963 = x.lastIndexOf("/");
      if(i__6963 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6963 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6964 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6964) {
      return or__3548__auto____6964
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6965 = x.lastIndexOf("/");
    if(i__6965 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6965)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6968 = cljs.core.ObjMap.fromObject([], {});
  var ks__6969 = cljs.core.seq.call(null, keys);
  var vs__6970 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6971 = ks__6969;
      if(cljs.core.truth_(and__3546__auto____6971)) {
        return vs__6970
      }else {
        return and__3546__auto____6971
      }
    }())) {
      var G__6972 = cljs.core.assoc.call(null, map__6968, cljs.core.first.call(null, ks__6969), cljs.core.first.call(null, vs__6970));
      var G__6973 = cljs.core.next.call(null, ks__6969);
      var G__6974 = cljs.core.next.call(null, vs__6970);
      map__6968 = G__6972;
      ks__6969 = G__6973;
      vs__6970 = G__6974;
      continue
    }else {
      return map__6968
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6977__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6966_SHARP_, p2__6967_SHARP_) {
        return max_key.call(null, k, p1__6966_SHARP_, p2__6967_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6977 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6977__delegate.call(this, k, x, y, more)
    };
    G__6977.cljs$lang$maxFixedArity = 3;
    G__6977.cljs$lang$applyTo = function(arglist__6978) {
      var k = cljs.core.first(arglist__6978);
      var x = cljs.core.first(cljs.core.next(arglist__6978));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6978)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6978)));
      return G__6977__delegate(k, x, y, more)
    };
    G__6977.cljs$lang$arity$variadic = G__6977__delegate;
    return G__6977
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6979__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6975_SHARP_, p2__6976_SHARP_) {
        return min_key.call(null, k, p1__6975_SHARP_, p2__6976_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6979 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6979__delegate.call(this, k, x, y, more)
    };
    G__6979.cljs$lang$maxFixedArity = 3;
    G__6979.cljs$lang$applyTo = function(arglist__6980) {
      var k = cljs.core.first(arglist__6980);
      var x = cljs.core.first(cljs.core.next(arglist__6980));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6980)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6980)));
      return G__6979__delegate(k, x, y, more)
    };
    G__6979.cljs$lang$arity$variadic = G__6979__delegate;
    return G__6979
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6981 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6981)) {
        var s__6982 = temp__3698__auto____6981;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6982), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6982)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6983 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6983)) {
      var s__6984 = temp__3698__auto____6983;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6984)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6984), take_while.call(null, pred, cljs.core.rest.call(null, s__6984)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6985 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6985.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6986 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6987 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6987)) {
        var vec__6988__6989 = temp__3698__auto____6987;
        var e__6990 = cljs.core.nth.call(null, vec__6988__6989, 0, null);
        var s__6991 = vec__6988__6989;
        if(cljs.core.truth_(include__6986.call(null, e__6990))) {
          return s__6991
        }else {
          return cljs.core.next.call(null, s__6991)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6986, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6992 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6992)) {
      var vec__6993__6994 = temp__3698__auto____6992;
      var e__6995 = cljs.core.nth.call(null, vec__6993__6994, 0, null);
      var s__6996 = vec__6993__6994;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__6995)) ? s__6996 : cljs.core.next.call(null, s__6996))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__6997 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____6998 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____6998)) {
        var vec__6999__7000 = temp__3698__auto____6998;
        var e__7001 = cljs.core.nth.call(null, vec__6999__7000, 0, null);
        var s__7002 = vec__6999__7000;
        if(cljs.core.truth_(include__6997.call(null, e__7001))) {
          return s__7002
        }else {
          return cljs.core.next.call(null, s__7002)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6997, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7003 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____7003)) {
      var vec__7004__7005 = temp__3698__auto____7003;
      var e__7006 = cljs.core.nth.call(null, vec__7004__7005, 0, null);
      var s__7007 = vec__7004__7005;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__7006)) ? s__7007 : cljs.core.next.call(null, s__7007))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__7008 = this;
  var h__364__auto____7009 = this__7008.__hash;
  if(h__364__auto____7009 != null) {
    return h__364__auto____7009
  }else {
    var h__364__auto____7010 = cljs.core.hash_coll.call(null, rng);
    this__7008.__hash = h__364__auto____7010;
    return h__364__auto____7010
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__7011 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__7012 = this;
  var this$__7013 = this;
  return cljs.core.pr_str.call(null, this$__7013)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__7014 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__7015 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__7016 = this;
  var comp__7017 = this__7016.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__7017.call(null, this__7016.start, this__7016.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__7018 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__7018.end - this__7018.start) / this__7018.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__7019 = this;
  return this__7019.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__7020 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__7020.meta, this__7020.start + this__7020.step, this__7020.end, this__7020.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__7021 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__7022 = this;
  return new cljs.core.Range(meta, this__7022.start, this__7022.end, this__7022.step, this__7022.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__7023 = this;
  return this__7023.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__7024 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7024.start + n * this__7024.step
  }else {
    if(function() {
      var and__3546__auto____7025 = this__7024.start > this__7024.end;
      if(and__3546__auto____7025) {
        return this__7024.step === 0
      }else {
        return and__3546__auto____7025
      }
    }()) {
      return this__7024.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__7026 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7026.start + n * this__7026.step
  }else {
    if(function() {
      var and__3546__auto____7027 = this__7026.start > this__7026.end;
      if(and__3546__auto____7027) {
        return this__7026.step === 0
      }else {
        return and__3546__auto____7027
      }
    }()) {
      return this__7026.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__7028 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7028.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7029 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7029)) {
      var s__7030 = temp__3698__auto____7029;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__7030), take_nth.call(null, n, cljs.core.drop.call(null, n, s__7030)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7032 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7032)) {
      var s__7033 = temp__3698__auto____7032;
      var fst__7034 = cljs.core.first.call(null, s__7033);
      var fv__7035 = f.call(null, fst__7034);
      var run__7036 = cljs.core.cons.call(null, fst__7034, cljs.core.take_while.call(null, function(p1__7031_SHARP_) {
        return cljs.core._EQ_.call(null, fv__7035, f.call(null, p1__7031_SHARP_))
      }, cljs.core.next.call(null, s__7033)));
      return cljs.core.cons.call(null, run__7036, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__7036), s__7033))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____7047 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____7047)) {
        var s__7048 = temp__3695__auto____7047;
        return reductions.call(null, f, cljs.core.first.call(null, s__7048), cljs.core.rest.call(null, s__7048))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____7049 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____7049)) {
        var s__7050 = temp__3698__auto____7049;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__7050)), cljs.core.rest.call(null, s__7050))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__7052 = null;
      var G__7052__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__7052__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__7052__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__7052__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__7052__4 = function() {
        var G__7053__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__7053 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7053__delegate.call(this, x, y, z, args)
        };
        G__7053.cljs$lang$maxFixedArity = 3;
        G__7053.cljs$lang$applyTo = function(arglist__7054) {
          var x = cljs.core.first(arglist__7054);
          var y = cljs.core.first(cljs.core.next(arglist__7054));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7054)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7054)));
          return G__7053__delegate(x, y, z, args)
        };
        G__7053.cljs$lang$arity$variadic = G__7053__delegate;
        return G__7053
      }();
      G__7052 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7052__0.call(this);
          case 1:
            return G__7052__1.call(this, x);
          case 2:
            return G__7052__2.call(this, x, y);
          case 3:
            return G__7052__3.call(this, x, y, z);
          default:
            return G__7052__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7052.cljs$lang$maxFixedArity = 3;
      G__7052.cljs$lang$applyTo = G__7052__4.cljs$lang$applyTo;
      return G__7052
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__7055 = null;
      var G__7055__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__7055__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__7055__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__7055__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__7055__4 = function() {
        var G__7056__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__7056 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7056__delegate.call(this, x, y, z, args)
        };
        G__7056.cljs$lang$maxFixedArity = 3;
        G__7056.cljs$lang$applyTo = function(arglist__7057) {
          var x = cljs.core.first(arglist__7057);
          var y = cljs.core.first(cljs.core.next(arglist__7057));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7057)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7057)));
          return G__7056__delegate(x, y, z, args)
        };
        G__7056.cljs$lang$arity$variadic = G__7056__delegate;
        return G__7056
      }();
      G__7055 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7055__0.call(this);
          case 1:
            return G__7055__1.call(this, x);
          case 2:
            return G__7055__2.call(this, x, y);
          case 3:
            return G__7055__3.call(this, x, y, z);
          default:
            return G__7055__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7055.cljs$lang$maxFixedArity = 3;
      G__7055.cljs$lang$applyTo = G__7055__4.cljs$lang$applyTo;
      return G__7055
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__7058 = null;
      var G__7058__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__7058__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__7058__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__7058__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__7058__4 = function() {
        var G__7059__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__7059 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7059__delegate.call(this, x, y, z, args)
        };
        G__7059.cljs$lang$maxFixedArity = 3;
        G__7059.cljs$lang$applyTo = function(arglist__7060) {
          var x = cljs.core.first(arglist__7060);
          var y = cljs.core.first(cljs.core.next(arglist__7060));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7060)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7060)));
          return G__7059__delegate(x, y, z, args)
        };
        G__7059.cljs$lang$arity$variadic = G__7059__delegate;
        return G__7059
      }();
      G__7058 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7058__0.call(this);
          case 1:
            return G__7058__1.call(this, x);
          case 2:
            return G__7058__2.call(this, x, y);
          case 3:
            return G__7058__3.call(this, x, y, z);
          default:
            return G__7058__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7058.cljs$lang$maxFixedArity = 3;
      G__7058.cljs$lang$applyTo = G__7058__4.cljs$lang$applyTo;
      return G__7058
    }()
  };
  var juxt__4 = function() {
    var G__7061__delegate = function(f, g, h, fs) {
      var fs__7051 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__7062 = null;
        var G__7062__0 = function() {
          return cljs.core.reduce.call(null, function(p1__7037_SHARP_, p2__7038_SHARP_) {
            return cljs.core.conj.call(null, p1__7037_SHARP_, p2__7038_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__7051)
        };
        var G__7062__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__7039_SHARP_, p2__7040_SHARP_) {
            return cljs.core.conj.call(null, p1__7039_SHARP_, p2__7040_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__7051)
        };
        var G__7062__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__7041_SHARP_, p2__7042_SHARP_) {
            return cljs.core.conj.call(null, p1__7041_SHARP_, p2__7042_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__7051)
        };
        var G__7062__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__7043_SHARP_, p2__7044_SHARP_) {
            return cljs.core.conj.call(null, p1__7043_SHARP_, p2__7044_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__7051)
        };
        var G__7062__4 = function() {
          var G__7063__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__7045_SHARP_, p2__7046_SHARP_) {
              return cljs.core.conj.call(null, p1__7045_SHARP_, cljs.core.apply.call(null, p2__7046_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__7051)
          };
          var G__7063 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__7063__delegate.call(this, x, y, z, args)
          };
          G__7063.cljs$lang$maxFixedArity = 3;
          G__7063.cljs$lang$applyTo = function(arglist__7064) {
            var x = cljs.core.first(arglist__7064);
            var y = cljs.core.first(cljs.core.next(arglist__7064));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7064)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7064)));
            return G__7063__delegate(x, y, z, args)
          };
          G__7063.cljs$lang$arity$variadic = G__7063__delegate;
          return G__7063
        }();
        G__7062 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__7062__0.call(this);
            case 1:
              return G__7062__1.call(this, x);
            case 2:
              return G__7062__2.call(this, x, y);
            case 3:
              return G__7062__3.call(this, x, y, z);
            default:
              return G__7062__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__7062.cljs$lang$maxFixedArity = 3;
        G__7062.cljs$lang$applyTo = G__7062__4.cljs$lang$applyTo;
        return G__7062
      }()
    };
    var G__7061 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7061__delegate.call(this, f, g, h, fs)
    };
    G__7061.cljs$lang$maxFixedArity = 3;
    G__7061.cljs$lang$applyTo = function(arglist__7065) {
      var f = cljs.core.first(arglist__7065);
      var g = cljs.core.first(cljs.core.next(arglist__7065));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7065)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7065)));
      return G__7061__delegate(f, g, h, fs)
    };
    G__7061.cljs$lang$arity$variadic = G__7061__delegate;
    return G__7061
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__7067 = cljs.core.next.call(null, coll);
        coll = G__7067;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____7066 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____7066)) {
          return n > 0
        }else {
          return and__3546__auto____7066
        }
      }())) {
        var G__7068 = n - 1;
        var G__7069 = cljs.core.next.call(null, coll);
        n = G__7068;
        coll = G__7069;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__7070 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__7070), s)) {
    if(cljs.core.count.call(null, matches__7070) === 1) {
      return cljs.core.first.call(null, matches__7070)
    }else {
      return cljs.core.vec.call(null, matches__7070)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__7071 = re.exec(s);
  if(matches__7071 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__7071) === 1) {
      return cljs.core.first.call(null, matches__7071)
    }else {
      return cljs.core.vec.call(null, matches__7071)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__7072 = cljs.core.re_find.call(null, re, s);
  var match_idx__7073 = s.search(re);
  var match_str__7074 = cljs.core.coll_QMARK_.call(null, match_data__7072) ? cljs.core.first.call(null, match_data__7072) : match_data__7072;
  var post_match__7075 = cljs.core.subs.call(null, s, match_idx__7073 + cljs.core.count.call(null, match_str__7074));
  if(cljs.core.truth_(match_data__7072)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__7072, re_seq.call(null, re, post_match__7075))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__7077__7078 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___7079 = cljs.core.nth.call(null, vec__7077__7078, 0, null);
  var flags__7080 = cljs.core.nth.call(null, vec__7077__7078, 1, null);
  var pattern__7081 = cljs.core.nth.call(null, vec__7077__7078, 2, null);
  return new RegExp(pattern__7081, flags__7080)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__7076_SHARP_) {
    return print_one.call(null, p1__7076_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____7082 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____7082)) {
            var and__3546__auto____7086 = function() {
              var G__7083__7084 = obj;
              if(G__7083__7084 != null) {
                if(function() {
                  var or__3548__auto____7085 = G__7083__7084.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____7085) {
                    return or__3548__auto____7085
                  }else {
                    return G__7083__7084.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__7083__7084.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7083__7084)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7083__7084)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____7086)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____7086
            }
          }else {
            return and__3546__auto____7082
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____7087 = obj != null;
          if(and__3546__auto____7087) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____7087
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__7088__7089 = obj;
          if(G__7088__7089 != null) {
            if(function() {
              var or__3548__auto____7090 = G__7088__7089.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____7090) {
                return or__3548__auto____7090
              }else {
                return G__7088__7089.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__7088__7089.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7088__7089)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7088__7089)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__7091 = cljs.core.first.call(null, objs);
  var sb__7092 = new goog.string.StringBuffer;
  var G__7093__7094 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7093__7094)) {
    var obj__7095 = cljs.core.first.call(null, G__7093__7094);
    var G__7093__7096 = G__7093__7094;
    while(true) {
      if(obj__7095 === first_obj__7091) {
      }else {
        sb__7092.append(" ")
      }
      var G__7097__7098 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7095, opts));
      if(cljs.core.truth_(G__7097__7098)) {
        var string__7099 = cljs.core.first.call(null, G__7097__7098);
        var G__7097__7100 = G__7097__7098;
        while(true) {
          sb__7092.append(string__7099);
          var temp__3698__auto____7101 = cljs.core.next.call(null, G__7097__7100);
          if(cljs.core.truth_(temp__3698__auto____7101)) {
            var G__7097__7102 = temp__3698__auto____7101;
            var G__7105 = cljs.core.first.call(null, G__7097__7102);
            var G__7106 = G__7097__7102;
            string__7099 = G__7105;
            G__7097__7100 = G__7106;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7103 = cljs.core.next.call(null, G__7093__7096);
      if(cljs.core.truth_(temp__3698__auto____7103)) {
        var G__7093__7104 = temp__3698__auto____7103;
        var G__7107 = cljs.core.first.call(null, G__7093__7104);
        var G__7108 = G__7093__7104;
        obj__7095 = G__7107;
        G__7093__7096 = G__7108;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__7092
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__7109 = cljs.core.pr_sb.call(null, objs, opts);
  sb__7109.append("\n");
  return[cljs.core.str(sb__7109)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__7110 = cljs.core.first.call(null, objs);
  var G__7111__7112 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7111__7112)) {
    var obj__7113 = cljs.core.first.call(null, G__7111__7112);
    var G__7111__7114 = G__7111__7112;
    while(true) {
      if(obj__7113 === first_obj__7110) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__7115__7116 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7113, opts));
      if(cljs.core.truth_(G__7115__7116)) {
        var string__7117 = cljs.core.first.call(null, G__7115__7116);
        var G__7115__7118 = G__7115__7116;
        while(true) {
          cljs.core.string_print.call(null, string__7117);
          var temp__3698__auto____7119 = cljs.core.next.call(null, G__7115__7118);
          if(cljs.core.truth_(temp__3698__auto____7119)) {
            var G__7115__7120 = temp__3698__auto____7119;
            var G__7123 = cljs.core.first.call(null, G__7115__7120);
            var G__7124 = G__7115__7120;
            string__7117 = G__7123;
            G__7115__7118 = G__7124;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7121 = cljs.core.next.call(null, G__7111__7114);
      if(cljs.core.truth_(temp__3698__auto____7121)) {
        var G__7111__7122 = temp__3698__auto____7121;
        var G__7125 = cljs.core.first.call(null, G__7111__7122);
        var G__7126 = G__7111__7122;
        obj__7113 = G__7125;
        G__7111__7114 = G__7126;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__7127) {
    var objs = cljs.core.seq(arglist__7127);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__7128) {
    var objs = cljs.core.seq(arglist__7128);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__7129) {
    var objs = cljs.core.seq(arglist__7129);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__7130) {
    var objs = cljs.core.seq(arglist__7130);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__7131) {
    var objs = cljs.core.seq(arglist__7131);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__7132) {
    var objs = cljs.core.seq(arglist__7132);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__7133) {
    var objs = cljs.core.seq(arglist__7133);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__7134) {
    var objs = cljs.core.seq(arglist__7134);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7135 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7135, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7136 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7136, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7137 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7137, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____7138 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____7138)) {
        var nspc__7139 = temp__3698__auto____7138;
        return[cljs.core.str(nspc__7139), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____7140 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____7140)) {
          var nspc__7141 = temp__3698__auto____7140;
          return[cljs.core.str(nspc__7141), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7142 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7142, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7143 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7143, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7144 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__7145 = this;
  var G__7146__7147 = cljs.core.seq.call(null, this__7145.watches);
  if(cljs.core.truth_(G__7146__7147)) {
    var G__7149__7151 = cljs.core.first.call(null, G__7146__7147);
    var vec__7150__7152 = G__7149__7151;
    var key__7153 = cljs.core.nth.call(null, vec__7150__7152, 0, null);
    var f__7154 = cljs.core.nth.call(null, vec__7150__7152, 1, null);
    var G__7146__7155 = G__7146__7147;
    var G__7149__7156 = G__7149__7151;
    var G__7146__7157 = G__7146__7155;
    while(true) {
      var vec__7158__7159 = G__7149__7156;
      var key__7160 = cljs.core.nth.call(null, vec__7158__7159, 0, null);
      var f__7161 = cljs.core.nth.call(null, vec__7158__7159, 1, null);
      var G__7146__7162 = G__7146__7157;
      f__7161.call(null, key__7160, this$, oldval, newval);
      var temp__3698__auto____7163 = cljs.core.next.call(null, G__7146__7162);
      if(cljs.core.truth_(temp__3698__auto____7163)) {
        var G__7146__7164 = temp__3698__auto____7163;
        var G__7171 = cljs.core.first.call(null, G__7146__7164);
        var G__7172 = G__7146__7164;
        G__7149__7156 = G__7171;
        G__7146__7157 = G__7172;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__7165 = this;
  return this$.watches = cljs.core.assoc.call(null, this__7165.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__7166 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__7166.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__7167 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__7167.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__7168 = this;
  return this__7168.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7169 = this;
  return this__7169.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__7170 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7179__delegate = function(x, p__7173) {
      var map__7174__7175 = p__7173;
      var map__7174__7176 = cljs.core.seq_QMARK_.call(null, map__7174__7175) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7174__7175) : map__7174__7175;
      var validator__7177 = cljs.core.get.call(null, map__7174__7176, "\ufdd0'validator");
      var meta__7178 = cljs.core.get.call(null, map__7174__7176, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7178, validator__7177, null)
    };
    var G__7179 = function(x, var_args) {
      var p__7173 = null;
      if(goog.isDef(var_args)) {
        p__7173 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7179__delegate.call(this, x, p__7173)
    };
    G__7179.cljs$lang$maxFixedArity = 1;
    G__7179.cljs$lang$applyTo = function(arglist__7180) {
      var x = cljs.core.first(arglist__7180);
      var p__7173 = cljs.core.rest(arglist__7180);
      return G__7179__delegate(x, p__7173)
    };
    G__7179.cljs$lang$arity$variadic = G__7179__delegate;
    return G__7179
  }();
  atom = function(x, var_args) {
    var p__7173 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7181 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7181)) {
    var validate__7182 = temp__3698__auto____7181;
    if(cljs.core.truth_(validate__7182.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7183 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7183, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7184__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7184 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7184__delegate.call(this, a, f, x, y, z, more)
    };
    G__7184.cljs$lang$maxFixedArity = 5;
    G__7184.cljs$lang$applyTo = function(arglist__7185) {
      var a = cljs.core.first(arglist__7185);
      var f = cljs.core.first(cljs.core.next(arglist__7185));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7185)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7185))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7185)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7185)))));
      return G__7184__delegate(a, f, x, y, z, more)
    };
    G__7184.cljs$lang$arity$variadic = G__7184__delegate;
    return G__7184
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7186) {
    var iref = cljs.core.first(arglist__7186);
    var f = cljs.core.first(cljs.core.next(arglist__7186));
    var args = cljs.core.rest(cljs.core.next(arglist__7186));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7187 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7187.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7188 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7188.state, function(p__7189) {
    var curr_state__7190 = p__7189;
    var curr_state__7191 = cljs.core.seq_QMARK_.call(null, curr_state__7190) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7190) : curr_state__7190;
    var done__7192 = cljs.core.get.call(null, curr_state__7191, "\ufdd0'done");
    if(cljs.core.truth_(done__7192)) {
      return curr_state__7191
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7188.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7193__7194 = options;
    var map__7193__7195 = cljs.core.seq_QMARK_.call(null, map__7193__7194) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7193__7194) : map__7193__7194;
    var keywordize_keys__7196 = cljs.core.get.call(null, map__7193__7195, "\ufdd0'keywordize-keys");
    var keyfn__7197 = cljs.core.truth_(keywordize_keys__7196) ? cljs.core.keyword : cljs.core.str;
    var f__7203 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7202 = function iter__7198(s__7199) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7199__7200 = s__7199;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7199__7200))) {
                        var k__7201 = cljs.core.first.call(null, s__7199__7200);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7197.call(null, k__7201), thisfn.call(null, x[k__7201])]), iter__7198.call(null, cljs.core.rest.call(null, s__7199__7200)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7202.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7203.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7204) {
    var x = cljs.core.first(arglist__7204);
    var options = cljs.core.rest(arglist__7204);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7205 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7209__delegate = function(args) {
      var temp__3695__auto____7206 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7205), args);
      if(cljs.core.truth_(temp__3695__auto____7206)) {
        var v__7207 = temp__3695__auto____7206;
        return v__7207
      }else {
        var ret__7208 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7205, cljs.core.assoc, args, ret__7208);
        return ret__7208
      }
    };
    var G__7209 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7209__delegate.call(this, args)
    };
    G__7209.cljs$lang$maxFixedArity = 0;
    G__7209.cljs$lang$applyTo = function(arglist__7210) {
      var args = cljs.core.seq(arglist__7210);
      return G__7209__delegate(args)
    };
    G__7209.cljs$lang$arity$variadic = G__7209__delegate;
    return G__7209
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7211 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7211)) {
        var G__7212 = ret__7211;
        f = G__7212;
        continue
      }else {
        return ret__7211
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7213__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7213 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7213__delegate.call(this, f, args)
    };
    G__7213.cljs$lang$maxFixedArity = 1;
    G__7213.cljs$lang$applyTo = function(arglist__7214) {
      var f = cljs.core.first(arglist__7214);
      var args = cljs.core.rest(arglist__7214);
      return G__7213__delegate(f, args)
    };
    G__7213.cljs$lang$arity$variadic = G__7213__delegate;
    return G__7213
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7215 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7215, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7215, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7216 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7216) {
      return or__3548__auto____7216
    }else {
      var or__3548__auto____7217 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7217) {
        return or__3548__auto____7217
      }else {
        var and__3546__auto____7218 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7218) {
          var and__3546__auto____7219 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7219) {
            var and__3546__auto____7220 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7220) {
              var ret__7221 = true;
              var i__7222 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7223 = cljs.core.not.call(null, ret__7221);
                  if(or__3548__auto____7223) {
                    return or__3548__auto____7223
                  }else {
                    return i__7222 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7221
                }else {
                  var G__7224 = isa_QMARK_.call(null, h, child.call(null, i__7222), parent.call(null, i__7222));
                  var G__7225 = i__7222 + 1;
                  ret__7221 = G__7224;
                  i__7222 = G__7225;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7220
            }
          }else {
            return and__3546__auto____7219
          }
        }else {
          return and__3546__auto____7218
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7229 = "\ufdd0'parents".call(null, h);
    var td__7230 = "\ufdd0'descendants".call(null, h);
    var ta__7231 = "\ufdd0'ancestors".call(null, h);
    var tf__7232 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7233 = cljs.core.contains_QMARK_.call(null, tp__7229.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7231.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7231.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7229, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7232.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7230, parent, ta__7231), "\ufdd0'descendants":tf__7232.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7231, tag, td__7230)})
    }();
    if(cljs.core.truth_(or__3548__auto____7233)) {
      return or__3548__auto____7233
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7234 = "\ufdd0'parents".call(null, h);
    var childsParents__7235 = cljs.core.truth_(parentMap__7234.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7234.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7236 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7235)) ? cljs.core.assoc.call(null, parentMap__7234, tag, childsParents__7235) : cljs.core.dissoc.call(null, parentMap__7234, tag);
    var deriv_seq__7237 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7226_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7226_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7226_SHARP_), cljs.core.second.call(null, p1__7226_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7236)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7234.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7227_SHARP_, p2__7228_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7227_SHARP_, p2__7228_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7237))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7238 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7240 = cljs.core.truth_(function() {
    var and__3546__auto____7239 = xprefs__7238;
    if(cljs.core.truth_(and__3546__auto____7239)) {
      return xprefs__7238.call(null, y)
    }else {
      return and__3546__auto____7239
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7240)) {
    return or__3548__auto____7240
  }else {
    var or__3548__auto____7242 = function() {
      var ps__7241 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7241) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7241), prefer_table))) {
          }else {
          }
          var G__7245 = cljs.core.rest.call(null, ps__7241);
          ps__7241 = G__7245;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7242)) {
      return or__3548__auto____7242
    }else {
      var or__3548__auto____7244 = function() {
        var ps__7243 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7243) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7243), y, prefer_table))) {
            }else {
            }
            var G__7246 = cljs.core.rest.call(null, ps__7243);
            ps__7243 = G__7246;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7244)) {
        return or__3548__auto____7244
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7247 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7247)) {
    return or__3548__auto____7247
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7256 = cljs.core.reduce.call(null, function(be, p__7248) {
    var vec__7249__7250 = p__7248;
    var k__7251 = cljs.core.nth.call(null, vec__7249__7250, 0, null);
    var ___7252 = cljs.core.nth.call(null, vec__7249__7250, 1, null);
    var e__7253 = vec__7249__7250;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7251)) {
      var be2__7255 = cljs.core.truth_(function() {
        var or__3548__auto____7254 = be == null;
        if(or__3548__auto____7254) {
          return or__3548__auto____7254
        }else {
          return cljs.core.dominates.call(null, k__7251, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7253 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7255), k__7251, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7251), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7255)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7255
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7256)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7256));
      return cljs.core.second.call(null, best_entry__7256)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7257 = mf;
    if(and__3546__auto____7257) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7257
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7258 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7258) {
        return or__3548__auto____7258
      }else {
        var or__3548__auto____7259 = cljs.core._reset["_"];
        if(or__3548__auto____7259) {
          return or__3548__auto____7259
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7260 = mf;
    if(and__3546__auto____7260) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7260
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7261 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7261) {
        return or__3548__auto____7261
      }else {
        var or__3548__auto____7262 = cljs.core._add_method["_"];
        if(or__3548__auto____7262) {
          return or__3548__auto____7262
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7263 = mf;
    if(and__3546__auto____7263) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7263
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7264 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7264) {
        return or__3548__auto____7264
      }else {
        var or__3548__auto____7265 = cljs.core._remove_method["_"];
        if(or__3548__auto____7265) {
          return or__3548__auto____7265
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7266 = mf;
    if(and__3546__auto____7266) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7266
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7267 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7267) {
        return or__3548__auto____7267
      }else {
        var or__3548__auto____7268 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7268) {
          return or__3548__auto____7268
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7269 = mf;
    if(and__3546__auto____7269) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7269
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7270 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7270) {
        return or__3548__auto____7270
      }else {
        var or__3548__auto____7271 = cljs.core._get_method["_"];
        if(or__3548__auto____7271) {
          return or__3548__auto____7271
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7272 = mf;
    if(and__3546__auto____7272) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7272
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7273 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7273) {
        return or__3548__auto____7273
      }else {
        var or__3548__auto____7274 = cljs.core._methods["_"];
        if(or__3548__auto____7274) {
          return or__3548__auto____7274
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7275 = mf;
    if(and__3546__auto____7275) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7275
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7276 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7276) {
        return or__3548__auto____7276
      }else {
        var or__3548__auto____7277 = cljs.core._prefers["_"];
        if(or__3548__auto____7277) {
          return or__3548__auto____7277
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7278 = mf;
    if(and__3546__auto____7278) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7278
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7279 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7279) {
        return or__3548__auto____7279
      }else {
        var or__3548__auto____7280 = cljs.core._dispatch["_"];
        if(or__3548__auto____7280) {
          return or__3548__auto____7280
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7281 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7282 = cljs.core._get_method.call(null, mf, dispatch_val__7281);
  if(cljs.core.truth_(target_fn__7282)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7281)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7282, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7283 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7284 = this;
  cljs.core.swap_BANG_.call(null, this__7284.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7284.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7284.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7284.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7285 = this;
  cljs.core.swap_BANG_.call(null, this__7285.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7285.method_cache, this__7285.method_table, this__7285.cached_hierarchy, this__7285.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7286 = this;
  cljs.core.swap_BANG_.call(null, this__7286.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7286.method_cache, this__7286.method_table, this__7286.cached_hierarchy, this__7286.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7287 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7287.cached_hierarchy), cljs.core.deref.call(null, this__7287.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7287.method_cache, this__7287.method_table, this__7287.cached_hierarchy, this__7287.hierarchy)
  }
  var temp__3695__auto____7288 = cljs.core.deref.call(null, this__7287.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7288)) {
    var target_fn__7289 = temp__3695__auto____7288;
    return target_fn__7289
  }else {
    var temp__3695__auto____7290 = cljs.core.find_and_cache_best_method.call(null, this__7287.name, dispatch_val, this__7287.hierarchy, this__7287.method_table, this__7287.prefer_table, this__7287.method_cache, this__7287.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7290)) {
      var target_fn__7291 = temp__3695__auto____7290;
      return target_fn__7291
    }else {
      return cljs.core.deref.call(null, this__7287.method_table).call(null, this__7287.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7292 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7292.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7292.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7292.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7292.method_cache, this__7292.method_table, this__7292.cached_hierarchy, this__7292.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7293 = this;
  return cljs.core.deref.call(null, this__7293.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7294 = this;
  return cljs.core.deref.call(null, this__7294.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7295 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7295.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7296__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7296 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7296__delegate.call(this, _, args)
  };
  G__7296.cljs$lang$maxFixedArity = 1;
  G__7296.cljs$lang$applyTo = function(arglist__7297) {
    var _ = cljs.core.first(arglist__7297);
    var args = cljs.core.rest(arglist__7297);
    return G__7296__delegate(_, args)
  };
  G__7296.cljs$lang$arity$variadic = G__7296__delegate;
  return G__7296
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7459 = reader;
    if(and__3546__auto____7459) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7459
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7460 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7460) {
        return or__3548__auto____7460
      }else {
        var or__3548__auto____7461 = cljs.reader.read_char["_"];
        if(or__3548__auto____7461) {
          return or__3548__auto____7461
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7462 = reader;
    if(and__3546__auto____7462) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7462
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7463 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7463) {
        return or__3548__auto____7463
      }else {
        var or__3548__auto____7464 = cljs.reader.unread["_"];
        if(or__3548__auto____7464) {
          return or__3548__auto____7464
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7465 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7465.buffer_atom))) {
    var idx__7466 = cljs.core.deref.call(null, this__7465.index_atom);
    cljs.core.swap_BANG_.call(null, this__7465.index_atom, cljs.core.inc);
    return this__7465.s[idx__7466]
  }else {
    var buf__7467 = cljs.core.deref.call(null, this__7465.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7465.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7467)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7468 = this;
  return cljs.core.swap_BANG_.call(null, this__7468.buffer_atom, function(p1__7458_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7458_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7469 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7469)) {
    return or__3548__auto____7469
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7470 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7470) {
    return or__3548__auto____7470
  }else {
    var and__3546__auto____7472 = function() {
      var or__3548__auto____7471 = "+" === initch;
      if(or__3548__auto____7471) {
        return or__3548__auto____7471
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7472)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7473 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7473);
        return next_ch__7473
      }())
    }else {
      return and__3546__auto____7472
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7474) {
    var rdr = cljs.core.first(arglist__7474);
    var msg = cljs.core.rest(arglist__7474);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7475 = ch != "#";
  if(and__3546__auto____7475) {
    var and__3546__auto____7476 = ch != "'";
    if(and__3546__auto____7476) {
      var and__3546__auto____7477 = ch != ":";
      if(and__3546__auto____7477) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7477
      }
    }else {
      return and__3546__auto____7476
    }
  }else {
    return and__3546__auto____7475
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7478 = new goog.string.StringBuffer(initch);
  var ch__7479 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7480 = ch__7479 == null;
      if(or__3548__auto____7480) {
        return or__3548__auto____7480
      }else {
        var or__3548__auto____7481 = cljs.reader.whitespace_QMARK_.call(null, ch__7479);
        if(or__3548__auto____7481) {
          return or__3548__auto____7481
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7479)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7479);
      return sb__7478.toString()
    }else {
      var G__7482 = function() {
        sb__7478.append(ch__7479);
        return sb__7478
      }();
      var G__7483 = cljs.reader.read_char.call(null, rdr);
      sb__7478 = G__7482;
      ch__7479 = G__7483;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7484 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7485 = ch__7484 === "n";
      if(or__3548__auto____7485) {
        return or__3548__auto____7485
      }else {
        var or__3548__auto____7486 = ch__7484 === "r";
        if(or__3548__auto____7486) {
          return or__3548__auto____7486
        }else {
          return ch__7484 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7487 = re.exec(s);
  if(matches__7487 != null) {
    if(matches__7487.length === 1) {
      return matches__7487[0]
    }else {
      return matches__7487
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7488 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7489 = groups__7488[2];
  if(!function() {
    var or__3548__auto____7490 = group3__7489 == null;
    if(or__3548__auto____7490) {
      return or__3548__auto____7490
    }else {
      return group3__7489.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7491 = "-" === groups__7488[1] ? -1 : 1;
    var a__7492 = cljs.core.truth_(groups__7488[3]) ? [groups__7488[3], 10] : cljs.core.truth_(groups__7488[4]) ? [groups__7488[4], 16] : cljs.core.truth_(groups__7488[5]) ? [groups__7488[5], 8] : cljs.core.truth_(groups__7488[7]) ? [groups__7488[7], parseInt(groups__7488[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7493 = a__7492[0];
    var radix__7494 = a__7492[1];
    if(n__7493 == null) {
      return null
    }else {
      return negate__7491 * parseInt(n__7493, radix__7494)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7495 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7496 = groups__7495[1];
  var denominator__7497 = groups__7495[2];
  return parseInt(numinator__7496) / parseInt(denominator__7497)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7498 = re.exec(s);
  if(function() {
    var and__3546__auto____7499 = matches__7498 != null;
    if(and__3546__auto____7499) {
      return matches__7498[0] === s
    }else {
      return and__3546__auto____7499
    }
  }()) {
    if(matches__7498.length === 1) {
      return matches__7498[0]
    }else {
      return matches__7498
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7500 = cljs.reader.read_char.call(null, reader);
  var mapresult__7501 = cljs.reader.escape_char_map.call(null, ch__7500);
  if(cljs.core.truth_(mapresult__7501)) {
    return mapresult__7501
  }else {
    if(function() {
      var or__3548__auto____7502 = "u" === ch__7500;
      if(or__3548__auto____7502) {
        return or__3548__auto____7502
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7500)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7500)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7500)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7503 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7503))) {
      var G__7504 = cljs.reader.read_char.call(null, rdr);
      ch__7503 = G__7504;
      continue
    }else {
      return ch__7503
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7505 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7506 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7506)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7506) {
      return cljs.core.persistent_BANG_.call(null, a__7505)
    }else {
      var temp__3695__auto____7507 = cljs.reader.macros.call(null, ch__7506);
      if(cljs.core.truth_(temp__3695__auto____7507)) {
        var macrofn__7508 = temp__3695__auto____7507;
        var mret__7509 = macrofn__7508.call(null, rdr, ch__7506);
        var G__7511 = mret__7509 === rdr ? a__7505 : cljs.core.conj_BANG_.call(null, a__7505, mret__7509);
        a__7505 = G__7511;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7506);
        var o__7510 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7512 = o__7510 === rdr ? a__7505 : cljs.core.conj_BANG_.call(null, a__7505, o__7510);
        a__7505 = G__7512;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7513 = cljs.reader.read_char.call(null, rdr);
  var dm__7514 = cljs.reader.dispatch_macros.call(null, ch__7513);
  if(cljs.core.truth_(dm__7514)) {
    return dm__7514.call(null, rdr, _)
  }else {
    var temp__3695__auto____7515 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7513);
    if(cljs.core.truth_(temp__3695__auto____7515)) {
      var obj__7516 = temp__3695__auto____7515;
      return obj__7516
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7513)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7517 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7517))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7517)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7518 = new goog.string.StringBuffer(initch);
  var ch__7519 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7520 = ch__7519 == null;
      if(or__3548__auto____7520) {
        return or__3548__auto____7520
      }else {
        var or__3548__auto____7521 = cljs.reader.whitespace_QMARK_.call(null, ch__7519);
        if(or__3548__auto____7521) {
          return or__3548__auto____7521
        }else {
          return cljs.reader.macros.call(null, ch__7519)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7519);
      var s__7522 = buffer__7518.toString();
      var or__3548__auto____7523 = cljs.reader.match_number.call(null, s__7522);
      if(cljs.core.truth_(or__3548__auto____7523)) {
        return or__3548__auto____7523
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7522, "]")
      }
    }else {
      var G__7524 = function() {
        buffer__7518.append(ch__7519);
        return buffer__7518
      }();
      var G__7525 = cljs.reader.read_char.call(null, reader);
      buffer__7518 = G__7524;
      ch__7519 = G__7525;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7526 = new goog.string.StringBuffer;
  var ch__7527 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7527 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7527) {
        var G__7528 = function() {
          buffer__7526.append(cljs.reader.escape_char.call(null, buffer__7526, reader));
          return buffer__7526
        }();
        var G__7529 = cljs.reader.read_char.call(null, reader);
        buffer__7526 = G__7528;
        ch__7527 = G__7529;
        continue
      }else {
        if('"' === ch__7527) {
          return buffer__7526.toString()
        }else {
          if("\ufdd0'default") {
            var G__7530 = function() {
              buffer__7526.append(ch__7527);
              return buffer__7526
            }();
            var G__7531 = cljs.reader.read_char.call(null, reader);
            buffer__7526 = G__7530;
            ch__7527 = G__7531;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7532 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7532, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7532, 0, token__7532.indexOf("/")), cljs.core.subs.call(null, token__7532, token__7532.indexOf("/") + 1, token__7532.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7532, cljs.core.symbol.call(null, token__7532))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7533 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7534 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7533);
  var token__7535 = a__7534[0];
  var ns__7536 = a__7534[1];
  var name__7537 = a__7534[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7539 = function() {
      var and__3546__auto____7538 = !(void 0 === ns__7536);
      if(and__3546__auto____7538) {
        return ns__7536.substring(ns__7536.length - 2, ns__7536.length) === ":/"
      }else {
        return and__3546__auto____7538
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7539)) {
      return or__3548__auto____7539
    }else {
      var or__3548__auto____7540 = name__7537[name__7537.length - 1] === ":";
      if(or__3548__auto____7540) {
        return or__3548__auto____7540
      }else {
        return!(token__7535.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7535)
  }else {
    if(cljs.core.truth_(ns__7536)) {
      return cljs.core.keyword.call(null, ns__7536.substring(0, ns__7536.indexOf("/")), name__7537)
    }else {
      return cljs.core.keyword.call(null, token__7535)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7541 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7541)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7542 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7543__7544 = o__7542;
    if(G__7543__7544 != null) {
      if(function() {
        var or__3548__auto____7545 = G__7543__7544.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7545) {
          return or__3548__auto____7545
        }else {
          return G__7543__7544.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7543__7544.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7543__7544)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7543__7544)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7542, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7542), m__7541))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7546 = cljs.reader.read_char.call(null, reader);
    if(ch__7546 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7546)) {
        var G__7549 = reader;
        var G__7550 = eof_is_error;
        var G__7551 = sentinel;
        var G__7552 = is_recursive;
        reader = G__7549;
        eof_is_error = G__7550;
        sentinel = G__7551;
        is_recursive = G__7552;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7546)) {
          var G__7553 = cljs.reader.read_comment.call(null, reader, ch__7546);
          var G__7554 = eof_is_error;
          var G__7555 = sentinel;
          var G__7556 = is_recursive;
          reader = G__7553;
          eof_is_error = G__7554;
          sentinel = G__7555;
          is_recursive = G__7556;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7547 = cljs.reader.macros.call(null, ch__7546);
            var res__7548 = cljs.core.truth_(f__7547) ? f__7547.call(null, reader, ch__7546) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7546) ? cljs.reader.read_number.call(null, reader, ch__7546) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7546) : null;
            if(res__7548 === reader) {
              var G__7557 = reader;
              var G__7558 = eof_is_error;
              var G__7559 = sentinel;
              var G__7560 = is_recursive;
              reader = G__7557;
              eof_is_error = G__7558;
              sentinel = G__7559;
              is_recursive = G__7560;
              continue
            }else {
              return res__7548
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7561 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7561, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7562 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7563 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7564 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7562));
  if(cljs.core.truth_(pfn__7564)) {
    return pfn__7564.call(null, form__7563)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7562), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7565 = cljs.core.name.call(null, tag);
  var old_parser__7566 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7565);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7565, f);
  return old_parser__7566
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7435 = s;
      var limit__7436 = limit;
      var parts__7437 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7436, 1)) {
          return cljs.core.conj.call(null, parts__7437, s__7435)
        }else {
          var temp__3695__auto____7438 = cljs.core.re_find.call(null, re, s__7435);
          if(cljs.core.truth_(temp__3695__auto____7438)) {
            var m__7439 = temp__3695__auto____7438;
            var index__7440 = s__7435.indexOf(m__7439);
            var G__7441 = s__7435.substring(index__7440 + cljs.core.count.call(null, m__7439));
            var G__7442 = limit__7436 - 1;
            var G__7443 = cljs.core.conj.call(null, parts__7437, s__7435.substring(0, index__7440));
            s__7435 = G__7441;
            limit__7436 = G__7442;
            parts__7437 = G__7443;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7437, s__7435)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7444 = s.length;
  while(true) {
    if(index__7444 === 0) {
      return""
    }else {
      var ch__7445 = cljs.core.get.call(null, s, index__7444 - 1);
      if(function() {
        var or__3548__auto____7446 = cljs.core._EQ_.call(null, ch__7445, "\n");
        if(or__3548__auto____7446) {
          return or__3548__auto____7446
        }else {
          return cljs.core._EQ_.call(null, ch__7445, "\r")
        }
      }()) {
        var G__7447 = index__7444 - 1;
        index__7444 = G__7447;
        continue
      }else {
        return s.substring(0, index__7444)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7448 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7449 = cljs.core.not.call(null, s__7448);
    if(or__3548__auto____7449) {
      return or__3548__auto____7449
    }else {
      var or__3548__auto____7450 = cljs.core._EQ_.call(null, "", s__7448);
      if(or__3548__auto____7450) {
        return or__3548__auto____7450
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7448)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7451 = new goog.string.StringBuffer;
  var length__7452 = s.length;
  var index__7453 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7452, index__7453)) {
      return buffer__7451.toString()
    }else {
      var ch__7454 = s.charAt(index__7453);
      var temp__3695__auto____7455 = cljs.core.get.call(null, cmap, ch__7454);
      if(cljs.core.truth_(temp__3695__auto____7455)) {
        var replacement__7456 = temp__3695__auto____7455;
        buffer__7451.append([cljs.core.str(replacement__7456)].join(""))
      }else {
        buffer__7451.append(ch__7454)
      }
      var G__7457 = index__7453 + 1;
      index__7453 = G__7457;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7406 = {};
  var G__7407__7408 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7407__7408)) {
    var G__7410__7412 = cljs.core.first.call(null, G__7407__7408);
    var vec__7411__7413 = G__7410__7412;
    var k__7414 = cljs.core.nth.call(null, vec__7411__7413, 0, null);
    var v__7415 = cljs.core.nth.call(null, vec__7411__7413, 1, null);
    var G__7407__7416 = G__7407__7408;
    var G__7410__7417 = G__7410__7412;
    var G__7407__7418 = G__7407__7416;
    while(true) {
      var vec__7419__7420 = G__7410__7417;
      var k__7421 = cljs.core.nth.call(null, vec__7419__7420, 0, null);
      var v__7422 = cljs.core.nth.call(null, vec__7419__7420, 1, null);
      var G__7407__7423 = G__7407__7418;
      out__7406[cljs.core.name.call(null, k__7421)] = v__7422;
      var temp__3698__auto____7424 = cljs.core.next.call(null, G__7407__7423);
      if(cljs.core.truth_(temp__3698__auto____7424)) {
        var G__7407__7425 = temp__3698__auto____7424;
        var G__7426 = cljs.core.first.call(null, G__7407__7425);
        var G__7427 = G__7407__7425;
        G__7410__7417 = G__7426;
        G__7407__7418 = G__7427;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7406
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7428 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7428)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7429) {
    var v = cljs.core.first(arglist__7429);
    var text = cljs.core.rest(arglist__7429);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7430) {
          var vec__7431__7432 = p__7430;
          var k__7433 = cljs.core.nth.call(null, vec__7431__7432, 0, null);
          var v__7434 = cljs.core.nth.call(null, vec__7431__7432, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7433), clj__GT_js.call(null, v__7434))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7298 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7298)) {
        var cm__7299 = temp__3695__auto____7298;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7299), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7300) {
    var vec__7301__7302 = p__7300;
    var context__7303 = cljs.core.nth.call(null, vec__7301__7302, 0, null);
    if(cljs.core.not.call(null, context__7303)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7303)
    }
  };
  var $ = function(sel, var_args) {
    var p__7300 = null;
    if(goog.isDef(var_args)) {
      p__7300 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7300)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7304) {
    var sel = cljs.core.first(arglist__7304);
    var p__7300 = cljs.core.rest(arglist__7304);
    return $__delegate(sel, p__7300)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7305 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7305)) {
    return or__3548__auto____7305
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7306 = null;
  var G__7306__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7306__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7306 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7306__2.call(this, _, k);
      case 3:
        return G__7306__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7306
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7307) {
    var vec__7308__7309 = p__7307;
    var v__7310 = cljs.core.nth.call(null, vec__7308__7309, 0, null);
    var a__7311 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7310)) {
      return $elem.attr(a__7311)
    }else {
      return $elem.attr(a__7311, v__7310)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7307 = null;
    if(goog.isDef(var_args)) {
      p__7307 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7307)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7312) {
    var $elem = cljs.core.first(arglist__7312);
    var a = cljs.core.first(cljs.core.next(arglist__7312));
    var p__7307 = cljs.core.rest(cljs.core.next(arglist__7312));
    return attr__delegate($elem, a, p__7307)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7313) {
    var vec__7314__7315 = p__7313;
    var v__7316 = cljs.core.nth.call(null, vec__7314__7315, 0, null);
    var k__7317 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7316)) {
      return $elem.data(k__7317)
    }else {
      return $elem.data(k__7317, v__7316)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7313 = null;
    if(goog.isDef(var_args)) {
      p__7313 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7313)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7318) {
    var $elem = cljs.core.first(arglist__7318);
    var k = cljs.core.first(cljs.core.next(arglist__7318));
    var p__7313 = cljs.core.rest(cljs.core.next(arglist__7318));
    return data__delegate($elem, k, p__7313)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7319 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7319)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7320 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7320)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7321 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7321)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7322 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7322)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7323) {
    var vec__7324__7325 = p__7323;
    var speed__7326 = cljs.core.nth.call(null, vec__7324__7325, 0, null);
    var on_finish__7327 = cljs.core.nth.call(null, vec__7324__7325, 1, null);
    return $elem.hide(speed__7326, on_finish__7327)
  };
  var hide = function($elem, var_args) {
    var p__7323 = null;
    if(goog.isDef(var_args)) {
      p__7323 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7323)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7328) {
    var $elem = cljs.core.first(arglist__7328);
    var p__7323 = cljs.core.rest(arglist__7328);
    return hide__delegate($elem, p__7323)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7329) {
    var vec__7330__7331 = p__7329;
    var speed__7332 = cljs.core.nth.call(null, vec__7330__7331, 0, null);
    var on_finish__7333 = cljs.core.nth.call(null, vec__7330__7331, 1, null);
    return $elem.show(speed__7332, on_finish__7333)
  };
  var show = function($elem, var_args) {
    var p__7329 = null;
    if(goog.isDef(var_args)) {
      p__7329 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7329)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7334) {
    var $elem = cljs.core.first(arglist__7334);
    var p__7329 = cljs.core.rest(arglist__7334);
    return show__delegate($elem, p__7329)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7335) {
    var vec__7336__7337 = p__7335;
    var speed__7338 = cljs.core.nth.call(null, vec__7336__7337, 0, null);
    var on_finish__7339 = cljs.core.nth.call(null, vec__7336__7337, 1, null);
    return $elem.toggle(speed__7338, on_finish__7339)
  };
  var toggle = function($elem, var_args) {
    var p__7335 = null;
    if(goog.isDef(var_args)) {
      p__7335 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7335)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7340) {
    var $elem = cljs.core.first(arglist__7340);
    var p__7335 = cljs.core.rest(arglist__7340);
    return toggle__delegate($elem, p__7335)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7341) {
    var vec__7342__7343 = p__7341;
    var speed__7344 = cljs.core.nth.call(null, vec__7342__7343, 0, null);
    var on_finish__7345 = cljs.core.nth.call(null, vec__7342__7343, 1, null);
    return $elem.fadeOut(speed__7344, on_finish__7345)
  };
  var fade_out = function($elem, var_args) {
    var p__7341 = null;
    if(goog.isDef(var_args)) {
      p__7341 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7341)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7346) {
    var $elem = cljs.core.first(arglist__7346);
    var p__7341 = cljs.core.rest(arglist__7346);
    return fade_out__delegate($elem, p__7341)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7347) {
    var vec__7348__7349 = p__7347;
    var speed__7350 = cljs.core.nth.call(null, vec__7348__7349, 0, null);
    var on_finish__7351 = cljs.core.nth.call(null, vec__7348__7349, 1, null);
    return $elem.fadeIn(speed__7350, on_finish__7351)
  };
  var fade_in = function($elem, var_args) {
    var p__7347 = null;
    if(goog.isDef(var_args)) {
      p__7347 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7347)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7352) {
    var $elem = cljs.core.first(arglist__7352);
    var p__7347 = cljs.core.rest(arglist__7352);
    return fade_in__delegate($elem, p__7347)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7353) {
    var vec__7354__7355 = p__7353;
    var speed__7356 = cljs.core.nth.call(null, vec__7354__7355, 0, null);
    var on_finish__7357 = cljs.core.nth.call(null, vec__7354__7355, 1, null);
    return $elem.slideUp(speed__7356, on_finish__7357)
  };
  var slide_up = function($elem, var_args) {
    var p__7353 = null;
    if(goog.isDef(var_args)) {
      p__7353 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7353)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7358) {
    var $elem = cljs.core.first(arglist__7358);
    var p__7353 = cljs.core.rest(arglist__7358);
    return slide_up__delegate($elem, p__7353)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7359) {
    var vec__7360__7361 = p__7359;
    var speed__7362 = cljs.core.nth.call(null, vec__7360__7361, 0, null);
    var on_finish__7363 = cljs.core.nth.call(null, vec__7360__7361, 1, null);
    return $elem.slideDown(speed__7362, on_finish__7363)
  };
  var slide_down = function($elem, var_args) {
    var p__7359 = null;
    if(goog.isDef(var_args)) {
      p__7359 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7359)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7364) {
    var $elem = cljs.core.first(arglist__7364);
    var p__7359 = cljs.core.rest(arglist__7364);
    return slide_down__delegate($elem, p__7359)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7365) {
    var vec__7366__7367 = p__7365;
    var context__7368 = cljs.core.nth.call(null, vec__7366__7367, 0, null);
    return $elem.closest(selector, context__7368)
  };
  var closest = function($elem, selector, var_args) {
    var p__7365 = null;
    if(goog.isDef(var_args)) {
      p__7365 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7365)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7369) {
    var $elem = cljs.core.first(arglist__7369);
    var selector = cljs.core.first(cljs.core.next(arglist__7369));
    var p__7365 = cljs.core.rest(cljs.core.next(arglist__7369));
    return closest__delegate($elem, selector, p__7365)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7370) {
    var vec__7371__7372 = p__7370;
    var v__7373 = cljs.core.nth.call(null, vec__7371__7372, 0, null);
    if(cljs.core.truth_(v__7373)) {
      return $elem.val(v__7373)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7370 = null;
    if(goog.isDef(var_args)) {
      p__7370 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7370)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7374) {
    var $elem = cljs.core.first(arglist__7374);
    var p__7370 = cljs.core.rest(arglist__7374);
    return val__delegate($elem, p__7370)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7375, content, callback) {
  var vec__7376__7377 = p__7375;
  var method__7378 = cljs.core.nth.call(null, vec__7376__7377, 0, null);
  var uri__7379 = cljs.core.nth.call(null, vec__7376__7377, 1, null);
  var params__7380 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7378)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7379, params__7380)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7381) {
    var vec__7382__7383 = p__7381;
    var func__7384 = cljs.core.nth.call(null, vec__7382__7383, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7384)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7381 = null;
    if(goog.isDef(var_args)) {
      p__7381 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7381)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7385) {
    var $elem = cljs.core.first(arglist__7385);
    var ev = cljs.core.first(cljs.core.next(arglist__7385));
    var p__7381 = cljs.core.rest(cljs.core.next(arglist__7385));
    return unbind__delegate($elem, ev, p__7381)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7386) {
    var vec__7387__7388 = p__7386;
    var sel__7389 = cljs.core.nth.call(null, vec__7387__7388, 0, null);
    var data__7390 = cljs.core.nth.call(null, vec__7387__7388, 1, null);
    var handler__7391 = cljs.core.nth.call(null, vec__7387__7388, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7389), data__7390, handler__7391)
  };
  var on = function($elem, events, var_args) {
    var p__7386 = null;
    if(goog.isDef(var_args)) {
      p__7386 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7386)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7392) {
    var $elem = cljs.core.first(arglist__7392);
    var events = cljs.core.first(cljs.core.next(arglist__7392));
    var p__7386 = cljs.core.rest(cljs.core.next(arglist__7392));
    return on__delegate($elem, events, p__7386)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7393) {
    var vec__7394__7395 = p__7393;
    var sel__7396 = cljs.core.nth.call(null, vec__7394__7395, 0, null);
    var data__7397 = cljs.core.nth.call(null, vec__7394__7395, 1, null);
    var handler__7398 = cljs.core.nth.call(null, vec__7394__7395, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7396), data__7397, handler__7398)
  };
  var one = function($elem, events, var_args) {
    var p__7393 = null;
    if(goog.isDef(var_args)) {
      p__7393 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7393)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7399) {
    var $elem = cljs.core.first(arglist__7399);
    var events = cljs.core.first(cljs.core.next(arglist__7399));
    var p__7393 = cljs.core.rest(cljs.core.next(arglist__7399));
    return one__delegate($elem, events, p__7393)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7400) {
    var vec__7401__7402 = p__7400;
    var sel__7403 = cljs.core.nth.call(null, vec__7401__7402, 0, null);
    var handler__7404 = cljs.core.nth.call(null, vec__7401__7402, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7403), handler__7404)
  };
  var off = function($elem, events, var_args) {
    var p__7400 = null;
    if(goog.isDef(var_args)) {
      p__7400 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7400)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7405) {
    var $elem = cljs.core.first(arglist__7405);
    var events = cljs.core.first(cljs.core.next(arglist__7405));
    var p__7400 = cljs.core.rest(cljs.core.next(arglist__7405));
    return off__delegate($elem, events, p__7400)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.dynamic_bindings = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.binding_key = cljs.core.atom.call(null, 0);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4816 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4815_SHARP_) {
    return out__4816[cljs.core.name.call(null, cljs.core.first.call(null, p1__4815_SHARP_))] = cljs.core.second.call(null, p1__4815_SHARP_)
  }, cljmap));
  return out__4816
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4817 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4817) {
    return or__3548__auto____4817
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bind_elem = function bind_elem(elem, bindingname, f) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname).call(null, elem, f.call(null))
    }
  }else {
    return function() {
      return elem[bindingname].call(elem, f.call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4818 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4819 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  return cljsbinding.bind_elem.call(null, elem, bindingname__4818, function() {
    return cljsbinding.valuefn.call(null, elem, fname__4819, ctx, bindingname__4818)
  })
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_jq_elem = function bind_jq_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4820__4821 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4820__4821)) {
    var data__4822 = cljs.core.first.call(null, G__4820__4821);
    var G__4820__4823 = G__4820__4821;
    while(true) {
      cljsbinding.bind_jq_elem.call(null, elem, data__4822.split(":"), ctx);
      var temp__3698__auto____4824 = cljs.core.next.call(null, G__4820__4823);
      if(cljs.core.truth_(temp__3698__auto____4824)) {
        var G__4820__4825 = temp__3698__auto____4824;
        var G__4826 = cljs.core.first.call(null, G__4820__4825);
        var G__4827 = G__4820__4825;
        data__4822 = G__4826;
        G__4820__4823 = G__4827;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem, atm) {
  var aval__4829 = cljs.core.deref.call(null, atm);
  if(cljs.core.map_QMARK_.call(null, aval__4829)) {
    return aval__4829.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4829
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4828_SHARP_) {
      return cljs.core.assoc.call(null, p1__4828_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.is(":checked"));
    return false
  })
};
cljsbinding.bind_text_atom = function bind_text_atom(elem, atm) {
  return cljsbinding.run_bind_fn.call(null, function() {
    return elem["text"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  })
};
cljsbinding.bind_elem_to_atom = function bind_elem_to_atom(elem, atm) {
  if(cljs.core.truth_(function() {
    var or__3548__auto____4830 = elem.is("input");
    if(cljs.core.truth_(or__3548__auto____4830)) {
      return or__3548__auto____4830
    }else {
      return elem.is("textarea")
    }
  }())) {
    if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
      return cljsbinding.bind_checkbox_atom.call(null, elem, atm)
    }else {
      return cljsbinding.bind_input_atom.call(null, elem, atm)
    }
  }else {
    return cljsbinding.bind_text_atom.call(null, elem, atm)
  }
};
cljsbinding.bindatom = function bindatom(elem) {
  var atm__4831 = eval(jayq.core.attr.call(null, elem, "bindatom"));
  return cljsbinding.bind_elem_to_atom.call(null, elem, atm__4831)
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem, bindfn) {
  jayq.core.append.call(null, parent, elem);
  return bindfn.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template, bindfn) {
  jayq.core.remove.call(null, parent.children());
  var G__4832__4833 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4832__4833)) {
    var item__4834 = cljs.core.first.call(null, G__4832__4833);
    var G__4832__4835 = G__4832__4833;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4834, template.clone(), bindfn);
      var temp__3698__auto____4836 = cljs.core.next.call(null, G__4832__4835);
      if(cljs.core.truth_(temp__3698__auto____4836)) {
        var G__4832__4837 = temp__3698__auto____4836;
        var G__4838 = cljs.core.first.call(null, G__4832__4837);
        var G__4839 = G__4832__4837;
        item__4834 = G__4838;
        G__4832__4835 = G__4839;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent, bindfn) {
  var atom__4841 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4841), elparent, elem, bindfn);
  return cljs.core.add_watch.call(null, atom__4841, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem, bindfn)
  })
};
cljsbinding.dobind = function dobind(parent, ctx) {
  var seqs__4842 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4843 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__4840_SHARP_) {
    return jayq.core.$.call(null, p1__4840_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4844__4845 = cljs.core.seq.call(null, seqs__4842);
  if(cljs.core.truth_(G__4844__4845)) {
    var elem__4846 = cljs.core.first.call(null, G__4844__4845);
    var G__4844__4847 = G__4844__4845;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4846));
      var temp__3698__auto____4848 = cljs.core.next.call(null, G__4844__4847);
      if(cljs.core.truth_(temp__3698__auto____4848)) {
        var G__4844__4849 = temp__3698__auto____4848;
        var G__4887 = cljs.core.first.call(null, G__4844__4849);
        var G__4888 = G__4844__4849;
        elem__4846 = G__4887;
        G__4844__4847 = G__4888;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4850__4851 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4850__4851)) {
    var elem__4852 = cljs.core.first.call(null, G__4850__4851);
    var G__4850__4853 = G__4850__4851;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4852), ctx);
      var temp__3698__auto____4854 = cljs.core.next.call(null, G__4850__4853);
      if(cljs.core.truth_(temp__3698__auto____4854)) {
        var G__4850__4855 = temp__3698__auto____4854;
        var G__4889 = cljs.core.first.call(null, G__4850__4855);
        var G__4890 = G__4850__4855;
        elem__4852 = G__4889;
        G__4850__4853 = G__4890;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4856__4857 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4856__4857)) {
    var elem__4858 = cljs.core.first.call(null, G__4856__4857);
    var G__4856__4859 = G__4856__4857;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4858), ctx);
      var temp__3698__auto____4860 = cljs.core.next.call(null, G__4856__4859);
      if(cljs.core.truth_(temp__3698__auto____4860)) {
        var G__4856__4861 = temp__3698__auto____4860;
        var G__4891 = cljs.core.first.call(null, G__4856__4861);
        var G__4892 = G__4856__4861;
        elem__4858 = G__4891;
        G__4856__4859 = G__4892;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4862__4863 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4862__4863)) {
    var elem__4864 = cljs.core.first.call(null, G__4862__4863);
    var G__4862__4865 = G__4862__4863;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4864));
      var temp__3698__auto____4866 = cljs.core.next.call(null, G__4862__4865);
      if(cljs.core.truth_(temp__3698__auto____4866)) {
        var G__4862__4867 = temp__3698__auto____4866;
        var G__4893 = cljs.core.first.call(null, G__4862__4867);
        var G__4894 = G__4862__4867;
        elem__4864 = G__4893;
        G__4862__4865 = G__4894;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4868__4869 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4842, seqparents__4843));
  if(cljs.core.truth_(G__4868__4869)) {
    var G__4871__4873 = cljs.core.first.call(null, G__4868__4869);
    var vec__4872__4874 = G__4871__4873;
    var elem__4875 = cljs.core.nth.call(null, vec__4872__4874, 0, null);
    var parent__4876 = cljs.core.nth.call(null, vec__4872__4874, 1, null);
    var G__4868__4877 = G__4868__4869;
    var G__4871__4878 = G__4871__4873;
    var G__4868__4879 = G__4868__4877;
    while(true) {
      var vec__4880__4881 = G__4871__4878;
      var elem__4882 = cljs.core.nth.call(null, vec__4880__4881, 0, null);
      var parent__4883 = cljs.core.nth.call(null, vec__4880__4881, 1, null);
      var G__4868__4884 = G__4868__4879;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4882), parent__4883, dobind);
      var temp__3698__auto____4885 = cljs.core.next.call(null, G__4868__4884);
      if(cljs.core.truth_(temp__3698__auto____4885)) {
        var G__4868__4886 = temp__3698__auto____4885;
        var G__4895 = cljs.core.first.call(null, G__4868__4886);
        var G__4896 = G__4868__4886;
        G__4871__4878 = G__4895;
        G__4868__4879 = G__4896;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindall = function() {
  var bindall = null;
  var bindall__1 = function(elem) {
    return cljsbinding.dobind.call(null, elem, null)
  };
  var bindall__2 = function(elem, ctx) {
    return cljsbinding.dobind.call(null, elem, ctx)
  };
  bindall = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindall__1.call(this, elem);
      case 2:
        return bindall__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindall.cljs$lang$arity$1 = bindall__1;
  bindall.cljs$lang$arity$2 = bindall__2;
  return bindall
}();
goog.exportSymbol("cljsbinding.bindall", cljsbinding.bindall);
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4897_SHARP_, p2__4898_SHARP_) {
      var or__3548__auto____4900 = p1__4897_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4900)) {
        return or__3548__auto____4900
      }else {
        return p2__4898_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4899_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4899_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.add_binding = function add_binding(atom, m) {
  return cljs.core.assoc.call(null, m, atom, cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), m.call(null, atom)))
};
cljsbinding.run_bindings = function run_bindings(key, a, old_val, new_val) {
  var G__4901__4902 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
  if(cljs.core.truth_(G__4901__4902)) {
    var f__4903 = cljs.core.first.call(null, G__4901__4902);
    var G__4901__4904 = G__4901__4902;
    while(true) {
      f__4903.call(null);
      var temp__3698__auto____4905 = cljs.core.next.call(null, G__4901__4904);
      if(cljs.core.truth_(temp__3698__auto____4905)) {
        var G__4901__4906 = temp__3698__auto____4905;
        var G__4907 = cljs.core.first.call(null, G__4901__4906);
        var G__4908 = G__4901__4906;
        f__4903 = G__4907;
        G__4901__4904 = G__4908;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.next_binding_key = function next_binding_key() {
  return cljs.core.swap_BANG_.call(null, cljsbinding.binding_key, cljs.core.inc)
};
cljsbinding.register_bindingsource = function register_bindingsource(source) {
  var bindingkey__4910 = [cljs.core.str(cljsbinding.next_binding_key.call(null))].join("");
  cljs.core.swap_BANG_.call(null, cljsbinding.dynamic_bindings, function(p1__4909_SHARP_) {
    return cljs.core.assoc.call(null, p1__4909_SHARP_, bindingkey__4910, source)
  });
  return bindingkey__4910
};
cljsbinding.apply_binding = function apply_binding(elem, source) {
  if(cljs.core.map_QMARK_.call(null, source)) {
    var G__4911__4912 = cljs.core.seq.call(null, source);
    if(cljs.core.truth_(G__4911__4912)) {
      var G__4914__4916 = cljs.core.first.call(null, G__4911__4912);
      var vec__4915__4917 = G__4914__4916;
      var bindingname__4918 = cljs.core.nth.call(null, vec__4915__4917, 0, null);
      var f__4919 = cljs.core.nth.call(null, vec__4915__4917, 1, null);
      var G__4911__4920 = G__4911__4912;
      var G__4914__4921 = G__4914__4916;
      var G__4911__4922 = G__4911__4920;
      while(true) {
        var vec__4923__4924 = G__4914__4921;
        var bindingname__4925 = cljs.core.nth.call(null, vec__4923__4924, 0, null);
        var f__4926 = cljs.core.nth.call(null, vec__4923__4924, 1, null);
        var G__4911__4927 = G__4911__4922;
        cljsbinding.run_bind_fn.call(null, cljsbinding.bind_elem.call(null, elem, cljs.core.name.call(null, bindingname__4925), f__4926));
        var temp__3698__auto____4928 = cljs.core.next.call(null, G__4911__4927);
        if(cljs.core.truth_(temp__3698__auto____4928)) {
          var G__4911__4929 = temp__3698__auto____4928;
          var G__4930 = cljs.core.first.call(null, G__4911__4929);
          var G__4931 = G__4911__4929;
          G__4914__4921 = G__4930;
          G__4911__4922 = G__4931;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  }else {
    return cljsbinding.bind_elem_to_atom.call(null, elem, source)
  }
};
cljsbinding.apply_bindingsource = function apply_bindingsource(elem, bindingkey) {
  var G__4932__4933 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.dynamic_bindings).call(null, bindingkey));
  if(cljs.core.truth_(G__4932__4933)) {
    var source__4934 = cljs.core.first.call(null, G__4932__4933);
    var G__4932__4935 = G__4932__4933;
    while(true) {
      cljsbinding.apply_binding.call(null, elem, source__4934);
      var temp__3698__auto____4936 = cljs.core.next.call(null, G__4932__4935);
      if(cljs.core.truth_(temp__3698__auto____4936)) {
        var G__4932__4937 = temp__3698__auto____4936;
        var G__4938 = cljs.core.first.call(null, G__4932__4937);
        var G__4939 = G__4932__4937;
        source__4934 = G__4938;
        G__4932__4935 = G__4939;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, cljs.core.partial.call(null, cljsbinding.add_binding, atom));
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", cljsbinding.run_bindings);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.cljsderef = function cljsderef() {
  return cljs.core._deref
};
goog.exportSymbol("cljsbinding.cljsderef", cljsbinding.cljsderef);
cljsbinding.shouldregister = function shouldregister(drf) {
  return drf.call(null, cljsbinding.BindMonitor)
};
goog.exportSymbol("cljsbinding.shouldregister", cljsbinding.shouldregister);
cljsbinding.boot = function boot() {
  return eval("    \n    var derefName = eval('cljsbinding.cljsderef.toString().match(/return.(.*$)\\\\s/m)[1]')\n    if (derefName[derefName.length-1] == ';')\n      derefName = derefName.substr(0,derefName.length-1)\n    var deref = eval(derefName)\n    eval(derefName +' = function (a) { if (cljsbinding.shouldregister(deref)) { cljsbinding.register(a) };return deref(a); }')\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4940 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4940), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4940)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4940)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4940)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4940))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  var storedValue__4941 = localStorage[name];
  if(cljs.core.not.call(null, storedValue__4941 == null)) {
    return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, storedValue__4941))
  }else {
    return null
  }
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
goog.provide("cljsbinding.crate");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljsbinding");
cljsbinding.crate.re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;
cljsbinding.crate.tag_str = function tag_str(tag) {
  if(cljs.core.keyword_QMARK_.call(null, tag)) {
    return cljs.core.name.call(null, tag)
  }else {
    return[cljs.core.str(tag)].join("")
  }
};
cljsbinding.crate.normalize_element = function normalize_element(p__4793) {
  var vec__4794__4795 = p__4793;
  var tag__4796 = cljs.core.nth.call(null, vec__4794__4795, 0, null);
  var content__4797 = cljs.core.nthnext.call(null, vec__4794__4795, 1);
  if(cljs.core.not.call(null, function() {
    var or__3548__auto____4798 = cljs.core.keyword_QMARK_.call(null, tag__4796);
    if(or__3548__auto____4798) {
      return or__3548__auto____4798
    }else {
      var or__3548__auto____4799 = cljs.core.symbol_QMARK_.call(null, tag__4796);
      if(or__3548__auto____4799) {
        return or__3548__auto____4799
      }else {
        return cljs.core.string_QMARK_.call(null, tag__4796)
      }
    }
  }())) {
    throw Error([cljs.core.str(tag__4796), cljs.core.str(" is not a valid element name.")].join(""));
  }else {
  }
  var vec__4800__4801 = cljs.core.re_matches.call(null, cljsbinding.crate.re_tag, cljsbinding.crate.tag_str.call(null, tag__4796));
  var ___4802 = cljs.core.nth.call(null, vec__4800__4801, 0, null);
  var tag__4803 = cljs.core.nth.call(null, vec__4800__4801, 1, null);
  var id__4804 = cljs.core.nth.call(null, vec__4800__4801, 2, null);
  var class$__4805 = cljs.core.nth.call(null, vec__4800__4801, 3, null);
  var tag_attrs__4806 = cljs.core.ObjMap.fromObject(["\ufdd0'id", "\ufdd0'class"], {"\ufdd0'id":id__4804, "\ufdd0'class":cljs.core.truth_(class$__4805) ? class$__4805.replace(".", " ") : null});
  var map_attrs__4807 = cljs.core.first.call(null, content__4797);
  if(cljs.core.map_QMARK_.call(null, map_attrs__4807)) {
    return cljs.core.PersistentVector.fromArray([tag__4803, cljs.core.merge.call(null, tag_attrs__4806, map_attrs__4807), cljs.core.next.call(null, content__4797)])
  }else {
    return cljs.core.PersistentVector.fromArray([tag__4803, tag_attrs__4806, content__4797])
  }
};
cljsbinding.crate.add_binding = function() {
  var add_binding__delegate = function(elem, bind) {
    var vec__4808__4809 = cljsbinding.crate.normalize_element.call(null, elem);
    var tagname__4810 = cljs.core.nth.call(null, vec__4808__4809, 0, null);
    var attrs__4811 = cljs.core.nth.call(null, vec__4808__4809, 1, null);
    var content__4812 = cljs.core.nth.call(null, vec__4808__4809, 2, null);
    return cljs.core.PersistentVector.fromArray([tagname__4810, cljs.core.assoc.call(null, attrs__4811, "\ufdd0'withbinding", cljsbinding.register_bindingsource.call(null, bind))])
  };
  var add_binding = function(elem, var_args) {
    var bind = null;
    if(goog.isDef(var_args)) {
      bind = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return add_binding__delegate.call(this, elem, bind)
  };
  add_binding.cljs$lang$maxFixedArity = 1;
  add_binding.cljs$lang$applyTo = function(arglist__4813) {
    var elem = cljs.core.first(arglist__4813);
    var bind = cljs.core.rest(arglist__4813);
    return add_binding__delegate(elem, bind)
  };
  add_binding.cljs$lang$arity$variadic = add_binding__delegate;
  return add_binding
}();
cljsbinding.crate.bind_html_elem = function bind_html_elem(elem) {
  var bindingkey__4814 = jayq.core.attr.call(null, elem, "withbinding");
  cljsbinding.apply_bindingsource.call(null, elem, bindingkey__4814);
  return elem.removeAttr("withbinding")
};
