var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4948__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4948 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4948__delegate.call(this, array, i, idxs)
    };
    G__4948.cljs$lang$maxFixedArity = 2;
    G__4948.cljs$lang$applyTo = function(arglist__4949) {
      var array = cljs.core.first(arglist__4949);
      var i = cljs.core.first(cljs.core.next(arglist__4949));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4949));
      return G__4948__delegate(array, i, idxs)
    };
    G__4948.cljs$lang$arity$variadic = G__4948__delegate;
    return G__4948
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4950 = this$;
      if(and__3546__auto____4950) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4950
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4951 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4951) {
          return or__3548__auto____4951
        }else {
          var or__3548__auto____4952 = cljs.core._invoke["_"];
          if(or__3548__auto____4952) {
            return or__3548__auto____4952
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4953 = this$;
      if(and__3546__auto____4953) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4953
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4954 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4954) {
          return or__3548__auto____4954
        }else {
          var or__3548__auto____4955 = cljs.core._invoke["_"];
          if(or__3548__auto____4955) {
            return or__3548__auto____4955
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4956 = this$;
      if(and__3546__auto____4956) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4956
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4957 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4957) {
          return or__3548__auto____4957
        }else {
          var or__3548__auto____4958 = cljs.core._invoke["_"];
          if(or__3548__auto____4958) {
            return or__3548__auto____4958
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4959 = this$;
      if(and__3546__auto____4959) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4959
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4960 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4960) {
          return or__3548__auto____4960
        }else {
          var or__3548__auto____4961 = cljs.core._invoke["_"];
          if(or__3548__auto____4961) {
            return or__3548__auto____4961
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4962 = this$;
      if(and__3546__auto____4962) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4962
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4963 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4963) {
          return or__3548__auto____4963
        }else {
          var or__3548__auto____4964 = cljs.core._invoke["_"];
          if(or__3548__auto____4964) {
            return or__3548__auto____4964
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4965 = this$;
      if(and__3546__auto____4965) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4965
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4966 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4966) {
          return or__3548__auto____4966
        }else {
          var or__3548__auto____4967 = cljs.core._invoke["_"];
          if(or__3548__auto____4967) {
            return or__3548__auto____4967
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4968 = this$;
      if(and__3546__auto____4968) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4968
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4969 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4969) {
          return or__3548__auto____4969
        }else {
          var or__3548__auto____4970 = cljs.core._invoke["_"];
          if(or__3548__auto____4970) {
            return or__3548__auto____4970
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4971 = this$;
      if(and__3546__auto____4971) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4971
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4972 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4972) {
          return or__3548__auto____4972
        }else {
          var or__3548__auto____4973 = cljs.core._invoke["_"];
          if(or__3548__auto____4973) {
            return or__3548__auto____4973
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4974 = this$;
      if(and__3546__auto____4974) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4974
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4975 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4975) {
          return or__3548__auto____4975
        }else {
          var or__3548__auto____4976 = cljs.core._invoke["_"];
          if(or__3548__auto____4976) {
            return or__3548__auto____4976
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4977 = this$;
      if(and__3546__auto____4977) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4977
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4978 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4978) {
          return or__3548__auto____4978
        }else {
          var or__3548__auto____4979 = cljs.core._invoke["_"];
          if(or__3548__auto____4979) {
            return or__3548__auto____4979
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4980 = this$;
      if(and__3546__auto____4980) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4980
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4981 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4981) {
          return or__3548__auto____4981
        }else {
          var or__3548__auto____4982 = cljs.core._invoke["_"];
          if(or__3548__auto____4982) {
            return or__3548__auto____4982
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4983 = this$;
      if(and__3546__auto____4983) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4983
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4984 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4984) {
          return or__3548__auto____4984
        }else {
          var or__3548__auto____4985 = cljs.core._invoke["_"];
          if(or__3548__auto____4985) {
            return or__3548__auto____4985
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4986 = this$;
      if(and__3546__auto____4986) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4986
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4987 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4987) {
          return or__3548__auto____4987
        }else {
          var or__3548__auto____4988 = cljs.core._invoke["_"];
          if(or__3548__auto____4988) {
            return or__3548__auto____4988
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4989 = this$;
      if(and__3546__auto____4989) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4989
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4990 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4990) {
          return or__3548__auto____4990
        }else {
          var or__3548__auto____4991 = cljs.core._invoke["_"];
          if(or__3548__auto____4991) {
            return or__3548__auto____4991
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4992 = this$;
      if(and__3546__auto____4992) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4992
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4993 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4993) {
          return or__3548__auto____4993
        }else {
          var or__3548__auto____4994 = cljs.core._invoke["_"];
          if(or__3548__auto____4994) {
            return or__3548__auto____4994
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4995 = this$;
      if(and__3546__auto____4995) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4995
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4996 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4996) {
          return or__3548__auto____4996
        }else {
          var or__3548__auto____4997 = cljs.core._invoke["_"];
          if(or__3548__auto____4997) {
            return or__3548__auto____4997
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4998 = this$;
      if(and__3546__auto____4998) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4998
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4999 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4999) {
          return or__3548__auto____4999
        }else {
          var or__3548__auto____5000 = cljs.core._invoke["_"];
          if(or__3548__auto____5000) {
            return or__3548__auto____5000
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____5001 = this$;
      if(and__3546__auto____5001) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____5001
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____5002 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5002) {
          return or__3548__auto____5002
        }else {
          var or__3548__auto____5003 = cljs.core._invoke["_"];
          if(or__3548__auto____5003) {
            return or__3548__auto____5003
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____5004 = this$;
      if(and__3546__auto____5004) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____5004
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____5005 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5005) {
          return or__3548__auto____5005
        }else {
          var or__3548__auto____5006 = cljs.core._invoke["_"];
          if(or__3548__auto____5006) {
            return or__3548__auto____5006
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____5007 = this$;
      if(and__3546__auto____5007) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____5007
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____5008 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5008) {
          return or__3548__auto____5008
        }else {
          var or__3548__auto____5009 = cljs.core._invoke["_"];
          if(or__3548__auto____5009) {
            return or__3548__auto____5009
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____5010 = this$;
      if(and__3546__auto____5010) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____5010
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____5011 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5011) {
          return or__3548__auto____5011
        }else {
          var or__3548__auto____5012 = cljs.core._invoke["_"];
          if(or__3548__auto____5012) {
            return or__3548__auto____5012
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____5013 = coll;
    if(and__3546__auto____5013) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____5013
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5014 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5014) {
        return or__3548__auto____5014
      }else {
        var or__3548__auto____5015 = cljs.core._count["_"];
        if(or__3548__auto____5015) {
          return or__3548__auto____5015
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____5016 = coll;
    if(and__3546__auto____5016) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____5016
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5017 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5017) {
        return or__3548__auto____5017
      }else {
        var or__3548__auto____5018 = cljs.core._empty["_"];
        if(or__3548__auto____5018) {
          return or__3548__auto____5018
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____5019 = coll;
    if(and__3546__auto____5019) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____5019
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____5020 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5020) {
        return or__3548__auto____5020
      }else {
        var or__3548__auto____5021 = cljs.core._conj["_"];
        if(or__3548__auto____5021) {
          return or__3548__auto____5021
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____5022 = coll;
      if(and__3546__auto____5022) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____5022
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____5023 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5023) {
          return or__3548__auto____5023
        }else {
          var or__3548__auto____5024 = cljs.core._nth["_"];
          if(or__3548__auto____5024) {
            return or__3548__auto____5024
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____5025 = coll;
      if(and__3546__auto____5025) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____5025
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____5026 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5026) {
          return or__3548__auto____5026
        }else {
          var or__3548__auto____5027 = cljs.core._nth["_"];
          if(or__3548__auto____5027) {
            return or__3548__auto____5027
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____5028 = coll;
    if(and__3546__auto____5028) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____5028
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5029 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5029) {
        return or__3548__auto____5029
      }else {
        var or__3548__auto____5030 = cljs.core._first["_"];
        if(or__3548__auto____5030) {
          return or__3548__auto____5030
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____5031 = coll;
    if(and__3546__auto____5031) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____5031
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5032 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5032) {
        return or__3548__auto____5032
      }else {
        var or__3548__auto____5033 = cljs.core._rest["_"];
        if(or__3548__auto____5033) {
          return or__3548__auto____5033
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____5034 = o;
      if(and__3546__auto____5034) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____5034
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____5035 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5035) {
          return or__3548__auto____5035
        }else {
          var or__3548__auto____5036 = cljs.core._lookup["_"];
          if(or__3548__auto____5036) {
            return or__3548__auto____5036
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____5037 = o;
      if(and__3546__auto____5037) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____5037
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____5038 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5038) {
          return or__3548__auto____5038
        }else {
          var or__3548__auto____5039 = cljs.core._lookup["_"];
          if(or__3548__auto____5039) {
            return or__3548__auto____5039
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____5040 = coll;
    if(and__3546__auto____5040) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____5040
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5041 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5041) {
        return or__3548__auto____5041
      }else {
        var or__3548__auto____5042 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____5042) {
          return or__3548__auto____5042
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____5043 = coll;
    if(and__3546__auto____5043) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____5043
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____5044 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5044) {
        return or__3548__auto____5044
      }else {
        var or__3548__auto____5045 = cljs.core._assoc["_"];
        if(or__3548__auto____5045) {
          return or__3548__auto____5045
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____5046 = coll;
    if(and__3546__auto____5046) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____5046
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5047 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5047) {
        return or__3548__auto____5047
      }else {
        var or__3548__auto____5048 = cljs.core._dissoc["_"];
        if(or__3548__auto____5048) {
          return or__3548__auto____5048
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____5049 = coll;
    if(and__3546__auto____5049) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____5049
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5050 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5050) {
        return or__3548__auto____5050
      }else {
        var or__3548__auto____5051 = cljs.core._key["_"];
        if(or__3548__auto____5051) {
          return or__3548__auto____5051
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____5052 = coll;
    if(and__3546__auto____5052) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____5052
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5053 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5053) {
        return or__3548__auto____5053
      }else {
        var or__3548__auto____5054 = cljs.core._val["_"];
        if(or__3548__auto____5054) {
          return or__3548__auto____5054
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____5055 = coll;
    if(and__3546__auto____5055) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____5055
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____5056 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5056) {
        return or__3548__auto____5056
      }else {
        var or__3548__auto____5057 = cljs.core._disjoin["_"];
        if(or__3548__auto____5057) {
          return or__3548__auto____5057
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____5058 = coll;
    if(and__3546__auto____5058) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____5058
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5059 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5059) {
        return or__3548__auto____5059
      }else {
        var or__3548__auto____5060 = cljs.core._peek["_"];
        if(or__3548__auto____5060) {
          return or__3548__auto____5060
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____5061 = coll;
    if(and__3546__auto____5061) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____5061
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5062 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5062) {
        return or__3548__auto____5062
      }else {
        var or__3548__auto____5063 = cljs.core._pop["_"];
        if(or__3548__auto____5063) {
          return or__3548__auto____5063
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____5064 = coll;
    if(and__3546__auto____5064) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____5064
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____5065 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5065) {
        return or__3548__auto____5065
      }else {
        var or__3548__auto____5066 = cljs.core._assoc_n["_"];
        if(or__3548__auto____5066) {
          return or__3548__auto____5066
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____5067 = o;
    if(and__3546__auto____5067) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____5067
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5068 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____5068) {
        return or__3548__auto____5068
      }else {
        var or__3548__auto____5069 = cljs.core._deref["_"];
        if(or__3548__auto____5069) {
          return or__3548__auto____5069
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____5070 = o;
    if(and__3546__auto____5070) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____5070
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____5071 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____5071) {
        return or__3548__auto____5071
      }else {
        var or__3548__auto____5072 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____5072) {
          return or__3548__auto____5072
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____5073 = o;
    if(and__3546__auto____5073) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____5073
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5074 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5074) {
        return or__3548__auto____5074
      }else {
        var or__3548__auto____5075 = cljs.core._meta["_"];
        if(or__3548__auto____5075) {
          return or__3548__auto____5075
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____5076 = o;
    if(and__3546__auto____5076) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____5076
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____5077 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5077) {
        return or__3548__auto____5077
      }else {
        var or__3548__auto____5078 = cljs.core._with_meta["_"];
        if(or__3548__auto____5078) {
          return or__3548__auto____5078
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____5079 = coll;
      if(and__3546__auto____5079) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____5079
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____5080 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5080) {
          return or__3548__auto____5080
        }else {
          var or__3548__auto____5081 = cljs.core._reduce["_"];
          if(or__3548__auto____5081) {
            return or__3548__auto____5081
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____5082 = coll;
      if(and__3546__auto____5082) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____5082
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____5083 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5083) {
          return or__3548__auto____5083
        }else {
          var or__3548__auto____5084 = cljs.core._reduce["_"];
          if(or__3548__auto____5084) {
            return or__3548__auto____5084
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____5085 = coll;
    if(and__3546__auto____5085) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____5085
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____5086 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5086) {
        return or__3548__auto____5086
      }else {
        var or__3548__auto____5087 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____5087) {
          return or__3548__auto____5087
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____5088 = o;
    if(and__3546__auto____5088) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____5088
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____5089 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____5089) {
        return or__3548__auto____5089
      }else {
        var or__3548__auto____5090 = cljs.core._equiv["_"];
        if(or__3548__auto____5090) {
          return or__3548__auto____5090
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____5091 = o;
    if(and__3546__auto____5091) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____5091
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5092 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____5092) {
        return or__3548__auto____5092
      }else {
        var or__3548__auto____5093 = cljs.core._hash["_"];
        if(or__3548__auto____5093) {
          return or__3548__auto____5093
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____5094 = o;
    if(and__3546__auto____5094) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____5094
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5095 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5095) {
        return or__3548__auto____5095
      }else {
        var or__3548__auto____5096 = cljs.core._seq["_"];
        if(or__3548__auto____5096) {
          return or__3548__auto____5096
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____5097 = coll;
    if(and__3546__auto____5097) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____5097
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5098 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5098) {
        return or__3548__auto____5098
      }else {
        var or__3548__auto____5099 = cljs.core._rseq["_"];
        if(or__3548__auto____5099) {
          return or__3548__auto____5099
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5100 = coll;
    if(and__3546__auto____5100) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____5100
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5101 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5101) {
        return or__3548__auto____5101
      }else {
        var or__3548__auto____5102 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____5102) {
          return or__3548__auto____5102
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5103 = coll;
    if(and__3546__auto____5103) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____5103
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5104 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5104) {
        return or__3548__auto____5104
      }else {
        var or__3548__auto____5105 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____5105) {
          return or__3548__auto____5105
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____5106 = coll;
    if(and__3546__auto____5106) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____5106
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____5107 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5107) {
        return or__3548__auto____5107
      }else {
        var or__3548__auto____5108 = cljs.core._entry_key["_"];
        if(or__3548__auto____5108) {
          return or__3548__auto____5108
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____5109 = coll;
    if(and__3546__auto____5109) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____5109
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5110 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5110) {
        return or__3548__auto____5110
      }else {
        var or__3548__auto____5111 = cljs.core._comparator["_"];
        if(or__3548__auto____5111) {
          return or__3548__auto____5111
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____5112 = o;
    if(and__3546__auto____5112) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____5112
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____5113 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5113) {
        return or__3548__auto____5113
      }else {
        var or__3548__auto____5114 = cljs.core._pr_seq["_"];
        if(or__3548__auto____5114) {
          return or__3548__auto____5114
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____5115 = d;
    if(and__3546__auto____5115) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____5115
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____5116 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____5116) {
        return or__3548__auto____5116
      }else {
        var or__3548__auto____5117 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____5117) {
          return or__3548__auto____5117
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____5118 = this$;
    if(and__3546__auto____5118) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____5118
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____5119 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5119) {
        return or__3548__auto____5119
      }else {
        var or__3548__auto____5120 = cljs.core._notify_watches["_"];
        if(or__3548__auto____5120) {
          return or__3548__auto____5120
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____5121 = this$;
    if(and__3546__auto____5121) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____5121
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____5122 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5122) {
        return or__3548__auto____5122
      }else {
        var or__3548__auto____5123 = cljs.core._add_watch["_"];
        if(or__3548__auto____5123) {
          return or__3548__auto____5123
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____5124 = this$;
    if(and__3546__auto____5124) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____5124
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____5125 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5125) {
        return or__3548__auto____5125
      }else {
        var or__3548__auto____5126 = cljs.core._remove_watch["_"];
        if(or__3548__auto____5126) {
          return or__3548__auto____5126
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____5127 = coll;
    if(and__3546__auto____5127) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____5127
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5128 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5128) {
        return or__3548__auto____5128
      }else {
        var or__3548__auto____5129 = cljs.core._as_transient["_"];
        if(or__3548__auto____5129) {
          return or__3548__auto____5129
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____5130 = tcoll;
    if(and__3546__auto____5130) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____5130
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____5131 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5131) {
        return or__3548__auto____5131
      }else {
        var or__3548__auto____5132 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____5132) {
          return or__3548__auto____5132
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5133 = tcoll;
    if(and__3546__auto____5133) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____5133
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5134 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5134) {
        return or__3548__auto____5134
      }else {
        var or__3548__auto____5135 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____5135) {
          return or__3548__auto____5135
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____5136 = tcoll;
    if(and__3546__auto____5136) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____5136
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____5137 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5137) {
        return or__3548__auto____5137
      }else {
        var or__3548__auto____5138 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____5138) {
          return or__3548__auto____5138
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____5139 = tcoll;
    if(and__3546__auto____5139) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____5139
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____5140 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5140) {
        return or__3548__auto____5140
      }else {
        var or__3548__auto____5141 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____5141) {
          return or__3548__auto____5141
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____5142 = tcoll;
    if(and__3546__auto____5142) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____5142
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____5143 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5143) {
        return or__3548__auto____5143
      }else {
        var or__3548__auto____5144 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____5144) {
          return or__3548__auto____5144
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5145 = tcoll;
    if(and__3546__auto____5145) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____5145
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5146 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5146) {
        return or__3548__auto____5146
      }else {
        var or__3548__auto____5147 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____5147) {
          return or__3548__auto____5147
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____5148 = tcoll;
    if(and__3546__auto____5148) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____5148
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____5149 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5149) {
        return or__3548__auto____5149
      }else {
        var or__3548__auto____5150 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____5150) {
          return or__3548__auto____5150
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____5151 = x === y;
    if(or__3548__auto____5151) {
      return or__3548__auto____5151
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__5152__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5153 = y;
            var G__5154 = cljs.core.first.call(null, more);
            var G__5155 = cljs.core.next.call(null, more);
            x = G__5153;
            y = G__5154;
            more = G__5155;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5152 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5152__delegate.call(this, x, y, more)
    };
    G__5152.cljs$lang$maxFixedArity = 2;
    G__5152.cljs$lang$applyTo = function(arglist__5156) {
      var x = cljs.core.first(arglist__5156);
      var y = cljs.core.first(cljs.core.next(arglist__5156));
      var more = cljs.core.rest(cljs.core.next(arglist__5156));
      return G__5152__delegate(x, y, more)
    };
    G__5152.cljs$lang$arity$variadic = G__5152__delegate;
    return G__5152
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____5157 = x == null;
    if(or__3548__auto____5157) {
      return or__3548__auto____5157
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__5158 = null;
  var G__5158__2 = function(o, k) {
    return null
  };
  var G__5158__3 = function(o, k, not_found) {
    return not_found
  };
  G__5158 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5158__2.call(this, o, k);
      case 3:
        return G__5158__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5158
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__5159 = null;
  var G__5159__2 = function(_, f) {
    return f.call(null)
  };
  var G__5159__3 = function(_, f, start) {
    return start
  };
  G__5159 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5159__2.call(this, _, f);
      case 3:
        return G__5159__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5159
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__5160 = null;
  var G__5160__2 = function(_, n) {
    return null
  };
  var G__5160__3 = function(_, n, not_found) {
    return not_found
  };
  G__5160 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5160__2.call(this, _, n);
      case 3:
        return G__5160__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5160
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__5161 = cljs.core._nth.call(null, cicoll, 0);
      var n__5162 = 1;
      while(true) {
        if(n__5162 < cljs.core._count.call(null, cicoll)) {
          var nval__5163 = f.call(null, val__5161, cljs.core._nth.call(null, cicoll, n__5162));
          if(cljs.core.reduced_QMARK_.call(null, nval__5163)) {
            return cljs.core.deref.call(null, nval__5163)
          }else {
            var G__5170 = nval__5163;
            var G__5171 = n__5162 + 1;
            val__5161 = G__5170;
            n__5162 = G__5171;
            continue
          }
        }else {
          return val__5161
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__5164 = val;
    var n__5165 = 0;
    while(true) {
      if(n__5165 < cljs.core._count.call(null, cicoll)) {
        var nval__5166 = f.call(null, val__5164, cljs.core._nth.call(null, cicoll, n__5165));
        if(cljs.core.reduced_QMARK_.call(null, nval__5166)) {
          return cljs.core.deref.call(null, nval__5166)
        }else {
          var G__5172 = nval__5166;
          var G__5173 = n__5165 + 1;
          val__5164 = G__5172;
          n__5165 = G__5173;
          continue
        }
      }else {
        return val__5164
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__5167 = val;
    var n__5168 = idx;
    while(true) {
      if(n__5168 < cljs.core._count.call(null, cicoll)) {
        var nval__5169 = f.call(null, val__5167, cljs.core._nth.call(null, cicoll, n__5168));
        if(cljs.core.reduced_QMARK_.call(null, nval__5169)) {
          return cljs.core.deref.call(null, nval__5169)
        }else {
          var G__5174 = nval__5169;
          var G__5175 = n__5168 + 1;
          val__5167 = G__5174;
          n__5168 = G__5175;
          continue
        }
      }else {
        return val__5167
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5176 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5177 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__5178 = this;
  var this$__5179 = this;
  return cljs.core.pr_str.call(null, this$__5179)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5180 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5180.a)) {
    return cljs.core.ci_reduce.call(null, this__5180.a, f, this__5180.a[this__5180.i], this__5180.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__5180.a[this__5180.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5181 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5181.a)) {
    return cljs.core.ci_reduce.call(null, this__5181.a, f, start, this__5181.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__5182 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__5183 = this;
  return this__5183.a.length - this__5183.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5184 = this;
  return this__5184.a[this__5184.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5185 = this;
  if(this__5185.i + 1 < this__5185.a.length) {
    return new cljs.core.IndexedSeq(this__5185.a, this__5185.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5186 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5187 = this;
  var i__5188 = n + this__5187.i;
  if(i__5188 < this__5187.a.length) {
    return this__5187.a[i__5188]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5189 = this;
  var i__5190 = n + this__5189.i;
  if(i__5190 < this__5189.a.length) {
    return this__5189.a[i__5190]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5191 = null;
  var G__5191__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5191__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5191 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5191__2.call(this, array, f);
      case 3:
        return G__5191__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5191
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5192 = null;
  var G__5192__2 = function(array, k) {
    return array[k]
  };
  var G__5192__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5192 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5192__2.call(this, array, k);
      case 3:
        return G__5192__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5192
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5193 = null;
  var G__5193__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5193__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5193 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5193__2.call(this, array, n);
      case 3:
        return G__5193__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5193
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5194__5195 = coll;
      if(G__5194__5195 != null) {
        if(function() {
          var or__3548__auto____5196 = G__5194__5195.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5196) {
            return or__3548__auto____5196
          }else {
            return G__5194__5195.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5194__5195.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5194__5195)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5194__5195)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5197__5198 = coll;
      if(G__5197__5198 != null) {
        if(function() {
          var or__3548__auto____5199 = G__5197__5198.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5199) {
            return or__3548__auto____5199
          }else {
            return G__5197__5198.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5197__5198.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5197__5198)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5197__5198)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5200 = cljs.core.seq.call(null, coll);
      if(s__5200 != null) {
        return cljs.core._first.call(null, s__5200)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5201__5202 = coll;
      if(G__5201__5202 != null) {
        if(function() {
          var or__3548__auto____5203 = G__5201__5202.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5203) {
            return or__3548__auto____5203
          }else {
            return G__5201__5202.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5201__5202.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5201__5202)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5201__5202)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5204 = cljs.core.seq.call(null, coll);
      if(s__5204 != null) {
        return cljs.core._rest.call(null, s__5204)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5205__5206 = coll;
      if(G__5205__5206 != null) {
        if(function() {
          var or__3548__auto____5207 = G__5205__5206.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5207) {
            return or__3548__auto____5207
          }else {
            return G__5205__5206.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5205__5206.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5205__5206)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5205__5206)
      }
    }()) {
      var coll__5208 = cljs.core._rest.call(null, coll);
      if(coll__5208 != null) {
        if(function() {
          var G__5209__5210 = coll__5208;
          if(G__5209__5210 != null) {
            if(function() {
              var or__3548__auto____5211 = G__5209__5210.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5211) {
                return or__3548__auto____5211
              }else {
                return G__5209__5210.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5209__5210.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5209__5210)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5209__5210)
          }
        }()) {
          return coll__5208
        }else {
          return cljs.core._seq.call(null, coll__5208)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5212 = cljs.core.next.call(null, s);
      s = G__5212;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5213__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5214 = conj.call(null, coll, x);
          var G__5215 = cljs.core.first.call(null, xs);
          var G__5216 = cljs.core.next.call(null, xs);
          coll = G__5214;
          x = G__5215;
          xs = G__5216;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5213 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5213__delegate.call(this, coll, x, xs)
    };
    G__5213.cljs$lang$maxFixedArity = 2;
    G__5213.cljs$lang$applyTo = function(arglist__5217) {
      var coll = cljs.core.first(arglist__5217);
      var x = cljs.core.first(cljs.core.next(arglist__5217));
      var xs = cljs.core.rest(cljs.core.next(arglist__5217));
      return G__5213__delegate(coll, x, xs)
    };
    G__5213.cljs$lang$arity$variadic = G__5213__delegate;
    return G__5213
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5218 = cljs.core.seq.call(null, coll);
  var acc__5219 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5218)) {
      return acc__5219 + cljs.core._count.call(null, s__5218)
    }else {
      var G__5220 = cljs.core.next.call(null, s__5218);
      var G__5221 = acc__5219 + 1;
      s__5218 = G__5220;
      acc__5219 = G__5221;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5222__5223 = coll;
        if(G__5222__5223 != null) {
          if(function() {
            var or__3548__auto____5224 = G__5222__5223.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5224) {
              return or__3548__auto____5224
            }else {
              return G__5222__5223.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5222__5223.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5222__5223)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5222__5223)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5225__5226 = coll;
        if(G__5225__5226 != null) {
          if(function() {
            var or__3548__auto____5227 = G__5225__5226.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5227) {
              return or__3548__auto____5227
            }else {
              return G__5225__5226.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5225__5226.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5225__5226)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5225__5226)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5229__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5228 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5230 = ret__5228;
          var G__5231 = cljs.core.first.call(null, kvs);
          var G__5232 = cljs.core.second.call(null, kvs);
          var G__5233 = cljs.core.nnext.call(null, kvs);
          coll = G__5230;
          k = G__5231;
          v = G__5232;
          kvs = G__5233;
          continue
        }else {
          return ret__5228
        }
        break
      }
    };
    var G__5229 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5229__delegate.call(this, coll, k, v, kvs)
    };
    G__5229.cljs$lang$maxFixedArity = 3;
    G__5229.cljs$lang$applyTo = function(arglist__5234) {
      var coll = cljs.core.first(arglist__5234);
      var k = cljs.core.first(cljs.core.next(arglist__5234));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5234)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5234)));
      return G__5229__delegate(coll, k, v, kvs)
    };
    G__5229.cljs$lang$arity$variadic = G__5229__delegate;
    return G__5229
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5236__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5235 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5237 = ret__5235;
          var G__5238 = cljs.core.first.call(null, ks);
          var G__5239 = cljs.core.next.call(null, ks);
          coll = G__5237;
          k = G__5238;
          ks = G__5239;
          continue
        }else {
          return ret__5235
        }
        break
      }
    };
    var G__5236 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5236__delegate.call(this, coll, k, ks)
    };
    G__5236.cljs$lang$maxFixedArity = 2;
    G__5236.cljs$lang$applyTo = function(arglist__5240) {
      var coll = cljs.core.first(arglist__5240);
      var k = cljs.core.first(cljs.core.next(arglist__5240));
      var ks = cljs.core.rest(cljs.core.next(arglist__5240));
      return G__5236__delegate(coll, k, ks)
    };
    G__5236.cljs$lang$arity$variadic = G__5236__delegate;
    return G__5236
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5241__5242 = o;
    if(G__5241__5242 != null) {
      if(function() {
        var or__3548__auto____5243 = G__5241__5242.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5243) {
          return or__3548__auto____5243
        }else {
          return G__5241__5242.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5241__5242.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5241__5242)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5241__5242)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5245__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5244 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5246 = ret__5244;
          var G__5247 = cljs.core.first.call(null, ks);
          var G__5248 = cljs.core.next.call(null, ks);
          coll = G__5246;
          k = G__5247;
          ks = G__5248;
          continue
        }else {
          return ret__5244
        }
        break
      }
    };
    var G__5245 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5245__delegate.call(this, coll, k, ks)
    };
    G__5245.cljs$lang$maxFixedArity = 2;
    G__5245.cljs$lang$applyTo = function(arglist__5249) {
      var coll = cljs.core.first(arglist__5249);
      var k = cljs.core.first(cljs.core.next(arglist__5249));
      var ks = cljs.core.rest(cljs.core.next(arglist__5249));
      return G__5245__delegate(coll, k, ks)
    };
    G__5245.cljs$lang$arity$variadic = G__5245__delegate;
    return G__5245
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5250__5251 = x;
    if(G__5250__5251 != null) {
      if(function() {
        var or__3548__auto____5252 = G__5250__5251.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5252) {
          return or__3548__auto____5252
        }else {
          return G__5250__5251.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5250__5251.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5250__5251)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5250__5251)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5253__5254 = x;
    if(G__5253__5254 != null) {
      if(function() {
        var or__3548__auto____5255 = G__5253__5254.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5255) {
          return or__3548__auto____5255
        }else {
          return G__5253__5254.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5253__5254.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5253__5254)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5253__5254)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5256__5257 = x;
  if(G__5256__5257 != null) {
    if(function() {
      var or__3548__auto____5258 = G__5256__5257.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5258) {
        return or__3548__auto____5258
      }else {
        return G__5256__5257.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5256__5257.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5256__5257)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5256__5257)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5259__5260 = x;
  if(G__5259__5260 != null) {
    if(function() {
      var or__3548__auto____5261 = G__5259__5260.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5261) {
        return or__3548__auto____5261
      }else {
        return G__5259__5260.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5259__5260.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5259__5260)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5259__5260)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5262__5263 = x;
  if(G__5262__5263 != null) {
    if(function() {
      var or__3548__auto____5264 = G__5262__5263.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5264) {
        return or__3548__auto____5264
      }else {
        return G__5262__5263.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5262__5263.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5262__5263)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5262__5263)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5265__5266 = x;
  if(G__5265__5266 != null) {
    if(function() {
      var or__3548__auto____5267 = G__5265__5266.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5267) {
        return or__3548__auto____5267
      }else {
        return G__5265__5266.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5265__5266.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5265__5266)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5265__5266)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5268__5269 = x;
  if(G__5268__5269 != null) {
    if(function() {
      var or__3548__auto____5270 = G__5268__5269.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5270) {
        return or__3548__auto____5270
      }else {
        return G__5268__5269.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5268__5269.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5268__5269)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5268__5269)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5271__5272 = x;
    if(G__5271__5272 != null) {
      if(function() {
        var or__3548__auto____5273 = G__5271__5272.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5273) {
          return or__3548__auto____5273
        }else {
          return G__5271__5272.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5271__5272.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5271__5272)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5271__5272)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5274__5275 = x;
  if(G__5274__5275 != null) {
    if(function() {
      var or__3548__auto____5276 = G__5274__5275.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5276) {
        return or__3548__auto____5276
      }else {
        return G__5274__5275.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5274__5275.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5274__5275)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5274__5275)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5277__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5277 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5277__delegate.call(this, keyvals)
    };
    G__5277.cljs$lang$maxFixedArity = 0;
    G__5277.cljs$lang$applyTo = function(arglist__5278) {
      var keyvals = cljs.core.seq(arglist__5278);
      return G__5277__delegate(keyvals)
    };
    G__5277.cljs$lang$arity$variadic = G__5277__delegate;
    return G__5277
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5279 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5279.push(key)
  });
  return keys__5279
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5280 = i;
  var j__5281 = j;
  var len__5282 = len;
  while(true) {
    if(len__5282 === 0) {
      return to
    }else {
      to[j__5281] = from[i__5280];
      var G__5283 = i__5280 + 1;
      var G__5284 = j__5281 + 1;
      var G__5285 = len__5282 - 1;
      i__5280 = G__5283;
      j__5281 = G__5284;
      len__5282 = G__5285;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5286 = i + (len - 1);
  var j__5287 = j + (len - 1);
  var len__5288 = len;
  while(true) {
    if(len__5288 === 0) {
      return to
    }else {
      to[j__5287] = from[i__5286];
      var G__5289 = i__5286 - 1;
      var G__5290 = j__5287 - 1;
      var G__5291 = len__5288 - 1;
      i__5286 = G__5289;
      j__5287 = G__5290;
      len__5288 = G__5291;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5292__5293 = s;
    if(G__5292__5293 != null) {
      if(function() {
        var or__3548__auto____5294 = G__5292__5293.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5294) {
          return or__3548__auto____5294
        }else {
          return G__5292__5293.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5292__5293.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5292__5293)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5292__5293)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5295__5296 = s;
  if(G__5295__5296 != null) {
    if(function() {
      var or__3548__auto____5297 = G__5295__5296.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5297) {
        return or__3548__auto____5297
      }else {
        return G__5295__5296.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5295__5296.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5295__5296)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5295__5296)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5298 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5298)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5299 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5299) {
        return or__3548__auto____5299
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5298
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5300 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5300)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5300
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5301 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5301)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5301
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5302 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5302) {
    return or__3548__auto____5302
  }else {
    var G__5303__5304 = f;
    if(G__5303__5304 != null) {
      if(function() {
        var or__3548__auto____5305 = G__5303__5304.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5305) {
          return or__3548__auto____5305
        }else {
          return G__5303__5304.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5303__5304.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5303__5304)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5303__5304)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5306 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5306) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5306
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5307 = coll;
    if(cljs.core.truth_(and__3546__auto____5307)) {
      var and__3546__auto____5308 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5308) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5308
      }
    }else {
      return and__3546__auto____5307
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5313__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5309 = cljs.core.set([y, x]);
        var xs__5310 = more;
        while(true) {
          var x__5311 = cljs.core.first.call(null, xs__5310);
          var etc__5312 = cljs.core.next.call(null, xs__5310);
          if(cljs.core.truth_(xs__5310)) {
            if(cljs.core.contains_QMARK_.call(null, s__5309, x__5311)) {
              return false
            }else {
              var G__5314 = cljs.core.conj.call(null, s__5309, x__5311);
              var G__5315 = etc__5312;
              s__5309 = G__5314;
              xs__5310 = G__5315;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5313 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5313__delegate.call(this, x, y, more)
    };
    G__5313.cljs$lang$maxFixedArity = 2;
    G__5313.cljs$lang$applyTo = function(arglist__5316) {
      var x = cljs.core.first(arglist__5316);
      var y = cljs.core.first(cljs.core.next(arglist__5316));
      var more = cljs.core.rest(cljs.core.next(arglist__5316));
      return G__5313__delegate(x, y, more)
    };
    G__5313.cljs$lang$arity$variadic = G__5313__delegate;
    return G__5313
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5317 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5317)) {
        return r__5317
      }else {
        if(cljs.core.truth_(r__5317)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5318 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5318, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5318)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5319 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5319)) {
      var s__5320 = temp__3695__auto____5319;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5320), cljs.core.next.call(null, s__5320))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5321 = val;
    var coll__5322 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5322)) {
        var nval__5323 = f.call(null, val__5321, cljs.core.first.call(null, coll__5322));
        if(cljs.core.reduced_QMARK_.call(null, nval__5323)) {
          return cljs.core.deref.call(null, nval__5323)
        }else {
          var G__5324 = nval__5323;
          var G__5325 = cljs.core.next.call(null, coll__5322);
          val__5321 = G__5324;
          coll__5322 = G__5325;
          continue
        }
      }else {
        return val__5321
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5326__5327 = coll;
      if(G__5326__5327 != null) {
        if(function() {
          var or__3548__auto____5328 = G__5326__5327.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5328) {
            return or__3548__auto____5328
          }else {
            return G__5326__5327.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5326__5327.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5326__5327)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5326__5327)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5329__5330 = coll;
      if(G__5329__5330 != null) {
        if(function() {
          var or__3548__auto____5331 = G__5329__5330.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5331) {
            return or__3548__auto____5331
          }else {
            return G__5329__5330.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5329__5330.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5329__5330)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5329__5330)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5332 = this;
  return this__5332.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5333__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5333 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5333__delegate.call(this, x, y, more)
    };
    G__5333.cljs$lang$maxFixedArity = 2;
    G__5333.cljs$lang$applyTo = function(arglist__5334) {
      var x = cljs.core.first(arglist__5334);
      var y = cljs.core.first(cljs.core.next(arglist__5334));
      var more = cljs.core.rest(cljs.core.next(arglist__5334));
      return G__5333__delegate(x, y, more)
    };
    G__5333.cljs$lang$arity$variadic = G__5333__delegate;
    return G__5333
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5335__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5335 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5335__delegate.call(this, x, y, more)
    };
    G__5335.cljs$lang$maxFixedArity = 2;
    G__5335.cljs$lang$applyTo = function(arglist__5336) {
      var x = cljs.core.first(arglist__5336);
      var y = cljs.core.first(cljs.core.next(arglist__5336));
      var more = cljs.core.rest(cljs.core.next(arglist__5336));
      return G__5335__delegate(x, y, more)
    };
    G__5335.cljs$lang$arity$variadic = G__5335__delegate;
    return G__5335
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5337__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5337 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5337__delegate.call(this, x, y, more)
    };
    G__5337.cljs$lang$maxFixedArity = 2;
    G__5337.cljs$lang$applyTo = function(arglist__5338) {
      var x = cljs.core.first(arglist__5338);
      var y = cljs.core.first(cljs.core.next(arglist__5338));
      var more = cljs.core.rest(cljs.core.next(arglist__5338));
      return G__5337__delegate(x, y, more)
    };
    G__5337.cljs$lang$arity$variadic = G__5337__delegate;
    return G__5337
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5339__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5339 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5339__delegate.call(this, x, y, more)
    };
    G__5339.cljs$lang$maxFixedArity = 2;
    G__5339.cljs$lang$applyTo = function(arglist__5340) {
      var x = cljs.core.first(arglist__5340);
      var y = cljs.core.first(cljs.core.next(arglist__5340));
      var more = cljs.core.rest(cljs.core.next(arglist__5340));
      return G__5339__delegate(x, y, more)
    };
    G__5339.cljs$lang$arity$variadic = G__5339__delegate;
    return G__5339
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5341__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5342 = y;
            var G__5343 = cljs.core.first.call(null, more);
            var G__5344 = cljs.core.next.call(null, more);
            x = G__5342;
            y = G__5343;
            more = G__5344;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5341 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5341__delegate.call(this, x, y, more)
    };
    G__5341.cljs$lang$maxFixedArity = 2;
    G__5341.cljs$lang$applyTo = function(arglist__5345) {
      var x = cljs.core.first(arglist__5345);
      var y = cljs.core.first(cljs.core.next(arglist__5345));
      var more = cljs.core.rest(cljs.core.next(arglist__5345));
      return G__5341__delegate(x, y, more)
    };
    G__5341.cljs$lang$arity$variadic = G__5341__delegate;
    return G__5341
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5346__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5347 = y;
            var G__5348 = cljs.core.first.call(null, more);
            var G__5349 = cljs.core.next.call(null, more);
            x = G__5347;
            y = G__5348;
            more = G__5349;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5346 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5346__delegate.call(this, x, y, more)
    };
    G__5346.cljs$lang$maxFixedArity = 2;
    G__5346.cljs$lang$applyTo = function(arglist__5350) {
      var x = cljs.core.first(arglist__5350);
      var y = cljs.core.first(cljs.core.next(arglist__5350));
      var more = cljs.core.rest(cljs.core.next(arglist__5350));
      return G__5346__delegate(x, y, more)
    };
    G__5346.cljs$lang$arity$variadic = G__5346__delegate;
    return G__5346
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5351__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5352 = y;
            var G__5353 = cljs.core.first.call(null, more);
            var G__5354 = cljs.core.next.call(null, more);
            x = G__5352;
            y = G__5353;
            more = G__5354;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5351 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5351__delegate.call(this, x, y, more)
    };
    G__5351.cljs$lang$maxFixedArity = 2;
    G__5351.cljs$lang$applyTo = function(arglist__5355) {
      var x = cljs.core.first(arglist__5355);
      var y = cljs.core.first(cljs.core.next(arglist__5355));
      var more = cljs.core.rest(cljs.core.next(arglist__5355));
      return G__5351__delegate(x, y, more)
    };
    G__5351.cljs$lang$arity$variadic = G__5351__delegate;
    return G__5351
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5356__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5357 = y;
            var G__5358 = cljs.core.first.call(null, more);
            var G__5359 = cljs.core.next.call(null, more);
            x = G__5357;
            y = G__5358;
            more = G__5359;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5356 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5356__delegate.call(this, x, y, more)
    };
    G__5356.cljs$lang$maxFixedArity = 2;
    G__5356.cljs$lang$applyTo = function(arglist__5360) {
      var x = cljs.core.first(arglist__5360);
      var y = cljs.core.first(cljs.core.next(arglist__5360));
      var more = cljs.core.rest(cljs.core.next(arglist__5360));
      return G__5356__delegate(x, y, more)
    };
    G__5356.cljs$lang$arity$variadic = G__5356__delegate;
    return G__5356
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5361__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5361 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5361__delegate.call(this, x, y, more)
    };
    G__5361.cljs$lang$maxFixedArity = 2;
    G__5361.cljs$lang$applyTo = function(arglist__5362) {
      var x = cljs.core.first(arglist__5362);
      var y = cljs.core.first(cljs.core.next(arglist__5362));
      var more = cljs.core.rest(cljs.core.next(arglist__5362));
      return G__5361__delegate(x, y, more)
    };
    G__5361.cljs$lang$arity$variadic = G__5361__delegate;
    return G__5361
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5363__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5363 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5363__delegate.call(this, x, y, more)
    };
    G__5363.cljs$lang$maxFixedArity = 2;
    G__5363.cljs$lang$applyTo = function(arglist__5364) {
      var x = cljs.core.first(arglist__5364);
      var y = cljs.core.first(cljs.core.next(arglist__5364));
      var more = cljs.core.rest(cljs.core.next(arglist__5364));
      return G__5363__delegate(x, y, more)
    };
    G__5363.cljs$lang$arity$variadic = G__5363__delegate;
    return G__5363
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5365 = n % d;
  return cljs.core.fix.call(null, (n - rem__5365) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5366 = cljs.core.quot.call(null, n, d);
  return n - d * q__5366
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5367 = 0;
  var n__5368 = n;
  while(true) {
    if(n__5368 === 0) {
      return c__5367
    }else {
      var G__5369 = c__5367 + 1;
      var G__5370 = n__5368 & n__5368 - 1;
      c__5367 = G__5369;
      n__5368 = G__5370;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5371__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5372 = y;
            var G__5373 = cljs.core.first.call(null, more);
            var G__5374 = cljs.core.next.call(null, more);
            x = G__5372;
            y = G__5373;
            more = G__5374;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5371 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5371__delegate.call(this, x, y, more)
    };
    G__5371.cljs$lang$maxFixedArity = 2;
    G__5371.cljs$lang$applyTo = function(arglist__5375) {
      var x = cljs.core.first(arglist__5375);
      var y = cljs.core.first(cljs.core.next(arglist__5375));
      var more = cljs.core.rest(cljs.core.next(arglist__5375));
      return G__5371__delegate(x, y, more)
    };
    G__5371.cljs$lang$arity$variadic = G__5371__delegate;
    return G__5371
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5376 = n;
  var xs__5377 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5378 = xs__5377;
      if(cljs.core.truth_(and__3546__auto____5378)) {
        return n__5376 > 0
      }else {
        return and__3546__auto____5378
      }
    }())) {
      var G__5379 = n__5376 - 1;
      var G__5380 = cljs.core.next.call(null, xs__5377);
      n__5376 = G__5379;
      xs__5377 = G__5380;
      continue
    }else {
      return xs__5377
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5381__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5382 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5383 = cljs.core.next.call(null, more);
            sb = G__5382;
            more = G__5383;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5381 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5381__delegate.call(this, x, ys)
    };
    G__5381.cljs$lang$maxFixedArity = 1;
    G__5381.cljs$lang$applyTo = function(arglist__5384) {
      var x = cljs.core.first(arglist__5384);
      var ys = cljs.core.rest(arglist__5384);
      return G__5381__delegate(x, ys)
    };
    G__5381.cljs$lang$arity$variadic = G__5381__delegate;
    return G__5381
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5385__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5386 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5387 = cljs.core.next.call(null, more);
            sb = G__5386;
            more = G__5387;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5385 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5385__delegate.call(this, x, ys)
    };
    G__5385.cljs$lang$maxFixedArity = 1;
    G__5385.cljs$lang$applyTo = function(arglist__5388) {
      var x = cljs.core.first(arglist__5388);
      var ys = cljs.core.rest(arglist__5388);
      return G__5385__delegate(x, ys)
    };
    G__5385.cljs$lang$arity$variadic = G__5385__delegate;
    return G__5385
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5389 = cljs.core.seq.call(null, x);
    var ys__5390 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5389 == null) {
        return ys__5390 == null
      }else {
        if(ys__5390 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5389), cljs.core.first.call(null, ys__5390))) {
            var G__5391 = cljs.core.next.call(null, xs__5389);
            var G__5392 = cljs.core.next.call(null, ys__5390);
            xs__5389 = G__5391;
            ys__5390 = G__5392;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5393_SHARP_, p2__5394_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5393_SHARP_, cljs.core.hash.call(null, p2__5394_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5395 = 0;
  var s__5396 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5396)) {
      var e__5397 = cljs.core.first.call(null, s__5396);
      var G__5398 = (h__5395 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5397)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5397)))) % 4503599627370496;
      var G__5399 = cljs.core.next.call(null, s__5396);
      h__5395 = G__5398;
      s__5396 = G__5399;
      continue
    }else {
      return h__5395
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5400 = 0;
  var s__5401 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5401)) {
      var e__5402 = cljs.core.first.call(null, s__5401);
      var G__5403 = (h__5400 + cljs.core.hash.call(null, e__5402)) % 4503599627370496;
      var G__5404 = cljs.core.next.call(null, s__5401);
      h__5400 = G__5403;
      s__5401 = G__5404;
      continue
    }else {
      return h__5400
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5405__5406 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5405__5406)) {
    var G__5408__5410 = cljs.core.first.call(null, G__5405__5406);
    var vec__5409__5411 = G__5408__5410;
    var key_name__5412 = cljs.core.nth.call(null, vec__5409__5411, 0, null);
    var f__5413 = cljs.core.nth.call(null, vec__5409__5411, 1, null);
    var G__5405__5414 = G__5405__5406;
    var G__5408__5415 = G__5408__5410;
    var G__5405__5416 = G__5405__5414;
    while(true) {
      var vec__5417__5418 = G__5408__5415;
      var key_name__5419 = cljs.core.nth.call(null, vec__5417__5418, 0, null);
      var f__5420 = cljs.core.nth.call(null, vec__5417__5418, 1, null);
      var G__5405__5421 = G__5405__5416;
      var str_name__5422 = cljs.core.name.call(null, key_name__5419);
      obj[str_name__5422] = f__5420;
      var temp__3698__auto____5423 = cljs.core.next.call(null, G__5405__5421);
      if(cljs.core.truth_(temp__3698__auto____5423)) {
        var G__5405__5424 = temp__3698__auto____5423;
        var G__5425 = cljs.core.first.call(null, G__5405__5424);
        var G__5426 = G__5405__5424;
        G__5408__5415 = G__5425;
        G__5405__5416 = G__5426;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5427 = this;
  var h__364__auto____5428 = this__5427.__hash;
  if(h__364__auto____5428 != null) {
    return h__364__auto____5428
  }else {
    var h__364__auto____5429 = cljs.core.hash_coll.call(null, coll);
    this__5427.__hash = h__364__auto____5429;
    return h__364__auto____5429
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5430 = this;
  return new cljs.core.List(this__5430.meta, o, coll, this__5430.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5431 = this;
  var this$__5432 = this;
  return cljs.core.pr_str.call(null, this$__5432)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5433 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5434 = this;
  return this__5434.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5435 = this;
  return this__5435.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5436 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5437 = this;
  return this__5437.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5438 = this;
  return this__5438.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5439 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5440 = this;
  return new cljs.core.List(meta, this__5440.first, this__5440.rest, this__5440.count, this__5440.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5441 = this;
  return this__5441.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5442 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5443 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5444 = this;
  return new cljs.core.List(this__5444.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5445 = this;
  var this$__5446 = this;
  return cljs.core.pr_str.call(null, this$__5446)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5447 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5448 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5449 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5450 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5451 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5452 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5453 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5454 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5455 = this;
  return this__5455.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5456 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5457__5458 = coll;
  if(G__5457__5458 != null) {
    if(function() {
      var or__3548__auto____5459 = G__5457__5458.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5459) {
        return or__3548__auto____5459
      }else {
        return G__5457__5458.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5457__5458.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5457__5458)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5457__5458)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5460) {
    var items = cljs.core.seq(arglist__5460);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5461 = this;
  var h__364__auto____5462 = this__5461.__hash;
  if(h__364__auto____5462 != null) {
    return h__364__auto____5462
  }else {
    var h__364__auto____5463 = cljs.core.hash_coll.call(null, coll);
    this__5461.__hash = h__364__auto____5463;
    return h__364__auto____5463
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5464 = this;
  return new cljs.core.Cons(null, o, coll, this__5464.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5465 = this;
  var this$__5466 = this;
  return cljs.core.pr_str.call(null, this$__5466)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5467 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5468 = this;
  return this__5468.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5469 = this;
  if(this__5469.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5469.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5470 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5471 = this;
  return new cljs.core.Cons(meta, this__5471.first, this__5471.rest, this__5471.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5472 = this;
  return this__5472.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5473 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5473.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5474 = coll == null;
    if(or__3548__auto____5474) {
      return or__3548__auto____5474
    }else {
      var G__5475__5476 = coll;
      if(G__5475__5476 != null) {
        if(function() {
          var or__3548__auto____5477 = G__5475__5476.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5477) {
            return or__3548__auto____5477
          }else {
            return G__5475__5476.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5475__5476.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5475__5476)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5475__5476)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5478__5479 = x;
  if(G__5478__5479 != null) {
    if(function() {
      var or__3548__auto____5480 = G__5478__5479.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5480) {
        return or__3548__auto____5480
      }else {
        return G__5478__5479.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5478__5479.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5478__5479)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5478__5479)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5481 = null;
  var G__5481__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5481__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5481 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5481__2.call(this, string, f);
      case 3:
        return G__5481__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5481
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5482 = null;
  var G__5482__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5482__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5482 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5482__2.call(this, string, k);
      case 3:
        return G__5482__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5482
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5483 = null;
  var G__5483__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5483__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5483 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5483__2.call(this, string, n);
      case 3:
        return G__5483__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5483
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5492 = null;
  var G__5492__2 = function(tsym5486, coll) {
    var tsym5486__5488 = this;
    var this$__5489 = tsym5486__5488;
    return cljs.core.get.call(null, coll, this$__5489.toString())
  };
  var G__5492__3 = function(tsym5487, coll, not_found) {
    var tsym5487__5490 = this;
    var this$__5491 = tsym5487__5490;
    return cljs.core.get.call(null, coll, this$__5491.toString(), not_found)
  };
  G__5492 = function(tsym5487, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5492__2.call(this, tsym5487, coll);
      case 3:
        return G__5492__3.call(this, tsym5487, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5492
}();
String.prototype.apply = function(tsym5484, args5485) {
  return tsym5484.call.apply(tsym5484, [tsym5484].concat(cljs.core.aclone.call(null, args5485)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5493 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5493
  }else {
    lazy_seq.x = x__5493.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5494 = this;
  var h__364__auto____5495 = this__5494.__hash;
  if(h__364__auto____5495 != null) {
    return h__364__auto____5495
  }else {
    var h__364__auto____5496 = cljs.core.hash_coll.call(null, coll);
    this__5494.__hash = h__364__auto____5496;
    return h__364__auto____5496
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5497 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5498 = this;
  var this$__5499 = this;
  return cljs.core.pr_str.call(null, this$__5499)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5500 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5501 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5502 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5503 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5504 = this;
  return new cljs.core.LazySeq(meta, this__5504.realized, this__5504.x, this__5504.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5505 = this;
  return this__5505.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5506 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5506.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5507 = [];
  var s__5508 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5508))) {
      ary__5507.push(cljs.core.first.call(null, s__5508));
      var G__5509 = cljs.core.next.call(null, s__5508);
      s__5508 = G__5509;
      continue
    }else {
      return ary__5507
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5510 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5511 = 0;
  var xs__5512 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5512)) {
      ret__5510[i__5511] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5512));
      var G__5513 = i__5511 + 1;
      var G__5514 = cljs.core.next.call(null, xs__5512);
      i__5511 = G__5513;
      xs__5512 = G__5514;
      continue
    }else {
    }
    break
  }
  return ret__5510
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5515 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5516 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5517 = 0;
      var s__5518 = s__5516;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5519 = s__5518;
          if(cljs.core.truth_(and__3546__auto____5519)) {
            return i__5517 < size
          }else {
            return and__3546__auto____5519
          }
        }())) {
          a__5515[i__5517] = cljs.core.first.call(null, s__5518);
          var G__5522 = i__5517 + 1;
          var G__5523 = cljs.core.next.call(null, s__5518);
          i__5517 = G__5522;
          s__5518 = G__5523;
          continue
        }else {
          return a__5515
        }
        break
      }
    }else {
      var n__685__auto____5520 = size;
      var i__5521 = 0;
      while(true) {
        if(i__5521 < n__685__auto____5520) {
          a__5515[i__5521] = init_val_or_seq;
          var G__5524 = i__5521 + 1;
          i__5521 = G__5524;
          continue
        }else {
        }
        break
      }
      return a__5515
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5525 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5526 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5527 = 0;
      var s__5528 = s__5526;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5529 = s__5528;
          if(cljs.core.truth_(and__3546__auto____5529)) {
            return i__5527 < size
          }else {
            return and__3546__auto____5529
          }
        }())) {
          a__5525[i__5527] = cljs.core.first.call(null, s__5528);
          var G__5532 = i__5527 + 1;
          var G__5533 = cljs.core.next.call(null, s__5528);
          i__5527 = G__5532;
          s__5528 = G__5533;
          continue
        }else {
          return a__5525
        }
        break
      }
    }else {
      var n__685__auto____5530 = size;
      var i__5531 = 0;
      while(true) {
        if(i__5531 < n__685__auto____5530) {
          a__5525[i__5531] = init_val_or_seq;
          var G__5534 = i__5531 + 1;
          i__5531 = G__5534;
          continue
        }else {
        }
        break
      }
      return a__5525
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5535 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5536 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5537 = 0;
      var s__5538 = s__5536;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5539 = s__5538;
          if(cljs.core.truth_(and__3546__auto____5539)) {
            return i__5537 < size
          }else {
            return and__3546__auto____5539
          }
        }())) {
          a__5535[i__5537] = cljs.core.first.call(null, s__5538);
          var G__5542 = i__5537 + 1;
          var G__5543 = cljs.core.next.call(null, s__5538);
          i__5537 = G__5542;
          s__5538 = G__5543;
          continue
        }else {
          return a__5535
        }
        break
      }
    }else {
      var n__685__auto____5540 = size;
      var i__5541 = 0;
      while(true) {
        if(i__5541 < n__685__auto____5540) {
          a__5535[i__5541] = init_val_or_seq;
          var G__5544 = i__5541 + 1;
          i__5541 = G__5544;
          continue
        }else {
        }
        break
      }
      return a__5535
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5545 = s;
    var i__5546 = n;
    var sum__5547 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5548 = i__5546 > 0;
        if(and__3546__auto____5548) {
          return cljs.core.seq.call(null, s__5545)
        }else {
          return and__3546__auto____5548
        }
      }())) {
        var G__5549 = cljs.core.next.call(null, s__5545);
        var G__5550 = i__5546 - 1;
        var G__5551 = sum__5547 + 1;
        s__5545 = G__5549;
        i__5546 = G__5550;
        sum__5547 = G__5551;
        continue
      }else {
        return sum__5547
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5552 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5552)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5552), concat.call(null, cljs.core.rest.call(null, s__5552), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5555__delegate = function(x, y, zs) {
      var cat__5554 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5553 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5553)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5553), cat.call(null, cljs.core.rest.call(null, xys__5553), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5554.call(null, concat.call(null, x, y), zs)
    };
    var G__5555 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5555__delegate.call(this, x, y, zs)
    };
    G__5555.cljs$lang$maxFixedArity = 2;
    G__5555.cljs$lang$applyTo = function(arglist__5556) {
      var x = cljs.core.first(arglist__5556);
      var y = cljs.core.first(cljs.core.next(arglist__5556));
      var zs = cljs.core.rest(cljs.core.next(arglist__5556));
      return G__5555__delegate(x, y, zs)
    };
    G__5555.cljs$lang$arity$variadic = G__5555__delegate;
    return G__5555
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5557__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5557 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5557__delegate.call(this, a, b, c, d, more)
    };
    G__5557.cljs$lang$maxFixedArity = 4;
    G__5557.cljs$lang$applyTo = function(arglist__5558) {
      var a = cljs.core.first(arglist__5558);
      var b = cljs.core.first(cljs.core.next(arglist__5558));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5558)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5558))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5558))));
      return G__5557__delegate(a, b, c, d, more)
    };
    G__5557.cljs$lang$arity$variadic = G__5557__delegate;
    return G__5557
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5559 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5560 = cljs.core._first.call(null, args__5559);
    var args__5561 = cljs.core._rest.call(null, args__5559);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5560)
      }else {
        return f.call(null, a__5560)
      }
    }else {
      var b__5562 = cljs.core._first.call(null, args__5561);
      var args__5563 = cljs.core._rest.call(null, args__5561);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5560, b__5562)
        }else {
          return f.call(null, a__5560, b__5562)
        }
      }else {
        var c__5564 = cljs.core._first.call(null, args__5563);
        var args__5565 = cljs.core._rest.call(null, args__5563);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5560, b__5562, c__5564)
          }else {
            return f.call(null, a__5560, b__5562, c__5564)
          }
        }else {
          var d__5566 = cljs.core._first.call(null, args__5565);
          var args__5567 = cljs.core._rest.call(null, args__5565);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5560, b__5562, c__5564, d__5566)
            }else {
              return f.call(null, a__5560, b__5562, c__5564, d__5566)
            }
          }else {
            var e__5568 = cljs.core._first.call(null, args__5567);
            var args__5569 = cljs.core._rest.call(null, args__5567);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5560, b__5562, c__5564, d__5566, e__5568)
              }else {
                return f.call(null, a__5560, b__5562, c__5564, d__5566, e__5568)
              }
            }else {
              var f__5570 = cljs.core._first.call(null, args__5569);
              var args__5571 = cljs.core._rest.call(null, args__5569);
              if(argc === 6) {
                if(f__5570.cljs$lang$arity$6) {
                  return f__5570.cljs$lang$arity$6(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570)
                }else {
                  return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570)
                }
              }else {
                var g__5572 = cljs.core._first.call(null, args__5571);
                var args__5573 = cljs.core._rest.call(null, args__5571);
                if(argc === 7) {
                  if(f__5570.cljs$lang$arity$7) {
                    return f__5570.cljs$lang$arity$7(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572)
                  }else {
                    return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572)
                  }
                }else {
                  var h__5574 = cljs.core._first.call(null, args__5573);
                  var args__5575 = cljs.core._rest.call(null, args__5573);
                  if(argc === 8) {
                    if(f__5570.cljs$lang$arity$8) {
                      return f__5570.cljs$lang$arity$8(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574)
                    }else {
                      return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574)
                    }
                  }else {
                    var i__5576 = cljs.core._first.call(null, args__5575);
                    var args__5577 = cljs.core._rest.call(null, args__5575);
                    if(argc === 9) {
                      if(f__5570.cljs$lang$arity$9) {
                        return f__5570.cljs$lang$arity$9(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576)
                      }else {
                        return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576)
                      }
                    }else {
                      var j__5578 = cljs.core._first.call(null, args__5577);
                      var args__5579 = cljs.core._rest.call(null, args__5577);
                      if(argc === 10) {
                        if(f__5570.cljs$lang$arity$10) {
                          return f__5570.cljs$lang$arity$10(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578)
                        }else {
                          return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578)
                        }
                      }else {
                        var k__5580 = cljs.core._first.call(null, args__5579);
                        var args__5581 = cljs.core._rest.call(null, args__5579);
                        if(argc === 11) {
                          if(f__5570.cljs$lang$arity$11) {
                            return f__5570.cljs$lang$arity$11(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580)
                          }else {
                            return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580)
                          }
                        }else {
                          var l__5582 = cljs.core._first.call(null, args__5581);
                          var args__5583 = cljs.core._rest.call(null, args__5581);
                          if(argc === 12) {
                            if(f__5570.cljs$lang$arity$12) {
                              return f__5570.cljs$lang$arity$12(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582)
                            }else {
                              return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582)
                            }
                          }else {
                            var m__5584 = cljs.core._first.call(null, args__5583);
                            var args__5585 = cljs.core._rest.call(null, args__5583);
                            if(argc === 13) {
                              if(f__5570.cljs$lang$arity$13) {
                                return f__5570.cljs$lang$arity$13(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584)
                              }else {
                                return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584)
                              }
                            }else {
                              var n__5586 = cljs.core._first.call(null, args__5585);
                              var args__5587 = cljs.core._rest.call(null, args__5585);
                              if(argc === 14) {
                                if(f__5570.cljs$lang$arity$14) {
                                  return f__5570.cljs$lang$arity$14(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586)
                                }else {
                                  return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586)
                                }
                              }else {
                                var o__5588 = cljs.core._first.call(null, args__5587);
                                var args__5589 = cljs.core._rest.call(null, args__5587);
                                if(argc === 15) {
                                  if(f__5570.cljs$lang$arity$15) {
                                    return f__5570.cljs$lang$arity$15(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588)
                                  }else {
                                    return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588)
                                  }
                                }else {
                                  var p__5590 = cljs.core._first.call(null, args__5589);
                                  var args__5591 = cljs.core._rest.call(null, args__5589);
                                  if(argc === 16) {
                                    if(f__5570.cljs$lang$arity$16) {
                                      return f__5570.cljs$lang$arity$16(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590)
                                    }else {
                                      return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590)
                                    }
                                  }else {
                                    var q__5592 = cljs.core._first.call(null, args__5591);
                                    var args__5593 = cljs.core._rest.call(null, args__5591);
                                    if(argc === 17) {
                                      if(f__5570.cljs$lang$arity$17) {
                                        return f__5570.cljs$lang$arity$17(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592)
                                      }else {
                                        return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592)
                                      }
                                    }else {
                                      var r__5594 = cljs.core._first.call(null, args__5593);
                                      var args__5595 = cljs.core._rest.call(null, args__5593);
                                      if(argc === 18) {
                                        if(f__5570.cljs$lang$arity$18) {
                                          return f__5570.cljs$lang$arity$18(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592, r__5594)
                                        }else {
                                          return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592, r__5594)
                                        }
                                      }else {
                                        var s__5596 = cljs.core._first.call(null, args__5595);
                                        var args__5597 = cljs.core._rest.call(null, args__5595);
                                        if(argc === 19) {
                                          if(f__5570.cljs$lang$arity$19) {
                                            return f__5570.cljs$lang$arity$19(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592, r__5594, s__5596)
                                          }else {
                                            return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592, r__5594, s__5596)
                                          }
                                        }else {
                                          var t__5598 = cljs.core._first.call(null, args__5597);
                                          var args__5599 = cljs.core._rest.call(null, args__5597);
                                          if(argc === 20) {
                                            if(f__5570.cljs$lang$arity$20) {
                                              return f__5570.cljs$lang$arity$20(a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592, r__5594, s__5596, t__5598)
                                            }else {
                                              return f__5570.call(null, a__5560, b__5562, c__5564, d__5566, e__5568, f__5570, g__5572, h__5574, i__5576, j__5578, k__5580, l__5582, m__5584, n__5586, o__5588, p__5590, q__5592, r__5594, s__5596, t__5598)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5600 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5601 = cljs.core.bounded_count.call(null, args, fixed_arity__5600 + 1);
      if(bc__5601 <= fixed_arity__5600) {
        return cljs.core.apply_to.call(null, f, bc__5601, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5602 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5603 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5604 = cljs.core.bounded_count.call(null, arglist__5602, fixed_arity__5603 + 1);
      if(bc__5604 <= fixed_arity__5603) {
        return cljs.core.apply_to.call(null, f, bc__5604, arglist__5602)
      }else {
        return f.cljs$lang$applyTo(arglist__5602)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5602))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5605 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5606 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5607 = cljs.core.bounded_count.call(null, arglist__5605, fixed_arity__5606 + 1);
      if(bc__5607 <= fixed_arity__5606) {
        return cljs.core.apply_to.call(null, f, bc__5607, arglist__5605)
      }else {
        return f.cljs$lang$applyTo(arglist__5605)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5605))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5608 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5609 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5610 = cljs.core.bounded_count.call(null, arglist__5608, fixed_arity__5609 + 1);
      if(bc__5610 <= fixed_arity__5609) {
        return cljs.core.apply_to.call(null, f, bc__5610, arglist__5608)
      }else {
        return f.cljs$lang$applyTo(arglist__5608)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5608))
    }
  };
  var apply__6 = function() {
    var G__5614__delegate = function(f, a, b, c, d, args) {
      var arglist__5611 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5612 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5613 = cljs.core.bounded_count.call(null, arglist__5611, fixed_arity__5612 + 1);
        if(bc__5613 <= fixed_arity__5612) {
          return cljs.core.apply_to.call(null, f, bc__5613, arglist__5611)
        }else {
          return f.cljs$lang$applyTo(arglist__5611)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5611))
      }
    };
    var G__5614 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5614__delegate.call(this, f, a, b, c, d, args)
    };
    G__5614.cljs$lang$maxFixedArity = 5;
    G__5614.cljs$lang$applyTo = function(arglist__5615) {
      var f = cljs.core.first(arglist__5615);
      var a = cljs.core.first(cljs.core.next(arglist__5615));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5615)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5615))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5615)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5615)))));
      return G__5614__delegate(f, a, b, c, d, args)
    };
    G__5614.cljs$lang$arity$variadic = G__5614__delegate;
    return G__5614
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5616) {
    var obj = cljs.core.first(arglist__5616);
    var f = cljs.core.first(cljs.core.next(arglist__5616));
    var args = cljs.core.rest(cljs.core.next(arglist__5616));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5617__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5617 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5617__delegate.call(this, x, y, more)
    };
    G__5617.cljs$lang$maxFixedArity = 2;
    G__5617.cljs$lang$applyTo = function(arglist__5618) {
      var x = cljs.core.first(arglist__5618);
      var y = cljs.core.first(cljs.core.next(arglist__5618));
      var more = cljs.core.rest(cljs.core.next(arglist__5618));
      return G__5617__delegate(x, y, more)
    };
    G__5617.cljs$lang$arity$variadic = G__5617__delegate;
    return G__5617
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5619 = pred;
        var G__5620 = cljs.core.next.call(null, coll);
        pred = G__5619;
        coll = G__5620;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5621 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5621)) {
        return or__3548__auto____5621
      }else {
        var G__5622 = pred;
        var G__5623 = cljs.core.next.call(null, coll);
        pred = G__5622;
        coll = G__5623;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5624 = null;
    var G__5624__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5624__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5624__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5624__3 = function() {
      var G__5625__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5625 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5625__delegate.call(this, x, y, zs)
      };
      G__5625.cljs$lang$maxFixedArity = 2;
      G__5625.cljs$lang$applyTo = function(arglist__5626) {
        var x = cljs.core.first(arglist__5626);
        var y = cljs.core.first(cljs.core.next(arglist__5626));
        var zs = cljs.core.rest(cljs.core.next(arglist__5626));
        return G__5625__delegate(x, y, zs)
      };
      G__5625.cljs$lang$arity$variadic = G__5625__delegate;
      return G__5625
    }();
    G__5624 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5624__0.call(this);
        case 1:
          return G__5624__1.call(this, x);
        case 2:
          return G__5624__2.call(this, x, y);
        default:
          return G__5624__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5624.cljs$lang$maxFixedArity = 2;
    G__5624.cljs$lang$applyTo = G__5624__3.cljs$lang$applyTo;
    return G__5624
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5627__delegate = function(args) {
      return x
    };
    var G__5627 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5627__delegate.call(this, args)
    };
    G__5627.cljs$lang$maxFixedArity = 0;
    G__5627.cljs$lang$applyTo = function(arglist__5628) {
      var args = cljs.core.seq(arglist__5628);
      return G__5627__delegate(args)
    };
    G__5627.cljs$lang$arity$variadic = G__5627__delegate;
    return G__5627
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5632 = null;
      var G__5632__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5632__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5632__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5632__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5632__4 = function() {
        var G__5633__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5633 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5633__delegate.call(this, x, y, z, args)
        };
        G__5633.cljs$lang$maxFixedArity = 3;
        G__5633.cljs$lang$applyTo = function(arglist__5634) {
          var x = cljs.core.first(arglist__5634);
          var y = cljs.core.first(cljs.core.next(arglist__5634));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5634)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5634)));
          return G__5633__delegate(x, y, z, args)
        };
        G__5633.cljs$lang$arity$variadic = G__5633__delegate;
        return G__5633
      }();
      G__5632 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5632__0.call(this);
          case 1:
            return G__5632__1.call(this, x);
          case 2:
            return G__5632__2.call(this, x, y);
          case 3:
            return G__5632__3.call(this, x, y, z);
          default:
            return G__5632__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5632.cljs$lang$maxFixedArity = 3;
      G__5632.cljs$lang$applyTo = G__5632__4.cljs$lang$applyTo;
      return G__5632
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5635 = null;
      var G__5635__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5635__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5635__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5635__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5635__4 = function() {
        var G__5636__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5636 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5636__delegate.call(this, x, y, z, args)
        };
        G__5636.cljs$lang$maxFixedArity = 3;
        G__5636.cljs$lang$applyTo = function(arglist__5637) {
          var x = cljs.core.first(arglist__5637);
          var y = cljs.core.first(cljs.core.next(arglist__5637));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5637)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5637)));
          return G__5636__delegate(x, y, z, args)
        };
        G__5636.cljs$lang$arity$variadic = G__5636__delegate;
        return G__5636
      }();
      G__5635 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5635__0.call(this);
          case 1:
            return G__5635__1.call(this, x);
          case 2:
            return G__5635__2.call(this, x, y);
          case 3:
            return G__5635__3.call(this, x, y, z);
          default:
            return G__5635__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5635.cljs$lang$maxFixedArity = 3;
      G__5635.cljs$lang$applyTo = G__5635__4.cljs$lang$applyTo;
      return G__5635
    }()
  };
  var comp__4 = function() {
    var G__5638__delegate = function(f1, f2, f3, fs) {
      var fs__5629 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5639__delegate = function(args) {
          var ret__5630 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5629), args);
          var fs__5631 = cljs.core.next.call(null, fs__5629);
          while(true) {
            if(cljs.core.truth_(fs__5631)) {
              var G__5640 = cljs.core.first.call(null, fs__5631).call(null, ret__5630);
              var G__5641 = cljs.core.next.call(null, fs__5631);
              ret__5630 = G__5640;
              fs__5631 = G__5641;
              continue
            }else {
              return ret__5630
            }
            break
          }
        };
        var G__5639 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5639__delegate.call(this, args)
        };
        G__5639.cljs$lang$maxFixedArity = 0;
        G__5639.cljs$lang$applyTo = function(arglist__5642) {
          var args = cljs.core.seq(arglist__5642);
          return G__5639__delegate(args)
        };
        G__5639.cljs$lang$arity$variadic = G__5639__delegate;
        return G__5639
      }()
    };
    var G__5638 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5638__delegate.call(this, f1, f2, f3, fs)
    };
    G__5638.cljs$lang$maxFixedArity = 3;
    G__5638.cljs$lang$applyTo = function(arglist__5643) {
      var f1 = cljs.core.first(arglist__5643);
      var f2 = cljs.core.first(cljs.core.next(arglist__5643));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5643)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5643)));
      return G__5638__delegate(f1, f2, f3, fs)
    };
    G__5638.cljs$lang$arity$variadic = G__5638__delegate;
    return G__5638
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5644__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5644 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5644__delegate.call(this, args)
      };
      G__5644.cljs$lang$maxFixedArity = 0;
      G__5644.cljs$lang$applyTo = function(arglist__5645) {
        var args = cljs.core.seq(arglist__5645);
        return G__5644__delegate(args)
      };
      G__5644.cljs$lang$arity$variadic = G__5644__delegate;
      return G__5644
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5646__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5646 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5646__delegate.call(this, args)
      };
      G__5646.cljs$lang$maxFixedArity = 0;
      G__5646.cljs$lang$applyTo = function(arglist__5647) {
        var args = cljs.core.seq(arglist__5647);
        return G__5646__delegate(args)
      };
      G__5646.cljs$lang$arity$variadic = G__5646__delegate;
      return G__5646
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5648__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5648 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5648__delegate.call(this, args)
      };
      G__5648.cljs$lang$maxFixedArity = 0;
      G__5648.cljs$lang$applyTo = function(arglist__5649) {
        var args = cljs.core.seq(arglist__5649);
        return G__5648__delegate(args)
      };
      G__5648.cljs$lang$arity$variadic = G__5648__delegate;
      return G__5648
    }()
  };
  var partial__5 = function() {
    var G__5650__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5651__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5651 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5651__delegate.call(this, args)
        };
        G__5651.cljs$lang$maxFixedArity = 0;
        G__5651.cljs$lang$applyTo = function(arglist__5652) {
          var args = cljs.core.seq(arglist__5652);
          return G__5651__delegate(args)
        };
        G__5651.cljs$lang$arity$variadic = G__5651__delegate;
        return G__5651
      }()
    };
    var G__5650 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5650__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5650.cljs$lang$maxFixedArity = 4;
    G__5650.cljs$lang$applyTo = function(arglist__5653) {
      var f = cljs.core.first(arglist__5653);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5653));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5653)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5653))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5653))));
      return G__5650__delegate(f, arg1, arg2, arg3, more)
    };
    G__5650.cljs$lang$arity$variadic = G__5650__delegate;
    return G__5650
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5654 = null;
      var G__5654__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5654__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5654__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5654__4 = function() {
        var G__5655__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5655 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5655__delegate.call(this, a, b, c, ds)
        };
        G__5655.cljs$lang$maxFixedArity = 3;
        G__5655.cljs$lang$applyTo = function(arglist__5656) {
          var a = cljs.core.first(arglist__5656);
          var b = cljs.core.first(cljs.core.next(arglist__5656));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5656)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5656)));
          return G__5655__delegate(a, b, c, ds)
        };
        G__5655.cljs$lang$arity$variadic = G__5655__delegate;
        return G__5655
      }();
      G__5654 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5654__1.call(this, a);
          case 2:
            return G__5654__2.call(this, a, b);
          case 3:
            return G__5654__3.call(this, a, b, c);
          default:
            return G__5654__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5654.cljs$lang$maxFixedArity = 3;
      G__5654.cljs$lang$applyTo = G__5654__4.cljs$lang$applyTo;
      return G__5654
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5657 = null;
      var G__5657__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5657__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5657__4 = function() {
        var G__5658__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5658 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5658__delegate.call(this, a, b, c, ds)
        };
        G__5658.cljs$lang$maxFixedArity = 3;
        G__5658.cljs$lang$applyTo = function(arglist__5659) {
          var a = cljs.core.first(arglist__5659);
          var b = cljs.core.first(cljs.core.next(arglist__5659));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5659)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5659)));
          return G__5658__delegate(a, b, c, ds)
        };
        G__5658.cljs$lang$arity$variadic = G__5658__delegate;
        return G__5658
      }();
      G__5657 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5657__2.call(this, a, b);
          case 3:
            return G__5657__3.call(this, a, b, c);
          default:
            return G__5657__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5657.cljs$lang$maxFixedArity = 3;
      G__5657.cljs$lang$applyTo = G__5657__4.cljs$lang$applyTo;
      return G__5657
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5660 = null;
      var G__5660__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5660__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5660__4 = function() {
        var G__5661__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5661 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5661__delegate.call(this, a, b, c, ds)
        };
        G__5661.cljs$lang$maxFixedArity = 3;
        G__5661.cljs$lang$applyTo = function(arglist__5662) {
          var a = cljs.core.first(arglist__5662);
          var b = cljs.core.first(cljs.core.next(arglist__5662));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5662)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5662)));
          return G__5661__delegate(a, b, c, ds)
        };
        G__5661.cljs$lang$arity$variadic = G__5661__delegate;
        return G__5661
      }();
      G__5660 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5660__2.call(this, a, b);
          case 3:
            return G__5660__3.call(this, a, b, c);
          default:
            return G__5660__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5660.cljs$lang$maxFixedArity = 3;
      G__5660.cljs$lang$applyTo = G__5660__4.cljs$lang$applyTo;
      return G__5660
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5665 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5663 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5663)) {
        var s__5664 = temp__3698__auto____5663;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5664)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5664)))
      }else {
        return null
      }
    })
  };
  return mapi__5665.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5666 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5666)) {
      var s__5667 = temp__3698__auto____5666;
      var x__5668 = f.call(null, cljs.core.first.call(null, s__5667));
      if(x__5668 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5667))
      }else {
        return cljs.core.cons.call(null, x__5668, keep.call(null, f, cljs.core.rest.call(null, s__5667)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5678 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5675 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5675)) {
        var s__5676 = temp__3698__auto____5675;
        var x__5677 = f.call(null, idx, cljs.core.first.call(null, s__5676));
        if(x__5677 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5676))
        }else {
          return cljs.core.cons.call(null, x__5677, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5676)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5678.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5685 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5685)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5685
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5686 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5686)) {
            var and__3546__auto____5687 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5687)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5687
            }
          }else {
            return and__3546__auto____5686
          }
        }())
      };
      var ep1__4 = function() {
        var G__5723__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5688 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5688)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5688
            }
          }())
        };
        var G__5723 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5723__delegate.call(this, x, y, z, args)
        };
        G__5723.cljs$lang$maxFixedArity = 3;
        G__5723.cljs$lang$applyTo = function(arglist__5724) {
          var x = cljs.core.first(arglist__5724);
          var y = cljs.core.first(cljs.core.next(arglist__5724));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5724)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5724)));
          return G__5723__delegate(x, y, z, args)
        };
        G__5723.cljs$lang$arity$variadic = G__5723__delegate;
        return G__5723
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5689 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5689)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5689
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5690 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5690)) {
            var and__3546__auto____5691 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5691)) {
              var and__3546__auto____5692 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5692)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5692
              }
            }else {
              return and__3546__auto____5691
            }
          }else {
            return and__3546__auto____5690
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5693 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5693)) {
            var and__3546__auto____5694 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5694)) {
              var and__3546__auto____5695 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5695)) {
                var and__3546__auto____5696 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5696)) {
                  var and__3546__auto____5697 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5697)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5697
                  }
                }else {
                  return and__3546__auto____5696
                }
              }else {
                return and__3546__auto____5695
              }
            }else {
              return and__3546__auto____5694
            }
          }else {
            return and__3546__auto____5693
          }
        }())
      };
      var ep2__4 = function() {
        var G__5725__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5698 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5698)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5669_SHARP_) {
                var and__3546__auto____5699 = p1.call(null, p1__5669_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5699)) {
                  return p2.call(null, p1__5669_SHARP_)
                }else {
                  return and__3546__auto____5699
                }
              }, args)
            }else {
              return and__3546__auto____5698
            }
          }())
        };
        var G__5725 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5725__delegate.call(this, x, y, z, args)
        };
        G__5725.cljs$lang$maxFixedArity = 3;
        G__5725.cljs$lang$applyTo = function(arglist__5726) {
          var x = cljs.core.first(arglist__5726);
          var y = cljs.core.first(cljs.core.next(arglist__5726));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5726)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5726)));
          return G__5725__delegate(x, y, z, args)
        };
        G__5725.cljs$lang$arity$variadic = G__5725__delegate;
        return G__5725
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5700 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5700)) {
            var and__3546__auto____5701 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5701)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5701
            }
          }else {
            return and__3546__auto____5700
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5702 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5702)) {
            var and__3546__auto____5703 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5703)) {
              var and__3546__auto____5704 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5704)) {
                var and__3546__auto____5705 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5705)) {
                  var and__3546__auto____5706 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5706)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5706
                  }
                }else {
                  return and__3546__auto____5705
                }
              }else {
                return and__3546__auto____5704
              }
            }else {
              return and__3546__auto____5703
            }
          }else {
            return and__3546__auto____5702
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5707 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5707)) {
            var and__3546__auto____5708 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5708)) {
              var and__3546__auto____5709 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5709)) {
                var and__3546__auto____5710 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5710)) {
                  var and__3546__auto____5711 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5711)) {
                    var and__3546__auto____5712 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5712)) {
                      var and__3546__auto____5713 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5713)) {
                        var and__3546__auto____5714 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5714)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5714
                        }
                      }else {
                        return and__3546__auto____5713
                      }
                    }else {
                      return and__3546__auto____5712
                    }
                  }else {
                    return and__3546__auto____5711
                  }
                }else {
                  return and__3546__auto____5710
                }
              }else {
                return and__3546__auto____5709
              }
            }else {
              return and__3546__auto____5708
            }
          }else {
            return and__3546__auto____5707
          }
        }())
      };
      var ep3__4 = function() {
        var G__5727__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5715 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5715)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5670_SHARP_) {
                var and__3546__auto____5716 = p1.call(null, p1__5670_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5716)) {
                  var and__3546__auto____5717 = p2.call(null, p1__5670_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5717)) {
                    return p3.call(null, p1__5670_SHARP_)
                  }else {
                    return and__3546__auto____5717
                  }
                }else {
                  return and__3546__auto____5716
                }
              }, args)
            }else {
              return and__3546__auto____5715
            }
          }())
        };
        var G__5727 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5727__delegate.call(this, x, y, z, args)
        };
        G__5727.cljs$lang$maxFixedArity = 3;
        G__5727.cljs$lang$applyTo = function(arglist__5728) {
          var x = cljs.core.first(arglist__5728);
          var y = cljs.core.first(cljs.core.next(arglist__5728));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5728)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5728)));
          return G__5727__delegate(x, y, z, args)
        };
        G__5727.cljs$lang$arity$variadic = G__5727__delegate;
        return G__5727
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5729__delegate = function(p1, p2, p3, ps) {
      var ps__5718 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5671_SHARP_) {
            return p1__5671_SHARP_.call(null, x)
          }, ps__5718)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5672_SHARP_) {
            var and__3546__auto____5719 = p1__5672_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5719)) {
              return p1__5672_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5719
            }
          }, ps__5718)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5673_SHARP_) {
            var and__3546__auto____5720 = p1__5673_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5720)) {
              var and__3546__auto____5721 = p1__5673_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5721)) {
                return p1__5673_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5721
              }
            }else {
              return and__3546__auto____5720
            }
          }, ps__5718)
        };
        var epn__4 = function() {
          var G__5730__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5722 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5722)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5674_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5674_SHARP_, args)
                }, ps__5718)
              }else {
                return and__3546__auto____5722
              }
            }())
          };
          var G__5730 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5730__delegate.call(this, x, y, z, args)
          };
          G__5730.cljs$lang$maxFixedArity = 3;
          G__5730.cljs$lang$applyTo = function(arglist__5731) {
            var x = cljs.core.first(arglist__5731);
            var y = cljs.core.first(cljs.core.next(arglist__5731));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5731)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5731)));
            return G__5730__delegate(x, y, z, args)
          };
          G__5730.cljs$lang$arity$variadic = G__5730__delegate;
          return G__5730
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5729 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5729__delegate.call(this, p1, p2, p3, ps)
    };
    G__5729.cljs$lang$maxFixedArity = 3;
    G__5729.cljs$lang$applyTo = function(arglist__5732) {
      var p1 = cljs.core.first(arglist__5732);
      var p2 = cljs.core.first(cljs.core.next(arglist__5732));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5732)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5732)));
      return G__5729__delegate(p1, p2, p3, ps)
    };
    G__5729.cljs$lang$arity$variadic = G__5729__delegate;
    return G__5729
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5734 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5734)) {
          return or__3548__auto____5734
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5735 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5735)) {
          return or__3548__auto____5735
        }else {
          var or__3548__auto____5736 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5736)) {
            return or__3548__auto____5736
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5772__delegate = function(x, y, z, args) {
          var or__3548__auto____5737 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5737)) {
            return or__3548__auto____5737
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5772 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5772__delegate.call(this, x, y, z, args)
        };
        G__5772.cljs$lang$maxFixedArity = 3;
        G__5772.cljs$lang$applyTo = function(arglist__5773) {
          var x = cljs.core.first(arglist__5773);
          var y = cljs.core.first(cljs.core.next(arglist__5773));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5773)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5773)));
          return G__5772__delegate(x, y, z, args)
        };
        G__5772.cljs$lang$arity$variadic = G__5772__delegate;
        return G__5772
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5738 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5738)) {
          return or__3548__auto____5738
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5739 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5739)) {
          return or__3548__auto____5739
        }else {
          var or__3548__auto____5740 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5740)) {
            return or__3548__auto____5740
          }else {
            var or__3548__auto____5741 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5741)) {
              return or__3548__auto____5741
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5742 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5742)) {
          return or__3548__auto____5742
        }else {
          var or__3548__auto____5743 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5743)) {
            return or__3548__auto____5743
          }else {
            var or__3548__auto____5744 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5744)) {
              return or__3548__auto____5744
            }else {
              var or__3548__auto____5745 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5745)) {
                return or__3548__auto____5745
              }else {
                var or__3548__auto____5746 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5746)) {
                  return or__3548__auto____5746
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5774__delegate = function(x, y, z, args) {
          var or__3548__auto____5747 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5747)) {
            return or__3548__auto____5747
          }else {
            return cljs.core.some.call(null, function(p1__5679_SHARP_) {
              var or__3548__auto____5748 = p1.call(null, p1__5679_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5748)) {
                return or__3548__auto____5748
              }else {
                return p2.call(null, p1__5679_SHARP_)
              }
            }, args)
          }
        };
        var G__5774 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5774__delegate.call(this, x, y, z, args)
        };
        G__5774.cljs$lang$maxFixedArity = 3;
        G__5774.cljs$lang$applyTo = function(arglist__5775) {
          var x = cljs.core.first(arglist__5775);
          var y = cljs.core.first(cljs.core.next(arglist__5775));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5775)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5775)));
          return G__5774__delegate(x, y, z, args)
        };
        G__5774.cljs$lang$arity$variadic = G__5774__delegate;
        return G__5774
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5749 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5749)) {
          return or__3548__auto____5749
        }else {
          var or__3548__auto____5750 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5750)) {
            return or__3548__auto____5750
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5751 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5751)) {
          return or__3548__auto____5751
        }else {
          var or__3548__auto____5752 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5752)) {
            return or__3548__auto____5752
          }else {
            var or__3548__auto____5753 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5753)) {
              return or__3548__auto____5753
            }else {
              var or__3548__auto____5754 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5754)) {
                return or__3548__auto____5754
              }else {
                var or__3548__auto____5755 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5755)) {
                  return or__3548__auto____5755
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5756 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5756)) {
          return or__3548__auto____5756
        }else {
          var or__3548__auto____5757 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5757)) {
            return or__3548__auto____5757
          }else {
            var or__3548__auto____5758 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5758)) {
              return or__3548__auto____5758
            }else {
              var or__3548__auto____5759 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5759)) {
                return or__3548__auto____5759
              }else {
                var or__3548__auto____5760 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5760)) {
                  return or__3548__auto____5760
                }else {
                  var or__3548__auto____5761 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5761)) {
                    return or__3548__auto____5761
                  }else {
                    var or__3548__auto____5762 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5762)) {
                      return or__3548__auto____5762
                    }else {
                      var or__3548__auto____5763 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5763)) {
                        return or__3548__auto____5763
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5776__delegate = function(x, y, z, args) {
          var or__3548__auto____5764 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5764)) {
            return or__3548__auto____5764
          }else {
            return cljs.core.some.call(null, function(p1__5680_SHARP_) {
              var or__3548__auto____5765 = p1.call(null, p1__5680_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5765)) {
                return or__3548__auto____5765
              }else {
                var or__3548__auto____5766 = p2.call(null, p1__5680_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5766)) {
                  return or__3548__auto____5766
                }else {
                  return p3.call(null, p1__5680_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5776 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5776__delegate.call(this, x, y, z, args)
        };
        G__5776.cljs$lang$maxFixedArity = 3;
        G__5776.cljs$lang$applyTo = function(arglist__5777) {
          var x = cljs.core.first(arglist__5777);
          var y = cljs.core.first(cljs.core.next(arglist__5777));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5777)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5777)));
          return G__5776__delegate(x, y, z, args)
        };
        G__5776.cljs$lang$arity$variadic = G__5776__delegate;
        return G__5776
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5778__delegate = function(p1, p2, p3, ps) {
      var ps__5767 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5681_SHARP_) {
            return p1__5681_SHARP_.call(null, x)
          }, ps__5767)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5682_SHARP_) {
            var or__3548__auto____5768 = p1__5682_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5768)) {
              return or__3548__auto____5768
            }else {
              return p1__5682_SHARP_.call(null, y)
            }
          }, ps__5767)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5683_SHARP_) {
            var or__3548__auto____5769 = p1__5683_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5769)) {
              return or__3548__auto____5769
            }else {
              var or__3548__auto____5770 = p1__5683_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5770)) {
                return or__3548__auto____5770
              }else {
                return p1__5683_SHARP_.call(null, z)
              }
            }
          }, ps__5767)
        };
        var spn__4 = function() {
          var G__5779__delegate = function(x, y, z, args) {
            var or__3548__auto____5771 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5771)) {
              return or__3548__auto____5771
            }else {
              return cljs.core.some.call(null, function(p1__5684_SHARP_) {
                return cljs.core.some.call(null, p1__5684_SHARP_, args)
              }, ps__5767)
            }
          };
          var G__5779 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5779__delegate.call(this, x, y, z, args)
          };
          G__5779.cljs$lang$maxFixedArity = 3;
          G__5779.cljs$lang$applyTo = function(arglist__5780) {
            var x = cljs.core.first(arglist__5780);
            var y = cljs.core.first(cljs.core.next(arglist__5780));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5780)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5780)));
            return G__5779__delegate(x, y, z, args)
          };
          G__5779.cljs$lang$arity$variadic = G__5779__delegate;
          return G__5779
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5778 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5778__delegate.call(this, p1, p2, p3, ps)
    };
    G__5778.cljs$lang$maxFixedArity = 3;
    G__5778.cljs$lang$applyTo = function(arglist__5781) {
      var p1 = cljs.core.first(arglist__5781);
      var p2 = cljs.core.first(cljs.core.next(arglist__5781));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5781)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5781)));
      return G__5778__delegate(p1, p2, p3, ps)
    };
    G__5778.cljs$lang$arity$variadic = G__5778__delegate;
    return G__5778
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5782 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5782)) {
        var s__5783 = temp__3698__auto____5782;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5783)), map.call(null, f, cljs.core.rest.call(null, s__5783)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5784 = cljs.core.seq.call(null, c1);
      var s2__5785 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5786 = s1__5784;
        if(cljs.core.truth_(and__3546__auto____5786)) {
          return s2__5785
        }else {
          return and__3546__auto____5786
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5784), cljs.core.first.call(null, s2__5785)), map.call(null, f, cljs.core.rest.call(null, s1__5784), cljs.core.rest.call(null, s2__5785)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5787 = cljs.core.seq.call(null, c1);
      var s2__5788 = cljs.core.seq.call(null, c2);
      var s3__5789 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5790 = s1__5787;
        if(cljs.core.truth_(and__3546__auto____5790)) {
          var and__3546__auto____5791 = s2__5788;
          if(cljs.core.truth_(and__3546__auto____5791)) {
            return s3__5789
          }else {
            return and__3546__auto____5791
          }
        }else {
          return and__3546__auto____5790
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5787), cljs.core.first.call(null, s2__5788), cljs.core.first.call(null, s3__5789)), map.call(null, f, cljs.core.rest.call(null, s1__5787), cljs.core.rest.call(null, s2__5788), cljs.core.rest.call(null, s3__5789)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5794__delegate = function(f, c1, c2, c3, colls) {
      var step__5793 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5792 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5792)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5792), step.call(null, map.call(null, cljs.core.rest, ss__5792)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5733_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5733_SHARP_)
      }, step__5793.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5794 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5794__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5794.cljs$lang$maxFixedArity = 4;
    G__5794.cljs$lang$applyTo = function(arglist__5795) {
      var f = cljs.core.first(arglist__5795);
      var c1 = cljs.core.first(cljs.core.next(arglist__5795));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5795)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5795))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5795))));
      return G__5794__delegate(f, c1, c2, c3, colls)
    };
    G__5794.cljs$lang$arity$variadic = G__5794__delegate;
    return G__5794
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5796 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5796)) {
        var s__5797 = temp__3698__auto____5796;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5797), take.call(null, n - 1, cljs.core.rest.call(null, s__5797)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5800 = function(n, coll) {
    while(true) {
      var s__5798 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5799 = n > 0;
        if(and__3546__auto____5799) {
          return s__5798
        }else {
          return and__3546__auto____5799
        }
      }())) {
        var G__5801 = n - 1;
        var G__5802 = cljs.core.rest.call(null, s__5798);
        n = G__5801;
        coll = G__5802;
        continue
      }else {
        return s__5798
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5800.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5803 = cljs.core.seq.call(null, coll);
  var lead__5804 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5804)) {
      var G__5805 = cljs.core.next.call(null, s__5803);
      var G__5806 = cljs.core.next.call(null, lead__5804);
      s__5803 = G__5805;
      lead__5804 = G__5806;
      continue
    }else {
      return s__5803
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5809 = function(pred, coll) {
    while(true) {
      var s__5807 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5808 = s__5807;
        if(cljs.core.truth_(and__3546__auto____5808)) {
          return pred.call(null, cljs.core.first.call(null, s__5807))
        }else {
          return and__3546__auto____5808
        }
      }())) {
        var G__5810 = pred;
        var G__5811 = cljs.core.rest.call(null, s__5807);
        pred = G__5810;
        coll = G__5811;
        continue
      }else {
        return s__5807
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5809.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5812 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5812)) {
      var s__5813 = temp__3698__auto____5812;
      return cljs.core.concat.call(null, s__5813, cycle.call(null, s__5813))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5814 = cljs.core.seq.call(null, c1);
      var s2__5815 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5816 = s1__5814;
        if(cljs.core.truth_(and__3546__auto____5816)) {
          return s2__5815
        }else {
          return and__3546__auto____5816
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5814), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5815), interleave.call(null, cljs.core.rest.call(null, s1__5814), cljs.core.rest.call(null, s2__5815))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5818__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5817 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5817)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5817), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5817)))
        }else {
          return null
        }
      })
    };
    var G__5818 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5818__delegate.call(this, c1, c2, colls)
    };
    G__5818.cljs$lang$maxFixedArity = 2;
    G__5818.cljs$lang$applyTo = function(arglist__5819) {
      var c1 = cljs.core.first(arglist__5819);
      var c2 = cljs.core.first(cljs.core.next(arglist__5819));
      var colls = cljs.core.rest(cljs.core.next(arglist__5819));
      return G__5818__delegate(c1, c2, colls)
    };
    G__5818.cljs$lang$arity$variadic = G__5818__delegate;
    return G__5818
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5822 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5820 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5820)) {
        var coll__5821 = temp__3695__auto____5820;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5821), cat.call(null, cljs.core.rest.call(null, coll__5821), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5822.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5823__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5823 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5823__delegate.call(this, f, coll, colls)
    };
    G__5823.cljs$lang$maxFixedArity = 2;
    G__5823.cljs$lang$applyTo = function(arglist__5824) {
      var f = cljs.core.first(arglist__5824);
      var coll = cljs.core.first(cljs.core.next(arglist__5824));
      var colls = cljs.core.rest(cljs.core.next(arglist__5824));
      return G__5823__delegate(f, coll, colls)
    };
    G__5823.cljs$lang$arity$variadic = G__5823__delegate;
    return G__5823
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5825 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5825)) {
      var s__5826 = temp__3698__auto____5825;
      var f__5827 = cljs.core.first.call(null, s__5826);
      var r__5828 = cljs.core.rest.call(null, s__5826);
      if(cljs.core.truth_(pred.call(null, f__5827))) {
        return cljs.core.cons.call(null, f__5827, filter.call(null, pred, r__5828))
      }else {
        return filter.call(null, pred, r__5828)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5830 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5830.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5829_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5829_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5831__5832 = to;
    if(G__5831__5832 != null) {
      if(function() {
        var or__3548__auto____5833 = G__5831__5832.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5833) {
          return or__3548__auto____5833
        }else {
          return G__5831__5832.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5831__5832.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5831__5832)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5831__5832)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5834__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5834 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5834__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5834.cljs$lang$maxFixedArity = 4;
    G__5834.cljs$lang$applyTo = function(arglist__5835) {
      var f = cljs.core.first(arglist__5835);
      var c1 = cljs.core.first(cljs.core.next(arglist__5835));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5835)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5835))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5835))));
      return G__5834__delegate(f, c1, c2, c3, colls)
    };
    G__5834.cljs$lang$arity$variadic = G__5834__delegate;
    return G__5834
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5836 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5836)) {
        var s__5837 = temp__3698__auto____5836;
        var p__5838 = cljs.core.take.call(null, n, s__5837);
        if(n === cljs.core.count.call(null, p__5838)) {
          return cljs.core.cons.call(null, p__5838, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5837)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5839 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5839)) {
        var s__5840 = temp__3698__auto____5839;
        var p__5841 = cljs.core.take.call(null, n, s__5840);
        if(n === cljs.core.count.call(null, p__5841)) {
          return cljs.core.cons.call(null, p__5841, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5840)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5841, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5842 = cljs.core.lookup_sentinel;
    var m__5843 = m;
    var ks__5844 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5844)) {
        var m__5845 = cljs.core.get.call(null, m__5843, cljs.core.first.call(null, ks__5844), sentinel__5842);
        if(sentinel__5842 === m__5845) {
          return not_found
        }else {
          var G__5846 = sentinel__5842;
          var G__5847 = m__5845;
          var G__5848 = cljs.core.next.call(null, ks__5844);
          sentinel__5842 = G__5846;
          m__5843 = G__5847;
          ks__5844 = G__5848;
          continue
        }
      }else {
        return m__5843
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5849, v) {
  var vec__5850__5851 = p__5849;
  var k__5852 = cljs.core.nth.call(null, vec__5850__5851, 0, null);
  var ks__5853 = cljs.core.nthnext.call(null, vec__5850__5851, 1);
  if(cljs.core.truth_(ks__5853)) {
    return cljs.core.assoc.call(null, m, k__5852, assoc_in.call(null, cljs.core.get.call(null, m, k__5852), ks__5853, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5852, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5854, f, args) {
    var vec__5855__5856 = p__5854;
    var k__5857 = cljs.core.nth.call(null, vec__5855__5856, 0, null);
    var ks__5858 = cljs.core.nthnext.call(null, vec__5855__5856, 1);
    if(cljs.core.truth_(ks__5858)) {
      return cljs.core.assoc.call(null, m, k__5857, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5857), ks__5858, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5857, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5857), args))
    }
  };
  var update_in = function(m, p__5854, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5854, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5859) {
    var m = cljs.core.first(arglist__5859);
    var p__5854 = cljs.core.first(cljs.core.next(arglist__5859));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5859)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5859)));
    return update_in__delegate(m, p__5854, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5864 = this;
  var h__364__auto____5865 = this__5864.__hash;
  if(h__364__auto____5865 != null) {
    return h__364__auto____5865
  }else {
    var h__364__auto____5866 = cljs.core.hash_coll.call(null, coll);
    this__5864.__hash = h__364__auto____5866;
    return h__364__auto____5866
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5867 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5868 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5869 = this;
  var new_array__5870 = cljs.core.aclone.call(null, this__5869.array);
  new_array__5870[k] = v;
  return new cljs.core.Vector(this__5869.meta, new_array__5870, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5899 = null;
  var G__5899__2 = function(tsym5862, k) {
    var this__5871 = this;
    var tsym5862__5872 = this;
    var coll__5873 = tsym5862__5872;
    return cljs.core._lookup.call(null, coll__5873, k)
  };
  var G__5899__3 = function(tsym5863, k, not_found) {
    var this__5874 = this;
    var tsym5863__5875 = this;
    var coll__5876 = tsym5863__5875;
    return cljs.core._lookup.call(null, coll__5876, k, not_found)
  };
  G__5899 = function(tsym5863, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5899__2.call(this, tsym5863, k);
      case 3:
        return G__5899__3.call(this, tsym5863, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5899
}();
cljs.core.Vector.prototype.apply = function(tsym5860, args5861) {
  return tsym5860.call.apply(tsym5860, [tsym5860].concat(cljs.core.aclone.call(null, args5861)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5877 = this;
  var new_array__5878 = cljs.core.aclone.call(null, this__5877.array);
  new_array__5878.push(o);
  return new cljs.core.Vector(this__5877.meta, new_array__5878, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5879 = this;
  var this$__5880 = this;
  return cljs.core.pr_str.call(null, this$__5880)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5881 = this;
  return cljs.core.ci_reduce.call(null, this__5881.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5882 = this;
  return cljs.core.ci_reduce.call(null, this__5882.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5883 = this;
  if(this__5883.array.length > 0) {
    var vector_seq__5884 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5883.array.length) {
          return cljs.core.cons.call(null, this__5883.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5884.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5885 = this;
  return this__5885.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5886 = this;
  var count__5887 = this__5886.array.length;
  if(count__5887 > 0) {
    return this__5886.array[count__5887 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5888 = this;
  if(this__5888.array.length > 0) {
    var new_array__5889 = cljs.core.aclone.call(null, this__5888.array);
    new_array__5889.pop();
    return new cljs.core.Vector(this__5888.meta, new_array__5889, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5890 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5891 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5892 = this;
  return new cljs.core.Vector(meta, this__5892.array, this__5892.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5893 = this;
  return this__5893.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5895 = this;
  if(function() {
    var and__3546__auto____5896 = 0 <= n;
    if(and__3546__auto____5896) {
      return n < this__5895.array.length
    }else {
      return and__3546__auto____5896
    }
  }()) {
    return this__5895.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5897 = this;
  if(function() {
    var and__3546__auto____5898 = 0 <= n;
    if(and__3546__auto____5898) {
      return n < this__5897.array.length
    }else {
      return and__3546__auto____5898
    }
  }()) {
    return this__5897.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5894 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5894.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5900 = pv.cnt;
  if(cnt__5900 < 32) {
    return 0
  }else {
    return cnt__5900 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5901 = level;
  var ret__5902 = node;
  while(true) {
    if(ll__5901 === 0) {
      return ret__5902
    }else {
      var embed__5903 = ret__5902;
      var r__5904 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5905 = cljs.core.pv_aset.call(null, r__5904, 0, embed__5903);
      var G__5906 = ll__5901 - 5;
      var G__5907 = r__5904;
      ll__5901 = G__5906;
      ret__5902 = G__5907;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5908 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5909 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5908, subidx__5909, tailnode);
    return ret__5908
  }else {
    var temp__3695__auto____5910 = cljs.core.pv_aget.call(null, parent, subidx__5909);
    if(cljs.core.truth_(temp__3695__auto____5910)) {
      var child__5911 = temp__3695__auto____5910;
      var node_to_insert__5912 = push_tail.call(null, pv, level - 5, child__5911, tailnode);
      cljs.core.pv_aset.call(null, ret__5908, subidx__5909, node_to_insert__5912);
      return ret__5908
    }else {
      var node_to_insert__5913 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5908, subidx__5909, node_to_insert__5913);
      return ret__5908
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5914 = 0 <= i;
    if(and__3546__auto____5914) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5914
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5915 = pv.root;
      var level__5916 = pv.shift;
      while(true) {
        if(level__5916 > 0) {
          var G__5917 = cljs.core.pv_aget.call(null, node__5915, i >>> level__5916 & 31);
          var G__5918 = level__5916 - 5;
          node__5915 = G__5917;
          level__5916 = G__5918;
          continue
        }else {
          return node__5915.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5919 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5919, i & 31, val);
    return ret__5919
  }else {
    var subidx__5920 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5919, subidx__5920, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5920), i, val));
    return ret__5919
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5921 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5922 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5921));
    if(function() {
      var and__3546__auto____5923 = new_child__5922 == null;
      if(and__3546__auto____5923) {
        return subidx__5921 === 0
      }else {
        return and__3546__auto____5923
      }
    }()) {
      return null
    }else {
      var ret__5924 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5924, subidx__5921, new_child__5922);
      return ret__5924
    }
  }else {
    if(subidx__5921 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5925 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5925, subidx__5921, null);
        return ret__5925
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5926 = cljs.core._count.call(null, v);
  if(c__5926 > 0) {
    if(void 0 === cljs.core.t5927) {
      cljs.core.t5927 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5927.cljs$lang$type = true;
      cljs.core.t5927.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5927")
      };
      cljs.core.t5927.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5927.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5928 = this;
        return vseq
      };
      cljs.core.t5927.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5927.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5929 = this;
        return cljs.core._nth.call(null, this__5929.v, this__5929.offset)
      };
      cljs.core.t5927.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5930 = this;
        var offset__5931 = this__5930.offset + 1;
        if(offset__5931 < this__5930.c) {
          return this__5930.vector_seq.call(null, this__5930.v, offset__5931)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5927.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5927.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5927.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5932 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5927.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5927.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5927.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5933 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5927.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5927.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5934 = this;
        return this__5934.__meta__389__auto__
      };
      cljs.core.t5927.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5927.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5935 = this;
        return new cljs.core.t5927(this__5935.c, this__5935.offset, this__5935.v, this__5935.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5927
    }else {
    }
    return new cljs.core.t5927(c__5926, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5940 = this;
  return new cljs.core.TransientVector(this__5940.cnt, this__5940.shift, cljs.core.tv_editable_root.call(null, this__5940.root), cljs.core.tv_editable_tail.call(null, this__5940.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5941 = this;
  var h__364__auto____5942 = this__5941.__hash;
  if(h__364__auto____5942 != null) {
    return h__364__auto____5942
  }else {
    var h__364__auto____5943 = cljs.core.hash_coll.call(null, coll);
    this__5941.__hash = h__364__auto____5943;
    return h__364__auto____5943
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5944 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5945 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5946 = this;
  if(function() {
    var and__3546__auto____5947 = 0 <= k;
    if(and__3546__auto____5947) {
      return k < this__5946.cnt
    }else {
      return and__3546__auto____5947
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5948 = cljs.core.aclone.call(null, this__5946.tail);
      new_tail__5948[k & 31] = v;
      return new cljs.core.PersistentVector(this__5946.meta, this__5946.cnt, this__5946.shift, this__5946.root, new_tail__5948, null)
    }else {
      return new cljs.core.PersistentVector(this__5946.meta, this__5946.cnt, this__5946.shift, cljs.core.do_assoc.call(null, coll, this__5946.shift, this__5946.root, k, v), this__5946.tail, null)
    }
  }else {
    if(k === this__5946.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5946.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5993 = null;
  var G__5993__2 = function(tsym5938, k) {
    var this__5949 = this;
    var tsym5938__5950 = this;
    var coll__5951 = tsym5938__5950;
    return cljs.core._lookup.call(null, coll__5951, k)
  };
  var G__5993__3 = function(tsym5939, k, not_found) {
    var this__5952 = this;
    var tsym5939__5953 = this;
    var coll__5954 = tsym5939__5953;
    return cljs.core._lookup.call(null, coll__5954, k, not_found)
  };
  G__5993 = function(tsym5939, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5993__2.call(this, tsym5939, k);
      case 3:
        return G__5993__3.call(this, tsym5939, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5993
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5936, args5937) {
  return tsym5936.call.apply(tsym5936, [tsym5936].concat(cljs.core.aclone.call(null, args5937)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5955 = this;
  var step_init__5956 = [0, init];
  var i__5957 = 0;
  while(true) {
    if(i__5957 < this__5955.cnt) {
      var arr__5958 = cljs.core.array_for.call(null, v, i__5957);
      var len__5959 = arr__5958.length;
      var init__5963 = function() {
        var j__5960 = 0;
        var init__5961 = step_init__5956[1];
        while(true) {
          if(j__5960 < len__5959) {
            var init__5962 = f.call(null, init__5961, j__5960 + i__5957, arr__5958[j__5960]);
            if(cljs.core.reduced_QMARK_.call(null, init__5962)) {
              return init__5962
            }else {
              var G__5994 = j__5960 + 1;
              var G__5995 = init__5962;
              j__5960 = G__5994;
              init__5961 = G__5995;
              continue
            }
          }else {
            step_init__5956[0] = len__5959;
            step_init__5956[1] = init__5961;
            return init__5961
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5963)) {
        return cljs.core.deref.call(null, init__5963)
      }else {
        var G__5996 = i__5957 + step_init__5956[0];
        i__5957 = G__5996;
        continue
      }
    }else {
      return step_init__5956[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5964 = this;
  if(this__5964.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5965 = cljs.core.aclone.call(null, this__5964.tail);
    new_tail__5965.push(o);
    return new cljs.core.PersistentVector(this__5964.meta, this__5964.cnt + 1, this__5964.shift, this__5964.root, new_tail__5965, null)
  }else {
    var root_overflow_QMARK___5966 = this__5964.cnt >>> 5 > 1 << this__5964.shift;
    var new_shift__5967 = root_overflow_QMARK___5966 ? this__5964.shift + 5 : this__5964.shift;
    var new_root__5969 = root_overflow_QMARK___5966 ? function() {
      var n_r__5968 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5968, 0, this__5964.root);
      cljs.core.pv_aset.call(null, n_r__5968, 1, cljs.core.new_path.call(null, null, this__5964.shift, new cljs.core.VectorNode(null, this__5964.tail)));
      return n_r__5968
    }() : cljs.core.push_tail.call(null, coll, this__5964.shift, this__5964.root, new cljs.core.VectorNode(null, this__5964.tail));
    return new cljs.core.PersistentVector(this__5964.meta, this__5964.cnt + 1, new_shift__5967, new_root__5969, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5970 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5971 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5972 = this;
  var this$__5973 = this;
  return cljs.core.pr_str.call(null, this$__5973)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5974 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5975 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5976 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5977 = this;
  return this__5977.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5978 = this;
  if(this__5978.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5978.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5979 = this;
  if(this__5979.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5979.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5979.meta)
    }else {
      if(1 < this__5979.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5979.meta, this__5979.cnt - 1, this__5979.shift, this__5979.root, this__5979.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5980 = cljs.core.array_for.call(null, coll, this__5979.cnt - 2);
          var nr__5981 = cljs.core.pop_tail.call(null, coll, this__5979.shift, this__5979.root);
          var new_root__5982 = nr__5981 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5981;
          var cnt_1__5983 = this__5979.cnt - 1;
          if(function() {
            var and__3546__auto____5984 = 5 < this__5979.shift;
            if(and__3546__auto____5984) {
              return cljs.core.pv_aget.call(null, new_root__5982, 1) == null
            }else {
              return and__3546__auto____5984
            }
          }()) {
            return new cljs.core.PersistentVector(this__5979.meta, cnt_1__5983, this__5979.shift - 5, cljs.core.pv_aget.call(null, new_root__5982, 0), new_tail__5980, null)
          }else {
            return new cljs.core.PersistentVector(this__5979.meta, cnt_1__5983, this__5979.shift, new_root__5982, new_tail__5980, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5986 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5987 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5988 = this;
  return new cljs.core.PersistentVector(meta, this__5988.cnt, this__5988.shift, this__5988.root, this__5988.tail, this__5988.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5989 = this;
  return this__5989.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5990 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5991 = this;
  if(function() {
    var and__3546__auto____5992 = 0 <= n;
    if(and__3546__auto____5992) {
      return n < this__5991.cnt
    }else {
      return and__3546__auto____5992
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5985 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5985.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5997 = cljs.core.seq.call(null, xs);
  var out__5998 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5997)) {
      var G__5999 = cljs.core.next.call(null, xs__5997);
      var G__6000 = cljs.core.conj_BANG_.call(null, out__5998, cljs.core.first.call(null, xs__5997));
      xs__5997 = G__5999;
      out__5998 = G__6000;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5998)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__6001) {
    var args = cljs.core.seq(arglist__6001);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6006 = this;
  var h__364__auto____6007 = this__6006.__hash;
  if(h__364__auto____6007 != null) {
    return h__364__auto____6007
  }else {
    var h__364__auto____6008 = cljs.core.hash_coll.call(null, coll);
    this__6006.__hash = h__364__auto____6008;
    return h__364__auto____6008
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6009 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6010 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__6011 = this;
  var v_pos__6012 = this__6011.start + key;
  return new cljs.core.Subvec(this__6011.meta, cljs.core._assoc.call(null, this__6011.v, v_pos__6012, val), this__6011.start, this__6011.end > v_pos__6012 + 1 ? this__6011.end : v_pos__6012 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__6036 = null;
  var G__6036__2 = function(tsym6004, k) {
    var this__6013 = this;
    var tsym6004__6014 = this;
    var coll__6015 = tsym6004__6014;
    return cljs.core._lookup.call(null, coll__6015, k)
  };
  var G__6036__3 = function(tsym6005, k, not_found) {
    var this__6016 = this;
    var tsym6005__6017 = this;
    var coll__6018 = tsym6005__6017;
    return cljs.core._lookup.call(null, coll__6018, k, not_found)
  };
  G__6036 = function(tsym6005, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6036__2.call(this, tsym6005, k);
      case 3:
        return G__6036__3.call(this, tsym6005, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6036
}();
cljs.core.Subvec.prototype.apply = function(tsym6002, args6003) {
  return tsym6002.call.apply(tsym6002, [tsym6002].concat(cljs.core.aclone.call(null, args6003)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6019 = this;
  return new cljs.core.Subvec(this__6019.meta, cljs.core._assoc_n.call(null, this__6019.v, this__6019.end, o), this__6019.start, this__6019.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__6020 = this;
  var this$__6021 = this;
  return cljs.core.pr_str.call(null, this$__6021)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__6022 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__6023 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6024 = this;
  var subvec_seq__6025 = function subvec_seq(i) {
    if(i === this__6024.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__6024.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__6025.call(null, this__6024.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6026 = this;
  return this__6026.end - this__6026.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6027 = this;
  return cljs.core._nth.call(null, this__6027.v, this__6027.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6028 = this;
  if(this__6028.start === this__6028.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__6028.meta, this__6028.v, this__6028.start, this__6028.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__6029 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6030 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6031 = this;
  return new cljs.core.Subvec(meta, this__6031.v, this__6031.start, this__6031.end, this__6031.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6032 = this;
  return this__6032.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6034 = this;
  return cljs.core._nth.call(null, this__6034.v, this__6034.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6035 = this;
  return cljs.core._nth.call(null, this__6035.v, this__6035.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6033 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__6033.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__6037 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__6037, 0, tl.length);
  return ret__6037
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__6038 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__6039 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__6038, subidx__6039, level === 5 ? tail_node : function() {
    var child__6040 = cljs.core.pv_aget.call(null, ret__6038, subidx__6039);
    if(child__6040 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__6040, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__6038
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__6041 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__6042 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__6043 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__6041, subidx__6042));
    if(function() {
      var and__3546__auto____6044 = new_child__6043 == null;
      if(and__3546__auto____6044) {
        return subidx__6042 === 0
      }else {
        return and__3546__auto____6044
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__6041, subidx__6042, new_child__6043);
      return node__6041
    }
  }else {
    if(subidx__6042 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__6041, subidx__6042, null);
        return node__6041
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____6045 = 0 <= i;
    if(and__3546__auto____6045) {
      return i < tv.cnt
    }else {
      return and__3546__auto____6045
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__6046 = tv.root;
      var node__6047 = root__6046;
      var level__6048 = tv.shift;
      while(true) {
        if(level__6048 > 0) {
          var G__6049 = cljs.core.tv_ensure_editable.call(null, root__6046.edit, cljs.core.pv_aget.call(null, node__6047, i >>> level__6048 & 31));
          var G__6050 = level__6048 - 5;
          node__6047 = G__6049;
          level__6048 = G__6050;
          continue
        }else {
          return node__6047.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__6088 = null;
  var G__6088__2 = function(tsym6053, k) {
    var this__6055 = this;
    var tsym6053__6056 = this;
    var coll__6057 = tsym6053__6056;
    return cljs.core._lookup.call(null, coll__6057, k)
  };
  var G__6088__3 = function(tsym6054, k, not_found) {
    var this__6058 = this;
    var tsym6054__6059 = this;
    var coll__6060 = tsym6054__6059;
    return cljs.core._lookup.call(null, coll__6060, k, not_found)
  };
  G__6088 = function(tsym6054, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6088__2.call(this, tsym6054, k);
      case 3:
        return G__6088__3.call(this, tsym6054, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6088
}();
cljs.core.TransientVector.prototype.apply = function(tsym6051, args6052) {
  return tsym6051.call.apply(tsym6051, [tsym6051].concat(cljs.core.aclone.call(null, args6052)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6061 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6062 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6063 = this;
  if(cljs.core.truth_(this__6063.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6064 = this;
  if(function() {
    var and__3546__auto____6065 = 0 <= n;
    if(and__3546__auto____6065) {
      return n < this__6064.cnt
    }else {
      return and__3546__auto____6065
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6066 = this;
  if(cljs.core.truth_(this__6066.root.edit)) {
    return this__6066.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__6067 = this;
  if(cljs.core.truth_(this__6067.root.edit)) {
    if(function() {
      var and__3546__auto____6068 = 0 <= n;
      if(and__3546__auto____6068) {
        return n < this__6067.cnt
      }else {
        return and__3546__auto____6068
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__6067.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__6071 = function go(level, node) {
          var node__6069 = cljs.core.tv_ensure_editable.call(null, this__6067.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__6069, n & 31, val);
            return node__6069
          }else {
            var subidx__6070 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__6069, subidx__6070, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__6069, subidx__6070)));
            return node__6069
          }
        }.call(null, this__6067.shift, this__6067.root);
        this__6067.root = new_root__6071;
        return tcoll
      }
    }else {
      if(n === this__6067.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__6067.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__6072 = this;
  if(cljs.core.truth_(this__6072.root.edit)) {
    if(this__6072.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__6072.cnt) {
        this__6072.cnt = 0;
        return tcoll
      }else {
        if((this__6072.cnt - 1 & 31) > 0) {
          this__6072.cnt = this__6072.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__6073 = cljs.core.editable_array_for.call(null, tcoll, this__6072.cnt - 2);
            var new_root__6075 = function() {
              var nr__6074 = cljs.core.tv_pop_tail.call(null, tcoll, this__6072.shift, this__6072.root);
              if(nr__6074 != null) {
                return nr__6074
              }else {
                return new cljs.core.VectorNode(this__6072.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____6076 = 5 < this__6072.shift;
              if(and__3546__auto____6076) {
                return cljs.core.pv_aget.call(null, new_root__6075, 1) == null
              }else {
                return and__3546__auto____6076
              }
            }()) {
              var new_root__6077 = cljs.core.tv_ensure_editable.call(null, this__6072.root.edit, cljs.core.pv_aget.call(null, new_root__6075, 0));
              this__6072.root = new_root__6077;
              this__6072.shift = this__6072.shift - 5;
              this__6072.cnt = this__6072.cnt - 1;
              this__6072.tail = new_tail__6073;
              return tcoll
            }else {
              this__6072.root = new_root__6075;
              this__6072.cnt = this__6072.cnt - 1;
              this__6072.tail = new_tail__6073;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6078 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6079 = this;
  if(cljs.core.truth_(this__6079.root.edit)) {
    if(this__6079.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__6079.tail[this__6079.cnt & 31] = o;
      this__6079.cnt = this__6079.cnt + 1;
      return tcoll
    }else {
      var tail_node__6080 = new cljs.core.VectorNode(this__6079.root.edit, this__6079.tail);
      var new_tail__6081 = cljs.core.make_array.call(null, 32);
      new_tail__6081[0] = o;
      this__6079.tail = new_tail__6081;
      if(this__6079.cnt >>> 5 > 1 << this__6079.shift) {
        var new_root_array__6082 = cljs.core.make_array.call(null, 32);
        var new_shift__6083 = this__6079.shift + 5;
        new_root_array__6082[0] = this__6079.root;
        new_root_array__6082[1] = cljs.core.new_path.call(null, this__6079.root.edit, this__6079.shift, tail_node__6080);
        this__6079.root = new cljs.core.VectorNode(this__6079.root.edit, new_root_array__6082);
        this__6079.shift = new_shift__6083;
        this__6079.cnt = this__6079.cnt + 1;
        return tcoll
      }else {
        var new_root__6084 = cljs.core.tv_push_tail.call(null, tcoll, this__6079.shift, this__6079.root, tail_node__6080);
        this__6079.root = new_root__6084;
        this__6079.cnt = this__6079.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6085 = this;
  if(cljs.core.truth_(this__6085.root.edit)) {
    this__6085.root.edit = null;
    var len__6086 = this__6085.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__6087 = cljs.core.make_array.call(null, len__6086);
    cljs.core.array_copy.call(null, this__6085.tail, 0, trimmed_tail__6087, 0, len__6086);
    return new cljs.core.PersistentVector(null, this__6085.cnt, this__6085.shift, this__6085.root, trimmed_tail__6087, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6089 = this;
  var h__364__auto____6090 = this__6089.__hash;
  if(h__364__auto____6090 != null) {
    return h__364__auto____6090
  }else {
    var h__364__auto____6091 = cljs.core.hash_coll.call(null, coll);
    this__6089.__hash = h__364__auto____6091;
    return h__364__auto____6091
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6092 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__6093 = this;
  var this$__6094 = this;
  return cljs.core.pr_str.call(null, this$__6094)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6095 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6096 = this;
  return cljs.core._first.call(null, this__6096.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6097 = this;
  var temp__3695__auto____6098 = cljs.core.next.call(null, this__6097.front);
  if(cljs.core.truth_(temp__3695__auto____6098)) {
    var f1__6099 = temp__3695__auto____6098;
    return new cljs.core.PersistentQueueSeq(this__6097.meta, f1__6099, this__6097.rear, null)
  }else {
    if(this__6097.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__6097.meta, this__6097.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6100 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6101 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__6101.front, this__6101.rear, this__6101.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6102 = this;
  return this__6102.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6103 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6103.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6104 = this;
  var h__364__auto____6105 = this__6104.__hash;
  if(h__364__auto____6105 != null) {
    return h__364__auto____6105
  }else {
    var h__364__auto____6106 = cljs.core.hash_coll.call(null, coll);
    this__6104.__hash = h__364__auto____6106;
    return h__364__auto____6106
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6107 = this;
  if(cljs.core.truth_(this__6107.front)) {
    return new cljs.core.PersistentQueue(this__6107.meta, this__6107.count + 1, this__6107.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____6108 = this__6107.rear;
      if(cljs.core.truth_(or__3548__auto____6108)) {
        return or__3548__auto____6108
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__6107.meta, this__6107.count + 1, cljs.core.conj.call(null, this__6107.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__6109 = this;
  var this$__6110 = this;
  return cljs.core.pr_str.call(null, this$__6110)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6111 = this;
  var rear__6112 = cljs.core.seq.call(null, this__6111.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____6113 = this__6111.front;
    if(cljs.core.truth_(or__3548__auto____6113)) {
      return or__3548__auto____6113
    }else {
      return rear__6112
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__6111.front, cljs.core.seq.call(null, rear__6112), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6114 = this;
  return this__6114.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6115 = this;
  return cljs.core._first.call(null, this__6115.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6116 = this;
  if(cljs.core.truth_(this__6116.front)) {
    var temp__3695__auto____6117 = cljs.core.next.call(null, this__6116.front);
    if(cljs.core.truth_(temp__3695__auto____6117)) {
      var f1__6118 = temp__3695__auto____6117;
      return new cljs.core.PersistentQueue(this__6116.meta, this__6116.count - 1, f1__6118, this__6116.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__6116.meta, this__6116.count - 1, cljs.core.seq.call(null, this__6116.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6119 = this;
  return cljs.core.first.call(null, this__6119.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6120 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6121 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6122 = this;
  return new cljs.core.PersistentQueue(meta, this__6122.count, this__6122.front, this__6122.rear, this__6122.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6123 = this;
  return this__6123.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6124 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6125 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__6126 = array.length;
  var i__6127 = 0;
  while(true) {
    if(i__6127 < len__6126) {
      if(cljs.core._EQ_.call(null, k, array[i__6127])) {
        return i__6127
      }else {
        var G__6128 = i__6127 + incr;
        i__6127 = G__6128;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6129 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____6129)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____6129
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__6130 = cljs.core.hash.call(null, a);
  var b__6131 = cljs.core.hash.call(null, b);
  if(a__6130 < b__6131) {
    return-1
  }else {
    if(a__6130 > b__6131) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__6133 = m.keys;
  var len__6134 = ks__6133.length;
  var so__6135 = m.strobj;
  var out__6136 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__6137 = 0;
  var out__6138 = cljs.core.transient$.call(null, out__6136);
  while(true) {
    if(i__6137 < len__6134) {
      var k__6139 = ks__6133[i__6137];
      var G__6140 = i__6137 + 1;
      var G__6141 = cljs.core.assoc_BANG_.call(null, out__6138, k__6139, so__6135[k__6139]);
      i__6137 = G__6140;
      out__6138 = G__6141;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__6138, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6146 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6147 = this;
  var h__364__auto____6148 = this__6147.__hash;
  if(h__364__auto____6148 != null) {
    return h__364__auto____6148
  }else {
    var h__364__auto____6149 = cljs.core.hash_imap.call(null, coll);
    this__6147.__hash = h__364__auto____6149;
    return h__364__auto____6149
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6150 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6151 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6151.strobj, this__6151.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6152 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___6153 = this__6152.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___6153)) {
      var new_strobj__6154 = goog.object.clone.call(null, this__6152.strobj);
      new_strobj__6154[k] = v;
      return new cljs.core.ObjMap(this__6152.meta, this__6152.keys, new_strobj__6154, this__6152.update_count + 1, null)
    }else {
      if(this__6152.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__6155 = goog.object.clone.call(null, this__6152.strobj);
        var new_keys__6156 = cljs.core.aclone.call(null, this__6152.keys);
        new_strobj__6155[k] = v;
        new_keys__6156.push(k);
        return new cljs.core.ObjMap(this__6152.meta, new_keys__6156, new_strobj__6155, this__6152.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6157 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6157.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__6177 = null;
  var G__6177__2 = function(tsym6144, k) {
    var this__6158 = this;
    var tsym6144__6159 = this;
    var coll__6160 = tsym6144__6159;
    return cljs.core._lookup.call(null, coll__6160, k)
  };
  var G__6177__3 = function(tsym6145, k, not_found) {
    var this__6161 = this;
    var tsym6145__6162 = this;
    var coll__6163 = tsym6145__6162;
    return cljs.core._lookup.call(null, coll__6163, k, not_found)
  };
  G__6177 = function(tsym6145, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6177__2.call(this, tsym6145, k);
      case 3:
        return G__6177__3.call(this, tsym6145, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6177
}();
cljs.core.ObjMap.prototype.apply = function(tsym6142, args6143) {
  return tsym6142.call.apply(tsym6142, [tsym6142].concat(cljs.core.aclone.call(null, args6143)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6164 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__6165 = this;
  var this$__6166 = this;
  return cljs.core.pr_str.call(null, this$__6166)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6167 = this;
  if(this__6167.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__6132_SHARP_) {
      return cljs.core.vector.call(null, p1__6132_SHARP_, this__6167.strobj[p1__6132_SHARP_])
    }, this__6167.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6168 = this;
  return this__6168.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6169 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6170 = this;
  return new cljs.core.ObjMap(meta, this__6170.keys, this__6170.strobj, this__6170.update_count, this__6170.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6171 = this;
  return this__6171.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6172 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__6172.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6173 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____6174 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____6174)) {
      return this__6173.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____6174
    }
  }())) {
    var new_keys__6175 = cljs.core.aclone.call(null, this__6173.keys);
    var new_strobj__6176 = goog.object.clone.call(null, this__6173.strobj);
    new_keys__6175.splice(cljs.core.scan_array.call(null, 1, k, new_keys__6175), 1);
    cljs.core.js_delete.call(null, new_strobj__6176, k);
    return new cljs.core.ObjMap(this__6173.meta, new_keys__6175, new_strobj__6176, this__6173.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6183 = this;
  var h__364__auto____6184 = this__6183.__hash;
  if(h__364__auto____6184 != null) {
    return h__364__auto____6184
  }else {
    var h__364__auto____6185 = cljs.core.hash_imap.call(null, coll);
    this__6183.__hash = h__364__auto____6185;
    return h__364__auto____6185
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6186 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6187 = this;
  var bucket__6188 = this__6187.hashobj[cljs.core.hash.call(null, k)];
  var i__6189 = cljs.core.truth_(bucket__6188) ? cljs.core.scan_array.call(null, 2, k, bucket__6188) : null;
  if(cljs.core.truth_(i__6189)) {
    return bucket__6188[i__6189 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6190 = this;
  var h__6191 = cljs.core.hash.call(null, k);
  var bucket__6192 = this__6190.hashobj[h__6191];
  if(cljs.core.truth_(bucket__6192)) {
    var new_bucket__6193 = cljs.core.aclone.call(null, bucket__6192);
    var new_hashobj__6194 = goog.object.clone.call(null, this__6190.hashobj);
    new_hashobj__6194[h__6191] = new_bucket__6193;
    var temp__3695__auto____6195 = cljs.core.scan_array.call(null, 2, k, new_bucket__6193);
    if(cljs.core.truth_(temp__3695__auto____6195)) {
      var i__6196 = temp__3695__auto____6195;
      new_bucket__6193[i__6196 + 1] = v;
      return new cljs.core.HashMap(this__6190.meta, this__6190.count, new_hashobj__6194, null)
    }else {
      new_bucket__6193.push(k, v);
      return new cljs.core.HashMap(this__6190.meta, this__6190.count + 1, new_hashobj__6194, null)
    }
  }else {
    var new_hashobj__6197 = goog.object.clone.call(null, this__6190.hashobj);
    new_hashobj__6197[h__6191] = [k, v];
    return new cljs.core.HashMap(this__6190.meta, this__6190.count + 1, new_hashobj__6197, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6198 = this;
  var bucket__6199 = this__6198.hashobj[cljs.core.hash.call(null, k)];
  var i__6200 = cljs.core.truth_(bucket__6199) ? cljs.core.scan_array.call(null, 2, k, bucket__6199) : null;
  if(cljs.core.truth_(i__6200)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6223 = null;
  var G__6223__2 = function(tsym6181, k) {
    var this__6201 = this;
    var tsym6181__6202 = this;
    var coll__6203 = tsym6181__6202;
    return cljs.core._lookup.call(null, coll__6203, k)
  };
  var G__6223__3 = function(tsym6182, k, not_found) {
    var this__6204 = this;
    var tsym6182__6205 = this;
    var coll__6206 = tsym6182__6205;
    return cljs.core._lookup.call(null, coll__6206, k, not_found)
  };
  G__6223 = function(tsym6182, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6223__2.call(this, tsym6182, k);
      case 3:
        return G__6223__3.call(this, tsym6182, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6223
}();
cljs.core.HashMap.prototype.apply = function(tsym6179, args6180) {
  return tsym6179.call.apply(tsym6179, [tsym6179].concat(cljs.core.aclone.call(null, args6180)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6207 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6208 = this;
  var this$__6209 = this;
  return cljs.core.pr_str.call(null, this$__6209)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6210 = this;
  if(this__6210.count > 0) {
    var hashes__6211 = cljs.core.js_keys.call(null, this__6210.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__6178_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6210.hashobj[p1__6178_SHARP_]))
    }, hashes__6211)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6212 = this;
  return this__6212.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6213 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6214 = this;
  return new cljs.core.HashMap(meta, this__6214.count, this__6214.hashobj, this__6214.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6215 = this;
  return this__6215.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6216 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6216.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6217 = this;
  var h__6218 = cljs.core.hash.call(null, k);
  var bucket__6219 = this__6217.hashobj[h__6218];
  var i__6220 = cljs.core.truth_(bucket__6219) ? cljs.core.scan_array.call(null, 2, k, bucket__6219) : null;
  if(cljs.core.not.call(null, i__6220)) {
    return coll
  }else {
    var new_hashobj__6221 = goog.object.clone.call(null, this__6217.hashobj);
    if(3 > bucket__6219.length) {
      cljs.core.js_delete.call(null, new_hashobj__6221, h__6218)
    }else {
      var new_bucket__6222 = cljs.core.aclone.call(null, bucket__6219);
      new_bucket__6222.splice(i__6220, 2);
      new_hashobj__6221[h__6218] = new_bucket__6222
    }
    return new cljs.core.HashMap(this__6217.meta, this__6217.count - 1, new_hashobj__6221, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6224 = ks.length;
  var i__6225 = 0;
  var out__6226 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6225 < len__6224) {
      var G__6227 = i__6225 + 1;
      var G__6228 = cljs.core.assoc.call(null, out__6226, ks[i__6225], vs[i__6225]);
      i__6225 = G__6227;
      out__6226 = G__6228;
      continue
    }else {
      return out__6226
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6229 = m.arr;
  var len__6230 = arr__6229.length;
  var i__6231 = 0;
  while(true) {
    if(len__6230 <= i__6231) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6229[i__6231], k)) {
        return i__6231
      }else {
        if("\ufdd0'else") {
          var G__6232 = i__6231 + 2;
          i__6231 = G__6232;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6237 = this;
  return new cljs.core.TransientArrayMap({}, this__6237.arr.length, cljs.core.aclone.call(null, this__6237.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6238 = this;
  var h__364__auto____6239 = this__6238.__hash;
  if(h__364__auto____6239 != null) {
    return h__364__auto____6239
  }else {
    var h__364__auto____6240 = cljs.core.hash_imap.call(null, coll);
    this__6238.__hash = h__364__auto____6240;
    return h__364__auto____6240
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6241 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6242 = this;
  var idx__6243 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6243 === -1) {
    return not_found
  }else {
    return this__6242.arr[idx__6243 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6244 = this;
  var idx__6245 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6245 === -1) {
    if(this__6244.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6244.meta, this__6244.cnt + 1, function() {
        var G__6246__6247 = cljs.core.aclone.call(null, this__6244.arr);
        G__6246__6247.push(k);
        G__6246__6247.push(v);
        return G__6246__6247
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6244.arr[idx__6245 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6244.meta, this__6244.cnt, function() {
          var G__6248__6249 = cljs.core.aclone.call(null, this__6244.arr);
          G__6248__6249[idx__6245 + 1] = v;
          return G__6248__6249
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6250 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6280 = null;
  var G__6280__2 = function(tsym6235, k) {
    var this__6251 = this;
    var tsym6235__6252 = this;
    var coll__6253 = tsym6235__6252;
    return cljs.core._lookup.call(null, coll__6253, k)
  };
  var G__6280__3 = function(tsym6236, k, not_found) {
    var this__6254 = this;
    var tsym6236__6255 = this;
    var coll__6256 = tsym6236__6255;
    return cljs.core._lookup.call(null, coll__6256, k, not_found)
  };
  G__6280 = function(tsym6236, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6280__2.call(this, tsym6236, k);
      case 3:
        return G__6280__3.call(this, tsym6236, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6280
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6233, args6234) {
  return tsym6233.call.apply(tsym6233, [tsym6233].concat(cljs.core.aclone.call(null, args6234)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6257 = this;
  var len__6258 = this__6257.arr.length;
  var i__6259 = 0;
  var init__6260 = init;
  while(true) {
    if(i__6259 < len__6258) {
      var init__6261 = f.call(null, init__6260, this__6257.arr[i__6259], this__6257.arr[i__6259 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6261)) {
        return cljs.core.deref.call(null, init__6261)
      }else {
        var G__6281 = i__6259 + 2;
        var G__6282 = init__6261;
        i__6259 = G__6281;
        init__6260 = G__6282;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6262 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6263 = this;
  var this$__6264 = this;
  return cljs.core.pr_str.call(null, this$__6264)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6265 = this;
  if(this__6265.cnt > 0) {
    var len__6266 = this__6265.arr.length;
    var array_map_seq__6267 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6266) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6265.arr[i], this__6265.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6267.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6268 = this;
  return this__6268.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6269 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6270 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6270.cnt, this__6270.arr, this__6270.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6271 = this;
  return this__6271.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6272 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6272.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6273 = this;
  var idx__6274 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6274 >= 0) {
    var len__6275 = this__6273.arr.length;
    var new_len__6276 = len__6275 - 2;
    if(new_len__6276 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6277 = cljs.core.make_array.call(null, new_len__6276);
      var s__6278 = 0;
      var d__6279 = 0;
      while(true) {
        if(s__6278 >= len__6275) {
          return new cljs.core.PersistentArrayMap(this__6273.meta, this__6273.cnt - 1, new_arr__6277, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6273.arr[s__6278])) {
            var G__6283 = s__6278 + 2;
            var G__6284 = d__6279;
            s__6278 = G__6283;
            d__6279 = G__6284;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6277[d__6279] = this__6273.arr[s__6278];
              new_arr__6277[d__6279 + 1] = this__6273.arr[s__6278 + 1];
              var G__6285 = s__6278 + 2;
              var G__6286 = d__6279 + 2;
              s__6278 = G__6285;
              d__6279 = G__6286;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6287 = cljs.core.count.call(null, ks);
  var i__6288 = 0;
  var out__6289 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6288 < len__6287) {
      var G__6290 = i__6288 + 1;
      var G__6291 = cljs.core.assoc_BANG_.call(null, out__6289, ks[i__6288], vs[i__6288]);
      i__6288 = G__6290;
      out__6289 = G__6291;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6289)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6292 = this;
  if(cljs.core.truth_(this__6292.editable_QMARK_)) {
    var idx__6293 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6293 >= 0) {
      this__6292.arr[idx__6293] = this__6292.arr[this__6292.len - 2];
      this__6292.arr[idx__6293 + 1] = this__6292.arr[this__6292.len - 1];
      var G__6294__6295 = this__6292.arr;
      G__6294__6295.pop();
      G__6294__6295.pop();
      G__6294__6295;
      this__6292.len = this__6292.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6296 = this;
  if(cljs.core.truth_(this__6296.editable_QMARK_)) {
    var idx__6297 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6297 === -1) {
      if(this__6296.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6296.len = this__6296.len + 2;
        this__6296.arr.push(key);
        this__6296.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6296.len, this__6296.arr), key, val)
      }
    }else {
      if(val === this__6296.arr[idx__6297 + 1]) {
        return tcoll
      }else {
        this__6296.arr[idx__6297 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6298 = this;
  if(cljs.core.truth_(this__6298.editable_QMARK_)) {
    if(function() {
      var G__6299__6300 = o;
      if(G__6299__6300 != null) {
        if(function() {
          var or__3548__auto____6301 = G__6299__6300.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6301) {
            return or__3548__auto____6301
          }else {
            return G__6299__6300.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6299__6300.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6299__6300)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6299__6300)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6302 = cljs.core.seq.call(null, o);
      var tcoll__6303 = tcoll;
      while(true) {
        var temp__3695__auto____6304 = cljs.core.first.call(null, es__6302);
        if(cljs.core.truth_(temp__3695__auto____6304)) {
          var e__6305 = temp__3695__auto____6304;
          var G__6311 = cljs.core.next.call(null, es__6302);
          var G__6312 = cljs.core._assoc_BANG_.call(null, tcoll__6303, cljs.core.key.call(null, e__6305), cljs.core.val.call(null, e__6305));
          es__6302 = G__6311;
          tcoll__6303 = G__6312;
          continue
        }else {
          return tcoll__6303
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6306 = this;
  if(cljs.core.truth_(this__6306.editable_QMARK_)) {
    this__6306.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6306.len, 2), this__6306.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6307 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6308 = this;
  if(cljs.core.truth_(this__6308.editable_QMARK_)) {
    var idx__6309 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6309 === -1) {
      return not_found
    }else {
      return this__6308.arr[idx__6309 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6310 = this;
  if(cljs.core.truth_(this__6310.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6310.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6313 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6314 = 0;
  while(true) {
    if(i__6314 < len) {
      var G__6315 = cljs.core.assoc_BANG_.call(null, out__6313, arr[i__6314], arr[i__6314 + 1]);
      var G__6316 = i__6314 + 2;
      out__6313 = G__6315;
      i__6314 = G__6316;
      continue
    }else {
      return out__6313
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6317__6318 = cljs.core.aclone.call(null, arr);
    G__6317__6318[i] = a;
    return G__6317__6318
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6319__6320 = cljs.core.aclone.call(null, arr);
    G__6319__6320[i] = a;
    G__6319__6320[j] = b;
    return G__6319__6320
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6321 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6321, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6321, 2 * i, new_arr__6321.length - 2 * i);
  return new_arr__6321
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6322 = inode.ensure_editable(edit);
    editable__6322.arr[i] = a;
    return editable__6322
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6323 = inode.ensure_editable(edit);
    editable__6323.arr[i] = a;
    editable__6323.arr[j] = b;
    return editable__6323
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6324 = arr.length;
  var i__6325 = 0;
  var init__6326 = init;
  while(true) {
    if(i__6325 < len__6324) {
      var init__6329 = function() {
        var k__6327 = arr[i__6325];
        if(k__6327 != null) {
          return f.call(null, init__6326, k__6327, arr[i__6325 + 1])
        }else {
          var node__6328 = arr[i__6325 + 1];
          if(node__6328 != null) {
            return node__6328.kv_reduce(f, init__6326)
          }else {
            return init__6326
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6329)) {
        return cljs.core.deref.call(null, init__6329)
      }else {
        var G__6330 = i__6325 + 2;
        var G__6331 = init__6329;
        i__6325 = G__6330;
        init__6326 = G__6331;
        continue
      }
    }else {
      return init__6326
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6332 = this;
  var inode__6333 = this;
  if(this__6332.bitmap === bit) {
    return null
  }else {
    var editable__6334 = inode__6333.ensure_editable(e);
    var earr__6335 = editable__6334.arr;
    var len__6336 = earr__6335.length;
    editable__6334.bitmap = bit ^ editable__6334.bitmap;
    cljs.core.array_copy.call(null, earr__6335, 2 * (i + 1), earr__6335, 2 * i, len__6336 - 2 * (i + 1));
    earr__6335[len__6336 - 2] = null;
    earr__6335[len__6336 - 1] = null;
    return editable__6334
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6337 = this;
  var inode__6338 = this;
  var bit__6339 = 1 << (hash >>> shift & 31);
  var idx__6340 = cljs.core.bitmap_indexed_node_index.call(null, this__6337.bitmap, bit__6339);
  if((this__6337.bitmap & bit__6339) === 0) {
    var n__6341 = cljs.core.bit_count.call(null, this__6337.bitmap);
    if(2 * n__6341 < this__6337.arr.length) {
      var editable__6342 = inode__6338.ensure_editable(edit);
      var earr__6343 = editable__6342.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6343, 2 * idx__6340, earr__6343, 2 * (idx__6340 + 1), 2 * (n__6341 - idx__6340));
      earr__6343[2 * idx__6340] = key;
      earr__6343[2 * idx__6340 + 1] = val;
      editable__6342.bitmap = editable__6342.bitmap | bit__6339;
      return editable__6342
    }else {
      if(n__6341 >= 16) {
        var nodes__6344 = cljs.core.make_array.call(null, 32);
        var jdx__6345 = hash >>> shift & 31;
        nodes__6344[jdx__6345] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6346 = 0;
        var j__6347 = 0;
        while(true) {
          if(i__6346 < 32) {
            if((this__6337.bitmap >>> i__6346 & 1) === 0) {
              var G__6400 = i__6346 + 1;
              var G__6401 = j__6347;
              i__6346 = G__6400;
              j__6347 = G__6401;
              continue
            }else {
              nodes__6344[i__6346] = null != this__6337.arr[j__6347] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6337.arr[j__6347]), this__6337.arr[j__6347], this__6337.arr[j__6347 + 1], added_leaf_QMARK_) : this__6337.arr[j__6347 + 1];
              var G__6402 = i__6346 + 1;
              var G__6403 = j__6347 + 2;
              i__6346 = G__6402;
              j__6347 = G__6403;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6341 + 1, nodes__6344)
      }else {
        if("\ufdd0'else") {
          var new_arr__6348 = cljs.core.make_array.call(null, 2 * (n__6341 + 4));
          cljs.core.array_copy.call(null, this__6337.arr, 0, new_arr__6348, 0, 2 * idx__6340);
          new_arr__6348[2 * idx__6340] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6348[2 * idx__6340 + 1] = val;
          cljs.core.array_copy.call(null, this__6337.arr, 2 * idx__6340, new_arr__6348, 2 * (idx__6340 + 1), 2 * (n__6341 - idx__6340));
          var editable__6349 = inode__6338.ensure_editable(edit);
          editable__6349.arr = new_arr__6348;
          editable__6349.bitmap = editable__6349.bitmap | bit__6339;
          return editable__6349
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6350 = this__6337.arr[2 * idx__6340];
    var val_or_node__6351 = this__6337.arr[2 * idx__6340 + 1];
    if(null == key_or_nil__6350) {
      var n__6352 = val_or_node__6351.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6352 === val_or_node__6351) {
        return inode__6338
      }else {
        return cljs.core.edit_and_set.call(null, inode__6338, edit, 2 * idx__6340 + 1, n__6352)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6350)) {
        if(val === val_or_node__6351) {
          return inode__6338
        }else {
          return cljs.core.edit_and_set.call(null, inode__6338, edit, 2 * idx__6340 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6338, edit, 2 * idx__6340, null, 2 * idx__6340 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6350, val_or_node__6351, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6353 = this;
  var inode__6354 = this;
  return cljs.core.create_inode_seq.call(null, this__6353.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6355 = this;
  var inode__6356 = this;
  var bit__6357 = 1 << (hash >>> shift & 31);
  if((this__6355.bitmap & bit__6357) === 0) {
    return inode__6356
  }else {
    var idx__6358 = cljs.core.bitmap_indexed_node_index.call(null, this__6355.bitmap, bit__6357);
    var key_or_nil__6359 = this__6355.arr[2 * idx__6358];
    var val_or_node__6360 = this__6355.arr[2 * idx__6358 + 1];
    if(null == key_or_nil__6359) {
      var n__6361 = val_or_node__6360.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6361 === val_or_node__6360) {
        return inode__6356
      }else {
        if(null != n__6361) {
          return cljs.core.edit_and_set.call(null, inode__6356, edit, 2 * idx__6358 + 1, n__6361)
        }else {
          if(this__6355.bitmap === bit__6357) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6356.edit_and_remove_pair(edit, bit__6357, idx__6358)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6359)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6356.edit_and_remove_pair(edit, bit__6357, idx__6358)
      }else {
        if("\ufdd0'else") {
          return inode__6356
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6362 = this;
  var inode__6363 = this;
  if(e === this__6362.edit) {
    return inode__6363
  }else {
    var n__6364 = cljs.core.bit_count.call(null, this__6362.bitmap);
    var new_arr__6365 = cljs.core.make_array.call(null, n__6364 < 0 ? 4 : 2 * (n__6364 + 1));
    cljs.core.array_copy.call(null, this__6362.arr, 0, new_arr__6365, 0, 2 * n__6364);
    return new cljs.core.BitmapIndexedNode(e, this__6362.bitmap, new_arr__6365)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6366 = this;
  var inode__6367 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6366.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6404 = null;
  var G__6404__3 = function(shift, hash, key) {
    var this__6368 = this;
    var inode__6369 = this;
    var bit__6370 = 1 << (hash >>> shift & 31);
    if((this__6368.bitmap & bit__6370) === 0) {
      return null
    }else {
      var idx__6371 = cljs.core.bitmap_indexed_node_index.call(null, this__6368.bitmap, bit__6370);
      var key_or_nil__6372 = this__6368.arr[2 * idx__6371];
      var val_or_node__6373 = this__6368.arr[2 * idx__6371 + 1];
      if(null == key_or_nil__6372) {
        return val_or_node__6373.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6372)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6372, val_or_node__6373])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6404__4 = function(shift, hash, key, not_found) {
    var this__6374 = this;
    var inode__6375 = this;
    var bit__6376 = 1 << (hash >>> shift & 31);
    if((this__6374.bitmap & bit__6376) === 0) {
      return not_found
    }else {
      var idx__6377 = cljs.core.bitmap_indexed_node_index.call(null, this__6374.bitmap, bit__6376);
      var key_or_nil__6378 = this__6374.arr[2 * idx__6377];
      var val_or_node__6379 = this__6374.arr[2 * idx__6377 + 1];
      if(null == key_or_nil__6378) {
        return val_or_node__6379.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6378)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6378, val_or_node__6379])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6404 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6404__3.call(this, shift, hash, key);
      case 4:
        return G__6404__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6404
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6380 = this;
  var inode__6381 = this;
  var bit__6382 = 1 << (hash >>> shift & 31);
  if((this__6380.bitmap & bit__6382) === 0) {
    return inode__6381
  }else {
    var idx__6383 = cljs.core.bitmap_indexed_node_index.call(null, this__6380.bitmap, bit__6382);
    var key_or_nil__6384 = this__6380.arr[2 * idx__6383];
    var val_or_node__6385 = this__6380.arr[2 * idx__6383 + 1];
    if(null == key_or_nil__6384) {
      var n__6386 = val_or_node__6385.inode_without(shift + 5, hash, key);
      if(n__6386 === val_or_node__6385) {
        return inode__6381
      }else {
        if(null != n__6386) {
          return new cljs.core.BitmapIndexedNode(null, this__6380.bitmap, cljs.core.clone_and_set.call(null, this__6380.arr, 2 * idx__6383 + 1, n__6386))
        }else {
          if(this__6380.bitmap === bit__6382) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6380.bitmap ^ bit__6382, cljs.core.remove_pair.call(null, this__6380.arr, idx__6383))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6384)) {
        return new cljs.core.BitmapIndexedNode(null, this__6380.bitmap ^ bit__6382, cljs.core.remove_pair.call(null, this__6380.arr, idx__6383))
      }else {
        if("\ufdd0'else") {
          return inode__6381
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6387 = this;
  var inode__6388 = this;
  var bit__6389 = 1 << (hash >>> shift & 31);
  var idx__6390 = cljs.core.bitmap_indexed_node_index.call(null, this__6387.bitmap, bit__6389);
  if((this__6387.bitmap & bit__6389) === 0) {
    var n__6391 = cljs.core.bit_count.call(null, this__6387.bitmap);
    if(n__6391 >= 16) {
      var nodes__6392 = cljs.core.make_array.call(null, 32);
      var jdx__6393 = hash >>> shift & 31;
      nodes__6392[jdx__6393] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6394 = 0;
      var j__6395 = 0;
      while(true) {
        if(i__6394 < 32) {
          if((this__6387.bitmap >>> i__6394 & 1) === 0) {
            var G__6405 = i__6394 + 1;
            var G__6406 = j__6395;
            i__6394 = G__6405;
            j__6395 = G__6406;
            continue
          }else {
            nodes__6392[i__6394] = null != this__6387.arr[j__6395] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6387.arr[j__6395]), this__6387.arr[j__6395], this__6387.arr[j__6395 + 1], added_leaf_QMARK_) : this__6387.arr[j__6395 + 1];
            var G__6407 = i__6394 + 1;
            var G__6408 = j__6395 + 2;
            i__6394 = G__6407;
            j__6395 = G__6408;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6391 + 1, nodes__6392)
    }else {
      var new_arr__6396 = cljs.core.make_array.call(null, 2 * (n__6391 + 1));
      cljs.core.array_copy.call(null, this__6387.arr, 0, new_arr__6396, 0, 2 * idx__6390);
      new_arr__6396[2 * idx__6390] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6396[2 * idx__6390 + 1] = val;
      cljs.core.array_copy.call(null, this__6387.arr, 2 * idx__6390, new_arr__6396, 2 * (idx__6390 + 1), 2 * (n__6391 - idx__6390));
      return new cljs.core.BitmapIndexedNode(null, this__6387.bitmap | bit__6389, new_arr__6396)
    }
  }else {
    var key_or_nil__6397 = this__6387.arr[2 * idx__6390];
    var val_or_node__6398 = this__6387.arr[2 * idx__6390 + 1];
    if(null == key_or_nil__6397) {
      var n__6399 = val_or_node__6398.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6399 === val_or_node__6398) {
        return inode__6388
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6387.bitmap, cljs.core.clone_and_set.call(null, this__6387.arr, 2 * idx__6390 + 1, n__6399))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6397)) {
        if(val === val_or_node__6398) {
          return inode__6388
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6387.bitmap, cljs.core.clone_and_set.call(null, this__6387.arr, 2 * idx__6390 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6387.bitmap, cljs.core.clone_and_set.call(null, this__6387.arr, 2 * idx__6390, null, 2 * idx__6390 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6397, val_or_node__6398, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6409 = array_node.arr;
  var len__6410 = 2 * (array_node.cnt - 1);
  var new_arr__6411 = cljs.core.make_array.call(null, len__6410);
  var i__6412 = 0;
  var j__6413 = 1;
  var bitmap__6414 = 0;
  while(true) {
    if(i__6412 < len__6410) {
      if(function() {
        var and__3546__auto____6415 = i__6412 != idx;
        if(and__3546__auto____6415) {
          return null != arr__6409[i__6412]
        }else {
          return and__3546__auto____6415
        }
      }()) {
        new_arr__6411[j__6413] = arr__6409[i__6412];
        var G__6416 = i__6412 + 1;
        var G__6417 = j__6413 + 2;
        var G__6418 = bitmap__6414 | 1 << i__6412;
        i__6412 = G__6416;
        j__6413 = G__6417;
        bitmap__6414 = G__6418;
        continue
      }else {
        var G__6419 = i__6412 + 1;
        var G__6420 = j__6413;
        var G__6421 = bitmap__6414;
        i__6412 = G__6419;
        j__6413 = G__6420;
        bitmap__6414 = G__6421;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6414, new_arr__6411)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6422 = this;
  var inode__6423 = this;
  var idx__6424 = hash >>> shift & 31;
  var node__6425 = this__6422.arr[idx__6424];
  if(null == node__6425) {
    return new cljs.core.ArrayNode(null, this__6422.cnt + 1, cljs.core.clone_and_set.call(null, this__6422.arr, idx__6424, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6426 = node__6425.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6426 === node__6425) {
      return inode__6423
    }else {
      return new cljs.core.ArrayNode(null, this__6422.cnt, cljs.core.clone_and_set.call(null, this__6422.arr, idx__6424, n__6426))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6427 = this;
  var inode__6428 = this;
  var idx__6429 = hash >>> shift & 31;
  var node__6430 = this__6427.arr[idx__6429];
  if(null != node__6430) {
    var n__6431 = node__6430.inode_without(shift + 5, hash, key);
    if(n__6431 === node__6430) {
      return inode__6428
    }else {
      if(n__6431 == null) {
        if(this__6427.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6428, null, idx__6429)
        }else {
          return new cljs.core.ArrayNode(null, this__6427.cnt - 1, cljs.core.clone_and_set.call(null, this__6427.arr, idx__6429, n__6431))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6427.cnt, cljs.core.clone_and_set.call(null, this__6427.arr, idx__6429, n__6431))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6428
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6463 = null;
  var G__6463__3 = function(shift, hash, key) {
    var this__6432 = this;
    var inode__6433 = this;
    var idx__6434 = hash >>> shift & 31;
    var node__6435 = this__6432.arr[idx__6434];
    if(null != node__6435) {
      return node__6435.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6463__4 = function(shift, hash, key, not_found) {
    var this__6436 = this;
    var inode__6437 = this;
    var idx__6438 = hash >>> shift & 31;
    var node__6439 = this__6436.arr[idx__6438];
    if(null != node__6439) {
      return node__6439.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6463 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6463__3.call(this, shift, hash, key);
      case 4:
        return G__6463__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6463
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6440 = this;
  var inode__6441 = this;
  return cljs.core.create_array_node_seq.call(null, this__6440.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6442 = this;
  var inode__6443 = this;
  if(e === this__6442.edit) {
    return inode__6443
  }else {
    return new cljs.core.ArrayNode(e, this__6442.cnt, cljs.core.aclone.call(null, this__6442.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6444 = this;
  var inode__6445 = this;
  var idx__6446 = hash >>> shift & 31;
  var node__6447 = this__6444.arr[idx__6446];
  if(null == node__6447) {
    var editable__6448 = cljs.core.edit_and_set.call(null, inode__6445, edit, idx__6446, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6448.cnt = editable__6448.cnt + 1;
    return editable__6448
  }else {
    var n__6449 = node__6447.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6449 === node__6447) {
      return inode__6445
    }else {
      return cljs.core.edit_and_set.call(null, inode__6445, edit, idx__6446, n__6449)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6450 = this;
  var inode__6451 = this;
  var idx__6452 = hash >>> shift & 31;
  var node__6453 = this__6450.arr[idx__6452];
  if(null == node__6453) {
    return inode__6451
  }else {
    var n__6454 = node__6453.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6454 === node__6453) {
      return inode__6451
    }else {
      if(null == n__6454) {
        if(this__6450.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6451, edit, idx__6452)
        }else {
          var editable__6455 = cljs.core.edit_and_set.call(null, inode__6451, edit, idx__6452, n__6454);
          editable__6455.cnt = editable__6455.cnt - 1;
          return editable__6455
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6451, edit, idx__6452, n__6454)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6456 = this;
  var inode__6457 = this;
  var len__6458 = this__6456.arr.length;
  var i__6459 = 0;
  var init__6460 = init;
  while(true) {
    if(i__6459 < len__6458) {
      var node__6461 = this__6456.arr[i__6459];
      if(node__6461 != null) {
        var init__6462 = node__6461.kv_reduce(f, init__6460);
        if(cljs.core.reduced_QMARK_.call(null, init__6462)) {
          return cljs.core.deref.call(null, init__6462)
        }else {
          var G__6464 = i__6459 + 1;
          var G__6465 = init__6462;
          i__6459 = G__6464;
          init__6460 = G__6465;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6460
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6466 = 2 * cnt;
  var i__6467 = 0;
  while(true) {
    if(i__6467 < lim__6466) {
      if(cljs.core._EQ_.call(null, key, arr[i__6467])) {
        return i__6467
      }else {
        var G__6468 = i__6467 + 2;
        i__6467 = G__6468;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6469 = this;
  var inode__6470 = this;
  if(hash === this__6469.collision_hash) {
    var idx__6471 = cljs.core.hash_collision_node_find_index.call(null, this__6469.arr, this__6469.cnt, key);
    if(idx__6471 === -1) {
      var len__6472 = this__6469.arr.length;
      var new_arr__6473 = cljs.core.make_array.call(null, len__6472 + 2);
      cljs.core.array_copy.call(null, this__6469.arr, 0, new_arr__6473, 0, len__6472);
      new_arr__6473[len__6472] = key;
      new_arr__6473[len__6472 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6469.collision_hash, this__6469.cnt + 1, new_arr__6473)
    }else {
      if(cljs.core._EQ_.call(null, this__6469.arr[idx__6471], val)) {
        return inode__6470
      }else {
        return new cljs.core.HashCollisionNode(null, this__6469.collision_hash, this__6469.cnt, cljs.core.clone_and_set.call(null, this__6469.arr, idx__6471 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6469.collision_hash >>> shift & 31), [null, inode__6470])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6474 = this;
  var inode__6475 = this;
  var idx__6476 = cljs.core.hash_collision_node_find_index.call(null, this__6474.arr, this__6474.cnt, key);
  if(idx__6476 === -1) {
    return inode__6475
  }else {
    if(this__6474.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6474.collision_hash, this__6474.cnt - 1, cljs.core.remove_pair.call(null, this__6474.arr, cljs.core.quot.call(null, idx__6476, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6503 = null;
  var G__6503__3 = function(shift, hash, key) {
    var this__6477 = this;
    var inode__6478 = this;
    var idx__6479 = cljs.core.hash_collision_node_find_index.call(null, this__6477.arr, this__6477.cnt, key);
    if(idx__6479 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6477.arr[idx__6479])) {
        return cljs.core.PersistentVector.fromArray([this__6477.arr[idx__6479], this__6477.arr[idx__6479 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6503__4 = function(shift, hash, key, not_found) {
    var this__6480 = this;
    var inode__6481 = this;
    var idx__6482 = cljs.core.hash_collision_node_find_index.call(null, this__6480.arr, this__6480.cnt, key);
    if(idx__6482 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6480.arr[idx__6482])) {
        return cljs.core.PersistentVector.fromArray([this__6480.arr[idx__6482], this__6480.arr[idx__6482 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6503 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6503__3.call(this, shift, hash, key);
      case 4:
        return G__6503__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6503
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6483 = this;
  var inode__6484 = this;
  return cljs.core.create_inode_seq.call(null, this__6483.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6504 = null;
  var G__6504__1 = function(e) {
    var this__6485 = this;
    var inode__6486 = this;
    if(e === this__6485.edit) {
      return inode__6486
    }else {
      var new_arr__6487 = cljs.core.make_array.call(null, 2 * (this__6485.cnt + 1));
      cljs.core.array_copy.call(null, this__6485.arr, 0, new_arr__6487, 0, 2 * this__6485.cnt);
      return new cljs.core.HashCollisionNode(e, this__6485.collision_hash, this__6485.cnt, new_arr__6487)
    }
  };
  var G__6504__3 = function(e, count, array) {
    var this__6488 = this;
    var inode__6489 = this;
    if(e === this__6488.edit) {
      this__6488.arr = array;
      this__6488.cnt = count;
      return inode__6489
    }else {
      return new cljs.core.HashCollisionNode(this__6488.edit, this__6488.collision_hash, count, array)
    }
  };
  G__6504 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6504__1.call(this, e);
      case 3:
        return G__6504__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6504
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6490 = this;
  var inode__6491 = this;
  if(hash === this__6490.collision_hash) {
    var idx__6492 = cljs.core.hash_collision_node_find_index.call(null, this__6490.arr, this__6490.cnt, key);
    if(idx__6492 === -1) {
      if(this__6490.arr.length > 2 * this__6490.cnt) {
        var editable__6493 = cljs.core.edit_and_set.call(null, inode__6491, edit, 2 * this__6490.cnt, key, 2 * this__6490.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6493.cnt = editable__6493.cnt + 1;
        return editable__6493
      }else {
        var len__6494 = this__6490.arr.length;
        var new_arr__6495 = cljs.core.make_array.call(null, len__6494 + 2);
        cljs.core.array_copy.call(null, this__6490.arr, 0, new_arr__6495, 0, len__6494);
        new_arr__6495[len__6494] = key;
        new_arr__6495[len__6494 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6491.ensure_editable(edit, this__6490.cnt + 1, new_arr__6495)
      }
    }else {
      if(this__6490.arr[idx__6492 + 1] === val) {
        return inode__6491
      }else {
        return cljs.core.edit_and_set.call(null, inode__6491, edit, idx__6492 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6490.collision_hash >>> shift & 31), [null, inode__6491, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6496 = this;
  var inode__6497 = this;
  var idx__6498 = cljs.core.hash_collision_node_find_index.call(null, this__6496.arr, this__6496.cnt, key);
  if(idx__6498 === -1) {
    return inode__6497
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6496.cnt === 1) {
      return null
    }else {
      var editable__6499 = inode__6497.ensure_editable(edit);
      var earr__6500 = editable__6499.arr;
      earr__6500[idx__6498] = earr__6500[2 * this__6496.cnt - 2];
      earr__6500[idx__6498 + 1] = earr__6500[2 * this__6496.cnt - 1];
      earr__6500[2 * this__6496.cnt - 1] = null;
      earr__6500[2 * this__6496.cnt - 2] = null;
      editable__6499.cnt = editable__6499.cnt - 1;
      return editable__6499
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6501 = this;
  var inode__6502 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6501.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6505 = cljs.core.hash.call(null, key1);
    if(key1hash__6505 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6505, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6506 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6505, key1, val1, added_leaf_QMARK___6506).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6506)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6507 = cljs.core.hash.call(null, key1);
    if(key1hash__6507 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6507, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6508 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6507, key1, val1, added_leaf_QMARK___6508).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6508)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6509 = this;
  var h__364__auto____6510 = this__6509.__hash;
  if(h__364__auto____6510 != null) {
    return h__364__auto____6510
  }else {
    var h__364__auto____6511 = cljs.core.hash_coll.call(null, coll);
    this__6509.__hash = h__364__auto____6511;
    return h__364__auto____6511
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6512 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6513 = this;
  var this$__6514 = this;
  return cljs.core.pr_str.call(null, this$__6514)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6515 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6516 = this;
  if(this__6516.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6516.nodes[this__6516.i], this__6516.nodes[this__6516.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6516.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6517 = this;
  if(this__6517.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6517.nodes, this__6517.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6517.nodes, this__6517.i, cljs.core.next.call(null, this__6517.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6518 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6519 = this;
  return new cljs.core.NodeSeq(meta, this__6519.nodes, this__6519.i, this__6519.s, this__6519.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6520 = this;
  return this__6520.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6521 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6521.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6522 = nodes.length;
      var j__6523 = i;
      while(true) {
        if(j__6523 < len__6522) {
          if(null != nodes[j__6523]) {
            return new cljs.core.NodeSeq(null, nodes, j__6523, null, null)
          }else {
            var temp__3695__auto____6524 = nodes[j__6523 + 1];
            if(cljs.core.truth_(temp__3695__auto____6524)) {
              var node__6525 = temp__3695__auto____6524;
              var temp__3695__auto____6526 = node__6525.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6526)) {
                var node_seq__6527 = temp__3695__auto____6526;
                return new cljs.core.NodeSeq(null, nodes, j__6523 + 2, node_seq__6527, null)
              }else {
                var G__6528 = j__6523 + 2;
                j__6523 = G__6528;
                continue
              }
            }else {
              var G__6529 = j__6523 + 2;
              j__6523 = G__6529;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6530 = this;
  var h__364__auto____6531 = this__6530.__hash;
  if(h__364__auto____6531 != null) {
    return h__364__auto____6531
  }else {
    var h__364__auto____6532 = cljs.core.hash_coll.call(null, coll);
    this__6530.__hash = h__364__auto____6532;
    return h__364__auto____6532
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6533 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6534 = this;
  var this$__6535 = this;
  return cljs.core.pr_str.call(null, this$__6535)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6536 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6537 = this;
  return cljs.core.first.call(null, this__6537.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6538 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6538.nodes, this__6538.i, cljs.core.next.call(null, this__6538.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6539 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6540 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6540.nodes, this__6540.i, this__6540.s, this__6540.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6541 = this;
  return this__6541.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6542 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6542.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6543 = nodes.length;
      var j__6544 = i;
      while(true) {
        if(j__6544 < len__6543) {
          var temp__3695__auto____6545 = nodes[j__6544];
          if(cljs.core.truth_(temp__3695__auto____6545)) {
            var nj__6546 = temp__3695__auto____6545;
            var temp__3695__auto____6547 = nj__6546.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6547)) {
              var ns__6548 = temp__3695__auto____6547;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6544 + 1, ns__6548, null)
            }else {
              var G__6549 = j__6544 + 1;
              j__6544 = G__6549;
              continue
            }
          }else {
            var G__6550 = j__6544 + 1;
            j__6544 = G__6550;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6555 = this;
  return new cljs.core.TransientHashMap({}, this__6555.root, this__6555.cnt, this__6555.has_nil_QMARK_, this__6555.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6556 = this;
  var h__364__auto____6557 = this__6556.__hash;
  if(h__364__auto____6557 != null) {
    return h__364__auto____6557
  }else {
    var h__364__auto____6558 = cljs.core.hash_imap.call(null, coll);
    this__6556.__hash = h__364__auto____6558;
    return h__364__auto____6558
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6559 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6560 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6560.has_nil_QMARK_)) {
      return this__6560.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6560.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6560.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6561 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6562 = this__6561.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6562)) {
        return v === this__6561.nil_val
      }else {
        return and__3546__auto____6562
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6561.meta, cljs.core.truth_(this__6561.has_nil_QMARK_) ? this__6561.cnt : this__6561.cnt + 1, this__6561.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6563 = [false];
    var new_root__6564 = (this__6561.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6561.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6563);
    if(new_root__6564 === this__6561.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6561.meta, cljs.core.truth_(added_leaf_QMARK___6563[0]) ? this__6561.cnt + 1 : this__6561.cnt, new_root__6564, this__6561.has_nil_QMARK_, this__6561.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6565 = this;
  if(k == null) {
    return this__6565.has_nil_QMARK_
  }else {
    if(this__6565.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6565.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6586 = null;
  var G__6586__2 = function(tsym6553, k) {
    var this__6566 = this;
    var tsym6553__6567 = this;
    var coll__6568 = tsym6553__6567;
    return cljs.core._lookup.call(null, coll__6568, k)
  };
  var G__6586__3 = function(tsym6554, k, not_found) {
    var this__6569 = this;
    var tsym6554__6570 = this;
    var coll__6571 = tsym6554__6570;
    return cljs.core._lookup.call(null, coll__6571, k, not_found)
  };
  G__6586 = function(tsym6554, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6586__2.call(this, tsym6554, k);
      case 3:
        return G__6586__3.call(this, tsym6554, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6586
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6551, args6552) {
  return tsym6551.call.apply(tsym6551, [tsym6551].concat(cljs.core.aclone.call(null, args6552)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6572 = this;
  var init__6573 = cljs.core.truth_(this__6572.has_nil_QMARK_) ? f.call(null, init, null, this__6572.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6573)) {
    return cljs.core.deref.call(null, init__6573)
  }else {
    if(null != this__6572.root) {
      return this__6572.root.kv_reduce(f, init__6573)
    }else {
      if("\ufdd0'else") {
        return init__6573
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6574 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6575 = this;
  var this$__6576 = this;
  return cljs.core.pr_str.call(null, this$__6576)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6577 = this;
  if(this__6577.cnt > 0) {
    var s__6578 = null != this__6577.root ? this__6577.root.inode_seq() : null;
    if(cljs.core.truth_(this__6577.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6577.nil_val]), s__6578)
    }else {
      return s__6578
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6579 = this;
  return this__6579.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6580 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6581 = this;
  return new cljs.core.PersistentHashMap(meta, this__6581.cnt, this__6581.root, this__6581.has_nil_QMARK_, this__6581.nil_val, this__6581.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6582 = this;
  return this__6582.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6583 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6583.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6584 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6584.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6584.meta, this__6584.cnt - 1, this__6584.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6584.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6585 = this__6584.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6585 === this__6584.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6584.meta, this__6584.cnt - 1, new_root__6585, this__6584.has_nil_QMARK_, this__6584.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6587 = ks.length;
  var i__6588 = 0;
  var out__6589 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6588 < len__6587) {
      var G__6590 = i__6588 + 1;
      var G__6591 = cljs.core.assoc_BANG_.call(null, out__6589, ks[i__6588], vs[i__6588]);
      i__6588 = G__6590;
      out__6589 = G__6591;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6589)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6592 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6593 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6594 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6595 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6596 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6596.has_nil_QMARK_)) {
      return this__6596.nil_val
    }else {
      return null
    }
  }else {
    if(this__6596.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6596.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6597 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6597.has_nil_QMARK_)) {
      return this__6597.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6597.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6597.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6598 = this;
  if(cljs.core.truth_(this__6598.edit)) {
    return this__6598.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6599 = this;
  var tcoll__6600 = this;
  if(cljs.core.truth_(this__6599.edit)) {
    if(function() {
      var G__6601__6602 = o;
      if(G__6601__6602 != null) {
        if(function() {
          var or__3548__auto____6603 = G__6601__6602.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6603) {
            return or__3548__auto____6603
          }else {
            return G__6601__6602.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6601__6602.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6601__6602)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6601__6602)
      }
    }()) {
      return tcoll__6600.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6604 = cljs.core.seq.call(null, o);
      var tcoll__6605 = tcoll__6600;
      while(true) {
        var temp__3695__auto____6606 = cljs.core.first.call(null, es__6604);
        if(cljs.core.truth_(temp__3695__auto____6606)) {
          var e__6607 = temp__3695__auto____6606;
          var G__6618 = cljs.core.next.call(null, es__6604);
          var G__6619 = tcoll__6605.assoc_BANG_(cljs.core.key.call(null, e__6607), cljs.core.val.call(null, e__6607));
          es__6604 = G__6618;
          tcoll__6605 = G__6619;
          continue
        }else {
          return tcoll__6605
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6608 = this;
  var tcoll__6609 = this;
  if(cljs.core.truth_(this__6608.edit)) {
    if(k == null) {
      if(this__6608.nil_val === v) {
      }else {
        this__6608.nil_val = v
      }
      if(cljs.core.truth_(this__6608.has_nil_QMARK_)) {
      }else {
        this__6608.count = this__6608.count + 1;
        this__6608.has_nil_QMARK_ = true
      }
      return tcoll__6609
    }else {
      var added_leaf_QMARK___6610 = [false];
      var node__6611 = (this__6608.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6608.root).inode_assoc_BANG_(this__6608.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6610);
      if(node__6611 === this__6608.root) {
      }else {
        this__6608.root = node__6611
      }
      if(cljs.core.truth_(added_leaf_QMARK___6610[0])) {
        this__6608.count = this__6608.count + 1
      }else {
      }
      return tcoll__6609
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6612 = this;
  var tcoll__6613 = this;
  if(cljs.core.truth_(this__6612.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6612.has_nil_QMARK_)) {
        this__6612.has_nil_QMARK_ = false;
        this__6612.nil_val = null;
        this__6612.count = this__6612.count - 1;
        return tcoll__6613
      }else {
        return tcoll__6613
      }
    }else {
      if(this__6612.root == null) {
        return tcoll__6613
      }else {
        var removed_leaf_QMARK___6614 = [false];
        var node__6615 = this__6612.root.inode_without_BANG_(this__6612.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6614);
        if(node__6615 === this__6612.root) {
        }else {
          this__6612.root = node__6615
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6614[0])) {
          this__6612.count = this__6612.count - 1
        }else {
        }
        return tcoll__6613
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6616 = this;
  var tcoll__6617 = this;
  if(cljs.core.truth_(this__6616.edit)) {
    this__6616.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6616.count, this__6616.root, this__6616.has_nil_QMARK_, this__6616.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6620 = node;
  var stack__6621 = stack;
  while(true) {
    if(t__6620 != null) {
      var G__6622 = cljs.core.truth_(ascending_QMARK_) ? t__6620.left : t__6620.right;
      var G__6623 = cljs.core.conj.call(null, stack__6621, t__6620);
      t__6620 = G__6622;
      stack__6621 = G__6623;
      continue
    }else {
      return stack__6621
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6624 = this;
  var h__364__auto____6625 = this__6624.__hash;
  if(h__364__auto____6625 != null) {
    return h__364__auto____6625
  }else {
    var h__364__auto____6626 = cljs.core.hash_coll.call(null, coll);
    this__6624.__hash = h__364__auto____6626;
    return h__364__auto____6626
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6627 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6628 = this;
  var this$__6629 = this;
  return cljs.core.pr_str.call(null, this$__6629)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6630 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6631 = this;
  if(this__6631.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6631.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6632 = this;
  return cljs.core.peek.call(null, this__6632.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6633 = this;
  var t__6634 = cljs.core.peek.call(null, this__6633.stack);
  var next_stack__6635 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6633.ascending_QMARK_) ? t__6634.right : t__6634.left, cljs.core.pop.call(null, this__6633.stack), this__6633.ascending_QMARK_);
  if(next_stack__6635 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6635, this__6633.ascending_QMARK_, this__6633.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6636 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6637 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6637.stack, this__6637.ascending_QMARK_, this__6637.cnt, this__6637.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6638 = this;
  return this__6638.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6639 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6639) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6639
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6640 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6640) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6640
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6641 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6641)) {
    return cljs.core.deref.call(null, init__6641)
  }else {
    var init__6642 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6641) : init__6641;
    if(cljs.core.reduced_QMARK_.call(null, init__6642)) {
      return cljs.core.deref.call(null, init__6642)
    }else {
      var init__6643 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6642) : init__6642;
      if(cljs.core.reduced_QMARK_.call(null, init__6643)) {
        return cljs.core.deref.call(null, init__6643)
      }else {
        return init__6643
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6648 = this;
  var h__364__auto____6649 = this__6648.__hash;
  if(h__364__auto____6649 != null) {
    return h__364__auto____6649
  }else {
    var h__364__auto____6650 = cljs.core.hash_coll.call(null, coll);
    this__6648.__hash = h__364__auto____6650;
    return h__364__auto____6650
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6651 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6652 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6653 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6653.key, this__6653.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6700 = null;
  var G__6700__2 = function(tsym6646, k) {
    var this__6654 = this;
    var tsym6646__6655 = this;
    var node__6656 = tsym6646__6655;
    return cljs.core._lookup.call(null, node__6656, k)
  };
  var G__6700__3 = function(tsym6647, k, not_found) {
    var this__6657 = this;
    var tsym6647__6658 = this;
    var node__6659 = tsym6647__6658;
    return cljs.core._lookup.call(null, node__6659, k, not_found)
  };
  G__6700 = function(tsym6647, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6700__2.call(this, tsym6647, k);
      case 3:
        return G__6700__3.call(this, tsym6647, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6700
}();
cljs.core.BlackNode.prototype.apply = function(tsym6644, args6645) {
  return tsym6644.call.apply(tsym6644, [tsym6644].concat(cljs.core.aclone.call(null, args6645)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6660 = this;
  return cljs.core.PersistentVector.fromArray([this__6660.key, this__6660.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6661 = this;
  return this__6661.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6662 = this;
  return this__6662.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6663 = this;
  var node__6664 = this;
  return ins.balance_right(node__6664)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6665 = this;
  var node__6666 = this;
  return new cljs.core.RedNode(this__6665.key, this__6665.val, this__6665.left, this__6665.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6667 = this;
  var node__6668 = this;
  return cljs.core.balance_right_del.call(null, this__6667.key, this__6667.val, this__6667.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6669 = this;
  var node__6670 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6671 = this;
  var node__6672 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6672, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6673 = this;
  var node__6674 = this;
  return cljs.core.balance_left_del.call(null, this__6673.key, this__6673.val, del, this__6673.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6675 = this;
  var node__6676 = this;
  return ins.balance_left(node__6676)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6677 = this;
  var node__6678 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6678, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6701 = null;
  var G__6701__0 = function() {
    var this__6681 = this;
    var this$__6682 = this;
    return cljs.core.pr_str.call(null, this$__6682)
  };
  G__6701 = function() {
    switch(arguments.length) {
      case 0:
        return G__6701__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6701
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6683 = this;
  var node__6684 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6684, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6685 = this;
  var node__6686 = this;
  return node__6686
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6687 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6688 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6689 = this;
  return cljs.core.list.call(null, this__6689.key, this__6689.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6691 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6692 = this;
  return this__6692.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6693 = this;
  return cljs.core.PersistentVector.fromArray([this__6693.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6694 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6694.key, this__6694.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6695 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6696 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6696.key, this__6696.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6697 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6698 = this;
  if(n === 0) {
    return this__6698.key
  }else {
    if(n === 1) {
      return this__6698.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6699 = this;
  if(n === 0) {
    return this__6699.key
  }else {
    if(n === 1) {
      return this__6699.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6690 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6706 = this;
  var h__364__auto____6707 = this__6706.__hash;
  if(h__364__auto____6707 != null) {
    return h__364__auto____6707
  }else {
    var h__364__auto____6708 = cljs.core.hash_coll.call(null, coll);
    this__6706.__hash = h__364__auto____6708;
    return h__364__auto____6708
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6709 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6710 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6711 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6711.key, this__6711.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6758 = null;
  var G__6758__2 = function(tsym6704, k) {
    var this__6712 = this;
    var tsym6704__6713 = this;
    var node__6714 = tsym6704__6713;
    return cljs.core._lookup.call(null, node__6714, k)
  };
  var G__6758__3 = function(tsym6705, k, not_found) {
    var this__6715 = this;
    var tsym6705__6716 = this;
    var node__6717 = tsym6705__6716;
    return cljs.core._lookup.call(null, node__6717, k, not_found)
  };
  G__6758 = function(tsym6705, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6758__2.call(this, tsym6705, k);
      case 3:
        return G__6758__3.call(this, tsym6705, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6758
}();
cljs.core.RedNode.prototype.apply = function(tsym6702, args6703) {
  return tsym6702.call.apply(tsym6702, [tsym6702].concat(cljs.core.aclone.call(null, args6703)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6718 = this;
  return cljs.core.PersistentVector.fromArray([this__6718.key, this__6718.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6719 = this;
  return this__6719.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6720 = this;
  return this__6720.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6721 = this;
  var node__6722 = this;
  return new cljs.core.RedNode(this__6721.key, this__6721.val, this__6721.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6723 = this;
  var node__6724 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6725 = this;
  var node__6726 = this;
  return new cljs.core.RedNode(this__6725.key, this__6725.val, this__6725.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6727 = this;
  var node__6728 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6729 = this;
  var node__6730 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6730, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6731 = this;
  var node__6732 = this;
  return new cljs.core.RedNode(this__6731.key, this__6731.val, del, this__6731.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6733 = this;
  var node__6734 = this;
  return new cljs.core.RedNode(this__6733.key, this__6733.val, ins, this__6733.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6735 = this;
  var node__6736 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6735.left)) {
    return new cljs.core.RedNode(this__6735.key, this__6735.val, this__6735.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6735.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6735.right)) {
      return new cljs.core.RedNode(this__6735.right.key, this__6735.right.val, new cljs.core.BlackNode(this__6735.key, this__6735.val, this__6735.left, this__6735.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6735.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6736, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6759 = null;
  var G__6759__0 = function() {
    var this__6739 = this;
    var this$__6740 = this;
    return cljs.core.pr_str.call(null, this$__6740)
  };
  G__6759 = function() {
    switch(arguments.length) {
      case 0:
        return G__6759__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6759
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6741 = this;
  var node__6742 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6741.right)) {
    return new cljs.core.RedNode(this__6741.key, this__6741.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6741.left, null), this__6741.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6741.left)) {
      return new cljs.core.RedNode(this__6741.left.key, this__6741.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6741.left.left, null), new cljs.core.BlackNode(this__6741.key, this__6741.val, this__6741.left.right, this__6741.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6742, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6743 = this;
  var node__6744 = this;
  return new cljs.core.BlackNode(this__6743.key, this__6743.val, this__6743.left, this__6743.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6745 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6746 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6747 = this;
  return cljs.core.list.call(null, this__6747.key, this__6747.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6749 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6750 = this;
  return this__6750.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6751 = this;
  return cljs.core.PersistentVector.fromArray([this__6751.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6752 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6752.key, this__6752.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6753 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6754 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6754.key, this__6754.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6755 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6756 = this;
  if(n === 0) {
    return this__6756.key
  }else {
    if(n === 1) {
      return this__6756.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6757 = this;
  if(n === 0) {
    return this__6757.key
  }else {
    if(n === 1) {
      return this__6757.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6748 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6760 = comp.call(null, k, tree.key);
    if(c__6760 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6760 < 0) {
        var ins__6761 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6761 != null) {
          return tree.add_left(ins__6761)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6762 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6762 != null) {
            return tree.add_right(ins__6762)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6763 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6763)) {
            return new cljs.core.RedNode(app__6763.key, app__6763.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6763.left), new cljs.core.RedNode(right.key, right.val, app__6763.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6763, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6764 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6764)) {
              return new cljs.core.RedNode(app__6764.key, app__6764.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6764.left, null), new cljs.core.BlackNode(right.key, right.val, app__6764.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6764, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6765 = comp.call(null, k, tree.key);
    if(c__6765 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6765 < 0) {
        var del__6766 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6767 = del__6766 != null;
          if(or__3548__auto____6767) {
            return or__3548__auto____6767
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6766, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6766, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6768 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6769 = del__6768 != null;
            if(or__3548__auto____6769) {
              return or__3548__auto____6769
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6768)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6768, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6770 = tree.key;
  var c__6771 = comp.call(null, k, tk__6770);
  if(c__6771 === 0) {
    return tree.replace(tk__6770, v, tree.left, tree.right)
  }else {
    if(c__6771 < 0) {
      return tree.replace(tk__6770, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6770, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6776 = this;
  var h__364__auto____6777 = this__6776.__hash;
  if(h__364__auto____6777 != null) {
    return h__364__auto____6777
  }else {
    var h__364__auto____6778 = cljs.core.hash_imap.call(null, coll);
    this__6776.__hash = h__364__auto____6778;
    return h__364__auto____6778
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6779 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6780 = this;
  var n__6781 = coll.entry_at(k);
  if(n__6781 != null) {
    return n__6781.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6782 = this;
  var found__6783 = [null];
  var t__6784 = cljs.core.tree_map_add.call(null, this__6782.comp, this__6782.tree, k, v, found__6783);
  if(t__6784 == null) {
    var found_node__6785 = cljs.core.nth.call(null, found__6783, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6785.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6782.comp, cljs.core.tree_map_replace.call(null, this__6782.comp, this__6782.tree, k, v), this__6782.cnt, this__6782.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6782.comp, t__6784.blacken(), this__6782.cnt + 1, this__6782.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6786 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6818 = null;
  var G__6818__2 = function(tsym6774, k) {
    var this__6787 = this;
    var tsym6774__6788 = this;
    var coll__6789 = tsym6774__6788;
    return cljs.core._lookup.call(null, coll__6789, k)
  };
  var G__6818__3 = function(tsym6775, k, not_found) {
    var this__6790 = this;
    var tsym6775__6791 = this;
    var coll__6792 = tsym6775__6791;
    return cljs.core._lookup.call(null, coll__6792, k, not_found)
  };
  G__6818 = function(tsym6775, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6818__2.call(this, tsym6775, k);
      case 3:
        return G__6818__3.call(this, tsym6775, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6818
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6772, args6773) {
  return tsym6772.call.apply(tsym6772, [tsym6772].concat(cljs.core.aclone.call(null, args6773)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6793 = this;
  if(this__6793.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6793.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6794 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6795 = this;
  if(this__6795.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6795.tree, false, this__6795.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6796 = this;
  var this$__6797 = this;
  return cljs.core.pr_str.call(null, this$__6797)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6798 = this;
  var coll__6799 = this;
  var t__6800 = this__6798.tree;
  while(true) {
    if(t__6800 != null) {
      var c__6801 = this__6798.comp.call(null, k, t__6800.key);
      if(c__6801 === 0) {
        return t__6800
      }else {
        if(c__6801 < 0) {
          var G__6819 = t__6800.left;
          t__6800 = G__6819;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6820 = t__6800.right;
            t__6800 = G__6820;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6802 = this;
  if(this__6802.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6802.tree, ascending_QMARK_, this__6802.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6803 = this;
  if(this__6803.cnt > 0) {
    var stack__6804 = null;
    var t__6805 = this__6803.tree;
    while(true) {
      if(t__6805 != null) {
        var c__6806 = this__6803.comp.call(null, k, t__6805.key);
        if(c__6806 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6804, t__6805), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6806 < 0) {
              var G__6821 = cljs.core.conj.call(null, stack__6804, t__6805);
              var G__6822 = t__6805.left;
              stack__6804 = G__6821;
              t__6805 = G__6822;
              continue
            }else {
              var G__6823 = stack__6804;
              var G__6824 = t__6805.right;
              stack__6804 = G__6823;
              t__6805 = G__6824;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6806 > 0) {
                var G__6825 = cljs.core.conj.call(null, stack__6804, t__6805);
                var G__6826 = t__6805.right;
                stack__6804 = G__6825;
                t__6805 = G__6826;
                continue
              }else {
                var G__6827 = stack__6804;
                var G__6828 = t__6805.left;
                stack__6804 = G__6827;
                t__6805 = G__6828;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6804 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6804, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6807 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6808 = this;
  return this__6808.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6809 = this;
  if(this__6809.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6809.tree, true, this__6809.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6810 = this;
  return this__6810.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6811 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6812 = this;
  return new cljs.core.PersistentTreeMap(this__6812.comp, this__6812.tree, this__6812.cnt, meta, this__6812.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6816 = this;
  return this__6816.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6817 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6817.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6813 = this;
  var found__6814 = [null];
  var t__6815 = cljs.core.tree_map_remove.call(null, this__6813.comp, this__6813.tree, k, found__6814);
  if(t__6815 == null) {
    if(cljs.core.nth.call(null, found__6814, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6813.comp, null, 0, this__6813.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6813.comp, t__6815.blacken(), this__6813.cnt - 1, this__6813.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6829 = cljs.core.seq.call(null, keyvals);
    var out__6830 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6829)) {
        var G__6831 = cljs.core.nnext.call(null, in$__6829);
        var G__6832 = cljs.core.assoc_BANG_.call(null, out__6830, cljs.core.first.call(null, in$__6829), cljs.core.second.call(null, in$__6829));
        in$__6829 = G__6831;
        out__6830 = G__6832;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6830)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6833) {
    var keyvals = cljs.core.seq(arglist__6833);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6834) {
    var keyvals = cljs.core.seq(arglist__6834);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6835 = cljs.core.seq.call(null, keyvals);
    var out__6836 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6835)) {
        var G__6837 = cljs.core.nnext.call(null, in$__6835);
        var G__6838 = cljs.core.assoc.call(null, out__6836, cljs.core.first.call(null, in$__6835), cljs.core.second.call(null, in$__6835));
        in$__6835 = G__6837;
        out__6836 = G__6838;
        continue
      }else {
        return out__6836
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6839) {
    var keyvals = cljs.core.seq(arglist__6839);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6840 = cljs.core.seq.call(null, keyvals);
    var out__6841 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6840)) {
        var G__6842 = cljs.core.nnext.call(null, in$__6840);
        var G__6843 = cljs.core.assoc.call(null, out__6841, cljs.core.first.call(null, in$__6840), cljs.core.second.call(null, in$__6840));
        in$__6840 = G__6842;
        out__6841 = G__6843;
        continue
      }else {
        return out__6841
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6844) {
    var comparator = cljs.core.first(arglist__6844);
    var keyvals = cljs.core.rest(arglist__6844);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6845_SHARP_, p2__6846_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6847 = p1__6845_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6847)) {
            return or__3548__auto____6847
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6846_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6848) {
    var maps = cljs.core.seq(arglist__6848);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6851 = function(m, e) {
        var k__6849 = cljs.core.first.call(null, e);
        var v__6850 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6849)) {
          return cljs.core.assoc.call(null, m, k__6849, f.call(null, cljs.core.get.call(null, m, k__6849), v__6850))
        }else {
          return cljs.core.assoc.call(null, m, k__6849, v__6850)
        }
      };
      var merge2__6853 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6851, function() {
          var or__3548__auto____6852 = m1;
          if(cljs.core.truth_(or__3548__auto____6852)) {
            return or__3548__auto____6852
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6853, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6854) {
    var f = cljs.core.first(arglist__6854);
    var maps = cljs.core.rest(arglist__6854);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6855 = cljs.core.ObjMap.fromObject([], {});
  var keys__6856 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6856)) {
      var key__6857 = cljs.core.first.call(null, keys__6856);
      var entry__6858 = cljs.core.get.call(null, map, key__6857, "\ufdd0'user/not-found");
      var G__6859 = cljs.core.not_EQ_.call(null, entry__6858, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6855, key__6857, entry__6858) : ret__6855;
      var G__6860 = cljs.core.next.call(null, keys__6856);
      ret__6855 = G__6859;
      keys__6856 = G__6860;
      continue
    }else {
      return ret__6855
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6866 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6866.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6867 = this;
  var h__364__auto____6868 = this__6867.__hash;
  if(h__364__auto____6868 != null) {
    return h__364__auto____6868
  }else {
    var h__364__auto____6869 = cljs.core.hash_iset.call(null, coll);
    this__6867.__hash = h__364__auto____6869;
    return h__364__auto____6869
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6870 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6871 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6871.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6890 = null;
  var G__6890__2 = function(tsym6864, k) {
    var this__6872 = this;
    var tsym6864__6873 = this;
    var coll__6874 = tsym6864__6873;
    return cljs.core._lookup.call(null, coll__6874, k)
  };
  var G__6890__3 = function(tsym6865, k, not_found) {
    var this__6875 = this;
    var tsym6865__6876 = this;
    var coll__6877 = tsym6865__6876;
    return cljs.core._lookup.call(null, coll__6877, k, not_found)
  };
  G__6890 = function(tsym6865, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6890__2.call(this, tsym6865, k);
      case 3:
        return G__6890__3.call(this, tsym6865, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6890
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6862, args6863) {
  return tsym6862.call.apply(tsym6862, [tsym6862].concat(cljs.core.aclone.call(null, args6863)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6878 = this;
  return new cljs.core.PersistentHashSet(this__6878.meta, cljs.core.assoc.call(null, this__6878.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6879 = this;
  var this$__6880 = this;
  return cljs.core.pr_str.call(null, this$__6880)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6881 = this;
  return cljs.core.keys.call(null, this__6881.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6882 = this;
  return new cljs.core.PersistentHashSet(this__6882.meta, cljs.core.dissoc.call(null, this__6882.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6883 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6884 = this;
  var and__3546__auto____6885 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6885) {
    var and__3546__auto____6886 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6886) {
      return cljs.core.every_QMARK_.call(null, function(p1__6861_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6861_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6886
    }
  }else {
    return and__3546__auto____6885
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6887 = this;
  return new cljs.core.PersistentHashSet(meta, this__6887.hash_map, this__6887.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6888 = this;
  return this__6888.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6889 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6889.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6908 = null;
  var G__6908__2 = function(tsym6894, k) {
    var this__6896 = this;
    var tsym6894__6897 = this;
    var tcoll__6898 = tsym6894__6897;
    if(cljs.core._lookup.call(null, this__6896.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6908__3 = function(tsym6895, k, not_found) {
    var this__6899 = this;
    var tsym6895__6900 = this;
    var tcoll__6901 = tsym6895__6900;
    if(cljs.core._lookup.call(null, this__6899.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6908 = function(tsym6895, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6908__2.call(this, tsym6895, k);
      case 3:
        return G__6908__3.call(this, tsym6895, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6908
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6892, args6893) {
  return tsym6892.call.apply(tsym6892, [tsym6892].concat(cljs.core.aclone.call(null, args6893)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6902 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6903 = this;
  if(cljs.core._lookup.call(null, this__6903.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6904 = this;
  return cljs.core.count.call(null, this__6904.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6905 = this;
  this__6905.transient_map = cljs.core.dissoc_BANG_.call(null, this__6905.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6906 = this;
  this__6906.transient_map = cljs.core.assoc_BANG_.call(null, this__6906.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6907 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6907.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6913 = this;
  var h__364__auto____6914 = this__6913.__hash;
  if(h__364__auto____6914 != null) {
    return h__364__auto____6914
  }else {
    var h__364__auto____6915 = cljs.core.hash_iset.call(null, coll);
    this__6913.__hash = h__364__auto____6915;
    return h__364__auto____6915
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6916 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6917 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6917.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6941 = null;
  var G__6941__2 = function(tsym6911, k) {
    var this__6918 = this;
    var tsym6911__6919 = this;
    var coll__6920 = tsym6911__6919;
    return cljs.core._lookup.call(null, coll__6920, k)
  };
  var G__6941__3 = function(tsym6912, k, not_found) {
    var this__6921 = this;
    var tsym6912__6922 = this;
    var coll__6923 = tsym6912__6922;
    return cljs.core._lookup.call(null, coll__6923, k, not_found)
  };
  G__6941 = function(tsym6912, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6941__2.call(this, tsym6912, k);
      case 3:
        return G__6941__3.call(this, tsym6912, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6941
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6909, args6910) {
  return tsym6909.call.apply(tsym6909, [tsym6909].concat(cljs.core.aclone.call(null, args6910)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6924 = this;
  return new cljs.core.PersistentTreeSet(this__6924.meta, cljs.core.assoc.call(null, this__6924.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6925 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6925.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6926 = this;
  var this$__6927 = this;
  return cljs.core.pr_str.call(null, this$__6927)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6928 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6928.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6929 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6929.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6930 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6931 = this;
  return cljs.core._comparator.call(null, this__6931.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6932 = this;
  return cljs.core.keys.call(null, this__6932.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6933 = this;
  return new cljs.core.PersistentTreeSet(this__6933.meta, cljs.core.dissoc.call(null, this__6933.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6934 = this;
  return cljs.core.count.call(null, this__6934.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6935 = this;
  var and__3546__auto____6936 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6936) {
    var and__3546__auto____6937 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6937) {
      return cljs.core.every_QMARK_.call(null, function(p1__6891_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6891_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6937
    }
  }else {
    return and__3546__auto____6936
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6938 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6938.tree_map, this__6938.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6939 = this;
  return this__6939.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6940 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6940.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6942 = cljs.core.seq.call(null, coll);
  var out__6943 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6942))) {
      var G__6944 = cljs.core.next.call(null, in$__6942);
      var G__6945 = cljs.core.conj_BANG_.call(null, out__6943, cljs.core.first.call(null, in$__6942));
      in$__6942 = G__6944;
      out__6943 = G__6945;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6943)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6946) {
    var keys = cljs.core.seq(arglist__6946);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6948) {
    var comparator = cljs.core.first(arglist__6948);
    var keys = cljs.core.rest(arglist__6948);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6949 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6950 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6950)) {
        var e__6951 = temp__3695__auto____6950;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6951))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6949, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6947_SHARP_) {
      var temp__3695__auto____6952 = cljs.core.find.call(null, smap, p1__6947_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6952)) {
        var e__6953 = temp__3695__auto____6952;
        return cljs.core.second.call(null, e__6953)
      }else {
        return p1__6947_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6961 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6954, seen) {
        while(true) {
          var vec__6955__6956 = p__6954;
          var f__6957 = cljs.core.nth.call(null, vec__6955__6956, 0, null);
          var xs__6958 = vec__6955__6956;
          var temp__3698__auto____6959 = cljs.core.seq.call(null, xs__6958);
          if(cljs.core.truth_(temp__3698__auto____6959)) {
            var s__6960 = temp__3698__auto____6959;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6957)) {
              var G__6962 = cljs.core.rest.call(null, s__6960);
              var G__6963 = seen;
              p__6954 = G__6962;
              seen = G__6963;
              continue
            }else {
              return cljs.core.cons.call(null, f__6957, step.call(null, cljs.core.rest.call(null, s__6960), cljs.core.conj.call(null, seen, f__6957)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6961.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6964 = cljs.core.PersistentVector.fromArray([]);
  var s__6965 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6965))) {
      var G__6966 = cljs.core.conj.call(null, ret__6964, cljs.core.first.call(null, s__6965));
      var G__6967 = cljs.core.next.call(null, s__6965);
      ret__6964 = G__6966;
      s__6965 = G__6967;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6964)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6968 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6968) {
        return or__3548__auto____6968
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6969 = x.lastIndexOf("/");
      if(i__6969 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6969 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6970 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6970) {
      return or__3548__auto____6970
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6971 = x.lastIndexOf("/");
    if(i__6971 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6971)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6974 = cljs.core.ObjMap.fromObject([], {});
  var ks__6975 = cljs.core.seq.call(null, keys);
  var vs__6976 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6977 = ks__6975;
      if(cljs.core.truth_(and__3546__auto____6977)) {
        return vs__6976
      }else {
        return and__3546__auto____6977
      }
    }())) {
      var G__6978 = cljs.core.assoc.call(null, map__6974, cljs.core.first.call(null, ks__6975), cljs.core.first.call(null, vs__6976));
      var G__6979 = cljs.core.next.call(null, ks__6975);
      var G__6980 = cljs.core.next.call(null, vs__6976);
      map__6974 = G__6978;
      ks__6975 = G__6979;
      vs__6976 = G__6980;
      continue
    }else {
      return map__6974
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6983__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6972_SHARP_, p2__6973_SHARP_) {
        return max_key.call(null, k, p1__6972_SHARP_, p2__6973_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6983 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6983__delegate.call(this, k, x, y, more)
    };
    G__6983.cljs$lang$maxFixedArity = 3;
    G__6983.cljs$lang$applyTo = function(arglist__6984) {
      var k = cljs.core.first(arglist__6984);
      var x = cljs.core.first(cljs.core.next(arglist__6984));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6984)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6984)));
      return G__6983__delegate(k, x, y, more)
    };
    G__6983.cljs$lang$arity$variadic = G__6983__delegate;
    return G__6983
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6985__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6981_SHARP_, p2__6982_SHARP_) {
        return min_key.call(null, k, p1__6981_SHARP_, p2__6982_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6985 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6985__delegate.call(this, k, x, y, more)
    };
    G__6985.cljs$lang$maxFixedArity = 3;
    G__6985.cljs$lang$applyTo = function(arglist__6986) {
      var k = cljs.core.first(arglist__6986);
      var x = cljs.core.first(cljs.core.next(arglist__6986));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6986)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6986)));
      return G__6985__delegate(k, x, y, more)
    };
    G__6985.cljs$lang$arity$variadic = G__6985__delegate;
    return G__6985
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6987 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6987)) {
        var s__6988 = temp__3698__auto____6987;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6988), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6988)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6989 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6989)) {
      var s__6990 = temp__3698__auto____6989;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6990)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6990), take_while.call(null, pred, cljs.core.rest.call(null, s__6990)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6991 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6991.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6992 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6993 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6993)) {
        var vec__6994__6995 = temp__3698__auto____6993;
        var e__6996 = cljs.core.nth.call(null, vec__6994__6995, 0, null);
        var s__6997 = vec__6994__6995;
        if(cljs.core.truth_(include__6992.call(null, e__6996))) {
          return s__6997
        }else {
          return cljs.core.next.call(null, s__6997)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6992, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6998 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6998)) {
      var vec__6999__7000 = temp__3698__auto____6998;
      var e__7001 = cljs.core.nth.call(null, vec__6999__7000, 0, null);
      var s__7002 = vec__6999__7000;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__7001)) ? s__7002 : cljs.core.next.call(null, s__7002))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__7003 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____7004 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____7004)) {
        var vec__7005__7006 = temp__3698__auto____7004;
        var e__7007 = cljs.core.nth.call(null, vec__7005__7006, 0, null);
        var s__7008 = vec__7005__7006;
        if(cljs.core.truth_(include__7003.call(null, e__7007))) {
          return s__7008
        }else {
          return cljs.core.next.call(null, s__7008)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__7003, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7009 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____7009)) {
      var vec__7010__7011 = temp__3698__auto____7009;
      var e__7012 = cljs.core.nth.call(null, vec__7010__7011, 0, null);
      var s__7013 = vec__7010__7011;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__7012)) ? s__7013 : cljs.core.next.call(null, s__7013))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__7014 = this;
  var h__364__auto____7015 = this__7014.__hash;
  if(h__364__auto____7015 != null) {
    return h__364__auto____7015
  }else {
    var h__364__auto____7016 = cljs.core.hash_coll.call(null, rng);
    this__7014.__hash = h__364__auto____7016;
    return h__364__auto____7016
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__7017 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__7018 = this;
  var this$__7019 = this;
  return cljs.core.pr_str.call(null, this$__7019)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__7020 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__7021 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__7022 = this;
  var comp__7023 = this__7022.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__7023.call(null, this__7022.start, this__7022.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__7024 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__7024.end - this__7024.start) / this__7024.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__7025 = this;
  return this__7025.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__7026 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__7026.meta, this__7026.start + this__7026.step, this__7026.end, this__7026.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__7027 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__7028 = this;
  return new cljs.core.Range(meta, this__7028.start, this__7028.end, this__7028.step, this__7028.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__7029 = this;
  return this__7029.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__7030 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7030.start + n * this__7030.step
  }else {
    if(function() {
      var and__3546__auto____7031 = this__7030.start > this__7030.end;
      if(and__3546__auto____7031) {
        return this__7030.step === 0
      }else {
        return and__3546__auto____7031
      }
    }()) {
      return this__7030.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__7032 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7032.start + n * this__7032.step
  }else {
    if(function() {
      var and__3546__auto____7033 = this__7032.start > this__7032.end;
      if(and__3546__auto____7033) {
        return this__7032.step === 0
      }else {
        return and__3546__auto____7033
      }
    }()) {
      return this__7032.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__7034 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7034.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7035 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7035)) {
      var s__7036 = temp__3698__auto____7035;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__7036), take_nth.call(null, n, cljs.core.drop.call(null, n, s__7036)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7038 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7038)) {
      var s__7039 = temp__3698__auto____7038;
      var fst__7040 = cljs.core.first.call(null, s__7039);
      var fv__7041 = f.call(null, fst__7040);
      var run__7042 = cljs.core.cons.call(null, fst__7040, cljs.core.take_while.call(null, function(p1__7037_SHARP_) {
        return cljs.core._EQ_.call(null, fv__7041, f.call(null, p1__7037_SHARP_))
      }, cljs.core.next.call(null, s__7039)));
      return cljs.core.cons.call(null, run__7042, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__7042), s__7039))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____7053 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____7053)) {
        var s__7054 = temp__3695__auto____7053;
        return reductions.call(null, f, cljs.core.first.call(null, s__7054), cljs.core.rest.call(null, s__7054))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____7055 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____7055)) {
        var s__7056 = temp__3698__auto____7055;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__7056)), cljs.core.rest.call(null, s__7056))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__7058 = null;
      var G__7058__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__7058__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__7058__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__7058__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__7058__4 = function() {
        var G__7059__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__7059 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7059__delegate.call(this, x, y, z, args)
        };
        G__7059.cljs$lang$maxFixedArity = 3;
        G__7059.cljs$lang$applyTo = function(arglist__7060) {
          var x = cljs.core.first(arglist__7060);
          var y = cljs.core.first(cljs.core.next(arglist__7060));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7060)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7060)));
          return G__7059__delegate(x, y, z, args)
        };
        G__7059.cljs$lang$arity$variadic = G__7059__delegate;
        return G__7059
      }();
      G__7058 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7058__0.call(this);
          case 1:
            return G__7058__1.call(this, x);
          case 2:
            return G__7058__2.call(this, x, y);
          case 3:
            return G__7058__3.call(this, x, y, z);
          default:
            return G__7058__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7058.cljs$lang$maxFixedArity = 3;
      G__7058.cljs$lang$applyTo = G__7058__4.cljs$lang$applyTo;
      return G__7058
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__7061 = null;
      var G__7061__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__7061__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__7061__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__7061__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__7061__4 = function() {
        var G__7062__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__7062 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7062__delegate.call(this, x, y, z, args)
        };
        G__7062.cljs$lang$maxFixedArity = 3;
        G__7062.cljs$lang$applyTo = function(arglist__7063) {
          var x = cljs.core.first(arglist__7063);
          var y = cljs.core.first(cljs.core.next(arglist__7063));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7063)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7063)));
          return G__7062__delegate(x, y, z, args)
        };
        G__7062.cljs$lang$arity$variadic = G__7062__delegate;
        return G__7062
      }();
      G__7061 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7061__0.call(this);
          case 1:
            return G__7061__1.call(this, x);
          case 2:
            return G__7061__2.call(this, x, y);
          case 3:
            return G__7061__3.call(this, x, y, z);
          default:
            return G__7061__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7061.cljs$lang$maxFixedArity = 3;
      G__7061.cljs$lang$applyTo = G__7061__4.cljs$lang$applyTo;
      return G__7061
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__7064 = null;
      var G__7064__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__7064__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__7064__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__7064__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__7064__4 = function() {
        var G__7065__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__7065 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7065__delegate.call(this, x, y, z, args)
        };
        G__7065.cljs$lang$maxFixedArity = 3;
        G__7065.cljs$lang$applyTo = function(arglist__7066) {
          var x = cljs.core.first(arglist__7066);
          var y = cljs.core.first(cljs.core.next(arglist__7066));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7066)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7066)));
          return G__7065__delegate(x, y, z, args)
        };
        G__7065.cljs$lang$arity$variadic = G__7065__delegate;
        return G__7065
      }();
      G__7064 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7064__0.call(this);
          case 1:
            return G__7064__1.call(this, x);
          case 2:
            return G__7064__2.call(this, x, y);
          case 3:
            return G__7064__3.call(this, x, y, z);
          default:
            return G__7064__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7064.cljs$lang$maxFixedArity = 3;
      G__7064.cljs$lang$applyTo = G__7064__4.cljs$lang$applyTo;
      return G__7064
    }()
  };
  var juxt__4 = function() {
    var G__7067__delegate = function(f, g, h, fs) {
      var fs__7057 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__7068 = null;
        var G__7068__0 = function() {
          return cljs.core.reduce.call(null, function(p1__7043_SHARP_, p2__7044_SHARP_) {
            return cljs.core.conj.call(null, p1__7043_SHARP_, p2__7044_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__7057)
        };
        var G__7068__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__7045_SHARP_, p2__7046_SHARP_) {
            return cljs.core.conj.call(null, p1__7045_SHARP_, p2__7046_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__7057)
        };
        var G__7068__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__7047_SHARP_, p2__7048_SHARP_) {
            return cljs.core.conj.call(null, p1__7047_SHARP_, p2__7048_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__7057)
        };
        var G__7068__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__7049_SHARP_, p2__7050_SHARP_) {
            return cljs.core.conj.call(null, p1__7049_SHARP_, p2__7050_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__7057)
        };
        var G__7068__4 = function() {
          var G__7069__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__7051_SHARP_, p2__7052_SHARP_) {
              return cljs.core.conj.call(null, p1__7051_SHARP_, cljs.core.apply.call(null, p2__7052_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__7057)
          };
          var G__7069 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__7069__delegate.call(this, x, y, z, args)
          };
          G__7069.cljs$lang$maxFixedArity = 3;
          G__7069.cljs$lang$applyTo = function(arglist__7070) {
            var x = cljs.core.first(arglist__7070);
            var y = cljs.core.first(cljs.core.next(arglist__7070));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7070)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7070)));
            return G__7069__delegate(x, y, z, args)
          };
          G__7069.cljs$lang$arity$variadic = G__7069__delegate;
          return G__7069
        }();
        G__7068 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__7068__0.call(this);
            case 1:
              return G__7068__1.call(this, x);
            case 2:
              return G__7068__2.call(this, x, y);
            case 3:
              return G__7068__3.call(this, x, y, z);
            default:
              return G__7068__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__7068.cljs$lang$maxFixedArity = 3;
        G__7068.cljs$lang$applyTo = G__7068__4.cljs$lang$applyTo;
        return G__7068
      }()
    };
    var G__7067 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7067__delegate.call(this, f, g, h, fs)
    };
    G__7067.cljs$lang$maxFixedArity = 3;
    G__7067.cljs$lang$applyTo = function(arglist__7071) {
      var f = cljs.core.first(arglist__7071);
      var g = cljs.core.first(cljs.core.next(arglist__7071));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7071)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7071)));
      return G__7067__delegate(f, g, h, fs)
    };
    G__7067.cljs$lang$arity$variadic = G__7067__delegate;
    return G__7067
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__7073 = cljs.core.next.call(null, coll);
        coll = G__7073;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____7072 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____7072)) {
          return n > 0
        }else {
          return and__3546__auto____7072
        }
      }())) {
        var G__7074 = n - 1;
        var G__7075 = cljs.core.next.call(null, coll);
        n = G__7074;
        coll = G__7075;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__7076 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__7076), s)) {
    if(cljs.core.count.call(null, matches__7076) === 1) {
      return cljs.core.first.call(null, matches__7076)
    }else {
      return cljs.core.vec.call(null, matches__7076)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__7077 = re.exec(s);
  if(matches__7077 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__7077) === 1) {
      return cljs.core.first.call(null, matches__7077)
    }else {
      return cljs.core.vec.call(null, matches__7077)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__7078 = cljs.core.re_find.call(null, re, s);
  var match_idx__7079 = s.search(re);
  var match_str__7080 = cljs.core.coll_QMARK_.call(null, match_data__7078) ? cljs.core.first.call(null, match_data__7078) : match_data__7078;
  var post_match__7081 = cljs.core.subs.call(null, s, match_idx__7079 + cljs.core.count.call(null, match_str__7080));
  if(cljs.core.truth_(match_data__7078)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__7078, re_seq.call(null, re, post_match__7081))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__7083__7084 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___7085 = cljs.core.nth.call(null, vec__7083__7084, 0, null);
  var flags__7086 = cljs.core.nth.call(null, vec__7083__7084, 1, null);
  var pattern__7087 = cljs.core.nth.call(null, vec__7083__7084, 2, null);
  return new RegExp(pattern__7087, flags__7086)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__7082_SHARP_) {
    return print_one.call(null, p1__7082_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____7088 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____7088)) {
            var and__3546__auto____7092 = function() {
              var G__7089__7090 = obj;
              if(G__7089__7090 != null) {
                if(function() {
                  var or__3548__auto____7091 = G__7089__7090.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____7091) {
                    return or__3548__auto____7091
                  }else {
                    return G__7089__7090.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__7089__7090.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7089__7090)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7089__7090)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____7092)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____7092
            }
          }else {
            return and__3546__auto____7088
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____7093 = obj != null;
          if(and__3546__auto____7093) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____7093
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__7094__7095 = obj;
          if(G__7094__7095 != null) {
            if(function() {
              var or__3548__auto____7096 = G__7094__7095.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____7096) {
                return or__3548__auto____7096
              }else {
                return G__7094__7095.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__7094__7095.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7094__7095)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7094__7095)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__7097 = cljs.core.first.call(null, objs);
  var sb__7098 = new goog.string.StringBuffer;
  var G__7099__7100 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7099__7100)) {
    var obj__7101 = cljs.core.first.call(null, G__7099__7100);
    var G__7099__7102 = G__7099__7100;
    while(true) {
      if(obj__7101 === first_obj__7097) {
      }else {
        sb__7098.append(" ")
      }
      var G__7103__7104 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7101, opts));
      if(cljs.core.truth_(G__7103__7104)) {
        var string__7105 = cljs.core.first.call(null, G__7103__7104);
        var G__7103__7106 = G__7103__7104;
        while(true) {
          sb__7098.append(string__7105);
          var temp__3698__auto____7107 = cljs.core.next.call(null, G__7103__7106);
          if(cljs.core.truth_(temp__3698__auto____7107)) {
            var G__7103__7108 = temp__3698__auto____7107;
            var G__7111 = cljs.core.first.call(null, G__7103__7108);
            var G__7112 = G__7103__7108;
            string__7105 = G__7111;
            G__7103__7106 = G__7112;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7109 = cljs.core.next.call(null, G__7099__7102);
      if(cljs.core.truth_(temp__3698__auto____7109)) {
        var G__7099__7110 = temp__3698__auto____7109;
        var G__7113 = cljs.core.first.call(null, G__7099__7110);
        var G__7114 = G__7099__7110;
        obj__7101 = G__7113;
        G__7099__7102 = G__7114;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__7098
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__7115 = cljs.core.pr_sb.call(null, objs, opts);
  sb__7115.append("\n");
  return[cljs.core.str(sb__7115)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__7116 = cljs.core.first.call(null, objs);
  var G__7117__7118 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7117__7118)) {
    var obj__7119 = cljs.core.first.call(null, G__7117__7118);
    var G__7117__7120 = G__7117__7118;
    while(true) {
      if(obj__7119 === first_obj__7116) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__7121__7122 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7119, opts));
      if(cljs.core.truth_(G__7121__7122)) {
        var string__7123 = cljs.core.first.call(null, G__7121__7122);
        var G__7121__7124 = G__7121__7122;
        while(true) {
          cljs.core.string_print.call(null, string__7123);
          var temp__3698__auto____7125 = cljs.core.next.call(null, G__7121__7124);
          if(cljs.core.truth_(temp__3698__auto____7125)) {
            var G__7121__7126 = temp__3698__auto____7125;
            var G__7129 = cljs.core.first.call(null, G__7121__7126);
            var G__7130 = G__7121__7126;
            string__7123 = G__7129;
            G__7121__7124 = G__7130;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7127 = cljs.core.next.call(null, G__7117__7120);
      if(cljs.core.truth_(temp__3698__auto____7127)) {
        var G__7117__7128 = temp__3698__auto____7127;
        var G__7131 = cljs.core.first.call(null, G__7117__7128);
        var G__7132 = G__7117__7128;
        obj__7119 = G__7131;
        G__7117__7120 = G__7132;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__7133) {
    var objs = cljs.core.seq(arglist__7133);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__7134) {
    var objs = cljs.core.seq(arglist__7134);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__7135) {
    var objs = cljs.core.seq(arglist__7135);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__7136) {
    var objs = cljs.core.seq(arglist__7136);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__7137) {
    var objs = cljs.core.seq(arglist__7137);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__7138) {
    var objs = cljs.core.seq(arglist__7138);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__7139) {
    var objs = cljs.core.seq(arglist__7139);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__7140) {
    var objs = cljs.core.seq(arglist__7140);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7141 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7141, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7142 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7142, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7143 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7143, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____7144 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____7144)) {
        var nspc__7145 = temp__3698__auto____7144;
        return[cljs.core.str(nspc__7145), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____7146 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____7146)) {
          var nspc__7147 = temp__3698__auto____7146;
          return[cljs.core.str(nspc__7147), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7148 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7148, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7149 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7149, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7150 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__7151 = this;
  var G__7152__7153 = cljs.core.seq.call(null, this__7151.watches);
  if(cljs.core.truth_(G__7152__7153)) {
    var G__7155__7157 = cljs.core.first.call(null, G__7152__7153);
    var vec__7156__7158 = G__7155__7157;
    var key__7159 = cljs.core.nth.call(null, vec__7156__7158, 0, null);
    var f__7160 = cljs.core.nth.call(null, vec__7156__7158, 1, null);
    var G__7152__7161 = G__7152__7153;
    var G__7155__7162 = G__7155__7157;
    var G__7152__7163 = G__7152__7161;
    while(true) {
      var vec__7164__7165 = G__7155__7162;
      var key__7166 = cljs.core.nth.call(null, vec__7164__7165, 0, null);
      var f__7167 = cljs.core.nth.call(null, vec__7164__7165, 1, null);
      var G__7152__7168 = G__7152__7163;
      f__7167.call(null, key__7166, this$, oldval, newval);
      var temp__3698__auto____7169 = cljs.core.next.call(null, G__7152__7168);
      if(cljs.core.truth_(temp__3698__auto____7169)) {
        var G__7152__7170 = temp__3698__auto____7169;
        var G__7177 = cljs.core.first.call(null, G__7152__7170);
        var G__7178 = G__7152__7170;
        G__7155__7162 = G__7177;
        G__7152__7163 = G__7178;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__7171 = this;
  return this$.watches = cljs.core.assoc.call(null, this__7171.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__7172 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__7172.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__7173 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__7173.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__7174 = this;
  return this__7174.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7175 = this;
  return this__7175.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__7176 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7185__delegate = function(x, p__7179) {
      var map__7180__7181 = p__7179;
      var map__7180__7182 = cljs.core.seq_QMARK_.call(null, map__7180__7181) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7180__7181) : map__7180__7181;
      var validator__7183 = cljs.core.get.call(null, map__7180__7182, "\ufdd0'validator");
      var meta__7184 = cljs.core.get.call(null, map__7180__7182, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7184, validator__7183, null)
    };
    var G__7185 = function(x, var_args) {
      var p__7179 = null;
      if(goog.isDef(var_args)) {
        p__7179 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7185__delegate.call(this, x, p__7179)
    };
    G__7185.cljs$lang$maxFixedArity = 1;
    G__7185.cljs$lang$applyTo = function(arglist__7186) {
      var x = cljs.core.first(arglist__7186);
      var p__7179 = cljs.core.rest(arglist__7186);
      return G__7185__delegate(x, p__7179)
    };
    G__7185.cljs$lang$arity$variadic = G__7185__delegate;
    return G__7185
  }();
  atom = function(x, var_args) {
    var p__7179 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7187 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7187)) {
    var validate__7188 = temp__3698__auto____7187;
    if(cljs.core.truth_(validate__7188.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7189 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7189, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7190__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7190 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7190__delegate.call(this, a, f, x, y, z, more)
    };
    G__7190.cljs$lang$maxFixedArity = 5;
    G__7190.cljs$lang$applyTo = function(arglist__7191) {
      var a = cljs.core.first(arglist__7191);
      var f = cljs.core.first(cljs.core.next(arglist__7191));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7191)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7191))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7191)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7191)))));
      return G__7190__delegate(a, f, x, y, z, more)
    };
    G__7190.cljs$lang$arity$variadic = G__7190__delegate;
    return G__7190
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7192) {
    var iref = cljs.core.first(arglist__7192);
    var f = cljs.core.first(cljs.core.next(arglist__7192));
    var args = cljs.core.rest(cljs.core.next(arglist__7192));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7193 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7193.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7194 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7194.state, function(p__7195) {
    var curr_state__7196 = p__7195;
    var curr_state__7197 = cljs.core.seq_QMARK_.call(null, curr_state__7196) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7196) : curr_state__7196;
    var done__7198 = cljs.core.get.call(null, curr_state__7197, "\ufdd0'done");
    if(cljs.core.truth_(done__7198)) {
      return curr_state__7197
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7194.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7199__7200 = options;
    var map__7199__7201 = cljs.core.seq_QMARK_.call(null, map__7199__7200) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7199__7200) : map__7199__7200;
    var keywordize_keys__7202 = cljs.core.get.call(null, map__7199__7201, "\ufdd0'keywordize-keys");
    var keyfn__7203 = cljs.core.truth_(keywordize_keys__7202) ? cljs.core.keyword : cljs.core.str;
    var f__7209 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7208 = function iter__7204(s__7205) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7205__7206 = s__7205;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7205__7206))) {
                        var k__7207 = cljs.core.first.call(null, s__7205__7206);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7203.call(null, k__7207), thisfn.call(null, x[k__7207])]), iter__7204.call(null, cljs.core.rest.call(null, s__7205__7206)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7208.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7209.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7210) {
    var x = cljs.core.first(arglist__7210);
    var options = cljs.core.rest(arglist__7210);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7211 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7215__delegate = function(args) {
      var temp__3695__auto____7212 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7211), args);
      if(cljs.core.truth_(temp__3695__auto____7212)) {
        var v__7213 = temp__3695__auto____7212;
        return v__7213
      }else {
        var ret__7214 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7211, cljs.core.assoc, args, ret__7214);
        return ret__7214
      }
    };
    var G__7215 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7215__delegate.call(this, args)
    };
    G__7215.cljs$lang$maxFixedArity = 0;
    G__7215.cljs$lang$applyTo = function(arglist__7216) {
      var args = cljs.core.seq(arglist__7216);
      return G__7215__delegate(args)
    };
    G__7215.cljs$lang$arity$variadic = G__7215__delegate;
    return G__7215
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7217 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7217)) {
        var G__7218 = ret__7217;
        f = G__7218;
        continue
      }else {
        return ret__7217
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7219__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7219 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7219__delegate.call(this, f, args)
    };
    G__7219.cljs$lang$maxFixedArity = 1;
    G__7219.cljs$lang$applyTo = function(arglist__7220) {
      var f = cljs.core.first(arglist__7220);
      var args = cljs.core.rest(arglist__7220);
      return G__7219__delegate(f, args)
    };
    G__7219.cljs$lang$arity$variadic = G__7219__delegate;
    return G__7219
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7221 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7221, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7221, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7222 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7222) {
      return or__3548__auto____7222
    }else {
      var or__3548__auto____7223 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7223) {
        return or__3548__auto____7223
      }else {
        var and__3546__auto____7224 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7224) {
          var and__3546__auto____7225 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7225) {
            var and__3546__auto____7226 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7226) {
              var ret__7227 = true;
              var i__7228 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7229 = cljs.core.not.call(null, ret__7227);
                  if(or__3548__auto____7229) {
                    return or__3548__auto____7229
                  }else {
                    return i__7228 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7227
                }else {
                  var G__7230 = isa_QMARK_.call(null, h, child.call(null, i__7228), parent.call(null, i__7228));
                  var G__7231 = i__7228 + 1;
                  ret__7227 = G__7230;
                  i__7228 = G__7231;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7226
            }
          }else {
            return and__3546__auto____7225
          }
        }else {
          return and__3546__auto____7224
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7235 = "\ufdd0'parents".call(null, h);
    var td__7236 = "\ufdd0'descendants".call(null, h);
    var ta__7237 = "\ufdd0'ancestors".call(null, h);
    var tf__7238 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7239 = cljs.core.contains_QMARK_.call(null, tp__7235.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7237.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7237.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7235, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7238.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7236, parent, ta__7237), "\ufdd0'descendants":tf__7238.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7237, tag, td__7236)})
    }();
    if(cljs.core.truth_(or__3548__auto____7239)) {
      return or__3548__auto____7239
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7240 = "\ufdd0'parents".call(null, h);
    var childsParents__7241 = cljs.core.truth_(parentMap__7240.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7240.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7242 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7241)) ? cljs.core.assoc.call(null, parentMap__7240, tag, childsParents__7241) : cljs.core.dissoc.call(null, parentMap__7240, tag);
    var deriv_seq__7243 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7232_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7232_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7232_SHARP_), cljs.core.second.call(null, p1__7232_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7242)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7240.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7233_SHARP_, p2__7234_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7233_SHARP_, p2__7234_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7243))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7244 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7246 = cljs.core.truth_(function() {
    var and__3546__auto____7245 = xprefs__7244;
    if(cljs.core.truth_(and__3546__auto____7245)) {
      return xprefs__7244.call(null, y)
    }else {
      return and__3546__auto____7245
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7246)) {
    return or__3548__auto____7246
  }else {
    var or__3548__auto____7248 = function() {
      var ps__7247 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7247) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7247), prefer_table))) {
          }else {
          }
          var G__7251 = cljs.core.rest.call(null, ps__7247);
          ps__7247 = G__7251;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7248)) {
      return or__3548__auto____7248
    }else {
      var or__3548__auto____7250 = function() {
        var ps__7249 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7249) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7249), y, prefer_table))) {
            }else {
            }
            var G__7252 = cljs.core.rest.call(null, ps__7249);
            ps__7249 = G__7252;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7250)) {
        return or__3548__auto____7250
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7253 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7253)) {
    return or__3548__auto____7253
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7262 = cljs.core.reduce.call(null, function(be, p__7254) {
    var vec__7255__7256 = p__7254;
    var k__7257 = cljs.core.nth.call(null, vec__7255__7256, 0, null);
    var ___7258 = cljs.core.nth.call(null, vec__7255__7256, 1, null);
    var e__7259 = vec__7255__7256;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7257)) {
      var be2__7261 = cljs.core.truth_(function() {
        var or__3548__auto____7260 = be == null;
        if(or__3548__auto____7260) {
          return or__3548__auto____7260
        }else {
          return cljs.core.dominates.call(null, k__7257, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7259 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7261), k__7257, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7257), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7261)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7261
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7262)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7262));
      return cljs.core.second.call(null, best_entry__7262)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7263 = mf;
    if(and__3546__auto____7263) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7263
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7264 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7264) {
        return or__3548__auto____7264
      }else {
        var or__3548__auto____7265 = cljs.core._reset["_"];
        if(or__3548__auto____7265) {
          return or__3548__auto____7265
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7266 = mf;
    if(and__3546__auto____7266) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7266
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7267 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7267) {
        return or__3548__auto____7267
      }else {
        var or__3548__auto____7268 = cljs.core._add_method["_"];
        if(or__3548__auto____7268) {
          return or__3548__auto____7268
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7269 = mf;
    if(and__3546__auto____7269) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7269
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7270 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7270) {
        return or__3548__auto____7270
      }else {
        var or__3548__auto____7271 = cljs.core._remove_method["_"];
        if(or__3548__auto____7271) {
          return or__3548__auto____7271
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7272 = mf;
    if(and__3546__auto____7272) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7272
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7273 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7273) {
        return or__3548__auto____7273
      }else {
        var or__3548__auto____7274 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7274) {
          return or__3548__auto____7274
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7275 = mf;
    if(and__3546__auto____7275) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7275
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7276 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7276) {
        return or__3548__auto____7276
      }else {
        var or__3548__auto____7277 = cljs.core._get_method["_"];
        if(or__3548__auto____7277) {
          return or__3548__auto____7277
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7278 = mf;
    if(and__3546__auto____7278) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7278
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7279 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7279) {
        return or__3548__auto____7279
      }else {
        var or__3548__auto____7280 = cljs.core._methods["_"];
        if(or__3548__auto____7280) {
          return or__3548__auto____7280
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7281 = mf;
    if(and__3546__auto____7281) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7281
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7282 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7282) {
        return or__3548__auto____7282
      }else {
        var or__3548__auto____7283 = cljs.core._prefers["_"];
        if(or__3548__auto____7283) {
          return or__3548__auto____7283
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7284 = mf;
    if(and__3546__auto____7284) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7284
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7285 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7285) {
        return or__3548__auto____7285
      }else {
        var or__3548__auto____7286 = cljs.core._dispatch["_"];
        if(or__3548__auto____7286) {
          return or__3548__auto____7286
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7287 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7288 = cljs.core._get_method.call(null, mf, dispatch_val__7287);
  if(cljs.core.truth_(target_fn__7288)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7287)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7288, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7289 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7290 = this;
  cljs.core.swap_BANG_.call(null, this__7290.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7290.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7290.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7290.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7291 = this;
  cljs.core.swap_BANG_.call(null, this__7291.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7291.method_cache, this__7291.method_table, this__7291.cached_hierarchy, this__7291.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7292 = this;
  cljs.core.swap_BANG_.call(null, this__7292.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7292.method_cache, this__7292.method_table, this__7292.cached_hierarchy, this__7292.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7293 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7293.cached_hierarchy), cljs.core.deref.call(null, this__7293.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7293.method_cache, this__7293.method_table, this__7293.cached_hierarchy, this__7293.hierarchy)
  }
  var temp__3695__auto____7294 = cljs.core.deref.call(null, this__7293.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7294)) {
    var target_fn__7295 = temp__3695__auto____7294;
    return target_fn__7295
  }else {
    var temp__3695__auto____7296 = cljs.core.find_and_cache_best_method.call(null, this__7293.name, dispatch_val, this__7293.hierarchy, this__7293.method_table, this__7293.prefer_table, this__7293.method_cache, this__7293.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7296)) {
      var target_fn__7297 = temp__3695__auto____7296;
      return target_fn__7297
    }else {
      return cljs.core.deref.call(null, this__7293.method_table).call(null, this__7293.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7298 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7298.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7298.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7298.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7298.method_cache, this__7298.method_table, this__7298.cached_hierarchy, this__7298.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7299 = this;
  return cljs.core.deref.call(null, this__7299.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7300 = this;
  return cljs.core.deref.call(null, this__7300.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7301 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7301.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7302__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7302 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7302__delegate.call(this, _, args)
  };
  G__7302.cljs$lang$maxFixedArity = 1;
  G__7302.cljs$lang$applyTo = function(arglist__7303) {
    var _ = cljs.core.first(arglist__7303);
    var args = cljs.core.rest(arglist__7303);
    return G__7302__delegate(_, args)
  };
  G__7302.cljs$lang$arity$variadic = G__7302__delegate;
  return G__7302
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7465 = reader;
    if(and__3546__auto____7465) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7465
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7466 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7466) {
        return or__3548__auto____7466
      }else {
        var or__3548__auto____7467 = cljs.reader.read_char["_"];
        if(or__3548__auto____7467) {
          return or__3548__auto____7467
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7468 = reader;
    if(and__3546__auto____7468) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7468
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7469 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7469) {
        return or__3548__auto____7469
      }else {
        var or__3548__auto____7470 = cljs.reader.unread["_"];
        if(or__3548__auto____7470) {
          return or__3548__auto____7470
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7471 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7471.buffer_atom))) {
    var idx__7472 = cljs.core.deref.call(null, this__7471.index_atom);
    cljs.core.swap_BANG_.call(null, this__7471.index_atom, cljs.core.inc);
    return this__7471.s[idx__7472]
  }else {
    var buf__7473 = cljs.core.deref.call(null, this__7471.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7471.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7473)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7474 = this;
  return cljs.core.swap_BANG_.call(null, this__7474.buffer_atom, function(p1__7464_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7464_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7475 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7475)) {
    return or__3548__auto____7475
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7476 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7476) {
    return or__3548__auto____7476
  }else {
    var and__3546__auto____7478 = function() {
      var or__3548__auto____7477 = "+" === initch;
      if(or__3548__auto____7477) {
        return or__3548__auto____7477
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7478)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7479 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7479);
        return next_ch__7479
      }())
    }else {
      return and__3546__auto____7478
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7480) {
    var rdr = cljs.core.first(arglist__7480);
    var msg = cljs.core.rest(arglist__7480);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7481 = ch != "#";
  if(and__3546__auto____7481) {
    var and__3546__auto____7482 = ch != "'";
    if(and__3546__auto____7482) {
      var and__3546__auto____7483 = ch != ":";
      if(and__3546__auto____7483) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7483
      }
    }else {
      return and__3546__auto____7482
    }
  }else {
    return and__3546__auto____7481
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7484 = new goog.string.StringBuffer(initch);
  var ch__7485 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7486 = ch__7485 == null;
      if(or__3548__auto____7486) {
        return or__3548__auto____7486
      }else {
        var or__3548__auto____7487 = cljs.reader.whitespace_QMARK_.call(null, ch__7485);
        if(or__3548__auto____7487) {
          return or__3548__auto____7487
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7485)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7485);
      return sb__7484.toString()
    }else {
      var G__7488 = function() {
        sb__7484.append(ch__7485);
        return sb__7484
      }();
      var G__7489 = cljs.reader.read_char.call(null, rdr);
      sb__7484 = G__7488;
      ch__7485 = G__7489;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7490 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7491 = ch__7490 === "n";
      if(or__3548__auto____7491) {
        return or__3548__auto____7491
      }else {
        var or__3548__auto____7492 = ch__7490 === "r";
        if(or__3548__auto____7492) {
          return or__3548__auto____7492
        }else {
          return ch__7490 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7493 = re.exec(s);
  if(matches__7493 != null) {
    if(matches__7493.length === 1) {
      return matches__7493[0]
    }else {
      return matches__7493
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7494 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7495 = groups__7494[2];
  if(!function() {
    var or__3548__auto____7496 = group3__7495 == null;
    if(or__3548__auto____7496) {
      return or__3548__auto____7496
    }else {
      return group3__7495.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7497 = "-" === groups__7494[1] ? -1 : 1;
    var a__7498 = cljs.core.truth_(groups__7494[3]) ? [groups__7494[3], 10] : cljs.core.truth_(groups__7494[4]) ? [groups__7494[4], 16] : cljs.core.truth_(groups__7494[5]) ? [groups__7494[5], 8] : cljs.core.truth_(groups__7494[7]) ? [groups__7494[7], parseInt(groups__7494[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7499 = a__7498[0];
    var radix__7500 = a__7498[1];
    if(n__7499 == null) {
      return null
    }else {
      return negate__7497 * parseInt(n__7499, radix__7500)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7501 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7502 = groups__7501[1];
  var denominator__7503 = groups__7501[2];
  return parseInt(numinator__7502) / parseInt(denominator__7503)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7504 = re.exec(s);
  if(function() {
    var and__3546__auto____7505 = matches__7504 != null;
    if(and__3546__auto____7505) {
      return matches__7504[0] === s
    }else {
      return and__3546__auto____7505
    }
  }()) {
    if(matches__7504.length === 1) {
      return matches__7504[0]
    }else {
      return matches__7504
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7506 = cljs.reader.read_char.call(null, reader);
  var mapresult__7507 = cljs.reader.escape_char_map.call(null, ch__7506);
  if(cljs.core.truth_(mapresult__7507)) {
    return mapresult__7507
  }else {
    if(function() {
      var or__3548__auto____7508 = "u" === ch__7506;
      if(or__3548__auto____7508) {
        return or__3548__auto____7508
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7506)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7506)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7506)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7509 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7509))) {
      var G__7510 = cljs.reader.read_char.call(null, rdr);
      ch__7509 = G__7510;
      continue
    }else {
      return ch__7509
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7511 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7512 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7512)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7512) {
      return cljs.core.persistent_BANG_.call(null, a__7511)
    }else {
      var temp__3695__auto____7513 = cljs.reader.macros.call(null, ch__7512);
      if(cljs.core.truth_(temp__3695__auto____7513)) {
        var macrofn__7514 = temp__3695__auto____7513;
        var mret__7515 = macrofn__7514.call(null, rdr, ch__7512);
        var G__7517 = mret__7515 === rdr ? a__7511 : cljs.core.conj_BANG_.call(null, a__7511, mret__7515);
        a__7511 = G__7517;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7512);
        var o__7516 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7518 = o__7516 === rdr ? a__7511 : cljs.core.conj_BANG_.call(null, a__7511, o__7516);
        a__7511 = G__7518;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7519 = cljs.reader.read_char.call(null, rdr);
  var dm__7520 = cljs.reader.dispatch_macros.call(null, ch__7519);
  if(cljs.core.truth_(dm__7520)) {
    return dm__7520.call(null, rdr, _)
  }else {
    var temp__3695__auto____7521 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7519);
    if(cljs.core.truth_(temp__3695__auto____7521)) {
      var obj__7522 = temp__3695__auto____7521;
      return obj__7522
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7519)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7523 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7523))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7523)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7524 = new goog.string.StringBuffer(initch);
  var ch__7525 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7526 = ch__7525 == null;
      if(or__3548__auto____7526) {
        return or__3548__auto____7526
      }else {
        var or__3548__auto____7527 = cljs.reader.whitespace_QMARK_.call(null, ch__7525);
        if(or__3548__auto____7527) {
          return or__3548__auto____7527
        }else {
          return cljs.reader.macros.call(null, ch__7525)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7525);
      var s__7528 = buffer__7524.toString();
      var or__3548__auto____7529 = cljs.reader.match_number.call(null, s__7528);
      if(cljs.core.truth_(or__3548__auto____7529)) {
        return or__3548__auto____7529
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7528, "]")
      }
    }else {
      var G__7530 = function() {
        buffer__7524.append(ch__7525);
        return buffer__7524
      }();
      var G__7531 = cljs.reader.read_char.call(null, reader);
      buffer__7524 = G__7530;
      ch__7525 = G__7531;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7532 = new goog.string.StringBuffer;
  var ch__7533 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7533 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7533) {
        var G__7534 = function() {
          buffer__7532.append(cljs.reader.escape_char.call(null, buffer__7532, reader));
          return buffer__7532
        }();
        var G__7535 = cljs.reader.read_char.call(null, reader);
        buffer__7532 = G__7534;
        ch__7533 = G__7535;
        continue
      }else {
        if('"' === ch__7533) {
          return buffer__7532.toString()
        }else {
          if("\ufdd0'default") {
            var G__7536 = function() {
              buffer__7532.append(ch__7533);
              return buffer__7532
            }();
            var G__7537 = cljs.reader.read_char.call(null, reader);
            buffer__7532 = G__7536;
            ch__7533 = G__7537;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7538 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7538, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7538, 0, token__7538.indexOf("/")), cljs.core.subs.call(null, token__7538, token__7538.indexOf("/") + 1, token__7538.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7538, cljs.core.symbol.call(null, token__7538))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7539 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7540 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7539);
  var token__7541 = a__7540[0];
  var ns__7542 = a__7540[1];
  var name__7543 = a__7540[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7545 = function() {
      var and__3546__auto____7544 = !(void 0 === ns__7542);
      if(and__3546__auto____7544) {
        return ns__7542.substring(ns__7542.length - 2, ns__7542.length) === ":/"
      }else {
        return and__3546__auto____7544
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7545)) {
      return or__3548__auto____7545
    }else {
      var or__3548__auto____7546 = name__7543[name__7543.length - 1] === ":";
      if(or__3548__auto____7546) {
        return or__3548__auto____7546
      }else {
        return!(token__7541.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7541)
  }else {
    if(cljs.core.truth_(ns__7542)) {
      return cljs.core.keyword.call(null, ns__7542.substring(0, ns__7542.indexOf("/")), name__7543)
    }else {
      return cljs.core.keyword.call(null, token__7541)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7547 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7547)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7548 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7549__7550 = o__7548;
    if(G__7549__7550 != null) {
      if(function() {
        var or__3548__auto____7551 = G__7549__7550.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7551) {
          return or__3548__auto____7551
        }else {
          return G__7549__7550.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7549__7550.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7549__7550)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7549__7550)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7548, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7548), m__7547))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7552 = cljs.reader.read_char.call(null, reader);
    if(ch__7552 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7552)) {
        var G__7555 = reader;
        var G__7556 = eof_is_error;
        var G__7557 = sentinel;
        var G__7558 = is_recursive;
        reader = G__7555;
        eof_is_error = G__7556;
        sentinel = G__7557;
        is_recursive = G__7558;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7552)) {
          var G__7559 = cljs.reader.read_comment.call(null, reader, ch__7552);
          var G__7560 = eof_is_error;
          var G__7561 = sentinel;
          var G__7562 = is_recursive;
          reader = G__7559;
          eof_is_error = G__7560;
          sentinel = G__7561;
          is_recursive = G__7562;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7553 = cljs.reader.macros.call(null, ch__7552);
            var res__7554 = cljs.core.truth_(f__7553) ? f__7553.call(null, reader, ch__7552) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7552) ? cljs.reader.read_number.call(null, reader, ch__7552) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7552) : null;
            if(res__7554 === reader) {
              var G__7563 = reader;
              var G__7564 = eof_is_error;
              var G__7565 = sentinel;
              var G__7566 = is_recursive;
              reader = G__7563;
              eof_is_error = G__7564;
              sentinel = G__7565;
              is_recursive = G__7566;
              continue
            }else {
              return res__7554
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7567 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7567, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7568 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7569 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7570 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7568));
  if(cljs.core.truth_(pfn__7570)) {
    return pfn__7570.call(null, form__7569)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7568), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7571 = cljs.core.name.call(null, tag);
  var old_parser__7572 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7571);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7571, f);
  return old_parser__7572
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7441 = s;
      var limit__7442 = limit;
      var parts__7443 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7442, 1)) {
          return cljs.core.conj.call(null, parts__7443, s__7441)
        }else {
          var temp__3695__auto____7444 = cljs.core.re_find.call(null, re, s__7441);
          if(cljs.core.truth_(temp__3695__auto____7444)) {
            var m__7445 = temp__3695__auto____7444;
            var index__7446 = s__7441.indexOf(m__7445);
            var G__7447 = s__7441.substring(index__7446 + cljs.core.count.call(null, m__7445));
            var G__7448 = limit__7442 - 1;
            var G__7449 = cljs.core.conj.call(null, parts__7443, s__7441.substring(0, index__7446));
            s__7441 = G__7447;
            limit__7442 = G__7448;
            parts__7443 = G__7449;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7443, s__7441)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7450 = s.length;
  while(true) {
    if(index__7450 === 0) {
      return""
    }else {
      var ch__7451 = cljs.core.get.call(null, s, index__7450 - 1);
      if(function() {
        var or__3548__auto____7452 = cljs.core._EQ_.call(null, ch__7451, "\n");
        if(or__3548__auto____7452) {
          return or__3548__auto____7452
        }else {
          return cljs.core._EQ_.call(null, ch__7451, "\r")
        }
      }()) {
        var G__7453 = index__7450 - 1;
        index__7450 = G__7453;
        continue
      }else {
        return s.substring(0, index__7450)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7454 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7455 = cljs.core.not.call(null, s__7454);
    if(or__3548__auto____7455) {
      return or__3548__auto____7455
    }else {
      var or__3548__auto____7456 = cljs.core._EQ_.call(null, "", s__7454);
      if(or__3548__auto____7456) {
        return or__3548__auto____7456
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7454)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7457 = new goog.string.StringBuffer;
  var length__7458 = s.length;
  var index__7459 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7458, index__7459)) {
      return buffer__7457.toString()
    }else {
      var ch__7460 = s.charAt(index__7459);
      var temp__3695__auto____7461 = cljs.core.get.call(null, cmap, ch__7460);
      if(cljs.core.truth_(temp__3695__auto____7461)) {
        var replacement__7462 = temp__3695__auto____7461;
        buffer__7457.append([cljs.core.str(replacement__7462)].join(""))
      }else {
        buffer__7457.append(ch__7460)
      }
      var G__7463 = index__7459 + 1;
      index__7459 = G__7463;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7412 = {};
  var G__7413__7414 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7413__7414)) {
    var G__7416__7418 = cljs.core.first.call(null, G__7413__7414);
    var vec__7417__7419 = G__7416__7418;
    var k__7420 = cljs.core.nth.call(null, vec__7417__7419, 0, null);
    var v__7421 = cljs.core.nth.call(null, vec__7417__7419, 1, null);
    var G__7413__7422 = G__7413__7414;
    var G__7416__7423 = G__7416__7418;
    var G__7413__7424 = G__7413__7422;
    while(true) {
      var vec__7425__7426 = G__7416__7423;
      var k__7427 = cljs.core.nth.call(null, vec__7425__7426, 0, null);
      var v__7428 = cljs.core.nth.call(null, vec__7425__7426, 1, null);
      var G__7413__7429 = G__7413__7424;
      out__7412[cljs.core.name.call(null, k__7427)] = v__7428;
      var temp__3698__auto____7430 = cljs.core.next.call(null, G__7413__7429);
      if(cljs.core.truth_(temp__3698__auto____7430)) {
        var G__7413__7431 = temp__3698__auto____7430;
        var G__7432 = cljs.core.first.call(null, G__7413__7431);
        var G__7433 = G__7413__7431;
        G__7416__7423 = G__7432;
        G__7413__7424 = G__7433;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7412
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7434 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7434)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7435) {
    var v = cljs.core.first(arglist__7435);
    var text = cljs.core.rest(arglist__7435);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7436) {
          var vec__7437__7438 = p__7436;
          var k__7439 = cljs.core.nth.call(null, vec__7437__7438, 0, null);
          var v__7440 = cljs.core.nth.call(null, vec__7437__7438, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7439), clj__GT_js.call(null, v__7440))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7304 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7304)) {
        var cm__7305 = temp__3695__auto____7304;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7305), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7306) {
    var vec__7307__7308 = p__7306;
    var context__7309 = cljs.core.nth.call(null, vec__7307__7308, 0, null);
    if(cljs.core.not.call(null, context__7309)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7309)
    }
  };
  var $ = function(sel, var_args) {
    var p__7306 = null;
    if(goog.isDef(var_args)) {
      p__7306 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7306)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7310) {
    var sel = cljs.core.first(arglist__7310);
    var p__7306 = cljs.core.rest(arglist__7310);
    return $__delegate(sel, p__7306)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7311 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7311)) {
    return or__3548__auto____7311
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7312 = null;
  var G__7312__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7312__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7312 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7312__2.call(this, _, k);
      case 3:
        return G__7312__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7312
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7313) {
    var vec__7314__7315 = p__7313;
    var v__7316 = cljs.core.nth.call(null, vec__7314__7315, 0, null);
    var a__7317 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7316)) {
      return $elem.attr(a__7317)
    }else {
      return $elem.attr(a__7317, v__7316)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7313 = null;
    if(goog.isDef(var_args)) {
      p__7313 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7313)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7318) {
    var $elem = cljs.core.first(arglist__7318);
    var a = cljs.core.first(cljs.core.next(arglist__7318));
    var p__7313 = cljs.core.rest(cljs.core.next(arglist__7318));
    return attr__delegate($elem, a, p__7313)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7319) {
    var vec__7320__7321 = p__7319;
    var v__7322 = cljs.core.nth.call(null, vec__7320__7321, 0, null);
    var k__7323 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7322)) {
      return $elem.data(k__7323)
    }else {
      return $elem.data(k__7323, v__7322)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7319 = null;
    if(goog.isDef(var_args)) {
      p__7319 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7319)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7324) {
    var $elem = cljs.core.first(arglist__7324);
    var k = cljs.core.first(cljs.core.next(arglist__7324));
    var p__7319 = cljs.core.rest(cljs.core.next(arglist__7324));
    return data__delegate($elem, k, p__7319)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7325 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7325)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7326 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7326)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7327 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7327)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7328 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7328)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7329) {
    var vec__7330__7331 = p__7329;
    var speed__7332 = cljs.core.nth.call(null, vec__7330__7331, 0, null);
    var on_finish__7333 = cljs.core.nth.call(null, vec__7330__7331, 1, null);
    return $elem.hide(speed__7332, on_finish__7333)
  };
  var hide = function($elem, var_args) {
    var p__7329 = null;
    if(goog.isDef(var_args)) {
      p__7329 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7329)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7334) {
    var $elem = cljs.core.first(arglist__7334);
    var p__7329 = cljs.core.rest(arglist__7334);
    return hide__delegate($elem, p__7329)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7335) {
    var vec__7336__7337 = p__7335;
    var speed__7338 = cljs.core.nth.call(null, vec__7336__7337, 0, null);
    var on_finish__7339 = cljs.core.nth.call(null, vec__7336__7337, 1, null);
    return $elem.show(speed__7338, on_finish__7339)
  };
  var show = function($elem, var_args) {
    var p__7335 = null;
    if(goog.isDef(var_args)) {
      p__7335 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7335)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7340) {
    var $elem = cljs.core.first(arglist__7340);
    var p__7335 = cljs.core.rest(arglist__7340);
    return show__delegate($elem, p__7335)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7341) {
    var vec__7342__7343 = p__7341;
    var speed__7344 = cljs.core.nth.call(null, vec__7342__7343, 0, null);
    var on_finish__7345 = cljs.core.nth.call(null, vec__7342__7343, 1, null);
    return $elem.toggle(speed__7344, on_finish__7345)
  };
  var toggle = function($elem, var_args) {
    var p__7341 = null;
    if(goog.isDef(var_args)) {
      p__7341 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7341)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7346) {
    var $elem = cljs.core.first(arglist__7346);
    var p__7341 = cljs.core.rest(arglist__7346);
    return toggle__delegate($elem, p__7341)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7347) {
    var vec__7348__7349 = p__7347;
    var speed__7350 = cljs.core.nth.call(null, vec__7348__7349, 0, null);
    var on_finish__7351 = cljs.core.nth.call(null, vec__7348__7349, 1, null);
    return $elem.fadeOut(speed__7350, on_finish__7351)
  };
  var fade_out = function($elem, var_args) {
    var p__7347 = null;
    if(goog.isDef(var_args)) {
      p__7347 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7347)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7352) {
    var $elem = cljs.core.first(arglist__7352);
    var p__7347 = cljs.core.rest(arglist__7352);
    return fade_out__delegate($elem, p__7347)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7353) {
    var vec__7354__7355 = p__7353;
    var speed__7356 = cljs.core.nth.call(null, vec__7354__7355, 0, null);
    var on_finish__7357 = cljs.core.nth.call(null, vec__7354__7355, 1, null);
    return $elem.fadeIn(speed__7356, on_finish__7357)
  };
  var fade_in = function($elem, var_args) {
    var p__7353 = null;
    if(goog.isDef(var_args)) {
      p__7353 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7353)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7358) {
    var $elem = cljs.core.first(arglist__7358);
    var p__7353 = cljs.core.rest(arglist__7358);
    return fade_in__delegate($elem, p__7353)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7359) {
    var vec__7360__7361 = p__7359;
    var speed__7362 = cljs.core.nth.call(null, vec__7360__7361, 0, null);
    var on_finish__7363 = cljs.core.nth.call(null, vec__7360__7361, 1, null);
    return $elem.slideUp(speed__7362, on_finish__7363)
  };
  var slide_up = function($elem, var_args) {
    var p__7359 = null;
    if(goog.isDef(var_args)) {
      p__7359 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7359)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7364) {
    var $elem = cljs.core.first(arglist__7364);
    var p__7359 = cljs.core.rest(arglist__7364);
    return slide_up__delegate($elem, p__7359)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7365) {
    var vec__7366__7367 = p__7365;
    var speed__7368 = cljs.core.nth.call(null, vec__7366__7367, 0, null);
    var on_finish__7369 = cljs.core.nth.call(null, vec__7366__7367, 1, null);
    return $elem.slideDown(speed__7368, on_finish__7369)
  };
  var slide_down = function($elem, var_args) {
    var p__7365 = null;
    if(goog.isDef(var_args)) {
      p__7365 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7365)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7370) {
    var $elem = cljs.core.first(arglist__7370);
    var p__7365 = cljs.core.rest(arglist__7370);
    return slide_down__delegate($elem, p__7365)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7371) {
    var vec__7372__7373 = p__7371;
    var context__7374 = cljs.core.nth.call(null, vec__7372__7373, 0, null);
    return $elem.closest(selector, context__7374)
  };
  var closest = function($elem, selector, var_args) {
    var p__7371 = null;
    if(goog.isDef(var_args)) {
      p__7371 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7371)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7375) {
    var $elem = cljs.core.first(arglist__7375);
    var selector = cljs.core.first(cljs.core.next(arglist__7375));
    var p__7371 = cljs.core.rest(cljs.core.next(arglist__7375));
    return closest__delegate($elem, selector, p__7371)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7376) {
    var vec__7377__7378 = p__7376;
    var v__7379 = cljs.core.nth.call(null, vec__7377__7378, 0, null);
    if(cljs.core.truth_(v__7379)) {
      return $elem.val(v__7379)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7376 = null;
    if(goog.isDef(var_args)) {
      p__7376 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7376)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7380) {
    var $elem = cljs.core.first(arglist__7380);
    var p__7376 = cljs.core.rest(arglist__7380);
    return val__delegate($elem, p__7376)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7381, content, callback) {
  var vec__7382__7383 = p__7381;
  var method__7384 = cljs.core.nth.call(null, vec__7382__7383, 0, null);
  var uri__7385 = cljs.core.nth.call(null, vec__7382__7383, 1, null);
  var params__7386 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7384)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7385, params__7386)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7387) {
    var vec__7388__7389 = p__7387;
    var func__7390 = cljs.core.nth.call(null, vec__7388__7389, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7390)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7387 = null;
    if(goog.isDef(var_args)) {
      p__7387 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7387)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7391) {
    var $elem = cljs.core.first(arglist__7391);
    var ev = cljs.core.first(cljs.core.next(arglist__7391));
    var p__7387 = cljs.core.rest(cljs.core.next(arglist__7391));
    return unbind__delegate($elem, ev, p__7387)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7392) {
    var vec__7393__7394 = p__7392;
    var sel__7395 = cljs.core.nth.call(null, vec__7393__7394, 0, null);
    var data__7396 = cljs.core.nth.call(null, vec__7393__7394, 1, null);
    var handler__7397 = cljs.core.nth.call(null, vec__7393__7394, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7395), data__7396, handler__7397)
  };
  var on = function($elem, events, var_args) {
    var p__7392 = null;
    if(goog.isDef(var_args)) {
      p__7392 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7392)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7398) {
    var $elem = cljs.core.first(arglist__7398);
    var events = cljs.core.first(cljs.core.next(arglist__7398));
    var p__7392 = cljs.core.rest(cljs.core.next(arglist__7398));
    return on__delegate($elem, events, p__7392)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7399) {
    var vec__7400__7401 = p__7399;
    var sel__7402 = cljs.core.nth.call(null, vec__7400__7401, 0, null);
    var data__7403 = cljs.core.nth.call(null, vec__7400__7401, 1, null);
    var handler__7404 = cljs.core.nth.call(null, vec__7400__7401, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7402), data__7403, handler__7404)
  };
  var one = function($elem, events, var_args) {
    var p__7399 = null;
    if(goog.isDef(var_args)) {
      p__7399 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7399)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7405) {
    var $elem = cljs.core.first(arglist__7405);
    var events = cljs.core.first(cljs.core.next(arglist__7405));
    var p__7399 = cljs.core.rest(cljs.core.next(arglist__7405));
    return one__delegate($elem, events, p__7399)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7406) {
    var vec__7407__7408 = p__7406;
    var sel__7409 = cljs.core.nth.call(null, vec__7407__7408, 0, null);
    var handler__7410 = cljs.core.nth.call(null, vec__7407__7408, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7409), handler__7410)
  };
  var off = function($elem, events, var_args) {
    var p__7406 = null;
    if(goog.isDef(var_args)) {
      p__7406 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7406)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7411) {
    var $elem = cljs.core.first(arglist__7411);
    var events = cljs.core.first(cljs.core.next(arglist__7411));
    var p__7406 = cljs.core.rest(cljs.core.next(arglist__7411));
    return off__delegate($elem, events, p__7406)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.dynamic_bindings = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.binding_key = cljs.core.atom.call(null, 0);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4821 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4820_SHARP_) {
    return out__4821[cljs.core.name.call(null, cljs.core.first.call(null, p1__4820_SHARP_))] = cljs.core.second.call(null, p1__4820_SHARP_)
  }, cljmap));
  return out__4821
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4822 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4822) {
    return or__3548__auto____4822
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bind_elem = function bind_elem(elem, bindingname, f) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname).call(null, elem, f.call(null))
    }
  }else {
    return function() {
      return elem[bindingname].call(elem, f.call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4823 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4824 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  return cljsbinding.bind_elem.call(null, elem, bindingname__4823, function() {
    return cljsbinding.valuefn.call(null, elem, fname__4824, ctx, bindingname__4823)
  })
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_jq_elem = function bind_jq_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4825__4826 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4825__4826)) {
    var data__4827 = cljs.core.first.call(null, G__4825__4826);
    var G__4825__4828 = G__4825__4826;
    while(true) {
      cljsbinding.bind_jq_elem.call(null, elem, data__4827.split(":"), ctx);
      var temp__3698__auto____4829 = cljs.core.next.call(null, G__4825__4828);
      if(cljs.core.truth_(temp__3698__auto____4829)) {
        var G__4825__4830 = temp__3698__auto____4829;
        var G__4831 = cljs.core.first.call(null, G__4825__4830);
        var G__4832 = G__4825__4830;
        data__4827 = G__4831;
        G__4825__4828 = G__4832;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem, atm) {
  var aval__4834 = cljs.core.deref.call(null, atm);
  if(cljs.core.map_QMARK_.call(null, aval__4834)) {
    return aval__4834.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4834
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4833_SHARP_) {
      return cljs.core.assoc.call(null, p1__4833_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.is(":checked"));
    return false
  })
};
cljsbinding.bind_text_atom = function bind_text_atom(elem, atm) {
  return cljsbinding.run_bind_fn.call(null, function() {
    return elem["text"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  })
};
cljsbinding.bind_elem_to_atom = function bind_elem_to_atom(elem, atm) {
  if(cljs.core.truth_(function() {
    var or__3548__auto____4835 = elem.is("input");
    if(cljs.core.truth_(or__3548__auto____4835)) {
      return or__3548__auto____4835
    }else {
      var or__3548__auto____4836 = elem.is("textarea");
      if(cljs.core.truth_(or__3548__auto____4836)) {
        return or__3548__auto____4836
      }else {
        return elem.is("select")
      }
    }
  }())) {
    if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
      return cljsbinding.bind_checkbox_atom.call(null, elem, atm)
    }else {
      return cljsbinding.bind_input_atom.call(null, elem, atm)
    }
  }else {
    return cljsbinding.bind_text_atom.call(null, elem, atm)
  }
};
cljsbinding.bindatom = function bindatom(elem) {
  var atm__4837 = eval(jayq.core.attr.call(null, elem, "bindatom"));
  return cljsbinding.bind_elem_to_atom.call(null, elem, atm__4837)
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem, bindfn) {
  jayq.core.append.call(null, parent, elem);
  return bindfn.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template, bindfn) {
  jayq.core.remove.call(null, parent.children());
  var G__4838__4839 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4838__4839)) {
    var item__4840 = cljs.core.first.call(null, G__4838__4839);
    var G__4838__4841 = G__4838__4839;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4840, template.clone(), bindfn);
      var temp__3698__auto____4842 = cljs.core.next.call(null, G__4838__4841);
      if(cljs.core.truth_(temp__3698__auto____4842)) {
        var G__4838__4843 = temp__3698__auto____4842;
        var G__4844 = cljs.core.first.call(null, G__4838__4843);
        var G__4845 = G__4838__4843;
        item__4840 = G__4844;
        G__4838__4841 = G__4845;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent, bindfn) {
  var atom__4847 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4847), elparent, elem, bindfn);
  return cljs.core.add_watch.call(null, atom__4847, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem, bindfn)
  })
};
cljsbinding.dobind = function dobind(parent, ctx) {
  var seqs__4848 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4849 = cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4846_SHARP_) {
    return jayq.core.$.call(null, p1__4846_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4850__4851 = cljs.core.seq.call(null, seqs__4848);
  if(cljs.core.truth_(G__4850__4851)) {
    var elem__4852 = cljs.core.first.call(null, G__4850__4851);
    var G__4850__4853 = G__4850__4851;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4852));
      var temp__3698__auto____4854 = cljs.core.next.call(null, G__4850__4853);
      if(cljs.core.truth_(temp__3698__auto____4854)) {
        var G__4850__4855 = temp__3698__auto____4854;
        var G__4893 = cljs.core.first.call(null, G__4850__4855);
        var G__4894 = G__4850__4855;
        elem__4852 = G__4893;
        G__4850__4853 = G__4894;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4856__4857 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4856__4857)) {
    var elem__4858 = cljs.core.first.call(null, G__4856__4857);
    var G__4856__4859 = G__4856__4857;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4858), ctx);
      var temp__3698__auto____4860 = cljs.core.next.call(null, G__4856__4859);
      if(cljs.core.truth_(temp__3698__auto____4860)) {
        var G__4856__4861 = temp__3698__auto____4860;
        var G__4895 = cljs.core.first.call(null, G__4856__4861);
        var G__4896 = G__4856__4861;
        elem__4858 = G__4895;
        G__4856__4859 = G__4896;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4862__4863 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4862__4863)) {
    var elem__4864 = cljs.core.first.call(null, G__4862__4863);
    var G__4862__4865 = G__4862__4863;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4864), ctx);
      var temp__3698__auto____4866 = cljs.core.next.call(null, G__4862__4865);
      if(cljs.core.truth_(temp__3698__auto____4866)) {
        var G__4862__4867 = temp__3698__auto____4866;
        var G__4897 = cljs.core.first.call(null, G__4862__4867);
        var G__4898 = G__4862__4867;
        elem__4864 = G__4897;
        G__4862__4865 = G__4898;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4868__4869 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4868__4869)) {
    var elem__4870 = cljs.core.first.call(null, G__4868__4869);
    var G__4868__4871 = G__4868__4869;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4870));
      var temp__3698__auto____4872 = cljs.core.next.call(null, G__4868__4871);
      if(cljs.core.truth_(temp__3698__auto____4872)) {
        var G__4868__4873 = temp__3698__auto____4872;
        var G__4899 = cljs.core.first.call(null, G__4868__4873);
        var G__4900 = G__4868__4873;
        elem__4870 = G__4899;
        G__4868__4871 = G__4900;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4874__4875 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4848, seqparents__4849));
  if(cljs.core.truth_(G__4874__4875)) {
    var G__4877__4879 = cljs.core.first.call(null, G__4874__4875);
    var vec__4878__4880 = G__4877__4879;
    var elem__4881 = cljs.core.nth.call(null, vec__4878__4880, 0, null);
    var parent__4882 = cljs.core.nth.call(null, vec__4878__4880, 1, null);
    var G__4874__4883 = G__4874__4875;
    var G__4877__4884 = G__4877__4879;
    var G__4874__4885 = G__4874__4883;
    while(true) {
      var vec__4886__4887 = G__4877__4884;
      var elem__4888 = cljs.core.nth.call(null, vec__4886__4887, 0, null);
      var parent__4889 = cljs.core.nth.call(null, vec__4886__4887, 1, null);
      var G__4874__4890 = G__4874__4885;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4888), parent__4889, dobind);
      var temp__3698__auto____4891 = cljs.core.next.call(null, G__4874__4890);
      if(cljs.core.truth_(temp__3698__auto____4891)) {
        var G__4874__4892 = temp__3698__auto____4891;
        var G__4901 = cljs.core.first.call(null, G__4874__4892);
        var G__4902 = G__4874__4892;
        G__4877__4884 = G__4901;
        G__4874__4885 = G__4902;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindall = function() {
  var bindall = null;
  var bindall__1 = function(elem) {
    return cljsbinding.dobind.call(null, elem, null)
  };
  var bindall__2 = function(elem, ctx) {
    return cljsbinding.dobind.call(null, elem, ctx)
  };
  bindall = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindall__1.call(this, elem);
      case 2:
        return bindall__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindall.cljs$lang$arity$1 = bindall__1;
  bindall.cljs$lang$arity$2 = bindall__2;
  return bindall
}();
goog.exportSymbol("cljsbinding.bindall", cljsbinding.bindall);
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4903_SHARP_, p2__4904_SHARP_) {
      var or__3548__auto____4906 = p1__4903_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4906)) {
        return or__3548__auto____4906
      }else {
        return p2__4904_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4905_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4905_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.add_binding = function add_binding(atom, m) {
  return cljs.core.assoc.call(null, m, atom, cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), m.call(null, atom)))
};
cljsbinding.run_bindings = function run_bindings(key, a, old_val, new_val) {
  var G__4907__4908 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
  if(cljs.core.truth_(G__4907__4908)) {
    var f__4909 = cljs.core.first.call(null, G__4907__4908);
    var G__4907__4910 = G__4907__4908;
    while(true) {
      f__4909.call(null);
      var temp__3698__auto____4911 = cljs.core.next.call(null, G__4907__4910);
      if(cljs.core.truth_(temp__3698__auto____4911)) {
        var G__4907__4912 = temp__3698__auto____4911;
        var G__4913 = cljs.core.first.call(null, G__4907__4912);
        var G__4914 = G__4907__4912;
        f__4909 = G__4913;
        G__4907__4910 = G__4914;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.next_binding_key = function next_binding_key() {
  return cljs.core.swap_BANG_.call(null, cljsbinding.binding_key, cljs.core.inc)
};
cljsbinding.register_bindingsource = function register_bindingsource(source) {
  var bindingkey__4916 = [cljs.core.str(cljsbinding.next_binding_key.call(null))].join("");
  cljs.core.swap_BANG_.call(null, cljsbinding.dynamic_bindings, function(p1__4915_SHARP_) {
    return cljs.core.assoc.call(null, p1__4915_SHARP_, bindingkey__4916, source)
  });
  return bindingkey__4916
};
cljsbinding.apply_binding = function apply_binding(elem, source) {
  if(cljs.core.map_QMARK_.call(null, source)) {
    var G__4917__4918 = cljs.core.seq.call(null, source);
    if(cljs.core.truth_(G__4917__4918)) {
      var G__4920__4922 = cljs.core.first.call(null, G__4917__4918);
      var vec__4921__4923 = G__4920__4922;
      var bindingname__4924 = cljs.core.nth.call(null, vec__4921__4923, 0, null);
      var f__4925 = cljs.core.nth.call(null, vec__4921__4923, 1, null);
      var G__4917__4926 = G__4917__4918;
      var G__4920__4927 = G__4920__4922;
      var G__4917__4928 = G__4917__4926;
      while(true) {
        var vec__4929__4930 = G__4920__4927;
        var bindingname__4931 = cljs.core.nth.call(null, vec__4929__4930, 0, null);
        var f__4932 = cljs.core.nth.call(null, vec__4929__4930, 1, null);
        var G__4917__4933 = G__4917__4928;
        cljsbinding.run_bind_fn.call(null, cljsbinding.bind_elem.call(null, elem, cljs.core.name.call(null, bindingname__4931), f__4932));
        var temp__3698__auto____4934 = cljs.core.next.call(null, G__4917__4933);
        if(cljs.core.truth_(temp__3698__auto____4934)) {
          var G__4917__4935 = temp__3698__auto____4934;
          var G__4936 = cljs.core.first.call(null, G__4917__4935);
          var G__4937 = G__4917__4935;
          G__4920__4927 = G__4936;
          G__4917__4928 = G__4937;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  }else {
    return cljsbinding.bind_elem_to_atom.call(null, elem, source)
  }
};
cljsbinding.apply_bindingsource = function apply_bindingsource(elem, bindingkey) {
  var G__4938__4939 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.dynamic_bindings).call(null, bindingkey));
  if(cljs.core.truth_(G__4938__4939)) {
    var source__4940 = cljs.core.first.call(null, G__4938__4939);
    var G__4938__4941 = G__4938__4939;
    while(true) {
      cljsbinding.apply_binding.call(null, elem, source__4940);
      var temp__3698__auto____4942 = cljs.core.next.call(null, G__4938__4941);
      if(cljs.core.truth_(temp__3698__auto____4942)) {
        var G__4938__4943 = temp__3698__auto____4942;
        var G__4944 = cljs.core.first.call(null, G__4938__4943);
        var G__4945 = G__4938__4943;
        source__4940 = G__4944;
        G__4938__4941 = G__4945;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, cljs.core.partial.call(null, cljsbinding.add_binding, atom));
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", cljsbinding.run_bindings);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.cljsderef = function cljsderef() {
  return cljs.core._deref
};
goog.exportSymbol("cljsbinding.cljsderef", cljsbinding.cljsderef);
cljsbinding.shouldregister = function shouldregister(drf) {
  return drf.call(null, cljsbinding.BindMonitor)
};
goog.exportSymbol("cljsbinding.shouldregister", cljsbinding.shouldregister);
cljsbinding.boot = function boot() {
  return eval("    \n    var derefName = eval('cljsbinding.cljsderef.toString().match(/return.(.*$)\\\\s/m)[1]')\n    if (derefName[derefName.length-1] == ';')\n      derefName = derefName.substr(0,derefName.length-1)\n    var deref = eval(derefName)\n    eval(derefName +' = function (a) { if (cljsbinding.shouldregister(deref)) { cljsbinding.register(a) };return deref(a); }')\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4946 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4946), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4946)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4946)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4946)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4946))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  var storedValue__4947 = localStorage[name];
  if(cljs.core.not.call(null, storedValue__4947 == null)) {
    return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, storedValue__4947))
  }else {
    return null
  }
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
goog.provide("cljsbinding.crate");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljsbinding");
cljsbinding.crate.re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;
cljsbinding.crate.tag_str = function tag_str(tag) {
  if(cljs.core.keyword_QMARK_.call(null, tag)) {
    return cljs.core.name.call(null, tag)
  }else {
    return[cljs.core.str(tag)].join("")
  }
};
cljsbinding.crate.normalize_element = function normalize_element(p__4798) {
  var vec__4799__4800 = p__4798;
  var tag__4801 = cljs.core.nth.call(null, vec__4799__4800, 0, null);
  var content__4802 = cljs.core.nthnext.call(null, vec__4799__4800, 1);
  if(cljs.core.not.call(null, function() {
    var or__3548__auto____4803 = cljs.core.keyword_QMARK_.call(null, tag__4801);
    if(or__3548__auto____4803) {
      return or__3548__auto____4803
    }else {
      var or__3548__auto____4804 = cljs.core.symbol_QMARK_.call(null, tag__4801);
      if(or__3548__auto____4804) {
        return or__3548__auto____4804
      }else {
        return cljs.core.string_QMARK_.call(null, tag__4801)
      }
    }
  }())) {
    throw Error([cljs.core.str(tag__4801), cljs.core.str(" is not a valid element name.")].join(""));
  }else {
  }
  var vec__4805__4806 = cljs.core.re_matches.call(null, cljsbinding.crate.re_tag, cljsbinding.crate.tag_str.call(null, tag__4801));
  var ___4807 = cljs.core.nth.call(null, vec__4805__4806, 0, null);
  var tag__4808 = cljs.core.nth.call(null, vec__4805__4806, 1, null);
  var id__4809 = cljs.core.nth.call(null, vec__4805__4806, 2, null);
  var class$__4810 = cljs.core.nth.call(null, vec__4805__4806, 3, null);
  var tag_attrs__4811 = cljs.core.ObjMap.fromObject(["\ufdd0'id", "\ufdd0'class"], {"\ufdd0'id":id__4809, "\ufdd0'class":cljs.core.truth_(class$__4810) ? class$__4810.replace(".", " ") : null});
  var map_attrs__4812 = cljs.core.first.call(null, content__4802);
  if(cljs.core.map_QMARK_.call(null, map_attrs__4812)) {
    return cljs.core.PersistentVector.fromArray([tag__4808, cljs.core.merge.call(null, tag_attrs__4811, map_attrs__4812), cljs.core.next.call(null, content__4802)])
  }else {
    return cljs.core.PersistentVector.fromArray([tag__4808, tag_attrs__4811, content__4802])
  }
};
cljsbinding.crate.add_binding = function() {
  var add_binding__delegate = function(elem, bind) {
    var vec__4813__4814 = cljsbinding.crate.normalize_element.call(null, elem);
    var tagname__4815 = cljs.core.nth.call(null, vec__4813__4814, 0, null);
    var attrs__4816 = cljs.core.nth.call(null, vec__4813__4814, 1, null);
    var content__4817 = cljs.core.nth.call(null, vec__4813__4814, 2, null);
    return cljs.core.PersistentVector.fromArray([tagname__4815, cljs.core.assoc.call(null, attrs__4816, "\ufdd0'withbinding", cljsbinding.register_bindingsource.call(null, bind))])
  };
  var add_binding = function(elem, var_args) {
    var bind = null;
    if(goog.isDef(var_args)) {
      bind = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return add_binding__delegate.call(this, elem, bind)
  };
  add_binding.cljs$lang$maxFixedArity = 1;
  add_binding.cljs$lang$applyTo = function(arglist__4818) {
    var elem = cljs.core.first(arglist__4818);
    var bind = cljs.core.rest(arglist__4818);
    return add_binding__delegate(elem, bind)
  };
  add_binding.cljs$lang$arity$variadic = add_binding__delegate;
  return add_binding
}();
cljsbinding.crate.bind_html_elem = function bind_html_elem(elem) {
  var bindingkey__4819 = jayq.core.attr.call(null, elem, "withbinding");
  cljsbinding.apply_bindingsource.call(null, elem, bindingkey__4819);
  return elem.removeAttr("withbinding")
};
