var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4950__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4950 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4950__delegate.call(this, array, i, idxs)
    };
    G__4950.cljs$lang$maxFixedArity = 2;
    G__4950.cljs$lang$applyTo = function(arglist__4951) {
      var array = cljs.core.first(arglist__4951);
      var i = cljs.core.first(cljs.core.next(arglist__4951));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4951));
      return G__4950__delegate(array, i, idxs)
    };
    G__4950.cljs$lang$arity$variadic = G__4950__delegate;
    return G__4950
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4952 = this$;
      if(and__3546__auto____4952) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4952
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4953 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4953) {
          return or__3548__auto____4953
        }else {
          var or__3548__auto____4954 = cljs.core._invoke["_"];
          if(or__3548__auto____4954) {
            return or__3548__auto____4954
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4955 = this$;
      if(and__3546__auto____4955) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4955
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4956 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4956) {
          return or__3548__auto____4956
        }else {
          var or__3548__auto____4957 = cljs.core._invoke["_"];
          if(or__3548__auto____4957) {
            return or__3548__auto____4957
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4958 = this$;
      if(and__3546__auto____4958) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4958
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4959 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4959) {
          return or__3548__auto____4959
        }else {
          var or__3548__auto____4960 = cljs.core._invoke["_"];
          if(or__3548__auto____4960) {
            return or__3548__auto____4960
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4961 = this$;
      if(and__3546__auto____4961) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4961
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4962 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4962) {
          return or__3548__auto____4962
        }else {
          var or__3548__auto____4963 = cljs.core._invoke["_"];
          if(or__3548__auto____4963) {
            return or__3548__auto____4963
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4964 = this$;
      if(and__3546__auto____4964) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4964
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4965 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4965) {
          return or__3548__auto____4965
        }else {
          var or__3548__auto____4966 = cljs.core._invoke["_"];
          if(or__3548__auto____4966) {
            return or__3548__auto____4966
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4967 = this$;
      if(and__3546__auto____4967) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4967
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4968 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4968) {
          return or__3548__auto____4968
        }else {
          var or__3548__auto____4969 = cljs.core._invoke["_"];
          if(or__3548__auto____4969) {
            return or__3548__auto____4969
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4970 = this$;
      if(and__3546__auto____4970) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4970
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4971 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4971) {
          return or__3548__auto____4971
        }else {
          var or__3548__auto____4972 = cljs.core._invoke["_"];
          if(or__3548__auto____4972) {
            return or__3548__auto____4972
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4973 = this$;
      if(and__3546__auto____4973) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4973
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4974 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4974) {
          return or__3548__auto____4974
        }else {
          var or__3548__auto____4975 = cljs.core._invoke["_"];
          if(or__3548__auto____4975) {
            return or__3548__auto____4975
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4976 = this$;
      if(and__3546__auto____4976) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4976
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4977 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4977) {
          return or__3548__auto____4977
        }else {
          var or__3548__auto____4978 = cljs.core._invoke["_"];
          if(or__3548__auto____4978) {
            return or__3548__auto____4978
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4979 = this$;
      if(and__3546__auto____4979) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4979
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4980 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4980) {
          return or__3548__auto____4980
        }else {
          var or__3548__auto____4981 = cljs.core._invoke["_"];
          if(or__3548__auto____4981) {
            return or__3548__auto____4981
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4982 = this$;
      if(and__3546__auto____4982) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4982
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4983 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4983) {
          return or__3548__auto____4983
        }else {
          var or__3548__auto____4984 = cljs.core._invoke["_"];
          if(or__3548__auto____4984) {
            return or__3548__auto____4984
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4985 = this$;
      if(and__3546__auto____4985) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4985
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4986 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4986) {
          return or__3548__auto____4986
        }else {
          var or__3548__auto____4987 = cljs.core._invoke["_"];
          if(or__3548__auto____4987) {
            return or__3548__auto____4987
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4988 = this$;
      if(and__3546__auto____4988) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4988
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4989 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4989) {
          return or__3548__auto____4989
        }else {
          var or__3548__auto____4990 = cljs.core._invoke["_"];
          if(or__3548__auto____4990) {
            return or__3548__auto____4990
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4991 = this$;
      if(and__3546__auto____4991) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4991
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4992 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4992) {
          return or__3548__auto____4992
        }else {
          var or__3548__auto____4993 = cljs.core._invoke["_"];
          if(or__3548__auto____4993) {
            return or__3548__auto____4993
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4994 = this$;
      if(and__3546__auto____4994) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4994
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4995 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4995) {
          return or__3548__auto____4995
        }else {
          var or__3548__auto____4996 = cljs.core._invoke["_"];
          if(or__3548__auto____4996) {
            return or__3548__auto____4996
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4997 = this$;
      if(and__3546__auto____4997) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4997
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4998 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4998) {
          return or__3548__auto____4998
        }else {
          var or__3548__auto____4999 = cljs.core._invoke["_"];
          if(or__3548__auto____4999) {
            return or__3548__auto____4999
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____5000 = this$;
      if(and__3546__auto____5000) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____5000
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____5001 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5001) {
          return or__3548__auto____5001
        }else {
          var or__3548__auto____5002 = cljs.core._invoke["_"];
          if(or__3548__auto____5002) {
            return or__3548__auto____5002
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____5003 = this$;
      if(and__3546__auto____5003) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____5003
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____5004 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5004) {
          return or__3548__auto____5004
        }else {
          var or__3548__auto____5005 = cljs.core._invoke["_"];
          if(or__3548__auto____5005) {
            return or__3548__auto____5005
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____5006 = this$;
      if(and__3546__auto____5006) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____5006
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____5007 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5007) {
          return or__3548__auto____5007
        }else {
          var or__3548__auto____5008 = cljs.core._invoke["_"];
          if(or__3548__auto____5008) {
            return or__3548__auto____5008
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____5009 = this$;
      if(and__3546__auto____5009) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____5009
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____5010 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5010) {
          return or__3548__auto____5010
        }else {
          var or__3548__auto____5011 = cljs.core._invoke["_"];
          if(or__3548__auto____5011) {
            return or__3548__auto____5011
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____5012 = this$;
      if(and__3546__auto____5012) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____5012
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____5013 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5013) {
          return or__3548__auto____5013
        }else {
          var or__3548__auto____5014 = cljs.core._invoke["_"];
          if(or__3548__auto____5014) {
            return or__3548__auto____5014
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____5015 = coll;
    if(and__3546__auto____5015) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____5015
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5016 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5016) {
        return or__3548__auto____5016
      }else {
        var or__3548__auto____5017 = cljs.core._count["_"];
        if(or__3548__auto____5017) {
          return or__3548__auto____5017
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____5018 = coll;
    if(and__3546__auto____5018) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____5018
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5019 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5019) {
        return or__3548__auto____5019
      }else {
        var or__3548__auto____5020 = cljs.core._empty["_"];
        if(or__3548__auto____5020) {
          return or__3548__auto____5020
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____5021 = coll;
    if(and__3546__auto____5021) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____5021
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____5022 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5022) {
        return or__3548__auto____5022
      }else {
        var or__3548__auto____5023 = cljs.core._conj["_"];
        if(or__3548__auto____5023) {
          return or__3548__auto____5023
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____5024 = coll;
      if(and__3546__auto____5024) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____5024
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____5025 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5025) {
          return or__3548__auto____5025
        }else {
          var or__3548__auto____5026 = cljs.core._nth["_"];
          if(or__3548__auto____5026) {
            return or__3548__auto____5026
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____5027 = coll;
      if(and__3546__auto____5027) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____5027
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____5028 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5028) {
          return or__3548__auto____5028
        }else {
          var or__3548__auto____5029 = cljs.core._nth["_"];
          if(or__3548__auto____5029) {
            return or__3548__auto____5029
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____5030 = coll;
    if(and__3546__auto____5030) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____5030
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5031 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5031) {
        return or__3548__auto____5031
      }else {
        var or__3548__auto____5032 = cljs.core._first["_"];
        if(or__3548__auto____5032) {
          return or__3548__auto____5032
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____5033 = coll;
    if(and__3546__auto____5033) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____5033
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5034 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5034) {
        return or__3548__auto____5034
      }else {
        var or__3548__auto____5035 = cljs.core._rest["_"];
        if(or__3548__auto____5035) {
          return or__3548__auto____5035
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____5036 = o;
      if(and__3546__auto____5036) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____5036
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____5037 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5037) {
          return or__3548__auto____5037
        }else {
          var or__3548__auto____5038 = cljs.core._lookup["_"];
          if(or__3548__auto____5038) {
            return or__3548__auto____5038
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____5039 = o;
      if(and__3546__auto____5039) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____5039
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____5040 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5040) {
          return or__3548__auto____5040
        }else {
          var or__3548__auto____5041 = cljs.core._lookup["_"];
          if(or__3548__auto____5041) {
            return or__3548__auto____5041
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____5042 = coll;
    if(and__3546__auto____5042) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____5042
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5043 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5043) {
        return or__3548__auto____5043
      }else {
        var or__3548__auto____5044 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____5044) {
          return or__3548__auto____5044
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____5045 = coll;
    if(and__3546__auto____5045) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____5045
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____5046 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5046) {
        return or__3548__auto____5046
      }else {
        var or__3548__auto____5047 = cljs.core._assoc["_"];
        if(or__3548__auto____5047) {
          return or__3548__auto____5047
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____5048 = coll;
    if(and__3546__auto____5048) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____5048
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5049 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5049) {
        return or__3548__auto____5049
      }else {
        var or__3548__auto____5050 = cljs.core._dissoc["_"];
        if(or__3548__auto____5050) {
          return or__3548__auto____5050
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____5051 = coll;
    if(and__3546__auto____5051) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____5051
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5052 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5052) {
        return or__3548__auto____5052
      }else {
        var or__3548__auto____5053 = cljs.core._key["_"];
        if(or__3548__auto____5053) {
          return or__3548__auto____5053
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____5054 = coll;
    if(and__3546__auto____5054) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____5054
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5055 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5055) {
        return or__3548__auto____5055
      }else {
        var or__3548__auto____5056 = cljs.core._val["_"];
        if(or__3548__auto____5056) {
          return or__3548__auto____5056
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____5057 = coll;
    if(and__3546__auto____5057) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____5057
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____5058 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5058) {
        return or__3548__auto____5058
      }else {
        var or__3548__auto____5059 = cljs.core._disjoin["_"];
        if(or__3548__auto____5059) {
          return or__3548__auto____5059
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____5060 = coll;
    if(and__3546__auto____5060) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____5060
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5061 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5061) {
        return or__3548__auto____5061
      }else {
        var or__3548__auto____5062 = cljs.core._peek["_"];
        if(or__3548__auto____5062) {
          return or__3548__auto____5062
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____5063 = coll;
    if(and__3546__auto____5063) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____5063
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5064 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5064) {
        return or__3548__auto____5064
      }else {
        var or__3548__auto____5065 = cljs.core._pop["_"];
        if(or__3548__auto____5065) {
          return or__3548__auto____5065
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____5066 = coll;
    if(and__3546__auto____5066) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____5066
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____5067 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5067) {
        return or__3548__auto____5067
      }else {
        var or__3548__auto____5068 = cljs.core._assoc_n["_"];
        if(or__3548__auto____5068) {
          return or__3548__auto____5068
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____5069 = o;
    if(and__3546__auto____5069) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____5069
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5070 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____5070) {
        return or__3548__auto____5070
      }else {
        var or__3548__auto____5071 = cljs.core._deref["_"];
        if(or__3548__auto____5071) {
          return or__3548__auto____5071
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____5072 = o;
    if(and__3546__auto____5072) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____5072
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____5073 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____5073) {
        return or__3548__auto____5073
      }else {
        var or__3548__auto____5074 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____5074) {
          return or__3548__auto____5074
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____5075 = o;
    if(and__3546__auto____5075) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____5075
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5076 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5076) {
        return or__3548__auto____5076
      }else {
        var or__3548__auto____5077 = cljs.core._meta["_"];
        if(or__3548__auto____5077) {
          return or__3548__auto____5077
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____5078 = o;
    if(and__3546__auto____5078) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____5078
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____5079 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5079) {
        return or__3548__auto____5079
      }else {
        var or__3548__auto____5080 = cljs.core._with_meta["_"];
        if(or__3548__auto____5080) {
          return or__3548__auto____5080
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____5081 = coll;
      if(and__3546__auto____5081) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____5081
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____5082 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5082) {
          return or__3548__auto____5082
        }else {
          var or__3548__auto____5083 = cljs.core._reduce["_"];
          if(or__3548__auto____5083) {
            return or__3548__auto____5083
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____5084 = coll;
      if(and__3546__auto____5084) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____5084
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____5085 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5085) {
          return or__3548__auto____5085
        }else {
          var or__3548__auto____5086 = cljs.core._reduce["_"];
          if(or__3548__auto____5086) {
            return or__3548__auto____5086
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____5087 = coll;
    if(and__3546__auto____5087) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____5087
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____5088 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5088) {
        return or__3548__auto____5088
      }else {
        var or__3548__auto____5089 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____5089) {
          return or__3548__auto____5089
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____5090 = o;
    if(and__3546__auto____5090) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____5090
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____5091 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____5091) {
        return or__3548__auto____5091
      }else {
        var or__3548__auto____5092 = cljs.core._equiv["_"];
        if(or__3548__auto____5092) {
          return or__3548__auto____5092
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____5093 = o;
    if(and__3546__auto____5093) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____5093
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5094 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____5094) {
        return or__3548__auto____5094
      }else {
        var or__3548__auto____5095 = cljs.core._hash["_"];
        if(or__3548__auto____5095) {
          return or__3548__auto____5095
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____5096 = o;
    if(and__3546__auto____5096) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____5096
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5097 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5097) {
        return or__3548__auto____5097
      }else {
        var or__3548__auto____5098 = cljs.core._seq["_"];
        if(or__3548__auto____5098) {
          return or__3548__auto____5098
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____5099 = coll;
    if(and__3546__auto____5099) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____5099
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5100 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5100) {
        return or__3548__auto____5100
      }else {
        var or__3548__auto____5101 = cljs.core._rseq["_"];
        if(or__3548__auto____5101) {
          return or__3548__auto____5101
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5102 = coll;
    if(and__3546__auto____5102) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____5102
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5103 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5103) {
        return or__3548__auto____5103
      }else {
        var or__3548__auto____5104 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____5104) {
          return or__3548__auto____5104
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5105 = coll;
    if(and__3546__auto____5105) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____5105
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5106 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5106) {
        return or__3548__auto____5106
      }else {
        var or__3548__auto____5107 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____5107) {
          return or__3548__auto____5107
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____5108 = coll;
    if(and__3546__auto____5108) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____5108
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____5109 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5109) {
        return or__3548__auto____5109
      }else {
        var or__3548__auto____5110 = cljs.core._entry_key["_"];
        if(or__3548__auto____5110) {
          return or__3548__auto____5110
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____5111 = coll;
    if(and__3546__auto____5111) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____5111
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5112 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5112) {
        return or__3548__auto____5112
      }else {
        var or__3548__auto____5113 = cljs.core._comparator["_"];
        if(or__3548__auto____5113) {
          return or__3548__auto____5113
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____5114 = o;
    if(and__3546__auto____5114) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____5114
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____5115 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5115) {
        return or__3548__auto____5115
      }else {
        var or__3548__auto____5116 = cljs.core._pr_seq["_"];
        if(or__3548__auto____5116) {
          return or__3548__auto____5116
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____5117 = d;
    if(and__3546__auto____5117) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____5117
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____5118 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____5118) {
        return or__3548__auto____5118
      }else {
        var or__3548__auto____5119 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____5119) {
          return or__3548__auto____5119
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____5120 = this$;
    if(and__3546__auto____5120) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____5120
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____5121 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5121) {
        return or__3548__auto____5121
      }else {
        var or__3548__auto____5122 = cljs.core._notify_watches["_"];
        if(or__3548__auto____5122) {
          return or__3548__auto____5122
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____5123 = this$;
    if(and__3546__auto____5123) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____5123
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____5124 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5124) {
        return or__3548__auto____5124
      }else {
        var or__3548__auto____5125 = cljs.core._add_watch["_"];
        if(or__3548__auto____5125) {
          return or__3548__auto____5125
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____5126 = this$;
    if(and__3546__auto____5126) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____5126
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____5127 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5127) {
        return or__3548__auto____5127
      }else {
        var or__3548__auto____5128 = cljs.core._remove_watch["_"];
        if(or__3548__auto____5128) {
          return or__3548__auto____5128
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____5129 = coll;
    if(and__3546__auto____5129) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____5129
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5130 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5130) {
        return or__3548__auto____5130
      }else {
        var or__3548__auto____5131 = cljs.core._as_transient["_"];
        if(or__3548__auto____5131) {
          return or__3548__auto____5131
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____5132 = tcoll;
    if(and__3546__auto____5132) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____5132
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____5133 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5133) {
        return or__3548__auto____5133
      }else {
        var or__3548__auto____5134 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____5134) {
          return or__3548__auto____5134
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5135 = tcoll;
    if(and__3546__auto____5135) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____5135
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5136 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5136) {
        return or__3548__auto____5136
      }else {
        var or__3548__auto____5137 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____5137) {
          return or__3548__auto____5137
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____5138 = tcoll;
    if(and__3546__auto____5138) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____5138
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____5139 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5139) {
        return or__3548__auto____5139
      }else {
        var or__3548__auto____5140 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____5140) {
          return or__3548__auto____5140
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____5141 = tcoll;
    if(and__3546__auto____5141) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____5141
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____5142 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5142) {
        return or__3548__auto____5142
      }else {
        var or__3548__auto____5143 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____5143) {
          return or__3548__auto____5143
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____5144 = tcoll;
    if(and__3546__auto____5144) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____5144
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____5145 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5145) {
        return or__3548__auto____5145
      }else {
        var or__3548__auto____5146 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____5146) {
          return or__3548__auto____5146
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5147 = tcoll;
    if(and__3546__auto____5147) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____5147
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5148 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5148) {
        return or__3548__auto____5148
      }else {
        var or__3548__auto____5149 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____5149) {
          return or__3548__auto____5149
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____5150 = tcoll;
    if(and__3546__auto____5150) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____5150
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____5151 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5151) {
        return or__3548__auto____5151
      }else {
        var or__3548__auto____5152 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____5152) {
          return or__3548__auto____5152
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____5153 = x === y;
    if(or__3548__auto____5153) {
      return or__3548__auto____5153
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__5154__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5155 = y;
            var G__5156 = cljs.core.first.call(null, more);
            var G__5157 = cljs.core.next.call(null, more);
            x = G__5155;
            y = G__5156;
            more = G__5157;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5154 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5154__delegate.call(this, x, y, more)
    };
    G__5154.cljs$lang$maxFixedArity = 2;
    G__5154.cljs$lang$applyTo = function(arglist__5158) {
      var x = cljs.core.first(arglist__5158);
      var y = cljs.core.first(cljs.core.next(arglist__5158));
      var more = cljs.core.rest(cljs.core.next(arglist__5158));
      return G__5154__delegate(x, y, more)
    };
    G__5154.cljs$lang$arity$variadic = G__5154__delegate;
    return G__5154
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____5159 = x == null;
    if(or__3548__auto____5159) {
      return or__3548__auto____5159
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__5160 = null;
  var G__5160__2 = function(o, k) {
    return null
  };
  var G__5160__3 = function(o, k, not_found) {
    return not_found
  };
  G__5160 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5160__2.call(this, o, k);
      case 3:
        return G__5160__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5160
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__5161 = null;
  var G__5161__2 = function(_, f) {
    return f.call(null)
  };
  var G__5161__3 = function(_, f, start) {
    return start
  };
  G__5161 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5161__2.call(this, _, f);
      case 3:
        return G__5161__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5161
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__5162 = null;
  var G__5162__2 = function(_, n) {
    return null
  };
  var G__5162__3 = function(_, n, not_found) {
    return not_found
  };
  G__5162 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5162__2.call(this, _, n);
      case 3:
        return G__5162__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5162
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__5163 = cljs.core._nth.call(null, cicoll, 0);
      var n__5164 = 1;
      while(true) {
        if(n__5164 < cljs.core._count.call(null, cicoll)) {
          var nval__5165 = f.call(null, val__5163, cljs.core._nth.call(null, cicoll, n__5164));
          if(cljs.core.reduced_QMARK_.call(null, nval__5165)) {
            return cljs.core.deref.call(null, nval__5165)
          }else {
            var G__5172 = nval__5165;
            var G__5173 = n__5164 + 1;
            val__5163 = G__5172;
            n__5164 = G__5173;
            continue
          }
        }else {
          return val__5163
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__5166 = val;
    var n__5167 = 0;
    while(true) {
      if(n__5167 < cljs.core._count.call(null, cicoll)) {
        var nval__5168 = f.call(null, val__5166, cljs.core._nth.call(null, cicoll, n__5167));
        if(cljs.core.reduced_QMARK_.call(null, nval__5168)) {
          return cljs.core.deref.call(null, nval__5168)
        }else {
          var G__5174 = nval__5168;
          var G__5175 = n__5167 + 1;
          val__5166 = G__5174;
          n__5167 = G__5175;
          continue
        }
      }else {
        return val__5166
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__5169 = val;
    var n__5170 = idx;
    while(true) {
      if(n__5170 < cljs.core._count.call(null, cicoll)) {
        var nval__5171 = f.call(null, val__5169, cljs.core._nth.call(null, cicoll, n__5170));
        if(cljs.core.reduced_QMARK_.call(null, nval__5171)) {
          return cljs.core.deref.call(null, nval__5171)
        }else {
          var G__5176 = nval__5171;
          var G__5177 = n__5170 + 1;
          val__5169 = G__5176;
          n__5170 = G__5177;
          continue
        }
      }else {
        return val__5169
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5178 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5179 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__5180 = this;
  var this$__5181 = this;
  return cljs.core.pr_str.call(null, this$__5181)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5182 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5182.a)) {
    return cljs.core.ci_reduce.call(null, this__5182.a, f, this__5182.a[this__5182.i], this__5182.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__5182.a[this__5182.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5183 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5183.a)) {
    return cljs.core.ci_reduce.call(null, this__5183.a, f, start, this__5183.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__5184 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__5185 = this;
  return this__5185.a.length - this__5185.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5186 = this;
  return this__5186.a[this__5186.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5187 = this;
  if(this__5187.i + 1 < this__5187.a.length) {
    return new cljs.core.IndexedSeq(this__5187.a, this__5187.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5188 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5189 = this;
  var i__5190 = n + this__5189.i;
  if(i__5190 < this__5189.a.length) {
    return this__5189.a[i__5190]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5191 = this;
  var i__5192 = n + this__5191.i;
  if(i__5192 < this__5191.a.length) {
    return this__5191.a[i__5192]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5193 = null;
  var G__5193__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5193__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5193 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5193__2.call(this, array, f);
      case 3:
        return G__5193__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5193
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5194 = null;
  var G__5194__2 = function(array, k) {
    return array[k]
  };
  var G__5194__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5194 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5194__2.call(this, array, k);
      case 3:
        return G__5194__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5194
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5195 = null;
  var G__5195__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5195__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5195 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5195__2.call(this, array, n);
      case 3:
        return G__5195__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5195
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5196__5197 = coll;
      if(G__5196__5197 != null) {
        if(function() {
          var or__3548__auto____5198 = G__5196__5197.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5198) {
            return or__3548__auto____5198
          }else {
            return G__5196__5197.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5196__5197.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5196__5197)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5196__5197)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5199__5200 = coll;
      if(G__5199__5200 != null) {
        if(function() {
          var or__3548__auto____5201 = G__5199__5200.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5201) {
            return or__3548__auto____5201
          }else {
            return G__5199__5200.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5199__5200.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5199__5200)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5199__5200)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5202 = cljs.core.seq.call(null, coll);
      if(s__5202 != null) {
        return cljs.core._first.call(null, s__5202)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5203__5204 = coll;
      if(G__5203__5204 != null) {
        if(function() {
          var or__3548__auto____5205 = G__5203__5204.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5205) {
            return or__3548__auto____5205
          }else {
            return G__5203__5204.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5203__5204.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5203__5204)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5203__5204)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5206 = cljs.core.seq.call(null, coll);
      if(s__5206 != null) {
        return cljs.core._rest.call(null, s__5206)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5207__5208 = coll;
      if(G__5207__5208 != null) {
        if(function() {
          var or__3548__auto____5209 = G__5207__5208.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5209) {
            return or__3548__auto____5209
          }else {
            return G__5207__5208.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5207__5208.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5207__5208)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5207__5208)
      }
    }()) {
      var coll__5210 = cljs.core._rest.call(null, coll);
      if(coll__5210 != null) {
        if(function() {
          var G__5211__5212 = coll__5210;
          if(G__5211__5212 != null) {
            if(function() {
              var or__3548__auto____5213 = G__5211__5212.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5213) {
                return or__3548__auto____5213
              }else {
                return G__5211__5212.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5211__5212.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5211__5212)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5211__5212)
          }
        }()) {
          return coll__5210
        }else {
          return cljs.core._seq.call(null, coll__5210)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5214 = cljs.core.next.call(null, s);
      s = G__5214;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5215__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5216 = conj.call(null, coll, x);
          var G__5217 = cljs.core.first.call(null, xs);
          var G__5218 = cljs.core.next.call(null, xs);
          coll = G__5216;
          x = G__5217;
          xs = G__5218;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5215 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5215__delegate.call(this, coll, x, xs)
    };
    G__5215.cljs$lang$maxFixedArity = 2;
    G__5215.cljs$lang$applyTo = function(arglist__5219) {
      var coll = cljs.core.first(arglist__5219);
      var x = cljs.core.first(cljs.core.next(arglist__5219));
      var xs = cljs.core.rest(cljs.core.next(arglist__5219));
      return G__5215__delegate(coll, x, xs)
    };
    G__5215.cljs$lang$arity$variadic = G__5215__delegate;
    return G__5215
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5220 = cljs.core.seq.call(null, coll);
  var acc__5221 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5220)) {
      return acc__5221 + cljs.core._count.call(null, s__5220)
    }else {
      var G__5222 = cljs.core.next.call(null, s__5220);
      var G__5223 = acc__5221 + 1;
      s__5220 = G__5222;
      acc__5221 = G__5223;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5224__5225 = coll;
        if(G__5224__5225 != null) {
          if(function() {
            var or__3548__auto____5226 = G__5224__5225.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5226) {
              return or__3548__auto____5226
            }else {
              return G__5224__5225.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5224__5225.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5224__5225)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5224__5225)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5227__5228 = coll;
        if(G__5227__5228 != null) {
          if(function() {
            var or__3548__auto____5229 = G__5227__5228.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5229) {
              return or__3548__auto____5229
            }else {
              return G__5227__5228.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5227__5228.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5227__5228)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5227__5228)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5231__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5230 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5232 = ret__5230;
          var G__5233 = cljs.core.first.call(null, kvs);
          var G__5234 = cljs.core.second.call(null, kvs);
          var G__5235 = cljs.core.nnext.call(null, kvs);
          coll = G__5232;
          k = G__5233;
          v = G__5234;
          kvs = G__5235;
          continue
        }else {
          return ret__5230
        }
        break
      }
    };
    var G__5231 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5231__delegate.call(this, coll, k, v, kvs)
    };
    G__5231.cljs$lang$maxFixedArity = 3;
    G__5231.cljs$lang$applyTo = function(arglist__5236) {
      var coll = cljs.core.first(arglist__5236);
      var k = cljs.core.first(cljs.core.next(arglist__5236));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5236)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5236)));
      return G__5231__delegate(coll, k, v, kvs)
    };
    G__5231.cljs$lang$arity$variadic = G__5231__delegate;
    return G__5231
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5238__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5237 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5239 = ret__5237;
          var G__5240 = cljs.core.first.call(null, ks);
          var G__5241 = cljs.core.next.call(null, ks);
          coll = G__5239;
          k = G__5240;
          ks = G__5241;
          continue
        }else {
          return ret__5237
        }
        break
      }
    };
    var G__5238 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5238__delegate.call(this, coll, k, ks)
    };
    G__5238.cljs$lang$maxFixedArity = 2;
    G__5238.cljs$lang$applyTo = function(arglist__5242) {
      var coll = cljs.core.first(arglist__5242);
      var k = cljs.core.first(cljs.core.next(arglist__5242));
      var ks = cljs.core.rest(cljs.core.next(arglist__5242));
      return G__5238__delegate(coll, k, ks)
    };
    G__5238.cljs$lang$arity$variadic = G__5238__delegate;
    return G__5238
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5243__5244 = o;
    if(G__5243__5244 != null) {
      if(function() {
        var or__3548__auto____5245 = G__5243__5244.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5245) {
          return or__3548__auto____5245
        }else {
          return G__5243__5244.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5243__5244.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5243__5244)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5243__5244)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5247__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5246 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5248 = ret__5246;
          var G__5249 = cljs.core.first.call(null, ks);
          var G__5250 = cljs.core.next.call(null, ks);
          coll = G__5248;
          k = G__5249;
          ks = G__5250;
          continue
        }else {
          return ret__5246
        }
        break
      }
    };
    var G__5247 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5247__delegate.call(this, coll, k, ks)
    };
    G__5247.cljs$lang$maxFixedArity = 2;
    G__5247.cljs$lang$applyTo = function(arglist__5251) {
      var coll = cljs.core.first(arglist__5251);
      var k = cljs.core.first(cljs.core.next(arglist__5251));
      var ks = cljs.core.rest(cljs.core.next(arglist__5251));
      return G__5247__delegate(coll, k, ks)
    };
    G__5247.cljs$lang$arity$variadic = G__5247__delegate;
    return G__5247
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5252__5253 = x;
    if(G__5252__5253 != null) {
      if(function() {
        var or__3548__auto____5254 = G__5252__5253.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5254) {
          return or__3548__auto____5254
        }else {
          return G__5252__5253.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5252__5253.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5252__5253)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5252__5253)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5255__5256 = x;
    if(G__5255__5256 != null) {
      if(function() {
        var or__3548__auto____5257 = G__5255__5256.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5257) {
          return or__3548__auto____5257
        }else {
          return G__5255__5256.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5255__5256.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5255__5256)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5255__5256)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5258__5259 = x;
  if(G__5258__5259 != null) {
    if(function() {
      var or__3548__auto____5260 = G__5258__5259.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5260) {
        return or__3548__auto____5260
      }else {
        return G__5258__5259.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5258__5259.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5258__5259)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5258__5259)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5261__5262 = x;
  if(G__5261__5262 != null) {
    if(function() {
      var or__3548__auto____5263 = G__5261__5262.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5263) {
        return or__3548__auto____5263
      }else {
        return G__5261__5262.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5261__5262.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5261__5262)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5261__5262)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5264__5265 = x;
  if(G__5264__5265 != null) {
    if(function() {
      var or__3548__auto____5266 = G__5264__5265.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5266) {
        return or__3548__auto____5266
      }else {
        return G__5264__5265.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5264__5265.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5264__5265)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5264__5265)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5267__5268 = x;
  if(G__5267__5268 != null) {
    if(function() {
      var or__3548__auto____5269 = G__5267__5268.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5269) {
        return or__3548__auto____5269
      }else {
        return G__5267__5268.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5267__5268.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5267__5268)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5267__5268)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5270__5271 = x;
  if(G__5270__5271 != null) {
    if(function() {
      var or__3548__auto____5272 = G__5270__5271.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5272) {
        return or__3548__auto____5272
      }else {
        return G__5270__5271.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5270__5271.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5270__5271)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5270__5271)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5273__5274 = x;
    if(G__5273__5274 != null) {
      if(function() {
        var or__3548__auto____5275 = G__5273__5274.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5275) {
          return or__3548__auto____5275
        }else {
          return G__5273__5274.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5273__5274.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5273__5274)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5273__5274)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5276__5277 = x;
  if(G__5276__5277 != null) {
    if(function() {
      var or__3548__auto____5278 = G__5276__5277.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5278) {
        return or__3548__auto____5278
      }else {
        return G__5276__5277.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5276__5277.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5276__5277)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5276__5277)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5279__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5279 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5279__delegate.call(this, keyvals)
    };
    G__5279.cljs$lang$maxFixedArity = 0;
    G__5279.cljs$lang$applyTo = function(arglist__5280) {
      var keyvals = cljs.core.seq(arglist__5280);
      return G__5279__delegate(keyvals)
    };
    G__5279.cljs$lang$arity$variadic = G__5279__delegate;
    return G__5279
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5281 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5281.push(key)
  });
  return keys__5281
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5282 = i;
  var j__5283 = j;
  var len__5284 = len;
  while(true) {
    if(len__5284 === 0) {
      return to
    }else {
      to[j__5283] = from[i__5282];
      var G__5285 = i__5282 + 1;
      var G__5286 = j__5283 + 1;
      var G__5287 = len__5284 - 1;
      i__5282 = G__5285;
      j__5283 = G__5286;
      len__5284 = G__5287;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5288 = i + (len - 1);
  var j__5289 = j + (len - 1);
  var len__5290 = len;
  while(true) {
    if(len__5290 === 0) {
      return to
    }else {
      to[j__5289] = from[i__5288];
      var G__5291 = i__5288 - 1;
      var G__5292 = j__5289 - 1;
      var G__5293 = len__5290 - 1;
      i__5288 = G__5291;
      j__5289 = G__5292;
      len__5290 = G__5293;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5294__5295 = s;
    if(G__5294__5295 != null) {
      if(function() {
        var or__3548__auto____5296 = G__5294__5295.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5296) {
          return or__3548__auto____5296
        }else {
          return G__5294__5295.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5294__5295.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5294__5295)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5294__5295)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5297__5298 = s;
  if(G__5297__5298 != null) {
    if(function() {
      var or__3548__auto____5299 = G__5297__5298.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5299) {
        return or__3548__auto____5299
      }else {
        return G__5297__5298.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5297__5298.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5297__5298)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5297__5298)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5300 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5300)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5301 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5301) {
        return or__3548__auto____5301
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5300
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5302 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5302)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5302
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5303 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5303)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5303
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5304 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5304) {
    return or__3548__auto____5304
  }else {
    var G__5305__5306 = f;
    if(G__5305__5306 != null) {
      if(function() {
        var or__3548__auto____5307 = G__5305__5306.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5307) {
          return or__3548__auto____5307
        }else {
          return G__5305__5306.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5305__5306.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5305__5306)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5305__5306)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5308 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5308) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5308
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5309 = coll;
    if(cljs.core.truth_(and__3546__auto____5309)) {
      var and__3546__auto____5310 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5310) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5310
      }
    }else {
      return and__3546__auto____5309
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5315__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5311 = cljs.core.set([y, x]);
        var xs__5312 = more;
        while(true) {
          var x__5313 = cljs.core.first.call(null, xs__5312);
          var etc__5314 = cljs.core.next.call(null, xs__5312);
          if(cljs.core.truth_(xs__5312)) {
            if(cljs.core.contains_QMARK_.call(null, s__5311, x__5313)) {
              return false
            }else {
              var G__5316 = cljs.core.conj.call(null, s__5311, x__5313);
              var G__5317 = etc__5314;
              s__5311 = G__5316;
              xs__5312 = G__5317;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5315 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5315__delegate.call(this, x, y, more)
    };
    G__5315.cljs$lang$maxFixedArity = 2;
    G__5315.cljs$lang$applyTo = function(arglist__5318) {
      var x = cljs.core.first(arglist__5318);
      var y = cljs.core.first(cljs.core.next(arglist__5318));
      var more = cljs.core.rest(cljs.core.next(arglist__5318));
      return G__5315__delegate(x, y, more)
    };
    G__5315.cljs$lang$arity$variadic = G__5315__delegate;
    return G__5315
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5319 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5319)) {
        return r__5319
      }else {
        if(cljs.core.truth_(r__5319)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5320 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5320, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5320)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5321 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5321)) {
      var s__5322 = temp__3695__auto____5321;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5322), cljs.core.next.call(null, s__5322))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5323 = val;
    var coll__5324 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5324)) {
        var nval__5325 = f.call(null, val__5323, cljs.core.first.call(null, coll__5324));
        if(cljs.core.reduced_QMARK_.call(null, nval__5325)) {
          return cljs.core.deref.call(null, nval__5325)
        }else {
          var G__5326 = nval__5325;
          var G__5327 = cljs.core.next.call(null, coll__5324);
          val__5323 = G__5326;
          coll__5324 = G__5327;
          continue
        }
      }else {
        return val__5323
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5328__5329 = coll;
      if(G__5328__5329 != null) {
        if(function() {
          var or__3548__auto____5330 = G__5328__5329.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5330) {
            return or__3548__auto____5330
          }else {
            return G__5328__5329.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5328__5329.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5328__5329)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5328__5329)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5331__5332 = coll;
      if(G__5331__5332 != null) {
        if(function() {
          var or__3548__auto____5333 = G__5331__5332.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5333) {
            return or__3548__auto____5333
          }else {
            return G__5331__5332.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5331__5332.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5331__5332)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5331__5332)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5334 = this;
  return this__5334.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5335__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5335 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5335__delegate.call(this, x, y, more)
    };
    G__5335.cljs$lang$maxFixedArity = 2;
    G__5335.cljs$lang$applyTo = function(arglist__5336) {
      var x = cljs.core.first(arglist__5336);
      var y = cljs.core.first(cljs.core.next(arglist__5336));
      var more = cljs.core.rest(cljs.core.next(arglist__5336));
      return G__5335__delegate(x, y, more)
    };
    G__5335.cljs$lang$arity$variadic = G__5335__delegate;
    return G__5335
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5337__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5337 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5337__delegate.call(this, x, y, more)
    };
    G__5337.cljs$lang$maxFixedArity = 2;
    G__5337.cljs$lang$applyTo = function(arglist__5338) {
      var x = cljs.core.first(arglist__5338);
      var y = cljs.core.first(cljs.core.next(arglist__5338));
      var more = cljs.core.rest(cljs.core.next(arglist__5338));
      return G__5337__delegate(x, y, more)
    };
    G__5337.cljs$lang$arity$variadic = G__5337__delegate;
    return G__5337
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5339__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5339 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5339__delegate.call(this, x, y, more)
    };
    G__5339.cljs$lang$maxFixedArity = 2;
    G__5339.cljs$lang$applyTo = function(arglist__5340) {
      var x = cljs.core.first(arglist__5340);
      var y = cljs.core.first(cljs.core.next(arglist__5340));
      var more = cljs.core.rest(cljs.core.next(arglist__5340));
      return G__5339__delegate(x, y, more)
    };
    G__5339.cljs$lang$arity$variadic = G__5339__delegate;
    return G__5339
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5341__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5341 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5341__delegate.call(this, x, y, more)
    };
    G__5341.cljs$lang$maxFixedArity = 2;
    G__5341.cljs$lang$applyTo = function(arglist__5342) {
      var x = cljs.core.first(arglist__5342);
      var y = cljs.core.first(cljs.core.next(arglist__5342));
      var more = cljs.core.rest(cljs.core.next(arglist__5342));
      return G__5341__delegate(x, y, more)
    };
    G__5341.cljs$lang$arity$variadic = G__5341__delegate;
    return G__5341
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5343__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5344 = y;
            var G__5345 = cljs.core.first.call(null, more);
            var G__5346 = cljs.core.next.call(null, more);
            x = G__5344;
            y = G__5345;
            more = G__5346;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5343 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5343__delegate.call(this, x, y, more)
    };
    G__5343.cljs$lang$maxFixedArity = 2;
    G__5343.cljs$lang$applyTo = function(arglist__5347) {
      var x = cljs.core.first(arglist__5347);
      var y = cljs.core.first(cljs.core.next(arglist__5347));
      var more = cljs.core.rest(cljs.core.next(arglist__5347));
      return G__5343__delegate(x, y, more)
    };
    G__5343.cljs$lang$arity$variadic = G__5343__delegate;
    return G__5343
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5348__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5349 = y;
            var G__5350 = cljs.core.first.call(null, more);
            var G__5351 = cljs.core.next.call(null, more);
            x = G__5349;
            y = G__5350;
            more = G__5351;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5348 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5348__delegate.call(this, x, y, more)
    };
    G__5348.cljs$lang$maxFixedArity = 2;
    G__5348.cljs$lang$applyTo = function(arglist__5352) {
      var x = cljs.core.first(arglist__5352);
      var y = cljs.core.first(cljs.core.next(arglist__5352));
      var more = cljs.core.rest(cljs.core.next(arglist__5352));
      return G__5348__delegate(x, y, more)
    };
    G__5348.cljs$lang$arity$variadic = G__5348__delegate;
    return G__5348
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5353__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5354 = y;
            var G__5355 = cljs.core.first.call(null, more);
            var G__5356 = cljs.core.next.call(null, more);
            x = G__5354;
            y = G__5355;
            more = G__5356;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5353 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5353__delegate.call(this, x, y, more)
    };
    G__5353.cljs$lang$maxFixedArity = 2;
    G__5353.cljs$lang$applyTo = function(arglist__5357) {
      var x = cljs.core.first(arglist__5357);
      var y = cljs.core.first(cljs.core.next(arglist__5357));
      var more = cljs.core.rest(cljs.core.next(arglist__5357));
      return G__5353__delegate(x, y, more)
    };
    G__5353.cljs$lang$arity$variadic = G__5353__delegate;
    return G__5353
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5358__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5359 = y;
            var G__5360 = cljs.core.first.call(null, more);
            var G__5361 = cljs.core.next.call(null, more);
            x = G__5359;
            y = G__5360;
            more = G__5361;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5358 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5358__delegate.call(this, x, y, more)
    };
    G__5358.cljs$lang$maxFixedArity = 2;
    G__5358.cljs$lang$applyTo = function(arglist__5362) {
      var x = cljs.core.first(arglist__5362);
      var y = cljs.core.first(cljs.core.next(arglist__5362));
      var more = cljs.core.rest(cljs.core.next(arglist__5362));
      return G__5358__delegate(x, y, more)
    };
    G__5358.cljs$lang$arity$variadic = G__5358__delegate;
    return G__5358
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5363__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5363 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5363__delegate.call(this, x, y, more)
    };
    G__5363.cljs$lang$maxFixedArity = 2;
    G__5363.cljs$lang$applyTo = function(arglist__5364) {
      var x = cljs.core.first(arglist__5364);
      var y = cljs.core.first(cljs.core.next(arglist__5364));
      var more = cljs.core.rest(cljs.core.next(arglist__5364));
      return G__5363__delegate(x, y, more)
    };
    G__5363.cljs$lang$arity$variadic = G__5363__delegate;
    return G__5363
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5365__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5365 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5365__delegate.call(this, x, y, more)
    };
    G__5365.cljs$lang$maxFixedArity = 2;
    G__5365.cljs$lang$applyTo = function(arglist__5366) {
      var x = cljs.core.first(arglist__5366);
      var y = cljs.core.first(cljs.core.next(arglist__5366));
      var more = cljs.core.rest(cljs.core.next(arglist__5366));
      return G__5365__delegate(x, y, more)
    };
    G__5365.cljs$lang$arity$variadic = G__5365__delegate;
    return G__5365
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5367 = n % d;
  return cljs.core.fix.call(null, (n - rem__5367) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5368 = cljs.core.quot.call(null, n, d);
  return n - d * q__5368
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5369 = 0;
  var n__5370 = n;
  while(true) {
    if(n__5370 === 0) {
      return c__5369
    }else {
      var G__5371 = c__5369 + 1;
      var G__5372 = n__5370 & n__5370 - 1;
      c__5369 = G__5371;
      n__5370 = G__5372;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5373__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5374 = y;
            var G__5375 = cljs.core.first.call(null, more);
            var G__5376 = cljs.core.next.call(null, more);
            x = G__5374;
            y = G__5375;
            more = G__5376;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5373 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5373__delegate.call(this, x, y, more)
    };
    G__5373.cljs$lang$maxFixedArity = 2;
    G__5373.cljs$lang$applyTo = function(arglist__5377) {
      var x = cljs.core.first(arglist__5377);
      var y = cljs.core.first(cljs.core.next(arglist__5377));
      var more = cljs.core.rest(cljs.core.next(arglist__5377));
      return G__5373__delegate(x, y, more)
    };
    G__5373.cljs$lang$arity$variadic = G__5373__delegate;
    return G__5373
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5378 = n;
  var xs__5379 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5380 = xs__5379;
      if(cljs.core.truth_(and__3546__auto____5380)) {
        return n__5378 > 0
      }else {
        return and__3546__auto____5380
      }
    }())) {
      var G__5381 = n__5378 - 1;
      var G__5382 = cljs.core.next.call(null, xs__5379);
      n__5378 = G__5381;
      xs__5379 = G__5382;
      continue
    }else {
      return xs__5379
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5383__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5384 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5385 = cljs.core.next.call(null, more);
            sb = G__5384;
            more = G__5385;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5383 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5383__delegate.call(this, x, ys)
    };
    G__5383.cljs$lang$maxFixedArity = 1;
    G__5383.cljs$lang$applyTo = function(arglist__5386) {
      var x = cljs.core.first(arglist__5386);
      var ys = cljs.core.rest(arglist__5386);
      return G__5383__delegate(x, ys)
    };
    G__5383.cljs$lang$arity$variadic = G__5383__delegate;
    return G__5383
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5387__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5388 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5389 = cljs.core.next.call(null, more);
            sb = G__5388;
            more = G__5389;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5387 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5387__delegate.call(this, x, ys)
    };
    G__5387.cljs$lang$maxFixedArity = 1;
    G__5387.cljs$lang$applyTo = function(arglist__5390) {
      var x = cljs.core.first(arglist__5390);
      var ys = cljs.core.rest(arglist__5390);
      return G__5387__delegate(x, ys)
    };
    G__5387.cljs$lang$arity$variadic = G__5387__delegate;
    return G__5387
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5391 = cljs.core.seq.call(null, x);
    var ys__5392 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5391 == null) {
        return ys__5392 == null
      }else {
        if(ys__5392 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5391), cljs.core.first.call(null, ys__5392))) {
            var G__5393 = cljs.core.next.call(null, xs__5391);
            var G__5394 = cljs.core.next.call(null, ys__5392);
            xs__5391 = G__5393;
            ys__5392 = G__5394;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5395_SHARP_, p2__5396_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5395_SHARP_, cljs.core.hash.call(null, p2__5396_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5397 = 0;
  var s__5398 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5398)) {
      var e__5399 = cljs.core.first.call(null, s__5398);
      var G__5400 = (h__5397 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5399)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5399)))) % 4503599627370496;
      var G__5401 = cljs.core.next.call(null, s__5398);
      h__5397 = G__5400;
      s__5398 = G__5401;
      continue
    }else {
      return h__5397
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5402 = 0;
  var s__5403 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5403)) {
      var e__5404 = cljs.core.first.call(null, s__5403);
      var G__5405 = (h__5402 + cljs.core.hash.call(null, e__5404)) % 4503599627370496;
      var G__5406 = cljs.core.next.call(null, s__5403);
      h__5402 = G__5405;
      s__5403 = G__5406;
      continue
    }else {
      return h__5402
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5407__5408 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5407__5408)) {
    var G__5410__5412 = cljs.core.first.call(null, G__5407__5408);
    var vec__5411__5413 = G__5410__5412;
    var key_name__5414 = cljs.core.nth.call(null, vec__5411__5413, 0, null);
    var f__5415 = cljs.core.nth.call(null, vec__5411__5413, 1, null);
    var G__5407__5416 = G__5407__5408;
    var G__5410__5417 = G__5410__5412;
    var G__5407__5418 = G__5407__5416;
    while(true) {
      var vec__5419__5420 = G__5410__5417;
      var key_name__5421 = cljs.core.nth.call(null, vec__5419__5420, 0, null);
      var f__5422 = cljs.core.nth.call(null, vec__5419__5420, 1, null);
      var G__5407__5423 = G__5407__5418;
      var str_name__5424 = cljs.core.name.call(null, key_name__5421);
      obj[str_name__5424] = f__5422;
      var temp__3698__auto____5425 = cljs.core.next.call(null, G__5407__5423);
      if(cljs.core.truth_(temp__3698__auto____5425)) {
        var G__5407__5426 = temp__3698__auto____5425;
        var G__5427 = cljs.core.first.call(null, G__5407__5426);
        var G__5428 = G__5407__5426;
        G__5410__5417 = G__5427;
        G__5407__5418 = G__5428;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5429 = this;
  var h__364__auto____5430 = this__5429.__hash;
  if(h__364__auto____5430 != null) {
    return h__364__auto____5430
  }else {
    var h__364__auto____5431 = cljs.core.hash_coll.call(null, coll);
    this__5429.__hash = h__364__auto____5431;
    return h__364__auto____5431
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5432 = this;
  return new cljs.core.List(this__5432.meta, o, coll, this__5432.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5433 = this;
  var this$__5434 = this;
  return cljs.core.pr_str.call(null, this$__5434)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5435 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5436 = this;
  return this__5436.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5437 = this;
  return this__5437.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5438 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5439 = this;
  return this__5439.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5440 = this;
  return this__5440.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5441 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5442 = this;
  return new cljs.core.List(meta, this__5442.first, this__5442.rest, this__5442.count, this__5442.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5443 = this;
  return this__5443.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5444 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5445 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5446 = this;
  return new cljs.core.List(this__5446.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5447 = this;
  var this$__5448 = this;
  return cljs.core.pr_str.call(null, this$__5448)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5449 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5450 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5451 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5452 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5453 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5454 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5455 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5456 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5457 = this;
  return this__5457.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5458 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5459__5460 = coll;
  if(G__5459__5460 != null) {
    if(function() {
      var or__3548__auto____5461 = G__5459__5460.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5461) {
        return or__3548__auto____5461
      }else {
        return G__5459__5460.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5459__5460.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5459__5460)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5459__5460)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5462) {
    var items = cljs.core.seq(arglist__5462);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5463 = this;
  var h__364__auto____5464 = this__5463.__hash;
  if(h__364__auto____5464 != null) {
    return h__364__auto____5464
  }else {
    var h__364__auto____5465 = cljs.core.hash_coll.call(null, coll);
    this__5463.__hash = h__364__auto____5465;
    return h__364__auto____5465
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5466 = this;
  return new cljs.core.Cons(null, o, coll, this__5466.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5467 = this;
  var this$__5468 = this;
  return cljs.core.pr_str.call(null, this$__5468)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5469 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5470 = this;
  return this__5470.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5471 = this;
  if(this__5471.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5471.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5472 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5473 = this;
  return new cljs.core.Cons(meta, this__5473.first, this__5473.rest, this__5473.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5474 = this;
  return this__5474.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5475 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5475.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5476 = coll == null;
    if(or__3548__auto____5476) {
      return or__3548__auto____5476
    }else {
      var G__5477__5478 = coll;
      if(G__5477__5478 != null) {
        if(function() {
          var or__3548__auto____5479 = G__5477__5478.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5479) {
            return or__3548__auto____5479
          }else {
            return G__5477__5478.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5477__5478.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5477__5478)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5477__5478)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5480__5481 = x;
  if(G__5480__5481 != null) {
    if(function() {
      var or__3548__auto____5482 = G__5480__5481.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5482) {
        return or__3548__auto____5482
      }else {
        return G__5480__5481.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5480__5481.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5480__5481)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5480__5481)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5483 = null;
  var G__5483__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5483__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5483 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5483__2.call(this, string, f);
      case 3:
        return G__5483__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5483
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5484 = null;
  var G__5484__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5484__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5484 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5484__2.call(this, string, k);
      case 3:
        return G__5484__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5484
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5485 = null;
  var G__5485__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5485__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5485 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5485__2.call(this, string, n);
      case 3:
        return G__5485__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5485
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5494 = null;
  var G__5494__2 = function(tsym5488, coll) {
    var tsym5488__5490 = this;
    var this$__5491 = tsym5488__5490;
    return cljs.core.get.call(null, coll, this$__5491.toString())
  };
  var G__5494__3 = function(tsym5489, coll, not_found) {
    var tsym5489__5492 = this;
    var this$__5493 = tsym5489__5492;
    return cljs.core.get.call(null, coll, this$__5493.toString(), not_found)
  };
  G__5494 = function(tsym5489, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5494__2.call(this, tsym5489, coll);
      case 3:
        return G__5494__3.call(this, tsym5489, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5494
}();
String.prototype.apply = function(tsym5486, args5487) {
  return tsym5486.call.apply(tsym5486, [tsym5486].concat(cljs.core.aclone.call(null, args5487)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5495 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5495
  }else {
    lazy_seq.x = x__5495.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5496 = this;
  var h__364__auto____5497 = this__5496.__hash;
  if(h__364__auto____5497 != null) {
    return h__364__auto____5497
  }else {
    var h__364__auto____5498 = cljs.core.hash_coll.call(null, coll);
    this__5496.__hash = h__364__auto____5498;
    return h__364__auto____5498
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5499 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5500 = this;
  var this$__5501 = this;
  return cljs.core.pr_str.call(null, this$__5501)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5502 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5503 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5504 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5505 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5506 = this;
  return new cljs.core.LazySeq(meta, this__5506.realized, this__5506.x, this__5506.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5507 = this;
  return this__5507.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5508 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5508.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5509 = [];
  var s__5510 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5510))) {
      ary__5509.push(cljs.core.first.call(null, s__5510));
      var G__5511 = cljs.core.next.call(null, s__5510);
      s__5510 = G__5511;
      continue
    }else {
      return ary__5509
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5512 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5513 = 0;
  var xs__5514 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5514)) {
      ret__5512[i__5513] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5514));
      var G__5515 = i__5513 + 1;
      var G__5516 = cljs.core.next.call(null, xs__5514);
      i__5513 = G__5515;
      xs__5514 = G__5516;
      continue
    }else {
    }
    break
  }
  return ret__5512
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5517 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5518 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5519 = 0;
      var s__5520 = s__5518;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5521 = s__5520;
          if(cljs.core.truth_(and__3546__auto____5521)) {
            return i__5519 < size
          }else {
            return and__3546__auto____5521
          }
        }())) {
          a__5517[i__5519] = cljs.core.first.call(null, s__5520);
          var G__5524 = i__5519 + 1;
          var G__5525 = cljs.core.next.call(null, s__5520);
          i__5519 = G__5524;
          s__5520 = G__5525;
          continue
        }else {
          return a__5517
        }
        break
      }
    }else {
      var n__685__auto____5522 = size;
      var i__5523 = 0;
      while(true) {
        if(i__5523 < n__685__auto____5522) {
          a__5517[i__5523] = init_val_or_seq;
          var G__5526 = i__5523 + 1;
          i__5523 = G__5526;
          continue
        }else {
        }
        break
      }
      return a__5517
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5527 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5528 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5529 = 0;
      var s__5530 = s__5528;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5531 = s__5530;
          if(cljs.core.truth_(and__3546__auto____5531)) {
            return i__5529 < size
          }else {
            return and__3546__auto____5531
          }
        }())) {
          a__5527[i__5529] = cljs.core.first.call(null, s__5530);
          var G__5534 = i__5529 + 1;
          var G__5535 = cljs.core.next.call(null, s__5530);
          i__5529 = G__5534;
          s__5530 = G__5535;
          continue
        }else {
          return a__5527
        }
        break
      }
    }else {
      var n__685__auto____5532 = size;
      var i__5533 = 0;
      while(true) {
        if(i__5533 < n__685__auto____5532) {
          a__5527[i__5533] = init_val_or_seq;
          var G__5536 = i__5533 + 1;
          i__5533 = G__5536;
          continue
        }else {
        }
        break
      }
      return a__5527
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5537 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5538 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5539 = 0;
      var s__5540 = s__5538;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5541 = s__5540;
          if(cljs.core.truth_(and__3546__auto____5541)) {
            return i__5539 < size
          }else {
            return and__3546__auto____5541
          }
        }())) {
          a__5537[i__5539] = cljs.core.first.call(null, s__5540);
          var G__5544 = i__5539 + 1;
          var G__5545 = cljs.core.next.call(null, s__5540);
          i__5539 = G__5544;
          s__5540 = G__5545;
          continue
        }else {
          return a__5537
        }
        break
      }
    }else {
      var n__685__auto____5542 = size;
      var i__5543 = 0;
      while(true) {
        if(i__5543 < n__685__auto____5542) {
          a__5537[i__5543] = init_val_or_seq;
          var G__5546 = i__5543 + 1;
          i__5543 = G__5546;
          continue
        }else {
        }
        break
      }
      return a__5537
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5547 = s;
    var i__5548 = n;
    var sum__5549 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5550 = i__5548 > 0;
        if(and__3546__auto____5550) {
          return cljs.core.seq.call(null, s__5547)
        }else {
          return and__3546__auto____5550
        }
      }())) {
        var G__5551 = cljs.core.next.call(null, s__5547);
        var G__5552 = i__5548 - 1;
        var G__5553 = sum__5549 + 1;
        s__5547 = G__5551;
        i__5548 = G__5552;
        sum__5549 = G__5553;
        continue
      }else {
        return sum__5549
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5554 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5554)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5554), concat.call(null, cljs.core.rest.call(null, s__5554), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5557__delegate = function(x, y, zs) {
      var cat__5556 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5555 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5555)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5555), cat.call(null, cljs.core.rest.call(null, xys__5555), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5556.call(null, concat.call(null, x, y), zs)
    };
    var G__5557 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5557__delegate.call(this, x, y, zs)
    };
    G__5557.cljs$lang$maxFixedArity = 2;
    G__5557.cljs$lang$applyTo = function(arglist__5558) {
      var x = cljs.core.first(arglist__5558);
      var y = cljs.core.first(cljs.core.next(arglist__5558));
      var zs = cljs.core.rest(cljs.core.next(arglist__5558));
      return G__5557__delegate(x, y, zs)
    };
    G__5557.cljs$lang$arity$variadic = G__5557__delegate;
    return G__5557
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5559__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5559 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5559__delegate.call(this, a, b, c, d, more)
    };
    G__5559.cljs$lang$maxFixedArity = 4;
    G__5559.cljs$lang$applyTo = function(arglist__5560) {
      var a = cljs.core.first(arglist__5560);
      var b = cljs.core.first(cljs.core.next(arglist__5560));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5560)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5560))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5560))));
      return G__5559__delegate(a, b, c, d, more)
    };
    G__5559.cljs$lang$arity$variadic = G__5559__delegate;
    return G__5559
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5561 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5562 = cljs.core._first.call(null, args__5561);
    var args__5563 = cljs.core._rest.call(null, args__5561);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5562)
      }else {
        return f.call(null, a__5562)
      }
    }else {
      var b__5564 = cljs.core._first.call(null, args__5563);
      var args__5565 = cljs.core._rest.call(null, args__5563);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5562, b__5564)
        }else {
          return f.call(null, a__5562, b__5564)
        }
      }else {
        var c__5566 = cljs.core._first.call(null, args__5565);
        var args__5567 = cljs.core._rest.call(null, args__5565);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5562, b__5564, c__5566)
          }else {
            return f.call(null, a__5562, b__5564, c__5566)
          }
        }else {
          var d__5568 = cljs.core._first.call(null, args__5567);
          var args__5569 = cljs.core._rest.call(null, args__5567);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5562, b__5564, c__5566, d__5568)
            }else {
              return f.call(null, a__5562, b__5564, c__5566, d__5568)
            }
          }else {
            var e__5570 = cljs.core._first.call(null, args__5569);
            var args__5571 = cljs.core._rest.call(null, args__5569);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5562, b__5564, c__5566, d__5568, e__5570)
              }else {
                return f.call(null, a__5562, b__5564, c__5566, d__5568, e__5570)
              }
            }else {
              var f__5572 = cljs.core._first.call(null, args__5571);
              var args__5573 = cljs.core._rest.call(null, args__5571);
              if(argc === 6) {
                if(f__5572.cljs$lang$arity$6) {
                  return f__5572.cljs$lang$arity$6(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572)
                }else {
                  return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572)
                }
              }else {
                var g__5574 = cljs.core._first.call(null, args__5573);
                var args__5575 = cljs.core._rest.call(null, args__5573);
                if(argc === 7) {
                  if(f__5572.cljs$lang$arity$7) {
                    return f__5572.cljs$lang$arity$7(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574)
                  }else {
                    return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574)
                  }
                }else {
                  var h__5576 = cljs.core._first.call(null, args__5575);
                  var args__5577 = cljs.core._rest.call(null, args__5575);
                  if(argc === 8) {
                    if(f__5572.cljs$lang$arity$8) {
                      return f__5572.cljs$lang$arity$8(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576)
                    }else {
                      return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576)
                    }
                  }else {
                    var i__5578 = cljs.core._first.call(null, args__5577);
                    var args__5579 = cljs.core._rest.call(null, args__5577);
                    if(argc === 9) {
                      if(f__5572.cljs$lang$arity$9) {
                        return f__5572.cljs$lang$arity$9(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578)
                      }else {
                        return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578)
                      }
                    }else {
                      var j__5580 = cljs.core._first.call(null, args__5579);
                      var args__5581 = cljs.core._rest.call(null, args__5579);
                      if(argc === 10) {
                        if(f__5572.cljs$lang$arity$10) {
                          return f__5572.cljs$lang$arity$10(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580)
                        }else {
                          return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580)
                        }
                      }else {
                        var k__5582 = cljs.core._first.call(null, args__5581);
                        var args__5583 = cljs.core._rest.call(null, args__5581);
                        if(argc === 11) {
                          if(f__5572.cljs$lang$arity$11) {
                            return f__5572.cljs$lang$arity$11(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582)
                          }else {
                            return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582)
                          }
                        }else {
                          var l__5584 = cljs.core._first.call(null, args__5583);
                          var args__5585 = cljs.core._rest.call(null, args__5583);
                          if(argc === 12) {
                            if(f__5572.cljs$lang$arity$12) {
                              return f__5572.cljs$lang$arity$12(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584)
                            }else {
                              return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584)
                            }
                          }else {
                            var m__5586 = cljs.core._first.call(null, args__5585);
                            var args__5587 = cljs.core._rest.call(null, args__5585);
                            if(argc === 13) {
                              if(f__5572.cljs$lang$arity$13) {
                                return f__5572.cljs$lang$arity$13(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586)
                              }else {
                                return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586)
                              }
                            }else {
                              var n__5588 = cljs.core._first.call(null, args__5587);
                              var args__5589 = cljs.core._rest.call(null, args__5587);
                              if(argc === 14) {
                                if(f__5572.cljs$lang$arity$14) {
                                  return f__5572.cljs$lang$arity$14(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588)
                                }else {
                                  return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588)
                                }
                              }else {
                                var o__5590 = cljs.core._first.call(null, args__5589);
                                var args__5591 = cljs.core._rest.call(null, args__5589);
                                if(argc === 15) {
                                  if(f__5572.cljs$lang$arity$15) {
                                    return f__5572.cljs$lang$arity$15(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590)
                                  }else {
                                    return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590)
                                  }
                                }else {
                                  var p__5592 = cljs.core._first.call(null, args__5591);
                                  var args__5593 = cljs.core._rest.call(null, args__5591);
                                  if(argc === 16) {
                                    if(f__5572.cljs$lang$arity$16) {
                                      return f__5572.cljs$lang$arity$16(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592)
                                    }else {
                                      return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592)
                                    }
                                  }else {
                                    var q__5594 = cljs.core._first.call(null, args__5593);
                                    var args__5595 = cljs.core._rest.call(null, args__5593);
                                    if(argc === 17) {
                                      if(f__5572.cljs$lang$arity$17) {
                                        return f__5572.cljs$lang$arity$17(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594)
                                      }else {
                                        return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594)
                                      }
                                    }else {
                                      var r__5596 = cljs.core._first.call(null, args__5595);
                                      var args__5597 = cljs.core._rest.call(null, args__5595);
                                      if(argc === 18) {
                                        if(f__5572.cljs$lang$arity$18) {
                                          return f__5572.cljs$lang$arity$18(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594, r__5596)
                                        }else {
                                          return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594, r__5596)
                                        }
                                      }else {
                                        var s__5598 = cljs.core._first.call(null, args__5597);
                                        var args__5599 = cljs.core._rest.call(null, args__5597);
                                        if(argc === 19) {
                                          if(f__5572.cljs$lang$arity$19) {
                                            return f__5572.cljs$lang$arity$19(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594, r__5596, s__5598)
                                          }else {
                                            return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594, r__5596, s__5598)
                                          }
                                        }else {
                                          var t__5600 = cljs.core._first.call(null, args__5599);
                                          var args__5601 = cljs.core._rest.call(null, args__5599);
                                          if(argc === 20) {
                                            if(f__5572.cljs$lang$arity$20) {
                                              return f__5572.cljs$lang$arity$20(a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594, r__5596, s__5598, t__5600)
                                            }else {
                                              return f__5572.call(null, a__5562, b__5564, c__5566, d__5568, e__5570, f__5572, g__5574, h__5576, i__5578, j__5580, k__5582, l__5584, m__5586, n__5588, o__5590, p__5592, q__5594, r__5596, s__5598, t__5600)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5602 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5603 = cljs.core.bounded_count.call(null, args, fixed_arity__5602 + 1);
      if(bc__5603 <= fixed_arity__5602) {
        return cljs.core.apply_to.call(null, f, bc__5603, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5604 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5605 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5606 = cljs.core.bounded_count.call(null, arglist__5604, fixed_arity__5605 + 1);
      if(bc__5606 <= fixed_arity__5605) {
        return cljs.core.apply_to.call(null, f, bc__5606, arglist__5604)
      }else {
        return f.cljs$lang$applyTo(arglist__5604)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5604))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5607 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5608 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5609 = cljs.core.bounded_count.call(null, arglist__5607, fixed_arity__5608 + 1);
      if(bc__5609 <= fixed_arity__5608) {
        return cljs.core.apply_to.call(null, f, bc__5609, arglist__5607)
      }else {
        return f.cljs$lang$applyTo(arglist__5607)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5607))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5610 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5611 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5612 = cljs.core.bounded_count.call(null, arglist__5610, fixed_arity__5611 + 1);
      if(bc__5612 <= fixed_arity__5611) {
        return cljs.core.apply_to.call(null, f, bc__5612, arglist__5610)
      }else {
        return f.cljs$lang$applyTo(arglist__5610)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5610))
    }
  };
  var apply__6 = function() {
    var G__5616__delegate = function(f, a, b, c, d, args) {
      var arglist__5613 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5614 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5615 = cljs.core.bounded_count.call(null, arglist__5613, fixed_arity__5614 + 1);
        if(bc__5615 <= fixed_arity__5614) {
          return cljs.core.apply_to.call(null, f, bc__5615, arglist__5613)
        }else {
          return f.cljs$lang$applyTo(arglist__5613)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5613))
      }
    };
    var G__5616 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5616__delegate.call(this, f, a, b, c, d, args)
    };
    G__5616.cljs$lang$maxFixedArity = 5;
    G__5616.cljs$lang$applyTo = function(arglist__5617) {
      var f = cljs.core.first(arglist__5617);
      var a = cljs.core.first(cljs.core.next(arglist__5617));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5617)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5617))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5617)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5617)))));
      return G__5616__delegate(f, a, b, c, d, args)
    };
    G__5616.cljs$lang$arity$variadic = G__5616__delegate;
    return G__5616
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5618) {
    var obj = cljs.core.first(arglist__5618);
    var f = cljs.core.first(cljs.core.next(arglist__5618));
    var args = cljs.core.rest(cljs.core.next(arglist__5618));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5619__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5619 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5619__delegate.call(this, x, y, more)
    };
    G__5619.cljs$lang$maxFixedArity = 2;
    G__5619.cljs$lang$applyTo = function(arglist__5620) {
      var x = cljs.core.first(arglist__5620);
      var y = cljs.core.first(cljs.core.next(arglist__5620));
      var more = cljs.core.rest(cljs.core.next(arglist__5620));
      return G__5619__delegate(x, y, more)
    };
    G__5619.cljs$lang$arity$variadic = G__5619__delegate;
    return G__5619
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5621 = pred;
        var G__5622 = cljs.core.next.call(null, coll);
        pred = G__5621;
        coll = G__5622;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5623 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5623)) {
        return or__3548__auto____5623
      }else {
        var G__5624 = pred;
        var G__5625 = cljs.core.next.call(null, coll);
        pred = G__5624;
        coll = G__5625;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5626 = null;
    var G__5626__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5626__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5626__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5626__3 = function() {
      var G__5627__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5627 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5627__delegate.call(this, x, y, zs)
      };
      G__5627.cljs$lang$maxFixedArity = 2;
      G__5627.cljs$lang$applyTo = function(arglist__5628) {
        var x = cljs.core.first(arglist__5628);
        var y = cljs.core.first(cljs.core.next(arglist__5628));
        var zs = cljs.core.rest(cljs.core.next(arglist__5628));
        return G__5627__delegate(x, y, zs)
      };
      G__5627.cljs$lang$arity$variadic = G__5627__delegate;
      return G__5627
    }();
    G__5626 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5626__0.call(this);
        case 1:
          return G__5626__1.call(this, x);
        case 2:
          return G__5626__2.call(this, x, y);
        default:
          return G__5626__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5626.cljs$lang$maxFixedArity = 2;
    G__5626.cljs$lang$applyTo = G__5626__3.cljs$lang$applyTo;
    return G__5626
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5629__delegate = function(args) {
      return x
    };
    var G__5629 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5629__delegate.call(this, args)
    };
    G__5629.cljs$lang$maxFixedArity = 0;
    G__5629.cljs$lang$applyTo = function(arglist__5630) {
      var args = cljs.core.seq(arglist__5630);
      return G__5629__delegate(args)
    };
    G__5629.cljs$lang$arity$variadic = G__5629__delegate;
    return G__5629
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5634 = null;
      var G__5634__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5634__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5634__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5634__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5634__4 = function() {
        var G__5635__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5635 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5635__delegate.call(this, x, y, z, args)
        };
        G__5635.cljs$lang$maxFixedArity = 3;
        G__5635.cljs$lang$applyTo = function(arglist__5636) {
          var x = cljs.core.first(arglist__5636);
          var y = cljs.core.first(cljs.core.next(arglist__5636));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5636)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5636)));
          return G__5635__delegate(x, y, z, args)
        };
        G__5635.cljs$lang$arity$variadic = G__5635__delegate;
        return G__5635
      }();
      G__5634 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5634__0.call(this);
          case 1:
            return G__5634__1.call(this, x);
          case 2:
            return G__5634__2.call(this, x, y);
          case 3:
            return G__5634__3.call(this, x, y, z);
          default:
            return G__5634__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5634.cljs$lang$maxFixedArity = 3;
      G__5634.cljs$lang$applyTo = G__5634__4.cljs$lang$applyTo;
      return G__5634
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5637 = null;
      var G__5637__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5637__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5637__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5637__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5637__4 = function() {
        var G__5638__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5638 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5638__delegate.call(this, x, y, z, args)
        };
        G__5638.cljs$lang$maxFixedArity = 3;
        G__5638.cljs$lang$applyTo = function(arglist__5639) {
          var x = cljs.core.first(arglist__5639);
          var y = cljs.core.first(cljs.core.next(arglist__5639));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5639)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5639)));
          return G__5638__delegate(x, y, z, args)
        };
        G__5638.cljs$lang$arity$variadic = G__5638__delegate;
        return G__5638
      }();
      G__5637 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5637__0.call(this);
          case 1:
            return G__5637__1.call(this, x);
          case 2:
            return G__5637__2.call(this, x, y);
          case 3:
            return G__5637__3.call(this, x, y, z);
          default:
            return G__5637__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5637.cljs$lang$maxFixedArity = 3;
      G__5637.cljs$lang$applyTo = G__5637__4.cljs$lang$applyTo;
      return G__5637
    }()
  };
  var comp__4 = function() {
    var G__5640__delegate = function(f1, f2, f3, fs) {
      var fs__5631 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5641__delegate = function(args) {
          var ret__5632 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5631), args);
          var fs__5633 = cljs.core.next.call(null, fs__5631);
          while(true) {
            if(cljs.core.truth_(fs__5633)) {
              var G__5642 = cljs.core.first.call(null, fs__5633).call(null, ret__5632);
              var G__5643 = cljs.core.next.call(null, fs__5633);
              ret__5632 = G__5642;
              fs__5633 = G__5643;
              continue
            }else {
              return ret__5632
            }
            break
          }
        };
        var G__5641 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5641__delegate.call(this, args)
        };
        G__5641.cljs$lang$maxFixedArity = 0;
        G__5641.cljs$lang$applyTo = function(arglist__5644) {
          var args = cljs.core.seq(arglist__5644);
          return G__5641__delegate(args)
        };
        G__5641.cljs$lang$arity$variadic = G__5641__delegate;
        return G__5641
      }()
    };
    var G__5640 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5640__delegate.call(this, f1, f2, f3, fs)
    };
    G__5640.cljs$lang$maxFixedArity = 3;
    G__5640.cljs$lang$applyTo = function(arglist__5645) {
      var f1 = cljs.core.first(arglist__5645);
      var f2 = cljs.core.first(cljs.core.next(arglist__5645));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5645)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5645)));
      return G__5640__delegate(f1, f2, f3, fs)
    };
    G__5640.cljs$lang$arity$variadic = G__5640__delegate;
    return G__5640
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5646__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5646 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5646__delegate.call(this, args)
      };
      G__5646.cljs$lang$maxFixedArity = 0;
      G__5646.cljs$lang$applyTo = function(arglist__5647) {
        var args = cljs.core.seq(arglist__5647);
        return G__5646__delegate(args)
      };
      G__5646.cljs$lang$arity$variadic = G__5646__delegate;
      return G__5646
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5648__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5648 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5648__delegate.call(this, args)
      };
      G__5648.cljs$lang$maxFixedArity = 0;
      G__5648.cljs$lang$applyTo = function(arglist__5649) {
        var args = cljs.core.seq(arglist__5649);
        return G__5648__delegate(args)
      };
      G__5648.cljs$lang$arity$variadic = G__5648__delegate;
      return G__5648
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5650__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5650 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5650__delegate.call(this, args)
      };
      G__5650.cljs$lang$maxFixedArity = 0;
      G__5650.cljs$lang$applyTo = function(arglist__5651) {
        var args = cljs.core.seq(arglist__5651);
        return G__5650__delegate(args)
      };
      G__5650.cljs$lang$arity$variadic = G__5650__delegate;
      return G__5650
    }()
  };
  var partial__5 = function() {
    var G__5652__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5653__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5653 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5653__delegate.call(this, args)
        };
        G__5653.cljs$lang$maxFixedArity = 0;
        G__5653.cljs$lang$applyTo = function(arglist__5654) {
          var args = cljs.core.seq(arglist__5654);
          return G__5653__delegate(args)
        };
        G__5653.cljs$lang$arity$variadic = G__5653__delegate;
        return G__5653
      }()
    };
    var G__5652 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5652__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5652.cljs$lang$maxFixedArity = 4;
    G__5652.cljs$lang$applyTo = function(arglist__5655) {
      var f = cljs.core.first(arglist__5655);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5655));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5655)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5655))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5655))));
      return G__5652__delegate(f, arg1, arg2, arg3, more)
    };
    G__5652.cljs$lang$arity$variadic = G__5652__delegate;
    return G__5652
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5656 = null;
      var G__5656__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5656__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5656__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5656__4 = function() {
        var G__5657__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5657 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5657__delegate.call(this, a, b, c, ds)
        };
        G__5657.cljs$lang$maxFixedArity = 3;
        G__5657.cljs$lang$applyTo = function(arglist__5658) {
          var a = cljs.core.first(arglist__5658);
          var b = cljs.core.first(cljs.core.next(arglist__5658));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5658)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5658)));
          return G__5657__delegate(a, b, c, ds)
        };
        G__5657.cljs$lang$arity$variadic = G__5657__delegate;
        return G__5657
      }();
      G__5656 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5656__1.call(this, a);
          case 2:
            return G__5656__2.call(this, a, b);
          case 3:
            return G__5656__3.call(this, a, b, c);
          default:
            return G__5656__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5656.cljs$lang$maxFixedArity = 3;
      G__5656.cljs$lang$applyTo = G__5656__4.cljs$lang$applyTo;
      return G__5656
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5659 = null;
      var G__5659__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5659__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5659__4 = function() {
        var G__5660__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5660 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5660__delegate.call(this, a, b, c, ds)
        };
        G__5660.cljs$lang$maxFixedArity = 3;
        G__5660.cljs$lang$applyTo = function(arglist__5661) {
          var a = cljs.core.first(arglist__5661);
          var b = cljs.core.first(cljs.core.next(arglist__5661));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5661)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5661)));
          return G__5660__delegate(a, b, c, ds)
        };
        G__5660.cljs$lang$arity$variadic = G__5660__delegate;
        return G__5660
      }();
      G__5659 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5659__2.call(this, a, b);
          case 3:
            return G__5659__3.call(this, a, b, c);
          default:
            return G__5659__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5659.cljs$lang$maxFixedArity = 3;
      G__5659.cljs$lang$applyTo = G__5659__4.cljs$lang$applyTo;
      return G__5659
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5662 = null;
      var G__5662__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5662__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5662__4 = function() {
        var G__5663__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5663 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5663__delegate.call(this, a, b, c, ds)
        };
        G__5663.cljs$lang$maxFixedArity = 3;
        G__5663.cljs$lang$applyTo = function(arglist__5664) {
          var a = cljs.core.first(arglist__5664);
          var b = cljs.core.first(cljs.core.next(arglist__5664));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5664)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5664)));
          return G__5663__delegate(a, b, c, ds)
        };
        G__5663.cljs$lang$arity$variadic = G__5663__delegate;
        return G__5663
      }();
      G__5662 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5662__2.call(this, a, b);
          case 3:
            return G__5662__3.call(this, a, b, c);
          default:
            return G__5662__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5662.cljs$lang$maxFixedArity = 3;
      G__5662.cljs$lang$applyTo = G__5662__4.cljs$lang$applyTo;
      return G__5662
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5667 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5665 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5665)) {
        var s__5666 = temp__3698__auto____5665;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5666)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5666)))
      }else {
        return null
      }
    })
  };
  return mapi__5667.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5668 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5668)) {
      var s__5669 = temp__3698__auto____5668;
      var x__5670 = f.call(null, cljs.core.first.call(null, s__5669));
      if(x__5670 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5669))
      }else {
        return cljs.core.cons.call(null, x__5670, keep.call(null, f, cljs.core.rest.call(null, s__5669)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5680 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5677 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5677)) {
        var s__5678 = temp__3698__auto____5677;
        var x__5679 = f.call(null, idx, cljs.core.first.call(null, s__5678));
        if(x__5679 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5678))
        }else {
          return cljs.core.cons.call(null, x__5679, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5678)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5680.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5687 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5687)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5687
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5688 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5688)) {
            var and__3546__auto____5689 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5689)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5689
            }
          }else {
            return and__3546__auto____5688
          }
        }())
      };
      var ep1__4 = function() {
        var G__5725__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5690 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5690)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5690
            }
          }())
        };
        var G__5725 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5725__delegate.call(this, x, y, z, args)
        };
        G__5725.cljs$lang$maxFixedArity = 3;
        G__5725.cljs$lang$applyTo = function(arglist__5726) {
          var x = cljs.core.first(arglist__5726);
          var y = cljs.core.first(cljs.core.next(arglist__5726));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5726)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5726)));
          return G__5725__delegate(x, y, z, args)
        };
        G__5725.cljs$lang$arity$variadic = G__5725__delegate;
        return G__5725
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5691 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5691)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5691
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5692 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5692)) {
            var and__3546__auto____5693 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5693)) {
              var and__3546__auto____5694 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5694)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5694
              }
            }else {
              return and__3546__auto____5693
            }
          }else {
            return and__3546__auto____5692
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5695 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5695)) {
            var and__3546__auto____5696 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5696)) {
              var and__3546__auto____5697 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5697)) {
                var and__3546__auto____5698 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5698)) {
                  var and__3546__auto____5699 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5699)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5699
                  }
                }else {
                  return and__3546__auto____5698
                }
              }else {
                return and__3546__auto____5697
              }
            }else {
              return and__3546__auto____5696
            }
          }else {
            return and__3546__auto____5695
          }
        }())
      };
      var ep2__4 = function() {
        var G__5727__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5700 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5700)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5671_SHARP_) {
                var and__3546__auto____5701 = p1.call(null, p1__5671_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5701)) {
                  return p2.call(null, p1__5671_SHARP_)
                }else {
                  return and__3546__auto____5701
                }
              }, args)
            }else {
              return and__3546__auto____5700
            }
          }())
        };
        var G__5727 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5727__delegate.call(this, x, y, z, args)
        };
        G__5727.cljs$lang$maxFixedArity = 3;
        G__5727.cljs$lang$applyTo = function(arglist__5728) {
          var x = cljs.core.first(arglist__5728);
          var y = cljs.core.first(cljs.core.next(arglist__5728));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5728)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5728)));
          return G__5727__delegate(x, y, z, args)
        };
        G__5727.cljs$lang$arity$variadic = G__5727__delegate;
        return G__5727
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5702 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5702)) {
            var and__3546__auto____5703 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5703)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5703
            }
          }else {
            return and__3546__auto____5702
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5704 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5704)) {
            var and__3546__auto____5705 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5705)) {
              var and__3546__auto____5706 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5706)) {
                var and__3546__auto____5707 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5707)) {
                  var and__3546__auto____5708 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5708)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5708
                  }
                }else {
                  return and__3546__auto____5707
                }
              }else {
                return and__3546__auto____5706
              }
            }else {
              return and__3546__auto____5705
            }
          }else {
            return and__3546__auto____5704
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5709 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5709)) {
            var and__3546__auto____5710 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5710)) {
              var and__3546__auto____5711 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5711)) {
                var and__3546__auto____5712 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5712)) {
                  var and__3546__auto____5713 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5713)) {
                    var and__3546__auto____5714 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5714)) {
                      var and__3546__auto____5715 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5715)) {
                        var and__3546__auto____5716 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5716)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5716
                        }
                      }else {
                        return and__3546__auto____5715
                      }
                    }else {
                      return and__3546__auto____5714
                    }
                  }else {
                    return and__3546__auto____5713
                  }
                }else {
                  return and__3546__auto____5712
                }
              }else {
                return and__3546__auto____5711
              }
            }else {
              return and__3546__auto____5710
            }
          }else {
            return and__3546__auto____5709
          }
        }())
      };
      var ep3__4 = function() {
        var G__5729__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5717 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5717)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5672_SHARP_) {
                var and__3546__auto____5718 = p1.call(null, p1__5672_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5718)) {
                  var and__3546__auto____5719 = p2.call(null, p1__5672_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5719)) {
                    return p3.call(null, p1__5672_SHARP_)
                  }else {
                    return and__3546__auto____5719
                  }
                }else {
                  return and__3546__auto____5718
                }
              }, args)
            }else {
              return and__3546__auto____5717
            }
          }())
        };
        var G__5729 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5729__delegate.call(this, x, y, z, args)
        };
        G__5729.cljs$lang$maxFixedArity = 3;
        G__5729.cljs$lang$applyTo = function(arglist__5730) {
          var x = cljs.core.first(arglist__5730);
          var y = cljs.core.first(cljs.core.next(arglist__5730));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5730)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5730)));
          return G__5729__delegate(x, y, z, args)
        };
        G__5729.cljs$lang$arity$variadic = G__5729__delegate;
        return G__5729
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5731__delegate = function(p1, p2, p3, ps) {
      var ps__5720 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5673_SHARP_) {
            return p1__5673_SHARP_.call(null, x)
          }, ps__5720)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5674_SHARP_) {
            var and__3546__auto____5721 = p1__5674_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5721)) {
              return p1__5674_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5721
            }
          }, ps__5720)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5675_SHARP_) {
            var and__3546__auto____5722 = p1__5675_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5722)) {
              var and__3546__auto____5723 = p1__5675_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5723)) {
                return p1__5675_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5723
              }
            }else {
              return and__3546__auto____5722
            }
          }, ps__5720)
        };
        var epn__4 = function() {
          var G__5732__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5724 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5724)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5676_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5676_SHARP_, args)
                }, ps__5720)
              }else {
                return and__3546__auto____5724
              }
            }())
          };
          var G__5732 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5732__delegate.call(this, x, y, z, args)
          };
          G__5732.cljs$lang$maxFixedArity = 3;
          G__5732.cljs$lang$applyTo = function(arglist__5733) {
            var x = cljs.core.first(arglist__5733);
            var y = cljs.core.first(cljs.core.next(arglist__5733));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5733)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5733)));
            return G__5732__delegate(x, y, z, args)
          };
          G__5732.cljs$lang$arity$variadic = G__5732__delegate;
          return G__5732
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5731 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5731__delegate.call(this, p1, p2, p3, ps)
    };
    G__5731.cljs$lang$maxFixedArity = 3;
    G__5731.cljs$lang$applyTo = function(arglist__5734) {
      var p1 = cljs.core.first(arglist__5734);
      var p2 = cljs.core.first(cljs.core.next(arglist__5734));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5734)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5734)));
      return G__5731__delegate(p1, p2, p3, ps)
    };
    G__5731.cljs$lang$arity$variadic = G__5731__delegate;
    return G__5731
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5736 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5736)) {
          return or__3548__auto____5736
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5737 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5737)) {
          return or__3548__auto____5737
        }else {
          var or__3548__auto____5738 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5738)) {
            return or__3548__auto____5738
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5774__delegate = function(x, y, z, args) {
          var or__3548__auto____5739 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5739)) {
            return or__3548__auto____5739
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5774 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5774__delegate.call(this, x, y, z, args)
        };
        G__5774.cljs$lang$maxFixedArity = 3;
        G__5774.cljs$lang$applyTo = function(arglist__5775) {
          var x = cljs.core.first(arglist__5775);
          var y = cljs.core.first(cljs.core.next(arglist__5775));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5775)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5775)));
          return G__5774__delegate(x, y, z, args)
        };
        G__5774.cljs$lang$arity$variadic = G__5774__delegate;
        return G__5774
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5740 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5740)) {
          return or__3548__auto____5740
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5741 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5741)) {
          return or__3548__auto____5741
        }else {
          var or__3548__auto____5742 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5742)) {
            return or__3548__auto____5742
          }else {
            var or__3548__auto____5743 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5743)) {
              return or__3548__auto____5743
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5744 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5744)) {
          return or__3548__auto____5744
        }else {
          var or__3548__auto____5745 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5745)) {
            return or__3548__auto____5745
          }else {
            var or__3548__auto____5746 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5746)) {
              return or__3548__auto____5746
            }else {
              var or__3548__auto____5747 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5747)) {
                return or__3548__auto____5747
              }else {
                var or__3548__auto____5748 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5748)) {
                  return or__3548__auto____5748
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5776__delegate = function(x, y, z, args) {
          var or__3548__auto____5749 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5749)) {
            return or__3548__auto____5749
          }else {
            return cljs.core.some.call(null, function(p1__5681_SHARP_) {
              var or__3548__auto____5750 = p1.call(null, p1__5681_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5750)) {
                return or__3548__auto____5750
              }else {
                return p2.call(null, p1__5681_SHARP_)
              }
            }, args)
          }
        };
        var G__5776 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5776__delegate.call(this, x, y, z, args)
        };
        G__5776.cljs$lang$maxFixedArity = 3;
        G__5776.cljs$lang$applyTo = function(arglist__5777) {
          var x = cljs.core.first(arglist__5777);
          var y = cljs.core.first(cljs.core.next(arglist__5777));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5777)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5777)));
          return G__5776__delegate(x, y, z, args)
        };
        G__5776.cljs$lang$arity$variadic = G__5776__delegate;
        return G__5776
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5751 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5751)) {
          return or__3548__auto____5751
        }else {
          var or__3548__auto____5752 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5752)) {
            return or__3548__auto____5752
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5753 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5753)) {
          return or__3548__auto____5753
        }else {
          var or__3548__auto____5754 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5754)) {
            return or__3548__auto____5754
          }else {
            var or__3548__auto____5755 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5755)) {
              return or__3548__auto____5755
            }else {
              var or__3548__auto____5756 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5756)) {
                return or__3548__auto____5756
              }else {
                var or__3548__auto____5757 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5757)) {
                  return or__3548__auto____5757
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5758 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5758)) {
          return or__3548__auto____5758
        }else {
          var or__3548__auto____5759 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5759)) {
            return or__3548__auto____5759
          }else {
            var or__3548__auto____5760 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5760)) {
              return or__3548__auto____5760
            }else {
              var or__3548__auto____5761 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5761)) {
                return or__3548__auto____5761
              }else {
                var or__3548__auto____5762 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5762)) {
                  return or__3548__auto____5762
                }else {
                  var or__3548__auto____5763 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5763)) {
                    return or__3548__auto____5763
                  }else {
                    var or__3548__auto____5764 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5764)) {
                      return or__3548__auto____5764
                    }else {
                      var or__3548__auto____5765 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5765)) {
                        return or__3548__auto____5765
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5778__delegate = function(x, y, z, args) {
          var or__3548__auto____5766 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5766)) {
            return or__3548__auto____5766
          }else {
            return cljs.core.some.call(null, function(p1__5682_SHARP_) {
              var or__3548__auto____5767 = p1.call(null, p1__5682_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5767)) {
                return or__3548__auto____5767
              }else {
                var or__3548__auto____5768 = p2.call(null, p1__5682_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5768)) {
                  return or__3548__auto____5768
                }else {
                  return p3.call(null, p1__5682_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5778 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5778__delegate.call(this, x, y, z, args)
        };
        G__5778.cljs$lang$maxFixedArity = 3;
        G__5778.cljs$lang$applyTo = function(arglist__5779) {
          var x = cljs.core.first(arglist__5779);
          var y = cljs.core.first(cljs.core.next(arglist__5779));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5779)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5779)));
          return G__5778__delegate(x, y, z, args)
        };
        G__5778.cljs$lang$arity$variadic = G__5778__delegate;
        return G__5778
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5780__delegate = function(p1, p2, p3, ps) {
      var ps__5769 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5683_SHARP_) {
            return p1__5683_SHARP_.call(null, x)
          }, ps__5769)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5684_SHARP_) {
            var or__3548__auto____5770 = p1__5684_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5770)) {
              return or__3548__auto____5770
            }else {
              return p1__5684_SHARP_.call(null, y)
            }
          }, ps__5769)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5685_SHARP_) {
            var or__3548__auto____5771 = p1__5685_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5771)) {
              return or__3548__auto____5771
            }else {
              var or__3548__auto____5772 = p1__5685_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5772)) {
                return or__3548__auto____5772
              }else {
                return p1__5685_SHARP_.call(null, z)
              }
            }
          }, ps__5769)
        };
        var spn__4 = function() {
          var G__5781__delegate = function(x, y, z, args) {
            var or__3548__auto____5773 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5773)) {
              return or__3548__auto____5773
            }else {
              return cljs.core.some.call(null, function(p1__5686_SHARP_) {
                return cljs.core.some.call(null, p1__5686_SHARP_, args)
              }, ps__5769)
            }
          };
          var G__5781 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5781__delegate.call(this, x, y, z, args)
          };
          G__5781.cljs$lang$maxFixedArity = 3;
          G__5781.cljs$lang$applyTo = function(arglist__5782) {
            var x = cljs.core.first(arglist__5782);
            var y = cljs.core.first(cljs.core.next(arglist__5782));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5782)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5782)));
            return G__5781__delegate(x, y, z, args)
          };
          G__5781.cljs$lang$arity$variadic = G__5781__delegate;
          return G__5781
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5780 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5780__delegate.call(this, p1, p2, p3, ps)
    };
    G__5780.cljs$lang$maxFixedArity = 3;
    G__5780.cljs$lang$applyTo = function(arglist__5783) {
      var p1 = cljs.core.first(arglist__5783);
      var p2 = cljs.core.first(cljs.core.next(arglist__5783));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5783)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5783)));
      return G__5780__delegate(p1, p2, p3, ps)
    };
    G__5780.cljs$lang$arity$variadic = G__5780__delegate;
    return G__5780
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5784 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5784)) {
        var s__5785 = temp__3698__auto____5784;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5785)), map.call(null, f, cljs.core.rest.call(null, s__5785)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5786 = cljs.core.seq.call(null, c1);
      var s2__5787 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5788 = s1__5786;
        if(cljs.core.truth_(and__3546__auto____5788)) {
          return s2__5787
        }else {
          return and__3546__auto____5788
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5786), cljs.core.first.call(null, s2__5787)), map.call(null, f, cljs.core.rest.call(null, s1__5786), cljs.core.rest.call(null, s2__5787)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5789 = cljs.core.seq.call(null, c1);
      var s2__5790 = cljs.core.seq.call(null, c2);
      var s3__5791 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5792 = s1__5789;
        if(cljs.core.truth_(and__3546__auto____5792)) {
          var and__3546__auto____5793 = s2__5790;
          if(cljs.core.truth_(and__3546__auto____5793)) {
            return s3__5791
          }else {
            return and__3546__auto____5793
          }
        }else {
          return and__3546__auto____5792
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5789), cljs.core.first.call(null, s2__5790), cljs.core.first.call(null, s3__5791)), map.call(null, f, cljs.core.rest.call(null, s1__5789), cljs.core.rest.call(null, s2__5790), cljs.core.rest.call(null, s3__5791)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5796__delegate = function(f, c1, c2, c3, colls) {
      var step__5795 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5794 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5794)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5794), step.call(null, map.call(null, cljs.core.rest, ss__5794)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5735_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5735_SHARP_)
      }, step__5795.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5796 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5796__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5796.cljs$lang$maxFixedArity = 4;
    G__5796.cljs$lang$applyTo = function(arglist__5797) {
      var f = cljs.core.first(arglist__5797);
      var c1 = cljs.core.first(cljs.core.next(arglist__5797));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5797)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5797))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5797))));
      return G__5796__delegate(f, c1, c2, c3, colls)
    };
    G__5796.cljs$lang$arity$variadic = G__5796__delegate;
    return G__5796
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5798 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5798)) {
        var s__5799 = temp__3698__auto____5798;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5799), take.call(null, n - 1, cljs.core.rest.call(null, s__5799)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5802 = function(n, coll) {
    while(true) {
      var s__5800 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5801 = n > 0;
        if(and__3546__auto____5801) {
          return s__5800
        }else {
          return and__3546__auto____5801
        }
      }())) {
        var G__5803 = n - 1;
        var G__5804 = cljs.core.rest.call(null, s__5800);
        n = G__5803;
        coll = G__5804;
        continue
      }else {
        return s__5800
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5802.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5805 = cljs.core.seq.call(null, coll);
  var lead__5806 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5806)) {
      var G__5807 = cljs.core.next.call(null, s__5805);
      var G__5808 = cljs.core.next.call(null, lead__5806);
      s__5805 = G__5807;
      lead__5806 = G__5808;
      continue
    }else {
      return s__5805
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5811 = function(pred, coll) {
    while(true) {
      var s__5809 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5810 = s__5809;
        if(cljs.core.truth_(and__3546__auto____5810)) {
          return pred.call(null, cljs.core.first.call(null, s__5809))
        }else {
          return and__3546__auto____5810
        }
      }())) {
        var G__5812 = pred;
        var G__5813 = cljs.core.rest.call(null, s__5809);
        pred = G__5812;
        coll = G__5813;
        continue
      }else {
        return s__5809
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5811.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5814 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5814)) {
      var s__5815 = temp__3698__auto____5814;
      return cljs.core.concat.call(null, s__5815, cycle.call(null, s__5815))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5816 = cljs.core.seq.call(null, c1);
      var s2__5817 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5818 = s1__5816;
        if(cljs.core.truth_(and__3546__auto____5818)) {
          return s2__5817
        }else {
          return and__3546__auto____5818
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5816), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5817), interleave.call(null, cljs.core.rest.call(null, s1__5816), cljs.core.rest.call(null, s2__5817))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5820__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5819 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5819)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5819), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5819)))
        }else {
          return null
        }
      })
    };
    var G__5820 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5820__delegate.call(this, c1, c2, colls)
    };
    G__5820.cljs$lang$maxFixedArity = 2;
    G__5820.cljs$lang$applyTo = function(arglist__5821) {
      var c1 = cljs.core.first(arglist__5821);
      var c2 = cljs.core.first(cljs.core.next(arglist__5821));
      var colls = cljs.core.rest(cljs.core.next(arglist__5821));
      return G__5820__delegate(c1, c2, colls)
    };
    G__5820.cljs$lang$arity$variadic = G__5820__delegate;
    return G__5820
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5824 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5822 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5822)) {
        var coll__5823 = temp__3695__auto____5822;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5823), cat.call(null, cljs.core.rest.call(null, coll__5823), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5824.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5825__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5825 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5825__delegate.call(this, f, coll, colls)
    };
    G__5825.cljs$lang$maxFixedArity = 2;
    G__5825.cljs$lang$applyTo = function(arglist__5826) {
      var f = cljs.core.first(arglist__5826);
      var coll = cljs.core.first(cljs.core.next(arglist__5826));
      var colls = cljs.core.rest(cljs.core.next(arglist__5826));
      return G__5825__delegate(f, coll, colls)
    };
    G__5825.cljs$lang$arity$variadic = G__5825__delegate;
    return G__5825
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5827 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5827)) {
      var s__5828 = temp__3698__auto____5827;
      var f__5829 = cljs.core.first.call(null, s__5828);
      var r__5830 = cljs.core.rest.call(null, s__5828);
      if(cljs.core.truth_(pred.call(null, f__5829))) {
        return cljs.core.cons.call(null, f__5829, filter.call(null, pred, r__5830))
      }else {
        return filter.call(null, pred, r__5830)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5832 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5832.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5831_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5831_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5833__5834 = to;
    if(G__5833__5834 != null) {
      if(function() {
        var or__3548__auto____5835 = G__5833__5834.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5835) {
          return or__3548__auto____5835
        }else {
          return G__5833__5834.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5833__5834.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5833__5834)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5833__5834)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5836__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5836 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5836__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5836.cljs$lang$maxFixedArity = 4;
    G__5836.cljs$lang$applyTo = function(arglist__5837) {
      var f = cljs.core.first(arglist__5837);
      var c1 = cljs.core.first(cljs.core.next(arglist__5837));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5837)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5837))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5837))));
      return G__5836__delegate(f, c1, c2, c3, colls)
    };
    G__5836.cljs$lang$arity$variadic = G__5836__delegate;
    return G__5836
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5838 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5838)) {
        var s__5839 = temp__3698__auto____5838;
        var p__5840 = cljs.core.take.call(null, n, s__5839);
        if(n === cljs.core.count.call(null, p__5840)) {
          return cljs.core.cons.call(null, p__5840, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5839)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5841 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5841)) {
        var s__5842 = temp__3698__auto____5841;
        var p__5843 = cljs.core.take.call(null, n, s__5842);
        if(n === cljs.core.count.call(null, p__5843)) {
          return cljs.core.cons.call(null, p__5843, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5842)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5843, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5844 = cljs.core.lookup_sentinel;
    var m__5845 = m;
    var ks__5846 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5846)) {
        var m__5847 = cljs.core.get.call(null, m__5845, cljs.core.first.call(null, ks__5846), sentinel__5844);
        if(sentinel__5844 === m__5847) {
          return not_found
        }else {
          var G__5848 = sentinel__5844;
          var G__5849 = m__5847;
          var G__5850 = cljs.core.next.call(null, ks__5846);
          sentinel__5844 = G__5848;
          m__5845 = G__5849;
          ks__5846 = G__5850;
          continue
        }
      }else {
        return m__5845
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5851, v) {
  var vec__5852__5853 = p__5851;
  var k__5854 = cljs.core.nth.call(null, vec__5852__5853, 0, null);
  var ks__5855 = cljs.core.nthnext.call(null, vec__5852__5853, 1);
  if(cljs.core.truth_(ks__5855)) {
    return cljs.core.assoc.call(null, m, k__5854, assoc_in.call(null, cljs.core.get.call(null, m, k__5854), ks__5855, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5854, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5856, f, args) {
    var vec__5857__5858 = p__5856;
    var k__5859 = cljs.core.nth.call(null, vec__5857__5858, 0, null);
    var ks__5860 = cljs.core.nthnext.call(null, vec__5857__5858, 1);
    if(cljs.core.truth_(ks__5860)) {
      return cljs.core.assoc.call(null, m, k__5859, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5859), ks__5860, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5859, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5859), args))
    }
  };
  var update_in = function(m, p__5856, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5856, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5861) {
    var m = cljs.core.first(arglist__5861);
    var p__5856 = cljs.core.first(cljs.core.next(arglist__5861));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5861)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5861)));
    return update_in__delegate(m, p__5856, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5866 = this;
  var h__364__auto____5867 = this__5866.__hash;
  if(h__364__auto____5867 != null) {
    return h__364__auto____5867
  }else {
    var h__364__auto____5868 = cljs.core.hash_coll.call(null, coll);
    this__5866.__hash = h__364__auto____5868;
    return h__364__auto____5868
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5869 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5870 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5871 = this;
  var new_array__5872 = cljs.core.aclone.call(null, this__5871.array);
  new_array__5872[k] = v;
  return new cljs.core.Vector(this__5871.meta, new_array__5872, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5901 = null;
  var G__5901__2 = function(tsym5864, k) {
    var this__5873 = this;
    var tsym5864__5874 = this;
    var coll__5875 = tsym5864__5874;
    return cljs.core._lookup.call(null, coll__5875, k)
  };
  var G__5901__3 = function(tsym5865, k, not_found) {
    var this__5876 = this;
    var tsym5865__5877 = this;
    var coll__5878 = tsym5865__5877;
    return cljs.core._lookup.call(null, coll__5878, k, not_found)
  };
  G__5901 = function(tsym5865, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5901__2.call(this, tsym5865, k);
      case 3:
        return G__5901__3.call(this, tsym5865, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5901
}();
cljs.core.Vector.prototype.apply = function(tsym5862, args5863) {
  return tsym5862.call.apply(tsym5862, [tsym5862].concat(cljs.core.aclone.call(null, args5863)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5879 = this;
  var new_array__5880 = cljs.core.aclone.call(null, this__5879.array);
  new_array__5880.push(o);
  return new cljs.core.Vector(this__5879.meta, new_array__5880, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5881 = this;
  var this$__5882 = this;
  return cljs.core.pr_str.call(null, this$__5882)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5883 = this;
  return cljs.core.ci_reduce.call(null, this__5883.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5884 = this;
  return cljs.core.ci_reduce.call(null, this__5884.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5885 = this;
  if(this__5885.array.length > 0) {
    var vector_seq__5886 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5885.array.length) {
          return cljs.core.cons.call(null, this__5885.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5886.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5887 = this;
  return this__5887.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5888 = this;
  var count__5889 = this__5888.array.length;
  if(count__5889 > 0) {
    return this__5888.array[count__5889 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5890 = this;
  if(this__5890.array.length > 0) {
    var new_array__5891 = cljs.core.aclone.call(null, this__5890.array);
    new_array__5891.pop();
    return new cljs.core.Vector(this__5890.meta, new_array__5891, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5892 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5893 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5894 = this;
  return new cljs.core.Vector(meta, this__5894.array, this__5894.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5895 = this;
  return this__5895.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5897 = this;
  if(function() {
    var and__3546__auto____5898 = 0 <= n;
    if(and__3546__auto____5898) {
      return n < this__5897.array.length
    }else {
      return and__3546__auto____5898
    }
  }()) {
    return this__5897.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5899 = this;
  if(function() {
    var and__3546__auto____5900 = 0 <= n;
    if(and__3546__auto____5900) {
      return n < this__5899.array.length
    }else {
      return and__3546__auto____5900
    }
  }()) {
    return this__5899.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5896 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5896.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5902 = pv.cnt;
  if(cnt__5902 < 32) {
    return 0
  }else {
    return cnt__5902 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5903 = level;
  var ret__5904 = node;
  while(true) {
    if(ll__5903 === 0) {
      return ret__5904
    }else {
      var embed__5905 = ret__5904;
      var r__5906 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5907 = cljs.core.pv_aset.call(null, r__5906, 0, embed__5905);
      var G__5908 = ll__5903 - 5;
      var G__5909 = r__5906;
      ll__5903 = G__5908;
      ret__5904 = G__5909;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5910 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5911 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5910, subidx__5911, tailnode);
    return ret__5910
  }else {
    var temp__3695__auto____5912 = cljs.core.pv_aget.call(null, parent, subidx__5911);
    if(cljs.core.truth_(temp__3695__auto____5912)) {
      var child__5913 = temp__3695__auto____5912;
      var node_to_insert__5914 = push_tail.call(null, pv, level - 5, child__5913, tailnode);
      cljs.core.pv_aset.call(null, ret__5910, subidx__5911, node_to_insert__5914);
      return ret__5910
    }else {
      var node_to_insert__5915 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5910, subidx__5911, node_to_insert__5915);
      return ret__5910
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5916 = 0 <= i;
    if(and__3546__auto____5916) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5916
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5917 = pv.root;
      var level__5918 = pv.shift;
      while(true) {
        if(level__5918 > 0) {
          var G__5919 = cljs.core.pv_aget.call(null, node__5917, i >>> level__5918 & 31);
          var G__5920 = level__5918 - 5;
          node__5917 = G__5919;
          level__5918 = G__5920;
          continue
        }else {
          return node__5917.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5921 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5921, i & 31, val);
    return ret__5921
  }else {
    var subidx__5922 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5921, subidx__5922, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5922), i, val));
    return ret__5921
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5923 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5924 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5923));
    if(function() {
      var and__3546__auto____5925 = new_child__5924 == null;
      if(and__3546__auto____5925) {
        return subidx__5923 === 0
      }else {
        return and__3546__auto____5925
      }
    }()) {
      return null
    }else {
      var ret__5926 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5926, subidx__5923, new_child__5924);
      return ret__5926
    }
  }else {
    if(subidx__5923 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5927 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5927, subidx__5923, null);
        return ret__5927
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5928 = cljs.core._count.call(null, v);
  if(c__5928 > 0) {
    if(void 0 === cljs.core.t5929) {
      cljs.core.t5929 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5929.cljs$lang$type = true;
      cljs.core.t5929.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5929")
      };
      cljs.core.t5929.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5929.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5930 = this;
        return vseq
      };
      cljs.core.t5929.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5929.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5931 = this;
        return cljs.core._nth.call(null, this__5931.v, this__5931.offset)
      };
      cljs.core.t5929.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5932 = this;
        var offset__5933 = this__5932.offset + 1;
        if(offset__5933 < this__5932.c) {
          return this__5932.vector_seq.call(null, this__5932.v, offset__5933)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5929.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5929.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5929.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5934 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5929.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5929.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5929.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5935 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5929.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5929.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5936 = this;
        return this__5936.__meta__389__auto__
      };
      cljs.core.t5929.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5937 = this;
        return new cljs.core.t5929(this__5937.c, this__5937.offset, this__5937.v, this__5937.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5929
    }else {
    }
    return new cljs.core.t5929(c__5928, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5942 = this;
  return new cljs.core.TransientVector(this__5942.cnt, this__5942.shift, cljs.core.tv_editable_root.call(null, this__5942.root), cljs.core.tv_editable_tail.call(null, this__5942.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5943 = this;
  var h__364__auto____5944 = this__5943.__hash;
  if(h__364__auto____5944 != null) {
    return h__364__auto____5944
  }else {
    var h__364__auto____5945 = cljs.core.hash_coll.call(null, coll);
    this__5943.__hash = h__364__auto____5945;
    return h__364__auto____5945
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5946 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5947 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5948 = this;
  if(function() {
    var and__3546__auto____5949 = 0 <= k;
    if(and__3546__auto____5949) {
      return k < this__5948.cnt
    }else {
      return and__3546__auto____5949
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5950 = cljs.core.aclone.call(null, this__5948.tail);
      new_tail__5950[k & 31] = v;
      return new cljs.core.PersistentVector(this__5948.meta, this__5948.cnt, this__5948.shift, this__5948.root, new_tail__5950, null)
    }else {
      return new cljs.core.PersistentVector(this__5948.meta, this__5948.cnt, this__5948.shift, cljs.core.do_assoc.call(null, coll, this__5948.shift, this__5948.root, k, v), this__5948.tail, null)
    }
  }else {
    if(k === this__5948.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5948.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5995 = null;
  var G__5995__2 = function(tsym5940, k) {
    var this__5951 = this;
    var tsym5940__5952 = this;
    var coll__5953 = tsym5940__5952;
    return cljs.core._lookup.call(null, coll__5953, k)
  };
  var G__5995__3 = function(tsym5941, k, not_found) {
    var this__5954 = this;
    var tsym5941__5955 = this;
    var coll__5956 = tsym5941__5955;
    return cljs.core._lookup.call(null, coll__5956, k, not_found)
  };
  G__5995 = function(tsym5941, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5995__2.call(this, tsym5941, k);
      case 3:
        return G__5995__3.call(this, tsym5941, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5995
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5938, args5939) {
  return tsym5938.call.apply(tsym5938, [tsym5938].concat(cljs.core.aclone.call(null, args5939)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5957 = this;
  var step_init__5958 = [0, init];
  var i__5959 = 0;
  while(true) {
    if(i__5959 < this__5957.cnt) {
      var arr__5960 = cljs.core.array_for.call(null, v, i__5959);
      var len__5961 = arr__5960.length;
      var init__5965 = function() {
        var j__5962 = 0;
        var init__5963 = step_init__5958[1];
        while(true) {
          if(j__5962 < len__5961) {
            var init__5964 = f.call(null, init__5963, j__5962 + i__5959, arr__5960[j__5962]);
            if(cljs.core.reduced_QMARK_.call(null, init__5964)) {
              return init__5964
            }else {
              var G__5996 = j__5962 + 1;
              var G__5997 = init__5964;
              j__5962 = G__5996;
              init__5963 = G__5997;
              continue
            }
          }else {
            step_init__5958[0] = len__5961;
            step_init__5958[1] = init__5963;
            return init__5963
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5965)) {
        return cljs.core.deref.call(null, init__5965)
      }else {
        var G__5998 = i__5959 + step_init__5958[0];
        i__5959 = G__5998;
        continue
      }
    }else {
      return step_init__5958[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5966 = this;
  if(this__5966.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5967 = cljs.core.aclone.call(null, this__5966.tail);
    new_tail__5967.push(o);
    return new cljs.core.PersistentVector(this__5966.meta, this__5966.cnt + 1, this__5966.shift, this__5966.root, new_tail__5967, null)
  }else {
    var root_overflow_QMARK___5968 = this__5966.cnt >>> 5 > 1 << this__5966.shift;
    var new_shift__5969 = root_overflow_QMARK___5968 ? this__5966.shift + 5 : this__5966.shift;
    var new_root__5971 = root_overflow_QMARK___5968 ? function() {
      var n_r__5970 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5970, 0, this__5966.root);
      cljs.core.pv_aset.call(null, n_r__5970, 1, cljs.core.new_path.call(null, null, this__5966.shift, new cljs.core.VectorNode(null, this__5966.tail)));
      return n_r__5970
    }() : cljs.core.push_tail.call(null, coll, this__5966.shift, this__5966.root, new cljs.core.VectorNode(null, this__5966.tail));
    return new cljs.core.PersistentVector(this__5966.meta, this__5966.cnt + 1, new_shift__5969, new_root__5971, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5972 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5973 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5974 = this;
  var this$__5975 = this;
  return cljs.core.pr_str.call(null, this$__5975)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5976 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5977 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5978 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5979 = this;
  return this__5979.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5980 = this;
  if(this__5980.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5980.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5981 = this;
  if(this__5981.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5981.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5981.meta)
    }else {
      if(1 < this__5981.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5981.meta, this__5981.cnt - 1, this__5981.shift, this__5981.root, this__5981.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5982 = cljs.core.array_for.call(null, coll, this__5981.cnt - 2);
          var nr__5983 = cljs.core.pop_tail.call(null, coll, this__5981.shift, this__5981.root);
          var new_root__5984 = nr__5983 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5983;
          var cnt_1__5985 = this__5981.cnt - 1;
          if(function() {
            var and__3546__auto____5986 = 5 < this__5981.shift;
            if(and__3546__auto____5986) {
              return cljs.core.pv_aget.call(null, new_root__5984, 1) == null
            }else {
              return and__3546__auto____5986
            }
          }()) {
            return new cljs.core.PersistentVector(this__5981.meta, cnt_1__5985, this__5981.shift - 5, cljs.core.pv_aget.call(null, new_root__5984, 0), new_tail__5982, null)
          }else {
            return new cljs.core.PersistentVector(this__5981.meta, cnt_1__5985, this__5981.shift, new_root__5984, new_tail__5982, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5988 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5989 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5990 = this;
  return new cljs.core.PersistentVector(meta, this__5990.cnt, this__5990.shift, this__5990.root, this__5990.tail, this__5990.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5991 = this;
  return this__5991.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5992 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5993 = this;
  if(function() {
    var and__3546__auto____5994 = 0 <= n;
    if(and__3546__auto____5994) {
      return n < this__5993.cnt
    }else {
      return and__3546__auto____5994
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5987 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5987.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5999 = cljs.core.seq.call(null, xs);
  var out__6000 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5999)) {
      var G__6001 = cljs.core.next.call(null, xs__5999);
      var G__6002 = cljs.core.conj_BANG_.call(null, out__6000, cljs.core.first.call(null, xs__5999));
      xs__5999 = G__6001;
      out__6000 = G__6002;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6000)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__6003) {
    var args = cljs.core.seq(arglist__6003);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6008 = this;
  var h__364__auto____6009 = this__6008.__hash;
  if(h__364__auto____6009 != null) {
    return h__364__auto____6009
  }else {
    var h__364__auto____6010 = cljs.core.hash_coll.call(null, coll);
    this__6008.__hash = h__364__auto____6010;
    return h__364__auto____6010
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6011 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6012 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__6013 = this;
  var v_pos__6014 = this__6013.start + key;
  return new cljs.core.Subvec(this__6013.meta, cljs.core._assoc.call(null, this__6013.v, v_pos__6014, val), this__6013.start, this__6013.end > v_pos__6014 + 1 ? this__6013.end : v_pos__6014 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__6038 = null;
  var G__6038__2 = function(tsym6006, k) {
    var this__6015 = this;
    var tsym6006__6016 = this;
    var coll__6017 = tsym6006__6016;
    return cljs.core._lookup.call(null, coll__6017, k)
  };
  var G__6038__3 = function(tsym6007, k, not_found) {
    var this__6018 = this;
    var tsym6007__6019 = this;
    var coll__6020 = tsym6007__6019;
    return cljs.core._lookup.call(null, coll__6020, k, not_found)
  };
  G__6038 = function(tsym6007, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6038__2.call(this, tsym6007, k);
      case 3:
        return G__6038__3.call(this, tsym6007, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6038
}();
cljs.core.Subvec.prototype.apply = function(tsym6004, args6005) {
  return tsym6004.call.apply(tsym6004, [tsym6004].concat(cljs.core.aclone.call(null, args6005)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6021 = this;
  return new cljs.core.Subvec(this__6021.meta, cljs.core._assoc_n.call(null, this__6021.v, this__6021.end, o), this__6021.start, this__6021.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__6022 = this;
  var this$__6023 = this;
  return cljs.core.pr_str.call(null, this$__6023)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__6024 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__6025 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6026 = this;
  var subvec_seq__6027 = function subvec_seq(i) {
    if(i === this__6026.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__6026.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__6027.call(null, this__6026.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6028 = this;
  return this__6028.end - this__6028.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6029 = this;
  return cljs.core._nth.call(null, this__6029.v, this__6029.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6030 = this;
  if(this__6030.start === this__6030.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__6030.meta, this__6030.v, this__6030.start, this__6030.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__6031 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6032 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6033 = this;
  return new cljs.core.Subvec(meta, this__6033.v, this__6033.start, this__6033.end, this__6033.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6034 = this;
  return this__6034.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6036 = this;
  return cljs.core._nth.call(null, this__6036.v, this__6036.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6037 = this;
  return cljs.core._nth.call(null, this__6037.v, this__6037.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6035 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__6035.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__6039 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__6039, 0, tl.length);
  return ret__6039
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__6040 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__6041 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__6040, subidx__6041, level === 5 ? tail_node : function() {
    var child__6042 = cljs.core.pv_aget.call(null, ret__6040, subidx__6041);
    if(child__6042 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__6042, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__6040
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__6043 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__6044 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__6045 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__6043, subidx__6044));
    if(function() {
      var and__3546__auto____6046 = new_child__6045 == null;
      if(and__3546__auto____6046) {
        return subidx__6044 === 0
      }else {
        return and__3546__auto____6046
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__6043, subidx__6044, new_child__6045);
      return node__6043
    }
  }else {
    if(subidx__6044 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__6043, subidx__6044, null);
        return node__6043
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____6047 = 0 <= i;
    if(and__3546__auto____6047) {
      return i < tv.cnt
    }else {
      return and__3546__auto____6047
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__6048 = tv.root;
      var node__6049 = root__6048;
      var level__6050 = tv.shift;
      while(true) {
        if(level__6050 > 0) {
          var G__6051 = cljs.core.tv_ensure_editable.call(null, root__6048.edit, cljs.core.pv_aget.call(null, node__6049, i >>> level__6050 & 31));
          var G__6052 = level__6050 - 5;
          node__6049 = G__6051;
          level__6050 = G__6052;
          continue
        }else {
          return node__6049.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__6090 = null;
  var G__6090__2 = function(tsym6055, k) {
    var this__6057 = this;
    var tsym6055__6058 = this;
    var coll__6059 = tsym6055__6058;
    return cljs.core._lookup.call(null, coll__6059, k)
  };
  var G__6090__3 = function(tsym6056, k, not_found) {
    var this__6060 = this;
    var tsym6056__6061 = this;
    var coll__6062 = tsym6056__6061;
    return cljs.core._lookup.call(null, coll__6062, k, not_found)
  };
  G__6090 = function(tsym6056, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6090__2.call(this, tsym6056, k);
      case 3:
        return G__6090__3.call(this, tsym6056, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6090
}();
cljs.core.TransientVector.prototype.apply = function(tsym6053, args6054) {
  return tsym6053.call.apply(tsym6053, [tsym6053].concat(cljs.core.aclone.call(null, args6054)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6063 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6064 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6065 = this;
  if(cljs.core.truth_(this__6065.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6066 = this;
  if(function() {
    var and__3546__auto____6067 = 0 <= n;
    if(and__3546__auto____6067) {
      return n < this__6066.cnt
    }else {
      return and__3546__auto____6067
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6068 = this;
  if(cljs.core.truth_(this__6068.root.edit)) {
    return this__6068.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__6069 = this;
  if(cljs.core.truth_(this__6069.root.edit)) {
    if(function() {
      var and__3546__auto____6070 = 0 <= n;
      if(and__3546__auto____6070) {
        return n < this__6069.cnt
      }else {
        return and__3546__auto____6070
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__6069.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__6073 = function go(level, node) {
          var node__6071 = cljs.core.tv_ensure_editable.call(null, this__6069.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__6071, n & 31, val);
            return node__6071
          }else {
            var subidx__6072 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__6071, subidx__6072, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__6071, subidx__6072)));
            return node__6071
          }
        }.call(null, this__6069.shift, this__6069.root);
        this__6069.root = new_root__6073;
        return tcoll
      }
    }else {
      if(n === this__6069.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__6069.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__6074 = this;
  if(cljs.core.truth_(this__6074.root.edit)) {
    if(this__6074.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__6074.cnt) {
        this__6074.cnt = 0;
        return tcoll
      }else {
        if((this__6074.cnt - 1 & 31) > 0) {
          this__6074.cnt = this__6074.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__6075 = cljs.core.editable_array_for.call(null, tcoll, this__6074.cnt - 2);
            var new_root__6077 = function() {
              var nr__6076 = cljs.core.tv_pop_tail.call(null, tcoll, this__6074.shift, this__6074.root);
              if(nr__6076 != null) {
                return nr__6076
              }else {
                return new cljs.core.VectorNode(this__6074.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____6078 = 5 < this__6074.shift;
              if(and__3546__auto____6078) {
                return cljs.core.pv_aget.call(null, new_root__6077, 1) == null
              }else {
                return and__3546__auto____6078
              }
            }()) {
              var new_root__6079 = cljs.core.tv_ensure_editable.call(null, this__6074.root.edit, cljs.core.pv_aget.call(null, new_root__6077, 0));
              this__6074.root = new_root__6079;
              this__6074.shift = this__6074.shift - 5;
              this__6074.cnt = this__6074.cnt - 1;
              this__6074.tail = new_tail__6075;
              return tcoll
            }else {
              this__6074.root = new_root__6077;
              this__6074.cnt = this__6074.cnt - 1;
              this__6074.tail = new_tail__6075;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6080 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6081 = this;
  if(cljs.core.truth_(this__6081.root.edit)) {
    if(this__6081.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__6081.tail[this__6081.cnt & 31] = o;
      this__6081.cnt = this__6081.cnt + 1;
      return tcoll
    }else {
      var tail_node__6082 = new cljs.core.VectorNode(this__6081.root.edit, this__6081.tail);
      var new_tail__6083 = cljs.core.make_array.call(null, 32);
      new_tail__6083[0] = o;
      this__6081.tail = new_tail__6083;
      if(this__6081.cnt >>> 5 > 1 << this__6081.shift) {
        var new_root_array__6084 = cljs.core.make_array.call(null, 32);
        var new_shift__6085 = this__6081.shift + 5;
        new_root_array__6084[0] = this__6081.root;
        new_root_array__6084[1] = cljs.core.new_path.call(null, this__6081.root.edit, this__6081.shift, tail_node__6082);
        this__6081.root = new cljs.core.VectorNode(this__6081.root.edit, new_root_array__6084);
        this__6081.shift = new_shift__6085;
        this__6081.cnt = this__6081.cnt + 1;
        return tcoll
      }else {
        var new_root__6086 = cljs.core.tv_push_tail.call(null, tcoll, this__6081.shift, this__6081.root, tail_node__6082);
        this__6081.root = new_root__6086;
        this__6081.cnt = this__6081.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6087 = this;
  if(cljs.core.truth_(this__6087.root.edit)) {
    this__6087.root.edit = null;
    var len__6088 = this__6087.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__6089 = cljs.core.make_array.call(null, len__6088);
    cljs.core.array_copy.call(null, this__6087.tail, 0, trimmed_tail__6089, 0, len__6088);
    return new cljs.core.PersistentVector(null, this__6087.cnt, this__6087.shift, this__6087.root, trimmed_tail__6089, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6091 = this;
  var h__364__auto____6092 = this__6091.__hash;
  if(h__364__auto____6092 != null) {
    return h__364__auto____6092
  }else {
    var h__364__auto____6093 = cljs.core.hash_coll.call(null, coll);
    this__6091.__hash = h__364__auto____6093;
    return h__364__auto____6093
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6094 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__6095 = this;
  var this$__6096 = this;
  return cljs.core.pr_str.call(null, this$__6096)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6097 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6098 = this;
  return cljs.core._first.call(null, this__6098.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6099 = this;
  var temp__3695__auto____6100 = cljs.core.next.call(null, this__6099.front);
  if(cljs.core.truth_(temp__3695__auto____6100)) {
    var f1__6101 = temp__3695__auto____6100;
    return new cljs.core.PersistentQueueSeq(this__6099.meta, f1__6101, this__6099.rear, null)
  }else {
    if(this__6099.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__6099.meta, this__6099.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6102 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6103 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__6103.front, this__6103.rear, this__6103.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6104 = this;
  return this__6104.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6105 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6105.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6106 = this;
  var h__364__auto____6107 = this__6106.__hash;
  if(h__364__auto____6107 != null) {
    return h__364__auto____6107
  }else {
    var h__364__auto____6108 = cljs.core.hash_coll.call(null, coll);
    this__6106.__hash = h__364__auto____6108;
    return h__364__auto____6108
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6109 = this;
  if(cljs.core.truth_(this__6109.front)) {
    return new cljs.core.PersistentQueue(this__6109.meta, this__6109.count + 1, this__6109.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____6110 = this__6109.rear;
      if(cljs.core.truth_(or__3548__auto____6110)) {
        return or__3548__auto____6110
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__6109.meta, this__6109.count + 1, cljs.core.conj.call(null, this__6109.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__6111 = this;
  var this$__6112 = this;
  return cljs.core.pr_str.call(null, this$__6112)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6113 = this;
  var rear__6114 = cljs.core.seq.call(null, this__6113.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____6115 = this__6113.front;
    if(cljs.core.truth_(or__3548__auto____6115)) {
      return or__3548__auto____6115
    }else {
      return rear__6114
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__6113.front, cljs.core.seq.call(null, rear__6114), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6116 = this;
  return this__6116.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6117 = this;
  return cljs.core._first.call(null, this__6117.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6118 = this;
  if(cljs.core.truth_(this__6118.front)) {
    var temp__3695__auto____6119 = cljs.core.next.call(null, this__6118.front);
    if(cljs.core.truth_(temp__3695__auto____6119)) {
      var f1__6120 = temp__3695__auto____6119;
      return new cljs.core.PersistentQueue(this__6118.meta, this__6118.count - 1, f1__6120, this__6118.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__6118.meta, this__6118.count - 1, cljs.core.seq.call(null, this__6118.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6121 = this;
  return cljs.core.first.call(null, this__6121.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6122 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6123 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6124 = this;
  return new cljs.core.PersistentQueue(meta, this__6124.count, this__6124.front, this__6124.rear, this__6124.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6125 = this;
  return this__6125.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6126 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6127 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__6128 = array.length;
  var i__6129 = 0;
  while(true) {
    if(i__6129 < len__6128) {
      if(cljs.core._EQ_.call(null, k, array[i__6129])) {
        return i__6129
      }else {
        var G__6130 = i__6129 + incr;
        i__6129 = G__6130;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6131 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____6131)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____6131
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__6132 = cljs.core.hash.call(null, a);
  var b__6133 = cljs.core.hash.call(null, b);
  if(a__6132 < b__6133) {
    return-1
  }else {
    if(a__6132 > b__6133) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__6135 = m.keys;
  var len__6136 = ks__6135.length;
  var so__6137 = m.strobj;
  var out__6138 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__6139 = 0;
  var out__6140 = cljs.core.transient$.call(null, out__6138);
  while(true) {
    if(i__6139 < len__6136) {
      var k__6141 = ks__6135[i__6139];
      var G__6142 = i__6139 + 1;
      var G__6143 = cljs.core.assoc_BANG_.call(null, out__6140, k__6141, so__6137[k__6141]);
      i__6139 = G__6142;
      out__6140 = G__6143;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__6140, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6148 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6149 = this;
  var h__364__auto____6150 = this__6149.__hash;
  if(h__364__auto____6150 != null) {
    return h__364__auto____6150
  }else {
    var h__364__auto____6151 = cljs.core.hash_imap.call(null, coll);
    this__6149.__hash = h__364__auto____6151;
    return h__364__auto____6151
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6152 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6153 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6153.strobj, this__6153.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6154 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___6155 = this__6154.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___6155)) {
      var new_strobj__6156 = goog.object.clone.call(null, this__6154.strobj);
      new_strobj__6156[k] = v;
      return new cljs.core.ObjMap(this__6154.meta, this__6154.keys, new_strobj__6156, this__6154.update_count + 1, null)
    }else {
      if(this__6154.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__6157 = goog.object.clone.call(null, this__6154.strobj);
        var new_keys__6158 = cljs.core.aclone.call(null, this__6154.keys);
        new_strobj__6157[k] = v;
        new_keys__6158.push(k);
        return new cljs.core.ObjMap(this__6154.meta, new_keys__6158, new_strobj__6157, this__6154.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6159 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6159.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__6179 = null;
  var G__6179__2 = function(tsym6146, k) {
    var this__6160 = this;
    var tsym6146__6161 = this;
    var coll__6162 = tsym6146__6161;
    return cljs.core._lookup.call(null, coll__6162, k)
  };
  var G__6179__3 = function(tsym6147, k, not_found) {
    var this__6163 = this;
    var tsym6147__6164 = this;
    var coll__6165 = tsym6147__6164;
    return cljs.core._lookup.call(null, coll__6165, k, not_found)
  };
  G__6179 = function(tsym6147, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6179__2.call(this, tsym6147, k);
      case 3:
        return G__6179__3.call(this, tsym6147, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6179
}();
cljs.core.ObjMap.prototype.apply = function(tsym6144, args6145) {
  return tsym6144.call.apply(tsym6144, [tsym6144].concat(cljs.core.aclone.call(null, args6145)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6166 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__6167 = this;
  var this$__6168 = this;
  return cljs.core.pr_str.call(null, this$__6168)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6169 = this;
  if(this__6169.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__6134_SHARP_) {
      return cljs.core.vector.call(null, p1__6134_SHARP_, this__6169.strobj[p1__6134_SHARP_])
    }, this__6169.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6170 = this;
  return this__6170.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6171 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6172 = this;
  return new cljs.core.ObjMap(meta, this__6172.keys, this__6172.strobj, this__6172.update_count, this__6172.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6173 = this;
  return this__6173.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6174 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__6174.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6175 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____6176 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____6176)) {
      return this__6175.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____6176
    }
  }())) {
    var new_keys__6177 = cljs.core.aclone.call(null, this__6175.keys);
    var new_strobj__6178 = goog.object.clone.call(null, this__6175.strobj);
    new_keys__6177.splice(cljs.core.scan_array.call(null, 1, k, new_keys__6177), 1);
    cljs.core.js_delete.call(null, new_strobj__6178, k);
    return new cljs.core.ObjMap(this__6175.meta, new_keys__6177, new_strobj__6178, this__6175.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6185 = this;
  var h__364__auto____6186 = this__6185.__hash;
  if(h__364__auto____6186 != null) {
    return h__364__auto____6186
  }else {
    var h__364__auto____6187 = cljs.core.hash_imap.call(null, coll);
    this__6185.__hash = h__364__auto____6187;
    return h__364__auto____6187
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6188 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6189 = this;
  var bucket__6190 = this__6189.hashobj[cljs.core.hash.call(null, k)];
  var i__6191 = cljs.core.truth_(bucket__6190) ? cljs.core.scan_array.call(null, 2, k, bucket__6190) : null;
  if(cljs.core.truth_(i__6191)) {
    return bucket__6190[i__6191 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6192 = this;
  var h__6193 = cljs.core.hash.call(null, k);
  var bucket__6194 = this__6192.hashobj[h__6193];
  if(cljs.core.truth_(bucket__6194)) {
    var new_bucket__6195 = cljs.core.aclone.call(null, bucket__6194);
    var new_hashobj__6196 = goog.object.clone.call(null, this__6192.hashobj);
    new_hashobj__6196[h__6193] = new_bucket__6195;
    var temp__3695__auto____6197 = cljs.core.scan_array.call(null, 2, k, new_bucket__6195);
    if(cljs.core.truth_(temp__3695__auto____6197)) {
      var i__6198 = temp__3695__auto____6197;
      new_bucket__6195[i__6198 + 1] = v;
      return new cljs.core.HashMap(this__6192.meta, this__6192.count, new_hashobj__6196, null)
    }else {
      new_bucket__6195.push(k, v);
      return new cljs.core.HashMap(this__6192.meta, this__6192.count + 1, new_hashobj__6196, null)
    }
  }else {
    var new_hashobj__6199 = goog.object.clone.call(null, this__6192.hashobj);
    new_hashobj__6199[h__6193] = [k, v];
    return new cljs.core.HashMap(this__6192.meta, this__6192.count + 1, new_hashobj__6199, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6200 = this;
  var bucket__6201 = this__6200.hashobj[cljs.core.hash.call(null, k)];
  var i__6202 = cljs.core.truth_(bucket__6201) ? cljs.core.scan_array.call(null, 2, k, bucket__6201) : null;
  if(cljs.core.truth_(i__6202)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6225 = null;
  var G__6225__2 = function(tsym6183, k) {
    var this__6203 = this;
    var tsym6183__6204 = this;
    var coll__6205 = tsym6183__6204;
    return cljs.core._lookup.call(null, coll__6205, k)
  };
  var G__6225__3 = function(tsym6184, k, not_found) {
    var this__6206 = this;
    var tsym6184__6207 = this;
    var coll__6208 = tsym6184__6207;
    return cljs.core._lookup.call(null, coll__6208, k, not_found)
  };
  G__6225 = function(tsym6184, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6225__2.call(this, tsym6184, k);
      case 3:
        return G__6225__3.call(this, tsym6184, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6225
}();
cljs.core.HashMap.prototype.apply = function(tsym6181, args6182) {
  return tsym6181.call.apply(tsym6181, [tsym6181].concat(cljs.core.aclone.call(null, args6182)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6209 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6210 = this;
  var this$__6211 = this;
  return cljs.core.pr_str.call(null, this$__6211)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6212 = this;
  if(this__6212.count > 0) {
    var hashes__6213 = cljs.core.js_keys.call(null, this__6212.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__6180_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6212.hashobj[p1__6180_SHARP_]))
    }, hashes__6213)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6214 = this;
  return this__6214.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6215 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6216 = this;
  return new cljs.core.HashMap(meta, this__6216.count, this__6216.hashobj, this__6216.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6217 = this;
  return this__6217.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6218 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6218.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6219 = this;
  var h__6220 = cljs.core.hash.call(null, k);
  var bucket__6221 = this__6219.hashobj[h__6220];
  var i__6222 = cljs.core.truth_(bucket__6221) ? cljs.core.scan_array.call(null, 2, k, bucket__6221) : null;
  if(cljs.core.not.call(null, i__6222)) {
    return coll
  }else {
    var new_hashobj__6223 = goog.object.clone.call(null, this__6219.hashobj);
    if(3 > bucket__6221.length) {
      cljs.core.js_delete.call(null, new_hashobj__6223, h__6220)
    }else {
      var new_bucket__6224 = cljs.core.aclone.call(null, bucket__6221);
      new_bucket__6224.splice(i__6222, 2);
      new_hashobj__6223[h__6220] = new_bucket__6224
    }
    return new cljs.core.HashMap(this__6219.meta, this__6219.count - 1, new_hashobj__6223, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6226 = ks.length;
  var i__6227 = 0;
  var out__6228 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6227 < len__6226) {
      var G__6229 = i__6227 + 1;
      var G__6230 = cljs.core.assoc.call(null, out__6228, ks[i__6227], vs[i__6227]);
      i__6227 = G__6229;
      out__6228 = G__6230;
      continue
    }else {
      return out__6228
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6231 = m.arr;
  var len__6232 = arr__6231.length;
  var i__6233 = 0;
  while(true) {
    if(len__6232 <= i__6233) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6231[i__6233], k)) {
        return i__6233
      }else {
        if("\ufdd0'else") {
          var G__6234 = i__6233 + 2;
          i__6233 = G__6234;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6239 = this;
  return new cljs.core.TransientArrayMap({}, this__6239.arr.length, cljs.core.aclone.call(null, this__6239.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6240 = this;
  var h__364__auto____6241 = this__6240.__hash;
  if(h__364__auto____6241 != null) {
    return h__364__auto____6241
  }else {
    var h__364__auto____6242 = cljs.core.hash_imap.call(null, coll);
    this__6240.__hash = h__364__auto____6242;
    return h__364__auto____6242
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6243 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6244 = this;
  var idx__6245 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6245 === -1) {
    return not_found
  }else {
    return this__6244.arr[idx__6245 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6246 = this;
  var idx__6247 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6247 === -1) {
    if(this__6246.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6246.meta, this__6246.cnt + 1, function() {
        var G__6248__6249 = cljs.core.aclone.call(null, this__6246.arr);
        G__6248__6249.push(k);
        G__6248__6249.push(v);
        return G__6248__6249
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6246.arr[idx__6247 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6246.meta, this__6246.cnt, function() {
          var G__6250__6251 = cljs.core.aclone.call(null, this__6246.arr);
          G__6250__6251[idx__6247 + 1] = v;
          return G__6250__6251
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6252 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6282 = null;
  var G__6282__2 = function(tsym6237, k) {
    var this__6253 = this;
    var tsym6237__6254 = this;
    var coll__6255 = tsym6237__6254;
    return cljs.core._lookup.call(null, coll__6255, k)
  };
  var G__6282__3 = function(tsym6238, k, not_found) {
    var this__6256 = this;
    var tsym6238__6257 = this;
    var coll__6258 = tsym6238__6257;
    return cljs.core._lookup.call(null, coll__6258, k, not_found)
  };
  G__6282 = function(tsym6238, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6282__2.call(this, tsym6238, k);
      case 3:
        return G__6282__3.call(this, tsym6238, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6282
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6235, args6236) {
  return tsym6235.call.apply(tsym6235, [tsym6235].concat(cljs.core.aclone.call(null, args6236)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6259 = this;
  var len__6260 = this__6259.arr.length;
  var i__6261 = 0;
  var init__6262 = init;
  while(true) {
    if(i__6261 < len__6260) {
      var init__6263 = f.call(null, init__6262, this__6259.arr[i__6261], this__6259.arr[i__6261 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6263)) {
        return cljs.core.deref.call(null, init__6263)
      }else {
        var G__6283 = i__6261 + 2;
        var G__6284 = init__6263;
        i__6261 = G__6283;
        init__6262 = G__6284;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6264 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6265 = this;
  var this$__6266 = this;
  return cljs.core.pr_str.call(null, this$__6266)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6267 = this;
  if(this__6267.cnt > 0) {
    var len__6268 = this__6267.arr.length;
    var array_map_seq__6269 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6268) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6267.arr[i], this__6267.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6269.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6270 = this;
  return this__6270.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6271 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6272 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6272.cnt, this__6272.arr, this__6272.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6273 = this;
  return this__6273.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6274 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6274.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6275 = this;
  var idx__6276 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6276 >= 0) {
    var len__6277 = this__6275.arr.length;
    var new_len__6278 = len__6277 - 2;
    if(new_len__6278 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6279 = cljs.core.make_array.call(null, new_len__6278);
      var s__6280 = 0;
      var d__6281 = 0;
      while(true) {
        if(s__6280 >= len__6277) {
          return new cljs.core.PersistentArrayMap(this__6275.meta, this__6275.cnt - 1, new_arr__6279, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6275.arr[s__6280])) {
            var G__6285 = s__6280 + 2;
            var G__6286 = d__6281;
            s__6280 = G__6285;
            d__6281 = G__6286;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6279[d__6281] = this__6275.arr[s__6280];
              new_arr__6279[d__6281 + 1] = this__6275.arr[s__6280 + 1];
              var G__6287 = s__6280 + 2;
              var G__6288 = d__6281 + 2;
              s__6280 = G__6287;
              d__6281 = G__6288;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6289 = cljs.core.count.call(null, ks);
  var i__6290 = 0;
  var out__6291 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6290 < len__6289) {
      var G__6292 = i__6290 + 1;
      var G__6293 = cljs.core.assoc_BANG_.call(null, out__6291, ks[i__6290], vs[i__6290]);
      i__6290 = G__6292;
      out__6291 = G__6293;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6291)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6294 = this;
  if(cljs.core.truth_(this__6294.editable_QMARK_)) {
    var idx__6295 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6295 >= 0) {
      this__6294.arr[idx__6295] = this__6294.arr[this__6294.len - 2];
      this__6294.arr[idx__6295 + 1] = this__6294.arr[this__6294.len - 1];
      var G__6296__6297 = this__6294.arr;
      G__6296__6297.pop();
      G__6296__6297.pop();
      G__6296__6297;
      this__6294.len = this__6294.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6298 = this;
  if(cljs.core.truth_(this__6298.editable_QMARK_)) {
    var idx__6299 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6299 === -1) {
      if(this__6298.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6298.len = this__6298.len + 2;
        this__6298.arr.push(key);
        this__6298.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6298.len, this__6298.arr), key, val)
      }
    }else {
      if(val === this__6298.arr[idx__6299 + 1]) {
        return tcoll
      }else {
        this__6298.arr[idx__6299 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6300 = this;
  if(cljs.core.truth_(this__6300.editable_QMARK_)) {
    if(function() {
      var G__6301__6302 = o;
      if(G__6301__6302 != null) {
        if(function() {
          var or__3548__auto____6303 = G__6301__6302.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6303) {
            return or__3548__auto____6303
          }else {
            return G__6301__6302.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6301__6302.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6301__6302)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6301__6302)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6304 = cljs.core.seq.call(null, o);
      var tcoll__6305 = tcoll;
      while(true) {
        var temp__3695__auto____6306 = cljs.core.first.call(null, es__6304);
        if(cljs.core.truth_(temp__3695__auto____6306)) {
          var e__6307 = temp__3695__auto____6306;
          var G__6313 = cljs.core.next.call(null, es__6304);
          var G__6314 = cljs.core._assoc_BANG_.call(null, tcoll__6305, cljs.core.key.call(null, e__6307), cljs.core.val.call(null, e__6307));
          es__6304 = G__6313;
          tcoll__6305 = G__6314;
          continue
        }else {
          return tcoll__6305
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6308 = this;
  if(cljs.core.truth_(this__6308.editable_QMARK_)) {
    this__6308.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6308.len, 2), this__6308.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6309 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6310 = this;
  if(cljs.core.truth_(this__6310.editable_QMARK_)) {
    var idx__6311 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6311 === -1) {
      return not_found
    }else {
      return this__6310.arr[idx__6311 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6312 = this;
  if(cljs.core.truth_(this__6312.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6312.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6315 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6316 = 0;
  while(true) {
    if(i__6316 < len) {
      var G__6317 = cljs.core.assoc_BANG_.call(null, out__6315, arr[i__6316], arr[i__6316 + 1]);
      var G__6318 = i__6316 + 2;
      out__6315 = G__6317;
      i__6316 = G__6318;
      continue
    }else {
      return out__6315
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6319__6320 = cljs.core.aclone.call(null, arr);
    G__6319__6320[i] = a;
    return G__6319__6320
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6321__6322 = cljs.core.aclone.call(null, arr);
    G__6321__6322[i] = a;
    G__6321__6322[j] = b;
    return G__6321__6322
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6323 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6323, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6323, 2 * i, new_arr__6323.length - 2 * i);
  return new_arr__6323
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6324 = inode.ensure_editable(edit);
    editable__6324.arr[i] = a;
    return editable__6324
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6325 = inode.ensure_editable(edit);
    editable__6325.arr[i] = a;
    editable__6325.arr[j] = b;
    return editable__6325
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6326 = arr.length;
  var i__6327 = 0;
  var init__6328 = init;
  while(true) {
    if(i__6327 < len__6326) {
      var init__6331 = function() {
        var k__6329 = arr[i__6327];
        if(k__6329 != null) {
          return f.call(null, init__6328, k__6329, arr[i__6327 + 1])
        }else {
          var node__6330 = arr[i__6327 + 1];
          if(node__6330 != null) {
            return node__6330.kv_reduce(f, init__6328)
          }else {
            return init__6328
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6331)) {
        return cljs.core.deref.call(null, init__6331)
      }else {
        var G__6332 = i__6327 + 2;
        var G__6333 = init__6331;
        i__6327 = G__6332;
        init__6328 = G__6333;
        continue
      }
    }else {
      return init__6328
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6334 = this;
  var inode__6335 = this;
  if(this__6334.bitmap === bit) {
    return null
  }else {
    var editable__6336 = inode__6335.ensure_editable(e);
    var earr__6337 = editable__6336.arr;
    var len__6338 = earr__6337.length;
    editable__6336.bitmap = bit ^ editable__6336.bitmap;
    cljs.core.array_copy.call(null, earr__6337, 2 * (i + 1), earr__6337, 2 * i, len__6338 - 2 * (i + 1));
    earr__6337[len__6338 - 2] = null;
    earr__6337[len__6338 - 1] = null;
    return editable__6336
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6339 = this;
  var inode__6340 = this;
  var bit__6341 = 1 << (hash >>> shift & 31);
  var idx__6342 = cljs.core.bitmap_indexed_node_index.call(null, this__6339.bitmap, bit__6341);
  if((this__6339.bitmap & bit__6341) === 0) {
    var n__6343 = cljs.core.bit_count.call(null, this__6339.bitmap);
    if(2 * n__6343 < this__6339.arr.length) {
      var editable__6344 = inode__6340.ensure_editable(edit);
      var earr__6345 = editable__6344.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6345, 2 * idx__6342, earr__6345, 2 * (idx__6342 + 1), 2 * (n__6343 - idx__6342));
      earr__6345[2 * idx__6342] = key;
      earr__6345[2 * idx__6342 + 1] = val;
      editable__6344.bitmap = editable__6344.bitmap | bit__6341;
      return editable__6344
    }else {
      if(n__6343 >= 16) {
        var nodes__6346 = cljs.core.make_array.call(null, 32);
        var jdx__6347 = hash >>> shift & 31;
        nodes__6346[jdx__6347] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6348 = 0;
        var j__6349 = 0;
        while(true) {
          if(i__6348 < 32) {
            if((this__6339.bitmap >>> i__6348 & 1) === 0) {
              var G__6402 = i__6348 + 1;
              var G__6403 = j__6349;
              i__6348 = G__6402;
              j__6349 = G__6403;
              continue
            }else {
              nodes__6346[i__6348] = null != this__6339.arr[j__6349] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6339.arr[j__6349]), this__6339.arr[j__6349], this__6339.arr[j__6349 + 1], added_leaf_QMARK_) : this__6339.arr[j__6349 + 1];
              var G__6404 = i__6348 + 1;
              var G__6405 = j__6349 + 2;
              i__6348 = G__6404;
              j__6349 = G__6405;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6343 + 1, nodes__6346)
      }else {
        if("\ufdd0'else") {
          var new_arr__6350 = cljs.core.make_array.call(null, 2 * (n__6343 + 4));
          cljs.core.array_copy.call(null, this__6339.arr, 0, new_arr__6350, 0, 2 * idx__6342);
          new_arr__6350[2 * idx__6342] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6350[2 * idx__6342 + 1] = val;
          cljs.core.array_copy.call(null, this__6339.arr, 2 * idx__6342, new_arr__6350, 2 * (idx__6342 + 1), 2 * (n__6343 - idx__6342));
          var editable__6351 = inode__6340.ensure_editable(edit);
          editable__6351.arr = new_arr__6350;
          editable__6351.bitmap = editable__6351.bitmap | bit__6341;
          return editable__6351
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6352 = this__6339.arr[2 * idx__6342];
    var val_or_node__6353 = this__6339.arr[2 * idx__6342 + 1];
    if(null == key_or_nil__6352) {
      var n__6354 = val_or_node__6353.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6354 === val_or_node__6353) {
        return inode__6340
      }else {
        return cljs.core.edit_and_set.call(null, inode__6340, edit, 2 * idx__6342 + 1, n__6354)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6352)) {
        if(val === val_or_node__6353) {
          return inode__6340
        }else {
          return cljs.core.edit_and_set.call(null, inode__6340, edit, 2 * idx__6342 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6340, edit, 2 * idx__6342, null, 2 * idx__6342 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6352, val_or_node__6353, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6355 = this;
  var inode__6356 = this;
  return cljs.core.create_inode_seq.call(null, this__6355.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6357 = this;
  var inode__6358 = this;
  var bit__6359 = 1 << (hash >>> shift & 31);
  if((this__6357.bitmap & bit__6359) === 0) {
    return inode__6358
  }else {
    var idx__6360 = cljs.core.bitmap_indexed_node_index.call(null, this__6357.bitmap, bit__6359);
    var key_or_nil__6361 = this__6357.arr[2 * idx__6360];
    var val_or_node__6362 = this__6357.arr[2 * idx__6360 + 1];
    if(null == key_or_nil__6361) {
      var n__6363 = val_or_node__6362.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6363 === val_or_node__6362) {
        return inode__6358
      }else {
        if(null != n__6363) {
          return cljs.core.edit_and_set.call(null, inode__6358, edit, 2 * idx__6360 + 1, n__6363)
        }else {
          if(this__6357.bitmap === bit__6359) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6358.edit_and_remove_pair(edit, bit__6359, idx__6360)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6361)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6358.edit_and_remove_pair(edit, bit__6359, idx__6360)
      }else {
        if("\ufdd0'else") {
          return inode__6358
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6364 = this;
  var inode__6365 = this;
  if(e === this__6364.edit) {
    return inode__6365
  }else {
    var n__6366 = cljs.core.bit_count.call(null, this__6364.bitmap);
    var new_arr__6367 = cljs.core.make_array.call(null, n__6366 < 0 ? 4 : 2 * (n__6366 + 1));
    cljs.core.array_copy.call(null, this__6364.arr, 0, new_arr__6367, 0, 2 * n__6366);
    return new cljs.core.BitmapIndexedNode(e, this__6364.bitmap, new_arr__6367)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6368 = this;
  var inode__6369 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6368.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6406 = null;
  var G__6406__3 = function(shift, hash, key) {
    var this__6370 = this;
    var inode__6371 = this;
    var bit__6372 = 1 << (hash >>> shift & 31);
    if((this__6370.bitmap & bit__6372) === 0) {
      return null
    }else {
      var idx__6373 = cljs.core.bitmap_indexed_node_index.call(null, this__6370.bitmap, bit__6372);
      var key_or_nil__6374 = this__6370.arr[2 * idx__6373];
      var val_or_node__6375 = this__6370.arr[2 * idx__6373 + 1];
      if(null == key_or_nil__6374) {
        return val_or_node__6375.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6374)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6374, val_or_node__6375])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6406__4 = function(shift, hash, key, not_found) {
    var this__6376 = this;
    var inode__6377 = this;
    var bit__6378 = 1 << (hash >>> shift & 31);
    if((this__6376.bitmap & bit__6378) === 0) {
      return not_found
    }else {
      var idx__6379 = cljs.core.bitmap_indexed_node_index.call(null, this__6376.bitmap, bit__6378);
      var key_or_nil__6380 = this__6376.arr[2 * idx__6379];
      var val_or_node__6381 = this__6376.arr[2 * idx__6379 + 1];
      if(null == key_or_nil__6380) {
        return val_or_node__6381.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6380)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6380, val_or_node__6381])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6406 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6406__3.call(this, shift, hash, key);
      case 4:
        return G__6406__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6406
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6382 = this;
  var inode__6383 = this;
  var bit__6384 = 1 << (hash >>> shift & 31);
  if((this__6382.bitmap & bit__6384) === 0) {
    return inode__6383
  }else {
    var idx__6385 = cljs.core.bitmap_indexed_node_index.call(null, this__6382.bitmap, bit__6384);
    var key_or_nil__6386 = this__6382.arr[2 * idx__6385];
    var val_or_node__6387 = this__6382.arr[2 * idx__6385 + 1];
    if(null == key_or_nil__6386) {
      var n__6388 = val_or_node__6387.inode_without(shift + 5, hash, key);
      if(n__6388 === val_or_node__6387) {
        return inode__6383
      }else {
        if(null != n__6388) {
          return new cljs.core.BitmapIndexedNode(null, this__6382.bitmap, cljs.core.clone_and_set.call(null, this__6382.arr, 2 * idx__6385 + 1, n__6388))
        }else {
          if(this__6382.bitmap === bit__6384) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6382.bitmap ^ bit__6384, cljs.core.remove_pair.call(null, this__6382.arr, idx__6385))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6386)) {
        return new cljs.core.BitmapIndexedNode(null, this__6382.bitmap ^ bit__6384, cljs.core.remove_pair.call(null, this__6382.arr, idx__6385))
      }else {
        if("\ufdd0'else") {
          return inode__6383
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6389 = this;
  var inode__6390 = this;
  var bit__6391 = 1 << (hash >>> shift & 31);
  var idx__6392 = cljs.core.bitmap_indexed_node_index.call(null, this__6389.bitmap, bit__6391);
  if((this__6389.bitmap & bit__6391) === 0) {
    var n__6393 = cljs.core.bit_count.call(null, this__6389.bitmap);
    if(n__6393 >= 16) {
      var nodes__6394 = cljs.core.make_array.call(null, 32);
      var jdx__6395 = hash >>> shift & 31;
      nodes__6394[jdx__6395] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6396 = 0;
      var j__6397 = 0;
      while(true) {
        if(i__6396 < 32) {
          if((this__6389.bitmap >>> i__6396 & 1) === 0) {
            var G__6407 = i__6396 + 1;
            var G__6408 = j__6397;
            i__6396 = G__6407;
            j__6397 = G__6408;
            continue
          }else {
            nodes__6394[i__6396] = null != this__6389.arr[j__6397] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6389.arr[j__6397]), this__6389.arr[j__6397], this__6389.arr[j__6397 + 1], added_leaf_QMARK_) : this__6389.arr[j__6397 + 1];
            var G__6409 = i__6396 + 1;
            var G__6410 = j__6397 + 2;
            i__6396 = G__6409;
            j__6397 = G__6410;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6393 + 1, nodes__6394)
    }else {
      var new_arr__6398 = cljs.core.make_array.call(null, 2 * (n__6393 + 1));
      cljs.core.array_copy.call(null, this__6389.arr, 0, new_arr__6398, 0, 2 * idx__6392);
      new_arr__6398[2 * idx__6392] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6398[2 * idx__6392 + 1] = val;
      cljs.core.array_copy.call(null, this__6389.arr, 2 * idx__6392, new_arr__6398, 2 * (idx__6392 + 1), 2 * (n__6393 - idx__6392));
      return new cljs.core.BitmapIndexedNode(null, this__6389.bitmap | bit__6391, new_arr__6398)
    }
  }else {
    var key_or_nil__6399 = this__6389.arr[2 * idx__6392];
    var val_or_node__6400 = this__6389.arr[2 * idx__6392 + 1];
    if(null == key_or_nil__6399) {
      var n__6401 = val_or_node__6400.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6401 === val_or_node__6400) {
        return inode__6390
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6389.bitmap, cljs.core.clone_and_set.call(null, this__6389.arr, 2 * idx__6392 + 1, n__6401))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6399)) {
        if(val === val_or_node__6400) {
          return inode__6390
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6389.bitmap, cljs.core.clone_and_set.call(null, this__6389.arr, 2 * idx__6392 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6389.bitmap, cljs.core.clone_and_set.call(null, this__6389.arr, 2 * idx__6392, null, 2 * idx__6392 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6399, val_or_node__6400, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6411 = array_node.arr;
  var len__6412 = 2 * (array_node.cnt - 1);
  var new_arr__6413 = cljs.core.make_array.call(null, len__6412);
  var i__6414 = 0;
  var j__6415 = 1;
  var bitmap__6416 = 0;
  while(true) {
    if(i__6414 < len__6412) {
      if(function() {
        var and__3546__auto____6417 = i__6414 != idx;
        if(and__3546__auto____6417) {
          return null != arr__6411[i__6414]
        }else {
          return and__3546__auto____6417
        }
      }()) {
        new_arr__6413[j__6415] = arr__6411[i__6414];
        var G__6418 = i__6414 + 1;
        var G__6419 = j__6415 + 2;
        var G__6420 = bitmap__6416 | 1 << i__6414;
        i__6414 = G__6418;
        j__6415 = G__6419;
        bitmap__6416 = G__6420;
        continue
      }else {
        var G__6421 = i__6414 + 1;
        var G__6422 = j__6415;
        var G__6423 = bitmap__6416;
        i__6414 = G__6421;
        j__6415 = G__6422;
        bitmap__6416 = G__6423;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6416, new_arr__6413)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6424 = this;
  var inode__6425 = this;
  var idx__6426 = hash >>> shift & 31;
  var node__6427 = this__6424.arr[idx__6426];
  if(null == node__6427) {
    return new cljs.core.ArrayNode(null, this__6424.cnt + 1, cljs.core.clone_and_set.call(null, this__6424.arr, idx__6426, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6428 = node__6427.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6428 === node__6427) {
      return inode__6425
    }else {
      return new cljs.core.ArrayNode(null, this__6424.cnt, cljs.core.clone_and_set.call(null, this__6424.arr, idx__6426, n__6428))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6429 = this;
  var inode__6430 = this;
  var idx__6431 = hash >>> shift & 31;
  var node__6432 = this__6429.arr[idx__6431];
  if(null != node__6432) {
    var n__6433 = node__6432.inode_without(shift + 5, hash, key);
    if(n__6433 === node__6432) {
      return inode__6430
    }else {
      if(n__6433 == null) {
        if(this__6429.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6430, null, idx__6431)
        }else {
          return new cljs.core.ArrayNode(null, this__6429.cnt - 1, cljs.core.clone_and_set.call(null, this__6429.arr, idx__6431, n__6433))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6429.cnt, cljs.core.clone_and_set.call(null, this__6429.arr, idx__6431, n__6433))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6430
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6465 = null;
  var G__6465__3 = function(shift, hash, key) {
    var this__6434 = this;
    var inode__6435 = this;
    var idx__6436 = hash >>> shift & 31;
    var node__6437 = this__6434.arr[idx__6436];
    if(null != node__6437) {
      return node__6437.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6465__4 = function(shift, hash, key, not_found) {
    var this__6438 = this;
    var inode__6439 = this;
    var idx__6440 = hash >>> shift & 31;
    var node__6441 = this__6438.arr[idx__6440];
    if(null != node__6441) {
      return node__6441.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6465 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6465__3.call(this, shift, hash, key);
      case 4:
        return G__6465__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6465
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6442 = this;
  var inode__6443 = this;
  return cljs.core.create_array_node_seq.call(null, this__6442.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6444 = this;
  var inode__6445 = this;
  if(e === this__6444.edit) {
    return inode__6445
  }else {
    return new cljs.core.ArrayNode(e, this__6444.cnt, cljs.core.aclone.call(null, this__6444.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6446 = this;
  var inode__6447 = this;
  var idx__6448 = hash >>> shift & 31;
  var node__6449 = this__6446.arr[idx__6448];
  if(null == node__6449) {
    var editable__6450 = cljs.core.edit_and_set.call(null, inode__6447, edit, idx__6448, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6450.cnt = editable__6450.cnt + 1;
    return editable__6450
  }else {
    var n__6451 = node__6449.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6451 === node__6449) {
      return inode__6447
    }else {
      return cljs.core.edit_and_set.call(null, inode__6447, edit, idx__6448, n__6451)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6452 = this;
  var inode__6453 = this;
  var idx__6454 = hash >>> shift & 31;
  var node__6455 = this__6452.arr[idx__6454];
  if(null == node__6455) {
    return inode__6453
  }else {
    var n__6456 = node__6455.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6456 === node__6455) {
      return inode__6453
    }else {
      if(null == n__6456) {
        if(this__6452.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6453, edit, idx__6454)
        }else {
          var editable__6457 = cljs.core.edit_and_set.call(null, inode__6453, edit, idx__6454, n__6456);
          editable__6457.cnt = editable__6457.cnt - 1;
          return editable__6457
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6453, edit, idx__6454, n__6456)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6458 = this;
  var inode__6459 = this;
  var len__6460 = this__6458.arr.length;
  var i__6461 = 0;
  var init__6462 = init;
  while(true) {
    if(i__6461 < len__6460) {
      var node__6463 = this__6458.arr[i__6461];
      if(node__6463 != null) {
        var init__6464 = node__6463.kv_reduce(f, init__6462);
        if(cljs.core.reduced_QMARK_.call(null, init__6464)) {
          return cljs.core.deref.call(null, init__6464)
        }else {
          var G__6466 = i__6461 + 1;
          var G__6467 = init__6464;
          i__6461 = G__6466;
          init__6462 = G__6467;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6462
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6468 = 2 * cnt;
  var i__6469 = 0;
  while(true) {
    if(i__6469 < lim__6468) {
      if(cljs.core._EQ_.call(null, key, arr[i__6469])) {
        return i__6469
      }else {
        var G__6470 = i__6469 + 2;
        i__6469 = G__6470;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6471 = this;
  var inode__6472 = this;
  if(hash === this__6471.collision_hash) {
    var idx__6473 = cljs.core.hash_collision_node_find_index.call(null, this__6471.arr, this__6471.cnt, key);
    if(idx__6473 === -1) {
      var len__6474 = this__6471.arr.length;
      var new_arr__6475 = cljs.core.make_array.call(null, len__6474 + 2);
      cljs.core.array_copy.call(null, this__6471.arr, 0, new_arr__6475, 0, len__6474);
      new_arr__6475[len__6474] = key;
      new_arr__6475[len__6474 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6471.collision_hash, this__6471.cnt + 1, new_arr__6475)
    }else {
      if(cljs.core._EQ_.call(null, this__6471.arr[idx__6473], val)) {
        return inode__6472
      }else {
        return new cljs.core.HashCollisionNode(null, this__6471.collision_hash, this__6471.cnt, cljs.core.clone_and_set.call(null, this__6471.arr, idx__6473 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6471.collision_hash >>> shift & 31), [null, inode__6472])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6476 = this;
  var inode__6477 = this;
  var idx__6478 = cljs.core.hash_collision_node_find_index.call(null, this__6476.arr, this__6476.cnt, key);
  if(idx__6478 === -1) {
    return inode__6477
  }else {
    if(this__6476.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6476.collision_hash, this__6476.cnt - 1, cljs.core.remove_pair.call(null, this__6476.arr, cljs.core.quot.call(null, idx__6478, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6505 = null;
  var G__6505__3 = function(shift, hash, key) {
    var this__6479 = this;
    var inode__6480 = this;
    var idx__6481 = cljs.core.hash_collision_node_find_index.call(null, this__6479.arr, this__6479.cnt, key);
    if(idx__6481 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6479.arr[idx__6481])) {
        return cljs.core.PersistentVector.fromArray([this__6479.arr[idx__6481], this__6479.arr[idx__6481 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6505__4 = function(shift, hash, key, not_found) {
    var this__6482 = this;
    var inode__6483 = this;
    var idx__6484 = cljs.core.hash_collision_node_find_index.call(null, this__6482.arr, this__6482.cnt, key);
    if(idx__6484 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6482.arr[idx__6484])) {
        return cljs.core.PersistentVector.fromArray([this__6482.arr[idx__6484], this__6482.arr[idx__6484 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6505 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6505__3.call(this, shift, hash, key);
      case 4:
        return G__6505__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6505
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6485 = this;
  var inode__6486 = this;
  return cljs.core.create_inode_seq.call(null, this__6485.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6506 = null;
  var G__6506__1 = function(e) {
    var this__6487 = this;
    var inode__6488 = this;
    if(e === this__6487.edit) {
      return inode__6488
    }else {
      var new_arr__6489 = cljs.core.make_array.call(null, 2 * (this__6487.cnt + 1));
      cljs.core.array_copy.call(null, this__6487.arr, 0, new_arr__6489, 0, 2 * this__6487.cnt);
      return new cljs.core.HashCollisionNode(e, this__6487.collision_hash, this__6487.cnt, new_arr__6489)
    }
  };
  var G__6506__3 = function(e, count, array) {
    var this__6490 = this;
    var inode__6491 = this;
    if(e === this__6490.edit) {
      this__6490.arr = array;
      this__6490.cnt = count;
      return inode__6491
    }else {
      return new cljs.core.HashCollisionNode(this__6490.edit, this__6490.collision_hash, count, array)
    }
  };
  G__6506 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6506__1.call(this, e);
      case 3:
        return G__6506__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6506
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6492 = this;
  var inode__6493 = this;
  if(hash === this__6492.collision_hash) {
    var idx__6494 = cljs.core.hash_collision_node_find_index.call(null, this__6492.arr, this__6492.cnt, key);
    if(idx__6494 === -1) {
      if(this__6492.arr.length > 2 * this__6492.cnt) {
        var editable__6495 = cljs.core.edit_and_set.call(null, inode__6493, edit, 2 * this__6492.cnt, key, 2 * this__6492.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6495.cnt = editable__6495.cnt + 1;
        return editable__6495
      }else {
        var len__6496 = this__6492.arr.length;
        var new_arr__6497 = cljs.core.make_array.call(null, len__6496 + 2);
        cljs.core.array_copy.call(null, this__6492.arr, 0, new_arr__6497, 0, len__6496);
        new_arr__6497[len__6496] = key;
        new_arr__6497[len__6496 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6493.ensure_editable(edit, this__6492.cnt + 1, new_arr__6497)
      }
    }else {
      if(this__6492.arr[idx__6494 + 1] === val) {
        return inode__6493
      }else {
        return cljs.core.edit_and_set.call(null, inode__6493, edit, idx__6494 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6492.collision_hash >>> shift & 31), [null, inode__6493, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6498 = this;
  var inode__6499 = this;
  var idx__6500 = cljs.core.hash_collision_node_find_index.call(null, this__6498.arr, this__6498.cnt, key);
  if(idx__6500 === -1) {
    return inode__6499
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6498.cnt === 1) {
      return null
    }else {
      var editable__6501 = inode__6499.ensure_editable(edit);
      var earr__6502 = editable__6501.arr;
      earr__6502[idx__6500] = earr__6502[2 * this__6498.cnt - 2];
      earr__6502[idx__6500 + 1] = earr__6502[2 * this__6498.cnt - 1];
      earr__6502[2 * this__6498.cnt - 1] = null;
      earr__6502[2 * this__6498.cnt - 2] = null;
      editable__6501.cnt = editable__6501.cnt - 1;
      return editable__6501
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6503 = this;
  var inode__6504 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6503.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6507 = cljs.core.hash.call(null, key1);
    if(key1hash__6507 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6507, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6508 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6507, key1, val1, added_leaf_QMARK___6508).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6508)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6509 = cljs.core.hash.call(null, key1);
    if(key1hash__6509 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6509, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6510 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6509, key1, val1, added_leaf_QMARK___6510).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6510)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6511 = this;
  var h__364__auto____6512 = this__6511.__hash;
  if(h__364__auto____6512 != null) {
    return h__364__auto____6512
  }else {
    var h__364__auto____6513 = cljs.core.hash_coll.call(null, coll);
    this__6511.__hash = h__364__auto____6513;
    return h__364__auto____6513
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6514 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6515 = this;
  var this$__6516 = this;
  return cljs.core.pr_str.call(null, this$__6516)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6517 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6518 = this;
  if(this__6518.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6518.nodes[this__6518.i], this__6518.nodes[this__6518.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6518.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6519 = this;
  if(this__6519.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6519.nodes, this__6519.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6519.nodes, this__6519.i, cljs.core.next.call(null, this__6519.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6520 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6521 = this;
  return new cljs.core.NodeSeq(meta, this__6521.nodes, this__6521.i, this__6521.s, this__6521.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6522 = this;
  return this__6522.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6523 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6523.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6524 = nodes.length;
      var j__6525 = i;
      while(true) {
        if(j__6525 < len__6524) {
          if(null != nodes[j__6525]) {
            return new cljs.core.NodeSeq(null, nodes, j__6525, null, null)
          }else {
            var temp__3695__auto____6526 = nodes[j__6525 + 1];
            if(cljs.core.truth_(temp__3695__auto____6526)) {
              var node__6527 = temp__3695__auto____6526;
              var temp__3695__auto____6528 = node__6527.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6528)) {
                var node_seq__6529 = temp__3695__auto____6528;
                return new cljs.core.NodeSeq(null, nodes, j__6525 + 2, node_seq__6529, null)
              }else {
                var G__6530 = j__6525 + 2;
                j__6525 = G__6530;
                continue
              }
            }else {
              var G__6531 = j__6525 + 2;
              j__6525 = G__6531;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6532 = this;
  var h__364__auto____6533 = this__6532.__hash;
  if(h__364__auto____6533 != null) {
    return h__364__auto____6533
  }else {
    var h__364__auto____6534 = cljs.core.hash_coll.call(null, coll);
    this__6532.__hash = h__364__auto____6534;
    return h__364__auto____6534
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6535 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6536 = this;
  var this$__6537 = this;
  return cljs.core.pr_str.call(null, this$__6537)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6538 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6539 = this;
  return cljs.core.first.call(null, this__6539.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6540 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6540.nodes, this__6540.i, cljs.core.next.call(null, this__6540.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6541 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6542 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6542.nodes, this__6542.i, this__6542.s, this__6542.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6543 = this;
  return this__6543.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6544 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6544.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6545 = nodes.length;
      var j__6546 = i;
      while(true) {
        if(j__6546 < len__6545) {
          var temp__3695__auto____6547 = nodes[j__6546];
          if(cljs.core.truth_(temp__3695__auto____6547)) {
            var nj__6548 = temp__3695__auto____6547;
            var temp__3695__auto____6549 = nj__6548.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6549)) {
              var ns__6550 = temp__3695__auto____6549;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6546 + 1, ns__6550, null)
            }else {
              var G__6551 = j__6546 + 1;
              j__6546 = G__6551;
              continue
            }
          }else {
            var G__6552 = j__6546 + 1;
            j__6546 = G__6552;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6557 = this;
  return new cljs.core.TransientHashMap({}, this__6557.root, this__6557.cnt, this__6557.has_nil_QMARK_, this__6557.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6558 = this;
  var h__364__auto____6559 = this__6558.__hash;
  if(h__364__auto____6559 != null) {
    return h__364__auto____6559
  }else {
    var h__364__auto____6560 = cljs.core.hash_imap.call(null, coll);
    this__6558.__hash = h__364__auto____6560;
    return h__364__auto____6560
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6561 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6562 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6562.has_nil_QMARK_)) {
      return this__6562.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6562.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6562.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6563 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6564 = this__6563.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6564)) {
        return v === this__6563.nil_val
      }else {
        return and__3546__auto____6564
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6563.meta, cljs.core.truth_(this__6563.has_nil_QMARK_) ? this__6563.cnt : this__6563.cnt + 1, this__6563.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6565 = [false];
    var new_root__6566 = (this__6563.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6563.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6565);
    if(new_root__6566 === this__6563.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6563.meta, cljs.core.truth_(added_leaf_QMARK___6565[0]) ? this__6563.cnt + 1 : this__6563.cnt, new_root__6566, this__6563.has_nil_QMARK_, this__6563.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6567 = this;
  if(k == null) {
    return this__6567.has_nil_QMARK_
  }else {
    if(this__6567.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6567.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6588 = null;
  var G__6588__2 = function(tsym6555, k) {
    var this__6568 = this;
    var tsym6555__6569 = this;
    var coll__6570 = tsym6555__6569;
    return cljs.core._lookup.call(null, coll__6570, k)
  };
  var G__6588__3 = function(tsym6556, k, not_found) {
    var this__6571 = this;
    var tsym6556__6572 = this;
    var coll__6573 = tsym6556__6572;
    return cljs.core._lookup.call(null, coll__6573, k, not_found)
  };
  G__6588 = function(tsym6556, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6588__2.call(this, tsym6556, k);
      case 3:
        return G__6588__3.call(this, tsym6556, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6588
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6553, args6554) {
  return tsym6553.call.apply(tsym6553, [tsym6553].concat(cljs.core.aclone.call(null, args6554)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6574 = this;
  var init__6575 = cljs.core.truth_(this__6574.has_nil_QMARK_) ? f.call(null, init, null, this__6574.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6575)) {
    return cljs.core.deref.call(null, init__6575)
  }else {
    if(null != this__6574.root) {
      return this__6574.root.kv_reduce(f, init__6575)
    }else {
      if("\ufdd0'else") {
        return init__6575
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6576 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6577 = this;
  var this$__6578 = this;
  return cljs.core.pr_str.call(null, this$__6578)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6579 = this;
  if(this__6579.cnt > 0) {
    var s__6580 = null != this__6579.root ? this__6579.root.inode_seq() : null;
    if(cljs.core.truth_(this__6579.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6579.nil_val]), s__6580)
    }else {
      return s__6580
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6581 = this;
  return this__6581.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6582 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6583 = this;
  return new cljs.core.PersistentHashMap(meta, this__6583.cnt, this__6583.root, this__6583.has_nil_QMARK_, this__6583.nil_val, this__6583.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6584 = this;
  return this__6584.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6585 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6585.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6586 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6586.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6586.meta, this__6586.cnt - 1, this__6586.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6586.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6587 = this__6586.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6587 === this__6586.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6586.meta, this__6586.cnt - 1, new_root__6587, this__6586.has_nil_QMARK_, this__6586.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6589 = ks.length;
  var i__6590 = 0;
  var out__6591 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6590 < len__6589) {
      var G__6592 = i__6590 + 1;
      var G__6593 = cljs.core.assoc_BANG_.call(null, out__6591, ks[i__6590], vs[i__6590]);
      i__6590 = G__6592;
      out__6591 = G__6593;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6591)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6594 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6595 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6596 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6597 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6598 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6598.has_nil_QMARK_)) {
      return this__6598.nil_val
    }else {
      return null
    }
  }else {
    if(this__6598.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6598.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6599 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6599.has_nil_QMARK_)) {
      return this__6599.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6599.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6599.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6600 = this;
  if(cljs.core.truth_(this__6600.edit)) {
    return this__6600.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6601 = this;
  var tcoll__6602 = this;
  if(cljs.core.truth_(this__6601.edit)) {
    if(function() {
      var G__6603__6604 = o;
      if(G__6603__6604 != null) {
        if(function() {
          var or__3548__auto____6605 = G__6603__6604.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6605) {
            return or__3548__auto____6605
          }else {
            return G__6603__6604.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6603__6604.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6603__6604)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6603__6604)
      }
    }()) {
      return tcoll__6602.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6606 = cljs.core.seq.call(null, o);
      var tcoll__6607 = tcoll__6602;
      while(true) {
        var temp__3695__auto____6608 = cljs.core.first.call(null, es__6606);
        if(cljs.core.truth_(temp__3695__auto____6608)) {
          var e__6609 = temp__3695__auto____6608;
          var G__6620 = cljs.core.next.call(null, es__6606);
          var G__6621 = tcoll__6607.assoc_BANG_(cljs.core.key.call(null, e__6609), cljs.core.val.call(null, e__6609));
          es__6606 = G__6620;
          tcoll__6607 = G__6621;
          continue
        }else {
          return tcoll__6607
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6610 = this;
  var tcoll__6611 = this;
  if(cljs.core.truth_(this__6610.edit)) {
    if(k == null) {
      if(this__6610.nil_val === v) {
      }else {
        this__6610.nil_val = v
      }
      if(cljs.core.truth_(this__6610.has_nil_QMARK_)) {
      }else {
        this__6610.count = this__6610.count + 1;
        this__6610.has_nil_QMARK_ = true
      }
      return tcoll__6611
    }else {
      var added_leaf_QMARK___6612 = [false];
      var node__6613 = (this__6610.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6610.root).inode_assoc_BANG_(this__6610.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6612);
      if(node__6613 === this__6610.root) {
      }else {
        this__6610.root = node__6613
      }
      if(cljs.core.truth_(added_leaf_QMARK___6612[0])) {
        this__6610.count = this__6610.count + 1
      }else {
      }
      return tcoll__6611
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6614 = this;
  var tcoll__6615 = this;
  if(cljs.core.truth_(this__6614.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6614.has_nil_QMARK_)) {
        this__6614.has_nil_QMARK_ = false;
        this__6614.nil_val = null;
        this__6614.count = this__6614.count - 1;
        return tcoll__6615
      }else {
        return tcoll__6615
      }
    }else {
      if(this__6614.root == null) {
        return tcoll__6615
      }else {
        var removed_leaf_QMARK___6616 = [false];
        var node__6617 = this__6614.root.inode_without_BANG_(this__6614.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6616);
        if(node__6617 === this__6614.root) {
        }else {
          this__6614.root = node__6617
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6616[0])) {
          this__6614.count = this__6614.count - 1
        }else {
        }
        return tcoll__6615
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6618 = this;
  var tcoll__6619 = this;
  if(cljs.core.truth_(this__6618.edit)) {
    this__6618.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6618.count, this__6618.root, this__6618.has_nil_QMARK_, this__6618.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6622 = node;
  var stack__6623 = stack;
  while(true) {
    if(t__6622 != null) {
      var G__6624 = cljs.core.truth_(ascending_QMARK_) ? t__6622.left : t__6622.right;
      var G__6625 = cljs.core.conj.call(null, stack__6623, t__6622);
      t__6622 = G__6624;
      stack__6623 = G__6625;
      continue
    }else {
      return stack__6623
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6626 = this;
  var h__364__auto____6627 = this__6626.__hash;
  if(h__364__auto____6627 != null) {
    return h__364__auto____6627
  }else {
    var h__364__auto____6628 = cljs.core.hash_coll.call(null, coll);
    this__6626.__hash = h__364__auto____6628;
    return h__364__auto____6628
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6629 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6630 = this;
  var this$__6631 = this;
  return cljs.core.pr_str.call(null, this$__6631)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6632 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6633 = this;
  if(this__6633.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6633.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6634 = this;
  return cljs.core.peek.call(null, this__6634.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6635 = this;
  var t__6636 = cljs.core.peek.call(null, this__6635.stack);
  var next_stack__6637 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6635.ascending_QMARK_) ? t__6636.right : t__6636.left, cljs.core.pop.call(null, this__6635.stack), this__6635.ascending_QMARK_);
  if(next_stack__6637 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6637, this__6635.ascending_QMARK_, this__6635.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6638 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6639 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6639.stack, this__6639.ascending_QMARK_, this__6639.cnt, this__6639.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6640 = this;
  return this__6640.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6641 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6641) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6641
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6642 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6642) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6642
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6643 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6643)) {
    return cljs.core.deref.call(null, init__6643)
  }else {
    var init__6644 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6643) : init__6643;
    if(cljs.core.reduced_QMARK_.call(null, init__6644)) {
      return cljs.core.deref.call(null, init__6644)
    }else {
      var init__6645 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6644) : init__6644;
      if(cljs.core.reduced_QMARK_.call(null, init__6645)) {
        return cljs.core.deref.call(null, init__6645)
      }else {
        return init__6645
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6650 = this;
  var h__364__auto____6651 = this__6650.__hash;
  if(h__364__auto____6651 != null) {
    return h__364__auto____6651
  }else {
    var h__364__auto____6652 = cljs.core.hash_coll.call(null, coll);
    this__6650.__hash = h__364__auto____6652;
    return h__364__auto____6652
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6653 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6654 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6655 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6655.key, this__6655.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6702 = null;
  var G__6702__2 = function(tsym6648, k) {
    var this__6656 = this;
    var tsym6648__6657 = this;
    var node__6658 = tsym6648__6657;
    return cljs.core._lookup.call(null, node__6658, k)
  };
  var G__6702__3 = function(tsym6649, k, not_found) {
    var this__6659 = this;
    var tsym6649__6660 = this;
    var node__6661 = tsym6649__6660;
    return cljs.core._lookup.call(null, node__6661, k, not_found)
  };
  G__6702 = function(tsym6649, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6702__2.call(this, tsym6649, k);
      case 3:
        return G__6702__3.call(this, tsym6649, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6702
}();
cljs.core.BlackNode.prototype.apply = function(tsym6646, args6647) {
  return tsym6646.call.apply(tsym6646, [tsym6646].concat(cljs.core.aclone.call(null, args6647)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6662 = this;
  return cljs.core.PersistentVector.fromArray([this__6662.key, this__6662.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6663 = this;
  return this__6663.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6664 = this;
  return this__6664.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6665 = this;
  var node__6666 = this;
  return ins.balance_right(node__6666)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6667 = this;
  var node__6668 = this;
  return new cljs.core.RedNode(this__6667.key, this__6667.val, this__6667.left, this__6667.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6669 = this;
  var node__6670 = this;
  return cljs.core.balance_right_del.call(null, this__6669.key, this__6669.val, this__6669.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6671 = this;
  var node__6672 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6673 = this;
  var node__6674 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6674, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6675 = this;
  var node__6676 = this;
  return cljs.core.balance_left_del.call(null, this__6675.key, this__6675.val, del, this__6675.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6677 = this;
  var node__6678 = this;
  return ins.balance_left(node__6678)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6679 = this;
  var node__6680 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6680, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6703 = null;
  var G__6703__0 = function() {
    var this__6683 = this;
    var this$__6684 = this;
    return cljs.core.pr_str.call(null, this$__6684)
  };
  G__6703 = function() {
    switch(arguments.length) {
      case 0:
        return G__6703__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6703
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6685 = this;
  var node__6686 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6686, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6687 = this;
  var node__6688 = this;
  return node__6688
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6689 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6690 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6691 = this;
  return cljs.core.list.call(null, this__6691.key, this__6691.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6693 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6694 = this;
  return this__6694.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6695 = this;
  return cljs.core.PersistentVector.fromArray([this__6695.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6696 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6696.key, this__6696.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6697 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6698 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6698.key, this__6698.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6699 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6700 = this;
  if(n === 0) {
    return this__6700.key
  }else {
    if(n === 1) {
      return this__6700.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6701 = this;
  if(n === 0) {
    return this__6701.key
  }else {
    if(n === 1) {
      return this__6701.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6692 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6708 = this;
  var h__364__auto____6709 = this__6708.__hash;
  if(h__364__auto____6709 != null) {
    return h__364__auto____6709
  }else {
    var h__364__auto____6710 = cljs.core.hash_coll.call(null, coll);
    this__6708.__hash = h__364__auto____6710;
    return h__364__auto____6710
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6711 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6712 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6713 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6713.key, this__6713.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6760 = null;
  var G__6760__2 = function(tsym6706, k) {
    var this__6714 = this;
    var tsym6706__6715 = this;
    var node__6716 = tsym6706__6715;
    return cljs.core._lookup.call(null, node__6716, k)
  };
  var G__6760__3 = function(tsym6707, k, not_found) {
    var this__6717 = this;
    var tsym6707__6718 = this;
    var node__6719 = tsym6707__6718;
    return cljs.core._lookup.call(null, node__6719, k, not_found)
  };
  G__6760 = function(tsym6707, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6760__2.call(this, tsym6707, k);
      case 3:
        return G__6760__3.call(this, tsym6707, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6760
}();
cljs.core.RedNode.prototype.apply = function(tsym6704, args6705) {
  return tsym6704.call.apply(tsym6704, [tsym6704].concat(cljs.core.aclone.call(null, args6705)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6720 = this;
  return cljs.core.PersistentVector.fromArray([this__6720.key, this__6720.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6721 = this;
  return this__6721.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6722 = this;
  return this__6722.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6723 = this;
  var node__6724 = this;
  return new cljs.core.RedNode(this__6723.key, this__6723.val, this__6723.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6725 = this;
  var node__6726 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6727 = this;
  var node__6728 = this;
  return new cljs.core.RedNode(this__6727.key, this__6727.val, this__6727.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6729 = this;
  var node__6730 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6731 = this;
  var node__6732 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6732, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6733 = this;
  var node__6734 = this;
  return new cljs.core.RedNode(this__6733.key, this__6733.val, del, this__6733.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6735 = this;
  var node__6736 = this;
  return new cljs.core.RedNode(this__6735.key, this__6735.val, ins, this__6735.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6737 = this;
  var node__6738 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6737.left)) {
    return new cljs.core.RedNode(this__6737.key, this__6737.val, this__6737.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6737.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6737.right)) {
      return new cljs.core.RedNode(this__6737.right.key, this__6737.right.val, new cljs.core.BlackNode(this__6737.key, this__6737.val, this__6737.left, this__6737.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6737.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6738, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6761 = null;
  var G__6761__0 = function() {
    var this__6741 = this;
    var this$__6742 = this;
    return cljs.core.pr_str.call(null, this$__6742)
  };
  G__6761 = function() {
    switch(arguments.length) {
      case 0:
        return G__6761__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6761
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6743 = this;
  var node__6744 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6743.right)) {
    return new cljs.core.RedNode(this__6743.key, this__6743.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6743.left, null), this__6743.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6743.left)) {
      return new cljs.core.RedNode(this__6743.left.key, this__6743.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6743.left.left, null), new cljs.core.BlackNode(this__6743.key, this__6743.val, this__6743.left.right, this__6743.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6744, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6745 = this;
  var node__6746 = this;
  return new cljs.core.BlackNode(this__6745.key, this__6745.val, this__6745.left, this__6745.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6747 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6748 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6749 = this;
  return cljs.core.list.call(null, this__6749.key, this__6749.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6751 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6752 = this;
  return this__6752.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6753 = this;
  return cljs.core.PersistentVector.fromArray([this__6753.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6754 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6754.key, this__6754.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6755 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6756 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6756.key, this__6756.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6757 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6758 = this;
  if(n === 0) {
    return this__6758.key
  }else {
    if(n === 1) {
      return this__6758.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6759 = this;
  if(n === 0) {
    return this__6759.key
  }else {
    if(n === 1) {
      return this__6759.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6750 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6762 = comp.call(null, k, tree.key);
    if(c__6762 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6762 < 0) {
        var ins__6763 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6763 != null) {
          return tree.add_left(ins__6763)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6764 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6764 != null) {
            return tree.add_right(ins__6764)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6765 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6765)) {
            return new cljs.core.RedNode(app__6765.key, app__6765.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6765.left), new cljs.core.RedNode(right.key, right.val, app__6765.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6765, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6766 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6766)) {
              return new cljs.core.RedNode(app__6766.key, app__6766.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6766.left, null), new cljs.core.BlackNode(right.key, right.val, app__6766.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6766, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6767 = comp.call(null, k, tree.key);
    if(c__6767 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6767 < 0) {
        var del__6768 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6769 = del__6768 != null;
          if(or__3548__auto____6769) {
            return or__3548__auto____6769
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6768, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6768, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6770 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6771 = del__6770 != null;
            if(or__3548__auto____6771) {
              return or__3548__auto____6771
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6770)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6770, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6772 = tree.key;
  var c__6773 = comp.call(null, k, tk__6772);
  if(c__6773 === 0) {
    return tree.replace(tk__6772, v, tree.left, tree.right)
  }else {
    if(c__6773 < 0) {
      return tree.replace(tk__6772, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6772, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6778 = this;
  var h__364__auto____6779 = this__6778.__hash;
  if(h__364__auto____6779 != null) {
    return h__364__auto____6779
  }else {
    var h__364__auto____6780 = cljs.core.hash_imap.call(null, coll);
    this__6778.__hash = h__364__auto____6780;
    return h__364__auto____6780
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6781 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6782 = this;
  var n__6783 = coll.entry_at(k);
  if(n__6783 != null) {
    return n__6783.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6784 = this;
  var found__6785 = [null];
  var t__6786 = cljs.core.tree_map_add.call(null, this__6784.comp, this__6784.tree, k, v, found__6785);
  if(t__6786 == null) {
    var found_node__6787 = cljs.core.nth.call(null, found__6785, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6787.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6784.comp, cljs.core.tree_map_replace.call(null, this__6784.comp, this__6784.tree, k, v), this__6784.cnt, this__6784.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6784.comp, t__6786.blacken(), this__6784.cnt + 1, this__6784.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6788 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6820 = null;
  var G__6820__2 = function(tsym6776, k) {
    var this__6789 = this;
    var tsym6776__6790 = this;
    var coll__6791 = tsym6776__6790;
    return cljs.core._lookup.call(null, coll__6791, k)
  };
  var G__6820__3 = function(tsym6777, k, not_found) {
    var this__6792 = this;
    var tsym6777__6793 = this;
    var coll__6794 = tsym6777__6793;
    return cljs.core._lookup.call(null, coll__6794, k, not_found)
  };
  G__6820 = function(tsym6777, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6820__2.call(this, tsym6777, k);
      case 3:
        return G__6820__3.call(this, tsym6777, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6820
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6774, args6775) {
  return tsym6774.call.apply(tsym6774, [tsym6774].concat(cljs.core.aclone.call(null, args6775)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6795 = this;
  if(this__6795.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6795.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6796 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6797 = this;
  if(this__6797.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6797.tree, false, this__6797.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6798 = this;
  var this$__6799 = this;
  return cljs.core.pr_str.call(null, this$__6799)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6800 = this;
  var coll__6801 = this;
  var t__6802 = this__6800.tree;
  while(true) {
    if(t__6802 != null) {
      var c__6803 = this__6800.comp.call(null, k, t__6802.key);
      if(c__6803 === 0) {
        return t__6802
      }else {
        if(c__6803 < 0) {
          var G__6821 = t__6802.left;
          t__6802 = G__6821;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6822 = t__6802.right;
            t__6802 = G__6822;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6804 = this;
  if(this__6804.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6804.tree, ascending_QMARK_, this__6804.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6805 = this;
  if(this__6805.cnt > 0) {
    var stack__6806 = null;
    var t__6807 = this__6805.tree;
    while(true) {
      if(t__6807 != null) {
        var c__6808 = this__6805.comp.call(null, k, t__6807.key);
        if(c__6808 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6806, t__6807), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6808 < 0) {
              var G__6823 = cljs.core.conj.call(null, stack__6806, t__6807);
              var G__6824 = t__6807.left;
              stack__6806 = G__6823;
              t__6807 = G__6824;
              continue
            }else {
              var G__6825 = stack__6806;
              var G__6826 = t__6807.right;
              stack__6806 = G__6825;
              t__6807 = G__6826;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6808 > 0) {
                var G__6827 = cljs.core.conj.call(null, stack__6806, t__6807);
                var G__6828 = t__6807.right;
                stack__6806 = G__6827;
                t__6807 = G__6828;
                continue
              }else {
                var G__6829 = stack__6806;
                var G__6830 = t__6807.left;
                stack__6806 = G__6829;
                t__6807 = G__6830;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6806 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6806, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6809 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6810 = this;
  return this__6810.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6811 = this;
  if(this__6811.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6811.tree, true, this__6811.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6812 = this;
  return this__6812.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6813 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6814 = this;
  return new cljs.core.PersistentTreeMap(this__6814.comp, this__6814.tree, this__6814.cnt, meta, this__6814.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6818 = this;
  return this__6818.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6819 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6819.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6815 = this;
  var found__6816 = [null];
  var t__6817 = cljs.core.tree_map_remove.call(null, this__6815.comp, this__6815.tree, k, found__6816);
  if(t__6817 == null) {
    if(cljs.core.nth.call(null, found__6816, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6815.comp, null, 0, this__6815.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6815.comp, t__6817.blacken(), this__6815.cnt - 1, this__6815.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6831 = cljs.core.seq.call(null, keyvals);
    var out__6832 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6831)) {
        var G__6833 = cljs.core.nnext.call(null, in$__6831);
        var G__6834 = cljs.core.assoc_BANG_.call(null, out__6832, cljs.core.first.call(null, in$__6831), cljs.core.second.call(null, in$__6831));
        in$__6831 = G__6833;
        out__6832 = G__6834;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6832)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6835) {
    var keyvals = cljs.core.seq(arglist__6835);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6836) {
    var keyvals = cljs.core.seq(arglist__6836);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6837 = cljs.core.seq.call(null, keyvals);
    var out__6838 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6837)) {
        var G__6839 = cljs.core.nnext.call(null, in$__6837);
        var G__6840 = cljs.core.assoc.call(null, out__6838, cljs.core.first.call(null, in$__6837), cljs.core.second.call(null, in$__6837));
        in$__6837 = G__6839;
        out__6838 = G__6840;
        continue
      }else {
        return out__6838
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6841) {
    var keyvals = cljs.core.seq(arglist__6841);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6842 = cljs.core.seq.call(null, keyvals);
    var out__6843 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6842)) {
        var G__6844 = cljs.core.nnext.call(null, in$__6842);
        var G__6845 = cljs.core.assoc.call(null, out__6843, cljs.core.first.call(null, in$__6842), cljs.core.second.call(null, in$__6842));
        in$__6842 = G__6844;
        out__6843 = G__6845;
        continue
      }else {
        return out__6843
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6846) {
    var comparator = cljs.core.first(arglist__6846);
    var keyvals = cljs.core.rest(arglist__6846);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6847_SHARP_, p2__6848_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6849 = p1__6847_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6849)) {
            return or__3548__auto____6849
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6848_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6850) {
    var maps = cljs.core.seq(arglist__6850);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6853 = function(m, e) {
        var k__6851 = cljs.core.first.call(null, e);
        var v__6852 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6851)) {
          return cljs.core.assoc.call(null, m, k__6851, f.call(null, cljs.core.get.call(null, m, k__6851), v__6852))
        }else {
          return cljs.core.assoc.call(null, m, k__6851, v__6852)
        }
      };
      var merge2__6855 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6853, function() {
          var or__3548__auto____6854 = m1;
          if(cljs.core.truth_(or__3548__auto____6854)) {
            return or__3548__auto____6854
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6855, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6856) {
    var f = cljs.core.first(arglist__6856);
    var maps = cljs.core.rest(arglist__6856);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6857 = cljs.core.ObjMap.fromObject([], {});
  var keys__6858 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6858)) {
      var key__6859 = cljs.core.first.call(null, keys__6858);
      var entry__6860 = cljs.core.get.call(null, map, key__6859, "\ufdd0'user/not-found");
      var G__6861 = cljs.core.not_EQ_.call(null, entry__6860, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6857, key__6859, entry__6860) : ret__6857;
      var G__6862 = cljs.core.next.call(null, keys__6858);
      ret__6857 = G__6861;
      keys__6858 = G__6862;
      continue
    }else {
      return ret__6857
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6868 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6868.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6869 = this;
  var h__364__auto____6870 = this__6869.__hash;
  if(h__364__auto____6870 != null) {
    return h__364__auto____6870
  }else {
    var h__364__auto____6871 = cljs.core.hash_iset.call(null, coll);
    this__6869.__hash = h__364__auto____6871;
    return h__364__auto____6871
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6872 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6873 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6873.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6892 = null;
  var G__6892__2 = function(tsym6866, k) {
    var this__6874 = this;
    var tsym6866__6875 = this;
    var coll__6876 = tsym6866__6875;
    return cljs.core._lookup.call(null, coll__6876, k)
  };
  var G__6892__3 = function(tsym6867, k, not_found) {
    var this__6877 = this;
    var tsym6867__6878 = this;
    var coll__6879 = tsym6867__6878;
    return cljs.core._lookup.call(null, coll__6879, k, not_found)
  };
  G__6892 = function(tsym6867, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6892__2.call(this, tsym6867, k);
      case 3:
        return G__6892__3.call(this, tsym6867, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6892
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6864, args6865) {
  return tsym6864.call.apply(tsym6864, [tsym6864].concat(cljs.core.aclone.call(null, args6865)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6880 = this;
  return new cljs.core.PersistentHashSet(this__6880.meta, cljs.core.assoc.call(null, this__6880.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6881 = this;
  var this$__6882 = this;
  return cljs.core.pr_str.call(null, this$__6882)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6883 = this;
  return cljs.core.keys.call(null, this__6883.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6884 = this;
  return new cljs.core.PersistentHashSet(this__6884.meta, cljs.core.dissoc.call(null, this__6884.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6885 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6886 = this;
  var and__3546__auto____6887 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6887) {
    var and__3546__auto____6888 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6888) {
      return cljs.core.every_QMARK_.call(null, function(p1__6863_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6863_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6888
    }
  }else {
    return and__3546__auto____6887
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6889 = this;
  return new cljs.core.PersistentHashSet(meta, this__6889.hash_map, this__6889.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6890 = this;
  return this__6890.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6891 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6891.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6910 = null;
  var G__6910__2 = function(tsym6896, k) {
    var this__6898 = this;
    var tsym6896__6899 = this;
    var tcoll__6900 = tsym6896__6899;
    if(cljs.core._lookup.call(null, this__6898.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6910__3 = function(tsym6897, k, not_found) {
    var this__6901 = this;
    var tsym6897__6902 = this;
    var tcoll__6903 = tsym6897__6902;
    if(cljs.core._lookup.call(null, this__6901.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6910 = function(tsym6897, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6910__2.call(this, tsym6897, k);
      case 3:
        return G__6910__3.call(this, tsym6897, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6910
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6894, args6895) {
  return tsym6894.call.apply(tsym6894, [tsym6894].concat(cljs.core.aclone.call(null, args6895)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6904 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6905 = this;
  if(cljs.core._lookup.call(null, this__6905.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6906 = this;
  return cljs.core.count.call(null, this__6906.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6907 = this;
  this__6907.transient_map = cljs.core.dissoc_BANG_.call(null, this__6907.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6908 = this;
  this__6908.transient_map = cljs.core.assoc_BANG_.call(null, this__6908.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6909 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6909.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6915 = this;
  var h__364__auto____6916 = this__6915.__hash;
  if(h__364__auto____6916 != null) {
    return h__364__auto____6916
  }else {
    var h__364__auto____6917 = cljs.core.hash_iset.call(null, coll);
    this__6915.__hash = h__364__auto____6917;
    return h__364__auto____6917
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6918 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6919 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6919.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6943 = null;
  var G__6943__2 = function(tsym6913, k) {
    var this__6920 = this;
    var tsym6913__6921 = this;
    var coll__6922 = tsym6913__6921;
    return cljs.core._lookup.call(null, coll__6922, k)
  };
  var G__6943__3 = function(tsym6914, k, not_found) {
    var this__6923 = this;
    var tsym6914__6924 = this;
    var coll__6925 = tsym6914__6924;
    return cljs.core._lookup.call(null, coll__6925, k, not_found)
  };
  G__6943 = function(tsym6914, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6943__2.call(this, tsym6914, k);
      case 3:
        return G__6943__3.call(this, tsym6914, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6943
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6911, args6912) {
  return tsym6911.call.apply(tsym6911, [tsym6911].concat(cljs.core.aclone.call(null, args6912)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6926 = this;
  return new cljs.core.PersistentTreeSet(this__6926.meta, cljs.core.assoc.call(null, this__6926.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6927 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6927.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6928 = this;
  var this$__6929 = this;
  return cljs.core.pr_str.call(null, this$__6929)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6930 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6930.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6931 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6931.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6932 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6933 = this;
  return cljs.core._comparator.call(null, this__6933.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6934 = this;
  return cljs.core.keys.call(null, this__6934.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6935 = this;
  return new cljs.core.PersistentTreeSet(this__6935.meta, cljs.core.dissoc.call(null, this__6935.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6936 = this;
  return cljs.core.count.call(null, this__6936.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6937 = this;
  var and__3546__auto____6938 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6938) {
    var and__3546__auto____6939 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6939) {
      return cljs.core.every_QMARK_.call(null, function(p1__6893_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6893_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6939
    }
  }else {
    return and__3546__auto____6938
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6940 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6940.tree_map, this__6940.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6941 = this;
  return this__6941.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6942 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6942.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6944 = cljs.core.seq.call(null, coll);
  var out__6945 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6944))) {
      var G__6946 = cljs.core.next.call(null, in$__6944);
      var G__6947 = cljs.core.conj_BANG_.call(null, out__6945, cljs.core.first.call(null, in$__6944));
      in$__6944 = G__6946;
      out__6945 = G__6947;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6945)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6948) {
    var keys = cljs.core.seq(arglist__6948);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6950) {
    var comparator = cljs.core.first(arglist__6950);
    var keys = cljs.core.rest(arglist__6950);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6951 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6952 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6952)) {
        var e__6953 = temp__3695__auto____6952;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6953))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6951, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6949_SHARP_) {
      var temp__3695__auto____6954 = cljs.core.find.call(null, smap, p1__6949_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6954)) {
        var e__6955 = temp__3695__auto____6954;
        return cljs.core.second.call(null, e__6955)
      }else {
        return p1__6949_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6963 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6956, seen) {
        while(true) {
          var vec__6957__6958 = p__6956;
          var f__6959 = cljs.core.nth.call(null, vec__6957__6958, 0, null);
          var xs__6960 = vec__6957__6958;
          var temp__3698__auto____6961 = cljs.core.seq.call(null, xs__6960);
          if(cljs.core.truth_(temp__3698__auto____6961)) {
            var s__6962 = temp__3698__auto____6961;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6959)) {
              var G__6964 = cljs.core.rest.call(null, s__6962);
              var G__6965 = seen;
              p__6956 = G__6964;
              seen = G__6965;
              continue
            }else {
              return cljs.core.cons.call(null, f__6959, step.call(null, cljs.core.rest.call(null, s__6962), cljs.core.conj.call(null, seen, f__6959)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6963.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6966 = cljs.core.PersistentVector.fromArray([]);
  var s__6967 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6967))) {
      var G__6968 = cljs.core.conj.call(null, ret__6966, cljs.core.first.call(null, s__6967));
      var G__6969 = cljs.core.next.call(null, s__6967);
      ret__6966 = G__6968;
      s__6967 = G__6969;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6966)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6970 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6970) {
        return or__3548__auto____6970
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6971 = x.lastIndexOf("/");
      if(i__6971 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6971 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6972 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6972) {
      return or__3548__auto____6972
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6973 = x.lastIndexOf("/");
    if(i__6973 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6973)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6976 = cljs.core.ObjMap.fromObject([], {});
  var ks__6977 = cljs.core.seq.call(null, keys);
  var vs__6978 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6979 = ks__6977;
      if(cljs.core.truth_(and__3546__auto____6979)) {
        return vs__6978
      }else {
        return and__3546__auto____6979
      }
    }())) {
      var G__6980 = cljs.core.assoc.call(null, map__6976, cljs.core.first.call(null, ks__6977), cljs.core.first.call(null, vs__6978));
      var G__6981 = cljs.core.next.call(null, ks__6977);
      var G__6982 = cljs.core.next.call(null, vs__6978);
      map__6976 = G__6980;
      ks__6977 = G__6981;
      vs__6978 = G__6982;
      continue
    }else {
      return map__6976
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6985__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6974_SHARP_, p2__6975_SHARP_) {
        return max_key.call(null, k, p1__6974_SHARP_, p2__6975_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6985 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6985__delegate.call(this, k, x, y, more)
    };
    G__6985.cljs$lang$maxFixedArity = 3;
    G__6985.cljs$lang$applyTo = function(arglist__6986) {
      var k = cljs.core.first(arglist__6986);
      var x = cljs.core.first(cljs.core.next(arglist__6986));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6986)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6986)));
      return G__6985__delegate(k, x, y, more)
    };
    G__6985.cljs$lang$arity$variadic = G__6985__delegate;
    return G__6985
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6987__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6983_SHARP_, p2__6984_SHARP_) {
        return min_key.call(null, k, p1__6983_SHARP_, p2__6984_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6987 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6987__delegate.call(this, k, x, y, more)
    };
    G__6987.cljs$lang$maxFixedArity = 3;
    G__6987.cljs$lang$applyTo = function(arglist__6988) {
      var k = cljs.core.first(arglist__6988);
      var x = cljs.core.first(cljs.core.next(arglist__6988));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6988)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6988)));
      return G__6987__delegate(k, x, y, more)
    };
    G__6987.cljs$lang$arity$variadic = G__6987__delegate;
    return G__6987
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6989 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6989)) {
        var s__6990 = temp__3698__auto____6989;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6990), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6990)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6991 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6991)) {
      var s__6992 = temp__3698__auto____6991;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6992)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6992), take_while.call(null, pred, cljs.core.rest.call(null, s__6992)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6993 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6993.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6994 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6995 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6995)) {
        var vec__6996__6997 = temp__3698__auto____6995;
        var e__6998 = cljs.core.nth.call(null, vec__6996__6997, 0, null);
        var s__6999 = vec__6996__6997;
        if(cljs.core.truth_(include__6994.call(null, e__6998))) {
          return s__6999
        }else {
          return cljs.core.next.call(null, s__6999)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6994, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7000 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____7000)) {
      var vec__7001__7002 = temp__3698__auto____7000;
      var e__7003 = cljs.core.nth.call(null, vec__7001__7002, 0, null);
      var s__7004 = vec__7001__7002;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__7003)) ? s__7004 : cljs.core.next.call(null, s__7004))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__7005 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____7006 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____7006)) {
        var vec__7007__7008 = temp__3698__auto____7006;
        var e__7009 = cljs.core.nth.call(null, vec__7007__7008, 0, null);
        var s__7010 = vec__7007__7008;
        if(cljs.core.truth_(include__7005.call(null, e__7009))) {
          return s__7010
        }else {
          return cljs.core.next.call(null, s__7010)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__7005, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7011 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____7011)) {
      var vec__7012__7013 = temp__3698__auto____7011;
      var e__7014 = cljs.core.nth.call(null, vec__7012__7013, 0, null);
      var s__7015 = vec__7012__7013;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__7014)) ? s__7015 : cljs.core.next.call(null, s__7015))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__7016 = this;
  var h__364__auto____7017 = this__7016.__hash;
  if(h__364__auto____7017 != null) {
    return h__364__auto____7017
  }else {
    var h__364__auto____7018 = cljs.core.hash_coll.call(null, rng);
    this__7016.__hash = h__364__auto____7018;
    return h__364__auto____7018
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__7019 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__7020 = this;
  var this$__7021 = this;
  return cljs.core.pr_str.call(null, this$__7021)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__7022 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__7023 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__7024 = this;
  var comp__7025 = this__7024.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__7025.call(null, this__7024.start, this__7024.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__7026 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__7026.end - this__7026.start) / this__7026.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__7027 = this;
  return this__7027.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__7028 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__7028.meta, this__7028.start + this__7028.step, this__7028.end, this__7028.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__7029 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__7030 = this;
  return new cljs.core.Range(meta, this__7030.start, this__7030.end, this__7030.step, this__7030.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__7031 = this;
  return this__7031.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__7032 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7032.start + n * this__7032.step
  }else {
    if(function() {
      var and__3546__auto____7033 = this__7032.start > this__7032.end;
      if(and__3546__auto____7033) {
        return this__7032.step === 0
      }else {
        return and__3546__auto____7033
      }
    }()) {
      return this__7032.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__7034 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7034.start + n * this__7034.step
  }else {
    if(function() {
      var and__3546__auto____7035 = this__7034.start > this__7034.end;
      if(and__3546__auto____7035) {
        return this__7034.step === 0
      }else {
        return and__3546__auto____7035
      }
    }()) {
      return this__7034.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__7036 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7036.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7037 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7037)) {
      var s__7038 = temp__3698__auto____7037;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__7038), take_nth.call(null, n, cljs.core.drop.call(null, n, s__7038)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7040 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7040)) {
      var s__7041 = temp__3698__auto____7040;
      var fst__7042 = cljs.core.first.call(null, s__7041);
      var fv__7043 = f.call(null, fst__7042);
      var run__7044 = cljs.core.cons.call(null, fst__7042, cljs.core.take_while.call(null, function(p1__7039_SHARP_) {
        return cljs.core._EQ_.call(null, fv__7043, f.call(null, p1__7039_SHARP_))
      }, cljs.core.next.call(null, s__7041)));
      return cljs.core.cons.call(null, run__7044, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__7044), s__7041))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____7055 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____7055)) {
        var s__7056 = temp__3695__auto____7055;
        return reductions.call(null, f, cljs.core.first.call(null, s__7056), cljs.core.rest.call(null, s__7056))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____7057 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____7057)) {
        var s__7058 = temp__3698__auto____7057;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__7058)), cljs.core.rest.call(null, s__7058))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__7060 = null;
      var G__7060__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__7060__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__7060__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__7060__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__7060__4 = function() {
        var G__7061__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__7061 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7061__delegate.call(this, x, y, z, args)
        };
        G__7061.cljs$lang$maxFixedArity = 3;
        G__7061.cljs$lang$applyTo = function(arglist__7062) {
          var x = cljs.core.first(arglist__7062);
          var y = cljs.core.first(cljs.core.next(arglist__7062));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7062)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7062)));
          return G__7061__delegate(x, y, z, args)
        };
        G__7061.cljs$lang$arity$variadic = G__7061__delegate;
        return G__7061
      }();
      G__7060 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7060__0.call(this);
          case 1:
            return G__7060__1.call(this, x);
          case 2:
            return G__7060__2.call(this, x, y);
          case 3:
            return G__7060__3.call(this, x, y, z);
          default:
            return G__7060__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7060.cljs$lang$maxFixedArity = 3;
      G__7060.cljs$lang$applyTo = G__7060__4.cljs$lang$applyTo;
      return G__7060
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__7063 = null;
      var G__7063__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__7063__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__7063__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__7063__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__7063__4 = function() {
        var G__7064__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__7064 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7064__delegate.call(this, x, y, z, args)
        };
        G__7064.cljs$lang$maxFixedArity = 3;
        G__7064.cljs$lang$applyTo = function(arglist__7065) {
          var x = cljs.core.first(arglist__7065);
          var y = cljs.core.first(cljs.core.next(arglist__7065));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7065)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7065)));
          return G__7064__delegate(x, y, z, args)
        };
        G__7064.cljs$lang$arity$variadic = G__7064__delegate;
        return G__7064
      }();
      G__7063 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7063__0.call(this);
          case 1:
            return G__7063__1.call(this, x);
          case 2:
            return G__7063__2.call(this, x, y);
          case 3:
            return G__7063__3.call(this, x, y, z);
          default:
            return G__7063__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7063.cljs$lang$maxFixedArity = 3;
      G__7063.cljs$lang$applyTo = G__7063__4.cljs$lang$applyTo;
      return G__7063
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__7066 = null;
      var G__7066__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__7066__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__7066__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__7066__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__7066__4 = function() {
        var G__7067__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__7067 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7067__delegate.call(this, x, y, z, args)
        };
        G__7067.cljs$lang$maxFixedArity = 3;
        G__7067.cljs$lang$applyTo = function(arglist__7068) {
          var x = cljs.core.first(arglist__7068);
          var y = cljs.core.first(cljs.core.next(arglist__7068));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7068)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7068)));
          return G__7067__delegate(x, y, z, args)
        };
        G__7067.cljs$lang$arity$variadic = G__7067__delegate;
        return G__7067
      }();
      G__7066 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7066__0.call(this);
          case 1:
            return G__7066__1.call(this, x);
          case 2:
            return G__7066__2.call(this, x, y);
          case 3:
            return G__7066__3.call(this, x, y, z);
          default:
            return G__7066__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7066.cljs$lang$maxFixedArity = 3;
      G__7066.cljs$lang$applyTo = G__7066__4.cljs$lang$applyTo;
      return G__7066
    }()
  };
  var juxt__4 = function() {
    var G__7069__delegate = function(f, g, h, fs) {
      var fs__7059 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__7070 = null;
        var G__7070__0 = function() {
          return cljs.core.reduce.call(null, function(p1__7045_SHARP_, p2__7046_SHARP_) {
            return cljs.core.conj.call(null, p1__7045_SHARP_, p2__7046_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__7059)
        };
        var G__7070__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__7047_SHARP_, p2__7048_SHARP_) {
            return cljs.core.conj.call(null, p1__7047_SHARP_, p2__7048_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__7059)
        };
        var G__7070__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__7049_SHARP_, p2__7050_SHARP_) {
            return cljs.core.conj.call(null, p1__7049_SHARP_, p2__7050_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__7059)
        };
        var G__7070__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__7051_SHARP_, p2__7052_SHARP_) {
            return cljs.core.conj.call(null, p1__7051_SHARP_, p2__7052_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__7059)
        };
        var G__7070__4 = function() {
          var G__7071__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__7053_SHARP_, p2__7054_SHARP_) {
              return cljs.core.conj.call(null, p1__7053_SHARP_, cljs.core.apply.call(null, p2__7054_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__7059)
          };
          var G__7071 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__7071__delegate.call(this, x, y, z, args)
          };
          G__7071.cljs$lang$maxFixedArity = 3;
          G__7071.cljs$lang$applyTo = function(arglist__7072) {
            var x = cljs.core.first(arglist__7072);
            var y = cljs.core.first(cljs.core.next(arglist__7072));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7072)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7072)));
            return G__7071__delegate(x, y, z, args)
          };
          G__7071.cljs$lang$arity$variadic = G__7071__delegate;
          return G__7071
        }();
        G__7070 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__7070__0.call(this);
            case 1:
              return G__7070__1.call(this, x);
            case 2:
              return G__7070__2.call(this, x, y);
            case 3:
              return G__7070__3.call(this, x, y, z);
            default:
              return G__7070__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__7070.cljs$lang$maxFixedArity = 3;
        G__7070.cljs$lang$applyTo = G__7070__4.cljs$lang$applyTo;
        return G__7070
      }()
    };
    var G__7069 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7069__delegate.call(this, f, g, h, fs)
    };
    G__7069.cljs$lang$maxFixedArity = 3;
    G__7069.cljs$lang$applyTo = function(arglist__7073) {
      var f = cljs.core.first(arglist__7073);
      var g = cljs.core.first(cljs.core.next(arglist__7073));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7073)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7073)));
      return G__7069__delegate(f, g, h, fs)
    };
    G__7069.cljs$lang$arity$variadic = G__7069__delegate;
    return G__7069
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__7075 = cljs.core.next.call(null, coll);
        coll = G__7075;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____7074 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____7074)) {
          return n > 0
        }else {
          return and__3546__auto____7074
        }
      }())) {
        var G__7076 = n - 1;
        var G__7077 = cljs.core.next.call(null, coll);
        n = G__7076;
        coll = G__7077;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__7078 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__7078), s)) {
    if(cljs.core.count.call(null, matches__7078) === 1) {
      return cljs.core.first.call(null, matches__7078)
    }else {
      return cljs.core.vec.call(null, matches__7078)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__7079 = re.exec(s);
  if(matches__7079 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__7079) === 1) {
      return cljs.core.first.call(null, matches__7079)
    }else {
      return cljs.core.vec.call(null, matches__7079)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__7080 = cljs.core.re_find.call(null, re, s);
  var match_idx__7081 = s.search(re);
  var match_str__7082 = cljs.core.coll_QMARK_.call(null, match_data__7080) ? cljs.core.first.call(null, match_data__7080) : match_data__7080;
  var post_match__7083 = cljs.core.subs.call(null, s, match_idx__7081 + cljs.core.count.call(null, match_str__7082));
  if(cljs.core.truth_(match_data__7080)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__7080, re_seq.call(null, re, post_match__7083))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__7085__7086 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___7087 = cljs.core.nth.call(null, vec__7085__7086, 0, null);
  var flags__7088 = cljs.core.nth.call(null, vec__7085__7086, 1, null);
  var pattern__7089 = cljs.core.nth.call(null, vec__7085__7086, 2, null);
  return new RegExp(pattern__7089, flags__7088)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__7084_SHARP_) {
    return print_one.call(null, p1__7084_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____7090 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____7090)) {
            var and__3546__auto____7094 = function() {
              var G__7091__7092 = obj;
              if(G__7091__7092 != null) {
                if(function() {
                  var or__3548__auto____7093 = G__7091__7092.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____7093) {
                    return or__3548__auto____7093
                  }else {
                    return G__7091__7092.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__7091__7092.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7091__7092)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7091__7092)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____7094)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____7094
            }
          }else {
            return and__3546__auto____7090
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____7095 = obj != null;
          if(and__3546__auto____7095) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____7095
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__7096__7097 = obj;
          if(G__7096__7097 != null) {
            if(function() {
              var or__3548__auto____7098 = G__7096__7097.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____7098) {
                return or__3548__auto____7098
              }else {
                return G__7096__7097.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__7096__7097.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7096__7097)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7096__7097)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__7099 = cljs.core.first.call(null, objs);
  var sb__7100 = new goog.string.StringBuffer;
  var G__7101__7102 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7101__7102)) {
    var obj__7103 = cljs.core.first.call(null, G__7101__7102);
    var G__7101__7104 = G__7101__7102;
    while(true) {
      if(obj__7103 === first_obj__7099) {
      }else {
        sb__7100.append(" ")
      }
      var G__7105__7106 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7103, opts));
      if(cljs.core.truth_(G__7105__7106)) {
        var string__7107 = cljs.core.first.call(null, G__7105__7106);
        var G__7105__7108 = G__7105__7106;
        while(true) {
          sb__7100.append(string__7107);
          var temp__3698__auto____7109 = cljs.core.next.call(null, G__7105__7108);
          if(cljs.core.truth_(temp__3698__auto____7109)) {
            var G__7105__7110 = temp__3698__auto____7109;
            var G__7113 = cljs.core.first.call(null, G__7105__7110);
            var G__7114 = G__7105__7110;
            string__7107 = G__7113;
            G__7105__7108 = G__7114;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7111 = cljs.core.next.call(null, G__7101__7104);
      if(cljs.core.truth_(temp__3698__auto____7111)) {
        var G__7101__7112 = temp__3698__auto____7111;
        var G__7115 = cljs.core.first.call(null, G__7101__7112);
        var G__7116 = G__7101__7112;
        obj__7103 = G__7115;
        G__7101__7104 = G__7116;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__7100
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__7117 = cljs.core.pr_sb.call(null, objs, opts);
  sb__7117.append("\n");
  return[cljs.core.str(sb__7117)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__7118 = cljs.core.first.call(null, objs);
  var G__7119__7120 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7119__7120)) {
    var obj__7121 = cljs.core.first.call(null, G__7119__7120);
    var G__7119__7122 = G__7119__7120;
    while(true) {
      if(obj__7121 === first_obj__7118) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__7123__7124 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7121, opts));
      if(cljs.core.truth_(G__7123__7124)) {
        var string__7125 = cljs.core.first.call(null, G__7123__7124);
        var G__7123__7126 = G__7123__7124;
        while(true) {
          cljs.core.string_print.call(null, string__7125);
          var temp__3698__auto____7127 = cljs.core.next.call(null, G__7123__7126);
          if(cljs.core.truth_(temp__3698__auto____7127)) {
            var G__7123__7128 = temp__3698__auto____7127;
            var G__7131 = cljs.core.first.call(null, G__7123__7128);
            var G__7132 = G__7123__7128;
            string__7125 = G__7131;
            G__7123__7126 = G__7132;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7129 = cljs.core.next.call(null, G__7119__7122);
      if(cljs.core.truth_(temp__3698__auto____7129)) {
        var G__7119__7130 = temp__3698__auto____7129;
        var G__7133 = cljs.core.first.call(null, G__7119__7130);
        var G__7134 = G__7119__7130;
        obj__7121 = G__7133;
        G__7119__7122 = G__7134;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__7135) {
    var objs = cljs.core.seq(arglist__7135);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__7136) {
    var objs = cljs.core.seq(arglist__7136);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__7137) {
    var objs = cljs.core.seq(arglist__7137);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__7138) {
    var objs = cljs.core.seq(arglist__7138);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__7139) {
    var objs = cljs.core.seq(arglist__7139);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__7140) {
    var objs = cljs.core.seq(arglist__7140);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__7141) {
    var objs = cljs.core.seq(arglist__7141);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__7142) {
    var objs = cljs.core.seq(arglist__7142);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7143 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7143, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7144 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7144, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7145 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7145, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____7146 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____7146)) {
        var nspc__7147 = temp__3698__auto____7146;
        return[cljs.core.str(nspc__7147), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____7148 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____7148)) {
          var nspc__7149 = temp__3698__auto____7148;
          return[cljs.core.str(nspc__7149), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7150 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7150, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7151 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7151, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7152 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__7153 = this;
  var G__7154__7155 = cljs.core.seq.call(null, this__7153.watches);
  if(cljs.core.truth_(G__7154__7155)) {
    var G__7157__7159 = cljs.core.first.call(null, G__7154__7155);
    var vec__7158__7160 = G__7157__7159;
    var key__7161 = cljs.core.nth.call(null, vec__7158__7160, 0, null);
    var f__7162 = cljs.core.nth.call(null, vec__7158__7160, 1, null);
    var G__7154__7163 = G__7154__7155;
    var G__7157__7164 = G__7157__7159;
    var G__7154__7165 = G__7154__7163;
    while(true) {
      var vec__7166__7167 = G__7157__7164;
      var key__7168 = cljs.core.nth.call(null, vec__7166__7167, 0, null);
      var f__7169 = cljs.core.nth.call(null, vec__7166__7167, 1, null);
      var G__7154__7170 = G__7154__7165;
      f__7169.call(null, key__7168, this$, oldval, newval);
      var temp__3698__auto____7171 = cljs.core.next.call(null, G__7154__7170);
      if(cljs.core.truth_(temp__3698__auto____7171)) {
        var G__7154__7172 = temp__3698__auto____7171;
        var G__7179 = cljs.core.first.call(null, G__7154__7172);
        var G__7180 = G__7154__7172;
        G__7157__7164 = G__7179;
        G__7154__7165 = G__7180;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__7173 = this;
  return this$.watches = cljs.core.assoc.call(null, this__7173.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__7174 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__7174.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__7175 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__7175.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__7176 = this;
  return this__7176.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7177 = this;
  return this__7177.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__7178 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7187__delegate = function(x, p__7181) {
      var map__7182__7183 = p__7181;
      var map__7182__7184 = cljs.core.seq_QMARK_.call(null, map__7182__7183) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7182__7183) : map__7182__7183;
      var validator__7185 = cljs.core.get.call(null, map__7182__7184, "\ufdd0'validator");
      var meta__7186 = cljs.core.get.call(null, map__7182__7184, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7186, validator__7185, null)
    };
    var G__7187 = function(x, var_args) {
      var p__7181 = null;
      if(goog.isDef(var_args)) {
        p__7181 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7187__delegate.call(this, x, p__7181)
    };
    G__7187.cljs$lang$maxFixedArity = 1;
    G__7187.cljs$lang$applyTo = function(arglist__7188) {
      var x = cljs.core.first(arglist__7188);
      var p__7181 = cljs.core.rest(arglist__7188);
      return G__7187__delegate(x, p__7181)
    };
    G__7187.cljs$lang$arity$variadic = G__7187__delegate;
    return G__7187
  }();
  atom = function(x, var_args) {
    var p__7181 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7189 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7189)) {
    var validate__7190 = temp__3698__auto____7189;
    if(cljs.core.truth_(validate__7190.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7191 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7191, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7192__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7192 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7192__delegate.call(this, a, f, x, y, z, more)
    };
    G__7192.cljs$lang$maxFixedArity = 5;
    G__7192.cljs$lang$applyTo = function(arglist__7193) {
      var a = cljs.core.first(arglist__7193);
      var f = cljs.core.first(cljs.core.next(arglist__7193));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7193)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7193))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7193)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7193)))));
      return G__7192__delegate(a, f, x, y, z, more)
    };
    G__7192.cljs$lang$arity$variadic = G__7192__delegate;
    return G__7192
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7194) {
    var iref = cljs.core.first(arglist__7194);
    var f = cljs.core.first(cljs.core.next(arglist__7194));
    var args = cljs.core.rest(cljs.core.next(arglist__7194));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7195 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7195.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7196 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7196.state, function(p__7197) {
    var curr_state__7198 = p__7197;
    var curr_state__7199 = cljs.core.seq_QMARK_.call(null, curr_state__7198) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7198) : curr_state__7198;
    var done__7200 = cljs.core.get.call(null, curr_state__7199, "\ufdd0'done");
    if(cljs.core.truth_(done__7200)) {
      return curr_state__7199
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7196.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7201__7202 = options;
    var map__7201__7203 = cljs.core.seq_QMARK_.call(null, map__7201__7202) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7201__7202) : map__7201__7202;
    var keywordize_keys__7204 = cljs.core.get.call(null, map__7201__7203, "\ufdd0'keywordize-keys");
    var keyfn__7205 = cljs.core.truth_(keywordize_keys__7204) ? cljs.core.keyword : cljs.core.str;
    var f__7211 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7210 = function iter__7206(s__7207) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7207__7208 = s__7207;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7207__7208))) {
                        var k__7209 = cljs.core.first.call(null, s__7207__7208);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7205.call(null, k__7209), thisfn.call(null, x[k__7209])]), iter__7206.call(null, cljs.core.rest.call(null, s__7207__7208)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7210.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7211.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7212) {
    var x = cljs.core.first(arglist__7212);
    var options = cljs.core.rest(arglist__7212);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7213 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7217__delegate = function(args) {
      var temp__3695__auto____7214 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7213), args);
      if(cljs.core.truth_(temp__3695__auto____7214)) {
        var v__7215 = temp__3695__auto____7214;
        return v__7215
      }else {
        var ret__7216 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7213, cljs.core.assoc, args, ret__7216);
        return ret__7216
      }
    };
    var G__7217 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7217__delegate.call(this, args)
    };
    G__7217.cljs$lang$maxFixedArity = 0;
    G__7217.cljs$lang$applyTo = function(arglist__7218) {
      var args = cljs.core.seq(arglist__7218);
      return G__7217__delegate(args)
    };
    G__7217.cljs$lang$arity$variadic = G__7217__delegate;
    return G__7217
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7219 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7219)) {
        var G__7220 = ret__7219;
        f = G__7220;
        continue
      }else {
        return ret__7219
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7221__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7221 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7221__delegate.call(this, f, args)
    };
    G__7221.cljs$lang$maxFixedArity = 1;
    G__7221.cljs$lang$applyTo = function(arglist__7222) {
      var f = cljs.core.first(arglist__7222);
      var args = cljs.core.rest(arglist__7222);
      return G__7221__delegate(f, args)
    };
    G__7221.cljs$lang$arity$variadic = G__7221__delegate;
    return G__7221
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7223 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7223, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7223, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7224 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7224) {
      return or__3548__auto____7224
    }else {
      var or__3548__auto____7225 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7225) {
        return or__3548__auto____7225
      }else {
        var and__3546__auto____7226 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7226) {
          var and__3546__auto____7227 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7227) {
            var and__3546__auto____7228 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7228) {
              var ret__7229 = true;
              var i__7230 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7231 = cljs.core.not.call(null, ret__7229);
                  if(or__3548__auto____7231) {
                    return or__3548__auto____7231
                  }else {
                    return i__7230 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7229
                }else {
                  var G__7232 = isa_QMARK_.call(null, h, child.call(null, i__7230), parent.call(null, i__7230));
                  var G__7233 = i__7230 + 1;
                  ret__7229 = G__7232;
                  i__7230 = G__7233;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7228
            }
          }else {
            return and__3546__auto____7227
          }
        }else {
          return and__3546__auto____7226
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7237 = "\ufdd0'parents".call(null, h);
    var td__7238 = "\ufdd0'descendants".call(null, h);
    var ta__7239 = "\ufdd0'ancestors".call(null, h);
    var tf__7240 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7241 = cljs.core.contains_QMARK_.call(null, tp__7237.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7239.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7239.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7237, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7240.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7238, parent, ta__7239), "\ufdd0'descendants":tf__7240.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7239, tag, td__7238)})
    }();
    if(cljs.core.truth_(or__3548__auto____7241)) {
      return or__3548__auto____7241
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7242 = "\ufdd0'parents".call(null, h);
    var childsParents__7243 = cljs.core.truth_(parentMap__7242.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7242.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7244 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7243)) ? cljs.core.assoc.call(null, parentMap__7242, tag, childsParents__7243) : cljs.core.dissoc.call(null, parentMap__7242, tag);
    var deriv_seq__7245 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7234_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7234_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7234_SHARP_), cljs.core.second.call(null, p1__7234_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7244)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7242.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7235_SHARP_, p2__7236_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7235_SHARP_, p2__7236_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7245))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7246 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7248 = cljs.core.truth_(function() {
    var and__3546__auto____7247 = xprefs__7246;
    if(cljs.core.truth_(and__3546__auto____7247)) {
      return xprefs__7246.call(null, y)
    }else {
      return and__3546__auto____7247
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7248)) {
    return or__3548__auto____7248
  }else {
    var or__3548__auto____7250 = function() {
      var ps__7249 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7249) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7249), prefer_table))) {
          }else {
          }
          var G__7253 = cljs.core.rest.call(null, ps__7249);
          ps__7249 = G__7253;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7250)) {
      return or__3548__auto____7250
    }else {
      var or__3548__auto____7252 = function() {
        var ps__7251 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7251) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7251), y, prefer_table))) {
            }else {
            }
            var G__7254 = cljs.core.rest.call(null, ps__7251);
            ps__7251 = G__7254;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7252)) {
        return or__3548__auto____7252
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7255 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7255)) {
    return or__3548__auto____7255
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7264 = cljs.core.reduce.call(null, function(be, p__7256) {
    var vec__7257__7258 = p__7256;
    var k__7259 = cljs.core.nth.call(null, vec__7257__7258, 0, null);
    var ___7260 = cljs.core.nth.call(null, vec__7257__7258, 1, null);
    var e__7261 = vec__7257__7258;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7259)) {
      var be2__7263 = cljs.core.truth_(function() {
        var or__3548__auto____7262 = be == null;
        if(or__3548__auto____7262) {
          return or__3548__auto____7262
        }else {
          return cljs.core.dominates.call(null, k__7259, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7261 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7263), k__7259, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7259), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7263)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7263
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7264)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7264));
      return cljs.core.second.call(null, best_entry__7264)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7265 = mf;
    if(and__3546__auto____7265) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7265
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7266 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7266) {
        return or__3548__auto____7266
      }else {
        var or__3548__auto____7267 = cljs.core._reset["_"];
        if(or__3548__auto____7267) {
          return or__3548__auto____7267
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7268 = mf;
    if(and__3546__auto____7268) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7268
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7269 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7269) {
        return or__3548__auto____7269
      }else {
        var or__3548__auto____7270 = cljs.core._add_method["_"];
        if(or__3548__auto____7270) {
          return or__3548__auto____7270
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7271 = mf;
    if(and__3546__auto____7271) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7271
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7272 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7272) {
        return or__3548__auto____7272
      }else {
        var or__3548__auto____7273 = cljs.core._remove_method["_"];
        if(or__3548__auto____7273) {
          return or__3548__auto____7273
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7274 = mf;
    if(and__3546__auto____7274) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7274
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7275 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7275) {
        return or__3548__auto____7275
      }else {
        var or__3548__auto____7276 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7276) {
          return or__3548__auto____7276
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7277 = mf;
    if(and__3546__auto____7277) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7277
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7278 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7278) {
        return or__3548__auto____7278
      }else {
        var or__3548__auto____7279 = cljs.core._get_method["_"];
        if(or__3548__auto____7279) {
          return or__3548__auto____7279
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7280 = mf;
    if(and__3546__auto____7280) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7280
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7281 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7281) {
        return or__3548__auto____7281
      }else {
        var or__3548__auto____7282 = cljs.core._methods["_"];
        if(or__3548__auto____7282) {
          return or__3548__auto____7282
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7283 = mf;
    if(and__3546__auto____7283) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7283
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7284 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7284) {
        return or__3548__auto____7284
      }else {
        var or__3548__auto____7285 = cljs.core._prefers["_"];
        if(or__3548__auto____7285) {
          return or__3548__auto____7285
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7286 = mf;
    if(and__3546__auto____7286) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7286
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7287 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7287) {
        return or__3548__auto____7287
      }else {
        var or__3548__auto____7288 = cljs.core._dispatch["_"];
        if(or__3548__auto____7288) {
          return or__3548__auto____7288
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7289 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7290 = cljs.core._get_method.call(null, mf, dispatch_val__7289);
  if(cljs.core.truth_(target_fn__7290)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7289)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7290, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7291 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7292 = this;
  cljs.core.swap_BANG_.call(null, this__7292.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7292.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7292.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7292.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7293 = this;
  cljs.core.swap_BANG_.call(null, this__7293.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7293.method_cache, this__7293.method_table, this__7293.cached_hierarchy, this__7293.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7294 = this;
  cljs.core.swap_BANG_.call(null, this__7294.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7294.method_cache, this__7294.method_table, this__7294.cached_hierarchy, this__7294.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7295 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7295.cached_hierarchy), cljs.core.deref.call(null, this__7295.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7295.method_cache, this__7295.method_table, this__7295.cached_hierarchy, this__7295.hierarchy)
  }
  var temp__3695__auto____7296 = cljs.core.deref.call(null, this__7295.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7296)) {
    var target_fn__7297 = temp__3695__auto____7296;
    return target_fn__7297
  }else {
    var temp__3695__auto____7298 = cljs.core.find_and_cache_best_method.call(null, this__7295.name, dispatch_val, this__7295.hierarchy, this__7295.method_table, this__7295.prefer_table, this__7295.method_cache, this__7295.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7298)) {
      var target_fn__7299 = temp__3695__auto____7298;
      return target_fn__7299
    }else {
      return cljs.core.deref.call(null, this__7295.method_table).call(null, this__7295.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7300 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7300.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7300.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7300.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7300.method_cache, this__7300.method_table, this__7300.cached_hierarchy, this__7300.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7301 = this;
  return cljs.core.deref.call(null, this__7301.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7302 = this;
  return cljs.core.deref.call(null, this__7302.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7303 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7303.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7304__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7304 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7304__delegate.call(this, _, args)
  };
  G__7304.cljs$lang$maxFixedArity = 1;
  G__7304.cljs$lang$applyTo = function(arglist__7305) {
    var _ = cljs.core.first(arglist__7305);
    var args = cljs.core.rest(arglist__7305);
    return G__7304__delegate(_, args)
  };
  G__7304.cljs$lang$arity$variadic = G__7304__delegate;
  return G__7304
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7467 = reader;
    if(and__3546__auto____7467) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7467
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7468 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7468) {
        return or__3548__auto____7468
      }else {
        var or__3548__auto____7469 = cljs.reader.read_char["_"];
        if(or__3548__auto____7469) {
          return or__3548__auto____7469
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7470 = reader;
    if(and__3546__auto____7470) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7470
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7471 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7471) {
        return or__3548__auto____7471
      }else {
        var or__3548__auto____7472 = cljs.reader.unread["_"];
        if(or__3548__auto____7472) {
          return or__3548__auto____7472
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7473 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7473.buffer_atom))) {
    var idx__7474 = cljs.core.deref.call(null, this__7473.index_atom);
    cljs.core.swap_BANG_.call(null, this__7473.index_atom, cljs.core.inc);
    return this__7473.s[idx__7474]
  }else {
    var buf__7475 = cljs.core.deref.call(null, this__7473.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7473.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7475)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7476 = this;
  return cljs.core.swap_BANG_.call(null, this__7476.buffer_atom, function(p1__7466_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7466_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7477 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7477)) {
    return or__3548__auto____7477
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7478 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7478) {
    return or__3548__auto____7478
  }else {
    var and__3546__auto____7480 = function() {
      var or__3548__auto____7479 = "+" === initch;
      if(or__3548__auto____7479) {
        return or__3548__auto____7479
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7480)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7481 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7481);
        return next_ch__7481
      }())
    }else {
      return and__3546__auto____7480
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7482) {
    var rdr = cljs.core.first(arglist__7482);
    var msg = cljs.core.rest(arglist__7482);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7483 = ch != "#";
  if(and__3546__auto____7483) {
    var and__3546__auto____7484 = ch != "'";
    if(and__3546__auto____7484) {
      var and__3546__auto____7485 = ch != ":";
      if(and__3546__auto____7485) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7485
      }
    }else {
      return and__3546__auto____7484
    }
  }else {
    return and__3546__auto____7483
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7486 = new goog.string.StringBuffer(initch);
  var ch__7487 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7488 = ch__7487 == null;
      if(or__3548__auto____7488) {
        return or__3548__auto____7488
      }else {
        var or__3548__auto____7489 = cljs.reader.whitespace_QMARK_.call(null, ch__7487);
        if(or__3548__auto____7489) {
          return or__3548__auto____7489
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7487)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7487);
      return sb__7486.toString()
    }else {
      var G__7490 = function() {
        sb__7486.append(ch__7487);
        return sb__7486
      }();
      var G__7491 = cljs.reader.read_char.call(null, rdr);
      sb__7486 = G__7490;
      ch__7487 = G__7491;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7492 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7493 = ch__7492 === "n";
      if(or__3548__auto____7493) {
        return or__3548__auto____7493
      }else {
        var or__3548__auto____7494 = ch__7492 === "r";
        if(or__3548__auto____7494) {
          return or__3548__auto____7494
        }else {
          return ch__7492 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7495 = re.exec(s);
  if(matches__7495 != null) {
    if(matches__7495.length === 1) {
      return matches__7495[0]
    }else {
      return matches__7495
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7496 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7497 = groups__7496[2];
  if(!function() {
    var or__3548__auto____7498 = group3__7497 == null;
    if(or__3548__auto____7498) {
      return or__3548__auto____7498
    }else {
      return group3__7497.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7499 = "-" === groups__7496[1] ? -1 : 1;
    var a__7500 = cljs.core.truth_(groups__7496[3]) ? [groups__7496[3], 10] : cljs.core.truth_(groups__7496[4]) ? [groups__7496[4], 16] : cljs.core.truth_(groups__7496[5]) ? [groups__7496[5], 8] : cljs.core.truth_(groups__7496[7]) ? [groups__7496[7], parseInt(groups__7496[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7501 = a__7500[0];
    var radix__7502 = a__7500[1];
    if(n__7501 == null) {
      return null
    }else {
      return negate__7499 * parseInt(n__7501, radix__7502)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7503 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7504 = groups__7503[1];
  var denominator__7505 = groups__7503[2];
  return parseInt(numinator__7504) / parseInt(denominator__7505)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7506 = re.exec(s);
  if(function() {
    var and__3546__auto____7507 = matches__7506 != null;
    if(and__3546__auto____7507) {
      return matches__7506[0] === s
    }else {
      return and__3546__auto____7507
    }
  }()) {
    if(matches__7506.length === 1) {
      return matches__7506[0]
    }else {
      return matches__7506
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7508 = cljs.reader.read_char.call(null, reader);
  var mapresult__7509 = cljs.reader.escape_char_map.call(null, ch__7508);
  if(cljs.core.truth_(mapresult__7509)) {
    return mapresult__7509
  }else {
    if(function() {
      var or__3548__auto____7510 = "u" === ch__7508;
      if(or__3548__auto____7510) {
        return or__3548__auto____7510
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7508)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7508)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7508)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7511 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7511))) {
      var G__7512 = cljs.reader.read_char.call(null, rdr);
      ch__7511 = G__7512;
      continue
    }else {
      return ch__7511
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7513 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7514 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7514)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7514) {
      return cljs.core.persistent_BANG_.call(null, a__7513)
    }else {
      var temp__3695__auto____7515 = cljs.reader.macros.call(null, ch__7514);
      if(cljs.core.truth_(temp__3695__auto____7515)) {
        var macrofn__7516 = temp__3695__auto____7515;
        var mret__7517 = macrofn__7516.call(null, rdr, ch__7514);
        var G__7519 = mret__7517 === rdr ? a__7513 : cljs.core.conj_BANG_.call(null, a__7513, mret__7517);
        a__7513 = G__7519;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7514);
        var o__7518 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7520 = o__7518 === rdr ? a__7513 : cljs.core.conj_BANG_.call(null, a__7513, o__7518);
        a__7513 = G__7520;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7521 = cljs.reader.read_char.call(null, rdr);
  var dm__7522 = cljs.reader.dispatch_macros.call(null, ch__7521);
  if(cljs.core.truth_(dm__7522)) {
    return dm__7522.call(null, rdr, _)
  }else {
    var temp__3695__auto____7523 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7521);
    if(cljs.core.truth_(temp__3695__auto____7523)) {
      var obj__7524 = temp__3695__auto____7523;
      return obj__7524
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7521)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7525 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7525))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7525)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7526 = new goog.string.StringBuffer(initch);
  var ch__7527 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7528 = ch__7527 == null;
      if(or__3548__auto____7528) {
        return or__3548__auto____7528
      }else {
        var or__3548__auto____7529 = cljs.reader.whitespace_QMARK_.call(null, ch__7527);
        if(or__3548__auto____7529) {
          return or__3548__auto____7529
        }else {
          return cljs.reader.macros.call(null, ch__7527)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7527);
      var s__7530 = buffer__7526.toString();
      var or__3548__auto____7531 = cljs.reader.match_number.call(null, s__7530);
      if(cljs.core.truth_(or__3548__auto____7531)) {
        return or__3548__auto____7531
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7530, "]")
      }
    }else {
      var G__7532 = function() {
        buffer__7526.append(ch__7527);
        return buffer__7526
      }();
      var G__7533 = cljs.reader.read_char.call(null, reader);
      buffer__7526 = G__7532;
      ch__7527 = G__7533;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7534 = new goog.string.StringBuffer;
  var ch__7535 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7535 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7535) {
        var G__7536 = function() {
          buffer__7534.append(cljs.reader.escape_char.call(null, buffer__7534, reader));
          return buffer__7534
        }();
        var G__7537 = cljs.reader.read_char.call(null, reader);
        buffer__7534 = G__7536;
        ch__7535 = G__7537;
        continue
      }else {
        if('"' === ch__7535) {
          return buffer__7534.toString()
        }else {
          if("\ufdd0'default") {
            var G__7538 = function() {
              buffer__7534.append(ch__7535);
              return buffer__7534
            }();
            var G__7539 = cljs.reader.read_char.call(null, reader);
            buffer__7534 = G__7538;
            ch__7535 = G__7539;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7540 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7540, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7540, 0, token__7540.indexOf("/")), cljs.core.subs.call(null, token__7540, token__7540.indexOf("/") + 1, token__7540.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7540, cljs.core.symbol.call(null, token__7540))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7541 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7542 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7541);
  var token__7543 = a__7542[0];
  var ns__7544 = a__7542[1];
  var name__7545 = a__7542[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7547 = function() {
      var and__3546__auto____7546 = !(void 0 === ns__7544);
      if(and__3546__auto____7546) {
        return ns__7544.substring(ns__7544.length - 2, ns__7544.length) === ":/"
      }else {
        return and__3546__auto____7546
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7547)) {
      return or__3548__auto____7547
    }else {
      var or__3548__auto____7548 = name__7545[name__7545.length - 1] === ":";
      if(or__3548__auto____7548) {
        return or__3548__auto____7548
      }else {
        return!(token__7543.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7543)
  }else {
    if(cljs.core.truth_(ns__7544)) {
      return cljs.core.keyword.call(null, ns__7544.substring(0, ns__7544.indexOf("/")), name__7545)
    }else {
      return cljs.core.keyword.call(null, token__7543)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7549 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7549)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7550 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7551__7552 = o__7550;
    if(G__7551__7552 != null) {
      if(function() {
        var or__3548__auto____7553 = G__7551__7552.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7553) {
          return or__3548__auto____7553
        }else {
          return G__7551__7552.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7551__7552.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7551__7552)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7551__7552)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7550, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7550), m__7549))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7554 = cljs.reader.read_char.call(null, reader);
    if(ch__7554 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7554)) {
        var G__7557 = reader;
        var G__7558 = eof_is_error;
        var G__7559 = sentinel;
        var G__7560 = is_recursive;
        reader = G__7557;
        eof_is_error = G__7558;
        sentinel = G__7559;
        is_recursive = G__7560;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7554)) {
          var G__7561 = cljs.reader.read_comment.call(null, reader, ch__7554);
          var G__7562 = eof_is_error;
          var G__7563 = sentinel;
          var G__7564 = is_recursive;
          reader = G__7561;
          eof_is_error = G__7562;
          sentinel = G__7563;
          is_recursive = G__7564;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7555 = cljs.reader.macros.call(null, ch__7554);
            var res__7556 = cljs.core.truth_(f__7555) ? f__7555.call(null, reader, ch__7554) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7554) ? cljs.reader.read_number.call(null, reader, ch__7554) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7554) : null;
            if(res__7556 === reader) {
              var G__7565 = reader;
              var G__7566 = eof_is_error;
              var G__7567 = sentinel;
              var G__7568 = is_recursive;
              reader = G__7565;
              eof_is_error = G__7566;
              sentinel = G__7567;
              is_recursive = G__7568;
              continue
            }else {
              return res__7556
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7569 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7569, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7570 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7571 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7572 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7570));
  if(cljs.core.truth_(pfn__7572)) {
    return pfn__7572.call(null, form__7571)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7570), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7573 = cljs.core.name.call(null, tag);
  var old_parser__7574 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7573);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7573, f);
  return old_parser__7574
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7443 = s;
      var limit__7444 = limit;
      var parts__7445 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7444, 1)) {
          return cljs.core.conj.call(null, parts__7445, s__7443)
        }else {
          var temp__3695__auto____7446 = cljs.core.re_find.call(null, re, s__7443);
          if(cljs.core.truth_(temp__3695__auto____7446)) {
            var m__7447 = temp__3695__auto____7446;
            var index__7448 = s__7443.indexOf(m__7447);
            var G__7449 = s__7443.substring(index__7448 + cljs.core.count.call(null, m__7447));
            var G__7450 = limit__7444 - 1;
            var G__7451 = cljs.core.conj.call(null, parts__7445, s__7443.substring(0, index__7448));
            s__7443 = G__7449;
            limit__7444 = G__7450;
            parts__7445 = G__7451;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7445, s__7443)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7452 = s.length;
  while(true) {
    if(index__7452 === 0) {
      return""
    }else {
      var ch__7453 = cljs.core.get.call(null, s, index__7452 - 1);
      if(function() {
        var or__3548__auto____7454 = cljs.core._EQ_.call(null, ch__7453, "\n");
        if(or__3548__auto____7454) {
          return or__3548__auto____7454
        }else {
          return cljs.core._EQ_.call(null, ch__7453, "\r")
        }
      }()) {
        var G__7455 = index__7452 - 1;
        index__7452 = G__7455;
        continue
      }else {
        return s.substring(0, index__7452)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7456 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7457 = cljs.core.not.call(null, s__7456);
    if(or__3548__auto____7457) {
      return or__3548__auto____7457
    }else {
      var or__3548__auto____7458 = cljs.core._EQ_.call(null, "", s__7456);
      if(or__3548__auto____7458) {
        return or__3548__auto____7458
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7456)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7459 = new goog.string.StringBuffer;
  var length__7460 = s.length;
  var index__7461 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7460, index__7461)) {
      return buffer__7459.toString()
    }else {
      var ch__7462 = s.charAt(index__7461);
      var temp__3695__auto____7463 = cljs.core.get.call(null, cmap, ch__7462);
      if(cljs.core.truth_(temp__3695__auto____7463)) {
        var replacement__7464 = temp__3695__auto____7463;
        buffer__7459.append([cljs.core.str(replacement__7464)].join(""))
      }else {
        buffer__7459.append(ch__7462)
      }
      var G__7465 = index__7461 + 1;
      index__7461 = G__7465;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7414 = {};
  var G__7415__7416 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7415__7416)) {
    var G__7418__7420 = cljs.core.first.call(null, G__7415__7416);
    var vec__7419__7421 = G__7418__7420;
    var k__7422 = cljs.core.nth.call(null, vec__7419__7421, 0, null);
    var v__7423 = cljs.core.nth.call(null, vec__7419__7421, 1, null);
    var G__7415__7424 = G__7415__7416;
    var G__7418__7425 = G__7418__7420;
    var G__7415__7426 = G__7415__7424;
    while(true) {
      var vec__7427__7428 = G__7418__7425;
      var k__7429 = cljs.core.nth.call(null, vec__7427__7428, 0, null);
      var v__7430 = cljs.core.nth.call(null, vec__7427__7428, 1, null);
      var G__7415__7431 = G__7415__7426;
      out__7414[cljs.core.name.call(null, k__7429)] = v__7430;
      var temp__3698__auto____7432 = cljs.core.next.call(null, G__7415__7431);
      if(cljs.core.truth_(temp__3698__auto____7432)) {
        var G__7415__7433 = temp__3698__auto____7432;
        var G__7434 = cljs.core.first.call(null, G__7415__7433);
        var G__7435 = G__7415__7433;
        G__7418__7425 = G__7434;
        G__7415__7426 = G__7435;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7414
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7436 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7436)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7437) {
    var v = cljs.core.first(arglist__7437);
    var text = cljs.core.rest(arglist__7437);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7438) {
          var vec__7439__7440 = p__7438;
          var k__7441 = cljs.core.nth.call(null, vec__7439__7440, 0, null);
          var v__7442 = cljs.core.nth.call(null, vec__7439__7440, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7441), clj__GT_js.call(null, v__7442))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7306 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7306)) {
        var cm__7307 = temp__3695__auto____7306;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7307), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7308) {
    var vec__7309__7310 = p__7308;
    var context__7311 = cljs.core.nth.call(null, vec__7309__7310, 0, null);
    if(cljs.core.not.call(null, context__7311)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7311)
    }
  };
  var $ = function(sel, var_args) {
    var p__7308 = null;
    if(goog.isDef(var_args)) {
      p__7308 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7308)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7312) {
    var sel = cljs.core.first(arglist__7312);
    var p__7308 = cljs.core.rest(arglist__7312);
    return $__delegate(sel, p__7308)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7313 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7313)) {
    return or__3548__auto____7313
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7314 = null;
  var G__7314__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7314__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7314 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7314__2.call(this, _, k);
      case 3:
        return G__7314__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7314
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7315) {
    var vec__7316__7317 = p__7315;
    var v__7318 = cljs.core.nth.call(null, vec__7316__7317, 0, null);
    var a__7319 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7318)) {
      return $elem.attr(a__7319)
    }else {
      return $elem.attr(a__7319, v__7318)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7315 = null;
    if(goog.isDef(var_args)) {
      p__7315 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7315)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7320) {
    var $elem = cljs.core.first(arglist__7320);
    var a = cljs.core.first(cljs.core.next(arglist__7320));
    var p__7315 = cljs.core.rest(cljs.core.next(arglist__7320));
    return attr__delegate($elem, a, p__7315)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7321) {
    var vec__7322__7323 = p__7321;
    var v__7324 = cljs.core.nth.call(null, vec__7322__7323, 0, null);
    var k__7325 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7324)) {
      return $elem.data(k__7325)
    }else {
      return $elem.data(k__7325, v__7324)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7321 = null;
    if(goog.isDef(var_args)) {
      p__7321 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7321)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7326) {
    var $elem = cljs.core.first(arglist__7326);
    var k = cljs.core.first(cljs.core.next(arglist__7326));
    var p__7321 = cljs.core.rest(cljs.core.next(arglist__7326));
    return data__delegate($elem, k, p__7321)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7327 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7327)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7328 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7328)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7329 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7329)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7330 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7330)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7331) {
    var vec__7332__7333 = p__7331;
    var speed__7334 = cljs.core.nth.call(null, vec__7332__7333, 0, null);
    var on_finish__7335 = cljs.core.nth.call(null, vec__7332__7333, 1, null);
    return $elem.hide(speed__7334, on_finish__7335)
  };
  var hide = function($elem, var_args) {
    var p__7331 = null;
    if(goog.isDef(var_args)) {
      p__7331 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7331)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7336) {
    var $elem = cljs.core.first(arglist__7336);
    var p__7331 = cljs.core.rest(arglist__7336);
    return hide__delegate($elem, p__7331)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7337) {
    var vec__7338__7339 = p__7337;
    var speed__7340 = cljs.core.nth.call(null, vec__7338__7339, 0, null);
    var on_finish__7341 = cljs.core.nth.call(null, vec__7338__7339, 1, null);
    return $elem.show(speed__7340, on_finish__7341)
  };
  var show = function($elem, var_args) {
    var p__7337 = null;
    if(goog.isDef(var_args)) {
      p__7337 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7337)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7342) {
    var $elem = cljs.core.first(arglist__7342);
    var p__7337 = cljs.core.rest(arglist__7342);
    return show__delegate($elem, p__7337)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7343) {
    var vec__7344__7345 = p__7343;
    var speed__7346 = cljs.core.nth.call(null, vec__7344__7345, 0, null);
    var on_finish__7347 = cljs.core.nth.call(null, vec__7344__7345, 1, null);
    return $elem.toggle(speed__7346, on_finish__7347)
  };
  var toggle = function($elem, var_args) {
    var p__7343 = null;
    if(goog.isDef(var_args)) {
      p__7343 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7343)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7348) {
    var $elem = cljs.core.first(arglist__7348);
    var p__7343 = cljs.core.rest(arglist__7348);
    return toggle__delegate($elem, p__7343)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7349) {
    var vec__7350__7351 = p__7349;
    var speed__7352 = cljs.core.nth.call(null, vec__7350__7351, 0, null);
    var on_finish__7353 = cljs.core.nth.call(null, vec__7350__7351, 1, null);
    return $elem.fadeOut(speed__7352, on_finish__7353)
  };
  var fade_out = function($elem, var_args) {
    var p__7349 = null;
    if(goog.isDef(var_args)) {
      p__7349 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7349)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7354) {
    var $elem = cljs.core.first(arglist__7354);
    var p__7349 = cljs.core.rest(arglist__7354);
    return fade_out__delegate($elem, p__7349)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7355) {
    var vec__7356__7357 = p__7355;
    var speed__7358 = cljs.core.nth.call(null, vec__7356__7357, 0, null);
    var on_finish__7359 = cljs.core.nth.call(null, vec__7356__7357, 1, null);
    return $elem.fadeIn(speed__7358, on_finish__7359)
  };
  var fade_in = function($elem, var_args) {
    var p__7355 = null;
    if(goog.isDef(var_args)) {
      p__7355 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7355)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7360) {
    var $elem = cljs.core.first(arglist__7360);
    var p__7355 = cljs.core.rest(arglist__7360);
    return fade_in__delegate($elem, p__7355)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7361) {
    var vec__7362__7363 = p__7361;
    var speed__7364 = cljs.core.nth.call(null, vec__7362__7363, 0, null);
    var on_finish__7365 = cljs.core.nth.call(null, vec__7362__7363, 1, null);
    return $elem.slideUp(speed__7364, on_finish__7365)
  };
  var slide_up = function($elem, var_args) {
    var p__7361 = null;
    if(goog.isDef(var_args)) {
      p__7361 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7361)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7366) {
    var $elem = cljs.core.first(arglist__7366);
    var p__7361 = cljs.core.rest(arglist__7366);
    return slide_up__delegate($elem, p__7361)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7367) {
    var vec__7368__7369 = p__7367;
    var speed__7370 = cljs.core.nth.call(null, vec__7368__7369, 0, null);
    var on_finish__7371 = cljs.core.nth.call(null, vec__7368__7369, 1, null);
    return $elem.slideDown(speed__7370, on_finish__7371)
  };
  var slide_down = function($elem, var_args) {
    var p__7367 = null;
    if(goog.isDef(var_args)) {
      p__7367 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7367)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7372) {
    var $elem = cljs.core.first(arglist__7372);
    var p__7367 = cljs.core.rest(arglist__7372);
    return slide_down__delegate($elem, p__7367)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7373) {
    var vec__7374__7375 = p__7373;
    var context__7376 = cljs.core.nth.call(null, vec__7374__7375, 0, null);
    return $elem.closest(selector, context__7376)
  };
  var closest = function($elem, selector, var_args) {
    var p__7373 = null;
    if(goog.isDef(var_args)) {
      p__7373 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7373)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7377) {
    var $elem = cljs.core.first(arglist__7377);
    var selector = cljs.core.first(cljs.core.next(arglist__7377));
    var p__7373 = cljs.core.rest(cljs.core.next(arglist__7377));
    return closest__delegate($elem, selector, p__7373)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7378) {
    var vec__7379__7380 = p__7378;
    var v__7381 = cljs.core.nth.call(null, vec__7379__7380, 0, null);
    if(cljs.core.truth_(v__7381)) {
      return $elem.val(v__7381)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7378 = null;
    if(goog.isDef(var_args)) {
      p__7378 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7378)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7382) {
    var $elem = cljs.core.first(arglist__7382);
    var p__7378 = cljs.core.rest(arglist__7382);
    return val__delegate($elem, p__7378)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7383, content, callback) {
  var vec__7384__7385 = p__7383;
  var method__7386 = cljs.core.nth.call(null, vec__7384__7385, 0, null);
  var uri__7387 = cljs.core.nth.call(null, vec__7384__7385, 1, null);
  var params__7388 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7386)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7387, params__7388)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7389) {
    var vec__7390__7391 = p__7389;
    var func__7392 = cljs.core.nth.call(null, vec__7390__7391, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7392)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7389 = null;
    if(goog.isDef(var_args)) {
      p__7389 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7389)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7393) {
    var $elem = cljs.core.first(arglist__7393);
    var ev = cljs.core.first(cljs.core.next(arglist__7393));
    var p__7389 = cljs.core.rest(cljs.core.next(arglist__7393));
    return unbind__delegate($elem, ev, p__7389)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7394) {
    var vec__7395__7396 = p__7394;
    var sel__7397 = cljs.core.nth.call(null, vec__7395__7396, 0, null);
    var data__7398 = cljs.core.nth.call(null, vec__7395__7396, 1, null);
    var handler__7399 = cljs.core.nth.call(null, vec__7395__7396, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7397), data__7398, handler__7399)
  };
  var on = function($elem, events, var_args) {
    var p__7394 = null;
    if(goog.isDef(var_args)) {
      p__7394 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7394)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7400) {
    var $elem = cljs.core.first(arglist__7400);
    var events = cljs.core.first(cljs.core.next(arglist__7400));
    var p__7394 = cljs.core.rest(cljs.core.next(arglist__7400));
    return on__delegate($elem, events, p__7394)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7401) {
    var vec__7402__7403 = p__7401;
    var sel__7404 = cljs.core.nth.call(null, vec__7402__7403, 0, null);
    var data__7405 = cljs.core.nth.call(null, vec__7402__7403, 1, null);
    var handler__7406 = cljs.core.nth.call(null, vec__7402__7403, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7404), data__7405, handler__7406)
  };
  var one = function($elem, events, var_args) {
    var p__7401 = null;
    if(goog.isDef(var_args)) {
      p__7401 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7401)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7407) {
    var $elem = cljs.core.first(arglist__7407);
    var events = cljs.core.first(cljs.core.next(arglist__7407));
    var p__7401 = cljs.core.rest(cljs.core.next(arglist__7407));
    return one__delegate($elem, events, p__7401)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7408) {
    var vec__7409__7410 = p__7408;
    var sel__7411 = cljs.core.nth.call(null, vec__7409__7410, 0, null);
    var handler__7412 = cljs.core.nth.call(null, vec__7409__7410, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7411), handler__7412)
  };
  var off = function($elem, events, var_args) {
    var p__7408 = null;
    if(goog.isDef(var_args)) {
      p__7408 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7408)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7413) {
    var $elem = cljs.core.first(arglist__7413);
    var events = cljs.core.first(cljs.core.next(arglist__7413));
    var p__7408 = cljs.core.rest(cljs.core.next(arglist__7413));
    return off__delegate($elem, events, p__7408)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.dynamic_bindings = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.binding_key = cljs.core.atom.call(null, 0);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4822 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4821_SHARP_) {
    return out__4822[cljs.core.name.call(null, cljs.core.first.call(null, p1__4821_SHARP_))] = cljs.core.second.call(null, p1__4821_SHARP_)
  }, cljmap));
  return out__4822
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4823 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4823) {
    return or__3548__auto____4823
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bind_elem = function bind_elem(elem, bindingname, f) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname).call(null, elem, f.call(null))
    }
  }else {
    return function() {
      return elem[bindingname].call(elem, f.call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4824 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4825 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  return cljsbinding.bind_elem.call(null, elem, bindingname__4824, function() {
    return cljsbinding.valuefn.call(null, elem, fname__4825, ctx, bindingname__4824)
  })
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_jq_elem = function bind_jq_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4826__4827 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4826__4827)) {
    var data__4828 = cljs.core.first.call(null, G__4826__4827);
    var G__4826__4829 = G__4826__4827;
    while(true) {
      cljsbinding.bind_jq_elem.call(null, elem, data__4828.split(":"), ctx);
      var temp__3698__auto____4830 = cljs.core.next.call(null, G__4826__4829);
      if(cljs.core.truth_(temp__3698__auto____4830)) {
        var G__4826__4831 = temp__3698__auto____4830;
        var G__4832 = cljs.core.first.call(null, G__4826__4831);
        var G__4833 = G__4826__4831;
        data__4828 = G__4832;
        G__4826__4829 = G__4833;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem, atm) {
  var aval__4835 = cljs.core.deref.call(null, atm);
  if(cljs.core.map_QMARK_.call(null, aval__4835)) {
    return aval__4835.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4835
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4834_SHARP_) {
      return cljs.core.assoc.call(null, p1__4834_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem, atm) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem, atm))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.is(":checked"));
    return false
  })
};
cljsbinding.bind_text_atom = function bind_text_atom(elem, atm) {
  return cljsbinding.run_bind_fn.call(null, function() {
    return elem["text"].call(elem, cljsbinding.atom_val.call(null, elem, atm))
  })
};
cljsbinding.bind_elem_to_atom = function bind_elem_to_atom(elem, atm) {
  if(cljs.core.truth_(function() {
    var or__3548__auto____4836 = elem.is("input");
    if(cljs.core.truth_(or__3548__auto____4836)) {
      return or__3548__auto____4836
    }else {
      var or__3548__auto____4837 = elem.is("textarea");
      if(cljs.core.truth_(or__3548__auto____4837)) {
        return or__3548__auto____4837
      }else {
        return elem.is("select")
      }
    }
  }())) {
    if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
      return cljsbinding.bind_checkbox_atom.call(null, elem, atm)
    }else {
      return cljsbinding.bind_input_atom.call(null, elem, atm)
    }
  }else {
    return cljsbinding.bind_text_atom.call(null, elem, atm)
  }
};
cljsbinding.bindatom = function bindatom(elem) {
  var atm__4838 = eval(jayq.core.attr.call(null, elem, "bindatom"));
  return cljsbinding.bind_elem_to_atom.call(null, elem, atm__4838)
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem, bindfn) {
  jayq.core.append.call(null, parent, elem);
  return bindfn.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(templateid, sequence, parent, template, bindfn) {
  jayq.core.remove.call(null, parent.children([cljs.core.str("[bind-template-id='"), cljs.core.str(templateid), cljs.core.str("']")].join("")));
  var G__4839__4840 = cljs.core.seq.call(null, sequence);
  if(cljs.core.truth_(G__4839__4840)) {
    var item__4841 = cljs.core.first.call(null, G__4839__4840);
    var G__4839__4842 = G__4839__4840;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4841, template.clone().attr("bind-template-id", templateid), bindfn);
      var temp__3698__auto____4843 = cljs.core.next.call(null, G__4839__4842);
      if(cljs.core.truth_(temp__3698__auto____4843)) {
        var G__4839__4844 = temp__3698__auto____4843;
        var G__4845 = cljs.core.first.call(null, G__4839__4844);
        var G__4846 = G__4839__4844;
        item__4841 = G__4845;
        G__4839__4842 = G__4846;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.uuid = function uuid() {
  var r__4847 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4847), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4847)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4847)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4847)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4847))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bindseq = function bindseq(elem, elparent, bindfn) {
  var atom__4849 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  var templateid__4850 = cljsbinding.uuid.call(null);
  cljsbinding.insertseq.call(null, templateid__4850, cljs.core.deref.call(null, atom__4849), elparent, elem, bindfn);
  return cljs.core.add_watch.call(null, atom__4849, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, templateid__4850, new_val, elparent, elem, bindfn)
  })
};
cljsbinding.dobind = function dobind(parent, ctx) {
  var seqs__4851 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4852 = cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4848_SHARP_) {
    return jayq.core.$.call(null, p1__4848_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4853__4854 = cljs.core.seq.call(null, seqs__4851);
  if(cljs.core.truth_(G__4853__4854)) {
    var elem__4855 = cljs.core.first.call(null, G__4853__4854);
    var G__4853__4856 = G__4853__4854;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4855));
      var temp__3698__auto____4857 = cljs.core.next.call(null, G__4853__4856);
      if(cljs.core.truth_(temp__3698__auto____4857)) {
        var G__4853__4858 = temp__3698__auto____4857;
        var G__4896 = cljs.core.first.call(null, G__4853__4858);
        var G__4897 = G__4853__4858;
        elem__4855 = G__4896;
        G__4853__4856 = G__4897;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4859__4860 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4859__4860)) {
    var elem__4861 = cljs.core.first.call(null, G__4859__4860);
    var G__4859__4862 = G__4859__4860;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4861), ctx);
      var temp__3698__auto____4863 = cljs.core.next.call(null, G__4859__4862);
      if(cljs.core.truth_(temp__3698__auto____4863)) {
        var G__4859__4864 = temp__3698__auto____4863;
        var G__4898 = cljs.core.first.call(null, G__4859__4864);
        var G__4899 = G__4859__4864;
        elem__4861 = G__4898;
        G__4859__4862 = G__4899;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4865__4866 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4865__4866)) {
    var elem__4867 = cljs.core.first.call(null, G__4865__4866);
    var G__4865__4868 = G__4865__4866;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4867), ctx);
      var temp__3698__auto____4869 = cljs.core.next.call(null, G__4865__4868);
      if(cljs.core.truth_(temp__3698__auto____4869)) {
        var G__4865__4870 = temp__3698__auto____4869;
        var G__4900 = cljs.core.first.call(null, G__4865__4870);
        var G__4901 = G__4865__4870;
        elem__4867 = G__4900;
        G__4865__4868 = G__4901;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4871__4872 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4871__4872)) {
    var elem__4873 = cljs.core.first.call(null, G__4871__4872);
    var G__4871__4874 = G__4871__4872;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4873));
      var temp__3698__auto____4875 = cljs.core.next.call(null, G__4871__4874);
      if(cljs.core.truth_(temp__3698__auto____4875)) {
        var G__4871__4876 = temp__3698__auto____4875;
        var G__4902 = cljs.core.first.call(null, G__4871__4876);
        var G__4903 = G__4871__4876;
        elem__4873 = G__4902;
        G__4871__4874 = G__4903;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4877__4878 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4851, seqparents__4852));
  if(cljs.core.truth_(G__4877__4878)) {
    var G__4880__4882 = cljs.core.first.call(null, G__4877__4878);
    var vec__4881__4883 = G__4880__4882;
    var elem__4884 = cljs.core.nth.call(null, vec__4881__4883, 0, null);
    var parent__4885 = cljs.core.nth.call(null, vec__4881__4883, 1, null);
    var G__4877__4886 = G__4877__4878;
    var G__4880__4887 = G__4880__4882;
    var G__4877__4888 = G__4877__4886;
    while(true) {
      var vec__4889__4890 = G__4880__4887;
      var elem__4891 = cljs.core.nth.call(null, vec__4889__4890, 0, null);
      var parent__4892 = cljs.core.nth.call(null, vec__4889__4890, 1, null);
      var G__4877__4893 = G__4877__4888;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4891), parent__4892, dobind);
      var temp__3698__auto____4894 = cljs.core.next.call(null, G__4877__4893);
      if(cljs.core.truth_(temp__3698__auto____4894)) {
        var G__4877__4895 = temp__3698__auto____4894;
        var G__4904 = cljs.core.first.call(null, G__4877__4895);
        var G__4905 = G__4877__4895;
        G__4880__4887 = G__4904;
        G__4877__4888 = G__4905;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindall = function() {
  var bindall = null;
  var bindall__1 = function(elem) {
    return cljsbinding.dobind.call(null, elem, null)
  };
  var bindall__2 = function(elem, ctx) {
    return cljsbinding.dobind.call(null, elem, ctx)
  };
  bindall = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindall__1.call(this, elem);
      case 2:
        return bindall__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindall.cljs$lang$arity$1 = bindall__1;
  bindall.cljs$lang$arity$2 = bindall__2;
  return bindall
}();
goog.exportSymbol("cljsbinding.bindall", cljsbinding.bindall);
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4906_SHARP_, p2__4907_SHARP_) {
      var or__3548__auto____4909 = p1__4906_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4909)) {
        return or__3548__auto____4909
      }else {
        return p2__4907_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4908_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4908_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.add_binding = function add_binding(atom, m) {
  return cljs.core.assoc.call(null, m, atom, cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), m.call(null, atom)))
};
cljsbinding.run_bindings = function run_bindings(key, a, old_val, new_val) {
  var G__4910__4911 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
  if(cljs.core.truth_(G__4910__4911)) {
    var f__4912 = cljs.core.first.call(null, G__4910__4911);
    var G__4910__4913 = G__4910__4911;
    while(true) {
      f__4912.call(null);
      var temp__3698__auto____4914 = cljs.core.next.call(null, G__4910__4913);
      if(cljs.core.truth_(temp__3698__auto____4914)) {
        var G__4910__4915 = temp__3698__auto____4914;
        var G__4916 = cljs.core.first.call(null, G__4910__4915);
        var G__4917 = G__4910__4915;
        f__4912 = G__4916;
        G__4910__4913 = G__4917;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.next_binding_key = function next_binding_key() {
  return cljs.core.swap_BANG_.call(null, cljsbinding.binding_key, cljs.core.inc)
};
cljsbinding.register_bindingsource = function register_bindingsource(source) {
  var bindingkey__4919 = [cljs.core.str(cljsbinding.next_binding_key.call(null))].join("");
  cljs.core.swap_BANG_.call(null, cljsbinding.dynamic_bindings, function(p1__4918_SHARP_) {
    return cljs.core.assoc.call(null, p1__4918_SHARP_, bindingkey__4919, source)
  });
  return bindingkey__4919
};
cljsbinding.apply_binding = function apply_binding(elem, source) {
  if(cljs.core.map_QMARK_.call(null, source)) {
    var G__4920__4921 = cljs.core.seq.call(null, source);
    if(cljs.core.truth_(G__4920__4921)) {
      var G__4923__4925 = cljs.core.first.call(null, G__4920__4921);
      var vec__4924__4926 = G__4923__4925;
      var bindingname__4927 = cljs.core.nth.call(null, vec__4924__4926, 0, null);
      var f__4928 = cljs.core.nth.call(null, vec__4924__4926, 1, null);
      var G__4920__4929 = G__4920__4921;
      var G__4923__4930 = G__4923__4925;
      var G__4920__4931 = G__4920__4929;
      while(true) {
        var vec__4932__4933 = G__4923__4930;
        var bindingname__4934 = cljs.core.nth.call(null, vec__4932__4933, 0, null);
        var f__4935 = cljs.core.nth.call(null, vec__4932__4933, 1, null);
        var G__4920__4936 = G__4920__4931;
        cljsbinding.run_bind_fn.call(null, cljsbinding.bind_elem.call(null, elem, cljs.core.name.call(null, bindingname__4934), f__4935));
        var temp__3698__auto____4937 = cljs.core.next.call(null, G__4920__4936);
        if(cljs.core.truth_(temp__3698__auto____4937)) {
          var G__4920__4938 = temp__3698__auto____4937;
          var G__4939 = cljs.core.first.call(null, G__4920__4938);
          var G__4940 = G__4920__4938;
          G__4923__4930 = G__4939;
          G__4920__4931 = G__4940;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  }else {
    return cljsbinding.bind_elem_to_atom.call(null, elem, source)
  }
};
cljsbinding.apply_bindingsource = function apply_bindingsource(elem, bindingkey) {
  var G__4941__4942 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.dynamic_bindings).call(null, bindingkey));
  if(cljs.core.truth_(G__4941__4942)) {
    var source__4943 = cljs.core.first.call(null, G__4941__4942);
    var G__4941__4944 = G__4941__4942;
    while(true) {
      cljsbinding.apply_binding.call(null, elem, source__4943);
      var temp__3698__auto____4945 = cljs.core.next.call(null, G__4941__4944);
      if(cljs.core.truth_(temp__3698__auto____4945)) {
        var G__4941__4946 = temp__3698__auto____4945;
        var G__4947 = cljs.core.first.call(null, G__4941__4946);
        var G__4948 = G__4941__4946;
        source__4943 = G__4947;
        G__4941__4944 = G__4948;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, cljs.core.partial.call(null, cljsbinding.add_binding, atom));
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", cljsbinding.run_bindings);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.cljsderef = function cljsderef() {
  return cljs.core._deref
};
goog.exportSymbol("cljsbinding.cljsderef", cljsbinding.cljsderef);
cljsbinding.shouldregister = function shouldregister(drf) {
  return drf.call(null, cljsbinding.BindMonitor)
};
goog.exportSymbol("cljsbinding.shouldregister", cljsbinding.shouldregister);
cljsbinding.boot = function boot() {
  return eval("    \n    var derefName = eval('cljsbinding.cljsderef.toString().match(/return.(.*$)\\\\s/m)[1]')\n    if (derefName[derefName.length-1] == ';')\n      derefName = derefName.substr(0,derefName.length-1)\n    var deref = eval(derefName)\n    eval(derefName +' = function (a) { if (cljsbinding.shouldregister(deref)) { cljsbinding.register(a) };return deref(a); }')\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  var storedValue__4949 = localStorage[name];
  if(cljs.core.not.call(null, storedValue__4949 == null)) {
    return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, storedValue__4949))
  }else {
    return null
  }
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
goog.provide("cljsbinding.crate");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljsbinding");
cljsbinding.crate.re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;
cljsbinding.crate.tag_str = function tag_str(tag) {
  if(cljs.core.keyword_QMARK_.call(null, tag)) {
    return cljs.core.name.call(null, tag)
  }else {
    return[cljs.core.str(tag)].join("")
  }
};
cljsbinding.crate.normalize_element = function normalize_element(p__4799) {
  var vec__4800__4801 = p__4799;
  var tag__4802 = cljs.core.nth.call(null, vec__4800__4801, 0, null);
  var content__4803 = cljs.core.nthnext.call(null, vec__4800__4801, 1);
  if(cljs.core.not.call(null, function() {
    var or__3548__auto____4804 = cljs.core.keyword_QMARK_.call(null, tag__4802);
    if(or__3548__auto____4804) {
      return or__3548__auto____4804
    }else {
      var or__3548__auto____4805 = cljs.core.symbol_QMARK_.call(null, tag__4802);
      if(or__3548__auto____4805) {
        return or__3548__auto____4805
      }else {
        return cljs.core.string_QMARK_.call(null, tag__4802)
      }
    }
  }())) {
    throw Error([cljs.core.str(tag__4802), cljs.core.str(" is not a valid element name.")].join(""));
  }else {
  }
  var vec__4806__4807 = cljs.core.re_matches.call(null, cljsbinding.crate.re_tag, cljsbinding.crate.tag_str.call(null, tag__4802));
  var ___4808 = cljs.core.nth.call(null, vec__4806__4807, 0, null);
  var tag__4809 = cljs.core.nth.call(null, vec__4806__4807, 1, null);
  var id__4810 = cljs.core.nth.call(null, vec__4806__4807, 2, null);
  var class$__4811 = cljs.core.nth.call(null, vec__4806__4807, 3, null);
  var tag_attrs__4812 = cljs.core.ObjMap.fromObject(["\ufdd0'id", "\ufdd0'class"], {"\ufdd0'id":id__4810, "\ufdd0'class":cljs.core.truth_(class$__4811) ? class$__4811.replace(".", " ") : null});
  var map_attrs__4813 = cljs.core.first.call(null, content__4803);
  if(cljs.core.map_QMARK_.call(null, map_attrs__4813)) {
    return cljs.core.PersistentVector.fromArray([tag__4809, cljs.core.merge.call(null, tag_attrs__4812, map_attrs__4813), cljs.core.next.call(null, content__4803)])
  }else {
    return cljs.core.PersistentVector.fromArray([tag__4809, tag_attrs__4812, content__4803])
  }
};
cljsbinding.crate.add_binding = function() {
  var add_binding__delegate = function(elem, bind) {
    var vec__4814__4815 = cljsbinding.crate.normalize_element.call(null, elem);
    var tagname__4816 = cljs.core.nth.call(null, vec__4814__4815, 0, null);
    var attrs__4817 = cljs.core.nth.call(null, vec__4814__4815, 1, null);
    var content__4818 = cljs.core.nth.call(null, vec__4814__4815, 2, null);
    return cljs.core.PersistentVector.fromArray([tagname__4816, cljs.core.assoc.call(null, attrs__4817, "\ufdd0'withbinding", cljsbinding.register_bindingsource.call(null, bind))])
  };
  var add_binding = function(elem, var_args) {
    var bind = null;
    if(goog.isDef(var_args)) {
      bind = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return add_binding__delegate.call(this, elem, bind)
  };
  add_binding.cljs$lang$maxFixedArity = 1;
  add_binding.cljs$lang$applyTo = function(arglist__4819) {
    var elem = cljs.core.first(arglist__4819);
    var bind = cljs.core.rest(arglist__4819);
    return add_binding__delegate(elem, bind)
  };
  add_binding.cljs$lang$arity$variadic = add_binding__delegate;
  return add_binding
}();
cljsbinding.crate.bind_html_elem = function bind_html_elem(elem) {
  var bindingkey__4820 = jayq.core.attr.call(null, elem, "withbinding");
  cljsbinding.apply_bindingsource.call(null, elem, bindingkey__4820);
  return elem.removeAttr("withbinding")
};
