// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('alphabase.codec');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.bytes');
/**
 * Pure implementation of radix division to calculate a sequence of
 *   tokens from a byte array.
 */
alphabase.codec.pure_divide = (function alphabase$codec$pure_divide(alphabet,data){
var base = cljs.core.count(alphabet);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.nth,alphabet),cljs.core.reverse(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (base){
return (function alphabase$codec$pure_divide_$_add_byte(digits,value){
var digits__$1 = digits;
var carry = value;
var i = (0);
while(true){
if((i < cljs.core.count(digits__$1))){
var carry_SINGLEQUOTE_ = (carry + (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(digits__$1,i) << (8)));
var G__5881 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(digits__$1,i,cljs.core.mod(carry_SINGLEQUOTE_,base));
var G__5882 = ((carry_SINGLEQUOTE_ / base) | (0));
var G__5883 = (i + (1));
digits__$1 = G__5881;
carry = G__5882;
i = G__5883;
continue;
} else {
if((carry > (0))){
var G__5884 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(digits__$1,cljs.core.mod(carry,base));
var G__5885 = ((carry / base) | (0));
var G__5886 = (i + (1));
digits__$1 = G__5884;
carry = G__5885;
i = G__5886;
continue;
} else {
return digits__$1;
}
}
break;
}
});})(base))
,cljs.core.transient$(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)),alphabase.bytes.byte_seq(data)))));
});
/**
 * Encodes binary data using the given alphabet. Returns the encoded string, or
 *   nil if the input is nil or empty.
 */
alphabase.codec.encode = (function alphabase$codec$encode(alphabet,data){
if(typeof alphabet === 'string'){
} else {
throw (new Error("Assert failed: (string? alphabet)"));
}

if(((1) < cljs.core.count(alphabet))){
} else {
throw (new Error("Assert failed: (< 1 (count alphabet))"));
}

if(cljs.core.truth_((function (){var and__4120__auto__ = data;
if(cljs.core.truth_(and__4120__auto__)){
return (!((data.length === (0))));
} else {
return and__4120__auto__;
}
})())){
var zeroes = cljs.core.count(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.zero_QMARK_,alphabase.bytes.byte_seq(data)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(zeroes,cljs.core.first(alphabet)),(((zeroes < data.length))?alphabase.codec.pure_divide(alphabet,data):null)));
} else {
return null;
}
});
/**
 * Pure implementation of radix multiplication to calculate a sequence of byte
 *   values from a string of tokens.
 */
alphabase.codec.pure_multiply = (function alphabase$codec$pure_multiply(alphabet,tokens){
var base = cljs.core.count(alphabet);
return cljs.core.reverse(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (base){
return (function alphabase$codec$pure_multiply_$_add_token(bytev,token){
var value = alphabet.indexOf(cljs.core.str.cljs$core$IFn$_invoke$arity$1(token));
if((value < (0))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid token ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([token], 0))," is not in ",cljs.core._STAR_ns_STAR_," (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base),") alphabet"].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$alphabet,alphabet,cljs.core.cst$kw$token,token], null));
} else {
}

var bytev__$1 = bytev;
var carry = value;
var i = (0);
while(true){
if((i < cljs.core.count(bytev__$1))){
var carry_SINGLEQUOTE_ = (carry + (base * cljs.core.nth.cljs$core$IFn$_invoke$arity$2(bytev__$1,i)));
var G__5887 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(bytev__$1,i,(carry_SINGLEQUOTE_ & (255)));
var G__5888 = (carry_SINGLEQUOTE_ >> (8));
var G__5889 = (i + (1));
bytev__$1 = G__5887;
carry = G__5888;
i = G__5889;
continue;
} else {
if((carry > (0))){
var G__5890 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(bytev__$1,(carry & (255)));
var G__5891 = (carry >> (8));
var G__5892 = (i + (1));
bytev__$1 = G__5890;
carry = G__5891;
i = G__5892;
continue;
} else {
return bytev__$1;
}
}
break;
}
});})(base))
,cljs.core.transient$(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)),cljs.core.seq(tokens))));
});
/**
 * Decodes a string of alphabet tokens. Returns the decoded binary array, or nil
 *   if the input is nil or empty.
 */
alphabase.codec.decode = (function alphabase$codec$decode(alphabet,tokens){
if(typeof alphabet === 'string'){
} else {
throw (new Error("Assert failed: (string? alphabet)"));
}

if((!(cljs.core.empty_QMARK_(alphabet)))){
} else {
throw (new Error("Assert failed: (not (empty? alphabet))"));
}

if(cljs.core.empty_QMARK_(tokens)){
return null;
} else {
var zeroes = cljs.core.count(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.first(alphabet)]),tokens));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(zeroes,cljs.core.count(tokens))){
return alphabase.bytes.byte_array(zeroes);
} else {
var byte_seq = alphabase.codec.pure_multiply(alphabet,tokens);
var data = alphabase.bytes.byte_array((zeroes + cljs.core.count(byte_seq)));
var n__4607__auto___5893 = cljs.core.count(byte_seq);
var i_5894 = (0);
while(true){
if((i_5894 < n__4607__auto___5893)){
alphabase.bytes.set_byte(data,(zeroes + i_5894),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(byte_seq,i_5894));

var G__5895 = (i_5894 + (1));
i_5894 = G__5895;
continue;
} else {
}
break;
}

return data;
}
}
});
