// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core');
goog.require('goog.math.Long');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.10.520";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/** @define {string} */
goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
var and__4120__auto__ = (typeof setTimeout !== 'undefined');
if(and__4120__auto__){
var and__4120__auto____$1 = setTimeout(f,(0));
if(cljs.core.truth_(and__4120__auto____$1)){
return true;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return cljs.core._STAR_print_err_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$flush_DASH_on_DASH_newline,cljs.core._STAR_flush_on_newline_STAR_,cljs.core.cst$kw$readably,cljs.core._STAR_print_readably_STAR_,cljs.core.cst$kw$meta,cljs.core._STAR_print_meta_STAR_,cljs.core.cst$kw$dup,cljs.core._STAR_print_dup_STAR_,cljs.core.cst$kw$print_DASH_length,cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_((function (){
var xs = arguments;
return console.log.apply(console,goog.array.clone(xs));
}));

cljs.core.set_print_err_fn_BANG_((function (){
var xs = arguments;
return console.error.apply(console,goog.array.clone(xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__4120__auto__ = ty;
if(cljs.core.truth_(and__4120__auto__)){
return ty.cljs$lang$type;
} else {
return and__4120__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5733__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__2907 = arguments.length;
switch (G__2907) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2909 = arguments.length;
var i__4731__auto___2910 = (0);
while(true){
if((i__4731__auto___2910 < len__4730__auto___2909)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2910]));

var G__2911 = (i__4731__auto___2910 + (1));
i__4731__auto___2910 = G__2911;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__4607__auto___2912 = dimarray.length;
var i_2913 = (0);
while(true){
if((i_2913 < n__4607__auto___2912)){
(dimarray[i_2913] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__2914 = (i_2913 + (1));
i_2913 = G__2914;
continue;
} else {
}
break;
}

return dimarray;
});

/** @this {Function} */
cljs.core.make_array.cljs$lang$applyTo = (function (seq2904){
var G__2905 = cljs.core.first(seq2904);
var seq2904__$1 = cljs.core.next(seq2904);
var G__2906 = cljs.core.first(seq2904__$1);
var seq2904__$2 = cljs.core.next(seq2904__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2905,G__2906,seq2904__$2);
});

cljs.core.make_array.cljs$lang$maxFixedArity = (2);

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4607__auto___2915 = len;
var i_2916 = (0);
while(true){
if((i_2916 < n__4607__auto___2915)){
(new_arr[i_2916] = (arr[i_2916]));

var G__2917 = (i_2916 + (1));
i_2916 = G__2917;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__2918 = (i + (1));
i = G__2918;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__2923 = arguments.length;
switch (G__2923) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2926 = arguments.length;
var i__4731__auto___2927 = (0);
while(true){
if((i__4731__auto___2927 < len__4730__auto___2926)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2927]));

var G__2928 = (i__4731__auto___2927 + (1));
i__4731__auto___2927 = G__2928;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
try{if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.array_QMARK_(array);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e2924){var e_2929 = e2924;
cljs.core.maybe_warn(e_2929);
}
return (array[idx]);
});

cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
});

/** @this {Function} */
cljs.core.checked_aget.cljs$lang$applyTo = (function (seq2920){
var G__2921 = cljs.core.first(seq2920);
var seq2920__$1 = cljs.core.next(seq2920);
var G__2922 = cljs.core.first(seq2920__$1);
var seq2920__$2 = cljs.core.next(seq2920__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2921,G__2922,seq2920__$2);
});

cljs.core.checked_aget.cljs$lang$maxFixedArity = (2);

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__2935 = arguments.length;
switch (G__2935) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2938 = arguments.length;
var i__4731__auto___2939 = (0);
while(true){
if((i__4731__auto___2939 < len__4730__auto___2938)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2939]));

var G__2940 = (i__4731__auto___2939 + (1));
i__4731__auto___2939 = G__2940;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
try{if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.array_QMARK_(array);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e2936){var e_2941 = e2936;
cljs.core.maybe_warn(e_2941);
}
return (array[idx] = val);
});

cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
});

/** @this {Function} */
cljs.core.checked_aset.cljs$lang$applyTo = (function (seq2931){
var G__2932 = cljs.core.first(seq2931);
var seq2931__$1 = cljs.core.next(seq2931);
var G__2933 = cljs.core.first(seq2931__$1);
var seq2931__$2 = cljs.core.next(seq2931__$1);
var G__2934 = cljs.core.first(seq2931__$2);
var seq2931__$3 = cljs.core.next(seq2931__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2932,G__2933,G__2934,seq2931__$3);
});

cljs.core.checked_aset.cljs$lang$maxFixedArity = (3);

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__2946 = arguments.length;
switch (G__2946) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2948 = arguments.length;
var i__4731__auto___2949 = (0);
while(true){
if((i__4731__auto___2949 < len__4730__auto___2948)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2949]));

var G__2950 = (i__4731__auto___2949 + (1));
i__4731__auto___2949 = G__2950;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.array_QMARK_(array);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
});

cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
});

/** @this {Function} */
cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq2943){
var G__2944 = cljs.core.first(seq2943);
var seq2943__$1 = cljs.core.next(seq2943);
var G__2945 = cljs.core.first(seq2943__$1);
var seq2943__$2 = cljs.core.next(seq2943__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2944,G__2945,seq2943__$2);
});

cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2);

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__2956 = arguments.length;
switch (G__2956) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2958 = arguments.length;
var i__4731__auto___2959 = (0);
while(true){
if((i__4731__auto___2959 < len__4730__auto___2958)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2959]));

var G__2960 = (i__4731__auto___2959 + (1));
i__4731__auto___2959 = G__2960;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.array_QMARK_(array);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
});

cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
});

/** @this {Function} */
cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq2952){
var G__2953 = cljs.core.first(seq2952);
var seq2952__$1 = cljs.core.next(seq2952);
var G__2954 = cljs.core.first(seq2952__$1);
var seq2952__$2 = cljs.core.next(seq2952__$1);
var G__2955 = cljs.core.first(seq2952__$2);
var seq2952__$3 = cljs.core.next(seq2952__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2953,G__2954,G__2955,seq2952__$3);
});

cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3);

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__2965 = arguments.length;
switch (G__2965) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2967 = arguments.length;
var i__4731__auto___2968 = (0);
while(true){
if((i__4731__auto___2968 < len__4730__auto___2967)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2968]));

var G__2969 = (i__4731__auto___2968 + (1));
i__4731__auto___2968 = G__2969;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
return (array[idx]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
});

/** @this {Function} */
cljs.core.aget.cljs$lang$applyTo = (function (seq2962){
var G__2963 = cljs.core.first(seq2962);
var seq2962__$1 = cljs.core.next(seq2962);
var G__2964 = cljs.core.first(seq2962__$1);
var seq2962__$2 = cljs.core.next(seq2962__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2963,G__2964,seq2962__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__2975 = arguments.length;
switch (G__2975) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___2977 = arguments.length;
var i__4731__auto___2978 = (0);
while(true){
if((i__4731__auto___2978 < len__4730__auto___2977)){
args_arr__4751__auto__.push((arguments[i__4731__auto___2978]));

var G__2979 = (i__4731__auto___2978 + (1));
i__4731__auto___2978 = G__2979;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
return (array[idx] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
});

/** @this {Function} */
cljs.core.aset.cljs$lang$applyTo = (function (seq2971){
var G__2972 = cljs.core.first(seq2971);
var seq2971__$1 = cljs.core.next(seq2971);
var G__2973 = cljs.core.first(seq2971__$1);
var seq2971__$2 = cljs.core.next(seq2971__$1);
var G__2974 = cljs.core.first(seq2971__$2);
var seq2971__$3 = cljs.core.next(seq2971__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2972,G__2973,G__2974,seq2971__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__2981 = arguments.length;
switch (G__2981) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (a,x){
a.push(x);

return a;
}),[],aseq);
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2986 = arguments.length;
var i__4731__auto___2987 = (0);
while(true){
if((i__4731__auto___2987 < len__4730__auto___2986)){
args__4736__auto__.push((arguments[i__4731__auto___2987]));

var G__2988 = (i__4731__auto___2987 + (1));
i__4731__auto___2987 = G__2988;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
cljs.core.js_invoke.cljs$lang$applyTo = (function (seq2983){
var G__2984 = cljs.core.first(seq2983);
var seq2983__$1 = cljs.core.next(seq2983);
var G__2985 = cljs.core.first(seq2983__$1);
var seq2983__$2 = cljs.core.next(seq2983__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2984,G__2985,seq2983__$2);
});


/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__2990 = arguments.length;
switch (G__2990) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4434__auto__.call(null,this$));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4431__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4434__auto__.call(null,this$,a));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4431__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4434__auto__.call(null,this$,a,b));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4431__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4434__auto__.call(null,this$,a,b,c));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4431__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4434__auto__.call(null,this$,a,b,c,d));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4431__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4434__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4431__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4434__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4431__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._invoke[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4434__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__4431__auto__ = (cljs.core._invoke["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4431__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4433__auto__ = (((value == null))?null:value);
var m__4434__auto__ = (cljs.core._clone[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4434__auto__.call(null,value));
} else {
var m__4431__auto__ = (cljs.core._clone["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4431__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._count[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._count["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._empty[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._empty["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._conj[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4434__auto__.call(null,coll,o));
} else {
var m__4431__auto__ = (cljs.core._conj["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4431__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__2993 = arguments.length;
switch (G__2993) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._nth[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4434__auto__.call(null,coll,n));
} else {
var m__4431__auto__ = (cljs.core._nth["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4431__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._nth[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4434__auto__.call(null,coll,n,not_found));
} else {
var m__4431__auto__ = (cljs.core._nth["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4431__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._first[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._first["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
}
});

/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._rest[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._rest["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._next[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._next["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__2996 = arguments.length;
switch (G__2996) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._lookup[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4434__auto__.call(null,o,k));
} else {
var m__4431__auto__ = (cljs.core._lookup["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4431__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._lookup[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4434__auto__.call(null,o,k,not_found));
} else {
var m__4431__auto__ = (cljs.core._lookup["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4431__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4434__auto__.call(null,coll,k));
} else {
var m__4431__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4431__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._assoc[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4434__auto__.call(null,coll,k,v));
} else {
var m__4431__auto__ = (cljs.core._assoc["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4431__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._find[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4434__auto__.call(null,coll,k));
} else {
var m__4431__auto__ = (cljs.core._find["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4431__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._dissoc[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4434__auto__.call(null,coll,k));
} else {
var m__4431__auto__ = (cljs.core._dissoc["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4431__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._key[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._key["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._val[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._val["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._disjoin[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4434__auto__.call(null,coll,v));
} else {
var m__4431__auto__ = (cljs.core._disjoin["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4431__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._peek[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._peek["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._pop[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._pop["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._assoc_n[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4434__auto__.call(null,coll,n,val));
} else {
var m__4431__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4431__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._deref[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4434__auto__.call(null,o));
} else {
var m__4431__auto__ = (cljs.core._deref["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4431__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4434__auto__.call(null,o,msec,timeout_val));
} else {
var m__4431__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4431__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._meta[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4434__auto__.call(null,o));
} else {
var m__4431__auto__ = (cljs.core._meta["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4431__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._with_meta[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4434__auto__.call(null,o,meta));
} else {
var m__4431__auto__ = (cljs.core._with_meta["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4431__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__2999 = arguments.length;
switch (G__2999) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._reduce[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4434__auto__.call(null,coll,f));
} else {
var m__4431__auto__ = (cljs.core._reduce["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4431__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._reduce[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4434__auto__.call(null,coll,f,start));
} else {
var m__4431__auto__ = (cljs.core._reduce["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4431__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4434__auto__.call(null,coll,f,init));
} else {
var m__4431__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4431__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._equiv[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4434__auto__.call(null,o,other));
} else {
var m__4431__auto__ = (cljs.core._equiv["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4431__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._hash[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4434__auto__.call(null,o));
} else {
var m__4431__auto__ = (cljs.core._hash["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4431__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._seq[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4434__auto__.call(null,o));
} else {
var m__4431__auto__ = (cljs.core._seq["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4431__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._rseq[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._rseq["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4434__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__4431__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4431__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4434__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__4431__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4431__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._entry_key[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4434__auto__.call(null,coll,entry));
} else {
var m__4431__auto__ = (cljs.core._entry_key["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4431__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._comparator[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._comparator["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4433__auto__ = (((writer == null))?null:writer);
var m__4434__auto__ = (cljs.core._write[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4434__auto__.call(null,writer,s));
} else {
var m__4431__auto__ = (cljs.core._write["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4431__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4433__auto__ = (((writer == null))?null:writer);
var m__4434__auto__ = (cljs.core._flush[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4434__auto__.call(null,writer));
} else {
var m__4431__auto__ = (cljs.core._flush["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4431__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._pr_writer[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4434__auto__.call(null,o,writer,opts));
} else {
var m__4431__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4431__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
var x__4433__auto__ = (((x == null))?null:x);
var m__4434__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4434__auto__.call(null,x));
} else {
var m__4431__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4431__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._notify_watches[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4434__auto__.call(null,this$,oldval,newval));
} else {
var m__4431__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4431__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._add_watch[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4434__auto__.call(null,this$,key,f));
} else {
var m__4431__auto__ = (cljs.core._add_watch["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4431__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (cljs.core._remove_watch[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4434__auto__.call(null,this$,key));
} else {
var m__4431__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4431__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._as_transient[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._as_transient["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4434__auto__.call(null,tcoll,val));
} else {
var m__4431__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4431__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4434__auto__.call(null,tcoll));
} else {
var m__4431__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4431__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4434__auto__.call(null,tcoll,key,val));
} else {
var m__4431__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4431__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4434__auto__.call(null,tcoll,key));
} else {
var m__4431__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4431__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4434__auto__.call(null,tcoll,n,val));
} else {
var m__4431__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4431__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4434__auto__.call(null,tcoll));
} else {
var m__4431__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4431__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4433__auto__ = (((tcoll == null))?null:tcoll);
var m__4434__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4434__auto__.call(null,tcoll,v));
} else {
var m__4431__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4431__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4433__auto__ = (((x == null))?null:x);
var m__4434__auto__ = (cljs.core._compare[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4434__auto__.call(null,x,y));
} else {
var m__4431__auto__ = (cljs.core._compare["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4431__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._drop_first[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._drop_first["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._chunked_first[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._chunked_next[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4433__auto__ = (((x == null))?null:x);
var m__4434__auto__ = (cljs.core._name[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4434__auto__.call(null,x));
} else {
var m__4431__auto__ = (cljs.core._name["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4431__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4433__auto__ = (((x == null))?null:x);
var m__4434__auto__ = (cljs.core._namespace[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4434__auto__.call(null,x));
} else {
var m__4431__auto__ = (cljs.core._namespace["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4431__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4434__auto__.call(null,o,new_value));
} else {
var m__4431__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4431__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__3002 = arguments.length;
switch (G__3002) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4434__auto__.call(null,o,f));
} else {
var m__4431__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4431__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4434__auto__.call(null,o,f,a));
} else {
var m__4431__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4431__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4434__auto__.call(null,o,f,a,b));
} else {
var m__4431__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4431__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4434__auto__.call(null,o,f,a,b,xs));
} else {
var m__4431__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4431__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4433__auto__ = (((o == null))?null:o);
var m__4434__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4434__auto__.call(null,o,new_value));
} else {
var m__4431__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4431__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4433__auto__ = (((coll == null))?null:coll);
var m__4434__auto__ = (cljs.core._iterator[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4434__auto__.call(null,coll));
} else {
var m__4431__auto__ = (cljs.core._iterator["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4431__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/StringBufferWriter");
});

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__3004 = (i + (2));
var G__3005 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__3004;
h1 = G__3005;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__3008 = (i + (1));
var G__3009 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__3008;
hash = G__3009;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
goog.object.set(cljs.core.string_hash_cache,k,h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = ({});

cljs.core.string_hash_cache_count = (0);
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (cljs.core._hash(o) ^ (0));
} else {
if(typeof o === 'number'){
if(cljs.core.truth_(isFinite(o))){
return (Math.floor(o) % (2147483647));
} else {
var G__3013 = o;
switch (G__3013) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.not(a.ns);
if(and__4120__auto__){
return b.ns;
} else {
return and__4120__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__3015 = a.ns;
var G__3016 = b.ns;
return goog.array.defaultCompare(G__3015,G__3016);
})();
if(((0) === nsc)){
var G__3017 = a.name;
var G__3018 = b.name;
return goog.array.defaultCompare(G__3017,G__3018);
} else {
return nsc;
}
}
} else {
var G__3019 = a.name;
var G__3020 = b.name;
return goog.array.defaultCompare(G__3019,G__3020);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__3022 = null;
var G__3022__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var G__3022__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__3022 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__3022__2.call(this,self__,coll);
case 3:
return G__3022__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3022.cljs$core$IFn$_invoke$arity$2 = G__3022__2;
G__3022.cljs$core$IFn$_invoke$arity$3 = G__3022__3;
return G__3022;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args3021){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3021)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4243__auto__ = self__._hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Symbol");
});

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__3024 = arguments.length;
switch (G__3024) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__3026 = name.fqn;
name = G__3026;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
});

cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
});

cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
});

cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
});

cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Var.prototype.call = (function() {
var G__3070 = null;
var G__3070__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3028 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3028.cljs$core$IFn$_invoke$arity$0 ? fexpr__3028.cljs$core$IFn$_invoke$arity$0() : fexpr__3028.call(null));
});
var G__3070__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3029 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3029.cljs$core$IFn$_invoke$arity$1 ? fexpr__3029.cljs$core$IFn$_invoke$arity$1(a) : fexpr__3029.call(null,a));
});
var G__3070__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3030 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3030.cljs$core$IFn$_invoke$arity$2 ? fexpr__3030.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__3030.call(null,a,b));
});
var G__3070__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3031 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3031.cljs$core$IFn$_invoke$arity$3 ? fexpr__3031.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__3031.call(null,a,b,c));
});
var G__3070__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3032 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3032.cljs$core$IFn$_invoke$arity$4 ? fexpr__3032.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__3032.call(null,a,b,c,d));
});
var G__3070__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3033 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3033.cljs$core$IFn$_invoke$arity$5 ? fexpr__3033.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__3033.call(null,a,b,c,d,e));
});
var G__3070__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3034 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3034.cljs$core$IFn$_invoke$arity$6 ? fexpr__3034.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__3034.call(null,a,b,c,d,e,f));
});
var G__3070__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3035 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3035.cljs$core$IFn$_invoke$arity$7 ? fexpr__3035.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__3035.call(null,a,b,c,d,e,f,g));
});
var G__3070__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3036 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3036.cljs$core$IFn$_invoke$arity$8 ? fexpr__3036.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__3036.call(null,a,b,c,d,e,f,g,h));
});
var G__3070__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3037 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3037.cljs$core$IFn$_invoke$arity$9 ? fexpr__3037.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__3037.call(null,a,b,c,d,e,f,g,h,i));
});
var G__3070__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3038 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3038.cljs$core$IFn$_invoke$arity$10 ? fexpr__3038.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__3038.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__3070__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3039 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3039.cljs$core$IFn$_invoke$arity$11 ? fexpr__3039.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__3039.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__3070__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3040 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3040.cljs$core$IFn$_invoke$arity$12 ? fexpr__3040.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__3040.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__3070__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3041 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3041.cljs$core$IFn$_invoke$arity$13 ? fexpr__3041.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__3041.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__3070__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3042 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3042.cljs$core$IFn$_invoke$arity$14 ? fexpr__3042.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__3042.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__3070__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3043 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3043.cljs$core$IFn$_invoke$arity$15 ? fexpr__3043.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__3043.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__3070__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3044 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3044.cljs$core$IFn$_invoke$arity$16 ? fexpr__3044.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__3044.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__3070__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3045 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3045.cljs$core$IFn$_invoke$arity$17 ? fexpr__3045.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__3045.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__3070__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3046 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3046.cljs$core$IFn$_invoke$arity$18 ? fexpr__3046.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__3046.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__3070__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3047 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3047.cljs$core$IFn$_invoke$arity$19 ? fexpr__3047.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__3047.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__3070__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3048 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3048.cljs$core$IFn$_invoke$arity$20 ? fexpr__3048.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__3048.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__3070__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
G__3070 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__3070__1.call(this,self__);
case 2:
return G__3070__2.call(this,self__,a);
case 3:
return G__3070__3.call(this,self__,a,b);
case 4:
return G__3070__4.call(this,self__,a,b,c);
case 5:
return G__3070__5.call(this,self__,a,b,c,d);
case 6:
return G__3070__6.call(this,self__,a,b,c,d,e);
case 7:
return G__3070__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__3070__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__3070__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__3070__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__3070__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__3070__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__3070__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__3070__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__3070__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__3070__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__3070__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__3070__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__3070__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__3070__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__3070__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__3070__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3070.cljs$core$IFn$_invoke$arity$1 = G__3070__1;
G__3070.cljs$core$IFn$_invoke$arity$2 = G__3070__2;
G__3070.cljs$core$IFn$_invoke$arity$3 = G__3070__3;
G__3070.cljs$core$IFn$_invoke$arity$4 = G__3070__4;
G__3070.cljs$core$IFn$_invoke$arity$5 = G__3070__5;
G__3070.cljs$core$IFn$_invoke$arity$6 = G__3070__6;
G__3070.cljs$core$IFn$_invoke$arity$7 = G__3070__7;
G__3070.cljs$core$IFn$_invoke$arity$8 = G__3070__8;
G__3070.cljs$core$IFn$_invoke$arity$9 = G__3070__9;
G__3070.cljs$core$IFn$_invoke$arity$10 = G__3070__10;
G__3070.cljs$core$IFn$_invoke$arity$11 = G__3070__11;
G__3070.cljs$core$IFn$_invoke$arity$12 = G__3070__12;
G__3070.cljs$core$IFn$_invoke$arity$13 = G__3070__13;
G__3070.cljs$core$IFn$_invoke$arity$14 = G__3070__14;
G__3070.cljs$core$IFn$_invoke$arity$15 = G__3070__15;
G__3070.cljs$core$IFn$_invoke$arity$16 = G__3070__16;
G__3070.cljs$core$IFn$_invoke$arity$17 = G__3070__17;
G__3070.cljs$core$IFn$_invoke$arity$18 = G__3070__18;
G__3070.cljs$core$IFn$_invoke$arity$19 = G__3070__19;
G__3070.cljs$core$IFn$_invoke$arity$20 = G__3070__20;
G__3070.cljs$core$IFn$_invoke$arity$21 = G__3070__21;
G__3070.cljs$core$IFn$_invoke$arity$22 = G__3070__22;
return G__3070;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args3027){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3027)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
var fexpr__3049 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3049.cljs$core$IFn$_invoke$arity$0 ? fexpr__3049.cljs$core$IFn$_invoke$arity$0() : fexpr__3049.call(null));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var fexpr__3050 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3050.cljs$core$IFn$_invoke$arity$1 ? fexpr__3050.cljs$core$IFn$_invoke$arity$1(a) : fexpr__3050.call(null,a));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var fexpr__3051 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3051.cljs$core$IFn$_invoke$arity$2 ? fexpr__3051.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__3051.call(null,a,b));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var fexpr__3052 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3052.cljs$core$IFn$_invoke$arity$3 ? fexpr__3052.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__3052.call(null,a,b,c));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__3053 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3053.cljs$core$IFn$_invoke$arity$4 ? fexpr__3053.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__3053.call(null,a,b,c,d));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__3054 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3054.cljs$core$IFn$_invoke$arity$5 ? fexpr__3054.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__3054.call(null,a,b,c,d,e));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__3055 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3055.cljs$core$IFn$_invoke$arity$6 ? fexpr__3055.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__3055.call(null,a,b,c,d,e,f));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__3056 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3056.cljs$core$IFn$_invoke$arity$7 ? fexpr__3056.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__3056.call(null,a,b,c,d,e,f,g));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__3057 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3057.cljs$core$IFn$_invoke$arity$8 ? fexpr__3057.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__3057.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__3058 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3058.cljs$core$IFn$_invoke$arity$9 ? fexpr__3058.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__3058.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__3059 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3059.cljs$core$IFn$_invoke$arity$10 ? fexpr__3059.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__3059.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__3060 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3060.cljs$core$IFn$_invoke$arity$11 ? fexpr__3060.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__3060.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__3061 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3061.cljs$core$IFn$_invoke$arity$12 ? fexpr__3061.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__3061.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__3062 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3062.cljs$core$IFn$_invoke$arity$13 ? fexpr__3062.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__3062.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__3063 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3063.cljs$core$IFn$_invoke$arity$14 ? fexpr__3063.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__3063.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__3064 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3064.cljs$core$IFn$_invoke$arity$15 ? fexpr__3064.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__3064.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__3065 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3065.cljs$core$IFn$_invoke$arity$16 ? fexpr__3065.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__3065.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__3066 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3066.cljs$core$IFn$_invoke$arity$17 ? fexpr__3066.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__3066.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__3067 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3067.cljs$core$IFn$_invoke$arity$18 ? fexpr__3067.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__3067.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__3068 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3068.cljs$core$IFn$_invoke$arity$19 ? fexpr__3068.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__3068.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__3069 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3069.cljs$core$IFn$_invoke$arity$20 ? fexpr__3069.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__3069.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Var");
});

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core._seq(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return cljs.core._first(coll);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return cljs.core._rest(coll);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return cljs.core._next(coll);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__3081 = arguments.length;
switch (G__3081) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3083 = arguments.length;
var i__4731__auto___3084 = (0);
while(true){
if((i__4731__auto___3084 < len__4730__auto___3083)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3084]));

var G__3085 = (i__4731__auto___3084 + (1));
i__4731__auto___3084 = G__3085;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__3086 = y;
var G__3087 = cljs.core.first(more);
var G__3088 = cljs.core.next(more);
x = G__3086;
y = G__3087;
more = G__3088;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

/** @this {Function} */
cljs.core._EQ_.cljs$lang$applyTo = (function (seq3078){
var G__3079 = cljs.core.first(seq3078);
var seq3078__$1 = cljs.core.next(seq3078);
var G__3080 = cljs.core.first(seq3078__$1);
var seq3078__$2 = cljs.core.next(seq3078__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3079,G__3080,seq3078__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ES6Iterator");
});

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = cljs.core.es6_iterator_seq(self__.iter);
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ES6IteratorSeq");
});

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__3089 = (n + (1));
var G__3090 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__3091 = cljs.core.next(coll__$1);
n = G__3089;
hash_code = G__3090;
coll__$1 = G__3091;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__3092 = (n + (1));
var G__3093 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__3094 = cljs.core.next(coll__$1);
n = G__3092;
hash_code = G__3093;
coll__$1 = G__3094;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


goog.object.set(cljs.core.ICounted,"null",true);

var G__3095_3098 = cljs.core._count;
var G__3096_3099 = "null";
var G__3097_3100 = ((function (G__3095_3098,G__3096_3099){
return (function (_){
return (0);
});})(G__3095_3098,G__3096_3099))
;
goog.object.set(G__3095_3098,G__3096_3099,G__3097_3100);
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
});

Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__3101 = this$__$1.valueOf();
var G__3102 = other.valueOf();
return goog.array.defaultCompare(G__3101,G__3102);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
});

/**
 * @interface
 */
cljs.core.Inst = function(){};

cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
var x__4433__auto__ = (((inst == null))?null:inst);
var m__4434__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4434__auto__.call(null,inst));
} else {
var m__4431__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4431__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
}
});

Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
});
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
goog.object.set(cljs.core.IEquiv,"number",true);

var G__3104_3107 = cljs.core._equiv;
var G__3105_3108 = "number";
var G__3106_3109 = ((function (G__3104_3107,G__3105_3108){
return (function (x,o){
return (x === o);
});})(G__3104_3107,G__3105_3108))
;
goog.object.set(G__3104_3107,G__3105_3108,G__3106_3109);
goog.object.set(cljs.core.Fn,"function",true);

goog.object.set(cljs.core.IMeta,"function",true);

var G__3110_3113 = cljs.core._meta;
var G__3111_3114 = "function";
var G__3112_3115 = ((function (G__3110_3113,G__3111_3114){
return (function (_){
return null;
});})(G__3110_3113,G__3111_3114))
;
goog.object.set(G__3110_3113,G__3111_3114,G__3112_3115);
goog.object.set(cljs.core.IHash,"_",true);

var G__3116_3119 = cljs.core._hash;
var G__3117_3120 = "_";
var G__3118_3121 = ((function (G__3116_3119,G__3117_3120){
return (function (o){
return goog.getUid(o);
});})(G__3116_3119,G__3117_3120))
;
goog.object.set(G__3116_3119,G__3117_3120,G__3118_3121);
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Reduced");
});

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__3123 = arguments.length;
switch (G__3123) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__3124 = val;
var G__3125 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3124,G__3125) : f.call(null,G__3124,G__3125));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3131 = nval;
var G__3132 = (n + (1));
val = G__3131;
n = G__3132;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__3126 = val__$1;
var G__3127 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3126,G__3127) : f.call(null,G__3126,G__3127));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3133 = nval;
var G__3134 = (n + (1));
val__$1 = G__3133;
n = G__3134;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__3128 = val__$1;
var G__3129 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3128,G__3129) : f.call(null,G__3128,G__3129));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3135 = nval;
var G__3136 = (n + (1));
val__$1 = G__3135;
n = G__3136;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__3138 = arguments.length;
switch (G__3138) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__3139 = val;
var G__3140 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3139,G__3140) : f.call(null,G__3139,G__3140));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3146 = nval;
var G__3147 = (n + (1));
val = G__3146;
n = G__3147;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__3141 = val__$1;
var G__3142 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3141,G__3142) : f.call(null,G__3141,G__3142));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3148 = nval;
var G__3149 = (n + (1));
val__$1 = G__3148;
n = G__3149;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__3143 = val__$1;
var G__3144 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3143,G__3144) : f.call(null,G__3143,G__3144));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3150 = nval;
var G__3151 = (n + (1));
val__$1 = G__3150;
n = G__3151;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__3155 = arguments.length;
switch (G__3155) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__4219__auto__ = (0);
var y__4220__auto__ = (start + len);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__3157 = (idx + (1));
idx = G__3157;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._indexOf.cljs$lang$maxFixedArity = 3;

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__3159 = arguments.length;
switch (G__3159) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__4222__auto__ = (len - (1));
var y__4223__auto__ = start;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__3161 = (idx - (1));
idx = G__3161;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/IndexedSeqIterator");
});

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__3162 = null;
var G__3162__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3162__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3162 = function(x,start){
switch(arguments.length){
case 1:
return G__3162__1.call(this,x);
case 2:
return G__3162__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3162.cljs$core$IFn$_invoke$arity$1 = G__3162__1;
G__3162.cljs$core$IFn$_invoke$arity$2 = G__3162__2;
return G__3162;
})()
;

cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__3163 = null;
var G__3163__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3163__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3163 = function(x,start){
switch(arguments.length){
case 1:
return G__3163__1.call(this,x);
case 2:
return G__3163__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3163.cljs$core$IFn$_invoke$arity$1 = G__3163__1;
G__3163.cljs$core$IFn$_invoke$arity$2 = G__3163__2;
return G__3163;
})()
;

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__4219__auto__ = (0);
var y__4220__auto__ = (self__.arr.length - self__.i);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/IndexedSeq");
});

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

var G__3164_3167 = cljs.core.IndexedSeq.prototype;
var G__3165_3168 = cljs.core.ITER_SYMBOL;
var G__3166_3169 = ((function (G__3164_3167,G__3165_3168){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3164_3167,G__3165_3168))
;
goog.object.set(G__3164_3167,G__3165_3168,G__3166_3169);
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__3171 = arguments.length;
switch (G__3171) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__3174 = arguments.length;
switch (G__3174) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.indexOf = (function() {
var G__3176 = null;
var G__3176__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3176__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3176 = function(x,start){
switch(arguments.length){
case 1:
return G__3176__1.call(this,x);
case 2:
return G__3176__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3176.cljs$core$IFn$_invoke$arity$1 = G__3176__1;
G__3176.cljs$core$IFn$_invoke$arity$2 = G__3176__2;
return G__3176;
})()
;

cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__3177 = null;
var G__3177__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3177__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3177 = function(x,start){
switch(arguments.length){
case 1:
return G__3177__1.call(this,x);
case 2:
return G__3177__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3177.cljs$core$IFn$_invoke$arity$1 = G__3177__1;
G__3177.cljs$core$IFn$_invoke$arity$2 = G__3177__2;
return G__3177;
})()
;

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/RSeq");
});

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

var G__3178_3181 = cljs.core.RSeq.prototype;
var G__3179_3182 = cljs.core.ITER_SYMBOL;
var G__3180_3183 = ((function (G__3178_3181,G__3179_3182){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3178_3181,G__3179_3182))
;
goog.object.set(G__3178_3181,G__3179_3182,G__3180_3183);
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__3184 = sn;
s = G__3184;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
goog.object.set(cljs.core.IEquiv,"_",true);

var G__3185_3188 = cljs.core._equiv;
var G__3186_3189 = "_";
var G__3187_3190 = ((function (G__3185_3188,G__3186_3189){
return (function (x,o){
return (x === o);
});})(G__3185_3188,G__3186_3189))
;
goog.object.set(G__3185_3188,G__3186_3189,G__3187_3190);
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__3195 = arguments.length;
switch (G__3195) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3197 = arguments.length;
var i__4731__auto___3198 = (0);
while(true){
if((i__4731__auto___3198 < len__4730__auto___3197)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3198]));

var G__3199 = (i__4731__auto___3198 + (1));
i__4731__auto___3198 = G__3199;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__3200 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__3201 = cljs.core.first(xs);
var G__3202 = cljs.core.next(xs);
coll = G__3200;
x = G__3201;
xs = G__3202;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

/** @this {Function} */
cljs.core.conj.cljs$lang$applyTo = (function (seq3192){
var G__3193 = cljs.core.first(seq3192);
var seq3192__$1 = cljs.core.next(seq3192);
var G__3194 = cljs.core.first(seq3192__$1);
var seq3192__$2 = cljs.core.next(seq3192__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3193,G__3194,seq3192__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return cljs.core._empty(coll);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__3205 = cljs.core.next(s);
var G__3206 = (acc + (1));
s = G__3205;
acc = G__3206;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return cljs.core._count(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__3210 = arguments.length;
switch (G__3210) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__3212 = cljs.core.next(coll);
var G__3213 = (n - (1));
coll = G__3212;
n = G__3213;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__3214 = cljs.core.next(coll);
var G__3215 = (n - (1));
var G__3216 = not_found;
coll = G__3214;
n = G__3215;
not_found = G__3216;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__3218 = arguments.length;
switch (G__3218) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__4131__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__4131__auto__){
return or__4131__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__4131__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__4131__auto__){
return or__4131__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
var temp__5733__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5733__auto__){
var xs__$1 = temp__5733__auto__;
var G__3228 = (n__$1 - (1));
var G__3229 = cljs.core.rest(xs__$1);
n__$1 = G__3228;
xs = G__3229;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__3231 = arguments.length;
switch (G__3231) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && ((k < o.length)))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__3240 = arguments.length;
switch (G__3240) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3242 = arguments.length;
var i__4731__auto___3243 = (0);
while(true){
if((i__4731__auto___3243 < len__4730__auto___3242)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3243]));

var G__3244 = (i__4731__auto___3243 + (1));
i__4731__auto___3243 = G__3244;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__3245 = ret;
var G__3246 = cljs.core.first(kvs);
var G__3247 = cljs.core.second(kvs);
var G__3248 = cljs.core.nnext(kvs);
coll = G__3245;
k = G__3246;
v = G__3247;
kvs = G__3248;
continue;
} else {
return ret;
}
break;
}
});

/** @this {Function} */
cljs.core.assoc.cljs$lang$applyTo = (function (seq3236){
var G__3237 = cljs.core.first(seq3236);
var seq3236__$1 = cljs.core.next(seq3236);
var G__3238 = cljs.core.first(seq3236__$1);
var seq3236__$2 = cljs.core.next(seq3236__$1);
var G__3239 = cljs.core.first(seq3236__$2);
var seq3236__$3 = cljs.core.next(seq3236__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3237,G__3238,G__3239,seq3236__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__3253 = arguments.length;
switch (G__3253) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3255 = arguments.length;
var i__4731__auto___3256 = (0);
while(true){
if((i__4731__auto___3256 < len__4730__auto___3255)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3256]));

var G__3257 = (i__4731__auto___3256 + (1));
i__4731__auto___3256 = G__3257;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__3258 = ret;
var G__3259 = cljs.core.first(ks);
var G__3260 = cljs.core.next(ks);
coll = G__3258;
k = G__3259;
ks = G__3260;
continue;
} else {
return ret;
}
}
break;
}
});

/** @this {Function} */
cljs.core.dissoc.cljs$lang$applyTo = (function (seq3250){
var G__3251 = cljs.core.first(seq3250);
var seq3250__$1 = cljs.core.next(seq3250);
var G__3252 = cljs.core.first(seq3250__$1);
var seq3250__$2 = cljs.core.next(seq3250__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3251,G__3252,seq3250__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__4131__auto__ = goog.isFunction(f);
if(or__4131__auto__){
return or__4131__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.MetaFn.prototype.call = (function() {
var G__3264 = null;
var G__3264__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__3264__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__3264__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__3264__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__3264__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__3264__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__3264__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__3264__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__3264__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__3264__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__3264__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__3264__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__3264__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__3264__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__3264__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__3264__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__3264__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__3264__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__3264__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__3264__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__3264__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__3264__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
G__3264 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__3264__1.call(this,self__);
case 2:
return G__3264__2.call(this,self__,a);
case 3:
return G__3264__3.call(this,self__,a,b);
case 4:
return G__3264__4.call(this,self__,a,b,c);
case 5:
return G__3264__5.call(this,self__,a,b,c,d);
case 6:
return G__3264__6.call(this,self__,a,b,c,d,e);
case 7:
return G__3264__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__3264__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__3264__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__3264__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__3264__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__3264__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__3264__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__3264__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__3264__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__3264__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__3264__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__3264__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__3264__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__3264__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__3264__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__3264__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3264.cljs$core$IFn$_invoke$arity$1 = G__3264__1;
G__3264.cljs$core$IFn$_invoke$arity$2 = G__3264__2;
G__3264.cljs$core$IFn$_invoke$arity$3 = G__3264__3;
G__3264.cljs$core$IFn$_invoke$arity$4 = G__3264__4;
G__3264.cljs$core$IFn$_invoke$arity$5 = G__3264__5;
G__3264.cljs$core$IFn$_invoke$arity$6 = G__3264__6;
G__3264.cljs$core$IFn$_invoke$arity$7 = G__3264__7;
G__3264.cljs$core$IFn$_invoke$arity$8 = G__3264__8;
G__3264.cljs$core$IFn$_invoke$arity$9 = G__3264__9;
G__3264.cljs$core$IFn$_invoke$arity$10 = G__3264__10;
G__3264.cljs$core$IFn$_invoke$arity$11 = G__3264__11;
G__3264.cljs$core$IFn$_invoke$arity$12 = G__3264__12;
G__3264.cljs$core$IFn$_invoke$arity$13 = G__3264__13;
G__3264.cljs$core$IFn$_invoke$arity$14 = G__3264__14;
G__3264.cljs$core$IFn$_invoke$arity$15 = G__3264__15;
G__3264.cljs$core$IFn$_invoke$arity$16 = G__3264__16;
G__3264.cljs$core$IFn$_invoke$arity$17 = G__3264__17;
G__3264.cljs$core$IFn$_invoke$arity$18 = G__3264__18;
G__3264.cljs$core$IFn$_invoke$arity$19 = G__3264__19;
G__3264.cljs$core$IFn$_invoke$arity$20 = G__3264__20;
G__3264.cljs$core$IFn$_invoke$arity$21 = G__3264__21;
G__3264.cljs$core$IFn$_invoke$arity$22 = G__3264__22;
return G__3264;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args3263){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3263)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/MetaFn");
});

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__4120__auto__ = (!((o == null)));
if(and__4120__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__4120__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__3271 = arguments.length;
switch (G__3271) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3273 = arguments.length;
var i__4731__auto___3274 = (0);
while(true){
if((i__4731__auto___3274 < len__4730__auto___3273)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3274]));

var G__3275 = (i__4731__auto___3274 + (1));
i__4731__auto___3274 = G__3275;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__3276 = ret;
var G__3277 = cljs.core.first(ks);
var G__3278 = cljs.core.next(ks);
coll = G__3276;
k = G__3277;
ks = G__3278;
continue;
} else {
return ret;
}
}
break;
}
});

/** @this {Function} */
cljs.core.disj.cljs$lang$applyTo = (function (seq3268){
var G__3269 = cljs.core.first(seq3268);
var seq3268__$1 = cljs.core.next(seq3268);
var G__3270 = cljs.core.first(seq3268__$1);
var seq3268__$2 = cljs.core.next(seq3268__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3269,G__3270,seq3268__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return (((coll == null)) || (cljs.core.not(cljs.core.seq(coll))));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__3292 = arguments.length;
switch (G__3292) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3296 = arguments.length;
var i__4731__auto___3297 = (0);
while(true){
if((i__4731__auto___3297 < len__4730__auto___3296)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3297]));

var G__3298 = (i__4731__auto___3297 + (1));
i__4731__auto___3297 = G__3298;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4752__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals);
});

/** @this {Function} */
cljs.core.js_obj.cljs$lang$applyTo = (function (seq3291){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq3291));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return goog.object.getKeys(obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__3299 = (i__$1 + (1));
var G__3300 = (j__$1 + (1));
var G__3301 = (len__$1 - (1));
i__$1 = G__3299;
j__$1 = G__3300;
len__$1 = G__3301;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__3302 = (i__$1 - (1));
var G__3303 = (j__$1 - (1));
var G__3304 = (len__$1 - (1));
i__$1 = G__3302;
j__$1 = G__3303;
len__$1 = G__3304;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__4131__auto__ = (s == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__4131__auto__ = cljs.core.fn_QMARK_(f);
if(or__4131__auto__){
return or__4131__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((!(isNaN(n)))) && ((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))));
});
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long)));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof goog.math.Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof goog.math.Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof goog.math.Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__3317 = arguments.length;
switch (G__3317) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3319 = arguments.length;
var i__4731__auto___3320 = (0);
while(true){
if((i__4731__auto___3320 < len__4730__auto___3319)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3320]));

var G__3321 = (i__4731__auto___3320 + (1));
i__4731__auto___3320 = G__3321;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__3322 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__3323 = etc;
s = G__3322;
xs = G__3323;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

/** @this {Function} */
cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq3314){
var G__3315 = cljs.core.first(seq3314);
var seq3314__$1 = cljs.core.next(seq3314);
var G__3316 = cljs.core.first(seq3314__$1);
var seq3314__$2 = cljs.core.next(seq3314__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3315,G__3316,seq3314__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__3326 = arguments.length;
switch (G__3326) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__3328 = xs;
var G__3329 = ys;
var G__3330 = len;
var G__3331 = (n + (1));
xs = G__3328;
ys = G__3329;
len = G__3330;
n = G__3331;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__3333 = arguments.length;
switch (G__3333) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__3334_3337 = a;
var G__3335_3338 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__3334_3337,G__3335_3338);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__3340 = arguments.length;
switch (G__3340) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
var G__3342 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__3343 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__3341 = cljs.core.fn__GT_comparator(comp);
return (fexpr__3341.cljs$core$IFn$_invoke$arity$2 ? fexpr__3341.cljs$core$IFn$_invoke$arity$2(G__3342,G__3343) : fexpr__3341.call(null,G__3342,G__3343));
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__3346 = arguments.length;
switch (G__3346) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__5733__auto__ = cljs.core.seq(coll);
if(temp__5733__auto__){
var s = temp__5733__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__3347 = val__$1;
var G__3348 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3347,G__3348) : f.call(null,G__3347,G__3348));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3350 = nval;
var G__3351 = cljs.core.next(coll__$1);
val__$1 = G__3350;
coll__$1 = G__3351;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
goog.array.shuffle(a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__3353 = arguments.length;
switch (G__3353) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__3354 = acc;
var G__3355 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3354,G__3355) : f.call(null,G__3354,G__3355));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__3359 = nacc;
acc = G__3359;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__3356 = acc;
var G__3357 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3356,G__3357) : f.call(null,G__3356,G__3357));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__3360 = nacc;
acc = G__3360;
continue;
}
} else {
return acc;
}
break;
}
});

cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3;

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__3362 = arguments.length;
switch (G__3362) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((!((coll == null)))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__3367 = arguments.length;
switch (G__3367) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__3369 = null;
var G__3369__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__3369__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__3369__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__3369 = function(x,y){
switch(arguments.length){
case 0:
return G__3369__0.call(this);
case 1:
return G__3369__1.call(this,x);
case 2:
return G__3369__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3369.cljs$core$IFn$_invoke$arity$0 = G__3369__0;
G__3369.cljs$core$IFn$_invoke$arity$1 = G__3369__1;
G__3369.cljs$core$IFn$_invoke$arity$2 = G__3369__2;
return G__3369;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__3371 = arguments.length;
switch (G__3371) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__3377 = arguments.length;
switch (G__3377) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3379 = arguments.length;
var i__4731__auto___3380 = (0);
while(true){
if((i__4731__auto___3380 < len__4730__auto___3379)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3380]));

var G__3381 = (i__4731__auto___3380 + (1));
i__4731__auto___3380 = G__3381;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

/** @this {Function} */
cljs.core._PLUS_.cljs$lang$applyTo = (function (seq3374){
var G__3375 = cljs.core.first(seq3374);
var seq3374__$1 = cljs.core.next(seq3374);
var G__3376 = cljs.core.first(seq3374__$1);
var seq3374__$2 = cljs.core.next(seq3374__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3375,G__3376,seq3374__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__3386 = arguments.length;
switch (G__3386) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3388 = arguments.length;
var i__4731__auto___3389 = (0);
while(true){
if((i__4731__auto___3389 < len__4730__auto___3388)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3389]));

var G__3390 = (i__4731__auto___3389 + (1));
i__4731__auto___3389 = G__3390;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

/** @this {Function} */
cljs.core._.cljs$lang$applyTo = (function (seq3383){
var G__3384 = cljs.core.first(seq3383);
var seq3383__$1 = cljs.core.next(seq3383);
var G__3385 = cljs.core.first(seq3383__$1);
var seq3383__$2 = cljs.core.next(seq3383__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3384,G__3385,seq3383__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__3395 = arguments.length;
switch (G__3395) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3397 = arguments.length;
var i__4731__auto___3398 = (0);
while(true){
if((i__4731__auto___3398 < len__4730__auto___3397)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3398]));

var G__3399 = (i__4731__auto___3398 + (1));
i__4731__auto___3398 = G__3399;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

/** @this {Function} */
cljs.core._STAR_.cljs$lang$applyTo = (function (seq3392){
var G__3393 = cljs.core.first(seq3392);
var seq3392__$1 = cljs.core.next(seq3392);
var G__3394 = cljs.core.first(seq3392__$1);
var seq3392__$2 = cljs.core.next(seq3392__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3393,G__3394,seq3392__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__3404 = arguments.length;
switch (G__3404) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3406 = arguments.length;
var i__4731__auto___3407 = (0);
while(true){
if((i__4731__auto___3407 < len__4730__auto___3406)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3407]));

var G__3408 = (i__4731__auto___3407 + (1));
i__4731__auto___3407 = G__3408;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

/** @this {Function} */
cljs.core._SLASH_.cljs$lang$applyTo = (function (seq3401){
var G__3402 = cljs.core.first(seq3401);
var seq3401__$1 = cljs.core.next(seq3401);
var G__3403 = cljs.core.first(seq3401__$1);
var seq3401__$2 = cljs.core.next(seq3401__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3402,G__3403,seq3401__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__3413 = arguments.length;
switch (G__3413) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3415 = arguments.length;
var i__4731__auto___3416 = (0);
while(true){
if((i__4731__auto___3416 < len__4730__auto___3415)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3416]));

var G__3417 = (i__4731__auto___3416 + (1));
i__4731__auto___3416 = G__3417;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__3418 = y;
var G__3419 = cljs.core.first(more);
var G__3420 = cljs.core.next(more);
x = G__3418;
y = G__3419;
more = G__3420;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

/** @this {Function} */
cljs.core._LT_.cljs$lang$applyTo = (function (seq3410){
var G__3411 = cljs.core.first(seq3410);
var seq3410__$1 = cljs.core.next(seq3410);
var G__3412 = cljs.core.first(seq3410__$1);
var seq3410__$2 = cljs.core.next(seq3410__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3411,G__3412,seq3410__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__3425 = arguments.length;
switch (G__3425) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3427 = arguments.length;
var i__4731__auto___3428 = (0);
while(true){
if((i__4731__auto___3428 < len__4730__auto___3427)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3428]));

var G__3429 = (i__4731__auto___3428 + (1));
i__4731__auto___3428 = G__3429;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__3430 = y;
var G__3431 = cljs.core.first(more);
var G__3432 = cljs.core.next(more);
x = G__3430;
y = G__3431;
more = G__3432;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

/** @this {Function} */
cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq3422){
var G__3423 = cljs.core.first(seq3422);
var seq3422__$1 = cljs.core.next(seq3422);
var G__3424 = cljs.core.first(seq3422__$1);
var seq3422__$2 = cljs.core.next(seq3422__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3423,G__3424,seq3422__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__3437 = arguments.length;
switch (G__3437) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3439 = arguments.length;
var i__4731__auto___3440 = (0);
while(true){
if((i__4731__auto___3440 < len__4730__auto___3439)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3440]));

var G__3441 = (i__4731__auto___3440 + (1));
i__4731__auto___3440 = G__3441;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__3442 = y;
var G__3443 = cljs.core.first(more);
var G__3444 = cljs.core.next(more);
x = G__3442;
y = G__3443;
more = G__3444;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

/** @this {Function} */
cljs.core._GT_.cljs$lang$applyTo = (function (seq3434){
var G__3435 = cljs.core.first(seq3434);
var seq3434__$1 = cljs.core.next(seq3434);
var G__3436 = cljs.core.first(seq3434__$1);
var seq3434__$2 = cljs.core.next(seq3434__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3435,G__3436,seq3434__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__3449 = arguments.length;
switch (G__3449) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3451 = arguments.length;
var i__4731__auto___3452 = (0);
while(true){
if((i__4731__auto___3452 < len__4730__auto___3451)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3452]));

var G__3453 = (i__4731__auto___3452 + (1));
i__4731__auto___3452 = G__3453;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__3454 = y;
var G__3455 = cljs.core.first(more);
var G__3456 = cljs.core.next(more);
x = G__3454;
y = G__3455;
more = G__3456;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

/** @this {Function} */
cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq3446){
var G__3447 = cljs.core.first(seq3446);
var seq3446__$1 = cljs.core.next(seq3446);
var G__3448 = cljs.core.first(seq3446__$1);
var seq3446__$2 = cljs.core.next(seq3446__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3447,G__3448,seq3446__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__3461 = arguments.length;
switch (G__3461) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3463 = arguments.length;
var i__4731__auto___3464 = (0);
while(true){
if((i__4731__auto___3464 < len__4730__auto___3463)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3464]));

var G__3465 = (i__4731__auto___3464 + (1));
i__4731__auto___3464 = G__3465;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4219__auto__ = x;
var y__4220__auto__ = y;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4219__auto__ = x;
var y__4220__auto__ = y;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})(),more);
});

/** @this {Function} */
cljs.core.max.cljs$lang$applyTo = (function (seq3458){
var G__3459 = cljs.core.first(seq3458);
var seq3458__$1 = cljs.core.next(seq3458);
var G__3460 = cljs.core.first(seq3458__$1);
var seq3458__$2 = cljs.core.next(seq3458__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3459,G__3460,seq3458__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__3470 = arguments.length;
switch (G__3470) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3472 = arguments.length;
var i__4731__auto___3473 = (0);
while(true){
if((i__4731__auto___3473 < len__4730__auto___3472)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3473]));

var G__3474 = (i__4731__auto___3473 + (1));
i__4731__auto___3473 = G__3474;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4222__auto__ = x;
var y__4223__auto__ = y;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4222__auto__ = x;
var y__4223__auto__ = y;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})(),more);
});

/** @this {Function} */
cljs.core.min.cljs$lang$applyTo = (function (seq3467){
var G__3468 = cljs.core.first(seq3467);
var seq3467__$1 = cljs.core.next(seq3467);
var G__3469 = cljs.core.first(seq3467__$1);
var seq3467__$2 = cljs.core.next(seq3467__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3468,G__3469,seq3467__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__3479 = arguments.length;
switch (G__3479) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3481 = arguments.length;
var i__4731__auto___3482 = (0);
while(true){
if((i__4731__auto___3482 < len__4730__auto___3481)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3482]));

var G__3483 = (i__4731__auto___3482 + (1));
i__4731__auto___3482 = G__3483;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

/** @this {Function} */
cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq3476){
var G__3477 = cljs.core.first(seq3476);
var seq3476__$1 = cljs.core.next(seq3476);
var G__3478 = cljs.core.first(seq3476__$1);
var seq3476__$2 = cljs.core.next(seq3476__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3477,G__3478,seq3476__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__3488 = arguments.length;
switch (G__3488) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3490 = arguments.length;
var i__4731__auto___3491 = (0);
while(true){
if((i__4731__auto___3491 < len__4730__auto___3490)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3491]));

var G__3492 = (i__4731__auto___3491 + (1));
i__4731__auto___3491 = G__3492;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

/** @this {Function} */
cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq3485){
var G__3486 = cljs.core.first(seq3485);
var seq3485__$1 = cljs.core.next(seq3485);
var G__3487 = cljs.core.first(seq3485__$1);
var seq3485__$2 = cljs.core.next(seq3485__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3486,G__3487,seq3485__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__3497 = arguments.length;
switch (G__3497) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3499 = arguments.length;
var i__4731__auto___3500 = (0);
while(true){
if((i__4731__auto___3500 < len__4730__auto___3499)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3500]));

var G__3501 = (i__4731__auto___3500 + (1));
i__4731__auto___3500 = G__3501;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

/** @this {Function} */
cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq3494){
var G__3495 = cljs.core.first(seq3494);
var seq3494__$1 = cljs.core.next(seq3494);
var G__3496 = cljs.core.first(seq3494__$1);
var seq3494__$2 = cljs.core.next(seq3494__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3495,G__3496,seq3494__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__3506 = arguments.length;
switch (G__3506) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3508 = arguments.length;
var i__4731__auto___3509 = (0);
while(true){
if((i__4731__auto___3509 < len__4730__auto___3508)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3509]));

var G__3510 = (i__4731__auto___3509 + (1));
i__4731__auto___3509 = G__3510;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

/** @this {Function} */
cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq3503){
var G__3504 = cljs.core.first(seq3503);
var seq3503__$1 = cljs.core.next(seq3503);
var G__3505 = cljs.core.first(seq3503__$1);
var seq3503__$2 = cljs.core.next(seq3503__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3504,G__3505,seq3503__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__3515 = arguments.length;
switch (G__3515) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3517 = arguments.length;
var i__4731__auto___3518 = (0);
while(true){
if((i__4731__auto___3518 < len__4730__auto___3517)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3518]));

var G__3519 = (i__4731__auto___3518 + (1));
i__4731__auto___3518 = G__3519;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

/** @this {Function} */
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq3512){
var G__3513 = cljs.core.first(seq3512);
var seq3512__$1 = cljs.core.next(seq3512);
var G__3514 = cljs.core.first(seq3512__$1);
var seq3512__$2 = cljs.core.next(seq3512__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3513,G__3514,seq3512__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__3524 = arguments.length;
switch (G__3524) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3526 = arguments.length;
var i__4731__auto___3527 = (0);
while(true){
if((i__4731__auto___3527 < len__4730__auto___3526)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3527]));

var G__3528 = (i__4731__auto___3527 + (1));
i__4731__auto___3527 = G__3528;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

/** @this {Function} */
cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq3521){
var G__3522 = cljs.core.first(seq3521);
var seq3521__$1 = cljs.core.next(seq3521);
var G__3523 = cljs.core.first(seq3521__$1);
var seq3521__$2 = cljs.core.next(seq3521__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3522,G__3523,seq3521__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__3533 = arguments.length;
switch (G__3533) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3535 = arguments.length;
var i__4731__auto___3536 = (0);
while(true){
if((i__4731__auto___3536 < len__4730__auto___3535)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3536]));

var G__3537 = (i__4731__auto___3536 + (1));
i__4731__auto___3536 = G__3537;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

/** @this {Function} */
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq3530){
var G__3531 = cljs.core.first(seq3530);
var seq3530__$1 = cljs.core.next(seq3530);
var G__3532 = cljs.core.first(seq3530__$1);
var seq3530__$2 = cljs.core.next(seq3530__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3531,G__3532,seq3530__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__3542 = arguments.length;
switch (G__3542) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3544 = arguments.length;
var i__4731__auto___3545 = (0);
while(true){
if((i__4731__auto___3545 < len__4730__auto___3544)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3545]));

var G__3546 = (i__4731__auto___3545 + (1));
i__4731__auto___3545 = G__3546;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

/** @this {Function} */
cljs.core.bit_xor.cljs$lang$applyTo = (function (seq3539){
var G__3540 = cljs.core.first(seq3539);
var seq3539__$1 = cljs.core.next(seq3539);
var G__3541 = cljs.core.first(seq3539__$1);
var seq3539__$2 = cljs.core.next(seq3539__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3540,G__3541,seq3539__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__3551 = arguments.length;
switch (G__3551) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3553 = arguments.length;
var i__4731__auto___3554 = (0);
while(true){
if((i__4731__auto___3554 < len__4730__auto___3553)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3554]));

var G__3555 = (i__4731__auto___3554 + (1));
i__4731__auto___3554 = G__3555;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

/** @this {Function} */
cljs.core.bit_and.cljs$lang$applyTo = (function (seq3548){
var G__3549 = cljs.core.first(seq3548);
var seq3548__$1 = cljs.core.next(seq3548);
var G__3550 = cljs.core.first(seq3548__$1);
var seq3548__$2 = cljs.core.next(seq3548__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3549,G__3550,seq3548__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__3560 = arguments.length;
switch (G__3560) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3562 = arguments.length;
var i__4731__auto___3563 = (0);
while(true){
if((i__4731__auto___3563 < len__4730__auto___3562)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3563]));

var G__3564 = (i__4731__auto___3563 + (1));
i__4731__auto___3563 = G__3564;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

/** @this {Function} */
cljs.core.bit_or.cljs$lang$applyTo = (function (seq3557){
var G__3558 = cljs.core.first(seq3557);
var seq3557__$1 = cljs.core.next(seq3557);
var G__3559 = cljs.core.first(seq3557__$1);
var seq3557__$2 = cljs.core.next(seq3557__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3558,G__3559,seq3557__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__3569 = arguments.length;
switch (G__3569) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3571 = arguments.length;
var i__4731__auto___3572 = (0);
while(true){
if((i__4731__auto___3572 < len__4730__auto___3571)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3572]));

var G__3573 = (i__4731__auto___3572 + (1));
i__4731__auto___3572 = G__3573;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

/** @this {Function} */
cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq3566){
var G__3567 = cljs.core.first(seq3566);
var seq3566__$1 = cljs.core.next(seq3566);
var G__3568 = cljs.core.first(seq3566__$1);
var seq3566__$2 = cljs.core.next(seq3566__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3567,G__3568,seq3566__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__3578 = arguments.length;
switch (G__3578) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3580 = arguments.length;
var i__4731__auto___3581 = (0);
while(true){
if((i__4731__auto___3581 < len__4730__auto___3580)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3581]));

var G__3582 = (i__4731__auto___3581 + (1));
i__4731__auto___3581 = G__3582;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__3583 = y;
var G__3584 = cljs.core.first(more);
var G__3585 = cljs.core.next(more);
x = G__3583;
y = G__3584;
more = G__3585;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

/** @this {Function} */
cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq3575){
var G__3576 = cljs.core.first(seq3575);
var seq3575__$1 = cljs.core.next(seq3575);
var G__3577 = cljs.core.first(seq3575__$1);
var seq3575__$2 = cljs.core.next(seq3575__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3576,G__3577,seq3575__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__3586 = (n__$1 - (1));
var G__3587 = cljs.core.next(xs);
n__$1 = G__3586;
xs = G__3587;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__3591 = arguments.length;
switch (G__3591) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3593 = arguments.length;
var i__4731__auto___3594 = (0);
while(true){
if((i__4731__auto___3594 < len__4730__auto___3593)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3594]));

var G__3595 = (i__4731__auto___3594 + (1));
i__4731__auto___3594 = G__3595;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4752__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__3596 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__3597 = cljs.core.next(more);
sb = G__3596;
more = G__3597;
continue;
} else {
return sb.toString();
}
break;
}
});

/** @this {Function} */
cljs.core.str.cljs$lang$applyTo = (function (seq3589){
var G__3590 = cljs.core.first(seq3589);
var seq3589__$1 = cljs.core.next(seq3589);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3590,seq3589__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__3599 = arguments.length;
switch (G__3599) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__3601 = cljs.core.next(xs);
var G__3602 = cljs.core.next(ys);
xs = G__3601;
ys = G__3602;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__3603 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__3604 = cljs.core.next(s);
res = G__3603;
s = G__3604;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__3605 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__3606 = cljs.core.next(s);
h = G__3605;
s = G__3606;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__3607 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__3608 = cljs.core.next(s__$1);
h = G__3607;
s__$1 = G__3608;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__3609_3625 = cljs.core.seq(fn_map);
var chunk__3610_3626 = null;
var count__3611_3627 = (0);
var i__3612_3628 = (0);
while(true){
if((i__3612_3628 < count__3611_3627)){
var vec__3619_3629 = chunk__3610_3626.cljs$core$IIndexed$_nth$arity$2(null,i__3612_3628);
var key_name_3630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3619_3629,(0),null);
var f_3631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3619_3629,(1),null);
var str_name_3632 = cljs.core.name(key_name_3630);
goog.object.set(obj,str_name_3632,f_3631);


var G__3633 = seq__3609_3625;
var G__3634 = chunk__3610_3626;
var G__3635 = count__3611_3627;
var G__3636 = (i__3612_3628 + (1));
seq__3609_3625 = G__3633;
chunk__3610_3626 = G__3634;
count__3611_3627 = G__3635;
i__3612_3628 = G__3636;
continue;
} else {
var temp__5735__auto___3637 = cljs.core.seq(seq__3609_3625);
if(temp__5735__auto___3637){
var seq__3609_3638__$1 = temp__5735__auto___3637;
if(cljs.core.chunked_seq_QMARK_(seq__3609_3638__$1)){
var c__4550__auto___3639 = cljs.core.chunk_first(seq__3609_3638__$1);
var G__3640 = cljs.core.chunk_rest(seq__3609_3638__$1);
var G__3641 = c__4550__auto___3639;
var G__3642 = cljs.core.count(c__4550__auto___3639);
var G__3643 = (0);
seq__3609_3625 = G__3640;
chunk__3610_3626 = G__3641;
count__3611_3627 = G__3642;
i__3612_3628 = G__3643;
continue;
} else {
var vec__3622_3644 = cljs.core.first(seq__3609_3638__$1);
var key_name_3645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3622_3644,(0),null);
var f_3646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3622_3644,(1),null);
var str_name_3647 = cljs.core.name(key_name_3645);
goog.object.set(obj,str_name_3647,f_3646);


var G__3648 = cljs.core.next(seq__3609_3638__$1);
var G__3649 = null;
var G__3650 = (0);
var G__3651 = (0);
seq__3609_3625 = G__3648;
chunk__3610_3626 = G__3649;
count__3611_3627 = G__3650;
i__3612_3628 = G__3651;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.indexOf = (function() {
var G__3652 = null;
var G__3652__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3652__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3652 = function(x,start){
switch(arguments.length){
case 1:
return G__3652__1.call(this,x);
case 2:
return G__3652__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3652.cljs$core$IFn$_invoke$arity$1 = G__3652__1;
G__3652.cljs$core$IFn$_invoke$arity$2 = G__3652__2;
return G__3652;
})()
;

cljs.core.List.prototype.lastIndexOf = (function() {
var G__3653 = null;
var G__3653__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__3653__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3653 = function(x,start){
switch(arguments.length){
case 1:
return G__3653__1.call(this,x);
case 2:
return G__3653__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3653.cljs$core$IFn$_invoke$arity$1 = G__3653__1;
G__3653.cljs$core$IFn$_invoke$arity$2 = G__3653__2;
return G__3653;
})()
;

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/List");
});

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
var G__3655_3658 = cljs.core.List.prototype;
var G__3656_3659 = cljs.core.ITER_SYMBOL;
var G__3657_3660 = ((function (G__3655_3658,G__3656_3659){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3655_3658,G__3656_3659))
;
goog.object.set(G__3655_3658,G__3656_3659,G__3657_3660);

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.indexOf = (function() {
var G__3661 = null;
var G__3661__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3661__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3661 = function(x,start){
switch(arguments.length){
case 1:
return G__3661__1.call(this,x);
case 2:
return G__3661__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3661.cljs$core$IFn$_invoke$arity$1 = G__3661__1;
G__3661.cljs$core$IFn$_invoke$arity$2 = G__3661__2;
return G__3661;
})()
;

cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__3662 = null;
var G__3662__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3662__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3662 = function(x,start){
switch(arguments.length){
case 1:
return G__3662__1.call(this,x);
case 2:
return G__3662__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3662.cljs$core$IFn$_invoke$arity$1 = G__3662__1;
G__3662.cljs$core$IFn$_invoke$arity$2 = G__3662__2;
return G__3662;
})()
;

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/EmptyList");
});

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
var G__3663_3666 = cljs.core.EmptyList.prototype;
var G__3664_3667 = cljs.core.ITER_SYMBOL;
var G__3665_3668 = ((function (G__3663_3666,G__3664_3667){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3663_3666,G__3664_3667))
;
goog.object.set(G__3663_3666,G__3664_3667,G__3665_3668);
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__4131__auto__ = cljs.core.rseq(coll);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3671 = arguments.length;
var i__4731__auto___3672 = (0);
while(true){
if((i__4731__auto___3672 < len__4730__auto___3671)){
args__4736__auto__.push((arguments[i__4731__auto___3672]));

var G__3673 = (i__4731__auto___3672 + (1));
i__4731__auto___3672 = G__3673;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__3674 = cljs.core._next(xs__$1);
xs__$1 = G__3674;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__3675 = (i - (1));
var G__3676 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__3675;
r = G__3676;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.list.cljs$lang$applyTo = (function (seq3670){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq3670));
});


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.indexOf = (function() {
var G__3677 = null;
var G__3677__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3677__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3677 = function(x,start){
switch(arguments.length){
case 1:
return G__3677__1.call(this,x);
case 2:
return G__3677__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3677.cljs$core$IFn$_invoke$arity$1 = G__3677__1;
G__3677.cljs$core$IFn$_invoke$arity$2 = G__3677__2;
return G__3677;
})()
;

cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__3678 = null;
var G__3678__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3678__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3678 = function(x,start){
switch(arguments.length){
case 1:
return G__3678__1.call(this,x);
case 2:
return G__3678__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3678.cljs$core$IFn$_invoke$arity$1 = G__3678__1;
G__3678.cljs$core$IFn$_invoke$arity$2 = G__3678__2;
return G__3678;
})()
;

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Cons");
});

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

var G__3679_3682 = cljs.core.Cons.prototype;
var G__3680_3683 = cljs.core.ITER_SYMBOL;
var G__3681_3684 = ((function (G__3679_3682,G__3680_3683){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3679_3682,G__3680_3683))
;
goog.object.set(G__3679_3682,G__3680_3683,G__3681_3684);
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.not(a.ns);
if(and__4120__auto__){
return b.ns;
} else {
return and__4120__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__3686 = a.ns;
var G__3687 = b.ns;
return goog.array.defaultCompare(G__3686,G__3687);
})();
if(((0) === nsc)){
var G__3688 = a.name;
var G__3689 = b.name;
return goog.array.defaultCompare(G__3688,G__3689);
} else {
return nsc;
}
}
} else {
var G__3690 = a.name;
var G__3691 = b.name;
return goog.array.defaultCompare(G__3690,G__3691);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__3693 = null;
var G__3693__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__3693__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__3693 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__3693__2.call(this,self__,coll);
case 3:
return G__3693__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3693.cljs$core$IFn$_invoke$arity$2 = G__3693__2;
G__3693.cljs$core$IFn$_invoke$arity$3 = G__3693__3;
return G__3693;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args3692){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3692)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4243__auto__ = self__._hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Keyword");
});

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return cljs.core._namespace(x);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__4120__auto__ = cljs.core.ident_QMARK_(x);
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__4120__auto____$1)){
return true;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__4120__auto__ = (x instanceof cljs.core.Symbol);
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__4120__auto____$1)){
return true;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__4120__auto__ = (x instanceof cljs.core.Keyword);
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__4120__auto____$1)){
return true;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__3696 = arguments.length;
switch (G__3696) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.indexOf = (function() {
var G__3698 = null;
var G__3698__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3698__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3698 = function(x,start){
switch(arguments.length){
case 1:
return G__3698__1.call(this,x);
case 2:
return G__3698__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3698.cljs$core$IFn$_invoke$arity$1 = G__3698__1;
G__3698.cljs$core$IFn$_invoke$arity$2 = G__3698__2;
return G__3698;
})()
;

cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__3699 = null;
var G__3699__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3699__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3699 = function(x,start){
switch(arguments.length){
case 1:
return G__3699__1.call(this,x);
case 2:
return G__3699__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3699.cljs$core$IFn$_invoke$arity$1 = G__3699__1;
G__3699.cljs$core$IFn$_invoke$arity$2 = G__3699__2;
return G__3699;
})()
;

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__3700 = ls.sval();
ls = G__3700;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,((function (coll__$1){
return (function (){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
});})(coll__$1))
,null,self__.__hash));
}
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/LazySeq");
});

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

var G__3701_3704 = cljs.core.LazySeq.prototype;
var G__3702_3705 = cljs.core.ITER_SYMBOL;
var G__3703_3706 = ((function (G__3701_3704,G__3702_3705){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3701_3704,G__3702_3705))
;
goog.object.set(G__3701_3704,G__3702_3705,G__3703_3706);

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ChunkBuffer");
});

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ArrayChunk");
});

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__3708 = arguments.length;
switch (G__3708) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__3710 = null;
var G__3710__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3710__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3710 = function(x,start){
switch(arguments.length){
case 1:
return G__3710__1.call(this,x);
case 2:
return G__3710__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3710.cljs$core$IFn$_invoke$arity$1 = G__3710__1;
G__3710.cljs$core$IFn$_invoke$arity$2 = G__3710__2;
return G__3710;
})()
;

cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__3711 = null;
var G__3711__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3711__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3711 = function(x,start){
switch(arguments.length){
case 1:
return G__3711__1.call(this,x);
case 2:
return G__3711__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3711.cljs$core$IFn$_invoke$arity$1 = G__3711__1;
G__3711.cljs$core$IFn$_invoke$arity$2 = G__3711__2;
return G__3711;
})()
;

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ChunkedCons");
});

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

var G__3712_3715 = cljs.core.ChunkedCons.prototype;
var G__3713_3716 = cljs.core.ITER_SYMBOL;
var G__3714_3717 = ((function (G__3712_3715,G__3713_3716){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3712_3715,G__3713_3716))
;
goog.object.set(G__3712_3715,G__3713_3716,G__3714_3717);
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__3719 = cljs.core.next(s);
s = G__3719;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_3720 = (0);
var xs_3721 = cljs.core.seq(coll);
while(true){
if((xs_3721 == null)){
} else {
(ret[i_3720] = cljs.core.to_array(cljs.core.first(xs_3721)));

var G__3722 = (i_3720 + (1));
var G__3723 = cljs.core.next(xs_3721);
i_3720 = G__3722;
xs_3721 = G__3723;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__3725 = arguments.length;
switch (G__3725) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__3727 = (i + (1));
var G__3728 = cljs.core.next(s__$1);
i = G__3727;
s__$1 = G__3728;
continue;
} else {
return a;
}
break;
}
} else {
var n__4607__auto___3729 = size;
var i_3730 = (0);
while(true){
if((i_3730 < n__4607__auto___3729)){
(a[i_3730] = init_val_or_seq);

var G__3731 = (i_3730 + (1));
i_3730 = G__3731;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__3733 = arguments.length;
switch (G__3733) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__3735 = (i + (1));
var G__3736 = cljs.core.next(s__$1);
i = G__3735;
s__$1 = G__3736;
continue;
} else {
return a;
}
break;
}
} else {
var n__4607__auto___3737 = size;
var i_3738 = (0);
while(true){
if((i_3738 < n__4607__auto___3737)){
(a[i_3738] = init_val_or_seq);

var G__3739 = (i_3738 + (1));
i_3738 = G__3739;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__3741 = arguments.length;
switch (G__3741) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__3743 = (i + (1));
var G__3744 = cljs.core.next(s__$1);
i = G__3743;
s__$1 = G__3744;
continue;
} else {
return a;
}
break;
}
} else {
var n__4607__auto___3745 = size;
var i_3746 = (0);
while(true){
if((i_3746 < n__4607__auto___3745)){
(a[i_3746] = init_val_or_seq);

var G__3747 = (i_3746 + (1));
i_3746 = G__3747;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__3749 = arguments.length;
switch (G__3749) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__3751 = (i + (1));
var G__3752 = cljs.core.next(s__$1);
i = G__3751;
s__$1 = G__3752;
continue;
} else {
return a;
}
break;
}
} else {
var n__4607__auto___3753 = size;
var i_3754 = (0);
while(true){
if((i_3754 < n__4607__auto___3753)){
(a[i_3754] = init_val_or_seq);

var G__3755 = (i_3754 + (1));
i_3754 = G__3755;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__3756 = (i + (1));
var G__3757 = cljs.core.next(s);
i = G__3756;
s = G__3757;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__3762 = arguments.length;
switch (G__3762) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3764 = arguments.length;
var i__4731__auto___3765 = (0);
while(true){
if((i__4731__auto___3765 < len__4730__auto___3764)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3765]));

var G__3766 = (i__4731__auto___3765 + (1));
i__4731__auto___3765 = G__3766;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

/** @this {Function} */
cljs.core.concat.cljs$lang$applyTo = (function (seq3759){
var G__3760 = cljs.core.first(seq3759);
var seq3759__$1 = cljs.core.next(seq3759);
var G__3761 = cljs.core.first(seq3759__$1);
var seq3759__$2 = cljs.core.next(seq3759__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3760,G__3761,seq3759__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__3773 = arguments.length;
switch (G__3773) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3775 = arguments.length;
var i__4731__auto___3776 = (0);
while(true){
if((i__4731__auto___3776 < len__4730__auto___3775)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3776]));

var G__3777 = (i__4731__auto___3776 + (1));
i__4731__auto___3776 = G__3777;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

/** @this {Function} */
cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq3768){
var G__3769 = cljs.core.first(seq3768);
var seq3768__$1 = cljs.core.next(seq3768);
var G__3770 = cljs.core.first(seq3768__$1);
var seq3768__$2 = cljs.core.next(seq3768__$1);
var G__3771 = cljs.core.first(seq3768__$2);
var seq3768__$3 = cljs.core.next(seq3768__$2);
var G__3772 = cljs.core.first(seq3768__$3);
var seq3768__$4 = cljs.core.next(seq3768__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3769,G__3770,G__3771,G__3772,seq3768__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__3782 = arguments.length;
switch (G__3782) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3784 = arguments.length;
var i__4731__auto___3785 = (0);
while(true){
if((i__4731__auto___3785 < len__4730__auto___3784)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3785]));

var G__3786 = (i__4731__auto___3785 + (1));
i__4731__auto___3785 = G__3786;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__3787 = ntcoll;
var G__3788 = cljs.core.first(vals);
var G__3789 = cljs.core.next(vals);
tcoll = G__3787;
val = G__3788;
vals = G__3789;
continue;
} else {
return ntcoll;
}
break;
}
});

/** @this {Function} */
cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq3779){
var G__3780 = cljs.core.first(seq3779);
var seq3779__$1 = cljs.core.next(seq3779);
var G__3781 = cljs.core.first(seq3779__$1);
var seq3779__$2 = cljs.core.next(seq3779__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3780,G__3781,seq3779__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__3795 = arguments.length;
switch (G__3795) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3797 = arguments.length;
var i__4731__auto___3798 = (0);
while(true){
if((i__4731__auto___3798 < len__4730__auto___3797)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3798]));

var G__3799 = (i__4731__auto___3798 + (1));
i__4731__auto___3798 = G__3799;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__3800 = ntcoll;
var G__3801 = cljs.core.first(kvs);
var G__3802 = cljs.core.second(kvs);
var G__3803 = cljs.core.nnext(kvs);
tcoll = G__3800;
key = G__3801;
val = G__3802;
kvs = G__3803;
continue;
} else {
return ntcoll;
}
break;
}
});

/** @this {Function} */
cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq3791){
var G__3792 = cljs.core.first(seq3791);
var seq3791__$1 = cljs.core.next(seq3791);
var G__3793 = cljs.core.first(seq3791__$1);
var seq3791__$2 = cljs.core.next(seq3791__$1);
var G__3794 = cljs.core.first(seq3791__$2);
var seq3791__$3 = cljs.core.next(seq3791__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3792,G__3793,G__3794,seq3791__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__3808 = arguments.length;
switch (G__3808) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3810 = arguments.length;
var i__4731__auto___3811 = (0);
while(true){
if((i__4731__auto___3811 < len__4730__auto___3810)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3811]));

var G__3812 = (i__4731__auto___3811 + (1));
i__4731__auto___3811 = G__3812;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__3813 = ntcoll;
var G__3814 = cljs.core.first(ks);
var G__3815 = cljs.core.next(ks);
tcoll = G__3813;
key = G__3814;
ks = G__3815;
continue;
} else {
return ntcoll;
}
break;
}
});

/** @this {Function} */
cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq3805){
var G__3806 = cljs.core.first(seq3805);
var seq3805__$1 = cljs.core.next(seq3805);
var G__3807 = cljs.core.first(seq3805__$1);
var seq3805__$2 = cljs.core.next(seq3805__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3806,G__3807,seq3805__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__3820 = arguments.length;
switch (G__3820) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3822 = arguments.length;
var i__4731__auto___3823 = (0);
while(true){
if((i__4731__auto___3823 < len__4730__auto___3822)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3823]));

var G__3824 = (i__4731__auto___3823 + (1));
i__4731__auto___3823 = G__3824;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__3825 = ntcoll;
var G__3826 = cljs.core.first(vals);
var G__3827 = cljs.core.next(vals);
tcoll = G__3825;
val = G__3826;
vals = G__3827;
continue;
} else {
return ntcoll;
}
break;
}
});

/** @this {Function} */
cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq3817){
var G__3818 = cljs.core.first(seq3817);
var seq3817__$1 = cljs.core.next(seq3817);
var G__3819 = cljs.core.first(seq3817__$1);
var seq3817__$2 = cljs.core.next(seq3817__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3818,G__3819,seq3817__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a254 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a254) : f.call(null,a254));
} else {
var b255 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a254,b255) : f.call(null,a254,b255));
} else {
var c256 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a254,b255,c256) : f.call(null,a254,b255,c256));
} else {
var d257 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a254,b255,c256,d257) : f.call(null,a254,b255,c256,d257));
} else {
var e258 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a254,b255,c256,d257,e258) : f.call(null,a254,b255,c256,d257,e258));
} else {
var f259 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a254,b255,c256,d257,e258,f259) : f.call(null,a254,b255,c256,d257,e258,f259));
} else {
var g260 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a254,b255,c256,d257,e258,f259,g260) : f.call(null,a254,b255,c256,d257,e258,f259,g260));
} else {
var h261 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a254,b255,c256,d257,e258,f259,g260,h261) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261));
} else {
var i262 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a254,b255,c256,d257,e258,f259,g260,h261,i262) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262));
} else {
var j263 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263));
} else {
var k264 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264));
} else {
var l265 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265));
} else {
var m266 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266));
} else {
var n267 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267));
} else {
var o268 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268));
} else {
var p269 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269));
} else {
var q270 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270));
} else {
var r271 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270,r271) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270,r271));
} else {
var s272 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270,r271,s272) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270,r271,s272));
} else {
var t273 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270,r271,s272,t273) : f.call(null,a254,b255,c256,d257,e258,f259,g260,h261,i262,j263,k264,l265,m266,n267,o268,p269,q270,r271,s272,t273));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__3830 = arguments.length;
switch (G__3830) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
});

cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function (f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
});

cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function (f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
});

cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function (f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
});

cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function (f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__4655__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__4656__auto___3832 = next_19;
while(true){
if(s__4656__auto___3832){
arr__4655__auto__.push(cljs.core._first(s__4656__auto___3832));

var G__3833 = cljs.core.next(s__4656__auto___3832);
s__4656__auto___3832 = G__3833;
continue;
} else {
}
break;
}

return f.apply(f,arr__4655__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6;

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__3841 = arguments.length;
switch (G__3841) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3843 = arguments.length;
var i__4731__auto___3844 = (0);
while(true){
if((i__4731__auto___3844 < len__4730__auto___3843)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3844]));

var G__3845 = (i__4731__auto___3844 + (1));
i__4731__auto___3844 = G__3845;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
});

/** @this {Function} */
cljs.core.apply.cljs$lang$applyTo = (function (seq3835){
var G__3836 = cljs.core.first(seq3835);
var seq3835__$1 = cljs.core.next(seq3835);
var G__3837 = cljs.core.first(seq3835__$1);
var seq3835__$2 = cljs.core.next(seq3835__$1);
var G__3838 = cljs.core.first(seq3835__$2);
var seq3835__$3 = cljs.core.next(seq3835__$2);
var G__3839 = cljs.core.first(seq3835__$3);
var seq3835__$4 = cljs.core.next(seq3835__$3);
var G__3840 = cljs.core.first(seq3835__$4);
var seq3835__$5 = cljs.core.next(seq3835__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3836,G__3837,G__3838,G__3839,G__3840,seq3835__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);

/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__3854 = arguments.length;
switch (G__3854) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3871 = arguments.length;
var i__4731__auto___3872 = (0);
while(true){
if((i__4731__auto___3872 < len__4730__auto___3871)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3872]));

var G__3873 = (i__4731__auto___3872 + (1));
i__4731__auto___3872 = G__3873;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4752__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__3855 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3855) : f.call(null,G__3855));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__3856 = cljs.core.meta(obj);
var G__3857 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3856,G__3857) : f.call(null,G__3856,G__3857));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__3858 = cljs.core.meta(obj);
var G__3859 = a;
var G__3860 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__3858,G__3859,G__3860) : f.call(null,G__3858,G__3859,G__3860));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__3861 = cljs.core.meta(obj);
var G__3862 = a;
var G__3863 = b;
var G__3864 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__3861,G__3862,G__3863,G__3864) : f.call(null,G__3861,G__3862,G__3863,G__3864));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__3865 = cljs.core.meta(obj);
var G__3866 = a;
var G__3867 = b;
var G__3868 = c;
var G__3869 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__3865,G__3866,G__3867,G__3868,G__3869) : f.call(null,G__3865,G__3866,G__3867,G__3868,G__3869));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
});

/** @this {Function} */
cljs.core.vary_meta.cljs$lang$applyTo = (function (seq3847){
var G__3848 = cljs.core.first(seq3847);
var seq3847__$1 = cljs.core.next(seq3847);
var G__3849 = cljs.core.first(seq3847__$1);
var seq3847__$2 = cljs.core.next(seq3847__$1);
var G__3850 = cljs.core.first(seq3847__$2);
var seq3847__$3 = cljs.core.next(seq3847__$2);
var G__3851 = cljs.core.first(seq3847__$3);
var seq3847__$4 = cljs.core.next(seq3847__$3);
var G__3852 = cljs.core.first(seq3847__$4);
var seq3847__$5 = cljs.core.next(seq3847__$4);
var G__3853 = cljs.core.first(seq3847__$5);
var seq3847__$6 = cljs.core.next(seq3847__$5);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3848,G__3849,G__3850,G__3851,G__3852,G__3853,seq3847__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__3878 = arguments.length;
switch (G__3878) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3880 = arguments.length;
var i__4731__auto___3881 = (0);
while(true){
if((i__4731__auto___3881 < len__4730__auto___3880)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3881]));

var G__3882 = (i__4731__auto___3881 + (1));
i__4731__auto___3881 = G__3882;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

/** @this {Function} */
cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq3875){
var G__3876 = cljs.core.first(seq3875);
var seq3875__$1 = cljs.core.next(seq3875);
var G__3877 = cljs.core.first(seq3875__$1);
var seq3875__$2 = cljs.core.next(seq3875__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3876,G__3877,seq3875__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core3883 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core3883 = (function (meta3884){
this.meta3884 = meta3884;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.t_cljs$core3883.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3885,meta3884__$1){
var self__ = this;
var _3885__$1 = this;
return (new cljs.core.t_cljs$core3883(meta3884__$1));
});

cljs.core.t_cljs$core3883.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3885){
var self__ = this;
var _3885__$1 = this;
return self__.meta3884;
});

cljs.core.t_cljs$core3883.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t_cljs$core3883.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t_cljs$core3883.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t_cljs$core3883.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta3884], null);
});

cljs.core.t_cljs$core3883.cljs$lang$type = true;

cljs.core.t_cljs$core3883.cljs$lang$ctorStr = "cljs.core/t_cljs$core3883";

cljs.core.t_cljs$core3883.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/t_cljs$core3883");
});

/**
 * Positional factory function for cljs.core/t_cljs$core3883.
 */
cljs.core.__GT_t_cljs$core3883 = (function cljs$core$nil_iter_$___GT_t_cljs$core3883(meta3884){
return (new cljs.core.t_cljs$core3883(meta3884));
});

}

return (new cljs.core.t_cljs$core3883(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/StringIter");
});

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ArrayIter");
});

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return (!((self__._next == null)));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/SeqIter");
});

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
cljs.core.Many.prototype.add = (function (o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
});

cljs.core.Many.prototype.remove = (function (){
var self__ = this;
var this$ = this;
return self__.vals.shift();
});

cljs.core.Many.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
});

cljs.core.Many.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
});

cljs.core.Many.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vals], null);
});

cljs.core.Many.cljs$lang$type = true;

cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many";

cljs.core.Many.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Many");
});

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
cljs.core.Single.prototype.add = (function (o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
self__.val = o;

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
});

cljs.core.Single.prototype.remove = (function (){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
self__.val = cljs.core.NONE;

return ret;
}
});

cljs.core.Single.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
});

cljs.core.Single.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
});

cljs.core.Single.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Single.cljs$lang$type = true;

cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single";

cljs.core.Single.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Single");
});

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
cljs.core.Empty.prototype.add = (function (o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
});

cljs.core.Empty.prototype.remove = (function (){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
});

cljs.core.Empty.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return true;
});

cljs.core.Empty.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return "Empty";
});

cljs.core.Empty.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.Empty.cljs$lang$type = true;

cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty";

cljs.core.Empty.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Empty");
});

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
cljs.core.MultiIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__3886 = cljs.core.next(iters__$1);
iters__$1 = G__3886;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var nexts = [];
var n__4607__auto___3887 = self__.iters.length;
var i_3888 = (0);
while(true){
if((i_3888 < n__4607__auto___3887)){
(nexts[i_3888] = (self__.iters[i_3888]).next());

var G__3889 = (i_3888 + (1));
i_3888 = G__3889;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
});

cljs.core.MultiIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iters], null);
});

cljs.core.MultiIterator.cljs$lang$type = true;

cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator";

cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/MultiIterator");
});

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function (){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__4120__auto__ = iter.hasNext();
if(cljs.core.truth_(and__4120__auto__)){
return (n < (32));
} else {
return and__4120__auto__;
}
})())){
(arr[n] = iter.next());

var G__3890 = (n + (1));
n = G__3890;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
cljs.core.TransformerIterator.prototype.step = (function (){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__3891 = null;
var G__3892 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__3891,G__3892) : self__.xf.call(null,G__3891,G__3892));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

self__.completed = true;
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

self__.completed = true;

continue;
}
}
} else {
self__._next = self__.buffer.remove();

continue;
}
} else {
return true;
}
break;
}
}
});

cljs.core.TransformerIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return this$.step();
});

cljs.core.TransformerIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
self__._next = cljs.core.NONE;

return ret;
} else {
throw (new Error("No such element"));
}
});

cljs.core.TransformerIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.TransformerIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buffer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$completed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$xf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null);
});

cljs.core.TransformerIterator.cljs$lang$type = true;

cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator";

cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/TransformerIterator");
});

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

var G__3893_3896 = cljs.core.TransformerIterator.prototype;
var G__3894_3897 = cljs.core.ITER_SYMBOL;
var G__3895_3898 = ((function (G__3893_3896,G__3894_3897){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__3893_3896,G__3894_3897))
;
goog.object.set(G__3893_3896,G__3894_3897,G__3895_3898);
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
iterator.xf = (function (){var G__3899 = ((function (iterator){
return (function() {
var G__3900 = null;
var G__3900__0 = (function (){
return null;
});
var G__3900__1 = (function (acc){
return acc;
});
var G__3900__2 = (function (acc,o){
iterator.buffer = iterator.buffer.add(o);

return acc;
});
G__3900 = function(acc,o){
switch(arguments.length){
case 0:
return G__3900__0.call(this);
case 1:
return G__3900__1.call(this,acc);
case 2:
return G__3900__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3900.cljs$core$IFn$_invoke$arity$0 = G__3900__0;
G__3900.cljs$core$IFn$_invoke$arity$1 = G__3900__1;
G__3900.cljs$core$IFn$_invoke$arity$2 = G__3900__2;
return G__3900;
})()
;})(iterator))
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__3899) : xform.call(null,G__3899));
})();

return iterator;
});
cljs.core.TransformerIterator.create = (function (xform,source){
return cljs.core.transformer_iterator(xform,source,false);
});
cljs.core.TransformerIterator.createMulti = (function (xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__3905 = arguments.length;
switch (G__3905) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3907 = arguments.length;
var i__4731__auto___3908 = (0);
while(true){
if((i__4731__auto___3908 < len__4730__auto___3907)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3908]));

var G__3909 = (i__4731__auto___3908 + (1));
i__4731__auto___3908 = G__3909;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__4131__auto__ = cljs.core.seq(coll);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
var or__4131__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
var or__4131__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.List.EMPTY;
}
});

/** @this {Function} */
cljs.core.sequence.cljs$lang$applyTo = (function (seq3902){
var G__3903 = cljs.core.first(seq3902);
var seq3902__$1 = cljs.core.next(seq3902);
var G__3904 = cljs.core.first(seq3902__$1);
var seq3902__$2 = cljs.core.next(seq3902__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3903,G__3904,seq3902__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__3910 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__3910) : pred.call(null,G__3910));
})())){
var G__3911 = pred;
var G__3912 = cljs.core.next(coll);
pred = G__3911;
coll = G__3912;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
var or__4131__auto__ = (function (){var G__3914 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__3914) : pred.call(null,G__3914));
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var G__3915 = pred;
var G__3916 = cljs.core.next(s);
pred = G__3915;
coll = G__3916;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__3917 = null;
var G__3917__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__3917__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__3917__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__3917__3 = (function() { 
var G__3918__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__3918 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__3919__i = 0, G__3919__a = new Array(arguments.length -  2);
while (G__3919__i < G__3919__a.length) {G__3919__a[G__3919__i] = arguments[G__3919__i + 2]; ++G__3919__i;}
  zs = new cljs.core.IndexedSeq(G__3919__a,0,null);
} 
return G__3918__delegate.call(this,x,y,zs);};
G__3918.cljs$lang$maxFixedArity = 2;
G__3918.cljs$lang$applyTo = (function (arglist__3920){
var x = cljs.core.first(arglist__3920);
arglist__3920 = cljs.core.next(arglist__3920);
var y = cljs.core.first(arglist__3920);
var zs = cljs.core.rest(arglist__3920);
return G__3918__delegate(x,y,zs);
});
G__3918.cljs$core$IFn$_invoke$arity$variadic = G__3918__delegate;
return G__3918;
})()
;
G__3917 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__3917__0.call(this);
case 1:
return G__3917__1.call(this,x);
case 2:
return G__3917__2.call(this,x,y);
default:
var G__3921 = null;
if (arguments.length > 2) {
var G__3922__i = 0, G__3922__a = new Array(arguments.length -  2);
while (G__3922__i < G__3922__a.length) {G__3922__a[G__3922__i] = arguments[G__3922__i + 2]; ++G__3922__i;}
G__3921 = new cljs.core.IndexedSeq(G__3922__a,0,null);
}
return G__3917__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__3921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3917.cljs$lang$maxFixedArity = 2;
G__3917.cljs$lang$applyTo = G__3917__3.cljs$lang$applyTo;
G__3917.cljs$core$IFn$_invoke$arity$0 = G__3917__0;
G__3917.cljs$core$IFn$_invoke$arity$1 = G__3917__1;
G__3917.cljs$core$IFn$_invoke$arity$2 = G__3917__2;
G__3917.cljs$core$IFn$_invoke$arity$variadic = G__3917__3.cljs$core$IFn$_invoke$arity$variadic;
return G__3917;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__3923__delegate = function (args){
return x;
};
var G__3923 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__3924__i = 0, G__3924__a = new Array(arguments.length -  0);
while (G__3924__i < G__3924__a.length) {G__3924__a[G__3924__i] = arguments[G__3924__i + 0]; ++G__3924__i;}
  args = new cljs.core.IndexedSeq(G__3924__a,0,null);
} 
return G__3923__delegate.call(this,args);};
G__3923.cljs$lang$maxFixedArity = 0;
G__3923.cljs$lang$applyTo = (function (arglist__3925){
var args = cljs.core.seq(arglist__3925);
return G__3923__delegate(args);
});
G__3923.cljs$core$IFn$_invoke$arity$variadic = G__3923__delegate;
return G__3923;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__3931 = arguments.length;
switch (G__3931) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3949 = arguments.length;
var i__4731__auto___3950 = (0);
while(true){
if((i__4731__auto___3950 < len__4730__auto___3949)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3950]));

var G__3951 = (i__4731__auto___3950 + (1));
i__4731__auto___3950 = G__3951;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__3952 = null;
var G__3952__0 = (function (){
var G__3932 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3932) : f.call(null,G__3932));
});
var G__3952__1 = (function (x){
var G__3933 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3933) : f.call(null,G__3933));
});
var G__3952__2 = (function (x,y){
var G__3934 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3934) : f.call(null,G__3934));
});
var G__3952__3 = (function (x,y,z){
var G__3935 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3935) : f.call(null,G__3935));
});
var G__3952__4 = (function() { 
var G__3953__delegate = function (x,y,z,args){
var G__3936 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3936) : f.call(null,G__3936));
};
var G__3953 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__3954__i = 0, G__3954__a = new Array(arguments.length -  3);
while (G__3954__i < G__3954__a.length) {G__3954__a[G__3954__i] = arguments[G__3954__i + 3]; ++G__3954__i;}
  args = new cljs.core.IndexedSeq(G__3954__a,0,null);
} 
return G__3953__delegate.call(this,x,y,z,args);};
G__3953.cljs$lang$maxFixedArity = 3;
G__3953.cljs$lang$applyTo = (function (arglist__3955){
var x = cljs.core.first(arglist__3955);
arglist__3955 = cljs.core.next(arglist__3955);
var y = cljs.core.first(arglist__3955);
arglist__3955 = cljs.core.next(arglist__3955);
var z = cljs.core.first(arglist__3955);
var args = cljs.core.rest(arglist__3955);
return G__3953__delegate(x,y,z,args);
});
G__3953.cljs$core$IFn$_invoke$arity$variadic = G__3953__delegate;
return G__3953;
})()
;
G__3952 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__3952__0.call(this);
case 1:
return G__3952__1.call(this,x);
case 2:
return G__3952__2.call(this,x,y);
case 3:
return G__3952__3.call(this,x,y,z);
default:
var G__3956 = null;
if (arguments.length > 3) {
var G__3957__i = 0, G__3957__a = new Array(arguments.length -  3);
while (G__3957__i < G__3957__a.length) {G__3957__a[G__3957__i] = arguments[G__3957__i + 3]; ++G__3957__i;}
G__3956 = new cljs.core.IndexedSeq(G__3957__a,0,null);
}
return G__3952__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__3956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3952.cljs$lang$maxFixedArity = 3;
G__3952.cljs$lang$applyTo = G__3952__4.cljs$lang$applyTo;
G__3952.cljs$core$IFn$_invoke$arity$0 = G__3952__0;
G__3952.cljs$core$IFn$_invoke$arity$1 = G__3952__1;
G__3952.cljs$core$IFn$_invoke$arity$2 = G__3952__2;
G__3952.cljs$core$IFn$_invoke$arity$3 = G__3952__3;
G__3952.cljs$core$IFn$_invoke$arity$variadic = G__3952__4.cljs$core$IFn$_invoke$arity$variadic;
return G__3952;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__3958 = null;
var G__3958__0 = (function (){
var G__3937 = (function (){var G__3938 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__3938) : g.call(null,G__3938));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3937) : f.call(null,G__3937));
});
var G__3958__1 = (function (x){
var G__3939 = (function (){var G__3940 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__3940) : g.call(null,G__3940));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3939) : f.call(null,G__3939));
});
var G__3958__2 = (function (x,y){
var G__3941 = (function (){var G__3942 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__3942) : g.call(null,G__3942));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3941) : f.call(null,G__3941));
});
var G__3958__3 = (function (x,y,z){
var G__3943 = (function (){var G__3944 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__3944) : g.call(null,G__3944));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3943) : f.call(null,G__3943));
});
var G__3958__4 = (function() { 
var G__3959__delegate = function (x,y,z,args){
var G__3945 = (function (){var G__3946 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__3946) : g.call(null,G__3946));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__3945) : f.call(null,G__3945));
};
var G__3959 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__3960__i = 0, G__3960__a = new Array(arguments.length -  3);
while (G__3960__i < G__3960__a.length) {G__3960__a[G__3960__i] = arguments[G__3960__i + 3]; ++G__3960__i;}
  args = new cljs.core.IndexedSeq(G__3960__a,0,null);
} 
return G__3959__delegate.call(this,x,y,z,args);};
G__3959.cljs$lang$maxFixedArity = 3;
G__3959.cljs$lang$applyTo = (function (arglist__3961){
var x = cljs.core.first(arglist__3961);
arglist__3961 = cljs.core.next(arglist__3961);
var y = cljs.core.first(arglist__3961);
arglist__3961 = cljs.core.next(arglist__3961);
var z = cljs.core.first(arglist__3961);
var args = cljs.core.rest(arglist__3961);
return G__3959__delegate(x,y,z,args);
});
G__3959.cljs$core$IFn$_invoke$arity$variadic = G__3959__delegate;
return G__3959;
})()
;
G__3958 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__3958__0.call(this);
case 1:
return G__3958__1.call(this,x);
case 2:
return G__3958__2.call(this,x,y);
case 3:
return G__3958__3.call(this,x,y,z);
default:
var G__3962 = null;
if (arguments.length > 3) {
var G__3963__i = 0, G__3963__a = new Array(arguments.length -  3);
while (G__3963__i < G__3963__a.length) {G__3963__a[G__3963__i] = arguments[G__3963__i + 3]; ++G__3963__i;}
G__3962 = new cljs.core.IndexedSeq(G__3963__a,0,null);
}
return G__3958__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__3962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3958.cljs$lang$maxFixedArity = 3;
G__3958.cljs$lang$applyTo = G__3958__4.cljs$lang$applyTo;
G__3958.cljs$core$IFn$_invoke$arity$0 = G__3958__0;
G__3958.cljs$core$IFn$_invoke$arity$1 = G__3958__1;
G__3958.cljs$core$IFn$_invoke$arity$2 = G__3958__2;
G__3958.cljs$core$IFn$_invoke$arity$3 = G__3958__3;
G__3958.cljs$core$IFn$_invoke$arity$variadic = G__3958__4.cljs$core$IFn$_invoke$arity$variadic;
return G__3958;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__3964__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__3965 = (function (){var fexpr__3947 = cljs.core.first(fs__$2);
return (fexpr__3947.cljs$core$IFn$_invoke$arity$1 ? fexpr__3947.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__3947.call(null,ret));
})();
var G__3966 = cljs.core.next(fs__$2);
ret = G__3965;
fs__$2 = G__3966;
continue;
} else {
return ret;
}
break;
}
};
var G__3964 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__3967__i = 0, G__3967__a = new Array(arguments.length -  0);
while (G__3967__i < G__3967__a.length) {G__3967__a[G__3967__i] = arguments[G__3967__i + 0]; ++G__3967__i;}
  args = new cljs.core.IndexedSeq(G__3967__a,0,null);
} 
return G__3964__delegate.call(this,args);};
G__3964.cljs$lang$maxFixedArity = 0;
G__3964.cljs$lang$applyTo = (function (arglist__3968){
var args = cljs.core.seq(arglist__3968);
return G__3964__delegate(args);
});
G__3964.cljs$core$IFn$_invoke$arity$variadic = G__3964__delegate;
return G__3964;
})()
;
;})(fs__$1))
});

/** @this {Function} */
cljs.core.comp.cljs$lang$applyTo = (function (seq3927){
var G__3928 = cljs.core.first(seq3927);
var seq3927__$1 = cljs.core.next(seq3927);
var G__3929 = cljs.core.first(seq3927__$1);
var seq3927__$2 = cljs.core.next(seq3927__$1);
var G__3930 = cljs.core.first(seq3927__$2);
var seq3927__$3 = cljs.core.next(seq3927__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3928,G__3929,G__3930,seq3927__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__3975 = arguments.length;
switch (G__3975) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___3977 = arguments.length;
var i__4731__auto___3978 = (0);
while(true){
if((i__4731__auto___3978 < len__4730__auto___3977)){
args_arr__4751__auto__.push((arguments[i__4731__auto___3978]));

var G__3979 = (i__4731__auto___3978 + (1));
i__4731__auto___3978 = G__3979;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__3980 = null;
var G__3980__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__3980__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__3980__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__3980__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__3980__4 = (function() { 
var G__3981__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__3981 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__3982__i = 0, G__3982__a = new Array(arguments.length -  3);
while (G__3982__i < G__3982__a.length) {G__3982__a[G__3982__i] = arguments[G__3982__i + 3]; ++G__3982__i;}
  args = new cljs.core.IndexedSeq(G__3982__a,0,null);
} 
return G__3981__delegate.call(this,x,y,z,args);};
G__3981.cljs$lang$maxFixedArity = 3;
G__3981.cljs$lang$applyTo = (function (arglist__3983){
var x = cljs.core.first(arglist__3983);
arglist__3983 = cljs.core.next(arglist__3983);
var y = cljs.core.first(arglist__3983);
arglist__3983 = cljs.core.next(arglist__3983);
var z = cljs.core.first(arglist__3983);
var args = cljs.core.rest(arglist__3983);
return G__3981__delegate(x,y,z,args);
});
G__3981.cljs$core$IFn$_invoke$arity$variadic = G__3981__delegate;
return G__3981;
})()
;
G__3980 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__3980__0.call(this);
case 1:
return G__3980__1.call(this,x);
case 2:
return G__3980__2.call(this,x,y);
case 3:
return G__3980__3.call(this,x,y,z);
default:
var G__3984 = null;
if (arguments.length > 3) {
var G__3985__i = 0, G__3985__a = new Array(arguments.length -  3);
while (G__3985__i < G__3985__a.length) {G__3985__a[G__3985__i] = arguments[G__3985__i + 3]; ++G__3985__i;}
G__3984 = new cljs.core.IndexedSeq(G__3985__a,0,null);
}
return G__3980__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__3984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3980.cljs$lang$maxFixedArity = 3;
G__3980.cljs$lang$applyTo = G__3980__4.cljs$lang$applyTo;
G__3980.cljs$core$IFn$_invoke$arity$0 = G__3980__0;
G__3980.cljs$core$IFn$_invoke$arity$1 = G__3980__1;
G__3980.cljs$core$IFn$_invoke$arity$2 = G__3980__2;
G__3980.cljs$core$IFn$_invoke$arity$3 = G__3980__3;
G__3980.cljs$core$IFn$_invoke$arity$variadic = G__3980__4.cljs$core$IFn$_invoke$arity$variadic;
return G__3980;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__3986 = null;
var G__3986__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__3986__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__3986__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__3986__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__3986__4 = (function() { 
var G__3987__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__3987 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__3988__i = 0, G__3988__a = new Array(arguments.length -  3);
while (G__3988__i < G__3988__a.length) {G__3988__a[G__3988__i] = arguments[G__3988__i + 3]; ++G__3988__i;}
  args = new cljs.core.IndexedSeq(G__3988__a,0,null);
} 
return G__3987__delegate.call(this,x,y,z,args);};
G__3987.cljs$lang$maxFixedArity = 3;
G__3987.cljs$lang$applyTo = (function (arglist__3989){
var x = cljs.core.first(arglist__3989);
arglist__3989 = cljs.core.next(arglist__3989);
var y = cljs.core.first(arglist__3989);
arglist__3989 = cljs.core.next(arglist__3989);
var z = cljs.core.first(arglist__3989);
var args = cljs.core.rest(arglist__3989);
return G__3987__delegate(x,y,z,args);
});
G__3987.cljs$core$IFn$_invoke$arity$variadic = G__3987__delegate;
return G__3987;
})()
;
G__3986 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__3986__0.call(this);
case 1:
return G__3986__1.call(this,x);
case 2:
return G__3986__2.call(this,x,y);
case 3:
return G__3986__3.call(this,x,y,z);
default:
var G__3990 = null;
if (arguments.length > 3) {
var G__3991__i = 0, G__3991__a = new Array(arguments.length -  3);
while (G__3991__i < G__3991__a.length) {G__3991__a[G__3991__i] = arguments[G__3991__i + 3]; ++G__3991__i;}
G__3990 = new cljs.core.IndexedSeq(G__3991__a,0,null);
}
return G__3986__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__3990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3986.cljs$lang$maxFixedArity = 3;
G__3986.cljs$lang$applyTo = G__3986__4.cljs$lang$applyTo;
G__3986.cljs$core$IFn$_invoke$arity$0 = G__3986__0;
G__3986.cljs$core$IFn$_invoke$arity$1 = G__3986__1;
G__3986.cljs$core$IFn$_invoke$arity$2 = G__3986__2;
G__3986.cljs$core$IFn$_invoke$arity$3 = G__3986__3;
G__3986.cljs$core$IFn$_invoke$arity$variadic = G__3986__4.cljs$core$IFn$_invoke$arity$variadic;
return G__3986;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__3992 = null;
var G__3992__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__3992__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__3992__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__3992__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__3992__4 = (function() { 
var G__3993__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__3993 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__3994__i = 0, G__3994__a = new Array(arguments.length -  3);
while (G__3994__i < G__3994__a.length) {G__3994__a[G__3994__i] = arguments[G__3994__i + 3]; ++G__3994__i;}
  args = new cljs.core.IndexedSeq(G__3994__a,0,null);
} 
return G__3993__delegate.call(this,x,y,z,args);};
G__3993.cljs$lang$maxFixedArity = 3;
G__3993.cljs$lang$applyTo = (function (arglist__3995){
var x = cljs.core.first(arglist__3995);
arglist__3995 = cljs.core.next(arglist__3995);
var y = cljs.core.first(arglist__3995);
arglist__3995 = cljs.core.next(arglist__3995);
var z = cljs.core.first(arglist__3995);
var args = cljs.core.rest(arglist__3995);
return G__3993__delegate(x,y,z,args);
});
G__3993.cljs$core$IFn$_invoke$arity$variadic = G__3993__delegate;
return G__3993;
})()
;
G__3992 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__3992__0.call(this);
case 1:
return G__3992__1.call(this,x);
case 2:
return G__3992__2.call(this,x,y);
case 3:
return G__3992__3.call(this,x,y,z);
default:
var G__3996 = null;
if (arguments.length > 3) {
var G__3997__i = 0, G__3997__a = new Array(arguments.length -  3);
while (G__3997__i < G__3997__a.length) {G__3997__a[G__3997__i] = arguments[G__3997__i + 3]; ++G__3997__i;}
G__3996 = new cljs.core.IndexedSeq(G__3997__a,0,null);
}
return G__3992__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__3996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3992.cljs$lang$maxFixedArity = 3;
G__3992.cljs$lang$applyTo = G__3992__4.cljs$lang$applyTo;
G__3992.cljs$core$IFn$_invoke$arity$0 = G__3992__0;
G__3992.cljs$core$IFn$_invoke$arity$1 = G__3992__1;
G__3992.cljs$core$IFn$_invoke$arity$2 = G__3992__2;
G__3992.cljs$core$IFn$_invoke$arity$3 = G__3992__3;
G__3992.cljs$core$IFn$_invoke$arity$variadic = G__3992__4.cljs$core$IFn$_invoke$arity$variadic;
return G__3992;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__3998__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__3998 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__3999__i = 0, G__3999__a = new Array(arguments.length -  0);
while (G__3999__i < G__3999__a.length) {G__3999__a[G__3999__i] = arguments[G__3999__i + 0]; ++G__3999__i;}
  args = new cljs.core.IndexedSeq(G__3999__a,0,null);
} 
return G__3998__delegate.call(this,args);};
G__3998.cljs$lang$maxFixedArity = 0;
G__3998.cljs$lang$applyTo = (function (arglist__4000){
var args = cljs.core.seq(arglist__4000);
return G__3998__delegate(args);
});
G__3998.cljs$core$IFn$_invoke$arity$variadic = G__3998__delegate;
return G__3998;
})()
;
});

/** @this {Function} */
cljs.core.partial.cljs$lang$applyTo = (function (seq3970){
var G__3971 = cljs.core.first(seq3970);
var seq3970__$1 = cljs.core.next(seq3970);
var G__3972 = cljs.core.first(seq3970__$1);
var seq3970__$2 = cljs.core.next(seq3970__$1);
var G__3973 = cljs.core.first(seq3970__$2);
var seq3970__$3 = cljs.core.next(seq3970__$2);
var G__3974 = cljs.core.first(seq3970__$3);
var seq3970__$4 = cljs.core.next(seq3970__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3971,G__3972,G__3973,G__3974,seq3970__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__4002 = arguments.length;
switch (G__4002) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__4020 = null;
var G__4020__1 = (function (a){
var G__4003 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4003) : f.call(null,G__4003));
});
var G__4020__2 = (function (a,b){
var G__4004 = (((a == null))?x:a);
var G__4005 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4004,G__4005) : f.call(null,G__4004,G__4005));
});
var G__4020__3 = (function (a,b,c){
var G__4006 = (((a == null))?x:a);
var G__4007 = b;
var G__4008 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4006,G__4007,G__4008) : f.call(null,G__4006,G__4007,G__4008));
});
var G__4020__4 = (function() { 
var G__4021__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__4021 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__4022__i = 0, G__4022__a = new Array(arguments.length -  3);
while (G__4022__i < G__4022__a.length) {G__4022__a[G__4022__i] = arguments[G__4022__i + 3]; ++G__4022__i;}
  ds = new cljs.core.IndexedSeq(G__4022__a,0,null);
} 
return G__4021__delegate.call(this,a,b,c,ds);};
G__4021.cljs$lang$maxFixedArity = 3;
G__4021.cljs$lang$applyTo = (function (arglist__4023){
var a = cljs.core.first(arglist__4023);
arglist__4023 = cljs.core.next(arglist__4023);
var b = cljs.core.first(arglist__4023);
arglist__4023 = cljs.core.next(arglist__4023);
var c = cljs.core.first(arglist__4023);
var ds = cljs.core.rest(arglist__4023);
return G__4021__delegate(a,b,c,ds);
});
G__4021.cljs$core$IFn$_invoke$arity$variadic = G__4021__delegate;
return G__4021;
})()
;
G__4020 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__4020__1.call(this,a);
case 2:
return G__4020__2.call(this,a,b);
case 3:
return G__4020__3.call(this,a,b,c);
default:
var G__4024 = null;
if (arguments.length > 3) {
var G__4025__i = 0, G__4025__a = new Array(arguments.length -  3);
while (G__4025__i < G__4025__a.length) {G__4025__a[G__4025__i] = arguments[G__4025__i + 3]; ++G__4025__i;}
G__4024 = new cljs.core.IndexedSeq(G__4025__a,0,null);
}
return G__4020__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__4024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4020.cljs$lang$maxFixedArity = 3;
G__4020.cljs$lang$applyTo = G__4020__4.cljs$lang$applyTo;
G__4020.cljs$core$IFn$_invoke$arity$1 = G__4020__1;
G__4020.cljs$core$IFn$_invoke$arity$2 = G__4020__2;
G__4020.cljs$core$IFn$_invoke$arity$3 = G__4020__3;
G__4020.cljs$core$IFn$_invoke$arity$variadic = G__4020__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4020;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__4026 = null;
var G__4026__2 = (function (a,b){
var G__4009 = (((a == null))?x:a);
var G__4010 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4009,G__4010) : f.call(null,G__4009,G__4010));
});
var G__4026__3 = (function (a,b,c){
var G__4011 = (((a == null))?x:a);
var G__4012 = (((b == null))?y:b);
var G__4013 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4011,G__4012,G__4013) : f.call(null,G__4011,G__4012,G__4013));
});
var G__4026__4 = (function() { 
var G__4027__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__4027 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__4028__i = 0, G__4028__a = new Array(arguments.length -  3);
while (G__4028__i < G__4028__a.length) {G__4028__a[G__4028__i] = arguments[G__4028__i + 3]; ++G__4028__i;}
  ds = new cljs.core.IndexedSeq(G__4028__a,0,null);
} 
return G__4027__delegate.call(this,a,b,c,ds);};
G__4027.cljs$lang$maxFixedArity = 3;
G__4027.cljs$lang$applyTo = (function (arglist__4029){
var a = cljs.core.first(arglist__4029);
arglist__4029 = cljs.core.next(arglist__4029);
var b = cljs.core.first(arglist__4029);
arglist__4029 = cljs.core.next(arglist__4029);
var c = cljs.core.first(arglist__4029);
var ds = cljs.core.rest(arglist__4029);
return G__4027__delegate(a,b,c,ds);
});
G__4027.cljs$core$IFn$_invoke$arity$variadic = G__4027__delegate;
return G__4027;
})()
;
G__4026 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__4026__2.call(this,a,b);
case 3:
return G__4026__3.call(this,a,b,c);
default:
var G__4030 = null;
if (arguments.length > 3) {
var G__4031__i = 0, G__4031__a = new Array(arguments.length -  3);
while (G__4031__i < G__4031__a.length) {G__4031__a[G__4031__i] = arguments[G__4031__i + 3]; ++G__4031__i;}
G__4030 = new cljs.core.IndexedSeq(G__4031__a,0,null);
}
return G__4026__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__4030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4026.cljs$lang$maxFixedArity = 3;
G__4026.cljs$lang$applyTo = G__4026__4.cljs$lang$applyTo;
G__4026.cljs$core$IFn$_invoke$arity$2 = G__4026__2;
G__4026.cljs$core$IFn$_invoke$arity$3 = G__4026__3;
G__4026.cljs$core$IFn$_invoke$arity$variadic = G__4026__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4026;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__4032 = null;
var G__4032__2 = (function (a,b){
var G__4014 = (((a == null))?x:a);
var G__4015 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4014,G__4015) : f.call(null,G__4014,G__4015));
});
var G__4032__3 = (function (a,b,c){
var G__4016 = (((a == null))?x:a);
var G__4017 = (((b == null))?y:b);
var G__4018 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4016,G__4017,G__4018) : f.call(null,G__4016,G__4017,G__4018));
});
var G__4032__4 = (function() { 
var G__4033__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__4033 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__4034__i = 0, G__4034__a = new Array(arguments.length -  3);
while (G__4034__i < G__4034__a.length) {G__4034__a[G__4034__i] = arguments[G__4034__i + 3]; ++G__4034__i;}
  ds = new cljs.core.IndexedSeq(G__4034__a,0,null);
} 
return G__4033__delegate.call(this,a,b,c,ds);};
G__4033.cljs$lang$maxFixedArity = 3;
G__4033.cljs$lang$applyTo = (function (arglist__4035){
var a = cljs.core.first(arglist__4035);
arglist__4035 = cljs.core.next(arglist__4035);
var b = cljs.core.first(arglist__4035);
arglist__4035 = cljs.core.next(arglist__4035);
var c = cljs.core.first(arglist__4035);
var ds = cljs.core.rest(arglist__4035);
return G__4033__delegate(a,b,c,ds);
});
G__4033.cljs$core$IFn$_invoke$arity$variadic = G__4033__delegate;
return G__4033;
})()
;
G__4032 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__4032__2.call(this,a,b);
case 3:
return G__4032__3.call(this,a,b,c);
default:
var G__4036 = null;
if (arguments.length > 3) {
var G__4037__i = 0, G__4037__a = new Array(arguments.length -  3);
while (G__4037__i < G__4037__a.length) {G__4037__a[G__4037__i] = arguments[G__4037__i + 3]; ++G__4037__i;}
G__4036 = new cljs.core.IndexedSeq(G__4037__a,0,null);
}
return G__4032__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__4036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4032.cljs$lang$maxFixedArity = 3;
G__4032.cljs$lang$applyTo = G__4032__4.cljs$lang$applyTo;
G__4032.cljs$core$IFn$_invoke$arity$2 = G__4032__2;
G__4032.cljs$core$IFn$_invoke$arity$3 = G__4032__3;
G__4032.cljs$core$IFn$_invoke$arity$variadic = G__4032__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4032;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__4039 = arguments.length;
switch (G__4039) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = cljs.core.volatile_BANG_((-1));
return ((function (i){
return (function() {
var G__4053 = null;
var G__4053__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4053__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4053__2 = (function (result,input){
var G__4040 = result;
var G__4041 = (function (){var G__4042 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__4043 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4042,G__4043) : f.call(null,G__4042,G__4043));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__4040,G__4041) : rf.call(null,G__4040,G__4041));
});
G__4053 = function(result,input){
switch(arguments.length){
case 0:
return G__4053__0.call(this);
case 1:
return G__4053__1.call(this,result);
case 2:
return G__4053__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4053.cljs$core$IFn$_invoke$arity$0 = G__4053__0;
G__4053.cljs$core$IFn$_invoke$arity$1 = G__4053__1;
G__4053.cljs$core$IFn$_invoke$arity$2 = G__4053__2;
return G__4053;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll__$1);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4607__auto___4054 = size;
var i_4055 = (0);
while(true){
if((i_4055 < n__4607__auto___4054)){
cljs.core.chunk_append(b,(function (){var G__4048 = (idx + i_4055);
var G__4049 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4055);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4048,G__4049) : f.call(null,G__4048,G__4049));
})());

var G__4056 = (i_4055 + (1));
i_4055 = G__4056;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__4050 = idx;
var G__4051 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4050,G__4051) : f.call(null,G__4050,G__4051));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__4058 = arguments.length;
switch (G__4058) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__4062 = null;
var G__4062__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4062__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4062__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__4062 = function(result,input){
switch(arguments.length){
case 0:
return G__4062__0.call(this);
case 1:
return G__4062__1.call(this,result);
case 2:
return G__4062__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4062.cljs$core$IFn$_invoke$arity$0 = G__4062__0;
G__4062.cljs$core$IFn$_invoke$arity$1 = G__4062__1;
G__4062.cljs$core$IFn$_invoke$arity$2 = G__4062__2;
return G__4062;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4607__auto___4063 = size;
var i_4064 = (0);
while(true){
if((i_4064 < n__4607__auto___4063)){
var x_4065 = (function (){var G__4059 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4064);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4059) : f.call(null,G__4059));
})();
if((x_4065 == null)){
} else {
cljs.core.chunk_append(b,x_4065);
}

var G__4066 = (i_4064 + (1));
i_4064 = G__4066;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__4060 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4060) : f.call(null,G__4060));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__4067 = cljs.core.seq(self__.watches);
var chunk__4068 = null;
var count__4069 = (0);
var i__4070 = (0);
while(true){
if((i__4070 < count__4069)){
var vec__4077 = chunk__4068.cljs$core$IIndexed$_nth$arity$2(null,i__4070);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4077,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4077,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__4083 = seq__4067;
var G__4084 = chunk__4068;
var G__4085 = count__4069;
var G__4086 = (i__4070 + (1));
seq__4067 = G__4083;
chunk__4068 = G__4084;
count__4069 = G__4085;
i__4070 = G__4086;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__4067);
if(temp__5735__auto__){
var seq__4067__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4067__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__4067__$1);
var G__4087 = cljs.core.chunk_rest(seq__4067__$1);
var G__4088 = c__4550__auto__;
var G__4089 = cljs.core.count(c__4550__auto__);
var G__4090 = (0);
seq__4067 = G__4087;
chunk__4068 = G__4088;
count__4069 = G__4089;
i__4070 = G__4090;
continue;
} else {
var vec__4080 = cljs.core.first(seq__4067__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4080,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4080,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__4091 = cljs.core.next(seq__4067__$1);
var G__4092 = null;
var G__4093 = (0);
var G__4094 = (0);
seq__4067 = G__4091;
chunk__4068 = G__4092;
count__4069 = G__4093;
i__4070 = G__4094;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Atom");
});

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__4098 = arguments.length;
switch (G__4098) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4103 = arguments.length;
var i__4731__auto___4104 = (0);
while(true){
if((i__4731__auto___4104 < len__4730__auto___4103)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4104]));

var G__4105 = (i__4731__auto___4104 + (1));
i__4731__auto___4104 = G__4105;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4752__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__4099){
var map__4100 = p__4099;
var map__4100__$1 = (((((!((map__4100 == null))))?(((((map__4100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4100.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4100):map__4100);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4100__$1,cljs.core.cst$kw$meta);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4100__$1,cljs.core.cst$kw$validator);
return (new cljs.core.Atom(x,meta,validator,null));
});

/** @this {Function} */
cljs.core.atom.cljs$lang$applyTo = (function (seq4096){
var G__4097 = cljs.core.first(seq4096);
var seq4096__$1 = cljs.core.next(seq4096);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4097,seq4096__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__4112 = arguments.length;
switch (G__4112) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4120 = arguments.length;
var i__4731__auto___4121 = (0);
while(true){
if((i__4731__auto___4121 < len__4730__auto___4120)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4121]));

var G__4122 = (i__4731__auto___4121 + (1));
i__4731__auto___4121 = G__4122;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__4113 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4113) : f.call(null,G__4113));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__4114 = a.state;
var G__4115 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4114,G__4115) : f.call(null,G__4114,G__4115));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__4116 = a.state;
var G__4117 = x;
var G__4118 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4116,G__4117,G__4118) : f.call(null,G__4116,G__4117,G__4118));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

/** @this {Function} */
cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq4107){
var G__4108 = cljs.core.first(seq4107);
var seq4107__$1 = cljs.core.next(seq4107);
var G__4109 = cljs.core.first(seq4107__$1);
var seq4107__$2 = cljs.core.next(seq4107__$1);
var G__4110 = cljs.core.first(seq4107__$2);
var seq4107__$3 = cljs.core.next(seq4107__$2);
var G__4111 = cljs.core.first(seq4107__$3);
var seq4107__$4 = cljs.core.next(seq4107__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4108,G__4109,G__4110,G__4111,seq4107__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__4129 = arguments.length;
switch (G__4129) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4137 = arguments.length;
var i__4731__auto___4138 = (0);
while(true){
if((i__4731__auto___4138 < len__4730__auto___4137)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4138]));

var G__4139 = (i__4731__auto___4138 + (1));
i__4731__auto___4138 = G__4139;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
return cljs.core.reset_vals_BANG_(a,(function (){var G__4130 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4130) : f.call(null,G__4130));
})());
});

cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
return cljs.core.reset_vals_BANG_(a,(function (){var G__4131 = a.state;
var G__4132 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4131,G__4132) : f.call(null,G__4131,G__4132));
})());
});

cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
return cljs.core.reset_vals_BANG_(a,(function (){var G__4133 = a.state;
var G__4134 = x;
var G__4135 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4133,G__4134,G__4135) : f.call(null,G__4133,G__4134,G__4135));
})());
});

cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
});

/** @this {Function} */
cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function (seq4124){
var G__4125 = cljs.core.first(seq4124);
var seq4124__$1 = cljs.core.next(seq4124);
var G__4126 = cljs.core.first(seq4124__$1);
var seq4124__$2 = cljs.core.next(seq4124__$1);
var G__4127 = cljs.core.first(seq4124__$2);
var seq4124__$3 = cljs.core.next(seq4124__$2);
var G__4128 = cljs.core.first(seq4124__$3);
var seq4124__$4 = cljs.core.next(seq4124__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4125,G__4126,G__4127,G__4128,seq4124__$4);
});

cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4);

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__4141 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__4141) : val.call(null,G__4141));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Volatile");
});

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__4143 = arguments.length;
switch (G__4143) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__4153 = null;
var G__4153__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4153__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4153__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__4153 = function(result,input){
switch(arguments.length){
case 0:
return G__4153__0.call(this);
case 1:
return G__4153__1.call(this,result);
case 2:
return G__4153__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4153.cljs$core$IFn$_invoke$arity$0 = G__4153__0;
G__4153.cljs$core$IFn$_invoke$arity$1 = G__4153__1;
G__4153.cljs$core$IFn$_invoke$arity$2 = G__4153__2;
return G__4153;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll__$1);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4607__auto___4154 = size;
var i_4155 = (0);
while(true){
if((i_4155 < n__4607__auto___4154)){
var x_4156 = (function (){var G__4148 = (idx + i_4155);
var G__4149 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4155);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4148,G__4149) : f.call(null,G__4148,G__4149));
})();
if((x_4156 == null)){
} else {
cljs.core.chunk_append(b,x_4156);
}

var G__4157 = (i_4155 + (1));
i_4155 = G__4157;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__4150 = idx;
var G__4151 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4150,G__4151) : f.call(null,G__4150,G__4151));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__4169 = arguments.length;
switch (G__4169) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4171 = arguments.length;
var i__4731__auto___4172 = (0);
while(true){
if((i__4731__auto___4172 < len__4730__auto___4171)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4172]));

var G__4173 = (i__4731__auto___4172 + (1));
i__4731__auto___4172 = G__4173;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__4120__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__4174__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4120__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__4120__auto__;
}
})());
};
var G__4174 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4175__i = 0, G__4175__a = new Array(arguments.length -  3);
while (G__4175__i < G__4175__a.length) {G__4175__a[G__4175__i] = arguments[G__4175__i + 3]; ++G__4175__i;}
  args = new cljs.core.IndexedSeq(G__4175__a,0,null);
} 
return G__4174__delegate.call(this,x,y,z,args);};
G__4174.cljs$lang$maxFixedArity = 3;
G__4174.cljs$lang$applyTo = (function (arglist__4176){
var x = cljs.core.first(arglist__4176);
arglist__4176 = cljs.core.next(arglist__4176);
var y = cljs.core.first(arglist__4176);
arglist__4176 = cljs.core.next(arglist__4176);
var z = cljs.core.first(arglist__4176);
var args = cljs.core.rest(arglist__4176);
return G__4174__delegate(x,y,z,args);
});
G__4174.cljs$core$IFn$_invoke$arity$variadic = G__4174__delegate;
return G__4174;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__4177 = null;
if (arguments.length > 3) {
var G__4178__i = 0, G__4178__a = new Array(arguments.length -  3);
while (G__4178__i < G__4178__a.length) {G__4178__a[G__4178__i] = arguments[G__4178__i + 3]; ++G__4178__i;}
G__4177 = new cljs.core.IndexedSeq(G__4178__a,0,null);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4120__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__4120__auto____$2)){
var and__4120__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4120__auto____$3)){
var and__4120__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4120__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__4120__auto____$4;
}
} else {
return and__4120__auto____$3;
}
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__4179__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4120__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.every_QMARK_(((function (and__4120__auto__){
return (function (p1__4158_SHARP_){
var and__4120__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4158_SHARP_) : p1.call(null,p1__4158_SHARP_));
if(cljs.core.truth_(and__4120__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4158_SHARP_) : p2.call(null,p1__4158_SHARP_));
} else {
return and__4120__auto____$1;
}
});})(and__4120__auto__))
,args);
} else {
return and__4120__auto__;
}
})());
};
var G__4179 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4180__i = 0, G__4180__a = new Array(arguments.length -  3);
while (G__4180__i < G__4180__a.length) {G__4180__a[G__4180__i] = arguments[G__4180__i + 3]; ++G__4180__i;}
  args = new cljs.core.IndexedSeq(G__4180__a,0,null);
} 
return G__4179__delegate.call(this,x,y,z,args);};
G__4179.cljs$lang$maxFixedArity = 3;
G__4179.cljs$lang$applyTo = (function (arglist__4181){
var x = cljs.core.first(arglist__4181);
arglist__4181 = cljs.core.next(arglist__4181);
var y = cljs.core.first(arglist__4181);
arglist__4181 = cljs.core.next(arglist__4181);
var z = cljs.core.first(arglist__4181);
var args = cljs.core.rest(arglist__4181);
return G__4179__delegate(x,y,z,args);
});
G__4179.cljs$core$IFn$_invoke$arity$variadic = G__4179__delegate;
return G__4179;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__4182 = null;
if (arguments.length > 3) {
var G__4183__i = 0, G__4183__a = new Array(arguments.length -  3);
while (G__4183__i < G__4183__a.length) {G__4183__a[G__4183__i] = arguments[G__4183__i + 3]; ++G__4183__i;}
G__4182 = new cljs.core.IndexedSeq(G__4183__a,0,null);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4120__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__4120__auto____$2)){
var and__4120__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4120__auto____$3)){
var and__4120__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4120__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__4120__auto____$4;
}
} else {
return and__4120__auto____$3;
}
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4120__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__4120__auto____$2)){
var and__4120__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4120__auto____$3)){
var and__4120__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4120__auto____$4)){
var and__4120__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__4120__auto____$5)){
var and__4120__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__4120__auto____$6)){
var and__4120__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__4120__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__4120__auto____$7;
}
} else {
return and__4120__auto____$6;
}
} else {
return and__4120__auto____$5;
}
} else {
return and__4120__auto____$4;
}
} else {
return and__4120__auto____$3;
}
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__4184__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4120__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.every_QMARK_(((function (and__4120__auto__){
return (function (p1__4159_SHARP_){
var and__4120__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4159_SHARP_) : p1.call(null,p1__4159_SHARP_));
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4159_SHARP_) : p2.call(null,p1__4159_SHARP_));
if(cljs.core.truth_(and__4120__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__4159_SHARP_) : p3.call(null,p1__4159_SHARP_));
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
});})(and__4120__auto__))
,args);
} else {
return and__4120__auto__;
}
})());
};
var G__4184 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4185__i = 0, G__4185__a = new Array(arguments.length -  3);
while (G__4185__i < G__4185__a.length) {G__4185__a[G__4185__i] = arguments[G__4185__i + 3]; ++G__4185__i;}
  args = new cljs.core.IndexedSeq(G__4185__a,0,null);
} 
return G__4184__delegate.call(this,x,y,z,args);};
G__4184.cljs$lang$maxFixedArity = 3;
G__4184.cljs$lang$applyTo = (function (arglist__4186){
var x = cljs.core.first(arglist__4186);
arglist__4186 = cljs.core.next(arglist__4186);
var y = cljs.core.first(arglist__4186);
arglist__4186 = cljs.core.next(arglist__4186);
var z = cljs.core.first(arglist__4186);
var args = cljs.core.rest(arglist__4186);
return G__4184__delegate(x,y,z,args);
});
G__4184.cljs$core$IFn$_invoke$arity$variadic = G__4184__delegate;
return G__4184;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__4187 = null;
if (arguments.length > 3) {
var G__4188__i = 0, G__4188__a = new Array(arguments.length -  3);
while (G__4188__i < G__4188__a.length) {G__4188__a[G__4188__i] = arguments[G__4188__i + 3]; ++G__4188__i;}
G__4187 = new cljs.core.IndexedSeq(G__4188__a,0,null);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__4160_SHARP_){
return (p1__4160_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4160_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4160_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__4161_SHARP_){
var and__4120__auto__ = (p1__4161_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4161_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4161_SHARP_.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
return (p1__4161_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4161_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4161_SHARP_.call(null,y));
} else {
return and__4120__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__4162_SHARP_){
var and__4120__auto__ = (p1__4162_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4162_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4162_SHARP_.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = (p1__4162_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4162_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4162_SHARP_.call(null,y));
if(cljs.core.truth_(and__4120__auto____$1)){
return (p1__4162_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4162_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__4162_SHARP_.call(null,z));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__4189__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4120__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.every_QMARK_(((function (and__4120__auto__,ps__$1){
return (function (p1__4163_SHARP_){
return cljs.core.every_QMARK_(p1__4163_SHARP_,args);
});})(and__4120__auto__,ps__$1))
,ps__$1);
} else {
return and__4120__auto__;
}
})());
};
var G__4189 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4190__i = 0, G__4190__a = new Array(arguments.length -  3);
while (G__4190__i < G__4190__a.length) {G__4190__a[G__4190__i] = arguments[G__4190__i + 3]; ++G__4190__i;}
  args = new cljs.core.IndexedSeq(G__4190__a,0,null);
} 
return G__4189__delegate.call(this,x,y,z,args);};
G__4189.cljs$lang$maxFixedArity = 3;
G__4189.cljs$lang$applyTo = (function (arglist__4191){
var x = cljs.core.first(arglist__4191);
arglist__4191 = cljs.core.next(arglist__4191);
var y = cljs.core.first(arglist__4191);
arglist__4191 = cljs.core.next(arglist__4191);
var z = cljs.core.first(arglist__4191);
var args = cljs.core.rest(arglist__4191);
return G__4189__delegate(x,y,z,args);
});
G__4189.cljs$core$IFn$_invoke$arity$variadic = G__4189__delegate;
return G__4189;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__4192 = null;
if (arguments.length > 3) {
var G__4193__i = 0, G__4193__a = new Array(arguments.length -  3);
while (G__4193__i < G__4193__a.length) {G__4193__a[G__4193__i] = arguments[G__4193__i + 3]; ++G__4193__i;}
G__4192 = new cljs.core.IndexedSeq(G__4193__a,0,null);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

/** @this {Function} */
cljs.core.every_pred.cljs$lang$applyTo = (function (seq4165){
var G__4166 = cljs.core.first(seq4165);
var seq4165__$1 = cljs.core.next(seq4165);
var G__4167 = cljs.core.first(seq4165__$1);
var seq4165__$2 = cljs.core.next(seq4165__$1);
var G__4168 = cljs.core.first(seq4165__$2);
var seq4165__$3 = cljs.core.next(seq4165__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4166,G__4167,G__4168,seq4165__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__4205 = arguments.length;
switch (G__4205) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4207 = arguments.length;
var i__4731__auto___4208 = (0);
while(true){
if((i__4731__auto___4208 < len__4730__auto___4207)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4208]));

var G__4209 = (i__4731__auto___4208 + (1));
i__4731__auto___4208 = G__4209;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__4131__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__4131__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__4210__delegate = function (x,y,z,args){
var or__4131__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__4210 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4211__i = 0, G__4211__a = new Array(arguments.length -  3);
while (G__4211__i < G__4211__a.length) {G__4211__a[G__4211__i] = arguments[G__4211__i + 3]; ++G__4211__i;}
  args = new cljs.core.IndexedSeq(G__4211__a,0,null);
} 
return G__4210__delegate.call(this,x,y,z,args);};
G__4210.cljs$lang$maxFixedArity = 3;
G__4210.cljs$lang$applyTo = (function (arglist__4212){
var x = cljs.core.first(arglist__4212);
arglist__4212 = cljs.core.next(arglist__4212);
var y = cljs.core.first(arglist__4212);
arglist__4212 = cljs.core.next(arglist__4212);
var z = cljs.core.first(arglist__4212);
var args = cljs.core.rest(arglist__4212);
return G__4210__delegate(x,y,z,args);
});
G__4210.cljs$core$IFn$_invoke$arity$variadic = G__4210__delegate;
return G__4210;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__4213 = null;
if (arguments.length > 3) {
var G__4214__i = 0, G__4214__a = new Array(arguments.length -  3);
while (G__4214__i < G__4214__a.length) {G__4214__a[G__4214__i] = arguments[G__4214__i + 3]; ++G__4214__i;}
G__4213 = new cljs.core.IndexedSeq(G__4214__a,0,null);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__4131__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__4131__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__4131__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
var or__4131__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4131__auto____$3)){
return or__4131__auto____$3;
} else {
var or__4131__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4131__auto____$4)){
return or__4131__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__4215__delegate = function (x,y,z,args){
var or__4131__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.some(((function (or__4131__auto__){
return (function (p1__4194_SHARP_){
var or__4131__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4194_SHARP_) : p1.call(null,p1__4194_SHARP_));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4194_SHARP_) : p2.call(null,p1__4194_SHARP_));
}
});})(or__4131__auto__))
,args);
}
};
var G__4215 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4216__i = 0, G__4216__a = new Array(arguments.length -  3);
while (G__4216__i < G__4216__a.length) {G__4216__a[G__4216__i] = arguments[G__4216__i + 3]; ++G__4216__i;}
  args = new cljs.core.IndexedSeq(G__4216__a,0,null);
} 
return G__4215__delegate.call(this,x,y,z,args);};
G__4215.cljs$lang$maxFixedArity = 3;
G__4215.cljs$lang$applyTo = (function (arglist__4217){
var x = cljs.core.first(arglist__4217);
arglist__4217 = cljs.core.next(arglist__4217);
var y = cljs.core.first(arglist__4217);
arglist__4217 = cljs.core.next(arglist__4217);
var z = cljs.core.first(arglist__4217);
var args = cljs.core.rest(arglist__4217);
return G__4215__delegate(x,y,z,args);
});
G__4215.cljs$core$IFn$_invoke$arity$variadic = G__4215__delegate;
return G__4215;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__4218 = null;
if (arguments.length > 3) {
var G__4219__i = 0, G__4219__a = new Array(arguments.length -  3);
while (G__4219__i < G__4219__a.length) {G__4219__a[G__4219__i] = arguments[G__4219__i + 3]; ++G__4219__i;}
G__4218 = new cljs.core.IndexedSeq(G__4219__a,0,null);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__4131__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__4131__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
var or__4131__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4131__auto____$3)){
return or__4131__auto____$3;
} else {
var or__4131__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4131__auto____$4)){
return or__4131__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__4131__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
var or__4131__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4131__auto____$3)){
return or__4131__auto____$3;
} else {
var or__4131__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4131__auto____$4)){
return or__4131__auto____$4;
} else {
var or__4131__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__4131__auto____$5)){
return or__4131__auto____$5;
} else {
var or__4131__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__4131__auto____$6)){
return or__4131__auto____$6;
} else {
var or__4131__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__4131__auto____$7)){
return or__4131__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__4220__delegate = function (x,y,z,args){
var or__4131__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.some(((function (or__4131__auto__){
return (function (p1__4195_SHARP_){
var or__4131__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4195_SHARP_) : p1.call(null,p1__4195_SHARP_));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4195_SHARP_) : p2.call(null,p1__4195_SHARP_));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__4195_SHARP_) : p3.call(null,p1__4195_SHARP_));
}
}
});})(or__4131__auto__))
,args);
}
};
var G__4220 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4221__i = 0, G__4221__a = new Array(arguments.length -  3);
while (G__4221__i < G__4221__a.length) {G__4221__a[G__4221__i] = arguments[G__4221__i + 3]; ++G__4221__i;}
  args = new cljs.core.IndexedSeq(G__4221__a,0,null);
} 
return G__4220__delegate.call(this,x,y,z,args);};
G__4220.cljs$lang$maxFixedArity = 3;
G__4220.cljs$lang$applyTo = (function (arglist__4222){
var x = cljs.core.first(arglist__4222);
arglist__4222 = cljs.core.next(arglist__4222);
var y = cljs.core.first(arglist__4222);
arglist__4222 = cljs.core.next(arglist__4222);
var z = cljs.core.first(arglist__4222);
var args = cljs.core.rest(arglist__4222);
return G__4220__delegate(x,y,z,args);
});
G__4220.cljs$core$IFn$_invoke$arity$variadic = G__4220__delegate;
return G__4220;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__4223 = null;
if (arguments.length > 3) {
var G__4224__i = 0, G__4224__a = new Array(arguments.length -  3);
while (G__4224__i < G__4224__a.length) {G__4224__a[G__4224__i] = arguments[G__4224__i + 3]; ++G__4224__i;}
G__4223 = new cljs.core.IndexedSeq(G__4224__a,0,null);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__4196_SHARP_){
return (p1__4196_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4196_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4196_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__4197_SHARP_){
var or__4131__auto__ = (p1__4197_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4197_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4197_SHARP_.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (p1__4197_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4197_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4197_SHARP_.call(null,y));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__4198_SHARP_){
var or__4131__auto__ = (p1__4198_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4198_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4198_SHARP_.call(null,x));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (p1__4198_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4198_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4198_SHARP_.call(null,y));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (p1__4198_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4198_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__4198_SHARP_.call(null,z));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__4225__delegate = function (x,y,z,args){
var or__4131__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.some(((function (or__4131__auto__,ps__$1){
return (function (p1__4199_SHARP_){
return cljs.core.some(p1__4199_SHARP_,args);
});})(or__4131__auto__,ps__$1))
,ps__$1);
}
};
var G__4225 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4226__i = 0, G__4226__a = new Array(arguments.length -  3);
while (G__4226__i < G__4226__a.length) {G__4226__a[G__4226__i] = arguments[G__4226__i + 3]; ++G__4226__i;}
  args = new cljs.core.IndexedSeq(G__4226__a,0,null);
} 
return G__4225__delegate.call(this,x,y,z,args);};
G__4225.cljs$lang$maxFixedArity = 3;
G__4225.cljs$lang$applyTo = (function (arglist__4227){
var x = cljs.core.first(arglist__4227);
arglist__4227 = cljs.core.next(arglist__4227);
var y = cljs.core.first(arglist__4227);
arglist__4227 = cljs.core.next(arglist__4227);
var z = cljs.core.first(arglist__4227);
var args = cljs.core.rest(arglist__4227);
return G__4225__delegate(x,y,z,args);
});
G__4225.cljs$core$IFn$_invoke$arity$variadic = G__4225__delegate;
return G__4225;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__4228 = null;
if (arguments.length > 3) {
var G__4229__i = 0, G__4229__a = new Array(arguments.length -  3);
while (G__4229__i < G__4229__a.length) {G__4229__a[G__4229__i] = arguments[G__4229__i + 3]; ++G__4229__i;}
G__4228 = new cljs.core.IndexedSeq(G__4229__a,0,null);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

/** @this {Function} */
cljs.core.some_fn.cljs$lang$applyTo = (function (seq4201){
var G__4202 = cljs.core.first(seq4201);
var seq4201__$1 = cljs.core.next(seq4201);
var G__4203 = cljs.core.first(seq4201__$1);
var seq4201__$2 = cljs.core.next(seq4201__$1);
var G__4204 = cljs.core.first(seq4201__$2);
var seq4201__$3 = cljs.core.next(seq4201__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4202,G__4203,G__4204,seq4201__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__4237 = arguments.length;
switch (G__4237) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4250 = arguments.length;
var i__4731__auto___4251 = (0);
while(true){
if((i__4731__auto___4251 < len__4730__auto___4250)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4251]));

var G__4252 = (i__4731__auto___4251 + (1));
i__4731__auto___4251 = G__4252;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__4253 = null;
var G__4253__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4253__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4253__2 = (function (result,input){
var G__4238 = result;
var G__4239 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__4238,G__4239) : rf.call(null,G__4238,G__4239));
});
var G__4253__3 = (function() { 
var G__4254__delegate = function (result,input,inputs){
var G__4240 = result;
var G__4241 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__4240,G__4241) : rf.call(null,G__4240,G__4241));
};
var G__4254 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__4255__i = 0, G__4255__a = new Array(arguments.length -  2);
while (G__4255__i < G__4255__a.length) {G__4255__a[G__4255__i] = arguments[G__4255__i + 2]; ++G__4255__i;}
  inputs = new cljs.core.IndexedSeq(G__4255__a,0,null);
} 
return G__4254__delegate.call(this,result,input,inputs);};
G__4254.cljs$lang$maxFixedArity = 2;
G__4254.cljs$lang$applyTo = (function (arglist__4256){
var result = cljs.core.first(arglist__4256);
arglist__4256 = cljs.core.next(arglist__4256);
var input = cljs.core.first(arglist__4256);
var inputs = cljs.core.rest(arglist__4256);
return G__4254__delegate(result,input,inputs);
});
G__4254.cljs$core$IFn$_invoke$arity$variadic = G__4254__delegate;
return G__4254;
})()
;
G__4253 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__4253__0.call(this);
case 1:
return G__4253__1.call(this,result);
case 2:
return G__4253__2.call(this,result,input);
default:
var G__4257 = null;
if (arguments.length > 2) {
var G__4258__i = 0, G__4258__a = new Array(arguments.length -  2);
while (G__4258__i < G__4258__a.length) {G__4258__a[G__4258__i] = arguments[G__4258__i + 2]; ++G__4258__i;}
G__4257 = new cljs.core.IndexedSeq(G__4258__a,0,null);
}
return G__4253__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__4257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4253.cljs$lang$maxFixedArity = 2;
G__4253.cljs$lang$applyTo = G__4253__3.cljs$lang$applyTo;
G__4253.cljs$core$IFn$_invoke$arity$0 = G__4253__0;
G__4253.cljs$core$IFn$_invoke$arity$1 = G__4253__1;
G__4253.cljs$core$IFn$_invoke$arity$2 = G__4253__2;
G__4253.cljs$core$IFn$_invoke$arity$variadic = G__4253__3.cljs$core$IFn$_invoke$arity$variadic;
return G__4253;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4607__auto___4259 = size;
var i_4260 = (0);
while(true){
if((i_4260 < n__4607__auto___4259)){
cljs.core.chunk_append(b,(function (){var G__4242 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4260);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4242) : f.call(null,G__4242));
})());

var G__4261 = (i_4260 + (1));
i_4260 = G__4261;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__4243 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4243) : f.call(null,G__4243));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__4244 = cljs.core.first(s1);
var G__4245 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4244,G__4245) : f.call(null,G__4244,G__4245));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (s2) && (s3))){
return cljs.core.cons((function (){var G__4246 = cljs.core.first(s1);
var G__4247 = cljs.core.first(s2);
var G__4248 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4246,G__4247,G__4248) : f.call(null,G__4246,G__4247,G__4248));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__4230_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__4230_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
});

/** @this {Function} */
cljs.core.map.cljs$lang$applyTo = (function (seq4232){
var G__4233 = cljs.core.first(seq4232);
var seq4232__$1 = cljs.core.next(seq4232);
var G__4234 = cljs.core.first(seq4232__$1);
var seq4232__$2 = cljs.core.next(seq4232__$1);
var G__4235 = cljs.core.first(seq4232__$2);
var seq4232__$3 = cljs.core.next(seq4232__$2);
var G__4236 = cljs.core.first(seq4232__$3);
var seq4232__$4 = cljs.core.next(seq4232__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4233,G__4234,G__4235,G__4236,seq4232__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__4263 = arguments.length;
switch (G__4263) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__4265 = null;
var G__4265__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4265__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4265__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__4265 = function(result,input){
switch(arguments.length){
case 0:
return G__4265__0.call(this);
case 1:
return G__4265__1.call(this,result);
case 2:
return G__4265__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4265.cljs$core$IFn$_invoke$arity$0 = G__4265__0;
G__4265.cljs$core$IFn$_invoke$arity$1 = G__4265__1;
G__4265.cljs$core$IFn$_invoke$arity$2 = G__4265__2;
return G__4265;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__4267 = arguments.length;
switch (G__4267) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__4269 = null;
var G__4269__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4269__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4269__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__4269 = function(result,input){
switch(arguments.length){
case 0:
return G__4269__0.call(this);
case 1:
return G__4269__1.call(this,result);
case 2:
return G__4269__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4269.cljs$core$IFn$_invoke$arity$0 = G__4269__0;
G__4269.cljs$core$IFn$_invoke$arity$1 = G__4269__1;
G__4269.cljs$core$IFn$_invoke$arity$2 = G__4269__2;
return G__4269;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__4270 = (n__$1 - (1));
var G__4271 = cljs.core.rest(s);
n__$1 = G__4270;
coll__$1 = G__4271;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__4273 = arguments.length;
switch (G__4273) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__4275 = cljs.core.next(s);
var G__4276 = cljs.core.next(lead);
s = G__4275;
lead = G__4276;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__4278 = arguments.length;
switch (G__4278) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__4282 = null;
var G__4282__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4282__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4282__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__4120__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__4120__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__4282 = function(result,input){
switch(arguments.length){
case 0:
return G__4282__0.call(this);
case 1:
return G__4282__1.call(this,result);
case 2:
return G__4282__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4282.cljs$core$IFn$_invoke$arity$0 = G__4282__0;
G__4282.cljs$core$IFn$_invoke$arity$1 = G__4282__1;
G__4282.cljs$core$IFn$_invoke$arity$2 = G__4282__2;
return G__4282;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = s;
if(and__4120__auto__){
var G__4280 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__4280) : pred__$1.call(null,G__4280));
} else {
return and__4120__auto__;
}
})())){
var G__4283 = pred__$1;
var G__4284 = cljs.core.rest(s);
pred__$1 = G__4283;
coll__$1 = G__4284;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
cljs.core.Cycle.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cycle.prototype.currentval = (function (){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5733__auto___4291 = cljs.core.next(self__.prev);
if(temp__5733__auto___4291){
var c_4292 = temp__5733__auto___4291;
self__.current = c_4292;
} else {
self__.current = self__.all;
}
}

return self__.current;
});

cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
});

cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
});

cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__4131__auto__ = cljs.core.next(s);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__4287 = ret;
var G__4288 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4287,G__4288) : f.call(null,G__4287,G__4288));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4293 = s__$1;
var G__4294 = ret__$1;
s = G__4293;
ret = G__4294;
continue;
}
break;
}
});

cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__4289 = ret;
var G__4290 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4289,G__4290) : f.call(null,G__4289,G__4290));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4295 = (function (){var or__4131__auto__ = cljs.core.next(s);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return self__.all;
}
})();
var G__4296 = ret__$1;
s = G__4295;
ret = G__4296;
continue;
}
break;
}
});

cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
});

cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null));
} else {
}

return self__._next;
});

cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
});

cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.Cycle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$all,cljs.core.cst$sym$prev,cljs.core.with_meta(cljs.core.cst$sym$current,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Cycle.cljs$lang$type = true;

cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle";

cljs.core.Cycle.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Cycle");
});

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5733__auto__ = cljs.core.seq(coll);
if(temp__5733__auto__){
var vals = temp__5733__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
cljs.core.Repeat.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Repeat.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Repeat.prototype.indexOf = (function() {
var G__4297 = null;
var G__4297__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4297__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4297 = function(x,start){
switch(arguments.length){
case 1:
return G__4297__1.call(this,x);
case 2:
return G__4297__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4297.cljs$core$IFn$_invoke$arity$1 = G__4297__1;
G__4297.cljs$core$IFn$_invoke$arity$2 = G__4297__2;
return G__4297;
})()
;

cljs.core.Repeat.prototype.lastIndexOf = (function() {
var G__4298 = null;
var G__4298__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__4298__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4298 = function(x,start){
switch(arguments.length){
case 1:
return G__4298__1.call(this,x);
case 2:
return G__4298__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4298.cljs$core$IFn$_invoke$arity$1 = G__4298__1;
G__4298.cljs$core$IFn$_invoke$arity$2 = G__4298__2;
return G__4298;
})()
;

cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
});

cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return false;
});

cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__4299 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__4299;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4300 = (i + (1));
var G__4301 = ret__$1;
i = G__4300;
ret = G__4301;
continue;
}
} else {
return ret;
}
break;
}
}
});

cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__4302 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__4302;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4303 = (i + (1));
var G__4304 = ret__$1;
i = G__4303;
ret = G__4304;
continue;
}
} else {
return ret;
}
break;
}
}
});

cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
});

cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
});

cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
});

cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.Repeat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$val,cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Repeat.cljs$lang$type = true;

cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat";

cljs.core.Repeat.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Repeat");
});

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__4306 = arguments.length;
switch (G__4306) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__4309 = arguments.length;
switch (G__4309) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
cljs.core.Iterate.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
});

cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
});

cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__4311 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__4312 = v__$2;
ret = G__4311;
v__$1 = G__4312;
continue;
}
break;
}
});

cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__4313 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__4314 = v__$2;
ret = G__4313;
v__$1 = G__4314;
continue;
}
break;
}
});

cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed));
} else {
}

return self__.seed;
});

cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null));
} else {
}

return self__.next;
});

cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
});

cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.Iterate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$f,cljs.core.cst$sym$prev_DASH_seed,cljs.core.with_meta(cljs.core.cst$sym$seed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Iterate.cljs$lang$type = true;

cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate";

cljs.core.Iterate.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Iterate");
});

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__4319 = arguments.length;
switch (G__4319) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4321 = arguments.length;
var i__4731__auto___4322 = (0);
while(true){
if((i__4731__auto___4322 < len__4730__auto___4321)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4322]));

var G__4323 = (i__4731__auto___4322 + (1));
i__4731__auto___4322 = G__4323;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

/** @this {Function} */
cljs.core.interleave.cljs$lang$applyTo = (function (seq4316){
var G__4317 = cljs.core.first(seq4316);
var seq4316__$1 = cljs.core.next(seq4316);
var G__4318 = cljs.core.first(seq4316__$1);
var seq4316__$2 = cljs.core.next(seq4316__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4317,G__4318,seq4316__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__4325 = arguments.length;
switch (G__4325) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__4327 = null;
var G__4327__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4327__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4327__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__4327 = function(result,input){
switch(arguments.length){
case 0:
return G__4327__0.call(this);
case 1:
return G__4327__1.call(this,result);
case 2:
return G__4327__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4327.cljs$core$IFn$_invoke$arity$0 = G__4327__0;
G__4327.cljs$core$IFn$_invoke$arity$1 = G__4327__1;
G__4327.cljs$core$IFn$_invoke$arity$2 = G__4327__2;
return G__4327;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5733__auto__ = cljs.core.seq(coll);
if(temp__5733__auto__){
var coll__$1 = temp__5733__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__4331 = arguments.length;
switch (G__4331) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4333 = arguments.length;
var i__4731__auto___4334 = (0);
while(true){
if((i__4731__auto___4334 < len__4730__auto___4333)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4334]));

var G__4335 = (i__4731__auto___4334 + (1));
i__4731__auto___4334 = G__4335;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4752__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

/** @this {Function} */
cljs.core.mapcat.cljs$lang$applyTo = (function (seq4329){
var G__4330 = cljs.core.first(seq4329);
var seq4329__$1 = cljs.core.next(seq4329);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4330,seq4329__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__4337 = arguments.length;
switch (G__4337) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__4340 = null;
var G__4340__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4340__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4340__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__4340 = function(result,input){
switch(arguments.length){
case 0:
return G__4340__0.call(this);
case 1:
return G__4340__1.call(this,result);
case 2:
return G__4340__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4340.cljs$core$IFn$_invoke$arity$0 = G__4340__0;
G__4340.cljs$core$IFn$_invoke$arity$1 = G__4340__1;
G__4340.cljs$core$IFn$_invoke$arity$2 = G__4340__2;
return G__4340;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4607__auto___4341 = size;
var i_4342 = (0);
while(true){
if((i_4342 < n__4607__auto___4341)){
if(cljs.core.truth_((function (){var G__4338 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4342);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__4338) : pred.call(null,G__4338));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4342));
} else {
}

var G__4343 = (i_4342 + (1));
i_4342 = G__4343;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__4345 = arguments.length;
switch (G__4345) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__4347_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__4347_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__4349 = arguments.length;
switch (G__4349) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__4359 = arguments.length;
switch (G__4359) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4361 = arguments.length;
var i__4731__auto___4362 = (0);
while(true){
if((i__4731__auto___4362 < len__4730__auto___4361)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4362]));

var G__4363 = (i__4731__auto___4362 + (1));
i__4731__auto___4362 = G__4363;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
});

/** @this {Function} */
cljs.core.mapv.cljs$lang$applyTo = (function (seq4354){
var G__4355 = cljs.core.first(seq4354);
var seq4354__$1 = cljs.core.next(seq4354);
var G__4356 = cljs.core.first(seq4354__$1);
var seq4354__$2 = cljs.core.next(seq4354__$1);
var G__4357 = cljs.core.first(seq4354__$2);
var seq4354__$3 = cljs.core.next(seq4354__$2);
var G__4358 = cljs.core.first(seq4354__$3);
var seq4354__$4 = cljs.core.next(seq4354__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4355,G__4356,G__4357,G__4358,seq4354__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__4365 = arguments.length;
switch (G__4365) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__4368 = arguments.length;
switch (G__4368) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__4370 = sentinel;
var G__4371 = m__$2;
var G__4372 = cljs.core.next(ks__$1);
sentinel = G__4370;
m__$1 = G__4371;
ks__$1 = G__4372;
continue;
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__4373,v){
var vec__4374 = p__4373;
var seq__4375 = cljs.core.seq(vec__4374);
var first__4376 = cljs.core.first(seq__4375);
var seq__4375__$1 = cljs.core.next(seq__4375);
var k = first__4376;
var ks = seq__4375__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4378 = ks;
var G__4379 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__4377,G__4378,G__4379) : cljs.core.assoc_in.call(null,G__4377,G__4378,G__4379));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__4388 = arguments.length;
switch (G__4388) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4420 = arguments.length;
var i__4731__auto___4421 = (0);
while(true){
if((i__4731__auto___4421 < len__4730__auto___4420)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4421]));

var G__4422 = (i__4731__auto___4421 + (1));
i__4731__auto___4421 = G__4422;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4752__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__4389,f){
var vec__4390 = p__4389;
var seq__4391 = cljs.core.seq(vec__4390);
var first__4392 = cljs.core.first(seq__4391);
var seq__4391__$1 = cljs.core.next(seq__4391);
var k = first__4392;
var ks = seq__4391__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4393) : f.call(null,G__4393));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__4394,f,a){
var vec__4395 = p__4394;
var seq__4396 = cljs.core.seq(vec__4395);
var first__4397 = cljs.core.first(seq__4396);
var seq__4396__$1 = cljs.core.next(seq__4396);
var k = first__4397;
var ks = seq__4396__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4398 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4399 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4398,G__4399) : f.call(null,G__4398,G__4399));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__4400,f,a,b){
var vec__4401 = p__4400;
var seq__4402 = cljs.core.seq(vec__4401);
var first__4403 = cljs.core.first(seq__4402);
var seq__4402__$1 = cljs.core.next(seq__4402);
var k = first__4403;
var ks = seq__4402__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4405 = a;
var G__4406 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4404,G__4405,G__4406) : f.call(null,G__4404,G__4405,G__4406));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__4407,f,a,b,c){
var vec__4408 = p__4407;
var seq__4409 = cljs.core.seq(vec__4408);
var first__4410 = cljs.core.first(seq__4409);
var seq__4409__$1 = cljs.core.next(seq__4409);
var k = first__4410;
var ks = seq__4409__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4412 = a;
var G__4413 = b;
var G__4414 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__4411,G__4412,G__4413,G__4414) : f.call(null,G__4411,G__4412,G__4413,G__4414));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__4415,f,a,b,c,args){
var vec__4416 = p__4415;
var seq__4417 = cljs.core.seq(vec__4416);
var first__4418 = cljs.core.first(seq__4417);
var seq__4417__$1 = cljs.core.next(seq__4417);
var k = first__4418;
var ks = seq__4417__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
});

/** @this {Function} */
cljs.core.update_in.cljs$lang$applyTo = (function (seq4381){
var G__4382 = cljs.core.first(seq4381);
var seq4381__$1 = cljs.core.next(seq4381);
var G__4383 = cljs.core.first(seq4381__$1);
var seq4381__$2 = cljs.core.next(seq4381__$1);
var G__4384 = cljs.core.first(seq4381__$2);
var seq4381__$3 = cljs.core.next(seq4381__$2);
var G__4385 = cljs.core.first(seq4381__$3);
var seq4381__$4 = cljs.core.next(seq4381__$3);
var G__4386 = cljs.core.first(seq4381__$4);
var seq4381__$5 = cljs.core.next(seq4381__$4);
var G__4387 = cljs.core.first(seq4381__$5);
var seq4381__$6 = cljs.core.next(seq4381__$5);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4382,G__4383,G__4384,G__4385,G__4386,G__4387,seq4381__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__4431 = arguments.length;
switch (G__4431) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___4443 = arguments.length;
var i__4731__auto___4444 = (0);
while(true){
if((i__4731__auto___4444 < len__4730__auto___4443)){
args_arr__4751__auto__.push((arguments[i__4731__auto___4444]));

var G__4445 = (i__4731__auto___4444 + (1));
i__4731__auto___4444 = G__4445;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4752__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4432) : f.call(null,G__4432));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4433 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4434 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4433,G__4434) : f.call(null,G__4433,G__4434));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4435 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4436 = x;
var G__4437 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4435,G__4436,G__4437) : f.call(null,G__4435,G__4436,G__4437));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4439 = x;
var G__4440 = y;
var G__4441 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__4438,G__4439,G__4440,G__4441) : f.call(null,G__4438,G__4439,G__4440,G__4441));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
});

/** @this {Function} */
cljs.core.update.cljs$lang$applyTo = (function (seq4424){
var G__4425 = cljs.core.first(seq4424);
var seq4424__$1 = cljs.core.next(seq4424);
var G__4426 = cljs.core.first(seq4424__$1);
var seq4424__$2 = cljs.core.next(seq4424__$1);
var G__4427 = cljs.core.first(seq4424__$2);
var seq4424__$3 = cljs.core.next(seq4424__$2);
var G__4428 = cljs.core.first(seq4424__$3);
var seq4424__$4 = cljs.core.next(seq4424__$3);
var G__4429 = cljs.core.first(seq4424__$4);
var seq4424__$5 = cljs.core.next(seq4424__$4);
var G__4430 = cljs.core.first(seq4424__$5);
var seq4424__$6 = cljs.core.next(seq4424__$5);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4425,G__4426,G__4427,G__4428,G__4429,G__4430,seq4424__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/VectorNode");
});

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__4446 = (ll - (5));
var G__4447 = r;
ll = G__4446;
ret = G__4447;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__4448 = pv;
var G__4449 = (level - (5));
var G__4450 = child;
var G__4451 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__4448,G__4449,G__4450,G__4451) : cljs.core.push_tail.call(null,G__4448,G__4449,G__4450,G__4451));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__4452 = cljs.core.pv_aget(node,(0));
var G__4453 = (level - (5));
node = G__4452;
level = G__4453;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__4454 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__4455 = (level - (5));
node = G__4454;
level = G__4455;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__4456 = pv;
var G__4457 = (level - (5));
var G__4458 = cljs.core.pv_aget(node,subidx);
var G__4459 = i;
var G__4460 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__4456,G__4457,G__4458,G__4459,G__4460) : cljs.core.do_assoc.call(null,G__4456,G__4457,G__4458,G__4459,G__4460));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__4461 = pv;
var G__4462 = (level - (5));
var G__4463 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__4461,G__4462,G__4463) : cljs.core.pop_tail.call(null,G__4461,G__4462,G__4463));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/RangedIterator");
});

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__4465 = arguments.length;
switch (G__4465) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function (pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function (pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__4466 = acc;
var G__4467 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4466,G__4467) : f.call(null,G__4466,G__4467));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__4469 = nacc;
var G__4470 = (i + (1));
var G__4471 = arr__$1;
acc = G__4469;
i = G__4470;
arr = G__4471;
continue;
}
} else {
return acc;
}
break;
}
});

cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5;








/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__4478 = null;
var G__4478__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4478__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4478 = function(x,start){
switch(arguments.length){
case 1:
return G__4478__1.call(this,x);
case 2:
return G__4478__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4478.cljs$core$IFn$_invoke$arity$1 = G__4478__1;
G__4478.cljs$core$IFn$_invoke$arity$2 = G__4478__2;
return G__4478;
})()
;

cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__4479 = null;
var G__4479__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4479__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4479 = function(x,start){
switch(arguments.length){
case 1:
return G__4479__1.call(this,x);
case 2:
return G__4479__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4479.cljs$core$IFn$_invoke$arity$1 = G__4479__1;
G__4479.cljs$core$IFn$_invoke$arity$2 = G__4479__2;
return G__4479;
})()
;

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__4473 = init__$2;
var G__4474 = (j + i);
var G__4475 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4473,G__4474,G__4475) : f.call(null,G__4473,G__4474,G__4475));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__4480 = (j + (1));
var G__4481 = init__$3;
j = G__4480;
init__$2 = G__4481;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4482 = (i + len);
var G__4483 = init__$2;
i = G__4482;
init__$1 = G__4483;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__4476 = init__$2;
var G__4477 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4476,G__4477) : f.call(null,G__4476,G__4477));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__4484 = (j + (1));
var G__4485 = init__$3;
j = G__4484;
init__$2 = G__4485;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4486 = (i + len);
var G__4487 = init__$2;
i = G__4486;
init__$1 = G__4487;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4607__auto___4488 = len;
var i_4489 = (0);
while(true){
if((i_4489 < n__4607__auto___4488)){
(new_tail[i_4489] = (self__.tail[i_4489]));

var G__4490 = (i_4489 + (1));
i_4489 = G__4490;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__4491 = null;
var G__4491__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4491__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4491 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4491__2.call(this,self__,k);
case 3:
return G__4491__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4491.cljs$core$IFn$_invoke$arity$2 = G__4491__2;
G__4491.cljs$core$IFn$_invoke$arity$3 = G__4491__3;
return G__4491;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args4472){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4472)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentVector");
});

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__4492 = (i + (1));
var G__4493 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__4492;
out = G__4493;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
var G__4494_4497 = cljs.core.PersistentVector.prototype;
var G__4495_4498 = cljs.core.ITER_SYMBOL;
var G__4496_4499 = ((function (G__4494_4497,G__4495_4498){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4494_4497,G__4495_4498))
;
goog.object.set(G__4494_4497,G__4495_4498,G__4496_4499);
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4501 = arguments.length;
var i__4731__auto___4502 = (0);
while(true){
if((i__4731__auto___4502 < len__4730__auto___4501)){
args__4736__auto__.push((arguments[i__4731__auto___4502]));

var G__4503 = (i__4731__auto___4502 + (1));
i__4731__auto___4502 = G__4503;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.vector.cljs$lang$applyTo = (function (seq4500){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4500));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__4504 = null;
var G__4504__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4504__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4504 = function(x,start){
switch(arguments.length){
case 1:
return G__4504__1.call(this,x);
case 2:
return G__4504__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4504.cljs$core$IFn$_invoke$arity$1 = G__4504__1;
G__4504.cljs$core$IFn$_invoke$arity$2 = G__4504__2;
return G__4504;
})()
;

cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__4505 = null;
var G__4505__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4505__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4505 = function(x,start){
switch(arguments.length){
case 1:
return G__4505__1.call(this,x);
case 2:
return G__4505__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4505.cljs$core$IFn$_invoke$arity$1 = G__4505__1;
G__4505.cljs$core$IFn$_invoke$arity$2 = G__4505__2;
return G__4505;
})()
;

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ChunkedSeq");
});

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

var G__4506_4509 = cljs.core.ChunkedSeq.prototype;
var G__4507_4510 = cljs.core.ITER_SYMBOL;
var G__4508_4511 = ((function (G__4506_4509,G__4507_4510){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4506_4509,G__4507_4510))
;
goog.object.set(G__4506_4509,G__4507_4510,G__4508_4511);
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__4513 = arguments.length;
switch (G__4513) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
});

cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.indexOf = (function() {
var G__4522 = null;
var G__4522__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4522__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__4522 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__4522__1.call(this,x);
case 2:
return G__4522__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4522.cljs$core$IFn$_invoke$arity$1 = G__4522__1;
G__4522.cljs$core$IFn$_invoke$arity$2 = G__4522__2;
return G__4522;
})()
;

cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__4523 = null;
var G__4523__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4523__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__4523 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__4523__1.call(this,x);
case 2:
return G__4523__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4523.cljs$core$IFn$_invoke$arity$1 = G__4523__1;
G__4523.cljs$core$IFn$_invoke$arity$2 = G__4523__2;
return G__4523;
})()
;

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__4516 = init__$1;
var G__4517 = j;
var G__4518 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4516,G__4517,G__4518) : f.call(null,G__4516,G__4517,G__4518));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4524 = (i + (1));
var G__4525 = (j + (1));
var G__4526 = init__$2;
i = G__4524;
j = G__4525;
init__$1 = G__4526;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__4219__auto__ = self__.end;
var y__4220__auto__ = (v_pos + (1));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})(),null);
}
});

cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
});

cljs.core.Subvec.prototype.call = (function() {
var G__4527 = null;
var G__4527__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4527__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4527 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4527__2.call(this,self__,k);
case 3:
return G__4527__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4527.cljs$core$IFn$_invoke$arity$2 = G__4527__2;
G__4527.cljs$core$IFn$_invoke$arity$3 = G__4527__3;
return G__4527;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args4515){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4515)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Subvec");
});

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

var G__4528_4531 = cljs.core.Subvec.prototype;
var G__4529_4532 = cljs.core.ITER_SYMBOL;
var G__4530_4533 = ((function (G__4528_4531,G__4529_4532){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4528_4531,G__4529_4532))
;
goog.object.set(G__4528_4531,G__4529_4532,G__4530_4533);
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__4534 = meta;
var G__4535 = v.v;
var G__4536 = (v.start + start);
var G__4537 = (v.start + end);
var G__4538 = __hash;
meta = G__4534;
v = G__4535;
start = G__4536;
end = G__4537;
__hash = G__4538;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

var c_4539 = cljs.core.count(v);
if((((start < (0))) || ((end < (0))) || ((start > c_4539)) || ((end > c_4539)))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__4541 = arguments.length;
switch (G__4541) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__4545 = tv;
var G__4546 = (level - (5));
var G__4547 = child;
var G__4548 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__4545,G__4546,G__4547,G__4548) : cljs.core.tv_push_tail.call(null,G__4545,G__4546,G__4547,G__4548));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__4549 = tv;
var G__4550 = (level - (5));
var G__4551 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__4549,G__4550,G__4551) : cljs.core.tv_pop_tail.call(null,G__4549,G__4550,G__4551));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__4552 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__4553 = (level - (5));
node = G__4552;
level = G__4553;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__4555 = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
;
return fexpr__4555(self__.shift,self__.root);
})();
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__4556 = null;
var G__4556__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4556__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4556 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4556__2.call(this,self__,k);
case 3:
return G__4556__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4556.cljs$core$IFn$_invoke$arity$2 = G__4556__2;
G__4556.cljs$core$IFn$_invoke$arity$3 = G__4556__3;
return G__4556;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args4554){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4554)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/TransientVector");
});

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__4131__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = (!((self__.riter == null)));
if(and__4120__auto__){
return self__.riter.hasNext();
} else {
return and__4120__auto__;
}
}
});

cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
self__.fseq = cljs.core.next(self__.fseq);

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
});

cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null);
});

cljs.core.PersistentQueueIter.cljs$lang$type = true;

cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";

cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentQueueIter");
});

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__4557 = null;
var G__4557__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4557__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4557 = function(x,start){
switch(arguments.length){
case 1:
return G__4557__1.call(this,x);
case 2:
return G__4557__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4557.cljs$core$IFn$_invoke$arity$1 = G__4557__1;
G__4557.cljs$core$IFn$_invoke$arity$2 = G__4557__2;
return G__4557;
})()
;

cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__4558 = null;
var G__4558__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4558__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4558 = function(x,start){
switch(arguments.length){
case 1:
return G__4558__1.call(this,x);
case 2:
return G__4558__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4558.cljs$core$IFn$_invoke$arity$1 = G__4558__1;
G__4558.cljs$core$IFn$_invoke$arity$2 = G__4558__2;
return G__4558;
})()
;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5733__auto__ = cljs.core.next(self__.front);
if(temp__5733__auto__){
var f1 = temp__5733__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5733__auto__ = cljs.core.next(self__.front);
if(temp__5733__auto__){
var f1 = temp__5733__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentQueueSeq");
});

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

var G__4559_4562 = cljs.core.PersistentQueueSeq.prototype;
var G__4560_4563 = cljs.core.ITER_SYMBOL;
var G__4561_4564 = ((function (G__4559_4562,G__4560_4563){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4559_4562,G__4560_4563))
;
goog.object.set(G__4559_4562,G__4560_4563,G__4561_4564);

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__4565 = null;
var G__4565__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4565__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4565 = function(x,start){
switch(arguments.length){
case 1:
return G__4565__1.call(this,x);
case 2:
return G__4565__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4565.cljs$core$IFn$_invoke$arity$1 = G__4565__1;
G__4565.cljs$core$IFn$_invoke$arity$2 = G__4565__2;
return G__4565;
})()
;

cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__4566 = null;
var G__4566__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var G__4566__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4566 = function(x,start){
switch(arguments.length){
case 1:
return G__4566__1.call(this,x);
case 2:
return G__4566__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4566.cljs$core$IFn$_invoke$arity$1 = G__4566__1;
G__4566.cljs$core$IFn$_invoke$arity$2 = G__4566__2;
return G__4566;
})()
;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5733__auto__ = cljs.core.next(self__.front);
if(temp__5733__auto__){
var f1 = temp__5733__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__4131__auto__ = self__.front;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = self__.rear;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentQueue");
});

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
var G__4567_4570 = cljs.core.PersistentQueue.prototype;
var G__4568_4571 = cljs.core.ITER_SYMBOL;
var G__4569_4572 = ((function (G__4567_4570,G__4568_4571){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4567_4570,G__4568_4571))
;
goog.object.set(G__4567_4570,G__4568_4571,G__4569_4572);

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/NeverEquiv");
});

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function (_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__4574 = (i + incr);
i = G__4574;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__4575 = (i + (1));
var G__4576 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,goog.object.get(so,k__$1));
i = G__4575;
out = G__4576;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_4582 = (0);
while(true){
if((i_4582 < l)){
var k_4583 = (ks[i_4582]);
var G__4579_4584 = new_obj;
var G__4580_4585 = k_4583;
var G__4581_4586 = goog.object.get(obj,k_4583);
goog.object.set(G__4579_4584,G__4580_4585,G__4581_4586);

var G__4587 = (i_4582 + (1));
i_4582 = G__4587;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__4590 = init__$1;
var G__4591 = k;
var G__4592 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4590,G__4591,G__4592) : f.call(null,G__4590,G__4591,G__4592));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4593 = cljs.core.rest(keys__$1);
var G__4594 = init__$2;
keys__$1 = G__4593;
init__$1 = G__4594;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
goog.object.set(new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
goog.object.set(new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__4588_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__4588_SHARP_,(self__.strobj[p1__4588_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__4595 = null;
var G__4595__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4595__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4595 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4595__2.call(this,self__,k);
case 3:
return G__4595__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4595.cljs$core$IFn$_invoke$arity$2 = G__4595__2;
G__4595.cljs$core$IFn$_invoke$arity$3 = G__4595__3;
return G__4595;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args4589){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4589)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ObjMap");
});

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__4131__auto__ = (self__.i < self__.base_count);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
});

cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
self__.i = (self__.i + (1));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
});

cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null);
});

cljs.core.RecordIter.cljs$lang$type = true;

cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";

cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/RecordIter");
});

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__4598 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4598,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4598,(1),null);
self__.s = cljs.core.next(self__.s);

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ES6EntriesIterator");
});

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ES6SetEntriesIterator");
});

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__4601 = (i + (2));
i = G__4601;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__4602 = (i + (2));
i = G__4602;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__4603 = (i + (2));
i = G__4603;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__4604 = (i + (2));
i = G__4604;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__4605 = (i + (2));
i = G__4605;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((goog.isString(k)) || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_4606 = (0);
while(true){
if((i_4606 < l)){
(narr[i_4606] = (arr[i_4606]));

var G__4607 = (i_4606 + (1));
i_4606 = G__4607;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__4609 = k;
switch (G__4609) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
});

cljs.core.MapEntry.prototype.indexOf = (function() {
var G__4611 = null;
var G__4611__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4611__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4611 = function(x,start){
switch(arguments.length){
case 1:
return G__4611__1.call(this,x);
case 2:
return G__4611__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4611.cljs$core$IFn$_invoke$arity$1 = G__4611__1;
G__4611.cljs$core$IFn$_invoke$arity$2 = G__4611__2;
return G__4611;
})()
;

cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var G__4612 = null;
var G__4612__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4612__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4612 = function(x,start){
switch(arguments.length){
case 1:
return G__4612__1.call(this,x);
case 2:
return G__4612__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4612.cljs$core$IFn$_invoke$arity$1 = G__4612__1;
G__4612.cljs$core$IFn$_invoke$arity$2 = G__4612__2;
return G__4612;
})()
;

cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
});

cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
});

cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
});

cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
});

cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
});

cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.MapEntry.prototype.call = (function() {
var G__4613 = null;
var G__4613__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4613__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4613 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4613__2.call(this,self__,k);
case 3:
return G__4613__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4613.cljs$core$IFn$_invoke$arity$2 = G__4613__2;
G__4613.cljs$core$IFn$_invoke$arity$3 = G__4613__3;
return G__4613;
})()
;

cljs.core.MapEntry.prototype.apply = (function (self__,args4608){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4608)));
});

cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.MapEntry.cljs$lang$type = true;

cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry";

cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/MapEntry");
});

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__4615 = null;
var G__4615__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4615__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4615 = function(x,start){
switch(arguments.length){
case 1:
return G__4615__1.call(this,x);
case 2:
return G__4615__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4615.cljs$core$IFn$_invoke$arity$1 = G__4615__1;
G__4615.cljs$core$IFn$_invoke$arity$2 = G__4615__2;
return G__4615;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__4616 = null;
var G__4616__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4616__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4616 = function(x,start){
switch(arguments.length){
case 1:
return G__4616__1.call(this,x);
case 2:
return G__4616__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4616.cljs$core$IFn$_invoke$arity$1 = G__4616__1;
G__4616.cljs$core$IFn$_invoke$arity$2 = G__4616__2;
return G__4616;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentArrayMapSeq");
});

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

var G__4617_4620 = cljs.core.PersistentArrayMapSeq.prototype;
var G__4618_4621 = cljs.core.ITER_SYMBOL;
var G__4619_4622 = ((function (G__4617_4620,G__4618_4621){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4617_4620,G__4618_4621))
;
goog.object.set(G__4617_4620,G__4618_4621,G__4619_4622);
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentArrayMapIterator");
});

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
});

cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__4624 = cljs.core.seq(coll);
var chunk__4625 = null;
var count__4626 = (0);
var i__4627 = (0);
while(true){
if((i__4627 < count__4626)){
var vec__4634 = chunk__4625.cljs$core$IIndexed$_nth$arity$2(null,i__4627);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4634,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4634,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4646 = seq__4624;
var G__4647 = chunk__4625;
var G__4648 = count__4626;
var G__4649 = (i__4627 + (1));
seq__4624 = G__4646;
chunk__4625 = G__4647;
count__4626 = G__4648;
i__4627 = G__4649;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__4624);
if(temp__5735__auto__){
var seq__4624__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4624__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__4624__$1);
var G__4650 = cljs.core.chunk_rest(seq__4624__$1);
var G__4651 = c__4550__auto__;
var G__4652 = cljs.core.count(c__4550__auto__);
var G__4653 = (0);
seq__4624 = G__4650;
chunk__4625 = G__4651;
count__4626 = G__4652;
i__4627 = G__4653;
continue;
} else {
var vec__4637 = cljs.core.first(seq__4624__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4637,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4637,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4654 = cljs.core.next(seq__4624__$1);
var G__4655 = null;
var G__4656 = (0);
var G__4657 = (0);
seq__4624 = G__4654;
chunk__4625 = G__4655;
count__4626 = G__4656;
i__4627 = G__4657;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__4640 = init__$1;
var G__4641 = (self__.arr[i]);
var G__4642 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4640,G__4641,G__4642) : f.call(null,G__4640,G__4641,G__4642));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4658 = (i + (2));
var G__4659 = init__$2;
i = G__4658;
init__$1 = G__4659;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__4660 = (i + (2));
i = G__4660;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__4661 = (s + (2));
var G__4662 = d;
s = G__4661;
d = G__4662;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__4663 = (s + (2));
var G__4664 = (d + (2));
s = G__4663;
d = G__4664;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__4645 = cljs.core.aclone(self__.arr);
(G__4645[(idx + (1))] = v);

return G__4645;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__4665 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__4666 = cljs.core.next(es);
ret = G__4665;
es = G__4666;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__4667 = null;
var G__4667__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4667__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4667 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4667__2.call(this,self__,k);
case 3:
return G__4667__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4667.cljs$core$IFn$_invoke$arity$2 = G__4667__2;
G__4667.cljs$core$IFn$_invoke$arity$3 = G__4667__3;
return G__4667;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args4623){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4623)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentArrayMap");
});

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_4668 = (0);
while(true){
if((i_4668 < arr__$1.length)){
var k_4669 = (arr__$1[i_4668]);
var v_4670 = (arr__$1[(i_4668 + (1))]);
var idx_4671 = cljs.core.array_index_of(ret,k_4669);
if((idx_4671 === (-1))){
ret.push(k_4669);

ret.push(v_4670);
} else {
}

var G__4672 = (i_4668 + (2));
i_4668 = G__4672;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
});
cljs.core.PersistentArrayMap.createWithCheck = (function (arr){
var ret = [];
var i_4674 = (0);
while(true){
if((i_4674 < arr.length)){
var k_4675 = (arr[i_4674]);
var v_4676 = (arr[(i_4674 + (1))]);
var idx_4677 = cljs.core.array_index_of(ret,k_4675);
if((idx_4677 === (-1))){
var G__4673_4678 = ret;
G__4673_4678.push(k_4675);

G__4673_4678.push(v_4676);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_4675)].join('')));
}

var G__4679 = (i_4674 + (2));
i_4674 = G__4679;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
});
cljs.core.PersistentArrayMap.createAsIfByAssoc = (function (arr){
var ret = [];
var i_4681 = (0);
while(true){
if((i_4681 < arr.length)){
var k_4682 = (arr[i_4681]);
var v_4683 = (arr[(i_4681 + (1))]);
var idx_4684 = cljs.core.array_index_of(ret,k_4682);
if((idx_4684 === (-1))){
var G__4680_4685 = ret;
G__4680_4685.push(k_4682);

G__4680_4685.push(v_4683);

} else {
(ret[(idx_4684 + (1))] = v_4683);
}

var G__4686 = (i_4681 + (2));
i_4681 = G__4686;
continue;
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(ret.length / (2)),ret,null));
});
var G__4687_4690 = cljs.core.PersistentArrayMap.prototype;
var G__4688_4691 = cljs.core.ITER_SYMBOL;
var G__4689_4692 = ((function (G__4687_4690,G__4688_4691){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4687_4690,G__4688_4691))
;
goog.object.set(G__4687_4690,G__4688_4691,G__4689_4692);

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5733__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
var G__4695 = cljs.core.next(es);
var G__4696 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__4695;
tcoll__$2 = G__4696;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__4694_4697 = self__.arr;
G__4694_4697.pop();

G__4694_4697.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.call = (function() {
var G__4698 = null;
var G__4698__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var G__4698__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
G__4698 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return G__4698__2.call(this,self__,key);
case 3:
return G__4698__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4698.cljs$core$IFn$_invoke$arity$2 = G__4698__2;
G__4698.cljs$core$IFn$_invoke$arity$3 = G__4698__3;
return G__4698;
})()
;

cljs.core.TransientArrayMap.prototype.apply = (function (self__,args4693){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4693)));
});

cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/TransientArrayMap");
});

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__4699 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__4700 = (i + (2));
out = G__4699;
i = G__4700;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/Box");
});

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__4702 = arguments.length;
switch (G__4702) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__4703 = cljs.core.aclone(arr);
(G__4703[i] = a);

return G__4703;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__4704 = cljs.core.aclone(arr);
(G__4704[i] = a);

(G__4704[j] = b);

return G__4704;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__4707 = arguments.length;
switch (G__4707) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__4709 = init__$1;
var G__4710 = k;
var G__4711 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4709,G__4710,G__4711) : f.call(null,G__4709,G__4710,G__4711));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__4712 = (i + (2));
var G__4713 = init__$2;
i = G__4712;
init__$1 = G__4713;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null)):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return self__.next_iter = new_iter;
} else {
return false;
}
})():false
));
self__.i = (self__.i + (2));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
});

cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__4131__auto__ = (!((self__.next_entry == null)));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (!((self__.next_iter == null)));
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
return this$.advance();
}
}
});

cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
self__.next_entry = null;

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
self__.next_iter = null;
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
});

cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeIterator.cljs$lang$type = true;

cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";

cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/NodeIterator");
});

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
removed_leaf_QMARK_.val = true;

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_4714 = (0);
var j_4715 = (0);
while(true){
if((i_4714 < (32))){
if((((self__.bitmap >>> i_4714) & (1)) === (0))){
var G__4716 = (i_4714 + (1));
var G__4717 = j_4715;
i_4714 = G__4716;
j_4715 = G__4717;
continue;
} else {
(nodes[i_4714] = (((!(((self__.arr[j_4715]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_4715])),(self__.arr[j_4715]),(self__.arr[(j_4715 + (1))]),added_leaf_QMARK_):(self__.arr[(j_4715 + (1))])));

var G__4718 = (i_4714 + (1));
var G__4719 = (j_4715 + (2));
i_4714 = G__4718;
j_4715 = G__4719;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_4720 = (0);
var j_4721 = (0);
while(true){
if((i_4720 < (32))){
if((((self__.bitmap >>> i_4720) & (1)) === (0))){
var G__4722 = (i_4720 + (1));
var G__4723 = j_4721;
i_4720 = G__4722;
j_4721 = G__4723;
continue;
} else {
(nodes[i_4720] = (((!(((self__.arr[j_4721]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_4721])),(self__.arr[j_4721]),(self__.arr[(j_4721 + (1))]),added_leaf_QMARK_):(self__.arr[(j_4721 + (1))])));

var G__4724 = (i_4720 + (1));
var G__4725 = (j_4721 + (2));
i_4720 = G__4724;
j_4721 = G__4725;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/BitmapIndexedNode");
});

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__4726 = (i + (1));
var G__4727 = (j + (2));
var G__4728 = (bitmap | ((1) << i));
i = G__4726;
j = G__4727;
bitmap = G__4728;
continue;
} else {
var G__4729 = (i + (1));
var G__4730 = j;
var G__4731 = bitmap;
i = G__4729;
j = G__4730;
bitmap = G__4731;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

if((!((node == null)))){
self__.next_iter = cljs.core._iterator(node);
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});

cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
});

cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeIterator.cljs$lang$type = true;

cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";

cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ArrayNodeIterator");
});

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__4732 = (i + (1));
var G__4733 = init__$2;
i = G__4732;
init__$1 = G__4733;
continue;
}
} else {
var G__4734 = (i + (1));
var G__4735 = init__$1;
i = G__4734;
init__$1 = G__4735;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ArrayNode");
});

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__4736 = (i + (2));
i = G__4736;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
removed_leaf_QMARK_.val = true;

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/HashCollisionNode");
});

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__4738 = arguments.length;
switch (G__4738) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__4740 = null;
var G__4740__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4740__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4740 = function(x,start){
switch(arguments.length){
case 1:
return G__4740__1.call(this,x);
case 2:
return G__4740__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4740.cljs$core$IFn$_invoke$arity$1 = G__4740__1;
G__4740.cljs$core$IFn$_invoke$arity$2 = G__4740__2;
return G__4740;
})()
;

cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__4741 = null;
var G__4741__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4741__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4741 = function(x,start){
switch(arguments.length){
case 1:
return G__4741__1.call(this,x);
case 2:
return G__4741__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4741.cljs$core$IFn$_invoke$arity$1 = G__4741__1;
G__4741.cljs$core$IFn$_invoke$arity$2 = G__4741__2;
return G__4741;
})()
;

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/NodeSeq");
});

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

var G__4742_4745 = cljs.core.NodeSeq.prototype;
var G__4743_4746 = cljs.core.ITER_SYMBOL;
var G__4744_4747 = ((function (G__4742_4745,G__4743_4746){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4742_4745,G__4743_4746))
;
goog.object.set(G__4742_4745,G__4743_4746,G__4744_4747);
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__4749 = arguments.length;
switch (G__4749) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5733__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5733__auto__)){
var node = temp__5733__auto__;
var temp__5733__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5733__auto____$1)){
var node_seq = temp__5733__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__4751 = (j + (2));
j = G__4751;
continue;
}
} else {
var G__4752 = (j + (2));
j = G__4752;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__4753 = null;
var G__4753__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4753__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4753 = function(x,start){
switch(arguments.length){
case 1:
return G__4753__1.call(this,x);
case 2:
return G__4753__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4753.cljs$core$IFn$_invoke$arity$1 = G__4753__1;
G__4753.cljs$core$IFn$_invoke$arity$2 = G__4753__2;
return G__4753;
})()
;

cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__4754 = null;
var G__4754__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4754__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4754 = function(x,start){
switch(arguments.length){
case 1:
return G__4754__1.call(this,x);
case 2:
return G__4754__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4754.cljs$core$IFn$_invoke$arity$1 = G__4754__1;
G__4754.cljs$core$IFn$_invoke$arity$2 = G__4754__2;
return G__4754;
})()
;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ArrayNodeSeq");
});

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

var G__4755_4758 = cljs.core.ArrayNodeSeq.prototype;
var G__4756_4759 = cljs.core.ITER_SYMBOL;
var G__4757_4760 = ((function (G__4755_4758,G__4756_4759){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4755_4758,G__4756_4759))
;
goog.object.set(G__4755_4758,G__4756_4759,G__4757_4760);
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__4762 = arguments.length;
switch (G__4762) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5733__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5733__auto__)){
var nj = temp__5733__auto__;
var temp__5733__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5733__auto____$1)){
var ns = temp__5733__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__4764 = (j + (1));
j = G__4764;
continue;
}
} else {
var G__4765 = (j + (1));
j = G__4765;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3;


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
});

cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!(self__.seen))){
self__.seen = true;

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
});

cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashMapIter.cljs$lang$type = true;

cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";

cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/HashMapIter");
});

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
});

cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__4767 = cljs.core.seq(coll);
var chunk__4768 = null;
var count__4769 = (0);
var i__4770 = (0);
while(true){
if((i__4770 < count__4769)){
var vec__4777 = chunk__4768.cljs$core$IIndexed$_nth$arity$2(null,i__4770);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4777,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4777,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4785 = seq__4767;
var G__4786 = chunk__4768;
var G__4787 = count__4769;
var G__4788 = (i__4770 + (1));
seq__4767 = G__4785;
chunk__4768 = G__4786;
count__4769 = G__4787;
i__4770 = G__4788;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__4767);
if(temp__5735__auto__){
var seq__4767__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4767__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__4767__$1);
var G__4789 = cljs.core.chunk_rest(seq__4767__$1);
var G__4790 = c__4550__auto__;
var G__4791 = cljs.core.count(c__4550__auto__);
var G__4792 = (0);
seq__4767 = G__4789;
chunk__4768 = G__4790;
count__4769 = G__4791;
i__4770 = G__4792;
continue;
} else {
var vec__4780 = cljs.core.first(seq__4767__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4780,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4780,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4793 = cljs.core.next(seq__4767__$1);
var G__4794 = null;
var G__4795 = (0);
var G__4796 = (0);
seq__4767 = G__4793;
chunk__4768 = G__4794;
count__4769 = G__4795;
i__4770 = G__4796;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__4797 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__4798 = cljs.core.next(es);
ret = G__4797;
es = G__4798;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__4799 = null;
var G__4799__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4799__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4799 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4799__2.call(this,self__,k);
case 3:
return G__4799__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4799.cljs$core$IFn$_invoke$arity$2 = G__4799__2;
G__4799.cljs$core$IFn$_invoke$arity$3 = G__4799__3;
return G__4799;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args4766){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4766)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentHashMap");
});

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__4800 = (i + (2));
var G__4801 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__4800;
ret = G__4801;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__4802 = (i + (1));
var G__4803 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__4802;
out = G__4803;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
cljs.core.PersistentHashMap.createWithCheck = (function (arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_4804 = (0);
while(true){
if((i_4804 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_4804]),(arr[(i_4804 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_4804 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_4804]))].join('')));
} else {
var G__4805 = (i_4804 + (2));
i_4804 = G__4805;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
});
var G__4806_4809 = cljs.core.PersistentHashMap.prototype;
var G__4807_4810 = cljs.core.ITER_SYMBOL;
var G__4808_4811 = ((function (G__4806_4809,G__4807_4810){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4806_4809,G__4807_4810))
;
goog.object.set(G__4806_4809,G__4807_4810,G__4808_4811);

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5733__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
var G__4813 = cljs.core.next(es);
var G__4814 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__4813;
tcoll__$1 = G__4814;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(removed_leaf_QMARK_.val){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.call = (function() {
var G__4815 = null;
var G__4815__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var G__4815__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
G__4815 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return G__4815__2.call(this,self__,key);
case 3:
return G__4815__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4815.cljs$core$IFn$_invoke$arity$2 = G__4815__2;
G__4815.cljs$core$IFn$_invoke$arity$3 = G__4815__3;
return G__4815;
})()
;

cljs.core.TransientHashMap.prototype.apply = (function (self__,args4812){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4812)));
});

cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});

cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/TransientHashMap");
});

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__4816 = ((ascending_QMARK_)?t.left:t.right);
var G__4817 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__4816;
stack__$1 = G__4817;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__4818 = null;
var G__4818__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4818__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4818 = function(x,start){
switch(arguments.length){
case 1:
return G__4818__1.call(this,x);
case 2:
return G__4818__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4818.cljs$core$IFn$_invoke$arity$1 = G__4818__1;
G__4818.cljs$core$IFn$_invoke$arity$2 = G__4818__2;
return G__4818;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__4819 = null;
var G__4819__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4819__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4819 = function(x,start){
switch(arguments.length){
case 1:
return G__4819__1.call(this,x);
case 2:
return G__4819__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4819.cljs$core$IFn$_invoke$arity$1 = G__4819__1;
G__4819.cljs$core$IFn$_invoke$arity$2 = G__4819__2;
return G__4819;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentTreeMapSeq");
});

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

var G__4820_4823 = cljs.core.PersistentTreeMapSeq.prototype;
var G__4821_4824 = cljs.core.ITER_SYMBOL;
var G__4822_4825 = ((function (G__4820_4823,G__4821_4824){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4820_4823,G__4821_4824))
;
goog.object.set(G__4820_4823,G__4821_4824,G__4822_4825);
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__4826 = node.left;
var G__4827 = f;
var G__4828 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__4826,G__4827,G__4828) : cljs.core.tree_map_kv_reduce.call(null,G__4826,G__4827,G__4828));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__4829 = init__$1;
var G__4830 = node.key;
var G__4831 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4829,G__4830,G__4831) : f.call(null,G__4829,G__4830,G__4831));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__4832 = node.right;
var G__4833 = f;
var G__4834 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__4832,G__4833,G__4834) : cljs.core.tree_map_kv_reduce.call(null,G__4832,G__4833,G__4834));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__4836 = k;
switch (G__4836) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
});

cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__4838 = null;
var G__4838__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4838__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4838 = function(x,start){
switch(arguments.length){
case 1:
return G__4838__1.call(this,x);
case 2:
return G__4838__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4838.cljs$core$IFn$_invoke$arity$1 = G__4838__1;
G__4838.cljs$core$IFn$_invoke$arity$2 = G__4838__2;
return G__4838;
})()
;

cljs.core.BlackNode.prototype.indexOf = (function() {
var G__4839 = null;
var G__4839__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4839__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4839 = function(x,start){
switch(arguments.length){
case 1:
return G__4839__1.call(this,x);
case 2:
return G__4839__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4839.cljs$core$IFn$_invoke$arity$1 = G__4839__1;
G__4839.cljs$core$IFn$_invoke$arity$2 = G__4839__2;
return G__4839;
})()
;

cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__4840 = null;
var G__4840__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4840__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4840 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4840__2.call(this,self__,k);
case 3:
return G__4840__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4840.cljs$core$IFn$_invoke$arity$2 = G__4840__2;
G__4840.cljs$core$IFn$_invoke$arity$3 = G__4840__3;
return G__4840;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args4835){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4835)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/BlackNode");
});

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

var G__4841_4844 = cljs.core.BlackNode.prototype;
var G__4842_4845 = cljs.core.ITER_SYMBOL;
var G__4843_4846 = ((function (G__4841_4844,G__4842_4845){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4841_4844,G__4842_4845))
;
goog.object.set(G__4841_4844,G__4842_4845,G__4843_4846);

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__4848 = k;
switch (G__4848) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
});

cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__4850 = null;
var G__4850__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4850__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4850 = function(x,start){
switch(arguments.length){
case 1:
return G__4850__1.call(this,x);
case 2:
return G__4850__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4850.cljs$core$IFn$_invoke$arity$1 = G__4850__1;
G__4850.cljs$core$IFn$_invoke$arity$2 = G__4850__2;
return G__4850;
})()
;

cljs.core.RedNode.prototype.indexOf = (function() {
var G__4851 = null;
var G__4851__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4851__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4851 = function(x,start){
switch(arguments.length){
case 1:
return G__4851__1.call(this,x);
case 2:
return G__4851__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4851.cljs$core$IFn$_invoke$arity$1 = G__4851__1;
G__4851.cljs$core$IFn$_invoke$arity$2 = G__4851__2;
return G__4851;
})()
;

cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__4852 = null;
var G__4852__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4852__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4852 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4852__2.call(this,self__,k);
case 3:
return G__4852__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4852.cljs$core$IFn$_invoke$arity$2 = G__4852__2;
G__4852.cljs$core$IFn$_invoke$arity$3 = G__4852__3;
return G__4852;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args4847){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4847)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/RedNode");
});

/**
 * Positional factory function for cljs.core/RedNode.
 */
cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

var G__4853_4856 = cljs.core.RedNode.prototype;
var G__4854_4857 = cljs.core.ITER_SYMBOL;
var G__4855_4858 = ((function (G__4853_4856,G__4854_4857){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4853_4856,G__4854_4857))
;
goog.object.set(G__4853_4856,G__4854_4857,G__4855_4858);
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__4859 = k;
var G__4860 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__4859,G__4860) : comp.call(null,G__4859,G__4860));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__4861 = comp;
var G__4862 = tree.left;
var G__4863 = k;
var G__4864 = v;
var G__4865 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__4861,G__4862,G__4863,G__4864,G__4865) : cljs.core.tree_map_add.call(null,G__4861,G__4862,G__4863,G__4864,G__4865));
})();
if((!((ins == null)))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__4866 = comp;
var G__4867 = tree.right;
var G__4868 = k;
var G__4869 = v;
var G__4870 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__4866,G__4867,G__4868,G__4869,G__4870) : cljs.core.tree_map_add.call(null,G__4866,G__4867,G__4868,G__4869,G__4870));
})();
if((!((ins == null)))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__4871 = left.right;
var G__4872 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__4871,G__4872) : cljs.core.tree_map_append.call(null,G__4871,G__4872));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__4873 = left.right;
var G__4874 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__4873,G__4874) : cljs.core.tree_map_append.call(null,G__4873,G__4874));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__4875 = left;
var G__4876 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__4875,G__4876) : cljs.core.tree_map_append.call(null,G__4875,G__4876));
})(),right.right,null));
} else {
var app = (function (){var G__4877 = left.right;
var G__4878 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__4877,G__4878) : cljs.core.tree_map_append.call(null,G__4877,G__4878));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if((!((tree == null)))){
var c = (function (){var G__4879 = k;
var G__4880 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__4879,G__4880) : comp.call(null,G__4879,G__4880));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__4881 = comp;
var G__4882 = tree.left;
var G__4883 = k;
var G__4884 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__4881,G__4882,G__4883,G__4884) : cljs.core.tree_map_remove.call(null,G__4881,G__4882,G__4883,G__4884));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__4885 = comp;
var G__4886 = tree.right;
var G__4887 = k;
var G__4888 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__4885,G__4886,G__4887,G__4888) : cljs.core.tree_map_remove.call(null,G__4885,G__4886,G__4887,G__4888));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__4889 = comp;
var G__4890 = tree.left;
var G__4891 = k;
var G__4892 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__4889,G__4890,G__4891,G__4892) : cljs.core.tree_map_replace.call(null,G__4889,G__4890,G__4891,G__4892));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__4893 = comp;
var G__4894 = tree.right;
var G__4895 = k;
var G__4896 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__4893,G__4894,G__4895,G__4896) : cljs.core.tree_map_replace.call(null,G__4893,G__4894,G__4895,G__4896));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
});

cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__4898 = cljs.core.seq(coll);
var chunk__4899 = null;
var count__4900 = (0);
var i__4901 = (0);
while(true){
if((i__4901 < count__4900)){
var vec__4908 = chunk__4899.cljs$core$IIndexed$_nth$arity$2(null,i__4901);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4908,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4908,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4920 = seq__4898;
var G__4921 = chunk__4899;
var G__4922 = count__4900;
var G__4923 = (i__4901 + (1));
seq__4898 = G__4920;
chunk__4899 = G__4921;
count__4900 = G__4922;
i__4901 = G__4923;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__4898);
if(temp__5735__auto__){
var seq__4898__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4898__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__4898__$1);
var G__4924 = cljs.core.chunk_rest(seq__4898__$1);
var G__4925 = c__4550__auto__;
var G__4926 = cljs.core.count(c__4550__auto__);
var G__4927 = (0);
seq__4898 = G__4924;
chunk__4899 = G__4925;
count__4900 = G__4926;
i__4901 = G__4927;
continue;
} else {
var vec__4911 = cljs.core.first(seq__4898__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4911,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4911,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4928 = cljs.core.next(seq__4898__$1);
var G__4929 = null;
var G__4930 = (0);
var G__4931 = (0);
seq__4898 = G__4928;
chunk__4899 = G__4929;
count__4900 = G__4930;
i__4901 = G__4931;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__4914 = k;
var G__4915 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__4914,G__4915) : self__.comp.call(null,G__4914,G__4915));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__4932 = t.left;
t = G__4932;
continue;
} else {
var G__4933 = t.right;
t = G__4933;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if((!((n == null)))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((!((self__.tree == null)))){
return cljs.core.unreduced(cljs.core.tree_map_kv_reduce(self__.tree,f,init));
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((coll__$1.entry_at(k) == null)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,new_meta,self__.__hash));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__4934 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__4935 = cljs.core.next(es);
ret = G__4934;
es = G__4935;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__4936 = null;
var G__4936__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4936__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4936 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4936__2.call(this,self__,k);
case 3:
return G__4936__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4936.cljs$core$IFn$_invoke$arity$2 = G__4936__2;
G__4936.cljs$core$IFn$_invoke$arity$3 = G__4936__3;
return G__4936;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args4897){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4897)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__4918 = k;
var G__4919 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__4918,G__4919) : self__.comp.call(null,G__4918,G__4919));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__4937 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__4938 = t.left;
stack = G__4937;
t = G__4938;
continue;
} else {
var G__4939 = stack;
var G__4940 = t.right;
stack = G__4939;
t = G__4940;
continue;
}
} else {
if((c > (0))){
var G__4941 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__4942 = t.right;
stack = G__4941;
t = G__4942;
continue;
} else {
var G__4943 = stack;
var G__4944 = t.left;
stack = G__4943;
t = G__4944;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return cljs.core.key(entry);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentTreeMap");
});

/**
 * Positional factory function for cljs.core/PersistentTreeMap.
 */
cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
var G__4945_4948 = cljs.core.PersistentTreeMap.prototype;
var G__4946_4949 = cljs.core.ITER_SYMBOL;
var G__4947_4950 = ((function (G__4945_4948,G__4946_4949){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4945_4948,G__4946_4949))
;
goog.object.set(G__4945_4948,G__4946_4949,G__4947_4950);
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4952 = arguments.length;
var i__4731__auto___4953 = (0);
while(true){
if((i__4731__auto___4953 < len__4730__auto___4952)){
args__4736__auto__.push((arguments[i__4731__auto___4953]));

var G__4954 = (i__4731__auto___4953 + (1));
i__4731__auto___4953 = G__4954;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__4955 = cljs.core.nnext(in$);
var G__4956 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__4955;
out = G__4956;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.hash_map.cljs$lang$applyTo = (function (seq4951){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4951));
});

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4958 = arguments.length;
var i__4731__auto___4959 = (0);
while(true){
if((i__4731__auto___4959 < len__4730__auto___4958)){
args__4736__auto__.push((arguments[i__4731__auto___4959]));

var G__4960 = (i__4731__auto___4959 + (1));
i__4731__auto___4959 = G__4960;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = (((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0)))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.createAsIfByAssoc(arr);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.array_map.cljs$lang$applyTo = (function (seq4957){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4957));
});

/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4967 = arguments.length;
var i__4731__auto___4968 = (0);
while(true){
if((i__4731__auto___4968 < len__4730__auto___4967)){
args__4736__auto__.push((arguments[i__4731__auto___4968]));

var G__4969 = (i__4731__auto___4968 + (1));
i__4731__auto___4968 = G__4969;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = ({});
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

var G__4964_4970 = obj;
var G__4965_4971 = cljs.core.first(kvs);
var G__4966_4972 = cljs.core.second(kvs);
goog.object.set(G__4964_4970,G__4965_4971,G__4966_4972);

var G__4973 = cljs.core.nnext(kvs);
kvs = G__4973;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.obj_map.cljs$lang$applyTo = (function (seq4961){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4961));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4975 = arguments.length;
var i__4731__auto___4976 = (0);
while(true){
if((i__4731__auto___4976 < len__4730__auto___4975)){
args__4736__auto__.push((arguments[i__4731__auto___4976]));

var G__4977 = (i__4731__auto___4976 + (1));
i__4731__auto___4976 = G__4977;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__4978 = cljs.core.nnext(in$);
var G__4979 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__4978;
out = G__4979;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.sorted_map.cljs$lang$applyTo = (function (seq4974){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4974));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4982 = arguments.length;
var i__4731__auto___4983 = (0);
while(true){
if((i__4731__auto___4983 < len__4730__auto___4982)){
args__4736__auto__.push((arguments[i__4731__auto___4983]));

var G__4984 = (i__4731__auto___4983 + (1));
i__4731__auto___4983 = G__4984;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__4985 = cljs.core.nnext(in$);
var G__4986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__4985;
out = G__4986;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq4980){
var G__4981 = cljs.core.first(seq4980);
var seq4980__$1 = cljs.core.next(seq4980);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4981,seq4980__$1);
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.indexOf = (function() {
var G__4989 = null;
var G__4989__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4989__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4989 = function(x,start){
switch(arguments.length){
case 1:
return G__4989__1.call(this,x);
case 2:
return G__4989__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4989.cljs$core$IFn$_invoke$arity$1 = G__4989__1;
G__4989.cljs$core$IFn$_invoke$arity$2 = G__4989__2;
return G__4989;
})()
;

cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__4990 = null;
var G__4990__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4990__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4990 = function(x,start){
switch(arguments.length){
case 1:
return G__4990__1.call(this,x);
case 2:
return G__4990__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4990.cljs$core$IFn$_invoke$arity$1 = G__4990__1;
G__4990.cljs$core$IFn$_invoke$arity$2 = G__4990__2;
return G__4990;
})()
;

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,null));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.KeySeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.KeySeq(self__.mseq,new_meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/KeySeq");
});

/**
 * Positional factory function for cljs.core/KeySeq.
 */
cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

var G__4991_4994 = cljs.core.KeySeq.prototype;
var G__4992_4995 = cljs.core.ITER_SYMBOL;
var G__4993_4996 = ((function (G__4991_4994,G__4992_4995){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__4991_4994,G__4992_4995))
;
goog.object.set(G__4991_4994,G__4992_4995,G__4993_4996);
/**
 * Returns a sequence of the map's keys, in the same order as (seq map).
 */
cljs.core.keys = (function cljs$core$keys(map){
var temp__5735__auto__ = cljs.core.seq(map);
if(temp__5735__auto__){
var mseq = temp__5735__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.indexOf = (function() {
var G__4999 = null;
var G__4999__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4999__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4999 = function(x,start){
switch(arguments.length){
case 1:
return G__4999__1.call(this,x);
case 2:
return G__4999__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4999.cljs$core$IFn$_invoke$arity$1 = G__4999__1;
G__4999.cljs$core$IFn$_invoke$arity$2 = G__4999__2;
return G__4999;
})()
;

cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__5000 = null;
var G__5000__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5000__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5000 = function(x,start){
switch(arguments.length){
case 1:
return G__5000__1.call(this,x);
case 2:
return G__5000__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5000.cljs$core$IFn$_invoke$arity$1 = G__5000__1;
G__5000.cljs$core$IFn$_invoke$arity$2 = G__5000__2;
return G__5000;
})()
;

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,null));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.ValSeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.ValSeq(self__.mseq,new_meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ValSeq");
});

/**
 * Positional factory function for cljs.core/ValSeq.
 */
cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

var G__5001_5004 = cljs.core.ValSeq.prototype;
var G__5002_5005 = cljs.core.ITER_SYMBOL;
var G__5003_5006 = ((function (G__5001_5004,G__5002_5005){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__5001_5004,G__5002_5005))
;
goog.object.set(G__5001_5004,G__5002_5005,G__5003_5006);
/**
 * Returns a sequence of the map's values, in the same order as (seq map).
 */
cljs.core.vals = (function cljs$core$vals(map){
var temp__5735__auto__ = cljs.core.seq(map);
if(temp__5735__auto__){
var mseq = temp__5735__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5010 = arguments.length;
var i__4731__auto___5011 = (0);
while(true){
if((i__4731__auto___5011 < len__4730__auto___5010)){
args__4736__auto__.push((arguments[i__4731__auto___5011]));

var G__5012 = (i__4731__auto___5011 + (1));
i__4731__auto___5011 = G__5012;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__5007_SHARP_,p2__5008_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = p1__5007_SHARP_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__5008_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.merge.cljs$lang$applyTo = (function (seq5009){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5009));
});

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5017 = arguments.length;
var i__4731__auto___5018 = (0);
while(true){
if((i__4731__auto___5018 < len__4730__auto___5017)){
args__4736__auto__.push((arguments[i__4731__auto___5018]));

var G__5019 = (i__4731__auto___5018 + (1));
i__4731__auto___5018 = G__5019;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var v = cljs.core.val(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__5015 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__5016 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5015,G__5016) : f.call(null,G__5015,G__5016));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__4131__auto__ = m1;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.merge_with.cljs$lang$applyTo = (function (seq5013){
var G__5014 = cljs.core.first(seq5013);
var seq5013__$1 = cljs.core.next(seq5013);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5014,seq5013__$1);
});

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found);
var G__5020 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__5021 = cljs.core.next(keys);
ret = G__5020;
keys = G__5021;
continue;
} else {
return cljs.core._with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
});
cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
});

cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return self__.iter.next().key;
} else {
throw (new Error("No such element"));
}
});

cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null);
});

cljs.core.HashSetIter.cljs$lang$type = true;

cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter";

cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/HashSetIter");
});

/**
 * Positional factory function for cljs.core/HashSetIter.
 */
cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__5025 = cljs.core.seq(coll);
var chunk__5026 = null;
var count__5027 = (0);
var i__5028 = (0);
while(true){
if((i__5028 < count__5027)){
var vec__5035 = chunk__5026.cljs$core$IIndexed$_nth$arity$2(null,i__5028);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5035,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5035,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5044 = seq__5025;
var G__5045 = chunk__5026;
var G__5046 = count__5027;
var G__5047 = (i__5028 + (1));
seq__5025 = G__5044;
chunk__5026 = G__5045;
count__5027 = G__5046;
i__5028 = G__5047;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__5025);
if(temp__5735__auto__){
var seq__5025__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5025__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__5025__$1);
var G__5048 = cljs.core.chunk_rest(seq__5025__$1);
var G__5049 = c__4550__auto__;
var G__5050 = cljs.core.count(c__4550__auto__);
var G__5051 = (0);
seq__5025 = G__5048;
chunk__5026 = G__5049;
count__5027 = G__5050;
i__5028 = G__5051;
continue;
} else {
var vec__5038 = cljs.core.first(seq__5025__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5038,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5038,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5052 = cljs.core.next(seq__5025__$1);
var G__5053 = null;
var G__5054 = (0);
var G__5055 = (0);
seq__5025 = G__5052;
chunk__5026 = G__5053;
count__5027 = G__5054;
i__5028 = G__5055;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var temp__5733__auto__ = cljs.core._find(self__.hash_map,v);
if(cljs.core.truth_(temp__5733__auto__)){
var entry = temp__5733__auto__;
return cljs.core.key(entry);
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var and__4120__auto__ = cljs.core.set_QMARK_(other);
if(and__4120__auto__){
var and__4120__auto____$1 = (cljs.core.count(coll__$1) === cljs.core.count(other));
if(and__4120__auto____$1){
try{return cljs.core.reduce_kv(((function (and__4120__auto____$1,and__4120__auto__,coll__$1){
return (function (p1__5023_SHARP_,p2__5022_SHARP_){
var or__4131__auto__ = cljs.core.contains_QMARK_(other,p2__5022_SHARP_);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.reduced(false);
}
});})(and__4120__auto____$1,and__4120__auto__,coll__$1))
,true,self__.hash_map);
}catch (e5043){if((e5043 instanceof Error)){
var ex = e5043;
return false;
} else {
throw e5043;

}
}} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashSet(new_meta,self__.hash_map,self__.__hash));
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__5056 = null;
var G__5056__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__5056__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__5056 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5056__2.call(this,self__,k);
case 3:
return G__5056__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5056.cljs$core$IFn$_invoke$arity$2 = G__5056__2;
G__5056.cljs$core$IFn$_invoke$arity$3 = G__5056__3;
return G__5056;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args5024){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5024)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentHashSet");
});

/**
 * Positional factory function for cljs.core/PersistentHashSet.
 */
cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__5057 = (i + (1));
var G__5058 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__5057;
out = G__5058;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__5059 = (i + (1));
var G__5060 = cljs.core._conj_BANG_(out,(items[i]));
i = G__5059;
out = G__5060;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
cljs.core.PersistentHashSet.createWithCheck = (function (items){
var len = items.length;
var t = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
var n__4607__auto___5061 = len;
var i_5062 = (0);
while(true){
if((i_5062 < n__4607__auto___5061)){
cljs.core._conj_BANG_(t,(items[i_5062]));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(t),(i_5062 + (1)))){
} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((items[i_5062]))].join('')));
}

var G__5063 = (i_5062 + (1));
i_5062 = G__5063;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_(t);
});
cljs.core.PersistentHashSet.createAsIfByAssoc = (function (items){
var len = items.length;
var t = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
var n__4607__auto___5064 = len;
var i_5065 = (0);
while(true){
if((i_5065 < n__4607__auto___5064)){
cljs.core._conj_BANG_(t,(items[i_5065]));

var G__5066 = (i_5065 + (1));
i_5065 = G__5066;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_(t);
});
var G__5067_5070 = cljs.core.PersistentHashSet.prototype;
var G__5068_5071 = cljs.core.ITER_SYMBOL;
var G__5069_5072 = ((function (G__5067_5070,G__5068_5071){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__5067_5070,G__5068_5071))
;
goog.object.set(G__5067_5070,G__5068_5071,G__5069_5072);

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
});
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__5074 = null;
var G__5074__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__5074__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__5074 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5074__2.call(this,self__,k);
case 3:
return G__5074__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5074.cljs$core$IFn$_invoke$arity$2 = G__5074__2;
G__5074.cljs$core$IFn$_invoke$arity$3 = G__5074__3;
return G__5074;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args5073){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5073)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/TransientHashSet");
});

/**
 * Positional factory function for cljs.core/TransientHashSet.
 */
cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__5078 = cljs.core.seq(coll);
var chunk__5079 = null;
var count__5080 = (0);
var i__5081 = (0);
while(true){
if((i__5081 < count__5080)){
var vec__5088 = chunk__5079.cljs$core$IIndexed$_nth$arity$2(null,i__5081);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5088,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5088,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5097 = seq__5078;
var G__5098 = chunk__5079;
var G__5099 = count__5080;
var G__5100 = (i__5081 + (1));
seq__5078 = G__5097;
chunk__5079 = G__5098;
count__5080 = G__5099;
i__5081 = G__5100;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__5078);
if(temp__5735__auto__){
var seq__5078__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5078__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__5078__$1);
var G__5101 = cljs.core.chunk_rest(seq__5078__$1);
var G__5102 = c__4550__auto__;
var G__5103 = cljs.core.count(c__4550__auto__);
var G__5104 = (0);
seq__5078 = G__5101;
chunk__5079 = G__5102;
count__5080 = G__5103;
i__5081 = G__5104;
continue;
} else {
var vec__5091 = cljs.core.first(seq__5078__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5091,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5091,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5105 = cljs.core.next(seq__5078__$1);
var G__5106 = null;
var G__5107 = (0);
var G__5108 = (0);
seq__5078 = G__5105;
chunk__5079 = G__5106;
count__5080 = G__5107;
i__5081 = G__5108;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if((!((n == null)))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var and__4120__auto__ = cljs.core.set_QMARK_(other);
if(and__4120__auto__){
var and__4120__auto____$1 = (cljs.core.count(coll__$1) === cljs.core.count(other));
if(and__4120__auto____$1){
try{return cljs.core.reduce_kv(((function (and__4120__auto____$1,and__4120__auto__,coll__$1){
return (function (p1__5076_SHARP_,p2__5075_SHARP_){
var or__4131__auto__ = cljs.core.contains_QMARK_(other,p2__5075_SHARP_);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.reduced(false);
}
});})(and__4120__auto____$1,and__4120__auto__,coll__$1))
,true,self__.tree_map);
}catch (e5096){if((e5096 instanceof Error)){
var ex = e5096;
return false;
} else {
throw e5096;

}
}} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeSet(new_meta,self__.tree_map,self__.__hash));
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__5109 = null;
var G__5109__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__5109__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__5109 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5109__2.call(this,self__,k);
case 3:
return G__5109__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5109.cljs$core$IFn$_invoke$arity$2 = G__5109__2;
G__5109.cljs$core$IFn$_invoke$arity$3 = G__5109__3;
return G__5109;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args5077){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5077)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/PersistentTreeSet");
});

/**
 * Positional factory function for cljs.core/PersistentTreeSet.
 */
cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
var G__5110_5113 = cljs.core.PersistentTreeSet.prototype;
var G__5111_5114 = cljs.core.ITER_SYMBOL;
var G__5112_5115 = ((function (G__5110_5113,G__5111_5114){
return (function (){
var this__4669__auto__ = this;
return cljs.core.es6_iterator(this__4669__auto__);
});})(G__5110_5113,G__5111_5114))
;
goog.object.set(G__5110_5113,G__5111_5114,G__5112_5115);
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4604__auto__ = arr;
var l__4605__auto__ = a__4604__auto__.length;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < l__4605__auto__)){
var G__5116 = (i + (1));
var G__5117 = cljs.core._conj_BANG_(res,(arr[i]));
i = G__5116;
res = G__5117;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
if(cljs.core.set_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if((((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0))))){
return cljs.core.PersistentHashSet.createAsIfByAssoc(in$.arr);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((!((in$__$1 == null)))){
var G__5118 = cljs.core.next(in$__$1);
var G__5119 = cljs.core._conj_BANG_(out,cljs.core._first(in$__$1));
in$__$1 = G__5118;
out = G__5119;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var G__5122 = arguments.length;
switch (G__5122) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___5124 = arguments.length;
var i__4731__auto___5125 = (0);
while(true){
if((i__4731__auto___5125 < len__4730__auto___5124)){
args_arr__4751__auto__.push((arguments[i__4731__auto___5125]));

var G__5126 = (i__4731__auto___5125 + (1));
i__4731__auto___5125 = G__5126;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((0)),(0),null));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4752__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

/** @this {Function} */
cljs.core.hash_set.cljs$lang$applyTo = (function (seq5121){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5121));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);

/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5128 = arguments.length;
var i__4731__auto___5129 = (0);
while(true){
if((i__4731__auto___5129 < len__4730__auto___5128)){
args__4736__auto__.push((arguments[i__4731__auto___5129]));

var G__5130 = (i__4731__auto___5129 + (1));
i__4731__auto___5129 = G__5130;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.core.sorted_set.cljs$lang$applyTo = (function (seq5127){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5127));
});

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5133 = arguments.length;
var i__4731__auto___5134 = (0);
while(true){
if((i__4731__auto___5134 < len__4730__auto___5133)){
args__4736__auto__.push((arguments[i__4731__auto___5134]));

var G__5135 = (i__4731__auto___5134 + (1));
i__4731__auto___5134 = G__5135;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq5131){
var G__5132 = cljs.core.first(seq5131);
var seq5131__$1 = cljs.core.next(seq5131);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5132,seq5131__$1);
});

/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var G__5139 = arguments.length;
switch (G__5139) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__5136_SHARP_){
var temp__5733__auto__ = cljs.core.find(smap,p1__5136_SHARP_);
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
return cljs.core.val(e);
} else {
return p1__5136_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__5733__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5137_SHARP_){
var temp__5733__auto__ = cljs.core.find(smap,p1__5137_SHARP_);
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
return cljs.core.second(e);
} else {
return p1__5137_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var G__5142 = arguments.length;
switch (G__5142) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__5153 = null;
var G__5153__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__5153__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__5153__2 = (function (result,input){
if(cljs.core.contains_QMARK_(cljs.core.deref(seen),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__5153 = function(result,input){
switch(arguments.length){
case 0:
return G__5153__0.call(this);
case 1:
return G__5153__1.call(this,result);
case 2:
return G__5153__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5153.cljs$core$IFn$_invoke$arity$0 = G__5153__0;
G__5153.cljs$core$IFn$_invoke$arity$1 = G__5153__1;
G__5153.cljs$core$IFn$_invoke$arity$2 = G__5153__2;
return G__5153;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
var fexpr__5147 = (function (p__5148,seen__$1){
while(true){
var vec__5149 = p__5148;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5149,(0),null);
var xs__$1 = vec__5149;
var temp__5735__auto__ = cljs.core.seq(xs__$1);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__5154 = cljs.core.rest(s);
var G__5155 = seen__$1;
p__5148 = G__5154;
seen__$1 = G__5155;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
});
return fexpr__5147(xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;

/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__5156 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__5157 = cljs.core.next(s__$1);
ret = G__5156;
s__$1 = G__5157;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return cljs.core._name(x);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error(["Doesn't support name: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if(((ks) && (vs))){
var G__5159 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__5160 = cljs.core.next(ks);
var G__5161 = cljs.core.next(vs);
map = G__5159;
ks = G__5160;
vs = G__5161;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 *   
 *   If there are multiple such xs, the last one is returned.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var G__5169 = arguments.length;
switch (G__5169) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___5171 = arguments.length;
var i__4731__auto___5172 = (0);
while(true){
if((i__4731__auto___5172 < len__4730__auto___5171)){
args_arr__4751__auto__.push((arguments[i__4731__auto___5172]));

var G__5173 = (i__4731__auto___5172 + (1));
i__4731__auto___5172 = G__5173;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) > (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__5162_SHARP_,p2__5163_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__5162_SHARP_,p2__5163_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

/** @this {Function} */
cljs.core.max_key.cljs$lang$applyTo = (function (seq5165){
var G__5166 = cljs.core.first(seq5165);
var seq5165__$1 = cljs.core.next(seq5165);
var G__5167 = cljs.core.first(seq5165__$1);
var seq5165__$2 = cljs.core.next(seq5165__$1);
var G__5168 = cljs.core.first(seq5165__$2);
var seq5165__$3 = cljs.core.next(seq5165__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5166,G__5167,G__5168,seq5165__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);

/**
 * Returns the x for which (k x), a number, is least.
 * 
 *   If there are multiple such xs, the last one is returned.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var G__5181 = arguments.length;
switch (G__5181) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___5183 = arguments.length;
var i__4731__auto___5184 = (0);
while(true){
if((i__4731__auto___5184 < len__4730__auto___5183)){
args_arr__4751__auto__.push((arguments[i__4731__auto___5184]));

var G__5185 = (i__4731__auto___5184 + (1));
i__4731__auto___5184 = G__5185;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) < (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__5174_SHARP_,p2__5175_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__5174_SHARP_,p2__5175_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

/** @this {Function} */
cljs.core.min_key.cljs$lang$applyTo = (function (seq5177){
var G__5178 = cljs.core.first(seq5177);
var seq5177__$1 = cljs.core.next(seq5177);
var G__5179 = cljs.core.first(seq5177__$1);
var seq5177__$2 = cljs.core.next(seq5177__$1);
var G__5180 = cljs.core.first(seq5177__$2);
var seq5177__$3 = cljs.core.next(seq5177__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5178,G__5179,G__5180,seq5177__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);


/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
});
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core/ArrayList");
});

/**
 * Positional factory function for cljs.core/ArrayList.
 */
cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var G__5187 = arguments.length;
switch (G__5187) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__5189 = null;
var G__5189__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__5189__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__5189__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
} else {
return result;
}
});
G__5189 = function(result,input){
switch(arguments.length){
case 0:
return G__5189__0.call(this);
case 1:
return G__5189__1.call(this,result);
case 2:
return G__5189__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5189.cljs$core$IFn$_invoke$arity$0 = G__5189__0;
G__5189.cljs$core$IFn$_invoke$arity$1 = G__5189__1;
G__5189.cljs$core$IFn$_invoke$arity$2 = G__5189__2;
return G__5189;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var G__5191 = arguments.length;
switch (G__5191) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__5194 = null;
var G__5194__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__5194__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__5194__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return cljs.core.reduced(result);
}
});
G__5194 = function(result,input){
switch(arguments.length){
case 0:
return G__5194__0.call(this);
case 1:
return G__5194__1.call(this,result);
case 2:
return G__5194__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5194.cljs$core$IFn$_invoke$arity$0 = G__5194__0;
G__5194.cljs$core$IFn$_invoke$arity$1 = G__5194__1;
G__5194.cljs$core$IFn$_invoke$arity$2 = G__5194__2;
return G__5194;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.seq(coll);
if(temp__5735__auto__){
var s = temp__5735__auto__;
if(cljs.core.truth_((function (){var G__5192 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__5192) : pred.call(null,G__5192));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;

cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__5195 = (function (){var G__5197 = cljs.core._entry_key(sc,e);
var G__5198 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__5197,G__5198) : comp.call(null,G__5197,G__5198));
})();
var G__5196 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__5195,G__5196) : test.call(null,G__5195,G__5196));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var G__5200 = arguments.length;
switch (G__5200) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_((function (){var fexpr__5201 = cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core._GT_,cljs.core._GT__EQ_]);
return (fexpr__5201.cljs$core$IFn$_invoke$arity$1 ? fexpr__5201.cljs$core$IFn$_invoke$arity$1(test) : fexpr__5201.call(null,test));
})())){
var temp__5735__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__5735__auto__)){
var vec__5202 = temp__5735__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5202,(0),null);
var s = vec__5202;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__5735__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__5735__auto__)){
var vec__5205 = temp__5735__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5205,(0),null);
var s = vec__5205;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_((function (){va