// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.core');
goog.require('fluree.crypto.sha3');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('goog.crypt.Pkcs7');
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6008 = arguments.length;
var i__4731__auto___6009 = (0);
while(true){
if((i__4731__auto___6009 < len__4730__auto___6008)){
args__4736__auto__.push((arguments[i__4731__auto___6009]));

var G__6010 = (i__4731__auto___6009 + (1));
i__4731__auto___6009 = G__6010;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__6001){
var vec__6002 = p__6001;
var map__6005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6002,(0),null);
var map__6005__$1 = (((((!((map__6005 == null))))?(((((map__6005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6005.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6005):map__6005);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__6005__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__6005__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$hex);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = (function (){var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var pkcs7 = (new goog.crypt.Pkcs7());
var padded = pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
})();
var G__6007 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__6007__$1 = (((G__6007 instanceof cljs.core.Keyword))?G__6007.fqn:null);
switch (G__6007__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__6007__$1)].join('')));

}
});

fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq5998){
var G__5999 = cljs.core.first(seq5998);
var seq5998__$1 = cljs.core.next(seq5998);
var G__6000 = cljs.core.first(seq5998__$1);
var seq5998__$2 = cljs.core.next(seq5998__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5999,G__6000,seq5998__$2);
});

/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6024 = arguments.length;
var i__4731__auto___6025 = (0);
while(true){
if((i__4731__auto___6025 < len__4730__auto___6024)){
args__4736__auto__.push((arguments[i__4731__auto___6025]));

var G__6026 = (i__4731__auto___6025 + (1));
i__4731__auto___6025 = G__6026;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__6016){
var vec__6017 = p__6016;
var map__6020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6017,(0),null);
var map__6020__$1 = (((((!((map__6020 == null))))?(((((map__6020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6020.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6020):map__6020);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__6020__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__6020__$1,cljs.core.cst$kw$input_DASH_format,cljs.core.cst$kw$hex);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__6020__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$string);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__6022 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__6022__$1 = (((G__6022 instanceof cljs.core.Keyword))?G__6022.fqn:null);
switch (G__6022__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__6022__$1)].join('')));

}
})():x);
var decrypt_ba = (function (){var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var pkcs7 = (new goog.crypt.Pkcs7());
return pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
})();
var G__6023 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__6023__$1 = (((G__6023 instanceof cljs.core.Keyword))?G__6023.fqn:null);
switch (G__6023__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__6023__$1)].join('')));

}
});

fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq6013){
var G__6014 = cljs.core.first(seq6013);
var seq6013__$1 = cljs.core.next(seq6013);
var G__6015 = cljs.core.first(seq6013__$1);
var seq6013__$2 = cljs.core.next(seq6013__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6014,G__6015,seq6013__$2);
});

