// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.crypto.secp256k1');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.core');
goog.require('fluree.crypto.hmac');
goog.require('fluree.crypto.sha2');
goog.require('fluree.crypto.ripemd');
goog.require('fluree.crypto.encodings');
goog.require('sjcl.ecc');
goog.require('sjcl.bn');
goog.require('sjcl.codec.hex');
goog.require('sjcl.codec.bytes');
if((typeof fluree !== 'undefined') && (typeof fluree.crypto !== 'undefined') && (typeof fluree.crypto.secp256k1 !== 'undefined') && (typeof fluree.crypto.secp256k1.secp256k1 !== 'undefined')){
} else {
fluree.crypto.secp256k1.secp256k1 = sjcl.ecc.curves.k256;
}
if((typeof fluree !== 'undefined') && (typeof fluree.crypto !== 'undefined') && (typeof fluree.crypto.secp256k1 !== 'undefined') && (typeof fluree.crypto.secp256k1.modulus !== 'undefined')){
} else {
fluree.crypto.secp256k1.modulus = fluree.crypto.secp256k1.secp256k1.r;
}
/**
 * Returns true if private key, as big number/integer, is valid.
 *   Private key must be >= 1 and <= curve modulus.
 */
fluree.crypto.secp256k1.valid_private_QMARK_ = (function fluree$crypto$secp256k1$valid_private_QMARK_(private$){
var and__4120__auto__ = private$.greaterEquals((1));
if(cljs.core.truth_(and__4120__auto__)){
return fluree.crypto.secp256k1.modulus.greaterEquals(private$);
} else {
return and__4120__auto__;
}
});
/**
 * Takes internal representation of a public key and returns X9.62 compressed encoded
 * public key, hex encoded.
 */
fluree.crypto.secp256k1.format_public_key = (function fluree$crypto$secp256k1$format_public_key(public$){
var x = fluree.crypto.encodings.pad_hex(public$.x.toString().replace(/^0x/,""));
var y = fluree.crypto.encodings.pad_hex(public$.y.toString().replace(/^0x/,""));
return fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$2(x,y);
});
/**
 * Takes internal representation of a key-pair and returns X9.62 compressed encoded
 *   public key and private key as a map, with each value hex encoded.
 */
fluree.crypto.secp256k1.format_key_pair = (function fluree$crypto$secp256k1$format_key_pair(pair){
var private$ = (pair["private"]);
var public$ = (pair["public"]);
var x = fluree.crypto.encodings.pad_hex((public$["x"]).toString().replace(/^0x/,""));
var y = fluree.crypto.encodings.pad_hex((public$["y"]).toString().replace(/^0x/,""));
var pair_hex = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,fluree.crypto.encodings.biginteger__GT_hex(private$),cljs.core.cst$kw$public,fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$2(x,y)], null);
return cljs.core.clj__GT_js(pair_hex);
});
fluree.crypto.secp256k1.public_key_from_private = (function fluree$crypto$secp256k1$public_key_from_private(private$){
var private_bn = (new sjcl.bn()).initWith(private$);
if(cljs.core.truth_(fluree.crypto.secp256k1.valid_private_QMARK_(private_bn))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid private key. Must be big integer and >= 1, <= curve modulus.",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$private,private$], null));
}

return ({"private": private_bn, "public": fluree.crypto.secp256k1.secp256k1.G.mult(private_bn)});
});
/**
 * Generate a SIN from a public key
 */
fluree.crypto.secp256k1.get_sin_from_public_key = (function fluree$crypto$secp256k1$get_sin_from_public_key(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6063 = arguments.length;
var i__4731__auto___6064 = (0);
while(true){
if((i__4731__auto___6064 < len__4730__auto___6063)){
args__4736__auto__.push((arguments[i__4731__auto___6064]));

var G__6065 = (i__4731__auto___6064 + (1));
i__4731__auto___6064 = G__6065;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.crypto.secp256k1.get_sin_from_public_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.crypto.secp256k1.get_sin_from_public_key.cljs$core$IFn$_invoke$arity$variadic = (function (pub_key,p__6058){
var map__6059 = p__6058;
var map__6059__$1 = (((((!((map__6059 == null))))?(((((map__6059.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6059.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6059):map__6059);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__6059__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$base58);
var pub_prefixed = cljs.core.clj__GT_js(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),(2)], null),fluree.crypto.ripemd.ripemd_160(fluree.crypto.sha2.sha2_256(alphabase.core.hex__GT_bytes(pub_key)))));
var checksum = cljs.core.clj__GT_js((function (){var G__6062 = fluree.crypto.sha2.sha2_256(fluree.crypto.sha2.sha2_256(pub_prefixed));
var fexpr__6061 = ((function (G__6062,pub_prefixed,map__6059,map__6059__$1,output_format){
return (function (p1__6055_SHARP_){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((4),p1__6055_SHARP_);
});})(G__6062,pub_prefixed,map__6059,map__6059__$1,output_format))
;
return fexpr__6061(G__6062);
})());
return alphabase.core.bytes__GT_base58(cljs.core.clj__GT_js(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pub_prefixed,checksum)));
});

fluree.crypto.secp256k1.get_sin_from_public_key.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.crypto.secp256k1.get_sin_from_public_key.cljs$lang$applyTo = (function (seq6056){
var G__6057 = cljs.core.first(seq6056);
var seq6056__$1 = cljs.core.next(seq6056);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6057,seq6056__$1);
});

/**
 * Generates a new random private key.
 */
fluree.crypto.secp256k1.new_private_key = (function fluree$crypto$secp256k1$new_private_key(){
return (new sjcl.bn(sjcl.ecc.ecdsa.generateKeys.call(null,fluree.crypto.secp256k1.secp256k1).sec.get()));
});
goog.exportSymbol('fluree.crypto.secp256k1.new_private_key', fluree.crypto.secp256k1.new_private_key);
/**
 * Generates an internal representation of key pair from a secure random seed or provided private key.
 *   Returns map/object with two keys:
 * - private  - a big number/integer
 * - public - a curve point
 * 
 * If a private key is provided, must be in either hex string or BigInteger (clj) bignumber (cljs).
 */
fluree.crypto.secp256k1.generate_key_pair_STAR_ = (function fluree$crypto$secp256k1$generate_key_pair_STAR_(var_args){
var G__6067 = arguments.length;
switch (G__6067) {
case 0:
return fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$1(fluree.crypto.secp256k1.new_private_key());
});

fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (private$){
return fluree.crypto.secp256k1.public_key_from_private(private$);
});

fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$lang$maxFixedArity = 1;

/**
 * Returns key pair in hex format using X9.62 compressed encoding for public key.
 */
fluree.crypto.secp256k1.generate_key_pair = (function fluree$crypto$secp256k1$generate_key_pair(var_args){
var G__6070 = arguments.length;
switch (G__6070) {
case 0:
return fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.secp256k1.generate_key_pair', fluree.crypto.secp256k1.generate_key_pair);

fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.crypto.secp256k1.format_key_pair(fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$0());
});

fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$1 = (function (private$){
return fluree.crypto.secp256k1.format_key_pair(fluree.crypto.secp256k1.generate_key_pair_STAR_.cljs$core$IFn$_invoke$arity$1(private$));
});

fluree.crypto.secp256k1.generate_key_pair.cljs$lang$maxFixedArity = 1;

/**
 * Deterministically generate a random number in accordance with RFC 6979.
 *   Provided hash should have 256 bits to align with secp256k1 curve.
 */
fluree.crypto.secp256k1.deterministic_generate_k = (function fluree$crypto$secp256k1$deterministic_generate_k(hash_ba,priv_key,curve){
var l = curve.r.bitLength();
var curve_bytes = (l / (8));
var v = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(curve_bytes,(1));
var k = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(curve_bytes,(0));
var pk = fluree.crypto.encodings.biginteger__GT_bytes.cljs$core$IFn$_invoke$arity$1(priv_key);
var left_padding = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((curve_bytes - cljs.core.count(hash_ba)),(0));
var hash = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(left_padding,hash_ba);
var k__$1 = fluree.crypto.hmac.hmac_sha256(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(v,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pk,hash], 0)),k);
var v__$1 = fluree.crypto.hmac.hmac_sha256(v,k__$1);
var k__$2 = fluree.crypto.hmac.hmac_sha256(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(v__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pk,hash], 0)),k__$1);
var v__$2 = fluree.crypto.hmac.hmac_sha256(v__$1,k__$2);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(hash),curve_bytes)){
} else {
throw (new Error(["Assert failed: ","Hash should have the same number of bytes as the curve modulus","\n","(= (count hash) curve-bytes)"].join('')));
}

return fluree.crypto.encodings.bytes__GT_biginteger(fluree.crypto.hmac.hmac_sha256(v__$2,k__$2));
});
/**
 * Compute a recovery byte for a compressed ECDSA signature given R and S parameters.
 *   Returns value as byte integer.
 */
fluree.crypto.secp256k1.compute_recovery_byte = (function fluree$crypto$secp256k1$compute_recovery_byte(kp,r,s){
var n = fluree.crypto.secp256k1.secp256k1.r;
var big_r_QMARK_ = r.greaterEquals(n);
var big_s_QMARK_ = s.add(s).greaterEquals(n);
var y_odd_QMARK_ = (!(fluree.crypto.encodings.bn_even_QMARK_(kp.y)));
return (((27) + ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(big_s_QMARK_,y_odd_QMARK_))?(1):(0))) + (cljs.core.truth_(big_r_QMARK_)?(2):(0)));
});
fluree.crypto.secp256k1.sign_hash = (function fluree$crypto$secp256k1$sign_hash(hash_ba,private_bn,recovery_byte_QMARK_){
var rng = fluree.crypto.secp256k1.deterministic_generate_k(hash_ba,private_bn,fluree.crypto.secp256k1.secp256k1);
var n = fluree.crypto.secp256k1.secp256k1.r;
var z = (new sjcl.bn(sjcl.codec.bytes.toBits(hash_ba)));
var l = n.bitLength();
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(hash_ba),(l / (8))))?null:(function(){throw (new Error(["Assert failed: ","Hash should have the same number of bytes as the curve modulus","\n","(= (count hash-ba) (/ l 8))"].join('')))})());
var vec__6072 = (function (){var k = rng;
var kp = fluree.crypto.secp256k1.secp256k1.G.mult(k);
var r = kp.x.mod(n);
var s_ = r.mul(private_bn).add(z).mul(k.inverseMod(n)).mod(n);
var s = (cljs.core.truth_(s_.add(s_).greaterEquals(n))?n.sub(s_):s_);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,s,s_,kp], null);
})();
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6072,(0),null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6072,(1),null);
var s_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6072,(2),null);
var kp = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6072,(3),null);
var recovery_byte = (cljs.core.truth_(recovery_byte_QMARK_)?fluree.crypto.secp256k1.compute_recovery_byte(kp,r,s_):null);
return alphabase.core.bytes__GT_hex(fluree.crypto.encodings.DER_encode_ECDSA_signature(r,s,recovery_byte,fluree.crypto.secp256k1.secp256k1));
});
goog.exportSymbol('fluree.crypto.secp256k1.sign_hash', fluree.crypto.secp256k1.sign_hash);
/**
 * Sign some message with provided private key.
 *   Message must be a byte-array or string.
 *   Private key must be hex-encoded or a BigInteger(clj)/bignumber(cljs).
 */
fluree.crypto.secp256k1.sign = (function fluree$crypto$secp256k1$sign(message,private_key){
var msg_ba = ((typeof message === 'string')?alphabase.core.string__GT_bytes(message):message);
var private_bn = ((typeof private_key === 'string')?fluree.crypto.encodings.hex__GT_biginteger(private_key):private_key);
var hash = fluree.crypto.sha2.sha2_256(msg_ba);
return fluree.crypto.secp256k1.sign_hash(hash,private_bn,true);
});
goog.exportSymbol('fluree.crypto.secp256k1.sign', fluree.crypto.secp256k1.sign);
/**
 * Given the components of a signature and a recovery value,
 *   recover and return the public key that generated the
 *   signature according to the algorithm in SEC1v2 section 4.1.6
 * 
 *   recovery-byte should be an integer byte.
 */
fluree.crypto.secp256k1.ecrecover = (function fluree$crypto$secp256k1$ecrecover(hash,recovery_byte,r,s){
if(((typeof recovery_byte === 'number') && (((27) <= recovery_byte)) && ((recovery_byte <= (30))))){
} else {
throw (new Error(["Assert failed: ",["Recovery byte should be between 0x1B and 0x1E. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(recovery_byte.toString((16)))].join(''),"\n","(and (number? recovery-byte) (<= 27 recovery-byte) (<= recovery-byte 30))"].join('')));
}

var l = (fluree.crypto.secp256k1.secp256k1.r.bitLength() / (8));
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(l,cljs.core.count(hash)))?null:(function(){throw (new Error(["Assert failed: ",["Hash should have ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(l)," bytes, but had ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(hash)),"."].join(''),"\n","(= l (count hash))"].join('')))})());
var y_even_QMARK_ = cljs.core.even_QMARK_((recovery_byte - (27)));
var is_second_key_QMARK_ = cljs.core.odd_QMARK_(((recovery_byte - (27)) >> (1)));
var n = fluree.crypto.secp256k1.secp256k1.r;
var point = fluree.crypto.encodings.compute_point(y_even_QMARK_,((is_second_key_QMARK_)?r.add(n):r),fluree.crypto.secp256k1.secp256k1);
var R = point;
var r_inv = r.inverseMod(n);
var hash_bi = fluree.crypto.encodings.bytes__GT_biginteger(hash);
var e_inv = n.sub(hash_bi);
var g_point = (new sjcl.ecc.point(fluree.crypto.secp256k1.secp256k1,fluree.crypto.secp256k1.secp256k1.G.x,fluree.crypto.secp256k1.secp256k1.G.y));
var r_point = (new sjcl.ecc.point(fluree.crypto.secp256k1.secp256k1,R.x,R.y));
var sumOTM = r_point.mult2(s,e_inv,g_point);
var sumPoint = (new sjcl.ecc.point(fluree.crypto.secp256k1.secp256k1,sumOTM.x,sumOTM.y));
return fluree.crypto.secp256k1.format_public_key(sumPoint.mult(r_inv));
});
/**
 * Recover a public key from a hash byte-array and signature (hex).
 */
fluree.crypto.secp256k1.recover_public_key_from_hash = (function fluree$crypto$secp256k1$recover_public_key_from_hash(hash,signature){
var map__6075 = fluree.crypto.encodings.DER_decode_ECDSA_signature(signature);
var map__6075__$1 = (((((!((map__6075 == null))))?(((((map__6075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6075.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6075):map__6075);
var recover = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6075__$1,cljs.core.cst$kw$recover);
var R = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6075__$1,cljs.core.cst$kw$R);
var S = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6075__$1,cljs.core.cst$kw$S);
var recover__$1 = (recover | (0));
var recovered = fluree.crypto.secp256k1.ecrecover(hash,recover__$1,R,S);
return recovered;
});
/**
 * Recover a public key from original message and signature (hex) of the
 *   message's sha2-256 hash.
 */
fluree.crypto.secp256k1.recover_public_key = (function fluree$crypto$secp256k1$recover_public_key(input,signature){
var hash = fluree.crypto.sha2.sha2_256(((typeof input === 'string')?alphabase.core.string__GT_bytes(input):input));
return fluree.crypto.secp256k1.recover_public_key_from_hash(hash,signature);
});
fluree.crypto.secp256k1.verify_signature_from_hash = (function fluree$crypto$secp256k1$verify_signature_from_hash(key,hash,signature){
var head1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(signature,(0),(2));
var head2 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(signature,(2),(4));
if(cljs.core.truth_((function (){var and__4120__auto__ = (function (){var fexpr__6078 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["1c",null,"1b",null,"1e",null,"1d",null], null), null);
return (fexpr__6078.cljs$core$IFn$_invoke$arity$1 ? fexpr__6078.cljs$core$IFn$_invoke$arity$1(head1) : fexpr__6078.call(null,head1));
})();
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("30",head2);
} else {
return and__4120__auto__;
}
})())){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,fluree.crypto.secp256k1.recover_public_key_from_hash(hash,signature));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unknown signature header",new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$key,key,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$signature,signature], null));

}
});
/**
 * Verifies a message given a signature (in hex).
 *   Assumes signature is DER-encoded with a recovery byte.
 */
fluree.crypto.secp256k1.verify = (function fluree$crypto$secp256k1$verify(pub_key,message,signature){
var hash = fluree.crypto.sha2.sha2_256(alphabase.core.string__GT_bytes(message));
return fluree.crypto.secp256k1.verify_signature_from_hash(pub_key,hash,signature);
});
goog.exportSymbol('fluree.crypto.secp256k1.verify', fluree.crypto.secp256k1.verify);
