// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.crypto_test');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.test');
goog.require('fluree.crypto');
goog.require('alphabase.core');
goog.require('fluree.crypto.ripemd');
fluree.crypto_test.random_char = (function fluree$crypto_test$random_char(){
return cljs.core.rand_int((15)).toString((16));
});
fluree.crypto_test.random_string = (function fluree$crypto_test$random_string(length){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take.cljs$core$IFn$_invoke$arity$2(length,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(fluree.crypto_test.random_char)));
});
fluree.crypto_test.composed_decomposed_map = new cljs.core.PersistentArrayMap(null, 3, ["\u00C5","A\u030A","\u212B","A\u030A","\u00E9","e\u0301"], null);
fluree.crypto_test.normalize_string_test = (function fluree$crypto_test$normalize_string_test(){
return cljs.test.test_var(fluree.crypto_test.normalize_string_test.cljs$lang$var);
});
fluree.crypto_test.normalize_string_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Normalize string test"], 0));

try{var rdm_str = fluree.crypto_test.random_string((10));
try{var values__7592__auto___7861 = (new cljs.core.List(null,cljs.core.count(fluree.crypto.normalize_string(rdm_str)),(new cljs.core.List(null,(10),null,(1),null)),(2),null));
var result__7593__auto___7862 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,values__7592__auto___7861);
if(cljs.core.truth_(result__7593__auto___7862)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$rdm_DASH_str)),(10)),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core._EQ_,values__7592__auto___7861),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$rdm_DASH_str)),(10)),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$_EQ_,values__7592__auto___7861),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

}catch (e7855){var t__7637__auto___7863 = e7855;
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$rdm_DASH_str)),(10)),cljs.core.cst$kw$actual,t__7637__auto___7863,cljs.core.cst$kw$message,null], null));
}
try{var values__7592__auto__ = (new cljs.core.List(null,((function (rdm_str){
return (function (p__7857){
var vec__7858 = p__7857;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7858,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7858,(1),null);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.crypto.normalize_string(k),fluree.crypto.normalize_string(v))) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(k,v)));
});})(rdm_str))
,(new cljs.core.List(null,fluree.crypto_test.composed_decomposed_map,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$and,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$v)),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$k,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$and,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$v)),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$k,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7856){var t__7637__auto__ = e7856;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$and,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_normalize_DASH_string,cljs.core.cst$sym$v)),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$k,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.normalize_string_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.normalize_string_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_normalize_DASH_string_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$normalize_DASH_string_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",31,1,36,36,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.normalize_string_test)?fluree.crypto_test.normalize_string_test.cljs$lang$test:null)]));
fluree.crypto_test.string__GT_byte_test = (function fluree$crypto_test$string__GT_byte_test(){
return cljs.test.test_var(fluree.crypto_test.string__GT_byte_test.cljs$lang$var);
});
fluree.crypto_test.string__GT_byte_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["String to byte conversions and back."], 0));

try{var rdm_strs = cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((10),(function (){
return fluree.crypto_test.random_string(cljs.core.rand_int((1000)));
}));
try{var values__7592__auto__ = (new cljs.core.List(null,((function (rdm_strs){
return (function (p1__7864_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__7864_SHARP_,fluree.crypto.byte_array__GT_string(fluree.crypto.string__GT_byte_array(p1__7864_SHARP_)));
});})(rdm_strs))
,(new cljs.core.List(null,rdm_strs,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7864_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$p1__7864_SHARP_,cljs.core.list(cljs.core.cst$sym$_DASH__GT_,cljs.core.cst$sym$p1__7864_SHARP_,cljs.core.cst$sym$crypto_SLASH_string_DASH__GT_byte_DASH_array,cljs.core.cst$sym$crypto_SLASH_byte_DASH_array_DASH__GT_string))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7864_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$p1__7864_SHARP_,cljs.core.list(cljs.core.cst$sym$_DASH__GT_,cljs.core.cst$sym$p1__7864_SHARP_,cljs.core.cst$sym$crypto_SLASH_string_DASH__GT_byte_DASH_array,cljs.core.cst$sym$crypto_SLASH_byte_DASH_array_DASH__GT_string))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7865){var t__7637__auto__ = e7865;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7864_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$p1__7864_SHARP_,cljs.core.list(cljs.core.cst$sym$_DASH__GT_,cljs.core.cst$sym$p1__7864_SHARP_,cljs.core.cst$sym$crypto_SLASH_string_DASH__GT_byte_DASH_array,cljs.core.cst$sym$crypto_SLASH_byte_DASH_array_DASH__GT_string))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.string__GT_byte_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.string__GT_byte_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_string_DASH__GT_byte_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$string_DASH__GT_byte_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",27,1,46,46,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.string__GT_byte_test)?fluree.crypto_test.string__GT_byte_test.cljs$lang$test:null)]));
fluree.crypto_test.sha2_256_test = (function fluree$crypto_test$sha2_256_test(){
return cljs.test.test_var(fluree.crypto_test.sha2_256_test.cljs$lang$var);
});
fluree.crypto_test.sha2_256_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["SHA2-256"], 0));

try{var rdm_strs = cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((10),(function (){
return fluree.crypto_test.random_string(cljs.core.rand_int((1000)));
}));
try{var values__7592__auto___7873 = (new cljs.core.List(null,((function (rdm_strs){
return (function (p1__7866_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((64),cljs.core.count(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1(p1__7866_SHARP_)));
});})(rdm_strs))
,(new cljs.core.List(null,rdm_strs,null,(1),null)),(2),null));
var result__7593__auto___7874 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto___7873);
if(cljs.core.truth_(result__7593__auto___7874)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7866_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(64),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$p1__7866_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto___7873),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7866_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(64),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$p1__7866_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto___7873),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

}catch (e7867){var t__7637__auto___7875 = e7867;
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7866_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(64),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$p1__7866_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,t__7637__auto___7875,cljs.core.cst$kw$message,null], null));
}
try{var values__7592__auto__ = (new cljs.core.List(null,((function (rdm_strs){
return (function (p__7869){
var vec__7870 = p__7869;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7870,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7870,(1),null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1(k),fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1(v));
});})(rdm_strs))
,(new cljs.core.List(null,fluree.crypto_test.composed_decomposed_map,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7868){var t__7637__auto__ = e7868;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.sha2_256_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.sha2_256_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_sha2_DASH_256_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$sha2_DASH_256_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",23,1,52,52,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.sha2_256_test)?fluree.crypto_test.sha2_256_test.cljs$lang$test:null)]));
fluree.crypto_test.sha2_256_normalize_test = (function fluree$crypto_test$sha2_256_normalize_test(){
return cljs.test.test_var(fluree.crypto_test.sha2_256_normalize_test.cljs$lang$var);
});
fluree.crypto_test.sha2_256_normalize_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["SHA2-256 normalize"], 0));

try{var rdm_strs = cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((10),(function (){
return fluree.crypto_test.random_string(cljs.core.rand_int((1000)));
}));
try{var values__7592__auto___7883 = (new cljs.core.List(null,((function (rdm_strs){
return (function (p1__7876_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((64),cljs.core.count(fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1(p1__7876_SHARP_)));
});})(rdm_strs))
,(new cljs.core.List(null,rdm_strs,null,(1),null)),(2),null));
var result__7593__auto___7884 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto___7883);
if(cljs.core.truth_(result__7593__auto___7884)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7876_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(64),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$p1__7876_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto___7883),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7876_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(64),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$p1__7876_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto___7883),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

}catch (e7877){var t__7637__auto___7885 = e7877;
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7876_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(64),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$p1__7876_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,t__7637__auto___7885,cljs.core.cst$kw$message,null], null));
}
try{var values__7592__auto__ = (new cljs.core.List(null,((function (rdm_strs){
return (function (p__7879){
var vec__7880 = p__7879;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7880,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7880,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1(k),fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1(v));
});})(rdm_strs))
,(new cljs.core.List(null,fluree.crypto_test.composed_decomposed_map,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7878){var t__7637__auto__ = e7878;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_256_DASH_normalize,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.sha2_256_normalize_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.sha2_256_normalize_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_sha2_DASH_256_DASH_normalize_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$sha2_DASH_256_DASH_normalize_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",33,1,62,62,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.sha2_256_normalize_test)?fluree.crypto_test.sha2_256_normalize_test.cljs$lang$test:null)]));
fluree.crypto_test.sha2_512_test = (function fluree$crypto_test$sha2_512_test(){
return cljs.test.test_var(fluree.crypto_test.sha2_512_test.cljs$lang$var);
});
fluree.crypto_test.sha2_512_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["SHA2-512"], 0));

try{var rdm_strs = cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((10),(function (){
return fluree.crypto_test.random_string(cljs.core.rand_int((1000)));
}));
try{var values__7592__auto___7893 = (new cljs.core.List(null,((function (rdm_strs){
return (function (p1__7886_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((128),cljs.core.count(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1(p1__7886_SHARP_)));
});})(rdm_strs))
,(new cljs.core.List(null,rdm_strs,null,(1),null)),(2),null));
var result__7593__auto___7894 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto___7893);
if(cljs.core.truth_(result__7593__auto___7894)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7886_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(128),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$p1__7886_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto___7893),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7886_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(128),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$p1__7886_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto___7893),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

}catch (e7887){var t__7637__auto___7895 = e7887;
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7886_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(128),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$p1__7886_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,t__7637__auto___7895,cljs.core.cst$kw$message,null], null));
}
try{var values__7592__auto__ = (new cljs.core.List(null,((function (rdm_strs){
return (function (p__7889){
var vec__7890 = p__7889;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7890,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7890,(1),null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1(k),fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1(v));
});})(rdm_strs))
,(new cljs.core.List(null,fluree.crypto_test.composed_decomposed_map,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7888){var t__7637__auto__ = e7888;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$not_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.sha2_512_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.sha2_512_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_sha2_DASH_512_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$sha2_DASH_512_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",23,1,72,72,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.sha2_512_test)?fluree.crypto_test.sha2_512_test.cljs$lang$test:null)]));
fluree.crypto_test.sha2_512_normalize_test = (function fluree$crypto_test$sha2_512_normalize_test(){
return cljs.test.test_var(fluree.crypto_test.sha2_512_normalize_test.cljs$lang$var);
});
fluree.crypto_test.sha2_512_normalize_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["SHA2-512 normalize"], 0));

try{var rdm_strs = cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((10),(function (){
return fluree.crypto_test.random_string(cljs.core.rand_int((1000)));
}));
try{var values__7592__auto___7903 = (new cljs.core.List(null,((function (rdm_strs){
return (function (p1__7896_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((128),cljs.core.count(fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1(p1__7896_SHARP_)));
});})(rdm_strs))
,(new cljs.core.List(null,rdm_strs,null,(1),null)),(2),null));
var result__7593__auto___7904 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto___7903);
if(cljs.core.truth_(result__7593__auto___7904)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7896_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(128),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$p1__7896_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto___7903),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7896_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(128),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$p1__7896_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto___7903),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

}catch (e7897){var t__7637__auto___7905 = e7897;
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p1__7896_SHARP_], null),cljs.core.list(cljs.core.cst$sym$_EQ_,(128),cljs.core.list(cljs.core.cst$sym$count,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$p1__7896_SHARP_)))),cljs.core.cst$sym$rdm_DASH_strs),cljs.core.cst$kw$actual,t__7637__auto___7905,cljs.core.cst$kw$message,null], null));
}
try{var values__7592__auto__ = (new cljs.core.List(null,((function (rdm_strs){
return (function (p__7899){
var vec__7900 = p__7899;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7900,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7900,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1(k),fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1(v));
});})(rdm_strs))
,(new cljs.core.List(null,fluree.crypto_test.composed_decomposed_map,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.every_QMARK_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core.every_QMARK_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$every_QMARK_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7898){var t__7637__auto__ = e7898;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$every_QMARK_,cljs.core.list(cljs.core.cst$sym$fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)], null),cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$k),cljs.core.list(cljs.core.cst$sym$crypto_SLASH_sha2_DASH_512_DASH_normalize,cljs.core.cst$sym$v))),cljs.core.cst$sym$composed_DASH_decomposed_DASH_map),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.sha2_512_normalize_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.sha2_512_normalize_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_sha2_DASH_512_DASH_normalize_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$sha2_DASH_512_DASH_normalize_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",33,1,82,82,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.sha2_512_normalize_test)?fluree.crypto_test.sha2_512_normalize_test.cljs$lang$test:null)]));
fluree.crypto_test.public_private_key_conversions = (function fluree$crypto_test$public_private_key_conversions(){
return cljs.test.test_var(fluree.crypto_test.public_private_key_conversions.cljs$lang$var);
});
fluree.crypto_test.public_private_key_conversions.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Private key returns the same public keys"], 0));

try{var kp_STAR_ = fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$0();
var public$ = (kp_STAR_["public"]);
var private$ = (kp_STAR_["private"]);
var public_SINGLEQUOTE_ = fluree.crypto.pub_key_from_private(private$);
try{var values__7592__auto__ = (new cljs.core.List(null,public$,(new cljs.core.List(null,public_SINGLEQUOTE_,null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$public,cljs.core.cst$sym$public_SINGLEQUOTE_),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core._EQ_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$public,cljs.core.cst$sym$public_SINGLEQUOTE_),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$_EQ_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7906){var t__7637__auto__ = e7906;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$public,cljs.core.cst$sym$public_SINGLEQUOTE_),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.public_private_key_conversions.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.public_private_key_conversions;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_public_DASH_private_DASH_key_DASH_conversions,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$public_DASH_private_DASH_key_DASH_conversions,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",40,1,92,92,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.public_private_key_conversions)?fluree.crypto_test.public_private_key_conversions.cljs$lang$test:null)]));
fluree.crypto_test.ripemd_160_test = (function fluree$crypto_test$ripemd_160_test(){
return cljs.test.test_var(fluree.crypto_test.ripemd_160_test.cljs$lang$var);
});
fluree.crypto_test.ripemd_160_test.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["RIPEMD-160 Hash"], 0));

try{try{var values__7592__auto__ = (new cljs.core.List(null,"ad6ce46f7f1ea8519dc02ce8ce0c278c6ff329b2",(new cljs.core.List(null,fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$1("hi there!"),null,(1),null)),(2),null));
var result__7593__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,values__7592__auto__);
if(cljs.core.truth_(result__7593__auto__)){
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$pass,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,"ad6ce46f7f1ea8519dc02ce8ce0c278c6ff329b2",cljs.core.list(cljs.core.cst$sym$crypto_SLASH_ripemd_DASH_160,"hi there!")),cljs.core.cst$kw$actual,cljs.core.cons(cljs.core._EQ_,values__7592__auto__),cljs.core.cst$kw$message,null], null));
} else {
cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$fail,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,"ad6ce46f7f1ea8519dc02ce8ce0c278c6ff329b2",cljs.core.list(cljs.core.cst$sym$crypto_SLASH_ripemd_DASH_160,"hi there!")),cljs.core.cst$kw$actual,(new cljs.core.List(null,cljs.core.cst$sym$not,(new cljs.core.List(null,cljs.core.cons(cljs.core.cst$sym$_EQ_,values__7592__auto__),null,(1),null)),(2),null)),cljs.core.cst$kw$message,null], null));
}

return result__7593__auto__;
}catch (e7907){var t__7637__auto__ = e7907;
return cljs.test.do_report(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$error,cljs.core.cst$kw$expected,cljs.core.list(cljs.core.cst$sym$_EQ_,"ad6ce46f7f1ea8519dc02ce8ce0c278c6ff329b2",cljs.core.list(cljs.core.cst$sym$crypto_SLASH_ripemd_DASH_160,"hi there!")),cljs.core.cst$kw$actual,t__7637__auto__,cljs.core.cst$kw$message,null], null));
}}finally {cljs.test.update_current_env_BANG_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$testing_DASH_contexts], null),cljs.core.rest);
}});

fluree.crypto_test.ripemd_160_test.cljs$lang$var = new cljs.core.Var(function(){return fluree.crypto_test.ripemd_160_test;},cljs.core.cst$sym$fluree$crypto_DASH_test_SLASH_ripemd_DASH_160_DASH_test,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$crypto_DASH_test,cljs.core.cst$sym$ripemd_DASH_160_DASH_test,"/Users/wmorgan/dev/fluree/fluree.crypto/test/fluree/crypto_test.cljc",25,1,104,104,cljs.core.List.EMPTY,null,(cljs.core.truth_(fluree.crypto_test.ripemd_160_test)?fluree.crypto_test.ripemd_160_test.cljs$lang$test:null)]));
