// Compiled by ClojureScript 1.10.520 {:static-fns false, :optimize-constants false}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.18";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && ((!((JSON.stringify == null))))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}catch (e28125){if((e28125 instanceof Error)){
var e = e28125;
return "Error: Unable to stringify";
} else {
throw e28125;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__28128 = arguments.length;
switch (G__28128) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__28126_SHARP_){
if(typeof p1__28126_SHARP_ === 'string'){
return p1__28126_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__28126_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___28131 = arguments.length;
var i__4731__auto___28132 = (0);
while(true){
if((i__4731__auto___28132 < len__4730__auto___28131)){
args__4736__auto__.push((arguments[i__4731__auto___28132]));

var G__28133 = (i__4731__auto___28132 + (1));
i__4731__auto___28132 = G__28133;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq28130){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28130));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___28135 = arguments.length;
var i__4731__auto___28136 = (0);
while(true){
if((i__4731__auto___28136 < len__4730__auto___28135)){
args__4736__auto__.push((arguments[i__4731__auto___28136]));

var G__28137 = (i__4731__auto___28136 + (1));
i__4731__auto___28136 = G__28137;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq28134){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28134));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),"Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",(cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF")].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__28138){
var map__28139 = p__28138;
var map__28139__$1 = (((((!((map__28139 == null))))?(((((map__28139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28139):map__28139);
var message = cljs.core.get.call(null,map__28139__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__28139__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__4131__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__4120__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__4120__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__4120__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__24123__auto___28218 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___28218,ch){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___28218,ch){
return (function (state_28190){
var state_val_28191 = (state_28190[(1)]);
if((state_val_28191 === (7))){
var inst_28186 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28192_28219 = state_28190__$1;
(statearr_28192_28219[(2)] = inst_28186);

(statearr_28192_28219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (1))){
var state_28190__$1 = state_28190;
var statearr_28193_28220 = state_28190__$1;
(statearr_28193_28220[(2)] = null);

(statearr_28193_28220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (4))){
var inst_28143 = (state_28190[(7)]);
var inst_28143__$1 = (state_28190[(2)]);
var state_28190__$1 = (function (){var statearr_28194 = state_28190;
(statearr_28194[(7)] = inst_28143__$1);

return statearr_28194;
})();
if(cljs.core.truth_(inst_28143__$1)){
var statearr_28195_28221 = state_28190__$1;
(statearr_28195_28221[(1)] = (5));

} else {
var statearr_28196_28222 = state_28190__$1;
(statearr_28196_28222[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (15))){
var inst_28150 = (state_28190[(8)]);
var inst_28165 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_28150);
var inst_28166 = cljs.core.first.call(null,inst_28165);
var inst_28167 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_28166);
var inst_28168 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28167)].join('');
var inst_28169 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_28168);
var state_28190__$1 = state_28190;
var statearr_28197_28223 = state_28190__$1;
(statearr_28197_28223[(2)] = inst_28169);

(statearr_28197_28223[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (13))){
var inst_28174 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28198_28224 = state_28190__$1;
(statearr_28198_28224[(2)] = inst_28174);

(statearr_28198_28224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (6))){
var state_28190__$1 = state_28190;
var statearr_28199_28225 = state_28190__$1;
(statearr_28199_28225[(2)] = null);

(statearr_28199_28225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (17))){
var inst_28172 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28200_28226 = state_28190__$1;
(statearr_28200_28226[(2)] = inst_28172);

(statearr_28200_28226[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (3))){
var inst_28188 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28190__$1,inst_28188);
} else {
if((state_val_28191 === (12))){
var inst_28149 = (state_28190[(9)]);
var inst_28163 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_28149,opts);
var state_28190__$1 = state_28190;
if(inst_28163){
var statearr_28201_28227 = state_28190__$1;
(statearr_28201_28227[(1)] = (15));

} else {
var statearr_28202_28228 = state_28190__$1;
(statearr_28202_28228[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (2))){
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28190__$1,(4),ch);
} else {
if((state_val_28191 === (11))){
var inst_28150 = (state_28190[(8)]);
var inst_28155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28156 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_28150);
var inst_28157 = cljs.core.async.timeout.call(null,(1000));
var inst_28158 = [inst_28156,inst_28157];
var inst_28159 = (new cljs.core.PersistentVector(null,2,(5),inst_28155,inst_28158,null));
var state_28190__$1 = state_28190;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28190__$1,(14),inst_28159);
} else {
if((state_val_28191 === (9))){
var inst_28150 = (state_28190[(8)]);
var inst_28176 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_28177 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_28150);
var inst_28178 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28177);
var inst_28179 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28178)].join('');
var inst_28180 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_28179);
var state_28190__$1 = (function (){var statearr_28203 = state_28190;
(statearr_28203[(10)] = inst_28176);

return statearr_28203;
})();
var statearr_28204_28229 = state_28190__$1;
(statearr_28204_28229[(2)] = inst_28180);

(statearr_28204_28229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (5))){
var inst_28143 = (state_28190[(7)]);
var inst_28145 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_28146 = (new cljs.core.PersistentArrayMap(null,2,inst_28145,null));
var inst_28147 = (new cljs.core.PersistentHashSet(null,inst_28146,null));
var inst_28148 = figwheel.client.focus_msgs.call(null,inst_28147,inst_28143);
var inst_28149 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_28148);
var inst_28150 = cljs.core.first.call(null,inst_28148);
var inst_28151 = figwheel.client.autoload_QMARK_.call(null);
var state_28190__$1 = (function (){var statearr_28205 = state_28190;
(statearr_28205[(8)] = inst_28150);

(statearr_28205[(9)] = inst_28149);

return statearr_28205;
})();
if(cljs.core.truth_(inst_28151)){
var statearr_28206_28230 = state_28190__$1;
(statearr_28206_28230[(1)] = (8));

} else {
var statearr_28207_28231 = state_28190__$1;
(statearr_28207_28231[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (14))){
var inst_28161 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28208_28232 = state_28190__$1;
(statearr_28208_28232[(2)] = inst_28161);

(statearr_28208_28232[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (16))){
var state_28190__$1 = state_28190;
var statearr_28209_28233 = state_28190__$1;
(statearr_28209_28233[(2)] = null);

(statearr_28209_28233[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (10))){
var inst_28182 = (state_28190[(2)]);
var state_28190__$1 = (function (){var statearr_28210 = state_28190;
(statearr_28210[(11)] = inst_28182);

return statearr_28210;
})();
var statearr_28211_28234 = state_28190__$1;
(statearr_28211_28234[(2)] = null);

(statearr_28211_28234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (8))){
var inst_28149 = (state_28190[(9)]);
var inst_28153 = figwheel.client.reload_file_state_QMARK_.call(null,inst_28149,opts);
var state_28190__$1 = state_28190;
if(cljs.core.truth_(inst_28153)){
var statearr_28212_28235 = state_28190__$1;
(statearr_28212_28235[(1)] = (11));

} else {
var statearr_28213_28236 = state_28190__$1;
(statearr_28213_28236[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___28218,ch))
;
return ((function (switch__24028__auto__,c__24123__auto___28218,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__24029__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__24029__auto____0 = (function (){
var statearr_28214 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28214[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__24029__auto__);

(statearr_28214[(1)] = (1));

return statearr_28214;
});
var figwheel$client$file_reloader_plugin_$_state_machine__24029__auto____1 = (function (state_28190){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_28190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e28215){if((e28215 instanceof Object)){
var ex__24032__auto__ = e28215;
var statearr_28216_28237 = state_28190;
(statearr_28216_28237[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28215;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28238 = state_28190;
state_28190 = G__28238;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__24029__auto__ = function(state_28190){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__24029__auto____1.call(this,state_28190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__24029__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__24029__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___28218,ch))
})();
var state__24125__auto__ = (function (){var statearr_28217 = f__24124__auto__.call(null);
(statearr_28217[(6)] = c__24123__auto___28218);

return statearr_28217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___28218,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__28239_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__28239_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(figwheel.client.utils.node_env_QMARK_.call(null)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_28245 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_28245){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__28241 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__28242 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__28243 = true;
var _STAR_print_fn_STAR__temp_val__28244 = ((function (_STAR_print_newline_STAR__orig_val__28241,_STAR_print_fn_STAR__orig_val__28242,_STAR_print_newline_STAR__temp_val__28243,sb,base_path_28245){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR__orig_val__28241,_STAR_print_fn_STAR__orig_val__28242,_STAR_print_newline_STAR__temp_val__28243,sb,base_path_28245))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__28243;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__28244;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
var result_value__$1 = (((!(typeof result_value === 'string')))?cljs.core.pr_str.call(null,result_value):result_value);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value__$1], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__28242;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__28241;
}}catch (e28240){if((e28240 instanceof Error)){
var e = e28240;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_28245], null));
} else {
var e = e28240;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_28245))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__28246){
var map__28247 = p__28246;
var map__28247__$1 = (((((!((map__28247 == null))))?(((((map__28247.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28247.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28247):map__28247);
var opts = map__28247__$1;
var build_id = cljs.core.get.call(null,map__28247__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__28247,map__28247__$1,opts,build_id){
return (function (p__28249){
var vec__28250 = p__28249;
var seq__28251 = cljs.core.seq.call(null,vec__28250);
var first__28252 = cljs.core.first.call(null,seq__28251);
var seq__28251__$1 = cljs.core.next.call(null,seq__28251);
var map__28253 = first__28252;
var map__28253__$1 = (((((!((map__28253 == null))))?(((((map__28253.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28253.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28253):map__28253);
var msg = map__28253__$1;
var msg_name = cljs.core.get.call(null,map__28253__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__28251__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__28250,seq__28251,first__28252,seq__28251__$1,map__28253,map__28253__$1,msg,msg_name,_,map__28247,map__28247__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__28250,seq__28251,first__28252,seq__28251__$1,map__28253,map__28253__$1,msg,msg_name,_,map__28247,map__28247__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__28247,map__28247__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__28255){
var vec__28256 = p__28255;
var seq__28257 = cljs.core.seq.call(null,vec__28256);
var first__28258 = cljs.core.first.call(null,seq__28257);
var seq__28257__$1 = cljs.core.next.call(null,seq__28257);
var map__28259 = first__28258;
var map__28259__$1 = (((((!((map__28259 == null))))?(((((map__28259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28259.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28259):map__28259);
var msg = map__28259__$1;
var msg_name = cljs.core.get.call(null,map__28259__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__28257__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__28261){
var map__28262 = p__28261;
var map__28262__$1 = (((((!((map__28262 == null))))?(((((map__28262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28262):map__28262);
var on_compile_warning = cljs.core.get.call(null,map__28262__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__28262__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__28262,map__28262__$1,on_compile_warning,on_compile_fail){
return (function (p__28264){
var vec__28265 = p__28264;
var seq__28266 = cljs.core.seq.call(null,vec__28265);
var first__28267 = cljs.core.first.call(null,seq__28266);
var seq__28266__$1 = cljs.core.next.call(null,seq__28266);
var map__28268 = first__28267;
var map__28268__$1 = (((((!((map__28268 == null))))?(((((map__28268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28268):map__28268);
var msg = map__28268__$1;
var msg_name = cljs.core.get.call(null,map__28268__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__28266__$1;
var pred__28270 = cljs.core._EQ_;
var expr__28271 = msg_name;
if(cljs.core.truth_(pred__28270.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__28271))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__28270.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__28271))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__28262,map__28262__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__,msg_hist,msg_names,msg){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__,msg_hist,msg_names,msg){
return (function (state_28360){
var state_val_28361 = (state_28360[(1)]);
if((state_val_28361 === (7))){
var inst_28280 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
if(cljs.core.truth_(inst_28280)){
var statearr_28362_28409 = state_28360__$1;
(statearr_28362_28409[(1)] = (8));

} else {
var statearr_28363_28410 = state_28360__$1;
(statearr_28363_28410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (20))){
var inst_28354 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28364_28411 = state_28360__$1;
(statearr_28364_28411[(2)] = inst_28354);

(statearr_28364_28411[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (27))){
var inst_28350 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28365_28412 = state_28360__$1;
(statearr_28365_28412[(2)] = inst_28350);

(statearr_28365_28412[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (1))){
var inst_28273 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_28360__$1 = state_28360;
if(cljs.core.truth_(inst_28273)){
var statearr_28366_28413 = state_28360__$1;
(statearr_28366_28413[(1)] = (2));

} else {
var statearr_28367_28414 = state_28360__$1;
(statearr_28367_28414[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (24))){
var inst_28352 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28368_28415 = state_28360__$1;
(statearr_28368_28415[(2)] = inst_28352);

(statearr_28368_28415[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (4))){
var inst_28358 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28360__$1,inst_28358);
} else {
if((state_val_28361 === (15))){
var inst_28356 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28369_28416 = state_28360__$1;
(statearr_28369_28416[(2)] = inst_28356);

(statearr_28369_28416[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (21))){
var inst_28309 = (state_28360[(2)]);
var inst_28310 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28311 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28310);
var state_28360__$1 = (function (){var statearr_28370 = state_28360;
(statearr_28370[(7)] = inst_28309);

return statearr_28370;
})();
var statearr_28371_28417 = state_28360__$1;
(statearr_28371_28417[(2)] = inst_28311);

(statearr_28371_28417[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (31))){
var inst_28339 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_28360__$1 = state_28360;
if(inst_28339){
var statearr_28372_28418 = state_28360__$1;
(statearr_28372_28418[(1)] = (34));

} else {
var statearr_28373_28419 = state_28360__$1;
(statearr_28373_28419[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (32))){
var inst_28348 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28374_28420 = state_28360__$1;
(statearr_28374_28420[(2)] = inst_28348);

(statearr_28374_28420[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (33))){
var inst_28335 = (state_28360[(2)]);
var inst_28336 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28337 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28336);
var state_28360__$1 = (function (){var statearr_28375 = state_28360;
(statearr_28375[(8)] = inst_28335);

return statearr_28375;
})();
var statearr_28376_28421 = state_28360__$1;
(statearr_28376_28421[(2)] = inst_28337);

(statearr_28376_28421[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (13))){
var inst_28294 = figwheel.client.heads_up.clear.call(null);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(16),inst_28294);
} else {
if((state_val_28361 === (22))){
var inst_28315 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28316 = figwheel.client.heads_up.append_warning_message.call(null,inst_28315);
var state_28360__$1 = state_28360;
var statearr_28377_28422 = state_28360__$1;
(statearr_28377_28422[(2)] = inst_28316);

(statearr_28377_28422[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (36))){
var inst_28346 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28378_28423 = state_28360__$1;
(statearr_28378_28423[(2)] = inst_28346);

(statearr_28378_28423[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (29))){
var inst_28326 = (state_28360[(2)]);
var inst_28327 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28328 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28327);
var state_28360__$1 = (function (){var statearr_28379 = state_28360;
(statearr_28379[(9)] = inst_28326);

return statearr_28379;
})();
var statearr_28380_28424 = state_28360__$1;
(statearr_28380_28424[(2)] = inst_28328);

(statearr_28380_28424[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (6))){
var inst_28275 = (state_28360[(10)]);
var state_28360__$1 = state_28360;
var statearr_28381_28425 = state_28360__$1;
(statearr_28381_28425[(2)] = inst_28275);

(statearr_28381_28425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (28))){
var inst_28322 = (state_28360[(2)]);
var inst_28323 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28324 = figwheel.client.heads_up.display_warning.call(null,inst_28323);
var state_28360__$1 = (function (){var statearr_28382 = state_28360;
(statearr_28382[(11)] = inst_28322);

return statearr_28382;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(29),inst_28324);
} else {
if((state_val_28361 === (25))){
var inst_28320 = figwheel.client.heads_up.clear.call(null);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(28),inst_28320);
} else {
if((state_val_28361 === (34))){
var inst_28341 = figwheel.client.heads_up.flash_loaded.call(null);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(37),inst_28341);
} else {
if((state_val_28361 === (17))){
var inst_28300 = (state_28360[(2)]);
var inst_28301 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28302 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28301);
var state_28360__$1 = (function (){var statearr_28383 = state_28360;
(statearr_28383[(12)] = inst_28300);

return statearr_28383;
})();
var statearr_28384_28426 = state_28360__$1;
(statearr_28384_28426[(2)] = inst_28302);

(statearr_28384_28426[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (3))){
var inst_28292 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_28360__$1 = state_28360;
if(inst_28292){
var statearr_28385_28427 = state_28360__$1;
(statearr_28385_28427[(1)] = (13));

} else {
var statearr_28386_28428 = state_28360__$1;
(statearr_28386_28428[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (12))){
var inst_28288 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28387_28429 = state_28360__$1;
(statearr_28387_28429[(2)] = inst_28288);

(statearr_28387_28429[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (2))){
var inst_28275 = (state_28360[(10)]);
var inst_28275__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_28360__$1 = (function (){var statearr_28388 = state_28360;
(statearr_28388[(10)] = inst_28275__$1);

return statearr_28388;
})();
if(cljs.core.truth_(inst_28275__$1)){
var statearr_28389_28430 = state_28360__$1;
(statearr_28389_28430[(1)] = (5));

} else {
var statearr_28390_28431 = state_28360__$1;
(statearr_28390_28431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (23))){
var inst_28318 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_28360__$1 = state_28360;
if(inst_28318){
var statearr_28391_28432 = state_28360__$1;
(statearr_28391_28432[(1)] = (25));

} else {
var statearr_28392_28433 = state_28360__$1;
(statearr_28392_28433[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (35))){
var state_28360__$1 = state_28360;
var statearr_28393_28434 = state_28360__$1;
(statearr_28393_28434[(2)] = null);

(statearr_28393_28434[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (19))){
var inst_28313 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_28360__$1 = state_28360;
if(inst_28313){
var statearr_28394_28435 = state_28360__$1;
(statearr_28394_28435[(1)] = (22));

} else {
var statearr_28395_28436 = state_28360__$1;
(statearr_28395_28436[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (11))){
var inst_28284 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28396_28437 = state_28360__$1;
(statearr_28396_28437[(2)] = inst_28284);

(statearr_28396_28437[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (9))){
var inst_28286 = figwheel.client.heads_up.clear.call(null);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(12),inst_28286);
} else {
if((state_val_28361 === (5))){
var inst_28277 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_28360__$1 = state_28360;
var statearr_28397_28438 = state_28360__$1;
(statearr_28397_28438[(2)] = inst_28277);

(statearr_28397_28438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (14))){
var inst_28304 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_28360__$1 = state_28360;
if(inst_28304){
var statearr_28398_28439 = state_28360__$1;
(statearr_28398_28439[(1)] = (18));

} else {
var statearr_28399_28440 = state_28360__$1;
(statearr_28399_28440[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (26))){
var inst_28330 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_28360__$1 = state_28360;
if(inst_28330){
var statearr_28400_28441 = state_28360__$1;
(statearr_28400_28441[(1)] = (30));

} else {
var statearr_28401_28442 = state_28360__$1;
(statearr_28401_28442[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (16))){
var inst_28296 = (state_28360[(2)]);
var inst_28297 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28298 = figwheel.client.heads_up.display_exception.call(null,inst_28297);
var state_28360__$1 = (function (){var statearr_28402 = state_28360;
(statearr_28402[(13)] = inst_28296);

return statearr_28402;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(17),inst_28298);
} else {
if((state_val_28361 === (30))){
var inst_28332 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28333 = figwheel.client.heads_up.display_warning.call(null,inst_28332);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(33),inst_28333);
} else {
if((state_val_28361 === (10))){
var inst_28290 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28403_28443 = state_28360__$1;
(statearr_28403_28443[(2)] = inst_28290);

(statearr_28403_28443[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (18))){
var inst_28306 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28307 = figwheel.client.heads_up.display_exception.call(null,inst_28306);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(21),inst_28307);
} else {
if((state_val_28361 === (37))){
var inst_28343 = (state_28360[(2)]);
var state_28360__$1 = state_28360;
var statearr_28404_28444 = state_28360__$1;
(statearr_28404_28444[(2)] = inst_28343);

(statearr_28404_28444[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28361 === (8))){
var inst_28282 = figwheel.client.heads_up.flash_loaded.call(null);
var state_28360__$1 = state_28360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28360__$1,(11),inst_28282);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__24028__auto__,c__24123__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto____0 = (function (){
var statearr_28405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28405[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto__);

(statearr_28405[(1)] = (1));

return statearr_28405;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto____1 = (function (state_28360){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_28360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e28406){if((e28406 instanceof Object)){
var ex__24032__auto__ = e28406;
var statearr_28407_28445 = state_28360;
(statearr_28407_28445[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28406;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28446 = state_28360;
state_28360 = G__28446;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto__ = function(state_28360){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto____1.call(this,state_28360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__,msg_hist,msg_names,msg))
})();
var state__24125__auto__ = (function (){var statearr_28408 = f__24124__auto__.call(null);
(statearr_28408[(6)] = c__24123__auto__);

return statearr_28408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__,msg_hist,msg_names,msg))
);

return c__24123__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__24123__auto___28475 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___28475,ch){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___28475,ch){
return (function (state_28461){
var state_val_28462 = (state_28461[(1)]);
if((state_val_28462 === (1))){
var state_28461__$1 = state_28461;
var statearr_28463_28476 = state_28461__$1;
(statearr_28463_28476[(2)] = null);

(statearr_28463_28476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (2))){
var state_28461__$1 = state_28461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28461__$1,(4),ch);
} else {
if((state_val_28462 === (3))){
var inst_28459 = (state_28461[(2)]);
var state_28461__$1 = state_28461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28461__$1,inst_28459);
} else {
if((state_val_28462 === (4))){
var inst_28449 = (state_28461[(7)]);
var inst_28449__$1 = (state_28461[(2)]);
var state_28461__$1 = (function (){var statearr_28464 = state_28461;
(statearr_28464[(7)] = inst_28449__$1);

return statearr_28464;
})();
if(cljs.core.truth_(inst_28449__$1)){
var statearr_28465_28477 = state_28461__$1;
(statearr_28465_28477[(1)] = (5));

} else {
var statearr_28466_28478 = state_28461__$1;
(statearr_28466_28478[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (5))){
var inst_28449 = (state_28461[(7)]);
var inst_28451 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_28449);
var state_28461__$1 = state_28461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28461__$1,(8),inst_28451);
} else {
if((state_val_28462 === (6))){
var state_28461__$1 = state_28461;
var statearr_28467_28479 = state_28461__$1;
(statearr_28467_28479[(2)] = null);

(statearr_28467_28479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (7))){
var inst_28457 = (state_28461[(2)]);
var state_28461__$1 = state_28461;
var statearr_28468_28480 = state_28461__$1;
(statearr_28468_28480[(2)] = inst_28457);

(statearr_28468_28480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (8))){
var inst_28453 = (state_28461[(2)]);
var state_28461__$1 = (function (){var statearr_28469 = state_28461;
(statearr_28469[(8)] = inst_28453);

return statearr_28469;
})();
var statearr_28470_28481 = state_28461__$1;
(statearr_28470_28481[(2)] = null);

(statearr_28470_28481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__24123__auto___28475,ch))
;
return ((function (switch__24028__auto__,c__24123__auto___28475,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__24029__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__24029__auto____0 = (function (){
var statearr_28471 = [null,null,null,null,null,null,null,null,null];
(statearr_28471[(0)] = figwheel$client$heads_up_plugin_$_state_machine__24029__auto__);

(statearr_28471[(1)] = (1));

return statearr_28471;
});
var figwheel$client$heads_up_plugin_$_state_machine__24029__auto____1 = (function (state_28461){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_28461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e28472){if((e28472 instanceof Object)){
var ex__24032__auto__ = e28472;
var statearr_28473_28482 = state_28461;
(statearr_28473_28482[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28461);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28472;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28483 = state_28461;
state_28461 = G__28483;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__24029__auto__ = function(state_28461){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__24029__auto____1.call(this,state_28461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__24029__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__24029__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___28475,ch))
})();
var state__24125__auto__ = (function (){var statearr_28474 = f__24124__auto__.call(null);
(statearr_28474[(6)] = c__24123__auto___28475);

return statearr_28474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___28475,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__){
return (function (state_28489){
var state_val_28490 = (state_28489[(1)]);
if((state_val_28490 === (1))){
var inst_28484 = cljs.core.async.timeout.call(null,(3000));
var state_28489__$1 = state_28489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28489__$1,(2),inst_28484);
} else {
if((state_val_28490 === (2))){
var inst_28486 = (state_28489[(2)]);
var inst_28487 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_28489__$1 = (function (){var statearr_28491 = state_28489;
(statearr_28491[(7)] = inst_28486);

return statearr_28491;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28489__$1,inst_28487);
} else {
return null;
}
}
});})(c__24123__auto__))
;
return ((function (switch__24028__auto__,c__24123__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__24029__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__24029__auto____0 = (function (){
var statearr_28492 = [null,null,null,null,null,null,null,null];
(statearr_28492[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__24029__auto__);

(statearr_28492[(1)] = (1));

return statearr_28492;
});
var figwheel$client$enforce_project_plugin_$_state_machine__24029__auto____1 = (function (state_28489){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_28489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e28493){if((e28493 instanceof Object)){
var ex__24032__auto__ = e28493;
var statearr_28494_28496 = state_28489;
(statearr_28494_28496[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28489);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28493;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28497 = state_28489;
state_28489 = G__28497;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__24029__auto__ = function(state_28489){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__24029__auto____1.call(this,state_28489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__24029__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__24029__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__))
})();
var state__24125__auto__ = (function (){var statearr_28495 = f__24124__auto__.call(null);
(statearr_28495[(6)] = c__24123__auto__);

return statearr_28495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__))
);

return c__24123__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5735__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5735__auto__)){
var figwheel_version = temp__5735__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__,figwheel_version,temp__5735__auto__){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__,figwheel_version,temp__5735__auto__){
return (function (state_28504){
var state_val_28505 = (state_28504[(1)]);
if((state_val_28505 === (1))){
var inst_28498 = cljs.core.async.timeout.call(null,(2000));
var state_28504__$1 = state_28504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28504__$1,(2),inst_28498);
} else {
if((state_val_28505 === (2))){
var inst_28500 = (state_28504[(2)]);
var inst_28501 = ["Figwheel Client Version <strong>",figwheel.client._figwheel_version_,"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_28502 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_28501);
var state_28504__$1 = (function (){var statearr_28506 = state_28504;
(statearr_28506[(7)] = inst_28500);

return statearr_28506;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28504__$1,inst_28502);
} else {
return null;
}
}
});})(c__24123__auto__,figwheel_version,temp__5735__auto__))
;
return ((function (switch__24028__auto__,c__24123__auto__,figwheel_version,temp__5735__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto____0 = (function (){
var statearr_28507 = [null,null,null,null,null,null,null,null];
(statearr_28507[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto__);

(statearr_28507[(1)] = (1));

return statearr_28507;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto____1 = (function (state_28504){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_28504);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e28508){if((e28508 instanceof Object)){
var ex__24032__auto__ = e28508;
var statearr_28509_28511 = state_28504;
(statearr_28509_28511[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28504);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28512 = state_28504;
state_28504 = G__28512;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto__ = function(state_28504){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto____1.call(this,state_28504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__,figwheel_version,temp__5735__auto__))
})();
var state__24125__auto__ = (function (){var statearr_28510 = f__24124__auto__.call(null);
(statearr_28510[(6)] = c__24123__auto__);

return statearr_28510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__,figwheel_version,temp__5735__auto__))
);

return c__24123__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__28513){
var map__28514 = p__28513;
var map__28514__$1 = (((((!((map__28514 == null))))?(((((map__28514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28514):map__28514);
var file = cljs.core.get.call(null,map__28514__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__28514__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__28514__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__28516 = "";
var G__28516__$1 = (cljs.core.truth_(file)?[G__28516,"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__28516);
var G__28516__$2 = (cljs.core.truth_(line)?[G__28516__$1," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__28516__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = line;
if(cljs.core.truth_(and__4120__auto__)){
return column;
} else {
return and__4120__auto__;
}
})())){
return [G__28516__$2,", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__28516__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__28517){
var map__28518 = p__28517;
var map__28518__$1 = (((((!((map__28518 == null))))?(((((map__28518.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28518.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28518):map__28518);
var ed = map__28518__$1;
var exception_data = cljs.core.get.call(null,map__28518__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__28518__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
var message_28521 = (function (){var G__28520 = cljs.core.apply.call(null,cljs.core.str,"Figwheel: Compile Exception ",figwheel.client.format_messages.call(null,exception_data));
if(cljs.core.truth_(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(exception_data))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28520)," Error on ",figwheel.client.file_line_column.call(null,exception_data)].join('');
} else {
return G__28520;
}
})();
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),message_28521);

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__28522){
var map__28523 = p__28522;
var map__28523__$1 = (((((!((map__28523 == null))))?(((((map__28523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28523):map__28523);
var w = map__28523__$1;
var message = cljs.core.get.call(null,map__28523__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",figwheel.client.file_line_column.call(null,message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,362,362,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(figwheel.client.utils.html_env_QMARK_.call(null)){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = (((!(figwheel.client.utils.html_env_QMARK_.call(null))))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__4120__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__28525 = cljs.core.seq.call(null,plugins);
var chunk__28526 = null;
var count__28527 = (0);
var i__28528 = (0);
while(true){
if((i__28528 < count__28527)){
var vec__28535 = cljs.core._nth.call(null,chunk__28526,i__28528);
var k = cljs.core.nth.call(null,vec__28535,(0),null);
var plugin = cljs.core.nth.call(null,vec__28535,(1),null);
if(cljs.core.truth_(plugin)){
var pl_28541 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__28525,chunk__28526,count__28527,i__28528,pl_28541,vec__28535,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_28541.call(null,msg_hist);
});})(seq__28525,chunk__28526,count__28527,i__28528,pl_28541,vec__28535,k,plugin))
);
} else {
}


var G__28542 = seq__28525;
var G__28543 = chunk__28526;
var G__28544 = count__28527;
var G__28545 = (i__28528 + (1));
seq__28525 = G__28542;
chunk__28526 = G__28543;
count__28527 = G__28544;
i__28528 = G__28545;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__28525);
if(temp__5735__auto__){
var seq__28525__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28525__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__28525__$1);
var G__28546 = cljs.core.chunk_rest.call(null,seq__28525__$1);
var G__28547 = c__4550__auto__;
var G__28548 = cljs.core.count.call(null,c__4550__auto__);
var G__28549 = (0);
seq__28525 = G__28546;
chunk__28526 = G__28547;
count__28527 = G__28548;
i__28528 = G__28549;
continue;
} else {
var vec__28538 = cljs.core.first.call(null,seq__28525__$1);
var k = cljs.core.nth.call(null,vec__28538,(0),null);
var plugin = cljs.core.nth.call(null,vec__28538,(1),null);
if(cljs.core.truth_(plugin)){
var pl_28550 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__28525,chunk__28526,count__28527,i__28528,pl_28550,vec__28538,k,plugin,seq__28525__$1,temp__5735__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_28550.call(null,msg_hist);
});})(seq__28525,chunk__28526,count__28527,i__28528,pl_28550,vec__28538,k,plugin,seq__28525__$1,temp__5735__auto__))
);
} else {
}


var G__28551 = cljs.core.next.call(null,seq__28525__$1);
var G__28552 = null;
var G__28553 = (0);
var G__28554 = (0);
seq__28525 = G__28551;
chunk__28526 = G__28552;
count__28527 = G__28553;
i__28528 = G__28554;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__28556 = arguments.length;
switch (G__28556) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__28557_28562 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__28558_28563 = null;
var count__28559_28564 = (0);
var i__28560_28565 = (0);
while(true){
if((i__28560_28565 < count__28559_28564)){
var msg_28566 = cljs.core._nth.call(null,chunk__28558_28563,i__28560_28565);
figwheel.client.socket.handle_incoming_message.call(null,msg_28566);


var G__28567 = seq__28557_28562;
var G__28568 = chunk__28558_28563;
var G__28569 = count__28559_28564;
var G__28570 = (i__28560_28565 + (1));
seq__28557_28562 = G__28567;
chunk__28558_28563 = G__28568;
count__28559_28564 = G__28569;
i__28560_28565 = G__28570;
continue;
} else {
var temp__5735__auto___28571 = cljs.core.seq.call(null,seq__28557_28562);
if(temp__5735__auto___28571){
var seq__28557_28572__$1 = temp__5735__auto___28571;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28557_28572__$1)){
var c__4550__auto___28573 = cljs.core.chunk_first.call(null,seq__28557_28572__$1);
var G__28574 = cljs.core.chunk_rest.call(null,seq__28557_28572__$1);
var G__28575 = c__4550__auto___28573;
var G__28576 = cljs.core.count.call(null,c__4550__auto___28573);
var G__28577 = (0);
seq__28557_28562 = G__28574;
chunk__28558_28563 = G__28575;
count__28559_28564 = G__28576;
i__28560_28565 = G__28577;
continue;
} else {
var msg_28578 = cljs.core.first.call(null,seq__28557_28572__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_28578);


var G__28579 = cljs.core.next.call(null,seq__28557_28572__$1);
var G__28580 = null;
var G__28581 = (0);
var G__28582 = (0);
seq__28557_28562 = G__28579;
chunk__28558_28563 = G__28580;
count__28559_28564 = G__28581;
i__28560_28565 = G__28582;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4736__auto__ = [];
var len__4730__auto___28587 = arguments.length;
var i__4731__auto___28588 = (0);
while(true){
if((i__4731__auto___28588 < len__4730__auto___28587)){
args__4736__auto__.push((arguments[i__4731__auto___28588]));

var G__28589 = (i__4731__auto___28588 + (1));
i__4731__auto___28588 = G__28589;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__28584){
var map__28585 = p__28584;
var map__28585__$1 = (((((!((map__28585 == null))))?(((((map__28585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28585):map__28585);
var opts = map__28585__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq28583){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28583));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e28590){if((e28590 instanceof Error)){
var e = e28590;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e28590;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__28591){
var map__28592 = p__28591;
var map__28592__$1 = (((((!((map__28592 == null))))?(((((map__28592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28592.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28592):map__28592);
var msg_name = cljs.core.get.call(null,map__28592__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1571424880560
