// Compiled by ClojureScript 1.10.520 {:static-fns false, :optimize-constants false}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__4131__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__4131__auto__){
return or__4131__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__4131__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__26238_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__26238_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__26239 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__26240 = null;
var count__26241 = (0);
var i__26242 = (0);
while(true){
if((i__26242 < count__26241)){
var n = cljs.core._nth.call(null,chunk__26240,i__26242);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__26243 = seq__26239;
var G__26244 = chunk__26240;
var G__26245 = count__26241;
var G__26246 = (i__26242 + (1));
seq__26239 = G__26243;
chunk__26240 = G__26244;
count__26241 = G__26245;
i__26242 = G__26246;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__26239);
if(temp__5735__auto__){
var seq__26239__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26239__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__26239__$1);
var G__26247 = cljs.core.chunk_rest.call(null,seq__26239__$1);
var G__26248 = c__4550__auto__;
var G__26249 = cljs.core.count.call(null,c__4550__auto__);
var G__26250 = (0);
seq__26239 = G__26247;
chunk__26240 = G__26248;
count__26241 = G__26249;
i__26242 = G__26250;
continue;
} else {
var n = cljs.core.first.call(null,seq__26239__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__26251 = cljs.core.next.call(null,seq__26239__$1);
var G__26252 = null;
var G__26253 = (0);
var G__26254 = (0);
seq__26239 = G__26251;
chunk__26240 = G__26252;
count__26241 = G__26253;
i__26242 = G__26254;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__26255){
var vec__26256 = p__26255;
var _ = cljs.core.nth.call(null,vec__26256,(0),null);
var v = cljs.core.nth.call(null,vec__26256,(1),null);
var and__4120__auto__ = v;
if(cljs.core.truth_(and__4120__auto__)){
return v.call(null,dep);
} else {
return and__4120__auto__;
}
}),cljs.core.filter.call(null,(function (p__26259){
var vec__26260 = p__26259;
var k = cljs.core.nth.call(null,vec__26260,(0),null);
var v = cljs.core.nth.call(null,vec__26260,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__26272_26280 = cljs.core.seq.call(null,deps);
var chunk__26273_26281 = null;
var count__26274_26282 = (0);
var i__26275_26283 = (0);
while(true){
if((i__26275_26283 < count__26274_26282)){
var dep_26284 = cljs.core._nth.call(null,chunk__26273_26281,i__26275_26283);
if(cljs.core.truth_((function (){var and__4120__auto__ = dep_26284;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_26284));
} else {
return and__4120__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_26284,(depth + (1)),state);
} else {
}


var G__26285 = seq__26272_26280;
var G__26286 = chunk__26273_26281;
var G__26287 = count__26274_26282;
var G__26288 = (i__26275_26283 + (1));
seq__26272_26280 = G__26285;
chunk__26273_26281 = G__26286;
count__26274_26282 = G__26287;
i__26275_26283 = G__26288;
continue;
} else {
var temp__5735__auto___26289 = cljs.core.seq.call(null,seq__26272_26280);
if(temp__5735__auto___26289){
var seq__26272_26290__$1 = temp__5735__auto___26289;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26272_26290__$1)){
var c__4550__auto___26291 = cljs.core.chunk_first.call(null,seq__26272_26290__$1);
var G__26292 = cljs.core.chunk_rest.call(null,seq__26272_26290__$1);
var G__26293 = c__4550__auto___26291;
var G__26294 = cljs.core.count.call(null,c__4550__auto___26291);
var G__26295 = (0);
seq__26272_26280 = G__26292;
chunk__26273_26281 = G__26293;
count__26274_26282 = G__26294;
i__26275_26283 = G__26295;
continue;
} else {
var dep_26296 = cljs.core.first.call(null,seq__26272_26290__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = dep_26296;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_26296));
} else {
return and__4120__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_26296,(depth + (1)),state);
} else {
}


var G__26297 = cljs.core.next.call(null,seq__26272_26290__$1);
var G__26298 = null;
var G__26299 = (0);
var G__26300 = (0);
seq__26272_26280 = G__26297;
chunk__26273_26281 = G__26298;
count__26274_26282 = G__26299;
i__26275_26283 = G__26300;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__26276){
var vec__26277 = p__26276;
var seq__26278 = cljs.core.seq.call(null,vec__26277);
var first__26279 = cljs.core.first.call(null,seq__26278);
var seq__26278__$1 = cljs.core.next.call(null,seq__26278);
var x = first__26279;
var xs = seq__26278__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__26277,seq__26278,first__26279,seq__26278__$1,x,xs,get_deps__$1){
return (function (p1__26263_SHARP_){
return clojure.set.difference.call(null,p1__26263_SHARP_,x);
});})(vec__26277,seq__26278,first__26279,seq__26278__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__26301 = cljs.core.seq.call(null,provides);
var chunk__26302 = null;
var count__26303 = (0);
var i__26304 = (0);
while(true){
if((i__26304 < count__26303)){
var prov = cljs.core._nth.call(null,chunk__26302,i__26304);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26313_26321 = cljs.core.seq.call(null,requires);
var chunk__26314_26322 = null;
var count__26315_26323 = (0);
var i__26316_26324 = (0);
while(true){
if((i__26316_26324 < count__26315_26323)){
var req_26325 = cljs.core._nth.call(null,chunk__26314_26322,i__26316_26324);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26325,prov);


var G__26326 = seq__26313_26321;
var G__26327 = chunk__26314_26322;
var G__26328 = count__26315_26323;
var G__26329 = (i__26316_26324 + (1));
seq__26313_26321 = G__26326;
chunk__26314_26322 = G__26327;
count__26315_26323 = G__26328;
i__26316_26324 = G__26329;
continue;
} else {
var temp__5735__auto___26330 = cljs.core.seq.call(null,seq__26313_26321);
if(temp__5735__auto___26330){
var seq__26313_26331__$1 = temp__5735__auto___26330;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26313_26331__$1)){
var c__4550__auto___26332 = cljs.core.chunk_first.call(null,seq__26313_26331__$1);
var G__26333 = cljs.core.chunk_rest.call(null,seq__26313_26331__$1);
var G__26334 = c__4550__auto___26332;
var G__26335 = cljs.core.count.call(null,c__4550__auto___26332);
var G__26336 = (0);
seq__26313_26321 = G__26333;
chunk__26314_26322 = G__26334;
count__26315_26323 = G__26335;
i__26316_26324 = G__26336;
continue;
} else {
var req_26337 = cljs.core.first.call(null,seq__26313_26331__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26337,prov);


var G__26338 = cljs.core.next.call(null,seq__26313_26331__$1);
var G__26339 = null;
var G__26340 = (0);
var G__26341 = (0);
seq__26313_26321 = G__26338;
chunk__26314_26322 = G__26339;
count__26315_26323 = G__26340;
i__26316_26324 = G__26341;
continue;
}
} else {
}
}
break;
}


var G__26342 = seq__26301;
var G__26343 = chunk__26302;
var G__26344 = count__26303;
var G__26345 = (i__26304 + (1));
seq__26301 = G__26342;
chunk__26302 = G__26343;
count__26303 = G__26344;
i__26304 = G__26345;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__26301);
if(temp__5735__auto__){
var seq__26301__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26301__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__26301__$1);
var G__26346 = cljs.core.chunk_rest.call(null,seq__26301__$1);
var G__26347 = c__4550__auto__;
var G__26348 = cljs.core.count.call(null,c__4550__auto__);
var G__26349 = (0);
seq__26301 = G__26346;
chunk__26302 = G__26347;
count__26303 = G__26348;
i__26304 = G__26349;
continue;
} else {
var prov = cljs.core.first.call(null,seq__26301__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26317_26350 = cljs.core.seq.call(null,requires);
var chunk__26318_26351 = null;
var count__26319_26352 = (0);
var i__26320_26353 = (0);
while(true){
if((i__26320_26353 < count__26319_26352)){
var req_26354 = cljs.core._nth.call(null,chunk__26318_26351,i__26320_26353);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26354,prov);


var G__26355 = seq__26317_26350;
var G__26356 = chunk__26318_26351;
var G__26357 = count__26319_26352;
var G__26358 = (i__26320_26353 + (1));
seq__26317_26350 = G__26355;
chunk__26318_26351 = G__26356;
count__26319_26352 = G__26357;
i__26320_26353 = G__26358;
continue;
} else {
var temp__5735__auto___26359__$1 = cljs.core.seq.call(null,seq__26317_26350);
if(temp__5735__auto___26359__$1){
var seq__26317_26360__$1 = temp__5735__auto___26359__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26317_26360__$1)){
var c__4550__auto___26361 = cljs.core.chunk_first.call(null,seq__26317_26360__$1);
var G__26362 = cljs.core.chunk_rest.call(null,seq__26317_26360__$1);
var G__26363 = c__4550__auto___26361;
var G__26364 = cljs.core.count.call(null,c__4550__auto___26361);
var G__26365 = (0);
seq__26317_26350 = G__26362;
chunk__26318_26351 = G__26363;
count__26319_26352 = G__26364;
i__26320_26353 = G__26365;
continue;
} else {
var req_26366 = cljs.core.first.call(null,seq__26317_26360__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26366,prov);


var G__26367 = cljs.core.next.call(null,seq__26317_26360__$1);
var G__26368 = null;
var G__26369 = (0);
var G__26370 = (0);
seq__26317_26350 = G__26367;
chunk__26318_26351 = G__26368;
count__26319_26352 = G__26369;
i__26320_26353 = G__26370;
continue;
}
} else {
}
}
break;
}


var G__26371 = cljs.core.next.call(null,seq__26301__$1);
var G__26372 = null;
var G__26373 = (0);
var G__26374 = (0);
seq__26301 = G__26371;
chunk__26302 = G__26372;
count__26303 = G__26373;
i__26304 = G__26374;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__26375_26379 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__26376_26380 = null;
var count__26377_26381 = (0);
var i__26378_26382 = (0);
while(true){
if((i__26378_26382 < count__26377_26381)){
var ns_26383 = cljs.core._nth.call(null,chunk__26376_26380,i__26378_26382);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26383);


var G__26384 = seq__26375_26379;
var G__26385 = chunk__26376_26380;
var G__26386 = count__26377_26381;
var G__26387 = (i__26378_26382 + (1));
seq__26375_26379 = G__26384;
chunk__26376_26380 = G__26385;
count__26377_26381 = G__26386;
i__26378_26382 = G__26387;
continue;
} else {
var temp__5735__auto___26388 = cljs.core.seq.call(null,seq__26375_26379);
if(temp__5735__auto___26388){
var seq__26375_26389__$1 = temp__5735__auto___26388;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26375_26389__$1)){
var c__4550__auto___26390 = cljs.core.chunk_first.call(null,seq__26375_26389__$1);
var G__26391 = cljs.core.chunk_rest.call(null,seq__26375_26389__$1);
var G__26392 = c__4550__auto___26390;
var G__26393 = cljs.core.count.call(null,c__4550__auto___26390);
var G__26394 = (0);
seq__26375_26379 = G__26391;
chunk__26376_26380 = G__26392;
count__26377_26381 = G__26393;
i__26378_26382 = G__26394;
continue;
} else {
var ns_26395 = cljs.core.first.call(null,seq__26375_26389__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26395);


var G__26396 = cljs.core.next.call(null,seq__26375_26389__$1);
var G__26397 = null;
var G__26398 = (0);
var G__26399 = (0);
seq__26375_26379 = G__26396;
chunk__26376_26380 = G__26397;
count__26377_26381 = G__26398;
i__26378_26382 = G__26399;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__4131__auto__ = goog.require__;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__26400__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__26400 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26401__i = 0, G__26401__a = new Array(arguments.length -  0);
while (G__26401__i < G__26401__a.length) {G__26401__a[G__26401__i] = arguments[G__26401__i + 0]; ++G__26401__i;}
  args = new cljs.core.IndexedSeq(G__26401__a,0,null);
} 
return G__26400__delegate.call(this,args);};
G__26400.cljs$lang$maxFixedArity = 0;
G__26400.cljs$lang$applyTo = (function (arglist__26402){
var args = cljs.core.seq(arglist__26402);
return G__26400__delegate(args);
});
G__26400.cljs$core$IFn$_invoke$arity$variadic = G__26400__delegate;
return G__26400;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__26403_SHARP_,p2__26404_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26403_SHARP_)),p2__26404_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__26405_SHARP_,p2__26406_SHARP_){
return goog.net.jsloader.load(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26405_SHARP_),p2__26406_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__26407 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__26407.addCallback(((function (G__26407){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__26407))
);

G__26407.addErrback(((function (G__26407){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__26407))
);

return G__26407;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e26408){if((e26408 instanceof Error)){
var e = e26408;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26408;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e26409){if((e26409 instanceof Error)){
var e = e26409;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26409;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__26410 = cljs.core._EQ_;
var expr__26411 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__26410.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__26411))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__26410.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__26411))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__26410.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__26411))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__26410,expr__26411){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__26410,expr__26411))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__26413,callback){
var map__26414 = p__26413;
var map__26414__$1 = (((((!((map__26414 == null))))?(((((map__26414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26414):map__26414);
var file_msg = map__26414__$1;
var request_url = cljs.core.get.call(null,map__26414__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__4131__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__26414,map__26414__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__26414,map__26414__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__){
return (function (state_26452){
var state_val_26453 = (state_26452[(1)]);
if((state_val_26453 === (7))){
var inst_26448 = (state_26452[(2)]);
var state_26452__$1 = state_26452;
var statearr_26454_26480 = state_26452__$1;
(statearr_26454_26480[(2)] = inst_26448);

(statearr_26454_26480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (1))){
var state_26452__$1 = state_26452;
var statearr_26455_26481 = state_26452__$1;
(statearr_26455_26481[(2)] = null);

(statearr_26455_26481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (4))){
var inst_26418 = (state_26452[(7)]);
var inst_26418__$1 = (state_26452[(2)]);
var state_26452__$1 = (function (){var statearr_26456 = state_26452;
(statearr_26456[(7)] = inst_26418__$1);

return statearr_26456;
})();
if(cljs.core.truth_(inst_26418__$1)){
var statearr_26457_26482 = state_26452__$1;
(statearr_26457_26482[(1)] = (5));

} else {
var statearr_26458_26483 = state_26452__$1;
(statearr_26458_26483[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (15))){
var inst_26433 = (state_26452[(8)]);
var inst_26431 = (state_26452[(9)]);
var inst_26435 = inst_26433.call(null,inst_26431);
var state_26452__$1 = state_26452;
var statearr_26459_26484 = state_26452__$1;
(statearr_26459_26484[(2)] = inst_26435);

(statearr_26459_26484[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (13))){
var inst_26442 = (state_26452[(2)]);
var state_26452__$1 = state_26452;
var statearr_26460_26485 = state_26452__$1;
(statearr_26460_26485[(2)] = inst_26442);

(statearr_26460_26485[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (6))){
var state_26452__$1 = state_26452;
var statearr_26461_26486 = state_26452__$1;
(statearr_26461_26486[(2)] = null);

(statearr_26461_26486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (17))){
var inst_26439 = (state_26452[(2)]);
var state_26452__$1 = state_26452;
var statearr_26462_26487 = state_26452__$1;
(statearr_26462_26487[(2)] = inst_26439);

(statearr_26462_26487[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (3))){
var inst_26450 = (state_26452[(2)]);
var state_26452__$1 = state_26452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26452__$1,inst_26450);
} else {
if((state_val_26453 === (12))){
var state_26452__$1 = state_26452;
var statearr_26463_26488 = state_26452__$1;
(statearr_26463_26488[(2)] = null);

(statearr_26463_26488[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (2))){
var state_26452__$1 = state_26452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26452__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_26453 === (11))){
var inst_26423 = (state_26452[(10)]);
var inst_26429 = figwheel.client.file_reloading.blocking_load.call(null,inst_26423);
var state_26452__$1 = state_26452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26452__$1,(14),inst_26429);
} else {
if((state_val_26453 === (9))){
var inst_26423 = (state_26452[(10)]);
var state_26452__$1 = state_26452;
if(cljs.core.truth_(inst_26423)){
var statearr_26464_26489 = state_26452__$1;
(statearr_26464_26489[(1)] = (11));

} else {
var statearr_26465_26490 = state_26452__$1;
(statearr_26465_26490[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (5))){
var inst_26424 = (state_26452[(11)]);
var inst_26418 = (state_26452[(7)]);
var inst_26423 = cljs.core.nth.call(null,inst_26418,(0),null);
var inst_26424__$1 = cljs.core.nth.call(null,inst_26418,(1),null);
var state_26452__$1 = (function (){var statearr_26466 = state_26452;
(statearr_26466[(10)] = inst_26423);

(statearr_26466[(11)] = inst_26424__$1);

return statearr_26466;
})();
if(cljs.core.truth_(inst_26424__$1)){
var statearr_26467_26491 = state_26452__$1;
(statearr_26467_26491[(1)] = (8));

} else {
var statearr_26468_26492 = state_26452__$1;
(statearr_26468_26492[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (14))){
var inst_26423 = (state_26452[(10)]);
var inst_26433 = (state_26452[(8)]);
var inst_26431 = (state_26452[(2)]);
var inst_26432 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_26433__$1 = cljs.core.get.call(null,inst_26432,inst_26423);
var state_26452__$1 = (function (){var statearr_26469 = state_26452;
(statearr_26469[(8)] = inst_26433__$1);

(statearr_26469[(9)] = inst_26431);

return statearr_26469;
})();
if(cljs.core.truth_(inst_26433__$1)){
var statearr_26470_26493 = state_26452__$1;
(statearr_26470_26493[(1)] = (15));

} else {
var statearr_26471_26494 = state_26452__$1;
(statearr_26471_26494[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (16))){
var inst_26431 = (state_26452[(9)]);
var inst_26437 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_26431);
var state_26452__$1 = state_26452;
var statearr_26472_26495 = state_26452__$1;
(statearr_26472_26495[(2)] = inst_26437);

(statearr_26472_26495[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (10))){
var inst_26444 = (state_26452[(2)]);
var state_26452__$1 = (function (){var statearr_26473 = state_26452;
(statearr_26473[(12)] = inst_26444);

return statearr_26473;
})();
var statearr_26474_26496 = state_26452__$1;
(statearr_26474_26496[(2)] = null);

(statearr_26474_26496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26453 === (8))){
var inst_26424 = (state_26452[(11)]);
var inst_26426 = eval(inst_26424);
var state_26452__$1 = state_26452;
var statearr_26475_26497 = state_26452__$1;
(statearr_26475_26497[(2)] = inst_26426);

(statearr_26475_26497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__))
;
return ((function (switch__24028__auto__,c__24123__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__24029__auto__ = null;
var figwheel$client$file_reloading$state_machine__24029__auto____0 = (function (){
var statearr_26476 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26476[(0)] = figwheel$client$file_reloading$state_machine__24029__auto__);

(statearr_26476[(1)] = (1));

return statearr_26476;
});
var figwheel$client$file_reloading$state_machine__24029__auto____1 = (function (state_26452){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_26452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e26477){if((e26477 instanceof Object)){
var ex__24032__auto__ = e26477;
var statearr_26478_26498 = state_26452;
(statearr_26478_26498[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26477;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26499 = state_26452;
state_26452 = G__26499;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__24029__auto__ = function(state_26452){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__24029__auto____1.call(this,state_26452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__24029__auto____0;
figwheel$client$file_reloading$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__24029__auto____1;
return figwheel$client$file_reloading$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__))
})();
var state__24125__auto__ = (function (){var statearr_26479 = f__24124__auto__.call(null);
(statearr_26479[(6)] = c__24123__auto__);

return statearr_26479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__))
);

return c__24123__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__26501 = arguments.length;
switch (G__26501) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__26503,callback){
var map__26504 = p__26503;
var map__26504__$1 = (((((!((map__26504 == null))))?(((((map__26504.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26504.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26504):map__26504);
var file_msg = map__26504__$1;
var namespace = cljs.core.get.call(null,map__26504__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__26504,map__26504__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__26504,map__26504__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__26506){
var map__26507 = p__26506;
var map__26507__$1 = (((((!((map__26507 == null))))?(((((map__26507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26507):map__26507);
var file_msg = map__26507__$1;
var namespace = cljs.core.get.call(null,map__26507__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return (!((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null)));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__26509){
var map__26510 = p__26509;
var map__26510__$1 = (((((!((map__26510 == null))))?(((((map__26510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26510.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26510):map__26510);
var file_msg = map__26510__$1;
var namespace = cljs.core.get.call(null,map__26510__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__4120__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__4120__auto__){
var or__4131__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__4120__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__26512,callback){
var map__26513 = p__26512;
var map__26513__$1 = (((((!((map__26513 == null))))?(((((map__26513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26513):map__26513);
var file_msg = map__26513__$1;
var request_url = cljs.core.get.call(null,map__26513__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__26513__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__24123__auto___26563 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___26563,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___26563,out){
return (function (state_26548){
var state_val_26549 = (state_26548[(1)]);
if((state_val_26549 === (1))){
var inst_26522 = cljs.core.seq.call(null,files);
var inst_26523 = cljs.core.first.call(null,inst_26522);
var inst_26524 = cljs.core.next.call(null,inst_26522);
var inst_26525 = files;
var state_26548__$1 = (function (){var statearr_26550 = state_26548;
(statearr_26550[(7)] = inst_26525);

(statearr_26550[(8)] = inst_26524);

(statearr_26550[(9)] = inst_26523);

return statearr_26550;
})();
var statearr_26551_26564 = state_26548__$1;
(statearr_26551_26564[(2)] = null);

(statearr_26551_26564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26549 === (2))){
var inst_26525 = (state_26548[(7)]);
var inst_26531 = (state_26548[(10)]);
var inst_26530 = cljs.core.seq.call(null,inst_26525);
var inst_26531__$1 = cljs.core.first.call(null,inst_26530);
var inst_26532 = cljs.core.next.call(null,inst_26530);
var inst_26533 = (inst_26531__$1 == null);
var inst_26534 = cljs.core.not.call(null,inst_26533);
var state_26548__$1 = (function (){var statearr_26552 = state_26548;
(statearr_26552[(10)] = inst_26531__$1);

(statearr_26552[(11)] = inst_26532);

return statearr_26552;
})();
if(inst_26534){
var statearr_26553_26565 = state_26548__$1;
(statearr_26553_26565[(1)] = (4));

} else {
var statearr_26554_26566 = state_26548__$1;
(statearr_26554_26566[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26549 === (3))){
var inst_26546 = (state_26548[(2)]);
var state_26548__$1 = state_26548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26548__$1,inst_26546);
} else {
if((state_val_26549 === (4))){
var inst_26531 = (state_26548[(10)]);
var inst_26536 = figwheel.client.file_reloading.reload_js_file.call(null,inst_26531);
var state_26548__$1 = state_26548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26548__$1,(7),inst_26536);
} else {
if((state_val_26549 === (5))){
var inst_26542 = cljs.core.async.close_BANG_.call(null,out);
var state_26548__$1 = state_26548;
var statearr_26555_26567 = state_26548__$1;
(statearr_26555_26567[(2)] = inst_26542);

(statearr_26555_26567[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26549 === (6))){
var inst_26544 = (state_26548[(2)]);
var state_26548__$1 = state_26548;
var statearr_26556_26568 = state_26548__$1;
(statearr_26556_26568[(2)] = inst_26544);

(statearr_26556_26568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26549 === (7))){
var inst_26532 = (state_26548[(11)]);
var inst_26538 = (state_26548[(2)]);
var inst_26539 = cljs.core.async.put_BANG_.call(null,out,inst_26538);
var inst_26525 = inst_26532;
var state_26548__$1 = (function (){var statearr_26557 = state_26548;
(statearr_26557[(7)] = inst_26525);

(statearr_26557[(12)] = inst_26539);

return statearr_26557;
})();
var statearr_26558_26569 = state_26548__$1;
(statearr_26558_26569[(2)] = null);

(statearr_26558_26569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__24123__auto___26563,out))
;
return ((function (switch__24028__auto__,c__24123__auto___26563,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto____0 = (function (){
var statearr_26559 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26559[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto__);

(statearr_26559[(1)] = (1));

return statearr_26559;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto____1 = (function (state_26548){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_26548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e26560){if((e26560 instanceof Object)){
var ex__24032__auto__ = e26560;
var statearr_26561_26570 = state_26548;
(statearr_26561_26570[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26560;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26571 = state_26548;
state_26548 = G__26571;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto__ = function(state_26548){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto____1.call(this,state_26548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___26563,out))
})();
var state__24125__auto__ = (function (){var statearr_26562 = f__24124__auto__.call(null);
(statearr_26562[(6)] = c__24123__auto___26563);

return statearr_26562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___26563,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__26572,opts){
var map__26573 = p__26572;
var map__26573__$1 = (((((!((map__26573 == null))))?(((((map__26573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26573.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26573):map__26573);
var eval_body = cljs.core.get.call(null,map__26573__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__26573__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__4120__auto__ = eval_body;
if(cljs.core.truth_(and__4120__auto__)){
return typeof eval_body === 'string';
} else {
return and__4120__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e26575){var e = e26575;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5733__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__26576_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26576_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5733__auto__)){
var file_msg = temp__5733__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__26577){
var vec__26578 = p__26577;
var k = cljs.core.nth.call(null,vec__26578,(0),null);
var v = cljs.core.nth.call(null,vec__26578,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__26581){
var vec__26582 = p__26581;
var k = cljs.core.nth.call(null,vec__26582,(0),null);
var v = cljs.core.nth.call(null,vec__26582,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__26588,p__26589){
var map__26590 = p__26588;
var map__26590__$1 = (((((!((map__26590 == null))))?(((((map__26590.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26590.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26590):map__26590);
var opts = map__26590__$1;
var before_jsload = cljs.core.get.call(null,map__26590__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__26590__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__26590__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__26591 = p__26589;
var map__26591__$1 = (((((!((map__26591 == null))))?(((((map__26591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26591.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26591):map__26591);
var msg = map__26591__$1;
var files = cljs.core.get.call(null,map__26591__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__26591__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__26591__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26745){
var state_val_26746 = (state_26745[(1)]);
if((state_val_26746 === (7))){
var inst_26606 = (state_26745[(7)]);
var inst_26607 = (state_26745[(8)]);
var inst_26605 = (state_26745[(9)]);
var inst_26608 = (state_26745[(10)]);
var inst_26613 = cljs.core._nth.call(null,inst_26606,inst_26608);
var inst_26614 = figwheel.client.file_reloading.eval_body.call(null,inst_26613,opts);
var inst_26615 = (inst_26608 + (1));
var tmp26747 = inst_26606;
var tmp26748 = inst_26607;
var tmp26749 = inst_26605;
var inst_26605__$1 = tmp26749;
var inst_26606__$1 = tmp26747;
var inst_26607__$1 = tmp26748;
var inst_26608__$1 = inst_26615;
var state_26745__$1 = (function (){var statearr_26750 = state_26745;
(statearr_26750[(7)] = inst_26606__$1);

(statearr_26750[(8)] = inst_26607__$1);

(statearr_26750[(11)] = inst_26614);

(statearr_26750[(9)] = inst_26605__$1);

(statearr_26750[(10)] = inst_26608__$1);

return statearr_26750;
})();
var statearr_26751_26834 = state_26745__$1;
(statearr_26751_26834[(2)] = null);

(statearr_26751_26834[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (20))){
var inst_26648 = (state_26745[(12)]);
var inst_26656 = figwheel.client.file_reloading.sort_files.call(null,inst_26648);
var state_26745__$1 = state_26745;
var statearr_26752_26835 = state_26745__$1;
(statearr_26752_26835[(2)] = inst_26656);

(statearr_26752_26835[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (27))){
var state_26745__$1 = state_26745;
var statearr_26753_26836 = state_26745__$1;
(statearr_26753_26836[(2)] = null);

(statearr_26753_26836[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (1))){
var inst_26597 = (state_26745[(13)]);
var inst_26594 = before_jsload.call(null,files);
var inst_26595 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_26596 = (function (){return ((function (inst_26597,inst_26594,inst_26595,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26585_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26585_SHARP_);
});
;})(inst_26597,inst_26594,inst_26595,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26597__$1 = cljs.core.filter.call(null,inst_26596,files);
var inst_26598 = cljs.core.not_empty.call(null,inst_26597__$1);
var state_26745__$1 = (function (){var statearr_26754 = state_26745;
(statearr_26754[(14)] = inst_26595);

(statearr_26754[(15)] = inst_26594);

(statearr_26754[(13)] = inst_26597__$1);

return statearr_26754;
})();
if(cljs.core.truth_(inst_26598)){
var statearr_26755_26837 = state_26745__$1;
(statearr_26755_26837[(1)] = (2));

} else {
var statearr_26756_26838 = state_26745__$1;
(statearr_26756_26838[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (24))){
var state_26745__$1 = state_26745;
var statearr_26757_26839 = state_26745__$1;
(statearr_26757_26839[(2)] = null);

(statearr_26757_26839[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (39))){
var inst_26698 = (state_26745[(16)]);
var state_26745__$1 = state_26745;
var statearr_26758_26840 = state_26745__$1;
(statearr_26758_26840[(2)] = inst_26698);

(statearr_26758_26840[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (46))){
var inst_26740 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
var statearr_26759_26841 = state_26745__$1;
(statearr_26759_26841[(2)] = inst_26740);

(statearr_26759_26841[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (4))){
var inst_26642 = (state_26745[(2)]);
var inst_26643 = cljs.core.List.EMPTY;
var inst_26644 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_26643);
var inst_26645 = (function (){return ((function (inst_26642,inst_26643,inst_26644,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26586_SHARP_){
var and__4120__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26586_SHARP_);
if(cljs.core.truth_(and__4120__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26586_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__26586_SHARP_))));
} else {
return and__4120__auto__;
}
});
;})(inst_26642,inst_26643,inst_26644,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26646 = cljs.core.filter.call(null,inst_26645,files);
var inst_26647 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_26648 = cljs.core.concat.call(null,inst_26646,inst_26647);
var state_26745__$1 = (function (){var statearr_26760 = state_26745;
(statearr_26760[(17)] = inst_26644);

(statearr_26760[(12)] = inst_26648);

(statearr_26760[(18)] = inst_26642);

return statearr_26760;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26761_26842 = state_26745__$1;
(statearr_26761_26842[(1)] = (16));

} else {
var statearr_26762_26843 = state_26745__$1;
(statearr_26762_26843[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (15))){
var inst_26632 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
var statearr_26763_26844 = state_26745__$1;
(statearr_26763_26844[(2)] = inst_26632);

(statearr_26763_26844[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (21))){
var inst_26658 = (state_26745[(19)]);
var inst_26658__$1 = (state_26745[(2)]);
var inst_26659 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_26658__$1);
var state_26745__$1 = (function (){var statearr_26764 = state_26745;
(statearr_26764[(19)] = inst_26658__$1);

return statearr_26764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26745__$1,(22),inst_26659);
} else {
if((state_val_26746 === (31))){
var inst_26743 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26745__$1,inst_26743);
} else {
if((state_val_26746 === (32))){
var inst_26698 = (state_26745[(16)]);
var inst_26703 = inst_26698.cljs$lang$protocol_mask$partition0$;
var inst_26704 = (inst_26703 & (64));
var inst_26705 = inst_26698.cljs$core$ISeq$;
var inst_26706 = (cljs.core.PROTOCOL_SENTINEL === inst_26705);
var inst_26707 = ((inst_26704) || (inst_26706));
var state_26745__$1 = state_26745;
if(cljs.core.truth_(inst_26707)){
var statearr_26765_26845 = state_26745__$1;
(statearr_26765_26845[(1)] = (35));

} else {
var statearr_26766_26846 = state_26745__$1;
(statearr_26766_26846[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (40))){
var inst_26720 = (state_26745[(20)]);
var inst_26719 = (state_26745[(2)]);
var inst_26720__$1 = cljs.core.get.call(null,inst_26719,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26721 = cljs.core.get.call(null,inst_26719,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26722 = cljs.core.not_empty.call(null,inst_26720__$1);
var state_26745__$1 = (function (){var statearr_26767 = state_26745;
(statearr_26767[(21)] = inst_26721);

(statearr_26767[(20)] = inst_26720__$1);

return statearr_26767;
})();
if(cljs.core.truth_(inst_26722)){
var statearr_26768_26847 = state_26745__$1;
(statearr_26768_26847[(1)] = (41));

} else {
var statearr_26769_26848 = state_26745__$1;
(statearr_26769_26848[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (33))){
var state_26745__$1 = state_26745;
var statearr_26770_26849 = state_26745__$1;
(statearr_26770_26849[(2)] = false);

(statearr_26770_26849[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (13))){
var inst_26618 = (state_26745[(22)]);
var inst_26622 = cljs.core.chunk_first.call(null,inst_26618);
var inst_26623 = cljs.core.chunk_rest.call(null,inst_26618);
var inst_26624 = cljs.core.count.call(null,inst_26622);
var inst_26605 = inst_26623;
var inst_26606 = inst_26622;
var inst_26607 = inst_26624;
var inst_26608 = (0);
var state_26745__$1 = (function (){var statearr_26771 = state_26745;
(statearr_26771[(7)] = inst_26606);

(statearr_26771[(8)] = inst_26607);

(statearr_26771[(9)] = inst_26605);

(statearr_26771[(10)] = inst_26608);

return statearr_26771;
})();
var statearr_26772_26850 = state_26745__$1;
(statearr_26772_26850[(2)] = null);

(statearr_26772_26850[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (22))){
var inst_26661 = (state_26745[(23)]);
var inst_26666 = (state_26745[(24)]);
var inst_26662 = (state_26745[(25)]);
var inst_26658 = (state_26745[(19)]);
var inst_26661__$1 = (state_26745[(2)]);
var inst_26662__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26661__$1);
var inst_26663 = (function (){var all_files = inst_26658;
var res_SINGLEQUOTE_ = inst_26661__$1;
var res = inst_26662__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_26661,inst_26666,inst_26662,inst_26658,inst_26661__$1,inst_26662__$1,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26587_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__26587_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_26661,inst_26666,inst_26662,inst_26658,inst_26661__$1,inst_26662__$1,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26664 = cljs.core.filter.call(null,inst_26663,inst_26661__$1);
var inst_26665 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_26666__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26665);
var inst_26667 = cljs.core.not_empty.call(null,inst_26666__$1);
var state_26745__$1 = (function (){var statearr_26773 = state_26745;
(statearr_26773[(26)] = inst_26664);

(statearr_26773[(23)] = inst_26661__$1);

(statearr_26773[(24)] = inst_26666__$1);

(statearr_26773[(25)] = inst_26662__$1);

return statearr_26773;
})();
if(cljs.core.truth_(inst_26667)){
var statearr_26774_26851 = state_26745__$1;
(statearr_26774_26851[(1)] = (23));

} else {
var statearr_26775_26852 = state_26745__$1;
(statearr_26775_26852[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (36))){
var state_26745__$1 = state_26745;
var statearr_26776_26853 = state_26745__$1;
(statearr_26776_26853[(2)] = false);

(statearr_26776_26853[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (41))){
var inst_26720 = (state_26745[(20)]);
var inst_26724 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26725 = cljs.core.map.call(null,inst_26724,inst_26720);
var inst_26726 = cljs.core.pr_str.call(null,inst_26725);
var inst_26727 = ["figwheel-no-load meta-data: ",inst_26726].join('');
var inst_26728 = figwheel.client.utils.log.call(null,inst_26727);
var state_26745__$1 = state_26745;
var statearr_26777_26854 = state_26745__$1;
(statearr_26777_26854[(2)] = inst_26728);

(statearr_26777_26854[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (43))){
var inst_26721 = (state_26745[(21)]);
var inst_26731 = (state_26745[(2)]);
var inst_26732 = cljs.core.not_empty.call(null,inst_26721);
var state_26745__$1 = (function (){var statearr_26778 = state_26745;
(statearr_26778[(27)] = inst_26731);

return statearr_26778;
})();
if(cljs.core.truth_(inst_26732)){
var statearr_26779_26855 = state_26745__$1;
(statearr_26779_26855[(1)] = (44));

} else {
var statearr_26780_26856 = state_26745__$1;
(statearr_26780_26856[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (29))){
var inst_26664 = (state_26745[(26)]);
var inst_26698 = (state_26745[(16)]);
var inst_26661 = (state_26745[(23)]);
var inst_26666 = (state_26745[(24)]);
var inst_26662 = (state_26745[(25)]);
var inst_26658 = (state_26745[(19)]);
var inst_26694 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_26697 = (function (){var all_files = inst_26658;
var res_SINGLEQUOTE_ = inst_26661;
var res = inst_26662;
var files_not_loaded = inst_26664;
var dependencies_that_loaded = inst_26666;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26698,inst_26661,inst_26666,inst_26662,inst_26658,inst_26694,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26696){
var map__26781 = p__26696;
var map__26781__$1 = (((((!((map__26781 == null))))?(((((map__26781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26781):map__26781);
var namespace = cljs.core.get.call(null,map__26781__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26698,inst_26661,inst_26666,inst_26662,inst_26658,inst_26694,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26698__$1 = cljs.core.group_by.call(null,inst_26697,inst_26664);
var inst_26700 = (inst_26698__$1 == null);
var inst_26701 = cljs.core.not.call(null,inst_26700);
var state_26745__$1 = (function (){var statearr_26783 = state_26745;
(statearr_26783[(16)] = inst_26698__$1);

(statearr_26783[(28)] = inst_26694);

return statearr_26783;
})();
if(inst_26701){
var statearr_26784_26857 = state_26745__$1;
(statearr_26784_26857[(1)] = (32));

} else {
var statearr_26785_26858 = state_26745__$1;
(statearr_26785_26858[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (44))){
var inst_26721 = (state_26745[(21)]);
var inst_26734 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26721);
var inst_26735 = cljs.core.pr_str.call(null,inst_26734);
var inst_26736 = ["not required: ",inst_26735].join('');
var inst_26737 = figwheel.client.utils.log.call(null,inst_26736);
var state_26745__$1 = state_26745;
var statearr_26786_26859 = state_26745__$1;
(statearr_26786_26859[(2)] = inst_26737);

(statearr_26786_26859[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (6))){
var inst_26639 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
var statearr_26787_26860 = state_26745__$1;
(statearr_26787_26860[(2)] = inst_26639);

(statearr_26787_26860[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (28))){
var inst_26664 = (state_26745[(26)]);
var inst_26691 = (state_26745[(2)]);
var inst_26692 = cljs.core.not_empty.call(null,inst_26664);
var state_26745__$1 = (function (){var statearr_26788 = state_26745;
(statearr_26788[(29)] = inst_26691);

return statearr_26788;
})();
if(cljs.core.truth_(inst_26692)){
var statearr_26789_26861 = state_26745__$1;
(statearr_26789_26861[(1)] = (29));

} else {
var statearr_26790_26862 = state_26745__$1;
(statearr_26790_26862[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (25))){
var inst_26662 = (state_26745[(25)]);
var inst_26678 = (state_26745[(2)]);
var inst_26679 = cljs.core.not_empty.call(null,inst_26662);
var state_26745__$1 = (function (){var statearr_26791 = state_26745;
(statearr_26791[(30)] = inst_26678);

return statearr_26791;
})();
if(cljs.core.truth_(inst_26679)){
var statearr_26792_26863 = state_26745__$1;
(statearr_26792_26863[(1)] = (26));

} else {
var statearr_26793_26864 = state_26745__$1;
(statearr_26793_26864[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (34))){
var inst_26714 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
if(cljs.core.truth_(inst_26714)){
var statearr_26794_26865 = state_26745__$1;
(statearr_26794_26865[(1)] = (38));

} else {
var statearr_26795_26866 = state_26745__$1;
(statearr_26795_26866[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (17))){
var state_26745__$1 = state_26745;
var statearr_26796_26867 = state_26745__$1;
(statearr_26796_26867[(2)] = recompile_dependents);

(statearr_26796_26867[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (3))){
var state_26745__$1 = state_26745;
var statearr_26797_26868 = state_26745__$1;
(statearr_26797_26868[(2)] = null);

(statearr_26797_26868[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (12))){
var inst_26635 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
var statearr_26798_26869 = state_26745__$1;
(statearr_26798_26869[(2)] = inst_26635);

(statearr_26798_26869[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (2))){
var inst_26597 = (state_26745[(13)]);
var inst_26604 = cljs.core.seq.call(null,inst_26597);
var inst_26605 = inst_26604;
var inst_26606 = null;
var inst_26607 = (0);
var inst_26608 = (0);
var state_26745__$1 = (function (){var statearr_26799 = state_26745;
(statearr_26799[(7)] = inst_26606);

(statearr_26799[(8)] = inst_26607);

(statearr_26799[(9)] = inst_26605);

(statearr_26799[(10)] = inst_26608);

return statearr_26799;
})();
var statearr_26800_26870 = state_26745__$1;
(statearr_26800_26870[(2)] = null);

(statearr_26800_26870[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (23))){
var inst_26664 = (state_26745[(26)]);
var inst_26661 = (state_26745[(23)]);
var inst_26666 = (state_26745[(24)]);
var inst_26662 = (state_26745[(25)]);
var inst_26658 = (state_26745[(19)]);
var inst_26669 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_26671 = (function (){var all_files = inst_26658;
var res_SINGLEQUOTE_ = inst_26661;
var res = inst_26662;
var files_not_loaded = inst_26664;
var dependencies_that_loaded = inst_26666;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26661,inst_26666,inst_26662,inst_26658,inst_26669,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26670){
var map__26801 = p__26670;
var map__26801__$1 = (((((!((map__26801 == null))))?(((((map__26801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26801):map__26801);
var request_url = cljs.core.get.call(null,map__26801__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26661,inst_26666,inst_26662,inst_26658,inst_26669,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26672 = cljs.core.reverse.call(null,inst_26666);
var inst_26673 = cljs.core.map.call(null,inst_26671,inst_26672);
var inst_26674 = cljs.core.pr_str.call(null,inst_26673);
var inst_26675 = figwheel.client.utils.log.call(null,inst_26674);
var state_26745__$1 = (function (){var statearr_26803 = state_26745;
(statearr_26803[(31)] = inst_26669);

return statearr_26803;
})();
var statearr_26804_26871 = state_26745__$1;
(statearr_26804_26871[(2)] = inst_26675);

(statearr_26804_26871[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (35))){
var state_26745__$1 = state_26745;
var statearr_26805_26872 = state_26745__$1;
(statearr_26805_26872[(2)] = true);

(statearr_26805_26872[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (19))){
var inst_26648 = (state_26745[(12)]);
var inst_26654 = figwheel.client.file_reloading.expand_files.call(null,inst_26648);
var state_26745__$1 = state_26745;
var statearr_26806_26873 = state_26745__$1;
(statearr_26806_26873[(2)] = inst_26654);

(statearr_26806_26873[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (11))){
var state_26745__$1 = state_26745;
var statearr_26807_26874 = state_26745__$1;
(statearr_26807_26874[(2)] = null);

(statearr_26807_26874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (9))){
var inst_26637 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
var statearr_26808_26875 = state_26745__$1;
(statearr_26808_26875[(2)] = inst_26637);

(statearr_26808_26875[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (5))){
var inst_26607 = (state_26745[(8)]);
var inst_26608 = (state_26745[(10)]);
var inst_26610 = (inst_26608 < inst_26607);
var inst_26611 = inst_26610;
var state_26745__$1 = state_26745;
if(cljs.core.truth_(inst_26611)){
var statearr_26809_26876 = state_26745__$1;
(statearr_26809_26876[(1)] = (7));

} else {
var statearr_26810_26877 = state_26745__$1;
(statearr_26810_26877[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (14))){
var inst_26618 = (state_26745[(22)]);
var inst_26627 = cljs.core.first.call(null,inst_26618);
var inst_26628 = figwheel.client.file_reloading.eval_body.call(null,inst_26627,opts);
var inst_26629 = cljs.core.next.call(null,inst_26618);
var inst_26605 = inst_26629;
var inst_26606 = null;
var inst_26607 = (0);
var inst_26608 = (0);
var state_26745__$1 = (function (){var statearr_26811 = state_26745;
(statearr_26811[(7)] = inst_26606);

(statearr_26811[(8)] = inst_26607);

(statearr_26811[(32)] = inst_26628);

(statearr_26811[(9)] = inst_26605);

(statearr_26811[(10)] = inst_26608);

return statearr_26811;
})();
var statearr_26812_26878 = state_26745__$1;
(statearr_26812_26878[(2)] = null);

(statearr_26812_26878[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (45))){
var state_26745__$1 = state_26745;
var statearr_26813_26879 = state_26745__$1;
(statearr_26813_26879[(2)] = null);

(statearr_26813_26879[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (26))){
var inst_26664 = (state_26745[(26)]);
var inst_26661 = (state_26745[(23)]);
var inst_26666 = (state_26745[(24)]);
var inst_26662 = (state_26745[(25)]);
var inst_26658 = (state_26745[(19)]);
var inst_26681 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_26683 = (function (){var all_files = inst_26658;
var res_SINGLEQUOTE_ = inst_26661;
var res = inst_26662;
var files_not_loaded = inst_26664;
var dependencies_that_loaded = inst_26666;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26661,inst_26666,inst_26662,inst_26658,inst_26681,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26682){
var map__26814 = p__26682;
var map__26814__$1 = (((((!((map__26814 == null))))?(((((map__26814.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26814.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26814):map__26814);
var namespace = cljs.core.get.call(null,map__26814__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26814__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26661,inst_26666,inst_26662,inst_26658,inst_26681,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26684 = cljs.core.map.call(null,inst_26683,inst_26662);
var inst_26685 = cljs.core.pr_str.call(null,inst_26684);
var inst_26686 = figwheel.client.utils.log.call(null,inst_26685);
var inst_26687 = (function (){var all_files = inst_26658;
var res_SINGLEQUOTE_ = inst_26661;
var res = inst_26662;
var files_not_loaded = inst_26664;
var dependencies_that_loaded = inst_26666;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26661,inst_26666,inst_26662,inst_26658,inst_26681,inst_26683,inst_26684,inst_26685,inst_26686,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26664,inst_26661,inst_26666,inst_26662,inst_26658,inst_26681,inst_26683,inst_26684,inst_26685,inst_26686,state_val_26746,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26688 = setTimeout(inst_26687,(10));
var state_26745__$1 = (function (){var statearr_26816 = state_26745;
(statearr_26816[(33)] = inst_26686);

(statearr_26816[(34)] = inst_26681);

return statearr_26816;
})();
var statearr_26817_26880 = state_26745__$1;
(statearr_26817_26880[(2)] = inst_26688);

(statearr_26817_26880[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (16))){
var state_26745__$1 = state_26745;
var statearr_26818_26881 = state_26745__$1;
(statearr_26818_26881[(2)] = reload_dependents);

(statearr_26818_26881[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (38))){
var inst_26698 = (state_26745[(16)]);
var inst_26716 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26698);
var state_26745__$1 = state_26745;
var statearr_26819_26882 = state_26745__$1;
(statearr_26819_26882[(2)] = inst_26716);

(statearr_26819_26882[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (30))){
var state_26745__$1 = state_26745;
var statearr_26820_26883 = state_26745__$1;
(statearr_26820_26883[(2)] = null);

(statearr_26820_26883[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (10))){
var inst_26618 = (state_26745[(22)]);
var inst_26620 = cljs.core.chunked_seq_QMARK_.call(null,inst_26618);
var state_26745__$1 = state_26745;
if(inst_26620){
var statearr_26821_26884 = state_26745__$1;
(statearr_26821_26884[(1)] = (13));

} else {
var statearr_26822_26885 = state_26745__$1;
(statearr_26822_26885[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (18))){
var inst_26652 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
if(cljs.core.truth_(inst_26652)){
var statearr_26823_26886 = state_26745__$1;
(statearr_26823_26886[(1)] = (19));

} else {
var statearr_26824_26887 = state_26745__$1;
(statearr_26824_26887[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (42))){
var state_26745__$1 = state_26745;
var statearr_26825_26888 = state_26745__$1;
(statearr_26825_26888[(2)] = null);

(statearr_26825_26888[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (37))){
var inst_26711 = (state_26745[(2)]);
var state_26745__$1 = state_26745;
var statearr_26826_26889 = state_26745__$1;
(statearr_26826_26889[(2)] = inst_26711);

(statearr_26826_26889[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26746 === (8))){
var inst_26605 = (state_26745[(9)]);
var inst_26618 = (state_26745[(22)]);
var inst_26618__$1 = cljs.core.seq.call(null,inst_26605);
var state_26745__$1 = (function (){var statearr_26827 = state_26745;
(statearr_26827[(22)] = inst_26618__$1);

return statearr_26827;
})();
if(inst_26618__$1){
var statearr_26828_26890 = state_26745__$1;
(statearr_26828_26890[(1)] = (10));

} else {
var statearr_26829_26891 = state_26745__$1;
(statearr_26829_26891[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__24028__auto__,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto____0 = (function (){
var statearr_26830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26830[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto__);

(statearr_26830[(1)] = (1));

return statearr_26830;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto____1 = (function (state_26745){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_26745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e26831){if((e26831 instanceof Object)){
var ex__24032__auto__ = e26831;
var statearr_26832_26892 = state_26745;
(statearr_26832_26892[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26831;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26893 = state_26745;
state_26745 = G__26893;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto__ = function(state_26745){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto____1.call(this,state_26745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__24125__auto__ = (function (){var statearr_26833 = f__24124__auto__.call(null);
(statearr_26833[(6)] = c__24123__auto__);

return statearr_26833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__,map__26590,map__26590__$1,opts,before_jsload,on_jsload,reload_dependents,map__26591,map__26591__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__24123__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__26896,link){
var map__26897 = p__26896;
var map__26897__$1 = (((((!((map__26897 == null))))?(((((map__26897.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26897.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26897):map__26897);
var file = cljs.core.get.call(null,map__26897__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5735__auto__ = link.href;
if(cljs.core.truth_(temp__5735__auto__)){
var link_href = temp__5735__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5735__auto__,map__26897,map__26897__$1,file){
return (function (p1__26894_SHARP_,p2__26895_SHARP_){
if(cljs.core._EQ_.call(null,p1__26894_SHARP_,p2__26895_SHARP_)){
return p1__26894_SHARP_;
} else {
return false;
}
});})(link_href,temp__5735__auto__,map__26897,map__26897__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5735__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__26900){
var map__26901 = p__26900;
var map__26901__$1 = (((((!((map__26901 == null))))?(((((map__26901.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26901.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26901):map__26901);
var match_length = cljs.core.get.call(null,map__26901__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__26901__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__26899_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__26899_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5735__auto__)){
var res = temp__5735__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__26903_SHARP_,p2__26904_SHARP_){
return cljs.core.assoc.call(null,p1__26903_SHARP_,cljs.core.get.call(null,p2__26904_SHARP_,key),p2__26904_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5733__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5733__auto__)){
var link = temp__5733__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5733__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5733__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_26905 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_26905);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_26905);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__26906,p__26907){
var map__26908 = p__26906;
var map__26908__$1 = (((((!((map__26908 == null))))?(((((map__26908.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26908.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26908):map__26908);
var on_cssload = cljs.core.get.call(null,map__26908__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__26909 = p__26907;
var map__26909__$1 = (((((!((map__26909 == null))))?(((((map__26909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26909):map__26909);
var files_msg = map__26909__$1;
var files = cljs.core.get.call(null,map__26909__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(figwheel.client.utils.html_env_QMARK_.call(null)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5735__auto__)){
var f_datas = temp__5735__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1571424879307
