// Compiled by ClojureScript 1.10.520 {:static-fns false, :optimize-constants false}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.sha3');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('goog.crypt.Pkcs7');
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___1704 = arguments.length;
var i__4731__auto___1705 = (0);
while(true){
if((i__4731__auto___1705 < len__4730__auto___1704)){
args__4736__auto__.push((arguments[i__4731__auto___1705]));

var G__1706 = (i__4731__auto___1705 + (1));
i__4731__auto___1705 = G__1706;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__1700){
var map__1701 = p__1700;
var map__1701__$1 = (((((!((map__1701 == null))))?(((((map__1701.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1701.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1701):map__1701);
var iv = cljs.core.get.call(null,map__1701__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.call(null,map__1701__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes.call(null,x):x);
var encrypted = (function (){var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var pkcs7 = (new goog.crypt.Pkcs7());
var padded = pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js.call(null,iv));
})();
var G__1703 = cljs.core.keyword.call(null,output_format);
var G__1703__$1 = (((G__1703 instanceof cljs.core.Keyword))?G__1703.fqn:null);
switch (G__1703__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64.call(null,encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__1703__$1)].join('')));

}
});

fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq1697){
var G__1698 = cljs.core.first.call(null,seq1697);
var seq1697__$1 = cljs.core.next.call(null,seq1697);
var G__1699 = cljs.core.first.call(null,seq1697__$1);
var seq1697__$2 = cljs.core.next.call(null,seq1697__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__1698,G__1699,seq1697__$2);
});

/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___1717 = arguments.length;
var i__4731__auto___1718 = (0);
while(true){
if((i__4731__auto___1718 < len__4730__auto___1717)){
args__4736__auto__.push((arguments[i__4731__auto___1718]));

var G__1719 = (i__4731__auto___1718 + (1));
i__4731__auto___1718 = G__1719;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__1712){
var map__1713 = p__1712;
var map__1713__$1 = (((((!((map__1713 == null))))?(((((map__1713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1713):map__1713);
var iv = cljs.core.get.call(null,map__1713__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.call(null,map__1713__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.call(null,map__1713__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__1715 = cljs.core.keyword.call(null,input_format);
var G__1715__$1 = (((G__1715 instanceof cljs.core.Keyword))?G__1715.fqn:null);
switch (G__1715__$1) {
case "hex":
return alphabase.core.hex__GT_bytes.call(null,x);

break;
case "base64":
return alphabase.core.base64__GT_bytes.call(null,x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__1715__$1)].join('')));

}
})():x);
var decrypt_ba = (function (){var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var pkcs7 = (new goog.crypt.Pkcs7());
return pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js.call(null,iv)));
})();
var G__1716 = cljs.core.keyword.call(null,output_format);
var G__1716__$1 = (((G__1716 instanceof cljs.core.Keyword))?G__1716.fqn:null);
switch (G__1716__$1) {
case "none":
return decrypt_ba;

break;
case "string":
return alphabase.core.bytes__GT_string.call(null,decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__1716__$1)].join('')));

}
});

fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq1709){
var G__1710 = cljs.core.first.call(null,seq1709);
var seq1709__$1 = cljs.core.next.call(null,seq1709);
var G__1711 = cljs.core.first.call(null,seq1709__$1);
var seq1709__$2 = cljs.core.next.call(null,seq1709__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__1710,G__1711,seq1709__$2);
});


//# sourceMappingURL=aes.js.map?rel=1571427764387
