;; Copyright (c) 2018 Flybot Pte Ltd, Singapore.
;;
;; This file is distributed under the Eclipse Public License, the same as
;; Clojure.
;;
;; This file incorporates work covered by the following copyright and
;; permission notice:
;;
;;     Copyright (c) 2015-2017 Michael Thompson
;;
;;     Permission is hereby granted, free of charge, to any person obtaining
;;     a copy of this software and associated documentation files (the
;;     "Software"), to deal in the Software without restriction, including
;;     without limitation the rights to use, copy, modify, merge, publish,
;;     distribute, sublicense, and/or sell copies of the Software, and to
;;     permit persons to whom the Software is furnished to do so, subject to
;;     the following conditions:
;;
;;     The above copyright notice and this permission notice shall be included
;;     in all copies or substantial portions of the Software.
;;
;;     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;;     OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;;     MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;;     IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
;;     CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
;;     TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
;;     SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
(ns flybot.console
  (:require
   [clojure.set :refer [difference]]
   [flybot.console.core :as core]))

(defn console
  [level & args]
  (assert (contains? @core/levels level) (str "flybot.console/write: called with unknown level: " level))
  (apply (level @core/levels) args))

(defn set-fns!
  "Change the set (or a subset) of console functions used by flybot.console.
   `new-fns` should be a map with the same keys as
   `flybot.console.core/levels`."
  [new-fns]
  (assert (empty? (difference (set (keys new-fns)) (-> @core/levels keys set))) "flybot.console/set-fns!: called with unknown keys in new-fns")
  (swap! core/levels merge new-fns))
 
(defn get-fns
  "Get the current console functions used by flybot.console."
  []
  @core/levels)






