;; Copyright (c) 2018 Flybot Pte Ltd, Singapore.
;;
;; This file is distributed under the Eclipse Public License, the same as
;; Clojure.
;;
;; This file incorporates alandipert.kahn from
;; https://gist.github.com/alandipert/1263783 covered by the following copyright
;; and permission notice:
;;
;;     Copyright (c) Alan Dipert. All rights reserved.
;;
;;     The use and distribution terms for this software are covered by the
;;     Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;;     By using this software in any fashion, you are agreeing to be bound by
;;     the terms of this license.
;;     You must not remove this notice, or any other, from this software.
(ns flybot.kahn.core
  (:require
    [clojure.set :refer [difference union]]))

(defn without
  "Returns set s with x removed."
  [s x] (difference s #{x}))

(defn take-1
  "Returns the pair [element, s'] where s' is set s with element removed."
  [s] {:pre [(not (empty? s))]}
  (let [item (first s)]
    [item (without s item)]))

(defn no-incoming
  "Returns the set of nodes in graph g for which there are no incoming
  edges, where g is a map of nodes to sets of nodes."
  [g]
  (let [nodes         (set (keys g))
        have-incoming (apply union (vals g))]
    (difference nodes have-incoming)))

(defn normalize
  "Returns g with empty outgoing edges added for nodes with incoming
  edges only.  Example: {:a #{:b}} => {:a #{:b}, :b #{}}"
  [g]
  (let [have-incoming (apply union (vals g))]
    (reduce #(if (get % %2) % (assoc % %2 #{})) g have-incoming)))