(ns sock.task.built-in
  "Sock built-in tasks."
  {:boot/export-tasks true}
  (:require
    [boot.core :as boot :refer [deftask]]
    [boot.task.built-in :as built-in]
    [boot.lein :as lein]
    [boot-tools-deps.core :as tools-deps]))

(deftask deps
  "Use tools.deps to read and resolve the specified deps.edn files.

  The dependencies read in are added to your Boot :dependencies vector.

  With the exception of -A, -r, and -v, the arguments are intended to match
  the clj script usage (as passed to clojure.tools.deps.alpha.makecp/-main).
  Note, in particular, that -c / --config-paths is assumed to be the COMPLETE
  list of EDN files to read (and therefore overrides the default set of
  system deps, user deps, and local deps).

  The -r option is equivalent to the -Srepro option in tools.deps, which will
  exclude both the system deps and the user deps."
  [c config-paths    PATH [str] "the list of deps.edn files to read"
   A aliases           KW [kw]  "the list of aliases (for both -C and -R)"
   C classpath-aliases KW [kw]  "the list of classpath aliases to use"
   R resolve-aliases   KW [kw]  "the list of resolve aliases to use"
   r repeatable           bool  "Use only the specified deps.edn file for a repeatable build"
   v verbose              bool  "Be verbose (and ask tools.deps to be verbose too)"]
  (tools-deps/deps :config-paths config-paths
                   :classpath-aliases (into (vec aliases) classpath-aliases)
                   :resolve-aliases (into (vec aliases) resolve-aliases)
                   :repeatable repeatable
                   :verbose verbose))

(deftask conflicts
  "Print graph of dependency conflicts"
  []
  (comp (deps) (built-in/show :pedantic true)))