(ns sock.task.porcelain.hybrid
  "Sock porcelain boot tasks for hybrid Clojure and Java projects"
  {:boot/export-tasks true}
  (:require
    [boot.core :refer [deftask]]
    [boot.task.built-in :as boot-built-in]
    [sock.task.plumbing.core :refer [testing]]
    [sock.task.plumbing.clj :refer [midje]]
    [sock.task.plumbing.deps :refer [deps]]
    [sock.task.plumbing.java :refer [junit]]))

(deftask build
  "Resolve dependencies, compile Java sources, perform AOT compilation on
   Clojure namespaces, create project pom.xml file and build a jar file."
  []
  (comp (deps)
        (boot-built-in/javac)
        (boot-built-in/aot)
        (boot-built-in/pom)
        (boot-built-in/jar)))

;;; This prevents a name collision WARNING between the test task and
;;; clojure.core/test, a function that nobody really uses or cares
;;; about.
(ns-unmap 'boot.user 'test)
(ns-unmap 'sock.task.porcelain.hybrid 'test)

(deftask test
  "Resolve dependencies including :test alias, compile Java sources, perform
   AOT compilation on Clojure namespaces, run Midje tests and run jUnit tests."
  []
  (comp (testing)
        (boot-built-in/javac)
        (boot-built-in/aot)
        (midje)
        (junit)))

(deftask local
  "Build then install project jar file to local Maven repository."
  []
  (comp (build)
        (boot-built-in/install)))

(deftask snapshot
  "Build then deploy project jar file to company snapshots repository."
  []
  (comp (build)
        (boot-built-in/push :repo "company-snapshots")))

(deftask release
  "Build then deploy project jar file to company releases repository."
  []
  (comp (build)
        (boot-built-in/push :repo "company-releases")))
