(ns sock.lib.deps-edn
  "Sock Boot functions for transformation of deps.edn to boot dependencies."
  (:require
    [sock.lib.io :as io]))

(defn obtain
  []
  (io/slurp-edn (io/file "deps.edn")))

(defn ->dependencies
  [deps]
  (-> (reduce
        (fn [ret [sym {:mvn/keys [version] :keys [exclusions]}]]
          (conj! ret [sym version]))
        (transient [])
        deps)
      (persistent!)))

(defn ->deps
  [deps-edn aliases]
  (reduce
    (fn [ret alias-k]
      (merge ret (get-in deps-edn [:aliases alias-k :extra-deps])))
    (:deps deps-edn)
    aliases))

(defn ->paths
  [deps-edn aliases]
  (-> (reduce
        (fn [ret alias-k]
          (conj! ret (get-in deps-edn [:aliases alias-k :extra-paths])))
        (transient (:paths deps-edn))
        aliases)
    (persistent!)))

(defn ->repositories
  [deps-edn]
  (reduce-kv #(conj %1 [%2 %3]) [] (:mvn/repos deps-edn)))