(ns sock.task.deps
  "Sock Book tasks for dependency resolution."
  {:boot/export-tasks true}
  (:require
    [boot.core :as core]
    [boot.task.built-in :as built-in]
    [sock.lib.core :refer [apply-kw]]))

(core/deftask conflicts
  "Print graph of dependency conflicts."
  [A aliases    KW      [kw] "Aliases used for classpath construction and dependency resolution."]
  (built-in/show :pedantic true))

(core/deftask fake-classpath
  "Print the project's fake classpath."
  [A aliases    KW      [kw] "Aliases used for classpath construction and dependency resolution."]
  (built-in/show :fake-classpath true))

(core/deftask classpath
  "Print the project's classpath."
  [A aliases    KW      [kw] "Aliases used for classpath construction and dependency resolution."]
  (built-in/show :classpath true))

(core/deftask graph
  "Print the project's dependency graph."
  [A aliases    KW      [kw] "Aliases used for classpath construction and dependency resolution."
   v verify-deps        bool "Include signature status of each dependency in graph."]
  (built-in/show :deps true :verify-deps verify-deps))

(core/deftask boot-env
  "Print the project's boot env map."
  [A aliases    KW      [kw] "Aliases used for classpath construction and dependency resolution."]
  (built-in/show :env true))

(core/deftask updates
  "Print newer releases of outdated dependencies."
  [A aliases    KW      [kw] "Aliases used for classpath construction and dependency resolution."
   S snapshots          bool "Include snapshot versions in update searches."]
  (built-in/show :updates (not snapshots) :update-snapshots snapshots))

