(ns sock.lib.io
  "I/O utility functions for Sock."
  (:require
    [clojure.edn :as edn]
    [clojure.java.io :as io])
  (:import [java.io File IOException FileReader PushbackReader]))

(def file io/file)

(defn err
  ^IOException [fmt ^File f]
  (IOException. (format fmt (.getAbsolutePath f))))

(defn slurp-edn
  "Read file file specified by the path segments, slurp it, and read it as edn."
  [^File f]
  (let [EOF (Object.)]
    (with-open [rdr (PushbackReader. (FileReader. f))]
      (let [val (edn/read {:eof EOF} rdr)]
         (cond
           (identical? val EOF) nil
           (map? val) val
           :else (throw (err "Expected edn map: %s" f)))))))
