(ns sock.task.plumbing.deps
  "Sock plumbing for dependencies"
  {:boot/export-tasks true}
  (:require
    [boot.core :as boot :refer [deftask *boot-version*]]
    [boot.task.built-in :as built-in]
    [sock.lib.core :refer [apply-kw]]
    [boot-tools-deps.core :refer [load-deps]]))

(deftask deps
  "Use tools.deps to read and resolve the specified deps.edn files.

  The dependencies read in are added to your Boot :dependencies vector.

  With the exception of -A, and -v, the arguments are intended to match
  the clj script usage (as passed to clojure.tools.deps.alpha.makecp/-main).
  Note, in particular, that -c / --config-paths is assumed to be the COMPLETE
  list of EDN files to read (and therefore overrides the default set of
  system deps and local deps)."
  [c config-paths    PATH [str] "the list of deps.edn files to read"
   A aliases           KW [kw]  "the list of aliases (for both -C and -R)"
   C classpath-aliases KW [kw]  "the list of classpath aliases to use"
   R resolve-aliases   KW [kw]  "the list of resolve aliases to use"
   v verbose              bool  "Be verbose (and ask tools.deps to be verbose too)"]
  (let [opts     {:config-paths      config-paths
                  :classpath-aliases (into (vec aliases) classpath-aliases)
                  :resolve-aliases   (into (vec aliases) resolve-aliases)
                  :overwrite-boot-deps true
                  :verbose           verbose
                  :default-versions  {:clojure (clojure-version)
                                      :boot    *boot-version*}}]
    (load-deps opts)
    identity))

(deftask conflicts
  "Print graph of dependency conflicts."
  []
  (built-in/show :pedantic true))
