(ns sock.task.porcelain.clj
  "Sock porcelain boot tasks for Clojure"
  {:boot/export-tasks true}
  (:require
    [boot.core :refer [deftask]]
    [boot.task.built-in :as built-in]
    [sock.lib.core :refer [apply-kw]]
    [sock.task.plumbing.core :refer [testing]]
    [sock.task.plumbing.deps :refer [deps]]
    [sock.task.plumbing.clj :refer [clj]]))

(deftask build
  "Resolve dependencies, create project pom.xml file and build a jar file."
  [_ tools-deps-options OPTIONS edn "Options for seancorfield/boot-tools-deps task."
   _ pom-options        OPTIONS edn "Options for built-in/pom task."
   _ jar-options        OPTIONS edn "Options for built-in/jar task."]
  (comp (apply-kw deps tools-deps-options)
        (apply-kw built-in/pom pom-options)
        (apply-kw built-in/jar jar-options)))

(deftask local
  "Build then install project jar file to local Maven repository."
  [_ tools-deps-options OPTIONS edn "Options for seancorfield/boot-tools-deps task."
   _ pom-options        OPTIONS edn "Options for built-in/pom task."
   _ jar-options        OPTIONS edn "Options for built-in/jar task."
   _ install-options    OPTIONS edn "Options for built-in/install task."]
  (comp (build :tools-deps-options tools-deps-options
               :pom-options pom-options
               :jar-options jar-options)
        (apply-kw built-in/install install-options)))

(deftask snapshot
  "Build then deploy project jar file to company snapshots repository."
  [_ tools-deps-options OPTIONS edn "Options for seancorfield/boot-tools-deps task."
   _ pom-options        OPTIONS edn "Options for built-in/pom task."
   _ jar-options        OPTIONS edn "Options for built-in/jar task."
   _ push-options       OPTIONS edn "Options for built-in/push task."]
  (let [push-options' (merge {:repo "company-snapshots"} push-options)]
    (comp (build :tools-deps-options tools-deps-options
                 :pom pom-options
                 :jar jar-options)
          (apply-kw built-in/push push-options'))))

(deftask release
  "Build then deploy project jar file to company releases repository."
  [_ tools-deps-options OPTIONS edn "Options for seancorfield/boot-tools-deps task."
   _ pom-options        OPTIONS edn "Options for built-in/pom task."
   _ jar-options        OPTIONS edn "Options for built-in/jar task."
   _ push-options       OPTIONS edn "Options for built-in/push task."]
  (let [push-options' (merge {:repo "company-releases"} push-options)]
    (comp (build :tools-deps-options tools-deps-options
                 :pom pom-options
                 :jar jar-options)
          (apply-kw built-in/push push-options'))))
