(ns sock.init
  "The sock core API."
  {:boot/export-tasks true}
  (:require
    [boot.core :as core]
    [boot.task.built-in :refer [pom]]
    [sock.lib.io :as io]
    [clojure.pprint :as pp]))

(defn- repositories!
  "Read repositories from deps.edn and merge into the boot environment."
  [^Boolean verbose]
  (let [deps (io/slurp-edn (io/file "deps.edn"))
        repositories (reduce-kv #(conj %1 [%2 %3]) [] (:mvn/repos deps))]
    (when verbose
      (println "\nAdding these repositories:")
      (pp/pprint repositories))
    (core/merge-env! :wagons '[[s3-wagon-private "1.2.0"]])
    (core/merge-env! :repositories repositories)))

(defn- pom-options!
  "Set pom task options from project.edn"
  []
  (let [project (io/slurp-edn (io/file "project.edn"))]
    (core/task-options! pom project)))

; Initialize on ns load
(pom-options!)
(repositories! true)
