(ns sock.init
  "The sock core API."
  {:boot/export-tasks true}
  (:require
    [boot.core :as core]
    [boot.util :as util]
    [boot.task.built-in :as built-in]
    [sock.lib.io :as io]))

(defn- repositories!
  "Read repositories from deps.edn and merge into the boot environment."
  []
  (let [deps (io/slurp-edn (io/file "deps.edn"))
        wagons '[[s3-wagon-private "1.2.0"]]
        repositories (reduce-kv #(conj %1 [%2 %3]) [] (:mvn/repos deps))]
    (util/dbug* "Adding these wagons: %s\n" (util/pp-str wagons))
    (util/dbug* "Adding these repositories: %s\n" (util/pp-str repositories))
    (core/merge-env! :wagons wagons)
    (core/merge-env! :repositories repositories)))

(defn- pom-options!
  "Set pom task options from project.edn"
  []
  (let [project (io/slurp-edn (io/file "project.edn"))]
    (util/dbug* "Setting these pom options: %s\n" (util/pp-str project))
    (core/task-options! built-in/pom project)))

; Initialize on ns load
(pom-options!)
(repositories!)
