(ns sock.task.plumbing.clj
  "Sock plumbing for Clojure"
  {:boot/export-tasks true}
  (:require
    [boot.core :as core]
    [sock.lib.core :refer [apply-kw]]))

(core/deftask environ
  "If 'environ is a dependency of the current project then require and run the
   boot-environ task, otherwise do nothing."
  [_ environ OPTIONS edn "Options for boot-environ task."]
  (let [environ? (some #(= (first %) 'environ) (:dependencies (core/get-env)))]
    (if environ?
      (do
        (core/set-env! :dependencies #(conj % '[boot-environ "1.1.0" :scope "test"]))
        (require 'environ.boot)
        (let [boot-environ (resolve 'environ.boot/environ)]
          (apply-kw boot-environ environ)))
      identity)))

(core/deftask midje
  "If 'midje is a dependency of the current project then require and run the
   zhuangxm/boot-midje Midje test runner, otherwise do nothing."
  [_ midje OPTIONS edn "Options for zhuangxm/boot-midje task."]
  (let [midje? (some #(= (first %) 'midje) (:dependencies (core/get-env)))]
    (if midje?
      (do
        (core/set-env! :dependencies #(conj % '[zhuangxm/boot-midje "0.1.2" :scope "test"]))
        (require 'zhuangxm.boot-midje)
        (let [boot-midje (resolve 'zhuangxm.boot-midje/midje)]
          (apply-kw boot-midje midje)))
      identity)))

(core/deftask clojure-test
  "Require and run the clojure.test test runner."
  [_ opts OPTIONS edn "Options for adzerk/boot-test task."]
  (core/set-env! :dependencies #(conj % '[adzerk/boot-test "1.2.0" :scope "test"]))
  (require 'adzerk.boot-test)
  (let [boot-test (resolve 'adzerk.boot-test/test)]
    (apply-kw boot-test opts)))
