(ns {{sanitized-ns}}.core
    (:require [monger [core :as mg]])
    (:use org.httpkit.server
          {{sanitized-ns}}.routes))

(def project-clj
  (->> (str (System/getenv "DIR_CONTAINING") "/project.clj")
       slurp
       read-string
       (drop 3)
       (apply hash-map)))

(defn apps-config
  [profiles]
  (-> project-clj :apps-config profiles))

(declare app)

(defonce server (atom nil))

(defn- start-server!
  [profiles]
  (let [conf (apps-config profiles)]
    (reset! server (run-server (reduce #(%2 %1)
                                       main-handler
                                       main-middleware)
                               (:server conf)))))

(defn- stop-server!
  []
  (when-not (nil? @server)
    (@server :timeout 100)
    (reset! server nil)))

(defonce db (atom nil))

(defn- connect-db!
  [profiles]
  (let [{:keys [host port db-name]} (-> profiles apps-config :db)]
    (reset! db (mg/connect! {:host host :port port}))
    (mg/set-db! (mg/get-db db-name))))

(defn- disconnect-db!
  []
  (when-not (nil? @db)
    (do
      (mg/disconnect!)
      (reset! db nil))))

(defn run-app!
  [profiles]
  (start-server! profiles)
  (connect-db! profiles)
  (doseq [f startup-funcs]
    (f (apps-config profiles))))

(defn stop-app!
  []
  (stop-server!)
  (disconnect-db!))
