(ns fogus.rv.matching
  (:require [clojure.core.unify :as unify]))

(comment
  ;; Unification
  
  (unify/unify '?x 'hello {})
  ;;=> {'?x 'hello}
  
  (unify/unify '?x 'hello {'?x 'world})
  ;;=> nil
  
  (unify/unify '?x 'hello {'?x 'hello})
  ;;=> {'?x 'hello}
  
  (unify/unify '?x 'hello {'?y 'world})
  ;;=> {'?x 'hello '?y 'world}
)

(comment
  ;; Structure unification

  (unify/unify '(father ?x b) '(father a b) {})
  ;;=> {'?x 'a}

  (unify/unify '(father ?x b) '(father a b) {'?x 'c})
  ;;=> nil

  (unify/unify '(father ?x ?y) '(father a b) {'?y 'c})
  ;;=> nil

  (unify/unify '(father ?x ?y) '(father a b) {'?y 'b})
  ;;=> {'?x 'a, '?y 'b}

)

(def unify unify/unify)
(def subst unify/subst)

(comment
  ;; Substitution
  
  (unify/subst '(hello ?a) {'?a 'world})
  ;;=> '(hello world)

)
