(ns fogus.thneed.config
  (:require [clojure.java.io :as io]))

(defmulti -read-impl (fn [frmt & _] frmt))

(defmethod -read-impl :default
  [_ rdr]
  (read (java.io.PushbackReader. rdr)))

(defn read-config
  "Usage:

      (config-reader \"/path/to/cfg.json\" :as :json)
  "
  [file _ format & args]
  (-read-impl format (apply io/reader file args)))
