(ns thneed.cps)

(defmacro cps->fn
  "Converts a function taking a callback to one that runs synchronously."
  [f k]
  `(fn [& args#]
     (let [p# (promise)]
       (apply ~f
              (fn [x#]
                (deliver p# (~k x#)))
              args#)
       @p#)))

