(ns fogus.thneed.print
  (:require [clojure.walk :as walk]))

(defn plot [f min max step]
  (doseq [i (range min max step)]
    (dotimes [_ (apply f [i])] (print "*"))
    (println)))

(comment
  (plot #(Math/pow % 2) 1 5 1)
  ; *
  ; ****
  ; *********
  ; ****************
  ;=> nil
)

;; queue-fish
(defmethod print-method clojure.lang.PersistentQueue [q, w]
  (print-method '<- w)
  (print-method (seq q) w)
  (print-method '-< w))

(defn print-meta
  ([form level]
     (walk/prewalk
      (fn [x]
        (when-let [m (meta x)]
          (println "Level" level ":" x "=>" m)
          (print-meta m (inc level)))
        x)
      form))
  ([form]
     (print-meta form 0)))

(comment
  ;; from http://groups.google.com/group/clojure/browse_frm/thread/d83c8643a7c7d595
  
  (print-meta (macroexpand-all '(def b (fn ^foo [^bar x] ^baz x))))
  ;; Level 0 : x => {:tag bar}
  ;; Level 0 : x => {:tag baz}
  ;; (def b (fn* ([x] x)))

  (print-meta (macroexpand-all '(defn b ^foo [^bar x] ^baz x)))
  ;; Level 0 : b => {:arglists (quote ([x]))}
  ;; Level 1 : [x] => {:tag foo}
  ;; Level 1 : x => {:tag bar}
  ;; Level 0 : x => {:tag bar}
  ;; Level 0 : x => {:tag baz}
  ;; (def b (fn* ([x] x)))
  )