(ns trout.impl.header)

(defn bifurcate [content]
  (let [idx (.indexOf content "%%%" 0)]
    (if (pos? idx)
      {:header (.substring content 0 idx)
       :content  (.substring content (+ 3 idx))}
      {:content content})))

(defn parse-metadata [hdr]
  (when hdr
    (reduce (fn [h [_ k v]]
              (let [key (keyword k)]
                (assoc h key v)))
            {}
            (re-seq #"([^:#\+]+): (.+)(\n|$)" hdr))))


(comment
  (def C
"test: foo bar baz
date: 2012.06.04
author: Fogus
%%%

This is a test
==============
Foo!
")

(-> C
    bifurcate)

  (def C
"
This is a test
==============
Foo!
1005269
")

  (-> C
      bifurcate
      :header
      parse-metadata)
)
