(ns trout.impl.illustrations
  (require [clojure.java.io :as io]
           [trout.util :refer (dev-null)])
  (import [org.stathissideris.ascii2image.graphics BitmapRenderer Diagram]
          org.stathissideris.ascii2image.core.ConversionOptions
          org.stathissideris.ascii2image.text.TextGrid
          java.awt.image.RenderedImage
          javax.imageio.ImageIO))

(defn ^:private render [ill-txt]
  (let [opts (ConversionOptions.)        
        grid (TextGrid.)]
    (binding [*out* (dev-null)]
      (.initialiseWithText grid ill-txt (.processingOptions opts)))
    (.renderToImage (BitmapRenderer.) (Diagram. grid opts) (.renderingOptions opts))))


(defn illustration->PNG [ill outfile]
  (ImageIO/write (render ill) "png" (io/as-file outfile)))


(defn test-img [filename]
  (let [s (str "+-------------+\n"
               "| cBLU        |\n"
               "| Trout       |\n"
               "|    +--------+\n"
               "|    |cPNK    |\n"
               "|    |  Power |\n"
               "|    |        |\n"
               "+----+--------+\n")]
    (illustration->PNG s filename)))

