(ns trout.parse
  (:use trout)
  (:require [trout.down :as markdown]
            [trout.util :as util]
            [trout.impl.header :as header]))

(defn process-markdown
  [trout-section]
  (let [{:keys [header content]} (header/bifurcate (:format/raw trout-section))
        header (when header (header/parse-metadata header))
        metadata (merge (meta trout-section) header)]
    (with-meta
      (assoc trout-section
        :format/html
        (str
         "<!--" metadata  "-->\n\n"
         (markdown/->html content)))
      metadata)))

(defn raw-text
  [section]
  (let [txt (slurp (util/path (:root section) (:path section) (:file section)))]
    (with-meta
      (assoc section
        :format/raw
        txt)
      {:trout/msg "Got some metadata here."})))

