(ns trout.down
  (:import [org.pegdown PegDownProcessor]))

(def parser (PegDownProcessor.))

(defn bifurcate [content]
  (let [idx (.indexOf content "%%%" 0)]
    (if (pos? idx)
      {:header (.substring content 0 idx)
       :content  (.substring content (+ 3 idx))}
      {:content content})))

(defn parse-metadata [hdr]
  (when hdr
    (reduce (fn [h [_ k v]]
              (let [key (keyword k)]
                (assoc h key v)))
            {}
            (re-seq #"([^:#\+]+): (.+)(\n|$)" hdr))))

(defn ->html
  ([trout-txt]
     (.markdownToHtml parser trout-txt))
  ([parser trout-txt]
     (.markdownToHtml parser trout-txt)))


(comment
  (def C
"test: foo bar baz
date: 2012.06.04
author: Fogus
%%%

This is a test
==============
Foo!
")

  (def C
"
This is a test
==============
Foo!
1005269
")

  (-> C
      bifurcate
      :header
      parse-metadata)
)
