(ns trout.generator.html
  (:require [trout.util :as util]
            [clojure.java.io :as io]
            [fs.core :as fs]
            clojure.pprint)
  (:import [org.apache.commons.lang StringUtils]))

(def ^:dynamic *default-styles*
  ["trout.css" "mediaqueries.css" "page.css" "reset.css" "typography.css"])

(defn prepare-html!
  [book]
  (let [css-src (util/path "css")
        target (util/path (:root (meta book)) "tmp")
        css-override? (fs/exists? (util/path css-src))
        getter (if css-override? slurp util/slurp-resource)
        style-set (if css-override?
                    (fs/list-dir css-src)
                    *default-styles*)]
    (println (str "Grabbing styles from " (if css-override? "local directory" "Trout")))
    (doseq [css-file style-set]
      (let [c (getter (util/path css-src css-file))]
        (spit (util/path target css-file) c)))
    book))

(defn save-html! [sect extension-re]
  (let [tmp     (util/replace-re #"txt.*$" "tmp" (:path sect))
        target  (str (util/replace-re #".*txt\/(.*)" "$1-" (:path sect))
                     (util/replace-re extension-re ".html" (:file sect)))
        html    (:format/html sect) 
        outpath (util/path (:root sect) tmp target)
        templ   (util/slurp-resource "trout.html")]
    (println (str "Writing HTML from " (util/path tmp target)))
    (spit outpath (StringUtils/replace templ "^^^INSERT^^^" html))
    sect))


