/*
 * Decompiled with CFR 0.152.
 */
package mapnik;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import mapnik.Datasource;
import mapnik.DatasourceCache;
import mapnik.FeatureSet;
import mapnik.FeatureTypeStyle;
import mapnik.FreetypeEngine;
import mapnik.Geometry;
import mapnik.Image;
import mapnik.Layer;
import mapnik.MapDefinition;
import mapnik.NativeObject;
import mapnik.Projection;
import mapnik.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapnik {
    private static boolean initialized;
    private static boolean registered;
    private static String loadedLibrary;
    private static List<String> librarySearchNames;
    private static List<String> librarySearchPath;
    private static boolean initializationFailure;
    private static Map<Class<? extends NativeObject>, AtomicInteger> nativeAllocCounts;

    public static Map<String, Integer> getNativeAllocations() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (Map.Entry<Class<? extends NativeObject>, AtomicInteger> entry : nativeAllocCounts.entrySet()) {
            int count = entry.getValue().get();
            if (count == 0) continue;
            String name = entry.getKey().getName();
            int dotPos = name.lastIndexOf(46);
            if (dotPos >= 0) {
                name = name.substring(dotPos + 1);
            }
            ret.put(name, count);
        }
        return ret;
    }

    public static CharSequence reportNativeAllocations() {
        Map<String, Integer> counts = Mapnik.getNativeAllocations();
        StringBuilder buffer = new StringBuilder();
        buffer.append("MapnikAllocations(");
        boolean first = true;
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(entry.getKey()).append("=").append(entry.getValue());
        }
        buffer.append(")");
        return buffer;
    }

    static void incrementAlloc(Class<? extends NativeObject> clazz, int delta) {
        AtomicInteger i = nativeAllocCounts.get(clazz);
        if (i == null) {
            throw new IllegalStateException("Not allocation counter defined for " + clazz.getName());
        }
        i.addAndGet(delta);
    }

    private static boolean tryLoadLibrary(String path) {
        if (loadedLibrary != null) {
            return true;
        }
        File file = new File(path);
        if (file.isFile()) {
            System.load(file.getAbsolutePath());
            loadedLibrary = path;
            return true;
        }
        return false;
    }

    private static void loadLibrary() {
        if (loadedLibrary != null) {
            return;
        }
        for (String path : librarySearchPath) {
            for (String name : librarySearchNames) {
                String mappedName = System.mapLibraryName(name);
                String libPath = path + File.separator + mappedName;
                if (!Mapnik.tryLoadLibrary(libPath)) continue;
                return;
            }
        }
        String message = "Unable to find mapnik-jni library.  Search names=" + Arrays.toString(librarySearchNames.toArray()) + ", Search path=" + Arrays.toString(librarySearchPath.toArray());
        throw new LinkageError(message);
    }

    public static String getLoadedLibrary() {
        return loadedLibrary;
    }

    public static List<String> getLibrarySearchNames() {
        return librarySearchNames;
    }

    public static List<String> getLibrarySearchPath() {
        return librarySearchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialize(boolean register) {
        if (!initialized) {
            if (initializationFailure) {
                throw new IllegalStateException("Previous call to Mapnik.initialize() failed");
            }
            Mapnik.loadLibrary();
            try {
                Mapnik.nativeInit();
                initialized = true;
            }
            finally {
                if (!initialized) {
                    initializationFailure = true;
                }
            }
        }
        if (!Mapnik.isThreadSafe()) {
            System.err.println("WARNING! Mapnik JNI bindings were compiled against a non-threadsafe Mapnik library.");
            System.err.println("The JVM is a threaded environment, running against a non-threadsafe Mapnik is highly");
            System.err.println("not recommended!");
        }
        if (register && !registered) {
            registered = true;
            String path = Mapnik.getInstalledFontsDir();
            if (path != null) {
                FreetypeEngine.registerFonts(path);
            }
            if ((path = Mapnik.getInstalledInputPluginsDir()) != null) {
                DatasourceCache.registerDatasources(path);
            }
        }
    }

    public static void initialize() {
        Mapnik.initialize(true);
    }

    private static native void nativeInit();

    public static native String getInstalledFontsDir();

    public static native String getInstalledInputPluginsDir();

    public static native boolean isThreadSafe();

    static {
        String sysLibraryPath;
        librarySearchNames = new ArrayList<String>();
        librarySearchPath = new ArrayList<String>();
        librarySearchNames.add("mapnik-jni");
        URL url = Mapnik.class.getResource("/mapnik/Mapnik.class");
        if (url != null) {
            String urlString = url.toString();
            String prefix = "jar:file:";
            String suffix = "!/mapnik/Mapnik.class";
            if (urlString.startsWith(prefix) && urlString.endsWith(suffix)) {
                String jarFile = urlString.substring(prefix.length(), urlString.length() - suffix.length());
                File jarPath = new File(jarFile).getParentFile();
                librarySearchPath.add(jarPath.getAbsolutePath());
            }
        }
        if ((sysLibraryPath = System.getProperty("java.library.path")) != null) {
            String[] paths;
            for (String path : paths = sysLibraryPath.split(Pattern.quote(File.pathSeparator))) {
                librarySearchPath.add(path);
            }
        }
        nativeAllocCounts = new HashMap<Class<? extends NativeObject>, AtomicInteger>();
        nativeAllocCounts.put(Datasource.class, new AtomicInteger());
        nativeAllocCounts.put(FeatureSet.class, new AtomicInteger());
        nativeAllocCounts.put(FeatureTypeStyle.class, new AtomicInteger());
        nativeAllocCounts.put(Geometry.class, new AtomicInteger());
        nativeAllocCounts.put(Image.class, new AtomicInteger());
        nativeAllocCounts.put(Layer.class, new AtomicInteger());
        nativeAllocCounts.put(MapDefinition.class, new AtomicInteger());
        nativeAllocCounts.put(Projection.class, new AtomicInteger());
        nativeAllocCounts.put(Query.class, new AtomicInteger());
    }
}

