/*
 * Decompiled with CFR 0.152.
 */
package mapnik;

import mapnik.Box2d;
import mapnik.Coord;
import mapnik.NativeObject;

public class Projection
extends NativeObject {
    public static final String LATLNG_PARAMS = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs";
    public static final String SRS900913_PARAMS = "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs +over";

    private static native long alloc(String var0);

    native void dealloc(long var1);

    public Projection(String params) {
        if (params == null) {
            throw new IllegalArgumentException("Projection params cannot be null");
        }
        this.ptr = Projection.alloc(params);
    }

    public Projection() {
        this.ptr = Projection.alloc(LATLNG_PARAMS);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Projection)) {
            return false;
        }
        return ((Projection)other).getParams().equals(this.getParams());
    }

    public native String getParams();

    public native String getExpanded();

    public native void forward(Coord var1);

    public native void inverse(Coord var1);

    public void forward(Box2d box) {
        Coord c = new Coord(box.minx, box.miny);
        this.forward(c);
        box.minx = c.x;
        box.miny = c.y;
        c.x = box.maxx;
        c.y = box.maxy;
        this.forward(c);
        box.maxx = c.x;
        box.maxy = c.y;
    }

    public void inverse(Box2d box) {
        Coord c = new Coord(box.minx, box.miny);
        this.inverse(c);
        box.minx = c.x;
        box.miny = c.y;
        c.x = box.maxx;
        c.y = box.maxy;
        this.inverse(c);
        box.maxx = c.x;
        box.maxy = c.y;
    }
}

