package carbonite;

import clojure.lang.IFn;
import clojure.java.api.Clojure;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Output;


public abstract class ClojureCollSerializer extends Serializer {
    final IFn printCollection;

    public ClojureCollSerializer() {
	JavaBridge.requireCarbonite();
	printCollection = Clojure.var("carbonite.serializer", "print-collection");
    }

    public void write(Kryo kryo, Output output, Object o) {
	printCollection.invoke(kryo, output, o);
    }
}
