package carbonite;

import clojure.lang.IFn;
import clojure.java.api.Clojure;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

/** User: sritchie Date: 1/21/12 Time: 8:19 PM */
public class StringSeqSerializer extends Serializer {
    final IFn readStringSeq;
    final IFn printStringSeq;

    public StringSeqSerializer() {
	JavaBridge.requireCarbonite();
	readStringSeq = Clojure.var("carbonite.serializer", "read-string-seq");
	printStringSeq = Clojure.var("carbonite.serializer", "write-string-seq");
    }

    public void write(Kryo kryo, Output output, Object o) {
	printStringSeq.invoke(output, o);
    }

    public Object read(Kryo kryo, Input input, Class aClass) {
	return readStringSeq.invoke(input);
    }
}
